// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package translate

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opDeleteTerminology = "DeleteTerminology"

// DeleteTerminologyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTerminology operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTerminology for more information on using the DeleteTerminology
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTerminologyRequest method.
//    req, resp := client.DeleteTerminologyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteTerminology
func (c *Translate) DeleteTerminologyRequest(input *DeleteTerminologyInput) (req *request.Request, output *DeleteTerminologyOutput) {
	op := &request.Operation{
		Name:       opDeleteTerminology,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTerminologyInput{}
	}

	output = &DeleteTerminologyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTerminology API operation for Amazon Translate.
//
// A synchronous action that deletes a custom terminology.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation DeleteTerminology for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource you are looking for has not been found. Review the resource
//   you're looking for and see if a different resource will accomplish your needs
//   before retrying the revised request. .
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteTerminology
func (c *Translate) DeleteTerminology(input *DeleteTerminologyInput) (*DeleteTerminologyOutput, error) {
	req, out := c.DeleteTerminologyRequest(input)
	return out, req.Send()
}

// DeleteTerminologyWithContext is the same as DeleteTerminology with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTerminology for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) DeleteTerminologyWithContext(ctx aws.Context, input *DeleteTerminologyInput, opts ...request.Option) (*DeleteTerminologyOutput, error) {
	req, out := c.DeleteTerminologyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTerminology = "GetTerminology"

// GetTerminologyRequest generates a "aws/request.Request" representing the
// client's request for the GetTerminology operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTerminology for more information on using the GetTerminology
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTerminologyRequest method.
//    req, resp := client.GetTerminologyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetTerminology
func (c *Translate) GetTerminologyRequest(input *GetTerminologyInput) (req *request.Request, output *GetTerminologyOutput) {
	op := &request.Operation{
		Name:       opGetTerminology,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTerminologyInput{}
	}

	output = &GetTerminologyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTerminology API operation for Amazon Translate.
//
// Retrieves a custom terminology.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation GetTerminology for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource you are looking for has not been found. Review the resource
//   you're looking for and see if a different resource will accomplish your needs
//   before retrying the revised request. .
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of the parameter is invalid. Review the value of the parameter
//   you are using to correct it, and then retry your operation.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetTerminology
func (c *Translate) GetTerminology(input *GetTerminologyInput) (*GetTerminologyOutput, error) {
	req, out := c.GetTerminologyRequest(input)
	return out, req.Send()
}

// GetTerminologyWithContext is the same as GetTerminology with the addition of
// the ability to pass a context and additional request options.
//
// See GetTerminology for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) GetTerminologyWithContext(ctx aws.Context, input *GetTerminologyInput, opts ...request.Option) (*GetTerminologyOutput, error) {
	req, out := c.GetTerminologyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportTerminology = "ImportTerminology"

// ImportTerminologyRequest generates a "aws/request.Request" representing the
// client's request for the ImportTerminology operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportTerminology for more information on using the ImportTerminology
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportTerminologyRequest method.
//    req, resp := client.ImportTerminologyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ImportTerminology
func (c *Translate) ImportTerminologyRequest(input *ImportTerminologyInput) (req *request.Request, output *ImportTerminologyOutput) {
	op := &request.Operation{
		Name:       opImportTerminology,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportTerminologyInput{}
	}

	output = &ImportTerminologyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportTerminology API operation for Amazon Translate.
//
// Creates or updates a custom terminology, depending on whether or not one
// already exists for the given terminology name. Importing a terminology with
// the same name as an existing one will merge the terminologies based on the
// chosen merge strategy. Currently, the only supported merge strategy is OVERWRITE,
// and so the imported terminology will overwrite an existing terminology of
// the same name.
//
// If you import a terminology that overwrites an existing one, the new terminology
// take up to 10 minutes to fully propagate and be available for use in a translation
// due to cache policies with the DataPlane service that performs the translations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation ImportTerminology for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of the parameter is invalid. Review the value of the parameter
//   you are using to correct it, and then retry your operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The specified limit has been exceeded. Review your request and retry it with
//   a quantity below the stated limit.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ImportTerminology
func (c *Translate) ImportTerminology(input *ImportTerminologyInput) (*ImportTerminologyOutput, error) {
	req, out := c.ImportTerminologyRequest(input)
	return out, req.Send()
}

// ImportTerminologyWithContext is the same as ImportTerminology with the addition of
// the ability to pass a context and additional request options.
//
// See ImportTerminology for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ImportTerminologyWithContext(ctx aws.Context, input *ImportTerminologyInput, opts ...request.Option) (*ImportTerminologyOutput, error) {
	req, out := c.ImportTerminologyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTerminologies = "ListTerminologies"

// ListTerminologiesRequest generates a "aws/request.Request" representing the
// client's request for the ListTerminologies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTerminologies for more information on using the ListTerminologies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTerminologiesRequest method.
//    req, resp := client.ListTerminologiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies
func (c *Translate) ListTerminologiesRequest(input *ListTerminologiesInput) (req *request.Request, output *ListTerminologiesOutput) {
	op := &request.Operation{
		Name:       opListTerminologies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTerminologiesInput{}
	}

	output = &ListTerminologiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTerminologies API operation for Amazon Translate.
//
// Provides a list of custom terminologies associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation ListTerminologies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of the parameter is invalid. Review the value of the parameter
//   you are using to correct it, and then retry your operation.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies
func (c *Translate) ListTerminologies(input *ListTerminologiesInput) (*ListTerminologiesOutput, error) {
	req, out := c.ListTerminologiesRequest(input)
	return out, req.Send()
}

// ListTerminologiesWithContext is the same as ListTerminologies with the addition of
// the ability to pass a context and additional request options.
//
// See ListTerminologies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ListTerminologiesWithContext(ctx aws.Context, input *ListTerminologiesInput, opts ...request.Option) (*ListTerminologiesOutput, error) {
	req, out := c.ListTerminologiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opText = "TranslateText"

// TextRequest generates a "aws/request.Request" representing the
// client's request for the Text operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Text for more information on using the Text
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TextRequest method.
//    req, resp := client.TextRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/Text
func (c *Translate) TextRequest(input *TextInput) (req *request.Request, output *TextOutput) {
	op := &request.Operation{
		Name:       opText,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TextInput{}
	}

	output = &TextOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Text API operation for Amazon Translate.
//
// Translates input text from the source language to the target language. It
// is not necessary to use English (en) as either the source or the target language
// but not all language combinations are supported by Amazon Translate. For
// more information, see Supported Language Pairs (http://docs.aws.amazon.com/translate/latest/dg/pairs.html).
//
//    * Arabic (ar)
//
//    * Chinese (Simplified) (zh)
//
//    * Chinese (Traditional) (zh-TW)
//
//    * Czech (cs)
//
//    * Danish (da)
//
//    * Dutch (nl)
//
//    * English (en)
//
//    * Finnish (fi)
//
//    * French (fr)
//
//    * German (de)
//
//    * Hebrew (he)
//
//    * Indonesian (id)
//
//    * Italian (it)
//
//    * Japanese (ja)
//
//    * Korean (ko)
//
//    * Polish (pl)
//
//    * Portuguese (pt)
//
//    * Russian (ru)
//
//    * Spanish (es)
//
//    * Swedish (sv)
//
//    * Turkish (tr)
//
// To have Amazon Translate determine the source language of your text, you
// can specify auto in the SourceLanguageCode field. If you specify auto, Amazon
// Translate will call Amazon Comprehend to determine the source language.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation Text for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request that you made is invalid. Check your request to determine why
//   it's invalid and then retry the request.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the text you submitted exceeds the size limit. Reduce the size
//   of the text or use a smaller document and then retry your request.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again.
//
//   * ErrCodeUnsupportedLanguagePairException "UnsupportedLanguagePairException"
//   Amazon Translate does not support translation from the language of the source
//   text into the requested target language. For more information, see how-to-error-msg.
//
//   * ErrCodeDetectedLanguageLowConfidenceException "DetectedLanguageLowConfidenceException"
//   The confidence that Amazon Comprehend accurately detected the source language
//   is low. If a low confidence level is acceptable for your application, you
//   can use the language in the exception to call Amazon Translate again. For
//   more information, see the DetectDominantLanguage (https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html)
//   operation in the Amazon Comprehend Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource you are looking for has not been found. Review the resource
//   you're looking for and see if a different resource will accomplish your needs
//   before retrying the revised request. .
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The Amazon Translate service is temporarily unavailable. Please wait a bit
//   and then retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/Text
func (c *Translate) Text(input *TextInput) (*TextOutput, error) {
	req, out := c.TextRequest(input)
	return out, req.Send()
}

// TextWithContext is the same as Text with the addition of
// the ability to pass a context and additional request options.
//
// See Text for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) TextWithContext(ctx aws.Context, input *TextInput, opts ...request.Option) (*TextOutput, error) {
	req, out := c.TextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The custom terminology applied to the input text by Amazon Translate for
// the translated text response. This is optional in the response and will only
// be present if you specified terminology input in the request. Currently,
// only one terminology can be applied per TranslateText request.
type AppliedTerminology struct {
	_ struct{} `type:"structure"`

	// The name of the custom terminology applied to the input text by Amazon Translate
	// for the translated text response.
	Name *string `min:"1" type:"string"`

	// The specific terms of the custom terminology applied to the input text by
	// Amazon Translate for the translated text response. A maximum of 250 terms
	// will be returned, and the specific terms applied will be the first 250 terms
	// in the source text.
	Terms []*Term `type:"list"`
}

// String returns the string representation
func (s AppliedTerminology) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AppliedTerminology) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AppliedTerminology) SetName(v string) *AppliedTerminology {
	s.Name = &v
	return s
}

// SetTerms sets the Terms field's value.
func (s *AppliedTerminology) SetTerms(v []*Term) *AppliedTerminology {
	s.Terms = v
	return s
}

type DeleteTerminologyInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom terminology being deleted.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTerminologyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTerminologyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTerminologyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTerminologyInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteTerminologyInput) SetName(v string) *DeleteTerminologyInput {
	s.Name = &v
	return s
}

type DeleteTerminologyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTerminologyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTerminologyOutput) GoString() string {
	return s.String()
}

// The encryption key used to encrypt the custom terminologies used by Amazon
// Translate.
type EncryptionKey struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the encryption key being used to encrypt
	// the custom terminology.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The type of encryption key used by Amazon Translate to encrypt custom terminologies.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"EncryptionKeyType"`
}

// String returns the string representation
func (s EncryptionKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionKey"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *EncryptionKey) SetId(v string) *EncryptionKey {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *EncryptionKey) SetType(v string) *EncryptionKey {
	s.Type = &v
	return s
}

type GetTerminologyInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom terminology being retrieved.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The data format of the custom terminology being retrieved, either CSV or
	// TMX.
	//
	// TerminologyDataFormat is a required field
	TerminologyDataFormat *string `type:"string" required:"true" enum:"TerminologyDataFormat"`
}

// String returns the string representation
func (s GetTerminologyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTerminologyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTerminologyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTerminologyInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TerminologyDataFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("TerminologyDataFormat"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetTerminologyInput) SetName(v string) *GetTerminologyInput {
	s.Name = &v
	return s
}

// SetTerminologyDataFormat sets the TerminologyDataFormat field's value.
func (s *GetTerminologyInput) SetTerminologyDataFormat(v string) *GetTerminologyInput {
	s.TerminologyDataFormat = &v
	return s
}

type GetTerminologyOutput struct {
	_ struct{} `type:"structure"`

	// The data location of the custom terminology being retrieved. The custom terminology
	// file is returned in a presigned url that has a 30 minute expiration.
	TerminologyDataLocation *TerminologyDataLocation `type:"structure"`

	// The properties of the custom terminology being retrieved.
	TerminologyProperties *TerminologyProperties `type:"structure"`
}

// String returns the string representation
func (s GetTerminologyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTerminologyOutput) GoString() string {
	return s.String()
}

// SetTerminologyDataLocation sets the TerminologyDataLocation field's value.
func (s *GetTerminologyOutput) SetTerminologyDataLocation(v *TerminologyDataLocation) *GetTerminologyOutput {
	s.TerminologyDataLocation = v
	return s
}

// SetTerminologyProperties sets the TerminologyProperties field's value.
func (s *GetTerminologyOutput) SetTerminologyProperties(v *TerminologyProperties) *GetTerminologyOutput {
	s.TerminologyProperties = v
	return s
}

type ImportTerminologyInput struct {
	_ struct{} `type:"structure"`

	// The description of the custom terminology being imported.
	Description *string `type:"string"`

	// The encryption key for the custom terminology being imported.
	EncryptionKey *EncryptionKey `type:"structure"`

	// The merge strategy of the custom terminology being imported. Currently, only
	// the OVERWRITE merge strategy is supported. In this case, the imported terminology
	// will overwrite an existing terminology of the same name.
	//
	// MergeStrategy is a required field
	MergeStrategy *string `type:"string" required:"true" enum:"MergeStrategy"`

	// The name of the custom terminology being imported.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The terminology data for the custom terminology being imported.
	//
	// TerminologyData is a required field
	TerminologyData *TerminologyData `type:"structure" required:"true"`
}

// String returns the string representation
func (s ImportTerminologyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportTerminologyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportTerminologyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportTerminologyInput"}
	if s.MergeStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("MergeStrategy"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TerminologyData == nil {
		invalidParams.Add(request.NewErrParamRequired("TerminologyData"))
	}
	if s.EncryptionKey != nil {
		if err := s.EncryptionKey.Validate(); err != nil {
			invalidParams.AddNested("EncryptionKey", err.(request.ErrInvalidParams))
		}
	}
	if s.TerminologyData != nil {
		if err := s.TerminologyData.Validate(); err != nil {
			invalidParams.AddNested("TerminologyData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ImportTerminologyInput) SetDescription(v string) *ImportTerminologyInput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *ImportTerminologyInput) SetEncryptionKey(v *EncryptionKey) *ImportTerminologyInput {
	s.EncryptionKey = v
	return s
}

// SetMergeStrategy sets the MergeStrategy field's value.
func (s *ImportTerminologyInput) SetMergeStrategy(v string) *ImportTerminologyInput {
	s.MergeStrategy = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImportTerminologyInput) SetName(v string) *ImportTerminologyInput {
	s.Name = &v
	return s
}

// SetTerminologyData sets the TerminologyData field's value.
func (s *ImportTerminologyInput) SetTerminologyData(v *TerminologyData) *ImportTerminologyInput {
	s.TerminologyData = v
	return s
}

type ImportTerminologyOutput struct {
	_ struct{} `type:"structure"`

	// The properties of the custom terminology being imported.
	TerminologyProperties *TerminologyProperties `type:"structure"`
}

// String returns the string representation
func (s ImportTerminologyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportTerminologyOutput) GoString() string {
	return s.String()
}

// SetTerminologyProperties sets the TerminologyProperties field's value.
func (s *ImportTerminologyOutput) SetTerminologyProperties(v *TerminologyProperties) *ImportTerminologyOutput {
	s.TerminologyProperties = v
	return s
}

type ListTerminologiesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of custom terminologies returned per list request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the request to ListTerminologies was truncated, include
	// the NextToken to fetch the next group of custom terminologies.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListTerminologiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTerminologiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTerminologiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTerminologiesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTerminologiesInput) SetMaxResults(v int64) *ListTerminologiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTerminologiesInput) SetNextToken(v string) *ListTerminologiesInput {
	s.NextToken = &v
	return s
}

type ListTerminologiesOutput struct {
	_ struct{} `type:"structure"`

	// If the response to the ListTerminologies was truncated, the NextToken fetches
	// the next group of custom terminologies.
	NextToken *string `type:"string"`

	// The properties list of the custom terminologies returned on the list request.
	TerminologyPropertiesList []*TerminologyProperties `type:"list"`
}

// String returns the string representation
func (s ListTerminologiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTerminologiesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTerminologiesOutput) SetNextToken(v string) *ListTerminologiesOutput {
	s.NextToken = &v
	return s
}

// SetTerminologyPropertiesList sets the TerminologyPropertiesList field's value.
func (s *ListTerminologiesOutput) SetTerminologyPropertiesList(v []*TerminologyProperties) *ListTerminologiesOutput {
	s.TerminologyPropertiesList = v
	return s
}

// The term being translated by the custom terminology.
type Term struct {
	_ struct{} `type:"structure"`

	// The source text of the term being translated by the custom terminology.
	SourceText *string `type:"string"`

	// The target text of the term being translated by the custom terminology.
	TargetText *string `type:"string"`
}

// String returns the string representation
func (s Term) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Term) GoString() string {
	return s.String()
}

// SetSourceText sets the SourceText field's value.
func (s *Term) SetSourceText(v string) *Term {
	s.SourceText = &v
	return s
}

// SetTargetText sets the TargetText field's value.
func (s *Term) SetTargetText(v string) *Term {
	s.TargetText = &v
	return s
}

// The data associated with the custom terminology.
type TerminologyData struct {
	_ struct{} `type:"structure"`

	// The file containing the custom terminology data.
	//
	// File is automatically base64 encoded/decoded by the SDK.
	//
	// File is a required field
	File []byte `type:"blob" required:"true" sensitive:"true"`

	// The data format of the custom terminology. Either CSV or TMX.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"TerminologyDataFormat"`
}

// String returns the string representation
func (s TerminologyData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminologyData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminologyData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminologyData"}
	if s.File == nil {
		invalidParams.Add(request.NewErrParamRequired("File"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFile sets the File field's value.
func (s *TerminologyData) SetFile(v []byte) *TerminologyData {
	s.File = v
	return s
}

// SetFormat sets the Format field's value.
func (s *TerminologyData) SetFormat(v string) *TerminologyData {
	s.Format = &v
	return s
}

// The location of the custom terminology data.
type TerminologyDataLocation struct {
	_ struct{} `type:"structure"`

	// The location of the custom terminology data.
	//
	// Location is a required field
	Location *string `type:"string" required:"true"`

	// The repository type for the custom terminology data.
	//
	// RepositoryType is a required field
	RepositoryType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TerminologyDataLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminologyDataLocation) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *TerminologyDataLocation) SetLocation(v string) *TerminologyDataLocation {
	s.Location = &v
	return s
}

// SetRepositoryType sets the RepositoryType field's value.
func (s *TerminologyDataLocation) SetRepositoryType(v string) *TerminologyDataLocation {
	s.RepositoryType = &v
	return s
}

// The properties of the custom terminology.
type TerminologyProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the custom terminology.
	Arn *string `type:"string"`

	// The time at which the custom terminology was created, based on the timestamp.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the custom terminology properties.
	Description *string `type:"string"`

	// The encryption key for the custom terminology.
	EncryptionKey *EncryptionKey `type:"structure"`

	// The time at which the custom terminology was last update, based on the timestamp.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The name of the custom terminology.
	Name *string `min:"1" type:"string"`

	// The size of the file used when importing a custom terminology.
	SizeBytes *int64 `type:"integer"`

	// The language code for the source text of the translation request for which
	// the custom terminology is being used.
	SourceLanguageCode *string `min:"2" type:"string"`

	// The language codes for the target languages available with the custom terminology
	// file. All possible target languages are returned in array.
	TargetLanguageCodes []*string `type:"list"`

	// The number of terms included in the custom terminology.
	TermCount *int64 `type:"integer"`
}

// String returns the string representation
func (s TerminologyProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminologyProperties) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *TerminologyProperties) SetArn(v string) *TerminologyProperties {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *TerminologyProperties) SetCreatedAt(v time.Time) *TerminologyProperties {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TerminologyProperties) SetDescription(v string) *TerminologyProperties {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *TerminologyProperties) SetEncryptionKey(v *EncryptionKey) *TerminologyProperties {
	s.EncryptionKey = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *TerminologyProperties) SetLastUpdatedAt(v time.Time) *TerminologyProperties {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *TerminologyProperties) SetName(v string) *TerminologyProperties {
	s.Name = &v
	return s
}

// SetSizeBytes sets the SizeBytes field's value.
func (s *TerminologyProperties) SetSizeBytes(v int64) *TerminologyProperties {
	s.SizeBytes = &v
	return s
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *TerminologyProperties) SetSourceLanguageCode(v string) *TerminologyProperties {
	s.SourceLanguageCode = &v
	return s
}

// SetTargetLanguageCodes sets the TargetLanguageCodes field's value.
func (s *TerminologyProperties) SetTargetLanguageCodes(v []*string) *TerminologyProperties {
	s.TargetLanguageCodes = v
	return s
}

// SetTermCount sets the TermCount field's value.
func (s *TerminologyProperties) SetTermCount(v int64) *TerminologyProperties {
	s.TermCount = &v
	return s
}

type TextInput struct {
	_ struct{} `type:"structure"`

	// The language code for the language of the source text. The language must
	// be a language supported by Amazon Translate.
	//
	// To have Amazon Translate determine the source language of your text, you
	// can specify auto in the SourceLanguageCode field. If you specify auto, Amazon
	// Translate will call Amazon Comprehend to determine the source language.
	//
	// SourceLanguageCode is a required field
	SourceLanguageCode *string `min:"2" type:"string" required:"true"`

	// The language code requested for the language of the target text. The language
	// must be a language supported by Amazon Translate.
	//
	// TargetLanguageCode is a required field
	TargetLanguageCode *string `min:"2" type:"string" required:"true"`

	// The TerminologyNames list that is taken as input to the TranslateText request.
	// This has a minimum length of 0 and a maximum length of 1.
	TerminologyNames []*string `type:"list"`

	// The text to translate. The text string can be a maximum of 5,000 bytes long.
	// Depending on your character set, this may be fewer than 5,000 characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TextInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TextInput"}
	if s.SourceLanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLanguageCode"))
	}
	if s.SourceLanguageCode != nil && len(*s.SourceLanguageCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLanguageCode", 2))
	}
	if s.TargetLanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetLanguageCode"))
	}
	if s.TargetLanguageCode != nil && len(*s.TargetLanguageCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("TargetLanguageCode", 2))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *TextInput) SetSourceLanguageCode(v string) *TextInput {
	s.SourceLanguageCode = &v
	return s
}

// SetTargetLanguageCode sets the TargetLanguageCode field's value.
func (s *TextInput) SetTargetLanguageCode(v string) *TextInput {
	s.TargetLanguageCode = &v
	return s
}

// SetTerminologyNames sets the TerminologyNames field's value.
func (s *TextInput) SetTerminologyNames(v []*string) *TextInput {
	s.TerminologyNames = v
	return s
}

// SetText sets the Text field's value.
func (s *TextInput) SetText(v string) *TextInput {
	s.Text = &v
	return s
}

type TextOutput struct {
	_ struct{} `type:"structure"`

	// The names of the custom terminologies applied to the input text by Amazon
	// Translate for the translated text response.
	AppliedTerminologies []*AppliedTerminology `type:"list"`

	// The language code for the language of the source text.
	//
	// SourceLanguageCode is a required field
	SourceLanguageCode *string `min:"2" type:"string" required:"true"`

	// The language code for the language of the target text.
	//
	// TargetLanguageCode is a required field
	TargetLanguageCode *string `min:"2" type:"string" required:"true"`

	// The the translated text. The maximum length of this text is 5kb.
	//
	// TranslatedText is a required field
	TranslatedText *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextOutput) GoString() string {
	return s.String()
}

// SetAppliedTerminologies sets the AppliedTerminologies field's value.
func (s *TextOutput) SetAppliedTerminologies(v []*AppliedTerminology) *TextOutput {
	s.AppliedTerminologies = v
	return s
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *TextOutput) SetSourceLanguageCode(v string) *TextOutput {
	s.SourceLanguageCode = &v
	return s
}

// SetTargetLanguageCode sets the TargetLanguageCode field's value.
func (s *TextOutput) SetTargetLanguageCode(v string) *TextOutput {
	s.TargetLanguageCode = &v
	return s
}

// SetTranslatedText sets the TranslatedText field's value.
func (s *TextOutput) SetTranslatedText(v string) *TextOutput {
	s.TranslatedText = &v
	return s
}

const (
	// EncryptionKeyTypeKms is a EncryptionKeyType enum value
	EncryptionKeyTypeKms = "KMS"
)

const (
	// MergeStrategyOverwrite is a MergeStrategy enum value
	MergeStrategyOverwrite = "OVERWRITE"
)

const (
	// TerminologyDataFormatCsv is a TerminologyDataFormat enum value
	TerminologyDataFormatCsv = "CSV"

	// TerminologyDataFormatTmx is a TerminologyDataFormat enum value
	TerminologyDataFormatTmx = "TMX"
)
