// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package imagebuilder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetImageRecipePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image recipe whose policy you wish
	// to retrieve.
	//
	// ImageRecipeArn is a required field
	ImageRecipeArn *string `location:"querystring" locationName:"imageRecipeArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetImageRecipePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImageRecipePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetImageRecipePolicyInput"}

	if s.ImageRecipeArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ImageRecipeArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetImageRecipePolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ImageRecipeArn != nil {
		v := *s.ImageRecipeArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "imageRecipeArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetImageRecipePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The image recipe policy object.
	Policy *string `locationName:"policy" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation
func (s GetImageRecipePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetImageRecipePolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetImageRecipePolicy = "GetImageRecipePolicy"

// GetImageRecipePolicyRequest returns a request value for making API operation for
// EC2 Image Builder.
//
// Gets an image recipe policy.
//
//    // Example sending a request using GetImageRecipePolicyRequest.
//    req := client.GetImageRecipePolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipePolicy
func (c *Client) GetImageRecipePolicyRequest(input *GetImageRecipePolicyInput) GetImageRecipePolicyRequest {
	op := &aws.Operation{
		Name:       opGetImageRecipePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/GetImageRecipePolicy",
	}

	if input == nil {
		input = &GetImageRecipePolicyInput{}
	}

	req := c.newRequest(op, input, &GetImageRecipePolicyOutput{})
	return GetImageRecipePolicyRequest{Request: req, Input: input, Copy: c.GetImageRecipePolicyRequest}
}

// GetImageRecipePolicyRequest is the request type for the
// GetImageRecipePolicy API operation.
type GetImageRecipePolicyRequest struct {
	*aws.Request
	Input *GetImageRecipePolicyInput
	Copy  func(*GetImageRecipePolicyInput) GetImageRecipePolicyRequest
}

// Send marshals and sends the GetImageRecipePolicy API request.
func (r GetImageRecipePolicyRequest) Send(ctx context.Context) (*GetImageRecipePolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetImageRecipePolicyResponse{
		GetImageRecipePolicyOutput: r.Request.Data.(*GetImageRecipePolicyOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetImageRecipePolicyResponse is the response type for the
// GetImageRecipePolicy API operation.
type GetImageRecipePolicyResponse struct {
	*GetImageRecipePolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetImageRecipePolicy request.
func (r *GetImageRecipePolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
