// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteProvisioningTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet provision template to delete.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProvisioningTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProvisioningTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteProvisioningTemplateInput"}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteProvisioningTemplateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "templateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteProvisioningTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProvisioningTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteProvisioningTemplateOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteProvisioningTemplate = "DeleteProvisioningTemplate"

// DeleteProvisioningTemplateRequest returns a request value for making API operation for
// AWS IoT.
//
// Deletes a fleet provisioning template.
//
//    // Example sending a request using DeleteProvisioningTemplateRequest.
//    req := client.DeleteProvisioningTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteProvisioningTemplateRequest(input *DeleteProvisioningTemplateInput) DeleteProvisioningTemplateRequest {
	op := &aws.Operation{
		Name:       opDeleteProvisioningTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/provisioning-templates/{templateName}",
	}

	if input == nil {
		input = &DeleteProvisioningTemplateInput{}
	}

	req := c.newRequest(op, input, &DeleteProvisioningTemplateOutput{})
	return DeleteProvisioningTemplateRequest{Request: req, Input: input, Copy: c.DeleteProvisioningTemplateRequest}
}

// DeleteProvisioningTemplateRequest is the request type for the
// DeleteProvisioningTemplate API operation.
type DeleteProvisioningTemplateRequest struct {
	*aws.Request
	Input *DeleteProvisioningTemplateInput
	Copy  func(*DeleteProvisioningTemplateInput) DeleteProvisioningTemplateRequest
}

// Send marshals and sends the DeleteProvisioningTemplate API request.
func (r DeleteProvisioningTemplateRequest) Send(ctx context.Context) (*DeleteProvisioningTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteProvisioningTemplateResponse{
		DeleteProvisioningTemplateOutput: r.Request.Data.(*DeleteProvisioningTemplateOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteProvisioningTemplateResponse is the response type for the
// DeleteProvisioningTemplate API operation.
type DeleteProvisioningTemplateResponse struct {
	*DeleteProvisioningTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteProvisioningTemplate request.
func (r *DeleteProvisioningTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
