// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package xray

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// An alias for an edge.
type Alias struct {
	_ struct{} `type:"structure"`

	// The canonical name of the alias.
	Name *string `type:"string"`

	// A list of names for the alias, including the canonical name.
	Names []string `type:"list"`

	// The type of the alias.
	Type *string `type:"string"`
}

// String returns the string representation
func (s Alias) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Alias) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Names != nil {
		v := s.Names

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Names", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Value of a segment annotation. Has one of three value types: Number, Boolean
// or String.
type AnnotationValue struct {
	_ struct{} `type:"structure"`

	// Value for a Boolean annotation.
	BooleanValue *bool `type:"boolean"`

	// Value for a Number annotation.
	NumberValue *float64 `type:"double"`

	// Value for a String annotation.
	StringValue *string `type:"string"`
}

// String returns the string representation
func (s AnnotationValue) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnnotationValue) MarshalFields(e protocol.FieldEncoder) error {
	if s.BooleanValue != nil {
		v := *s.BooleanValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BooleanValue", protocol.BoolValue(v), metadata)
	}
	if s.NumberValue != nil {
		v := *s.NumberValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NumberValue", protocol.Float64Value(v), metadata)
	}
	if s.StringValue != nil {
		v := *s.StringValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StringValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A list of availability zones corresponding to the segments in a trace.
type AvailabilityZoneDetail struct {
	_ struct{} `type:"structure"`

	// The name of a corresponding availability zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZoneDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AvailabilityZoneDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type BackendConnectionErrors struct {
	_ struct{} `type:"structure"`

	ConnectionRefusedCount *int64 `type:"integer"`

	HTTPCode4XXCount *int64 `type:"integer"`

	HTTPCode5XXCount *int64 `type:"integer"`

	OtherCount *int64 `type:"integer"`

	TimeoutCount *int64 `type:"integer"`

	UnknownHostCount *int64 `type:"integer"`
}

// String returns the string representation
func (s BackendConnectionErrors) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BackendConnectionErrors) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConnectionRefusedCount != nil {
		v := *s.ConnectionRefusedCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConnectionRefusedCount", protocol.Int64Value(v), metadata)
	}
	if s.HTTPCode4XXCount != nil {
		v := *s.HTTPCode4XXCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HTTPCode4XXCount", protocol.Int64Value(v), metadata)
	}
	if s.HTTPCode5XXCount != nil {
		v := *s.HTTPCode5XXCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HTTPCode5XXCount", protocol.Int64Value(v), metadata)
	}
	if s.OtherCount != nil {
		v := *s.OtherCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OtherCount", protocol.Int64Value(v), metadata)
	}
	if s.TimeoutCount != nil {
		v := *s.TimeoutCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimeoutCount", protocol.Int64Value(v), metadata)
	}
	if s.UnknownHostCount != nil {
		v := *s.UnknownHostCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UnknownHostCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Information about a connection between two services.
type Edge struct {
	_ struct{} `type:"structure"`

	// Aliases for the edge.
	Aliases []Alias `type:"list"`

	// The end time of the last segment on the edge.
	EndTime *time.Time `type:"timestamp"`

	// Identifier of the edge. Unique within a service map.
	ReferenceId *int64 `type:"integer"`

	// A histogram that maps the spread of client response times on an edge.
	ResponseTimeHistogram []HistogramEntry `type:"list"`

	// The start time of the first segment on the edge.
	StartTime *time.Time `type:"timestamp"`

	// Response statistics for segments on the edge.
	SummaryStatistics *EdgeStatistics `type:"structure"`
}

// String returns the string representation
func (s Edge) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Edge) MarshalFields(e protocol.FieldEncoder) error {
	if s.Aliases != nil {
		v := s.Aliases

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Aliases", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ReferenceId != nil {
		v := *s.ReferenceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReferenceId", protocol.Int64Value(v), metadata)
	}
	if s.ResponseTimeHistogram != nil {
		v := s.ResponseTimeHistogram

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResponseTimeHistogram", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.SummaryStatistics != nil {
		v := s.SummaryStatistics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SummaryStatistics", v, metadata)
	}
	return nil
}

// Response statistics for an edge.
type EdgeStatistics struct {
	_ struct{} `type:"structure"`

	// Information about requests that failed with a 4xx Client Error status code.
	ErrorStatistics *ErrorStatistics `type:"structure"`

	// Information about requests that failed with a 5xx Server Error status code.
	FaultStatistics *FaultStatistics `type:"structure"`

	// The number of requests that completed with a 2xx Success status code.
	OkCount *int64 `type:"long"`

	// The total number of completed requests.
	TotalCount *int64 `type:"long"`

	// The aggregate response time of completed requests.
	TotalResponseTime *float64 `type:"double"`
}

// String returns the string representation
func (s EdgeStatistics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EdgeStatistics) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorStatistics != nil {
		v := s.ErrorStatistics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ErrorStatistics", v, metadata)
	}
	if s.FaultStatistics != nil {
		v := s.FaultStatistics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FaultStatistics", v, metadata)
	}
	if s.OkCount != nil {
		v := *s.OkCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OkCount", protocol.Int64Value(v), metadata)
	}
	if s.TotalCount != nil {
		v := *s.TotalCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalCount", protocol.Int64Value(v), metadata)
	}
	if s.TotalResponseTime != nil {
		v := *s.TotalResponseTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalResponseTime", protocol.Float64Value(v), metadata)
	}
	return nil
}

// A configuration document that specifies encryption configuration settings.
type EncryptionConfig struct {
	_ struct{} `type:"structure"`

	// The ID of the customer master key (CMK) used for encryption, if applicable.
	KeyId *string `type:"string"`

	// The encryption status. While the status is UPDATING, X-Ray may encrypt data
	// with a combination of the new and old settings.
	Status EncryptionStatus `type:"string" enum:"true"`

	// The type of encryption. Set to KMS for encryption with CMKs. Set to NONE
	// for default encryption.
	Type EncryptionType `type:"string" enum:"true"`
}

// String returns the string representation
func (s EncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EncryptionConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.KeyId != nil {
		v := *s.KeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The root cause of a trace summary error.
type ErrorRootCause struct {
	_ struct{} `type:"structure"`

	// A list of services corresponding to an error. A service identifies a segment
	// and it contains a name, account ID, type, and inferred flag.
	Services []ErrorRootCauseService `type:"list"`
}

// String returns the string representation
func (s ErrorRootCause) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ErrorRootCause) MarshalFields(e protocol.FieldEncoder) error {
	if s.Services != nil {
		v := s.Services

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Services", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A collection of segments and corresponding subsegments associated to a trace
// summary error.
type ErrorRootCauseEntity struct {
	_ struct{} `type:"structure"`

	// The types and messages of the exceptions.
	Exceptions []RootCauseException `type:"list"`

	// The name of the entity.
	Name *string `type:"string"`

	// A flag that denotes a remote subsegment.
	Remote *bool `type:"boolean"`
}

// String returns the string representation
func (s ErrorRootCauseEntity) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ErrorRootCauseEntity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Exceptions != nil {
		v := s.Exceptions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Exceptions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Remote != nil {
		v := *s.Remote

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Remote", protocol.BoolValue(v), metadata)
	}
	return nil
}

// A collection of fields identifying the services in a trace summary error.
type ErrorRootCauseService struct {
	_ struct{} `type:"structure"`

	// The account ID associated to the service.
	AccountId *string `type:"string"`

	// The path of root cause entities found on the service.
	EntityPath []ErrorRootCauseEntity `type:"list"`

	// A Boolean value indicating if the service is inferred from the trace.
	Inferred *bool `type:"boolean"`

	// The service name.
	Name *string `type:"string"`

	// A collection of associated service names.
	Names []string `type:"list"`

	// The type associated to the service.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ErrorRootCauseService) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ErrorRootCauseService) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EntityPath != nil {
		v := s.EntityPath

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "EntityPath", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Inferred != nil {
		v := *s.Inferred

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Inferred", protocol.BoolValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Names != nil {
		v := s.Names

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Names", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about requests that failed with a 4xx Client Error status code.
type ErrorStatistics struct {
	_ struct{} `type:"structure"`

	// The number of requests that failed with untracked 4xx Client Error status
	// codes.
	OtherCount *int64 `type:"long"`

	// The number of requests that failed with a 419 throttling status code.
	ThrottleCount *int64 `type:"long"`

	// The total number of requests that failed with a 4xx Client Error status code.
	TotalCount *int64 `type:"long"`
}

// String returns the string representation
func (s ErrorStatistics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ErrorStatistics) MarshalFields(e protocol.FieldEncoder) error {
	if s.OtherCount != nil {
		v := *s.OtherCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OtherCount", protocol.Int64Value(v), metadata)
	}
	if s.ThrottleCount != nil {
		v := *s.ThrottleCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThrottleCount", protocol.Int64Value(v), metadata)
	}
	if s.TotalCount != nil {
		v := *s.TotalCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The root cause information for a trace summary fault.
type FaultRootCause struct {
	_ struct{} `type:"structure"`

	// A list of corresponding services. A service identifies a segment and it contains
	// a name, account ID, type, and inferred flag.
	Services []FaultRootCauseService `type:"list"`
}

// String returns the string representation
func (s FaultRootCause) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FaultRootCause) MarshalFields(e protocol.FieldEncoder) error {
	if s.Services != nil {
		v := s.Services

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Services", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A collection of segments and corresponding subsegments associated to a trace
// summary fault error.
type FaultRootCauseEntity struct {
	_ struct{} `type:"structure"`

	// The types and messages of the exceptions.
	Exceptions []RootCauseException `type:"list"`

	// The name of the entity.
	Name *string `type:"string"`

	// A flag that denotes a remote subsegment.
	Remote *bool `type:"boolean"`
}

// String returns the string representation
func (s FaultRootCauseEntity) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FaultRootCauseEntity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Exceptions != nil {
		v := s.Exceptions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Exceptions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Remote != nil {
		v := *s.Remote

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Remote", protocol.BoolValue(v), metadata)
	}
	return nil
}

// A collection of fields identifying the services in a trace summary fault.
type FaultRootCauseService struct {
	_ struct{} `type:"structure"`

	// The account ID associated to the service.
	AccountId *string `type:"string"`

	// The path of root cause entities found on the service.
	EntityPath []FaultRootCauseEntity `type:"list"`

	// A Boolean value indicating if the service is inferred from the trace.
	Inferred *bool `type:"boolean"`

	// The service name.
	Name *string `type:"string"`

	// A collection of associated service names.
	Names []string `type:"list"`

	// The type associated to the service.
	Type *string `type:"string"`
}

// String returns the string representation
func (s FaultRootCauseService) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FaultRootCauseService) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EntityPath != nil {
		v := s.EntityPath

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "EntityPath", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Inferred != nil {
		v := *s.Inferred

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Inferred", protocol.BoolValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Names != nil {
		v := s.Names

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Names", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about requests that failed with a 5xx Server Error status code.
type FaultStatistics struct {
	_ struct{} `type:"structure"`

	// The number of requests that failed with untracked 5xx Server Error status
	// codes.
	OtherCount *int64 `type:"long"`

	// The total number of requests that failed with a 5xx Server Error status code.
	TotalCount *int64 `type:"long"`
}

// String returns the string representation
func (s FaultStatistics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FaultStatistics) MarshalFields(e protocol.FieldEncoder) error {
	if s.OtherCount != nil {
		v := *s.OtherCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OtherCount", protocol.Int64Value(v), metadata)
	}
	if s.TotalCount != nil {
		v := *s.TotalCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Details and metadata for a group.
type Group struct {
	_ struct{} `type:"structure"`

	// The filter expression defining the parameters to include traces.
	FilterExpression *string `type:"string"`

	// The ARN of the group generated based on the GroupName.
	GroupARN *string `type:"string"`

	// The unique case-sensitive name of the group.
	GroupName *string `type:"string"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Group) MarshalFields(e protocol.FieldEncoder) error {
	if s.FilterExpression != nil {
		v := *s.FilterExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FilterExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupARN != nil {
		v := *s.GroupARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupName != nil {
		v := *s.GroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details for a group without metadata.
type GroupSummary struct {
	_ struct{} `type:"structure"`

	// The filter expression defining the parameters to include traces.
	FilterExpression *string `type:"string"`

	// The ARN of the group generated based on the GroupName.
	GroupARN *string `type:"string"`

	// The unique case-sensitive name of the group.
	GroupName *string `type:"string"`
}

// String returns the string representation
func (s GroupSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GroupSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.FilterExpression != nil {
		v := *s.FilterExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FilterExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupARN != nil {
		v := *s.GroupARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupName != nil {
		v := *s.GroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An entry in a histogram for a statistic. A histogram maps the range of observed
// values on the X axis, and the prevalence of each value on the Y axis.
type HistogramEntry struct {
	_ struct{} `type:"structure"`

	// The prevalence of the entry.
	Count *int64 `type:"integer"`

	// The value of the entry.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s HistogramEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HistogramEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Count", protocol.Int64Value(v), metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Information about an HTTP request.
type Http struct {
	_ struct{} `type:"structure"`

	// The IP address of the requestor.
	ClientIp *string `type:"string"`

	// The request method.
	HttpMethod *string `type:"string"`

	// The response status.
	HttpStatus *int64 `type:"integer"`

	// The request URL.
	HttpURL *string `type:"string"`

	// The request's user agent string.
	UserAgent *string `type:"string"`
}

// String returns the string representation
func (s Http) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Http) MarshalFields(e protocol.FieldEncoder) error {
	if s.ClientIp != nil {
		v := *s.ClientIp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientIp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HttpMethod != nil {
		v := *s.HttpMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HttpMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HttpStatus != nil {
		v := *s.HttpStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HttpStatus", protocol.Int64Value(v), metadata)
	}
	if s.HttpURL != nil {
		v := *s.HttpURL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HttpURL", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserAgent != nil {
		v := *s.UserAgent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserAgent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A list of EC2 instance IDs corresponding to the segments in a trace.
type InstanceIdDetail struct {
	_ struct{} `type:"structure"`

	// The ID of a corresponding EC2 instance.
	Id *string `type:"string"`
}

// String returns the string representation
func (s InstanceIdDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InstanceIdDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A list of resources ARNs corresponding to the segments in a trace.
type ResourceARNDetail struct {
	_ struct{} `type:"structure"`

	// The ARN of a corresponding resource.
	ARN *string `type:"string"`
}

// String returns the string representation
func (s ResourceARNDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceARNDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.ARN != nil {
		v := *s.ARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The root cause information for a response time warning.
type ResponseTimeRootCause struct {
	_ struct{} `type:"structure"`

	// A list of corresponding services. A service identifies a segment and contains
	// a name, account ID, type, and inferred flag.
	Services []ResponseTimeRootCauseService `type:"list"`
}

// String returns the string representation
func (s ResponseTimeRootCause) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResponseTimeRootCause) MarshalFields(e protocol.FieldEncoder) error {
	if s.Services != nil {
		v := s.Services

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Services", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A collection of segments and corresponding subsegments associated to a response
// time warning.
type ResponseTimeRootCauseEntity struct {
	_ struct{} `type:"structure"`

	// The types and messages of the exceptions.
	Coverage *float64 `type:"double"`

	// The name of the entity.
	Name *string `type:"string"`

	// A flag that denotes a remote subsegment.
	Remote *bool `type:"boolean"`
}

// String returns the string representation
func (s ResponseTimeRootCauseEntity) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResponseTimeRootCauseEntity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Coverage != nil {
		v := *s.Coverage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Coverage", protocol.Float64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Remote != nil {
		v := *s.Remote

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Remote", protocol.BoolValue(v), metadata)
	}
	return nil
}

// A collection of fields identifying the service in a response time warning.
type ResponseTimeRootCauseService struct {
	_ struct{} `type:"structure"`

	// The account ID associated to the service.
	AccountId *string `type:"string"`

	// The path of root cause entities found on the service.
	EntityPath []ResponseTimeRootCauseEntity `type:"list"`

	// A Boolean value indicating if the service is inferred from the trace.
	Inferred *bool `type:"boolean"`

	// The service name.
	Name *string `type:"string"`

	// A collection of associated service names.
	Names []string `type:"list"`

	// The type associated to the service.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ResponseTimeRootCauseService) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResponseTimeRootCauseService) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EntityPath != nil {
		v := s.EntityPath

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "EntityPath", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Inferred != nil {
		v := *s.Inferred

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Inferred", protocol.BoolValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Names != nil {
		v := s.Names

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Names", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The exception associated with a root cause.
type RootCauseException struct {
	_ struct{} `type:"structure"`

	// The message of the exception.
	Message *string `type:"string"`

	// The name of the exception.
	Name *string `type:"string"`
}

// String returns the string representation
func (s RootCauseException) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RootCauseException) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A sampling rule that services use to decide whether to instrument a request.
// Rule fields can match properties of the service, or properties of a request.
// The service can ignore rules that don't match its properties.
type SamplingRule struct {
	_ struct{} `type:"structure"`

	// Matches attributes derived from the request.
	Attributes map[string]string `type:"map"`

	// The percentage of matching requests to instrument, after the reservoir is
	// exhausted.
	//
	// FixedRate is a required field
	FixedRate *float64 `type:"double" required:"true"`

	// Matches the HTTP method of a request.
	//
	// HTTPMethod is a required field
	HTTPMethod *string `type:"string" required:"true"`

	// Matches the hostname from a request URL.
	//
	// Host is a required field
	Host *string `type:"string" required:"true"`

	// The priority of the sampling rule.
	//
	// Priority is a required field
	Priority *int64 `min:"1" type:"integer" required:"true"`

	// A fixed number of matching requests to instrument per second, prior to applying
	// the fixed rate. The reservoir is not used directly by services, but applies
	// to all services using the rule collectively.
	//
	// ReservoirSize is a required field
	ReservoirSize *int64 `type:"integer" required:"true"`

	// Matches the ARN of the AWS resource on which the service runs.
	//
	// ResourceARN is a required field
	ResourceARN *string `type:"string" required:"true"`

	// The ARN of the sampling rule. Specify a rule by either name or ARN, but not
	// both.
	RuleARN *string `type:"string"`

	// The name of the sampling rule. Specify a rule by either name or ARN, but
	// not both.
	RuleName *string `min:"1" type:"string"`

	// Matches the name that the service uses to identify itself in segments.
	//
	// ServiceName is a required field
	ServiceName *string `type:"string" required:"true"`

	// Matches the origin that the service uses to identify its type in segments.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true"`

	// Matches the path from a request URL.
	//
	// URLPath is a required field
	URLPath *string `type:"string" required:"true"`

	// The version of the sampling rule format (1).
	//
	// Version is a required field
	Version *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s SamplingRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SamplingRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SamplingRule"}

	if s.FixedRate == nil {
		invalidParams.Add(aws.NewErrParamRequired("FixedRate"))
	}

	if s.HTTPMethod == nil {
		invalidParams.Add(aws.NewErrParamRequired("HTTPMethod"))
	}

	if s.Host == nil {
		invalidParams.Add(aws.NewErrParamRequired("Host"))
	}

	if s.Priority == nil {
		invalidParams.Add(aws.NewErrParamRequired("Priority"))
	}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Priority", 1))
	}

	if s.ReservoirSize == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReservoirSize"))
	}

	if s.ResourceARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARN"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleName", 1))
	}

	if s.ServiceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceName"))
	}

	if s.ServiceType == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceType"))
	}

	if s.URLPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("URLPath"))
	}

	if s.Version == nil {
		invalidParams.Add(aws.NewErrParamRequired("Version"))
	}
	if s.Version != nil && *s.Version < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SamplingRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.FixedRate != nil {
		v := *s.FixedRate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FixedRate", protocol.Float64Value(v), metadata)
	}
	if s.HTTPMethod != nil {
		v := *s.HTTPMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HTTPMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Host != nil {
		v := *s.Host

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Host", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Priority", protocol.Int64Value(v), metadata)
	}
	if s.ReservoirSize != nil {
		v := *s.ReservoirSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReservoirSize", protocol.Int64Value(v), metadata)
	}
	if s.ResourceARN != nil {
		v := *s.ResourceARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RuleARN != nil {
		v := *s.RuleARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RuleARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RuleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ServiceName != nil {
		v := *s.ServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ServiceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ServiceType != nil {
		v := *s.ServiceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ServiceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.URLPath != nil {
		v := *s.URLPath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "URLPath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A SamplingRule and its metadata.
type SamplingRuleRecord struct {
	_ struct{} `type:"structure"`

	// When the rule was created.
	CreatedAt *time.Time `type:"timestamp"`

	// When the rule was last modified.
	ModifiedAt *time.Time `type:"timestamp"`

	// The sampling rule.
	SamplingRule *SamplingRule `type:"structure"`
}

// String returns the string representation
func (s SamplingRuleRecord) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SamplingRuleRecord) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ModifiedAt != nil {
		v := *s.ModifiedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ModifiedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.SamplingRule != nil {
		v := s.SamplingRule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SamplingRule", v, metadata)
	}
	return nil
}

// A document specifying changes to a sampling rule's configuration.
type SamplingRuleUpdate struct {
	_ struct{} `type:"structure"`

	// Matches attributes derived from the request.
	Attributes map[string]string `type:"map"`

	// The percentage of matching requests to instrument, after the reservoir is
	// exhausted.
	FixedRate *float64 `type:"double"`

	// Matches the HTTP method of a request.
	HTTPMethod *string `type:"string"`

	// Matches the hostname from a request URL.
	Host *string `type:"string"`

	// The priority of the sampling rule.
	Priority *int64 `type:"integer"`

	// A fixed number of matching requests to instrument per second, prior to applying
	// the fixed rate. The reservoir is not used directly by services, but applies
	// to all services using the rule collectively.
	ReservoirSize *int64 `type:"integer"`

	// Matches the ARN of the AWS resource on which the service runs.
	ResourceARN *string `type:"string"`

	// The ARN of the sampling rule. Specify a rule by either name or ARN, but not
	// both.
	RuleARN *string `type:"string"`

	// The name of the sampling rule. Specify a rule by either name or ARN, but
	// not both.
	RuleName *string `min:"1" type:"string"`

	// Matches the name that the service uses to identify itself in segments.
	ServiceName *string `type:"string"`

	// Matches the origin that the service uses to identify its type in segments.
	ServiceType *string `type:"string"`

	// Matches the path from a request URL.
	URLPath *string `type:"string"`
}

// String returns the string representation
func (s SamplingRuleUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SamplingRuleUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SamplingRuleUpdate"}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SamplingRuleUpdate) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.FixedRate != nil {
		v := *s.FixedRate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FixedRate", protocol.Float64Value(v), metadata)
	}
	if s.HTTPMethod != nil {
		v := *s.HTTPMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HTTPMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Host != nil {
		v := *s.Host

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Host", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Priority", protocol.Int64Value(v), metadata)
	}
	if s.ReservoirSize != nil {
		v := *s.ReservoirSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReservoirSize", protocol.Int64Value(v), metadata)
	}
	if s.ResourceARN != nil {
		v := *s.ResourceARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RuleARN != nil {
		v := *s.RuleARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RuleARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RuleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ServiceName != nil {
		v := *s.ServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ServiceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ServiceType != nil {
		v := *s.ServiceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ServiceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.URLPath != nil {
		v := *s.URLPath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "URLPath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Aggregated request sampling data for a sampling rule across all services
// for a 10 second window.
type SamplingStatisticSummary struct {
	_ struct{} `type:"structure"`

	// The number of requests recorded with borrowed reservoir quota.
	BorrowCount *int64 `type:"integer"`

	// The number of requests that matched the rule.
	RequestCount *int64 `type:"integer"`

	// The name of the sampling rule.
	RuleName *string `type:"string"`

	// The number of requests recorded.
	SampledCount *int64 `type:"integer"`

	// The start time of the reporting window.
	Timestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s SamplingStatisticSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SamplingStatisticSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.BorrowCount != nil {
		v := *s.BorrowCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BorrowCount", protocol.Int64Value(v), metadata)
	}
	if s.RequestCount != nil {
		v := *s.RequestCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestCount", protocol.Int64Value(v), metadata)
	}
	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RuleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SampledCount != nil {
		v := *s.SampledCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SampledCount", protocol.Int64Value(v), metadata)
	}
	if s.Timestamp != nil {
		v := *s.Timestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Request sampling results for a single rule from a service. Results are for
// the last 10 seconds unless the service has been assigned a longer reporting
// interval after a previous call to GetSamplingTargets.
type SamplingStatisticsDocument struct {
	_ struct{} `type:"structure"`

	// The number of requests recorded with borrowed reservoir quota.
	BorrowCount *int64 `type:"integer"`

	// A unique identifier for the service in hexadecimal.
	//
	// ClientID is a required field
	ClientID *string `min:"24" type:"string" required:"true"`

	// The number of requests that matched the rule.
	//
	// RequestCount is a required field
	RequestCount *int64 `type:"integer" required:"true"`

	// The name of the sampling rule.
	//
	// RuleName is a required field
	RuleName *string `min:"1" type:"string" required:"true"`

	// The number of requests recorded.
	//
	// SampledCount is a required field
	SampledCount *int64 `type:"integer" required:"true"`

	// The current time.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s SamplingStatisticsDocument) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SamplingStatisticsDocument) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SamplingStatisticsDocument"}

	if s.ClientID == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientID"))
	}
	if s.ClientID != nil && len(*s.ClientID) < 24 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientID", 24))
	}

	if s.RequestCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("RequestCount"))
	}

	if s.RuleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleName", 1))
	}

	if s.SampledCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("SampledCount"))
	}

	if s.Timestamp == nil {
		invalidParams.Add(aws.NewErrParamRequired("Timestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SamplingStatisticsDocument) MarshalFields(e protocol.FieldEncoder) error {
	if s.BorrowCount != nil {
		v := *s.BorrowCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BorrowCount", protocol.Int64Value(v), metadata)
	}
	if s.ClientID != nil {
		v := *s.ClientID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestCount != nil {
		v := *s.RequestCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestCount", protocol.Int64Value(v), metadata)
	}
	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RuleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SampledCount != nil {
		v := *s.SampledCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SampledCount", protocol.Int64Value(v), metadata)
	}
	if s.Timestamp != nil {
		v := *s.Timestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The name and value of a sampling rule to apply to a trace summary.
type SamplingStrategy struct {
	_ struct{} `type:"structure"`

	// The name of a sampling rule.
	Name SamplingStrategyName `type:"string" enum:"true"`

	// The value of a sampling rule.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s SamplingStrategy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SamplingStrategy) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Temporary changes to a sampling rule configuration. To meet the global sampling
// target for a rule, X-Ray calculates a new reservoir for each service based
// on the recent sampling results of all services that called GetSamplingTargets.
type SamplingTargetDocument struct {
	_ struct{} `type:"structure"`

	// The percentage of matching requests to instrument, after the reservoir is
	// exhausted.
	FixedRate *float64 `type:"double"`

	// The number of seconds for the service to wait before getting sampling targets
	// again.
	Interval *int64 `type:"integer"`

	// The number of requests per second that X-Ray allocated this service.
	ReservoirQuota *int64 `type:"integer"`

	// When the reservoir quota expires.
	ReservoirQuotaTTL *time.Time `type:"timestamp"`

	// The name of the sampling rule.
	RuleName *string `type:"string"`
}

// String returns the string representation
func (s SamplingTargetDocument) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SamplingTargetDocument) MarshalFields(e protocol.FieldEncoder) error {
	if s.FixedRate != nil {
		v := *s.FixedRate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FixedRate", protocol.Float64Value(v), metadata)
	}
	if s.Interval != nil {
		v := *s.Interval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Interval", protocol.Int64Value(v), metadata)
	}
	if s.ReservoirQuota != nil {
		v := *s.ReservoirQuota

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReservoirQuota", protocol.Int64Value(v), metadata)
	}
	if s.ReservoirQuotaTTL != nil {
		v := *s.ReservoirQuotaTTL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReservoirQuotaTTL",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RuleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A segment from a trace that has been ingested by the X-Ray service. The segment
// can be compiled from documents uploaded with PutTraceSegments, or an inferred
// segment for a downstream service, generated from a subsegment sent by the
// service that called it.
//
// For the full segment document schema, see AWS X-Ray Segment Documents (https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html)
// in the AWS X-Ray Developer Guide.
type Segment struct {
	_ struct{} `type:"structure"`

	// The segment document.
	Document *string `min:"1" type:"string"`

	// The segment's ID.
	Id *string `type:"string"`
}

// String returns the string representation
func (s Segment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Segment) MarshalFields(e protocol.FieldEncoder) error {
	if s.Document != nil {
		v := *s.Document

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Document", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about an application that processed requests, users that made
// requests, or downstream services, resources and applications that an application
// used.
type Service struct {
	_ struct{} `type:"structure"`

	// Identifier of the AWS account in which the service runs.
	AccountId *string `type:"string"`

	// A histogram that maps the spread of service durations.
	DurationHistogram []HistogramEntry `type:"list"`

	// Connections to downstream services.
	Edges []Edge `type:"list"`

	// The end time of the last segment that the service generated.
	EndTime *time.Time `type:"timestamp"`

	// The canonical name of the service.
	Name *string `type:"string"`

	// A list of names for the service, including the canonical name.
	Names []string `type:"list"`

	// Identifier for the service. Unique within the service map.
	ReferenceId *int64 `type:"integer"`

	// A histogram that maps the spread of service response times.
	ResponseTimeHistogram []HistogramEntry `type:"list"`

	// Indicates that the service was the first service to process a request.
	Root *bool `type:"boolean"`

	// The start time of the first segment that the service generated.
	StartTime *time.Time `type:"timestamp"`

	// The service's state.
	State *string `type:"string"`

	// Aggregated statistics for the service.
	SummaryStatistics *ServiceStatistics `type:"structure"`

	// The type of service.
	//
	//    * AWS Resource - The type of an AWS resource. For example, AWS::EC2::Instance
	//    for a application running on Amazon EC2 or AWS::DynamoDB::Table for an
	//    Amazon DynamoDB table that the application used.
	//
	//    * AWS Service - The type of an AWS service. For example, AWS::DynamoDB
	//    for downstream calls to Amazon DynamoDB that didn't target a specific
	//    table.
	//
	//    * client - Represents the clients that sent requests to a root service.
	//
	//    * remote - A downstream service of indeterminate type.
	Type *string `type:"string"`
}

// String returns the string representation
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Service) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DurationHistogram != nil {
		v := s.DurationHistogram

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DurationHistogram", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Edges != nil {
		v := s.Edges

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Edges", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Names != nil {
		v := s.Names

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Names", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ReferenceId != nil {
		v := *s.ReferenceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReferenceId", protocol.Int64Value(v), metadata)
	}
	if s.ResponseTimeHistogram != nil {
		v := s.ResponseTimeHistogram

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResponseTimeHistogram", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Root != nil {
		v := *s.Root

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Root", protocol.BoolValue(v), metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.State != nil {
		v := *s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SummaryStatistics != nil {
		v := s.SummaryStatistics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SummaryStatistics", v, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ServiceId struct {
	_ struct{} `type:"structure"`

	AccountId *string `type:"string"`

	Name *string `type:"string"`

	Names []string `type:"list"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s ServiceId) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServiceId) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Names != nil {
		v := s.Names

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Names", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Response statistics for a service.
type ServiceStatistics struct {
	_ struct{} `type:"structure"`

	// Information about requests that failed with a 4xx Client Error status code.
	ErrorStatistics *ErrorStatistics `type:"structure"`

	// Information about requests that failed with a 5xx Server Error status code.
	FaultStatistics *FaultStatistics `type:"structure"`

	// The number of requests that completed with a 2xx Success status code.
	OkCount *int64 `type:"long"`

	// The total number of completed requests.
	TotalCount *int64 `type:"long"`

	// The aggregate response time of completed requests.
	TotalResponseTime *float64 `type:"double"`
}

// String returns the string representation
func (s ServiceStatistics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServiceStatistics) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorStatistics != nil {
		v := s.ErrorStatistics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ErrorStatistics", v, metadata)
	}
	if s.FaultStatistics != nil {
		v := s.FaultStatistics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FaultStatistics", v, metadata)
	}
	if s.OkCount != nil {
		v := *s.OkCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OkCount", protocol.Int64Value(v), metadata)
	}
	if s.TotalCount != nil {
		v := *s.TotalCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalCount", protocol.Int64Value(v), metadata)
	}
	if s.TotalResponseTime != nil {
		v := *s.TotalResponseTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalResponseTime", protocol.Float64Value(v), metadata)
	}
	return nil
}

type TelemetryRecord struct {
	_ struct{} `type:"structure"`

	BackendConnectionErrors *BackendConnectionErrors `type:"structure"`

	SegmentsReceivedCount *int64 `type:"integer"`

	SegmentsRejectedCount *int64 `type:"integer"`

	SegmentsSentCount *int64 `type:"integer"`

	SegmentsSpilloverCount *int64 `type:"integer"`

	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s TelemetryRecord) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TelemetryRecord) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TelemetryRecord"}

	if s.Timestamp == nil {
		invalidParams.Add(aws.NewErrParamRequired("Timestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TelemetryRecord) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackendConnectionErrors != nil {
		v := s.BackendConnectionErrors

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "BackendConnectionErrors", v, metadata)
	}
	if s.SegmentsReceivedCount != nil {
		v := *s.SegmentsReceivedCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentsReceivedCount", protocol.Int64Value(v), metadata)
	}
	if s.SegmentsRejectedCount != nil {
		v := *s.SegmentsRejectedCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentsRejectedCount", protocol.Int64Value(v), metadata)
	}
	if s.SegmentsSentCount != nil {
		v := *s.SegmentsSentCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentsSentCount", protocol.Int64Value(v), metadata)
	}
	if s.SegmentsSpilloverCount != nil {
		v := *s.SegmentsSpilloverCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentsSpilloverCount", protocol.Int64Value(v), metadata)
	}
	if s.Timestamp != nil {
		v := *s.Timestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// A list of TimeSeriesStatistic structures.
type TimeSeriesServiceStatistics struct {
	_ struct{} `type:"structure"`

	// Response statistics for an edge.
	EdgeSummaryStatistics *EdgeStatistics `type:"structure"`

	// The response time histogram for the selected entities.
	ResponseTimeHistogram []HistogramEntry `type:"list"`

	// Response statistics for a service.
	ServiceSummaryStatistics *ServiceStatistics `type:"structure"`

	// Timestamp of the window for which statistics are aggregated.
	Timestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TimeSeriesServiceStatistics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TimeSeriesServiceStatistics) MarshalFields(e protocol.FieldEncoder) error {
	if s.EdgeSummaryStatistics != nil {
		v := s.EdgeSummaryStatistics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EdgeSummaryStatistics", v, metadata)
	}
	if s.ResponseTimeHistogram != nil {
		v := s.ResponseTimeHistogram

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResponseTimeHistogram", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ServiceSummaryStatistics != nil {
		v := s.ServiceSummaryStatistics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ServiceSummaryStatistics", v, metadata)
	}
	if s.Timestamp != nil {
		v := *s.Timestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// A collection of segment documents with matching trace IDs.
type Trace struct {
	_ struct{} `type:"structure"`

	// The length of time in seconds between the start time of the root segment
	// and the end time of the last segment that completed.
	Duration *float64 `type:"double"`

	// The unique identifier for the request that generated the trace's segments
	// and subsegments.
	Id *string `min:"1" type:"string"`

	// Segment documents for the segments and subsegments that comprise the trace.
	Segments []Segment `type:"list"`
}

// String returns the string representation
func (s Trace) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Trace) MarshalFields(e protocol.FieldEncoder) error {
	if s.Duration != nil {
		v := *s.Duration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Duration", protocol.Float64Value(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Segments != nil {
		v := s.Segments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Segments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Metadata generated from the segment documents in a trace.
type TraceSummary struct {
	_ struct{} `type:"structure"`

	// Annotations from the trace's segment documents.
	Annotations map[string][]ValueWithServiceIds `type:"map"`

	// A list of availability zones for any zone corresponding to the trace segments.
	AvailabilityZones []AvailabilityZoneDetail `type:"list"`

	// The length of time in seconds between the start time of the root segment
	// and the end time of the last segment that completed.
	Duration *float64 `type:"double"`

	// The root of a trace.
	EntryPoint *ServiceId `type:"structure"`

	// A collection of ErrorRootCause structures corresponding to the trace segments.
	ErrorRootCauses []ErrorRootCause `type:"list"`

	// A collection of FaultRootCause structures corresponding to the the trace
	// segments.
	FaultRootCauses []FaultRootCause `type:"list"`

	// One or more of the segment documents has a 400 series error.
	HasError *bool `type:"boolean"`

	// One or more of the segment documents has a 500 series error.
	HasFault *bool `type:"boolean"`

	// One or more of the segment documents has a 429 throttling error.
	HasThrottle *bool `type:"boolean"`

	// Information about the HTTP request served by the trace.
	Http *Http `type:"structure"`

	// The unique identifier for the request that generated the trace's segments
	// and subsegments.
	Id *string `min:"1" type:"string"`

	// A list of EC2 instance IDs for any instance corresponding to the trace segments.
	InstanceIds []InstanceIdDetail `type:"list"`

	// One or more of the segment documents is in progress.
	IsPartial *bool `type:"boolean"`

	// The matched time stamp of a defined event.
	MatchedEventTime *time.Time `type:"timestamp"`

	// A list of resource ARNs for any resource corresponding to the trace segments.
	ResourceARNs []ResourceARNDetail `type:"list"`

	// The length of time in seconds between the start and end times of the root
	// segment. If the service performs work asynchronously, the response time measures
	// the time before the response is sent to the user, while the duration measures
	// the amount of time before the last traced activity completes.
	ResponseTime *float64 `type:"double"`

	// A collection of ResponseTimeRootCause structures corresponding to the trace
	// segments.
	ResponseTimeRootCauses []ResponseTimeRootCause `type:"list"`

	// The revision number of a trace.
	Revision *int64 `type:"integer"`

	// Service IDs from the trace's segment documents.
	ServiceIds []ServiceId `type:"list"`

	// Users from the trace's segment documents.
	Users []TraceUser `type:"list"`
}

// String returns the string representation
func (s TraceSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TraceSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Annotations != nil {
		v := s.Annotations

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Annotations", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddFields(v2)
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.AvailabilityZones != nil {
		v := s.AvailabilityZones

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AvailabilityZones", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Duration != nil {
		v := *s.Duration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Duration", protocol.Float64Value(v), metadata)
	}
	if s.EntryPoint != nil {
		v := s.EntryPoint

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EntryPoint", v, metadata)
	}
	if s.ErrorRootCauses != nil {
		v := s.ErrorRootCauses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ErrorRootCauses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.FaultRootCauses != nil {
		v := s.FaultRootCauses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "FaultRootCauses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.HasError != nil {
		v := *s.HasError

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasError", protocol.BoolValue(v), metadata)
	}
	if s.HasFault != nil {
		v := *s.HasFault

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasFault", protocol.BoolValue(v), metadata)
	}
	if s.HasThrottle != nil {
		v := *s.HasThrottle

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasThrottle", protocol.BoolValue(v), metadata)
	}
	if s.Http != nil {
		v := s.Http

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Http", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceIds != nil {
		v := s.InstanceIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "InstanceIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.IsPartial != nil {
		v := *s.IsPartial

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsPartial", protocol.BoolValue(v), metadata)
	}
	if s.MatchedEventTime != nil {
		v := *s.MatchedEventTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MatchedEventTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ResourceARNs != nil {
		v := s.ResourceARNs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceARNs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResponseTime != nil {
		v := *s.ResponseTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResponseTime", protocol.Float64Value(v), metadata)
	}
	if s.ResponseTimeRootCauses != nil {
		v := s.ResponseTimeRootCauses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResponseTimeRootCauses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Revision != nil {
		v := *s.Revision

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Revision", protocol.Int64Value(v), metadata)
	}
	if s.ServiceIds != nil {
		v := s.ServiceIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ServiceIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Users != nil {
		v := s.Users

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Users", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Information about a user recorded in segment documents.
type TraceUser struct {
	_ struct{} `type:"structure"`

	// Services that the user's request hit.
	ServiceIds []ServiceId `type:"list"`

	// The user's name.
	UserName *string `type:"string"`
}

// String returns the string representation
func (s TraceUser) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TraceUser) MarshalFields(e protocol.FieldEncoder) error {
	if s.ServiceIds != nil {
		v := s.ServiceIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ServiceIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.UserName != nil {
		v := *s.UserName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Sampling statistics from a call to GetSamplingTargets that X-Ray could not
// process.
type UnprocessedStatistics struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The error message.
	Message *string `type:"string"`

	// The name of the sampling rule.
	RuleName *string `type:"string"`
}

// String returns the string representation
func (s UnprocessedStatistics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UnprocessedStatistics) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorCode != nil {
		v := *s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RuleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a segment that failed processing.
type UnprocessedTraceSegment struct {
	_ struct{} `type:"structure"`

	// The error that caused processing to fail.
	ErrorCode *string `type:"string"`

	// The segment's ID.
	Id *string `type:"string"`

	// The error message.
	Message *string `type:"string"`
}

// String returns the string representation
func (s UnprocessedTraceSegment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UnprocessedTraceSegment) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorCode != nil {
		v := *s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a segment annotation.
type ValueWithServiceIds struct {
	_ struct{} `type:"structure"`

	// Values of the annotation.
	AnnotationValue *AnnotationValue `type:"structure"`

	// Services to which the annotation applies.
	ServiceIds []ServiceId `type:"list"`
}

// String returns the string representation
func (s ValueWithServiceIds) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ValueWithServiceIds) MarshalFields(e protocol.FieldEncoder) error {
	if s.AnnotationValue != nil {
		v := s.AnnotationValue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AnnotationValue", v, metadata)
	}
	if s.ServiceIds != nil {
		v := s.ServiceIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ServiceIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}
