// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisassociateTransitGatewayMulticastDomainInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The IDs of the subnets;
	SubnetIds []string `locationNameList:"item" type:"list"`

	// The ID of the attachment.
	TransitGatewayAttachmentId *string `type:"string"`

	// The ID of the transit gateway multicast domain.
	TransitGatewayMulticastDomainId *string `type:"string"`
}

// String returns the string representation
func (s DisassociateTransitGatewayMulticastDomainInput) String() string {
	return awsutil.Prettify(s)
}

type DisassociateTransitGatewayMulticastDomainOutput struct {
	_ struct{} `type:"structure"`

	// Information about the association.
	Associations *TransitGatewayMulticastDomainAssociations `locationName:"associations" type:"structure"`
}

// String returns the string representation
func (s DisassociateTransitGatewayMulticastDomainOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateTransitGatewayMulticastDomain = "DisassociateTransitGatewayMulticastDomain"

// DisassociateTransitGatewayMulticastDomainRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Disassociates the specified subnets from the transit gateway multicast domain.
//
//    // Example sending a request using DisassociateTransitGatewayMulticastDomainRequest.
//    req := client.DisassociateTransitGatewayMulticastDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateTransitGatewayMulticastDomain
func (c *Client) DisassociateTransitGatewayMulticastDomainRequest(input *DisassociateTransitGatewayMulticastDomainInput) DisassociateTransitGatewayMulticastDomainRequest {
	op := &aws.Operation{
		Name:       opDisassociateTransitGatewayMulticastDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateTransitGatewayMulticastDomainInput{}
	}

	req := c.newRequest(op, input, &DisassociateTransitGatewayMulticastDomainOutput{})
	return DisassociateTransitGatewayMulticastDomainRequest{Request: req, Input: input, Copy: c.DisassociateTransitGatewayMulticastDomainRequest}
}

// DisassociateTransitGatewayMulticastDomainRequest is the request type for the
// DisassociateTransitGatewayMulticastDomain API operation.
type DisassociateTransitGatewayMulticastDomainRequest struct {
	*aws.Request
	Input *DisassociateTransitGatewayMulticastDomainInput
	Copy  func(*DisassociateTransitGatewayMulticastDomainInput) DisassociateTransitGatewayMulticastDomainRequest
}

// Send marshals and sends the DisassociateTransitGatewayMulticastDomain API request.
func (r DisassociateTransitGatewayMulticastDomainRequest) Send(ctx context.Context) (*DisassociateTransitGatewayMulticastDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateTransitGatewayMulticastDomainResponse{
		DisassociateTransitGatewayMulticastDomainOutput: r.Request.Data.(*DisassociateTransitGatewayMulticastDomainOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateTransitGatewayMulticastDomainResponse is the response type for the
// DisassociateTransitGatewayMulticastDomain API operation.
type DisassociateTransitGatewayMulticastDomainResponse struct {
	*DisassociateTransitGatewayMulticastDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateTransitGatewayMulticastDomain request.
func (r *DisassociateTransitGatewayMulticastDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
