// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53recoverycluster

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opGetRoutingControlState = "GetRoutingControlState"

// GetRoutingControlStateRequest generates a "aws/request.Request" representing the
// client's request for the GetRoutingControlState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRoutingControlState for more information on using the GetRoutingControlState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRoutingControlStateRequest method.
//    req, resp := client.GetRoutingControlStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/GetRoutingControlState
func (c *Route53RecoveryCluster) GetRoutingControlStateRequest(input *GetRoutingControlStateInput) (req *request.Request, output *GetRoutingControlStateOutput) {
	op := &request.Operation{
		Name:       opGetRoutingControlState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRoutingControlStateInput{}
	}

	output = &GetRoutingControlStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRoutingControlState API operation for Route53 Recovery Cluster.
//
// Get the state for a routing control. A routing control is a simple on/off
// switch that you can use to route traffic to cells. When the state is On,
// traffic flows to a cell. When it's off, traffic does not flow.
//
// Before you can create a routing control, you first must create a cluster
// to host the control. For more information, see CreateCluster (https://docs.aws.amazon.com/recovery-cluster/latest/api/cluster.html).
// Access one of the endpoints for the cluster to get or update the routing
// control state to redirect traffic.
//
// For more information about working with routing controls, see Routing control
// (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html)
// in the Route 53 Application Recovery Controller Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route53 Recovery Cluster's
// API operation GetRoutingControlState for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have sufficient permissions to query the routing control state.
//
//   * InternalServerException
//   There was an unexpected error during processing of the request.
//
//   * ResourceNotFoundException
//   The request references a routing control that was not found.
//
//   * ValidationException
//   There was a validation error on the request.
//
//   * ThrottlingException
//   The request was denied because of request throttling.
//
//   * EndpointTemporarilyUnavailableException
//   The cluster endpoint isn't available. Try another cluster endpoint.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/GetRoutingControlState
func (c *Route53RecoveryCluster) GetRoutingControlState(input *GetRoutingControlStateInput) (*GetRoutingControlStateOutput, error) {
	req, out := c.GetRoutingControlStateRequest(input)
	return out, req.Send()
}

// GetRoutingControlStateWithContext is the same as GetRoutingControlState with the addition of
// the ability to pass a context and additional request options.
//
// See GetRoutingControlState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryCluster) GetRoutingControlStateWithContext(ctx aws.Context, input *GetRoutingControlStateInput, opts ...request.Option) (*GetRoutingControlStateOutput, error) {
	req, out := c.GetRoutingControlStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoutingControlState = "UpdateRoutingControlState"

// UpdateRoutingControlStateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoutingControlState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoutingControlState for more information on using the UpdateRoutingControlState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRoutingControlStateRequest method.
//    req, resp := client.UpdateRoutingControlStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/UpdateRoutingControlState
func (c *Route53RecoveryCluster) UpdateRoutingControlStateRequest(input *UpdateRoutingControlStateInput) (req *request.Request, output *UpdateRoutingControlStateOutput) {
	op := &request.Operation{
		Name:       opUpdateRoutingControlState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRoutingControlStateInput{}
	}

	output = &UpdateRoutingControlStateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRoutingControlState API operation for Route53 Recovery Cluster.
//
// Set the state of the routing control to reroute traffic. You can set the
// value to be On or Off. When the state is On, traffic flows to a cell. When
// it's off, traffic does not flow.
//
// For more information about working with routing controls, see Routing control
// (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html)
// in the Route 53 Application Recovery Controller Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route53 Recovery Cluster's
// API operation UpdateRoutingControlState for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have sufficient permissions to query the routing control state.
//
//   * InternalServerException
//   There was an unexpected error during processing of the request.
//
//   * ResourceNotFoundException
//   The request references a routing control that was not found.
//
//   * ValidationException
//   There was a validation error on the request.
//
//   * ThrottlingException
//   The request was denied because of request throttling.
//
//   * EndpointTemporarilyUnavailableException
//   The cluster endpoint isn't available. Try another cluster endpoint.
//
//   * ConflictException
//   There was a conflict with this request. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/UpdateRoutingControlState
func (c *Route53RecoveryCluster) UpdateRoutingControlState(input *UpdateRoutingControlStateInput) (*UpdateRoutingControlStateOutput, error) {
	req, out := c.UpdateRoutingControlStateRequest(input)
	return out, req.Send()
}

// UpdateRoutingControlStateWithContext is the same as UpdateRoutingControlState with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoutingControlState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryCluster) UpdateRoutingControlStateWithContext(ctx aws.Context, input *UpdateRoutingControlStateInput, opts ...request.Option) (*UpdateRoutingControlStateOutput, error) {
	req, out := c.UpdateRoutingControlStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoutingControlStates = "UpdateRoutingControlStates"

// UpdateRoutingControlStatesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoutingControlStates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoutingControlStates for more information on using the UpdateRoutingControlStates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRoutingControlStatesRequest method.
//    req, resp := client.UpdateRoutingControlStatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/UpdateRoutingControlStates
func (c *Route53RecoveryCluster) UpdateRoutingControlStatesRequest(input *UpdateRoutingControlStatesInput) (req *request.Request, output *UpdateRoutingControlStatesOutput) {
	op := &request.Operation{
		Name:       opUpdateRoutingControlStates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRoutingControlStatesInput{}
	}

	output = &UpdateRoutingControlStatesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRoutingControlStates API operation for Route53 Recovery Cluster.
//
// Set multiple routing control states. You can set the value for each state
// to be On or Off. When the state is On, traffic flows to a cell. When it's
// off, traffic does not flow.
//
// For more information about working with routing controls, see Routing control
// (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html)
// in the Route 53 Application Recovery Controller Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route53 Recovery Cluster's
// API operation UpdateRoutingControlStates for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have sufficient permissions to query the routing control state.
//
//   * InternalServerException
//   There was an unexpected error during processing of the request.
//
//   * ResourceNotFoundException
//   The request references a routing control that was not found.
//
//   * ValidationException
//   There was a validation error on the request.
//
//   * ThrottlingException
//   The request was denied because of request throttling.
//
//   * EndpointTemporarilyUnavailableException
//   The cluster endpoint isn't available. Try another cluster endpoint.
//
//   * ConflictException
//   There was a conflict with this request. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-cluster-2019-12-02/UpdateRoutingControlStates
func (c *Route53RecoveryCluster) UpdateRoutingControlStates(input *UpdateRoutingControlStatesInput) (*UpdateRoutingControlStatesOutput, error) {
	req, out := c.UpdateRoutingControlStatesRequest(input)
	return out, req.Send()
}

// UpdateRoutingControlStatesWithContext is the same as UpdateRoutingControlStates with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoutingControlStates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryCluster) UpdateRoutingControlStatesWithContext(ctx aws.Context, input *UpdateRoutingControlStatesInput, opts ...request.Option) (*UpdateRoutingControlStatesOutput, error) {
	req, out := c.UpdateRoutingControlStatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have sufficient permissions to query the routing control state.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There was a conflict with this request. Try again.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the ConflictException error
	Message_ *string `locationName:"message" type:"string"`

	// Identifier of the resource in use
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// Type of the resource in use
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The cluster endpoint isn't available. Try another cluster endpoint.
type EndpointTemporarilyUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s EndpointTemporarilyUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointTemporarilyUnavailableException) GoString() string {
	return s.String()
}

func newErrorEndpointTemporarilyUnavailableException(v protocol.ResponseMetadata) error {
	return &EndpointTemporarilyUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EndpointTemporarilyUnavailableException) Code() string {
	return "EndpointTemporarilyUnavailableException"
}

// Message returns the exception's message.
func (s *EndpointTemporarilyUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EndpointTemporarilyUnavailableException) OrigErr() error {
	return nil
}

func (s *EndpointTemporarilyUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EndpointTemporarilyUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EndpointTemporarilyUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetRoutingControlStateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) for the routing control that you want to
	// get the state for.
	//
	// RoutingControlArn is a required field
	RoutingControlArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRoutingControlStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRoutingControlStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRoutingControlStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRoutingControlStateInput"}
	if s.RoutingControlArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlArn"))
	}
	if s.RoutingControlArn != nil && len(*s.RoutingControlArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingControlArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoutingControlArn sets the RoutingControlArn field's value.
func (s *GetRoutingControlStateInput) SetRoutingControlArn(v string) *GetRoutingControlStateInput {
	s.RoutingControlArn = &v
	return s
}

type GetRoutingControlStateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the response.
	//
	// RoutingControlArn is a required field
	RoutingControlArn *string `min:"1" type:"string" required:"true"`

	// The state of the routing control.
	//
	// RoutingControlState is a required field
	RoutingControlState *string `type:"string" required:"true" enum:"RoutingControlState"`
}

// String returns the string representation
func (s GetRoutingControlStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRoutingControlStateOutput) GoString() string {
	return s.String()
}

// SetRoutingControlArn sets the RoutingControlArn field's value.
func (s *GetRoutingControlStateOutput) SetRoutingControlArn(v string) *GetRoutingControlStateOutput {
	s.RoutingControlArn = &v
	return s
}

// SetRoutingControlState sets the RoutingControlState field's value.
func (s *GetRoutingControlStateOutput) SetRoutingControlState(v string) *GetRoutingControlStateOutput {
	s.RoutingControlState = &v
	return s
}

// There was an unexpected error during processing of the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Advice to clients on when the call can be safely retried
	RetryAfterSeconds *int64 `locationName:"retryAfterSeconds" type:"integer"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request references a routing control that was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Hypothetical resource identifier that was not found
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// Hypothetical resource type that was not found
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was denied because of request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Advice to clients on when the call can be safely retried
	RetryAfterSeconds *int64 `locationName:"retryAfterSeconds" type:"integer"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A routing control state.
type UpdateRoutingControlStateEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) for the routing control state entry.
	//
	// RoutingControlArn is a required field
	RoutingControlArn *string `min:"1" type:"string" required:"true"`

	// The routing control state in a set of routing control state entries.
	//
	// RoutingControlState is a required field
	RoutingControlState *string `type:"string" required:"true" enum:"RoutingControlState"`
}

// String returns the string representation
func (s UpdateRoutingControlStateEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRoutingControlStateEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoutingControlStateEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRoutingControlStateEntry"}
	if s.RoutingControlArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlArn"))
	}
	if s.RoutingControlArn != nil && len(*s.RoutingControlArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingControlArn", 1))
	}
	if s.RoutingControlState == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlState"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoutingControlArn sets the RoutingControlArn field's value.
func (s *UpdateRoutingControlStateEntry) SetRoutingControlArn(v string) *UpdateRoutingControlStateEntry {
	s.RoutingControlArn = &v
	return s
}

// SetRoutingControlState sets the RoutingControlState field's value.
func (s *UpdateRoutingControlStateEntry) SetRoutingControlState(v string) *UpdateRoutingControlStateEntry {
	s.RoutingControlState = &v
	return s
}

type UpdateRoutingControlStateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) for the routing control that you want to
	// update the state for.
	//
	// RoutingControlArn is a required field
	RoutingControlArn *string `min:"1" type:"string" required:"true"`

	// The state of the routing control. You can set the value to be On or Off.
	//
	// RoutingControlState is a required field
	RoutingControlState *string `type:"string" required:"true" enum:"RoutingControlState"`
}

// String returns the string representation
func (s UpdateRoutingControlStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRoutingControlStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoutingControlStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRoutingControlStateInput"}
	if s.RoutingControlArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlArn"))
	}
	if s.RoutingControlArn != nil && len(*s.RoutingControlArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingControlArn", 1))
	}
	if s.RoutingControlState == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlState"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoutingControlArn sets the RoutingControlArn field's value.
func (s *UpdateRoutingControlStateInput) SetRoutingControlArn(v string) *UpdateRoutingControlStateInput {
	s.RoutingControlArn = &v
	return s
}

// SetRoutingControlState sets the RoutingControlState field's value.
func (s *UpdateRoutingControlStateInput) SetRoutingControlState(v string) *UpdateRoutingControlStateInput {
	s.RoutingControlState = &v
	return s
}

type UpdateRoutingControlStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRoutingControlStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRoutingControlStateOutput) GoString() string {
	return s.String()
}

type UpdateRoutingControlStatesInput struct {
	_ struct{} `type:"structure"`

	// A set of routing control entries that you want to update.
	//
	// UpdateRoutingControlStateEntries is a required field
	UpdateRoutingControlStateEntries []*UpdateRoutingControlStateEntry `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateRoutingControlStatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRoutingControlStatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoutingControlStatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRoutingControlStatesInput"}
	if s.UpdateRoutingControlStateEntries == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateRoutingControlStateEntries"))
	}
	if s.UpdateRoutingControlStateEntries != nil {
		for i, v := range s.UpdateRoutingControlStateEntries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UpdateRoutingControlStateEntries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUpdateRoutingControlStateEntries sets the UpdateRoutingControlStateEntries field's value.
func (s *UpdateRoutingControlStatesInput) SetUpdateRoutingControlStateEntries(v []*UpdateRoutingControlStateEntry) *UpdateRoutingControlStatesInput {
	s.UpdateRoutingControlStateEntries = v
	return s
}

type UpdateRoutingControlStatesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRoutingControlStatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRoutingControlStatesOutput) GoString() string {
	return s.String()
}

// There was a validation error on the request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The fields that caused the error, if applicable
	Fields []*ValidationExceptionField `locationName:"fields" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// Reason the request failed validation
	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There was a validation error on the request.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Information about the validation exception.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The field that had the validation exception.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// RoutingControlStateOn is a RoutingControlState enum value
	RoutingControlStateOn = "On"

	// RoutingControlStateOff is a RoutingControlState enum value
	RoutingControlStateOff = "Off"
)

// RoutingControlState_Values returns all elements of the RoutingControlState enum
func RoutingControlState_Values() []string {
	return []string{
		RoutingControlStateOn,
		RoutingControlStateOff,
	}
}

// Reason the request failed validation
const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
