// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateDatasetImportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket that contains the training data to import.
	//
	// DataSource is a required field
	DataSource *DataSource `locationName:"dataSource" type:"structure" required:"true"`

	// The ARN of the dataset that receives the imported data.
	//
	// DatasetArn is a required field
	DatasetArn *string `locationName:"datasetArn" type:"string" required:"true"`

	// The name for the dataset import job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that has permissions to read from the Amazon S3 data
	// source.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDatasetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetImportJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDatasetImportJobInput"}

	if s.DataSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSource"))
	}

	if s.DatasetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatasetArn"))
	}

	if s.JobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobName", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateDatasetImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset import job.
	DatasetImportJobArn *string `locationName:"datasetImportJobArn" type:"string"`
}

// String returns the string representation
func (s CreateDatasetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDatasetImportJob = "CreateDatasetImportJob"

// CreateDatasetImportJobRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Creates a job that imports training data from your data source (an Amazon
// S3 bucket) to an Amazon Personalize dataset. To allow Amazon Personalize
// to import the training data, you must specify an AWS Identity and Access
// Management (IAM) role that has permission to read from the data source.
//
// The dataset import job replaces any previous data in the dataset.
//
// Status
//
// A dataset import job can be in one of the following states:
//
//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
// To get the status of the import job, call DescribeDatasetImportJob, providing
// the Amazon Resource Name (ARN) of the dataset import job. The dataset import
// is complete when the status shows as ACTIVE. If the status shows as CREATE
// FAILED, the response includes a failureReason key, which describes why the
// job failed.
//
// Importing takes time. You must wait until the status shows as ACTIVE before
// training a model using the dataset.
//
// Related APIs
//
//    * ListDatasetImportJobs
//
//    * DescribeDatasetImportJob
//
//    // Example sending a request using CreateDatasetImportJobRequest.
//    req := client.CreateDatasetImportJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetImportJob
func (c *Client) CreateDatasetImportJobRequest(input *CreateDatasetImportJobInput) CreateDatasetImportJobRequest {
	op := &aws.Operation{
		Name:       opCreateDatasetImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetImportJobInput{}
	}

	req := c.newRequest(op, input, &CreateDatasetImportJobOutput{})
	return CreateDatasetImportJobRequest{Request: req, Input: input, Copy: c.CreateDatasetImportJobRequest}
}

// CreateDatasetImportJobRequest is the request type for the
// CreateDatasetImportJob API operation.
type CreateDatasetImportJobRequest struct {
	*aws.Request
	Input *CreateDatasetImportJobInput
	Copy  func(*CreateDatasetImportJobInput) CreateDatasetImportJobRequest
}

// Send marshals and sends the CreateDatasetImportJob API request.
func (r CreateDatasetImportJobRequest) Send(ctx context.Context) (*CreateDatasetImportJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDatasetImportJobResponse{
		CreateDatasetImportJobOutput: r.Request.Data.(*CreateDatasetImportJobOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDatasetImportJobResponse is the response type for the
// CreateDatasetImportJob API operation.
type CreateDatasetImportJobResponse struct {
	*CreateDatasetImportJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDatasetImportJob request.
func (r *CreateDatasetImportJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
