// DO NOT EDIT: This file is autogenerated via the builtin command.

package tickscript

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
	runtime "github.com/influxdata/flux/runtime"
	"regexp"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 69,
					Line:   174,
				},
				File:   "tickscript.flux",
				Source: "package tickscript\n\n\nimport \"experimental\"\nimport \"experimental/array\"\nimport \"influxdata/influxdb\"\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/schema\"\nimport \"universe\"\n\n// defineCheck creates custom check data required by alert() and deadman()\ndefineCheck = (id, name, type=\"custom\") => {\n    return {\n        _check_id: id,\n        _check_name: name,\n        _type: type,\n        tags: {},\n    }\n}\n\n// alert is a helper function similar to TICKscript alert.\nalert = (\n        check,\n        id=(r) => \"${r._check_id}\",\n        details=(r) => \"\",\n        message=(r) => \"Threshold Check: ${r._check_name} is: ${r._level}\",\n        crit=(r) => false,\n        warn=(r) => false,\n        info=(r) => false,\n        ok=(r) => true,\n        topic=\"\",\n        tables=<-,\n) => {\n    _addTopic = if topic != \"\" then\n        (tables=<-) => tables\n            |> set(key: \"_topic\", value: topic)\n            |> experimental.group(mode: \"extend\", columns: [\"_topic\"])\n    else\n        (tables=<-) => tables\n\n    return tables\n        |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n        |> map(\n            fn: (r) => ({r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            }),\n        )\n        |> map(fn: (r) => ({r with id: id(r: r)}))\n        |> map(fn: (r) => ({r with details: details(r: r)}))\n        |> _addTopic()\n        |> monitor.check(\n            crit: crit,\n            warn: warn,\n            info: info,\n            ok: ok,\n            messageFn: message,\n            data: check,\n        )\n}\n\n// deadman is a helper function similar to TICKscript deadman.\ndeadman = (\n        check,\n        measurement,\n        threshold=0,\n        id=(r) => \"${r._check_id}\",\n        message=(r) => \"Deadman Check: ${r._check_name} is: \" + (if r.dead then \"dead\" else \"alive\"),\n        topic=\"\",\n        tables=<-,\n) => {\n    // In order to detect empty stream (without tables), we concatenate input with dummy stream and count the result,\n    // because count() returns nothing for empty stream. If the input stream is empty, then dummy stream with empty\n    // table is used as input for actual threshold check in order to get 0.\n    _dummy = array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n        |> set(key: \"_measurement\", value: measurement)\n        // required by monitor.check\n        |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")\n        // input tables are expected to be pivoted already    \n        |> schema.fieldsAsCols()\n    _counts = union(tables: [_dummy, tables])\n        |> keep(columns: [\"_measurement\", \"_time\"])\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")\n        |> findColumn(fn: (key) => key._measurement == measurement, column: \"__value__\")\n    _tables = \n        // only dummy table is in the concatenated stream\n        if _counts[0] == 1 then\n            _dummy\n                |> drop(columns: [\"unknown\"])\n                // need empty table\n                |> limit(n: 0)\n        else\n            tables\n\n    return _tables\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")\n        // recreate _time column after aggregation\n        |> map(fn: (r) => ({r with _time: now()}))\n        // same tag that monitor.deadman() adds\n        |> map(fn: (r) => ({r with dead: r.__value__ <= threshold}))\n        // drop dummy field\n        |> drop(columns: [\"__value__\"])\n        |> alert(\n            check: check,\n            id: id,\n            message: message,\n            crit: (r) => r.dead,\n            topic: topic,\n        )\n}\n\n// select selects a column and optionally computes aggregated value.\n// It is meant to be a convenience function to be used for:\n//\n//   query(\"SELECT x AS y\")\n//   query(\"SELECT f(x) AS y\") without time grouping\n//\nselect = (column=\"_value\", fn=(column, tables=<-) => tables, as, tables=<-) => {\n    _column = column\n    _as = as\n\n    return tables\n        |> fn(column: _column)\n        |> rename(fn: (column) => if column == _column then _as else column)\n}\n\n// selectWindow selects a column with time grouping and computes aggregated values.\n// It is a convenience function to be used as\n//\n//   query(\"SELECT f(x) AS y\")\n//     .groupBy(time(t), ...)\n//\nselectWindow = (\n        column=\"_value\",\n        fn,\n        as,\n        every,\n        defaultValue,\n        tables=<-,\n) => {\n    _column = column\n    _as = as\n\n    return tables\n        |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)\n        |> fill(column: _column, value: defaultValue)\n        |> rename(fn: (column) => if column == _column then _as else column)\n}\n\n// compute computes aggregated value of the input data.\n// It is a convenience function to be used as\n//\n//   |median('x)'\n//      .as(y)\n//\ncompute = select\n\n// groupBy groups by specified columns.\n// It is a convenience function, it adds _measurement column which is required by monitor.check().\ngroupBy = (columns, tables=<-) => tables\n    |> group(columns: columns)\n    // required by monitor.check\n    |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")\n\n// join merges two streams using standard join().\n// It is meant a convenience function, it ensures _measurement column exists and is in the group key.\njoin = (tables, on=[\"_time\"], measurement) => universe.join(tables: tables, on: on)\n    |> map(fn: (r) => ({r with _measurement: measurement}))\n    // required by monitor.check\n    |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   19,
					},
					File:   "tickscript.flux",
					Source: "defineCheck = (id, name, type=\"custom\") => {\n    return {\n        _check_id: id,\n        _check_name: name,\n        _type: type,\n        tags: {},\n    }\n}",
					Start: ast.Position{
						Column: 1,
						Line:   12,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// defineCheck creates custom check data required by alert() and deadman()\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   12,
						},
						File:   "tickscript.flux",
						Source: "defineCheck",
						Start: ast.Position{
							Column: 1,
							Line:   12,
						},
					},
				},
				Name: "defineCheck",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   19,
						},
						File:   "tickscript.flux",
						Source: "(id, name, type=\"custom\") => {\n    return {\n        _check_id: id,\n        _check_name: name,\n        _type: type,\n        tags: {},\n    }\n}",
						Start: ast.Position{
							Column: 15,
							Line:   12,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   19,
							},
							File:   "tickscript.flux",
							Source: "{\n    return {\n        _check_id: id,\n        _check_name: name,\n        _type: type,\n        tags: {},\n    }\n}",
							Start: ast.Position{
								Column: 44,
								Line:   12,
							},
						},
					},
					Body: []ast.Statement{&ast.ReturnStatement{
						Argument: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   18,
									},
									File:   "tickscript.flux",
									Source: "{\n        _check_id: id,\n        _check_name: name,\n        _type: type,\n        tags: {},\n    }",
									Start: ast.Position{
										Column: 12,
										Line:   13,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   14,
										},
										File:   "tickscript.flux",
										Source: "_check_id: id",
										Start: ast.Position{
											Column: 9,
											Line:   14,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   14,
											},
											File:   "tickscript.flux",
											Source: "_check_id",
											Start: ast.Position{
												Column: 9,
												Line:   14,
											},
										},
									},
									Name: "_check_id",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   14,
											},
											File:   "tickscript.flux",
											Source: "id",
											Start: ast.Position{
												Column: 20,
												Line:   14,
											},
										},
									},
									Name: "id",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   15,
										},
										File:   "tickscript.flux",
										Source: "_check_name: name",
										Start: ast.Position{
											Column: 9,
											Line:   15,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   15,
											},
											File:   "tickscript.flux",
											Source: "_check_name",
											Start: ast.Position{
												Column: 9,
												Line:   15,
											},
										},
									},
									Name: "_check_name",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   15,
											},
											File:   "tickscript.flux",
											Source: "name",
											Start: ast.Position{
												Column: 22,
												Line:   15,
											},
										},
									},
									Name: "name",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   16,
										},
										File:   "tickscript.flux",
										Source: "_type: type",
										Start: ast.Position{
											Column: 9,
											Line:   16,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   16,
											},
											File:   "tickscript.flux",
											Source: "_type",
											Start: ast.Position{
												Column: 9,
												Line:   16,
											},
										},
									},
									Name: "_type",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   16,
											},
											File:   "tickscript.flux",
											Source: "type",
											Start: ast.Position{
												Column: 16,
												Line:   16,
											},
										},
									},
									Name: "type",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   17,
										},
										File:   "tickscript.flux",
										Source: "tags: {}",
										Start: ast.Position{
											Column: 9,
											Line:   17,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   17,
											},
											File:   "tickscript.flux",
											Source: "tags",
											Start: ast.Position{
												Column: 9,
												Line:   17,
											},
										},
									},
									Name: "tags",
								},
								Separator: nil,
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   17,
											},
											File:   "tickscript.flux",
											Source: "{}",
											Start: ast.Position{
												Column: 15,
												Line:   17,
											},
										},
									},
									Lbrace:     nil,
									Properties: []*ast.Property{},
									Rbrace:     nil,
									With:       nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   18,
								},
								File:   "tickscript.flux",
								Source: "return {\n        _check_id: id,\n        _check_name: name,\n        _type: type,\n        tags: {},\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   13,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   12,
							},
							File:   "tickscript.flux",
							Source: "id",
							Start: ast.Position{
								Column: 16,
								Line:   12,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   12,
								},
								File:   "tickscript.flux",
								Source: "id",
								Start: ast.Position{
									Column: 16,
									Line:   12,
								},
							},
						},
						Name: "id",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   12,
							},
							File:   "tickscript.flux",
							Source: "name",
							Start: ast.Position{
								Column: 20,
								Line:   12,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   12,
								},
								File:   "tickscript.flux",
								Source: "name",
								Start: ast.Position{
									Column: 20,
									Line:   12,
								},
							},
						},
						Name: "name",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   12,
							},
							File:   "tickscript.flux",
							Source: "type=\"custom\"",
							Start: ast.Position{
								Column: 26,
								Line:   12,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   12,
								},
								File:   "tickscript.flux",
								Source: "type",
								Start: ast.Position{
									Column: 26,
									Line:   12,
								},
							},
						},
						Name: "type",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   12,
								},
								File:   "tickscript.flux",
								Source: "\"custom\"",
								Start: ast.Position{
									Column: 31,
									Line:   12,
								},
							},
						},
						Value: "custom",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   60,
					},
					File:   "tickscript.flux",
					Source: "alert = (\n        check,\n        id=(r) => \"${r._check_id}\",\n        details=(r) => \"\",\n        message=(r) => \"Threshold Check: ${r._check_name} is: ${r._level}\",\n        crit=(r) => false,\n        warn=(r) => false,\n        info=(r) => false,\n        ok=(r) => true,\n        topic=\"\",\n        tables=<-,\n) => {\n    _addTopic = if topic != \"\" then\n        (tables=<-) => tables\n            |> set(key: \"_topic\", value: topic)\n            |> experimental.group(mode: \"extend\", columns: [\"_topic\"])\n    else\n        (tables=<-) => tables\n\n    return tables\n        |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n        |> map(\n            fn: (r) => ({r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            }),\n        )\n        |> map(fn: (r) => ({r with id: id(r: r)}))\n        |> map(fn: (r) => ({r with details: details(r: r)}))\n        |> _addTopic()\n        |> monitor.check(\n            crit: crit,\n            warn: warn,\n            info: info,\n            ok: ok,\n            messageFn: message,\n            data: check,\n        )\n}",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// alert is a helper function similar to TICKscript alert.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   22,
						},
						File:   "tickscript.flux",
						Source: "alert",
						Start: ast.Position{
							Column: 1,
							Line:   22,
						},
					},
				},
				Name: "alert",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   60,
						},
						File:   "tickscript.flux",
						Source: "(\n        check,\n        id=(r) => \"${r._check_id}\",\n        details=(r) => \"\",\n        message=(r) => \"Threshold Check: ${r._check_name} is: ${r._level}\",\n        crit=(r) => false,\n        warn=(r) => false,\n        info=(r) => false,\n        ok=(r) => true,\n        topic=\"\",\n        tables=<-,\n) => {\n    _addTopic = if topic != \"\" then\n        (tables=<-) => tables\n            |> set(key: \"_topic\", value: topic)\n            |> experimental.group(mode: \"extend\", columns: [\"_topic\"])\n    else\n        (tables=<-) => tables\n\n    return tables\n        |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n        |> map(\n            fn: (r) => ({r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            }),\n        )\n        |> map(fn: (r) => ({r with id: id(r: r)}))\n        |> map(fn: (r) => ({r with details: details(r: r)}))\n        |> _addTopic()\n        |> monitor.check(\n            crit: crit,\n            warn: warn,\n            info: info,\n            ok: ok,\n            messageFn: message,\n            data: check,\n        )\n}",
						Start: ast.Position{
							Column: 9,
							Line:   22,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   60,
							},
							File:   "tickscript.flux",
							Source: "{\n    _addTopic = if topic != \"\" then\n        (tables=<-) => tables\n            |> set(key: \"_topic\", value: topic)\n            |> experimental.group(mode: \"extend\", columns: [\"_topic\"])\n    else\n        (tables=<-) => tables\n\n    return tables\n        |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n        |> map(\n            fn: (r) => ({r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            }),\n        )\n        |> map(fn: (r) => ({r with id: id(r: r)}))\n        |> map(fn: (r) => ({r with details: details(r: r)}))\n        |> _addTopic()\n        |> monitor.check(\n            crit: crit,\n            warn: warn,\n            info: info,\n            ok: ok,\n            messageFn: message,\n            data: check,\n        )\n}",
							Start: ast.Position{
								Column: 6,
								Line:   33,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   39,
								},
								File:   "tickscript.flux",
								Source: "_addTopic = if topic != \"\" then\n        (tables=<-) => tables\n            |> set(key: \"_topic\", value: topic)\n            |> experimental.group(mode: \"extend\", columns: [\"_topic\"])\n    else\n        (tables=<-) => tables",
								Start: ast.Position{
									Column: 5,
									Line:   34,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   34,
									},
									File:   "tickscript.flux",
									Source: "_addTopic",
									Start: ast.Position{
										Column: 5,
										Line:   34,
									},
								},
							},
							Name: "_addTopic",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   39,
										},
										File:   "tickscript.flux",
										Source: "(tables=<-) => tables",
										Start: ast.Position{
											Column: 9,
											Line:   39,
										},
									},
								},
								Body: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   39,
											},
											File:   "tickscript.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 24,
												Line:   39,
											},
										},
									},
									Name: "tables",
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   39,
											},
											File:   "tickscript.flux",
											Source: "tables=<-",
											Start: ast.Position{
												Column: 10,
												Line:   39,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   39,
												},
												File:   "tickscript.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 10,
													Line:   39,
												},
											},
										},
										Name: "tables",
									},
									Separator: nil,
									Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   39,
											},
											File:   "tickscript.flux",
											Source: "<-",
											Start: ast.Position{
												Column: 17,
												Line:   39,
											},
										},
									}},
								}},
								Rparan: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   39,
									},
									File:   "tickscript.flux",
									Source: "if topic != \"\" then\n        (tables=<-) => tables\n            |> set(key: \"_topic\", value: topic)\n            |> experimental.group(mode: \"extend\", columns: [\"_topic\"])\n    else\n        (tables=<-) => tables",
									Start: ast.Position{
										Column: 17,
										Line:   34,
									},
								},
							},
							Consequent: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   37,
										},
										File:   "tickscript.flux",
										Source: "(tables=<-) => tables\n            |> set(key: \"_topic\", value: topic)\n            |> experimental.group(mode: \"extend\", columns: [\"_topic\"])",
										Start: ast.Position{
											Column: 9,
											Line:   35,
										},
									},
								},
								Body: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   35,
													},
													File:   "tickscript.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   36,
												},
												File:   "tickscript.flux",
												Source: "tables\n            |> set(key: \"_topic\", value: topic)",
												Start: ast.Position{
													Column: 24,
													Line:   35,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   36,
														},
														File:   "tickscript.flux",
														Source: "key: \"_topic\", value: topic",
														Start: ast.Position{
															Column: 20,
															Line:   36,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 33,
																Line:   36,
															},
															File:   "tickscript.flux",
															Source: "key: \"_topic\"",
															Start: ast.Position{
																Column: 20,
																Line:   36,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   36,
																},
																File:   "tickscript.flux",
																Source: "key",
																Start: ast.Position{
																	Column: 20,
																	Line:   36,
																},
															},
														},
														Name: "key",
													},
													Separator: nil,
													Value: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 33,
																	Line:   36,
																},
																File:   "tickscript.flux",
																Source: "\"_topic\"",
																Start: ast.Position{
																	Column: 25,
																	Line:   36,
																},
															},
														},
														Value: "_topic",
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   36,
															},
															File:   "tickscript.flux",
															Source: "value: topic",
															Start: ast.Position{
																Column: 35,
																Line:   36,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 40,
																	Line:   36,
																},
																File:   "tickscript.flux",
																Source: "value",
																Start: ast.Position{
																	Column: 35,
																	Line:   36,
																},
															},
														},
														Name: "value",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   36,
																},
																File:   "tickscript.flux",
																Source: "topic",
																Start: ast.Position{
																	Column: 42,
																	Line:   36,
																},
															},
														},
														Name: "topic",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   36,
													},
													File:   "tickscript.flux",
													Source: "set(key: \"_topic\", value: topic)",
													Start: ast.Position{
														Column: 16,
														Line:   36,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   36,
														},
														File:   "tickscript.flux",
														Source: "set",
														Start: ast.Position{
															Column: 16,
															Line:   36,
														},
													},
												},
												Name: "set",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   37,
											},
											File:   "tickscript.flux",
											Source: "tables\n            |> set(key: \"_topic\", value: topic)\n            |> experimental.group(mode: \"extend\", columns: [\"_topic\"])",
											Start: ast.Position{
												Column: 24,
												Line:   35,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   37,
													},
													File:   "tickscript.flux",
													Source: "mode: \"extend\", columns: [\"_topic\"]",
													Start: ast.Position{
														Column: 35,
														Line:   37,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   37,
														},
														File:   "tickscript.flux",
														Source: "mode: \"extend\"",
														Start: ast.Position{
															Column: 35,
															Line:   37,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   37,
															},
															File:   "tickscript.flux",
															Source: "mode",
															Start: ast.Position{
																Column: 35,
																Line:   37,
															},
														},
													},
													Name: "mode",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 49,
																Line:   37,
															},
															File:   "tickscript.flux",
															Source: "\"extend\"",
															Start: ast.Position{
																Column: 41,
																Line:   37,
															},
														},
													},
													Value: "extend",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   37,
														},
														File:   "tickscript.flux",
														Source: "columns: [\"_topic\"]",
														Start: ast.Position{
															Column: 51,
															Line:   37,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 58,
																Line:   37,
															},
															File:   "tickscript.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 51,
																Line:   37,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 70,
																Line:   37,
															},
															File:   "tickscript.flux",
															Source: "[\"_topic\"]",
															Start: ast.Position{
																Column: 60,
																Line:   37,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   37,
																},
																File:   "tickscript.flux",
																Source: "\"_topic\"",
																Start: ast.Position{
																	Column: 61,
																	Line:   37,
																},
															},
														},
														Value: "_topic",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   37,
												},
												File:   "tickscript.flux",
												Source: "experimental.group(mode: \"extend\", columns: [\"_topic\"])",
												Start: ast.Position{
													Column: 16,
													Line:   37,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   37,
													},
													File:   "tickscript.flux",
													Source: "experimental.group",
													Start: ast.Position{
														Column: 16,
														Line:   37,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   37,
														},
														File:   "tickscript.flux",
														Source: "experimental",
														Start: ast.Position{
															Column: 16,
															Line:   37,
														},
													},
												},
												Name: "experimental",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   37,
														},
														File:   "tickscript.flux",
														Source: "group",
														Start: ast.Position{
															Column: 29,
															Line:   37,
														},
													},
												},
												Name: "group",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   35,
											},
											File:   "tickscript.flux",
											Source: "tables=<-",
											Start: ast.Position{
												Column: 10,
												Line:   35,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   35,
												},
												File:   "tickscript.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 10,
													Line:   35,
												},
											},
										},
										Name: "tables",
									},
									Separator: nil,
									Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   35,
											},
											File:   "tickscript.flux",
											Source: "<-",
											Start: ast.Position{
												Column: 17,
												Line:   35,
											},
										},
									}},
								}},
								Rparan: nil,
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   34,
										},
										File:   "tickscript.flux",
										Source: "topic != \"\"",
										Start: ast.Position{
											Column: 20,
											Line:   34,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   34,
											},
											File:   "tickscript.flux",
											Source: "topic",
											Start: ast.Position{
												Column: 20,
												Line:   34,
											},
										},
									},
									Name: "topic",
								},
								Operator: 18,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   34,
											},
											File:   "tickscript.flux",
											Source: "\"\"",
											Start: ast.Position{
												Column: 29,
												Line:   34,
											},
										},
									},
									Value: "",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.PipeExpression{
												Argument: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   41,
															},
															File:   "tickscript.flux",
															Source: "tables",
															Start: ast.Position{
																Column: 12,
																Line:   41,
															},
														},
													},
													Name: "tables",
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   42,
														},
														File:   "tickscript.flux",
														Source: "tables\n        |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)",
														Start: ast.Position{
															Column: 12,
															Line:   41,
														},
													},
												},
												Call: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 76,
																	Line:   42,
																},
																File:   "tickscript.flux",
																Source: "fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/",
																Start: ast.Position{
																	Column: 17,
																	Line:   42,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 76,
																		Line:   42,
																	},
																	File:   "tickscript.flux",
																	Source: "fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/",
																	Start: ast.Position{
																		Column: 17,
																		Line:   42,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 19,
																			Line:   42,
																		},
																		File:   "tickscript.flux",
																		Source: "fn",
																		Start: ast.Position{
																			Column: 17,
																			Line:   42,
																		},
																	},
																},
																Name: "fn",
															},
															Separator: nil,
															Value: &ast.FunctionExpression{
																Arrow: nil,
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 76,
																			Line:   42,
																		},
																		File:   "tickscript.flux",
																		Source: "(column) => column =~ /_start.*/ or column =~ /_stop.*/",
																		Start: ast.Position{
																			Column: 21,
																			Line:   42,
																		},
																	},
																},
																Body: &ast.LogicalExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 76,
																				Line:   42,
																			},
																			File:   "tickscript.flux",
																			Source: "column =~ /_start.*/ or column =~ /_stop.*/",
																			Start: ast.Position{
																				Column: 33,
																				Line:   42,
																			},
																		},
																	},
																	Left: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 53,
																					Line:   42,
																				},
																				File:   "tickscript.flux",
																				Source: "column =~ /_start.*/",
																				Start: ast.Position{
																					Column: 33,
																					Line:   42,
																				},
																			},
																		},
																		Left: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 39,
																						Line:   42,
																					},
																					File:   "tickscript.flux",
																					Source: "column",
																					Start: ast.Position{
																						Column: 33,
																						Line:   42,
																					},
																				},
																			},
																			Name: "column",
																		},
																		Operator: 19,
																		Right: &ast.RegexpLiteral{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 53,
																						Line:   42,
																					},
																					File:   "tickscript.flux",
																					Source: "/_start.*/",
																					Start: ast.Position{
																						Column: 43,
																						Line:   42,
																					},
																				},
																			},
																			Value: regexp.MustCompile("_start.*"),
																		},
																	},
																	Operator: 2,
																	Right: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 76,
																					Line:   42,
																				},
																				File:   "tickscript.flux",
																				Source: "column =~ /_stop.*/",
																				Start: ast.Position{
																					Column: 57,
																					Line:   42,
																				},
																			},
																		},
																		Left: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 63,
																						Line:   42,
																					},
																					File:   "tickscript.flux",
																					Source: "column",
																					Start: ast.Position{
																						Column: 57,
																						Line:   42,
																					},
																				},
																			},
																			Name: "column",
																		},
																		Operator: 19,
																		Right: &ast.RegexpLiteral{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 76,
																						Line:   42,
																					},
																					File:   "tickscript.flux",
																					Source: "/_stop.*/",
																					Start: ast.Position{
																						Column: 67,
																						Line:   42,
																					},
																				},
																			},
																			Value: regexp.MustCompile("_stop.*"),
																		},
																	},
																},
																Lparen: nil,
																Params: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   42,
																			},
																			File:   "tickscript.flux",
																			Source: "column",
																			Start: ast.Position{
																				Column: 22,
																				Line:   42,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   42,
																				},
																				File:   "tickscript.flux",
																				Source: "column",
																				Start: ast.Position{
																					Column: 22,
																					Line:   42,
																				},
																			},
																		},
																		Name: "column",
																	},
																	Separator: nil,
																	Value:     nil,
																}},
																Rparan: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   42,
															},
															File:   "tickscript.flux",
															Source: "drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)",
															Start: ast.Position{
																Column: 12,
																Line:   42,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   42,
																},
																File:   "tickscript.flux",
																Source: "drop",
																Start: ast.Position{
																	Column: 12,
																	Line:   42,
																},
															},
														},
														Name: "drop",
													},
													Lparen: nil,
													Rparen: nil,
												},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   48,
													},
													File:   "tickscript.flux",
													Source: "tables\n        |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n        |> map(\n            fn: (r) => ({r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            }),\n        )",
													Start: ast.Position{
														Column: 12,
														Line:   41,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   47,
															},
															File:   "tickscript.flux",
															Source: "fn: (r) => ({r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            })",
															Start: ast.Position{
																Column: 13,
																Line:   44,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 15,
																	Line:   47,
																},
																File:   "tickscript.flux",
																Source: "fn: (r) => ({r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            })",
																Start: ast.Position{
																	Column: 13,
																	Line:   44,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 15,
																		Line:   44,
																	},
																	File:   "tickscript.flux",
																	Source: "fn",
																	Start: ast.Position{
																		Column: 13,
																		Line:   44,
																	},
																},
															},
															Name: "fn",
														},
														Separator: nil,
														Value: &ast.FunctionExpression{
															Arrow: nil,
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 15,
																		Line:   47,
																	},
																	File:   "tickscript.flux",
																	Source: "(r) => ({r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            })",
																	Start: ast.Position{
																		Column: 17,
																		Line:   44,
																	},
																},
															},
															Body: &ast.ParenExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 15,
																			Line:   47,
																		},
																		File:   "tickscript.flux",
																		Source: "({r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            })",
																		Start: ast.Position{
																			Column: 24,
																			Line:   44,
																		},
																	},
																},
																Expression: &ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 14,
																				Line:   47,
																			},
																			File:   "tickscript.flux",
																			Source: "{r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            }",
																			Start: ast.Position{
																				Column: 25,
																				Line:   44,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 43,
																					Line:   45,
																				},
																				File:   "tickscript.flux",
																				Source: "_check_id: check._check_id",
																				Start: ast.Position{
																					Column: 17,
																					Line:   45,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 26,
																						Line:   45,
																					},
																					File:   "tickscript.flux",
																					Source: "_check_id",
																					Start: ast.Position{
																						Column: 17,
																						Line:   45,
																					},
																				},
																			},
																			Name: "_check_id",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 43,
																						Line:   45,
																					},
																					File:   "tickscript.flux",
																					Source: "check._check_id",
																					Start: ast.Position{
																						Column: 28,
																						Line:   45,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 33,
																							Line:   45,
																						},
																						File:   "tickscript.flux",
																						Source: "check",
																						Start: ast.Position{
																							Column: 28,
																							Line:   45,
																						},
																					},
																				},
																				Name: "check",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 43,
																							Line:   45,
																						},
																						File:   "tickscript.flux",
																						Source: "_check_id",
																						Start: ast.Position{
																							Column: 34,
																							Line:   45,
																						},
																					},
																				},
																				Name: "_check_id",
																			},
																			Rbrack: nil,
																		},
																	}, &ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 47,
																					Line:   46,
																				},
																				File:   "tickscript.flux",
																				Source: "_check_name: check._check_name",
																				Start: ast.Position{
																					Column: 17,
																					Line:   46,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 28,
																						Line:   46,
																					},
																					File:   "tickscript.flux",
																					Source: "_check_name",
																					Start: ast.Position{
																						Column: 17,
																						Line:   46,
																					},
																				},
																			},
																			Name: "_check_name",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 47,
																						Line:   46,
																					},
																					File:   "tickscript.flux",
																					Source: "check._check_name",
																					Start: ast.Position{
																						Column: 30,
																						Line:   46,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 35,
																							Line:   46,
																						},
																						File:   "tickscript.flux",
																						Source: "check",
																						Start: ast.Position{
																							Column: 30,
																							Line:   46,
																						},
																					},
																				},
																				Name: "check",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 47,
																							Line:   46,
																						},
																						File:   "tickscript.flux",
																						Source: "_check_name",
																						Start: ast.Position{
																							Column: 36,
																							Line:   46,
																						},
																					},
																				},
																				Name: "_check_name",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 27,
																					Line:   44,
																				},
																				File:   "tickscript.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 26,
																					Line:   44,
																				},
																			},
																		},
																		Name: "r",
																	},
																},
																Lparen: nil,
																Rparen: nil,
															},
															Lparen: nil,
															Params: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 19,
																			Line:   44,
																		},
																		File:   "tickscript.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 18,
																			Line:   44,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 19,
																				Line:   44,
																			},
																			File:   "tickscript.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 18,
																				Line:   44,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value:     nil,
															}},
															Rparan: nil,
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   48,
														},
														File:   "tickscript.flux",
														Source: "map(\n            fn: (r) => ({r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            }),\n        )",
														Start: ast.Position{
															Column: 12,
															Line:   43,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   43,
															},
															File:   "tickscript.flux",
															Source: "map",
															Start: ast.Position{
																Column: 12,
																Line:   43,
															},
														},
													},
													Name: "map",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   49,
												},
												File:   "tickscript.flux",
												Source: "tables\n        |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n        |> map(\n            fn: (r) => ({r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            }),\n        )\n        |> map(fn: (r) => ({r with id: id(r: r)}))",
												Start: ast.Position{
													Column: 12,
													Line:   41,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   49,
														},
														File:   "tickscript.flux",
														Source: "fn: (r) => ({r with id: id(r: r)})",
														Start: ast.Position{
															Column: 16,
															Line:   49,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   49,
															},
															File:   "tickscript.flux",
															Source: "fn: (r) => ({r with id: id(r: r)})",
															Start: ast.Position{
																Column: 16,
																Line:   49,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   49,
																},
																File:   "tickscript.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 16,
																	Line:   49,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.FunctionExpression{
														Arrow: nil,
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   49,
																},
																File:   "tickscript.flux",
																Source: "(r) => ({r with id: id(r: r)})",
																Start: ast.Position{
																	Column: 20,
																	Line:   49,
																},
															},
														},
														Body: &ast.ParenExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 50,
																		Line:   49,
																	},
																	File:   "tickscript.flux",
																	Source: "({r with id: id(r: r)})",
																	Start: ast.Position{
																		Column: 27,
																		Line:   49,
																	},
																},
															},
															Expression: &ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   49,
																		},
																		File:   "tickscript.flux",
																		Source: "{r with id: id(r: r)}",
																		Start: ast.Position{
																			Column: 28,
																			Line:   49,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   49,
																			},
																			File:   "tickscript.flux",
																			Source: "id: id(r: r)",
																			Start: ast.Position{
																				Column: 36,
																				Line:   49,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 38,
																					Line:   49,
																				},
																				File:   "tickscript.flux",
																				Source: "id",
																				Start: ast.Position{
																					Column: 36,
																					Line:   49,
																				},
																			},
																		},
																		Name: "id",
																	},
																	Separator: nil,
																	Value: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 47,
																						Line:   49,
																					},
																					File:   "tickscript.flux",
																					Source: "r: r",
																					Start: ast.Position{
																						Column: 43,
																						Line:   49,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 47,
																							Line:   49,
																						},
																						File:   "tickscript.flux",
																						Source: "r: r",
																						Start: ast.Position{
																							Column: 43,
																							Line:   49,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 44,
																								Line:   49,
																							},
																							File:   "tickscript.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 43,
																								Line:   49,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Separator: nil,
																				Value: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 47,
																								Line:   49,
																							},
																							File:   "tickscript.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 46,
																								Line:   49,
																							},
																						},
																					},
																					Name: "r",
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 48,
																					Line:   49,
																				},
																				File:   "tickscript.flux",
																				Source: "id(r: r)",
																				Start: ast.Position{
																					Column: 40,
																					Line:   49,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 42,
																						Line:   49,
																					},
																					File:   "tickscript.flux",
																					Source: "id",
																					Start: ast.Position{
																						Column: 40,
																						Line:   49,
																					},
																				},
																			},
																			Name: "id",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																}},
																Rbrace: nil,
																With: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   49,
																			},
																			File:   "tickscript.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 29,
																				Line:   49,
																			},
																		},
																	},
																	Name: "r",
																},
															},
															Lparen: nil,
															Rparen: nil,
														},
														Lparen: nil,
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   49,
																	},
																	File:   "tickscript.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   49,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   49,
																		},
																		File:   "tickscript.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 21,
																			Line:   49,
																		},
																	},
																},
																Name: "r",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rparan: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 51,
														Line:   49,
													},
													File:   "tickscript.flux",
													Source: "map(fn: (r) => ({r with id: id(r: r)}))",
													Start: ast.Position{
														Column: 12,
														Line:   49,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   49,
														},
														File:   "tickscript.flux",
														Source: "map",
														Start: ast.Position{
															Column: 12,
															Line:   49,
														},
													},
												},
												Name: "map",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   50,
											},
											File:   "tickscript.flux",
											Source: "tables\n        |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n        |> map(\n            fn: (r) => ({r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            }),\n        )\n        |> map(fn: (r) => ({r with id: id(r: r)}))\n        |> map(fn: (r) => ({r with details: details(r: r)}))",
											Start: ast.Position{
												Column: 12,
												Line:   41,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   50,
													},
													File:   "tickscript.flux",
													Source: "fn: (r) => ({r with details: details(r: r)})",
													Start: ast.Position{
														Column: 16,
														Line:   50,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   50,
														},
														File:   "tickscript.flux",
														Source: "fn: (r) => ({r with details: details(r: r)})",
														Start: ast.Position{
															Column: 16,
															Line:   50,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   50,
															},
															File:   "tickscript.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 16,
																Line:   50,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 60,
																Line:   50,
															},
															File:   "tickscript.flux",
															Source: "(r) => ({r with details: details(r: r)})",
															Start: ast.Position{
																Column: 20,
																Line:   50,
															},
														},
													},
													Body: &ast.ParenExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   50,
																},
																File:   "tickscript.flux",
																Source: "({r with details: details(r: r)})",
																Start: ast.Position{
																	Column: 27,
																	Line:   50,
																},
															},
														},
														Expression: &ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 59,
																		Line:   50,
																	},
																	File:   "tickscript.flux",
																	Source: "{r with details: details(r: r)}",
																	Start: ast.Position{
																		Column: 28,
																		Line:   50,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   50,
																		},
																		File:   "tickscript.flux",
																		Source: "details: details(r: r)",
																		Start: ast.Position{
																			Column: 36,
																			Line:   50,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 43,
																				Line:   50,
																			},
																			File:   "tickscript.flux",
																			Source: "details",
																			Start: ast.Position{
																				Column: 36,
																				Line:   50,
																			},
																		},
																	},
																	Name: "details",
																},
																Separator: nil,
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 57,
																					Line:   50,
																				},
																				File:   "tickscript.flux",
																				Source: "r: r",
																				Start: ast.Position{
																					Column: 53,
																					Line:   50,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 57,
																						Line:   50,
																					},
																					File:   "tickscript.flux",
																					Source: "r: r",
																					Start: ast.Position{
																						Column: 53,
																						Line:   50,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 54,
																							Line:   50,
																						},
																						File:   "tickscript.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 53,
																							Line:   50,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Separator: nil,
																			Value: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 57,
																							Line:   50,
																						},
																						File:   "tickscript.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 56,
																							Line:   50,
																						},
																					},
																				},
																				Name: "r",
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 58,
																				Line:   50,
																			},
																			File:   "tickscript.flux",
																			Source: "details(r: r)",
																			Start: ast.Position{
																				Column: 45,
																				Line:   50,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 52,
																					Line:   50,
																				},
																				File:   "tickscript.flux",
																				Source: "details",
																				Start: ast.Position{
																					Column: 45,
																					Line:   50,
																				},
																			},
																		},
																		Name: "details",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															}},
															Rbrace: nil,
															With: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 30,
																			Line:   50,
																		},
																		File:   "tickscript.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 29,
																			Line:   50,
																		},
																	},
																},
																Name: "r",
															},
														},
														Lparen: nil,
														Rparen: nil,
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   50,
																},
																File:   "tickscript.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 21,
																	Line:   50,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   50,
																	},
																	File:   "tickscript.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   50,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   50,
												},
												File:   "tickscript.flux",
												Source: "map(fn: (r) => ({r with details: details(r: r)}))",
												Start: ast.Position{
													Column: 12,
													Line:   50,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   50,
													},
													File:   "tickscript.flux",
													Source: "map",
													Start: ast.Position{
														Column: 12,
														Line:   50,
													},
												},
											},
											Name: "map",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   51,
										},
										File:   "tickscript.flux",
										Source: "tables\n        |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n        |> map(\n            fn: (r) => ({r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            }),\n        )\n        |> map(fn: (r) => ({r with id: id(r: r)}))\n        |> map(fn: (r) => ({r with details: details(r: r)}))\n        |> _addTopic()",
										Start: ast.Position{
											Column: 12,
											Line:   41,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   51,
											},
											File:   "tickscript.flux",
											Source: "_addTopic()",
											Start: ast.Position{
												Column: 12,
												Line:   51,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   51,
												},
												File:   "tickscript.flux",
												Source: "_addTopic",
												Start: ast.Position{
													Column: 12,
													Line:   51,
												},
											},
										},
										Name: "_addTopic",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   59,
									},
									File:   "tickscript.flux",
									Source: "tables\n        |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n        |> map(\n            fn: (r) => ({r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            }),\n        )\n        |> map(fn: (r) => ({r with id: id(r: r)}))\n        |> map(fn: (r) => ({r with details: details(r: r)}))\n        |> _addTopic()\n        |> monitor.check(\n            crit: crit,\n            warn: warn,\n            info: info,\n            ok: ok,\n            messageFn: message,\n            data: check,\n        )",
									Start: ast.Position{
										Column: 12,
										Line:   41,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   58,
											},
											File:   "tickscript.flux",
											Source: "crit: crit,\n            warn: warn,\n            info: info,\n            ok: ok,\n            messageFn: message,\n            data: check",
											Start: ast.Position{
												Column: 13,
												Line:   53,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   53,
												},
												File:   "tickscript.flux",
												Source: "crit: crit",
												Start: ast.Position{
													Column: 13,
													Line:   53,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   53,
													},
													File:   "tickscript.flux",
													Source: "crit",
													Start: ast.Position{
														Column: 13,
														Line:   53,
													},
												},
											},
											Name: "crit",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   53,
													},
													File:   "tickscript.flux",
													Source: "crit",
													Start: ast.Position{
														Column: 19,
														Line:   53,
													},
												},
											},
											Name: "crit",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   54,
												},
												File:   "tickscript.flux",
												Source: "warn: warn",
												Start: ast.Position{
													Column: 13,
													Line:   54,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   54,
													},
													File:   "tickscript.flux",
													Source: "warn",
													Start: ast.Position{
														Column: 13,
														Line:   54,
													},
												},
											},
											Name: "warn",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   54,
													},
													File:   "tickscript.flux",
													Source: "warn",
													Start: ast.Position{
														Column: 19,
														Line:   54,
													},
												},
											},
											Name: "warn",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   55,
												},
												File:   "tickscript.flux",
												Source: "info: info",
												Start: ast.Position{
													Column: 13,
													Line:   55,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   55,
													},
													File:   "tickscript.flux",
													Source: "info",
													Start: ast.Position{
														Column: 13,
														Line:   55,
													},
												},
											},
											Name: "info",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   55,
													},
													File:   "tickscript.flux",
													Source: "info",
													Start: ast.Position{
														Column: 19,
														Line:   55,
													},
												},
											},
											Name: "info",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   56,
												},
												File:   "tickscript.flux",
												Source: "ok: ok",
												Start: ast.Position{
													Column: 13,
													Line:   56,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   56,
													},
													File:   "tickscript.flux",
													Source: "ok",
													Start: ast.Position{
														Column: 13,
														Line:   56,
													},
												},
											},
											Name: "ok",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   56,
													},
													File:   "tickscript.flux",
													Source: "ok",
													Start: ast.Position{
														Column: 17,
														Line:   56,
													},
												},
											},
											Name: "ok",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   57,
												},
												File:   "tickscript.flux",
												Source: "messageFn: message",
												Start: ast.Position{
													Column: 13,
													Line:   57,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   57,
													},
													File:   "tickscript.flux",
													Source: "messageFn",
													Start: ast.Position{
														Column: 13,
														Line:   57,
													},
												},
											},
											Name: "messageFn",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   57,
													},
													File:   "tickscript.flux",
													Source: "message",
													Start: ast.Position{
														Column: 24,
														Line:   57,
													},
												},
											},
											Name: "message",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   58,
												},
												File:   "tickscript.flux",
												Source: "data: check",
												Start: ast.Position{
													Column: 13,
													Line:   58,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   58,
													},
													File:   "tickscript.flux",
													Source: "data",
													Start: ast.Position{
														Column: 13,
														Line:   58,
													},
												},
											},
											Name: "data",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   58,
													},
													File:   "tickscript.flux",
													Source: "check",
													Start: ast.Position{
														Column: 19,
														Line:   58,
													},
												},
											},
											Name: "check",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   59,
										},
										File:   "tickscript.flux",
										Source: "monitor.check(\n            crit: crit,\n            warn: warn,\n            info: info,\n            ok: ok,\n            messageFn: message,\n            data: check,\n        )",
										Start: ast.Position{
											Column: 12,
											Line:   52,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   52,
											},
											File:   "tickscript.flux",
											Source: "monitor.check",
											Start: ast.Position{
												Column: 12,
												Line:   52,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   52,
												},
												File:   "tickscript.flux",
												Source: "monitor",
												Start: ast.Position{
													Column: 12,
													Line:   52,
												},
											},
										},
										Name: "monitor",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   52,
												},
												File:   "tickscript.flux",
												Source: "check",
												Start: ast.Position{
													Column: 20,
													Line:   52,
												},
											},
										},
										Name: "check",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   59,
								},
								File:   "tickscript.flux",
								Source: "return tables\n        |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n        |> map(\n            fn: (r) => ({r with\n                _check_id: check._check_id,\n                _check_name: check._check_name,\n            }),\n        )\n        |> map(fn: (r) => ({r with id: id(r: r)}))\n        |> map(fn: (r) => ({r with details: details(r: r)}))\n        |> _addTopic()\n        |> monitor.check(\n            crit: crit,\n            warn: warn,\n            info: info,\n            ok: ok,\n            messageFn: message,\n            data: check,\n        )",
								Start: ast.Position{
									Column: 5,
									Line:   41,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   23,
							},
							File:   "tickscript.flux",
							Source: "check",
							Start: ast.Position{
								Column: 9,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   23,
								},
								File:   "tickscript.flux",
								Source: "check",
								Start: ast.Position{
									Column: 9,
									Line:   23,
								},
							},
						},
						Name: "check",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   24,
							},
							File:   "tickscript.flux",
							Source: "id=(r) => \"${r._check_id}\"",
							Start: ast.Position{
								Column: 9,
								Line:   24,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   24,
								},
								File:   "tickscript.flux",
								Source: "id",
								Start: ast.Position{
									Column: 9,
									Line:   24,
								},
							},
						},
						Name: "id",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   24,
								},
								File:   "tickscript.flux",
								Source: "(r) => \"${r._check_id}\"",
								Start: ast.Position{
									Column: 12,
									Line:   24,
								},
							},
						},
						Body: &ast.StringExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   24,
									},
									File:   "tickscript.flux",
									Source: "\"${r._check_id}\"",
									Start: ast.Position{
										Column: 19,
										Line:   24,
									},
								},
							},
							Parts: []ast.StringExpressionPart{&ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   24,
										},
										File:   "tickscript.flux",
										Source: "${r._check_id}",
										Start: ast.Position{
											Column: 20,
											Line:   24,
										},
									},
								},
								Expression: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   24,
											},
											File:   "tickscript.flux",
											Source: "r._check_id",
											Start: ast.Position{
												Column: 22,
												Line:   24,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   24,
												},
												File:   "tickscript.flux",
												Source: "r",
												Start: ast.Position{
													Column: 22,
													Line:   24,
												},
											},
										},
										Name: "r",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   24,
												},
												File:   "tickscript.flux",
												Source: "_check_id",
												Start: ast.Position{
													Column: 24,
													Line:   24,
												},
											},
										},
										Name: "_check_id",
									},
									Rbrack: nil,
								},
							}},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   24,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 13,
										Line:   24,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   24,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 13,
											Line:   24,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   25,
							},
							File:   "tickscript.flux",
							Source: "details=(r) => \"\"",
							Start: ast.Position{
								Column: 9,
								Line:   25,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   25,
								},
								File:   "tickscript.flux",
								Source: "details",
								Start: ast.Position{
									Column: 9,
									Line:   25,
								},
							},
						},
						Name: "details",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   25,
								},
								File:   "tickscript.flux",
								Source: "(r) => \"\"",
								Start: ast.Position{
									Column: 17,
									Line:   25,
								},
							},
						},
						Body: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   25,
									},
									File:   "tickscript.flux",
									Source: "\"\"",
									Start: ast.Position{
										Column: 24,
										Line:   25,
									},
								},
							},
							Value: "",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   25,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 18,
										Line:   25,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   25,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 18,
											Line:   25,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 75,
								Line:   26,
							},
							File:   "tickscript.flux",
							Source: "message=(r) => \"Threshold Check: ${r._check_name} is: ${r._level}\"",
							Start: ast.Position{
								Column: 9,
								Line:   26,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   26,
								},
								File:   "tickscript.flux",
								Source: "message",
								Start: ast.Position{
									Column: 9,
									Line:   26,
								},
							},
						},
						Name: "message",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   26,
								},
								File:   "tickscript.flux",
								Source: "(r) => \"Threshold Check: ${r._check_name} is: ${r._level}\"",
								Start: ast.Position{
									Column: 17,
									Line:   26,
								},
							},
						},
						Body: &ast.StringExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   26,
									},
									File:   "tickscript.flux",
									Source: "\"Threshold Check: ${r._check_name} is: ${r._level}\"",
									Start: ast.Position{
										Column: 24,
										Line:   26,
									},
								},
							},
							Parts: []ast.StringExpressionPart{&ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   26,
										},
										File:   "tickscript.flux",
										Source: "Threshold Check: ",
										Start: ast.Position{
											Column: 25,
											Line:   26,
										},
									},
								},
								Value: "Threshold Check: ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   26,
										},
										File:   "tickscript.flux",
										Source: "${r._check_name}",
										Start: ast.Position{
											Column: 42,
											Line:   26,
										},
									},
								},
								Expression: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   26,
											},
											File:   "tickscript.flux",
											Source: "r._check_name",
											Start: ast.Position{
												Column: 44,
												Line:   26,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   26,
												},
												File:   "tickscript.flux",
												Source: "r",
												Start: ast.Position{
													Column: 44,
													Line:   26,
												},
											},
										},
										Name: "r",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   26,
												},
												File:   "tickscript.flux",
												Source: "_check_name",
												Start: ast.Position{
													Column: 46,
													Line:   26,
												},
											},
										},
										Name: "_check_name",
									},
									Rbrack: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   26,
										},
										File:   "tickscript.flux",
										Source: " is: ",
										Start: ast.Position{
											Column: 58,
											Line:   26,
										},
									},
								},
								Value: " is: ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   26,
										},
										File:   "tickscript.flux",
										Source: "${r._level}",
										Start: ast.Position{
											Column: 63,
											Line:   26,
										},
									},
								},
								Expression: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   26,
											},
											File:   "tickscript.flux",
											Source: "r._level",
											Start: ast.Position{
												Column: 65,
												Line:   26,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   26,
												},
												File:   "tickscript.flux",
												Source: "r",
												Start: ast.Position{
													Column: 65,
													Line:   26,
												},
											},
										},
										Name: "r",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 73,
													Line:   26,
												},
												File:   "tickscript.flux",
												Source: "_level",
												Start: ast.Position{
													Column: 67,
													Line:   26,
												},
											},
										},
										Name: "_level",
									},
									Rbrack: nil,
								},
							}},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   26,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 18,
										Line:   26,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   26,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 18,
											Line:   26,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   27,
							},
							File:   "tickscript.flux",
							Source: "crit=(r) => false",
							Start: ast.Position{
								Column: 9,
								Line:   27,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   27,
								},
								File:   "tickscript.flux",
								Source: "crit",
								Start: ast.Position{
									Column: 9,
									Line:   27,
								},
							},
						},
						Name: "crit",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   27,
								},
								File:   "tickscript.flux",
								Source: "(r) => false",
								Start: ast.Position{
									Column: 14,
									Line:   27,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   27,
									},
									File:   "tickscript.flux",
									Source: "false",
									Start: ast.Position{
										Column: 21,
										Line:   27,
									},
								},
							},
							Name: "false",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   27,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 15,
										Line:   27,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   27,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 15,
											Line:   27,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   28,
							},
							File:   "tickscript.flux",
							Source: "warn=(r) => false",
							Start: ast.Position{
								Column: 9,
								Line:   28,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   28,
								},
								File:   "tickscript.flux",
								Source: "warn",
								Start: ast.Position{
									Column: 9,
									Line:   28,
								},
							},
						},
						Name: "warn",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   28,
								},
								File:   "tickscript.flux",
								Source: "(r) => false",
								Start: ast.Position{
									Column: 14,
									Line:   28,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   28,
									},
									File:   "tickscript.flux",
									Source: "false",
									Start: ast.Position{
										Column: 21,
										Line:   28,
									},
								},
							},
							Name: "false",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   28,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 15,
										Line:   28,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   28,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 15,
											Line:   28,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   29,
							},
							File:   "tickscript.flux",
							Source: "info=(r) => false",
							Start: ast.Position{
								Column: 9,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   29,
								},
								File:   "tickscript.flux",
								Source: "info",
								Start: ast.Position{
									Column: 9,
									Line:   29,
								},
							},
						},
						Name: "info",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   29,
								},
								File:   "tickscript.flux",
								Source: "(r) => false",
								Start: ast.Position{
									Column: 14,
									Line:   29,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   29,
									},
									File:   "tickscript.flux",
									Source: "false",
									Start: ast.Position{
										Column: 21,
										Line:   29,
									},
								},
							},
							Name: "false",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   29,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 15,
										Line:   29,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   29,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 15,
											Line:   29,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   30,
							},
							File:   "tickscript.flux",
							Source: "ok=(r) => true",
							Start: ast.Position{
								Column: 9,
								Line:   30,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   30,
								},
								File:   "tickscript.flux",
								Source: "ok",
								Start: ast.Position{
									Column: 9,
									Line:   30,
								},
							},
						},
						Name: "ok",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   30,
								},
								File:   "tickscript.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 12,
									Line:   30,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   30,
									},
									File:   "tickscript.flux",
									Source: "true",
									Start: ast.Position{
										Column: 19,
										Line:   30,
									},
								},
							},
							Name: "true",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   30,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 13,
										Line:   30,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   30,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 13,
											Line:   30,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   31,
							},
							File:   "tickscript.flux",
							Source: "topic=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   31,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   31,
								},
								File:   "tickscript.flux",
								Source: "topic",
								Start: ast.Position{
									Column: 9,
									Line:   31,
								},
							},
						},
						Name: "topic",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   31,
								},
								File:   "tickscript.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 15,
									Line:   31,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   32,
							},
							File:   "tickscript.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 9,
								Line:   32,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   32,
								},
								File:   "tickscript.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 9,
									Line:   32,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   32,
							},
							File:   "tickscript.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   32,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   114,
					},
					File:   "tickscript.flux",
					Source: "deadman = (\n        check,\n        measurement,\n        threshold=0,\n        id=(r) => \"${r._check_id}\",\n        message=(r) => \"Deadman Check: ${r._check_name} is: \" + (if r.dead then \"dead\" else \"alive\"),\n        topic=\"\",\n        tables=<-,\n) => {\n    // In order to detect empty stream (without tables), we concatenate input with dummy stream and count the result,\n    // because count() returns nothing for empty stream. If the input stream is empty, then dummy stream with empty\n    // table is used as input for actual threshold check in order to get 0.\n    _dummy = array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n        |> set(key: \"_measurement\", value: measurement)\n        // required by monitor.check\n        |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")\n        // input tables are expected to be pivoted already    \n        |> schema.fieldsAsCols()\n    _counts = union(tables: [_dummy, tables])\n        |> keep(columns: [\"_measurement\", \"_time\"])\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")\n        |> findColumn(fn: (key) => key._measurement == measurement, column: \"__value__\")\n    _tables = \n        // only dummy table is in the concatenated stream\n        if _counts[0] == 1 then\n            _dummy\n                |> drop(columns: [\"unknown\"])\n                // need empty table\n                |> limit(n: 0)\n        else\n            tables\n\n    return _tables\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")\n        // recreate _time column after aggregation\n        |> map(fn: (r) => ({r with _time: now()}))\n        // same tag that monitor.deadman() adds\n        |> map(fn: (r) => ({r with dead: r.__value__ <= threshold}))\n        // drop dummy field\n        |> drop(columns: [\"__value__\"])\n        |> alert(\n            check: check,\n            id: id,\n            message: message,\n            crit: (r) => r.dead,\n            topic: topic,\n        )\n}",
					Start: ast.Position{
						Column: 1,
						Line:   63,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// deadman is a helper function similar to TICKscript deadman.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   63,
						},
						File:   "tickscript.flux",
						Source: "deadman",
						Start: ast.Position{
							Column: 1,
							Line:   63,
						},
					},
				},
				Name: "deadman",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   114,
						},
						File:   "tickscript.flux",
						Source: "(\n        check,\n        measurement,\n        threshold=0,\n        id=(r) => \"${r._check_id}\",\n        message=(r) => \"Deadman Check: ${r._check_name} is: \" + (if r.dead then \"dead\" else \"alive\"),\n        topic=\"\",\n        tables=<-,\n) => {\n    // In order to detect empty stream (without tables), we concatenate input with dummy stream and count the result,\n    // because count() returns nothing for empty stream. If the input stream is empty, then dummy stream with empty\n    // table is used as input for actual threshold check in order to get 0.\n    _dummy = array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n        |> set(key: \"_measurement\", value: measurement)\n        // required by monitor.check\n        |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")\n        // input tables are expected to be pivoted already    \n        |> schema.fieldsAsCols()\n    _counts = union(tables: [_dummy, tables])\n        |> keep(columns: [\"_measurement\", \"_time\"])\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")\n        |> findColumn(fn: (key) => key._measurement == measurement, column: \"__value__\")\n    _tables = \n        // only dummy table is in the concatenated stream\n        if _counts[0] == 1 then\n            _dummy\n                |> drop(columns: [\"unknown\"])\n                // need empty table\n                |> limit(n: 0)\n        else\n            tables\n\n    return _tables\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")\n        // recreate _time column after aggregation\n        |> map(fn: (r) => ({r with _time: now()}))\n        // same tag that monitor.deadman() adds\n        |> map(fn: (r) => ({r with dead: r.__value__ <= threshold}))\n        // drop dummy field\n        |> drop(columns: [\"__value__\"])\n        |> alert(\n            check: check,\n            id: id,\n            message: message,\n            crit: (r) => r.dead,\n            topic: topic,\n        )\n}",
						Start: ast.Position{
							Column: 11,
							Line:   63,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   114,
							},
							File:   "tickscript.flux",
							Source: "{\n    // In order to detect empty stream (without tables), we concatenate input with dummy stream and count the result,\n    // because count() returns nothing for empty stream. If the input stream is empty, then dummy stream with empty\n    // table is used as input for actual threshold check in order to get 0.\n    _dummy = array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n        |> set(key: \"_measurement\", value: measurement)\n        // required by monitor.check\n        |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")\n        // input tables are expected to be pivoted already    \n        |> schema.fieldsAsCols()\n    _counts = union(tables: [_dummy, tables])\n        |> keep(columns: [\"_measurement\", \"_time\"])\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")\n        |> findColumn(fn: (key) => key._measurement == measurement, column: \"__value__\")\n    _tables = \n        // only dummy table is in the concatenated stream\n        if _counts[0] == 1 then\n            _dummy\n                |> drop(columns: [\"unknown\"])\n                // need empty table\n                |> limit(n: 0)\n        else\n            tables\n\n    return _tables\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")\n        // recreate _time column after aggregation\n        |> map(fn: (r) => ({r with _time: now()}))\n        // same tag that monitor.deadman() adds\n        |> map(fn: (r) => ({r with dead: r.__value__ <= threshold}))\n        // drop dummy field\n        |> drop(columns: [\"__value__\"])\n        |> alert(\n            check: check,\n            id: id,\n            message: message,\n            crit: (r) => r.dead,\n            topic: topic,\n        )\n}",
							Start: ast.Position{
								Column: 6,
								Line:   71,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   80,
								},
								File:   "tickscript.flux",
								Source: "_dummy = array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n        |> set(key: \"_measurement\", value: measurement)\n        // required by monitor.check\n        |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")\n        // input tables are expected to be pivoted already    \n        |> schema.fieldsAsCols()",
								Start: ast.Position{
									Column: 5,
									Line:   75,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// In order to detect empty stream (without tables), we concatenate input with dummy stream and count the result,\n"}, ast.Comment{Text: "// because count() returns nothing for empty stream. If the input stream is empty, then dummy stream with empty\n"}, ast.Comment{Text: "// table is used as input for actual threshold check in order to get 0.\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   75,
									},
									File:   "tickscript.flux",
									Source: "_dummy",
									Start: ast.Position{
										Column: 5,
										Line:   75,
									},
								},
							},
							Name: "_dummy",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 92,
														Line:   75,
													},
													File:   "tickscript.flux",
													Source: "rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}]",
													Start: ast.Position{
														Column: 25,
														Line:   75,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 92,
															Line:   75,
														},
														File:   "tickscript.flux",
														Source: "rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}]",
														Start: ast.Position{
															Column: 25,
															Line:   75,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 29,
																Line:   75,
															},
															File:   "tickscript.flux",
															Source: "rows",
															Start: ast.Position{
																Column: 25,
																Line:   75,
															},
														},
													},
													Name: "rows",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 92,
																Line:   75,
															},
															File:   "tickscript.flux",
															Source: "[{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}]",
															Start: ast.Position{
																Column: 31,
																Line:   75,
															},
														},
													},
													Elements: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 91,
																	Line:   75,
																},
																File:   "tickscript.flux",
																Source: "{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}",
																Start: ast.Position{
																	Column: 32,
																	Line:   75,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   75,
																	},
																	File:   "tickscript.flux",
																	Source: "_time: 2000-01-01T00:00:00Z",
																	Start: ast.Position{
																		Column: 33,
																		Line:   75,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 38,
																			Line:   75,
																		},
																		File:   "tickscript.flux",
																		Source: "_time",
																		Start: ast.Position{
																			Column: 33,
																			Line:   75,
																		},
																	},
																},
																Name: "_time",
															},
															Separator: nil,
															Value: &ast.DateTimeLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 60,
																			Line:   75,
																		},
																		File:   "tickscript.flux",
																		Source: "2000-01-01T00:00:00Z",
																		Start: ast.Position{
																			Column: 40,
																			Line:   75,
																		},
																	},
																},
																Value: parser.MustParseTime("2000-01-01T00:00:00Z"),
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 79,
																		Line:   75,
																	},
																	File:   "tickscript.flux",
																	Source: "_field: \"unknown\"",
																	Start: ast.Position{
																		Column: 62,
																		Line:   75,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 68,
																			Line:   75,
																		},
																		File:   "tickscript.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 62,
																			Line:   75,
																		},
																	},
																},
																Name: "_field",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 79,
																			Line:   75,
																		},
																		File:   "tickscript.flux",
																		Source: "\"unknown\"",
																		Start: ast.Position{
																			Column: 70,
																			Line:   75,
																		},
																	},
																},
																Value: "unknown",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 90,
																		Line:   75,
																	},
																	File:   "tickscript.flux",
																	Source: "_value: 0",
																	Start: ast.Position{
																		Column: 81,
																		Line:   75,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 87,
																			Line:   75,
																		},
																		File:   "tickscript.flux",
																		Source: "_value",
																		Start: ast.Position{
																			Column: 81,
																			Line:   75,
																		},
																	},
																},
																Name: "_value",
															},
															Separator: nil,
															Value: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 90,
																			Line:   75,
																		},
																		File:   "tickscript.flux",
																		Source: "0",
																		Start: ast.Position{
																			Column: 89,
																			Line:   75,
																		},
																	},
																},
																Value: int64(0),
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 93,
													Line:   75,
												},
												File:   "tickscript.flux",
												Source: "array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])",
												Start: ast.Position{
													Column: 14,
													Line:   75,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   75,
													},
													File:   "tickscript.flux",
													Source: "array.from",
													Start: ast.Position{
														Column: 14,
														Line:   75,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   75,
														},
														File:   "tickscript.flux",
														Source: "array",
														Start: ast.Position{
															Column: 14,
															Line:   75,
														},
													},
												},
												Name: "array",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   75,
														},
														File:   "tickscript.flux",
														Source: "from",
														Start: ast.Position{
															Column: 20,
															Line:   75,
														},
													},
												},
												Name: "from",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   76,
											},
											File:   "tickscript.flux",
											Source: "array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n        |> set(key: \"_measurement\", value: measurement)",
											Start: ast.Position{
												Column: 14,
												Line:   75,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   76,
													},
													File:   "tickscript.flux",
													Source: "key: \"_measurement\", value: measurement",
													Start: ast.Position{
														Column: 16,
														Line:   76,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   76,
														},
														File:   "tickscript.flux",
														Source: "key: \"_measurement\"",
														Start: ast.Position{
															Column: 16,
															Line:   76,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 19,
																Line:   76,
															},
															File:   "tickscript.flux",
															Source: "key",
															Start: ast.Position{
																Column: 16,
																Line:   76,
															},
														},
													},
													Name: "key",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   76,
															},
															File:   "tickscript.flux",
															Source: "\"_measurement\"",
															Start: ast.Position{
																Column: 21,
																Line:   76,
															},
														},
													},
													Value: "_measurement",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   76,
														},
														File:   "tickscript.flux",
														Source: "value: measurement",
														Start: ast.Position{
															Column: 37,
															Line:   76,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   76,
															},
															File:   "tickscript.flux",
															Source: "value",
															Start: ast.Position{
																Column: 37,
																Line:   76,
															},
														},
													},
													Name: "value",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 55,
																Line:   76,
															},
															File:   "tickscript.flux",
															Source: "measurement",
															Start: ast.Position{
																Column: 44,
																Line:   76,
															},
														},
													},
													Name: "measurement",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   76,
												},
												File:   "tickscript.flux",
												Source: "set(key: \"_measurement\", value: measurement)",
												Start: ast.Position{
													Column: 12,
													Line:   76,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   76,
													},
													File:   "tickscript.flux",
													Source: "set",
													Start: ast.Position{
														Column: 12,
														Line:   76,
													},
												},
											},
											Name: "set",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: []ast.Comment{ast.Comment{Text: "// required by monitor.check\n"}},
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   78,
										},
										File:   "tickscript.flux",
										Source: "array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n        |> set(key: \"_measurement\", value: measurement)\n        // required by monitor.check\n        |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
										Start: ast.Position{
											Column: 14,
											Line:   75,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 72,
													Line:   78,
												},
												File:   "tickscript.flux",
												Source: "columns: [\"_measurement\"], mode: \"extend\"",
												Start: ast.Position{
													Column: 31,
													Line:   78,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   78,
													},
													File:   "tickscript.flux",
													Source: "columns: [\"_measurement\"]",
													Start: ast.Position{
														Column: 31,
														Line:   78,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   78,
														},
														File:   "tickscript.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 31,
															Line:   78,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   78,
														},
														File:   "tickscript.flux",
														Source: "[\"_measurement\"]",
														Start: ast.Position{
															Column: 40,
															Line:   78,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 55,
																Line:   78,
															},
															File:   "tickscript.flux",
															Source: "\"_measurement\"",
															Start: ast.Position{
																Column: 41,
																Line:   78,
															},
														},
													},
													Value: "_measurement",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 72,
														Line:   78,
													},
													File:   "tickscript.flux",
													Source: "mode: \"extend\"",
													Start: ast.Position{
														Column: 58,
														Line:   78,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   78,
														},
														File:   "tickscript.flux",
														Source: "mode",
														Start: ast.Position{
															Column: 58,
															Line:   78,
														},
													},
												},
												Name: "mode",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   78,
														},
														File:   "tickscript.flux",
														Source: "\"extend\"",
														Start: ast.Position{
															Column: 64,
															Line:   78,
														},
													},
												},
												Value: "extend",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   78,
											},
											File:   "tickscript.flux",
											Source: "experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
											Start: ast.Position{
												Column: 12,
												Line:   78,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   78,
												},
												File:   "tickscript.flux",
												Source: "experimental.group",
												Start: ast.Position{
													Column: 12,
													Line:   78,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   78,
													},
													File:   "tickscript.flux",
													Source: "experimental",
													Start: ast.Position{
														Column: 12,
														Line:   78,
													},
												},
											},
											Name: "experimental",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   78,
													},
													File:   "tickscript.flux",
													Source: "group",
													Start: ast.Position{
														Column: 25,
														Line:   78,
													},
												},
											},
											Name: "group",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// input tables are expected to be pivoted already    \n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   80,
									},
									File:   "tickscript.flux",
									Source: "array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n        |> set(key: \"_measurement\", value: measurement)\n        // required by monitor.check\n        |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")\n        // input tables are expected to be pivoted already    \n        |> schema.fieldsAsCols()",
									Start: ast.Position{
										Column: 14,
										Line:   75,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   80,
										},
										File:   "tickscript.flux",
										Source: "schema.fieldsAsCols()",
										Start: ast.Position{
											Column: 12,
											Line:   80,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   80,
											},
											File:   "tickscript.flux",
											Source: "schema.fieldsAsCols",
											Start: ast.Position{
												Column: 12,
												Line:   80,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   80,
												},
												File:   "tickscript.flux",
												Source: "schema",
												Start: ast.Position{
													Column: 12,
													Line:   80,
												},
											},
										},
										Name: "schema",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   80,
												},
												File:   "tickscript.flux",
												Source: "fieldsAsCols",
												Start: ast.Position{
													Column: 19,
													Line:   80,
												},
											},
										},
										Name: "fieldsAsCols",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   86,
								},
								File:   "tickscript.flux",
								Source: "_counts = union(tables: [_dummy, tables])\n        |> keep(columns: [\"_measurement\", \"_time\"])\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")\n        |> findColumn(fn: (key) => key._measurement == measurement, column: \"__value__\")",
								Start: ast.Position{
									Column: 5,
									Line:   81,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   81,
									},
									File:   "tickscript.flux",
									Source: "_counts",
									Start: ast.Position{
										Column: 5,
										Line:   81,
									},
								},
							},
							Name: "_counts",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   81,
														},
														File:   "tickscript.flux",
														Source: "tables: [_dummy, tables]",
														Start: ast.Position{
															Column: 21,
															Line:   81,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   81,
															},
															File:   "tickscript.flux",
															Source: "tables: [_dummy, tables]",
															Start: ast.Position{
																Column: 21,
																Line:   81,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   81,
																},
																File:   "tickscript.flux",
																Source: "tables",
																Start: ast.Position{
																	Column: 21,
																	Line:   81,
																},
															},
														},
														Name: "tables",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   81,
																},
																File:   "tickscript.flux",
																Source: "[_dummy, tables]",
																Start: ast.Position{
																	Column: 29,
																	Line:   81,
																},
															},
														},
														Elements: []ast.Expression{&ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   81,
																	},
																	File:   "tickscript.flux",
																	Source: "_dummy",
																	Start: ast.Position{
																		Column: 30,
																		Line:   81,
																	},
																},
															},
															Name: "_dummy",
														}, &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   81,
																	},
																	File:   "tickscript.flux",
																	Source: "tables",
																	Start: ast.Position{
																		Column: 38,
																		Line:   81,
																	},
																},
															},
															Name: "tables",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   81,
													},
													File:   "tickscript.flux",
													Source: "union(tables: [_dummy, tables])",
													Start: ast.Position{
														Column: 15,
														Line:   81,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   81,
														},
														File:   "tickscript.flux",
														Source: "union",
														Start: ast.Position{
															Column: 15,
															Line:   81,
														},
													},
												},
												Name: "union",
											},
											Lparen: nil,
											Rparen: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   82,
												},
												File:   "tickscript.flux",
												Source: "union(tables: [_dummy, tables])\n        |> keep(columns: [\"_measurement\", \"_time\"])",
												Start: ast.Position{
													Column: 15,
													Line:   81,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 51,
															Line:   82,
														},
														File:   "tickscript.flux",
														Source: "columns: [\"_measurement\", \"_time\"]",
														Start: ast.Position{
															Column: 17,
															Line:   82,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 51,
																Line:   82,
															},
															File:   "tickscript.flux",
															Source: "columns: [\"_measurement\", \"_time\"]",
															Start: ast.Position{
																Column: 17,
																Line:   82,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 24,
																	Line:   82,
																},
																File:   "tickscript.flux",
																Source: "columns",
																Start: ast.Position{
																	Column: 17,
																	Line:   82,
																},
															},
														},
														Name: "columns",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   82,
																},
																File:   "tickscript.flux",
																Source: "[\"_measurement\", \"_time\"]",
																Start: ast.Position{
																	Column: 26,
																	Line:   82,
																},
															},
														},
														Elements: []ast.Expression{&ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   82,
																	},
																	File:   "tickscript.flux",
																	Source: "\"_measurement\"",
																	Start: ast.Position{
																		Column: 27,
																		Line:   82,
																	},
																},
															},
															Value: "_measurement",
														}, &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 50,
																		Line:   82,
																	},
																	File:   "tickscript.flux",
																	Source: "\"_time\"",
																	Start: ast.Position{
																		Column: 43,
																		Line:   82,
																	},
																},
															},
															Value: "_time",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   82,
													},
													File:   "tickscript.flux",
													Source: "keep(columns: [\"_measurement\", \"_time\"])",
													Start: ast.Position{
														Column: 12,
														Line:   82,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   82,
														},
														File:   "tickscript.flux",
														Source: "keep",
														Start: ast.Position{
															Column: 12,
															Line:   82,
														},
													},
												},
												Name: "keep",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: []ast.Comment{ast.Comment{Text: "// _measurement column is always present\n"}},
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 62,
												Line:   84,
											},
											File:   "tickscript.flux",
											Source: "union(tables: [_dummy, tables])\n        |> keep(columns: [\"_measurement\", \"_time\"])\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")",
											Start: ast.Position{
												Column: 15,
												Line:   81,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   84,
													},
													File:   "tickscript.flux",
													Source: "column: \"_measurement\", as: \"__value__\"",
													Start: ast.Position{
														Column: 22,
														Line:   84,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   84,
														},
														File:   "tickscript.flux",
														Source: "column: \"_measurement\"",
														Start: ast.Position{
															Column: 22,
															Line:   84,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   84,
															},
															File:   "tickscript.flux",
															Source: "column",
															Start: ast.Position{
																Column: 22,
																Line:   84,
															},
														},
													},
													Name: "column",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   84,
															},
															File:   "tickscript.flux",
															Source: "\"_measurement\"",
															Start: ast.Position{
																Column: 30,
																Line:   84,
															},
														},
													},
													Value: "_measurement",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   84,
														},
														File:   "tickscript.flux",
														Source: "as: \"__value__\"",
														Start: ast.Position{
															Column: 46,
															Line:   84,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   84,
															},
															File:   "tickscript.flux",
															Source: "as",
															Start: ast.Position{
																Column: 46,
																Line:   84,
															},
														},
													},
													Name: "as",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   84,
															},
															File:   "tickscript.flux",
															Source: "\"__value__\"",
															Start: ast.Position{
																Column: 50,
																Line:   84,
															},
														},
													},
													Value: "__value__",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 62,
													Line:   84,
												},
												File:   "tickscript.flux",
												Source: "duplicate(column: \"_measurement\", as: \"__value__\")",
												Start: ast.Position{
													Column: 12,
													Line:   84,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   84,
													},
													File:   "tickscript.flux",
													Source: "duplicate",
													Start: ast.Position{
														Column: 12,
														Line:   84,
													},
												},
											},
											Name: "duplicate",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   85,
										},
										File:   "tickscript.flux",
										Source: "union(tables: [_dummy, tables])\n        |> keep(columns: [\"_measurement\", \"_time\"])\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")",
										Start: ast.Position{
											Column: 15,
											Line:   81,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   85,
												},
												File:   "tickscript.flux",
												Source: "column: \"__value__\"",
												Start: ast.Position{
													Column: 18,
													Line:   85,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   85,
													},
													File:   "tickscript.flux",
													Source: "column: \"__value__\"",
													Start: ast.Position{
														Column: 18,
														Line:   85,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   85,
														},
														File:   "tickscript.flux",
														Source: "column",
														Start: ast.Position{
															Column: 18,
															Line:   85,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   85,
														},
														File:   "tickscript.flux",
														Source: "\"__value__\"",
														Start: ast.Position{
															Column: 26,
															Line:   85,
														},
													},
												},
												Value: "__value__",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   85,
											},
											File:   "tickscript.flux",
											Source: "count(column: \"__value__\")",
											Start: ast.Position{
												Column: 12,
												Line:   85,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   85,
												},
												File:   "tickscript.flux",
												Source: "count",
												Start: ast.Position{
													Column: 12,
													Line:   85,
												},
											},
										},
										Name: "count",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 89,
										Line:   86,
									},
									File:   "tickscript.flux",
									Source: "union(tables: [_dummy, tables])\n        |> keep(columns: [\"_measurement\", \"_time\"])\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")\n        |> findColumn(fn: (key) => key._measurement == measurement, column: \"__value__\")",
									Start: ast.Position{
										Column: 15,
										Line:   81,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   86,
											},
											File:   "tickscript.flux",
											Source: "fn: (key) => key._measurement == measurement, column: \"__value__\"",
											Start: ast.Position{
												Column: 23,
												Line:   86,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   86,
												},
												File:   "tickscript.flux",
												Source: "fn: (key) => key._measurement == measurement",
												Start: ast.Position{
													Column: 23,
													Line:   86,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   86,
													},
													File:   "tickscript.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 23,
														Line:   86,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   86,
													},
													File:   "tickscript.flux",
													Source: "(key) => key._measurement == measurement",
													Start: ast.Position{
														Column: 27,
														Line:   86,
													},
												},
											},
											Body: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   86,
														},
														File:   "tickscript.flux",
														Source: "key._measurement == measurement",
														Start: ast.Position{
															Column: 36,
															Line:   86,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 52,
																Line:   86,
															},
															File:   "tickscript.flux",
															Source: "key._measurement",
															Start: ast.Position{
																Column: 36,
																Line:   86,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 39,
																	Line:   86,
																},
																File:   "tickscript.flux",
																Source: "key",
																Start: ast.Position{
																	Column: 36,
																	Line:   86,
																},
															},
														},
														Name: "key",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 52,
																	Line:   86,
																},
																File:   "tickscript.flux",
																Source: "_measurement",
																Start: ast.Position{
																	Column: 40,
																	Line:   86,
																},
															},
														},
														Name: "_measurement",
													},
													Rbrack: nil,
												},
												Operator: 17,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 67,
																Line:   86,
															},
															File:   "tickscript.flux",
															Source: "measurement",
															Start: ast.Position{
																Column: 56,
																Line:   86,
															},
														},
													},
													Name: "measurement",
												},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   86,
														},
														File:   "tickscript.flux",
														Source: "key",
														Start: ast.Position{
															Column: 28,
															Line:   86,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   86,
															},
															File:   "tickscript.flux",
															Source: "key",
															Start: ast.Position{
																Column: 28,
																Line:   86,
															},
														},
													},
													Name: "key",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 88,
													Line:   86,
												},
												File:   "tickscript.flux",
												Source: "column: \"__value__\"",
												Start: ast.Position{
													Column: 69,
													Line:   86,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 75,
														Line:   86,
													},
													File:   "tickscript.flux",
													Source: "column",
													Start: ast.Position{
														Column: 69,
														Line:   86,
													},
												},
											},
											Name: "column",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   86,
													},
													File:   "tickscript.flux",
													Source: "\"__value__\"",
													Start: ast.Position{
														Column: 77,
														Line:   86,
													},
												},
											},
											Value: "__value__",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 89,
											Line:   86,
										},
										File:   "tickscript.flux",
										Source: "findColumn(fn: (key) => key._measurement == measurement, column: \"__value__\")",
										Start: ast.Position{
											Column: 12,
											Line:   86,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   86,
											},
											File:   "tickscript.flux",
											Source: "findColumn",
											Start: ast.Position{
												Column: 12,
												Line:   86,
											},
										},
									},
									Name: "findColumn",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   95,
								},
								File:   "tickscript.flux",
								Source: "_tables = \n        // only dummy table is in the concatenated stream\n        if _counts[0] == 1 then\n            _dummy\n                |> drop(columns: [\"unknown\"])\n                // need empty table\n                |> limit(n: 0)\n        else\n            tables",
								Start: ast.Position{
									Column: 5,
									Line:   87,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   87,
									},
									File:   "tickscript.flux",
									Source: "_tables",
									Start: ast.Position{
										Column: 5,
										Line:   87,
									},
								},
							},
							Name: "_tables",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   95,
										},
										File:   "tickscript.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 13,
											Line:   95,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   95,
									},
									File:   "tickscript.flux",
									Source: "if _counts[0] == 1 then\n            _dummy\n                |> drop(columns: [\"unknown\"])\n                // need empty table\n                |> limit(n: 0)\n        else\n            tables",
									Start: ast.Position{
										Column: 9,
										Line:   89,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   90,
												},
												File:   "tickscript.flux",
												Source: "_dummy",
												Start: ast.Position{
													Column: 13,
													Line:   90,
												},
											},
										},
										Name: "_dummy",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   91,
											},
											File:   "tickscript.flux",
											Source: "_dummy\n                |> drop(columns: [\"unknown\"])",
											Start: ast.Position{
												Column: 13,
												Line:   90,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   91,
													},
													File:   "tickscript.flux",
													Source: "columns: [\"unknown\"]",
													Start: ast.Position{
														Column: 25,
														Line:   91,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   91,
														},
														File:   "tickscript.flux",
														Source: "columns: [\"unknown\"]",
														Start: ast.Position{
															Column: 25,
															Line:   91,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   91,
															},
															File:   "tickscript.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 25,
																Line:   91,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   91,
															},
															File:   "tickscript.flux",
															Source: "[\"unknown\"]",
															Start: ast.Position{
																Column: 34,
																Line:   91,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   91,
																},
																File:   "tickscript.flux",
																Source: "\"unknown\"",
																Start: ast.Position{
																	Column: 35,
																	Line:   91,
																},
															},
														},
														Value: "unknown",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   91,
												},
												File:   "tickscript.flux",
												Source: "drop(columns: [\"unknown\"])",
												Start: ast.Position{
													Column: 20,
													Line:   91,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   91,
													},
													File:   "tickscript.flux",
													Source: "drop",
													Start: ast.Position{
														Column: 20,
														Line:   91,
													},
												},
											},
											Name: "drop",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: []ast.Comment{ast.Comment{Text: "// need empty table\n"}},
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   93,
										},
										File:   "tickscript.flux",
										Source: "_dummy\n                |> drop(columns: [\"unknown\"])\n                // need empty table\n                |> limit(n: 0)",
										Start: ast.Position{
											Column: 13,
											Line:   90,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   93,
												},
												File:   "tickscript.flux",
												Source: "n: 0",
												Start: ast.Position{
													Column: 26,
													Line:   93,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   93,
													},
													File:   "tickscript.flux",
													Source: "n: 0",
													Start: ast.Position{
														Column: 26,
														Line:   93,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   93,
														},
														File:   "tickscript.flux",
														Source: "n",
														Start: ast.Position{
															Column: 26,
															Line:   93,
														},
													},
												},
												Name: "n",
											},
											Separator: nil,
											Value: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   93,
														},
														File:   "tickscript.flux",
														Source: "0",
														Start: ast.Position{
															Column: 29,
															Line:   93,
														},
													},
												},
												Value: int64(0),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   93,
											},
											File:   "tickscript.flux",
											Source: "limit(n: 0)",
											Start: ast.Position{
												Column: 20,
												Line:   93,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   93,
												},
												File:   "tickscript.flux",
												Source: "limit",
												Start: ast.Position{
													Column: 20,
													Line:   93,
												},
											},
										},
										Name: "limit",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   89,
										},
										File:   "tickscript.flux",
										Source: "_counts[0] == 1",
										Start: ast.Position{
											Column: 12,
											Line:   89,
										},
									},
								},
								Left: &ast.IndexExpression{
									Array: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   89,
												},
												File:   "tickscript.flux",
												Source: "_counts",
												Start: ast.Position{
													Column: 12,
													Line:   89,
												},
											},
										},
										Name: "_counts",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   89,
											},
											File:   "tickscript.flux",
											Source: "_counts[0]",
											Start: ast.Position{
												Column: 12,
												Line:   89,
											},
										},
									},
									Index: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   89,
												},
												File:   "tickscript.flux",
												Source: "0",
												Start: ast.Position{
													Column: 20,
													Line:   89,
												},
											},
										},
										Value: int64(0),
									},
									Lbrack: nil,
									Rbrack: nil,
								},
								Operator: 17,
								Right: &ast.IntegerLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   89,
											},
											File:   "tickscript.flux",
											Source: "1",
											Start: ast.Position{
												Column: 26,
												Line:   89,
											},
										},
									},
									Value: int64(1),
								},
							},
							Tk_else: nil,
							Tk_if:   []ast.Comment{ast.Comment{Text: "// only dummy table is in the concatenated stream\n"}},
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.PipeExpression{
												Argument: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 19,
																Line:   97,
															},
															File:   "tickscript.flux",
															Source: "_tables",
															Start: ast.Position{
																Column: 12,
																Line:   97,
															},
														},
													},
													Name: "_tables",
												},
												BaseNode: ast.BaseNode{
													Comments: []ast.Comment{ast.Comment{Text: "// _measurement column is always present\n"}},
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   99,
														},
														File:   "tickscript.flux",
														Source: "_tables\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")",
														Start: ast.Position{
															Column: 12,
															Line:   97,
														},
													},
												},
												Call: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 61,
																	Line:   99,
																},
																File:   "tickscript.flux",
																Source: "column: \"_measurement\", as: \"__value__\"",
																Start: ast.Position{
																	Column: 22,
																	Line:   99,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   99,
																	},
																	File:   "tickscript.flux",
																	Source: "column: \"_measurement\"",
																	Start: ast.Position{
																		Column: 22,
																		Line:   99,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 28,
																			Line:   99,
																		},
																		File:   "tickscript.flux",
																		Source: "column",
																		Start: ast.Position{
																			Column: 22,
																			Line:   99,
																		},
																	},
																},
																Name: "column",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   99,
																		},
																		File:   "tickscript.flux",
																		Source: "\"_measurement\"",
																		Start: ast.Position{
																			Column: 30,
																			Line:   99,
																		},
																	},
																},
																Value: "_measurement",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 61,
																		Line:   99,
																	},
																	File:   "tickscript.flux",
																	Source: "as: \"__value__\"",
																	Start: ast.Position{
																		Column: 46,
																		Line:   99,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   99,
																		},
																		File:   "tickscript.flux",
																		Source: "as",
																		Start: ast.Position{
																			Column: 46,
																			Line:   99,
																		},
																	},
																},
																Name: "as",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 61,
																			Line:   99,
																		},
																		File:   "tickscript.flux",
																		Source: "\"__value__\"",
																		Start: ast.Position{
																			Column: 50,
																			Line:   99,
																		},
																	},
																},
																Value: "__value__",
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 62,
																Line:   99,
															},
															File:   "tickscript.flux",
															Source: "duplicate(column: \"_measurement\", as: \"__value__\")",
															Start: ast.Position{
																Column: 12,
																Line:   99,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 21,
																	Line:   99,
																},
																File:   "tickscript.flux",
																Source: "duplicate",
																Start: ast.Position{
																	Column: 12,
																	Line:   99,
																},
															},
														},
														Name: "duplicate",
													},
													Lparen: nil,
													Rparen: nil,
												},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   100,
													},
													File:   "tickscript.flux",
													Source: "_tables\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")",
													Start: ast.Position{
														Column: 12,
														Line:   97,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   100,
															},
															File:   "tickscript.flux",
															Source: "column: \"__value__\"",
															Start: ast.Position{
																Column: 18,
																Line:   100,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   100,
																},
																File:   "tickscript.flux",
																Source: "column: \"__value__\"",
																Start: ast.Position{
																	Column: 18,
																	Line:   100,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   100,
																	},
																	File:   "tickscript.flux",
																	Source: "column",
																	Start: ast.Position{
																		Column: 18,
																		Line:   100,
																	},
																},
															},
															Name: "column",
														},
														Separator: nil,
														Value: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   100,
																	},
																	File:   "tickscript.flux",
																	Source: "\"__value__\"",
																	Start: ast.Position{
																		Column: 26,
																		Line:   100,
																	},
																},
															},
															Value: "__value__",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   100,
														},
														File:   "tickscript.flux",
														Source: "count(column: \"__value__\")",
														Start: ast.Position{
															Column: 12,
															Line:   100,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 17,
																Line:   100,
															},
															File:   "tickscript.flux",
															Source: "count",
															Start: ast.Position{
																Column: 12,
																Line:   100,
															},
														},
													},
													Name: "count",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: []ast.Comment{ast.Comment{Text: "// recreate _time column after aggregation\n"}},
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   102,
												},
												File:   "tickscript.flux",
												Source: "_tables\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")\n        // recreate _time column after aggregation\n        |> map(fn: (r) => ({r with _time: now()}))",
												Start: ast.Position{
													Column: 12,
													Line:   97,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   102,
														},
														File:   "tickscript.flux",
														Source: "fn: (r) => ({r with _time: now()})",
														Start: ast.Position{
															Column: 16,
															Line:   102,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   102,
															},
															File:   "tickscript.flux",
															Source: "fn: (r) => ({r with _time: now()})",
															Start: ast.Position{
																Column: 16,
																Line:   102,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   102,
																},
																File:   "tickscript.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 16,
																	Line:   102,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.FunctionExpression{
														Arrow: nil,
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   102,
																},
																File:   "tickscript.flux",
																Source: "(r) => ({r with _time: now()})",
																Start: ast.Position{
																	Column: 20,
																	Line:   102,
																},
															},
														},
														Body: &ast.ParenExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 50,
																		Line:   102,
																	},
																	File:   "tickscript.flux",
																	Source: "({r with _time: now()})",
																	Start: ast.Position{
																		Column: 27,
																		Line:   102,
																	},
																},
															},
															Expression: &ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   102,
																		},
																		File:   "tickscript.flux",
																		Source: "{r with _time: now()}",
																		Start: ast.Position{
																			Column: 28,
																			Line:   102,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   102,
																			},
																			File:   "tickscript.flux",
																			Source: "_time: now()",
																			Start: ast.Position{
																				Column: 36,
																				Line:   102,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 41,
																					Line:   102,
																				},
																				File:   "tickscript.flux",
																				Source: "_time",
																				Start: ast.Position{
																					Column: 36,
																					Line:   102,
																				},
																			},
																		},
																		Name: "_time",
																	},
																	Separator: nil,
																	Value: &ast.CallExpression{
																		Arguments: nil,
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 48,
																					Line:   102,
																				},
																				File:   "tickscript.flux",
																				Source: "now()",
																				Start: ast.Position{
																					Column: 43,
																					Line:   102,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 46,
																						Line:   102,
																					},
																					File:   "tickscript.flux",
																					Source: "now",
																					Start: ast.Position{
																						Column: 43,
																						Line:   102,
																					},
																				},
																			},
																			Name: "now",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																}},
																Rbrace: nil,
																With: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   102,
																			},
																			File:   "tickscript.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 29,
																				Line:   102,
																			},
																		},
																	},
																	Name: "r",
																},
															},
															Lparen: nil,
															Rparen: nil,
														},
														Lparen: nil,
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   102,
																	},
																	File:   "tickscript.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   102,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   102,
																		},
																		File:   "tickscript.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 21,
																			Line:   102,
																		},
																	},
																},
																Name: "r",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rparan: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 51,
														Line:   102,
													},
													File:   "tickscript.flux",
													Source: "map(fn: (r) => ({r with _time: now()}))",
													Start: ast.Position{
														Column: 12,
														Line:   102,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   102,
														},
														File:   "tickscript.flux",
														Source: "map",
														Start: ast.Position{
															Column: 12,
															Line:   102,
														},
													},
												},
												Name: "map",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: []ast.Comment{ast.Comment{Text: "// same tag that monitor.deadman() adds\n"}},
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   104,
											},
											File:   "tickscript.flux",
											Source: "_tables\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")\n        // recreate _time column after aggregation\n        |> map(fn: (r) => ({r with _time: now()}))\n        // same tag that monitor.deadman() adds\n        |> map(fn: (r) => ({r with dead: r.__value__ <= threshold}))",
											Start: ast.Position{
												Column: 12,
												Line:   97,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   104,
													},
													File:   "tickscript.flux",
													Source: "fn: (r) => ({r with dead: r.__value__ <= threshold})",
													Start: ast.Position{
														Column: 16,
														Line:   104,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   104,
														},
														File:   "tickscript.flux",
														Source: "fn: (r) => ({r with dead: r.__value__ <= threshold})",
														Start: ast.Position{
															Column: 16,
															Line:   104,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   104,
															},
															File:   "tickscript.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 16,
																Line:   104,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   104,
															},
															File:   "tickscript.flux",
															Source: "(r) => ({r with dead: r.__value__ <= threshold})",
															Start: ast.Position{
																Column: 20,
																Line:   104,
															},
														},
													},
													Body: &ast.ParenExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   104,
																},
																File:   "tickscript.flux",
																Source: "({r with dead: r.__value__ <= threshold})",
																Start: ast.Position{
																	Column: 27,
																	Line:   104,
																},
															},
														},
														Expression: &ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 67,
																		Line:   104,
																	},
																	File:   "tickscript.flux",
																	Source: "{r with dead: r.__value__ <= threshold}",
																	Start: ast.Position{
																		Column: 28,
																		Line:   104,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 66,
																			Line:   104,
																		},
																		File:   "tickscript.flux",
																		Source: "dead: r.__value__ <= threshold",
																		Start: ast.Position{
																			Column: 36,
																			Line:   104,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 40,
																				Line:   104,
																			},
																			File:   "tickscript.flux",
																			Source: "dead",
																			Start: ast.Position{
																				Column: 36,
																				Line:   104,
																			},
																		},
																	},
																	Name: "dead",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 66,
																				Line:   104,
																			},
																			File:   "tickscript.flux",
																			Source: "r.__value__ <= threshold",
																			Start: ast.Position{
																				Column: 42,
																				Line:   104,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 53,
																					Line:   104,
																				},
																				File:   "tickscript.flux",
																				Source: "r.__value__",
																				Start: ast.Position{
																					Column: 42,
																					Line:   104,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 43,
																						Line:   104,
																					},
																					File:   "tickscript.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 42,
																						Line:   104,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 53,
																						Line:   104,
																					},
																					File:   "tickscript.flux",
																					Source: "__value__",
																					Start: ast.Position{
																						Column: 44,
																						Line:   104,
																					},
																				},
																			},
																			Name: "__value__",
																		},
																		Rbrack: nil,
																	},
																	Operator: 7,
																	Right: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 66,
																					Line:   104,
																				},
																				File:   "tickscript.flux",
																				Source: "threshold",
																				Start: ast.Position{
																					Column: 57,
																					Line:   104,
																				},
																			},
																		},
																		Name: "threshold",
																	},
																},
															}},
															Rbrace: nil,
															With: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 30,
																			Line:   104,
																		},
																		File:   "tickscript.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 29,
																			Line:   104,
																		},
																	},
																},
																Name: "r",
															},
														},
														Lparen: nil,
														Rparen: nil,
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   104,
																},
																File:   "tickscript.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 21,
																	Line:   104,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   104,
																	},
																	File:   "tickscript.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   104,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   104,
												},
												File:   "tickscript.flux",
												Source: "map(fn: (r) => ({r with dead: r.__value__ <= threshold}))",
												Start: ast.Position{
													Column: 12,
													Line:   104,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   104,
													},
													File:   "tickscript.flux",
													Source: "map",
													Start: ast.Position{
														Column: 12,
														Line:   104,
													},
												},
											},
											Name: "map",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: []ast.Comment{ast.Comment{Text: "// drop dummy field\n"}},
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   106,
										},
										File:   "tickscript.flux",
										Source: "_tables\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")\n        // recreate _time column after aggregation\n        |> map(fn: (r) => ({r with _time: now()}))\n        // same tag that monitor.deadman() adds\n        |> map(fn: (r) => ({r with dead: r.__value__ <= threshold}))\n        // drop dummy field\n        |> drop(columns: [\"__value__\"])",
										Start: ast.Position{
											Column: 12,
											Line:   97,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   106,
												},
												File:   "tickscript.flux",
												Source: "columns: [\"__value__\"]",
												Start: ast.Position{
													Column: 17,
													Line:   106,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   106,
													},
													File:   "tickscript.flux",
													Source: "columns: [\"__value__\"]",
													Start: ast.Position{
														Column: 17,
														Line:   106,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   106,
														},
														File:   "tickscript.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 17,
															Line:   106,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   106,
														},
														File:   "tickscript.flux",
														Source: "[\"__value__\"]",
														Start: ast.Position{
															Column: 26,
															Line:   106,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   106,
															},
															File:   "tickscript.flux",
															Source: "\"__value__\"",
															Start: ast.Position{
																Column: 27,
																Line:   106,
															},
														},
													},
													Value: "__value__",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   106,
											},
											File:   "tickscript.flux",
											Source: "drop(columns: [\"__value__\"])",
											Start: ast.Position{
												Column: 12,
												Line:   106,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   106,
												},
												File:   "tickscript.flux",
												Source: "drop",
												Start: ast.Position{
													Column: 12,
													Line:   106,
												},
											},
										},
										Name: "drop",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   113,
									},
									File:   "tickscript.flux",
									Source: "_tables\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")\n        // recreate _time column after aggregation\n        |> map(fn: (r) => ({r with _time: now()}))\n        // same tag that monitor.deadman() adds\n        |> map(fn: (r) => ({r with dead: r.__value__ <= threshold}))\n        // drop dummy field\n        |> drop(columns: [\"__value__\"])\n        |> alert(\n            check: check,\n            id: id,\n            message: message,\n            crit: (r) => r.dead,\n            topic: topic,\n        )",
									Start: ast.Position{
										Column: 12,
										Line:   97,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   112,
											},
											File:   "tickscript.flux",
											Source: "check: check,\n            id: id,\n            message: message,\n            crit: (r) => r.dead,\n            topic: topic",
											Start: ast.Position{
												Column: 13,
												Line:   108,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   108,
												},
												File:   "tickscript.flux",
												Source: "check: check",
												Start: ast.Position{
													Column: 13,
													Line:   108,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   108,
													},
													File:   "tickscript.flux",
													Source: "check",
													Start: ast.Position{
														Column: 13,
														Line:   108,
													},
												},
											},
											Name: "check",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   108,
													},
													File:   "tickscript.flux",
													Source: "check",
													Start: ast.Position{
														Column: 20,
														Line:   108,
													},
												},
											},
											Name: "check",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   109,
												},
												File:   "tickscript.flux",
												Source: "id: id",
												Start: ast.Position{
													Column: 13,
													Line:   109,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   109,
													},
													File:   "tickscript.flux",
													Source: "id",
													Start: ast.Position{
														Column: 13,
														Line:   109,
													},
												},
											},
											Name: "id",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   109,
													},
													File:   "tickscript.flux",
													Source: "id",
													Start: ast.Position{
														Column: 17,
														Line:   109,
													},
												},
											},
											Name: "id",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   110,
												},
												File:   "tickscript.flux",
												Source: "message: message",
												Start: ast.Position{
													Column: 13,
													Line:   110,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   110,
													},
													File:   "tickscript.flux",
													Source: "message",
													Start: ast.Position{
														Column: 13,
														Line:   110,
													},
												},
											},
											Name: "message",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   110,
													},
													File:   "tickscript.flux",
													Source: "message",
													Start: ast.Position{
														Column: 22,
														Line:   110,
													},
												},
											},
											Name: "message",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   111,
												},
												File:   "tickscript.flux",
												Source: "crit: (r) => r.dead",
												Start: ast.Position{
													Column: 13,
													Line:   111,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   111,
													},
													File:   "tickscript.flux",
													Source: "crit",
													Start: ast.Position{
														Column: 13,
														Line:   111,
													},
												},
											},
											Name: "crit",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   111,
													},
													File:   "tickscript.flux",
													Source: "(r) => r.dead",
													Start: ast.Position{
														Column: 19,
														Line:   111,
													},
												},
											},
											Body: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   111,
														},
														File:   "tickscript.flux",
														Source: "r.dead",
														Start: ast.Position{
															Column: 26,
															Line:   111,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   111,
															},
															File:   "tickscript.flux",
															Source: "r",
															Start: ast.Position{
																Column: 26,
																Line:   111,
															},
														},
													},
													Name: "r",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   111,
															},
															File:   "tickscript.flux",
															Source: "dead",
															Start: ast.Position{
																Column: 28,
																Line:   111,
															},
														},
													},
													Name: "dead",
												},
												Rbrack: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   111,
														},
														File:   "tickscript.flux",
														Source: "r",
														Start: ast.Position{
															Column: 20,
															Line:   111,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   111,
															},
															File:   "tickscript.flux",
															Source: "r",
															Start: ast.Position{
																Column: 20,
																Line:   111,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   112,
												},
												File:   "tickscript.flux",
												Source: "topic: topic",
												Start: ast.Position{
													Column: 13,
													Line:   112,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   112,
													},
													File:   "tickscript.flux",
													Source: "topic",
													Start: ast.Position{
														Column: 13,
														Line:   112,
													},
												},
											},
											Name: "topic",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   112,
													},
													File:   "tickscript.flux",
													Source: "topic",
													Start: ast.Position{
														Column: 20,
														Line:   112,
													},
												},
											},
											Name: "topic",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   113,
										},
										File:   "tickscript.flux",
										Source: "alert(\n            check: check,\n            id: id,\n            message: message,\n            crit: (r) => r.dead,\n            topic: topic,\n        )",
										Start: ast.Position{
											Column: 12,
											Line:   107,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   107,
											},
											File:   "tickscript.flux",
											Source: "alert",
											Start: ast.Position{
												Column: 12,
												Line:   107,
											},
										},
									},
									Name: "alert",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   113,
								},
								File:   "tickscript.flux",
								Source: "return _tables\n        // _measurement column is always present\n        |> duplicate(column: \"_measurement\", as: \"__value__\")\n        |> count(column: \"__value__\")\n        // recreate _time column after aggregation\n        |> map(fn: (r) => ({r with _time: now()}))\n        // same tag that monitor.deadman() adds\n        |> map(fn: (r) => ({r with dead: r.__value__ <= threshold}))\n        // drop dummy field\n        |> drop(columns: [\"__value__\"])\n        |> alert(\n            check: check,\n            id: id,\n            message: message,\n            crit: (r) => r.dead,\n            topic: topic,\n        )",
								Start: ast.Position{
									Column: 5,
									Line:   97,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   64,
							},
							File:   "tickscript.flux",
							Source: "check",
							Start: ast.Position{
								Column: 9,
								Line:   64,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   64,
								},
								File:   "tickscript.flux",
								Source: "check",
								Start: ast.Position{
									Column: 9,
									Line:   64,
								},
							},
						},
						Name: "check",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   65,
							},
							File:   "tickscript.flux",
							Source: "measurement",
							Start: ast.Position{
								Column: 9,
								Line:   65,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   65,
								},
								File:   "tickscript.flux",
								Source: "measurement",
								Start: ast.Position{
									Column: 9,
									Line:   65,
								},
							},
						},
						Name: "measurement",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   66,
							},
							File:   "tickscript.flux",
							Source: "threshold=0",
							Start: ast.Position{
								Column: 9,
								Line:   66,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   66,
								},
								File:   "tickscript.flux",
								Source: "threshold",
								Start: ast.Position{
									Column: 9,
									Line:   66,
								},
							},
						},
						Name: "threshold",
					},
					Separator: nil,
					Value: &ast.IntegerLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   66,
								},
								File:   "tickscript.flux",
								Source: "0",
								Start: ast.Position{
									Column: 19,
									Line:   66,
								},
							},
						},
						Value: int64(0),
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   67,
							},
							File:   "tickscript.flux",
							Source: "id=(r) => \"${r._check_id}\"",
							Start: ast.Position{
								Column: 9,
								Line:   67,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   67,
								},
								File:   "tickscript.flux",
								Source: "id",
								Start: ast.Position{
									Column: 9,
									Line:   67,
								},
							},
						},
						Name: "id",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   67,
								},
								File:   "tickscript.flux",
								Source: "(r) => \"${r._check_id}\"",
								Start: ast.Position{
									Column: 12,
									Line:   67,
								},
							},
						},
						Body: &ast.StringExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   67,
									},
									File:   "tickscript.flux",
									Source: "\"${r._check_id}\"",
									Start: ast.Position{
										Column: 19,
										Line:   67,
									},
								},
							},
							Parts: []ast.StringExpressionPart{&ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   67,
										},
										File:   "tickscript.flux",
										Source: "${r._check_id}",
										Start: ast.Position{
											Column: 20,
											Line:   67,
										},
									},
								},
								Expression: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   67,
											},
											File:   "tickscript.flux",
											Source: "r._check_id",
											Start: ast.Position{
												Column: 22,
												Line:   67,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   67,
												},
												File:   "tickscript.flux",
												Source: "r",
												Start: ast.Position{
													Column: 22,
													Line:   67,
												},
											},
										},
										Name: "r",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   67,
												},
												File:   "tickscript.flux",
												Source: "_check_id",
												Start: ast.Position{
													Column: 24,
													Line:   67,
												},
											},
										},
										Name: "_check_id",
									},
									Rbrack: nil,
								},
							}},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   67,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 13,
										Line:   67,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   67,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 13,
											Line:   67,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 101,
								Line:   68,
							},
							File:   "tickscript.flux",
							Source: "message=(r) => \"Deadman Check: ${r._check_name} is: \" + (if r.dead then \"dead\" else \"alive\")",
							Start: ast.Position{
								Column: 9,
								Line:   68,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   68,
								},
								File:   "tickscript.flux",
								Source: "message",
								Start: ast.Position{
									Column: 9,
									Line:   68,
								},
							},
						},
						Name: "message",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   68,
								},
								File:   "tickscript.flux",
								Source: "(r) => \"Deadman Check: ${r._check_name} is: \" + (if r.dead then \"dead\" else \"alive\")",
								Start: ast.Position{
									Column: 17,
									Line:   68,
								},
							},
						},
						Body: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 101,
										Line:   68,
									},
									File:   "tickscript.flux",
									Source: "\"Deadman Check: ${r._check_name} is: \" + (if r.dead then \"dead\" else \"alive\")",
									Start: ast.Position{
										Column: 24,
										Line:   68,
									},
								},
							},
							Left: &ast.StringExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   68,
										},
										File:   "tickscript.flux",
										Source: "\"Deadman Check: ${r._check_name} is: \"",
										Start: ast.Position{
											Column: 24,
											Line:   68,
										},
									},
								},
								Parts: []ast.StringExpressionPart{&ast.TextPart{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   68,
											},
											File:   "tickscript.flux",
											Source: "Deadman Check: ",
											Start: ast.Position{
												Column: 25,
												Line:   68,
											},
										},
									},
									Value: "Deadman Check: ",
								}, &ast.InterpolatedPart{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   68,
											},
											File:   "tickscript.flux",
											Source: "${r._check_name}",
											Start: ast.Position{
												Column: 40,
												Line:   68,
											},
										},
									},
									Expression: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 55,
													Line:   68,
												},
												File:   "tickscript.flux",
												Source: "r._check_name",
												Start: ast.Position{
													Column: 42,
													Line:   68,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   68,
													},
													File:   "tickscript.flux",
													Source: "r",
													Start: ast.Position{
														Column: 42,
														Line:   68,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   68,
													},
													File:   "tickscript.flux",
													Source: "_check_name",
													Start: ast.Position{
														Column: 44,
														Line:   68,
													},
												},
											},
											Name: "_check_name",
										},
										Rbrack: nil,
									},
								}, &ast.TextPart{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   68,
											},
											File:   "tickscript.flux",
											Source: " is: ",
											Start: ast.Position{
												Column: 56,
												Line:   68,
											},
										},
									},
									Value: " is: ",
								}},
							},
							Operator: 5,
							Right: &ast.ParenExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 101,
											Line:   68,
										},
										File:   "tickscript.flux",
										Source: "(if r.dead then \"dead\" else \"alive\")",
										Start: ast.Position{
											Column: 65,
											Line:   68,
										},
									},
								},
								Expression: &ast.ConditionalExpression{
									Alternate: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 100,
													Line:   68,
												},
												File:   "tickscript.flux",
												Source: "\"alive\"",
												Start: ast.Position{
													Column: 93,
													Line:   68,
												},
											},
										},
										Value: "alive",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 100,
												Line:   68,
											},
											File:   "tickscript.flux",
											Source: "if r.dead then \"dead\" else \"alive\"",
											Start: ast.Position{
												Column: 66,
												Line:   68,
											},
										},
									},
									Consequent: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 87,
													Line:   68,
												},
												File:   "tickscript.flux",
												Source: "\"dead\"",
												Start: ast.Position{
													Column: 81,
													Line:   68,
												},
											},
										},
										Value: "dead",
									},
									Test: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 75,
													Line:   68,
												},
												File:   "tickscript.flux",
												Source: "r.dead",
												Start: ast.Position{
													Column: 69,
													Line:   68,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   68,
													},
													File:   "tickscript.flux",
													Source: "r",
													Start: ast.Position{
														Column: 69,
														Line:   68,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 75,
														Line:   68,
													},
													File:   "tickscript.flux",
													Source: "dead",
													Start: ast.Position{
														Column: 71,
														Line:   68,
													},
												},
											},
											Name: "dead",
										},
										Rbrack: nil,
									},
									Tk_else: nil,
									Tk_if:   nil,
									Tk_then: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   68,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 18,
										Line:   68,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   68,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 18,
											Line:   68,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   69,
							},
							File:   "tickscript.flux",
							Source: "topic=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   69,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   69,
								},
								File:   "tickscript.flux",
								Source: "topic",
								Start: ast.Position{
									Column: 9,
									Line:   69,
								},
							},
						},
						Name: "topic",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   69,
								},
								File:   "tickscript.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 15,
									Line:   69,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   70,
							},
							File:   "tickscript.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 9,
								Line:   70,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   70,
								},
								File:   "tickscript.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 9,
									Line:   70,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   70,
							},
							File:   "tickscript.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   70,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   129,
					},
					File:   "tickscript.flux",
					Source: "select = (column=\"_value\", fn=(column, tables=<-) => tables, as, tables=<-) => {\n    _column = column\n    _as = as\n\n    return tables\n        |> fn(column: _column)\n        |> rename(fn: (column) => if column == _column then _as else column)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   122,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// select selects a column and optionally computes aggregated value.\n"}, ast.Comment{Text: "// It is meant to be a convenience function to be used for:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   query(\"SELECT x AS y\")\n"}, ast.Comment{Text: "//   query(\"SELECT f(x) AS y\") without time grouping\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   122,
						},
						File:   "tickscript.flux",
						Source: "select",
						Start: ast.Position{
							Column: 1,
							Line:   122,
						},
					},
				},
				Name: "select",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   129,
						},
						File:   "tickscript.flux",
						Source: "(column=\"_value\", fn=(column, tables=<-) => tables, as, tables=<-) => {\n    _column = column\n    _as = as\n\n    return tables\n        |> fn(column: _column)\n        |> rename(fn: (column) => if column == _column then _as else column)\n}",
						Start: ast.Position{
							Column: 10,
							Line:   122,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   129,
							},
							File:   "tickscript.flux",
							Source: "{\n    _column = column\n    _as = as\n\n    return tables\n        |> fn(column: _column)\n        |> rename(fn: (column) => if column == _column then _as else column)\n}",
							Start: ast.Position{
								Column: 80,
								Line:   122,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   123,
								},
								File:   "tickscript.flux",
								Source: "_column = column",
								Start: ast.Position{
									Column: 5,
									Line:   123,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   123,
									},
									File:   "tickscript.flux",
									Source: "_column",
									Start: ast.Position{
										Column: 5,
										Line:   123,
									},
								},
							},
							Name: "_column",
						},
						Init: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   123,
									},
									File:   "tickscript.flux",
									Source: "column",
									Start: ast.Position{
										Column: 15,
										Line:   123,
									},
								},
							},
							Name: "column",
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   124,
								},
								File:   "tickscript.flux",
								Source: "_as = as",
								Start: ast.Position{
									Column: 5,
									Line:   124,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   124,
									},
									File:   "tickscript.flux",
									Source: "_as",
									Start: ast.Position{
										Column: 5,
										Line:   124,
									},
								},
							},
							Name: "_as",
						},
						Init: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   124,
									},
									File:   "tickscript.flux",
									Source: "as",
									Start: ast.Position{
										Column: 11,
										Line:   124,
									},
								},
							},
							Name: "as",
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   126,
											},
											File:   "tickscript.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 12,
												Line:   126,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   127,
										},
										File:   "tickscript.flux",
										Source: "tables\n        |> fn(column: _column)",
										Start: ast.Position{
											Column: 12,
											Line:   126,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   127,
												},
												File:   "tickscript.flux",
												Source: "column: _column",
												Start: ast.Position{
													Column: 15,
													Line:   127,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   127,
													},
													File:   "tickscript.flux",
													Source: "column: _column",
													Start: ast.Position{
														Column: 15,
														Line:   127,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   127,
														},
														File:   "tickscript.flux",
														Source: "column",
														Start: ast.Position{
															Column: 15,
															Line:   127,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   127,
														},
														File:   "tickscript.flux",
														Source: "_column",
														Start: ast.Position{
															Column: 23,
															Line:   127,
														},
													},
												},
												Name: "_column",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   127,
											},
											File:   "tickscript.flux",
											Source: "fn(column: _column)",
											Start: ast.Position{
												Column: 12,
												Line:   127,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   127,
												},
												File:   "tickscript.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 12,
													Line:   127,
												},
											},
										},
										Name: "fn",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 77,
										Line:   128,
									},
									File:   "tickscript.flux",
									Source: "tables\n        |> fn(column: _column)\n        |> rename(fn: (column) => if column == _column then _as else column)",
									Start: ast.Position{
										Column: 12,
										Line:   126,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   128,
											},
											File:   "tickscript.flux",
											Source: "fn: (column) => if column == _column then _as else column",
											Start: ast.Position{
												Column: 19,
												Line:   128,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   128,
												},
												File:   "tickscript.flux",
												Source: "fn: (column) => if column == _column then _as else column",
												Start: ast.Position{
													Column: 19,
													Line:   128,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   128,
													},
													File:   "tickscript.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 19,
														Line:   128,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 76,
														Line:   128,
													},
													File:   "tickscript.flux",
													Source: "(column) => if column == _column then _as else column",
													Start: ast.Position{
														Column: 23,
														Line:   128,
													},
												},
											},
											Body: &ast.ConditionalExpression{
												Alternate: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 76,
																Line:   128,
															},
															File:   "tickscript.flux",
															Source: "column",
															Start: ast.Position{
																Column: 70,
																Line:   128,
															},
														},
													},
													Name: "column",
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 76,
															Line:   128,
														},
														File:   "tickscript.flux",
														Source: "if column == _column then _as else column",
														Start: ast.Position{
															Column: 35,
															Line:   128,
														},
													},
												},
												Consequent: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 64,
																Line:   128,
															},
															File:   "tickscript.flux",
															Source: "_as",
															Start: ast.Position{
																Column: 61,
																Line:   128,
															},
														},
													},
													Name: "_as",
												},
												Test: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 55,
																Line:   128,
															},
															File:   "tickscript.flux",
															Source: "column == _column",
															Start: ast.Position{
																Column: 38,
																Line:   128,
															},
														},
													},
													Left: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   128,
																},
																File:   "tickscript.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 38,
																	Line:   128,
																},
															},
														},
														Name: "column",
													},
													Operator: 17,
													Right: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   128,
																},
																File:   "tickscript.flux",
																Source: "_column",
																Start: ast.Position{
																	Column: 48,
																	Line:   128,
																},
															},
														},
														Name: "_column",
													},
												},
												Tk_else: nil,
												Tk_if:   nil,
												Tk_then: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   128,
														},
														File:   "tickscript.flux",
														Source: "column",
														Start: ast.Position{
															Column: 24,
															Line:   128,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   128,
															},
															File:   "tickscript.flux",
															Source: "column",
															Start: ast.Position{
																Column: 24,
																Line:   128,
															},
														},
													},
													Name: "column",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   128,
										},
										File:   "tickscript.flux",
										Source: "rename(fn: (column) => if column == _column then _as else column)",
										Start: ast.Position{
											Column: 12,
											Line:   128,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   128,
											},
											File:   "tickscript.flux",
											Source: "rename",
											Start: ast.Position{
												Column: 12,
												Line:   128,
											},
										},
									},
									Name: "rename",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   128,
								},
								File:   "tickscript.flux",
								Source: "return tables\n        |> fn(column: _column)\n        |> rename(fn: (column) => if column == _column then _as else column)",
								Start: ast.Position{
									Column: 5,
									Line:   126,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   122,
							},
							File:   "tickscript.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 11,
								Line:   122,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   122,
								},
								File:   "tickscript.flux",
								Source: "column",
								Start: ast.Position{
									Column: 11,
									Line:   122,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   122,
								},
								File:   "tickscript.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 18,
									Line:   122,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   122,
							},
							File:   "tickscript.flux",
							Source: "fn=(column, tables=<-) => tables",
							Start: ast.Position{
								Column: 28,
								Line:   122,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   122,
								},
								File:   "tickscript.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 28,
									Line:   122,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   122,
								},
								File:   "tickscript.flux",
								Source: "(column, tables=<-) => tables",
								Start: ast.Position{
									Column: 31,
									Line:   122,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   122,
									},
									File:   "tickscript.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 54,
										Line:   122,
									},
								},
							},
							Name: "tables",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   122,
									},
									File:   "tickscript.flux",
									Source: "column",
									Start: ast.Position{
										Column: 32,
										Line:   122,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   122,
										},
										File:   "tickscript.flux",
										Source: "column",
										Start: ast.Position{
											Column: 32,
											Line:   122,
										},
									},
								},
								Name: "column",
							},
							Separator: nil,
							Value:     nil,
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   122,
									},
									File:   "tickscript.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 40,
										Line:   122,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   122,
										},
										File:   "tickscript.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 40,
											Line:   122,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   122,
									},
									File:   "tickscript.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 47,
										Line:   122,
									},
								},
							}},
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   122,
							},
							File:   "tickscript.flux",
							Source: "as",
							Start: ast.Position{
								Column: 62,
								Line:   122,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   122,
								},
								File:   "tickscript.flux",
								Source: "as",
								Start: ast.Position{
									Column: 62,
									Line:   122,
								},
							},
						},
						Name: "as",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 75,
								Line:   122,
							},
							File:   "tickscript.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 66,
								Line:   122,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   122,
								},
								File:   "tickscript.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 66,
									Line:   122,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 75,
								Line:   122,
							},
							File:   "tickscript.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 73,
								Line:   122,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   152,
					},
					File:   "tickscript.flux",
					Source: "selectWindow = (\n        column=\"_value\",\n        fn,\n        as,\n        every,\n        defaultValue,\n        tables=<-,\n) => {\n    _column = column\n    _as = as\n\n    return tables\n        |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)\n        |> fill(column: _column, value: defaultValue)\n        |> rename(fn: (column) => if column == _column then _as else column)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   137,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// selectWindow selects a column with time grouping and computes aggregated values.\n"}, ast.Comment{Text: "// It is a convenience function to be used as\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   query(\"SELECT f(x) AS y\")\n"}, ast.Comment{Text: "//     .groupBy(time(t), ...)\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   137,
						},
						File:   "tickscript.flux",
						Source: "selectWindow",
						Start: ast.Position{
							Column: 1,
							Line:   137,
						},
					},
				},
				Name: "selectWindow",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   152,
						},
						File:   "tickscript.flux",
						Source: "(\n        column=\"_value\",\n        fn,\n        as,\n        every,\n        defaultValue,\n        tables=<-,\n) => {\n    _column = column\n    _as = as\n\n    return tables\n        |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)\n        |> fill(column: _column, value: defaultValue)\n        |> rename(fn: (column) => if column == _column then _as else column)\n}",
						Start: ast.Position{
							Column: 16,
							Line:   137,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   152,
							},
							File:   "tickscript.flux",
							Source: "{\n    _column = column\n    _as = as\n\n    return tables\n        |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)\n        |> fill(column: _column, value: defaultValue)\n        |> rename(fn: (column) => if column == _column then _as else column)\n}",
							Start: ast.Position{
								Column: 6,
								Line:   144,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   145,
								},
								File:   "tickscript.flux",
								Source: "_column = column",
								Start: ast.Position{
									Column: 5,
									Line:   145,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   145,
									},
									File:   "tickscript.flux",
									Source: "_column",
									Start: ast.Position{
										Column: 5,
										Line:   145,
									},
								},
							},
							Name: "_column",
						},
						Init: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   145,
									},
									File:   "tickscript.flux",
									Source: "column",
									Start: ast.Position{
										Column: 15,
										Line:   145,
									},
								},
							},
							Name: "column",
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   146,
								},
								File:   "tickscript.flux",
								Source: "_as = as",
								Start: ast.Position{
									Column: 5,
									Line:   146,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   146,
									},
									File:   "tickscript.flux",
									Source: "_as",
									Start: ast.Position{
										Column: 5,
										Line:   146,
									},
								},
							},
							Name: "_as",
						},
						Init: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   146,
									},
									File:   "tickscript.flux",
									Source: "as",
									Start: ast.Position{
										Column: 11,
										Line:   146,
									},
								},
							},
							Name: "as",
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   148,
												},
												File:   "tickscript.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 12,
													Line:   148,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   149,
											},
											File:   "tickscript.flux",
											Source: "tables\n        |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)",
											Start: ast.Position{
												Column: 12,
												Line:   148,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 84,
														Line:   149,
													},
													File:   "tickscript.flux",
													Source: "every: every, fn: fn, column: _column, createEmpty: true",
													Start: ast.Position{
														Column: 28,
														Line:   149,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   149,
														},
														File:   "tickscript.flux",
														Source: "every: every",
														Start: ast.Position{
															Column: 28,
															Line:   149,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 33,
																Line:   149,
															},
															File:   "tickscript.flux",
															Source: "every",
															Start: ast.Position{
																Column: 28,
																Line:   149,
															},
														},
													},
													Name: "every",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   149,
															},
															File:   "tickscript.flux",
															Source: "every",
															Start: ast.Position{
																Column: 35,
																Line:   149,
															},
														},
													},
													Name: "every",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   149,
														},
														File:   "tickscript.flux",
														Source: "fn: fn",
														Start: ast.Position{
															Column: 42,
															Line:   149,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   149,
															},
															File:   "tickscript.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 42,
																Line:   149,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   149,
															},
															File:   "tickscript.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 46,
																Line:   149,
															},
														},
													},
													Name: "fn",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   149,
														},
														File:   "tickscript.flux",
														Source: "column: _column",
														Start: ast.Position{
															Column: 50,
															Line:   149,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   149,
															},
															File:   "tickscript.flux",
															Source: "column",
															Start: ast.Position{
																Column: 50,
																Line:   149,
															},
														},
													},
													Name: "column",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 65,
																Line:   149,
															},
															File:   "tickscript.flux",
															Source: "_column",
															Start: ast.Position{
																Column: 58,
																Line:   149,
															},
														},
													},
													Name: "_column",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 84,
															Line:   149,
														},
														File:   "tickscript.flux",
														Source: "createEmpty: true",
														Start: ast.Position{
															Column: 67,
															Line:   149,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 78,
																Line:   149,
															},
															File:   "tickscript.flux",
															Source: "createEmpty",
															Start: ast.Position{
																Column: 67,
																Line:   149,
															},
														},
													},
													Name: "createEmpty",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 84,
																Line:   149,
															},
															File:   "tickscript.flux",
															Source: "true",
															Start: ast.Position{
																Column: 80,
																Line:   149,
															},
														},
													},
													Name: "true",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 85,
													Line:   149,
												},
												File:   "tickscript.flux",
												Source: "aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)",
												Start: ast.Position{
													Column: 12,
													Line:   149,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   149,
													},
													File:   "tickscript.flux",
													Source: "aggregateWindow",
													Start: ast.Position{
														Column: 12,
														Line:   149,
													},
												},
											},
											Name: "aggregateWindow",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   150,
										},
										File:   "tickscript.flux",
										Source: "tables\n        |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)\n        |> fill(column: _column, value: defaultValue)",
										Start: ast.Position{
											Column: 12,
											Line:   148,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   150,
												},
												File:   "tickscript.flux",
												Source: "column: _column, value: defaultValue",
												Start: ast.Position{
													Column: 17,
													Line:   150,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   150,
													},
													File:   "tickscript.flux",
													Source: "column: _column",
													Start: ast.Position{
														Column: 17,
														Line:   150,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   150,
														},
														File:   "tickscript.flux",
														Source: "column",
														Start: ast.Position{
															Column: 17,
															Line:   150,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   150,
														},
														File:   "tickscript.flux",
														Source: "_column",
														Start: ast.Position{
															Column: 25,
															Line:   150,
														},
													},
												},
												Name: "_column",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   150,
													},
													File:   "tickscript.flux",
													Source: "value: defaultValue",
													Start: ast.Position{
														Column: 34,
														Line:   150,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   150,
														},
														File:   "tickscript.flux",
														Source: "value",
														Start: ast.Position{
															Column: 34,
															Line:   150,
														},
													},
												},
												Name: "value",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 53,
															Line:   150,
														},
														File:   "tickscript.flux",
														Source: "defaultValue",
														Start: ast.Position{
															Column: 41,
															Line:   150,
														},
													},
												},
												Name: "defaultValue",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   150,
											},
											File:   "tickscript.flux",
											Source: "fill(column: _column, value: defaultValue)",
											Start: ast.Position{
												Column: 12,
												Line:   150,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   150,
												},
												File:   "tickscript.flux",
												Source: "fill",
												Start: ast.Position{
													Column: 12,
													Line:   150,
												},
											},
										},
										Name: "fill",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 77,
										Line:   151,
									},
									File:   "tickscript.flux",
									Source: "tables\n        |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)\n        |> fill(column: _column, value: defaultValue)\n        |> rename(fn: (column) => if column == _column then _as else column)",
									Start: ast.Position{
										Column: 12,
										Line:   148,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   151,
											},
											File:   "tickscript.flux",
											Source: "fn: (column) => if column == _column then _as else column",
											Start: ast.Position{
												Column: 19,
												Line:   151,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   151,
												},
												File:   "tickscript.flux",
												Source: "fn: (column) => if column == _column then _as else column",
												Start: ast.Position{
													Column: 19,
													Line:   151,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   151,
													},
													File:   "tickscript.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 19,
														Line:   151,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 76,
														Line:   151,
													},
													File:   "tickscript.flux",
													Source: "(column) => if column == _column then _as else column",
													Start: ast.Position{
														Column: 23,
														Line:   151,
													},
												},
											},
											Body: &ast.ConditionalExpression{
												Alternate: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 76,
																Line:   151,
															},
															File:   "tickscript.flux",
															Source: "column",
															Start: ast.Position{
																Column: 70,
																Line:   151,
															},
														},
													},
													Name: "column",
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 76,
															Line:   151,
														},
														File:   "tickscript.flux",
														Source: "if column == _column then _as else column",
														Start: ast.Position{
															Column: 35,
															Line:   151,
														},
													},
												},
												Consequent: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 64,
																Line:   151,
															},
															File:   "tickscript.flux",
															Source: "_as",
															Start: ast.Position{
																Column: 61,
																Line:   151,
															},
														},
													},
													Name: "_as",
												},
												Test: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 55,
																Line:   151,
															},
															File:   "tickscript.flux",
															Source: "column == _column",
															Start: ast.Position{
																Column: 38,
																Line:   151,
															},
														},
													},
													Left: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   151,
																},
																File:   "tickscript.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 38,
																	Line:   151,
																},
															},
														},
														Name: "column",
													},
													Operator: 17,
													Right: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   151,
																},
																File:   "tickscript.flux",
																Source: "_column",
																Start: ast.Position{
																	Column: 48,
																	Line:   151,
																},
															},
														},
														Name: "_column",
													},
												},
												Tk_else: nil,
												Tk_if:   nil,
												Tk_then: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   151,
														},
														File:   "tickscript.flux",
														Source: "column",
														Start: ast.Position{
															Column: 24,
															Line:   151,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   151,
															},
															File:   "tickscript.flux",
															Source: "column",
															Start: ast.Position{
																Column: 24,
																Line:   151,
															},
														},
													},
													Name: "column",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   151,
										},
										File:   "tickscript.flux",
										Source: "rename(fn: (column) => if column == _column then _as else column)",
										Start: ast.Position{
											Column: 12,
											Line:   151,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   151,
											},
											File:   "tickscript.flux",
											Source: "rename",
											Start: ast.Position{
												Column: 12,
												Line:   151,
											},
										},
									},
									Name: "rename",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   151,
								},
								File:   "tickscript.flux",
								Source: "return tables\n        |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)\n        |> fill(column: _column, value: defaultValue)\n        |> rename(fn: (column) => if column == _column then _as else column)",
								Start: ast.Position{
									Column: 5,
									Line:   148,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   138,
							},
							File:   "tickscript.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 9,
								Line:   138,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   138,
								},
								File:   "tickscript.flux",
								Source: "column",
								Start: ast.Position{
									Column: 9,
									Line:   138,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   138,
								},
								File:   "tickscript.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 16,
									Line:   138,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   139,
							},
							File:   "tickscript.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 9,
								Line:   139,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   139,
								},
								File:   "tickscript.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 9,
									Line:   139,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   140,
							},
							File:   "tickscript.flux",
							Source: "as",
							Start: ast.Position{
								Column: 9,
								Line:   140,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   140,
								},
								File:   "tickscript.flux",
								Source: "as",
								Start: ast.Position{
									Column: 9,
									Line:   140,
								},
							},
						},
						Name: "as",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   141,
							},
							File:   "tickscript.flux",
							Source: "every",
							Start: ast.Position{
								Column: 9,
								Line:   141,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   141,
								},
								File:   "tickscript.flux",
								Source: "every",
								Start: ast.Position{
									Column: 9,
									Line:   141,
								},
							},
						},
						Name: "every",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   142,
							},
							File:   "tickscript.flux",
							Source: "defaultValue",
							Start: ast.Position{
								Column: 9,
								Line:   142,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   142,
								},
								File:   "tickscript.flux",
								Source: "defaultValue",
								Start: ast.Position{
									Column: 9,
									Line:   142,
								},
							},
						},
						Name: "defaultValue",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   143,
							},
							File:   "tickscript.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 9,
								Line:   143,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   143,
								},
								File:   "tickscript.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 9,
									Line:   143,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   143,
							},
							File:   "tickscript.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   143,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   160,
					},
					File:   "tickscript.flux",
					Source: "compute = select",
					Start: ast.Position{
						Column: 1,
						Line:   160,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// compute computes aggregated value of the input data.\n"}, ast.Comment{Text: "// It is a convenience function to be used as\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   |median('x)'\n"}, ast.Comment{Text: "//      .as(y)\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   160,
						},
						File:   "tickscript.flux",
						Source: "compute",
						Start: ast.Position{
							Column: 1,
							Line:   160,
						},
					},
				},
				Name: "compute",
			},
			Init: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   160,
						},
						File:   "tickscript.flux",
						Source: "select",
						Start: ast.Position{
							Column: 11,
							Line:   160,
						},
					},
				},
				Name: "select",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 69,
						Line:   167,
					},
					File:   "tickscript.flux",
					Source: "groupBy = (columns, tables=<-) => tables\n    |> group(columns: columns)\n    // required by monitor.check\n    |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
					Start: ast.Position{
						Column: 1,
						Line:   164,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// groupBy groups by specified columns.\n"}, ast.Comment{Text: "// It is a convenience function, it adds _measurement column which is required by monitor.check().\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   164,
						},
						File:   "tickscript.flux",
						Source: "groupBy",
						Start: ast.Position{
							Column: 1,
							Line:   164,
						},
					},
				},
				Name: "groupBy",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 69,
							Line:   167,
						},
						File:   "tickscript.flux",
						Source: "(columns, tables=<-) => tables\n    |> group(columns: columns)\n    // required by monitor.check\n    |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
						Start: ast.Position{
							Column: 11,
							Line:   164,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   164,
									},
									File:   "tickscript.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 35,
										Line:   164,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   165,
								},
								File:   "tickscript.flux",
								Source: "tables\n    |> group(columns: columns)",
								Start: ast.Position{
									Column: 35,
									Line:   164,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   165,
										},
										File:   "tickscript.flux",
										Source: "columns: columns",
										Start: ast.Position{
											Column: 14,
											Line:   165,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   165,
											},
											File:   "tickscript.flux",
											Source: "columns: columns",
											Start: ast.Position{
												Column: 14,
												Line:   165,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   165,
												},
												File:   "tickscript.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 14,
													Line:   165,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   165,
												},
												File:   "tickscript.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 23,
													Line:   165,
												},
											},
										},
										Name: "columns",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   165,
									},
									File:   "tickscript.flux",
									Source: "group(columns: columns)",
									Start: ast.Position{
										Column: 8,
										Line:   165,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   165,
										},
										File:   "tickscript.flux",
										Source: "group",
										Start: ast.Position{
											Column: 8,
											Line:   165,
										},
									},
								},
								Name: "group",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: []ast.Comment{ast.Comment{Text: "// required by monitor.check\n"}},
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 69,
								Line:   167,
							},
							File:   "tickscript.flux",
							Source: "tables\n    |> group(columns: columns)\n    // required by monitor.check\n    |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
							Start: ast.Position{
								Column: 35,
								Line:   164,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   167,
									},
									File:   "tickscript.flux",
									Source: "columns: [\"_measurement\"], mode: \"extend\"",
									Start: ast.Position{
										Column: 27,
										Line:   167,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   167,
										},
										File:   "tickscript.flux",
										Source: "columns: [\"_measurement\"]",
										Start: ast.Position{
											Column: 27,
											Line:   167,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   167,
											},
											File:   "tickscript.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 27,
												Line:   167,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   167,
											},
											File:   "tickscript.flux",
											Source: "[\"_measurement\"]",
											Start: ast.Position{
												Column: 36,
												Line:   167,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   167,
												},
												File:   "tickscript.flux",
												Source: "\"_measurement\"",
												Start: ast.Position{
													Column: 37,
													Line:   167,
												},
											},
										},
										Value: "_measurement",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   167,
										},
										File:   "tickscript.flux",
										Source: "mode: \"extend\"",
										Start: ast.Position{
											Column: 54,
											Line:   167,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   167,
											},
											File:   "tickscript.flux",
											Source: "mode",
											Start: ast.Position{
												Column: 54,
												Line:   167,
											},
										},
									},
									Name: "mode",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   167,
											},
											File:   "tickscript.flux",
											Source: "\"extend\"",
											Start: ast.Position{
												Column: 60,
												Line:   167,
											},
										},
									},
									Value: "extend",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   167,
								},
								File:   "tickscript.flux",
								Source: "experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
								Start: ast.Position{
									Column: 8,
									Line:   167,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   167,
									},
									File:   "tickscript.flux",
									Source: "experimental.group",
									Start: ast.Position{
										Column: 8,
										Line:   167,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   167,
										},
										File:   "tickscript.flux",
										Source: "experimental",
										Start: ast.Position{
											Column: 8,
											Line:   167,
										},
									},
								},
								Name: "experimental",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   167,
										},
										File:   "tickscript.flux",
										Source: "group",
										Start: ast.Position{
											Column: 21,
											Line:   167,
										},
									},
								},
								Name: "group",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   164,
							},
							File:   "tickscript.flux",
							Source: "columns",
							Start: ast.Position{
								Column: 12,
								Line:   164,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   164,
								},
								File:   "tickscript.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 12,
									Line:   164,
								},
							},
						},
						Name: "columns",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   164,
							},
							File:   "tickscript.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 21,
								Line:   164,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   164,
								},
								File:   "tickscript.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 21,
									Line:   164,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   164,
							},
							File:   "tickscript.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   164,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 69,
						Line:   174,
					},
					File:   "tickscript.flux",
					Source: "join = (tables, on=[\"_time\"], measurement) => universe.join(tables: tables, on: on)\n    |> map(fn: (r) => ({r with _measurement: measurement}))\n    // required by monitor.check\n    |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
					Start: ast.Position{
						Column: 1,
						Line:   171,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// join merges two streams using standard join().\n"}, ast.Comment{Text: "// It is meant a convenience function, it ensures _measurement column exists and is in the group key.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   171,
						},
						File:   "tickscript.flux",
						Source: "join",
						Start: ast.Position{
							Column: 1,
							Line:   171,
						},
					},
				},
				Name: "join",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 69,
							Line:   174,
						},
						File:   "tickscript.flux",
						Source: "(tables, on=[\"_time\"], measurement) => universe.join(tables: tables, on: on)\n    |> map(fn: (r) => ({r with _measurement: measurement}))\n    // required by monitor.check\n    |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
						Start: ast.Position{
							Column: 8,
							Line:   171,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   171,
										},
										File:   "tickscript.flux",
										Source: "tables: tables, on: on",
										Start: ast.Position{
											Column: 61,
											Line:   171,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   171,
											},
											File:   "tickscript.flux",
											Source: "tables: tables",
											Start: ast.Position{
												Column: 61,
												Line:   171,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   171,
												},
												File:   "tickscript.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 61,
													Line:   171,
												},
											},
										},
										Name: "tables",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 75,
													Line:   171,
												},
												File:   "tickscript.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 69,
													Line:   171,
												},
											},
										},
										Name: "tables",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 83,
												Line:   171,
											},
											File:   "tickscript.flux",
											Source: "on: on",
											Start: ast.Position{
												Column: 77,
												Line:   171,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   171,
												},
												File:   "tickscript.flux",
												Source: "on",
												Start: ast.Position{
													Column: 77,
													Line:   171,
												},
											},
										},
										Name: "on",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 83,
													Line:   171,
												},
												File:   "tickscript.flux",
												Source: "on",
												Start: ast.Position{
													Column: 81,
													Line:   171,
												},
											},
										},
										Name: "on",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   171,
									},
									File:   "tickscript.flux",
									Source: "universe.join(tables: tables, on: on)",
									Start: ast.Position{
										Column: 47,
										Line:   171,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 60,
											Line:   171,
										},
										File:   "tickscript.flux",
										Source: "universe.join",
										Start: ast.Position{
											Column: 47,
											Line:   171,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   171,
											},
											File:   "tickscript.flux",
											Source: "universe",
											Start: ast.Position{
												Column: 47,
												Line:   171,
											},
										},
									},
									Name: "universe",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 60,
												Line:   171,
											},
											File:   "tickscript.flux",
											Source: "join",
											Start: ast.Position{
												Column: 56,
												Line:   171,
											},
										},
									},
									Name: "join",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   172,
								},
								File:   "tickscript.flux",
								Source: "universe.join(tables: tables, on: on)\n    |> map(fn: (r) => ({r with _measurement: measurement}))",
								Start: ast.Position{
									Column: 47,
									Line:   171,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   172,
										},
										File:   "tickscript.flux",
										Source: "fn: (r) => ({r with _measurement: measurement})",
										Start: ast.Position{
											Column: 12,
											Line:   172,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   172,
											},
											File:   "tickscript.flux",
											Source: "fn: (r) => ({r with _measurement: measurement})",
											Start: ast.Position{
												Column: 12,
												Line:   172,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   172,
												},
												File:   "tickscript.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 12,
													Line:   172,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   172,
												},
												File:   "tickscript.flux",
												Source: "(r) => ({r with _measurement: measurement})",
												Start: ast.Position{
													Column: 16,
													Line:   172,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   172,
													},
													File:   "tickscript.flux",
													Source: "({r with _measurement: measurement})",
													Start: ast.Position{
														Column: 23,
														Line:   172,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   172,
														},
														File:   "tickscript.flux",
														Source: "{r with _measurement: measurement}",
														Start: ast.Position{
															Column: 24,
															Line:   172,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 57,
																Line:   172,
															},
															File:   "tickscript.flux",
															Source: "_measurement: measurement",
															Start: ast.Position{
																Column: 32,
																Line:   172,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   172,
																},
																File:   "tickscript.flux",
																Source: "_measurement",
																Start: ast.Position{
																	Column: 32,
																	Line:   172,
																},
															},
														},
														Name: "_measurement",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   172,
																},
																File:   "tickscript.flux",
																Source: "measurement",
																Start: ast.Position{
																	Column: 46,
																	Line:   172,
																},
															},
														},
														Name: "measurement",
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   172,
															},
															File:   "tickscript.flux",
															Source: "r",
															Start: ast.Position{
																Column: 25,
																Line:   172,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   172,
													},
													File:   "tickscript.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   172,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   172,
														},
														File:   "tickscript.flux",
														Source: "r",
														Start: ast.Position{
															Column: 17,
															Line:   172,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   172,
									},
									File:   "tickscript.flux",
									Source: "map(fn: (r) => ({r with _measurement: measurement}))",
									Start: ast.Position{
										Column: 8,
										Line:   172,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   172,
										},
										File:   "tickscript.flux",
										Source: "map",
										Start: ast.Position{
											Column: 8,
											Line:   172,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: []ast.Comment{ast.Comment{Text: "// required by monitor.check\n"}},
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 69,
								Line:   174,
							},
							File:   "tickscript.flux",
							Source: "universe.join(tables: tables, on: on)\n    |> map(fn: (r) => ({r with _measurement: measurement}))\n    // required by monitor.check\n    |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
							Start: ast.Position{
								Column: 47,
								Line:   171,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   174,
									},
									File:   "tickscript.flux",
									Source: "columns: [\"_measurement\"], mode: \"extend\"",
									Start: ast.Position{
										Column: 27,
										Line:   174,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   174,
										},
										File:   "tickscript.flux",
										Source: "columns: [\"_measurement\"]",
										Start: ast.Position{
											Column: 27,
											Line:   174,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   174,
											},
											File:   "tickscript.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 27,
												Line:   174,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   174,
											},
											File:   "tickscript.flux",
											Source: "[\"_measurement\"]",
											Start: ast.Position{
												Column: 36,
												Line:   174,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   174,
												},
												File:   "tickscript.flux",
												Source: "\"_measurement\"",
												Start: ast.Position{
													Column: 37,
													Line:   174,
												},
											},
										},
										Value: "_measurement",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   174,
										},
										File:   "tickscript.flux",
										Source: "mode: \"extend\"",
										Start: ast.Position{
											Column: 54,
											Line:   174,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   174,
											},
											File:   "tickscript.flux",
											Source: "mode",
											Start: ast.Position{
												Column: 54,
												Line:   174,
											},
										},
									},
									Name: "mode",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   174,
											},
											File:   "tickscript.flux",
											Source: "\"extend\"",
											Start: ast.Position{
												Column: 60,
												Line:   174,
											},
										},
									},
									Value: "extend",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   174,
								},
								File:   "tickscript.flux",
								Source: "experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
								Start: ast.Position{
									Column: 8,
									Line:   174,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   174,
									},
									File:   "tickscript.flux",
									Source: "experimental.group",
									Start: ast.Position{
										Column: 8,
										Line:   174,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   174,
										},
										File:   "tickscript.flux",
										Source: "experimental",
										Start: ast.Position{
											Column: 8,
											Line:   174,
										},
									},
								},
								Name: "experimental",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   174,
										},
										File:   "tickscript.flux",
										Source: "group",
										Start: ast.Position{
											Column: 21,
											Line:   174,
										},
									},
								},
								Name: "group",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   171,
							},
							File:   "tickscript.flux",
							Source: "tables",
							Start: ast.Position{
								Column: 9,
								Line:   171,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   171,
								},
								File:   "tickscript.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 9,
									Line:   171,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   171,
							},
							File:   "tickscript.flux",
							Source: "on=[\"_time\"]",
							Start: ast.Position{
								Column: 17,
								Line:   171,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   171,
								},
								File:   "tickscript.flux",
								Source: "on",
								Start: ast.Position{
									Column: 17,
									Line:   171,
								},
							},
						},
						Name: "on",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   171,
								},
								File:   "tickscript.flux",
								Source: "[\"_time\"]",
								Start: ast.Position{
									Column: 20,
									Line:   171,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   171,
									},
									File:   "tickscript.flux",
									Source: "\"_time\"",
									Start: ast.Position{
										Column: 21,
										Line:   171,
									},
								},
							},
							Value: "_time",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   171,
							},
							File:   "tickscript.flux",
							Source: "measurement",
							Start: ast.Position{
								Column: 31,
								Line:   171,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   171,
								},
								File:   "tickscript.flux",
								Source: "measurement",
								Start: ast.Position{
									Column: 31,
									Line:   171,
								},
							},
						},
						Name: "measurement",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   4,
					},
					File:   "tickscript.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   4,
						},
						File:   "tickscript.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "experimental",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 28,
						Line:   5,
					},
					File:   "tickscript.flux",
					Source: "import \"experimental/array\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   5,
						},
						File:   "tickscript.flux",
						Source: "\"experimental/array\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "experimental/array",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   6,
					},
					File:   "tickscript.flux",
					Source: "import \"influxdata/influxdb\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   6,
						},
						File:   "tickscript.flux",
						Source: "\"influxdata/influxdb\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "influxdata/influxdb",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   7,
					},
					File:   "tickscript.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   7,
						},
						File:   "tickscript.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 36,
						Line:   8,
					},
					File:   "tickscript.flux",
					Source: "import \"influxdata/influxdb/schema\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   8,
						},
						File:   "tickscript.flux",
						Source: "\"influxdata/influxdb/schema\"",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				Value: "influxdata/influxdb/schema",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   9,
					},
					File:   "tickscript.flux",
					Source: "import \"universe\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   9,
						},
						File:   "tickscript.flux",
						Source: "\"universe\"",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				Value: "universe",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "tickscript.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   1,
					},
					File:   "tickscript.flux",
					Source: "package tickscript",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   1,
						},
						File:   "tickscript.flux",
						Source: "tickscript",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "tickscript",
			},
		},
	}},
	Package: "tickscript",
	Path:    "contrib/bonitoo-io/tickscript",
}
