// DO NOT EDIT: This file is autogenerated via the builtin command.

package webexteams

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 6,
					Line:   57,
				},
				File:   "webexteams.flux",
				Source: "package webexteams\n\n\nimport \"http\"\nimport \"json\"\n\n// `message` sends a single message to Webex Teams as described in [Webex Message API](https://developer.webex.com/docs/api/v1/messages/create-a-message). \n// `url` - string - base URL of Webex API endpoint without a trailing slash, \"https://webexapis.com\" by default.\n// `token` - string - [Webex API access token](https://developer.webex.com/docs/api/getting-started).\n// `roomId` - string - The room ID of the message, required.\n// `text` - string - the message, in plain text.\n// `markdown` - string - the message, in markdown format as explained in https://developer.webex.com/docs/api/basics\nmessage = (\n        url=\"https://webexapis.com\",\n        token,\n        roomId,\n        text,\n        markdown,\n) => {\n    data = {\n        text: text,\n        markdown: markdown,\n        roomId: roomId,\n    }\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"Bearer \" + token,\n    }\n\n    content = json.encode(v: data)\n\n    return http.post(headers: headers, url: url + \"/v1/messages\", data: content)\n}\n\n// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send message to Webex teams for each table row.\n// `url` - string - base URL of Webex API endpoint without a trailing slash, \"https://webexapis.com\" by default.\n// `token` - string - [Webex API access token](https://developer.webex.com/docs/api/getting-started).\n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` must return an object with `roomId`, `text` and `markdown` properties  as defined in the `message` function arguments.\nendpoint = (url=\"https://webexapis.com\", token) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   33,
					},
					File:   "webexteams.flux",
					Source: "message = (\n        url=\"https://webexapis.com\",\n        token,\n        roomId,\n        text,\n        markdown,\n) => {\n    data = {\n        text: text,\n        markdown: markdown,\n        roomId: roomId,\n    }\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"Bearer \" + token,\n    }\n\n    content = json.encode(v: data)\n\n    return http.post(headers: headers, url: url + \"/v1/messages\", data: content)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `message` sends a single message to Webex Teams as described in [Webex Message API](https://developer.webex.com/docs/api/v1/messages/create-a-message). \n"}, ast.Comment{Text: "// `url` - string - base URL of Webex API endpoint without a trailing slash, \"https://webexapis.com\" by default.\n"}, ast.Comment{Text: "// `token` - string - [Webex API access token](https://developer.webex.com/docs/api/getting-started).\n"}, ast.Comment{Text: "// `roomId` - string - The room ID of the message, required.\n"}, ast.Comment{Text: "// `text` - string - the message, in plain text.\n"}, ast.Comment{Text: "// `markdown` - string - the message, in markdown format as explained in https://developer.webex.com/docs/api/basics\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   13,
						},
						File:   "webexteams.flux",
						Source: "message",
						Start: ast.Position{
							Column: 1,
							Line:   13,
						},
					},
				},
				Name: "message",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   33,
						},
						File:   "webexteams.flux",
						Source: "(\n        url=\"https://webexapis.com\",\n        token,\n        roomId,\n        text,\n        markdown,\n) => {\n    data = {\n        text: text,\n        markdown: markdown,\n        roomId: roomId,\n    }\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"Bearer \" + token,\n    }\n\n    content = json.encode(v: data)\n\n    return http.post(headers: headers, url: url + \"/v1/messages\", data: content)\n}",
						Start: ast.Position{
							Column: 11,
							Line:   13,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   33,
							},
							File:   "webexteams.flux",
							Source: "{\n    data = {\n        text: text,\n        markdown: markdown,\n        roomId: roomId,\n    }\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"Bearer \" + token,\n    }\n\n    content = json.encode(v: data)\n\n    return http.post(headers: headers, url: url + \"/v1/messages\", data: content)\n}",
							Start: ast.Position{
								Column: 6,
								Line:   19,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   24,
								},
								File:   "webexteams.flux",
								Source: "data = {\n        text: text,\n        markdown: markdown,\n        roomId: roomId,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   20,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   20,
									},
									File:   "webexteams.flux",
									Source: "data",
									Start: ast.Position{
										Column: 5,
										Line:   20,
									},
								},
							},
							Name: "data",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   24,
									},
									File:   "webexteams.flux",
									Source: "{\n        text: text,\n        markdown: markdown,\n        roomId: roomId,\n    }",
									Start: ast.Position{
										Column: 12,
										Line:   20,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   21,
										},
										File:   "webexteams.flux",
										Source: "text: text",
										Start: ast.Position{
											Column: 9,
											Line:   21,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   21,
											},
											File:   "webexteams.flux",
											Source: "text",
											Start: ast.Position{
												Column: 9,
												Line:   21,
											},
										},
									},
									Name: "text",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   21,
											},
											File:   "webexteams.flux",
											Source: "text",
											Start: ast.Position{
												Column: 15,
												Line:   21,
											},
										},
									},
									Name: "text",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   22,
										},
										File:   "webexteams.flux",
										Source: "markdown: markdown",
										Start: ast.Position{
											Column: 9,
											Line:   22,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   22,
											},
											File:   "webexteams.flux",
											Source: "markdown",
											Start: ast.Position{
												Column: 9,
												Line:   22,
											},
										},
									},
									Name: "markdown",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   22,
											},
											File:   "webexteams.flux",
											Source: "markdown",
											Start: ast.Position{
												Column: 19,
												Line:   22,
											},
										},
									},
									Name: "markdown",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   23,
										},
										File:   "webexteams.flux",
										Source: "roomId: roomId",
										Start: ast.Position{
											Column: 9,
											Line:   23,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   23,
											},
											File:   "webexteams.flux",
											Source: "roomId",
											Start: ast.Position{
												Column: 9,
												Line:   23,
											},
										},
									},
									Name: "roomId",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   23,
											},
											File:   "webexteams.flux",
											Source: "roomId",
											Start: ast.Position{
												Column: 17,
												Line:   23,
											},
										},
									},
									Name: "roomId",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   28,
								},
								File:   "webexteams.flux",
								Source: "headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"Bearer \" + token,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   25,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   25,
									},
									File:   "webexteams.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   25,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   28,
									},
									File:   "webexteams.flux",
									Source: "{\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"Bearer \" + token,\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   25,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   26,
										},
										File:   "webexteams.flux",
										Source: "\"Content-Type\": \"application/json; charset=utf-8\"",
										Start: ast.Position{
											Column: 9,
											Line:   26,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   26,
											},
											File:   "webexteams.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   26,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   26,
											},
											File:   "webexteams.flux",
											Source: "\"application/json; charset=utf-8\"",
											Start: ast.Position{
												Column: 25,
												Line:   26,
											},
										},
									},
									Value: "application/json; charset=utf-8",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   27,
										},
										File:   "webexteams.flux",
										Source: "\"Authorization\": \"Bearer \" + token",
										Start: ast.Position{
											Column: 9,
											Line:   27,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   27,
											},
											File:   "webexteams.flux",
											Source: "\"Authorization\"",
											Start: ast.Position{
												Column: 9,
												Line:   27,
											},
										},
									},
									Value: "Authorization",
								},
								Separator: nil,
								Value: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   27,
											},
											File:   "webexteams.flux",
											Source: "\"Bearer \" + token",
											Start: ast.Position{
												Column: 26,
												Line:   27,
											},
										},
									},
									Left: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   27,
												},
												File:   "webexteams.flux",
												Source: "\"Bearer \"",
												Start: ast.Position{
													Column: 26,
													Line:   27,
												},
											},
										},
										Value: "Bearer ",
									},
									Operator: 5,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   27,
												},
												File:   "webexteams.flux",
												Source: "token",
												Start: ast.Position{
													Column: 38,
													Line:   27,
												},
											},
										},
										Name: "token",
									},
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   30,
								},
								File:   "webexteams.flux",
								Source: "content = json.encode(v: data)",
								Start: ast.Position{
									Column: 5,
									Line:   30,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   30,
									},
									File:   "webexteams.flux",
									Source: "content",
									Start: ast.Position{
										Column: 5,
										Line:   30,
									},
								},
							},
							Name: "content",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   30,
										},
										File:   "webexteams.flux",
										Source: "v: data",
										Start: ast.Position{
											Column: 27,
											Line:   30,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   30,
											},
											File:   "webexteams.flux",
											Source: "v: data",
											Start: ast.Position{
												Column: 27,
												Line:   30,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   30,
												},
												File:   "webexteams.flux",
												Source: "v",
												Start: ast.Position{
													Column: 27,
													Line:   30,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   30,
												},
												File:   "webexteams.flux",
												Source: "data",
												Start: ast.Position{
													Column: 30,
													Line:   30,
												},
											},
										},
										Name: "data",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   30,
									},
									File:   "webexteams.flux",
									Source: "json.encode(v: data)",
									Start: ast.Position{
										Column: 15,
										Line:   30,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   30,
										},
										File:   "webexteams.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 15,
											Line:   30,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   30,
											},
											File:   "webexteams.flux",
											Source: "json",
											Start: ast.Position{
												Column: 15,
												Line:   30,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   30,
											},
											File:   "webexteams.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 20,
												Line:   30,
											},
										},
									},
									Name: "encode",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   32,
										},
										File:   "webexteams.flux",
										Source: "headers: headers, url: url + \"/v1/messages\", data: content",
										Start: ast.Position{
											Column: 22,
											Line:   32,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   32,
											},
											File:   "webexteams.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   32,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   32,
												},
												File:   "webexteams.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   32,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   32,
												},
												File:   "webexteams.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   32,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   32,
											},
											File:   "webexteams.flux",
											Source: "url: url + \"/v1/messages\"",
											Start: ast.Position{
												Column: 40,
												Line:   32,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   32,
												},
												File:   "webexteams.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   32,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   32,
												},
												File:   "webexteams.flux",
												Source: "url + \"/v1/messages\"",
												Start: ast.Position{
													Column: 45,
													Line:   32,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   32,
													},
													File:   "webexteams.flux",
													Source: "url",
													Start: ast.Position{
														Column: 45,
														Line:   32,
													},
												},
											},
											Name: "url",
										},
										Operator: 5,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   32,
													},
													File:   "webexteams.flux",
													Source: "\"/v1/messages\"",
													Start: ast.Position{
														Column: 51,
														Line:   32,
													},
												},
											},
											Value: "/v1/messages",
										},
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   32,
											},
											File:   "webexteams.flux",
											Source: "data: content",
											Start: ast.Position{
												Column: 67,
												Line:   32,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   32,
												},
												File:   "webexteams.flux",
												Source: "data",
												Start: ast.Position{
													Column: 67,
													Line:   32,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   32,
												},
												File:   "webexteams.flux",
												Source: "content",
												Start: ast.Position{
													Column: 73,
													Line:   32,
												},
											},
										},
										Name: "content",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   32,
									},
									File:   "webexteams.flux",
									Source: "http.post(headers: headers, url: url + \"/v1/messages\", data: content)",
									Start: ast.Position{
										Column: 12,
										Line:   32,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   32,
										},
										File:   "webexteams.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   32,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   32,
											},
											File:   "webexteams.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   32,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   32,
											},
											File:   "webexteams.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   32,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   32,
								},
								File:   "webexteams.flux",
								Source: "return http.post(headers: headers, url: url + \"/v1/messages\", data: content)",
								Start: ast.Position{
									Column: 5,
									Line:   32,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   14,
							},
							File:   "webexteams.flux",
							Source: "url=\"https://webexapis.com\"",
							Start: ast.Position{
								Column: 9,
								Line:   14,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   14,
								},
								File:   "webexteams.flux",
								Source: "url",
								Start: ast.Position{
									Column: 9,
									Line:   14,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   14,
								},
								File:   "webexteams.flux",
								Source: "\"https://webexapis.com\"",
								Start: ast.Position{
									Column: 13,
									Line:   14,
								},
							},
						},
						Value: "https://webexapis.com",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   15,
							},
							File:   "webexteams.flux",
							Source: "token",
							Start: ast.Position{
								Column: 9,
								Line:   15,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   15,
								},
								File:   "webexteams.flux",
								Source: "token",
								Start: ast.Position{
									Column: 9,
									Line:   15,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   16,
							},
							File:   "webexteams.flux",
							Source: "roomId",
							Start: ast.Position{
								Column: 9,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   16,
								},
								File:   "webexteams.flux",
								Source: "roomId",
								Start: ast.Position{
									Column: 9,
									Line:   16,
								},
							},
						},
						Name: "roomId",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   17,
							},
							File:   "webexteams.flux",
							Source: "text",
							Start: ast.Position{
								Column: 9,
								Line:   17,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   17,
								},
								File:   "webexteams.flux",
								Source: "text",
								Start: ast.Position{
									Column: 9,
									Line:   17,
								},
							},
						},
						Name: "text",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   18,
							},
							File:   "webexteams.flux",
							Source: "markdown",
							Start: ast.Position{
								Column: 9,
								Line:   18,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   18,
								},
								File:   "webexteams.flux",
								Source: "markdown",
								Start: ast.Position{
									Column: 9,
									Line:   18,
								},
							},
						},
						Name: "markdown",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   57,
					},
					File:   "webexteams.flux",
					Source: "endpoint = (url=\"https://webexapis.com\", token) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send message to Webex teams for each table row.\n"}, ast.Comment{Text: "// `url` - string - base URL of Webex API endpoint without a trailing slash, \"https://webexapis.com\" by default.\n"}, ast.Comment{Text: "// `token` - string - [Webex API access token](https://developer.webex.com/docs/api/getting-started).\n"}, ast.Comment{Text: "// The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "// The `mapFn` must return an object with `roomId`, `text` and `markdown` properties  as defined in the `message` function arguments.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   40,
						},
						File:   "webexteams.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   40,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   57,
						},
						File:   "webexteams.flux",
						Source: "(url=\"https://webexapis.com\", token) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
						Start: ast.Position{
							Column: 12,
							Line:   40,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   57,
							},
							File:   "webexteams.flux",
							Source: "(mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
							Start: ast.Position{
								Column: 52,
								Line:   40,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   57,
								},
								File:   "webexteams.flux",
								Source: "(tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
								Start: ast.Position{
									Column: 63,
									Line:   40,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   40,
										},
										File:   "webexteams.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 78,
											Line:   40,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   57,
									},
									File:   "webexteams.flux",
									Source: "tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
									Start: ast.Position{
										Column: 78,
										Line:   40,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   56,
											},
											File:   "webexteams.flux",
											Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100,\n                ),\n            }\n        }",
											Start: ast.Position{
												Column: 9,
												Line:   42,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   56,
												},
												File:   "webexteams.flux",
												Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100,\n                ),\n            }\n        }",
												Start: ast.Position{
													Column: 9,
													Line:   42,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   42,
													},
													File:   "webexteams.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   42,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   56,
													},
													File:   "webexteams.flux",
													Source: "(r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100,\n                ),\n            }\n        }",
													Start: ast.Position{
														Column: 13,
														Line:   42,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   56,
														},
														File:   "webexteams.flux",
														Source: "{\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100,\n                ),\n            }\n        }",
														Start: ast.Position{
															Column: 20,
															Line:   42,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   43,
															},
															File:   "webexteams.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 13,
																Line:   43,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   43,
																},
																File:   "webexteams.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 13,
																	Line:   43,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   43,
																	},
																	File:   "webexteams.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   43,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   43,
																		},
																		File:   "webexteams.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 25,
																			Line:   43,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   43,
																			},
																			File:   "webexteams.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 25,
																				Line:   43,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   43,
																			},
																			File:   "webexteams.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 28,
																				Line:   43,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   43,
																},
																File:   "webexteams.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 19,
																	Line:   43,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   43,
																	},
																	File:   "webexteams.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 19,
																		Line:   43,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   55,
																},
																File:   "webexteams.flux",
																Source: "{r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100,\n                ),\n            }",
																Start: ast.Position{
																	Column: 20,
																	Line:   45,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   54,
																	},
																	File:   "webexteams.flux",
																	Source: "_sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100,\n                )",
																	Start: ast.Position{
																		Column: 17,
																		Line:   46,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   46,
																		},
																		File:   "webexteams.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 17,
																			Line:   46,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   53,
																			},
																			File:   "webexteams.flux",
																			Source: "v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100",
																			Start: ast.Position{
																				Column: 21,
																				Line:   47,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   53,
																				},
																				File:   "webexteams.flux",
																				Source: "v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100",
																				Start: ast.Position{
																					Column: 21,
																					Line:   47,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   47,
																					},
																					File:   "webexteams.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 21,
																						Line:   47,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 28,
																						Line:   53,
																					},
																					File:   "webexteams.flux",
																					Source: "2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100",
																					Start: ast.Position{
																						Column: 24,
																						Line:   47,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   47,
																						},
																						File:   "webexteams.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 24,
																							Line:   47,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 28,
																							Line:   53,
																						},
																						File:   "webexteams.flux",
																						Source: "message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100",
																						Start: ast.Position{
																							Column: 29,
																							Line:   47,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 47,
																									Line:   52,
																								},
																								File:   "webexteams.flux",
																								Source: "url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown",
																								Start: ast.Position{
																									Column: 25,
																									Line:   48,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 33,
																										Line:   48,
																									},
																									File:   "webexteams.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 25,
																										Line:   48,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   48,
																										},
																										File:   "webexteams.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 25,
																											Line:   48,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   48,
																										},
																										File:   "webexteams.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 30,
																											Line:   48,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 37,
																										Line:   49,
																									},
																									File:   "webexteams.flux",
																									Source: "token: token",
																									Start: ast.Position{
																										Column: 25,
																										Line:   49,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   49,
																										},
																										File:   "webexteams.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 25,
																											Line:   49,
																										},
																									},
																								},
																								Name: "token",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   49,
																										},
																										File:   "webexteams.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 32,
																											Line:   49,
																										},
																									},
																								},
																								Name: "token",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 43,
																										Line:   50,
																									},
																									File:   "webexteams.flux",
																									Source: "roomId: obj.roomId",
																									Start: ast.Position{
																										Column: 25,
																										Line:   50,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   50,
																										},
																										File:   "webexteams.flux",
																										Source: "roomId",
																										Start: ast.Position{
																											Column: 25,
																											Line:   50,
																										},
																									},
																								},
																								Name: "roomId",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 43,
																											Line:   50,
																										},
																										File:   "webexteams.flux",
																										Source: "obj.roomId",
																										Start: ast.Position{
																											Column: 33,
																											Line:   50,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 36,
																												Line:   50,
																											},
																											File:   "webexteams.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 33,
																												Line:   50,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 43,
																												Line:   50,
																											},
																											File:   "webexteams.flux",
																											Source: "roomId",
																											Start: ast.Position{
																												Column: 37,
																												Line:   50,
																											},
																										},
																									},
																									Name: "roomId",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   51,
																									},
																									File:   "webexteams.flux",
																									Source: "text: obj.text",
																									Start: ast.Position{
																										Column: 25,
																										Line:   51,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   51,
																										},
																										File:   "webexteams.flux",
																										Source: "text",
																										Start: ast.Position{
																											Column: 25,
																											Line:   51,
																										},
																									},
																								},
																								Name: "text",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   51,
																										},
																										File:   "webexteams.flux",
																										Source: "obj.text",
																										Start: ast.Position{
																											Column: 31,
																											Line:   51,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 34,
																												Line:   51,
																											},
																											File:   "webexteams.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 31,
																												Line:   51,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   51,
																											},
																											File:   "webexteams.flux",
																											Source: "text",
																											Start: ast.Position{
																												Column: 35,
																												Line:   51,
																											},
																										},
																									},
																									Name: "text",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 47,
																										Line:   52,
																									},
																									File:   "webexteams.flux",
																									Source: "markdown: obj.markdown",
																									Start: ast.Position{
																										Column: 25,
																										Line:   52,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   52,
																										},
																										File:   "webexteams.flux",
																										Source: "markdown",
																										Start: ast.Position{
																											Column: 25,
																											Line:   52,
																										},
																									},
																								},
																								Name: "markdown",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 47,
																											Line:   52,
																										},
																										File:   "webexteams.flux",
																										Source: "obj.markdown",
																										Start: ast.Position{
																											Column: 35,
																											Line:   52,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 38,
																												Line:   52,
																											},
																											File:   "webexteams.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 35,
																												Line:   52,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 47,
																												Line:   52,
																											},
																											File:   "webexteams.flux",
																											Source: "markdown",
																											Start: ast.Position{
																												Column: 39,
																												Line:   52,
																											},
																										},
																									},
																									Name: "markdown",
																								},
																								Rbrack: nil,
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   53,
																							},
																							File:   "webexteams.flux",
																							Source: "message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    )",
																							Start: ast.Position{
																								Column: 29,
																								Line:   47,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 36,
																									Line:   47,
																								},
																								File:   "webexteams.flux",
																								Source: "message",
																								Start: ast.Position{
																									Column: 29,
																									Line:   47,
																								},
																							},
																						},
																						Name: "message",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 28,
																								Line:   53,
																							},
																							File:   "webexteams.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 25,
																								Line:   53,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   54,
																		},
																		File:   "webexteams.flux",
																		Source: "string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100,\n                )",
																		Start: ast.Position{
																			Column: 24,
																			Line:   46,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   46,
																			},
																			File:   "webexteams.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 24,
																				Line:   46,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   45,
																	},
																	File:   "webexteams.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   45,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   55,
															},
															File:   "webexteams.flux",
															Source: "return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100,\n                ),\n            }",
															Start: ast.Position{
																Column: 13,
																Line:   45,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   42,
														},
														File:   "webexteams.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   42,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   42,
															},
															File:   "webexteams.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   42,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   57,
										},
										File:   "webexteams.flux",
										Source: "map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        roomId: obj.roomId,\n                        text: obj.text,\n                        markdown: obj.markdown,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   41,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   41,
											},
											File:   "webexteams.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   41,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 73,
										Line:   40,
									},
									File:   "webexteams.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 64,
										Line:   40,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   40,
										},
										File:   "webexteams.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 64,
											Line:   40,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 73,
										Line:   40,
									},
									File:   "webexteams.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 71,
										Line:   40,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   40,
								},
								File:   "webexteams.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 53,
									Line:   40,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   40,
									},
									File:   "webexteams.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 53,
										Line:   40,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   40,
							},
							File:   "webexteams.flux",
							Source: "url=\"https://webexapis.com\"",
							Start: ast.Position{
								Column: 13,
								Line:   40,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   40,
								},
								File:   "webexteams.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   40,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   40,
								},
								File:   "webexteams.flux",
								Source: "\"https://webexapis.com\"",
								Start: ast.Position{
									Column: 17,
									Line:   40,
								},
							},
						},
						Value: "https://webexapis.com",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   40,
							},
							File:   "webexteams.flux",
							Source: "token",
							Start: ast.Position{
								Column: 42,
								Line:   40,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   40,
								},
								File:   "webexteams.flux",
								Source: "token",
								Start: ast.Position{
									Column: 42,
									Line:   40,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "webexteams.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "webexteams.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "webexteams.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "webexteams.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "json",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "webexteams.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   1,
					},
					File:   "webexteams.flux",
					Source: "package webexteams",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   1,
						},
						File:   "webexteams.flux",
						Source: "webexteams",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "webexteams",
			},
		},
	}},
	Package: "webexteams",
	Path:    "contrib/sranka/webexteams",
}
