// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAllocateStaticIp = "AllocateStaticIp"

// AllocateStaticIpRequest generates a "aws/request.Request" representing the
// client's request for the AllocateStaticIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocateStaticIp for more information on using the AllocateStaticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AllocateStaticIpRequest method.
//    req, resp := client.AllocateStaticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIp
func (c *Lightsail) AllocateStaticIpRequest(input *AllocateStaticIpInput) (req *request.Request, output *AllocateStaticIpOutput) {
	op := &request.Operation{
		Name:       opAllocateStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateStaticIpInput{}
	}

	output = &AllocateStaticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateStaticIp API operation for Amazon Lightsail.
//
// Allocates a static IP address.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation AllocateStaticIp for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIp
func (c *Lightsail) AllocateStaticIp(input *AllocateStaticIpInput) (*AllocateStaticIpOutput, error) {
	req, out := c.AllocateStaticIpRequest(input)
	return out, req.Send()
}

// AllocateStaticIpWithContext is the same as AllocateStaticIp with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateStaticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) AllocateStaticIpWithContext(ctx aws.Context, input *AllocateStaticIpInput, opts ...request.Option) (*AllocateStaticIpOutput, error) {
	req, out := c.AllocateStaticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachCertificateToDistribution = "AttachCertificateToDistribution"

// AttachCertificateToDistributionRequest generates a "aws/request.Request" representing the
// client's request for the AttachCertificateToDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachCertificateToDistribution for more information on using the AttachCertificateToDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachCertificateToDistributionRequest method.
//    req, resp := client.AttachCertificateToDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachCertificateToDistribution
func (c *Lightsail) AttachCertificateToDistributionRequest(input *AttachCertificateToDistributionInput) (req *request.Request, output *AttachCertificateToDistributionOutput) {
	op := &request.Operation{
		Name:       opAttachCertificateToDistribution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachCertificateToDistributionInput{}
	}

	output = &AttachCertificateToDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachCertificateToDistribution API operation for Amazon Lightsail.
//
// Attaches an SSL/TLS certificate to your Amazon Lightsail content delivery
// network (CDN) distribution.
//
// After the certificate is attached, your distribution accepts HTTPS traffic
// for all of the domains that are associated with the certificate.
//
// Use the CreateCertificate action to create a certificate that you can attach
// to your distribution.
//
// Only certificates created in the us-east-1 AWS Region can be attached to
// Lightsail distributions. Lightsail distributions are global resources that
// can reference an origin in any AWS Region, and distribute its content globally.
// However, all distributions are located in the us-east-1 Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation AttachCertificateToDistribution for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachCertificateToDistribution
func (c *Lightsail) AttachCertificateToDistribution(input *AttachCertificateToDistributionInput) (*AttachCertificateToDistributionOutput, error) {
	req, out := c.AttachCertificateToDistributionRequest(input)
	return out, req.Send()
}

// AttachCertificateToDistributionWithContext is the same as AttachCertificateToDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See AttachCertificateToDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) AttachCertificateToDistributionWithContext(ctx aws.Context, input *AttachCertificateToDistributionInput, opts ...request.Option) (*AttachCertificateToDistributionOutput, error) {
	req, out := c.AttachCertificateToDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachDisk = "AttachDisk"

// AttachDiskRequest generates a "aws/request.Request" representing the
// client's request for the AttachDisk operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachDisk for more information on using the AttachDisk
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachDiskRequest method.
//    req, resp := client.AttachDiskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachDisk
func (c *Lightsail) AttachDiskRequest(input *AttachDiskInput) (req *request.Request, output *AttachDiskOutput) {
	op := &request.Operation{
		Name:       opAttachDisk,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachDiskInput{}
	}

	output = &AttachDiskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachDisk API operation for Amazon Lightsail.
//
// Attaches a block storage disk to a running or stopped Lightsail instance
// and exposes it to the instance with the specified disk name.
//
// The attach disk operation supports tag-based access control via resource
// tags applied to the resource identified by disk name. For more information,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation AttachDisk for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachDisk
func (c *Lightsail) AttachDisk(input *AttachDiskInput) (*AttachDiskOutput, error) {
	req, out := c.AttachDiskRequest(input)
	return out, req.Send()
}

// AttachDiskWithContext is the same as AttachDisk with the addition of
// the ability to pass a context and additional request options.
//
// See AttachDisk for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) AttachDiskWithContext(ctx aws.Context, input *AttachDiskInput, opts ...request.Option) (*AttachDiskOutput, error) {
	req, out := c.AttachDiskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachInstancesToLoadBalancer = "AttachInstancesToLoadBalancer"

// AttachInstancesToLoadBalancerRequest generates a "aws/request.Request" representing the
// client's request for the AttachInstancesToLoadBalancer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachInstancesToLoadBalancer for more information on using the AttachInstancesToLoadBalancer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachInstancesToLoadBalancerRequest method.
//    req, resp := client.AttachInstancesToLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachInstancesToLoadBalancer
func (c *Lightsail) AttachInstancesToLoadBalancerRequest(input *AttachInstancesToLoadBalancerInput) (req *request.Request, output *AttachInstancesToLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opAttachInstancesToLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachInstancesToLoadBalancerInput{}
	}

	output = &AttachInstancesToLoadBalancerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachInstancesToLoadBalancer API operation for Amazon Lightsail.
//
// Attaches one or more Lightsail instances to a load balancer.
//
// After some time, the instances are attached to the load balancer and the
// health check status is available.
//
// The attach instances to load balancer operation supports tag-based access
// control via resource tags applied to the resource identified by load balancer
// name. For more information, see the Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation AttachInstancesToLoadBalancer for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachInstancesToLoadBalancer
func (c *Lightsail) AttachInstancesToLoadBalancer(input *AttachInstancesToLoadBalancerInput) (*AttachInstancesToLoadBalancerOutput, error) {
	req, out := c.AttachInstancesToLoadBalancerRequest(input)
	return out, req.Send()
}

// AttachInstancesToLoadBalancerWithContext is the same as AttachInstancesToLoadBalancer with the addition of
// the ability to pass a context and additional request options.
//
// See AttachInstancesToLoadBalancer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) AttachInstancesToLoadBalancerWithContext(ctx aws.Context, input *AttachInstancesToLoadBalancerInput, opts ...request.Option) (*AttachInstancesToLoadBalancerOutput, error) {
	req, out := c.AttachInstancesToLoadBalancerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachLoadBalancerTlsCertificate = "AttachLoadBalancerTlsCertificate"

// AttachLoadBalancerTlsCertificateRequest generates a "aws/request.Request" representing the
// client's request for the AttachLoadBalancerTlsCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachLoadBalancerTlsCertificate for more information on using the AttachLoadBalancerTlsCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachLoadBalancerTlsCertificateRequest method.
//    req, resp := client.AttachLoadBalancerTlsCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachLoadBalancerTlsCertificate
func (c *Lightsail) AttachLoadBalancerTlsCertificateRequest(input *AttachLoadBalancerTlsCertificateInput) (req *request.Request, output *AttachLoadBalancerTlsCertificateOutput) {
	op := &request.Operation{
		Name:       opAttachLoadBalancerTlsCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachLoadBalancerTlsCertificateInput{}
	}

	output = &AttachLoadBalancerTlsCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachLoadBalancerTlsCertificate API operation for Amazon Lightsail.
//
// Attaches a Transport Layer Security (TLS) certificate to your load balancer.
// TLS is just an updated, more secure version of Secure Socket Layer (SSL).
//
// Once you create and validate your certificate, you can attach it to your
// load balancer. You can also use this API to rotate the certificates on your
// account. Use the AttachLoadBalancerTlsCertificate action with the non-attached
// certificate, and it will replace the existing one and become the attached
// certificate.
//
// The AttachLoadBalancerTlsCertificate operation supports tag-based access
// control via resource tags applied to the resource identified by load balancer
// name. For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation AttachLoadBalancerTlsCertificate for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachLoadBalancerTlsCertificate
func (c *Lightsail) AttachLoadBalancerTlsCertificate(input *AttachLoadBalancerTlsCertificateInput) (*AttachLoadBalancerTlsCertificateOutput, error) {
	req, out := c.AttachLoadBalancerTlsCertificateRequest(input)
	return out, req.Send()
}

// AttachLoadBalancerTlsCertificateWithContext is the same as AttachLoadBalancerTlsCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See AttachLoadBalancerTlsCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) AttachLoadBalancerTlsCertificateWithContext(ctx aws.Context, input *AttachLoadBalancerTlsCertificateInput, opts ...request.Option) (*AttachLoadBalancerTlsCertificateOutput, error) {
	req, out := c.AttachLoadBalancerTlsCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachStaticIp = "AttachStaticIp"

// AttachStaticIpRequest generates a "aws/request.Request" representing the
// client's request for the AttachStaticIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachStaticIp for more information on using the AttachStaticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachStaticIpRequest method.
//    req, resp := client.AttachStaticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp
func (c *Lightsail) AttachStaticIpRequest(input *AttachStaticIpInput) (req *request.Request, output *AttachStaticIpOutput) {
	op := &request.Operation{
		Name:       opAttachStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachStaticIpInput{}
	}

	output = &AttachStaticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachStaticIp API operation for Amazon Lightsail.
//
// Attaches a static IP address to a specific Amazon Lightsail instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation AttachStaticIp for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp
func (c *Lightsail) AttachStaticIp(input *AttachStaticIpInput) (*AttachStaticIpOutput, error) {
	req, out := c.AttachStaticIpRequest(input)
	return out, req.Send()
}

// AttachStaticIpWithContext is the same as AttachStaticIp with the addition of
// the ability to pass a context and additional request options.
//
// See AttachStaticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) AttachStaticIpWithContext(ctx aws.Context, input *AttachStaticIpInput, opts ...request.Option) (*AttachStaticIpOutput, error) {
	req, out := c.AttachStaticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCloseInstancePublicPorts = "CloseInstancePublicPorts"

// CloseInstancePublicPortsRequest generates a "aws/request.Request" representing the
// client's request for the CloseInstancePublicPorts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CloseInstancePublicPorts for more information on using the CloseInstancePublicPorts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CloseInstancePublicPortsRequest method.
//    req, resp := client.CloseInstancePublicPortsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPorts
func (c *Lightsail) CloseInstancePublicPortsRequest(input *CloseInstancePublicPortsInput) (req *request.Request, output *CloseInstancePublicPortsOutput) {
	op := &request.Operation{
		Name:       opCloseInstancePublicPorts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CloseInstancePublicPortsInput{}
	}

	output = &CloseInstancePublicPortsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CloseInstancePublicPorts API operation for Amazon Lightsail.
//
// Closes ports for a specific Amazon Lightsail instance.
//
// The CloseInstancePublicPorts action supports tag-based access control via
// resource tags applied to the resource identified by instanceName. For more
// information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CloseInstancePublicPorts for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPorts
func (c *Lightsail) CloseInstancePublicPorts(input *CloseInstancePublicPortsInput) (*CloseInstancePublicPortsOutput, error) {
	req, out := c.CloseInstancePublicPortsRequest(input)
	return out, req.Send()
}

// CloseInstancePublicPortsWithContext is the same as CloseInstancePublicPorts with the addition of
// the ability to pass a context and additional request options.
//
// See CloseInstancePublicPorts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CloseInstancePublicPortsWithContext(ctx aws.Context, input *CloseInstancePublicPortsInput, opts ...request.Option) (*CloseInstancePublicPortsOutput, error) {
	req, out := c.CloseInstancePublicPortsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopySnapshot = "CopySnapshot"

// CopySnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CopySnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopySnapshot for more information on using the CopySnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopySnapshotRequest method.
//    req, resp := client.CopySnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CopySnapshot
func (c *Lightsail) CopySnapshotRequest(input *CopySnapshotInput) (req *request.Request, output *CopySnapshotOutput) {
	op := &request.Operation{
		Name:       opCopySnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopySnapshotInput{}
	}

	output = &CopySnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopySnapshot API operation for Amazon Lightsail.
//
// Copies a manual snapshot of an instance or disk as another manual snapshot,
// or copies an automatic snapshot of an instance or disk as a manual snapshot.
// This operation can also be used to copy a manual or automatic snapshot of
// an instance or a disk from one AWS Region to another in Amazon Lightsail.
//
// When copying a manual snapshot, be sure to define the source region, source
// snapshot name, and target snapshot name parameters.
//
// When copying an automatic snapshot, be sure to define the source region,
// source resource name, target snapshot name, and either the restore date or
// the use latest restorable auto snapshot parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CopySnapshot for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CopySnapshot
func (c *Lightsail) CopySnapshot(input *CopySnapshotInput) (*CopySnapshotOutput, error) {
	req, out := c.CopySnapshotRequest(input)
	return out, req.Send()
}

// CopySnapshotWithContext is the same as CopySnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CopySnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CopySnapshotWithContext(ctx aws.Context, input *CopySnapshotInput, opts ...request.Option) (*CopySnapshotOutput, error) {
	req, out := c.CopySnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBucket = "CreateBucket"

// CreateBucketRequest generates a "aws/request.Request" representing the
// client's request for the CreateBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBucket for more information on using the CreateBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBucketRequest method.
//    req, resp := client.CreateBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateBucket
func (c *Lightsail) CreateBucketRequest(input *CreateBucketInput) (req *request.Request, output *CreateBucketOutput) {
	op := &request.Operation{
		Name:       opCreateBucket,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBucketInput{}
	}

	output = &CreateBucketOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBucket API operation for Amazon Lightsail.
//
// Creates an Amazon Lightsail bucket.
//
// A bucket is a cloud storage resource available in the Lightsail object storage
// service. Use buckets to store objects such as data and its descriptive metadata.
// For more information about buckets, see Buckets in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/buckets-in-amazon-lightsail)
// in the Amazon Lightsail Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateBucket for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * ServiceException
//   A general service exception.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateBucket
func (c *Lightsail) CreateBucket(input *CreateBucketInput) (*CreateBucketOutput, error) {
	req, out := c.CreateBucketRequest(input)
	return out, req.Send()
}

// CreateBucketWithContext is the same as CreateBucket with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateBucketWithContext(ctx aws.Context, input *CreateBucketInput, opts ...request.Option) (*CreateBucketOutput, error) {
	req, out := c.CreateBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBucketAccessKey = "CreateBucketAccessKey"

// CreateBucketAccessKeyRequest generates a "aws/request.Request" representing the
// client's request for the CreateBucketAccessKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBucketAccessKey for more information on using the CreateBucketAccessKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBucketAccessKeyRequest method.
//    req, resp := client.CreateBucketAccessKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateBucketAccessKey
func (c *Lightsail) CreateBucketAccessKeyRequest(input *CreateBucketAccessKeyInput) (req *request.Request, output *CreateBucketAccessKeyOutput) {
	op := &request.Operation{
		Name:       opCreateBucketAccessKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBucketAccessKeyInput{}
	}

	output = &CreateBucketAccessKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBucketAccessKey API operation for Amazon Lightsail.
//
// Creates a new access key for the specified Amazon Lightsail bucket. Access
// keys consist of an access key ID and corresponding secret access key.
//
// Access keys grant full programmatic access to the specified bucket and its
// objects. You can have a maximum of two access keys per bucket. Use the GetBucketAccessKeys
// action to get a list of current access keys for a specific bucket. For more
// information about access keys, see Creating access keys for a bucket in Amazon
// Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys)
// in the Amazon Lightsail Developer Guide.
//
// The secretAccessKey value is returned only in response to the CreateBucketAccessKey
// action. You can get a secret access key only when you first create an access
// key; you cannot get the secret access key later. If you lose the secret access
// key, you must create a new access key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateBucketAccessKey for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * ServiceException
//   A general service exception.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateBucketAccessKey
func (c *Lightsail) CreateBucketAccessKey(input *CreateBucketAccessKeyInput) (*CreateBucketAccessKeyOutput, error) {
	req, out := c.CreateBucketAccessKeyRequest(input)
	return out, req.Send()
}

// CreateBucketAccessKeyWithContext is the same as CreateBucketAccessKey with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBucketAccessKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateBucketAccessKeyWithContext(ctx aws.Context, input *CreateBucketAccessKeyInput, opts ...request.Option) (*CreateBucketAccessKeyOutput, error) {
	req, out := c.CreateBucketAccessKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCertificate = "CreateCertificate"

// CreateCertificateRequest generates a "aws/request.Request" representing the
// client's request for the CreateCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCertificate for more information on using the CreateCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCertificateRequest method.
//    req, resp := client.CreateCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateCertificate
func (c *Lightsail) CreateCertificateRequest(input *CreateCertificateInput) (req *request.Request, output *CreateCertificateOutput) {
	op := &request.Operation{
		Name:       opCreateCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCertificateInput{}
	}

	output = &CreateCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCertificate API operation for Amazon Lightsail.
//
// Creates an SSL/TLS certificate for an Amazon Lightsail content delivery network
// (CDN) distribution and a container service.
//
// After the certificate is valid, use the AttachCertificateToDistribution action
// to use the certificate and its domains with your distribution. Or use the
// UpdateContainerService action to use the certificate and its domains with
// your container service.
//
// Only certificates created in the us-east-1 AWS Region can be attached to
// Lightsail distributions. Lightsail distributions are global resources that
// can reference an origin in any AWS Region, and distribute its content globally.
// However, all distributions are located in the us-east-1 Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateCertificate for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateCertificate
func (c *Lightsail) CreateCertificate(input *CreateCertificateInput) (*CreateCertificateOutput, error) {
	req, out := c.CreateCertificateRequest(input)
	return out, req.Send()
}

// CreateCertificateWithContext is the same as CreateCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateCertificateWithContext(ctx aws.Context, input *CreateCertificateInput, opts ...request.Option) (*CreateCertificateOutput, error) {
	req, out := c.CreateCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCloudFormationStack = "CreateCloudFormationStack"

// CreateCloudFormationStackRequest generates a "aws/request.Request" representing the
// client's request for the CreateCloudFormationStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCloudFormationStack for more information on using the CreateCloudFormationStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCloudFormationStackRequest method.
//    req, resp := client.CreateCloudFormationStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateCloudFormationStack
func (c *Lightsail) CreateCloudFormationStackRequest(input *CreateCloudFormationStackInput) (req *request.Request, output *CreateCloudFormationStackOutput) {
	op := &request.Operation{
		Name:       opCreateCloudFormationStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCloudFormationStackInput{}
	}

	output = &CreateCloudFormationStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCloudFormationStack API operation for Amazon Lightsail.
//
// Creates an AWS CloudFormation stack, which creates a new Amazon EC2 instance
// from an exported Amazon Lightsail snapshot. This operation results in a CloudFormation
// stack record that can be used to track the AWS CloudFormation stack created.
// Use the get cloud formation stack records operation to get a list of the
// CloudFormation stacks created.
//
// Wait until after your new Amazon EC2 instance is created before running the
// create cloud formation stack operation again with the same export snapshot
// record.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateCloudFormationStack for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateCloudFormationStack
func (c *Lightsail) CreateCloudFormationStack(input *CreateCloudFormationStackInput) (*CreateCloudFormationStackOutput, error) {
	req, out := c.CreateCloudFormationStackRequest(input)
	return out, req.Send()
}

// CreateCloudFormationStackWithContext is the same as CreateCloudFormationStack with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCloudFormationStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateCloudFormationStackWithContext(ctx aws.Context, input *CreateCloudFormationStackInput, opts ...request.Option) (*CreateCloudFormationStackOutput, error) {
	req, out := c.CreateCloudFormationStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateContactMethod = "CreateContactMethod"

// CreateContactMethodRequest generates a "aws/request.Request" representing the
// client's request for the CreateContactMethod operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContactMethod for more information on using the CreateContactMethod
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateContactMethodRequest method.
//    req, resp := client.CreateContactMethodRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContactMethod
func (c *Lightsail) CreateContactMethodRequest(input *CreateContactMethodInput) (req *request.Request, output *CreateContactMethodOutput) {
	op := &request.Operation{
		Name:       opCreateContactMethod,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateContactMethodInput{}
	}

	output = &CreateContactMethodOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContactMethod API operation for Amazon Lightsail.
//
// Creates an email or SMS text message contact method.
//
// A contact method is used to send you notifications about your Amazon Lightsail
// resources. You can add one email address and one mobile phone number contact
// method in each AWS Region. However, SMS text messaging is not supported in
// some AWS Regions, and SMS text messages cannot be sent to some countries/regions.
// For more information, see Notifications in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateContactMethod for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContactMethod
func (c *Lightsail) CreateContactMethod(input *CreateContactMethodInput) (*CreateContactMethodOutput, error) {
	req, out := c.CreateContactMethodRequest(input)
	return out, req.Send()
}

// CreateContactMethodWithContext is the same as CreateContactMethod with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContactMethod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateContactMethodWithContext(ctx aws.Context, input *CreateContactMethodInput, opts ...request.Option) (*CreateContactMethodOutput, error) {
	req, out := c.CreateContactMethodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateContainerService = "CreateContainerService"

// CreateContainerServiceRequest generates a "aws/request.Request" representing the
// client's request for the CreateContainerService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContainerService for more information on using the CreateContainerService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateContainerServiceRequest method.
//    req, resp := client.CreateContainerServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContainerService
func (c *Lightsail) CreateContainerServiceRequest(input *CreateContainerServiceInput) (req *request.Request, output *CreateContainerServiceOutput) {
	op := &request.Operation{
		Name:       opCreateContainerService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateContainerServiceInput{}
	}

	output = &CreateContainerServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContainerService API operation for Amazon Lightsail.
//
// Creates an Amazon Lightsail container service.
//
// A Lightsail container service is a compute resource to which you can deploy
// containers. For more information, see Container services in Amazon Lightsail
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-services)
// in the Lightsail Dev Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateContainerService for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContainerService
func (c *Lightsail) CreateContainerService(input *CreateContainerServiceInput) (*CreateContainerServiceOutput, error) {
	req, out := c.CreateContainerServiceRequest(input)
	return out, req.Send()
}

// CreateContainerServiceWithContext is the same as CreateContainerService with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContainerService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateContainerServiceWithContext(ctx aws.Context, input *CreateContainerServiceInput, opts ...request.Option) (*CreateContainerServiceOutput, error) {
	req, out := c.CreateContainerServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateContainerServiceDeployment = "CreateContainerServiceDeployment"

// CreateContainerServiceDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CreateContainerServiceDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContainerServiceDeployment for more information on using the CreateContainerServiceDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateContainerServiceDeploymentRequest method.
//    req, resp := client.CreateContainerServiceDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContainerServiceDeployment
func (c *Lightsail) CreateContainerServiceDeploymentRequest(input *CreateContainerServiceDeploymentInput) (req *request.Request, output *CreateContainerServiceDeploymentOutput) {
	op := &request.Operation{
		Name:       opCreateContainerServiceDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateContainerServiceDeploymentInput{}
	}

	output = &CreateContainerServiceDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContainerServiceDeployment API operation for Amazon Lightsail.
//
// Creates a deployment for your Amazon Lightsail container service.
//
// A deployment specifies the containers that will be launched on the container
// service and their settings, such as the ports to open, the environment variables
// to apply, and the launch command to run. It also specifies the container
// that will serve as the public endpoint of the deployment and its settings,
// such as the HTTP or HTTPS port to use, and the health check configuration.
//
// You can deploy containers to your container service using container images
// from a public registry like Docker Hub, or from your local machine. For more
// information, see Creating container images for your Amazon Lightsail container
// services (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-container-images)
// in the Amazon Lightsail Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateContainerServiceDeployment for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContainerServiceDeployment
func (c *Lightsail) CreateContainerServiceDeployment(input *CreateContainerServiceDeploymentInput) (*CreateContainerServiceDeploymentOutput, error) {
	req, out := c.CreateContainerServiceDeploymentRequest(input)
	return out, req.Send()
}

// CreateContainerServiceDeploymentWithContext is the same as CreateContainerServiceDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContainerServiceDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateContainerServiceDeploymentWithContext(ctx aws.Context, input *CreateContainerServiceDeploymentInput, opts ...request.Option) (*CreateContainerServiceDeploymentOutput, error) {
	req, out := c.CreateContainerServiceDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateContainerServiceRegistryLogin = "CreateContainerServiceRegistryLogin"

// CreateContainerServiceRegistryLoginRequest generates a "aws/request.Request" representing the
// client's request for the CreateContainerServiceRegistryLogin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContainerServiceRegistryLogin for more information on using the CreateContainerServiceRegistryLogin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateContainerServiceRegistryLoginRequest method.
//    req, resp := client.CreateContainerServiceRegistryLoginRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContainerServiceRegistryLogin
func (c *Lightsail) CreateContainerServiceRegistryLoginRequest(input *CreateContainerServiceRegistryLoginInput) (req *request.Request, output *CreateContainerServiceRegistryLoginOutput) {
	op := &request.Operation{
		Name:       opCreateContainerServiceRegistryLogin,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateContainerServiceRegistryLoginInput{}
	}

	output = &CreateContainerServiceRegistryLoginOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContainerServiceRegistryLogin API operation for Amazon Lightsail.
//
// Creates a temporary set of log in credentials that you can use to log in
// to the Docker process on your local machine. After you're logged in, you
// can use the native Docker commands to push your local container images to
// the container image registry of your Amazon Lightsail account so that you
// can use them with your Lightsail container service. The log in credentials
// expire 12 hours after they are created, at which point you will need to create
// a new set of log in credentials.
//
// You can only push container images to the container service registry of your
// Lightsail account. You cannot pull container images or perform any other
// container image management actions on the container service registry.
//
// After you push your container images to the container image registry of your
// Lightsail account, use the RegisterContainerImage action to register the
// pushed images to a specific Lightsail container service.
//
// This action is not required if you install and use the Lightsail Control
// (lightsailctl) plugin to push container images to your Lightsail container
// service. For more information, see Pushing and managing container images
// on your Amazon Lightsail container services (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images)
// in the Amazon Lightsail Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateContainerServiceRegistryLogin for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContainerServiceRegistryLogin
func (c *Lightsail) CreateContainerServiceRegistryLogin(input *CreateContainerServiceRegistryLoginInput) (*CreateContainerServiceRegistryLoginOutput, error) {
	req, out := c.CreateContainerServiceRegistryLoginRequest(input)
	return out, req.Send()
}

// CreateContainerServiceRegistryLoginWithContext is the same as CreateContainerServiceRegistryLogin with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContainerServiceRegistryLogin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateContainerServiceRegistryLoginWithContext(ctx aws.Context, input *CreateContainerServiceRegistryLoginInput, opts ...request.Option) (*CreateContainerServiceRegistryLoginOutput, error) {
	req, out := c.CreateContainerServiceRegistryLoginRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDisk = "CreateDisk"

// CreateDiskRequest generates a "aws/request.Request" representing the
// client's request for the CreateDisk operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDisk for more information on using the CreateDisk
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDiskRequest method.
//    req, resp := client.CreateDiskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDisk
func (c *Lightsail) CreateDiskRequest(input *CreateDiskInput) (req *request.Request, output *CreateDiskOutput) {
	op := &request.Operation{
		Name:       opCreateDisk,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDiskInput{}
	}

	output = &CreateDiskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDisk API operation for Amazon Lightsail.
//
// Creates a block storage disk that can be attached to an Amazon Lightsail
// instance in the same Availability Zone (e.g., us-east-2a).
//
// The create disk operation supports tag-based access control via request tags.
// For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateDisk for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDisk
func (c *Lightsail) CreateDisk(input *CreateDiskInput) (*CreateDiskOutput, error) {
	req, out := c.CreateDiskRequest(input)
	return out, req.Send()
}

// CreateDiskWithContext is the same as CreateDisk with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDisk for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateDiskWithContext(ctx aws.Context, input *CreateDiskInput, opts ...request.Option) (*CreateDiskOutput, error) {
	req, out := c.CreateDiskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDiskFromSnapshot = "CreateDiskFromSnapshot"

// CreateDiskFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateDiskFromSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDiskFromSnapshot for more information on using the CreateDiskFromSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDiskFromSnapshotRequest method.
//    req, resp := client.CreateDiskFromSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskFromSnapshot
func (c *Lightsail) CreateDiskFromSnapshotRequest(input *CreateDiskFromSnapshotInput) (req *request.Request, output *CreateDiskFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateDiskFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDiskFromSnapshotInput{}
	}

	output = &CreateDiskFromSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDiskFromSnapshot API operation for Amazon Lightsail.
//
// Creates a block storage disk from a manual or automatic snapshot of a disk.
// The resulting disk can be attached to an Amazon Lightsail instance in the
// same Availability Zone (e.g., us-east-2a).
//
// The create disk from snapshot operation supports tag-based access control
// via request tags and resource tags applied to the resource identified by
// disk snapshot name. For more information, see the Amazon Lightsail Developer
// Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateDiskFromSnapshot for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskFromSnapshot
func (c *Lightsail) CreateDiskFromSnapshot(input *CreateDiskFromSnapshotInput) (*CreateDiskFromSnapshotOutput, error) {
	req, out := c.CreateDiskFromSnapshotRequest(input)
	return out, req.Send()
}

// CreateDiskFromSnapshotWithContext is the same as CreateDiskFromSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDiskFromSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateDiskFromSnapshotWithContext(ctx aws.Context, input *CreateDiskFromSnapshotInput, opts ...request.Option) (*CreateDiskFromSnapshotOutput, error) {
	req, out := c.CreateDiskFromSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDiskSnapshot = "CreateDiskSnapshot"

// CreateDiskSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateDiskSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDiskSnapshot for more information on using the CreateDiskSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDiskSnapshotRequest method.
//    req, resp := client.CreateDiskSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskSnapshot
func (c *Lightsail) CreateDiskSnapshotRequest(input *CreateDiskSnapshotInput) (req *request.Request, output *CreateDiskSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateDiskSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDiskSnapshotInput{}
	}

	output = &CreateDiskSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDiskSnapshot API operation for Amazon Lightsail.
//
// Creates a snapshot of a block storage disk. You can use snapshots for backups,
// to make copies of disks, and to save data before shutting down a Lightsail
// instance.
//
// You can take a snapshot of an attached disk that is in use; however, snapshots
// only capture data that has been written to your disk at the time the snapshot
// command is issued. This may exclude any data that has been cached by any
// applications or the operating system. If you can pause any file systems on
// the disk long enough to take a snapshot, your snapshot should be complete.
// Nevertheless, if you cannot pause all file writes to the disk, you should
// unmount the disk from within the Lightsail instance, issue the create disk
// snapshot command, and then remount the disk to ensure a consistent and complete
// snapshot. You may remount and use your disk while the snapshot status is
// pending.
//
// You can also use this operation to create a snapshot of an instance's system
// volume. You might want to do this, for example, to recover data from the
// system volume of a botched instance or to create a backup of the system volume
// like you would for a block storage disk. To create a snapshot of a system
// volume, just define the instance name parameter when issuing the snapshot
// command, and a snapshot of the defined instance's system volume will be created.
// After the snapshot is available, you can create a block storage disk from
// the snapshot and attach it to a running instance to access the data on the
// disk.
//
// The create disk snapshot operation supports tag-based access control via
// request tags. For more information, see the Amazon Lightsail Developer Guide
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateDiskSnapshot for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskSnapshot
func (c *Lightsail) CreateDiskSnapshot(input *CreateDiskSnapshotInput) (*CreateDiskSnapshotOutput, error) {
	req, out := c.CreateDiskSnapshotRequest(input)
	return out, req.Send()
}

// CreateDiskSnapshotWithContext is the same as CreateDiskSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDiskSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateDiskSnapshotWithContext(ctx aws.Context, input *CreateDiskSnapshotInput, opts ...request.Option) (*CreateDiskSnapshotOutput, error) {
	req, out := c.CreateDiskSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDistribution = "CreateDistribution"

// CreateDistributionRequest generates a "aws/request.Request" representing the
// client's request for the CreateDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDistribution for more information on using the CreateDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDistributionRequest method.
//    req, resp := client.CreateDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDistribution
func (c *Lightsail) CreateDistributionRequest(input *CreateDistributionInput) (req *request.Request, output *CreateDistributionOutput) {
	op := &request.Operation{
		Name:       opCreateDistribution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDistributionInput{}
	}

	output = &CreateDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDistribution API operation for Amazon Lightsail.
//
// Creates an Amazon Lightsail content delivery network (CDN) distribution.
//
// A distribution is a globally distributed network of caching servers that
// improve the performance of your website or web application hosted on a Lightsail
// instance. For more information, see Content delivery networks in Amazon Lightsail
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-content-delivery-network-distributions).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateDistribution for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDistribution
func (c *Lightsail) CreateDistribution(input *CreateDistributionInput) (*CreateDistributionOutput, error) {
	req, out := c.CreateDistributionRequest(input)
	return out, req.Send()
}

// CreateDistributionWithContext is the same as CreateDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateDistributionWithContext(ctx aws.Context, input *CreateDistributionInput, opts ...request.Option) (*CreateDistributionOutput, error) {
	req, out := c.CreateDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomain for more information on using the CreateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDomainRequest method.
//    req, resp := client.CreateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomain
func (c *Lightsail) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	output = &CreateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomain API operation for Amazon Lightsail.
//
// Creates a domain resource for the specified domain (e.g., example.com).
//
// The create domain operation supports tag-based access control via request
// tags. For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateDomain for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomain
func (c *Lightsail) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	return out, req.Send()
}

// CreateDomainWithContext is the same as CreateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateDomainWithContext(ctx aws.Context, input *CreateDomainInput, opts ...request.Option) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomainEntry = "CreateDomainEntry"

// CreateDomainEntryRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomainEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomainEntry for more information on using the CreateDomainEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDomainEntryRequest method.
//    req, resp := client.CreateDomainEntryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntry
func (c *Lightsail) CreateDomainEntryRequest(input *CreateDomainEntryInput) (req *request.Request, output *CreateDomainEntryOutput) {
	op := &request.Operation{
		Name:       opCreateDomainEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainEntryInput{}
	}

	output = &CreateDomainEntryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomainEntry API operation for Amazon Lightsail.
//
// Creates one of the following domain name system (DNS) records in a domain
// DNS zone: Address (A), canonical name (CNAME), mail exchanger (MX), name
// server (NS), start of authority (SOA), service locator (SRV), or text (TXT).
//
// The create domain entry operation supports tag-based access control via resource
// tags applied to the resource identified by domain name. For more information,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateDomainEntry for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntry
func (c *Lightsail) CreateDomainEntry(input *CreateDomainEntryInput) (*CreateDomainEntryOutput, error) {
	req, out := c.CreateDomainEntryRequest(input)
	return out, req.Send()
}

// CreateDomainEntryWithContext is the same as CreateDomainEntry with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomainEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateDomainEntryWithContext(ctx aws.Context, input *CreateDomainEntryInput, opts ...request.Option) (*CreateDomainEntryOutput, error) {
	req, out := c.CreateDomainEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstanceSnapshot = "CreateInstanceSnapshot"

// CreateInstanceSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstanceSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstanceSnapshot for more information on using the CreateInstanceSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInstanceSnapshotRequest method.
//    req, resp := client.CreateInstanceSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot
func (c *Lightsail) CreateInstanceSnapshotRequest(input *CreateInstanceSnapshotInput) (req *request.Request, output *CreateInstanceSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceSnapshotInput{}
	}

	output = &CreateInstanceSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstanceSnapshot API operation for Amazon Lightsail.
//
// Creates a snapshot of a specific virtual private server, or instance. You
// can use a snapshot to create a new instance that is based on that snapshot.
//
// The create instance snapshot operation supports tag-based access control
// via request tags. For more information, see the Amazon Lightsail Developer
// Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateInstanceSnapshot for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot
func (c *Lightsail) CreateInstanceSnapshot(input *CreateInstanceSnapshotInput) (*CreateInstanceSnapshotOutput, error) {
	req, out := c.CreateInstanceSnapshotRequest(input)
	return out, req.Send()
}

// CreateInstanceSnapshotWithContext is the same as CreateInstanceSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateInstanceSnapshotWithContext(ctx aws.Context, input *CreateInstanceSnapshotInput, opts ...request.Option) (*CreateInstanceSnapshotOutput, error) {
	req, out := c.CreateInstanceSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstances = "CreateInstances"

// CreateInstancesRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstances for more information on using the CreateInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInstancesRequest method.
//    req, resp := client.CreateInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances
func (c *Lightsail) CreateInstancesRequest(input *CreateInstancesInput) (req *request.Request, output *CreateInstancesOutput) {
	op := &request.Operation{
		Name:       opCreateInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstancesInput{}
	}

	output = &CreateInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstances API operation for Amazon Lightsail.
//
// Creates one or more Amazon Lightsail instances.
//
// The create instances operation supports tag-based access control via request
// tags. For more information, see the Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateInstances for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances
func (c *Lightsail) CreateInstances(input *CreateInstancesInput) (*CreateInstancesOutput, error) {
	req, out := c.CreateInstancesRequest(input)
	return out, req.Send()
}

// CreateInstancesWithContext is the same as CreateInstances with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateInstancesWithContext(ctx aws.Context, input *CreateInstancesInput, opts ...request.Option) (*CreateInstancesOutput, error) {
	req, out := c.CreateInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstancesFromSnapshot = "CreateInstancesFromSnapshot"

// CreateInstancesFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstancesFromSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstancesFromSnapshot for more information on using the CreateInstancesFromSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInstancesFromSnapshotRequest method.
//    req, resp := client.CreateInstancesFromSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot
func (c *Lightsail) CreateInstancesFromSnapshotRequest(input *CreateInstancesFromSnapshotInput) (req *request.Request, output *CreateInstancesFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateInstancesFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstancesFromSnapshotInput{}
	}

	output = &CreateInstancesFromSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstancesFromSnapshot API operation for Amazon Lightsail.
//
// Creates one or more new instances from a manual or automatic snapshot of
// an instance.
//
// The create instances from snapshot operation supports tag-based access control
// via request tags and resource tags applied to the resource identified by
// instance snapshot name. For more information, see the Amazon Lightsail Developer
// Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateInstancesFromSnapshot for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot
func (c *Lightsail) CreateInstancesFromSnapshot(input *CreateInstancesFromSnapshotInput) (*CreateInstancesFromSnapshotOutput, error) {
	req, out := c.CreateInstancesFromSnapshotRequest(input)
	return out, req.Send()
}

// CreateInstancesFromSnapshotWithContext is the same as CreateInstancesFromSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstancesFromSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateInstancesFromSnapshotWithContext(ctx aws.Context, input *CreateInstancesFromSnapshotInput, opts ...request.Option) (*CreateInstancesFromSnapshotOutput, error) {
	req, out := c.CreateInstancesFromSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKeyPair = "CreateKeyPair"

// CreateKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the CreateKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKeyPair for more information on using the CreateKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateKeyPairRequest method.
//    req, resp := client.CreateKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPair
func (c *Lightsail) CreateKeyPairRequest(input *CreateKeyPairInput) (req *request.Request, output *CreateKeyPairOutput) {
	op := &request.Operation{
		Name:       opCreateKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyPairInput{}
	}

	output = &CreateKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKeyPair API operation for Amazon Lightsail.
//
// Creates an SSH key pair.
//
// The create key pair operation supports tag-based access control via request
// tags. For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateKeyPair for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPair
func (c *Lightsail) CreateKeyPair(input *CreateKeyPairInput) (*CreateKeyPairOutput, error) {
	req, out := c.CreateKeyPairRequest(input)
	return out, req.Send()
}

// CreateKeyPairWithContext is the same as CreateKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateKeyPairWithContext(ctx aws.Context, input *CreateKeyPairInput, opts ...request.Option) (*CreateKeyPairOutput, error) {
	req, out := c.CreateKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLoadBalancer = "CreateLoadBalancer"

// CreateLoadBalancerRequest generates a "aws/request.Request" representing the
// client's request for the CreateLoadBalancer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLoadBalancer for more information on using the CreateLoadBalancer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLoadBalancerRequest method.
//    req, resp := client.CreateLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancer
func (c *Lightsail) CreateLoadBalancerRequest(input *CreateLoadBalancerInput) (req *request.Request, output *CreateLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opCreateLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLoadBalancerInput{}
	}

	output = &CreateLoadBalancerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLoadBalancer API operation for Amazon Lightsail.
//
// Creates a Lightsail load balancer. To learn more about deciding whether to
// load balance your application, see Configure your Lightsail instances for
// load balancing (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/configure-lightsail-instances-for-load-balancing).
// You can create up to 5 load balancers per AWS Region in your account.
//
// When you create a load balancer, you can specify a unique name and port settings.
// To change additional load balancer settings, use the UpdateLoadBalancerAttribute
// operation.
//
// The create load balancer operation supports tag-based access control via
// request tags. For more information, see the Amazon Lightsail Developer Guide
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateLoadBalancer for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancer
func (c *Lightsail) CreateLoadBalancer(input *CreateLoadBalancerInput) (*CreateLoadBalancerOutput, error) {
	req, out := c.CreateLoadBalancerRequest(input)
	return out, req.Send()
}

// CreateLoadBalancerWithContext is the same as CreateLoadBalancer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLoadBalancer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateLoadBalancerWithContext(ctx aws.Context, input *CreateLoadBalancerInput, opts ...request.Option) (*CreateLoadBalancerOutput, error) {
	req, out := c.CreateLoadBalancerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLoadBalancerTlsCertificate = "CreateLoadBalancerTlsCertificate"

// CreateLoadBalancerTlsCertificateRequest generates a "aws/request.Request" representing the
// client's request for the CreateLoadBalancerTlsCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLoadBalancerTlsCertificate for more information on using the CreateLoadBalancerTlsCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLoadBalancerTlsCertificateRequest method.
//    req, resp := client.CreateLoadBalancerTlsCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerTlsCertificate
func (c *Lightsail) CreateLoadBalancerTlsCertificateRequest(input *CreateLoadBalancerTlsCertificateInput) (req *request.Request, output *CreateLoadBalancerTlsCertificateOutput) {
	op := &request.Operation{
		Name:       opCreateLoadBalancerTlsCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLoadBalancerTlsCertificateInput{}
	}

	output = &CreateLoadBalancerTlsCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLoadBalancerTlsCertificate API operation for Amazon Lightsail.
//
// Creates an SSL/TLS certificate for an Amazon Lightsail load balancer.
//
// TLS is just an updated, more secure version of Secure Socket Layer (SSL).
//
// The CreateLoadBalancerTlsCertificate operation supports tag-based access
// control via resource tags applied to the resource identified by load balancer
// name. For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateLoadBalancerTlsCertificate for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerTlsCertificate
func (c *Lightsail) CreateLoadBalancerTlsCertificate(input *CreateLoadBalancerTlsCertificateInput) (*CreateLoadBalancerTlsCertificateOutput, error) {
	req, out := c.CreateLoadBalancerTlsCertificateRequest(input)
	return out, req.Send()
}

// CreateLoadBalancerTlsCertificateWithContext is the same as CreateLoadBalancerTlsCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLoadBalancerTlsCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateLoadBalancerTlsCertificateWithContext(ctx aws.Context, input *CreateLoadBalancerTlsCertificateInput, opts ...request.Option) (*CreateLoadBalancerTlsCertificateOutput, error) {
	req, out := c.CreateLoadBalancerTlsCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRelationalDatabase = "CreateRelationalDatabase"

// CreateRelationalDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the CreateRelationalDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRelationalDatabase for more information on using the CreateRelationalDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRelationalDatabaseRequest method.
//    req, resp := client.CreateRelationalDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabase
func (c *Lightsail) CreateRelationalDatabaseRequest(input *CreateRelationalDatabaseInput) (req *request.Request, output *CreateRelationalDatabaseOutput) {
	op := &request.Operation{
		Name:       opCreateRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRelationalDatabaseInput{}
	}

	output = &CreateRelationalDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRelationalDatabase API operation for Amazon Lightsail.
//
// Creates a new database in Amazon Lightsail.
//
// The create relational database operation supports tag-based access control
// via request tags. For more information, see the Amazon Lightsail Developer
// Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateRelationalDatabase for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabase
func (c *Lightsail) CreateRelationalDatabase(input *CreateRelationalDatabaseInput) (*CreateRelationalDatabaseOutput, error) {
	req, out := c.CreateRelationalDatabaseRequest(input)
	return out, req.Send()
}

// CreateRelationalDatabaseWithContext is the same as CreateRelationalDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRelationalDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateRelationalDatabaseWithContext(ctx aws.Context, input *CreateRelationalDatabaseInput, opts ...request.Option) (*CreateRelationalDatabaseOutput, error) {
	req, out := c.CreateRelationalDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRelationalDatabaseFromSnapshot = "CreateRelationalDatabaseFromSnapshot"

// CreateRelationalDatabaseFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateRelationalDatabaseFromSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRelationalDatabaseFromSnapshot for more information on using the CreateRelationalDatabaseFromSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRelationalDatabaseFromSnapshotRequest method.
//    req, resp := client.CreateRelationalDatabaseFromSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseFromSnapshot
func (c *Lightsail) CreateRelationalDatabaseFromSnapshotRequest(input *CreateRelationalDatabaseFromSnapshotInput) (req *request.Request, output *CreateRelationalDatabaseFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateRelationalDatabaseFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRelationalDatabaseFromSnapshotInput{}
	}

	output = &CreateRelationalDatabaseFromSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRelationalDatabaseFromSnapshot API operation for Amazon Lightsail.
//
// Creates a new database from an existing database snapshot in Amazon Lightsail.
//
// You can create a new database from a snapshot in if something goes wrong
// with your original database, or to change it to a different plan, such as
// a high availability or standard plan.
//
// The create relational database from snapshot operation supports tag-based
// access control via request tags and resource tags applied to the resource
// identified by relationalDatabaseSnapshotName. For more information, see the
// Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateRelationalDatabaseFromSnapshot for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseFromSnapshot
func (c *Lightsail) CreateRelationalDatabaseFromSnapshot(input *CreateRelationalDatabaseFromSnapshotInput) (*CreateRelationalDatabaseFromSnapshotOutput, error) {
	req, out := c.CreateRelationalDatabaseFromSnapshotRequest(input)
	return out, req.Send()
}

// CreateRelationalDatabaseFromSnapshotWithContext is the same as CreateRelationalDatabaseFromSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRelationalDatabaseFromSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateRelationalDatabaseFromSnapshotWithContext(ctx aws.Context, input *CreateRelationalDatabaseFromSnapshotInput, opts ...request.Option) (*CreateRelationalDatabaseFromSnapshotOutput, error) {
	req, out := c.CreateRelationalDatabaseFromSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRelationalDatabaseSnapshot = "CreateRelationalDatabaseSnapshot"

// CreateRelationalDatabaseSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateRelationalDatabaseSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRelationalDatabaseSnapshot for more information on using the CreateRelationalDatabaseSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRelationalDatabaseSnapshotRequest method.
//    req, resp := client.CreateRelationalDatabaseSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseSnapshot
func (c *Lightsail) CreateRelationalDatabaseSnapshotRequest(input *CreateRelationalDatabaseSnapshotInput) (req *request.Request, output *CreateRelationalDatabaseSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateRelationalDatabaseSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRelationalDatabaseSnapshotInput{}
	}

	output = &CreateRelationalDatabaseSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRelationalDatabaseSnapshot API operation for Amazon Lightsail.
//
// Creates a snapshot of your database in Amazon Lightsail. You can use snapshots
// for backups, to make copies of a database, and to save data before deleting
// a database.
//
// The create relational database snapshot operation supports tag-based access
// control via request tags. For more information, see the Amazon Lightsail
// Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateRelationalDatabaseSnapshot for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseSnapshot
func (c *Lightsail) CreateRelationalDatabaseSnapshot(input *CreateRelationalDatabaseSnapshotInput) (*CreateRelationalDatabaseSnapshotOutput, error) {
	req, out := c.CreateRelationalDatabaseSnapshotRequest(input)
	return out, req.Send()
}

// CreateRelationalDatabaseSnapshotWithContext is the same as CreateRelationalDatabaseSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRelationalDatabaseSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateRelationalDatabaseSnapshotWithContext(ctx aws.Context, input *CreateRelationalDatabaseSnapshotInput, opts ...request.Option) (*CreateRelationalDatabaseSnapshotOutput, error) {
	req, out := c.CreateRelationalDatabaseSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAlarm = "DeleteAlarm"

// DeleteAlarmRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlarm for more information on using the DeleteAlarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAlarmRequest method.
//    req, resp := client.DeleteAlarmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteAlarm
func (c *Lightsail) DeleteAlarmRequest(input *DeleteAlarmInput) (req *request.Request, output *DeleteAlarmOutput) {
	op := &request.Operation{
		Name:       opDeleteAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAlarmInput{}
	}

	output = &DeleteAlarmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAlarm API operation for Amazon Lightsail.
//
// Deletes an alarm.
//
// An alarm is used to monitor a single metric for one of your resources. When
// a metric condition is met, the alarm can notify you by email, SMS text message,
// and a banner displayed on the Amazon Lightsail console. For more information,
// see Alarms in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteAlarm for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteAlarm
func (c *Lightsail) DeleteAlarm(input *DeleteAlarmInput) (*DeleteAlarmOutput, error) {
	req, out := c.DeleteAlarmRequest(input)
	return out, req.Send()
}

// DeleteAlarmWithContext is the same as DeleteAlarm with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteAlarmWithContext(ctx aws.Context, input *DeleteAlarmInput, opts ...request.Option) (*DeleteAlarmOutput, error) {
	req, out := c.DeleteAlarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAutoSnapshot = "DeleteAutoSnapshot"

// DeleteAutoSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAutoSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAutoSnapshot for more information on using the DeleteAutoSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAutoSnapshotRequest method.
//    req, resp := client.DeleteAutoSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteAutoSnapshot
func (c *Lightsail) DeleteAutoSnapshotRequest(input *DeleteAutoSnapshotInput) (req *request.Request, output *DeleteAutoSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteAutoSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAutoSnapshotInput{}
	}

	output = &DeleteAutoSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAutoSnapshot API operation for Amazon Lightsail.
//
// Deletes an automatic snapshot of an instance or disk. For more information,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteAutoSnapshot for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteAutoSnapshot
func (c *Lightsail) DeleteAutoSnapshot(input *DeleteAutoSnapshotInput) (*DeleteAutoSnapshotOutput, error) {
	req, out := c.DeleteAutoSnapshotRequest(input)
	return out, req.Send()
}

// DeleteAutoSnapshotWithContext is the same as DeleteAutoSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAutoSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteAutoSnapshotWithContext(ctx aws.Context, input *DeleteAutoSnapshotInput, opts ...request.Option) (*DeleteAutoSnapshotOutput, error) {
	req, out := c.DeleteAutoSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucket = "DeleteBucket"

// DeleteBucketRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucket for more information on using the DeleteBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketRequest method.
//    req, resp := client.DeleteBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteBucket
func (c *Lightsail) DeleteBucketRequest(input *DeleteBucketInput) (req *request.Request, output *DeleteBucketOutput) {
	op := &request.Operation{
		Name:       opDeleteBucket,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBucketInput{}
	}

	output = &DeleteBucketOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBucket API operation for Amazon Lightsail.
//
// Deletes a Amazon Lightsail bucket.
//
// When you delete your bucket, the bucket name is released and can be reused
// for a new bucket in your account or another AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteBucket for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ServiceException
//   A general service exception.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteBucket
func (c *Lightsail) DeleteBucket(input *DeleteBucketInput) (*DeleteBucketOutput, error) {
	req, out := c.DeleteBucketRequest(input)
	return out, req.Send()
}

// DeleteBucketWithContext is the same as DeleteBucket with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteBucketWithContext(ctx aws.Context, input *DeleteBucketInput, opts ...request.Option) (*DeleteBucketOutput, error) {
	req, out := c.DeleteBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketAccessKey = "DeleteBucketAccessKey"

// DeleteBucketAccessKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketAccessKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketAccessKey for more information on using the DeleteBucketAccessKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketAccessKeyRequest method.
//    req, resp := client.DeleteBucketAccessKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteBucketAccessKey
func (c *Lightsail) DeleteBucketAccessKeyRequest(input *DeleteBucketAccessKeyInput) (req *request.Request, output *DeleteBucketAccessKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketAccessKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBucketAccessKeyInput{}
	}

	output = &DeleteBucketAccessKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBucketAccessKey API operation for Amazon Lightsail.
//
// Deletes an access key for the specified Amazon Lightsail bucket.
//
// We recommend that you delete an access key if the secret access key is compromised.
//
// For more information about access keys, see Creating access keys for a bucket
// in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys)
// in the Amazon Lightsail Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteBucketAccessKey for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ServiceException
//   A general service exception.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteBucketAccessKey
func (c *Lightsail) DeleteBucketAccessKey(input *DeleteBucketAccessKeyInput) (*DeleteBucketAccessKeyOutput, error) {
	req, out := c.DeleteBucketAccessKeyRequest(input)
	return out, req.Send()
}

// DeleteBucketAccessKeyWithContext is the same as DeleteBucketAccessKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketAccessKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteBucketAccessKeyWithContext(ctx aws.Context, input *DeleteBucketAccessKeyInput, opts ...request.Option) (*DeleteBucketAccessKeyOutput, error) {
	req, out := c.DeleteBucketAccessKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCertificate = "DeleteCertificate"

// DeleteCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCertificate for more information on using the DeleteCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCertificateRequest method.
//    req, resp := client.DeleteCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteCertificate
func (c *Lightsail) DeleteCertificateRequest(input *DeleteCertificateInput) (req *request.Request, output *DeleteCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCertificateInput{}
	}

	output = &DeleteCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCertificate API operation for Amazon Lightsail.
//
// Deletes an SSL/TLS certificate for your Amazon Lightsail content delivery
// network (CDN) distribution.
//
// Certificates that are currently attached to a distribution cannot be deleted.
// Use the DetachCertificateFromDistribution action to detach a certificate
// from a distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteCertificate for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteCertificate
func (c *Lightsail) DeleteCertificate(input *DeleteCertificateInput) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	return out, req.Send()
}

// DeleteCertificateWithContext is the same as DeleteCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteCertificateWithContext(ctx aws.Context, input *DeleteCertificateInput, opts ...request.Option) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContactMethod = "DeleteContactMethod"

// DeleteContactMethodRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContactMethod operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContactMethod for more information on using the DeleteContactMethod
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteContactMethodRequest method.
//    req, resp := client.DeleteContactMethodRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteContactMethod
func (c *Lightsail) DeleteContactMethodRequest(input *DeleteContactMethodInput) (req *request.Request, output *DeleteContactMethodOutput) {
	op := &request.Operation{
		Name:       opDeleteContactMethod,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteContactMethodInput{}
	}

	output = &DeleteContactMethodOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteContactMethod API operation for Amazon Lightsail.
//
// Deletes a contact method.
//
// A contact method is used to send you notifications about your Amazon Lightsail
// resources. You can add one email address and one mobile phone number contact
// method in each AWS Region. However, SMS text messaging is not supported in
// some AWS Regions, and SMS text messages cannot be sent to some countries/regions.
// For more information, see Notifications in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteContactMethod for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteContactMethod
func (c *Lightsail) DeleteContactMethod(input *DeleteContactMethodInput) (*DeleteContactMethodOutput, error) {
	req, out := c.DeleteContactMethodRequest(input)
	return out, req.Send()
}

// DeleteContactMethodWithContext is the same as DeleteContactMethod with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContactMethod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteContactMethodWithContext(ctx aws.Context, input *DeleteContactMethodInput, opts ...request.Option) (*DeleteContactMethodOutput, error) {
	req, out := c.DeleteContactMethodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContainerImage = "DeleteContainerImage"

// DeleteContainerImageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContainerImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContainerImage for more information on using the DeleteContainerImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteContainerImageRequest method.
//    req, resp := client.DeleteContainerImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteContainerImage
func (c *Lightsail) DeleteContainerImageRequest(input *DeleteContainerImageInput) (req *request.Request, output *DeleteContainerImageOutput) {
	op := &request.Operation{
		Name:       opDeleteContainerImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteContainerImageInput{}
	}

	output = &DeleteContainerImageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteContainerImage API operation for Amazon Lightsail.
//
// Deletes a container image that is registered to your Amazon Lightsail container
// service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteContainerImage for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteContainerImage
func (c *Lightsail) DeleteContainerImage(input *DeleteContainerImageInput) (*DeleteContainerImageOutput, error) {
	req, out := c.DeleteContainerImageRequest(input)
	return out, req.Send()
}

// DeleteContainerImageWithContext is the same as DeleteContainerImage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContainerImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteContainerImageWithContext(ctx aws.Context, input *DeleteContainerImageInput, opts ...request.Option) (*DeleteContainerImageOutput, error) {
	req, out := c.DeleteContainerImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContainerService = "DeleteContainerService"

// DeleteContainerServiceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContainerService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContainerService for more information on using the DeleteContainerService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteContainerServiceRequest method.
//    req, resp := client.DeleteContainerServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteContainerService
func (c *Lightsail) DeleteContainerServiceRequest(input *DeleteContainerServiceInput) (req *request.Request, output *DeleteContainerServiceOutput) {
	op := &request.Operation{
		Name:       opDeleteContainerService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteContainerServiceInput{}
	}

	output = &DeleteContainerServiceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteContainerService API operation for Amazon Lightsail.
//
// Deletes your Amazon Lightsail container service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteContainerService for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteContainerService
func (c *Lightsail) DeleteContainerService(input *DeleteContainerServiceInput) (*DeleteContainerServiceOutput, error) {
	req, out := c.DeleteContainerServiceRequest(input)
	return out, req.Send()
}

// DeleteContainerServiceWithContext is the same as DeleteContainerService with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContainerService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteContainerServiceWithContext(ctx aws.Context, input *DeleteContainerServiceInput, opts ...request.Option) (*DeleteContainerServiceOutput, error) {
	req, out := c.DeleteContainerServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDisk = "DeleteDisk"

// DeleteDiskRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDisk operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDisk for more information on using the DeleteDisk
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDiskRequest method.
//    req, resp := client.DeleteDiskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDisk
func (c *Lightsail) DeleteDiskRequest(input *DeleteDiskInput) (req *request.Request, output *DeleteDiskOutput) {
	op := &request.Operation{
		Name:       opDeleteDisk,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDiskInput{}
	}

	output = &DeleteDiskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDisk API operation for Amazon Lightsail.
//
// Deletes the specified block storage disk. The disk must be in the available
// state (not attached to a Lightsail instance).
//
// The disk may remain in the deleting state for several minutes.
//
// The delete disk operation supports tag-based access control via resource
// tags applied to the resource identified by disk name. For more information,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteDisk for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDisk
func (c *Lightsail) DeleteDisk(input *DeleteDiskInput) (*DeleteDiskOutput, error) {
	req, out := c.DeleteDiskRequest(input)
	return out, req.Send()
}

// DeleteDiskWithContext is the same as DeleteDisk with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDisk for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteDiskWithContext(ctx aws.Context, input *DeleteDiskInput, opts ...request.Option) (*DeleteDiskOutput, error) {
	req, out := c.DeleteDiskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDiskSnapshot = "DeleteDiskSnapshot"

// DeleteDiskSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDiskSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDiskSnapshot for more information on using the DeleteDiskSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDiskSnapshotRequest method.
//    req, resp := client.DeleteDiskSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDiskSnapshot
func (c *Lightsail) DeleteDiskSnapshotRequest(input *DeleteDiskSnapshotInput) (req *request.Request, output *DeleteDiskSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteDiskSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDiskSnapshotInput{}
	}

	output = &DeleteDiskSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDiskSnapshot API operation for Amazon Lightsail.
//
// Deletes the specified disk snapshot.
//
// When you make periodic snapshots of a disk, the snapshots are incremental,
// and only the blocks on the device that have changed since your last snapshot
// are saved in the new snapshot. When you delete a snapshot, only the data
// not needed for any other snapshot is removed. So regardless of which prior
// snapshots have been deleted, all active snapshots will have access to all
// the information needed to restore the disk.
//
// The delete disk snapshot operation supports tag-based access control via
// resource tags applied to the resource identified by disk snapshot name. For
// more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteDiskSnapshot for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDiskSnapshot
func (c *Lightsail) DeleteDiskSnapshot(input *DeleteDiskSnapshotInput) (*DeleteDiskSnapshotOutput, error) {
	req, out := c.DeleteDiskSnapshotRequest(input)
	return out, req.Send()
}

// DeleteDiskSnapshotWithContext is the same as DeleteDiskSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDiskSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteDiskSnapshotWithContext(ctx aws.Context, input *DeleteDiskSnapshotInput, opts ...request.Option) (*DeleteDiskSnapshotOutput, error) {
	req, out := c.DeleteDiskSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDistribution = "DeleteDistribution"

// DeleteDistributionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDistribution for more information on using the DeleteDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDistributionRequest method.
//    req, resp := client.DeleteDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDistribution
func (c *Lightsail) DeleteDistributionRequest(input *DeleteDistributionInput) (req *request.Request, output *DeleteDistributionOutput) {
	op := &request.Operation{
		Name:       opDeleteDistribution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDistributionInput{}
	}

	output = &DeleteDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDistribution API operation for Amazon Lightsail.
//
// Deletes your Amazon Lightsail content delivery network (CDN) distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteDistribution for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDistribution
func (c *Lightsail) DeleteDistribution(input *DeleteDistributionInput) (*DeleteDistributionOutput, error) {
	req, out := c.DeleteDistributionRequest(input)
	return out, req.Send()
}

// DeleteDistributionWithContext is the same as DeleteDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteDistributionWithContext(ctx aws.Context, input *DeleteDistributionInput, opts ...request.Option) (*DeleteDistributionOutput, error) {
	req, out := c.DeleteDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomain for more information on using the DeleteDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDomainRequest method.
//    req, resp := client.DeleteDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomain
func (c *Lightsail) DeleteDomainRequest(input *DeleteDomainInput) (req *request.Request, output *DeleteDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	output = &DeleteDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDomain API operation for Amazon Lightsail.
//
// Deletes the specified domain recordset and all of its domain records.
//
// The delete domain operation supports tag-based access control via resource
// tags applied to the resource identified by domain name. For more information,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteDomain for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomain
func (c *Lightsail) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	return out, req.Send()
}

// DeleteDomainWithContext is the same as DeleteDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteDomainWithContext(ctx aws.Context, input *DeleteDomainInput, opts ...request.Option) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomainEntry = "DeleteDomainEntry"

// DeleteDomainEntryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomainEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomainEntry for more information on using the DeleteDomainEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDomainEntryRequest method.
//    req, resp := client.DeleteDomainEntryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntry
func (c *Lightsail) DeleteDomainEntryRequest(input *DeleteDomainEntryInput) (req *request.Request, output *DeleteDomainEntryOutput) {
	op := &request.Operation{
		Name:       opDeleteDomainEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDomainEntryInput{}
	}

	output = &DeleteDomainEntryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDomainEntry API operation for Amazon Lightsail.
//
// Deletes a specific domain entry.
//
// The delete domain entry operation supports tag-based access control via resource
// tags applied to the resource identified by domain name. For more information,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteDomainEntry for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntry
func (c *Lightsail) DeleteDomainEntry(input *DeleteDomainEntryInput) (*DeleteDomainEntryOutput, error) {
	req, out := c.DeleteDomainEntryRequest(input)
	return out, req.Send()
}

// DeleteDomainEntryWithContext is the same as DeleteDomainEntry with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomainEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteDomainEntryWithContext(ctx aws.Context, input *DeleteDomainEntryInput, opts ...request.Option) (*DeleteDomainEntryOutput, error) {
	req, out := c.DeleteDomainEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstance = "DeleteInstance"

// DeleteInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstance for more information on using the DeleteInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInstanceRequest method.
//    req, resp := client.DeleteInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance
func (c *Lightsail) DeleteInstanceRequest(input *DeleteInstanceInput) (req *request.Request, output *DeleteInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceInput{}
	}

	output = &DeleteInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInstance API operation for Amazon Lightsail.
//
// Deletes an Amazon Lightsail instance.
//
// The delete instance operation supports tag-based access control via resource
// tags applied to the resource identified by instance name. For more information,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteInstance for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance
func (c *Lightsail) DeleteInstance(input *DeleteInstanceInput) (*DeleteInstanceOutput, error) {
	req, out := c.DeleteInstanceRequest(input)
	return out, req.Send()
}

// DeleteInstanceWithContext is the same as DeleteInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteInstanceWithContext(ctx aws.Context, input *DeleteInstanceInput, opts ...request.Option) (*DeleteInstanceOutput, error) {
	req, out := c.DeleteInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstanceSnapshot = "DeleteInstanceSnapshot"

// DeleteInstanceSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstanceSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstanceSnapshot for more information on using the DeleteInstanceSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInstanceSnapshotRequest method.
//    req, resp := client.DeleteInstanceSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshot
func (c *Lightsail) DeleteInstanceSnapshotRequest(input *DeleteInstanceSnapshotInput) (req *request.Request, output *DeleteInstanceSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteInstanceSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceSnapshotInput{}
	}

	output = &DeleteInstanceSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInstanceSnapshot API operation for Amazon Lightsail.
//
// Deletes a specific snapshot of a virtual private server (or instance).
//
// The delete instance snapshot operation supports tag-based access control
// via resource tags applied to the resource identified by instance snapshot
// name. For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteInstanceSnapshot for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshot
func (c *Lightsail) DeleteInstanceSnapshot(input *DeleteInstanceSnapshotInput) (*DeleteInstanceSnapshotOutput, error) {
	req, out := c.DeleteInstanceSnapshotRequest(input)
	return out, req.Send()
}

// DeleteInstanceSnapshotWithContext is the same as DeleteInstanceSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstanceSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteInstanceSnapshotWithContext(ctx aws.Context, input *DeleteInstanceSnapshotInput, opts ...request.Option) (*DeleteInstanceSnapshotOutput, error) {
	req, out := c.DeleteInstanceSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKeyPair = "DeleteKeyPair"

// DeleteKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKeyPair for more information on using the DeleteKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteKeyPairRequest method.
//    req, resp := client.DeleteKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair
func (c *Lightsail) DeleteKeyPairRequest(input *DeleteKeyPairInput) (req *request.Request, output *DeleteKeyPairOutput) {
	op := &request.Operation{
		Name:       opDeleteKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteKeyPairInput{}
	}

	output = &DeleteKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteKeyPair API operation for Amazon Lightsail.
//
// Deletes a specific SSH key pair.
//
// The delete key pair operation supports tag-based access control via resource
// tags applied to the resource identified by key pair name. For more information,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteKeyPair for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair
func (c *Lightsail) DeleteKeyPair(input *DeleteKeyPairInput) (*DeleteKeyPairOutput, error) {
	req, out := c.DeleteKeyPairRequest(input)
	return out, req.Send()
}

// DeleteKeyPairWithContext is the same as DeleteKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteKeyPairWithContext(ctx aws.Context, input *DeleteKeyPairInput, opts ...request.Option) (*DeleteKeyPairOutput, error) {
	req, out := c.DeleteKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKnownHostKeys = "DeleteKnownHostKeys"

// DeleteKnownHostKeysRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKnownHostKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKnownHostKeys for more information on using the DeleteKnownHostKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteKnownHostKeysRequest method.
//    req, resp := client.DeleteKnownHostKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKnownHostKeys
func (c *Lightsail) DeleteKnownHostKeysRequest(input *DeleteKnownHostKeysInput) (req *request.Request, output *DeleteKnownHostKeysOutput) {
	op := &request.Operation{
		Name:       opDeleteKnownHostKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteKnownHostKeysInput{}
	}

	output = &DeleteKnownHostKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteKnownHostKeys API operation for Amazon Lightsail.
//
// Deletes the known host key or certificate used by the Amazon Lightsail browser-based
// SSH or RDP clients to authenticate an instance. This operation enables the
// Lightsail browser-based SSH or RDP clients to connect to the instance after
// a host key mismatch.
//
// Perform this operation only if you were expecting the host key or certificate
// mismatch or if you are familiar with the new host key or certificate on the
// instance. For more information, see Troubleshooting connection issues when
// using the Amazon Lightsail browser-based SSH or RDP client (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-troubleshooting-browser-based-ssh-rdp-client-connection).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteKnownHostKeys for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKnownHostKeys
func (c *Lightsail) DeleteKnownHostKeys(input *DeleteKnownHostKeysInput) (*DeleteKnownHostKeysOutput, error) {
	req, out := c.DeleteKnownHostKeysRequest(input)
	return out, req.Send()
}

// DeleteKnownHostKeysWithContext is the same as DeleteKnownHostKeys with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKnownHostKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteKnownHostKeysWithContext(ctx aws.Context, input *DeleteKnownHostKeysInput, opts ...request.Option) (*DeleteKnownHostKeysOutput, error) {
	req, out := c.DeleteKnownHostKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLoadBalancer = "DeleteLoadBalancer"

// DeleteLoadBalancerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLoadBalancer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLoadBalancer for more information on using the DeleteLoadBalancer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLoadBalancerRequest method.
//    req, resp := client.DeleteLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancer
func (c *Lightsail) DeleteLoadBalancerRequest(input *DeleteLoadBalancerInput) (req *request.Request, output *DeleteLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opDeleteLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoadBalancerInput{}
	}

	output = &DeleteLoadBalancerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLoadBalancer API operation for Amazon Lightsail.
//
// Deletes a Lightsail load balancer and all its associated SSL/TLS certificates.
// Once the load balancer is deleted, you will need to create a new load balancer,
// create a new certificate, and verify domain ownership again.
//
// The delete load balancer operation supports tag-based access control via
// resource tags applied to the resource identified by load balancer name. For
// more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteLoadBalancer for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancer
func (c *Lightsail) DeleteLoadBalancer(input *DeleteLoadBalancerInput) (*DeleteLoadBalancerOutput, error) {
	req, out := c.DeleteLoadBalancerRequest(input)
	return out, req.Send()
}

// DeleteLoadBalancerWithContext is the same as DeleteLoadBalancer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLoadBalancer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteLoadBalancerWithContext(ctx aws.Context, input *DeleteLoadBalancerInput, opts ...request.Option) (*DeleteLoadBalancerOutput, error) {
	req, out := c.DeleteLoadBalancerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLoadBalancerTlsCertificate = "DeleteLoadBalancerTlsCertificate"

// DeleteLoadBalancerTlsCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLoadBalancerTlsCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLoadBalancerTlsCertificate for more information on using the DeleteLoadBalancerTlsCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLoadBalancerTlsCertificateRequest method.
//    req, resp := client.DeleteLoadBalancerTlsCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancerTlsCertificate
func (c *Lightsail) DeleteLoadBalancerTlsCertificateRequest(input *DeleteLoadBalancerTlsCertificateInput) (req *request.Request, output *DeleteLoadBalancerTlsCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteLoadBalancerTlsCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoadBalancerTlsCertificateInput{}
	}

	output = &DeleteLoadBalancerTlsCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLoadBalancerTlsCertificate API operation for Amazon Lightsail.
//
// Deletes an SSL/TLS certificate associated with a Lightsail load balancer.
//
// The DeleteLoadBalancerTlsCertificate operation supports tag-based access
// control via resource tags applied to the resource identified by load balancer
// name. For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteLoadBalancerTlsCertificate for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancerTlsCertificate
func (c *Lightsail) DeleteLoadBalancerTlsCertificate(input *DeleteLoadBalancerTlsCertificateInput) (*DeleteLoadBalancerTlsCertificateOutput, error) {
	req, out := c.DeleteLoadBalancerTlsCertificateRequest(input)
	return out, req.Send()
}

// DeleteLoadBalancerTlsCertificateWithContext is the same as DeleteLoadBalancerTlsCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLoadBalancerTlsCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteLoadBalancerTlsCertificateWithContext(ctx aws.Context, input *DeleteLoadBalancerTlsCertificateInput, opts ...request.Option) (*DeleteLoadBalancerTlsCertificateOutput, error) {
	req, out := c.DeleteLoadBalancerTlsCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRelationalDatabase = "DeleteRelationalDatabase"

// DeleteRelationalDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRelationalDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRelationalDatabase for more information on using the DeleteRelationalDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRelationalDatabaseRequest method.
//    req, resp := client.DeleteRelationalDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabase
func (c *Lightsail) DeleteRelationalDatabaseRequest(input *DeleteRelationalDatabaseInput) (req *request.Request, output *DeleteRelationalDatabaseOutput) {
	op := &request.Operation{
		Name:       opDeleteRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRelationalDatabaseInput{}
	}

	output = &DeleteRelationalDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRelationalDatabase API operation for Amazon Lightsail.
//
// Deletes a database in Amazon Lightsail.
//
// The delete relational database operation supports tag-based access control
// via resource tags applied to the resource identified by relationalDatabaseName.
// For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteRelationalDatabase for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabase
func (c *Lightsail) DeleteRelationalDatabase(input *DeleteRelationalDatabaseInput) (*DeleteRelationalDatabaseOutput, error) {
	req, out := c.DeleteRelationalDatabaseRequest(input)
	return out, req.Send()
}

// DeleteRelationalDatabaseWithContext is the same as DeleteRelationalDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRelationalDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteRelationalDatabaseWithContext(ctx aws.Context, input *DeleteRelationalDatabaseInput, opts ...request.Option) (*DeleteRelationalDatabaseOutput, error) {
	req, out := c.DeleteRelationalDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRelationalDatabaseSnapshot = "DeleteRelationalDatabaseSnapshot"

// DeleteRelationalDatabaseSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRelationalDatabaseSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRelationalDatabaseSnapshot for more information on using the DeleteRelationalDatabaseSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRelationalDatabaseSnapshotRequest method.
//    req, resp := client.DeleteRelationalDatabaseSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabaseSnapshot
func (c *Lightsail) DeleteRelationalDatabaseSnapshotRequest(input *DeleteRelationalDatabaseSnapshotInput) (req *request.Request, output *DeleteRelationalDatabaseSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteRelationalDatabaseSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRelationalDatabaseSnapshotInput{}
	}

	output = &DeleteRelationalDatabaseSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRelationalDatabaseSnapshot API operation for Amazon Lightsail.
//
// Deletes a database snapshot in Amazon Lightsail.
//
// The delete relational database snapshot operation supports tag-based access
// control via resource tags applied to the resource identified by relationalDatabaseName.
// For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteRelationalDatabaseSnapshot for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabaseSnapshot
func (c *Lightsail) DeleteRelationalDatabaseSnapshot(input *DeleteRelationalDatabaseSnapshotInput) (*DeleteRelationalDatabaseSnapshotOutput, error) {
	req, out := c.DeleteRelationalDatabaseSnapshotRequest(input)
	return out, req.Send()
}

// DeleteRelationalDatabaseSnapshotWithContext is the same as DeleteRelationalDatabaseSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRelationalDatabaseSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteRelationalDatabaseSnapshotWithContext(ctx aws.Context, input *DeleteRelationalDatabaseSnapshotInput, opts ...request.Option) (*DeleteRelationalDatabaseSnapshotOutput, error) {
	req, out := c.DeleteRelationalDatabaseSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachCertificateFromDistribution = "DetachCertificateFromDistribution"

// DetachCertificateFromDistributionRequest generates a "aws/request.Request" representing the
// client's request for the DetachCertificateFromDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachCertificateFromDistribution for more information on using the DetachCertificateFromDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachCertificateFromDistributionRequest method.
//    req, resp := client.DetachCertificateFromDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachCertificateFromDistribution
func (c *Lightsail) DetachCertificateFromDistributionRequest(input *DetachCertificateFromDistributionInput) (req *request.Request, output *DetachCertificateFromDistributionOutput) {
	op := &request.Operation{
		Name:       opDetachCertificateFromDistribution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachCertificateFromDistributionInput{}
	}

	output = &DetachCertificateFromDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetachCertificateFromDistribution API operation for Amazon Lightsail.
//
// Detaches an SSL/TLS certificate from your Amazon Lightsail content delivery
// network (CDN) distribution.
//
// After the certificate is detached, your distribution stops accepting traffic
// for all of the domains that are associated with the certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DetachCertificateFromDistribution for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachCertificateFromDistribution
func (c *Lightsail) DetachCertificateFromDistribution(input *DetachCertificateFromDistributionInput) (*DetachCertificateFromDistributionOutput, error) {
	req, out := c.DetachCertificateFromDistributionRequest(input)
	return out, req.Send()
}

// DetachCertificateFromDistributionWithContext is the same as DetachCertificateFromDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See DetachCertificateFromDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DetachCertificateFromDistributionWithContext(ctx aws.Context, input *DetachCertificateFromDistributionInput, opts ...request.Option) (*DetachCertificateFromDistributionOutput, error) {
	req, out := c.DetachCertificateFromDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachDisk = "DetachDisk"

// DetachDiskRequest generates a "aws/request.Request" representing the
// client's request for the DetachDisk operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachDisk for more information on using the DetachDisk
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachDiskRequest method.
//    req, resp := client.DetachDiskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachDisk
func (c *Lightsail) DetachDiskRequest(input *DetachDiskInput) (req *request.Request, output *DetachDiskOutput) {
	op := &request.Operation{
		Name:       opDetachDisk,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachDiskInput{}
	}

	output = &DetachDiskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetachDisk API operation for Amazon Lightsail.
//
// Detaches a stopped block storage disk from a Lightsail instance. Make sure
// to unmount any file systems on the device within your operating system before
// stopping the instance and detaching the disk.
//
// The detach disk operation supports tag-based access control via resource
// tags applied to the resource identified by disk name. For more information,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DetachDisk for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachDisk
func (c *Lightsail) DetachDisk(input *DetachDiskInput) (*DetachDiskOutput, error) {
	req, out := c.DetachDiskRequest(input)
	return out, req.Send()
}

// DetachDiskWithContext is the same as DetachDisk with the addition of
// the ability to pass a context and additional request options.
//
// See DetachDisk for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DetachDiskWithContext(ctx aws.Context, input *DetachDiskInput, opts ...request.Option) (*DetachDiskOutput, error) {
	req, out := c.DetachDiskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachInstancesFromLoadBalancer = "DetachInstancesFromLoadBalancer"

// DetachInstancesFromLoadBalancerRequest generates a "aws/request.Request" representing the
// client's request for the DetachInstancesFromLoadBalancer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachInstancesFromLoadBalancer for more information on using the DetachInstancesFromLoadBalancer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachInstancesFromLoadBalancerRequest method.
//    req, resp := client.DetachInstancesFromLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachInstancesFromLoadBalancer
func (c *Lightsail) DetachInstancesFromLoadBalancerRequest(input *DetachInstancesFromLoadBalancerInput) (req *request.Request, output *DetachInstancesFromLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opDetachInstancesFromLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachInstancesFromLoadBalancerInput{}
	}

	output = &DetachInstancesFromLoadBalancerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetachInstancesFromLoadBalancer API operation for Amazon Lightsail.
//
// Detaches the specified instances from a Lightsail load balancer.
//
// This operation waits until the instances are no longer needed before they
// are detached from the load balancer.
//
// The detach instances from load balancer operation supports tag-based access
// control via resource tags applied to the resource identified by load balancer
// name. For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DetachInstancesFromLoadBalancer for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachInstancesFromLoadBalancer
func (c *Lightsail) DetachInstancesFromLoadBalancer(input *DetachInstancesFromLoadBalancerInput) (*DetachInstancesFromLoadBalancerOutput, error) {
	req, out := c.DetachInstancesFromLoadBalancerRequest(input)
	return out, req.Send()
}

// DetachInstancesFromLoadBalancerWithContext is the same as DetachInstancesFromLoadBalancer with the addition of
// the ability to pass a context and additional request options.
//
// See DetachInstancesFromLoadBalancer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DetachInstancesFromLoadBalancerWithContext(ctx aws.Context, input *DetachInstancesFromLoadBalancerInput, opts ...request.Option) (*DetachInstancesFromLoadBalancerOutput, error) {
	req, out := c.DetachInstancesFromLoadBalancerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachStaticIp = "DetachStaticIp"

// DetachStaticIpRequest generates a "aws/request.Request" representing the
// client's request for the DetachStaticIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachStaticIp for more information on using the DetachStaticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachStaticIpRequest method.
//    req, resp := client.DetachStaticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIp
func (c *Lightsail) DetachStaticIpRequest(input *DetachStaticIpInput) (req *request.Request, output *DetachStaticIpOutput) {
	op := &request.Operation{
		Name:       opDetachStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachStaticIpInput{}
	}

	output = &DetachStaticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetachStaticIp API operation for Amazon Lightsail.
//
// Detaches a static IP from the Amazon Lightsail instance to which it is attached.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DetachStaticIp for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIp
func (c *Lightsail) DetachStaticIp(input *DetachStaticIpInput) (*DetachStaticIpOutput, error) {
	req, out := c.DetachStaticIpRequest(input)
	return out, req.Send()
}

// DetachStaticIpWithContext is the same as DetachStaticIp with the addition of
// the ability to pass a context and additional request options.
//
// See DetachStaticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DetachStaticIpWithContext(ctx aws.Context, input *DetachStaticIpInput, opts ...request.Option) (*DetachStaticIpOutput, error) {
	req, out := c.DetachStaticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableAddOn = "DisableAddOn"

// DisableAddOnRequest generates a "aws/request.Request" representing the
// client's request for the DisableAddOn operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableAddOn for more information on using the DisableAddOn
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableAddOnRequest method.
//    req, resp := client.DisableAddOnRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DisableAddOn
func (c *Lightsail) DisableAddOnRequest(input *DisableAddOnInput) (req *request.Request, output *DisableAddOnOutput) {
	op := &request.Operation{
		Name:       opDisableAddOn,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableAddOnInput{}
	}

	output = &DisableAddOnOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableAddOn API operation for Amazon Lightsail.
//
// Disables an add-on for an Amazon Lightsail resource. For more information,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DisableAddOn for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DisableAddOn
func (c *Lightsail) DisableAddOn(input *DisableAddOnInput) (*DisableAddOnOutput, error) {
	req, out := c.DisableAddOnRequest(input)
	return out, req.Send()
}

// DisableAddOnWithContext is the same as DisableAddOn with the addition of
// the ability to pass a context and additional request options.
//
// See DisableAddOn for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DisableAddOnWithContext(ctx aws.Context, input *DisableAddOnInput, opts ...request.Option) (*DisableAddOnOutput, error) {
	req, out := c.DisableAddOnRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDownloadDefaultKeyPair = "DownloadDefaultKeyPair"

// DownloadDefaultKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the DownloadDefaultKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DownloadDefaultKeyPair for more information on using the DownloadDefaultKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DownloadDefaultKeyPairRequest method.
//    req, resp := client.DownloadDefaultKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair
func (c *Lightsail) DownloadDefaultKeyPairRequest(input *DownloadDefaultKeyPairInput) (req *request.Request, output *DownloadDefaultKeyPairOutput) {
	op := &request.Operation{
		Name:       opDownloadDefaultKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DownloadDefaultKeyPairInput{}
	}

	output = &DownloadDefaultKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DownloadDefaultKeyPair API operation for Amazon Lightsail.
//
// Downloads the default SSH key pair from the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DownloadDefaultKeyPair for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair
func (c *Lightsail) DownloadDefaultKeyPair(input *DownloadDefaultKeyPairInput) (*DownloadDefaultKeyPairOutput, error) {
	req, out := c.DownloadDefaultKeyPairRequest(input)
	return out, req.Send()
}

// DownloadDefaultKeyPairWithContext is the same as DownloadDefaultKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See DownloadDefaultKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DownloadDefaultKeyPairWithContext(ctx aws.Context, input *DownloadDefaultKeyPairInput, opts ...request.Option) (*DownloadDefaultKeyPairOutput, error) {
	req, out := c.DownloadDefaultKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableAddOn = "EnableAddOn"

// EnableAddOnRequest generates a "aws/request.Request" representing the
// client's request for the EnableAddOn operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableAddOn for more information on using the EnableAddOn
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableAddOnRequest method.
//    req, resp := client.EnableAddOnRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/EnableAddOn
func (c *Lightsail) EnableAddOnRequest(input *EnableAddOnInput) (req *request.Request, output *EnableAddOnOutput) {
	op := &request.Operation{
		Name:       opEnableAddOn,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableAddOnInput{}
	}

	output = &EnableAddOnOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableAddOn API operation for Amazon Lightsail.
//
// Enables or modifies an add-on for an Amazon Lightsail resource. For more
// information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation EnableAddOn for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/EnableAddOn
func (c *Lightsail) EnableAddOn(input *EnableAddOnInput) (*EnableAddOnOutput, error) {
	req, out := c.EnableAddOnRequest(input)
	return out, req.Send()
}

// EnableAddOnWithContext is the same as EnableAddOn with the addition of
// the ability to pass a context and additional request options.
//
// See EnableAddOn for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) EnableAddOnWithContext(ctx aws.Context, input *EnableAddOnInput, opts ...request.Option) (*EnableAddOnOutput, error) {
	req, out := c.EnableAddOnRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportSnapshot = "ExportSnapshot"

// ExportSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the ExportSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportSnapshot for more information on using the ExportSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExportSnapshotRequest method.
//    req, resp := client.ExportSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ExportSnapshot
func (c *Lightsail) ExportSnapshotRequest(input *ExportSnapshotInput) (req *request.Request, output *ExportSnapshotOutput) {
	op := &request.Operation{
		Name:       opExportSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExportSnapshotInput{}
	}

	output = &ExportSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportSnapshot API operation for Amazon Lightsail.
//
// Exports an Amazon Lightsail instance or block storage disk snapshot to Amazon
// Elastic Compute Cloud (Amazon EC2). This operation results in an export snapshot
// record that can be used with the create cloud formation stack operation to
// create new Amazon EC2 instances.
//
// Exported instance snapshots appear in Amazon EC2 as Amazon Machine Images
// (AMIs), and the instance system disk appears as an Amazon Elastic Block Store
// (Amazon EBS) volume. Exported disk snapshots appear in Amazon EC2 as Amazon
// EBS volumes. Snapshots are exported to the same Amazon Web Services Region
// in Amazon EC2 as the source Lightsail snapshot.
//
// The export snapshot operation supports tag-based access control via resource
// tags applied to the resource identified by source snapshot name. For more
// information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Use the get instance snapshots or get disk snapshots operations to get a
// list of snapshots that you can export to Amazon EC2.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation ExportSnapshot for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ExportSnapshot
func (c *Lightsail) ExportSnapshot(input *ExportSnapshotInput) (*ExportSnapshotOutput, error) {
	req, out := c.ExportSnapshotRequest(input)
	return out, req.Send()
}

// ExportSnapshotWithContext is the same as ExportSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See ExportSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) ExportSnapshotWithContext(ctx aws.Context, input *ExportSnapshotInput, opts ...request.Option) (*ExportSnapshotOutput, error) {
	req, out := c.ExportSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetActiveNames = "GetActiveNames"

// GetActiveNamesRequest generates a "aws/request.Request" representing the
// client's request for the GetActiveNames operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetActiveNames for more information on using the GetActiveNames
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetActiveNamesRequest method.
//    req, resp := client.GetActiveNamesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames
func (c *Lightsail) GetActiveNamesRequest(input *GetActiveNamesInput) (req *request.Request, output *GetActiveNamesOutput) {
	op := &request.Operation{
		Name:       opGetActiveNames,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetActiveNamesInput{}
	}

	output = &GetActiveNamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetActiveNames API operation for Amazon Lightsail.
//
// Returns the names of all active (not deleted) resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetActiveNames for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames
func (c *Lightsail) GetActiveNames(input *GetActiveNamesInput) (*GetActiveNamesOutput, error) {
	req, out := c.GetActiveNamesRequest(input)
	return out, req.Send()
}

// GetActiveNamesWithContext is the same as GetActiveNames with the addition of
// the ability to pass a context and additional request options.
//
// See GetActiveNames for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetActiveNamesWithContext(ctx aws.Context, input *GetActiveNamesInput, opts ...request.Option) (*GetActiveNamesOutput, error) {
	req, out := c.GetActiveNamesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAlarms = "GetAlarms"

// GetAlarmsRequest generates a "aws/request.Request" representing the
// client's request for the GetAlarms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAlarms for more information on using the GetAlarms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAlarmsRequest method.
//    req, resp := client.GetAlarmsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetAlarms
func (c *Lightsail) GetAlarmsRequest(input *GetAlarmsInput) (req *request.Request, output *GetAlarmsOutput) {
	op := &request.Operation{
		Name:       opGetAlarms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAlarmsInput{}
	}

	output = &GetAlarmsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAlarms API operation for Amazon Lightsail.
//
// Returns information about the configured alarms. Specify an alarm name in
// your request to return information about a specific alarm, or specify a monitored
// resource name to return information about all alarms for a specific resource.
//
// An alarm is used to monitor a single metric for one of your resources. When
// a metric condition is met, the alarm can notify you by email, SMS text message,
// and a banner displayed on the Amazon Lightsail console. For more information,
// see Alarms in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetAlarms for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetAlarms
func (c *Lightsail) GetAlarms(input *GetAlarmsInput) (*GetAlarmsOutput, error) {
	req, out := c.GetAlarmsRequest(input)
	return out, req.Send()
}

// GetAlarmsWithContext is the same as GetAlarms with the addition of
// the ability to pass a context and additional request options.
//
// See GetAlarms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetAlarmsWithContext(ctx aws.Context, input *GetAlarmsInput, opts ...request.Option) (*GetAlarmsOutput, error) {
	req, out := c.GetAlarmsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAutoSnapshots = "GetAutoSnapshots"

// GetAutoSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the GetAutoSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAutoSnapshots for more information on using the GetAutoSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAutoSnapshotsRequest method.
//    req, resp := client.GetAutoSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetAutoSnapshots
func (c *Lightsail) GetAutoSnapshotsRequest(input *GetAutoSnapshotsInput) (req *request.Request, output *GetAutoSnapshotsOutput) {
	op := &request.Operation{
		Name:       opGetAutoSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAutoSnapshotsInput{}
	}

	output = &GetAutoSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAutoSnapshots API operation for Amazon Lightsail.
//
// Returns the available automatic snapshots for an instance or disk. For more
// information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetAutoSnapshots for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetAutoSnapshots
func (c *Lightsail) GetAutoSnapshots(input *GetAutoSnapshotsInput) (*GetAutoSnapshotsOutput, error) {
	req, out := c.GetAutoSnapshotsRequest(input)
	return out, req.Send()
}

// GetAutoSnapshotsWithContext is the same as GetAutoSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See GetAutoSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetAutoSnapshotsWithContext(ctx aws.Context, input *GetAutoSnapshotsInput, opts ...request.Option) (*GetAutoSnapshotsOutput, error) {
	req, out := c.GetAutoSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBlueprints = "GetBlueprints"

// GetBlueprintsRequest generates a "aws/request.Request" representing the
// client's request for the GetBlueprints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBlueprints for more information on using the GetBlueprints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBlueprintsRequest method.
//    req, resp := client.GetBlueprintsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints
func (c *Lightsail) GetBlueprintsRequest(input *GetBlueprintsInput) (req *request.Request, output *GetBlueprintsOutput) {
	op := &request.Operation{
		Name:       opGetBlueprints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBlueprintsInput{}
	}

	output = &GetBlueprintsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBlueprints API operation for Amazon Lightsail.
//
// Returns the list of available instance images, or blueprints. You can use
// a blueprint to create a new instance already running a specific operating
// system, as well as a preinstalled app or development stack. The software
// each instance is running depends on the blueprint image you choose.
//
// Use active blueprints when creating new instances. Inactive blueprints are
// listed to support customers with existing instances and are not necessarily
// available to create new instances. Blueprints are marked inactive when they
// become outdated due to operating system updates or new application releases.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetBlueprints for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints
func (c *Lightsail) GetBlueprints(input *GetBlueprintsInput) (*GetBlueprintsOutput, error) {
	req, out := c.GetBlueprintsRequest(input)
	return out, req.Send()
}

// GetBlueprintsWithContext is the same as GetBlueprints with the addition of
// the ability to pass a context and additional request options.
//
// See GetBlueprints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetBlueprintsWithContext(ctx aws.Context, input *GetBlueprintsInput, opts ...request.Option) (*GetBlueprintsOutput, error) {
	req, out := c.GetBlueprintsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketAccessKeys = "GetBucketAccessKeys"

// GetBucketAccessKeysRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketAccessKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketAccessKeys for more information on using the GetBucketAccessKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketAccessKeysRequest method.
//    req, resp := client.GetBucketAccessKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBucketAccessKeys
func (c *Lightsail) GetBucketAccessKeysRequest(input *GetBucketAccessKeysInput) (req *request.Request, output *GetBucketAccessKeysOutput) {
	op := &request.Operation{
		Name:       opGetBucketAccessKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBucketAccessKeysInput{}
	}

	output = &GetBucketAccessKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketAccessKeys API operation for Amazon Lightsail.
//
// Returns the existing access key IDs for the specified Amazon Lightsail bucket.
//
// This action does not return the secret access key value of an access key.
// You can get a secret access key only when you create it from the response
// of the CreateBucketAccessKey action. If you lose the secret access key, you
// must create a new access key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetBucketAccessKeys for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ServiceException
//   A general service exception.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBucketAccessKeys
func (c *Lightsail) GetBucketAccessKeys(input *GetBucketAccessKeysInput) (*GetBucketAccessKeysOutput, error) {
	req, out := c.GetBucketAccessKeysRequest(input)
	return out, req.Send()
}

// GetBucketAccessKeysWithContext is the same as GetBucketAccessKeys with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketAccessKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetBucketAccessKeysWithContext(ctx aws.Context, input *GetBucketAccessKeysInput, opts ...request.Option) (*GetBucketAccessKeysOutput, error) {
	req, out := c.GetBucketAccessKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketBundles = "GetBucketBundles"

// GetBucketBundlesRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketBundles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketBundles for more information on using the GetBucketBundles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketBundlesRequest method.
//    req, resp := client.GetBucketBundlesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBucketBundles
func (c *Lightsail) GetBucketBundlesRequest(input *GetBucketBundlesInput) (req *request.Request, output *GetBucketBundlesOutput) {
	op := &request.Operation{
		Name:       opGetBucketBundles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBucketBundlesInput{}
	}

	output = &GetBucketBundlesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketBundles API operation for Amazon Lightsail.
//
// Returns the bundles that you can apply to a Amazon Lightsail bucket.
//
// The bucket bundle specifies the monthly cost, storage quota, and data transfer
// quota for a bucket.
//
// Use the UpdateBucketBundle action to update the bundle for a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetBucketBundles for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * ServiceException
//   A general service exception.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBucketBundles
func (c *Lightsail) GetBucketBundles(input *GetBucketBundlesInput) (*GetBucketBundlesOutput, error) {
	req, out := c.GetBucketBundlesRequest(input)
	return out, req.Send()
}

// GetBucketBundlesWithContext is the same as GetBucketBundles with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketBundles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetBucketBundlesWithContext(ctx aws.Context, input *GetBucketBundlesInput, opts ...request.Option) (*GetBucketBundlesOutput, error) {
	req, out := c.GetBucketBundlesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketMetricData = "GetBucketMetricData"

// GetBucketMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketMetricData for more information on using the GetBucketMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketMetricDataRequest method.
//    req, resp := client.GetBucketMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBucketMetricData
func (c *Lightsail) GetBucketMetricDataRequest(input *GetBucketMetricDataInput) (req *request.Request, output *GetBucketMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetBucketMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBucketMetricDataInput{}
	}

	output = &GetBucketMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketMetricData API operation for Amazon Lightsail.
//
// Returns the data points of a specific metric for an Amazon Lightsail bucket.
//
// Metrics report the utilization of a bucket. View and collect metric data
// regularly to monitor the number of objects stored in a bucket (including
// object versions) and the storage space used by those objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetBucketMetricData for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ServiceException
//   A general service exception.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBucketMetricData
func (c *Lightsail) GetBucketMetricData(input *GetBucketMetricDataInput) (*GetBucketMetricDataOutput, error) {
	req, out := c.GetBucketMetricDataRequest(input)
	return out, req.Send()
}

// GetBucketMetricDataWithContext is the same as GetBucketMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetBucketMetricDataWithContext(ctx aws.Context, input *GetBucketMetricDataInput, opts ...request.Option) (*GetBucketMetricDataOutput, error) {
	req, out := c.GetBucketMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBuckets = "GetBuckets"

// GetBucketsRequest generates a "aws/request.Request" representing the
// client's request for the GetBuckets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBuckets for more information on using the GetBuckets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketsRequest method.
//    req, resp := client.GetBucketsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBuckets
func (c *Lightsail) GetBucketsRequest(input *GetBucketsInput) (req *request.Request, output *GetBucketsOutput) {
	op := &request.Operation{
		Name:       opGetBuckets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBucketsInput{}
	}

	output = &GetBucketsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBuckets API operation for Amazon Lightsail.
//
// Returns information about one or more Amazon Lightsail buckets.
//
// For more information about buckets, see Buckets in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/buckets-in-amazon-lightsail)
// in the Amazon Lightsail Developer Guide..
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetBuckets for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ServiceException
//   A general service exception.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBuckets
func (c *Lightsail) GetBuckets(input *GetBucketsInput) (*GetBucketsOutput, error) {
	req, out := c.GetBucketsRequest(input)
	return out, req.Send()
}

// GetBucketsWithContext is the same as GetBuckets with the addition of
// the ability to pass a context and additional request options.
//
// See GetBuckets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetBucketsWithContext(ctx aws.Context, input *GetBucketsInput, opts ...request.Option) (*GetBucketsOutput, error) {
	req, out := c.GetBucketsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBundles = "GetBundles"

// GetBundlesRequest generates a "aws/request.Request" representing the
// client's request for the GetBundles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBundles for more information on using the GetBundles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBundlesRequest method.
//    req, resp := client.GetBundlesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles
func (c *Lightsail) GetBundlesRequest(input *GetBundlesInput) (req *request.Request, output *GetBundlesOutput) {
	op := &request.Operation{
		Name:       opGetBundles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBundlesInput{}
	}

	output = &GetBundlesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBundles API operation for Amazon Lightsail.
//
// Returns the list of bundles that are available for purchase. A bundle describes
// the specs for your virtual private server (or instance).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetBundles for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles
func (c *Lightsail) GetBundles(input *GetBundlesInput) (*GetBundlesOutput, error) {
	req, out := c.GetBundlesRequest(input)
	return out, req.Send()
}

// GetBundlesWithContext is the same as GetBundles with the addition of
// the ability to pass a context and additional request options.
//
// See GetBundles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetBundlesWithContext(ctx aws.Context, input *GetBundlesInput, opts ...request.Option) (*GetBundlesOutput, error) {
	req, out := c.GetBundlesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCertificates = "GetCertificates"

// GetCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the GetCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCertificates for more information on using the GetCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCertificatesRequest method.
//    req, resp := client.GetCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetCertificates
func (c *Lightsail) GetCertificatesRequest(input *GetCertificatesInput) (req *request.Request, output *GetCertificatesOutput) {
	op := &request.Operation{
		Name:       opGetCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCertificatesInput{}
	}

	output = &GetCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCertificates API operation for Amazon Lightsail.
//
// Returns information about one or more Amazon Lightsail SSL/TLS certificates.
//
// To get a summary of a certificate, ommit includeCertificateDetails from your
// request. The response will include only the certificate Amazon Resource Name
// (ARN), certificate name, domain name, and tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetCertificates for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetCertificates
func (c *Lightsail) GetCertificates(input *GetCertificatesInput) (*GetCertificatesOutput, error) {
	req, out := c.GetCertificatesRequest(input)
	return out, req.Send()
}

// GetCertificatesWithContext is the same as GetCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See GetCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetCertificatesWithContext(ctx aws.Context, input *GetCertificatesInput, opts ...request.Option) (*GetCertificatesOutput, error) {
	req, out := c.GetCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCloudFormationStackRecords = "GetCloudFormationStackRecords"

// GetCloudFormationStackRecordsRequest generates a "aws/request.Request" representing the
// client's request for the GetCloudFormationStackRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCloudFormationStackRecords for more information on using the GetCloudFormationStackRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCloudFormationStackRecordsRequest method.
//    req, resp := client.GetCloudFormationStackRecordsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetCloudFormationStackRecords
func (c *Lightsail) GetCloudFormationStackRecordsRequest(input *GetCloudFormationStackRecordsInput) (req *request.Request, output *GetCloudFormationStackRecordsOutput) {
	op := &request.Operation{
		Name:       opGetCloudFormationStackRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCloudFormationStackRecordsInput{}
	}

	output = &GetCloudFormationStackRecordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCloudFormationStackRecords API operation for Amazon Lightsail.
//
// Returns the CloudFormation stack record created as a result of the create
// cloud formation stack operation.
//
// An AWS CloudFormation stack is used to create a new Amazon EC2 instance from
// an exported Lightsail snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetCloudFormationStackRecords for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetCloudFormationStackRecords
func (c *Lightsail) GetCloudFormationStackRecords(input *GetCloudFormationStackRecordsInput) (*GetCloudFormationStackRecordsOutput, error) {
	req, out := c.GetCloudFormationStackRecordsRequest(input)
	return out, req.Send()
}

// GetCloudFormationStackRecordsWithContext is the same as GetCloudFormationStackRecords with the addition of
// the ability to pass a context and additional request options.
//
// See GetCloudFormationStackRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetCloudFormationStackRecordsWithContext(ctx aws.Context, input *GetCloudFormationStackRecordsInput, opts ...request.Option) (*GetCloudFormationStackRecordsOutput, error) {
	req, out := c.GetCloudFormationStackRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContactMethods = "GetContactMethods"

// GetContactMethodsRequest generates a "aws/request.Request" representing the
// client's request for the GetContactMethods operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContactMethods for more information on using the GetContactMethods
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContactMethodsRequest method.
//    req, resp := client.GetContactMethodsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContactMethods
func (c *Lightsail) GetContactMethodsRequest(input *GetContactMethodsInput) (req *request.Request, output *GetContactMethodsOutput) {
	op := &request.Operation{
		Name:       opGetContactMethods,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContactMethodsInput{}
	}

	output = &GetContactMethodsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContactMethods API operation for Amazon Lightsail.
//
// Returns information about the configured contact methods. Specify a protocol
// in your request to return information about a specific contact method.
//
// A contact method is used to send you notifications about your Amazon Lightsail
// resources. You can add one email address and one mobile phone number contact
// method in each AWS Region. However, SMS text messaging is not supported in
// some AWS Regions, and SMS text messages cannot be sent to some countries/regions.
// For more information, see Notifications in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetContactMethods for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContactMethods
func (c *Lightsail) GetContactMethods(input *GetContactMethodsInput) (*GetContactMethodsOutput, error) {
	req, out := c.GetContactMethodsRequest(input)
	return out, req.Send()
}

// GetContactMethodsWithContext is the same as GetContactMethods with the addition of
// the ability to pass a context and additional request options.
//
// See GetContactMethods for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetContactMethodsWithContext(ctx aws.Context, input *GetContactMethodsInput, opts ...request.Option) (*GetContactMethodsOutput, error) {
	req, out := c.GetContactMethodsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContainerAPIMetadata = "GetContainerAPIMetadata"

// GetContainerAPIMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetContainerAPIMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContainerAPIMetadata for more information on using the GetContainerAPIMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContainerAPIMetadataRequest method.
//    req, resp := client.GetContainerAPIMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerAPIMetadata
func (c *Lightsail) GetContainerAPIMetadataRequest(input *GetContainerAPIMetadataInput) (req *request.Request, output *GetContainerAPIMetadataOutput) {
	op := &request.Operation{
		Name:       opGetContainerAPIMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContainerAPIMetadataInput{}
	}

	output = &GetContainerAPIMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContainerAPIMetadata API operation for Amazon Lightsail.
//
// Returns information about Amazon Lightsail containers, such as the current
// version of the Lightsail Control (lightsailctl) plugin.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetContainerAPIMetadata for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerAPIMetadata
func (c *Lightsail) GetContainerAPIMetadata(input *GetContainerAPIMetadataInput) (*GetContainerAPIMetadataOutput, error) {
	req, out := c.GetContainerAPIMetadataRequest(input)
	return out, req.Send()
}

// GetContainerAPIMetadataWithContext is the same as GetContainerAPIMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetContainerAPIMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetContainerAPIMetadataWithContext(ctx aws.Context, input *GetContainerAPIMetadataInput, opts ...request.Option) (*GetContainerAPIMetadataOutput, error) {
	req, out := c.GetContainerAPIMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContainerImages = "GetContainerImages"

// GetContainerImagesRequest generates a "aws/request.Request" representing the
// client's request for the GetContainerImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContainerImages for more information on using the GetContainerImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContainerImagesRequest method.
//    req, resp := client.GetContainerImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerImages
func (c *Lightsail) GetContainerImagesRequest(input *GetContainerImagesInput) (req *request.Request, output *GetContainerImagesOutput) {
	op := &request.Operation{
		Name:       opGetContainerImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContainerImagesInput{}
	}

	output = &GetContainerImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContainerImages API operation for Amazon Lightsail.
//
// Returns the container images that are registered to your Amazon Lightsail
// container service.
//
// If you created a deployment on your Lightsail container service that uses
// container images from a public registry like Docker Hub, those images are
// not returned as part of this action. Those images are not registered to your
// Lightsail container service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetContainerImages for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerImages
func (c *Lightsail) GetContainerImages(input *GetContainerImagesInput) (*GetContainerImagesOutput, error) {
	req, out := c.GetContainerImagesRequest(input)
	return out, req.Send()
}

// GetContainerImagesWithContext is the same as GetContainerImages with the addition of
// the ability to pass a context and additional request options.
//
// See GetContainerImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetContainerImagesWithContext(ctx aws.Context, input *GetContainerImagesInput, opts ...request.Option) (*GetContainerImagesOutput, error) {
	req, out := c.GetContainerImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContainerLog = "GetContainerLog"

// GetContainerLogRequest generates a "aws/request.Request" representing the
// client's request for the GetContainerLog operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContainerLog for more information on using the GetContainerLog
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContainerLogRequest method.
//    req, resp := client.GetContainerLogRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerLog
func (c *Lightsail) GetContainerLogRequest(input *GetContainerLogInput) (req *request.Request, output *GetContainerLogOutput) {
	op := &request.Operation{
		Name:       opGetContainerLog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContainerLogInput{}
	}

	output = &GetContainerLogOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContainerLog API operation for Amazon Lightsail.
//
// Returns the log events of a container of your Amazon Lightsail container
// service.
//
// If your container service has more than one node (i.e., a scale greater than
// 1), then the log events that are returned for the specified container are
// merged from all nodes on your container service.
//
// Container logs are retained for a certain amount of time. For more information,
// see Amazon Lightsail endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/lightsail.html)
// in the AWS General Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetContainerLog for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerLog
func (c *Lightsail) GetContainerLog(input *GetContainerLogInput) (*GetContainerLogOutput, error) {
	req, out := c.GetContainerLogRequest(input)
	return out, req.Send()
}

// GetContainerLogWithContext is the same as GetContainerLog with the addition of
// the ability to pass a context and additional request options.
//
// See GetContainerLog for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetContainerLogWithContext(ctx aws.Context, input *GetContainerLogInput, opts ...request.Option) (*GetContainerLogOutput, error) {
	req, out := c.GetContainerLogRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContainerServiceDeployments = "GetContainerServiceDeployments"

// GetContainerServiceDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the GetContainerServiceDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContainerServiceDeployments for more information on using the GetContainerServiceDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContainerServiceDeploymentsRequest method.
//    req, resp := client.GetContainerServiceDeploymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServiceDeployments
func (c *Lightsail) GetContainerServiceDeploymentsRequest(input *GetContainerServiceDeploymentsInput) (req *request.Request, output *GetContainerServiceDeploymentsOutput) {
	op := &request.Operation{
		Name:       opGetContainerServiceDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContainerServiceDeploymentsInput{}
	}

	output = &GetContainerServiceDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContainerServiceDeployments API operation for Amazon Lightsail.
//
// Returns the deployments for your Amazon Lightsail container service
//
// A deployment specifies the settings, such as the ports and launch command,
// of containers that are deployed to your container service.
//
// The deployments are ordered by version in ascending order. The newest version
// is listed at the top of the response.
//
// A set number of deployments are kept before the oldest one is replaced with
// the newest one. For more information, see Amazon Lightsail endpoints and
// quotas (https://docs.aws.amazon.com/general/latest/gr/lightsail.html) in
// the AWS General Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetContainerServiceDeployments for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServiceDeployments
func (c *Lightsail) GetContainerServiceDeployments(input *GetContainerServiceDeploymentsInput) (*GetContainerServiceDeploymentsOutput, error) {
	req, out := c.GetContainerServiceDeploymentsRequest(input)
	return out, req.Send()
}

// GetContainerServiceDeploymentsWithContext is the same as GetContainerServiceDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See GetContainerServiceDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetContainerServiceDeploymentsWithContext(ctx aws.Context, input *GetContainerServiceDeploymentsInput, opts ...request.Option) (*GetContainerServiceDeploymentsOutput, error) {
	req, out := c.GetContainerServiceDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContainerServiceMetricData = "GetContainerServiceMetricData"

// GetContainerServiceMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetContainerServiceMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContainerServiceMetricData for more information on using the GetContainerServiceMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContainerServiceMetricDataRequest method.
//    req, resp := client.GetContainerServiceMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServiceMetricData
func (c *Lightsail) GetContainerServiceMetricDataRequest(input *GetContainerServiceMetricDataInput) (req *request.Request, output *GetContainerServiceMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetContainerServiceMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContainerServiceMetricDataInput{}
	}

	output = &GetContainerServiceMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContainerServiceMetricData API operation for Amazon Lightsail.
//
// Returns the data points of a specific metric of your Amazon Lightsail container
// service.
//
// Metrics report the utilization of your resources. Monitor and collect metric
// data regularly to maintain the reliability, availability, and performance
// of your resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetContainerServiceMetricData for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServiceMetricData
func (c *Lightsail) GetContainerServiceMetricData(input *GetContainerServiceMetricDataInput) (*GetContainerServiceMetricDataOutput, error) {
	req, out := c.GetContainerServiceMetricDataRequest(input)
	return out, req.Send()
}

// GetContainerServiceMetricDataWithContext is the same as GetContainerServiceMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetContainerServiceMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetContainerServiceMetricDataWithContext(ctx aws.Context, input *GetContainerServiceMetricDataInput, opts ...request.Option) (*GetContainerServiceMetricDataOutput, error) {
	req, out := c.GetContainerServiceMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContainerServicePowers = "GetContainerServicePowers"

// GetContainerServicePowersRequest generates a "aws/request.Request" representing the
// client's request for the GetContainerServicePowers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContainerServicePowers for more information on using the GetContainerServicePowers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContainerServicePowersRequest method.
//    req, resp := client.GetContainerServicePowersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServicePowers
func (c *Lightsail) GetContainerServicePowersRequest(input *GetContainerServicePowersInput) (req *request.Request, output *GetContainerServicePowersOutput) {
	op := &request.Operation{
		Name:       opGetContainerServicePowers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContainerServicePowersInput{}
	}

	output = &GetContainerServicePowersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContainerServicePowers API operation for Amazon Lightsail.
//
// Returns the list of powers that can be specified for your Amazon Lightsail
// container services.
//
// The power specifies the amount of memory, the number of vCPUs, and the base
// price of the container service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetContainerServicePowers for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServicePowers
func (c *Lightsail) GetContainerServicePowers(input *GetContainerServicePowersInput) (*GetContainerServicePowersOutput, error) {
	req, out := c.GetContainerServicePowersRequest(input)
	return out, req.Send()
}

// GetContainerServicePowersWithContext is the same as GetContainerServicePowers with the addition of
// the ability to pass a context and additional request options.
//
// See GetContainerServicePowers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetContainerServicePowersWithContext(ctx aws.Context, input *GetContainerServicePowersInput, opts ...request.Option) (*GetContainerServicePowersOutput, error) {
	req, out := c.GetContainerServicePowersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContainerServices = "GetContainerServices"

// GetContainerServicesRequest generates a "aws/request.Request" representing the
// client's request for the GetContainerServices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContainerServices for more information on using the GetContainerServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContainerServicesRequest method.
//    req, resp := client.GetContainerServicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServices
func (c *Lightsail) GetContainerServicesRequest(input *GetContainerServicesInput) (req *request.Request, output *GetContainerServicesOutput) {
	op := &request.Operation{
		Name:       opGetContainerServices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContainerServicesInput{}
	}

	output = &GetContainerServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContainerServices API operation for Amazon Lightsail.
//
// Returns information about one or more of your Amazon Lightsail container
// services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetContainerServices for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServices
func (c *Lightsail) GetContainerServices(input *GetContainerServicesInput) (*GetContainerServicesOutput, error) {
	req, out := c.GetContainerServicesRequest(input)
	return out, req.Send()
}

// GetContainerServicesWithContext is the same as GetContainerServices with the addition of
// the ability to pass a context and additional request options.
//
// See GetContainerServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetContainerServicesWithContext(ctx aws.Context, input *GetContainerServicesInput, opts ...request.Option) (*GetContainerServicesOutput, error) {
	req, out := c.GetContainerServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDisk = "GetDisk"

// GetDiskRequest generates a "aws/request.Request" representing the
// client's request for the GetDisk operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDisk for more information on using the GetDisk
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDiskRequest method.
//    req, resp := client.GetDiskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisk
func (c *Lightsail) GetDiskRequest(input *GetDiskInput) (req *request.Request, output *GetDiskOutput) {
	op := &request.Operation{
		Name:       opGetDisk,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDiskInput{}
	}

	output = &GetDiskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDisk API operation for Amazon Lightsail.
//
// Returns information about a specific block storage disk.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDisk for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisk
func (c *Lightsail) GetDisk(input *GetDiskInput) (*GetDiskOutput, error) {
	req, out := c.GetDiskRequest(input)
	return out, req.Send()
}

// GetDiskWithContext is the same as GetDisk with the addition of
// the ability to pass a context and additional request options.
//
// See GetDisk for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDiskWithContext(ctx aws.Context, input *GetDiskInput, opts ...request.Option) (*GetDiskOutput, error) {
	req, out := c.GetDiskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDiskSnapshot = "GetDiskSnapshot"

// GetDiskSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the GetDiskSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDiskSnapshot for more information on using the GetDiskSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDiskSnapshotRequest method.
//    req, resp := client.GetDiskSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshot
func (c *Lightsail) GetDiskSnapshotRequest(input *GetDiskSnapshotInput) (req *request.Request, output *GetDiskSnapshotOutput) {
	op := &request.Operation{
		Name:       opGetDiskSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDiskSnapshotInput{}
	}

	output = &GetDiskSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDiskSnapshot API operation for Amazon Lightsail.
//
// Returns information about a specific block storage disk snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDiskSnapshot for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshot
func (c *Lightsail) GetDiskSnapshot(input *GetDiskSnapshotInput) (*GetDiskSnapshotOutput, error) {
	req, out := c.GetDiskSnapshotRequest(input)
	return out, req.Send()
}

// GetDiskSnapshotWithContext is the same as GetDiskSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See GetDiskSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDiskSnapshotWithContext(ctx aws.Context, input *GetDiskSnapshotInput, opts ...request.Option) (*GetDiskSnapshotOutput, error) {
	req, out := c.GetDiskSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDiskSnapshots = "GetDiskSnapshots"

// GetDiskSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the GetDiskSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDiskSnapshots for more information on using the GetDiskSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDiskSnapshotsRequest method.
//    req, resp := client.GetDiskSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshots
func (c *Lightsail) GetDiskSnapshotsRequest(input *GetDiskSnapshotsInput) (req *request.Request, output *GetDiskSnapshotsOutput) {
	op := &request.Operation{
		Name:       opGetDiskSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDiskSnapshotsInput{}
	}

	output = &GetDiskSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDiskSnapshots API operation for Amazon Lightsail.
//
// Returns information about all block storage disk snapshots in your AWS account
// and region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDiskSnapshots for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshots
func (c *Lightsail) GetDiskSnapshots(input *GetDiskSnapshotsInput) (*GetDiskSnapshotsOutput, error) {
	req, out := c.GetDiskSnapshotsRequest(input)
	return out, req.Send()
}

// GetDiskSnapshotsWithContext is the same as GetDiskSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See GetDiskSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDiskSnapshotsWithContext(ctx aws.Context, input *GetDiskSnapshotsInput, opts ...request.Option) (*GetDiskSnapshotsOutput, error) {
	req, out := c.GetDiskSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDisks = "GetDisks"

// GetDisksRequest generates a "aws/request.Request" representing the
// client's request for the GetDisks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDisks for more information on using the GetDisks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDisksRequest method.
//    req, resp := client.GetDisksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisks
func (c *Lightsail) GetDisksRequest(input *GetDisksInput) (req *request.Request, output *GetDisksOutput) {
	op := &request.Operation{
		Name:       opGetDisks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDisksInput{}
	}

	output = &GetDisksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDisks API operation for Amazon Lightsail.
//
// Returns information about all block storage disks in your AWS account and
// region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDisks for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisks
func (c *Lightsail) GetDisks(input *GetDisksInput) (*GetDisksOutput, error) {
	req, out := c.GetDisksRequest(input)
	return out, req.Send()
}

// GetDisksWithContext is the same as GetDisks with the addition of
// the ability to pass a context and additional request options.
//
// See GetDisks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDisksWithContext(ctx aws.Context, input *GetDisksInput, opts ...request.Option) (*GetDisksOutput, error) {
	req, out := c.GetDisksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDistributionBundles = "GetDistributionBundles"

// GetDistributionBundlesRequest generates a "aws/request.Request" representing the
// client's request for the GetDistributionBundles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDistributionBundles for more information on using the GetDistributionBundles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDistributionBundlesRequest method.
//    req, resp := client.GetDistributionBundlesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributionBundles
func (c *Lightsail) GetDistributionBundlesRequest(input *GetDistributionBundlesInput) (req *request.Request, output *GetDistributionBundlesOutput) {
	op := &request.Operation{
		Name:       opGetDistributionBundles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDistributionBundlesInput{}
	}

	output = &GetDistributionBundlesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDistributionBundles API operation for Amazon Lightsail.
//
// Returns the bundles that can be applied to your Amazon Lightsail content
// delivery network (CDN) distributions.
//
// A distribution bundle specifies the monthly network transfer quota and monthly
// cost of your dsitribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDistributionBundles for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributionBundles
func (c *Lightsail) GetDistributionBundles(input *GetDistributionBundlesInput) (*GetDistributionBundlesOutput, error) {
	req, out := c.GetDistributionBundlesRequest(input)
	return out, req.Send()
}

// GetDistributionBundlesWithContext is the same as GetDistributionBundles with the addition of
// the ability to pass a context and additional request options.
//
// See GetDistributionBundles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDistributionBundlesWithContext(ctx aws.Context, input *GetDistributionBundlesInput, opts ...request.Option) (*GetDistributionBundlesOutput, error) {
	req, out := c.GetDistributionBundlesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDistributionLatestCacheReset = "GetDistributionLatestCacheReset"

// GetDistributionLatestCacheResetRequest generates a "aws/request.Request" representing the
// client's request for the GetDistributionLatestCacheReset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDistributionLatestCacheReset for more information on using the GetDistributionLatestCacheReset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDistributionLatestCacheResetRequest method.
//    req, resp := client.GetDistributionLatestCacheResetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributionLatestCacheReset
func (c *Lightsail) GetDistributionLatestCacheResetRequest(input *GetDistributionLatestCacheResetInput) (req *request.Request, output *GetDistributionLatestCacheResetOutput) {
	op := &request.Operation{
		Name:       opGetDistributionLatestCacheReset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDistributionLatestCacheResetInput{}
	}

	output = &GetDistributionLatestCacheResetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDistributionLatestCacheReset API operation for Amazon Lightsail.
//
// Returns the timestamp and status of the last cache reset of a specific Amazon
// Lightsail content delivery network (CDN) distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDistributionLatestCacheReset for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributionLatestCacheReset
func (c *Lightsail) GetDistributionLatestCacheReset(input *GetDistributionLatestCacheResetInput) (*GetDistributionLatestCacheResetOutput, error) {
	req, out := c.GetDistributionLatestCacheResetRequest(input)
	return out, req.Send()
}

// GetDistributionLatestCacheResetWithContext is the same as GetDistributionLatestCacheReset with the addition of
// the ability to pass a context and additional request options.
//
// See GetDistributionLatestCacheReset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDistributionLatestCacheResetWithContext(ctx aws.Context, input *GetDistributionLatestCacheResetInput, opts ...request.Option) (*GetDistributionLatestCacheResetOutput, error) {
	req, out := c.GetDistributionLatestCacheResetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDistributionMetricData = "GetDistributionMetricData"

// GetDistributionMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetDistributionMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDistributionMetricData for more information on using the GetDistributionMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDistributionMetricDataRequest method.
//    req, resp := client.GetDistributionMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributionMetricData
func (c *Lightsail) GetDistributionMetricDataRequest(input *GetDistributionMetricDataInput) (req *request.Request, output *GetDistributionMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetDistributionMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDistributionMetricDataInput{}
	}

	output = &GetDistributionMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDistributionMetricData API operation for Amazon Lightsail.
//
// Returns the data points of a specific metric for an Amazon Lightsail content
// delivery network (CDN) distribution.
//
// Metrics report the utilization of your resources, and the error counts generated
// by them. Monitor and collect metric data regularly to maintain the reliability,
// availability, and performance of your resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDistributionMetricData for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributionMetricData
func (c *Lightsail) GetDistributionMetricData(input *GetDistributionMetricDataInput) (*GetDistributionMetricDataOutput, error) {
	req, out := c.GetDistributionMetricDataRequest(input)
	return out, req.Send()
}

// GetDistributionMetricDataWithContext is the same as GetDistributionMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetDistributionMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDistributionMetricDataWithContext(ctx aws.Context, input *GetDistributionMetricDataInput, opts ...request.Option) (*GetDistributionMetricDataOutput, error) {
	req, out := c.GetDistributionMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDistributions = "GetDistributions"

// GetDistributionsRequest generates a "aws/request.Request" representing the
// client's request for the GetDistributions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDistributions for more information on using the GetDistributions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDistributionsRequest method.
//    req, resp := client.GetDistributionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributions
func (c *Lightsail) GetDistributionsRequest(input *GetDistributionsInput) (req *request.Request, output *GetDistributionsOutput) {
	op := &request.Operation{
		Name:       opGetDistributions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDistributionsInput{}
	}

	output = &GetDistributionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDistributions API operation for Amazon Lightsail.
//
// Returns information about one or more of your Amazon Lightsail content delivery
// network (CDN) distributions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDistributions for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributions
func (c *Lightsail) GetDistributions(input *GetDistributionsInput) (*GetDistributionsOutput, error) {
	req, out := c.GetDistributionsRequest(input)
	return out, req.Send()
}

// GetDistributionsWithContext is the same as GetDistributions with the addition of
// the ability to pass a context and additional request options.
//
// See GetDistributions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDistributionsWithContext(ctx aws.Context, input *GetDistributionsInput, opts ...request.Option) (*GetDistributionsOutput, error) {
	req, out := c.GetDistributionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomain = "GetDomain"

// GetDomainRequest generates a "aws/request.Request" representing the
// client's request for the GetDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomain for more information on using the GetDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainRequest method.
//    req, resp := client.GetDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain
func (c *Lightsail) GetDomainRequest(input *GetDomainInput) (req *request.Request, output *GetDomainOutput) {
	op := &request.Operation{
		Name:       opGetDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDomainInput{}
	}

	output = &GetDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomain API operation for Amazon Lightsail.
//
// Returns information about a specific domain recordset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDomain for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain
func (c *Lightsail) GetDomain(input *GetDomainInput) (*GetDomainOutput, error) {
	req, out := c.GetDomainRequest(input)
	return out, req.Send()
}

// GetDomainWithContext is the same as GetDomain with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDomainWithContext(ctx aws.Context, input *GetDomainInput, opts ...request.Option) (*GetDomainOutput, error) {
	req, out := c.GetDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomains = "GetDomains"

// GetDomainsRequest generates a "aws/request.Request" representing the
// client's request for the GetDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomains for more information on using the GetDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainsRequest method.
//    req, resp := client.GetDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains
func (c *Lightsail) GetDomainsRequest(input *GetDomainsInput) (req *request.Request, output *GetDomainsOutput) {
	op := &request.Operation{
		Name:       opGetDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDomainsInput{}
	}

	output = &GetDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomains API operation for Amazon Lightsail.
//
// Returns a list of all domains in the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDomains for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains
func (c *Lightsail) GetDomains(input *GetDomainsInput) (*GetDomainsOutput, error) {
	req, out := c.GetDomainsRequest(input)
	return out, req.Send()
}

// GetDomainsWithContext is the same as GetDomains with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDomainsWithContext(ctx aws.Context, input *GetDomainsInput, opts ...request.Option) (*GetDomainsOutput, error) {
	req, out := c.GetDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExportSnapshotRecords = "GetExportSnapshotRecords"

// GetExportSnapshotRecordsRequest generates a "aws/request.Request" representing the
// client's request for the GetExportSnapshotRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExportSnapshotRecords for more information on using the GetExportSnapshotRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExportSnapshotRecordsRequest method.
//    req, resp := client.GetExportSnapshotRecordsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetExportSnapshotRecords
func (c *Lightsail) GetExportSnapshotRecordsRequest(input *GetExportSnapshotRecordsInput) (req *request.Request, output *GetExportSnapshotRecordsOutput) {
	op := &request.Operation{
		Name:       opGetExportSnapshotRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetExportSnapshotRecordsInput{}
	}

	output = &GetExportSnapshotRecordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExportSnapshotRecords API operation for Amazon Lightsail.
//
// Returns all export snapshot records created as a result of the export snapshot
// operation.
//
// An export snapshot record can be used to create a new Amazon EC2 instance
// and its related resources with the CreateCloudFormationStack action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetExportSnapshotRecords for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetExportSnapshotRecords
func (c *Lightsail) GetExportSnapshotRecords(input *GetExportSnapshotRecordsInput) (*GetExportSnapshotRecordsOutput, error) {
	req, out := c.GetExportSnapshotRecordsRequest(input)
	return out, req.Send()
}

// GetExportSnapshotRecordsWithContext is the same as GetExportSnapshotRecords with the addition of
// the ability to pass a context and additional request options.
//
// See GetExportSnapshotRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetExportSnapshotRecordsWithContext(ctx aws.Context, input *GetExportSnapshotRecordsInput, opts ...request.Option) (*GetExportSnapshotRecordsOutput, error) {
	req, out := c.GetExportSnapshotRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstance = "GetInstance"

// GetInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstance for more information on using the GetInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceRequest method.
//    req, resp := client.GetInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance
func (c *Lightsail) GetInstanceRequest(input *GetInstanceInput) (req *request.Request, output *GetInstanceOutput) {
	op := &request.Operation{
		Name:       opGetInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceInput{}
	}

	output = &GetInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstance API operation for Amazon Lightsail.
//
// Returns information about a specific Amazon Lightsail instance, which is
// a virtual private server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstance for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance
func (c *Lightsail) GetInstance(input *GetInstanceInput) (*GetInstanceOutput, error) {
	req, out := c.GetInstanceRequest(input)
	return out, req.Send()
}

// GetInstanceWithContext is the same as GetInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceWithContext(ctx aws.Context, input *GetInstanceInput, opts ...request.Option) (*GetInstanceOutput, error) {
	req, out := c.GetInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceAccessDetails = "GetInstanceAccessDetails"

// GetInstanceAccessDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceAccessDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceAccessDetails for more information on using the GetInstanceAccessDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceAccessDetailsRequest method.
//    req, resp := client.GetInstanceAccessDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails
func (c *Lightsail) GetInstanceAccessDetailsRequest(input *GetInstanceAccessDetailsInput) (req *request.Request, output *GetInstanceAccessDetailsOutput) {
	op := &request.Operation{
		Name:       opGetInstanceAccessDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceAccessDetailsInput{}
	}

	output = &GetInstanceAccessDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceAccessDetails API operation for Amazon Lightsail.
//
// Returns temporary SSH keys you can use to connect to a specific virtual private
// server, or instance.
//
// The get instance access details operation supports tag-based access control
// via resource tags applied to the resource identified by instance name. For
// more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstanceAccessDetails for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails
func (c *Lightsail) GetInstanceAccessDetails(input *GetInstanceAccessDetailsInput) (*GetInstanceAccessDetailsOutput, error) {
	req, out := c.GetInstanceAccessDetailsRequest(input)
	return out, req.Send()
}

// GetInstanceAccessDetailsWithContext is the same as GetInstanceAccessDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceAccessDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceAccessDetailsWithContext(ctx aws.Context, input *GetInstanceAccessDetailsInput, opts ...request.Option) (*GetInstanceAccessDetailsOutput, error) {
	req, out := c.GetInstanceAccessDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceMetricData = "GetInstanceMetricData"

// GetInstanceMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceMetricData for more information on using the GetInstanceMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceMetricDataRequest method.
//    req, resp := client.GetInstanceMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData
func (c *Lightsail) GetInstanceMetricDataRequest(input *GetInstanceMetricDataInput) (req *request.Request, output *GetInstanceMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetInstanceMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceMetricDataInput{}
	}

	output = &GetInstanceMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceMetricData API operation for Amazon Lightsail.
//
// Returns the data points for the specified Amazon Lightsail instance metric,
// given an instance name.
//
// Metrics report the utilization of your resources, and the error counts generated
// by them. Monitor and collect metric data regularly to maintain the reliability,
// availability, and performance of your resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstanceMetricData for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData
func (c *Lightsail) GetInstanceMetricData(input *GetInstanceMetricDataInput) (*GetInstanceMetricDataOutput, error) {
	req, out := c.GetInstanceMetricDataRequest(input)
	return out, req.Send()
}

// GetInstanceMetricDataWithContext is the same as GetInstanceMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceMetricDataWithContext(ctx aws.Context, input *GetInstanceMetricDataInput, opts ...request.Option) (*GetInstanceMetricDataOutput, error) {
	req, out := c.GetInstanceMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstancePortStates = "GetInstancePortStates"

// GetInstancePortStatesRequest generates a "aws/request.Request" representing the
// client's request for the GetInstancePortStates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstancePortStates for more information on using the GetInstancePortStates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstancePortStatesRequest method.
//    req, resp := client.GetInstancePortStatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStates
func (c *Lightsail) GetInstancePortStatesRequest(input *GetInstancePortStatesInput) (req *request.Request, output *GetInstancePortStatesOutput) {
	op := &request.Operation{
		Name:       opGetInstancePortStates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstancePortStatesInput{}
	}

	output = &GetInstancePortStatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstancePortStates API operation for Amazon Lightsail.
//
// Returns the firewall port states for a specific Amazon Lightsail instance,
// the IP addresses allowed to connect to the instance through the ports, and
// the protocol.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstancePortStates for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStates
func (c *Lightsail) GetInstancePortStates(input *GetInstancePortStatesInput) (*GetInstancePortStatesOutput, error) {
	req, out := c.GetInstancePortStatesRequest(input)
	return out, req.Send()
}

// GetInstancePortStatesWithContext is the same as GetInstancePortStates with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstancePortStates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstancePortStatesWithContext(ctx aws.Context, input *GetInstancePortStatesInput, opts ...request.Option) (*GetInstancePortStatesOutput, error) {
	req, out := c.GetInstancePortStatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceSnapshot = "GetInstanceSnapshot"

// GetInstanceSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceSnapshot for more information on using the GetInstanceSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceSnapshotRequest method.
//    req, resp := client.GetInstanceSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshot
func (c *Lightsail) GetInstanceSnapshotRequest(input *GetInstanceSnapshotInput) (req *request.Request, output *GetInstanceSnapshotOutput) {
	op := &request.Operation{
		Name:       opGetInstanceSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceSnapshotInput{}
	}

	output = &GetInstanceSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceSnapshot API operation for Amazon Lightsail.
//
// Returns information about a specific instance snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstanceSnapshot for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshot
func (c *Lightsail) GetInstanceSnapshot(input *GetInstanceSnapshotInput) (*GetInstanceSnapshotOutput, error) {
	req, out := c.GetInstanceSnapshotRequest(input)
	return out, req.Send()
}

// GetInstanceSnapshotWithContext is the same as GetInstanceSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceSnapshotWithContext(ctx aws.Context, input *GetInstanceSnapshotInput, opts ...request.Option) (*GetInstanceSnapshotOutput, error) {
	req, out := c.GetInstanceSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceSnapshots = "GetInstanceSnapshots"

// GetInstanceSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceSnapshots for more information on using the GetInstanceSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceSnapshotsRequest method.
//    req, resp := client.GetInstanceSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots
func (c *Lightsail) GetInstanceSnapshotsRequest(input *GetInstanceSnapshotsInput) (req *request.Request, output *GetInstanceSnapshotsOutput) {
	op := &request.Operation{
		Name:       opGetInstanceSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceSnapshotsInput{}
	}

	output = &GetInstanceSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceSnapshots API operation for Amazon Lightsail.
//
// Returns all instance snapshots for the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstanceSnapshots for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots
func (c *Lightsail) GetInstanceSnapshots(input *GetInstanceSnapshotsInput) (*GetInstanceSnapshotsOutput, error) {
	req, out := c.GetInstanceSnapshotsRequest(input)
	return out, req.Send()
}

// GetInstanceSnapshotsWithContext is the same as GetInstanceSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceSnapshotsWithContext(ctx aws.Context, input *GetInstanceSnapshotsInput, opts ...request.Option) (*GetInstanceSnapshotsOutput, error) {
	req, out := c.GetInstanceSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceState = "GetInstanceState"

// GetInstanceStateRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceState for more information on using the GetInstanceState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceStateRequest method.
//    req, resp := client.GetInstanceStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceState
func (c *Lightsail) GetInstanceStateRequest(input *GetInstanceStateInput) (req *request.Request, output *GetInstanceStateOutput) {
	op := &request.Operation{
		Name:       opGetInstanceState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceStateInput{}
	}

	output = &GetInstanceStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceState API operation for Amazon Lightsail.
//
// Returns the state of a specific instance. Works on one instance at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstanceState for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceState
func (c *Lightsail) GetInstanceState(input *GetInstanceStateInput) (*GetInstanceStateOutput, error) {
	req, out := c.GetInstanceStateRequest(input)
	return out, req.Send()
}

// GetInstanceStateWithContext is the same as GetInstanceState with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceStateWithContext(ctx aws.Context, input *GetInstanceStateInput, opts ...request.Option) (*GetInstanceStateOutput, error) {
	req, out := c.GetInstanceStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstances = "GetInstances"

// GetInstancesRequest generates a "aws/request.Request" representing the
// client's request for the GetInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstances for more information on using the GetInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstancesRequest method.
//    req, resp := client.GetInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances
func (c *Lightsail) GetInstancesRequest(input *GetInstancesInput) (req *request.Request, output *GetInstancesOutput) {
	op := &request.Operation{
		Name:       opGetInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstancesInput{}
	}

	output = &GetInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstances API operation for Amazon Lightsail.
//
// Returns information about all Amazon Lightsail virtual private servers, or
// instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstances for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances
func (c *Lightsail) GetInstances(input *GetInstancesInput) (*GetInstancesOutput, error) {
	req, out := c.GetInstancesRequest(input)
	return out, req.Send()
}

// GetInstancesWithContext is the same as GetInstances with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstancesWithContext(ctx aws.Context, input *GetInstancesInput, opts ...request.Option) (*GetInstancesOutput, error) {
	req, out := c.GetInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKeyPair = "GetKeyPair"

// GetKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the GetKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKeyPair for more information on using the GetKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetKeyPairRequest method.
//    req, resp := client.GetKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair
func (c *Lightsail) GetKeyPairRequest(input *GetKeyPairInput) (req *request.Request, output *GetKeyPairOutput) {
	op := &request.Operation{
		Name:       opGetKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyPairInput{}
	}

	output = &GetKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKeyPair API operation for Amazon Lightsail.
//
// Returns information about a specific key pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetKeyPair for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair
func (c *Lightsail) GetKeyPair(input *GetKeyPairInput) (*GetKeyPairOutput, error) {
	req, out := c.GetKeyPairRequest(input)
	return out, req.Send()
}

// GetKeyPairWithContext is the same as GetKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See GetKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetKeyPairWithContext(ctx aws.Context, input *GetKeyPairInput, opts ...request.Option) (*GetKeyPairOutput, error) {
	req, out := c.GetKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKeyPairs = "GetKeyPairs"

// GetKeyPairsRequest generates a "aws/request.Request" representing the
// client's request for the GetKeyPairs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKeyPairs for more information on using the GetKeyPairs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetKeyPairsRequest method.
//    req, resp := client.GetKeyPairsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs
func (c *Lightsail) GetKeyPairsRequest(input *GetKeyPairsInput) (req *request.Request, output *GetKeyPairsOutput) {
	op := &request.Operation{
		Name:       opGetKeyPairs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyPairsInput{}
	}

	output = &GetKeyPairsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKeyPairs API operation for Amazon Lightsail.
//
// Returns information about all key pairs in the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetKeyPairs for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs
func (c *Lightsail) GetKeyPairs(input *GetKeyPairsInput) (*GetKeyPairsOutput, error) {
	req, out := c.GetKeyPairsRequest(input)
	return out, req.Send()
}

// GetKeyPairsWithContext is the same as GetKeyPairs with the addition of
// the ability to pass a context and additional request options.
//
// See GetKeyPairs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetKeyPairsWithContext(ctx aws.Context, input *GetKeyPairsInput, opts ...request.Option) (*GetKeyPairsOutput, error) {
	req, out := c.GetKeyPairsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoadBalancer = "GetLoadBalancer"

// GetLoadBalancerRequest generates a "aws/request.Request" representing the
// client's request for the GetLoadBalancer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoadBalancer for more information on using the GetLoadBalancer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoadBalancerRequest method.
//    req, resp := client.GetLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancer
func (c *Lightsail) GetLoadBalancerRequest(input *GetLoadBalancerInput) (req *request.Request, output *GetLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opGetLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLoadBalancerInput{}
	}

	output = &GetLoadBalancerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoadBalancer API operation for Amazon Lightsail.
//
// Returns information about the specified Lightsail load balancer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetLoadBalancer for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancer
func (c *Lightsail) GetLoadBalancer(input *GetLoadBalancerInput) (*GetLoadBalancerOutput, error) {
	req, out := c.GetLoadBalancerRequest(input)
	return out, req.Send()
}

// GetLoadBalancerWithContext is the same as GetLoadBalancer with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoadBalancer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetLoadBalancerWithContext(ctx aws.Context, input *GetLoadBalancerInput, opts ...request.Option) (*GetLoadBalancerOutput, error) {
	req, out := c.GetLoadBalancerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoadBalancerMetricData = "GetLoadBalancerMetricData"

// GetLoadBalancerMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetLoadBalancerMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoadBalancerMetricData for more information on using the GetLoadBalancerMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoadBalancerMetricDataRequest method.
//    req, resp := client.GetLoadBalancerMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerMetricData
func (c *Lightsail) GetLoadBalancerMetricDataRequest(input *GetLoadBalancerMetricDataInput) (req *request.Request, output *GetLoadBalancerMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetLoadBalancerMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLoadBalancerMetricDataInput{}
	}

	output = &GetLoadBalancerMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoadBalancerMetricData API operation for Amazon Lightsail.
//
// Returns information about health metrics for your Lightsail load balancer.
//
// Metrics report the utilization of your resources, and the error counts generated
// by them. Monitor and collect metric data regularly to maintain the reliability,
// availability, and performance of your resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetLoadBalancerMetricData for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerMetricData
func (c *Lightsail) GetLoadBalancerMetricData(input *GetLoadBalancerMetricDataInput) (*GetLoadBalancerMetricDataOutput, error) {
	req, out := c.GetLoadBalancerMetricDataRequest(input)
	return out, req.Send()
}

// GetLoadBalancerMetricDataWithContext is the same as GetLoadBalancerMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoadBalancerMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetLoadBalancerMetricDataWithContext(ctx aws.Context, input *GetLoadBalancerMetricDataInput, opts ...request.Option) (*GetLoadBalancerMetricDataOutput, error) {
	req, out := c.GetLoadBalancerMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoadBalancerTlsCertificates = "GetLoadBalancerTlsCertificates"

// GetLoadBalancerTlsCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the GetLoadBalancerTlsCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoadBalancerTlsCertificates for more information on using the GetLoadBalancerTlsCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoadBalancerTlsCertificatesRequest method.
//    req, resp := client.GetLoadBalancerTlsCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerTlsCertificates
func (c *Lightsail) GetLoadBalancerTlsCertificatesRequest(input *GetLoadBalancerTlsCertificatesInput) (req *request.Request, output *GetLoadBalancerTlsCertificatesOutput) {
	op := &request.Operation{
		Name:       opGetLoadBalancerTlsCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLoadBalancerTlsCertificatesInput{}
	}

	output = &GetLoadBalancerTlsCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoadBalancerTlsCertificates API operation for Amazon Lightsail.
//
// Returns information about the TLS certificates that are associated with the
// specified Lightsail load balancer.
//
// TLS is just an updated, more secure version of Secure Socket Layer (SSL).
//
// You can have a maximum of 2 certificates associated with a Lightsail load
// balancer. One is active and the other is inactive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetLoadBalancerTlsCertificates for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerTlsCertificates
func (c *Lightsail) GetLoadBalancerTlsCertificates(input *GetLoadBalancerTlsCertificatesInput) (*GetLoadBalancerTlsCertificatesOutput, error) {
	req, out := c.GetLoadBalancerTlsCertificatesRequest(input)
	return out, req.Send()
}

// GetLoadBalancerTlsCertificatesWithContext is the same as GetLoadBalancerTlsCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoadBalancerTlsCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetLoadBalancerTlsCertificatesWithContext(ctx aws.Context, input *GetLoadBalancerTlsCertificatesInput, opts ...request.Option) (*GetLoadBalancerTlsCertificatesOutput, error) {
	req, out := c.GetLoadBalancerTlsCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoadBalancers = "GetLoadBalancers"

// GetLoadBalancersRequest generates a "aws/request.Request" representing the
// client's request for the GetLoadBalancers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoadBalancers for more information on using the GetLoadBalancers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoadBalancersRequest method.
//    req, resp := client.GetLoadBalancersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancers
func (c *Lightsail) GetLoadBalancersRequest(input *GetLoadBalancersInput) (req *request.Request, output *GetLoadBalancersOutput) {
	op := &request.Operation{
		Name:       opGetLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLoadBalancersInput{}
	}

	output = &GetLoadBalancersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoadBalancers API operation for Amazon Lightsail.
//
// Returns information about all load balancers in an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetLoadBalancers for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancers
func (c *Lightsail) GetLoadBalancers(input *GetLoadBalancersInput) (*GetLoadBalancersOutput, error) {
	req, out := c.GetLoadBalancersRequest(input)
	return out, req.Send()
}

// GetLoadBalancersWithContext is the same as GetLoadBalancers with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoadBalancers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetLoadBalancersWithContext(ctx aws.Context, input *GetLoadBalancersInput, opts ...request.Option) (*GetLoadBalancersOutput, error) {
	req, out := c.GetLoadBalancersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOperation = "GetOperation"

// GetOperationRequest generates a "aws/request.Request" representing the
// client's request for the GetOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOperation for more information on using the GetOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOperationRequest method.
//    req, resp := client.GetOperationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperation
func (c *Lightsail) GetOperationRequest(input *GetOperationInput) (req *request.Request, output *GetOperationOutput) {
	op := &request.Operation{
		Name:       opGetOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOperationInput{}
	}

	output = &GetOperationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOperation API operation for Amazon Lightsail.
//
// Returns information about a specific operation. Operations include events
// such as when you create an instance, allocate a static IP, attach a static
// IP, and so on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetOperation for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperation
func (c *Lightsail) GetOperation(input *GetOperationInput) (*GetOperationOutput, error) {
	req, out := c.GetOperationRequest(input)
	return out, req.Send()
}

// GetOperationWithContext is the same as GetOperation with the addition of
// the ability to pass a context and additional request options.
//
// See GetOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetOperationWithContext(ctx aws.Context, input *GetOperationInput, opts ...request.Option) (*GetOperationOutput, error) {
	req, out := c.GetOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOperations = "GetOperations"

// GetOperationsRequest generates a "aws/request.Request" representing the
// client's request for the GetOperations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOperations for more information on using the GetOperations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOperationsRequest method.
//    req, resp := client.GetOperationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations
func (c *Lightsail) GetOperationsRequest(input *GetOperationsInput) (req *request.Request, output *GetOperationsOutput) {
	op := &request.Operation{
		Name:       opGetOperations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOperationsInput{}
	}

	output = &GetOperationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOperations API operation for Amazon Lightsail.
//
// Returns information about all operations.
//
// Results are returned from oldest to newest, up to a maximum of 200. Results
// can be paged by making each subsequent call to GetOperations use the maximum
// (last) statusChangedAt value from the previous request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetOperations for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations
func (c *Lightsail) GetOperations(input *GetOperationsInput) (*GetOperationsOutput, error) {
	req, out := c.GetOperationsRequest(input)
	return out, req.Send()
}

// GetOperationsWithContext is the same as GetOperations with the addition of
// the ability to pass a context and additional request options.
//
// See GetOperations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetOperationsWithContext(ctx aws.Context, input *GetOperationsInput, opts ...request.Option) (*GetOperationsOutput, error) {
	req, out := c.GetOperationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOperationsForResource = "GetOperationsForResource"

// GetOperationsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetOperationsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOperationsForResource for more information on using the GetOperationsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOperationsForResourceRequest method.
//    req, resp := client.GetOperationsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource
func (c *Lightsail) GetOperationsForResourceRequest(input *GetOperationsForResourceInput) (req *request.Request, output *GetOperationsForResourceOutput) {
	op := &request.Operation{
		Name:       opGetOperationsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOperationsForResourceInput{}
	}

	output = &GetOperationsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOperationsForResource API operation for Amazon Lightsail.
//
// Gets operations for a specific resource (e.g., an instance or a static IP).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetOperationsForResource for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource
func (c *Lightsail) GetOperationsForResource(input *GetOperationsForResourceInput) (*GetOperationsForResourceOutput, error) {
	req, out := c.GetOperationsForResourceRequest(input)
	return out, req.Send()
}

// GetOperationsForResourceWithContext is the same as GetOperationsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetOperationsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetOperationsForResourceWithContext(ctx aws.Context, input *GetOperationsForResourceInput, opts ...request.Option) (*GetOperationsForResourceOutput, error) {
	req, out := c.GetOperationsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRegions = "GetRegions"

// GetRegionsRequest generates a "aws/request.Request" representing the
// client's request for the GetRegions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRegions for more information on using the GetRegions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRegionsRequest method.
//    req, resp := client.GetRegionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions
func (c *Lightsail) GetRegionsRequest(input *GetRegionsInput) (req *request.Request, output *GetRegionsOutput) {
	op := &request.Operation{
		Name:       opGetRegions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRegionsInput{}
	}

	output = &GetRegionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRegions API operation for Amazon Lightsail.
//
// Returns a list of all valid regions for Amazon Lightsail. Use the include
// availability zones parameter to also return the Availability Zones in a region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRegions for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions
func (c *Lightsail) GetRegions(input *GetRegionsInput) (*GetRegionsOutput, error) {
	req, out := c.GetRegionsRequest(input)
	return out, req.Send()
}

// GetRegionsWithContext is the same as GetRegions with the addition of
// the ability to pass a context and additional request options.
//
// See GetRegions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRegionsWithContext(ctx aws.Context, input *GetRegionsInput, opts ...request.Option) (*GetRegionsOutput, error) {
	req, out := c.GetRegionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabase = "GetRelationalDatabase"

// GetRelationalDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabase for more information on using the GetRelationalDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseRequest method.
//    req, resp := client.GetRelationalDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabase
func (c *Lightsail) GetRelationalDatabaseRequest(input *GetRelationalDatabaseInput) (req *request.Request, output *GetRelationalDatabaseOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseInput{}
	}

	output = &GetRelationalDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabase API operation for Amazon Lightsail.
//
// Returns information about a specific database in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabase for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabase
func (c *Lightsail) GetRelationalDatabase(input *GetRelationalDatabaseInput) (*GetRelationalDatabaseOutput, error) {
	req, out := c.GetRelationalDatabaseRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseWithContext is the same as GetRelationalDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseWithContext(ctx aws.Context, input *GetRelationalDatabaseInput, opts ...request.Option) (*GetRelationalDatabaseOutput, error) {
	req, out := c.GetRelationalDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseBlueprints = "GetRelationalDatabaseBlueprints"

// GetRelationalDatabaseBlueprintsRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseBlueprints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseBlueprints for more information on using the GetRelationalDatabaseBlueprints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseBlueprintsRequest method.
//    req, resp := client.GetRelationalDatabaseBlueprintsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBlueprints
func (c *Lightsail) GetRelationalDatabaseBlueprintsRequest(input *GetRelationalDatabaseBlueprintsInput) (req *request.Request, output *GetRelationalDatabaseBlueprintsOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseBlueprints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseBlueprintsInput{}
	}

	output = &GetRelationalDatabaseBlueprintsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseBlueprints API operation for Amazon Lightsail.
//
// Returns a list of available database blueprints in Amazon Lightsail. A blueprint
// describes the major engine version of a database.
//
// You can use a blueprint ID to create a new database that runs a specific
// database engine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseBlueprints for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBlueprints
func (c *Lightsail) GetRelationalDatabaseBlueprints(input *GetRelationalDatabaseBlueprintsInput) (*GetRelationalDatabaseBlueprintsOutput, error) {
	req, out := c.GetRelationalDatabaseBlueprintsRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseBlueprintsWithContext is the same as GetRelationalDatabaseBlueprints with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseBlueprints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseBlueprintsWithContext(ctx aws.Context, input *GetRelationalDatabaseBlueprintsInput, opts ...request.Option) (*GetRelationalDatabaseBlueprintsOutput, error) {
	req, out := c.GetRelationalDatabaseBlueprintsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseBundles = "GetRelationalDatabaseBundles"

// GetRelationalDatabaseBundlesRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseBundles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseBundles for more information on using the GetRelationalDatabaseBundles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseBundlesRequest method.
//    req, resp := client.GetRelationalDatabaseBundlesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBundles
func (c *Lightsail) GetRelationalDatabaseBundlesRequest(input *GetRelationalDatabaseBundlesInput) (req *request.Request, output *GetRelationalDatabaseBundlesOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseBundles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseBundlesInput{}
	}

	output = &GetRelationalDatabaseBundlesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseBundles API operation for Amazon Lightsail.
//
// Returns the list of bundles that are available in Amazon Lightsail. A bundle
// describes the performance specifications for a database.
//
// You can use a bundle ID to create a new database with explicit performance
// specifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseBundles for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBundles
func (c *Lightsail) GetRelationalDatabaseBundles(input *GetRelationalDatabaseBundlesInput) (*GetRelationalDatabaseBundlesOutput, error) {
	req, out := c.GetRelationalDatabaseBundlesRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseBundlesWithContext is the same as GetRelationalDatabaseBundles with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseBundles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseBundlesWithContext(ctx aws.Context, input *GetRelationalDatabaseBundlesInput, opts ...request.Option) (*GetRelationalDatabaseBundlesOutput, error) {
	req, out := c.GetRelationalDatabaseBundlesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseEvents = "GetRelationalDatabaseEvents"

// GetRelationalDatabaseEventsRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseEvents for more information on using the GetRelationalDatabaseEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseEventsRequest method.
//    req, resp := client.GetRelationalDatabaseEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseEvents
func (c *Lightsail) GetRelationalDatabaseEventsRequest(input *GetRelationalDatabaseEventsInput) (req *request.Request, output *GetRelationalDatabaseEventsOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseEventsInput{}
	}

	output = &GetRelationalDatabaseEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseEvents API operation for Amazon Lightsail.
//
// Returns a list of events for a specific database in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseEvents for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseEvents
func (c *Lightsail) GetRelationalDatabaseEvents(input *GetRelationalDatabaseEventsInput) (*GetRelationalDatabaseEventsOutput, error) {
	req, out := c.GetRelationalDatabaseEventsRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseEventsWithContext is the same as GetRelationalDatabaseEvents with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseEventsWithContext(ctx aws.Context, input *GetRelationalDatabaseEventsInput, opts ...request.Option) (*GetRelationalDatabaseEventsOutput, error) {
	req, out := c.GetRelationalDatabaseEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseLogEvents = "GetRelationalDatabaseLogEvents"

// GetRelationalDatabaseLogEventsRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseLogEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseLogEvents for more information on using the GetRelationalDatabaseLogEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseLogEventsRequest method.
//    req, resp := client.GetRelationalDatabaseLogEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogEvents
func (c *Lightsail) GetRelationalDatabaseLogEventsRequest(input *GetRelationalDatabaseLogEventsInput) (req *request.Request, output *GetRelationalDatabaseLogEventsOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseLogEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseLogEventsInput{}
	}

	output = &GetRelationalDatabaseLogEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseLogEvents API operation for Amazon Lightsail.
//
// Returns a list of log events for a database in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseLogEvents for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogEvents
func (c *Lightsail) GetRelationalDatabaseLogEvents(input *GetRelationalDatabaseLogEventsInput) (*GetRelationalDatabaseLogEventsOutput, error) {
	req, out := c.GetRelationalDatabaseLogEventsRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseLogEventsWithContext is the same as GetRelationalDatabaseLogEvents with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseLogEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseLogEventsWithContext(ctx aws.Context, input *GetRelationalDatabaseLogEventsInput, opts ...request.Option) (*GetRelationalDatabaseLogEventsOutput, error) {
	req, out := c.GetRelationalDatabaseLogEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseLogStreams = "GetRelationalDatabaseLogStreams"

// GetRelationalDatabaseLogStreamsRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseLogStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseLogStreams for more information on using the GetRelationalDatabaseLogStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseLogStreamsRequest method.
//    req, resp := client.GetRelationalDatabaseLogStreamsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogStreams
func (c *Lightsail) GetRelationalDatabaseLogStreamsRequest(input *GetRelationalDatabaseLogStreamsInput) (req *request.Request, output *GetRelationalDatabaseLogStreamsOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseLogStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseLogStreamsInput{}
	}

	output = &GetRelationalDatabaseLogStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseLogStreams API operation for Amazon Lightsail.
//
// Returns a list of available log streams for a specific database in Amazon
// Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseLogStreams for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogStreams
func (c *Lightsail) GetRelationalDatabaseLogStreams(input *GetRelationalDatabaseLogStreamsInput) (*GetRelationalDatabaseLogStreamsOutput, error) {
	req, out := c.GetRelationalDatabaseLogStreamsRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseLogStreamsWithContext is the same as GetRelationalDatabaseLogStreams with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseLogStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseLogStreamsWithContext(ctx aws.Context, input *GetRelationalDatabaseLogStreamsInput, opts ...request.Option) (*GetRelationalDatabaseLogStreamsOutput, error) {
	req, out := c.GetRelationalDatabaseLogStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseMasterUserPassword = "GetRelationalDatabaseMasterUserPassword"

// GetRelationalDatabaseMasterUserPasswordRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseMasterUserPassword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseMasterUserPassword for more information on using the GetRelationalDatabaseMasterUserPassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseMasterUserPasswordRequest method.
//    req, resp := client.GetRelationalDatabaseMasterUserPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMasterUserPassword
func (c *Lightsail) GetRelationalDatabaseMasterUserPasswordRequest(input *GetRelationalDatabaseMasterUserPasswordInput) (req *request.Request, output *GetRelationalDatabaseMasterUserPasswordOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseMasterUserPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseMasterUserPasswordInput{}
	}

	output = &GetRelationalDatabaseMasterUserPasswordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseMasterUserPassword API operation for Amazon Lightsail.
//
// Returns the current, previous, or pending versions of the master user password
// for a Lightsail database.
//
// The GetRelationalDatabaseMasterUserPassword operation supports tag-based
// access control via resource tags applied to the resource identified by relationalDatabaseName.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseMasterUserPassword for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMasterUserPassword
func (c *Lightsail) GetRelationalDatabaseMasterUserPassword(input *GetRelationalDatabaseMasterUserPasswordInput) (*GetRelationalDatabaseMasterUserPasswordOutput, error) {
	req, out := c.GetRelationalDatabaseMasterUserPasswordRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseMasterUserPasswordWithContext is the same as GetRelationalDatabaseMasterUserPassword with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseMasterUserPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseMasterUserPasswordWithContext(ctx aws.Context, input *GetRelationalDatabaseMasterUserPasswordInput, opts ...request.Option) (*GetRelationalDatabaseMasterUserPasswordOutput, error) {
	req, out := c.GetRelationalDatabaseMasterUserPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseMetricData = "GetRelationalDatabaseMetricData"

// GetRelationalDatabaseMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseMetricData for more information on using the GetRelationalDatabaseMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseMetricDataRequest method.
//    req, resp := client.GetRelationalDatabaseMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMetricData
func (c *Lightsail) GetRelationalDatabaseMetricDataRequest(input *GetRelationalDatabaseMetricDataInput) (req *request.Request, output *GetRelationalDatabaseMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseMetricDataInput{}
	}

	output = &GetRelationalDatabaseMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseMetricData API operation for Amazon Lightsail.
//
// Returns the data points of the specified metric for a database in Amazon
// Lightsail.
//
// Metrics report the utilization of your resources, and the error counts generated
// by them. Monitor and collect metric data regularly to maintain the reliability,
// availability, and performance of your resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseMetricData for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMetricData
func (c *Lightsail) GetRelationalDatabaseMetricData(input *GetRelationalDatabaseMetricDataInput) (*GetRelationalDatabaseMetricDataOutput, error) {
	req, out := c.GetRelationalDatabaseMetricDataRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseMetricDataWithContext is the same as GetRelationalDatabaseMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseMetricDataWithContext(ctx aws.Context, input *GetRelationalDatabaseMetricDataInput, opts ...request.Option) (*GetRelationalDatabaseMetricDataOutput, error) {
	req, out := c.GetRelationalDatabaseMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseParameters = "GetRelationalDatabaseParameters"

// GetRelationalDatabaseParametersRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseParameters for more information on using the GetRelationalDatabaseParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseParametersRequest method.
//    req, resp := client.GetRelationalDatabaseParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseParameters
func (c *Lightsail) GetRelationalDatabaseParametersRequest(input *GetRelationalDatabaseParametersInput) (req *request.Request, output *GetRelationalDatabaseParametersOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseParametersInput{}
	}

	output = &GetRelationalDatabaseParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseParameters API operation for Amazon Lightsail.
//
// Returns all of the runtime parameters offered by the underlying database
// software, or engine, for a specific database in Amazon Lightsail.
//
// In addition to the parameter names and values, this operation returns other
// information about each parameter. This information includes whether changes
// require a reboot, whether the parameter is modifiable, the allowed values,
// and the data types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseParameters for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseParameters
func (c *Lightsail) GetRelationalDatabaseParameters(input *GetRelationalDatabaseParametersInput) (*GetRelationalDatabaseParametersOutput, error) {
	req, out := c.GetRelationalDatabaseParametersRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseParametersWithContext is the same as GetRelationalDatabaseParameters with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseParametersWithContext(ctx aws.Context, input *GetRelationalDatabaseParametersInput, opts ...request.Option) (*GetRelationalDatabaseParametersOutput, error) {
	req, out := c.GetRelationalDatabaseParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseSnapshot = "GetRelationalDatabaseSnapshot"

// GetRelationalDatabaseSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseSnapshot for more information on using the GetRelationalDatabaseSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseSnapshotRequest method.
//    req, resp := client.GetRelationalDatabaseSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshot
func (c *Lightsail) GetRelationalDatabaseSnapshotRequest(input *GetRelationalDatabaseSnapshotInput) (req *request.Request, output *GetRelationalDatabaseSnapshotOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseSnapshotInput{}
	}

	output = &GetRelationalDatabaseSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseSnapshot API operation for Amazon Lightsail.
//
// Returns information about a specific database snapshot in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseSnapshot for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshot
func (c *Lightsail) GetRelationalDatabaseSnapshot(input *GetRelationalDatabaseSnapshotInput) (*GetRelationalDatabaseSnapshotOutput, error) {
	req, out := c.GetRelationalDatabaseSnapshotRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseSnapshotWithContext is the same as GetRelationalDatabaseSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseSnapshotWithContext(ctx aws.Context, input *GetRelationalDatabaseSnapshotInput, opts ...request.Option) (*GetRelationalDatabaseSnapshotOutput, error) {
	req, out := c.GetRelationalDatabaseSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseSnapshots = "GetRelationalDatabaseSnapshots"

// GetRelationalDatabaseSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseSnapshots for more information on using the GetRelationalDatabaseSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseSnapshotsRequest method.
//    req, resp := client.GetRelationalDatabaseSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshots
func (c *Lightsail) GetRelationalDatabaseSnapshotsRequest(input *GetRelationalDatabaseSnapshotsInput) (req *request.Request, output *GetRelationalDatabaseSnapshotsOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseSnapshotsInput{}
	}

	output = &GetRelationalDatabaseSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseSnapshots API operation for Amazon Lightsail.
//
// Returns information about all of your database snapshots in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseSnapshots for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshots
func (c *Lightsail) GetRelationalDatabaseSnapshots(input *GetRelationalDatabaseSnapshotsInput) (*GetRelationalDatabaseSnapshotsOutput, error) {
	req, out := c.GetRelationalDatabaseSnapshotsRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseSnapshotsWithContext is the same as GetRelationalDatabaseSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseSnapshotsWithContext(ctx aws.Context, input *GetRelationalDatabaseSnapshotsInput, opts ...request.Option) (*GetRelationalDatabaseSnapshotsOutput, error) {
	req, out := c.GetRelationalDatabaseSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabases = "GetRelationalDatabases"

// GetRelationalDatabasesRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabases for more information on using the GetRelationalDatabases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabasesRequest method.
//    req, resp := client.GetRelationalDatabasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabases
func (c *Lightsail) GetRelationalDatabasesRequest(input *GetRelationalDatabasesInput) (req *request.Request, output *GetRelationalDatabasesOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabasesInput{}
	}

	output = &GetRelationalDatabasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabases API operation for Amazon Lightsail.
//
// Returns information about all of your databases in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabases for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabases
func (c *Lightsail) GetRelationalDatabases(input *GetRelationalDatabasesInput) (*GetRelationalDatabasesOutput, error) {
	req, out := c.GetRelationalDatabasesRequest(input)
	return out, req.Send()
}

// GetRelationalDatabasesWithContext is the same as GetRelationalDatabases with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabasesWithContext(ctx aws.Context, input *GetRelationalDatabasesInput, opts ...request.Option) (*GetRelationalDatabasesOutput, error) {
	req, out := c.GetRelationalDatabasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStaticIp = "GetStaticIp"

// GetStaticIpRequest generates a "aws/request.Request" representing the
// client's request for the GetStaticIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStaticIp for more information on using the GetStaticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStaticIpRequest method.
//    req, resp := client.GetStaticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp
func (c *Lightsail) GetStaticIpRequest(input *GetStaticIpInput) (req *request.Request, output *GetStaticIpOutput) {
	op := &request.Operation{
		Name:       opGetStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStaticIpInput{}
	}

	output = &GetStaticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStaticIp API operation for Amazon Lightsail.
//
// Returns information about an Amazon Lightsail static IP.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetStaticIp for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp
func (c *Lightsail) GetStaticIp(input *GetStaticIpInput) (*GetStaticIpOutput, error) {
	req, out := c.GetStaticIpRequest(input)
	return out, req.Send()
}

// GetStaticIpWithContext is the same as GetStaticIp with the addition of
// the ability to pass a context and additional request options.
//
// See GetStaticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetStaticIpWithContext(ctx aws.Context, input *GetStaticIpInput, opts ...request.Option) (*GetStaticIpOutput, error) {
	req, out := c.GetStaticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStaticIps = "GetStaticIps"

// GetStaticIpsRequest generates a "aws/request.Request" representing the
// client's request for the GetStaticIps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStaticIps for more information on using the GetStaticIps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStaticIpsRequest method.
//    req, resp := client.GetStaticIpsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps
func (c *Lightsail) GetStaticIpsRequest(input *GetStaticIpsInput) (req *request.Request, output *GetStaticIpsOutput) {
	op := &request.Operation{
		Name:       opGetStaticIps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStaticIpsInput{}
	}

	output = &GetStaticIpsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStaticIps API operation for Amazon Lightsail.
//
// Returns information about all static IPs in the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetStaticIps for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps
func (c *Lightsail) GetStaticIps(input *GetStaticIpsInput) (*GetStaticIpsOutput, error) {
	req, out := c.GetStaticIpsRequest(input)
	return out, req.Send()
}

// GetStaticIpsWithContext is the same as GetStaticIps with the addition of
// the ability to pass a context and additional request options.
//
// See GetStaticIps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetStaticIpsWithContext(ctx aws.Context, input *GetStaticIpsInput, opts ...request.Option) (*GetStaticIpsOutput, error) {
	req, out := c.GetStaticIpsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportKeyPair = "ImportKeyPair"

// ImportKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the ImportKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportKeyPair for more information on using the ImportKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportKeyPairRequest method.
//    req, resp := client.ImportKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair
func (c *Lightsail) ImportKeyPairRequest(input *ImportKeyPairInput) (req *request.Request, output *ImportKeyPairOutput) {
	op := &request.Operation{
		Name:       opImportKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportKeyPairInput{}
	}

	output = &ImportKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportKeyPair API operation for Amazon Lightsail.
//
// Imports a public SSH key from a specific key pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation ImportKeyPair for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair
func (c *Lightsail) ImportKeyPair(input *ImportKeyPairInput) (*ImportKeyPairOutput, error) {
	req, out := c.ImportKeyPairRequest(input)
	return out, req.Send()
}

// ImportKeyPairWithContext is the same as ImportKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See ImportKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) ImportKeyPairWithContext(ctx aws.Context, input *ImportKeyPairInput, opts ...request.Option) (*ImportKeyPairOutput, error) {
	req, out := c.ImportKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opIsVpcPeered = "IsVpcPeered"

// IsVpcPeeredRequest generates a "aws/request.Request" representing the
// client's request for the IsVpcPeered operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See IsVpcPeered for more information on using the IsVpcPeered
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the IsVpcPeeredRequest method.
//    req, resp := client.IsVpcPeeredRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered
func (c *Lightsail) IsVpcPeeredRequest(input *IsVpcPeeredInput) (req *request.Request, output *IsVpcPeeredOutput) {
	op := &request.Operation{
		Name:       opIsVpcPeered,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IsVpcPeeredInput{}
	}

	output = &IsVpcPeeredOutput{}
	req = c.newRequest(op, input, output)
	return
}

// IsVpcPeered API operation for Amazon Lightsail.
//
// Returns a Boolean value indicating whether your Lightsail VPC is peered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation IsVpcPeered for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered
func (c *Lightsail) IsVpcPeered(input *IsVpcPeeredInput) (*IsVpcPeeredOutput, error) {
	req, out := c.IsVpcPeeredRequest(input)
	return out, req.Send()
}

// IsVpcPeeredWithContext is the same as IsVpcPeered with the addition of
// the ability to pass a context and additional request options.
//
// See IsVpcPeered for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) IsVpcPeeredWithContext(ctx aws.Context, input *IsVpcPeeredInput, opts ...request.Option) (*IsVpcPeeredOutput, error) {
	req, out := c.IsVpcPeeredRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opOpenInstancePublicPorts = "OpenInstancePublicPorts"

// OpenInstancePublicPortsRequest generates a "aws/request.Request" representing the
// client's request for the OpenInstancePublicPorts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See OpenInstancePublicPorts for more information on using the OpenInstancePublicPorts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the OpenInstancePublicPortsRequest method.
//    req, resp := client.OpenInstancePublicPortsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPorts
func (c *Lightsail) OpenInstancePublicPortsRequest(input *OpenInstancePublicPortsInput) (req *request.Request, output *OpenInstancePublicPortsOutput) {
	op := &request.Operation{
		Name:       opOpenInstancePublicPorts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &OpenInstancePublicPortsInput{}
	}

	output = &OpenInstancePublicPortsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// OpenInstancePublicPorts API operation for Amazon Lightsail.
//
// Opens ports for a specific Amazon Lightsail instance, and specifies the IP
// addresses allowed to connect to the instance through the ports, and the protocol.
//
// The OpenInstancePublicPorts action supports tag-based access control via
// resource tags applied to the resource identified by instanceName. For more
// information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation OpenInstancePublicPorts for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPorts
func (c *Lightsail) OpenInstancePublicPorts(input *OpenInstancePublicPortsInput) (*OpenInstancePublicPortsOutput, error) {
	req, out := c.OpenInstancePublicPortsRequest(input)
	return out, req.Send()
}

// OpenInstancePublicPortsWithContext is the same as OpenInstancePublicPorts with the addition of
// the ability to pass a context and additional request options.
//
// See OpenInstancePublicPorts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) OpenInstancePublicPortsWithContext(ctx aws.Context, input *OpenInstancePublicPortsInput, opts ...request.Option) (*OpenInstancePublicPortsOutput, error) {
	req, out := c.OpenInstancePublicPortsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPeerVpc = "PeerVpc"

// PeerVpcRequest generates a "aws/request.Request" representing the
// client's request for the PeerVpc operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PeerVpc for more information on using the PeerVpc
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PeerVpcRequest method.
//    req, resp := client.PeerVpcRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc
func (c *Lightsail) PeerVpcRequest(input *PeerVpcInput) (req *request.Request, output *PeerVpcOutput) {
	op := &request.Operation{
		Name:       opPeerVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PeerVpcInput{}
	}

	output = &PeerVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PeerVpc API operation for Amazon Lightsail.
//
// Peers the Lightsail VPC with the user's default VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation PeerVpc for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc
func (c *Lightsail) PeerVpc(input *PeerVpcInput) (*PeerVpcOutput, error) {
	req, out := c.PeerVpcRequest(input)
	return out, req.Send()
}

// PeerVpcWithContext is the same as PeerVpc with the addition of
// the ability to pass a context and additional request options.
//
// See PeerVpc for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) PeerVpcWithContext(ctx aws.Context, input *PeerVpcInput, opts ...request.Option) (*PeerVpcOutput, error) {
	req, out := c.PeerVpcRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAlarm = "PutAlarm"

// PutAlarmRequest generates a "aws/request.Request" representing the
// client's request for the PutAlarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAlarm for more information on using the PutAlarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAlarmRequest method.
//    req, resp := client.PutAlarmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutAlarm
func (c *Lightsail) PutAlarmRequest(input *PutAlarmInput) (req *request.Request, output *PutAlarmOutput) {
	op := &request.Operation{
		Name:       opPutAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAlarmInput{}
	}

	output = &PutAlarmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAlarm API operation for Amazon Lightsail.
//
// Creates or updates an alarm, and associates it with the specified metric.
//
// An alarm is used to monitor a single metric for one of your resources. When
// a metric condition is met, the alarm can notify you by email, SMS text message,
// and a banner displayed on the Amazon Lightsail console. For more information,
// see Alarms in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
//
// When this action creates an alarm, the alarm state is immediately set to
// INSUFFICIENT_DATA. The alarm is then evaluated and its state is set appropriately.
// Any actions associated with the new state are then executed.
//
// When you update an existing alarm, its state is left unchanged, but the update
// completely overwrites the previous configuration of the alarm. The alarm
// is then evaluated with the updated configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation PutAlarm for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutAlarm
func (c *Lightsail) PutAlarm(input *PutAlarmInput) (*PutAlarmOutput, error) {
	req, out := c.PutAlarmRequest(input)
	return out, req.Send()
}

// PutAlarmWithContext is the same as PutAlarm with the addition of
// the ability to pass a context and additional request options.
//
// See PutAlarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) PutAlarmWithContext(ctx aws.Context, input *PutAlarmInput, opts ...request.Option) (*PutAlarmOutput, error) {
	req, out := c.PutAlarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutInstancePublicPorts = "PutInstancePublicPorts"

// PutInstancePublicPortsRequest generates a "aws/request.Request" representing the
// client's request for the PutInstancePublicPorts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutInstancePublicPorts for more information on using the PutInstancePublicPorts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutInstancePublicPortsRequest method.
//    req, resp := client.PutInstancePublicPortsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts
func (c *Lightsail) PutInstancePublicPortsRequest(input *PutInstancePublicPortsInput) (req *request.Request, output *PutInstancePublicPortsOutput) {
	op := &request.Operation{
		Name:       opPutInstancePublicPorts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutInstancePublicPortsInput{}
	}

	output = &PutInstancePublicPortsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutInstancePublicPorts API operation for Amazon Lightsail.
//
// Opens ports for a specific Amazon Lightsail instance, and specifies the IP
// addresses allowed to connect to the instance through the ports, and the protocol.
// This action also closes all currently open ports that are not included in
// the request. Include all of the ports and the protocols you want to open
// in your PutInstancePublicPortsrequest. Or use the OpenInstancePublicPorts
// action to open ports without closing currently open ports.
//
// The PutInstancePublicPorts action supports tag-based access control via resource
// tags applied to the resource identified by instanceName. For more information,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation PutInstancePublicPorts for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts
func (c *Lightsail) PutInstancePublicPorts(input *PutInstancePublicPortsInput) (*PutInstancePublicPortsOutput, error) {
	req, out := c.PutInstancePublicPortsRequest(input)
	return out, req.Send()
}

// PutInstancePublicPortsWithContext is the same as PutInstancePublicPorts with the addition of
// the ability to pass a context and additional request options.
//
// See PutInstancePublicPorts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) PutInstancePublicPortsWithContext(ctx aws.Context, input *PutInstancePublicPortsInput, opts ...request.Option) (*PutInstancePublicPortsOutput, error) {
	req, out := c.PutInstancePublicPortsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootInstance = "RebootInstance"

// RebootInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RebootInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootInstance for more information on using the RebootInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootInstanceRequest method.
//    req, resp := client.RebootInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance
func (c *Lightsail) RebootInstanceRequest(input *RebootInstanceInput) (req *request.Request, output *RebootInstanceOutput) {
	op := &request.Operation{
		Name:       opRebootInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootInstanceInput{}
	}

	output = &RebootInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootInstance API operation for Amazon Lightsail.
//
// Restarts a specific instance.
//
// The reboot instance operation supports tag-based access control via resource
// tags applied to the resource identified by instance name. For more information,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation RebootInstance for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance
func (c *Lightsail) RebootInstance(input *RebootInstanceInput) (*RebootInstanceOutput, error) {
	req, out := c.RebootInstanceRequest(input)
	return out, req.Send()
}

// RebootInstanceWithContext is the same as RebootInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RebootInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) RebootInstanceWithContext(ctx aws.Context, input *RebootInstanceInput, opts ...request.Option) (*RebootInstanceOutput, error) {
	req, out := c.RebootInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootRelationalDatabase = "RebootRelationalDatabase"

// RebootRelationalDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the RebootRelationalDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootRelationalDatabase for more information on using the RebootRelationalDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootRelationalDatabaseRequest method.
//    req, resp := client.RebootRelationalDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootRelationalDatabase
func (c *Lightsail) RebootRelationalDatabaseRequest(input *RebootRelationalDatabaseInput) (req *request.Request, output *RebootRelationalDatabaseOutput) {
	op := &request.Operation{
		Name:       opRebootRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootRelationalDatabaseInput{}
	}

	output = &RebootRelationalDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootRelationalDatabase API operation for Amazon Lightsail.
//
// Restarts a specific database in Amazon Lightsail.
//
// The reboot relational database operation supports tag-based access control
// via resource tags applied to the resource identified by relationalDatabaseName.
// For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation RebootRelationalDatabase for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootRelationalDatabase
func (c *Lightsail) RebootRelationalDatabase(input *RebootRelationalDatabaseInput) (*RebootRelationalDatabaseOutput, error) {
	req, out := c.RebootRelationalDatabaseRequest(input)
	return out, req.Send()
}

// RebootRelationalDatabaseWithContext is the same as RebootRelationalDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See RebootRelationalDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) RebootRelationalDatabaseWithContext(ctx aws.Context, input *RebootRelationalDatabaseInput, opts ...request.Option) (*RebootRelationalDatabaseOutput, error) {
	req, out := c.RebootRelationalDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterContainerImage = "RegisterContainerImage"

// RegisterContainerImageRequest generates a "aws/request.Request" representing the
// client's request for the RegisterContainerImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterContainerImage for more information on using the RegisterContainerImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterContainerImageRequest method.
//    req, resp := client.RegisterContainerImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RegisterContainerImage
func (c *Lightsail) RegisterContainerImageRequest(input *RegisterContainerImageInput) (req *request.Request, output *RegisterContainerImageOutput) {
	op := &request.Operation{
		Name:       opRegisterContainerImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterContainerImageInput{}
	}

	output = &RegisterContainerImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterContainerImage API operation for Amazon Lightsail.
//
// Registers a container image to your Amazon Lightsail container service.
//
// This action is not required if you install and use the Lightsail Control
// (lightsailctl) plugin to push container images to your Lightsail container
// service. For more information, see Pushing and managing container images
// on your Amazon Lightsail container services (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images)
// in the Amazon Lightsail Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation RegisterContainerImage for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RegisterContainerImage
func (c *Lightsail) RegisterContainerImage(input *RegisterContainerImageInput) (*RegisterContainerImageOutput, error) {
	req, out := c.RegisterContainerImageRequest(input)
	return out, req.Send()
}

// RegisterContainerImageWithContext is the same as RegisterContainerImage with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterContainerImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) RegisterContainerImageWithContext(ctx aws.Context, input *RegisterContainerImageInput, opts ...request.Option) (*RegisterContainerImageOutput, error) {
	req, out := c.RegisterContainerImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReleaseStaticIp = "ReleaseStaticIp"

// ReleaseStaticIpRequest generates a "aws/request.Request" representing the
// client's request for the ReleaseStaticIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReleaseStaticIp for more information on using the ReleaseStaticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ReleaseStaticIpRequest method.
//    req, resp := client.ReleaseStaticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIp
func (c *Lightsail) ReleaseStaticIpRequest(input *ReleaseStaticIpInput) (req *request.Request, output *ReleaseStaticIpOutput) {
	op := &request.Operation{
		Name:       opReleaseStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReleaseStaticIpInput{}
	}

	output = &ReleaseStaticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReleaseStaticIp API operation for Amazon Lightsail.
//
// Deletes a specific static IP from your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation ReleaseStaticIp for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIp
func (c *Lightsail) ReleaseStaticIp(input *ReleaseStaticIpInput) (*ReleaseStaticIpOutput, error) {
	req, out := c.ReleaseStaticIpRequest(input)
	return out, req.Send()
}

// ReleaseStaticIpWithContext is the same as ReleaseStaticIp with the addition of
// the ability to pass a context and additional request options.
//
// See ReleaseStaticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) ReleaseStaticIpWithContext(ctx aws.Context, input *ReleaseStaticIpInput, opts ...request.Option) (*ReleaseStaticIpOutput, error) {
	req, out := c.ReleaseStaticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetDistributionCache = "ResetDistributionCache"

// ResetDistributionCacheRequest generates a "aws/request.Request" representing the
// client's request for the ResetDistributionCache operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetDistributionCache for more information on using the ResetDistributionCache
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetDistributionCacheRequest method.
//    req, resp := client.ResetDistributionCacheRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ResetDistributionCache
func (c *Lightsail) ResetDistributionCacheRequest(input *ResetDistributionCacheInput) (req *request.Request, output *ResetDistributionCacheOutput) {
	op := &request.Operation{
		Name:       opResetDistributionCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetDistributionCacheInput{}
	}

	output = &ResetDistributionCacheOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetDistributionCache API operation for Amazon Lightsail.
//
// Deletes currently cached content from your Amazon Lightsail content delivery
// network (CDN) distribution.
//
// After resetting the cache, the next time a content request is made, your
// distribution pulls, serves, and caches it from the origin.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation ResetDistributionCache for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ResetDistributionCache
func (c *Lightsail) ResetDistributionCache(input *ResetDistributionCacheInput) (*ResetDistributionCacheOutput, error) {
	req, out := c.ResetDistributionCacheRequest(input)
	return out, req.Send()
}

// ResetDistributionCacheWithContext is the same as ResetDistributionCache with the addition of
// the ability to pass a context and additional request options.
//
// See ResetDistributionCache for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) ResetDistributionCacheWithContext(ctx aws.Context, input *ResetDistributionCacheInput, opts ...request.Option) (*ResetDistributionCacheOutput, error) {
	req, out := c.ResetDistributionCacheRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendContactMethodVerification = "SendContactMethodVerification"

// SendContactMethodVerificationRequest generates a "aws/request.Request" representing the
// client's request for the SendContactMethodVerification operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendContactMethodVerification for more information on using the SendContactMethodVerification
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendContactMethodVerificationRequest method.
//    req, resp := client.SendContactMethodVerificationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/SendContactMethodVerification
func (c *Lightsail) SendContactMethodVerificationRequest(input *SendContactMethodVerificationInput) (req *request.Request, output *SendContactMethodVerificationOutput) {
	op := &request.Operation{
		Name:       opSendContactMethodVerification,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendContactMethodVerificationInput{}
	}

	output = &SendContactMethodVerificationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendContactMethodVerification API operation for Amazon Lightsail.
//
// Sends a verification request to an email contact method to ensure it's owned
// by the requester. SMS contact methods don't need to be verified.
//
// A contact method is used to send you notifications about your Amazon Lightsail
// resources. You can add one email address and one mobile phone number contact
// method in each AWS Region. However, SMS text messaging is not supported in
// some AWS Regions, and SMS text messages cannot be sent to some countries/regions.
// For more information, see Notifications in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
//
// A verification request is sent to the contact method when you initially create
// it. Use this action to send another verification request if a previous verification
// request was deleted, or has expired.
//
// Notifications are not sent to an email contact method until after it is verified,
// and confirmed as valid.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation SendContactMethodVerification for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/SendContactMethodVerification
func (c *Lightsail) SendContactMethodVerification(input *SendContactMethodVerificationInput) (*SendContactMethodVerificationOutput, error) {
	req, out := c.SendContactMethodVerificationRequest(input)
	return out, req.Send()
}

// SendContactMethodVerificationWithContext is the same as SendContactMethodVerification with the addition of
// the ability to pass a context and additional request options.
//
// See SendContactMethodVerification for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) SendContactMethodVerificationWithContext(ctx aws.Context, input *SendContactMethodVerificationInput, opts ...request.Option) (*SendContactMethodVerificationOutput, error) {
	req, out := c.SendContactMethodVerificationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetIpAddressType = "SetIpAddressType"

// SetIpAddressTypeRequest generates a "aws/request.Request" representing the
// client's request for the SetIpAddressType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetIpAddressType for more information on using the SetIpAddressType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetIpAddressTypeRequest method.
//    req, resp := client.SetIpAddressTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/SetIpAddressType
func (c *Lightsail) SetIpAddressTypeRequest(input *SetIpAddressTypeInput) (req *request.Request, output *SetIpAddressTypeOutput) {
	op := &request.Operation{
		Name:       opSetIpAddressType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIpAddressTypeInput{}
	}

	output = &SetIpAddressTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetIpAddressType API operation for Amazon Lightsail.
//
// Sets the IP address type for an Amazon Lightsail resource.
//
// Use this action to enable dual-stack for a resource, which enables IPv4 and
// IPv6 for the specified resource. Alternately, you can use this action to
// disable dual-stack, and enable IPv4 only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation SetIpAddressType for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/SetIpAddressType
func (c *Lightsail) SetIpAddressType(input *SetIpAddressTypeInput) (*SetIpAddressTypeOutput, error) {
	req, out := c.SetIpAddressTypeRequest(input)
	return out, req.Send()
}

// SetIpAddressTypeWithContext is the same as SetIpAddressType with the addition of
// the ability to pass a context and additional request options.
//
// See SetIpAddressType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) SetIpAddressTypeWithContext(ctx aws.Context, input *SetIpAddressTypeInput, opts ...request.Option) (*SetIpAddressTypeOutput, error) {
	req, out := c.SetIpAddressTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetResourceAccessForBucket = "SetResourceAccessForBucket"

// SetResourceAccessForBucketRequest generates a "aws/request.Request" representing the
// client's request for the SetResourceAccessForBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetResourceAccessForBucket for more information on using the SetResourceAccessForBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetResourceAccessForBucketRequest method.
//    req, resp := client.SetResourceAccessForBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/SetResourceAccessForBucket
func (c *Lightsail) SetResourceAccessForBucketRequest(input *SetResourceAccessForBucketInput) (req *request.Request, output *SetResourceAccessForBucketOutput) {
	op := &request.Operation{
		Name:       opSetResourceAccessForBucket,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetResourceAccessForBucketInput{}
	}

	output = &SetResourceAccessForBucketOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetResourceAccessForBucket API operation for Amazon Lightsail.
//
// Sets the Amazon Lightsail resources that can access the specified Lightsail
// bucket.
//
// Lightsail buckets currently support setting access for Lightsail instances
// in the same AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation SetResourceAccessForBucket for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ServiceException
//   A general service exception.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/SetResourceAccessForBucket
func (c *Lightsail) SetResourceAccessForBucket(input *SetResourceAccessForBucketInput) (*SetResourceAccessForBucketOutput, error) {
	req, out := c.SetResourceAccessForBucketRequest(input)
	return out, req.Send()
}

// SetResourceAccessForBucketWithContext is the same as SetResourceAccessForBucket with the addition of
// the ability to pass a context and additional request options.
//
// See SetResourceAccessForBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) SetResourceAccessForBucketWithContext(ctx aws.Context, input *SetResourceAccessForBucketInput, opts ...request.Option) (*SetResourceAccessForBucketOutput, error) {
	req, out := c.SetResourceAccessForBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartInstance = "StartInstance"

// StartInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StartInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartInstance for more information on using the StartInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartInstanceRequest method.
//    req, resp := client.StartInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance
func (c *Lightsail) StartInstanceRequest(input *StartInstanceInput) (req *request.Request, output *StartInstanceOutput) {
	op := &request.Operation{
		Name:       opStartInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartInstanceInput{}
	}

	output = &StartInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartInstance API operation for Amazon Lightsail.
//
// Starts a specific Amazon Lightsail instance from a stopped state. To restart
// an instance, use the reboot instance operation.
//
// When you start a stopped instance, Lightsail assigns a new public IP address
// to the instance. To use the same IP address after stopping and starting an
// instance, create a static IP address and attach it to the instance. For more
// information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-create-static-ip).
//
// The start instance operation supports tag-based access control via resource
// tags applied to the resource identified by instance name. For more information,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation StartInstance for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance
func (c *Lightsail) StartInstance(input *StartInstanceInput) (*StartInstanceOutput, error) {
	req, out := c.StartInstanceRequest(input)
	return out, req.Send()
}

// StartInstanceWithContext is the same as StartInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StartInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) StartInstanceWithContext(ctx aws.Context, input *StartInstanceInput, opts ...request.Option) (*StartInstanceOutput, error) {
	req, out := c.StartInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartRelationalDatabase = "StartRelationalDatabase"

// StartRelationalDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the StartRelationalDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartRelationalDatabase for more information on using the StartRelationalDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartRelationalDatabaseRequest method.
//    req, resp := client.StartRelationalDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartRelationalDatabase
func (c *Lightsail) StartRelationalDatabaseRequest(input *StartRelationalDatabaseInput) (req *request.Request, output *StartRelationalDatabaseOutput) {
	op := &request.Operation{
		Name:       opStartRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartRelationalDatabaseInput{}
	}

	output = &StartRelationalDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartRelationalDatabase API operation for Amazon Lightsail.
//
// Starts a specific database from a stopped state in Amazon Lightsail. To restart
// a database, use the reboot relational database operation.
//
// The start relational database operation supports tag-based access control
// via resource tags applied to the resource identified by relationalDatabaseName.
// For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation StartRelationalDatabase for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartRelationalDatabase
func (c *Lightsail) StartRelationalDatabase(input *StartRelationalDatabaseInput) (*StartRelationalDatabaseOutput, error) {
	req, out := c.StartRelationalDatabaseRequest(input)
	return out, req.Send()
}

// StartRelationalDatabaseWithContext is the same as StartRelationalDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See StartRelationalDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) StartRelationalDatabaseWithContext(ctx aws.Context, input *StartRelationalDatabaseInput, opts ...request.Option) (*StartRelationalDatabaseOutput, error) {
	req, out := c.StartRelationalDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopInstance = "StopInstance"

// StopInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StopInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopInstance for more information on using the StopInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopInstanceRequest method.
//    req, resp := client.StopInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance
func (c *Lightsail) StopInstanceRequest(input *StopInstanceInput) (req *request.Request, output *StopInstanceOutput) {
	op := &request.Operation{
		Name:       opStopInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopInstanceInput{}
	}

	output = &StopInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopInstance API operation for Amazon Lightsail.
//
// Stops a specific Amazon Lightsail instance that is currently running.
//
// When you start a stopped instance, Lightsail assigns a new public IP address
// to the instance. To use the same IP address after stopping and starting an
// instance, create a static IP address and attach it to the instance. For more
// information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-create-static-ip).
//
// The stop instance operation supports tag-based access control via resource
// tags applied to the resource identified by instance name. For more information,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation StopInstance for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance
func (c *Lightsail) StopInstance(input *StopInstanceInput) (*StopInstanceOutput, error) {
	req, out := c.StopInstanceRequest(input)
	return out, req.Send()
}

// StopInstanceWithContext is the same as StopInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StopInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) StopInstanceWithContext(ctx aws.Context, input *StopInstanceInput, opts ...request.Option) (*StopInstanceOutput, error) {
	req, out := c.StopInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopRelationalDatabase = "StopRelationalDatabase"

// StopRelationalDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the StopRelationalDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopRelationalDatabase for more information on using the StopRelationalDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopRelationalDatabaseRequest method.
//    req, resp := client.StopRelationalDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopRelationalDatabase
func (c *Lightsail) StopRelationalDatabaseRequest(input *StopRelationalDatabaseInput) (req *request.Request, output *StopRelationalDatabaseOutput) {
	op := &request.Operation{
		Name:       opStopRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopRelationalDatabaseInput{}
	}

	output = &StopRelationalDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopRelationalDatabase API operation for Amazon Lightsail.
//
// Stops a specific database that is currently running in Amazon Lightsail.
//
// The stop relational database operation supports tag-based access control
// via resource tags applied to the resource identified by relationalDatabaseName.
// For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation StopRelationalDatabase for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopRelationalDatabase
func (c *Lightsail) StopRelationalDatabase(input *StopRelationalDatabaseInput) (*StopRelationalDatabaseOutput, error) {
	req, out := c.StopRelationalDatabaseRequest(input)
	return out, req.Send()
}

// StopRelationalDatabaseWithContext is the same as StopRelationalDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See StopRelationalDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) StopRelationalDatabaseWithContext(ctx aws.Context, input *StopRelationalDatabaseInput, opts ...request.Option) (*StopRelationalDatabaseOutput, error) {
	req, out := c.StopRelationalDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/TagResource
func (c *Lightsail) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResource API operation for Amazon Lightsail.
//
// Adds one or more tags to the specified Amazon Lightsail resource. Each resource
// can have a maximum of 50 tags. Each tag consists of a key and an optional
// value. Tag keys must be unique per resource. For more information about tags,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
//
// The tag resource operation supports tag-based access control via request
// tags and resource tags applied to the resource identified by resource name.
// For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/TagResource
func (c *Lightsail) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestAlarm = "TestAlarm"

// TestAlarmRequest generates a "aws/request.Request" representing the
// client's request for the TestAlarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestAlarm for more information on using the TestAlarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestAlarmRequest method.
//    req, resp := client.TestAlarmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/TestAlarm
func (c *Lightsail) TestAlarmRequest(input *TestAlarmInput) (req *request.Request, output *TestAlarmOutput) {
	op := &request.Operation{
		Name:       opTestAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestAlarmInput{}
	}

	output = &TestAlarmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestAlarm API operation for Amazon Lightsail.
//
// Tests an alarm by displaying a banner on the Amazon Lightsail console. If
// a notification trigger is configured for the specified alarm, the test also
// sends a notification to the notification protocol (Email and/or SMS) configured
// for the alarm.
//
// An alarm is used to monitor a single metric for one of your resources. When
// a metric condition is met, the alarm can notify you by email, SMS text message,
// and a banner displayed on the Amazon Lightsail console. For more information,
// see Alarms in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation TestAlarm for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/TestAlarm
func (c *Lightsail) TestAlarm(input *TestAlarmInput) (*TestAlarmOutput, error) {
	req, out := c.TestAlarmRequest(input)
	return out, req.Send()
}

// TestAlarmWithContext is the same as TestAlarm with the addition of
// the ability to pass a context and additional request options.
//
// See TestAlarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) TestAlarmWithContext(ctx aws.Context, input *TestAlarmInput, opts ...request.Option) (*TestAlarmOutput, error) {
	req, out := c.TestAlarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnpeerVpc = "UnpeerVpc"

// UnpeerVpcRequest generates a "aws/request.Request" representing the
// client's request for the UnpeerVpc operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnpeerVpc for more information on using the UnpeerVpc
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UnpeerVpcRequest method.
//    req, resp := client.UnpeerVpcRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc
func (c *Lightsail) UnpeerVpcRequest(input *UnpeerVpcInput) (req *request.Request, output *UnpeerVpcOutput) {
	op := &request.Operation{
		Name:       opUnpeerVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnpeerVpcInput{}
	}

	output = &UnpeerVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UnpeerVpc API operation for Amazon Lightsail.
//
// Unpeers the Lightsail VPC from the user's default VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UnpeerVpc for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc
func (c *Lightsail) UnpeerVpc(input *UnpeerVpcInput) (*UnpeerVpcOutput, error) {
	req, out := c.UnpeerVpcRequest(input)
	return out, req.Send()
}

// UnpeerVpcWithContext is the same as UnpeerVpc with the addition of
// the ability to pass a context and additional request options.
//
// See UnpeerVpc for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UnpeerVpcWithContext(ctx aws.Context, input *UnpeerVpcInput, opts ...request.Option) (*UnpeerVpcOutput, error) {
	req, out := c.UnpeerVpcRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UntagResource
func (c *Lightsail) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResource API operation for Amazon Lightsail.
//
// Deletes the specified set of tag keys and their values from the specified
// Amazon Lightsail resource.
//
// The untag resource operation supports tag-based access control via request
// tags and resource tags applied to the resource identified by resource name.
// For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UntagResource
func (c *Lightsail) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBucket = "UpdateBucket"

// UpdateBucketRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBucket for more information on using the UpdateBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBucketRequest method.
//    req, resp := client.UpdateBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateBucket
func (c *Lightsail) UpdateBucketRequest(input *UpdateBucketInput) (req *request.Request, output *UpdateBucketOutput) {
	op := &request.Operation{
		Name:       opUpdateBucket,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBucketInput{}
	}

	output = &UpdateBucketOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBucket API operation for Amazon Lightsail.
//
// Updates an existing Amazon Lightsail bucket.
//
// Use this action to update the configuration of an existing bucket, such as
// versioning, public accessibility, and the AWS accounts that can access the
// bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UpdateBucket for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ServiceException
//   A general service exception.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateBucket
func (c *Lightsail) UpdateBucket(input *UpdateBucketInput) (*UpdateBucketOutput, error) {
	req, out := c.UpdateBucketRequest(input)
	return out, req.Send()
}

// UpdateBucketWithContext is the same as UpdateBucket with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UpdateBucketWithContext(ctx aws.Context, input *UpdateBucketInput, opts ...request.Option) (*UpdateBucketOutput, error) {
	req, out := c.UpdateBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBucketBundle = "UpdateBucketBundle"

// UpdateBucketBundleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBucketBundle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBucketBundle for more information on using the UpdateBucketBundle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBucketBundleRequest method.
//    req, resp := client.UpdateBucketBundleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateBucketBundle
func (c *Lightsail) UpdateBucketBundleRequest(input *UpdateBucketBundleInput) (req *request.Request, output *UpdateBucketBundleOutput) {
	op := &request.Operation{
		Name:       opUpdateBucketBundle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBucketBundleInput{}
	}

	output = &UpdateBucketBundleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBucketBundle API operation for Amazon Lightsail.
//
// Updates the bundle, or storage plan, of an existing Amazon Lightsail bucket.
//
// A bucket bundle specifies the monthly cost, storage space, and data transfer
// quota for a bucket. You can update a bucket's bundle only one time within
// a monthly AWS billing cycle. To determine if you can update a bucket's bundle,
// use the GetBuckets action. The ableToUpdateBundle parameter in the response
// will indicate whether you can currently update a bucket's bundle.
//
// Update a bucket's bundle if it's consistently going over its storage space
// or data transfer quota, or if a bucket's usage is consistently in the lower
// range of its storage space or data transfer quota. Due to the unpredictable
// usage fluctuations that a bucket might experience, we strongly recommend
// that you update a bucket's bundle only as a long-term strategy, instead of
// as a short-term, monthly cost-cutting measure. Choose a bucket bundle that
// will provide the bucket with ample storage space and data transfer for a
// long time to come.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UpdateBucketBundle for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ServiceException
//   A general service exception.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateBucketBundle
func (c *Lightsail) UpdateBucketBundle(input *UpdateBucketBundleInput) (*UpdateBucketBundleOutput, error) {
	req, out := c.UpdateBucketBundleRequest(input)
	return out, req.Send()
}

// UpdateBucketBundleWithContext is the same as UpdateBucketBundle with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBucketBundle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UpdateBucketBundleWithContext(ctx aws.Context, input *UpdateBucketBundleInput, opts ...request.Option) (*UpdateBucketBundleOutput, error) {
	req, out := c.UpdateBucketBundleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContainerService = "UpdateContainerService"

// UpdateContainerServiceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContainerService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContainerService for more information on using the UpdateContainerService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateContainerServiceRequest method.
//    req, resp := client.UpdateContainerServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateContainerService
func (c *Lightsail) UpdateContainerServiceRequest(input *UpdateContainerServiceInput) (req *request.Request, output *UpdateContainerServiceOutput) {
	op := &request.Operation{
		Name:       opUpdateContainerService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateContainerServiceInput{}
	}

	output = &UpdateContainerServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateContainerService API operation for Amazon Lightsail.
//
// Updates the configuration of your Amazon Lightsail container service, such
// as its power, scale, and public domain names.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UpdateContainerService for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateContainerService
func (c *Lightsail) UpdateContainerService(input *UpdateContainerServiceInput) (*UpdateContainerServiceOutput, error) {
	req, out := c.UpdateContainerServiceRequest(input)
	return out, req.Send()
}

// UpdateContainerServiceWithContext is the same as UpdateContainerService with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContainerService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UpdateContainerServiceWithContext(ctx aws.Context, input *UpdateContainerServiceInput, opts ...request.Option) (*UpdateContainerServiceOutput, error) {
	req, out := c.UpdateContainerServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDistribution = "UpdateDistribution"

// UpdateDistributionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDistribution for more information on using the UpdateDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDistributionRequest method.
//    req, resp := client.UpdateDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDistribution
func (c *Lightsail) UpdateDistributionRequest(input *UpdateDistributionInput) (req *request.Request, output *UpdateDistributionOutput) {
	op := &request.Operation{
		Name:       opUpdateDistribution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDistributionInput{}
	}

	output = &UpdateDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDistribution API operation for Amazon Lightsail.
//
// Updates an existing Amazon Lightsail content delivery network (CDN) distribution.
//
// Use this action to update the configuration of your existing distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UpdateDistribution for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDistribution
func (c *Lightsail) UpdateDistribution(input *UpdateDistributionInput) (*UpdateDistributionOutput, error) {
	req, out := c.UpdateDistributionRequest(input)
	return out, req.Send()
}

// UpdateDistributionWithContext is the same as UpdateDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UpdateDistributionWithContext(ctx aws.Context, input *UpdateDistributionInput, opts ...request.Option) (*UpdateDistributionOutput, error) {
	req, out := c.UpdateDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDistributionBundle = "UpdateDistributionBundle"

// UpdateDistributionBundleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDistributionBundle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDistributionBundle for more information on using the UpdateDistributionBundle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDistributionBundleRequest method.
//    req, resp := client.UpdateDistributionBundleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDistributionBundle
func (c *Lightsail) UpdateDistributionBundleRequest(input *UpdateDistributionBundleInput) (req *request.Request, output *UpdateDistributionBundleOutput) {
	op := &request.Operation{
		Name:       opUpdateDistributionBundle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDistributionBundleInput{}
	}

	output = &UpdateDistributionBundleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDistributionBundle API operation for Amazon Lightsail.
//
// Updates the bundle of your Amazon Lightsail content delivery network (CDN)
// distribution.
//
// A distribution bundle specifies the monthly network transfer quota and monthly
// cost of your dsitribution.
//
// Update your distribution's bundle if your distribution is going over its
// monthly network transfer quota and is incurring an overage fee.
//
// You can update your distribution's bundle only one time within your monthly
// AWS billing cycle. To determine if you can update your distribution's bundle,
// use the GetDistributions action. The ableToUpdateBundle parameter in the
// result will indicate whether you can currently update your distribution's
// bundle.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UpdateDistributionBundle for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDistributionBundle
func (c *Lightsail) UpdateDistributionBundle(input *UpdateDistributionBundleInput) (*UpdateDistributionBundleOutput, error) {
	req, out := c.UpdateDistributionBundleRequest(input)
	return out, req.Send()
}

// UpdateDistributionBundleWithContext is the same as UpdateDistributionBundle with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDistributionBundle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UpdateDistributionBundleWithContext(ctx aws.Context, input *UpdateDistributionBundleInput, opts ...request.Option) (*UpdateDistributionBundleOutput, error) {
	req, out := c.UpdateDistributionBundleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomainEntry = "UpdateDomainEntry"

// UpdateDomainEntryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomainEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomainEntry for more information on using the UpdateDomainEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDomainEntryRequest method.
//    req, resp := client.UpdateDomainEntryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntry
func (c *Lightsail) UpdateDomainEntryRequest(input *UpdateDomainEntryInput) (req *request.Request, output *UpdateDomainEntryOutput) {
	op := &request.Operation{
		Name:       opUpdateDomainEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDomainEntryInput{}
	}

	output = &UpdateDomainEntryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDomainEntry API operation for Amazon Lightsail.
//
// Updates a domain recordset after it is created.
//
// The update domain entry operation supports tag-based access control via resource
// tags applied to the resource identified by domain name. For more information,
// see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UpdateDomainEntry for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntry
func (c *Lightsail) UpdateDomainEntry(input *UpdateDomainEntryInput) (*UpdateDomainEntryOutput, error) {
	req, out := c.UpdateDomainEntryRequest(input)
	return out, req.Send()
}

// UpdateDomainEntryWithContext is the same as UpdateDomainEntry with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomainEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UpdateDomainEntryWithContext(ctx aws.Context, input *UpdateDomainEntryInput, opts ...request.Option) (*UpdateDomainEntryOutput, error) {
	req, out := c.UpdateDomainEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLoadBalancerAttribute = "UpdateLoadBalancerAttribute"

// UpdateLoadBalancerAttributeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLoadBalancerAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLoadBalancerAttribute for more information on using the UpdateLoadBalancerAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLoadBalancerAttributeRequest method.
//    req, resp := client.UpdateLoadBalancerAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateLoadBalancerAttribute
func (c *Lightsail) UpdateLoadBalancerAttributeRequest(input *UpdateLoadBalancerAttributeInput) (req *request.Request, output *UpdateLoadBalancerAttributeOutput) {
	op := &request.Operation{
		Name:       opUpdateLoadBalancerAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLoadBalancerAttributeInput{}
	}

	output = &UpdateLoadBalancerAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLoadBalancerAttribute API operation for Amazon Lightsail.
//
// Updates the specified attribute for a load balancer. You can only update
// one attribute at a time.
//
// The update load balancer attribute operation supports tag-based access control
// via resource tags applied to the resource identified by load balancer name.
// For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UpdateLoadBalancerAttribute for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateLoadBalancerAttribute
func (c *Lightsail) UpdateLoadBalancerAttribute(input *UpdateLoadBalancerAttributeInput) (*UpdateLoadBalancerAttributeOutput, error) {
	req, out := c.UpdateLoadBalancerAttributeRequest(input)
	return out, req.Send()
}

// UpdateLoadBalancerAttributeWithContext is the same as UpdateLoadBalancerAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLoadBalancerAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UpdateLoadBalancerAttributeWithContext(ctx aws.Context, input *UpdateLoadBalancerAttributeInput, opts ...request.Option) (*UpdateLoadBalancerAttributeOutput, error) {
	req, out := c.UpdateLoadBalancerAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRelationalDatabase = "UpdateRelationalDatabase"

// UpdateRelationalDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRelationalDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRelationalDatabase for more information on using the UpdateRelationalDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRelationalDatabaseRequest method.
//    req, resp := client.UpdateRelationalDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabase
func (c *Lightsail) UpdateRelationalDatabaseRequest(input *UpdateRelationalDatabaseInput) (req *request.Request, output *UpdateRelationalDatabaseOutput) {
	op := &request.Operation{
		Name:       opUpdateRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRelationalDatabaseInput{}
	}

	output = &UpdateRelationalDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRelationalDatabase API operation for Amazon Lightsail.
//
// Allows the update of one or more attributes of a database in Amazon Lightsail.
//
// Updates are applied immediately, or in cases where the updates could result
// in an outage, are applied during the database's predefined maintenance window.
//
// The update relational database operation supports tag-based access control
// via resource tags applied to the resource identified by relationalDatabaseName.
// For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UpdateRelationalDatabase for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabase
func (c *Lightsail) UpdateRelationalDatabase(input *UpdateRelationalDatabaseInput) (*UpdateRelationalDatabaseOutput, error) {
	req, out := c.UpdateRelationalDatabaseRequest(input)
	return out, req.Send()
}

// UpdateRelationalDatabaseWithContext is the same as UpdateRelationalDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRelationalDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UpdateRelationalDatabaseWithContext(ctx aws.Context, input *UpdateRelationalDatabaseInput, opts ...request.Option) (*UpdateRelationalDatabaseOutput, error) {
	req, out := c.UpdateRelationalDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRelationalDatabaseParameters = "UpdateRelationalDatabaseParameters"

// UpdateRelationalDatabaseParametersRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRelationalDatabaseParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRelationalDatabaseParameters for more information on using the UpdateRelationalDatabaseParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRelationalDatabaseParametersRequest method.
//    req, resp := client.UpdateRelationalDatabaseParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabaseParameters
func (c *Lightsail) UpdateRelationalDatabaseParametersRequest(input *UpdateRelationalDatabaseParametersInput) (req *request.Request, output *UpdateRelationalDatabaseParametersOutput) {
	op := &request.Operation{
		Name:       opUpdateRelationalDatabaseParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRelationalDatabaseParametersInput{}
	}

	output = &UpdateRelationalDatabaseParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRelationalDatabaseParameters API operation for Amazon Lightsail.
//
// Allows the update of one or more parameters of a database in Amazon Lightsail.
//
// Parameter updates don't cause outages; therefore, their application is not
// subject to the preferred maintenance window. However, there are two ways
// in which parameter updates are applied: dynamic or pending-reboot. Parameters
// marked with a dynamic apply type are applied immediately. Parameters marked
// with a pending-reboot apply type are applied only after the database is rebooted
// using the reboot relational database operation.
//
// The update relational database parameters operation supports tag-based access
// control via resource tags applied to the resource identified by relationalDatabaseName.
// For more information, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UpdateRelationalDatabaseParameters for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   A general service exception.
//
//   * InvalidInputException
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain and distribution APIs are only available in the N. Virginia (us-east-1)
//   AWS Region. Please set your AWS Region configuration to us-east-1 to create,
//   view, or edit these resources.
//
//   * NotFoundException
//   Lightsail throws this exception when it cannot find a resource.
//
//   * OperationFailureException
//   Lightsail throws this exception when an operation fails to execute.
//
//   * AccessDeniedException
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * AccountSetupInProgressException
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * UnauthenticatedException
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabaseParameters
func (c *Lightsail) UpdateRelationalDatabaseParameters(input *UpdateRelationalDatabaseParametersInput) (*UpdateRelationalDatabaseParametersOutput, error) {
	req, out := c.UpdateRelationalDatabaseParametersRequest(input)
	return out, req.Send()
}

// UpdateRelationalDatabaseParametersWithContext is the same as UpdateRelationalDatabaseParameters with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRelationalDatabaseParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UpdateRelationalDatabaseParametersWithContext(ctx aws.Context, input *UpdateRelationalDatabaseParametersInput, opts ...request.Option) (*UpdateRelationalDatabaseParametersOutput, error) {
	req, out := c.UpdateRelationalDatabaseParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Lightsail throws this exception when the user cannot be authenticated or
// uses invalid credentials to access a resource.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Docs *string `locationName:"docs" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	Tip *string `locationName:"tip" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes an access key for an Amazon Lightsail bucket.
//
// Access keys grant full programmatic access to the specified bucket and its
// objects. You can have a maximum of two access keys per bucket. Use the CreateBucketAccessKey
// action to create an access key for a specific bucket. For more information
// about access keys, see Creating access keys for a bucket in Amazon Lightsail
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys)
// in the Amazon Lightsail Developer Guide.
//
// The secretAccessKey value is returned only in response to the CreateBucketAccessKey
// action. You can get a secret access key only when you first create an access
// key; you cannot get the secret access key later. If you lose the secret access
// key, you must create a new access key.
type AccessKey struct {
	_ struct{} `type:"structure"`

	// The ID of the access key.
	AccessKeyId *string `locationName:"accessKeyId" min:"20" type:"string" sensitive:"true"`

	// The timestamp when the access key was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The secret access key used to sign requests.
	//
	// You should store the secret access key in a safe location. We recommend that
	// you delete the access key if the secret access key is compromised.
	SecretAccessKey *string `locationName:"secretAccessKey" type:"string"`

	// The status of the access key.
	//
	// A status of Active means that the key is valid, while Inactive means it is
	// not.
	Status *string `locationName:"status" type:"string" enum:"StatusType"`
}

// String returns the string representation
func (s AccessKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessKey) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *AccessKey) SetAccessKeyId(v string) *AccessKey {
	s.AccessKeyId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AccessKey) SetCreatedAt(v time.Time) *AccessKey {
	s.CreatedAt = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *AccessKey) SetSecretAccessKey(v string) *AccessKey {
	s.SecretAccessKey = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccessKey) SetStatus(v string) *AccessKey {
	s.Status = &v
	return s
}

// Describes the anonymous access permissions for an Amazon Lightsail bucket
// and its objects.
//
// For more information about bucket access permissions, see Understanding bucket
// permissions in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-understanding-bucket-permissions)
// in the
//
// Amazon Lightsail Developer Guide.
type AccessRules struct {
	_ struct{} `type:"structure"`

	// A Boolean value that indicates whether the access control list (ACL) permissions
	// that are applied to individual objects override the getObject option that
	// is currently specified.
	//
	// When this is true, you can use the PutObjectAcl (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectAcl.html)
	// Amazon S3 API action to set individual objects to public (read-only) using
	// the public-read ACL, or to private using the private ACL.
	AllowPublicOverrides *bool `locationName:"allowPublicOverrides" type:"boolean"`

	// Specifies the anonymous access to all objects in a bucket.
	//
	// The following options can be specified:
	//
	//    * public - Sets all objects in the bucket to public (read-only), making
	//    them readable by anyone in the world. If the getObject value is set to
	//    public, then all objects in the bucket default to public regardless of
	//    the allowPublicOverrides value.
	//
	//    * private - Sets all objects in the bucket to private, making them readable
	//    only by you or anyone you give access to. If the getObject value is set
	//    to private, and the allowPublicOverrides value is set to true, then all
	//    objects in the bucket default to private unless they are configured with
	//    a public-read ACL. Individual objects with a public-read ACL are readable
	//    by anyone in the world.
	GetObject *string `locationName:"getObject" type:"string" enum:"AccessType"`
}

// String returns the string representation
func (s AccessRules) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessRules) GoString() string {
	return s.String()
}

// SetAllowPublicOverrides sets the AllowPublicOverrides field's value.
func (s *AccessRules) SetAllowPublicOverrides(v bool) *AccessRules {
	s.AllowPublicOverrides = &v
	return s
}

// SetGetObject sets the GetObject field's value.
func (s *AccessRules) SetGetObject(v string) *AccessRules {
	s.GetObject = &v
	return s
}

// Lightsail throws this exception when an account is still in the setup in
// progress state.
type AccountSetupInProgressException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Docs *string `locationName:"docs" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	Tip *string `locationName:"tip" type:"string"`
}

// String returns the string representation
func (s AccountSetupInProgressException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountSetupInProgressException) GoString() string {
	return s.String()
}

func newErrorAccountSetupInProgressException(v protocol.ResponseMetadata) error {
	return &AccountSetupInProgressException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccountSetupInProgressException) Code() string {
	return "AccountSetupInProgressException"
}

// Message returns the exception's message.
func (s *AccountSetupInProgressException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccountSetupInProgressException) OrigErr() error {
	return nil
}

func (s *AccountSetupInProgressException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccountSetupInProgressException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccountSetupInProgressException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes an add-on that is enabled for an Amazon Lightsail resource.
type AddOn struct {
	_ struct{} `type:"structure"`

	// The name of the add-on.
	Name *string `locationName:"name" type:"string"`

	// The next daily time an automatic snapshot will be created.
	//
	// The time shown is in HH:00 format, and in Coordinated Universal Time (UTC).
	//
	// The snapshot is automatically created between the time shown and up to 45
	// minutes after.
	NextSnapshotTimeOfDay *string `locationName:"nextSnapshotTimeOfDay" type:"string"`

	// The daily time when an automatic snapshot is created.
	//
	// The time shown is in HH:00 format, and in Coordinated Universal Time (UTC).
	//
	// The snapshot is automatically created between the time shown and up to 45
	// minutes after.
	SnapshotTimeOfDay *string `locationName:"snapshotTimeOfDay" type:"string"`

	// The status of the add-on.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s AddOn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddOn) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AddOn) SetName(v string) *AddOn {
	s.Name = &v
	return s
}

// SetNextSnapshotTimeOfDay sets the NextSnapshotTimeOfDay field's value.
func (s *AddOn) SetNextSnapshotTimeOfDay(v string) *AddOn {
	s.NextSnapshotTimeOfDay = &v
	return s
}

// SetSnapshotTimeOfDay sets the SnapshotTimeOfDay field's value.
func (s *AddOn) SetSnapshotTimeOfDay(v string) *AddOn {
	s.SnapshotTimeOfDay = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AddOn) SetStatus(v string) *AddOn {
	s.Status = &v
	return s
}

// Describes a request to enable, modify, or disable an add-on for an Amazon
// Lightsail resource.
//
// An additional cost may be associated with enabling add-ons. For more information,
// see the Lightsail pricing page (https://aws.amazon.com/lightsail/pricing/).
type AddOnRequest struct {
	_ struct{} `type:"structure"`

	// The add-on type.
	//
	// AddOnType is a required field
	AddOnType *string `locationName:"addOnType" type:"string" required:"true" enum:"AddOnType"`

	// An object that represents additional parameters when enabling or modifying
	// the automatic snapshot add-on.
	AutoSnapshotAddOnRequest *AutoSnapshotAddOnRequest `locationName:"autoSnapshotAddOnRequest" type:"structure"`
}

// String returns the string representation
func (s AddOnRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddOnRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddOnRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddOnRequest"}
	if s.AddOnType == nil {
		invalidParams.Add(request.NewErrParamRequired("AddOnType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddOnType sets the AddOnType field's value.
func (s *AddOnRequest) SetAddOnType(v string) *AddOnRequest {
	s.AddOnType = &v
	return s
}

// SetAutoSnapshotAddOnRequest sets the AutoSnapshotAddOnRequest field's value.
func (s *AddOnRequest) SetAutoSnapshotAddOnRequest(v *AutoSnapshotAddOnRequest) *AddOnRequest {
	s.AutoSnapshotAddOnRequest = v
	return s
}

// Describes an alarm.
//
// An alarm is a way to monitor your Lightsail resource metrics. For more information,
// see Alarms in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
type Alarm struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the alarm.
	Arn *string `locationName:"arn" type:"string"`

	// The arithmetic operation used when comparing the specified statistic and
	// threshold.
	ComparisonOperator *string `locationName:"comparisonOperator" type:"string" enum:"ComparisonOperator"`

	// The contact protocols for the alarm, such as Email, SMS (text messaging),
	// or both.
	ContactProtocols []*string `locationName:"contactProtocols" type:"list"`

	// The timestamp when the alarm was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The number of data points that must not within the specified threshold to
	// trigger the alarm.
	DatapointsToAlarm *int64 `locationName:"datapointsToAlarm" type:"integer"`

	// The number of periods over which data is compared to the specified threshold.
	EvaluationPeriods *int64 `locationName:"evaluationPeriods" type:"integer"`

	// An object that lists information about the location of the alarm.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the metric associated with the alarm.
	MetricName *string `locationName:"metricName" type:"string" enum:"MetricName"`

	// An object that lists information about the resource monitored by the alarm.
	MonitoredResourceInfo *MonitoredResourceInfo `locationName:"monitoredResourceInfo" type:"structure"`

	// The name of the alarm.
	Name *string `locationName:"name" type:"string"`

	// Indicates whether the alarm is enabled.
	NotificationEnabled *bool `locationName:"notificationEnabled" type:"boolean"`

	// The alarm states that trigger a notification.
	NotificationTriggers []*string `locationName:"notificationTriggers" type:"list"`

	// The period, in seconds, over which the statistic is applied.
	Period *int64 `locationName:"period" min:"60" type:"integer"`

	// The Lightsail resource type (e.g., Alarm).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The current state of the alarm.
	//
	// An alarm has the following possible states:
	//
	//    * ALARM - The metric is outside of the defined threshold.
	//
	//    * INSUFFICIENT_DATA - The alarm has just started, the metric is not available,
	//    or not enough data is available for the metric to determine the alarm
	//    state.
	//
	//    * OK - The metric is within the defined threshold.
	State *string `locationName:"state" type:"string" enum:"AlarmState"`

	// The statistic for the metric associated with the alarm.
	//
	// The following statistics are available:
	//
	//    * Minimum - The lowest value observed during the specified period. Use
	//    this value to determine low volumes of activity for your application.
	//
	//    * Maximum - The highest value observed during the specified period. Use
	//    this value to determine high volumes of activity for your application.
	//
	//    * Sum - All values submitted for the matching metric added together. You
	//    can use this statistic to determine the total volume of a metric.
	//
	//    * Average - The value of Sum / SampleCount during the specified period.
	//    By comparing this statistic with the Minimum and Maximum values, you can
	//    determine the full scope of a metric and how close the average use is
	//    to the Minimum and Maximum values. This comparison helps you to know when
	//    to increase or decrease your resources.
	//
	//    * SampleCount - The count, or number, of data points used for the statistical
	//    calculation.
	Statistic *string `locationName:"statistic" type:"string" enum:"MetricStatistic"`

	// The support code. Include this code in your email to support when you have
	// questions about your Lightsail alarm. This code enables our support team
	// to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`

	// The value against which the specified statistic is compared.
	Threshold *float64 `locationName:"threshold" type:"double"`

	// Specifies how the alarm handles missing data points.
	//
	// An alarm can treat missing data in the following ways:
	//
	//    * breaching - Assume the missing data is not within the threshold. Missing
	//    data counts towards the number of times the metric is not within the threshold.
	//
	//    * notBreaching - Assume the missing data is within the threshold. Missing
	//    data does not count towards the number of times the metric is not within
	//    the threshold.
	//
	//    * ignore - Ignore the missing data. Maintains the current alarm state.
	//
	//    * missing - Missing data is treated as missing.
	TreatMissingData *string `locationName:"treatMissingData" type:"string" enum:"TreatMissingData"`

	// The unit of the metric associated with the alarm.
	Unit *string `locationName:"unit" type:"string" enum:"MetricUnit"`
}

// String returns the string representation
func (s Alarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Alarm) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Alarm) SetArn(v string) *Alarm {
	s.Arn = &v
	return s
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *Alarm) SetComparisonOperator(v string) *Alarm {
	s.ComparisonOperator = &v
	return s
}

// SetContactProtocols sets the ContactProtocols field's value.
func (s *Alarm) SetContactProtocols(v []*string) *Alarm {
	s.ContactProtocols = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Alarm) SetCreatedAt(v time.Time) *Alarm {
	s.CreatedAt = &v
	return s
}

// SetDatapointsToAlarm sets the DatapointsToAlarm field's value.
func (s *Alarm) SetDatapointsToAlarm(v int64) *Alarm {
	s.DatapointsToAlarm = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *Alarm) SetEvaluationPeriods(v int64) *Alarm {
	s.EvaluationPeriods = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Alarm) SetLocation(v *ResourceLocation) *Alarm {
	s.Location = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *Alarm) SetMetricName(v string) *Alarm {
	s.MetricName = &v
	return s
}

// SetMonitoredResourceInfo sets the MonitoredResourceInfo field's value.
func (s *Alarm) SetMonitoredResourceInfo(v *MonitoredResourceInfo) *Alarm {
	s.MonitoredResourceInfo = v
	return s
}

// SetName sets the Name field's value.
func (s *Alarm) SetName(v string) *Alarm {
	s.Name = &v
	return s
}

// SetNotificationEnabled sets the NotificationEnabled field's value.
func (s *Alarm) SetNotificationEnabled(v bool) *Alarm {
	s.NotificationEnabled = &v
	return s
}

// SetNotificationTriggers sets the NotificationTriggers field's value.
func (s *Alarm) SetNotificationTriggers(v []*string) *Alarm {
	s.NotificationTriggers = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *Alarm) SetPeriod(v int64) *Alarm {
	s.Period = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Alarm) SetResourceType(v string) *Alarm {
	s.ResourceType = &v
	return s
}

// SetState sets the State field's value.
func (s *Alarm) SetState(v string) *Alarm {
	s.State = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *Alarm) SetStatistic(v string) *Alarm {
	s.Statistic = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *Alarm) SetSupportCode(v string) *Alarm {
	s.SupportCode = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *Alarm) SetThreshold(v float64) *Alarm {
	s.Threshold = &v
	return s
}

// SetTreatMissingData sets the TreatMissingData field's value.
func (s *Alarm) SetTreatMissingData(v string) *Alarm {
	s.TreatMissingData = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Alarm) SetUnit(v string) *Alarm {
	s.Unit = &v
	return s
}

type AllocateStaticIpInput struct {
	_ struct{} `type:"structure"`

	// The name of the static IP address.
	//
	// StaticIpName is a required field
	StaticIpName *string `locationName:"staticIpName" type:"string" required:"true"`
}

// String returns the string representation
func (s AllocateStaticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateStaticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocateStaticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocateStaticIpInput"}
	if s.StaticIpName == nil {
		invalidParams.Add(request.NewErrParamRequired("StaticIpName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStaticIpName sets the StaticIpName field's value.
func (s *AllocateStaticIpInput) SetStaticIpName(v string) *AllocateStaticIpInput {
	s.StaticIpName = &v
	return s
}

type AllocateStaticIpOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s AllocateStaticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateStaticIpOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *AllocateStaticIpOutput) SetOperations(v []*Operation) *AllocateStaticIpOutput {
	s.Operations = v
	return s
}

type AttachCertificateToDistributionInput struct {
	_ struct{} `type:"structure"`

	// The name of the certificate to attach to a distribution.
	//
	// Only certificates with a status of ISSUED can be attached to a distribution.
	//
	// Use the GetCertificates action to get a list of certificate names that you
	// can specify.
	//
	// This is the name of the certificate resource type and is used only to reference
	// the certificate in other API actions. It can be different than the domain
	// name of the certificate. For example, your certificate name might be WordPress-Blog-Certificate
	// and the domain name of the certificate might be example.com.
	//
	// CertificateName is a required field
	CertificateName *string `locationName:"certificateName" type:"string" required:"true"`

	// The name of the distribution that the certificate will be attached to.
	//
	// Use the GetDistributions action to get a list of distribution names that
	// you can specify.
	//
	// DistributionName is a required field
	DistributionName *string `locationName:"distributionName" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachCertificateToDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachCertificateToDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachCertificateToDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachCertificateToDistributionInput"}
	if s.CertificateName == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateName"))
	}
	if s.DistributionName == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateName sets the CertificateName field's value.
func (s *AttachCertificateToDistributionInput) SetCertificateName(v string) *AttachCertificateToDistributionInput {
	s.CertificateName = &v
	return s
}

// SetDistributionName sets the DistributionName field's value.
func (s *AttachCertificateToDistributionInput) SetDistributionName(v string) *AttachCertificateToDistributionInput {
	s.DistributionName = &v
	return s
}

type AttachCertificateToDistributionOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the result of the action, such as the status of
	// the request, the timestamp of the request, and the resources affected by
	// the request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s AttachCertificateToDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachCertificateToDistributionOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *AttachCertificateToDistributionOutput) SetOperation(v *Operation) *AttachCertificateToDistributionOutput {
	s.Operation = v
	return s
}

type AttachDiskInput struct {
	_ struct{} `type:"structure"`

	// The unique Lightsail disk name (e.g., my-disk).
	//
	// DiskName is a required field
	DiskName *string `locationName:"diskName" type:"string" required:"true"`

	// The disk path to expose to the instance (e.g., /dev/xvdf).
	//
	// DiskPath is a required field
	DiskPath *string `locationName:"diskPath" type:"string" required:"true"`

	// The name of the Lightsail instance where you want to utilize the storage
	// disk.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachDiskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachDiskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachDiskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachDiskInput"}
	if s.DiskName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskName"))
	}
	if s.DiskPath == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskPath"))
	}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskName sets the DiskName field's value.
func (s *AttachDiskInput) SetDiskName(v string) *AttachDiskInput {
	s.DiskName = &v
	return s
}

// SetDiskPath sets the DiskPath field's value.
func (s *AttachDiskInput) SetDiskPath(v string) *AttachDiskInput {
	s.DiskPath = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *AttachDiskInput) SetInstanceName(v string) *AttachDiskInput {
	s.InstanceName = &v
	return s
}

type AttachDiskOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s AttachDiskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachDiskOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *AttachDiskOutput) SetOperations(v []*Operation) *AttachDiskOutput {
	s.Operations = v
	return s
}

type AttachInstancesToLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// An array of strings representing the instance name(s) you want to attach
	// to your load balancer.
	//
	// An instance must be running before you can attach it to your load balancer.
	//
	// There are no additional limits on the number of instances you can attach
	// to your load balancer, aside from the limit of Lightsail instances you can
	// create in your account (20).
	//
	// InstanceNames is a required field
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The name of the load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachInstancesToLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachInstancesToLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachInstancesToLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachInstancesToLoadBalancerInput"}
	if s.InstanceNames == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceNames"))
	}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceNames sets the InstanceNames field's value.
func (s *AttachInstancesToLoadBalancerInput) SetInstanceNames(v []*string) *AttachInstancesToLoadBalancerInput {
	s.InstanceNames = v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *AttachInstancesToLoadBalancerInput) SetLoadBalancerName(v string) *AttachInstancesToLoadBalancerInput {
	s.LoadBalancerName = &v
	return s
}

type AttachInstancesToLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s AttachInstancesToLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachInstancesToLoadBalancerOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *AttachInstancesToLoadBalancerOutput) SetOperations(v []*Operation) *AttachInstancesToLoadBalancerOutput {
	s.Operations = v
	return s
}

type AttachLoadBalancerTlsCertificateInput struct {
	_ struct{} `type:"structure"`

	// The name of your SSL/TLS certificate.
	//
	// CertificateName is a required field
	CertificateName *string `locationName:"certificateName" type:"string" required:"true"`

	// The name of the load balancer to which you want to associate the SSL/TLS
	// certificate.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachLoadBalancerTlsCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachLoadBalancerTlsCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachLoadBalancerTlsCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachLoadBalancerTlsCertificateInput"}
	if s.CertificateName == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateName"))
	}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateName sets the CertificateName field's value.
func (s *AttachLoadBalancerTlsCertificateInput) SetCertificateName(v string) *AttachLoadBalancerTlsCertificateInput {
	s.CertificateName = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *AttachLoadBalancerTlsCertificateInput) SetLoadBalancerName(v string) *AttachLoadBalancerTlsCertificateInput {
	s.LoadBalancerName = &v
	return s
}

type AttachLoadBalancerTlsCertificateOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	//
	// These SSL/TLS certificates are only usable by Lightsail load balancers. You
	// can't get the certificate and use it for another purpose.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s AttachLoadBalancerTlsCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachLoadBalancerTlsCertificateOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *AttachLoadBalancerTlsCertificateOutput) SetOperations(v []*Operation) *AttachLoadBalancerTlsCertificateOutput {
	s.Operations = v
	return s
}

type AttachStaticIpInput struct {
	_ struct{} `type:"structure"`

	// The instance name to which you want to attach the static IP address.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// The name of the static IP.
	//
	// StaticIpName is a required field
	StaticIpName *string `locationName:"staticIpName" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachStaticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachStaticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachStaticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachStaticIpInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.StaticIpName == nil {
		invalidParams.Add(request.NewErrParamRequired("StaticIpName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *AttachStaticIpInput) SetInstanceName(v string) *AttachStaticIpInput {
	s.InstanceName = &v
	return s
}

// SetStaticIpName sets the StaticIpName field's value.
func (s *AttachStaticIpInput) SetStaticIpName(v string) *AttachStaticIpInput {
	s.StaticIpName = &v
	return s
}

type AttachStaticIpOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s AttachStaticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachStaticIpOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *AttachStaticIpOutput) SetOperations(v []*Operation) *AttachStaticIpOutput {
	s.Operations = v
	return s
}

// Describes a block storage disk that is attached to an instance, and is included
// in an automatic snapshot.
type AttachedDisk struct {
	_ struct{} `type:"structure"`

	// The path of the disk (e.g., /dev/xvdf).
	Path *string `locationName:"path" type:"string"`

	// The size of the disk in GB.
	SizeInGb *int64 `locationName:"sizeInGb" type:"integer"`
}

// String returns the string representation
func (s AttachedDisk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachedDisk) GoString() string {
	return s.String()
}

// SetPath sets the Path field's value.
func (s *AttachedDisk) SetPath(v string) *AttachedDisk {
	s.Path = &v
	return s
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *AttachedDisk) SetSizeInGb(v int64) *AttachedDisk {
	s.SizeInGb = &v
	return s
}

// Describes a request to enable or modify the automatic snapshot add-on for
// an Amazon Lightsail instance or disk.
//
// When you modify the automatic snapshot time for a resource, it is typically
// effective immediately except under the following conditions:
//
//    * If an automatic snapshot has been created for the current day, and you
//    change the snapshot time to a later time of day, then the new snapshot
//    time will be effective the following day. This ensures that two snapshots
//    are not created for the current day.
//
//    * If an automatic snapshot has not yet been created for the current day,
//    and you change the snapshot time to an earlier time of day, then the new
//    snapshot time will be effective the following day and a snapshot is automatically
//    created at the previously set time for the current day. This ensures that
//    a snapshot is created for the current day.
//
//    * If an automatic snapshot has not yet been created for the current day,
//    and you change the snapshot time to a time that is within 30 minutes from
//    your current time, then the new snapshot time will be effective the following
//    day and a snapshot is automatically created at the previously set time
//    for the current day. This ensures that a snapshot is created for the current
//    day, because 30 minutes is required between your current time and the
//    new snapshot time that you specify.
//
//    * If an automatic snapshot is scheduled to be created within 30 minutes
//    from your current time and you change the snapshot time, then the new
//    snapshot time will be effective the following day and a snapshot is automatically
//    created at the previously set time for the current day. This ensures that
//    a snapshot is created for the current day, because 30 minutes is required
//    between your current time and the new snapshot time that you specify.
type AutoSnapshotAddOnRequest struct {
	_ struct{} `type:"structure"`

	// The daily time when an automatic snapshot will be created.
	//
	// Constraints:
	//
	//    * Must be in HH:00 format, and in an hourly increment.
	//
	//    * Specified in Coordinated Universal Time (UTC).
	//
	//    * The snapshot will be automatically created between the time specified
	//    and up to 45 minutes after.
	SnapshotTimeOfDay *string `locationName:"snapshotTimeOfDay" type:"string"`
}

// String returns the string representation
func (s AutoSnapshotAddOnRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoSnapshotAddOnRequest) GoString() string {
	return s.String()
}

// SetSnapshotTimeOfDay sets the SnapshotTimeOfDay field's value.
func (s *AutoSnapshotAddOnRequest) SetSnapshotTimeOfDay(v string) *AutoSnapshotAddOnRequest {
	s.SnapshotTimeOfDay = &v
	return s
}

// Describes an automatic snapshot.
type AutoSnapshotDetails struct {
	_ struct{} `type:"structure"`

	// The timestamp when the automatic snapshot was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The date of the automatic snapshot in YYYY-MM-DD format.
	Date *string `locationName:"date" type:"string"`

	// An array of objects that describe the block storage disks attached to the
	// instance when the automatic snapshot was created.
	FromAttachedDisks []*AttachedDisk `locationName:"fromAttachedDisks" type:"list"`

	// The status of the automatic snapshot.
	Status *string `locationName:"status" type:"string" enum:"AutoSnapshotStatus"`
}

// String returns the string representation
func (s AutoSnapshotDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoSnapshotDetails) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AutoSnapshotDetails) SetCreatedAt(v time.Time) *AutoSnapshotDetails {
	s.CreatedAt = &v
	return s
}

// SetDate sets the Date field's value.
func (s *AutoSnapshotDetails) SetDate(v string) *AutoSnapshotDetails {
	s.Date = &v
	return s
}

// SetFromAttachedDisks sets the FromAttachedDisks field's value.
func (s *AutoSnapshotDetails) SetFromAttachedDisks(v []*AttachedDisk) *AutoSnapshotDetails {
	s.FromAttachedDisks = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AutoSnapshotDetails) SetStatus(v string) *AutoSnapshotDetails {
	s.Status = &v
	return s
}

// Describes an Availability Zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The state of the Availability Zone.
	State *string `locationName:"state" type:"string"`

	// The name of the Availability Zone. The format is us-east-2a (case-sensitive).
	ZoneName *string `locationName:"zoneName" type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *AvailabilityZone) SetState(v string) *AvailabilityZone {
	s.State = &v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *AvailabilityZone) SetZoneName(v string) *AvailabilityZone {
	s.ZoneName = &v
	return s
}

// Describes a blueprint (a virtual private server image).
type Blueprint struct {
	_ struct{} `type:"structure"`

	// The ID for the virtual private server image (e.g., app_wordpress_4_4 or app_lamp_7_0).
	BlueprintId *string `locationName:"blueprintId" type:"string"`

	// The description of the blueprint.
	Description *string `locationName:"description" type:"string"`

	// The group name of the blueprint (e.g., amazon-linux).
	Group *string `locationName:"group" type:"string"`

	// A Boolean value indicating whether the blueprint is active. Inactive blueprints
	// are listed to support customers with existing instances but are not necessarily
	// available for launch of new instances. Blueprints are marked inactive when
	// they become outdated due to operating system updates or new application releases.
	IsActive *bool `locationName:"isActive" type:"boolean"`

	// The end-user license agreement URL for the image or blueprint.
	LicenseUrl *string `locationName:"licenseUrl" type:"string"`

	// The minimum bundle power required to run this blueprint. For example, you
	// need a bundle with a power value of 500 or more to create an instance that
	// uses a blueprint with a minimum power value of 500. 0 indicates that the
	// blueprint runs on all instance sizes.
	MinPower *int64 `locationName:"minPower" type:"integer"`

	// The friendly name of the blueprint (e.g., Amazon Linux).
	Name *string `locationName:"name" type:"string"`

	// The operating system platform (either Linux/Unix-based or Windows Server-based)
	// of the blueprint.
	Platform *string `locationName:"platform" type:"string" enum:"InstancePlatform"`

	// The product URL to learn more about the image or blueprint.
	ProductUrl *string `locationName:"productUrl" type:"string"`

	// The type of the blueprint (e.g., os or app).
	Type *string `locationName:"type" type:"string" enum:"BlueprintType"`

	// The version number of the operating system, application, or stack (e.g.,
	// 2016.03.0).
	Version *string `locationName:"version" type:"string"`

	// The version code.
	VersionCode *string `locationName:"versionCode" type:"string"`
}

// String returns the string representation
func (s Blueprint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Blueprint) GoString() string {
	return s.String()
}

// SetBlueprintId sets the BlueprintId field's value.
func (s *Blueprint) SetBlueprintId(v string) *Blueprint {
	s.BlueprintId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Blueprint) SetDescription(v string) *Blueprint {
	s.Description = &v
	return s
}

// SetGroup sets the Group field's value.
func (s *Blueprint) SetGroup(v string) *Blueprint {
	s.Group = &v
	return s
}

// SetIsActive sets the IsActive field's value.
func (s *Blueprint) SetIsActive(v bool) *Blueprint {
	s.IsActive = &v
	return s
}

// SetLicenseUrl sets the LicenseUrl field's value.
func (s *Blueprint) SetLicenseUrl(v string) *Blueprint {
	s.LicenseUrl = &v
	return s
}

// SetMinPower sets the MinPower field's value.
func (s *Blueprint) SetMinPower(v int64) *Blueprint {
	s.MinPower = &v
	return s
}

// SetName sets the Name field's value.
func (s *Blueprint) SetName(v string) *Blueprint {
	s.Name = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Blueprint) SetPlatform(v string) *Blueprint {
	s.Platform = &v
	return s
}

// SetProductUrl sets the ProductUrl field's value.
func (s *Blueprint) SetProductUrl(v string) *Blueprint {
	s.ProductUrl = &v
	return s
}

// SetType sets the Type field's value.
func (s *Blueprint) SetType(v string) *Blueprint {
	s.Type = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Blueprint) SetVersion(v string) *Blueprint {
	s.Version = &v
	return s
}

// SetVersionCode sets the VersionCode field's value.
func (s *Blueprint) SetVersionCode(v string) *Blueprint {
	s.VersionCode = &v
	return s
}

// Describes an Amazon Lightsail bucket.
type Bucket struct {
	_ struct{} `type:"structure"`

	// Indicates whether the bundle that is currently applied to a bucket can be
	// changed to another bundle.
	//
	// You can update a bucket's bundle only one time within a monthly AWS billing
	// cycle.
	//
	// Use the UpdateBucketBundle action to change a bucket's bundle.
	AbleToUpdateBundle *bool `locationName:"ableToUpdateBundle" type:"boolean"`

	// An object that describes the access rules of the bucket.
	AccessRules *AccessRules `locationName:"accessRules" type:"structure"`

	// The Amazon Resource Name (ARN) of the bucket.
	Arn *string `locationName:"arn" type:"string"`

	// The ID of the bundle currently applied to the bucket.
	//
	// A bucket bundle specifies the monthly cost, storage space, and data transfer
	// quota for a bucket.
	//
	// Use the UpdateBucketBundle action to change the bundle of a bucket.
	BundleId *string `locationName:"bundleId" type:"string"`

	// The timestamp when the distribution was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Describes the resource location.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the bucket.
	Name *string `locationName:"name" min:"3" type:"string"`

	// Indicates whether object versioning is enabled for the bucket.
	//
	// The following options can be configured:
	//
	//    * Enabled - Object versioning is enabled.
	//
	//    * Suspended - Object versioning was previously enabled but is currently
	//    suspended. Existing object versions are retained.
	//
	//    * NeverEnabled - Object versioning has never been enabled.
	ObjectVersioning *string `locationName:"objectVersioning" type:"string"`

	// An array of strings that specify the AWS account IDs that have read-only
	// access to the bucket.
	ReadonlyAccessAccounts []*string `locationName:"readonlyAccessAccounts" type:"list"`

	// The Lightsail resource type of the bucket (for example, Bucket).
	ResourceType *string `locationName:"resourceType" type:"string"`

	// An array of objects that describe Lightsail instances that have access to
	// the bucket.
	//
	// Use the SetResourceAccessForBucket action to update the instances that have
	// access to a bucket.
	ResourcesReceivingAccess []*ResourceReceivingAccess `locationName:"resourcesReceivingAccess" type:"list"`

	// An object that describes the state of the bucket.
	State *BucketState `locationName:"state" type:"structure"`

	// The support code for a bucket. Include this code in your email to support
	// when you have questions about a Lightsail bucket. This code enables our support
	// team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`

	// The tag keys and optional values for the bucket. For more information, see
	// Tags in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags)
	// in the Amazon Lightsail Developer Guide.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The URL of the bucket.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s Bucket) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Bucket) GoString() string {
	return s.String()
}

// SetAbleToUpdateBundle sets the AbleToUpdateBundle field's value.
func (s *Bucket) SetAbleToUpdateBundle(v bool) *Bucket {
	s.AbleToUpdateBundle = &v
	return s
}

// SetAccessRules sets the AccessRules field's value.
func (s *Bucket) SetAccessRules(v *AccessRules) *Bucket {
	s.AccessRules = v
	return s
}

// SetArn sets the Arn field's value.
func (s *Bucket) SetArn(v string) *Bucket {
	s.Arn = &v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *Bucket) SetBundleId(v string) *Bucket {
	s.BundleId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Bucket) SetCreatedAt(v time.Time) *Bucket {
	s.CreatedAt = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Bucket) SetLocation(v *ResourceLocation) *Bucket {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *Bucket) SetName(v string) *Bucket {
	s.Name = &v
	return s
}

// SetObjectVersioning sets the ObjectVersioning field's value.
func (s *Bucket) SetObjectVersioning(v string) *Bucket {
	s.ObjectVersioning = &v
	return s
}

// SetReadonlyAccessAccounts sets the ReadonlyAccessAccounts field's value.
func (s *Bucket) SetReadonlyAccessAccounts(v []*string) *Bucket {
	s.ReadonlyAccessAccounts = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Bucket) SetResourceType(v string) *Bucket {
	s.ResourceType = &v
	return s
}

// SetResourcesReceivingAccess sets the ResourcesReceivingAccess field's value.
func (s *Bucket) SetResourcesReceivingAccess(v []*ResourceReceivingAccess) *Bucket {
	s.ResourcesReceivingAccess = v
	return s
}

// SetState sets the State field's value.
func (s *Bucket) SetState(v *BucketState) *Bucket {
	s.State = v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *Bucket) SetSupportCode(v string) *Bucket {
	s.SupportCode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Bucket) SetTags(v []*Tag) *Bucket {
	s.Tags = v
	return s
}

// SetUrl sets the Url field's value.
func (s *Bucket) SetUrl(v string) *Bucket {
	s.Url = &v
	return s
}

// Describes the specifications of a bundle that can be applied to an Amazon
// Lightsail bucket.
//
// A bucket bundle specifies the monthly cost, storage space, and data transfer
// quota for a bucket.
type BucketBundle struct {
	_ struct{} `type:"structure"`

	// The ID of the bundle.
	BundleId *string `locationName:"bundleId" type:"string"`

	// Indicates whether the bundle is active. Use for a new or existing bucket.
	IsActive *bool `locationName:"isActive" type:"boolean"`

	// The name of the bundle.
	Name *string `locationName:"name" type:"string"`

	// The monthly price of the bundle, in US dollars.
	Price *float64 `locationName:"price" type:"float"`

	// The storage size of the bundle, in GB.
	StoragePerMonthInGb *int64 `locationName:"storagePerMonthInGb" type:"integer"`

	// The monthly network transfer quota of the bundle.
	TransferPerMonthInGb *int64 `locationName:"transferPerMonthInGb" type:"integer"`
}

// String returns the string representation
func (s BucketBundle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketBundle) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *BucketBundle) SetBundleId(v string) *BucketBundle {
	s.BundleId = &v
	return s
}

// SetIsActive sets the IsActive field's value.
func (s *BucketBundle) SetIsActive(v bool) *BucketBundle {
	s.IsActive = &v
	return s
}

// SetName sets the Name field's value.
func (s *BucketBundle) SetName(v string) *BucketBundle {
	s.Name = &v
	return s
}

// SetPrice sets the Price field's value.
func (s *BucketBundle) SetPrice(v float64) *BucketBundle {
	s.Price = &v
	return s
}

// SetStoragePerMonthInGb sets the StoragePerMonthInGb field's value.
func (s *BucketBundle) SetStoragePerMonthInGb(v int64) *BucketBundle {
	s.StoragePerMonthInGb = &v
	return s
}

// SetTransferPerMonthInGb sets the TransferPerMonthInGb field's value.
func (s *BucketBundle) SetTransferPerMonthInGb(v int64) *BucketBundle {
	s.TransferPerMonthInGb = &v
	return s
}

// Describes the state of an Amazon Lightsail bucket.
type BucketState struct {
	_ struct{} `type:"structure"`

	// The state code of the bucket.
	//
	// The following codes are possible:
	//
	//    * OK - The bucket is in a running state.
	//
	//    * Unknown - Creation of the bucket might have timed-out. You might want
	//    to delete the bucket and create a new one.
	Code *string `locationName:"code" type:"string"`

	// A message that describes the state of the bucket.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BucketState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketState) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *BucketState) SetCode(v string) *BucketState {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BucketState) SetMessage(v string) *BucketState {
	s.Message = &v
	return s
}

// Describes a bundle, which is a set of specs describing your virtual private
// server (or instance).
type Bundle struct {
	_ struct{} `type:"structure"`

	// The bundle ID (e.g., micro_1_0).
	BundleId *string `locationName:"bundleId" type:"string"`

	// The number of vCPUs included in the bundle (e.g., 2).
	CpuCount *int64 `locationName:"cpuCount" type:"integer"`

	// The size of the SSD (e.g., 30).
	DiskSizeInGb *int64 `locationName:"diskSizeInGb" type:"integer"`

	// The Amazon EC2 instance type (e.g., t2.micro).
	InstanceType *string `locationName:"instanceType" type:"string"`

	// A Boolean value indicating whether the bundle is active.
	IsActive *bool `locationName:"isActive" type:"boolean"`

	// A friendly name for the bundle (e.g., Micro).
	Name *string `locationName:"name" type:"string"`

	// A numeric value that represents the power of the bundle (e.g., 500). You
	// can use the bundle's power value in conjunction with a blueprint's minimum
	// power value to determine whether the blueprint will run on the bundle. For
	// example, you need a bundle with a power value of 500 or more to create an
	// instance that uses a blueprint with a minimum power value of 500.
	Power *int64 `locationName:"power" type:"integer"`

	// The price in US dollars (e.g., 5.0) of the bundle.
	Price *float64 `locationName:"price" type:"float"`

	// The amount of RAM in GB (e.g., 2.0).
	RamSizeInGb *float64 `locationName:"ramSizeInGb" type:"float"`

	// The operating system platform (Linux/Unix-based or Windows Server-based)
	// that the bundle supports. You can only launch a WINDOWS bundle on a blueprint
	// that supports the WINDOWS platform. LINUX_UNIX blueprints require a LINUX_UNIX
	// bundle.
	SupportedPlatforms []*string `locationName:"supportedPlatforms" type:"list"`

	// The data transfer rate per month in GB (e.g., 2000).
	TransferPerMonthInGb *int64 `locationName:"transferPerMonthInGb" type:"integer"`
}

// String returns the string representation
func (s Bundle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Bundle) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *Bundle) SetBundleId(v string) *Bundle {
	s.BundleId = &v
	return s
}

// SetCpuCount sets the CpuCount field's value.
func (s *Bundle) SetCpuCount(v int64) *Bundle {
	s.CpuCount = &v
	return s
}

// SetDiskSizeInGb sets the DiskSizeInGb field's value.
func (s *Bundle) SetDiskSizeInGb(v int64) *Bundle {
	s.DiskSizeInGb = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *Bundle) SetInstanceType(v string) *Bundle {
	s.InstanceType = &v
	return s
}

// SetIsActive sets the IsActive field's value.
func (s *Bundle) SetIsActive(v bool) *Bundle {
	s.IsActive = &v
	return s
}

// SetName sets the Name field's value.
func (s *Bundle) SetName(v string) *Bundle {
	s.Name = &v
	return s
}

// SetPower sets the Power field's value.
func (s *Bundle) SetPower(v int64) *Bundle {
	s.Power = &v
	return s
}

// SetPrice sets the Price field's value.
func (s *Bundle) SetPrice(v float64) *Bundle {
	s.Price = &v
	return s
}

// SetRamSizeInGb sets the RamSizeInGb field's value.
func (s *Bundle) SetRamSizeInGb(v float64) *Bundle {
	s.RamSizeInGb = &v
	return s
}

// SetSupportedPlatforms sets the SupportedPlatforms field's value.
func (s *Bundle) SetSupportedPlatforms(v []*string) *Bundle {
	s.SupportedPlatforms = v
	return s
}

// SetTransferPerMonthInGb sets the TransferPerMonthInGb field's value.
func (s *Bundle) SetTransferPerMonthInGb(v int64) *Bundle {
	s.TransferPerMonthInGb = &v
	return s
}

// Describes the default cache behavior of an Amazon Lightsail content delivery
// network (CDN) distribution.
type CacheBehavior struct {
	_ struct{} `type:"structure"`

	// The cache behavior of the distribution.
	//
	// The following cache behaviors can be specified:
	//
	//    * cache - This option is best for static sites. When specified, your distribution
	//    caches and serves your entire website as static content. This behavior
	//    is ideal for websites with static content that doesn't change depending
	//    on who views it, or for websites that don't use cookies, headers, or query
	//    strings to personalize content.
	//
	//    * dont-cache - This option is best for sites that serve a mix of static
	//    and dynamic content. When specified, your distribution caches and serve
	//    only the content that is specified in the distribution's CacheBehaviorPerPath
	//    parameter. This behavior is ideal for websites or web applications that
	//    use cookies, headers, and query strings to personalize content for individual
	//    users.
	Behavior *string `locationName:"behavior" type:"string" enum:"BehaviorEnum"`
}

// String returns the string representation
func (s CacheBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheBehavior) GoString() string {
	return s.String()
}

// SetBehavior sets the Behavior field's value.
func (s *CacheBehavior) SetBehavior(v string) *CacheBehavior {
	s.Behavior = &v
	return s
}

// Describes the per-path cache behavior of an Amazon Lightsail content delivery
// network (CDN) distribution.
//
// A per-path cache behavior is used to override, or add an exception to, the
// default cache behavior of a distribution. For example, if the cacheBehavior
// is set to cache, then a per-path cache behavior can be used to specify a
// directory, file, or file type that your distribution will cache. Alternately,
// if the distribution's cacheBehavior is dont-cache, then a per-path cache
// behavior can be used to specify a directory, file, or file type that your
// distribution will not cache.
//
// if the cacheBehavior's behavior is set to 'cache', then
type CacheBehaviorPerPath struct {
	_ struct{} `type:"structure"`

	// The cache behavior for the specified path.
	//
	// You can specify one of the following per-path cache behaviors:
	//
	//    * cache - This behavior caches the specified path.
	//
	//    * dont-cache - This behavior doesn't cache the specified path.
	Behavior *string `locationName:"behavior" type:"string" enum:"BehaviorEnum"`

	// The path to a directory or file to cached, or not cache. Use an asterisk
	// symbol to specify wildcard directories (path/to/assets/*), and file types
	// (*.html, *jpg, *js). Directories and file paths are case-sensitive.
	//
	// Examples:
	//
	//    * Specify the following to cache all files in the document root of an
	//    Apache web server running on a Lightsail instance. var/www/html/
	//
	//    * Specify the following file to cache only the index page in the document
	//    root of an Apache web server. var/www/html/index.html
	//
	//    * Specify the following to cache only the .html files in the document
	//    root of an Apache web server. var/www/html/*.html
	//
	//    * Specify the following to cache only the .jpg, .png, and .gif files in
	//    the images sub-directory of the document root of an Apache web server.
	//    var/www/html/images/*.jpg var/www/html/images/*.png var/www/html/images/*.gif
	//    Specify the following to cache all files in the images sub-directory of
	//    the document root of an Apache web server. var/www/html/images/
	Path *string `locationName:"path" type:"string"`
}

// String returns the string representation
func (s CacheBehaviorPerPath) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheBehaviorPerPath) GoString() string {
	return s.String()
}

// SetBehavior sets the Behavior field's value.
func (s *CacheBehaviorPerPath) SetBehavior(v string) *CacheBehaviorPerPath {
	s.Behavior = &v
	return s
}

// SetPath sets the Path field's value.
func (s *CacheBehaviorPerPath) SetPath(v string) *CacheBehaviorPerPath {
	s.Path = &v
	return s
}

// Describes the cache settings of an Amazon Lightsail content delivery network
// (CDN) distribution.
//
// These settings apply only to your distribution's cacheBehaviors (including
// the defaultCacheBehavior) that have a behavior of cache.
type CacheSettings struct {
	_ struct{} `type:"structure"`

	// The HTTP methods that are processed and forwarded to the distribution's origin.
	//
	// You can specify the following options:
	//
	//    * GET,HEAD - The distribution forwards the GET and HEAD methods.
	//
	//    * GET,HEAD,OPTIONS - The distribution forwards the GET, HEAD, and OPTIONS
	//    methods.
	//
	//    * GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE - The distribution forwards the
	//    GET, HEAD, OPTIONS, PUT, PATCH, POST, and DELETE methods.
	//
	// If you specify the third option, you might need to restrict access to your
	// distribution's origin so users can't perform operations that you don't want
	// them to. For example, you might not want users to have permission to delete
	// objects from your origin.
	AllowedHTTPMethods *string `locationName:"allowedHTTPMethods" type:"string"`

	// The HTTP method responses that are cached by your distribution.
	//
	// You can specify the following options:
	//
	//    * GET,HEAD - The distribution caches responses to the GET and HEAD methods.
	//
	//    * GET,HEAD,OPTIONS - The distribution caches responses to the GET, HEAD,
	//    and OPTIONS methods.
	CachedHTTPMethods *string `locationName:"cachedHTTPMethods" type:"string"`

	// The default amount of time that objects stay in the distribution's cache
	// before the distribution forwards another request to the origin to determine
	// whether the content has been updated.
	//
	// The value specified applies only when the origin does not add HTTP headers
	// such as Cache-Control max-age, Cache-Control s-maxage, and Expires to objects.
	DefaultTTL *int64 `locationName:"defaultTTL" type:"long"`

	// An object that describes the cookies that are forwarded to the origin. Your
	// content is cached based on the cookies that are forwarded.
	ForwardedCookies *CookieObject `locationName:"forwardedCookies" type:"structure"`

	// An object that describes the headers that are forwarded to the origin. Your
	// content is cached based on the headers that are forwarded.
	ForwardedHeaders *HeaderObject `locationName:"forwardedHeaders" type:"structure"`

	// An object that describes the query strings that are forwarded to the origin.
	// Your content is cached based on the query strings that are forwarded.
	ForwardedQueryStrings *QueryStringObject `locationName:"forwardedQueryStrings" type:"structure"`

	// The maximum amount of time that objects stay in the distribution's cache
	// before the distribution forwards another request to the origin to determine
	// whether the object has been updated.
	//
	// The value specified applies only when the origin adds HTTP headers such as
	// Cache-Control max-age, Cache-Control s-maxage, and Expires to objects.
	MaximumTTL *int64 `locationName:"maximumTTL" type:"long"`

	// The minimum amount of time that objects stay in the distribution's cache
	// before the distribution forwards another request to the origin to determine
	// whether the object has been updated.
	//
	// A value of 0 must be specified for minimumTTL if the distribution is configured
	// to forward all headers to the origin.
	MinimumTTL *int64 `locationName:"minimumTTL" type:"long"`
}

// String returns the string representation
func (s CacheSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheSettings) GoString() string {
	return s.String()
}

// SetAllowedHTTPMethods sets the AllowedHTTPMethods field's value.
func (s *CacheSettings) SetAllowedHTTPMethods(v string) *CacheSettings {
	s.AllowedHTTPMethods = &v
	return s
}

// SetCachedHTTPMethods sets the CachedHTTPMethods field's value.
func (s *CacheSettings) SetCachedHTTPMethods(v string) *CacheSettings {
	s.CachedHTTPMethods = &v
	return s
}

// SetDefaultTTL sets the DefaultTTL field's value.
func (s *CacheSettings) SetDefaultTTL(v int64) *CacheSettings {
	s.DefaultTTL = &v
	return s
}

// SetForwardedCookies sets the ForwardedCookies field's value.
func (s *CacheSettings) SetForwardedCookies(v *CookieObject) *CacheSettings {
	s.ForwardedCookies = v
	return s
}

// SetForwardedHeaders sets the ForwardedHeaders field's value.
func (s *CacheSettings) SetForwardedHeaders(v *HeaderObject) *CacheSettings {
	s.ForwardedHeaders = v
	return s
}

// SetForwardedQueryStrings sets the ForwardedQueryStrings field's value.
func (s *CacheSettings) SetForwardedQueryStrings(v *QueryStringObject) *CacheSettings {
	s.ForwardedQueryStrings = v
	return s
}

// SetMaximumTTL sets the MaximumTTL field's value.
func (s *CacheSettings) SetMaximumTTL(v int64) *CacheSettings {
	s.MaximumTTL = &v
	return s
}

// SetMinimumTTL sets the MinimumTTL field's value.
func (s *CacheSettings) SetMinimumTTL(v int64) *CacheSettings {
	s.MinimumTTL = &v
	return s
}

// Describes the full details of an Amazon Lightsail SSL/TLS certificate.
//
// To get a summary of a certificate, use the GetCertificates action and ommit
// includeCertificateDetails from your request. The response will include only
// the certificate Amazon Resource Name (ARN), certificate name, domain name,
// and tags.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate.
	Arn *string `locationName:"arn" type:"string"`

	// The timestamp when the certificate was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The domain name of the certificate.
	DomainName *string `locationName:"domainName" type:"string"`

	// An array of objects that describe the domain validation records of the certificate.
	DomainValidationRecords []*DomainValidationRecord `locationName:"domainValidationRecords" type:"list"`

	// The renewal eligibility of the certificate.
	EligibleToRenew *string `locationName:"eligibleToRenew" type:"string"`

	// The number of Lightsail resources that the certificate is attached to.
	InUseResourceCount *int64 `locationName:"inUseResourceCount" type:"integer"`

	// The timestamp when the certificate was issued.
	IssuedAt *time.Time `locationName:"issuedAt" type:"timestamp"`

	// The certificate authority that issued the certificate.
	IssuerCA *string `locationName:"issuerCA" type:"string"`

	// The algorithm used to generate the key pair (the public and private key)
	// of the certificate.
	KeyAlgorithm *string `locationName:"keyAlgorithm" type:"string"`

	// The name of the certificate (e.g., my-certificate).
	Name *string `locationName:"name" type:"string"`

	// The timestamp when the certificate expires.
	NotAfter *time.Time `locationName:"notAfter" type:"timestamp"`

	// The timestamp when the certificate is first valid.
	NotBefore *time.Time `locationName:"notBefore" type:"timestamp"`

	// An object that describes the status of the certificate renewal managed by
	// Lightsail.
	RenewalSummary *RenewalSummary `locationName:"renewalSummary" type:"structure"`

	// The validation failure reason, if any, of the certificate.
	//
	// The following failure reasons are possible:
	//
	//    * NO_AVAILABLE_CONTACTS - This failure applies to email validation, which
	//    is not available for Lightsail certificates.
	//
	//    * ADDITIONAL_VERIFICATION_REQUIRED - Lightsail requires additional information
	//    to process this certificate request. This can happen as a fraud-protection
	//    measure, such as when the domain ranks within the Alexa top 1000 websites.
	//    To provide the required information, use the AWS Support Center (https://console.aws.amazon.com/support/home)
	//    to contact AWS Support. You cannot request a certificate for Amazon-owned
	//    domain names such as those ending in amazonaws.com, cloudfront.net, or
	//    elasticbeanstalk.com.
	//
	//    * DOMAIN_NOT_ALLOWED - One or more of the domain names in the certificate
	//    request was reported as an unsafe domain by VirusTotal (https://www.virustotal.com/gui/home/url).
	//    To correct the problem, search for your domain name on the VirusTotal
	//    (https://www.virustotal.com/gui/home/url) website. If your domain is reported
	//    as suspicious, see Google Help for Hacked Websites (https://developers.google.com/web/fundamentals/security/hacked)
	//    to learn what you can do. If you believe that the result is a false positive,
	//    notify the organization that is reporting the domain. VirusTotal is an
	//    aggregate of several antivirus and URL scanners and cannot remove your
	//    domain from a block list itself. After you correct the problem and the
	//    VirusTotal registry has been updated, request a new certificate. If you
	//    see this error and your domain is not included in the VirusTotal list,
	//    visit the AWS Support Center (https://console.aws.amazon.com/support/home)
	//    and create a case.
	//
	//    * INVALID_PUBLIC_DOMAIN - One or more of the domain names in the certificate
	//    request is not valid. Typically, this is because a domain name in the
	//    request is not a valid top-level domain. Try to request a certificate
	//    again, correcting any spelling errors or typos that were in the failed
	//    request, and ensure that all domain names in the request are for valid
	//    top-level domains. For example, you cannot request a certificate for example.invalidpublicdomain
	//    because invalidpublicdomain is not a valid top-level domain.
	//
	//    * OTHER - Typically, this failure occurs when there is a typographical
	//    error in one or more of the domain names in the certificate request. Try
	//    to request a certificate again, correcting any spelling errors or typos
	//    that were in the failed request.
	RequestFailureReason *string `locationName:"requestFailureReason" type:"string"`

	// The reason the certificate was revoked. This value is present only when the
	// certificate status is REVOKED.
	RevocationReason *string `locationName:"revocationReason" type:"string"`

	// The timestamp when the certificate was revoked. This value is present only
	// when the certificate status is REVOKED.
	RevokedAt *time.Time `locationName:"revokedAt" type:"timestamp"`

	// The serial number of the certificate.
	SerialNumber *string `locationName:"serialNumber" type:"string"`

	// The validation status of the certificate.
	Status *string `locationName:"status" type:"string" enum:"CertificateStatus"`

	// An array of strings that specify the alternate domains (e.g., example2.com)
	// and subdomains (e.g., blog.example.com) of the certificate.
	SubjectAlternativeNames []*string `locationName:"subjectAlternativeNames" type:"list"`

	// The support code. Include this code in your email to support when you have
	// questions about your Lightsail certificate. This code enables our support
	// team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Certificate) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Certificate) SetArn(v string) *Certificate {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Certificate) SetCreatedAt(v time.Time) *Certificate {
	s.CreatedAt = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *Certificate) SetDomainName(v string) *Certificate {
	s.DomainName = &v
	return s
}

// SetDomainValidationRecords sets the DomainValidationRecords field's value.
func (s *Certificate) SetDomainValidationRecords(v []*DomainValidationRecord) *Certificate {
	s.DomainValidationRecords = v
	return s
}

// SetEligibleToRenew sets the EligibleToRenew field's value.
func (s *Certificate) SetEligibleToRenew(v string) *Certificate {
	s.EligibleToRenew = &v
	return s
}

// SetInUseResourceCount sets the InUseResourceCount field's value.
func (s *Certificate) SetInUseResourceCount(v int64) *Certificate {
	s.InUseResourceCount = &v
	return s
}

// SetIssuedAt sets the IssuedAt field's value.
func (s *Certificate) SetIssuedAt(v time.Time) *Certificate {
	s.IssuedAt = &v
	return s
}

// SetIssuerCA sets the IssuerCA field's value.
func (s *Certificate) SetIssuerCA(v string) *Certificate {
	s.IssuerCA = &v
	return s
}

// SetKeyAlgorithm sets the KeyAlgorithm field's value.
func (s *Certificate) SetKeyAlgorithm(v string) *Certificate {
	s.KeyAlgorithm = &v
	return s
}

// SetName sets the Name field's value.
func (s *Certificate) SetName(v string) *Certificate {
	s.Name = &v
	return s
}

// SetNotAfter sets the NotAfter field's value.
func (s *Certificate) SetNotAfter(v time.Time) *Certificate {
	s.NotAfter = &v
	return s
}

// SetNotBefore sets the NotBefore field's value.
func (s *Certificate) SetNotBefore(v time.Time) *Certificate {
	s.NotBefore = &v
	return s
}

// SetRenewalSummary sets the RenewalSummary field's value.
func (s *Certificate) SetRenewalSummary(v *RenewalSummary) *Certificate {
	s.RenewalSummary = v
	return s
}

// SetRequestFailureReason sets the RequestFailureReason field's value.
func (s *Certificate) SetRequestFailureReason(v string) *Certificate {
	s.RequestFailureReason = &v
	return s
}

// SetRevocationReason sets the RevocationReason field's value.
func (s *Certificate) SetRevocationReason(v string) *Certificate {
	s.RevocationReason = &v
	return s
}

// SetRevokedAt sets the RevokedAt field's value.
func (s *Certificate) SetRevokedAt(v time.Time) *Certificate {
	s.RevokedAt = &v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *Certificate) SetSerialNumber(v string) *Certificate {
	s.SerialNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Certificate) SetStatus(v string) *Certificate {
	s.Status = &v
	return s
}

// SetSubjectAlternativeNames sets the SubjectAlternativeNames field's value.
func (s *Certificate) SetSubjectAlternativeNames(v []*string) *Certificate {
	s.SubjectAlternativeNames = v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *Certificate) SetSupportCode(v string) *Certificate {
	s.SupportCode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Certificate) SetTags(v []*Tag) *Certificate {
	s.Tags = v
	return s
}

// Describes an Amazon Lightsail SSL/TLS certificate.
type CertificateSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// An object that describes a certificate in detail.
	CertificateDetail *Certificate `locationName:"certificateDetail" type:"structure"`

	// The name of the certificate.
	CertificateName *string `locationName:"certificateName" type:"string"`

	// The domain name of the certificate.
	DomainName *string `locationName:"domainName" type:"string"`

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CertificateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateSummary) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CertificateSummary) SetCertificateArn(v string) *CertificateSummary {
	s.CertificateArn = &v
	return s
}

// SetCertificateDetail sets the CertificateDetail field's value.
func (s *CertificateSummary) SetCertificateDetail(v *Certificate) *CertificateSummary {
	s.CertificateDetail = v
	return s
}

// SetCertificateName sets the CertificateName field's value.
func (s *CertificateSummary) SetCertificateName(v string) *CertificateSummary {
	s.CertificateName = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CertificateSummary) SetDomainName(v string) *CertificateSummary {
	s.DomainName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CertificateSummary) SetTags(v []*Tag) *CertificateSummary {
	s.Tags = v
	return s
}

type CloseInstancePublicPortsInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance for which to close ports.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// An object to describe the ports to close for the specified instance.
	//
	// PortInfo is a required field
	PortInfo *PortInfo `locationName:"portInfo" type:"structure" required:"true"`
}

// String returns the string representation
func (s CloseInstancePublicPortsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloseInstancePublicPortsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloseInstancePublicPortsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloseInstancePublicPortsInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.PortInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("PortInfo"))
	}
	if s.PortInfo != nil {
		if err := s.PortInfo.Validate(); err != nil {
			invalidParams.AddNested("PortInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *CloseInstancePublicPortsInput) SetInstanceName(v string) *CloseInstancePublicPortsInput {
	s.InstanceName = &v
	return s
}

// SetPortInfo sets the PortInfo field's value.
func (s *CloseInstancePublicPortsInput) SetPortInfo(v *PortInfo) *CloseInstancePublicPortsInput {
	s.PortInfo = v
	return s
}

type CloseInstancePublicPortsOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the result of the action, such as the status of
	// the request, the timestamp of the request, and the resources affected by
	// the request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s CloseInstancePublicPortsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloseInstancePublicPortsOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *CloseInstancePublicPortsOutput) SetOperation(v *Operation) *CloseInstancePublicPortsOutput {
	s.Operation = v
	return s
}

// Describes a CloudFormation stack record created as a result of the create
// cloud formation stack action.
//
// A CloudFormation stack record provides information about the AWS CloudFormation
// stack used to create a new Amazon Elastic Compute Cloud instance from an
// exported Lightsail instance snapshot.
type CloudFormationStackRecord struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CloudFormation stack record.
	Arn *string `locationName:"arn" type:"string"`

	// The date when the CloudFormation stack record was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// A list of objects describing the destination service, which is AWS CloudFormation,
	// and the Amazon Resource Name (ARN) of the AWS CloudFormation stack.
	DestinationInfo *DestinationInfo `locationName:"destinationInfo" type:"structure"`

	// A list of objects describing the Availability Zone and AWS Region of the
	// CloudFormation stack record.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the CloudFormation stack record. It starts with CloudFormationStackRecord
	// followed by a GUID.
	Name *string `locationName:"name" type:"string"`

	// The Lightsail resource type (e.g., CloudFormationStackRecord).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// A list of objects describing the source of the CloudFormation stack record.
	SourceInfo []*CloudFormationStackRecordSourceInfo `locationName:"sourceInfo" type:"list"`

	// The current state of the CloudFormation stack record.
	State *string `locationName:"state" type:"string" enum:"RecordState"`
}

// String returns the string representation
func (s CloudFormationStackRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudFormationStackRecord) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CloudFormationStackRecord) SetArn(v string) *CloudFormationStackRecord {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CloudFormationStackRecord) SetCreatedAt(v time.Time) *CloudFormationStackRecord {
	s.CreatedAt = &v
	return s
}

// SetDestinationInfo sets the DestinationInfo field's value.
func (s *CloudFormationStackRecord) SetDestinationInfo(v *DestinationInfo) *CloudFormationStackRecord {
	s.DestinationInfo = v
	return s
}

// SetLocation sets the Location field's value.
func (s *CloudFormationStackRecord) SetLocation(v *ResourceLocation) *CloudFormationStackRecord {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *CloudFormationStackRecord) SetName(v string) *CloudFormationStackRecord {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *CloudFormationStackRecord) SetResourceType(v string) *CloudFormationStackRecord {
	s.ResourceType = &v
	return s
}

// SetSourceInfo sets the SourceInfo field's value.
func (s *CloudFormationStackRecord) SetSourceInfo(v []*CloudFormationStackRecordSourceInfo) *CloudFormationStackRecord {
	s.SourceInfo = v
	return s
}

// SetState sets the State field's value.
func (s *CloudFormationStackRecord) SetState(v string) *CloudFormationStackRecord {
	s.State = &v
	return s
}

// Describes the source of a CloudFormation stack record (i.e., the export snapshot
// record).
type CloudFormationStackRecordSourceInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the export snapshot record.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the record.
	Name *string `locationName:"name" type:"string"`

	// The Lightsail resource type (e.g., ExportSnapshotRecord).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"CloudFormationStackRecordSourceType"`
}

// String returns the string representation
func (s CloudFormationStackRecordSourceInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudFormationStackRecordSourceInfo) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CloudFormationStackRecordSourceInfo) SetArn(v string) *CloudFormationStackRecordSourceInfo {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CloudFormationStackRecordSourceInfo) SetName(v string) *CloudFormationStackRecordSourceInfo {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *CloudFormationStackRecordSourceInfo) SetResourceType(v string) *CloudFormationStackRecordSourceInfo {
	s.ResourceType = &v
	return s
}

// Describes a contact method.
//
// A contact method is a way to send you notifications. For more information,
// see Notifications in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
type ContactMethod struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact method.
	Arn *string `locationName:"arn" type:"string"`

	// The destination of the contact method, such as an email address or a mobile
	// phone number.
	ContactEndpoint *string `locationName:"contactEndpoint" type:"string"`

	// The timestamp when the contact method was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Describes the resource location.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the contact method.
	Name *string `locationName:"name" type:"string"`

	// The protocol of the contact method, such as email or SMS (text messaging).
	Protocol *string `locationName:"protocol" type:"string" enum:"ContactProtocol"`

	// The Lightsail resource type (e.g., ContactMethod).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The current status of the contact method.
	//
	// A contact method has the following possible status:
	//
	//    * PendingVerification - The contact method has not yet been verified,
	//    and the verification has not yet expired.
	//
	//    * Valid - The contact method has been verified.
	//
	//    * InValid - An attempt was made to verify the contact method, but the
	//    verification has expired.
	Status *string `locationName:"status" type:"string" enum:"ContactMethodStatus"`

	// The support code. Include this code in your email to support when you have
	// questions about your Lightsail contact method. This code enables our support
	// team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`
}

// String returns the string representation
func (s ContactMethod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContactMethod) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ContactMethod) SetArn(v string) *ContactMethod {
	s.Arn = &v
	return s
}

// SetContactEndpoint sets the ContactEndpoint field's value.
func (s *ContactMethod) SetContactEndpoint(v string) *ContactMethod {
	s.ContactEndpoint = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ContactMethod) SetCreatedAt(v time.Time) *ContactMethod {
	s.CreatedAt = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *ContactMethod) SetLocation(v *ResourceLocation) *ContactMethod {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *ContactMethod) SetName(v string) *ContactMethod {
	s.Name = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *ContactMethod) SetProtocol(v string) *ContactMethod {
	s.Protocol = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ContactMethod) SetResourceType(v string) *ContactMethod {
	s.ResourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ContactMethod) SetStatus(v string) *ContactMethod {
	s.Status = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *ContactMethod) SetSupportCode(v string) *ContactMethod {
	s.SupportCode = &v
	return s
}

// Describes the settings of a container that will be launched, or that is launched,
// to an Amazon Lightsail container service.
type Container struct {
	_ struct{} `type:"structure"`

	// The launch command for the container.
	Command []*string `locationName:"command" type:"list"`

	// The environment variables of the container.
	Environment map[string]*string `locationName:"environment" type:"map"`

	// The name of the image used for the container.
	//
	// Container images sourced from your Lightsail container service, that are
	// registered and stored on your service, start with a colon (:). For example,
	// :container-service-1.mystaticwebsite.1. Container images sourced from a public
	// registry like Docker Hub don't start with a colon. For example, nginx:latest
	// or nginx.
	Image *string `locationName:"image" type:"string"`

	// The open firewall ports of the container.
	Ports map[string]*string `locationName:"ports" type:"map"`
}

// String returns the string representation
func (s Container) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Container) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *Container) SetCommand(v []*string) *Container {
	s.Command = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *Container) SetEnvironment(v map[string]*string) *Container {
	s.Environment = v
	return s
}

// SetImage sets the Image field's value.
func (s *Container) SetImage(v string) *Container {
	s.Image = &v
	return s
}

// SetPorts sets the Ports field's value.
func (s *Container) SetPorts(v map[string]*string) *Container {
	s.Ports = v
	return s
}

// Describes a container image that is registered to an Amazon Lightsail container
// service.
type ContainerImage struct {
	_ struct{} `type:"structure"`

	// The timestamp when the container image was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The digest of the container image.
	Digest *string `locationName:"digest" type:"string"`

	// The name of the container image.
	Image *string `locationName:"image" type:"string"`
}

// String returns the string representation
func (s ContainerImage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerImage) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ContainerImage) SetCreatedAt(v time.Time) *ContainerImage {
	s.CreatedAt = &v
	return s
}

// SetDigest sets the Digest field's value.
func (s *ContainerImage) SetDigest(v string) *ContainerImage {
	s.Digest = &v
	return s
}

// SetImage sets the Image field's value.
func (s *ContainerImage) SetImage(v string) *ContainerImage {
	s.Image = &v
	return s
}

// Describes an Amazon Lightsail container service.
type ContainerService struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the container service.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the container service.
	ContainerServiceName *string `locationName:"containerServiceName" min:"1" type:"string"`

	// The timestamp when the container service was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// An object that describes the current container deployment of the container
	// service.
	CurrentDeployment *ContainerServiceDeployment `locationName:"currentDeployment" type:"structure"`

	// A Boolean value indicating whether the container service is disabled.
	IsDisabled *bool `locationName:"isDisabled" type:"boolean"`

	// An object that describes the location of the container service, such as the
	// AWS Region and Availability Zone.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// An object that describes the next deployment of the container service.
	//
	// This value is null when there is no deployment in a pending state.
	NextDeployment *ContainerServiceDeployment `locationName:"nextDeployment" type:"structure"`

	// The power specification of the container service.
	//
	// The power specifies the amount of RAM, the number of vCPUs, and the base
	// price of the container service.
	Power *string `locationName:"power" type:"string" enum:"ContainerServicePowerName"`

	// The ID of the power of the container service.
	PowerId *string `locationName:"powerId" type:"string"`

	// The principal ARN of the container service.
	//
	// The principal ARN can be used to create a trust relationship between your
	// standard AWS account and your Lightsail container service. This allows you
	// to give your service permission to access resources in your standard AWS
	// account.
	PrincipalArn *string `locationName:"principalArn" type:"string"`

	// The private domain name of the container service.
	//
	// The private domain name is accessible only by other resources within the
	// default virtual private cloud (VPC) of your Lightsail account.
	PrivateDomainName *string `locationName:"privateDomainName" type:"string"`

	// The public domain name of the container service, such as example.com and
	// www.example.com.
	//
	// You can specify up to four public domain names for a container service. The
	// domain names that you specify are used when you create a deployment with
	// a container configured as the public endpoint of your container service.
	//
	// If you don't specify public domain names, then you can use the default domain
	// of the container service.
	//
	// You must create and validate an SSL/TLS certificate before you can use public
	// domain names with your container service. Use the CreateCertificate action
	// to create a certificate for the public domain names you want to use with
	// your container service.
	//
	// See CreateContainerService or UpdateContainerService for information about
	// how to specify public domain names for your Lightsail container service.
	PublicDomainNames map[string][]*string `locationName:"publicDomainNames" type:"map"`

	// The Lightsail resource type of the container service (i.e., ContainerService).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The scale specification of the container service.
	//
	// The scale specifies the allocated compute nodes of the container service.
	Scale *int64 `locationName:"scale" min:"1" type:"integer"`

	// The current state of the container service.
	//
	// The following container service states are possible:
	//
	//    * PENDING - The container service is being created.
	//
	//    * READY - The container service is running but it does not have an active
	//    container deployment.
	//
	//    * DEPLOYING - The container service is launching a container deployment.
	//
	//    * RUNNING - The container service is running and it has an active container
	//    deployment.
	//
	//    * UPDATING - The container service capacity or its custom domains are
	//    being updated.
	//
	//    * DELETING - The container service is being deleted.
	//
	//    * DISABLED - The container service is disabled, and its active deployment
	//    and containers, if any, are shut down.
	State *string `locationName:"state" type:"string" enum:"ContainerServiceState"`

	// An object that describes the current state of the container service.
	//
	// The state detail is populated only when a container service is in a PENDING,
	// DEPLOYING, or UPDATING state.
	StateDetail *ContainerServiceStateDetail `locationName:"stateDetail" type:"structure"`

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []*Tag `locationName:"tags" type:"list"`

	// The publicly accessible URL of the container service.
	//
	// If no public endpoint is specified in the currentDeployment, this URL returns
	// a 404 response.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s ContainerService) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerService) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ContainerService) SetArn(v string) *ContainerService {
	s.Arn = &v
	return s
}

// SetContainerServiceName sets the ContainerServiceName field's value.
func (s *ContainerService) SetContainerServiceName(v string) *ContainerService {
	s.ContainerServiceName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ContainerService) SetCreatedAt(v time.Time) *ContainerService {
	s.CreatedAt = &v
	return s
}

// SetCurrentDeployment sets the CurrentDeployment field's value.
func (s *ContainerService) SetCurrentDeployment(v *ContainerServiceDeployment) *ContainerService {
	s.CurrentDeployment = v
	return s
}

// SetIsDisabled sets the IsDisabled field's value.
func (s *ContainerService) SetIsDisabled(v bool) *ContainerService {
	s.IsDisabled = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *ContainerService) SetLocation(v *ResourceLocation) *ContainerService {
	s.Location = v
	return s
}

// SetNextDeployment sets the NextDeployment field's value.
func (s *ContainerService) SetNextDeployment(v *ContainerServiceDeployment) *ContainerService {
	s.NextDeployment = v
	return s
}

// SetPower sets the Power field's value.
func (s *ContainerService) SetPower(v string) *ContainerService {
	s.Power = &v
	return s
}

// SetPowerId sets the PowerId field's value.
func (s *ContainerService) SetPowerId(v string) *ContainerService {
	s.PowerId = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *ContainerService) SetPrincipalArn(v string) *ContainerService {
	s.PrincipalArn = &v
	return s
}

// SetPrivateDomainName sets the PrivateDomainName field's value.
func (s *ContainerService) SetPrivateDomainName(v string) *ContainerService {
	s.PrivateDomainName = &v
	return s
}

// SetPublicDomainNames sets the PublicDomainNames field's value.
func (s *ContainerService) SetPublicDomainNames(v map[string][]*string) *ContainerService {
	s.PublicDomainNames = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ContainerService) SetResourceType(v string) *ContainerService {
	s.ResourceType = &v
	return s
}

// SetScale sets the Scale field's value.
func (s *ContainerService) SetScale(v int64) *ContainerService {
	s.Scale = &v
	return s
}

// SetState sets the State field's value.
func (s *ContainerService) SetState(v string) *ContainerService {
	s.State = &v
	return s
}

// SetStateDetail sets the StateDetail field's value.
func (s *ContainerService) SetStateDetail(v *ContainerServiceStateDetail) *ContainerService {
	s.StateDetail = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ContainerService) SetTags(v []*Tag) *ContainerService {
	s.Tags = v
	return s
}

// SetUrl sets the Url field's value.
func (s *ContainerService) SetUrl(v string) *ContainerService {
	s.Url = &v
	return s
}

// Describes a container deployment configuration of an Amazon Lightsail container
// service.
//
// A deployment specifies the settings, such as the ports and launch command,
// of containers that are deployed to your container service.
type ContainerServiceDeployment struct {
	_ struct{} `type:"structure"`

	// An object that describes the configuration for the containers of the deployment.
	Containers map[string]*Container `locationName:"containers" type:"map"`

	// The timestamp when the deployment was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// An object that describes the endpoint of the deployment.
	PublicEndpoint *ContainerServiceEndpoint `locationName:"publicEndpoint" type:"structure"`

	// The state of the deployment.
	//
	// A deployment can be in one of the following states:
	//
	//    * Activating - The deployment is being created.
	//
	//    * Active - The deployment was successfully created, and it's currently
	//    running on the container service. The container service can have only
	//    one deployment in an active state at a time.
	//
	//    * Inactive - The deployment was previously successfully created, but it
	//    is not currently running on the container service.
	//
	//    * Failed - The deployment failed. Use the GetContainerLog action to view
	//    the log events for the containers in the deployment to try to determine
	//    the reason for the failure.
	State *string `locationName:"state" type:"string" enum:"ContainerServiceDeploymentState"`

	// The version number of the deployment.
	Version *int64 `locationName:"version" type:"integer"`
}

// String returns the string representation
func (s ContainerServiceDeployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerServiceDeployment) GoString() string {
	return s.String()
}

// SetContainers sets the Containers field's value.
func (s *ContainerServiceDeployment) SetContainers(v map[string]*Container) *ContainerServiceDeployment {
	s.Containers = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ContainerServiceDeployment) SetCreatedAt(v time.Time) *ContainerServiceDeployment {
	s.CreatedAt = &v
	return s
}

// SetPublicEndpoint sets the PublicEndpoint field's value.
func (s *ContainerServiceDeployment) SetPublicEndpoint(v *ContainerServiceEndpoint) *ContainerServiceDeployment {
	s.PublicEndpoint = v
	return s
}

// SetState sets the State field's value.
func (s *ContainerServiceDeployment) SetState(v string) *ContainerServiceDeployment {
	s.State = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ContainerServiceDeployment) SetVersion(v int64) *ContainerServiceDeployment {
	s.Version = &v
	return s
}

// Describes a container deployment configuration of an Amazon Lightsail container
// service.
//
// A deployment specifies the settings, such as the ports and launch command,
// of containers that are deployed to your container service.
type ContainerServiceDeploymentRequest struct {
	_ struct{} `type:"structure"`

	// An object that describes the configuration for the containers of the deployment.
	Containers map[string]*Container `locationName:"containers" type:"map"`

	// An object that describes the endpoint of the deployment.
	PublicEndpoint *EndpointRequest `locationName:"publicEndpoint" type:"structure"`
}

// String returns the string representation
func (s ContainerServiceDeploymentRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerServiceDeploymentRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerServiceDeploymentRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerServiceDeploymentRequest"}
	if s.PublicEndpoint != nil {
		if err := s.PublicEndpoint.Validate(); err != nil {
			invalidParams.AddNested("PublicEndpoint", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainers sets the Containers field's value.
func (s *ContainerServiceDeploymentRequest) SetContainers(v map[string]*Container) *ContainerServiceDeploymentRequest {
	s.Containers = v
	return s
}

// SetPublicEndpoint sets the PublicEndpoint field's value.
func (s *ContainerServiceDeploymentRequest) SetPublicEndpoint(v *EndpointRequest) *ContainerServiceDeploymentRequest {
	s.PublicEndpoint = v
	return s
}

// Describes the public endpoint configuration of a deployment of an Amazon
// Lightsail container service.
type ContainerServiceEndpoint struct {
	_ struct{} `type:"structure"`

	// The name of the container entry of the deployment that the endpoint configuration
	// applies to.
	ContainerName *string `locationName:"containerName" type:"string"`

	// The port of the specified container to which traffic is forwarded to.
	ContainerPort *int64 `locationName:"containerPort" type:"integer"`

	// An object that describes the health check configuration of the container.
	HealthCheck *ContainerServiceHealthCheckConfig `locationName:"healthCheck" type:"structure"`
}

// String returns the string representation
func (s ContainerServiceEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerServiceEndpoint) GoString() string {
	return s.String()
}

// SetContainerName sets the ContainerName field's value.
func (s *ContainerServiceEndpoint) SetContainerName(v string) *ContainerServiceEndpoint {
	s.ContainerName = &v
	return s
}

// SetContainerPort sets the ContainerPort field's value.
func (s *ContainerServiceEndpoint) SetContainerPort(v int64) *ContainerServiceEndpoint {
	s.ContainerPort = &v
	return s
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *ContainerServiceEndpoint) SetHealthCheck(v *ContainerServiceHealthCheckConfig) *ContainerServiceEndpoint {
	s.HealthCheck = v
	return s
}

// Describes the health check configuration of an Amazon Lightsail container
// service.
type ContainerServiceHealthCheckConfig struct {
	_ struct{} `type:"structure"`

	// The number of consecutive health checks successes required before moving
	// the container to the Healthy state. The default value is 2.
	HealthyThreshold *int64 `locationName:"healthyThreshold" type:"integer"`

	// The approximate interval, in seconds, between health checks of an individual
	// container. You can specify between 5 and 300 seconds. The default value is
	// 5.
	IntervalSeconds *int64 `locationName:"intervalSeconds" type:"integer"`

	// The path on the container on which to perform the health check. The default
	// value is /.
	Path *string `locationName:"path" type:"string"`

	// The HTTP codes to use when checking for a successful response from a container.
	// You can specify values between 200 and 499. You can specify multiple values
	// (for example, 200,202) or a range of values (for example, 200-299).
	SuccessCodes *string `locationName:"successCodes" type:"string"`

	// The amount of time, in seconds, during which no response means a failed health
	// check. You can specify between 2 and 60 seconds. The default value is 2.
	TimeoutSeconds *int64 `locationName:"timeoutSeconds" type:"integer"`

	// The number of consecutive health check failures required before moving the
	// container to the Unhealthy state. The default value is 2.
	UnhealthyThreshold *int64 `locationName:"unhealthyThreshold" type:"integer"`
}

// String returns the string representation
func (s ContainerServiceHealthCheckConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerServiceHealthCheckConfig) GoString() string {
	return s.String()
}

// SetHealthyThreshold sets the HealthyThreshold field's value.
func (s *ContainerServiceHealthCheckConfig) SetHealthyThreshold(v int64) *ContainerServiceHealthCheckConfig {
	s.HealthyThreshold = &v
	return s
}

// SetIntervalSeconds sets the IntervalSeconds field's value.
func (s *ContainerServiceHealthCheckConfig) SetIntervalSeconds(v int64) *ContainerServiceHealthCheckConfig {
	s.IntervalSeconds = &v
	return s
}

// SetPath sets the Path field's value.
func (s *ContainerServiceHealthCheckConfig) SetPath(v string) *ContainerServiceHealthCheckConfig {
	s.Path = &v
	return s
}

// SetSuccessCodes sets the SuccessCodes field's value.
func (s *ContainerServiceHealthCheckConfig) SetSuccessCodes(v string) *ContainerServiceHealthCheckConfig {
	s.SuccessCodes = &v
	return s
}

// SetTimeoutSeconds sets the TimeoutSeconds field's value.
func (s *ContainerServiceHealthCheckConfig) SetTimeoutSeconds(v int64) *ContainerServiceHealthCheckConfig {
	s.TimeoutSeconds = &v
	return s
}

// SetUnhealthyThreshold sets the UnhealthyThreshold field's value.
func (s *ContainerServiceHealthCheckConfig) SetUnhealthyThreshold(v int64) *ContainerServiceHealthCheckConfig {
	s.UnhealthyThreshold = &v
	return s
}

// Describes the log events of a container of an Amazon Lightsail container
// service.
type ContainerServiceLogEvent struct {
	_ struct{} `type:"structure"`

	// The timestamp when the container service log event was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The message of the container service log event.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ContainerServiceLogEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerServiceLogEvent) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ContainerServiceLogEvent) SetCreatedAt(v time.Time) *ContainerServiceLogEvent {
	s.CreatedAt = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ContainerServiceLogEvent) SetMessage(v string) *ContainerServiceLogEvent {
	s.Message = &v
	return s
}

// Describes the powers that can be specified for an Amazon Lightsail container
// service.
//
// The power specifies the amount of RAM, the number of vCPUs, and the base
// price of the container service.
type ContainerServicePower struct {
	_ struct{} `type:"structure"`

	// The number of vCPUs included in the power.
	CpuCount *float64 `locationName:"cpuCount" type:"float"`

	// A Boolean value indicating whether the power is active and can be specified
	// for container services.
	IsActive *bool `locationName:"isActive" type:"boolean"`

	// The friendly name of the power (e.g., nano).
	Name *string `locationName:"name" type:"string"`

	// The ID of the power (e.g., nano-1).
	PowerId *string `locationName:"powerId" type:"string"`

	// The monthly price of the power in USD.
	Price *float64 `locationName:"price" type:"float"`

	// The amount of RAM (in GB) of the power.
	RamSizeInGb *float64 `locationName:"ramSizeInGb" type:"float"`
}

// String returns the string representation
func (s ContainerServicePower) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerServicePower) GoString() string {
	return s.String()
}

// SetCpuCount sets the CpuCount field's value.
func (s *ContainerServicePower) SetCpuCount(v float64) *ContainerServicePower {
	s.CpuCount = &v
	return s
}

// SetIsActive sets the IsActive field's value.
func (s *ContainerServicePower) SetIsActive(v bool) *ContainerServicePower {
	s.IsActive = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContainerServicePower) SetName(v string) *ContainerServicePower {
	s.Name = &v
	return s
}

// SetPowerId sets the PowerId field's value.
func (s *ContainerServicePower) SetPowerId(v string) *ContainerServicePower {
	s.PowerId = &v
	return s
}

// SetPrice sets the Price field's value.
func (s *ContainerServicePower) SetPrice(v float64) *ContainerServicePower {
	s.Price = &v
	return s
}

// SetRamSizeInGb sets the RamSizeInGb field's value.
func (s *ContainerServicePower) SetRamSizeInGb(v float64) *ContainerServicePower {
	s.RamSizeInGb = &v
	return s
}

// Describes the login information for the container image registry of an Amazon
// Lightsail account.
type ContainerServiceRegistryLogin struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the container image registry username and password
	// expire.
	//
	// The log in credentials expire 12 hours after they are created, at which point
	// you will need to create a new set of log in credentials using the CreateContainerServiceRegistryLogin
	// action.
	ExpiresAt *time.Time `locationName:"expiresAt" type:"timestamp"`

	// The container service registry password to use to push container images to
	// the container image registry of a Lightsail account
	Password *string `locationName:"password" type:"string"`

	// The address to use to push container images to the container image registry
	// of a Lightsail account.
	Registry *string `locationName:"registry" type:"string"`

	// The container service registry username to use to push container images to
	// the container image registry of a Lightsail account.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s ContainerServiceRegistryLogin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerServiceRegistryLogin) GoString() string {
	return s.String()
}

// SetExpiresAt sets the ExpiresAt field's value.
func (s *ContainerServiceRegistryLogin) SetExpiresAt(v time.Time) *ContainerServiceRegistryLogin {
	s.ExpiresAt = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *ContainerServiceRegistryLogin) SetPassword(v string) *ContainerServiceRegistryLogin {
	s.Password = &v
	return s
}

// SetRegistry sets the Registry field's value.
func (s *ContainerServiceRegistryLogin) SetRegistry(v string) *ContainerServiceRegistryLogin {
	s.Registry = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *ContainerServiceRegistryLogin) SetUsername(v string) *ContainerServiceRegistryLogin {
	s.Username = &v
	return s
}

// Describes the current state of a container service.
type ContainerServiceStateDetail struct {
	_ struct{} `type:"structure"`

	// The state code of the container service.
	//
	// The following state codes are possible:
	//
	//    * The following state codes are possible if your container service is
	//    in a DEPLOYING or UPDATING state: CREATING_SYSTEM_RESOURCES - The system
	//    resources for your container service are being created. CREATING_NETWORK_INFRASTRUCTURE
	//    - The network infrastructure for your container service are being created.
	//    PROVISIONING_CERTIFICATE - The SSL/TLS certificate for your container
	//    service is being created. PROVISIONING_SERVICE - Your container service
	//    is being provisioned. CREATING_DEPLOYMENT - Your deployment is being created
	//    on your container service. EVALUATING_HEALTH_CHECK - The health of your
	//    deployment is being evaluated. ACTIVATING_DEPLOYMENT - Your deployment
	//    is being activated.
	//
	//    * The following state codes are possible if your container service is
	//    in a PENDING state: CERTIFICATE_LIMIT_EXCEEDED - The SSL/TLS certificate
	//    required for your container service exceeds the maximum number of certificates
	//    allowed for your account. UNKNOWN_ERROR - An error was experienced when
	//    your container service was being created.
	Code *string `locationName:"code" type:"string" enum:"ContainerServiceStateDetailCode"`

	// A message that provides more information for the state code.
	//
	// The state detail is populated only when a container service is in a PENDING,
	// DEPLOYING, or UPDATING state.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ContainerServiceStateDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerServiceStateDetail) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ContainerServiceStateDetail) SetCode(v string) *ContainerServiceStateDetail {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ContainerServiceStateDetail) SetMessage(v string) *ContainerServiceStateDetail {
	s.Message = &v
	return s
}

// Describes whether an Amazon Lightsail content delivery network (CDN) distribution
// forwards cookies to the origin and, if so, which ones.
//
// For the cookies that you specify, your distribution caches separate versions
// of the specified content based on the cookie values in viewer requests.
type CookieObject struct {
	_ struct{} `type:"structure"`

	// The specific cookies to forward to your distribution's origin.
	CookiesAllowList []*string `locationName:"cookiesAllowList" type:"list"`

	// Specifies which cookies to forward to the distribution's origin for a cache
	// behavior: all, none, or allow-list to forward only the cookies specified
	// in the cookiesAllowList parameter.
	Option *string `locationName:"option" type:"string" enum:"ForwardValues"`
}

// String returns the string representation
func (s CookieObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CookieObject) GoString() string {
	return s.String()
}

// SetCookiesAllowList sets the CookiesAllowList field's value.
func (s *CookieObject) SetCookiesAllowList(v []*string) *CookieObject {
	s.CookiesAllowList = v
	return s
}

// SetOption sets the Option field's value.
func (s *CookieObject) SetOption(v string) *CookieObject {
	s.Option = &v
	return s
}

type CopySnapshotInput struct {
	_ struct{} `type:"structure"`

	// The date of the source automatic snapshot to copy. Use the get auto snapshots
	// operation to identify the dates of the available automatic snapshots.
	//
	// Constraints:
	//
	//    * Must be specified in YYYY-MM-DD format.
	//
	//    * This parameter cannot be defined together with the use latest restorable
	//    auto snapshot parameter. The restore date and use latest restorable auto
	//    snapshot parameters are mutually exclusive.
	//
	//    * Define this parameter only when copying an automatic snapshot as a manual
	//    snapshot. For more information, see the Amazon Lightsail Developer Guide
	//    (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots).
	RestoreDate *string `locationName:"restoreDate" type:"string"`

	// The AWS Region where the source manual or automatic snapshot is located.
	//
	// SourceRegion is a required field
	SourceRegion *string `locationName:"sourceRegion" type:"string" required:"true" enum:"RegionName"`

	// The name of the source instance or disk from which the source automatic snapshot
	// was created.
	//
	// Constraint:
	//
	//    * Define this parameter only when copying an automatic snapshot as a manual
	//    snapshot. For more information, see the Amazon Lightsail Developer Guide
	//    (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots).
	SourceResourceName *string `locationName:"sourceResourceName" type:"string"`

	// The name of the source manual snapshot to copy.
	//
	// Constraint:
	//
	//    * Define this parameter only when copying a manual snapshot as another
	//    manual snapshot.
	SourceSnapshotName *string `locationName:"sourceSnapshotName" type:"string"`

	// The name of the new manual snapshot to be created as a copy.
	//
	// TargetSnapshotName is a required field
	TargetSnapshotName *string `locationName:"targetSnapshotName" type:"string" required:"true"`

	// A Boolean value to indicate whether to use the latest available automatic
	// snapshot of the specified source instance or disk.
	//
	// Constraints:
	//
	//    * This parameter cannot be defined together with the restore date parameter.
	//    The use latest restorable auto snapshot and restore date parameters are
	//    mutually exclusive.
	//
	//    * Define this parameter only when copying an automatic snapshot as a manual
	//    snapshot. For more information, see the Amazon Lightsail Developer Guide
	//    (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots).
	UseLatestRestorableAutoSnapshot *bool `locationName:"useLatestRestorableAutoSnapshot" type:"boolean"`
}

// String returns the string representation
func (s CopySnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopySnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopySnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopySnapshotInput"}
	if s.SourceRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceRegion"))
	}
	if s.TargetSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRestoreDate sets the RestoreDate field's value.
func (s *CopySnapshotInput) SetRestoreDate(v string) *CopySnapshotInput {
	s.RestoreDate = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *CopySnapshotInput) SetSourceRegion(v string) *CopySnapshotInput {
	s.SourceRegion = &v
	return s
}

// SetSourceResourceName sets the SourceResourceName field's value.
func (s *CopySnapshotInput) SetSourceResourceName(v string) *CopySnapshotInput {
	s.SourceResourceName = &v
	return s
}

// SetSourceSnapshotName sets the SourceSnapshotName field's value.
func (s *CopySnapshotInput) SetSourceSnapshotName(v string) *CopySnapshotInput {
	s.SourceSnapshotName = &v
	return s
}

// SetTargetSnapshotName sets the TargetSnapshotName field's value.
func (s *CopySnapshotInput) SetTargetSnapshotName(v string) *CopySnapshotInput {
	s.TargetSnapshotName = &v
	return s
}

// SetUseLatestRestorableAutoSnapshot sets the UseLatestRestorableAutoSnapshot field's value.
func (s *CopySnapshotInput) SetUseLatestRestorableAutoSnapshot(v bool) *CopySnapshotInput {
	s.UseLatestRestorableAutoSnapshot = &v
	return s
}

type CopySnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CopySnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopySnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CopySnapshotOutput) SetOperations(v []*Operation) *CopySnapshotOutput {
	s.Operations = v
	return s
}

type CreateBucketAccessKeyInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket that the new access key will belong to, and grant
	// access to.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateBucketAccessKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketAccessKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBucketAccessKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBucketAccessKeyInput"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *CreateBucketAccessKeyInput) SetBucketName(v string) *CreateBucketAccessKeyInput {
	s.BucketName = &v
	return s
}

type CreateBucketAccessKeyOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the access key that is created.
	AccessKey *AccessKey `locationName:"accessKey" type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateBucketAccessKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketAccessKeyOutput) GoString() string {
	return s.String()
}

// SetAccessKey sets the AccessKey field's value.
func (s *CreateBucketAccessKeyOutput) SetAccessKey(v *AccessKey) *CreateBucketAccessKeyOutput {
	s.AccessKey = v
	return s
}

// SetOperations sets the Operations field's value.
func (s *CreateBucketAccessKeyOutput) SetOperations(v []*Operation) *CreateBucketAccessKeyOutput {
	s.Operations = v
	return s
}

type CreateBucketInput struct {
	_ struct{} `type:"structure"`

	// The name for the bucket.
	//
	// For more information about bucket names, see Bucket naming rules in Amazon
	// Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/bucket-naming-rules-in-amazon-lightsail)
	// in the Amazon Lightsail Developer Guide.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`

	// The ID of the bundle to use for the bucket.
	//
	// A bucket bundle specifies the monthly cost, storage space, and data transfer
	// quota for a bucket.
	//
	// Use the GetBucketBundles action to get a list of bundle IDs that you can
	// specify.
	//
	// Use the UpdateBucketBundle action to change the bundle after the bucket is
	// created.
	//
	// BundleId is a required field
	BundleId *string `locationName:"bundleId" type:"string" required:"true"`

	// A Boolean value that indicates whether to enable versioning of objects in
	// the bucket.
	//
	// For more information about versioning, see Enabling and suspending bucket
	// object versioning in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-managing-bucket-object-versioning)
	// in the Amazon Lightsail Developer Guide.
	EnableObjectVersioning *bool `locationName:"enableObjectVersioning" type:"boolean"`

	// The tag keys and optional values to add to the bucket during creation.
	//
	// Use the TagResource action to tag the bucket after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBucketInput"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *CreateBucketInput) SetBucketName(v string) *CreateBucketInput {
	s.BucketName = &v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *CreateBucketInput) SetBundleId(v string) *CreateBucketInput {
	s.BundleId = &v
	return s
}

// SetEnableObjectVersioning sets the EnableObjectVersioning field's value.
func (s *CreateBucketInput) SetEnableObjectVersioning(v bool) *CreateBucketInput {
	s.EnableObjectVersioning = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBucketInput) SetTags(v []*Tag) *CreateBucketInput {
	s.Tags = v
	return s
}

type CreateBucketOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the bucket that is created.
	Bucket *Bucket `locationName:"bucket" type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketOutput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *CreateBucketOutput) SetBucket(v *Bucket) *CreateBucketOutput {
	s.Bucket = v
	return s
}

// SetOperations sets the Operations field's value.
func (s *CreateBucketOutput) SetOperations(v []*Operation) *CreateBucketOutput {
	s.Operations = v
	return s
}

type CreateCertificateInput struct {
	_ struct{} `type:"structure"`

	// The name for the certificate.
	//
	// CertificateName is a required field
	CertificateName *string `locationName:"certificateName" type:"string" required:"true"`

	// The domain name (e.g., example.com) for the certificate.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`

	// An array of strings that specify the alternate domains (e.g., example2.com)
	// and subdomains (e.g., blog.example.com) for the certificate.
	//
	// You can specify a maximum of nine alternate domains (in addition to the primary
	// domain name).
	//
	// Wildcard domain entries (e.g., *.example.com) are not supported.
	SubjectAlternativeNames []*string `locationName:"subjectAlternativeNames" type:"list"`

	// The tag keys and optional values to add to the certificate during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCertificateInput"}
	if s.CertificateName == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateName"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateName sets the CertificateName field's value.
func (s *CreateCertificateInput) SetCertificateName(v string) *CreateCertificateInput {
	s.CertificateName = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateCertificateInput) SetDomainName(v string) *CreateCertificateInput {
	s.DomainName = &v
	return s
}

// SetSubjectAlternativeNames sets the SubjectAlternativeNames field's value.
func (s *CreateCertificateInput) SetSubjectAlternativeNames(v []*string) *CreateCertificateInput {
	s.SubjectAlternativeNames = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCertificateInput) SetTags(v []*Tag) *CreateCertificateInput {
	s.Tags = v
	return s
}

type CreateCertificateOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the certificate created.
	Certificate *CertificateSummary `locationName:"certificate" type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *CreateCertificateOutput) SetCertificate(v *CertificateSummary) *CreateCertificateOutput {
	s.Certificate = v
	return s
}

// SetOperations sets the Operations field's value.
func (s *CreateCertificateOutput) SetOperations(v []*Operation) *CreateCertificateOutput {
	s.Operations = v
	return s
}

type CreateCloudFormationStackInput struct {
	_ struct{} `type:"structure"`

	// An array of parameters that will be used to create the new Amazon EC2 instance.
	// You can only pass one instance entry at a time in this array. You will get
	// an invalid parameter error if you pass more than one instance entry in this
	// array.
	//
	// Instances is a required field
	Instances []*InstanceEntry `locationName:"instances" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateCloudFormationStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCloudFormationStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCloudFormationStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCloudFormationStackInput"}
	if s.Instances == nil {
		invalidParams.Add(request.NewErrParamRequired("Instances"))
	}
	if s.Instances != nil {
		for i, v := range s.Instances {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Instances", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstances sets the Instances field's value.
func (s *CreateCloudFormationStackInput) SetInstances(v []*InstanceEntry) *CreateCloudFormationStackInput {
	s.Instances = v
	return s
}

type CreateCloudFormationStackOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateCloudFormationStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCloudFormationStackOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateCloudFormationStackOutput) SetOperations(v []*Operation) *CreateCloudFormationStackOutput {
	s.Operations = v
	return s
}

type CreateContactMethodInput struct {
	_ struct{} `type:"structure"`

	// The destination of the contact method, such as an email address or a mobile
	// phone number.
	//
	// Use the E.164 format when specifying a mobile phone number. E.164 is a standard
	// for the phone number structure used for international telecommunication.
	// Phone numbers that follow this format can have a maximum of 15 digits, and
	// they are prefixed with the plus character (+) and the country code. For example,
	// a U.S. phone number in E.164 format would be specified as +1XXX5550100. For
	// more information, see E.164 (https://en.wikipedia.org/wiki/E.164) on Wikipedia.
	//
	// ContactEndpoint is a required field
	ContactEndpoint *string `locationName:"contactEndpoint" min:"1" type:"string" required:"true"`

	// The protocol of the contact method, such as Email or SMS (text messaging).
	//
	// The SMS protocol is supported only in the following AWS Regions.
	//
	//    * US East (N. Virginia) (us-east-1)
	//
	//    * US West (Oregon) (us-west-2)
	//
	//    * Europe (Ireland) (eu-west-1)
	//
	//    * Asia Pacific (Tokyo) (ap-northeast-1)
	//
	//    * Asia Pacific (Singapore) (ap-southeast-1)
	//
	//    * Asia Pacific (Sydney) (ap-southeast-2)
	//
	// For a list of countries/regions where SMS text messages can be sent, and
	// the latest AWS Regions where SMS text messaging is supported, see Supported
	// Regions and Countries (https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html)
	// in the Amazon SNS Developer Guide.
	//
	// For more information about notifications in Amazon Lightsail, see Notifications
	// in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"ContactProtocol"`
}

// String returns the string representation
func (s CreateContactMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateContactMethodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContactMethodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateContactMethodInput"}
	if s.ContactEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactEndpoint"))
	}
	if s.ContactEndpoint != nil && len(*s.ContactEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactEndpoint", 1))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactEndpoint sets the ContactEndpoint field's value.
func (s *CreateContactMethodInput) SetContactEndpoint(v string) *CreateContactMethodInput {
	s.ContactEndpoint = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *CreateContactMethodInput) SetProtocol(v string) *CreateContactMethodInput {
	s.Protocol = &v
	return s
}

type CreateContactMethodOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateContactMethodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateContactMethodOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateContactMethodOutput) SetOperations(v []*Operation) *CreateContactMethodOutput {
	s.Operations = v
	return s
}

type CreateContainerServiceDeploymentInput struct {
	_ struct{} `type:"structure"`

	// An object that describes the settings of the containers that will be launched
	// on the container service.
	Containers map[string]*Container `locationName:"containers" type:"map"`

	// An object that describes the settings of the public endpoint for the container
	// service.
	PublicEndpoint *EndpointRequest `locationName:"publicEndpoint" type:"structure"`

	// The name of the container service for which to create the deployment.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateContainerServiceDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateContainerServiceDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContainerServiceDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateContainerServiceDeploymentInput"}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}
	if s.PublicEndpoint != nil {
		if err := s.PublicEndpoint.Validate(); err != nil {
			invalidParams.AddNested("PublicEndpoint", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainers sets the Containers field's value.
func (s *CreateContainerServiceDeploymentInput) SetContainers(v map[string]*Container) *CreateContainerServiceDeploymentInput {
	s.Containers = v
	return s
}

// SetPublicEndpoint sets the PublicEndpoint field's value.
func (s *CreateContainerServiceDeploymentInput) SetPublicEndpoint(v *EndpointRequest) *CreateContainerServiceDeploymentInput {
	s.PublicEndpoint = v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *CreateContainerServiceDeploymentInput) SetServiceName(v string) *CreateContainerServiceDeploymentInput {
	s.ServiceName = &v
	return s
}

type CreateContainerServiceDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes a container service.
	ContainerService *ContainerService `locationName:"containerService" type:"structure"`
}

// String returns the string representation
func (s CreateContainerServiceDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateContainerServiceDeploymentOutput) GoString() string {
	return s.String()
}

// SetContainerService sets the ContainerService field's value.
func (s *CreateContainerServiceDeploymentOutput) SetContainerService(v *ContainerService) *CreateContainerServiceDeploymentOutput {
	s.ContainerService = v
	return s
}

type CreateContainerServiceInput struct {
	_ struct{} `type:"structure"`

	// An object that describes a deployment for the container service.
	//
	// A deployment specifies the containers that will be launched on the container
	// service and their settings, such as the ports to open, the environment variables
	// to apply, and the launch command to run. It also specifies the container
	// that will serve as the public endpoint of the deployment and its settings,
	// such as the HTTP or HTTPS port to use, and the health check configuration.
	Deployment *ContainerServiceDeploymentRequest `locationName:"deployment" type:"structure"`

	// The power specification for the container service.
	//
	// The power specifies the amount of memory, vCPUs, and base monthly cost of
	// each node of the container service. The power and scale of a container service
	// makes up its configured capacity. To determine the monthly price of your
	// container service, multiply the base price of the power with the scale (the
	// number of nodes) of the service.
	//
	// Use the GetContainerServicePowers action to get a list of power options that
	// you can specify using this parameter, and their base monthly cost.
	//
	// Power is a required field
	Power *string `locationName:"power" type:"string" required:"true" enum:"ContainerServicePowerName"`

	// The public domain names to use with the container service, such as example.com
	// and www.example.com.
	//
	// You can specify up to four public domain names for a container service. The
	// domain names that you specify are used when you create a deployment with
	// a container configured as the public endpoint of your container service.
	//
	// If you don't specify public domain names, then you can use the default domain
	// of the container service.
	//
	// You must create and validate an SSL/TLS certificate before you can use public
	// domain names with your container service. Use the CreateCertificate action
	// to create a certificate for the public domain names you want to use with
	// your container service.
	//
	// You can specify public domain names using a string to array map as shown
	// in the example later on this page.
	PublicDomainNames map[string][]*string `locationName:"publicDomainNames" type:"map"`

	// The scale specification for the container service.
	//
	// The scale specifies the allocated compute nodes of the container service.
	// The power and scale of a container service makes up its configured capacity.
	// To determine the monthly price of your container service, multiply the base
	// price of the power with the scale (the number of nodes) of the service.
	//
	// Scale is a required field
	Scale *int64 `locationName:"scale" min:"1" type:"integer" required:"true"`

	// The name for the container service.
	//
	// The name that you specify for your container service will make up part of
	// its default domain. The default domain of a container service is typically
	// https://<ServiceName>.<RandomGUID>.<AWSRegion>.cs.amazonlightsail.com. If
	// the name of your container service is container-service-1, and it's located
	// in the US East (Ohio) AWS region (us-east-2), then the domain for your container
	// service will be like the following example: https://container-service-1.ur4EXAMPLE2uq.us-east-2.cs.amazonlightsail.com
	//
	// The following are the requirements for container service names:
	//
	//    * Must be unique within each AWS Region in your Lightsail account.
	//
	//    * Must contain 1 to 63 characters.
	//
	//    * Must contain only alphanumeric characters and hyphens.
	//
	//    * A hyphen (-) can separate words but cannot be at the start or end of
	//    the name.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`

	// The tag keys and optional values to add to the certificate during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	//
	// For more information about tags in Lightsail, see the Amazon Lightsail Developer
	// Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateContainerServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateContainerServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContainerServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateContainerServiceInput"}
	if s.Power == nil {
		invalidParams.Add(request.NewErrParamRequired("Power"))
	}
	if s.Scale == nil {
		invalidParams.Add(request.NewErrParamRequired("Scale"))
	}
	if s.Scale != nil && *s.Scale < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Scale", 1))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}
	if s.Deployment != nil {
		if err := s.Deployment.Validate(); err != nil {
			invalidParams.AddNested("Deployment", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeployment sets the Deployment field's value.
func (s *CreateContainerServiceInput) SetDeployment(v *ContainerServiceDeploymentRequest) *CreateContainerServiceInput {
	s.Deployment = v
	return s
}

// SetPower sets the Power field's value.
func (s *CreateContainerServiceInput) SetPower(v string) *CreateContainerServiceInput {
	s.Power = &v
	return s
}

// SetPublicDomainNames sets the PublicDomainNames field's value.
func (s *CreateContainerServiceInput) SetPublicDomainNames(v map[string][]*string) *CreateContainerServiceInput {
	s.PublicDomainNames = v
	return s
}

// SetScale sets the Scale field's value.
func (s *CreateContainerServiceInput) SetScale(v int64) *CreateContainerServiceInput {
	s.Scale = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *CreateContainerServiceInput) SetServiceName(v string) *CreateContainerServiceInput {
	s.ServiceName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateContainerServiceInput) SetTags(v []*Tag) *CreateContainerServiceInput {
	s.Tags = v
	return s
}

type CreateContainerServiceOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes a container service.
	ContainerService *ContainerService `locationName:"containerService" type:"structure"`
}

// String returns the string representation
func (s CreateContainerServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateContainerServiceOutput) GoString() string {
	return s.String()
}

// SetContainerService sets the ContainerService field's value.
func (s *CreateContainerServiceOutput) SetContainerService(v *ContainerService) *CreateContainerServiceOutput {
	s.ContainerService = v
	return s
}

type CreateContainerServiceRegistryLoginInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateContainerServiceRegistryLoginInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateContainerServiceRegistryLoginInput) GoString() string {
	return s.String()
}

type CreateContainerServiceRegistryLoginOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the log in information for the container service
	// registry of your Lightsail account.
	RegistryLogin *ContainerServiceRegistryLogin `locationName:"registryLogin" type:"structure"`
}

// String returns the string representation
func (s CreateContainerServiceRegistryLoginOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateContainerServiceRegistryLoginOutput) GoString() string {
	return s.String()
}

// SetRegistryLogin sets the RegistryLogin field's value.
func (s *CreateContainerServiceRegistryLoginOutput) SetRegistryLogin(v *ContainerServiceRegistryLogin) *CreateContainerServiceRegistryLoginOutput {
	s.RegistryLogin = v
	return s
}

type CreateDiskFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// An array of objects that represent the add-ons to enable for the new disk.
	AddOns []*AddOnRequest `locationName:"addOns" type:"list"`

	// The Availability Zone where you want to create the disk (e.g., us-east-2a).
	// Choose the same Availability Zone as the Lightsail instance where you want
	// to create the disk.
	//
	// Use the GetRegions operation to list the Availability Zones where Lightsail
	// is currently available.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// The unique Lightsail disk name (e.g., my-disk).
	//
	// DiskName is a required field
	DiskName *string `locationName:"diskName" type:"string" required:"true"`

	// The name of the disk snapshot (e.g., my-snapshot) from which to create the
	// new storage disk.
	//
	// Constraint:
	//
	//    * This parameter cannot be defined together with the source disk name
	//    parameter. The disk snapshot name and source disk name parameters are
	//    mutually exclusive.
	DiskSnapshotName *string `locationName:"diskSnapshotName" type:"string"`

	// The date of the automatic snapshot to use for the new disk. Use the get auto
	// snapshots operation to identify the dates of the available automatic snapshots.
	//
	// Constraints:
	//
	//    * Must be specified in YYYY-MM-DD format.
	//
	//    * This parameter cannot be defined together with the use latest restorable
	//    auto snapshot parameter. The restore date and use latest restorable auto
	//    snapshot parameters are mutually exclusive.
	//
	//    * Define this parameter only when creating a new disk from an automatic
	//    snapshot. For more information, see the Amazon Lightsail Developer Guide
	//    (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
	RestoreDate *string `locationName:"restoreDate" type:"string"`

	// The size of the disk in GB (e.g., 32).
	//
	// SizeInGb is a required field
	SizeInGb *int64 `locationName:"sizeInGb" type:"integer" required:"true"`

	// The name of the source disk from which the source automatic snapshot was
	// created.
	//
	// Constraints:
	//
	//    * This parameter cannot be defined together with the disk snapshot name
	//    parameter. The source disk name and disk snapshot name parameters are
	//    mutually exclusive.
	//
	//    * Define this parameter only when creating a new disk from an automatic
	//    snapshot. For more information, see the Amazon Lightsail Developer Guide
	//    (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
	SourceDiskName *string `locationName:"sourceDiskName" type:"string"`

	// The tag keys and optional values to add to the resource during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`

	// A Boolean value to indicate whether to use the latest available automatic
	// snapshot.
	//
	// Constraints:
	//
	//    * This parameter cannot be defined together with the restore date parameter.
	//    The use latest restorable auto snapshot and restore date parameters are
	//    mutually exclusive.
	//
	//    * Define this parameter only when creating a new disk from an automatic
	//    snapshot. For more information, see the Amazon Lightsail Developer Guide
	//    (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
	UseLatestRestorableAutoSnapshot *bool `locationName:"useLatestRestorableAutoSnapshot" type:"boolean"`
}

// String returns the string representation
func (s CreateDiskFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDiskFromSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDiskFromSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDiskFromSnapshotInput"}
	if s.AvailabilityZone == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZone"))
	}
	if s.DiskName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskName"))
	}
	if s.SizeInGb == nil {
		invalidParams.Add(request.NewErrParamRequired("SizeInGb"))
	}
	if s.AddOns != nil {
		for i, v := range s.AddOns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddOns", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddOns sets the AddOns field's value.
func (s *CreateDiskFromSnapshotInput) SetAddOns(v []*AddOnRequest) *CreateDiskFromSnapshotInput {
	s.AddOns = v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateDiskFromSnapshotInput) SetAvailabilityZone(v string) *CreateDiskFromSnapshotInput {
	s.AvailabilityZone = &v
	return s
}

// SetDiskName sets the DiskName field's value.
func (s *CreateDiskFromSnapshotInput) SetDiskName(v string) *CreateDiskFromSnapshotInput {
	s.DiskName = &v
	return s
}

// SetDiskSnapshotName sets the DiskSnapshotName field's value.
func (s *CreateDiskFromSnapshotInput) SetDiskSnapshotName(v string) *CreateDiskFromSnapshotInput {
	s.DiskSnapshotName = &v
	return s
}

// SetRestoreDate sets the RestoreDate field's value.
func (s *CreateDiskFromSnapshotInput) SetRestoreDate(v string) *CreateDiskFromSnapshotInput {
	s.RestoreDate = &v
	return s
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *CreateDiskFromSnapshotInput) SetSizeInGb(v int64) *CreateDiskFromSnapshotInput {
	s.SizeInGb = &v
	return s
}

// SetSourceDiskName sets the SourceDiskName field's value.
func (s *CreateDiskFromSnapshotInput) SetSourceDiskName(v string) *CreateDiskFromSnapshotInput {
	s.SourceDiskName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDiskFromSnapshotInput) SetTags(v []*Tag) *CreateDiskFromSnapshotInput {
	s.Tags = v
	return s
}

// SetUseLatestRestorableAutoSnapshot sets the UseLatestRestorableAutoSnapshot field's value.
func (s *CreateDiskFromSnapshotInput) SetUseLatestRestorableAutoSnapshot(v bool) *CreateDiskFromSnapshotInput {
	s.UseLatestRestorableAutoSnapshot = &v
	return s
}

type CreateDiskFromSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateDiskFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDiskFromSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateDiskFromSnapshotOutput) SetOperations(v []*Operation) *CreateDiskFromSnapshotOutput {
	s.Operations = v
	return s
}

type CreateDiskInput struct {
	_ struct{} `type:"structure"`

	// An array of objects that represent the add-ons to enable for the new disk.
	AddOns []*AddOnRequest `locationName:"addOns" type:"list"`

	// The Availability Zone where you want to create the disk (e.g., us-east-2a).
	// Use the same Availability Zone as the Lightsail instance to which you want
	// to attach the disk.
	//
	// Use the get regions operation to list the Availability Zones where Lightsail
	// is currently available.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// The unique Lightsail disk name (e.g., my-disk).
	//
	// DiskName is a required field
	DiskName *string `locationName:"diskName" type:"string" required:"true"`

	// The size of the disk in GB (e.g., 32).
	//
	// SizeInGb is a required field
	SizeInGb *int64 `locationName:"sizeInGb" type:"integer" required:"true"`

	// The tag keys and optional values to add to the resource during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateDiskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDiskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDiskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDiskInput"}
	if s.AvailabilityZone == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZone"))
	}
	if s.DiskName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskName"))
	}
	if s.SizeInGb == nil {
		invalidParams.Add(request.NewErrParamRequired("SizeInGb"))
	}
	if s.AddOns != nil {
		for i, v := range s.AddOns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddOns", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddOns sets the AddOns field's value.
func (s *CreateDiskInput) SetAddOns(v []*AddOnRequest) *CreateDiskInput {
	s.AddOns = v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateDiskInput) SetAvailabilityZone(v string) *CreateDiskInput {
	s.AvailabilityZone = &v
	return s
}

// SetDiskName sets the DiskName field's value.
func (s *CreateDiskInput) SetDiskName(v string) *CreateDiskInput {
	s.DiskName = &v
	return s
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *CreateDiskInput) SetSizeInGb(v int64) *CreateDiskInput {
	s.SizeInGb = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDiskInput) SetTags(v []*Tag) *CreateDiskInput {
	s.Tags = v
	return s
}

type CreateDiskOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateDiskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDiskOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateDiskOutput) SetOperations(v []*Operation) *CreateDiskOutput {
	s.Operations = v
	return s
}

type CreateDiskSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the source disk (e.g., Disk-Virginia-1).
	//
	// This parameter cannot be defined together with the instance name parameter.
	// The disk name and instance name parameters are mutually exclusive.
	DiskName *string `locationName:"diskName" type:"string"`

	// The name of the destination disk snapshot (e.g., my-disk-snapshot) based
	// on the source disk.
	//
	// DiskSnapshotName is a required field
	DiskSnapshotName *string `locationName:"diskSnapshotName" type:"string" required:"true"`

	// The unique name of the source instance (e.g., Amazon_Linux-512MB-Virginia-1).
	// When this is defined, a snapshot of the instance's system volume is created.
	//
	// This parameter cannot be defined together with the disk name parameter. The
	// instance name and disk name parameters are mutually exclusive.
	InstanceName *string `locationName:"instanceName" type:"string"`

	// The tag keys and optional values to add to the resource during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateDiskSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDiskSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDiskSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDiskSnapshotInput"}
	if s.DiskSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskName sets the DiskName field's value.
func (s *CreateDiskSnapshotInput) SetDiskName(v string) *CreateDiskSnapshotInput {
	s.DiskName = &v
	return s
}

// SetDiskSnapshotName sets the DiskSnapshotName field's value.
func (s *CreateDiskSnapshotInput) SetDiskSnapshotName(v string) *CreateDiskSnapshotInput {
	s.DiskSnapshotName = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *CreateDiskSnapshotInput) SetInstanceName(v string) *CreateDiskSnapshotInput {
	s.InstanceName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDiskSnapshotInput) SetTags(v []*Tag) *CreateDiskSnapshotInput {
	s.Tags = v
	return s
}

type CreateDiskSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateDiskSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDiskSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateDiskSnapshotOutput) SetOperations(v []*Operation) *CreateDiskSnapshotOutput {
	s.Operations = v
	return s
}

type CreateDistributionInput struct {
	_ struct{} `type:"structure"`

	// The bundle ID to use for the distribution.
	//
	// A distribution bundle describes the specifications of your distribution,
	// such as the monthly cost and monthly network transfer quota.
	//
	// Use the GetDistributionBundles action to get a list of distribution bundle
	// IDs that you can specify.
	//
	// BundleId is a required field
	BundleId *string `locationName:"bundleId" type:"string" required:"true"`

	// An object that describes the cache behavior settings for the distribution.
	CacheBehaviorSettings *CacheSettings `locationName:"cacheBehaviorSettings" type:"structure"`

	// An array of objects that describe the per-path cache behavior for the distribution.
	CacheBehaviors []*CacheBehaviorPerPath `locationName:"cacheBehaviors" type:"list"`

	// An object that describes the default cache behavior for the distribution.
	//
	// DefaultCacheBehavior is a required field
	DefaultCacheBehavior *CacheBehavior `locationName:"defaultCacheBehavior" type:"structure" required:"true"`

	// The name for the distribution.
	//
	// DistributionName is a required field
	DistributionName *string `locationName:"distributionName" type:"string" required:"true"`

	// The IP address type for the distribution.
	//
	// The possible values are ipv4 for IPv4 only, and dualstack for IPv4 and IPv6.
	//
	// The default value is dualstack.
	IpAddressType *string `locationName:"ipAddressType" type:"string" enum:"IpAddressType"`

	// An object that describes the origin resource for the distribution, such as
	// a Lightsail instance or load balancer.
	//
	// The distribution pulls, caches, and serves content from the origin.
	//
	// Origin is a required field
	Origin *InputOrigin `locationName:"origin" type:"structure" required:"true"`

	// The tag keys and optional values to add to the distribution during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDistributionInput"}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.DefaultCacheBehavior == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultCacheBehavior"))
	}
	if s.DistributionName == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionName"))
	}
	if s.Origin == nil {
		invalidParams.Add(request.NewErrParamRequired("Origin"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *CreateDistributionInput) SetBundleId(v string) *CreateDistributionInput {
	s.BundleId = &v
	return s
}

// SetCacheBehaviorSettings sets the CacheBehaviorSettings field's value.
func (s *CreateDistributionInput) SetCacheBehaviorSettings(v *CacheSettings) *CreateDistributionInput {
	s.CacheBehaviorSettings = v
	return s
}

// SetCacheBehaviors sets the CacheBehaviors field's value.
func (s *CreateDistributionInput) SetCacheBehaviors(v []*CacheBehaviorPerPath) *CreateDistributionInput {
	s.CacheBehaviors = v
	return s
}

// SetDefaultCacheBehavior sets the DefaultCacheBehavior field's value.
func (s *CreateDistributionInput) SetDefaultCacheBehavior(v *CacheBehavior) *CreateDistributionInput {
	s.DefaultCacheBehavior = v
	return s
}

// SetDistributionName sets the DistributionName field's value.
func (s *CreateDistributionInput) SetDistributionName(v string) *CreateDistributionInput {
	s.DistributionName = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *CreateDistributionInput) SetIpAddressType(v string) *CreateDistributionInput {
	s.IpAddressType = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *CreateDistributionInput) SetOrigin(v *InputOrigin) *CreateDistributionInput {
	s.Origin = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDistributionInput) SetTags(v []*Tag) *CreateDistributionInput {
	s.Tags = v
	return s
}

type CreateDistributionOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the distribution created.
	Distribution *LightsailDistribution `locationName:"distribution" type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s CreateDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDistributionOutput) GoString() string {
	return s.String()
}

// SetDistribution sets the Distribution field's value.
func (s *CreateDistributionOutput) SetDistribution(v *LightsailDistribution) *CreateDistributionOutput {
	s.Distribution = v
	return s
}

// SetOperation sets the Operation field's value.
func (s *CreateDistributionOutput) SetOperation(v *Operation) *CreateDistributionOutput {
	s.Operation = v
	return s
}

type CreateDomainEntryInput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the domain entry
	// request.
	//
	// DomainEntry is a required field
	DomainEntry *DomainEntry `locationName:"domainEntry" type:"structure" required:"true"`

	// The domain name (e.g., example.com) for which you want to create the domain
	// entry.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDomainEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainEntryInput"}
	if s.DomainEntry == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainEntry"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainEntry sets the DomainEntry field's value.
func (s *CreateDomainEntryInput) SetDomainEntry(v *DomainEntry) *CreateDomainEntryInput {
	s.DomainEntry = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainEntryInput) SetDomainName(v string) *CreateDomainEntryInput {
	s.DomainName = &v
	return s
}

type CreateDomainEntryOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s CreateDomainEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainEntryOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *CreateDomainEntryOutput) SetOperation(v *Operation) *CreateDomainEntryOutput {
	s.Operation = v
	return s
}

type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain name to manage (e.g., example.com).
	//
	// You cannot register a new domain name using Lightsail. You must register
	// a domain name using Amazon Route 53 or another domain name registrar. If
	// you have already registered your domain, you can enter its name in this parameter
	// to manage the DNS records for that domain using Lightsail.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`

	// The tag keys and optional values to add to the resource during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainInput) SetDomainName(v string) *CreateDomainInput {
	s.DomainName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDomainInput) SetTags(v []*Tag) *CreateDomainInput {
	s.Tags = v
	return s
}

type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *CreateDomainOutput) SetOperation(v *Operation) *CreateDomainOutput {
	s.Operation = v
	return s
}

type CreateInstanceSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The Lightsail instance on which to base your snapshot.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// The name for your new snapshot.
	//
	// InstanceSnapshotName is a required field
	InstanceSnapshotName *string `locationName:"instanceSnapshotName" type:"string" required:"true"`

	// The tag keys and optional values to add to the resource during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateInstanceSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstanceSnapshotInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.InstanceSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *CreateInstanceSnapshotInput) SetInstanceName(v string) *CreateInstanceSnapshotInput {
	s.InstanceName = &v
	return s
}

// SetInstanceSnapshotName sets the InstanceSnapshotName field's value.
func (s *CreateInstanceSnapshotInput) SetInstanceSnapshotName(v string) *CreateInstanceSnapshotInput {
	s.InstanceSnapshotName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateInstanceSnapshotInput) SetTags(v []*Tag) *CreateInstanceSnapshotInput {
	s.Tags = v
	return s
}

type CreateInstanceSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateInstanceSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateInstanceSnapshotOutput) SetOperations(v []*Operation) *CreateInstanceSnapshotOutput {
	s.Operations = v
	return s
}

type CreateInstancesFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// An array of objects representing the add-ons to enable for the new instance.
	AddOns []*AddOnRequest `locationName:"addOns" type:"list"`

	// An object containing information about one or more disk mappings.
	AttachedDiskMapping map[string][]*DiskMap `locationName:"attachedDiskMapping" type:"map"`

	// The Availability Zone where you want to create your instances. Use the following
	// formatting: us-east-2a (case sensitive). You can get a list of Availability
	// Zones by using the get regions (http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html)
	// operation. Be sure to add the include Availability Zones parameter to your
	// request.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// The bundle of specification information for your virtual private server (or
	// instance), including the pricing plan (e.g., micro_1_0).
	//
	// BundleId is a required field
	BundleId *string `locationName:"bundleId" type:"string" required:"true"`

	// The names for your new instances.
	//
	// InstanceNames is a required field
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The name of the instance snapshot on which you are basing your new instances.
	// Use the get instance snapshots operation to return information about your
	// existing snapshots.
	//
	// Constraint:
	//
	//    * This parameter cannot be defined together with the source instance name
	//    parameter. The instance snapshot name and source instance name parameters
	//    are mutually exclusive.
	InstanceSnapshotName *string `locationName:"instanceSnapshotName" type:"string"`

	// The IP address type for the instance.
	//
	// The possible values are ipv4 for IPv4 only, and dualstack for IPv4 and IPv6.
	//
	// The default value is dualstack.
	IpAddressType *string `locationName:"ipAddressType" type:"string" enum:"IpAddressType"`

	// The name for your key pair.
	KeyPairName *string `locationName:"keyPairName" type:"string"`

	// The date of the automatic snapshot to use for the new instance. Use the get
	// auto snapshots operation to identify the dates of the available automatic
	// snapshots.
	//
	// Constraints:
	//
	//    * Must be specified in YYYY-MM-DD format.
	//
	//    * This parameter cannot be defined together with the use latest restorable
	//    auto snapshot parameter. The restore date and use latest restorable auto
	//    snapshot parameters are mutually exclusive.
	//
	//    * Define this parameter only when creating a new instance from an automatic
	//    snapshot. For more information, see the Amazon Lightsail Developer Guide
	//    (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
	RestoreDate *string `locationName:"restoreDate" type:"string"`

	// The name of the source instance from which the source automatic snapshot
	// was created.
	//
	// Constraints:
	//
	//    * This parameter cannot be defined together with the instance snapshot
	//    name parameter. The source instance name and instance snapshot name parameters
	//    are mutually exclusive.
	//
	//    * Define this parameter only when creating a new instance from an automatic
	//    snapshot. For more information, see the Amazon Lightsail Developer Guide
	//    (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
	SourceInstanceName *string `locationName:"sourceInstanceName" type:"string"`

	// The tag keys and optional values to add to the resource during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`

	// A Boolean value to indicate whether to use the latest available automatic
	// snapshot.
	//
	// Constraints:
	//
	//    * This parameter cannot be defined together with the restore date parameter.
	//    The use latest restorable auto snapshot and restore date parameters are
	//    mutually exclusive.
	//
	//    * Define this parameter only when creating a new instance from an automatic
	//    snapshot. For more information, see the Amazon Lightsail Developer Guide
	//    (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
	UseLatestRestorableAutoSnapshot *bool `locationName:"useLatestRestorableAutoSnapshot" type:"boolean"`

	// You can create a launch script that configures a server with additional user
	// data. For example, apt-get -y update.
	//
	// Depending on the machine image you choose, the command to get software on
	// your instance varies. Amazon Linux and CentOS use yum, Debian and Ubuntu
	// use apt-get, and FreeBSD uses pkg. For a complete list, see the Amazon Lightsail
	// Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image).
	UserData *string `locationName:"userData" type:"string"`
}

// String returns the string representation
func (s CreateInstancesFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstancesFromSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstancesFromSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstancesFromSnapshotInput"}
	if s.AvailabilityZone == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZone"))
	}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.InstanceNames == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceNames"))
	}
	if s.AddOns != nil {
		for i, v := range s.AddOns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddOns", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddOns sets the AddOns field's value.
func (s *CreateInstancesFromSnapshotInput) SetAddOns(v []*AddOnRequest) *CreateInstancesFromSnapshotInput {
	s.AddOns = v
	return s
}

// SetAttachedDiskMapping sets the AttachedDiskMapping field's value.
func (s *CreateInstancesFromSnapshotInput) SetAttachedDiskMapping(v map[string][]*DiskMap) *CreateInstancesFromSnapshotInput {
	s.AttachedDiskMapping = v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateInstancesFromSnapshotInput) SetAvailabilityZone(v string) *CreateInstancesFromSnapshotInput {
	s.AvailabilityZone = &v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *CreateInstancesFromSnapshotInput) SetBundleId(v string) *CreateInstancesFromSnapshotInput {
	s.BundleId = &v
	return s
}

// SetInstanceNames sets the InstanceNames field's value.
func (s *CreateInstancesFromSnapshotInput) SetInstanceNames(v []*string) *CreateInstancesFromSnapshotInput {
	s.InstanceNames = v
	return s
}

// SetInstanceSnapshotName sets the InstanceSnapshotName field's value.
func (s *CreateInstancesFromSnapshotInput) SetInstanceSnapshotName(v string) *CreateInstancesFromSnapshotInput {
	s.InstanceSnapshotName = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *CreateInstancesFromSnapshotInput) SetIpAddressType(v string) *CreateInstancesFromSnapshotInput {
	s.IpAddressType = &v
	return s
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *CreateInstancesFromSnapshotInput) SetKeyPairName(v string) *CreateInstancesFromSnapshotInput {
	s.KeyPairName = &v
	return s
}

// SetRestoreDate sets the RestoreDate field's value.
func (s *CreateInstancesFromSnapshotInput) SetRestoreDate(v string) *CreateInstancesFromSnapshotInput {
	s.RestoreDate = &v
	return s
}

// SetSourceInstanceName sets the SourceInstanceName field's value.
func (s *CreateInstancesFromSnapshotInput) SetSourceInstanceName(v string) *CreateInstancesFromSnapshotInput {
	s.SourceInstanceName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateInstancesFromSnapshotInput) SetTags(v []*Tag) *CreateInstancesFromSnapshotInput {
	s.Tags = v
	return s
}

// SetUseLatestRestorableAutoSnapshot sets the UseLatestRestorableAutoSnapshot field's value.
func (s *CreateInstancesFromSnapshotInput) SetUseLatestRestorableAutoSnapshot(v bool) *CreateInstancesFromSnapshotInput {
	s.UseLatestRestorableAutoSnapshot = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *CreateInstancesFromSnapshotInput) SetUserData(v string) *CreateInstancesFromSnapshotInput {
	s.UserData = &v
	return s
}

type CreateInstancesFromSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateInstancesFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstancesFromSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateInstancesFromSnapshotOutput) SetOperations(v []*Operation) *CreateInstancesFromSnapshotOutput {
	s.Operations = v
	return s
}

type CreateInstancesInput struct {
	_ struct{} `type:"structure"`

	// An array of objects representing the add-ons to enable for the new instance.
	AddOns []*AddOnRequest `locationName:"addOns" type:"list"`

	// The Availability Zone in which to create your instance. Use the following
	// format: us-east-2a (case sensitive). You can get a list of Availability Zones
	// by using the get regions (http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html)
	// operation. Be sure to add the include Availability Zones parameter to your
	// request.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// The ID for a virtual private server image (e.g., app_wordpress_4_4 or app_lamp_7_0).
	// Use the get blueprints operation to return a list of available images (or
	// blueprints).
	//
	// Use active blueprints when creating new instances. Inactive blueprints are
	// listed to support customers with existing instances and are not necessarily
	// available to create new instances. Blueprints are marked inactive when they
	// become outdated due to operating system updates or new application releases.
	//
	// BlueprintId is a required field
	BlueprintId *string `locationName:"blueprintId" type:"string" required:"true"`

	// The bundle of specification information for your virtual private server (or
	// instance), including the pricing plan (e.g., micro_1_0).
	//
	// BundleId is a required field
	BundleId *string `locationName:"bundleId" type:"string" required:"true"`

	// (Deprecated) The name for your custom image.
	//
	// In releases prior to June 12, 2017, this parameter was ignored by the API.
	// It is now deprecated.
	//
	// Deprecated: CustomImageName has been deprecated
	CustomImageName *string `locationName:"customImageName" deprecated:"true" type:"string"`

	// The names to use for your new Lightsail instances. Separate multiple values
	// using quotation marks and commas, for example: ["MyFirstInstance","MySecondInstance"]
	//
	// InstanceNames is a required field
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The IP address type for the instance.
	//
	// The possible values are ipv4 for IPv4 only, and dualstack for IPv4 and IPv6.
	//
	// The default value is dualstack.
	IpAddressType *string `locationName:"ipAddressType" type:"string" enum:"IpAddressType"`

	// The name of your key pair.
	KeyPairName *string `locationName:"keyPairName" type:"string"`

	// The tag keys and optional values to add to the resource during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`

	// A launch script you can create that configures a server with additional user
	// data. For example, you might want to run apt-get -y update.
	//
	// Depending on the machine image you choose, the command to get software on
	// your instance varies. Amazon Linux and CentOS use yum, Debian and Ubuntu
	// use apt-get, and FreeBSD uses pkg. For a complete list, see the Amazon Lightsail
	// Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image).
	UserData *string `locationName:"userData" type:"string"`
}

// String returns the string representation
func (s CreateInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstancesInput"}
	if s.AvailabilityZone == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZone"))
	}
	if s.BlueprintId == nil {
		invalidParams.Add(request.NewErrParamRequired("BlueprintId"))
	}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.InstanceNames == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceNames"))
	}
	if s.AddOns != nil {
		for i, v := range s.AddOns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddOns", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddOns sets the AddOns field's value.
func (s *CreateInstancesInput) SetAddOns(v []*AddOnRequest) *CreateInstancesInput {
	s.AddOns = v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateInstancesInput) SetAvailabilityZone(v string) *CreateInstancesInput {
	s.AvailabilityZone = &v
	return s
}

// SetBlueprintId sets the BlueprintId field's value.
func (s *CreateInstancesInput) SetBlueprintId(v string) *CreateInstancesInput {
	s.BlueprintId = &v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *CreateInstancesInput) SetBundleId(v string) *CreateInstancesInput {
	s.BundleId = &v
	return s
}

// SetCustomImageName sets the CustomImageName field's value.
func (s *CreateInstancesInput) SetCustomImageName(v string) *CreateInstancesInput {
	s.CustomImageName = &v
	return s
}

// SetInstanceNames sets the InstanceNames field's value.
func (s *CreateInstancesInput) SetInstanceNames(v []*string) *CreateInstancesInput {
	s.InstanceNames = v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *CreateInstancesInput) SetIpAddressType(v string) *CreateInstancesInput {
	s.IpAddressType = &v
	return s
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *CreateInstancesInput) SetKeyPairName(v string) *CreateInstancesInput {
	s.KeyPairName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateInstancesInput) SetTags(v []*Tag) *CreateInstancesInput {
	s.Tags = v
	return s
}

// SetUserData sets the UserData field's value.
func (s *CreateInstancesInput) SetUserData(v string) *CreateInstancesInput {
	s.UserData = &v
	return s
}

type CreateInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstancesOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateInstancesOutput) SetOperations(v []*Operation) *CreateInstancesOutput {
	s.Operations = v
	return s
}

type CreateKeyPairInput struct {
	_ struct{} `type:"structure"`

	// The name for your new key pair.
	//
	// KeyPairName is a required field
	KeyPairName *string `locationName:"keyPairName" type:"string" required:"true"`

	// The tag keys and optional values to add to the resource during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKeyPairInput"}
	if s.KeyPairName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyPairName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *CreateKeyPairInput) SetKeyPairName(v string) *CreateKeyPairInput {
	s.KeyPairName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKeyPairInput) SetTags(v []*Tag) *CreateKeyPairInput {
	s.Tags = v
	return s
}

type CreateKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the new key pair
	// you just created.
	KeyPair *KeyPair `locationName:"keyPair" type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operation *Operation `locationName:"operation" type:"structure"`

	// A base64-encoded RSA private key.
	PrivateKeyBase64 *string `locationName:"privateKeyBase64" type:"string"`

	// A base64-encoded public key of the ssh-rsa type.
	PublicKeyBase64 *string `locationName:"publicKeyBase64" type:"string"`
}

// String returns the string representation
func (s CreateKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyPairOutput) GoString() string {
	return s.String()
}

// SetKeyPair sets the KeyPair field's value.
func (s *CreateKeyPairOutput) SetKeyPair(v *KeyPair) *CreateKeyPairOutput {
	s.KeyPair = v
	return s
}

// SetOperation sets the Operation field's value.
func (s *CreateKeyPairOutput) SetOperation(v *Operation) *CreateKeyPairOutput {
	s.Operation = v
	return s
}

// SetPrivateKeyBase64 sets the PrivateKeyBase64 field's value.
func (s *CreateKeyPairOutput) SetPrivateKeyBase64(v string) *CreateKeyPairOutput {
	s.PrivateKeyBase64 = &v
	return s
}

// SetPublicKeyBase64 sets the PublicKeyBase64 field's value.
func (s *CreateKeyPairOutput) SetPublicKeyBase64(v string) *CreateKeyPairOutput {
	s.PublicKeyBase64 = &v
	return s
}

type CreateLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The optional alternative domains and subdomains to use with your SSL/TLS
	// certificate (e.g., www.example.com, example.com, m.example.com, blog.example.com).
	CertificateAlternativeNames []*string `locationName:"certificateAlternativeNames" type:"list"`

	// The domain name with which your certificate is associated (e.g., example.com).
	//
	// If you specify certificateDomainName, then certificateName is required (and
	// vice-versa).
	CertificateDomainName *string `locationName:"certificateDomainName" type:"string"`

	// The name of the SSL/TLS certificate.
	//
	// If you specify certificateName, then certificateDomainName is required (and
	// vice-versa).
	CertificateName *string `locationName:"certificateName" type:"string"`

	// The path you provided to perform the load balancer health check. If you didn't
	// specify a health check path, Lightsail uses the root path of your website
	// (e.g., "/").
	//
	// You may want to specify a custom health check path other than the root of
	// your application if your home page loads slowly or has a lot of media or
	// scripting on it.
	HealthCheckPath *string `locationName:"healthCheckPath" type:"string"`

	// The instance port where you're creating your load balancer.
	//
	// InstancePort is a required field
	InstancePort *int64 `locationName:"instancePort" type:"integer" required:"true"`

	// The IP address type for the load balancer.
	//
	// The possible values are ipv4 for IPv4 only, and dualstack for IPv4 and IPv6.
	//
	// The default value is dualstack.
	IpAddressType *string `locationName:"ipAddressType" type:"string" enum:"IpAddressType"`

	// The name of your load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`

	// The tag keys and optional values to add to the resource during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLoadBalancerInput"}
	if s.InstancePort == nil {
		invalidParams.Add(request.NewErrParamRequired("InstancePort"))
	}
	if s.InstancePort != nil && *s.InstancePort < -1 {
		invalidParams.Add(request.NewErrParamMinValue("InstancePort", -1))
	}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAlternativeNames sets the CertificateAlternativeNames field's value.
func (s *CreateLoadBalancerInput) SetCertificateAlternativeNames(v []*string) *CreateLoadBalancerInput {
	s.CertificateAlternativeNames = v
	return s
}

// SetCertificateDomainName sets the CertificateDomainName field's value.
func (s *CreateLoadBalancerInput) SetCertificateDomainName(v string) *CreateLoadBalancerInput {
	s.CertificateDomainName = &v
	return s
}

// SetCertificateName sets the CertificateName field's value.
func (s *CreateLoadBalancerInput) SetCertificateName(v string) *CreateLoadBalancerInput {
	s.CertificateName = &v
	return s
}

// SetHealthCheckPath sets the HealthCheckPath field's value.
func (s *CreateLoadBalancerInput) SetHealthCheckPath(v string) *CreateLoadBalancerInput {
	s.HealthCheckPath = &v
	return s
}

// SetInstancePort sets the InstancePort field's value.
func (s *CreateLoadBalancerInput) SetInstancePort(v int64) *CreateLoadBalancerInput {
	s.InstancePort = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *CreateLoadBalancerInput) SetIpAddressType(v string) *CreateLoadBalancerInput {
	s.IpAddressType = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *CreateLoadBalancerInput) SetLoadBalancerName(v string) *CreateLoadBalancerInput {
	s.LoadBalancerName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLoadBalancerInput) SetTags(v []*Tag) *CreateLoadBalancerInput {
	s.Tags = v
	return s
}

type CreateLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateLoadBalancerOutput) SetOperations(v []*Operation) *CreateLoadBalancerOutput {
	s.Operations = v
	return s
}

type CreateLoadBalancerTlsCertificateInput struct {
	_ struct{} `type:"structure"`

	// An array of strings listing alternative domains and subdomains for your SSL/TLS
	// certificate. Lightsail will de-dupe the names for you. You can have a maximum
	// of 9 alternative names (in addition to the 1 primary domain). We do not support
	// wildcards (e.g., *.example.com).
	CertificateAlternativeNames []*string `locationName:"certificateAlternativeNames" type:"list"`

	// The domain name (e.g., example.com) for your SSL/TLS certificate.
	//
	// CertificateDomainName is a required field
	CertificateDomainName *string `locationName:"certificateDomainName" type:"string" required:"true"`

	// The SSL/TLS certificate name.
	//
	// You can have up to 10 certificates in your account at one time. Each Lightsail
	// load balancer can have up to 2 certificates associated with it at one time.
	// There is also an overall limit to the number of certificates that can be
	// issue in a 365-day period. For more information, see Limits (http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html).
	//
	// CertificateName is a required field
	CertificateName *string `locationName:"certificateName" type:"string" required:"true"`

	// The load balancer name where you want to create the SSL/TLS certificate.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`

	// The tag keys and optional values to add to the resource during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateLoadBalancerTlsCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerTlsCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLoadBalancerTlsCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLoadBalancerTlsCertificateInput"}
	if s.CertificateDomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateDomainName"))
	}
	if s.CertificateName == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateName"))
	}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAlternativeNames sets the CertificateAlternativeNames field's value.
func (s *CreateLoadBalancerTlsCertificateInput) SetCertificateAlternativeNames(v []*string) *CreateLoadBalancerTlsCertificateInput {
	s.CertificateAlternativeNames = v
	return s
}

// SetCertificateDomainName sets the CertificateDomainName field's value.
func (s *CreateLoadBalancerTlsCertificateInput) SetCertificateDomainName(v string) *CreateLoadBalancerTlsCertificateInput {
	s.CertificateDomainName = &v
	return s
}

// SetCertificateName sets the CertificateName field's value.
func (s *CreateLoadBalancerTlsCertificateInput) SetCertificateName(v string) *CreateLoadBalancerTlsCertificateInput {
	s.CertificateName = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *CreateLoadBalancerTlsCertificateInput) SetLoadBalancerName(v string) *CreateLoadBalancerTlsCertificateInput {
	s.LoadBalancerName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLoadBalancerTlsCertificateInput) SetTags(v []*Tag) *CreateLoadBalancerTlsCertificateInput {
	s.Tags = v
	return s
}

type CreateLoadBalancerTlsCertificateOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateLoadBalancerTlsCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerTlsCertificateOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateLoadBalancerTlsCertificateOutput) SetOperations(v []*Operation) *CreateLoadBalancerTlsCertificateOutput {
	s.Operations = v
	return s
}

type CreateRelationalDatabaseFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which to create your new database. Use the us-east-2a
	// case-sensitive format.
	//
	// You can get a list of Availability Zones by using the get regions operation.
	// Be sure to add the include relational database Availability Zones parameter
	// to your request.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// Specifies the accessibility options for your new database. A value of true
	// specifies a database that is available to resources outside of your Lightsail
	// account. A value of false specifies a database that is available only to
	// your Lightsail resources in the same region as your database.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// The bundle ID for your new database. A bundle describes the performance specifications
	// for your database.
	//
	// You can get a list of database bundle IDs by using the get relational database
	// bundles operation.
	//
	// When creating a new database from a snapshot, you cannot choose a bundle
	// that is smaller than the bundle of the source database.
	RelationalDatabaseBundleId *string `locationName:"relationalDatabaseBundleId" type:"string"`

	// The name to use for your new Lightsail database resource.
	//
	// Constraints:
	//
	//    * Must contain from 2 to 255 alphanumeric characters, or hyphens.
	//
	//    * The first and last character must be a letter or number.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`

	// The name of the database snapshot from which to create your new database.
	RelationalDatabaseSnapshotName *string `locationName:"relationalDatabaseSnapshotName" type:"string"`

	// The date and time to restore your database from.
	//
	// Constraints:
	//
	//    * Must be before the latest restorable time for the database.
	//
	//    * Cannot be specified if the use latest restorable time parameter is true.
	//
	//    * Specified in Coordinated Universal Time (UTC).
	//
	//    * Specified in the Unix time format. For example, if you wish to use a
	//    restore time of October 1, 2018, at 8 PM UTC, then you input 1538424000
	//    as the restore time.
	RestoreTime *time.Time `locationName:"restoreTime" type:"timestamp"`

	// The name of the source database.
	SourceRelationalDatabaseName *string `locationName:"sourceRelationalDatabaseName" type:"string"`

	// The tag keys and optional values to add to the resource during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`

	// Specifies whether your database is restored from the latest backup time.
	// A value of true restores from the latest backup time.
	//
	// Default: false
	//
	// Constraints: Cannot be specified if the restore time parameter is provided.
	UseLatestRestorableTime *bool `locationName:"useLatestRestorableTime" type:"boolean"`
}

// String returns the string representation
func (s CreateRelationalDatabaseFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRelationalDatabaseFromSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRelationalDatabaseFromSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRelationalDatabaseFromSnapshotInput"}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetAvailabilityZone(v string) *CreateRelationalDatabaseFromSnapshotInput {
	s.AvailabilityZone = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetPubliclyAccessible(v bool) *CreateRelationalDatabaseFromSnapshotInput {
	s.PubliclyAccessible = &v
	return s
}

// SetRelationalDatabaseBundleId sets the RelationalDatabaseBundleId field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetRelationalDatabaseBundleId(v string) *CreateRelationalDatabaseFromSnapshotInput {
	s.RelationalDatabaseBundleId = &v
	return s
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetRelationalDatabaseName(v string) *CreateRelationalDatabaseFromSnapshotInput {
	s.RelationalDatabaseName = &v
	return s
}

// SetRelationalDatabaseSnapshotName sets the RelationalDatabaseSnapshotName field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetRelationalDatabaseSnapshotName(v string) *CreateRelationalDatabaseFromSnapshotInput {
	s.RelationalDatabaseSnapshotName = &v
	return s
}

// SetRestoreTime sets the RestoreTime field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetRestoreTime(v time.Time) *CreateRelationalDatabaseFromSnapshotInput {
	s.RestoreTime = &v
	return s
}

// SetSourceRelationalDatabaseName sets the SourceRelationalDatabaseName field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetSourceRelationalDatabaseName(v string) *CreateRelationalDatabaseFromSnapshotInput {
	s.SourceRelationalDatabaseName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetTags(v []*Tag) *CreateRelationalDatabaseFromSnapshotInput {
	s.Tags = v
	return s
}

// SetUseLatestRestorableTime sets the UseLatestRestorableTime field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetUseLatestRestorableTime(v bool) *CreateRelationalDatabaseFromSnapshotInput {
	s.UseLatestRestorableTime = &v
	return s
}

type CreateRelationalDatabaseFromSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateRelationalDatabaseFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRelationalDatabaseFromSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateRelationalDatabaseFromSnapshotOutput) SetOperations(v []*Operation) *CreateRelationalDatabaseFromSnapshotOutput {
	s.Operations = v
	return s
}

type CreateRelationalDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which to create your new database. Use the us-east-2a
	// case-sensitive format.
	//
	// You can get a list of Availability Zones by using the get regions operation.
	// Be sure to add the include relational database Availability Zones parameter
	// to your request.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The meaning of this parameter differs according to the database engine you
	// use.
	//
	// MySQL
	//
	// The name of the database to create when the Lightsail database resource is
	// created. If this parameter isn't specified, no database is created in the
	// database resource.
	//
	// Constraints:
	//
	//    * Must contain 1 to 64 letters or numbers.
	//
	//    * Must begin with a letter. Subsequent characters can be letters, underscores,
	//    or digits (0- 9).
	//
	//    * Can't be a word reserved by the specified database engine. For more
	//    information about reserved words in MySQL, see the Keywords and Reserved
	//    Words articles for MySQL 5.6 (https://dev.mysql.com/doc/refman/5.6/en/keywords.html),
	//    MySQL 5.7 (https://dev.mysql.com/doc/refman/5.7/en/keywords.html), and
	//    MySQL 8.0 (https://dev.mysql.com/doc/refman/8.0/en/keywords.html).
	//
	// PostgreSQL
	//
	// The name of the database to create when the Lightsail database resource is
	// created. If this parameter isn't specified, a database named postgres is
	// created in the database resource.
	//
	// Constraints:
	//
	//    * Must contain 1 to 63 letters or numbers.
	//
	//    * Must begin with a letter. Subsequent characters can be letters, underscores,
	//    or digits (0- 9).
	//
	//    * Can't be a word reserved by the specified database engine. For more
	//    information about reserved words in PostgreSQL, see the SQL Key Words
	//    articles for PostgreSQL 9.6 (https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html),
	//    PostgreSQL 10 (https://www.postgresql.org/docs/10/sql-keywords-appendix.html),
	//    PostgreSQL 11 (https://www.postgresql.org/docs/11/sql-keywords-appendix.html),
	//    and PostgreSQL 12 (https://www.postgresql.org/docs/12/sql-keywords-appendix.html).
	//
	// MasterDatabaseName is a required field
	MasterDatabaseName *string `locationName:"masterDatabaseName" type:"string" required:"true"`

	// The password for the master user. The password can include any printable
	// ASCII character except "/", """, or "@". It cannot contain spaces.
	//
	// MySQL
	//
	// Constraints: Must contain from 8 to 41 characters.
	//
	// PostgreSQL
	//
	// Constraints: Must contain from 8 to 128 characters.
	MasterUserPassword *string `locationName:"masterUserPassword" type:"string" sensitive:"true"`

	// The name for the master user.
	//
	// MySQL
	//
	// Constraints:
	//
	//    * Required for MySQL.
	//
	//    * Must be 1 to 16 letters or numbers. Can contain underscores.
	//
	//    * First character must be a letter.
	//
	//    * Can't be a reserved word for the chosen database engine. For more information
	//    about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved
	//    Words articles for MySQL 5.6 (https://dev.mysql.com/doc/refman/5.6/en/keywords.html),
	//    MySQL 5.7 (https://dev.mysql.com/doc/refman/5.7/en/keywords.html), or
	//    MySQL 8.0 (https://dev.mysql.com/doc/refman/8.0/en/keywords.html).
	//
	// PostgreSQL
	//
	// Constraints:
	//
	//    * Required for PostgreSQL.
	//
	//    * Must be 1 to 63 letters or numbers. Can contain underscores.
	//
	//    * First character must be a letter.
	//
	//    * Can't be a reserved word for the chosen database engine. For more information
	//    about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved
	//    Words articles for PostgreSQL 9.6 (https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html),
	//    PostgreSQL 10 (https://www.postgresql.org/docs/10/sql-keywords-appendix.html),
	//    PostgreSQL 11 (https://www.postgresql.org/docs/11/sql-keywords-appendix.html),
	//    and PostgreSQL 12 (https://www.postgresql.org/docs/12/sql-keywords-appendix.html).
	//
	// MasterUsername is a required field
	MasterUsername *string `locationName:"masterUsername" type:"string" required:"true"`

	// The daily time range during which automated backups are created for your
	// new database if automated backups are enabled.
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region. For more information about the preferred backup
	// window time blocks for each region, see the Working With Backups (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow)
	// guide in the Amazon Relational Database Service (Amazon RDS) documentation.
	//
	// Constraints:
	//
	//    * Must be in the hh24:mi-hh24:mi format. Example: 16:00-16:30
	//
	//    * Specified in Coordinated Universal Time (UTC).
	//
	//    * Must not conflict with the preferred maintenance window.
	//
	//    * Must be at least 30 minutes.
	PreferredBackupWindow *string `locationName:"preferredBackupWindow" type:"string"`

	// The weekly time range during which system maintenance can occur on your new
	// database.
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region, occurring on a random day of the week.
	//
	// Constraints:
	//
	//    * Must be in the ddd:hh24:mi-ddd:hh24:mi format.
	//
	//    * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
	//
	//    * Must be at least 30 minutes.
	//
	//    * Specified in Coordinated Universal Time (UTC).
	//
	//    * Example: Tue:17:00-Tue:17:30
	PreferredMaintenanceWindow *string `locationName:"preferredMaintenanceWindow" type:"string"`

	// Specifies the accessibility options for your new database. A value of true
	// specifies a database that is available to resources outside of your Lightsail
	// account. A value of false specifies a database that is available only to
	// your Lightsail resources in the same region as your database.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// The blueprint ID for your new database. A blueprint describes the major engine
	// version of a database.
	//
	// You can get a list of database blueprints IDs by using the get relational
	// database blueprints operation.
	//
	// RelationalDatabaseBlueprintId is a required field
	RelationalDatabaseBlueprintId *string `locationName:"relationalDatabaseBlueprintId" type:"string" required:"true"`

	// The bundle ID for your new database. A bundle describes the performance specifications
	// for your database.
	//
	// You can get a list of database bundle IDs by using the get relational database
	// bundles operation.
	//
	// RelationalDatabaseBundleId is a required field
	RelationalDatabaseBundleId *string `locationName:"relationalDatabaseBundleId" type:"string" required:"true"`

	// The name to use for your new Lightsail database resource.
	//
	// Constraints:
	//
	//    * Must contain from 2 to 255 alphanumeric characters, or hyphens.
	//
	//    * The first and last character must be a letter or number.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`

	// The tag keys and optional values to add to the resource during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateRelationalDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRelationalDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRelationalDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRelationalDatabaseInput"}
	if s.MasterDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterDatabaseName"))
	}
	if s.MasterUsername == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterUsername"))
	}
	if s.RelationalDatabaseBlueprintId == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseBlueprintId"))
	}
	if s.RelationalDatabaseBundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseBundleId"))
	}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateRelationalDatabaseInput) SetAvailabilityZone(v string) *CreateRelationalDatabaseInput {
	s.AvailabilityZone = &v
	return s
}

// SetMasterDatabaseName sets the MasterDatabaseName field's value.
func (s *CreateRelationalDatabaseInput) SetMasterDatabaseName(v string) *CreateRelationalDatabaseInput {
	s.MasterDatabaseName = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *CreateRelationalDatabaseInput) SetMasterUserPassword(v string) *CreateRelationalDatabaseInput {
	s.MasterUserPassword = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *CreateRelationalDatabaseInput) SetMasterUsername(v string) *CreateRelationalDatabaseInput {
	s.MasterUsername = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *CreateRelationalDatabaseInput) SetPreferredBackupWindow(v string) *CreateRelationalDatabaseInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateRelationalDatabaseInput) SetPreferredMaintenanceWindow(v string) *CreateRelationalDatabaseInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateRelationalDatabaseInput) SetPubliclyAccessible(v bool) *CreateRelationalDatabaseInput {
	s.PubliclyAccessible = &v
	return s
}

// SetRelationalDatabaseBlueprintId sets the RelationalDatabaseBlueprintId field's value.
func (s *CreateRelationalDatabaseInput) SetRelationalDatabaseBlueprintId(v string) *CreateRelationalDatabaseInput {
	s.RelationalDatabaseBlueprintId = &v
	return s
}

// SetRelationalDatabaseBundleId sets the RelationalDatabaseBundleId field's value.
func (s *CreateRelationalDatabaseInput) SetRelationalDatabaseBundleId(v string) *CreateRelationalDatabaseInput {
	s.RelationalDatabaseBundleId = &v
	return s
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *CreateRelationalDatabaseInput) SetRelationalDatabaseName(v string) *CreateRelationalDatabaseInput {
	s.RelationalDatabaseName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRelationalDatabaseInput) SetTags(v []*Tag) *CreateRelationalDatabaseInput {
	s.Tags = v
	return s
}

type CreateRelationalDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateRelationalDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRelationalDatabaseOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateRelationalDatabaseOutput) SetOperations(v []*Operation) *CreateRelationalDatabaseOutput {
	s.Operations = v
	return s
}

type CreateRelationalDatabaseSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the database on which to base your new snapshot.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`

	// The name for your new database snapshot.
	//
	// Constraints:
	//
	//    * Must contain from 2 to 255 alphanumeric characters, or hyphens.
	//
	//    * The first and last character must be a letter or number.
	//
	// RelationalDatabaseSnapshotName is a required field
	RelationalDatabaseSnapshotName *string `locationName:"relationalDatabaseSnapshotName" type:"string" required:"true"`

	// The tag keys and optional values to add to the resource during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateRelationalDatabaseSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRelationalDatabaseSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRelationalDatabaseSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRelationalDatabaseSnapshotInput"}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}
	if s.RelationalDatabaseSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *CreateRelationalDatabaseSnapshotInput) SetRelationalDatabaseName(v string) *CreateRelationalDatabaseSnapshotInput {
	s.RelationalDatabaseName = &v
	return s
}

// SetRelationalDatabaseSnapshotName sets the RelationalDatabaseSnapshotName field's value.
func (s *CreateRelationalDatabaseSnapshotInput) SetRelationalDatabaseSnapshotName(v string) *CreateRelationalDatabaseSnapshotInput {
	s.RelationalDatabaseSnapshotName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRelationalDatabaseSnapshotInput) SetTags(v []*Tag) *CreateRelationalDatabaseSnapshotInput {
	s.Tags = v
	return s
}

type CreateRelationalDatabaseSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateRelationalDatabaseSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRelationalDatabaseSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateRelationalDatabaseSnapshotOutput) SetOperations(v []*Operation) *CreateRelationalDatabaseSnapshotOutput {
	s.Operations = v
	return s
}

type DeleteAlarmInput struct {
	_ struct{} `type:"structure"`

	// The name of the alarm to delete.
	//
	// AlarmName is a required field
	AlarmName *string `locationName:"alarmName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAlarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAlarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAlarmInput"}
	if s.AlarmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmName sets the AlarmName field's value.
func (s *DeleteAlarmInput) SetAlarmName(v string) *DeleteAlarmInput {
	s.AlarmName = &v
	return s
}

type DeleteAlarmOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAlarmOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteAlarmOutput) SetOperations(v []*Operation) *DeleteAlarmOutput {
	s.Operations = v
	return s
}

type DeleteAutoSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The date of the automatic snapshot to delete in YYYY-MM-DD format. Use the
	// get auto snapshots operation to get the available automatic snapshots for
	// a resource.
	//
	// Date is a required field
	Date *string `locationName:"date" type:"string" required:"true"`

	// The name of the source instance or disk from which to delete the automatic
	// snapshot.
	//
	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAutoSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAutoSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAutoSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAutoSnapshotInput"}
	if s.Date == nil {
		invalidParams.Add(request.NewErrParamRequired("Date"))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDate sets the Date field's value.
func (s *DeleteAutoSnapshotInput) SetDate(v string) *DeleteAutoSnapshotInput {
	s.Date = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *DeleteAutoSnapshotInput) SetResourceName(v string) *DeleteAutoSnapshotInput {
	s.ResourceName = &v
	return s
}

type DeleteAutoSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteAutoSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAutoSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteAutoSnapshotOutput) SetOperations(v []*Operation) *DeleteAutoSnapshotOutput {
	s.Operations = v
	return s
}

type DeleteBucketAccessKeyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the access key to delete.
	//
	// Use the GetBucketAccessKeys action to get a list of access key IDs that you
	// can specify.
	//
	// AccessKeyId is a required field
	AccessKeyId *string `locationName:"accessKeyId" type:"string" required:"true"`

	// The name of the bucket that the access key belongs to.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketAccessKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketAccessKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketAccessKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketAccessKeyInput"}
	if s.AccessKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessKeyId"))
	}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *DeleteBucketAccessKeyInput) SetAccessKeyId(v string) *DeleteBucketAccessKeyInput {
	s.AccessKeyId = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *DeleteBucketAccessKeyInput) SetBucketName(v string) *DeleteBucketAccessKeyInput {
	s.BucketName = &v
	return s
}

type DeleteBucketAccessKeyOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteBucketAccessKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketAccessKeyOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteBucketAccessKeyOutput) SetOperations(v []*Operation) *DeleteBucketAccessKeyOutput {
	s.Operations = v
	return s
}

type DeleteBucketInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket to delete.
	//
	// Use the GetBuckets action to get a list of bucket names that you can specify.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`

	// A Boolean value that indicates whether to force delete the bucket.
	//
	// You must force delete the bucket if it has one of the following conditions:
	//
	//    * The bucket is the origin of a distribution.
	//
	//    * The bucket has instances that were granted access to it using the SetResourceAccessForBucket
	//    action.
	//
	//    * The bucket has objects.
	//
	//    * The bucket has access keys.
	//
	// Force deleting a bucket might impact other resources that rely on the bucket,
	// such as instances, distributions, or software that use the issued access
	// keys.
	ForceDelete *bool `locationName:"forceDelete" type:"boolean"`
}

// String returns the string representation
func (s DeleteBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketInput"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *DeleteBucketInput) SetBucketName(v string) *DeleteBucketInput {
	s.BucketName = &v
	return s
}

// SetForceDelete sets the ForceDelete field's value.
func (s *DeleteBucketInput) SetForceDelete(v bool) *DeleteBucketInput {
	s.ForceDelete = &v
	return s
}

type DeleteBucketOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteBucketOutput) SetOperations(v []*Operation) *DeleteBucketOutput {
	s.Operations = v
	return s
}

type DeleteCertificateInput struct {
	_ struct{} `type:"structure"`

	// The name of the certificate to delete.
	//
	// Use the GetCertificates action to get a list of certificate names that you
	// can specify.
	//
	// CertificateName is a required field
	CertificateName *string `locationName:"certificateName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCertificateInput"}
	if s.CertificateName == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateName sets the CertificateName field's value.
func (s *DeleteCertificateInput) SetCertificateName(v string) *DeleteCertificateInput {
	s.CertificateName = &v
	return s
}

type DeleteCertificateOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteCertificateOutput) SetOperations(v []*Operation) *DeleteCertificateOutput {
	s.Operations = v
	return s
}

type DeleteContactMethodInput struct {
	_ struct{} `type:"structure"`

	// The protocol that will be deleted, such as Email or SMS (text messaging).
	//
	// To delete an Email and an SMS contact method if you added both, you must
	// run separate DeleteContactMethod actions to delete each protocol.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"ContactProtocol"`
}

// String returns the string representation
func (s DeleteContactMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteContactMethodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContactMethodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteContactMethodInput"}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProtocol sets the Protocol field's value.
func (s *DeleteContactMethodInput) SetProtocol(v string) *DeleteContactMethodInput {
	s.Protocol = &v
	return s
}

type DeleteContactMethodOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteContactMethodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteContactMethodOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteContactMethodOutput) SetOperations(v []*Operation) *DeleteContactMethodOutput {
	s.Operations = v
	return s
}

type DeleteContainerImageInput struct {
	_ struct{} `type:"structure"`

	// The name of the container image to delete from the container service.
	//
	// Use the GetContainerImages action to get the name of the container images
	// that are registered to a container service.
	//
	// Container images sourced from your Lightsail container service, that are
	// registered and stored on your service, start with a colon (:). For example,
	// :container-service-1.mystaticwebsite.1. Container images sourced from a public
	// registry like Docker Hub don't start with a colon. For example, nginx:latest
	// or nginx.
	//
	// Image is a required field
	Image *string `locationName:"image" type:"string" required:"true"`

	// The name of the container service for which to delete a registered container
	// image.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteContainerImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteContainerImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContainerImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteContainerImageInput"}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImage sets the Image field's value.
func (s *DeleteContainerImageInput) SetImage(v string) *DeleteContainerImageInput {
	s.Image = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *DeleteContainerImageInput) SetServiceName(v string) *DeleteContainerImageInput {
	s.ServiceName = &v
	return s
}

type DeleteContainerImageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteContainerImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteContainerImageOutput) GoString() string {
	return s.String()
}

type DeleteContainerServiceInput struct {
	_ struct{} `type:"structure"`

	// The name of the container service to delete.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteContainerServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteContainerServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContainerServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteContainerServiceInput"}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceName sets the ServiceName field's value.
func (s *DeleteContainerServiceInput) SetServiceName(v string) *DeleteContainerServiceInput {
	s.ServiceName = &v
	return s
}

type DeleteContainerServiceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteContainerServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteContainerServiceOutput) GoString() string {
	return s.String()
}

type DeleteDiskInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the disk you want to delete (e.g., my-disk).
	//
	// DiskName is a required field
	DiskName *string `locationName:"diskName" type:"string" required:"true"`

	// A Boolean value to indicate whether to delete the enabled add-ons for the
	// disk.
	ForceDeleteAddOns *bool `locationName:"forceDeleteAddOns" type:"boolean"`
}

// String returns the string representation
func (s DeleteDiskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDiskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDiskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDiskInput"}
	if s.DiskName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskName sets the DiskName field's value.
func (s *DeleteDiskInput) SetDiskName(v string) *DeleteDiskInput {
	s.DiskName = &v
	return s
}

// SetForceDeleteAddOns sets the ForceDeleteAddOns field's value.
func (s *DeleteDiskInput) SetForceDeleteAddOns(v bool) *DeleteDiskInput {
	s.ForceDeleteAddOns = &v
	return s
}

type DeleteDiskOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteDiskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDiskOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteDiskOutput) SetOperations(v []*Operation) *DeleteDiskOutput {
	s.Operations = v
	return s
}

type DeleteDiskSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the disk snapshot you want to delete (e.g., my-disk-snapshot).
	//
	// DiskSnapshotName is a required field
	DiskSnapshotName *string `locationName:"diskSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDiskSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDiskSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDiskSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDiskSnapshotInput"}
	if s.DiskSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskSnapshotName sets the DiskSnapshotName field's value.
func (s *DeleteDiskSnapshotInput) SetDiskSnapshotName(v string) *DeleteDiskSnapshotInput {
	s.DiskSnapshotName = &v
	return s
}

type DeleteDiskSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteDiskSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDiskSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteDiskSnapshotOutput) SetOperations(v []*Operation) *DeleteDiskSnapshotOutput {
	s.Operations = v
	return s
}

type DeleteDistributionInput struct {
	_ struct{} `type:"structure"`

	// The name of the distribution to delete.
	//
	// Use the GetDistributions action to get a list of distribution names that
	// you can specify.
	DistributionName *string `locationName:"distributionName" type:"string"`
}

// String returns the string representation
func (s DeleteDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDistributionInput) GoString() string {
	return s.String()
}

// SetDistributionName sets the DistributionName field's value.
func (s *DeleteDistributionInput) SetDistributionName(v string) *DeleteDistributionInput {
	s.DistributionName = &v
	return s
}

type DeleteDistributionOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the result of the action, such as the status of
	// the request, the timestamp of the request, and the resources affected by
	// the request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s DeleteDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDistributionOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *DeleteDistributionOutput) SetOperation(v *Operation) *DeleteDistributionOutput {
	s.Operation = v
	return s
}

type DeleteDomainEntryInput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about your domain entries.
	//
	// DomainEntry is a required field
	DomainEntry *DomainEntry `locationName:"domainEntry" type:"structure" required:"true"`

	// The name of the domain entry to delete.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainEntryInput"}
	if s.DomainEntry == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainEntry"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainEntry sets the DomainEntry field's value.
func (s *DeleteDomainEntryInput) SetDomainEntry(v *DomainEntry) *DeleteDomainEntryInput {
	s.DomainEntry = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteDomainEntryInput) SetDomainName(v string) *DeleteDomainEntryInput {
	s.DomainName = &v
	return s
}

type DeleteDomainEntryOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s DeleteDomainEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainEntryOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *DeleteDomainEntryOutput) SetOperation(v *Operation) *DeleteDomainEntryOutput {
	s.Operation = v
	return s
}

type DeleteDomainInput struct {
	_ struct{} `type:"structure"`

	// The specific domain name to delete.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteDomainInput) SetDomainName(v string) *DeleteDomainInput {
	s.DomainName = &v
	return s
}

type DeleteDomainOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *DeleteDomainOutput) SetOperation(v *Operation) *DeleteDomainOutput {
	s.Operation = v
	return s
}

type DeleteInstanceInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value to indicate whether to delete the enabled add-ons for the
	// disk.
	ForceDeleteAddOns *bool `locationName:"forceDeleteAddOns" type:"boolean"`

	// The name of the instance to delete.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForceDeleteAddOns sets the ForceDeleteAddOns field's value.
func (s *DeleteInstanceInput) SetForceDeleteAddOns(v bool) *DeleteInstanceInput {
	s.ForceDeleteAddOns = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *DeleteInstanceInput) SetInstanceName(v string) *DeleteInstanceInput {
	s.InstanceName = &v
	return s
}

type DeleteInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteInstanceOutput) SetOperations(v []*Operation) *DeleteInstanceOutput {
	s.Operations = v
	return s
}

type DeleteInstanceSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the snapshot to delete.
	//
	// InstanceSnapshotName is a required field
	InstanceSnapshotName *string `locationName:"instanceSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInstanceSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInstanceSnapshotInput"}
	if s.InstanceSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceSnapshotName sets the InstanceSnapshotName field's value.
func (s *DeleteInstanceSnapshotInput) SetInstanceSnapshotName(v string) *DeleteInstanceSnapshotInput {
	s.InstanceSnapshotName = &v
	return s
}

type DeleteInstanceSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteInstanceSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteInstanceSnapshotOutput) SetOperations(v []*Operation) *DeleteInstanceSnapshotOutput {
	s.Operations = v
	return s
}

type DeleteKeyPairInput struct {
	_ struct{} `type:"structure"`

	// The name of the key pair to delete.
	//
	// KeyPairName is a required field
	KeyPairName *string `locationName:"keyPairName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKeyPairInput"}
	if s.KeyPairName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyPairName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *DeleteKeyPairInput) SetKeyPairName(v string) *DeleteKeyPairInput {
	s.KeyPairName = &v
	return s
}

type DeleteKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s DeleteKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKeyPairOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *DeleteKeyPairOutput) SetOperation(v *Operation) *DeleteKeyPairOutput {
	s.Operation = v
	return s
}

type DeleteKnownHostKeysInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance for which you want to reset the host key or certificate.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteKnownHostKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKnownHostKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKnownHostKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKnownHostKeysInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *DeleteKnownHostKeysInput) SetInstanceName(v string) *DeleteKnownHostKeysInput {
	s.InstanceName = &v
	return s
}

type DeleteKnownHostKeysOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteKnownHostKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKnownHostKeysOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteKnownHostKeysOutput) SetOperations(v []*Operation) *DeleteKnownHostKeysOutput {
	s.Operations = v
	return s
}

type DeleteLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer you want to delete.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLoadBalancerInput"}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *DeleteLoadBalancerInput) SetLoadBalancerName(v string) *DeleteLoadBalancerInput {
	s.LoadBalancerName = &v
	return s
}

type DeleteLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteLoadBalancerOutput) SetOperations(v []*Operation) *DeleteLoadBalancerOutput {
	s.Operations = v
	return s
}

type DeleteLoadBalancerTlsCertificateInput struct {
	_ struct{} `type:"structure"`

	// The SSL/TLS certificate name.
	//
	// CertificateName is a required field
	CertificateName *string `locationName:"certificateName" type:"string" required:"true"`

	// When true, forces the deletion of an SSL/TLS certificate.
	//
	// There can be two certificates associated with a Lightsail load balancer:
	// the primary and the backup. The force parameter is required when the primary
	// SSL/TLS certificate is in use by an instance attached to the load balancer.
	Force *bool `locationName:"force" type:"boolean"`

	// The load balancer name.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoadBalancerTlsCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerTlsCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoadBalancerTlsCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLoadBalancerTlsCertificateInput"}
	if s.CertificateName == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateName"))
	}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateName sets the CertificateName field's value.
func (s *DeleteLoadBalancerTlsCertificateInput) SetCertificateName(v string) *DeleteLoadBalancerTlsCertificateInput {
	s.CertificateName = &v
	return s
}

// SetForce sets the Force field's value.
func (s *DeleteLoadBalancerTlsCertificateInput) SetForce(v bool) *DeleteLoadBalancerTlsCertificateInput {
	s.Force = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *DeleteLoadBalancerTlsCertificateInput) SetLoadBalancerName(v string) *DeleteLoadBalancerTlsCertificateInput {
	s.LoadBalancerName = &v
	return s
}

type DeleteLoadBalancerTlsCertificateOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteLoadBalancerTlsCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerTlsCertificateOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteLoadBalancerTlsCertificateOutput) SetOperations(v []*Operation) *DeleteLoadBalancerTlsCertificateOutput {
	s.Operations = v
	return s
}

type DeleteRelationalDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of the database snapshot created if skip final snapshot is false,
	// which is the default value for that parameter.
	//
	// Specifying this parameter and also specifying the skip final snapshot parameter
	// to true results in an error.
	//
	// Constraints:
	//
	//    * Must contain from 2 to 255 alphanumeric characters, or hyphens.
	//
	//    * The first and last character must be a letter or number.
	FinalRelationalDatabaseSnapshotName *string `locationName:"finalRelationalDatabaseSnapshotName" type:"string"`

	// The name of the database that you are deleting.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`

	// Determines whether a final database snapshot is created before your database
	// is deleted. If true is specified, no database snapshot is created. If false
	// is specified, a database snapshot is created before your database is deleted.
	//
	// You must specify the final relational database snapshot name parameter if
	// the skip final snapshot parameter is false.
	//
	// Default: false
	SkipFinalSnapshot *bool `locationName:"skipFinalSnapshot" type:"boolean"`
}

// String returns the string representation
func (s DeleteRelationalDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRelationalDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRelationalDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRelationalDatabaseInput"}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFinalRelationalDatabaseSnapshotName sets the FinalRelationalDatabaseSnapshotName field's value.
func (s *DeleteRelationalDatabaseInput) SetFinalRelationalDatabaseSnapshotName(v string) *DeleteRelationalDatabaseInput {
	s.FinalRelationalDatabaseSnapshotName = &v
	return s
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *DeleteRelationalDatabaseInput) SetRelationalDatabaseName(v string) *DeleteRelationalDatabaseInput {
	s.RelationalDatabaseName = &v
	return s
}

// SetSkipFinalSnapshot sets the SkipFinalSnapshot field's value.
func (s *DeleteRelationalDatabaseInput) SetSkipFinalSnapshot(v bool) *DeleteRelationalDatabaseInput {
	s.SkipFinalSnapshot = &v
	return s
}

type DeleteRelationalDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteRelationalDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRelationalDatabaseOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteRelationalDatabaseOutput) SetOperations(v []*Operation) *DeleteRelationalDatabaseOutput {
	s.Operations = v
	return s
}

type DeleteRelationalDatabaseSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the database snapshot that you are deleting.
	//
	// RelationalDatabaseSnapshotName is a required field
	RelationalDatabaseSnapshotName *string `locationName:"relationalDatabaseSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRelationalDatabaseSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRelationalDatabaseSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRelationalDatabaseSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRelationalDatabaseSnapshotInput"}
	if s.RelationalDatabaseSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelationalDatabaseSnapshotName sets the RelationalDatabaseSnapshotName field's value.
func (s *DeleteRelationalDatabaseSnapshotInput) SetRelationalDatabaseSnapshotName(v string) *DeleteRelationalDatabaseSnapshotInput {
	s.RelationalDatabaseSnapshotName = &v
	return s
}

type DeleteRelationalDatabaseSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteRelationalDatabaseSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRelationalDatabaseSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteRelationalDatabaseSnapshotOutput) SetOperations(v []*Operation) *DeleteRelationalDatabaseSnapshotOutput {
	s.Operations = v
	return s
}

// Describes the destination of a record.
type DestinationInfo struct {
	_ struct{} `type:"structure"`

	// The ID of the resource created at the destination.
	Id *string `locationName:"id" type:"string"`

	// The destination service of the record.
	Service *string `locationName:"service" type:"string"`
}

// String returns the string representation
func (s DestinationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DestinationInfo) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DestinationInfo) SetId(v string) *DestinationInfo {
	s.Id = &v
	return s
}

// SetService sets the Service field's value.
func (s *DestinationInfo) SetService(v string) *DestinationInfo {
	s.Service = &v
	return s
}

type DetachCertificateFromDistributionInput struct {
	_ struct{} `type:"structure"`

	// The name of the distribution from which to detach the certificate.
	//
	// Use the GetDistributions action to get a list of distribution names that
	// you can specify.
	//
	// DistributionName is a required field
	DistributionName *string `locationName:"distributionName" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachCertificateFromDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachCertificateFromDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachCertificateFromDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachCertificateFromDistributionInput"}
	if s.DistributionName == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionName sets the DistributionName field's value.
func (s *DetachCertificateFromDistributionInput) SetDistributionName(v string) *DetachCertificateFromDistributionInput {
	s.DistributionName = &v
	return s
}

type DetachCertificateFromDistributionOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the result of the action, such as the status of
	// the request, the timestamp of the request, and the resources affected by
	// the request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s DetachCertificateFromDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachCertificateFromDistributionOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *DetachCertificateFromDistributionOutput) SetOperation(v *Operation) *DetachCertificateFromDistributionOutput {
	s.Operation = v
	return s
}

type DetachDiskInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the disk you want to detach from your instance (e.g.,
	// my-disk).
	//
	// DiskName is a required field
	DiskName *string `locationName:"diskName" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachDiskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachDiskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachDiskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachDiskInput"}
	if s.DiskName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskName sets the DiskName field's value.
func (s *DetachDiskInput) SetDiskName(v string) *DetachDiskInput {
	s.DiskName = &v
	return s
}

type DetachDiskOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DetachDiskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachDiskOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DetachDiskOutput) SetOperations(v []*Operation) *DetachDiskOutput {
	s.Operations = v
	return s
}

type DetachInstancesFromLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// An array of strings containing the names of the instances you want to detach
	// from the load balancer.
	//
	// InstanceNames is a required field
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The name of the Lightsail load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachInstancesFromLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachInstancesFromLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachInstancesFromLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachInstancesFromLoadBalancerInput"}
	if s.InstanceNames == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceNames"))
	}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceNames sets the InstanceNames field's value.
func (s *DetachInstancesFromLoadBalancerInput) SetInstanceNames(v []*string) *DetachInstancesFromLoadBalancerInput {
	s.InstanceNames = v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *DetachInstancesFromLoadBalancerInput) SetLoadBalancerName(v string) *DetachInstancesFromLoadBalancerInput {
	s.LoadBalancerName = &v
	return s
}

type DetachInstancesFromLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DetachInstancesFromLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachInstancesFromLoadBalancerOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DetachInstancesFromLoadBalancerOutput) SetOperations(v []*Operation) *DetachInstancesFromLoadBalancerOutput {
	s.Operations = v
	return s
}

type DetachStaticIpInput struct {
	_ struct{} `type:"structure"`

	// The name of the static IP to detach from the instance.
	//
	// StaticIpName is a required field
	StaticIpName *string `locationName:"staticIpName" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachStaticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachStaticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachStaticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachStaticIpInput"}
	if s.StaticIpName == nil {
		invalidParams.Add(request.NewErrParamRequired("StaticIpName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStaticIpName sets the StaticIpName field's value.
func (s *DetachStaticIpInput) SetStaticIpName(v string) *DetachStaticIpInput {
	s.StaticIpName = &v
	return s
}

type DetachStaticIpOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DetachStaticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachStaticIpOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DetachStaticIpOutput) SetOperations(v []*Operation) *DetachStaticIpOutput {
	s.Operations = v
	return s
}

type DisableAddOnInput struct {
	_ struct{} `type:"structure"`

	// The add-on type to disable.
	//
	// AddOnType is a required field
	AddOnType *string `locationName:"addOnType" type:"string" required:"true" enum:"AddOnType"`

	// The name of the source resource for which to disable the add-on.
	//
	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableAddOnInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableAddOnInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableAddOnInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableAddOnInput"}
	if s.AddOnType == nil {
		invalidParams.Add(request.NewErrParamRequired("AddOnType"))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddOnType sets the AddOnType field's value.
func (s *DisableAddOnInput) SetAddOnType(v string) *DisableAddOnInput {
	s.AddOnType = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *DisableAddOnInput) SetResourceName(v string) *DisableAddOnInput {
	s.ResourceName = &v
	return s
}

type DisableAddOnOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DisableAddOnOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableAddOnOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DisableAddOnOutput) SetOperations(v []*Operation) *DisableAddOnOutput {
	s.Operations = v
	return s
}

// Describes a block storage disk.
type Disk struct {
	_ struct{} `type:"structure"`

	// An array of objects representing the add-ons enabled on the disk.
	AddOns []*AddOn `locationName:"addOns" type:"list"`

	// The Amazon Resource Name (ARN) of the disk.
	Arn *string `locationName:"arn" type:"string"`

	// The resources to which the disk is attached.
	AttachedTo *string `locationName:"attachedTo" type:"string"`

	// (Deprecated) The attachment state of the disk.
	//
	// In releases prior to November 14, 2017, this parameter returned attached
	// for system disks in the API response. It is now deprecated, but still included
	// in the response. Use isAttached instead.
	//
	// Deprecated: AttachmentState has been deprecated
	AttachmentState *string `locationName:"attachmentState" deprecated:"true" type:"string"`

	// The date when the disk was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// (Deprecated) The number of GB in use by the disk.
	//
	// In releases prior to November 14, 2017, this parameter was not included in
	// the API response. It is now deprecated.
	//
	// Deprecated: GbInUse has been deprecated
	GbInUse *int64 `locationName:"gbInUse" deprecated:"true" type:"integer"`

	// The input/output operations per second (IOPS) of the disk.
	Iops *int64 `locationName:"iops" type:"integer"`

	// A Boolean value indicating whether the disk is attached.
	IsAttached *bool `locationName:"isAttached" type:"boolean"`

	// A Boolean value indicating whether this disk is a system disk (has an operating
	// system loaded on it).
	IsSystemDisk *bool `locationName:"isSystemDisk" type:"boolean"`

	// The AWS Region and Availability Zone where the disk is located.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The unique name of the disk.
	Name *string `locationName:"name" type:"string"`

	// The disk path.
	Path *string `locationName:"path" type:"string"`

	// The Lightsail resource type (e.g., Disk).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The size of the disk in GB.
	SizeInGb *int64 `locationName:"sizeInGb" type:"integer"`

	// Describes the status of the disk.
	State *string `locationName:"state" type:"string" enum:"DiskState"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s Disk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Disk) GoString() string {
	return s.String()
}

// SetAddOns sets the AddOns field's value.
func (s *Disk) SetAddOns(v []*AddOn) *Disk {
	s.AddOns = v
	return s
}

// SetArn sets the Arn field's value.
func (s *Disk) SetArn(v string) *Disk {
	s.Arn = &v
	return s
}

// SetAttachedTo sets the AttachedTo field's value.
func (s *Disk) SetAttachedTo(v string) *Disk {
	s.AttachedTo = &v
	return s
}

// SetAttachmentState sets the AttachmentState field's value.
func (s *Disk) SetAttachmentState(v string) *Disk {
	s.AttachmentState = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Disk) SetCreatedAt(v time.Time) *Disk {
	s.CreatedAt = &v
	return s
}

// SetGbInUse sets the GbInUse field's value.
func (s *Disk) SetGbInUse(v int64) *Disk {
	s.GbInUse = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *Disk) SetIops(v int64) *Disk {
	s.Iops = &v
	return s
}

// SetIsAttached sets the IsAttached field's value.
func (s *Disk) SetIsAttached(v bool) *Disk {
	s.IsAttached = &v
	return s
}

// SetIsSystemDisk sets the IsSystemDisk field's value.
func (s *Disk) SetIsSystemDisk(v bool) *Disk {
	s.IsSystemDisk = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Disk) SetLocation(v *ResourceLocation) *Disk {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *Disk) SetName(v string) *Disk {
	s.Name = &v
	return s
}

// SetPath sets the Path field's value.
func (s *Disk) SetPath(v string) *Disk {
	s.Path = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Disk) SetResourceType(v string) *Disk {
	s.ResourceType = &v
	return s
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *Disk) SetSizeInGb(v int64) *Disk {
	s.SizeInGb = &v
	return s
}

// SetState sets the State field's value.
func (s *Disk) SetState(v string) *Disk {
	s.State = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *Disk) SetSupportCode(v string) *Disk {
	s.SupportCode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Disk) SetTags(v []*Tag) *Disk {
	s.Tags = v
	return s
}

// Describes a disk.
type DiskInfo struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating whether this disk is a system disk (has an operating
	// system loaded on it).
	IsSystemDisk *bool `locationName:"isSystemDisk" type:"boolean"`

	// The disk name.
	Name *string `locationName:"name" type:"string"`

	// The disk path.
	Path *string `locationName:"path" type:"string"`

	// The size of the disk in GB (e.g., 32).
	SizeInGb *int64 `locationName:"sizeInGb" type:"integer"`
}

// String returns the string representation
func (s DiskInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DiskInfo) GoString() string {
	return s.String()
}

// SetIsSystemDisk sets the IsSystemDisk field's value.
func (s *DiskInfo) SetIsSystemDisk(v bool) *DiskInfo {
	s.IsSystemDisk = &v
	return s
}

// SetName sets the Name field's value.
func (s *DiskInfo) SetName(v string) *DiskInfo {
	s.Name = &v
	return s
}

// SetPath sets the Path field's value.
func (s *DiskInfo) SetPath(v string) *DiskInfo {
	s.Path = &v
	return s
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *DiskInfo) SetSizeInGb(v int64) *DiskInfo {
	s.SizeInGb = &v
	return s
}

// Describes a block storage disk mapping.
type DiskMap struct {
	_ struct{} `type:"structure"`

	// The new disk name (e.g., my-new-disk).
	NewDiskName *string `locationName:"newDiskName" type:"string"`

	// The original disk path exposed to the instance (for example, /dev/sdh).
	OriginalDiskPath *string `locationName:"originalDiskPath" type:"string"`
}

// String returns the string representation
func (s DiskMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DiskMap) GoString() string {
	return s.String()
}

// SetNewDiskName sets the NewDiskName field's value.
func (s *DiskMap) SetNewDiskName(v string) *DiskMap {
	s.NewDiskName = &v
	return s
}

// SetOriginalDiskPath sets the OriginalDiskPath field's value.
func (s *DiskMap) SetOriginalDiskPath(v string) *DiskMap {
	s.OriginalDiskPath = &v
	return s
}

// Describes a block storage disk snapshot.
type DiskSnapshot struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the disk snapshot.
	Arn *string `locationName:"arn" type:"string"`

	// The date when the disk snapshot was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the source disk from which the disk snapshot
	// was created.
	FromDiskArn *string `locationName:"fromDiskArn" type:"string"`

	// The unique name of the source disk from which the disk snapshot was created.
	FromDiskName *string `locationName:"fromDiskName" type:"string"`

	// The Amazon Resource Name (ARN) of the source instance from which the disk
	// (system volume) snapshot was created.
	FromInstanceArn *string `locationName:"fromInstanceArn" type:"string"`

	// The unique name of the source instance from which the disk (system volume)
	// snapshot was created.
	FromInstanceName *string `locationName:"fromInstanceName" type:"string"`

	// A Boolean value indicating whether the snapshot was created from an automatic
	// snapshot.
	IsFromAutoSnapshot *bool `locationName:"isFromAutoSnapshot" type:"boolean"`

	// The AWS Region and Availability Zone where the disk snapshot was created.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the disk snapshot (e.g., my-disk-snapshot).
	Name *string `locationName:"name" type:"string"`

	// The progress of the snapshot.
	Progress *string `locationName:"progress" type:"string"`

	// The Lightsail resource type (e.g., DiskSnapshot).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The size of the disk in GB.
	SizeInGb *int64 `locationName:"sizeInGb" type:"integer"`

	// The status of the disk snapshot operation.
	State *string `locationName:"state" type:"string" enum:"DiskSnapshotState"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s DiskSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DiskSnapshot) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DiskSnapshot) SetArn(v string) *DiskSnapshot {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DiskSnapshot) SetCreatedAt(v time.Time) *DiskSnapshot {
	s.CreatedAt = &v
	return s
}

// SetFromDiskArn sets the FromDiskArn field's value.
func (s *DiskSnapshot) SetFromDiskArn(v string) *DiskSnapshot {
	s.FromDiskArn = &v
	return s
}

// SetFromDiskName sets the FromDiskName field's value.
func (s *DiskSnapshot) SetFromDiskName(v string) *DiskSnapshot {
	s.FromDiskName = &v
	return s
}

// SetFromInstanceArn sets the FromInstanceArn field's value.
func (s *DiskSnapshot) SetFromInstanceArn(v string) *DiskSnapshot {
	s.FromInstanceArn = &v
	return s
}

// SetFromInstanceName sets the FromInstanceName field's value.
func (s *DiskSnapshot) SetFromInstanceName(v string) *DiskSnapshot {
	s.FromInstanceName = &v
	return s
}

// SetIsFromAutoSnapshot sets the IsFromAutoSnapshot field's value.
func (s *DiskSnapshot) SetIsFromAutoSnapshot(v bool) *DiskSnapshot {
	s.IsFromAutoSnapshot = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *DiskSnapshot) SetLocation(v *ResourceLocation) *DiskSnapshot {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *DiskSnapshot) SetName(v string) *DiskSnapshot {
	s.Name = &v
	return s
}

// SetProgress sets the Progress field's value.
func (s *DiskSnapshot) SetProgress(v string) *DiskSnapshot {
	s.Progress = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DiskSnapshot) SetResourceType(v string) *DiskSnapshot {
	s.ResourceType = &v
	return s
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *DiskSnapshot) SetSizeInGb(v int64) *DiskSnapshot {
	s.SizeInGb = &v
	return s
}

// SetState sets the State field's value.
func (s *DiskSnapshot) SetState(v string) *DiskSnapshot {
	s.State = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *DiskSnapshot) SetSupportCode(v string) *DiskSnapshot {
	s.SupportCode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DiskSnapshot) SetTags(v []*Tag) *DiskSnapshot {
	s.Tags = v
	return s
}

// Describes a disk snapshot.
type DiskSnapshotInfo struct {
	_ struct{} `type:"structure"`

	// The size of the disk in GB (e.g., 32).
	SizeInGb *int64 `locationName:"sizeInGb" type:"integer"`
}

// String returns the string representation
func (s DiskSnapshotInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DiskSnapshotInfo) GoString() string {
	return s.String()
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *DiskSnapshotInfo) SetSizeInGb(v int64) *DiskSnapshotInfo {
	s.SizeInGb = &v
	return s
}

// Describes the specifications of a distribution bundle.
type DistributionBundle struct {
	_ struct{} `type:"structure"`

	// The ID of the bundle.
	BundleId *string `locationName:"bundleId" type:"string"`

	// Indicates whether the bundle is active, and can be specified for a new or
	// existing distribution.
	IsActive *bool `locationName:"isActive" type:"boolean"`

	// The name of the distribution bundle.
	Name *string `locationName:"name" type:"string"`

	// The monthly price, in US dollars, of the bundle.
	Price *float64 `locationName:"price" type:"float"`

	// The monthly network transfer quota of the bundle.
	TransferPerMonthInGb *int64 `locationName:"transferPerMonthInGb" type:"integer"`
}

// String returns the string representation
func (s DistributionBundle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DistributionBundle) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *DistributionBundle) SetBundleId(v string) *DistributionBundle {
	s.BundleId = &v
	return s
}

// SetIsActive sets the IsActive field's value.
func (s *DistributionBundle) SetIsActive(v bool) *DistributionBundle {
	s.IsActive = &v
	return s
}

// SetName sets the Name field's value.
func (s *DistributionBundle) SetName(v string) *DistributionBundle {
	s.Name = &v
	return s
}

// SetPrice sets the Price field's value.
func (s *DistributionBundle) SetPrice(v float64) *DistributionBundle {
	s.Price = &v
	return s
}

// SetTransferPerMonthInGb sets the TransferPerMonthInGb field's value.
func (s *DistributionBundle) SetTransferPerMonthInGb(v int64) *DistributionBundle {
	s.TransferPerMonthInGb = &v
	return s
}

// Describes a domain where you are storing recordsets.
type Domain struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the domain recordset (e.g., arn:aws:lightsail:global:123456789101:Domain/824cede0-abc7-4f84-8dbc-12345EXAMPLE).
	Arn *string `locationName:"arn" type:"string"`

	// The date when the domain recordset was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// An array of key-value pairs containing information about the domain entries.
	DomainEntries []*DomainEntry `locationName:"domainEntries" type:"list"`

	// The AWS Region and Availability Zones where the domain recordset was created.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the domain.
	Name *string `locationName:"name" type:"string"`

	// The resource type.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s Domain) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Domain) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Domain) SetArn(v string) *Domain {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Domain) SetCreatedAt(v time.Time) *Domain {
	s.CreatedAt = &v
	return s
}

// SetDomainEntries sets the DomainEntries field's value.
func (s *Domain) SetDomainEntries(v []*DomainEntry) *Domain {
	s.DomainEntries = v
	return s
}

// SetLocation sets the Location field's value.
func (s *Domain) SetLocation(v *ResourceLocation) *Domain {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *Domain) SetName(v string) *Domain {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Domain) SetResourceType(v string) *Domain {
	s.ResourceType = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *Domain) SetSupportCode(v string) *Domain {
	s.SupportCode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Domain) SetTags(v []*Tag) *Domain {
	s.Tags = v
	return s
}

// Describes a domain recordset entry.
type DomainEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the domain recordset entry.
	Id *string `locationName:"id" type:"string"`

	// When true, specifies whether the domain entry is an alias used by the Lightsail
	// load balancer. You can include an alias (A type) record in your request,
	// which points to a load balancer DNS name and routes traffic to your load
	// balancer.
	IsAlias *bool `locationName:"isAlias" type:"boolean"`

	// The name of the domain.
	Name *string `locationName:"name" type:"string"`

	// (Deprecated) The options for the domain entry.
	//
	// In releases prior to November 29, 2017, this parameter was not included in
	// the API response. It is now deprecated.
	//
	// Deprecated: Options has been deprecated
	Options map[string]*string `locationName:"options" deprecated:"true" type:"map"`

	// The target IP address (e.g., 192.0.2.0), or AWS name server (e.g., ns-111.awsdns-22.com.).
	//
	// For Lightsail load balancers, the value looks like ab1234c56789c6b86aba6fb203d443bc-123456789.us-east-2.elb.amazonaws.com.
	// For Lightsail distributions, the value looks like exampled1182ne.cloudfront.net.
	// For Lightsail container services, the value looks like container-service-1.example23scljs.us-west-2.cs.amazonlightsail.com.
	// Be sure to also set isAlias to true when setting up an A record for a Lightsail
	// load balancer, distribution, or container service.
	Target *string `locationName:"target" type:"string"`

	// The type of domain entry, such as address for IPv4 (A), address for IPv6
	// (AAAA), canonical name (CNAME), mail exchanger (MX), name server (NS), start
	// of authority (SOA), service locator (SRV), or text (TXT).
	//
	// The following domain entry types can be used:
	//
	//    * A
	//
	//    * AAAA
	//
	//    * CNAME
	//
	//    * MX
	//
	//    * NS
	//
	//    * SOA
	//
	//    * SRV
	//
	//    * TXT
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s DomainEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainEntry) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DomainEntry) SetId(v string) *DomainEntry {
	s.Id = &v
	return s
}

// SetIsAlias sets the IsAlias field's value.
func (s *DomainEntry) SetIsAlias(v bool) *DomainEntry {
	s.IsAlias = &v
	return s
}

// SetName sets the Name field's value.
func (s *DomainEntry) SetName(v string) *DomainEntry {
	s.Name = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *DomainEntry) SetOptions(v map[string]*string) *DomainEntry {
	s.Options = v
	return s
}

// SetTarget sets the Target field's value.
func (s *DomainEntry) SetTarget(v string) *DomainEntry {
	s.Target = &v
	return s
}

// SetType sets the Type field's value.
func (s *DomainEntry) SetType(v string) *DomainEntry {
	s.Type = &v
	return s
}

// Describes the domain validation records of an Amazon Lightsail SSL/TLS certificate.
type DomainValidationRecord struct {
	_ struct{} `type:"structure"`

	// The domain name of the certificate validation record. For example, example.com
	// or www.example.com.
	DomainName *string `locationName:"domainName" type:"string"`

	// An object that describes the DNS records to add to your domain's DNS to validate
	// it for the certificate.
	ResourceRecord *ResourceRecord `locationName:"resourceRecord" type:"structure"`
}

// String returns the string representation
func (s DomainValidationRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainValidationRecord) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *DomainValidationRecord) SetDomainName(v string) *DomainValidationRecord {
	s.DomainName = &v
	return s
}

// SetResourceRecord sets the ResourceRecord field's value.
func (s *DomainValidationRecord) SetResourceRecord(v *ResourceRecord) *DomainValidationRecord {
	s.ResourceRecord = v
	return s
}

type DownloadDefaultKeyPairInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DownloadDefaultKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadDefaultKeyPairInput) GoString() string {
	return s.String()
}

type DownloadDefaultKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// A base64-encoded RSA private key.
	PrivateKeyBase64 *string `locationName:"privateKeyBase64" type:"string"`

	// A base64-encoded public key of the ssh-rsa type.
	PublicKeyBase64 *string `locationName:"publicKeyBase64" type:"string"`
}

// String returns the string representation
func (s DownloadDefaultKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadDefaultKeyPairOutput) GoString() string {
	return s.String()
}

// SetPrivateKeyBase64 sets the PrivateKeyBase64 field's value.
func (s *DownloadDefaultKeyPairOutput) SetPrivateKeyBase64(v string) *DownloadDefaultKeyPairOutput {
	s.PrivateKeyBase64 = &v
	return s
}

// SetPublicKeyBase64 sets the PublicKeyBase64 field's value.
func (s *DownloadDefaultKeyPairOutput) SetPublicKeyBase64(v string) *DownloadDefaultKeyPairOutput {
	s.PublicKeyBase64 = &v
	return s
}

type EnableAddOnInput struct {
	_ struct{} `type:"structure"`

	// An array of strings representing the add-on to enable or modify.
	//
	// AddOnRequest is a required field
	AddOnRequest *AddOnRequest `locationName:"addOnRequest" type:"structure" required:"true"`

	// The name of the source resource for which to enable or modify the add-on.
	//
	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableAddOnInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAddOnInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableAddOnInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableAddOnInput"}
	if s.AddOnRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("AddOnRequest"))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.AddOnRequest != nil {
		if err := s.AddOnRequest.Validate(); err != nil {
			invalidParams.AddNested("AddOnRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddOnRequest sets the AddOnRequest field's value.
func (s *EnableAddOnInput) SetAddOnRequest(v *AddOnRequest) *EnableAddOnInput {
	s.AddOnRequest = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *EnableAddOnInput) SetResourceName(v string) *EnableAddOnInput {
	s.ResourceName = &v
	return s
}

type EnableAddOnOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s EnableAddOnOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAddOnOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *EnableAddOnOutput) SetOperations(v []*Operation) *EnableAddOnOutput {
	s.Operations = v
	return s
}

// Describes the settings of a public endpoint for an Amazon Lightsail container
// service.
type EndpointRequest struct {
	_ struct{} `type:"structure"`

	// The name of the container for the endpoint.
	//
	// ContainerName is a required field
	ContainerName *string `locationName:"containerName" type:"string" required:"true"`

	// The port of the container to which traffic is forwarded to.
	//
	// ContainerPort is a required field
	ContainerPort *int64 `locationName:"containerPort" type:"integer" required:"true"`

	// An object that describes the health check configuration of the container.
	HealthCheck *ContainerServiceHealthCheckConfig `locationName:"healthCheck" type:"structure"`
}

// String returns the string representation
func (s EndpointRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndpointRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EndpointRequest"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerPort == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerPort"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *EndpointRequest) SetContainerName(v string) *EndpointRequest {
	s.ContainerName = &v
	return s
}

// SetContainerPort sets the ContainerPort field's value.
func (s *EndpointRequest) SetContainerPort(v int64) *EndpointRequest {
	s.ContainerPort = &v
	return s
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *EndpointRequest) SetHealthCheck(v *ContainerServiceHealthCheckConfig) *EndpointRequest {
	s.HealthCheck = v
	return s
}

type ExportSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance or disk snapshot to be exported to Amazon EC2.
	//
	// SourceSnapshotName is a required field
	SourceSnapshotName *string `locationName:"sourceSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s ExportSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportSnapshotInput"}
	if s.SourceSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceSnapshotName sets the SourceSnapshotName field's value.
func (s *ExportSnapshotInput) SetSourceSnapshotName(v string) *ExportSnapshotInput {
	s.SourceSnapshotName = &v
	return s
}

type ExportSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s ExportSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *ExportSnapshotOutput) SetOperations(v []*Operation) *ExportSnapshotOutput {
	s.Operations = v
	return s
}

// Describes an export snapshot record.
type ExportSnapshotRecord struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the export snapshot record.
	Arn *string `locationName:"arn" type:"string"`

	// The date when the export snapshot record was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// A list of objects describing the destination of the export snapshot record.
	DestinationInfo *DestinationInfo `locationName:"destinationInfo" type:"structure"`

	// The AWS Region and Availability Zone where the export snapshot record is
	// located.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The export snapshot record name.
	Name *string `locationName:"name" type:"string"`

	// The Lightsail resource type (e.g., ExportSnapshotRecord).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// A list of objects describing the source of the export snapshot record.
	SourceInfo *ExportSnapshotRecordSourceInfo `locationName:"sourceInfo" type:"structure"`

	// The state of the export snapshot record.
	State *string `locationName:"state" type:"string" enum:"RecordState"`
}

// String returns the string representation
func (s ExportSnapshotRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportSnapshotRecord) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ExportSnapshotRecord) SetArn(v string) *ExportSnapshotRecord {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ExportSnapshotRecord) SetCreatedAt(v time.Time) *ExportSnapshotRecord {
	s.CreatedAt = &v
	return s
}

// SetDestinationInfo sets the DestinationInfo field's value.
func (s *ExportSnapshotRecord) SetDestinationInfo(v *DestinationInfo) *ExportSnapshotRecord {
	s.DestinationInfo = v
	return s
}

// SetLocation sets the Location field's value.
func (s *ExportSnapshotRecord) SetLocation(v *ResourceLocation) *ExportSnapshotRecord {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *ExportSnapshotRecord) SetName(v string) *ExportSnapshotRecord {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ExportSnapshotRecord) SetResourceType(v string) *ExportSnapshotRecord {
	s.ResourceType = &v
	return s
}

// SetSourceInfo sets the SourceInfo field's value.
func (s *ExportSnapshotRecord) SetSourceInfo(v *ExportSnapshotRecordSourceInfo) *ExportSnapshotRecord {
	s.SourceInfo = v
	return s
}

// SetState sets the State field's value.
func (s *ExportSnapshotRecord) SetState(v string) *ExportSnapshotRecord {
	s.State = &v
	return s
}

// Describes the source of an export snapshot record.
type ExportSnapshotRecordSourceInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the source instance or disk snapshot.
	Arn *string `locationName:"arn" type:"string"`

	// The date when the source instance or disk snapshot was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// A list of objects describing a disk snapshot.
	DiskSnapshotInfo *DiskSnapshotInfo `locationName:"diskSnapshotInfo" type:"structure"`

	// The Amazon Resource Name (ARN) of the snapshot's source instance or disk.
	FromResourceArn *string `locationName:"fromResourceArn" type:"string"`

	// The name of the snapshot's source instance or disk.
	FromResourceName *string `locationName:"fromResourceName" type:"string"`

	// A list of objects describing an instance snapshot.
	InstanceSnapshotInfo *InstanceSnapshotInfo `locationName:"instanceSnapshotInfo" type:"structure"`

	// The name of the source instance or disk snapshot.
	Name *string `locationName:"name" type:"string"`

	// The Lightsail resource type (e.g., InstanceSnapshot or DiskSnapshot).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ExportSnapshotRecordSourceType"`
}

// String returns the string representation
func (s ExportSnapshotRecordSourceInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportSnapshotRecordSourceInfo) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ExportSnapshotRecordSourceInfo) SetArn(v string) *ExportSnapshotRecordSourceInfo {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ExportSnapshotRecordSourceInfo) SetCreatedAt(v time.Time) *ExportSnapshotRecordSourceInfo {
	s.CreatedAt = &v
	return s
}

// SetDiskSnapshotInfo sets the DiskSnapshotInfo field's value.
func (s *ExportSnapshotRecordSourceInfo) SetDiskSnapshotInfo(v *DiskSnapshotInfo) *ExportSnapshotRecordSourceInfo {
	s.DiskSnapshotInfo = v
	return s
}

// SetFromResourceArn sets the FromResourceArn field's value.
func (s *ExportSnapshotRecordSourceInfo) SetFromResourceArn(v string) *ExportSnapshotRecordSourceInfo {
	s.FromResourceArn = &v
	return s
}

// SetFromResourceName sets the FromResourceName field's value.
func (s *ExportSnapshotRecordSourceInfo) SetFromResourceName(v string) *ExportSnapshotRecordSourceInfo {
	s.FromResourceName = &v
	return s
}

// SetInstanceSnapshotInfo sets the InstanceSnapshotInfo field's value.
func (s *ExportSnapshotRecordSourceInfo) SetInstanceSnapshotInfo(v *InstanceSnapshotInfo) *ExportSnapshotRecordSourceInfo {
	s.InstanceSnapshotInfo = v
	return s
}

// SetName sets the Name field's value.
func (s *ExportSnapshotRecordSourceInfo) SetName(v string) *ExportSnapshotRecordSourceInfo {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ExportSnapshotRecordSourceInfo) SetResourceType(v string) *ExportSnapshotRecordSourceInfo {
	s.ResourceType = &v
	return s
}

type GetActiveNamesInput struct {
	_ struct{} `type:"structure"`

	// The token to advance to the next page of results from your request.
	//
	// To get a page token, perform an initial GetActiveNames request. If your results
	// are paginated, the response will return a next page token that you can specify
	// as the page token in a subsequent request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetActiveNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetActiveNamesInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetActiveNamesInput) SetPageToken(v string) *GetActiveNamesInput {
	s.PageToken = &v
	return s
}

type GetActiveNamesOutput struct {
	_ struct{} `type:"structure"`

	// The list of active names returned by the get active names request.
	ActiveNames []*string `locationName:"activeNames" type:"list"`

	// The token to advance to the next page of results from your request.
	//
	// A next page token is not returned if there are no more results to display.
	//
	// To get the next page of results, perform another GetActiveNames request and
	// specify the next page token using the pageToken parameter.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetActiveNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetActiveNamesOutput) GoString() string {
	return s.String()
}

// SetActiveNames sets the ActiveNames field's value.
func (s *GetActiveNamesOutput) SetActiveNames(v []*string) *GetActiveNamesOutput {
	s.ActiveNames = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetActiveNamesOutput) SetNextPageToken(v string) *GetActiveNamesOutput {
	s.NextPageToken = &v
	return s
}

type GetAlarmsInput struct {
	_ struct{} `type:"structure"`

	// The name of the alarm.
	//
	// Specify an alarm name to return information about a specific alarm.
	AlarmName *string `locationName:"alarmName" type:"string"`

	// The name of the Lightsail resource being monitored by the alarm.
	//
	// Specify a monitored resource name to return information about all alarms
	// for a specific resource.
	MonitoredResourceName *string `locationName:"monitoredResourceName" type:"string"`

	// The token to advance to the next page of results from your request.
	//
	// To get a page token, perform an initial GetAlarms request. If your results
	// are paginated, the response will return a next page token that you can specify
	// as the page token in a subsequent request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetAlarmsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAlarmsInput) GoString() string {
	return s.String()
}

// SetAlarmName sets the AlarmName field's value.
func (s *GetAlarmsInput) SetAlarmName(v string) *GetAlarmsInput {
	s.AlarmName = &v
	return s
}

// SetMonitoredResourceName sets the MonitoredResourceName field's value.
func (s *GetAlarmsInput) SetMonitoredResourceName(v string) *GetAlarmsInput {
	s.MonitoredResourceName = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *GetAlarmsInput) SetPageToken(v string) *GetAlarmsInput {
	s.PageToken = &v
	return s
}

type GetAlarmsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the alarms.
	Alarms []*Alarm `locationName:"alarms" type:"list"`

	// The token to advance to the next page of results from your request.
	//
	// A next page token is not returned if there are no more results to display.
	//
	// To get the next page of results, perform another GetAlarms request and specify
	// the next page token using the pageToken parameter.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetAlarmsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAlarmsOutput) GoString() string {
	return s.String()
}

// SetAlarms sets the Alarms field's value.
func (s *GetAlarmsOutput) SetAlarms(v []*Alarm) *GetAlarmsOutput {
	s.Alarms = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetAlarmsOutput) SetNextPageToken(v string) *GetAlarmsOutput {
	s.NextPageToken = &v
	return s
}

type GetAutoSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// The name of the source instance or disk from which to get automatic snapshot
	// information.
	//
	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAutoSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAutoSnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAutoSnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAutoSnapshotsInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *GetAutoSnapshotsInput) SetResourceName(v string) *GetAutoSnapshotsInput {
	s.ResourceName = &v
	return s
}

type GetAutoSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the automatic snapshots that are available
	// for the specified source instance or disk.
	AutoSnapshots []*AutoSnapshotDetails `locationName:"autoSnapshots" type:"list"`

	// The name of the source instance or disk for the automatic snapshots.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The resource type (e.g., Instance or Disk).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s GetAutoSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAutoSnapshotsOutput) GoString() string {
	return s.String()
}

// SetAutoSnapshots sets the AutoSnapshots field's value.
func (s *GetAutoSnapshotsOutput) SetAutoSnapshots(v []*AutoSnapshotDetails) *GetAutoSnapshotsOutput {
	s.AutoSnapshots = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *GetAutoSnapshotsOutput) SetResourceName(v string) *GetAutoSnapshotsOutput {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *GetAutoSnapshotsOutput) SetResourceType(v string) *GetAutoSnapshotsOutput {
	s.ResourceType = &v
	return s
}

type GetBlueprintsInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating whether to include inactive results in your request.
	IncludeInactive *bool `locationName:"includeInactive" type:"boolean"`

	// The token to advance to the next page of results from your request.
	//
	// To get a page token, perform an initial GetBlueprints request. If your results
	// are paginated, the response will return a next page token that you can specify
	// as the page token in a subsequent request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetBlueprintsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlueprintsInput) GoString() string {
	return s.String()
}

// SetIncludeInactive sets the IncludeInactive field's value.
func (s *GetBlueprintsInput) SetIncludeInactive(v bool) *GetBlueprintsInput {
	s.IncludeInactive = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *GetBlueprintsInput) SetPageToken(v string) *GetBlueprintsInput {
	s.PageToken = &v
	return s
}

type GetBlueprintsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs that contains information about the available
	// blueprints.
	Blueprints []*Blueprint `locationName:"blueprints" type:"list"`

	// The token to advance to the next page of results from your request.
	//
	// A next page token is not returned if there are no more results to display.
	//
	// To get the next page of results, perform another GetBlueprints request and
	// specify the next page token using the pageToken parameter.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetBlueprintsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlueprintsOutput) GoString() string {
	return s.String()
}

// SetBlueprints sets the Blueprints field's value.
func (s *GetBlueprintsOutput) SetBlueprints(v []*Blueprint) *GetBlueprintsOutput {
	s.Blueprints = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetBlueprintsOutput) SetNextPageToken(v string) *GetBlueprintsOutput {
	s.NextPageToken = &v
	return s
}

type GetBucketAccessKeysInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket for which to return access keys.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketAccessKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAccessKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketAccessKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketAccessKeysInput"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *GetBucketAccessKeysInput) SetBucketName(v string) *GetBucketAccessKeysInput {
	s.BucketName = &v
	return s
}

type GetBucketAccessKeysOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the access keys for the specified bucket.
	AccessKeys []*AccessKey `locationName:"accessKeys" type:"list"`
}

// String returns the string representation
func (s GetBucketAccessKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAccessKeysOutput) GoString() string {
	return s.String()
}

// SetAccessKeys sets the AccessKeys field's value.
func (s *GetBucketAccessKeysOutput) SetAccessKeys(v []*AccessKey) *GetBucketAccessKeysOutput {
	s.AccessKeys = v
	return s
}

type GetBucketBundlesInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value that indicates whether to include inactive (unavailable)
	// bundles in the response.
	IncludeInactive *bool `locationName:"includeInactive" type:"boolean"`
}

// String returns the string representation
func (s GetBucketBundlesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketBundlesInput) GoString() string {
	return s.String()
}

// SetIncludeInactive sets the IncludeInactive field's value.
func (s *GetBucketBundlesInput) SetIncludeInactive(v bool) *GetBucketBundlesInput {
	s.IncludeInactive = &v
	return s
}

type GetBucketBundlesOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes bucket bundles.
	Bundles []*BucketBundle `locationName:"bundles" type:"list"`
}

// String returns the string representation
func (s GetBucketBundlesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketBundlesOutput) GoString() string {
	return s.String()
}

// SetBundles sets the Bundles field's value.
func (s *GetBucketBundlesOutput) SetBundles(v []*BucketBundle) *GetBucketBundlesOutput {
	s.Bundles = v
	return s
}

type GetBucketMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket for which to get metric data.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`

	// The timestamp indicating the latest data to be returned.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" required:"true"`

	// The metric for which you want to return information.
	//
	// Valid bucket metric names are listed below, along with the most useful statistics
	// to include in your request, and the published unit value.
	//
	// These bucket metrics are reported once per day.
	//
	//    * BucketSizeBytes - The amount of data in bytes stored in a bucket. This
	//    value is calculated by summing the size of all objects in the bucket (including
	//    object versions), including the size of all parts for all incomplete multipart
	//    uploads to the bucket. Statistics: The most useful statistic is Maximum.
	//    Unit: The published unit is Bytes.
	//
	//    * NumberOfObjects - The total number of objects stored in a bucket. This
	//    value is calculated by counting all objects in the bucket (including object
	//    versions) and the total number of parts for all incomplete multipart uploads
	//    to the bucket. Statistics: The most useful statistic is Average. Unit:
	//    The published unit is Count.
	//
	// MetricName is a required field
	MetricName *string `locationName:"metricName" type:"string" required:"true" enum:"BucketMetricName"`

	// The granularity, in seconds, of the returned data points.
	//
	// Bucket storage metrics are reported once per day. Therefore, you should specify
	// a period of 86400 seconds, which is the number of seconds in a day.
	//
	// Period is a required field
	Period *int64 `locationName:"period" min:"60" type:"integer" required:"true"`

	// The timestamp indicating the earliest data to be returned.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The statistic for the metric.
	//
	// The following statistics are available:
	//
	//    * Minimum - The lowest value observed during the specified period. Use
	//    this value to determine low volumes of activity for your application.
	//
	//    * Maximum - The highest value observed during the specified period. Use
	//    this value to determine high volumes of activity for your application.
	//
	//    * Sum - The sum of all values submitted for the matching metric. You can
	//    use this statistic to determine the total volume of a metric.
	//
	//    * Average - The value of Sum / SampleCount during the specified period.
	//    By comparing this statistic with the Minimum and Maximum values, you can
	//    determine the full scope of a metric and how close the average use is
	//    to the Minimum and Maximum values. This comparison helps you to know when
	//    to increase or decrease your resources.
	//
	//    * SampleCount - The count, or number, of data points used for the statistical
	//    calculation.
	//
	// Statistics is a required field
	Statistics []*string `locationName:"statistics" type:"list" required:"true"`

	// The unit for the metric data request.
	//
	// Valid units depend on the metric data being requested. For the valid units
	// with each available metric, see the metricName parameter.
	//
	// Unit is a required field
	Unit *string `locationName:"unit" type:"string" required:"true" enum:"MetricUnit"`
}

// String returns the string representation
func (s GetBucketMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketMetricDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketMetricDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketMetricDataInput"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 60 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 60))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.Statistics == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistics"))
	}
	if s.Unit == nil {
		invalidParams.Add(request.NewErrParamRequired("Unit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *GetBucketMetricDataInput) SetBucketName(v string) *GetBucketMetricDataInput {
	s.BucketName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetBucketMetricDataInput) SetEndTime(v time.Time) *GetBucketMetricDataInput {
	s.EndTime = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *GetBucketMetricDataInput) SetMetricName(v string) *GetBucketMetricDataInput {
	s.MetricName = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GetBucketMetricDataInput) SetPeriod(v int64) *GetBucketMetricDataInput {
	s.Period = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetBucketMetricDataInput) SetStartTime(v time.Time) *GetBucketMetricDataInput {
	s.StartTime = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *GetBucketMetricDataInput) SetStatistics(v []*string) *GetBucketMetricDataInput {
	s.Statistics = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *GetBucketMetricDataInput) SetUnit(v string) *GetBucketMetricDataInput {
	s.Unit = &v
	return s
}

type GetBucketMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the metric data returned.
	MetricData []*MetricDatapoint `locationName:"metricData" type:"list"`

	// The name of the metric returned.
	MetricName *string `locationName:"metricName" type:"string" enum:"BucketMetricName"`
}

// String returns the string representation
func (s GetBucketMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketMetricDataOutput) GoString() string {
	return s.String()
}

// SetMetricData sets the MetricData field's value.
func (s *GetBucketMetricDataOutput) SetMetricData(v []*MetricDatapoint) *GetBucketMetricDataOutput {
	s.MetricData = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *GetBucketMetricDataOutput) SetMetricName(v string) *GetBucketMetricDataOutput {
	s.MetricName = &v
	return s
}

type GetBucketsInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket for which to return information.
	//
	// When omitted, the response includes all of your buckets in the AWS Region
	// where the request is made.
	BucketName *string `locationName:"bucketName" min:"3" type:"string"`

	// A Boolean value that indicates whether to include Lightsail instances that
	// were given access to the bucket using the SetResourceAccessForBucket action.
	IncludeConnectedResources *bool `locationName:"includeConnectedResources" type:"boolean"`

	// The token to advance to the next page of results from your request.
	//
	// To get a page token, perform an initial GetBuckets request. If your results
	// are paginated, the response will return a next page token that you can specify
	// as the page token in a subsequent request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetBucketsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketsInput"}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("