+++
title = "Calculations list"
weight = 460
+++

# List of calculations

This topic lists and defines calculations used in Grafana.

Among other places, these calculations are used in the Transform tab and the bar gauge, gauge, and stat visualizations.

| Calculation        | Description                                               |
| :----------------- | :-------------------------------------------------------- |
| All nulls          | True when all values are null                             |
| All zeros          | True when all values are 0                                |
| Change count       | Number of times the field's value changes                 |
| Count              | Number of values in a field                               |
| Delta              | Cumulative change in value, only counts increments        |
| Difference         | Difference between first and last value of a field        |
| Difference percent | Percentage change between first and last value of a field |
| Distinct count     | Number of unique values in a field                        |
| First (not null)   | First, not null value in a field                          |
| Max                | Maximum value of a field                                  |
| Mean               | Mean value of all values in a field                       |
| Min                | Minimum value of a field                                  |
| Min (above zero)   | Minimum, positive value of a field                        |
| Range              | Difference between maximum and minimum values of a field  |
| Step               | Minimal interval between values of a field                |
| Total              | Sum of all values in a field                              |
