+++
title = "Permissions"
description = "Understand fine-grained access control permissions"
keywords = ["grafana", "fine-grained access-control", "roles", "permissions", "enterprise"]
weight = 110
+++

# Permissions

A permission is an action and a scope. When creating a fine-grained access control, consider what specific action a user should be allowed to perform, and on what resources (its scope).

To grant permissions to a user, you create a built-in role assignment to map a role to a built-in role. A built-in role assignment _modifies_ to one of the existing built-in roles in Grafana (Viewer, Editor, Admin). For more information, refer to [Built-in role assignments]({{< relref "./roles.md#built-in-role-assignments" >}}).

To learn more about which permissions are used for which resources, refer to [Resources with fine-grained permissions]({{< relref "./_index.md#resources-with-fine-grained-permissions" >}}).

action
: The specific action on a resource defines what a user is allowed to perform if they have permission with the relevant action assigned to it.

scope
: The scope describes where an action can be performed, such as reading a specific user profile. In such case, a permission is associated with the scope `users:<userId>` to the relevant role.

## Action definitions

The following list contains fine-grained access control actions.

| Action                           | Applicable scope                                                                            | Description                                                                                                                                                |
| -------------------------------- | ------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `roles:list`                     | `roles:*`                                                                                   | List available roles without permissions.                                                                                                                  |
| `roles:read`                     | `roles:*` <br> `roles:uid:*`                                                                | Read a specific role with its permissions.                                                                                                                 |
| `roles:write`                    | `permissions:delegate`                                                                      | Create or update a custom role.                                                                                                                            |
| `roles:delete`                   | `permissions:delegate`                                                                      | Delete a custom role.                                                                                                                                      |
| `roles.builtin:list`             | `roles:*`                                                                                   | List built-in role assignments.                                                                                                                            |
| `roles.builtin:add`              | `permissions:delegate`                                                                      | Create a built-in role assignment.                                                                                                                         |
| `roles.builtin:remove`           | `permissions:delegate`                                                                      | Delete a built-in role assignment.                                                                                                                         |
| `reports.admin:create`           | n/a                                                                                         | Create reports.                                                                                                                                            |
| `reports.admin:write`            | `reports:*` <br> `reports:id:*`                                                             | Update reports.                                                                                                                                            |
| `reports:delete`                 | `reports:*` <br> `reports:id:*`                                                             | Delete reports.                                                                                                                                            |
| `reports:read`                   | `reports:*`                                                                                 | List all available reports or get a specific report.                                                                                                       |
| `reports:send`                   | `reports:*`                                                                                 | Send a report email.                                                                                                                                       |
| `reports.settings:write`         | n/a                                                                                         | Update report settings.                                                                                                                                    |
| `reports.settings:read`          | n/a                                                                                         | Read report settings.                                                                                                                                      |
| `provisioning:reload`            | `provisioners:*`                                                                            | Reload provisioning files. To find the exact scope for specific provisioner, see [Scope definitions]({{< relref "./permissions.md#scope-definitions" >}}). |
| `users:read`                     | `global:users:*`                                                                            | Read or search user profiles.                                                                                                                              |
| `users:write`                    | `global:users:*` <br> `global:users:id`                                                     | Update a user’s profile.                                                                                                                                   |
| `users.teams:read`               | `global:users:*` <br> `global:users:id:*`                                                   | Read a user’s teams.                                                                                                                                       |
| `users.authtoken:list`           | `global:users:*` <br> `global:users:id:*`                                                   | List authentication tokens that are assigned to a user.                                                                                                    |
| `users.authtoken:update`         | `global:users:*` <br> `global:users:id:*`                                                   | Update authentication tokens that are assigned to a user.                                                                                                  |
| `users.password:update`          | `global:users:*` <br> `global:users:id:*`                                                   | Update a user’s password.                                                                                                                                  |
| `users:delete`                   | `global:users:*` <br> `global:users:id:*`                                                   | Delete a user.                                                                                                                                             |
| `users:create`                   | n/a                                                                                         | Create a user.                                                                                                                                             |
| `users:enable`                   | `global:users:*` <br> `global:users:id:*`                                                   | Enable a user.                                                                                                                                             |
| `users:disable`                  | `global:users:*` <br> `global:users:id:*`                                                   | Disable a user.                                                                                                                                            |
| `users.permissions:update`       | `global:users:*` <br> `global:users:id:*`                                                   | Update a user’s organization-level permissions.                                                                                                            |
| `users:logout`                   | `global:users:*` <br> `global:users:id:*`                                                   | Sign out a user.                                                                                                                                           |
| `users.quotas:list`              | `global:users:*` <br> `global:users:id:*`                                                   | List a user’s quotas.                                                                                                                                      |
| `users.quotas:update`            | `global:users:*` <br> `global:users:id:*`                                                   | Update a user’s quotas.                                                                                                                                    |
| `users.roles:list`               | `users:*`                                                                                   | List roles assigned directly to a user.                                                                                                                    |
| `users.roles:add`                | `permissions:delegate`                                                                      | Assign a role to a user.                                                                                                                                   |
| `users.roles:remove`             | `permissions:delegate`                                                                      | Unassign a role from a auser.                                                                                                                              |
| `users.permissions:list`         | `users:*`                                                                                   | List permissions of a user.                                                                                                                                |
| `org.users:read`                 | `users:*` <br> `users:id:*`                                                                 | Get user profiles within an organization.                                                                                                                  |
| `org.users:add`                  | `users:*`                                                                                   | Add a user to an organization.                                                                                                                             |
| `org.users:remove`               | `users:*` <br> `users:id:*`                                                                 | Remove a user from an organization.                                                                                                                        |
| `org.users.role:update`          | `users:*` <br> `users:id:*`                                                                 | Update the organization role (`Viewer`, `Editor`, or `Admin`) of an organization.                                                                          |
| `orgs:read`                      | `orgs:*` <br> `orgs:id:*`                                                                   | Read one or more organizations.                                                                                                                            |
| `orgs:write`                     | `orgs:*` <br> `orgs:id:*`                                                                   | Update one or more organizations.                                                                                                                          |
| `org:create`                     | n/a                                                                                         | Create an organization.                                                                                                                                    |
| `orgs:delete`                    | `orgs:*` <br> `orgs:id:*`                                                                   | Delete one or more organizations.                                                                                                                          |
| `orgs.quotas:read`               | `orgs:*` <br> `orgs:id:*`                                                                   | Read organization quotas.                                                                                                                                  |
| `orgs.quotas:write`              | `orgs:*` <br> `orgs:id:*`                                                                   | Update organization quotas.                                                                                                                                |
| `orgs.preferences:read`          | `orgs:*` <br> `orgs:id:*`                                                                   | Read organization preferences.                                                                                                                             |
| `orgs.preferences:write`         | `orgs:*` <br> `orgs:id:*`                                                                   | Update organization preferences.                                                                                                                           |
| `ldap.user:read`                 | n/a                                                                                         | Read users via LDAP.                                                                                                                                       |
| `ldap.user:sync`                 | n/a                                                                                         | Sync users via LDAP.                                                                                                                                       |
| `ldap.status:read`               | n/a                                                                                         | Verify the availability of the LDAP server or servers.                                                                                                     |
| `ldap.config:reload`             | n/a                                                                                         | Reload the LDAP configuration.                                                                                                                             |
| `status:accesscontrol`           | `services:accesscontrol`                                                                    | Get access-control enabled status.                                                                                                                         |
| `settings:read`                  | `settings:*`<br>`settings:auth.saml:*`<br>`settings:auth.saml:enabled` (property level)     | Read the [Grafana configuration settings]({{< relref "../../administration/configuration/_index.md" >}})                                                   |
| `settings:write`                 | `settings:*`<br>`settings:auth.saml:*`<br>`settings:auth.saml:enabled` (property level)     | Update any Grafana configuration settings that can be [updated at runtime]({{< relref "../../enterprise/settings-updates/_index.md" >}}).                  |
| `server.stats:read`              | n/a                                                                                         | Read Grafana instance statistics.                                                                                                                          |
| `datasources:explore`            | n/a                                                                                         | Enable access to the **Explore** tab.                                                                                                                      |
| `datasources:read`               | n/a<br>`datasources:*`<br>`datasources:id:*`<br>`datasources:uid:*`<br>`datasources:name:*` | List data sources.                                                                                                                                         |
| `datasources:query`              | n/a<br>`datasources:*`<br>`datasources:id:*`                                                | Query data sources.                                                                                                                                        |
| `datasources.id:read`            | `datasources:*`<br>`datasources:name:*`                                                     | Read data source IDs.                                                                                                                                      |
| `datasources:create`             | n/a                                                                                         | Create data sources.                                                                                                                                       |
| `datasources:write`              | `datasources:*`<br>`datasources:id:*`                                                       | Update data sources.                                                                                                                                       |
| `datasources:delete`             | `datasources:id:*`<br>`datasources:uid:*`<br>`datasources:name:*`                           | Delete data sources.                                                                                                                                       |
| `datasources.permissions:read`   | `datasources:*`<br>`datasources:id:*`                                                       | List data source permissions.                                                                                                                              |
| `datasources.permissions:create` | `datasources:*`<br>`datasources:id:*`                                                       | Create data source permissions.                                                                                                                            |
| `datasources.permissions:delete` | `datasources:*`<br>`datasources:id:*`                                                       | Delete data source permissions.                                                                                                                            |
| `datasources.permissions:toggle` | `datasources:*`<br>`datasources:id:*`                                                       | Enable or disable data source permissions.                                                                                                                 |
| `licensing:read`                 | n/a                                                                                         | Read licensing information.                                                                                                                                |
| `licensing:update`               | n/a                                                                                         | Update the license token.                                                                                                                                  |
| `licensing:delete`               | n/a                                                                                         | Delete the license token.                                                                                                                                  |
| `licensing.reports:read`         | n/a                                                                                         | Get custom permission reports.                                                                                                                             |
| `serviceaccounts:delete`         | `serviceaccounts:*` <br> `serviceaccounts:id:*`                                             | Delete one or more service accounts.                                                                                                                       |

## Scope definitions

The following list contains fine-grained access control scopes.

| Scopes                                                                               | Descriptions                                                                                                                                                                                                                     |
| ------------------------------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `permissions:delegate`                                                               | The scope is only applicable for roles associated with the Access Control itself and indicates that you can delegate your permissions only, or a subset of it, by creating a new role or making an assignment.                   |
| `roles:*` <br> `roles:uid:*`                                                         | Restrict an action to a set of roles. For example, `roles:*` matches any role and `roles:uid:randomuid` matches only the role whose UID is `randomuid`.                                                                          |
| `reports:*` <br> `reports:id:*`                                                      | Restrict an action to a set of reports. For example, `reports:*` matches any report and `reports:id:1` matches the report whose ID is `1`.                                                                                       |
| `services:accesscontrol`                                                             | Restrict an action to target only the fine-grained access control service. You can use this in conjunction with the `status:accesscontrol` actions.                                                                              |
| `global:users:*` <br> `global:users:id:*`                                            | Restrict an action to a set of global users. For example, `global:users:*` matches any user and `global:users:id:1` matches the user whose ID is `1`.                                                                            |
| `users:*` <br> `users:id:*`                                                          | Restrict an action to a set of users from an organization. For example, `users:*` matches any user and `users:id:1` matches the user whose ID is `1`.                                                                            |
| `orgs:*` <br> `orgs:id:*`                                                            | Restrict an action to a set of organizations. For example, `orgs:*` matches any organization and `orgs:id:1` matches the organization whose ID is `1`.                                                                           |
| `settings:*`                                                                         | Restrict an action to a subset of settings. For example, `settings:*` matches all settings, `settings:auth.saml:*` matches all SAML settings, and `settings:auth.saml:enabled` matches the enable property on the SAML settings. |
| `provisioners:*`                                                                     | Restrict an action to a set of provisioners. For example, `provisioners:*` matches any provisioner, and `provisioners:accesscontrol` matches the fine-grained access control [provisioner]({{< relref "./provisioning.md" >}}).  |
| `datasources:*`<br>`datasources:id:*`<br>`datasources:uid:*`<br>`datasources:name:*` | Restrict an action to a set of data sources. For example, `datasources:*` matches any data source, and `datasources:name:postgres` matches the data source named `postgres`.                                                     |
| `serviceaccounts:*` <br> `serviceaccounts:id:*`                                      | Restrict an action to a set of service accounts. For example, `serviceaccounts:*` matches any service account and `serviceaccounts:id:1` matches the service account whose ID is `1`.                                            |
