//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package migrate

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/migrate/mgmt/2020-01-01/migrate"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type Bitness = original.Bitness

const (
	SixFourbit  Bitness = original.SixFourbit
	ThreeTwobit Bitness = original.ThreeTwobit
)

type CPUSpeedAccuracy = original.CPUSpeedAccuracy

const (
	Actual    CPUSpeedAccuracy = original.Actual
	Estimated CPUSpeedAccuracy = original.Estimated
)

type CredentialType = original.CredentialType

const (
	HyperVFabric  CredentialType = original.HyperVFabric
	LinuxGuest    CredentialType = original.LinuxGuest
	LinuxServer   CredentialType = original.LinuxServer
	VMwareFabric  CredentialType = original.VMwareFabric
	WindowsGuest  CredentialType = original.WindowsGuest
	WindowsServer CredentialType = original.WindowsServer
)

type Family = original.Family

const (
	Aix     Family = original.Aix
	Linux   Family = original.Linux
	Solaris Family = original.Solaris
	Unknown Family = original.Unknown
	Windows Family = original.Windows
)

type HighlyAvailable = original.HighlyAvailable

const (
	HighlyAvailableNo      HighlyAvailable = original.HighlyAvailableNo
	HighlyAvailableUnknown HighlyAvailable = original.HighlyAvailableUnknown
	HighlyAvailableYes     HighlyAvailable = original.HighlyAvailableYes
)

type HypervisorType = original.HypervisorType

const (
	HypervisorTypeHyperv  HypervisorType = original.HypervisorTypeHyperv
	HypervisorTypeUnknown HypervisorType = original.HypervisorTypeUnknown
)

type PropertiesMonitoringState = original.PropertiesMonitoringState

const (
	Discovered PropertiesMonitoringState = original.Discovered
	Monitored  PropertiesMonitoringState = original.Monitored
)

type PropertiesVirtualizationState = original.PropertiesVirtualizationState

const (
	PropertiesVirtualizationStateHypervisor PropertiesVirtualizationState = original.PropertiesVirtualizationStateHypervisor
	PropertiesVirtualizationStatePhysical   PropertiesVirtualizationState = original.PropertiesVirtualizationStatePhysical
	PropertiesVirtualizationStateUnknown    PropertiesVirtualizationState = original.PropertiesVirtualizationStateUnknown
	PropertiesVirtualizationStateVirtual    PropertiesVirtualizationState = original.PropertiesVirtualizationStateVirtual
)

type RebootStatus = original.RebootStatus

const (
	RebootStatusNotRebooted RebootStatus = original.RebootStatusNotRebooted
	RebootStatusRebooted    RebootStatus = original.RebootStatusRebooted
	RebootStatusUnknown     RebootStatus = original.RebootStatusUnknown
)

type VirtualDiskMode = original.VirtualDiskMode

const (
	Append                   VirtualDiskMode = original.Append
	IndependentNonpersistent VirtualDiskMode = original.IndependentNonpersistent
	IndependentPersistent    VirtualDiskMode = original.IndependentPersistent
	Nonpersistent            VirtualDiskMode = original.Nonpersistent
	Persistent               VirtualDiskMode = original.Persistent
	Undoable                 VirtualDiskMode = original.Undoable
)

type VirtualMachineType = original.VirtualMachineType

const (
	VirtualMachineTypeHyperv    VirtualMachineType = original.VirtualMachineTypeHyperv
	VirtualMachineTypeLdom      VirtualMachineType = original.VirtualMachineTypeLdom
	VirtualMachineTypeLpar      VirtualMachineType = original.VirtualMachineTypeLpar
	VirtualMachineTypeUnknown   VirtualMachineType = original.VirtualMachineTypeUnknown
	VirtualMachineTypeVirtualPc VirtualMachineType = original.VirtualMachineTypeVirtualPc
	VirtualMachineTypeVmware    VirtualMachineType = original.VirtualMachineTypeVmware
	VirtualMachineTypeXen       VirtualMachineType = original.VirtualMachineTypeXen
)

type AgentConfiguration = original.AgentConfiguration
type Application = original.Application
type AppsAndRoles = original.AppsAndRoles
type BaseClient = original.BaseClient
type BizTalkServer = original.BizTalkServer
type ErrorDetails = original.ErrorDetails
type ExchangeServer = original.ExchangeServer
type Feature = original.Feature
type GuestOSDetails = original.GuestOSDetails
type HealthErrorDetails = original.HealthErrorDetails
type HostingConfiguration = original.HostingConfiguration
type HyperVCluster = original.HyperVCluster
type HyperVClusterClient = original.HyperVClusterClient
type HyperVClusterCollection = original.HyperVClusterCollection
type HyperVClusterCollectionIterator = original.HyperVClusterCollectionIterator
type HyperVClusterCollectionPage = original.HyperVClusterCollectionPage
type HyperVClusterProperties = original.HyperVClusterProperties
type HyperVDisk = original.HyperVDisk
type HyperVHost = original.HyperVHost
type HyperVHostClient = original.HyperVHostClient
type HyperVHostCollection = original.HyperVHostCollection
type HyperVHostCollectionIterator = original.HyperVHostCollectionIterator
type HyperVHostCollectionPage = original.HyperVHostCollectionPage
type HyperVHostProperties = original.HyperVHostProperties
type HyperVJob = original.HyperVJob
type HyperVJobCollection = original.HyperVJobCollection
type HyperVJobCollectionIterator = original.HyperVJobCollectionIterator
type HyperVJobCollectionPage = original.HyperVJobCollectionPage
type HyperVJobsClient = original.HyperVJobsClient
type HyperVMachine = original.HyperVMachine
type HyperVMachineCollection = original.HyperVMachineCollection
type HyperVMachineCollectionIterator = original.HyperVMachineCollectionIterator
type HyperVMachineCollectionPage = original.HyperVMachineCollectionPage
type HyperVMachineProperties = original.HyperVMachineProperties
type HyperVMachinesClient = original.HyperVMachinesClient
type HyperVNetworkAdapter = original.HyperVNetworkAdapter
type HyperVOperationsStatusClient = original.HyperVOperationsStatusClient
type HyperVRunAsAccount = original.HyperVRunAsAccount
type HyperVRunAsAccountCollection = original.HyperVRunAsAccountCollection
type HyperVRunAsAccountCollectionIterator = original.HyperVRunAsAccountCollectionIterator
type HyperVRunAsAccountCollectionPage = original.HyperVRunAsAccountCollectionPage
type HyperVRunAsAccountsClient = original.HyperVRunAsAccountsClient
type HyperVSite = original.HyperVSite
type HyperVSiteUsage = original.HyperVSiteUsage
type HyperVSitesClient = original.HyperVSitesClient
type HypervisorConfiguration = original.HypervisorConfiguration
type Ipv4NetworkInterface = original.Ipv4NetworkInterface
type Ipv6NetworkInterface = original.Ipv6NetworkInterface
type JobProperties = original.JobProperties
type JobsClient = original.JobsClient
type Machine = original.Machine
type MachineResourcesConfiguration = original.MachineResourcesConfiguration
type MachinesClient = original.MachinesClient
type NetworkConfiguration = original.NetworkConfiguration
type OperatingSystem = original.OperatingSystem
type OperatingSystemConfiguration = original.OperatingSystemConfiguration
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationResultList = original.OperationResultList
type OperationResultListIterator = original.OperationResultListIterator
type OperationResultListPage = original.OperationResultListPage
type OperationStatus = original.OperationStatus
type OperationStatusError = original.OperationStatusError
type OperationStatusProperties = original.OperationStatusProperties
type OperationsClient = original.OperationsClient
type OtherDatabase = original.OtherDatabase
type RunAsAccountProperties = original.RunAsAccountProperties
type RunAsAccountsClient = original.RunAsAccountsClient
type SQLServer = original.SQLServer
type SharePointServer = original.SharePointServer
type SiteAgentProperties = original.SiteAgentProperties
type SiteHealthSummary = original.SiteHealthSummary
type SiteHealthSummaryCollection = original.SiteHealthSummaryCollection
type SiteHealthSummaryCollectionIterator = original.SiteHealthSummaryCollectionIterator
type SiteHealthSummaryCollectionPage = original.SiteHealthSummaryCollectionPage
type SiteProperties = original.SiteProperties
type SiteSpnProperties = original.SiteSpnProperties
type SitesClient = original.SitesClient
type SystemCenter = original.SystemCenter
type Timezone = original.Timezone
type VCenter = original.VCenter
type VCenterClient = original.VCenterClient
type VCenterCollection = original.VCenterCollection
type VCenterCollectionIterator = original.VCenterCollectionIterator
type VCenterCollectionPage = original.VCenterCollectionPage
type VCenterProperties = original.VCenterProperties
type VMwareDisk = original.VMwareDisk
type VMwareJob = original.VMwareJob
type VMwareJobCollection = original.VMwareJobCollection
type VMwareJobCollectionIterator = original.VMwareJobCollectionIterator
type VMwareJobCollectionPage = original.VMwareJobCollectionPage
type VMwareMachine = original.VMwareMachine
type VMwareMachineCollection = original.VMwareMachineCollection
type VMwareMachineCollectionIterator = original.VMwareMachineCollectionIterator
type VMwareMachineCollectionPage = original.VMwareMachineCollectionPage
type VMwareMachineProperties = original.VMwareMachineProperties
type VMwareNetworkAdapter = original.VMwareNetworkAdapter
type VMwareOperationsStatusClient = original.VMwareOperationsStatusClient
type VMwareRunAsAccount = original.VMwareRunAsAccount
type VMwareRunAsAccountCollection = original.VMwareRunAsAccountCollection
type VMwareRunAsAccountCollectionIterator = original.VMwareRunAsAccountCollectionIterator
type VMwareRunAsAccountCollectionPage = original.VMwareRunAsAccountCollectionPage
type VMwareSite = original.VMwareSite
type VMwareSiteUsage = original.VMwareSiteUsage
type VirtualMachineConfiguration = original.VirtualMachineConfiguration
type WebApplication = original.WebApplication

func New() BaseClient {
	return original.New()
}
func NewHyperVClusterClient() HyperVClusterClient {
	return original.NewHyperVClusterClient()
}
func NewHyperVClusterClientWithBaseURI(baseURI string) HyperVClusterClient {
	return original.NewHyperVClusterClientWithBaseURI(baseURI)
}
func NewHyperVClusterCollectionIterator(page HyperVClusterCollectionPage) HyperVClusterCollectionIterator {
	return original.NewHyperVClusterCollectionIterator(page)
}
func NewHyperVClusterCollectionPage(cur HyperVClusterCollection, getNextPage func(context.Context, HyperVClusterCollection) (HyperVClusterCollection, error)) HyperVClusterCollectionPage {
	return original.NewHyperVClusterCollectionPage(cur, getNextPage)
}
func NewHyperVHostClient() HyperVHostClient {
	return original.NewHyperVHostClient()
}
func NewHyperVHostClientWithBaseURI(baseURI string) HyperVHostClient {
	return original.NewHyperVHostClientWithBaseURI(baseURI)
}
func NewHyperVHostCollectionIterator(page HyperVHostCollectionPage) HyperVHostCollectionIterator {
	return original.NewHyperVHostCollectionIterator(page)
}
func NewHyperVHostCollectionPage(cur HyperVHostCollection, getNextPage func(context.Context, HyperVHostCollection) (HyperVHostCollection, error)) HyperVHostCollectionPage {
	return original.NewHyperVHostCollectionPage(cur, getNextPage)
}
func NewHyperVJobCollectionIterator(page HyperVJobCollectionPage) HyperVJobCollectionIterator {
	return original.NewHyperVJobCollectionIterator(page)
}
func NewHyperVJobCollectionPage(cur HyperVJobCollection, getNextPage func(context.Context, HyperVJobCollection) (HyperVJobCollection, error)) HyperVJobCollectionPage {
	return original.NewHyperVJobCollectionPage(cur, getNextPage)
}
func NewHyperVJobsClient() HyperVJobsClient {
	return original.NewHyperVJobsClient()
}
func NewHyperVJobsClientWithBaseURI(baseURI string) HyperVJobsClient {
	return original.NewHyperVJobsClientWithBaseURI(baseURI)
}
func NewHyperVMachineCollectionIterator(page HyperVMachineCollectionPage) HyperVMachineCollectionIterator {
	return original.NewHyperVMachineCollectionIterator(page)
}
func NewHyperVMachineCollectionPage(cur HyperVMachineCollection, getNextPage func(context.Context, HyperVMachineCollection) (HyperVMachineCollection, error)) HyperVMachineCollectionPage {
	return original.NewHyperVMachineCollectionPage(cur, getNextPage)
}
func NewHyperVMachinesClient() HyperVMachinesClient {
	return original.NewHyperVMachinesClient()
}
func NewHyperVMachinesClientWithBaseURI(baseURI string) HyperVMachinesClient {
	return original.NewHyperVMachinesClientWithBaseURI(baseURI)
}
func NewHyperVOperationsStatusClient() HyperVOperationsStatusClient {
	return original.NewHyperVOperationsStatusClient()
}
func NewHyperVOperationsStatusClientWithBaseURI(baseURI string) HyperVOperationsStatusClient {
	return original.NewHyperVOperationsStatusClientWithBaseURI(baseURI)
}
func NewHyperVRunAsAccountCollectionIterator(page HyperVRunAsAccountCollectionPage) HyperVRunAsAccountCollectionIterator {
	return original.NewHyperVRunAsAccountCollectionIterator(page)
}
func NewHyperVRunAsAccountCollectionPage(cur HyperVRunAsAccountCollection, getNextPage func(context.Context, HyperVRunAsAccountCollection) (HyperVRunAsAccountCollection, error)) HyperVRunAsAccountCollectionPage {
	return original.NewHyperVRunAsAccountCollectionPage(cur, getNextPage)
}
func NewHyperVRunAsAccountsClient() HyperVRunAsAccountsClient {
	return original.NewHyperVRunAsAccountsClient()
}
func NewHyperVRunAsAccountsClientWithBaseURI(baseURI string) HyperVRunAsAccountsClient {
	return original.NewHyperVRunAsAccountsClientWithBaseURI(baseURI)
}
func NewHyperVSitesClient() HyperVSitesClient {
	return original.NewHyperVSitesClient()
}
func NewHyperVSitesClientWithBaseURI(baseURI string) HyperVSitesClient {
	return original.NewHyperVSitesClientWithBaseURI(baseURI)
}
func NewJobsClient() JobsClient {
	return original.NewJobsClient()
}
func NewJobsClientWithBaseURI(baseURI string) JobsClient {
	return original.NewJobsClientWithBaseURI(baseURI)
}
func NewMachinesClient() MachinesClient {
	return original.NewMachinesClient()
}
func NewMachinesClientWithBaseURI(baseURI string) MachinesClient {
	return original.NewMachinesClientWithBaseURI(baseURI)
}
func NewOperationResultListIterator(page OperationResultListPage) OperationResultListIterator {
	return original.NewOperationResultListIterator(page)
}
func NewOperationResultListPage(cur OperationResultList, getNextPage func(context.Context, OperationResultList) (OperationResultList, error)) OperationResultListPage {
	return original.NewOperationResultListPage(cur, getNextPage)
}
func NewOperationsClient() OperationsClient {
	return original.NewOperationsClient()
}
func NewOperationsClientWithBaseURI(baseURI string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI)
}
func NewRunAsAccountsClient() RunAsAccountsClient {
	return original.NewRunAsAccountsClient()
}
func NewRunAsAccountsClientWithBaseURI(baseURI string) RunAsAccountsClient {
	return original.NewRunAsAccountsClientWithBaseURI(baseURI)
}
func NewSiteHealthSummaryCollectionIterator(page SiteHealthSummaryCollectionPage) SiteHealthSummaryCollectionIterator {
	return original.NewSiteHealthSummaryCollectionIterator(page)
}
func NewSiteHealthSummaryCollectionPage(cur SiteHealthSummaryCollection, getNextPage func(context.Context, SiteHealthSummaryCollection) (SiteHealthSummaryCollection, error)) SiteHealthSummaryCollectionPage {
	return original.NewSiteHealthSummaryCollectionPage(cur, getNextPage)
}
func NewSitesClient() SitesClient {
	return original.NewSitesClient()
}
func NewSitesClientWithBaseURI(baseURI string) SitesClient {
	return original.NewSitesClientWithBaseURI(baseURI)
}
func NewVCenterClient() VCenterClient {
	return original.NewVCenterClient()
}
func NewVCenterClientWithBaseURI(baseURI string) VCenterClient {
	return original.NewVCenterClientWithBaseURI(baseURI)
}
func NewVCenterCollectionIterator(page VCenterCollectionPage) VCenterCollectionIterator {
	return original.NewVCenterCollectionIterator(page)
}
func NewVCenterCollectionPage(cur VCenterCollection, getNextPage func(context.Context, VCenterCollection) (VCenterCollection, error)) VCenterCollectionPage {
	return original.NewVCenterCollectionPage(cur, getNextPage)
}
func NewVMwareJobCollectionIterator(page VMwareJobCollectionPage) VMwareJobCollectionIterator {
	return original.NewVMwareJobCollectionIterator(page)
}
func NewVMwareJobCollectionPage(cur VMwareJobCollection, getNextPage func(context.Context, VMwareJobCollection) (VMwareJobCollection, error)) VMwareJobCollectionPage {
	return original.NewVMwareJobCollectionPage(cur, getNextPage)
}
func NewVMwareMachineCollectionIterator(page VMwareMachineCollectionPage) VMwareMachineCollectionIterator {
	return original.NewVMwareMachineCollectionIterator(page)
}
func NewVMwareMachineCollectionPage(cur VMwareMachineCollection, getNextPage func(context.Context, VMwareMachineCollection) (VMwareMachineCollection, error)) VMwareMachineCollectionPage {
	return original.NewVMwareMachineCollectionPage(cur, getNextPage)
}
func NewVMwareOperationsStatusClient() VMwareOperationsStatusClient {
	return original.NewVMwareOperationsStatusClient()
}
func NewVMwareOperationsStatusClientWithBaseURI(baseURI string) VMwareOperationsStatusClient {
	return original.NewVMwareOperationsStatusClientWithBaseURI(baseURI)
}
func NewVMwareRunAsAccountCollectionIterator(page VMwareRunAsAccountCollectionPage) VMwareRunAsAccountCollectionIterator {
	return original.NewVMwareRunAsAccountCollectionIterator(page)
}
func NewVMwareRunAsAccountCollectionPage(cur VMwareRunAsAccountCollection, getNextPage func(context.Context, VMwareRunAsAccountCollection) (VMwareRunAsAccountCollection, error)) VMwareRunAsAccountCollectionPage {
	return original.NewVMwareRunAsAccountCollectionPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string) BaseClient {
	return original.NewWithBaseURI(baseURI)
}
func PossibleBitnessValues() []Bitness {
	return original.PossibleBitnessValues()
}
func PossibleCPUSpeedAccuracyValues() []CPUSpeedAccuracy {
	return original.PossibleCPUSpeedAccuracyValues()
}
func PossibleCredentialTypeValues() []CredentialType {
	return original.PossibleCredentialTypeValues()
}
func PossibleFamilyValues() []Family {
	return original.PossibleFamilyValues()
}
func PossibleHighlyAvailableValues() []HighlyAvailable {
	return original.PossibleHighlyAvailableValues()
}
func PossibleHypervisorTypeValues() []HypervisorType {
	return original.PossibleHypervisorTypeValues()
}
func PossiblePropertiesMonitoringStateValues() []PropertiesMonitoringState {
	return original.PossiblePropertiesMonitoringStateValues()
}
func PossiblePropertiesVirtualizationStateValues() []PropertiesVirtualizationState {
	return original.PossiblePropertiesVirtualizationStateValues()
}
func PossibleRebootStatusValues() []RebootStatus {
	return original.PossibleRebootStatusValues()
}
func PossibleVirtualDiskModeValues() []VirtualDiskMode {
	return original.PossibleVirtualDiskModeValues()
}
func PossibleVirtualMachineTypeValues() []VirtualMachineType {
	return original.PossibleVirtualMachineTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
