+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "BackendSrv"
keywords = ["grafana","documentation","sdk","@grafana/runtime"]
type = "docs"
+++

## BackendSrv interface

Used to communicate via http(s) to a remote backend such as the Grafana backend, a datasource etc. The BackendSrv is using the [Fetch API](https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API) under the hood to handle all the communication.

The request function can be used to perform a remote call by specifying a [BackendSrvRequest](./runtime/backendsrvrequest.md)<!-- -->. To make the BackendSrv a bit easier to use we have added a couple of shorthand functions that will use default values executing the request.

<b>Signature</b>

```typescript
export interface BackendSrv
```

<b>Import</b>

```typescript
import { BackendSrv } from '@grafana/runtime';
```

## Remarks

By default Grafana will display an error message alert if the remote call fails. If you want to prevent this from happending you need to catch the error thrown by the BackendSrv and set the `showErrorAlert = true` on the request options object.

> In versions prior to v7.2 you disable the notification alert by setting isHandled on the caught error

<b>Methods</b>

| Method                                                  | Description                                                                                                                                                                                                                                                                              |
| ------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [datasourceRequest(options)](#datasourcerequest-method) | Special function used to communicate with datasources that will emit core events that the Grafana QueryInspector and QueryEditor is listening for to be able to display datasource query information. Can be skipped by adding <code>option.silent</code> when initializing the request. |
| [delete(url)](#delete-method)                           |                                                                                                                                                                                                                                                                                          |
| [get(url, params, requestId)](#get-method)              |                                                                                                                                                                                                                                                                                          |
| [patch(url, data)](#patch-method)                       |                                                                                                                                                                                                                                                                                          |
| [post(url, data)](#post-method)                         |                                                                                                                                                                                                                                                                                          |
| [put(url, data)](#put-method)                           |                                                                                                                                                                                                                                                                                          |
| [request(options)](#request-method)                     |                                                                                                                                                                                                                                                                                          |

### datasourceRequest method

Special function used to communicate with datasources that will emit core events that the Grafana QueryInspector and QueryEditor is listening for to be able to display datasource query information. Can be skipped by adding `option.silent` when initializing the request.

<b>Signature</b>

```typescript
datasourceRequest(options: BackendSrvRequest): Promise<any>;
```

<b>Parameters</b>

| Parameter | Type                           | Description |
| --------- | ------------------------------ | ----------- |
| options   | <code>BackendSrvRequest</code> |             |

<b>Returns:</b>

`Promise<any>`

### delete method

<b>Signature</b>

```typescript
delete(url: string): Promise<any>;
```

<b>Parameters</b>

| Parameter | Type                | Description |
| --------- | ------------------- | ----------- |
| url       | <code>string</code> |             |

<b>Returns:</b>

`Promise<any>`

### get method

<b>Signature</b>

```typescript
get(url: string, params?: any, requestId?: string): Promise<any>;
```

<b>Parameters</b>

| Parameter | Type                | Description |
| --------- | ------------------- | ----------- |
| url       | <code>string</code> |             |
| params    | <code>any</code>    |             |
| requestId | <code>string</code> |             |

<b>Returns:</b>

`Promise<any>`

### patch method

<b>Signature</b>

```typescript
patch(url: string, data?: any): Promise<any>;
```

<b>Parameters</b>

| Parameter | Type                | Description |
| --------- | ------------------- | ----------- |
| url       | <code>string</code> |             |
| data      | <code>any</code>    |             |

<b>Returns:</b>

`Promise<any>`

### post method

<b>Signature</b>

```typescript
post(url: string, data?: any): Promise<any>;
```

<b>Parameters</b>

| Parameter | Type                | Description |
| --------- | ------------------- | ----------- |
| url       | <code>string</code> |             |
| data      | <code>any</code>    |             |

<b>Returns:</b>

`Promise<any>`

### put method

<b>Signature</b>

```typescript
put(url: string, data?: any): Promise<any>;
```

<b>Parameters</b>

| Parameter | Type                | Description |
| --------- | ------------------- | ----------- |
| url       | <code>string</code> |             |
| data      | <code>any</code>    |             |

<b>Returns:</b>

`Promise<any>`

### request method

<b>Signature</b>

```typescript
request(options: BackendSrvRequest): Promise<any>;
```

<b>Parameters</b>

| Parameter | Type                           | Description |
| --------- | ------------------------------ | ----------- |
| options   | <code>BackendSrvRequest</code> |             |

<b>Returns:</b>

`Promise<any>`
