package catalog

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// Client is the creates an Azure Data Lake Analytics catalog client.
type Client struct {
	BaseClient
}

// NewClient creates an instance of the Client client.
func NewClient() Client {
	return Client{New()}
}

// CreateSecret creates the specified secret for use with external data sources in the specified database.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database in which to create the secret.
// secretName - the name of the secret.
// parameters - the parameters required to create the secret (name and password)
func (client Client) CreateSecret(ctx context.Context, accountName string, databaseName string, secretName string, parameters DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters) (result USQLSecret, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.CreateSecret")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Password", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("catalog.Client", "CreateSecret", err.Error())
	}

	req, err := client.CreateSecretPreparer(ctx, accountName, databaseName, secretName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "CreateSecret", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSecretSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "CreateSecret", resp, "Failure sending request")
		return
	}

	result, err = client.CreateSecretResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "CreateSecret", resp, "Failure responding to request")
	}

	return
}

// CreateSecretPreparer prepares the CreateSecret request.
func (client Client) CreateSecretPreparer(ctx context.Context, accountName string, databaseName string, secretName string, parameters DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
		"secretName":   autorest.Encode("path", secretName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/secrets/{secretName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSecretSender sends the CreateSecret request. The method will close the
// http.Response Body if it receives an error.
func (client Client) CreateSecretSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateSecretResponder handles the response to the CreateSecret request. The method always
// closes the http.Response Body.
func (client Client) CreateSecretResponder(resp *http.Response) (result USQLSecret, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteAllSecrets deletes all secrets in the specified database
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the secret.
func (client Client) DeleteAllSecrets(ctx context.Context, accountName string, databaseName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.DeleteAllSecrets")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteAllSecretsPreparer(ctx, accountName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "DeleteAllSecrets", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteAllSecretsSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "catalog.Client", "DeleteAllSecrets", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteAllSecretsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "DeleteAllSecrets", resp, "Failure responding to request")
	}

	return
}

// DeleteAllSecretsPreparer prepares the DeleteAllSecrets request.
func (client Client) DeleteAllSecretsPreparer(ctx context.Context, accountName string, databaseName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/secrets", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteAllSecretsSender sends the DeleteAllSecrets request. The method will close the
// http.Response Body if it receives an error.
func (client Client) DeleteAllSecretsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteAllSecretsResponder handles the response to the DeleteAllSecrets request. The method always
// closes the http.Response Body.
func (client Client) DeleteAllSecretsResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSecret deletes the specified secret in the specified database
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the secret.
// secretName - the name of the secret to delete
func (client Client) DeleteSecret(ctx context.Context, accountName string, databaseName string, secretName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.DeleteSecret")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSecretPreparer(ctx, accountName, databaseName, secretName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "DeleteSecret", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSecretSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "catalog.Client", "DeleteSecret", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSecretResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "DeleteSecret", resp, "Failure responding to request")
	}

	return
}

// DeleteSecretPreparer prepares the DeleteSecret request.
func (client Client) DeleteSecretPreparer(ctx context.Context, accountName string, databaseName string, secretName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
		"secretName":   autorest.Encode("path", secretName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/secrets/{secretName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSecretSender sends the DeleteSecret request. The method will close the
// http.Response Body if it receives an error.
func (client Client) DeleteSecretSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteSecretResponder handles the response to the DeleteSecret request. The method always
// closes the http.Response Body.
func (client Client) DeleteSecretResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetAssembly retrieves the specified assembly from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the assembly.
// assemblyName - the name of the assembly.
func (client Client) GetAssembly(ctx context.Context, accountName string, databaseName string, assemblyName string) (result USQLAssembly, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetAssembly")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAssemblyPreparer(ctx, accountName, databaseName, assemblyName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetAssembly", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAssemblySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetAssembly", resp, "Failure sending request")
		return
	}

	result, err = client.GetAssemblyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetAssembly", resp, "Failure responding to request")
	}

	return
}

// GetAssemblyPreparer prepares the GetAssembly request.
func (client Client) GetAssemblyPreparer(ctx context.Context, accountName string, databaseName string, assemblyName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"assemblyName": autorest.Encode("path", assemblyName),
		"databaseName": autorest.Encode("path", databaseName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/assemblies/{assemblyName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAssemblySender sends the GetAssembly request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetAssemblySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAssemblyResponder handles the response to the GetAssembly request. The method always
// closes the http.Response Body.
func (client Client) GetAssemblyResponder(resp *http.Response) (result USQLAssembly, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCredential retrieves the specified credential from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the schema.
// credentialName - the name of the credential.
func (client Client) GetCredential(ctx context.Context, accountName string, databaseName string, credentialName string) (result USQLCredential, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetCredential")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetCredentialPreparer(ctx, accountName, databaseName, credentialName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetCredential", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCredentialSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetCredential", resp, "Failure sending request")
		return
	}

	result, err = client.GetCredentialResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetCredential", resp, "Failure responding to request")
	}

	return
}

// GetCredentialPreparer prepares the GetCredential request.
func (client Client) GetCredentialPreparer(ctx context.Context, accountName string, databaseName string, credentialName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"credentialName": autorest.Encode("path", credentialName),
		"databaseName":   autorest.Encode("path", databaseName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/credentials/{credentialName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCredentialSender sends the GetCredential request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetCredentialSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetCredentialResponder handles the response to the GetCredential request. The method always
// closes the http.Response Body.
func (client Client) GetCredentialResponder(resp *http.Response) (result USQLCredential, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDatabase retrieves the specified database from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database.
func (client Client) GetDatabase(ctx context.Context, accountName string, databaseName string) (result USQLDatabase, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetDatabase")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDatabasePreparer(ctx, accountName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetDatabase", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDatabaseSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetDatabase", resp, "Failure sending request")
		return
	}

	result, err = client.GetDatabaseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetDatabase", resp, "Failure responding to request")
	}

	return
}

// GetDatabasePreparer prepares the GetDatabase request.
func (client Client) GetDatabasePreparer(ctx context.Context, accountName string, databaseName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDatabaseSender sends the GetDatabase request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetDatabaseSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetDatabaseResponder handles the response to the GetDatabase request. The method always
// closes the http.Response Body.
func (client Client) GetDatabaseResponder(resp *http.Response) (result USQLDatabase, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetExternalDataSource retrieves the specified external data source from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the external data source.
// externalDataSourceName - the name of the external data source.
func (client Client) GetExternalDataSource(ctx context.Context, accountName string, databaseName string, externalDataSourceName string) (result USQLExternalDataSource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetExternalDataSource")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetExternalDataSourcePreparer(ctx, accountName, databaseName, externalDataSourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetExternalDataSource", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetExternalDataSourceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetExternalDataSource", resp, "Failure sending request")
		return
	}

	result, err = client.GetExternalDataSourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetExternalDataSource", resp, "Failure responding to request")
	}

	return
}

// GetExternalDataSourcePreparer prepares the GetExternalDataSource request.
func (client Client) GetExternalDataSourcePreparer(ctx context.Context, accountName string, databaseName string, externalDataSourceName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName":           autorest.Encode("path", databaseName),
		"externalDataSourceName": autorest.Encode("path", externalDataSourceName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/externaldatasources/{externalDataSourceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetExternalDataSourceSender sends the GetExternalDataSource request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetExternalDataSourceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetExternalDataSourceResponder handles the response to the GetExternalDataSource request. The method always
// closes the http.Response Body.
func (client Client) GetExternalDataSourceResponder(resp *http.Response) (result USQLExternalDataSource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProcedure retrieves the specified procedure from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the procedure.
// schemaName - the name of the schema containing the procedure.
// procedureName - the name of the procedure.
func (client Client) GetProcedure(ctx context.Context, accountName string, databaseName string, schemaName string, procedureName string) (result USQLProcedure, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetProcedure")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetProcedurePreparer(ctx, accountName, databaseName, schemaName, procedureName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetProcedure", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProcedureSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetProcedure", resp, "Failure sending request")
		return
	}

	result, err = client.GetProcedureResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetProcedure", resp, "Failure responding to request")
	}

	return
}

// GetProcedurePreparer prepares the GetProcedure request.
func (client Client) GetProcedurePreparer(ctx context.Context, accountName string, databaseName string, schemaName string, procedureName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName":  autorest.Encode("path", databaseName),
		"procedureName": autorest.Encode("path", procedureName),
		"schemaName":    autorest.Encode("path", schemaName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/procedures/{procedureName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetProcedureSender sends the GetProcedure request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetProcedureSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetProcedureResponder handles the response to the GetProcedure request. The method always
// closes the http.Response Body.
func (client Client) GetProcedureResponder(resp *http.Response) (result USQLProcedure, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSchema retrieves the specified schema from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the schema.
// schemaName - the name of the schema.
func (client Client) GetSchema(ctx context.Context, accountName string, databaseName string, schemaName string) (result USQLSchema, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetSchema")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSchemaPreparer(ctx, accountName, databaseName, schemaName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetSchema", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSchemaSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetSchema", resp, "Failure sending request")
		return
	}

	result, err = client.GetSchemaResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetSchema", resp, "Failure responding to request")
	}

	return
}

// GetSchemaPreparer prepares the GetSchema request.
func (client Client) GetSchemaPreparer(ctx context.Context, accountName string, databaseName string, schemaName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
		"schemaName":   autorest.Encode("path", schemaName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSchemaSender sends the GetSchema request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetSchemaSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetSchemaResponder handles the response to the GetSchema request. The method always
// closes the http.Response Body.
func (client Client) GetSchemaResponder(resp *http.Response) (result USQLSchema, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSecret gets the specified secret in the specified database
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the secret.
// secretName - the name of the secret to get
func (client Client) GetSecret(ctx context.Context, accountName string, databaseName string, secretName string) (result USQLSecret, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetSecret")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSecretPreparer(ctx, accountName, databaseName, secretName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetSecret", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSecretSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetSecret", resp, "Failure sending request")
		return
	}

	result, err = client.GetSecretResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetSecret", resp, "Failure responding to request")
	}

	return
}

// GetSecretPreparer prepares the GetSecret request.
func (client Client) GetSecretPreparer(ctx context.Context, accountName string, databaseName string, secretName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
		"secretName":   autorest.Encode("path", secretName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/secrets/{secretName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSecretSender sends the GetSecret request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetSecretSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetSecretResponder handles the response to the GetSecret request. The method always
// closes the http.Response Body.
func (client Client) GetSecretResponder(resp *http.Response) (result USQLSecret, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTable retrieves the specified table from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the table.
// schemaName - the name of the schema containing the table.
// tableName - the name of the table.
func (client Client) GetTable(ctx context.Context, accountName string, databaseName string, schemaName string, tableName string) (result USQLTable, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetTable")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetTablePreparer(ctx, accountName, databaseName, schemaName, tableName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetTable", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTableSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetTable", resp, "Failure sending request")
		return
	}

	result, err = client.GetTableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetTable", resp, "Failure responding to request")
	}

	return
}

// GetTablePreparer prepares the GetTable request.
func (client Client) GetTablePreparer(ctx context.Context, accountName string, databaseName string, schemaName string, tableName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
		"schemaName":   autorest.Encode("path", schemaName),
		"tableName":    autorest.Encode("path", tableName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetTableSender sends the GetTable request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetTableSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetTableResponder handles the response to the GetTable request. The method always
// closes the http.Response Body.
func (client Client) GetTableResponder(resp *http.Response) (result USQLTable, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTablePartition retrieves the specified table partition from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the partition.
// schemaName - the name of the schema containing the partition.
// tableName - the name of the table containing the partition.
// partitionName - the name of the table partition.
func (client Client) GetTablePartition(ctx context.Context, accountName string, databaseName string, schemaName string, tableName string, partitionName string) (result USQLTablePartition, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetTablePartition")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetTablePartitionPreparer(ctx, accountName, databaseName, schemaName, tableName, partitionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetTablePartition", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTablePartitionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetTablePartition", resp, "Failure sending request")
		return
	}

	result, err = client.GetTablePartitionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetTablePartition", resp, "Failure responding to request")
	}

	return
}

// GetTablePartitionPreparer prepares the GetTablePartition request.
func (client Client) GetTablePartitionPreparer(ctx context.Context, accountName string, databaseName string, schemaName string, tableName string, partitionName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName":  autorest.Encode("path", databaseName),
		"partitionName": autorest.Encode("path", partitionName),
		"schemaName":    autorest.Encode("path", schemaName),
		"tableName":     autorest.Encode("path", tableName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/partitions/{partitionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetTablePartitionSender sends the GetTablePartition request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetTablePartitionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetTablePartitionResponder handles the response to the GetTablePartition request. The method always
// closes the http.Response Body.
func (client Client) GetTablePartitionResponder(resp *http.Response) (result USQLTablePartition, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTableStatistic retrieves the specified table statistics from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the statistics.
// schemaName - the name of the schema containing the statistics.
// tableName - the name of the table containing the statistics.
// statisticsName - the name of the table statistics.
func (client Client) GetTableStatistic(ctx context.Context, accountName string, databaseName string, schemaName string, tableName string, statisticsName string) (result USQLTableStatistics, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetTableStatistic")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetTableStatisticPreparer(ctx, accountName, databaseName, schemaName, tableName, statisticsName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetTableStatistic", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTableStatisticSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetTableStatistic", resp, "Failure sending request")
		return
	}

	result, err = client.GetTableStatisticResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetTableStatistic", resp, "Failure responding to request")
	}

	return
}

// GetTableStatisticPreparer prepares the GetTableStatistic request.
func (client Client) GetTableStatisticPreparer(ctx context.Context, accountName string, databaseName string, schemaName string, tableName string, statisticsName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName":   autorest.Encode("path", databaseName),
		"schemaName":     autorest.Encode("path", schemaName),
		"statisticsName": autorest.Encode("path", statisticsName),
		"tableName":      autorest.Encode("path", tableName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/statistics/{statisticsName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetTableStatisticSender sends the GetTableStatistic request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetTableStatisticSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetTableStatisticResponder handles the response to the GetTableStatistic request. The method always
// closes the http.Response Body.
func (client Client) GetTableStatisticResponder(resp *http.Response) (result USQLTableStatistics, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTableType retrieves the specified table type from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the table type.
// schemaName - the name of the schema containing the table type.
// tableTypeName - the name of the table type to retrieve.
func (client Client) GetTableType(ctx context.Context, accountName string, databaseName string, schemaName string, tableTypeName string) (result USQLTableType, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetTableType")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetTableTypePreparer(ctx, accountName, databaseName, schemaName, tableTypeName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetTableType", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTableTypeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetTableType", resp, "Failure sending request")
		return
	}

	result, err = client.GetTableTypeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetTableType", resp, "Failure responding to request")
	}

	return
}

// GetTableTypePreparer prepares the GetTableType request.
func (client Client) GetTableTypePreparer(ctx context.Context, accountName string, databaseName string, schemaName string, tableTypeName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName":  autorest.Encode("path", databaseName),
		"schemaName":    autorest.Encode("path", schemaName),
		"tableTypeName": autorest.Encode("path", tableTypeName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tabletypes/{tableTypeName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetTableTypeSender sends the GetTableType request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetTableTypeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetTableTypeResponder handles the response to the GetTableType request. The method always
// closes the http.Response Body.
func (client Client) GetTableTypeResponder(resp *http.Response) (result USQLTableType, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTableValuedFunction retrieves the specified table valued function from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the table valued function.
// schemaName - the name of the schema containing the table valued function.
// tableValuedFunctionName - the name of the tableValuedFunction.
func (client Client) GetTableValuedFunction(ctx context.Context, accountName string, databaseName string, schemaName string, tableValuedFunctionName string) (result USQLTableValuedFunction, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetTableValuedFunction")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetTableValuedFunctionPreparer(ctx, accountName, databaseName, schemaName, tableValuedFunctionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetTableValuedFunction", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTableValuedFunctionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetTableValuedFunction", resp, "Failure sending request")
		return
	}

	result, err = client.GetTableValuedFunctionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetTableValuedFunction", resp, "Failure responding to request")
	}

	return
}

// GetTableValuedFunctionPreparer prepares the GetTableValuedFunction request.
func (client Client) GetTableValuedFunctionPreparer(ctx context.Context, accountName string, databaseName string, schemaName string, tableValuedFunctionName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName":            autorest.Encode("path", databaseName),
		"schemaName":              autorest.Encode("path", schemaName),
		"tableValuedFunctionName": autorest.Encode("path", tableValuedFunctionName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tablevaluedfunctions/{tableValuedFunctionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetTableValuedFunctionSender sends the GetTableValuedFunction request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetTableValuedFunctionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetTableValuedFunctionResponder handles the response to the GetTableValuedFunction request. The method always
// closes the http.Response Body.
func (client Client) GetTableValuedFunctionResponder(resp *http.Response) (result USQLTableValuedFunction, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetView retrieves the specified view from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the view.
// schemaName - the name of the schema containing the view.
// viewName - the name of the view.
func (client Client) GetView(ctx context.Context, accountName string, databaseName string, schemaName string, viewName string) (result USQLView, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetView")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetViewPreparer(ctx, accountName, databaseName, schemaName, viewName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetView", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetViewSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetView", resp, "Failure sending request")
		return
	}

	result, err = client.GetViewResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "GetView", resp, "Failure responding to request")
	}

	return
}

// GetViewPreparer prepares the GetView request.
func (client Client) GetViewPreparer(ctx context.Context, accountName string, databaseName string, schemaName string, viewName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
		"schemaName":   autorest.Encode("path", schemaName),
		"viewName":     autorest.Encode("path", viewName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/views/{viewName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetViewSender sends the GetView request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetViewSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetViewResponder handles the response to the GetView request. The method always
// closes the http.Response Body.
func (client Client) GetViewResponder(resp *http.Response) (result USQLView, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAssemblies retrieves the list of assemblies from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the assembly.
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories?$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
func (client Client) ListAssemblies(ctx context.Context, accountName string, databaseName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLAssemblyListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListAssemblies")
		defer func() {
			sc := -1
			if result.ual.Response.Response != nil {
				sc = result.ual.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listAssembliesNextResults
	req, err := client.ListAssembliesPreparer(ctx, accountName, databaseName, filter, top, skip, expand, selectParameter, orderby, count)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListAssemblies", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAssembliesSender(req)
	if err != nil {
		result.ual.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListAssemblies", resp, "Failure sending request")
		return
	}

	result.ual, err = client.ListAssembliesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListAssemblies", resp, "Failure responding to request")
	}

	return
}

// ListAssembliesPreparer prepares the ListAssemblies request.
func (client Client) ListAssembliesPreparer(ctx context.Context, accountName string, databaseName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/assemblies", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAssembliesSender sends the ListAssemblies request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListAssembliesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListAssembliesResponder handles the response to the ListAssemblies request. The method always
// closes the http.Response Body.
func (client Client) ListAssembliesResponder(resp *http.Response) (result USQLAssemblyList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listAssembliesNextResults retrieves the next set of results, if any.
func (client Client) listAssembliesNextResults(ctx context.Context, lastResults USQLAssemblyList) (result USQLAssemblyList, err error) {
	req, err := lastResults.uSQLAssemblyListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listAssembliesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListAssembliesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listAssembliesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListAssembliesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "listAssembliesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListAssembliesComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListAssembliesComplete(ctx context.Context, accountName string, databaseName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLAssemblyListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListAssemblies")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListAssemblies(ctx, accountName, databaseName, filter, top, skip, expand, selectParameter, orderby, count)
	return
}

// ListCredentials retrieves the list of credentials from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the schema.
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories?$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
func (client Client) ListCredentials(ctx context.Context, accountName string, databaseName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLCredentialListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListCredentials")
		defer func() {
			sc := -1
			if result.ucl.Response.Response != nil {
				sc = result.ucl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listCredentialsNextResults
	req, err := client.ListCredentialsPreparer(ctx, accountName, databaseName, filter, top, skip, expand, selectParameter, orderby, count)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListCredentials", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCredentialsSender(req)
	if err != nil {
		result.ucl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListCredentials", resp, "Failure sending request")
		return
	}

	result.ucl, err = client.ListCredentialsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListCredentials", resp, "Failure responding to request")
	}

	return
}

// ListCredentialsPreparer prepares the ListCredentials request.
func (client Client) ListCredentialsPreparer(ctx context.Context, accountName string, databaseName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/credentials", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCredentialsSender sends the ListCredentials request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListCredentialsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListCredentialsResponder handles the response to the ListCredentials request. The method always
// closes the http.Response Body.
func (client Client) ListCredentialsResponder(resp *http.Response) (result USQLCredentialList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listCredentialsNextResults retrieves the next set of results, if any.
func (client Client) listCredentialsNextResults(ctx context.Context, lastResults USQLCredentialList) (result USQLCredentialList, err error) {
	req, err := lastResults.uSQLCredentialListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listCredentialsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListCredentialsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listCredentialsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListCredentialsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "listCredentialsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListCredentialsComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListCredentialsComplete(ctx context.Context, accountName string, databaseName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLCredentialListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListCredentials")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListCredentials(ctx, accountName, databaseName, filter, top, skip, expand, selectParameter, orderby, count)
	return
}

// ListDatabases retrieves the list of databases from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories?$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
func (client Client) ListDatabases(ctx context.Context, accountName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLDatabaseListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListDatabases")
		defer func() {
			sc := -1
			if result.udl.Response.Response != nil {
				sc = result.udl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listDatabasesNextResults
	req, err := client.ListDatabasesPreparer(ctx, accountName, filter, top, skip, expand, selectParameter, orderby, count)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListDatabases", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDatabasesSender(req)
	if err != nil {
		result.udl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListDatabases", resp, "Failure sending request")
		return
	}

	result.udl, err = client.ListDatabasesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListDatabases", resp, "Failure responding to request")
	}

	return
}

// ListDatabasesPreparer prepares the ListDatabases request.
func (client Client) ListDatabasesPreparer(ctx context.Context, accountName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPath("/catalog/usql/databases"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDatabasesSender sends the ListDatabases request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListDatabasesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListDatabasesResponder handles the response to the ListDatabases request. The method always
// closes the http.Response Body.
func (client Client) ListDatabasesResponder(resp *http.Response) (result USQLDatabaseList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listDatabasesNextResults retrieves the next set of results, if any.
func (client Client) listDatabasesNextResults(ctx context.Context, lastResults USQLDatabaseList) (result USQLDatabaseList, err error) {
	req, err := lastResults.uSQLDatabaseListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listDatabasesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListDatabasesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listDatabasesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListDatabasesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "listDatabasesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListDatabasesComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListDatabasesComplete(ctx context.Context, accountName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLDatabaseListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListDatabases")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListDatabases(ctx, accountName, filter, top, skip, expand, selectParameter, orderby, count)
	return
}

// ListExternalDataSources retrieves the list of external data sources from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the external data sources.
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories?$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
func (client Client) ListExternalDataSources(ctx context.Context, accountName string, databaseName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLExternalDataSourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListExternalDataSources")
		defer func() {
			sc := -1
			if result.uedsl.Response.Response != nil {
				sc = result.uedsl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listExternalDataSourcesNextResults
	req, err := client.ListExternalDataSourcesPreparer(ctx, accountName, databaseName, filter, top, skip, expand, selectParameter, orderby, count)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListExternalDataSources", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListExternalDataSourcesSender(req)
	if err != nil {
		result.uedsl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListExternalDataSources", resp, "Failure sending request")
		return
	}

	result.uedsl, err = client.ListExternalDataSourcesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListExternalDataSources", resp, "Failure responding to request")
	}

	return
}

// ListExternalDataSourcesPreparer prepares the ListExternalDataSources request.
func (client Client) ListExternalDataSourcesPreparer(ctx context.Context, accountName string, databaseName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/externaldatasources", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListExternalDataSourcesSender sends the ListExternalDataSources request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListExternalDataSourcesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListExternalDataSourcesResponder handles the response to the ListExternalDataSources request. The method always
// closes the http.Response Body.
func (client Client) ListExternalDataSourcesResponder(resp *http.Response) (result USQLExternalDataSourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listExternalDataSourcesNextResults retrieves the next set of results, if any.
func (client Client) listExternalDataSourcesNextResults(ctx context.Context, lastResults USQLExternalDataSourceList) (result USQLExternalDataSourceList, err error) {
	req, err := lastResults.uSQLExternalDataSourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listExternalDataSourcesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListExternalDataSourcesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listExternalDataSourcesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListExternalDataSourcesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "listExternalDataSourcesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListExternalDataSourcesComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListExternalDataSourcesComplete(ctx context.Context, accountName string, databaseName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLExternalDataSourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListExternalDataSources")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListExternalDataSources(ctx, accountName, databaseName, filter, top, skip, expand, selectParameter, orderby, count)
	return
}

// ListProcedures retrieves the list of procedures from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the procedures.
// schemaName - the name of the schema containing the procedures.
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories?$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
func (client Client) ListProcedures(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLProcedureListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListProcedures")
		defer func() {
			sc := -1
			if result.upl.Response.Response != nil {
				sc = result.upl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listProceduresNextResults
	req, err := client.ListProceduresPreparer(ctx, accountName, databaseName, schemaName, filter, top, skip, expand, selectParameter, orderby, count)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListProcedures", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListProceduresSender(req)
	if err != nil {
		result.upl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListProcedures", resp, "Failure sending request")
		return
	}

	result.upl, err = client.ListProceduresResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListProcedures", resp, "Failure responding to request")
	}

	return
}

// ListProceduresPreparer prepares the ListProcedures request.
func (client Client) ListProceduresPreparer(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
		"schemaName":   autorest.Encode("path", schemaName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/procedures", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListProceduresSender sends the ListProcedures request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListProceduresSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListProceduresResponder handles the response to the ListProcedures request. The method always
// closes the http.Response Body.
func (client Client) ListProceduresResponder(resp *http.Response) (result USQLProcedureList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listProceduresNextResults retrieves the next set of results, if any.
func (client Client) listProceduresNextResults(ctx context.Context, lastResults USQLProcedureList) (result USQLProcedureList, err error) {
	req, err := lastResults.uSQLProcedureListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listProceduresNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListProceduresSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listProceduresNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListProceduresResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "listProceduresNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListProceduresComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListProceduresComplete(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLProcedureListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListProcedures")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListProcedures(ctx, accountName, databaseName, schemaName, filter, top, skip, expand, selectParameter, orderby, count)
	return
}

// ListSchemas retrieves the list of schemas from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the schema.
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories?$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
func (client Client) ListSchemas(ctx context.Context, accountName string, databaseName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLSchemaListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListSchemas")
		defer func() {
			sc := -1
			if result.usl.Response.Response != nil {
				sc = result.usl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listSchemasNextResults
	req, err := client.ListSchemasPreparer(ctx, accountName, databaseName, filter, top, skip, expand, selectParameter, orderby, count)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListSchemas", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSchemasSender(req)
	if err != nil {
		result.usl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListSchemas", resp, "Failure sending request")
		return
	}

	result.usl, err = client.ListSchemasResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListSchemas", resp, "Failure responding to request")
	}

	return
}

// ListSchemasPreparer prepares the ListSchemas request.
func (client Client) ListSchemasPreparer(ctx context.Context, accountName string, databaseName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSchemasSender sends the ListSchemas request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListSchemasSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListSchemasResponder handles the response to the ListSchemas request. The method always
// closes the http.Response Body.
func (client Client) ListSchemasResponder(resp *http.Response) (result USQLSchemaList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSchemasNextResults retrieves the next set of results, if any.
func (client Client) listSchemasNextResults(ctx context.Context, lastResults USQLSchemaList) (result USQLSchemaList, err error) {
	req, err := lastResults.uSQLSchemaListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listSchemasNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSchemasSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listSchemasNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSchemasResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "listSchemasNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSchemasComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListSchemasComplete(ctx context.Context, accountName string, databaseName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLSchemaListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListSchemas")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSchemas(ctx, accountName, databaseName, filter, top, skip, expand, selectParameter, orderby, count)
	return
}

// ListTablePartitions retrieves the list of table partitions from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the partitions.
// schemaName - the name of the schema containing the partitions.
// tableName - the name of the table containing the partitions.
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories?$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
func (client Client) ListTablePartitions(ctx context.Context, accountName string, databaseName string, schemaName string, tableName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLTablePartitionListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListTablePartitions")
		defer func() {
			sc := -1
			if result.utpl.Response.Response != nil {
				sc = result.utpl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listTablePartitionsNextResults
	req, err := client.ListTablePartitionsPreparer(ctx, accountName, databaseName, schemaName, tableName, filter, top, skip, expand, selectParameter, orderby, count)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTablePartitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListTablePartitionsSender(req)
	if err != nil {
		result.utpl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTablePartitions", resp, "Failure sending request")
		return
	}

	result.utpl, err = client.ListTablePartitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTablePartitions", resp, "Failure responding to request")
	}

	return
}

// ListTablePartitionsPreparer prepares the ListTablePartitions request.
func (client Client) ListTablePartitionsPreparer(ctx context.Context, accountName string, databaseName string, schemaName string, tableName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
		"schemaName":   autorest.Encode("path", schemaName),
		"tableName":    autorest.Encode("path", tableName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/partitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListTablePartitionsSender sends the ListTablePartitions request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListTablePartitionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListTablePartitionsResponder handles the response to the ListTablePartitions request. The method always
// closes the http.Response Body.
func (client Client) ListTablePartitionsResponder(resp *http.Response) (result USQLTablePartitionList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listTablePartitionsNextResults retrieves the next set of results, if any.
func (client Client) listTablePartitionsNextResults(ctx context.Context, lastResults USQLTablePartitionList) (result USQLTablePartitionList, err error) {
	req, err := lastResults.uSQLTablePartitionListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listTablePartitionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListTablePartitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listTablePartitionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListTablePartitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "listTablePartitionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListTablePartitionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListTablePartitionsComplete(ctx context.Context, accountName string, databaseName string, schemaName string, tableName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLTablePartitionListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListTablePartitions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListTablePartitions(ctx, accountName, databaseName, schemaName, tableName, filter, top, skip, expand, selectParameter, orderby, count)
	return
}

// ListTables retrieves the list of tables from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the tables.
// schemaName - the name of the schema containing the tables.
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories?$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
func (client Client) ListTables(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLTableListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListTables")
		defer func() {
			sc := -1
			if result.utl.Response.Response != nil {
				sc = result.utl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listTablesNextResults
	req, err := client.ListTablesPreparer(ctx, accountName, databaseName, schemaName, filter, top, skip, expand, selectParameter, orderby, count)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTables", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListTablesSender(req)
	if err != nil {
		result.utl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTables", resp, "Failure sending request")
		return
	}

	result.utl, err = client.ListTablesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTables", resp, "Failure responding to request")
	}

	return
}

// ListTablesPreparer prepares the ListTables request.
func (client Client) ListTablesPreparer(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
		"schemaName":   autorest.Encode("path", schemaName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListTablesSender sends the ListTables request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListTablesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListTablesResponder handles the response to the ListTables request. The method always
// closes the http.Response Body.
func (client Client) ListTablesResponder(resp *http.Response) (result USQLTableList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listTablesNextResults retrieves the next set of results, if any.
func (client Client) listTablesNextResults(ctx context.Context, lastResults USQLTableList) (result USQLTableList, err error) {
	req, err := lastResults.uSQLTableListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listTablesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListTablesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listTablesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListTablesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "listTablesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListTablesComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListTablesComplete(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLTableListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListTables")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListTables(ctx, accountName, databaseName, schemaName, filter, top, skip, expand, selectParameter, orderby, count)
	return
}

// ListTableStatistics retrieves the list of table statistics from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the statistics.
// schemaName - the name of the schema containing the statistics.
// tableName - the name of the table containing the statistics.
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories?$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
func (client Client) ListTableStatistics(ctx context.Context, accountName string, databaseName string, schemaName string, tableName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLTableStatisticsListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListTableStatistics")
		defer func() {
			sc := -1
			if result.utsl.Response.Response != nil {
				sc = result.utsl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listTableStatisticsNextResults
	req, err := client.ListTableStatisticsPreparer(ctx, accountName, databaseName, schemaName, tableName, filter, top, skip, expand, selectParameter, orderby, count)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTableStatistics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListTableStatisticsSender(req)
	if err != nil {
		result.utsl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTableStatistics", resp, "Failure sending request")
		return
	}

	result.utsl, err = client.ListTableStatisticsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTableStatistics", resp, "Failure responding to request")
	}

	return
}

// ListTableStatisticsPreparer prepares the ListTableStatistics request.
func (client Client) ListTableStatisticsPreparer(ctx context.Context, accountName string, databaseName string, schemaName string, tableName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
		"schemaName":   autorest.Encode("path", schemaName),
		"tableName":    autorest.Encode("path", tableName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/statistics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListTableStatisticsSender sends the ListTableStatistics request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListTableStatisticsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListTableStatisticsResponder handles the response to the ListTableStatistics request. The method always
// closes the http.Response Body.
func (client Client) ListTableStatisticsResponder(resp *http.Response) (result USQLTableStatisticsList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listTableStatisticsNextResults retrieves the next set of results, if any.
func (client Client) listTableStatisticsNextResults(ctx context.Context, lastResults USQLTableStatisticsList) (result USQLTableStatisticsList, err error) {
	req, err := lastResults.uSQLTableStatisticsListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listTableStatisticsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListTableStatisticsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listTableStatisticsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListTableStatisticsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "listTableStatisticsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListTableStatisticsComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListTableStatisticsComplete(ctx context.Context, accountName string, databaseName string, schemaName string, tableName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLTableStatisticsListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListTableStatistics")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListTableStatistics(ctx, accountName, databaseName, schemaName, tableName, filter, top, skip, expand, selectParameter, orderby, count)
	return
}

// ListTableTypes retrieves the list of table types from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the table types.
// schemaName - the name of the schema containing the table types.
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories?$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
func (client Client) ListTableTypes(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLTableTypeListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListTableTypes")
		defer func() {
			sc := -1
			if result.uttl.Response.Response != nil {
				sc = result.uttl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listTableTypesNextResults
	req, err := client.ListTableTypesPreparer(ctx, accountName, databaseName, schemaName, filter, top, skip, expand, selectParameter, orderby, count)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTableTypes", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListTableTypesSender(req)
	if err != nil {
		result.uttl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTableTypes", resp, "Failure sending request")
		return
	}

	result.uttl, err = client.ListTableTypesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTableTypes", resp, "Failure responding to request")
	}

	return
}

// ListTableTypesPreparer prepares the ListTableTypes request.
func (client Client) ListTableTypesPreparer(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
		"schemaName":   autorest.Encode("path", schemaName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tabletypes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListTableTypesSender sends the ListTableTypes request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListTableTypesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListTableTypesResponder handles the response to the ListTableTypes request. The method always
// closes the http.Response Body.
func (client Client) ListTableTypesResponder(resp *http.Response) (result USQLTableTypeList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listTableTypesNextResults retrieves the next set of results, if any.
func (client Client) listTableTypesNextResults(ctx context.Context, lastResults USQLTableTypeList) (result USQLTableTypeList, err error) {
	req, err := lastResults.uSQLTableTypeListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listTableTypesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListTableTypesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listTableTypesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListTableTypesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "listTableTypesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListTableTypesComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListTableTypesComplete(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLTableTypeListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListTableTypes")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListTableTypes(ctx, accountName, databaseName, schemaName, filter, top, skip, expand, selectParameter, orderby, count)
	return
}

// ListTableValuedFunctions retrieves the list of table valued functions from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the table valued functions.
// schemaName - the name of the schema containing the table valued functions.
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories?$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
func (client Client) ListTableValuedFunctions(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLTableValuedFunctionListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListTableValuedFunctions")
		defer func() {
			sc := -1
			if result.utvfl.Response.Response != nil {
				sc = result.utvfl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listTableValuedFunctionsNextResults
	req, err := client.ListTableValuedFunctionsPreparer(ctx, accountName, databaseName, schemaName, filter, top, skip, expand, selectParameter, orderby, count)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTableValuedFunctions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListTableValuedFunctionsSender(req)
	if err != nil {
		result.utvfl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTableValuedFunctions", resp, "Failure sending request")
		return
	}

	result.utvfl, err = client.ListTableValuedFunctionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTableValuedFunctions", resp, "Failure responding to request")
	}

	return
}

// ListTableValuedFunctionsPreparer prepares the ListTableValuedFunctions request.
func (client Client) ListTableValuedFunctionsPreparer(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
		"schemaName":   autorest.Encode("path", schemaName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tablevaluedfunctions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListTableValuedFunctionsSender sends the ListTableValuedFunctions request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListTableValuedFunctionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListTableValuedFunctionsResponder handles the response to the ListTableValuedFunctions request. The method always
// closes the http.Response Body.
func (client Client) ListTableValuedFunctionsResponder(resp *http.Response) (result USQLTableValuedFunctionList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listTableValuedFunctionsNextResults retrieves the next set of results, if any.
func (client Client) listTableValuedFunctionsNextResults(ctx context.Context, lastResults USQLTableValuedFunctionList) (result USQLTableValuedFunctionList, err error) {
	req, err := lastResults.uSQLTableValuedFunctionListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listTableValuedFunctionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListTableValuedFunctionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listTableValuedFunctionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListTableValuedFunctionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "listTableValuedFunctionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListTableValuedFunctionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListTableValuedFunctionsComplete(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLTableValuedFunctionListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListTableValuedFunctions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListTableValuedFunctions(ctx, accountName, databaseName, schemaName, filter, top, skip, expand, selectParameter, orderby, count)
	return
}

// ListTypes retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the types.
// schemaName - the name of the schema containing the types.
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories?$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
func (client Client) ListTypes(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLTypeListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListTypes")
		defer func() {
			sc := -1
			if result.utl.Response.Response != nil {
				sc = result.utl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listTypesNextResults
	req, err := client.ListTypesPreparer(ctx, accountName, databaseName, schemaName, filter, top, skip, expand, selectParameter, orderby, count)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTypes", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListTypesSender(req)
	if err != nil {
		result.utl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTypes", resp, "Failure sending request")
		return
	}

	result.utl, err = client.ListTypesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListTypes", resp, "Failure responding to request")
	}

	return
}

// ListTypesPreparer prepares the ListTypes request.
func (client Client) ListTypesPreparer(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
		"schemaName":   autorest.Encode("path", schemaName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/types", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListTypesSender sends the ListTypes request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListTypesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListTypesResponder handles the response to the ListTypes request. The method always
// closes the http.Response Body.
func (client Client) ListTypesResponder(resp *http.Response) (result USQLTypeList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listTypesNextResults retrieves the next set of results, if any.
func (client Client) listTypesNextResults(ctx context.Context, lastResults USQLTypeList) (result USQLTypeList, err error) {
	req, err := lastResults.uSQLTypeListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listTypesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListTypesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listTypesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListTypesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "listTypesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListTypesComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListTypesComplete(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLTypeListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListTypes")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListTypes(ctx, accountName, databaseName, schemaName, filter, top, skip, expand, selectParameter, orderby, count)
	return
}

// ListViews retrieves the list of views from the Data Lake Analytics catalog.
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the views.
// schemaName - the name of the schema containing the views.
// filter - oData filter. Optional.
// top - the number of items to return. Optional.
// skip - the number of items to skip over before returning elements. Optional.
// expand - oData expansion. Expand related resources in line with the retrieved resources, e.g.
// Categories?$expand=Products would expand Product data in line with each Category entry. Optional.
// selectParameter - oData Select statement. Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional.
// orderby - orderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or
// "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
// Optional.
// count - the Boolean value of true or false to request a count of the matching resources included with the
// resources in the response, e.g. Categories?$count=true. Optional.
func (client Client) ListViews(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLViewListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListViews")
		defer func() {
			sc := -1
			if result.uvl.Response.Response != nil {
				sc = result.uvl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listViewsNextResults
	req, err := client.ListViewsPreparer(ctx, accountName, databaseName, schemaName, filter, top, skip, expand, selectParameter, orderby, count)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListViews", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListViewsSender(req)
	if err != nil {
		result.uvl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListViews", resp, "Failure sending request")
		return
	}

	result.uvl, err = client.ListViewsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "ListViews", resp, "Failure responding to request")
	}

	return
}

// ListViewsPreparer prepares the ListViews request.
func (client Client) ListViewsPreparer(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
		"schemaName":   autorest.Encode("path", schemaName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/views", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListViewsSender sends the ListViews request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListViewsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListViewsResponder handles the response to the ListViews request. The method always
// closes the http.Response Body.
func (client Client) ListViewsResponder(resp *http.Response) (result USQLViewList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listViewsNextResults retrieves the next set of results, if any.
func (client Client) listViewsNextResults(ctx context.Context, lastResults USQLViewList) (result USQLViewList, err error) {
	req, err := lastResults.uSQLViewListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listViewsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListViewsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "catalog.Client", "listViewsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListViewsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "listViewsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListViewsComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListViewsComplete(ctx context.Context, accountName string, databaseName string, schemaName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool) (result USQLViewListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListViews")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListViews(ctx, accountName, databaseName, schemaName, filter, top, skip, expand, selectParameter, orderby, count)
	return
}

// UpdateSecret modifies the specified secret for use with external data sources in the specified database
// Parameters:
// accountName - the Azure Data Lake Analytics account to execute catalog operations on.
// databaseName - the name of the database containing the secret.
// secretName - the name of the secret.
// parameters - the parameters required to modify the secret (name and password)
func (client Client) UpdateSecret(ctx context.Context, accountName string, databaseName string, secretName string, parameters DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters) (result USQLSecret, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.UpdateSecret")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSecretPreparer(ctx, accountName, databaseName, secretName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "UpdateSecret", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSecretSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "catalog.Client", "UpdateSecret", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSecretResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "catalog.Client", "UpdateSecret", resp, "Failure responding to request")
	}

	return
}

// UpdateSecretPreparer prepares the UpdateSecret request.
func (client Client) UpdateSecretPreparer(ctx context.Context, accountName string, databaseName string, secretName string, parameters DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName":          accountName,
		"adlaCatalogDnsSuffix": client.AdlaCatalogDNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"databaseName": autorest.Encode("path", databaseName),
		"secretName":   autorest.Encode("path", secretName),
	}

	const APIVersion = "2015-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("https://{accountName}.{adlaCatalogDnsSuffix}", urlParameters),
		autorest.WithPathParameters("/catalog/usql/databases/{databaseName}/secrets/{secretName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSecretSender sends the UpdateSecret request. The method will close the
// http.Response Body if it receives an error.
func (client Client) UpdateSecretSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateSecretResponder handles the response to the UpdateSecret request. The method always
// closes the http.Response Body.
func (client Client) UpdateSecretResponder(resp *http.Response) (result USQLSecret, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
