package digitaltwins

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/digitaltwins/2020-05-31/digitaltwins"

// Error error definition.
type Error struct {
	// Code - READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; A human-readable representation of the error.
	Message *string `json:"message,omitempty"`
	// Details - READ-ONLY; Internal error details.
	Details *[]Error `json:"details,omitempty"`
	// Innererror - An object containing more specific information than the current object about the error.
	Innererror *InnerError `json:"innererror,omitempty"`
}

// ErrorResponse error response.
type ErrorResponse struct {
	// Error - The error details.
	Error *Error `json:"error,omitempty"`
}

// EventRoute a route which directs notification and telemetry events to an endpoint. Endpoints are a
// destination outside of Azure Digital Twins such as an EventHub.
type EventRoute struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The id of the event route.
	ID *string `json:"id,omitempty"`
	// EndpointName - The name of the endpoint this event route is bound to.
	EndpointName *string `json:"endpointName,omitempty"`
	// Filter - An expression which describes the events which are routed to the endpoint.
	Filter *string `json:"filter,omitempty"`
}

// EventRouteCollection a collection of EventRoute objects.
type EventRouteCollection struct {
	autorest.Response `json:"-"`
	// Value - The EventRoute objects.
	Value *[]EventRoute `json:"value,omitempty"`
	// NextLink - A URI to retrieve the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// EventRouteCollectionIterator provides access to a complete listing of EventRoute values.
type EventRouteCollectionIterator struct {
	i    int
	page EventRouteCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventRouteCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventRouteCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EventRouteCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventRouteCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventRouteCollectionIterator) Response() EventRouteCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventRouteCollectionIterator) Value() EventRoute {
	if !iter.page.NotDone() {
		return EventRoute{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EventRouteCollectionIterator type.
func NewEventRouteCollectionIterator(page EventRouteCollectionPage) EventRouteCollectionIterator {
	return EventRouteCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erc EventRouteCollection) IsEmpty() bool {
	return erc.Value == nil || len(*erc.Value) == 0
}

// eventRouteCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erc EventRouteCollection) eventRouteCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if erc.NextLink == nil || len(to.String(erc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erc.NextLink)))
}

// EventRouteCollectionPage contains a page of EventRoute values.
type EventRouteCollectionPage struct {
	fn  func(context.Context, EventRouteCollection) (EventRouteCollection, error)
	erc EventRouteCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventRouteCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventRouteCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.erc)
	if err != nil {
		return err
	}
	page.erc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EventRouteCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventRouteCollectionPage) NotDone() bool {
	return !page.erc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventRouteCollectionPage) Response() EventRouteCollection {
	return page.erc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventRouteCollectionPage) Values() []EventRoute {
	if page.erc.IsEmpty() {
		return nil
	}
	return *page.erc.Value
}

// Creates a new instance of the EventRouteCollectionPage type.
func NewEventRouteCollectionPage(getNextPage func(context.Context, EventRouteCollection) (EventRouteCollection, error)) EventRouteCollectionPage {
	return EventRouteCollectionPage{fn: getNextPage}
}

// IncomingRelationship an incoming relationship.
type IncomingRelationship struct {
	// RelationshipID - A user-provided string representing the id of this relationship, unique in the context of the source digital twin, i.e. sourceId + relationshipId is unique in the context of the service.
	RelationshipID *string `json:"$relationshipId,omitempty"`
	// SourceID - The id of the source digital twin.
	SourceID *string `json:"$sourceId,omitempty"`
	// RelationshipName - The name of the relationship.
	RelationshipName *string `json:"$relationshipName,omitempty"`
	// RelationshipLink - Link to the relationship, to be used for deletion.
	RelationshipLink *string `json:"$relationshipLink,omitempty"`
}

// IncomingRelationshipCollection a collection of incoming relationships which relate digital twins
// together.
type IncomingRelationshipCollection struct {
	autorest.Response `json:"-"`
	Value             *[]IncomingRelationship `json:"value,omitempty"`
	// NextLink - A URI to retrieve the next page of objects.
	NextLink *string `json:"nextLink,omitempty"`
}

// IncomingRelationshipCollectionIterator provides access to a complete listing of IncomingRelationship
// values.
type IncomingRelationshipCollectionIterator struct {
	i    int
	page IncomingRelationshipCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IncomingRelationshipCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IncomingRelationshipCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IncomingRelationshipCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IncomingRelationshipCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IncomingRelationshipCollectionIterator) Response() IncomingRelationshipCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IncomingRelationshipCollectionIterator) Value() IncomingRelationship {
	if !iter.page.NotDone() {
		return IncomingRelationship{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IncomingRelationshipCollectionIterator type.
func NewIncomingRelationshipCollectionIterator(page IncomingRelationshipCollectionPage) IncomingRelationshipCollectionIterator {
	return IncomingRelationshipCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (irc IncomingRelationshipCollection) IsEmpty() bool {
	return irc.Value == nil || len(*irc.Value) == 0
}

// incomingRelationshipCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (irc IncomingRelationshipCollection) incomingRelationshipCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if irc.NextLink == nil || len(to.String(irc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(irc.NextLink)))
}

// IncomingRelationshipCollectionPage contains a page of IncomingRelationship values.
type IncomingRelationshipCollectionPage struct {
	fn  func(context.Context, IncomingRelationshipCollection) (IncomingRelationshipCollection, error)
	irc IncomingRelationshipCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IncomingRelationshipCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IncomingRelationshipCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.irc)
	if err != nil {
		return err
	}
	page.irc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IncomingRelationshipCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IncomingRelationshipCollectionPage) NotDone() bool {
	return !page.irc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IncomingRelationshipCollectionPage) Response() IncomingRelationshipCollection {
	return page.irc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IncomingRelationshipCollectionPage) Values() []IncomingRelationship {
	if page.irc.IsEmpty() {
		return nil
	}
	return *page.irc.Value
}

// Creates a new instance of the IncomingRelationshipCollectionPage type.
func NewIncomingRelationshipCollectionPage(getNextPage func(context.Context, IncomingRelationshipCollection) (IncomingRelationshipCollection, error)) IncomingRelationshipCollectionPage {
	return IncomingRelationshipCollectionPage{fn: getNextPage}
}

// InnerError a more specific error description than was provided by the containing error.
type InnerError struct {
	// Code - A more specific error code than was provided by the containing error.
	Code *string `json:"code,omitempty"`
	// Innererror - An object containing more specific information than the current object about the error.
	Innererror *InnerError `json:"innererror,omitempty"`
}

// ListModelData ...
type ListModelData struct {
	autorest.Response `json:"-"`
	Value             *[]ModelData `json:"value,omitempty"`
}

// ModelData a model definition and metadata for that model.
type ModelData struct {
	autorest.Response `json:"-"`
	// DisplayName - A language map that contains the localized display names as specified in the model definition.
	DisplayName map[string]*string `json:"displayName"`
	// Description - A language map that contains the localized descriptions as specified in the model definition.
	Description map[string]*string `json:"description"`
	// ID - The id of the model as specified in the model definition.
	ID *string `json:"id,omitempty"`
	// UploadTime - The time the model was uploaded to the service.
	UploadTime *date.Time `json:"uploadTime,omitempty"`
	// Decommissioned - Indicates if the model is decommissioned. Decommissioned models cannot be referenced by newly created digital twins.
	Decommissioned *bool `json:"decommissioned,omitempty"`
	// Model - The model definition.
	Model interface{} `json:"model,omitempty"`
}

// MarshalJSON is the custom marshaler for ModelData.
func (md ModelData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if md.DisplayName != nil {
		objectMap["displayName"] = md.DisplayName
	}
	if md.Description != nil {
		objectMap["description"] = md.Description
	}
	if md.ID != nil {
		objectMap["id"] = md.ID
	}
	if md.UploadTime != nil {
		objectMap["uploadTime"] = md.UploadTime
	}
	if md.Decommissioned != nil {
		objectMap["decommissioned"] = md.Decommissioned
	}
	if md.Model != nil {
		objectMap["model"] = md.Model
	}
	return json.Marshal(objectMap)
}

// PagedModelDataCollection a collection of ModelData objects.
type PagedModelDataCollection struct {
	autorest.Response `json:"-"`
	// Value - The ModelData objects.
	Value *[]ModelData `json:"value,omitempty"`
	// NextLink - A URI to retrieve the next page of objects.
	NextLink *string `json:"nextLink,omitempty"`
}

// PagedModelDataCollectionIterator provides access to a complete listing of ModelData values.
type PagedModelDataCollectionIterator struct {
	i    int
	page PagedModelDataCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PagedModelDataCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedModelDataCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PagedModelDataCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PagedModelDataCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PagedModelDataCollectionIterator) Response() PagedModelDataCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PagedModelDataCollectionIterator) Value() ModelData {
	if !iter.page.NotDone() {
		return ModelData{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PagedModelDataCollectionIterator type.
func NewPagedModelDataCollectionIterator(page PagedModelDataCollectionPage) PagedModelDataCollectionIterator {
	return PagedModelDataCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pmdc PagedModelDataCollection) IsEmpty() bool {
	return pmdc.Value == nil || len(*pmdc.Value) == 0
}

// pagedModelDataCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pmdc PagedModelDataCollection) pagedModelDataCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if pmdc.NextLink == nil || len(to.String(pmdc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pmdc.NextLink)))
}

// PagedModelDataCollectionPage contains a page of ModelData values.
type PagedModelDataCollectionPage struct {
	fn   func(context.Context, PagedModelDataCollection) (PagedModelDataCollection, error)
	pmdc PagedModelDataCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PagedModelDataCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PagedModelDataCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pmdc)
	if err != nil {
		return err
	}
	page.pmdc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PagedModelDataCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PagedModelDataCollectionPage) NotDone() bool {
	return !page.pmdc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PagedModelDataCollectionPage) Response() PagedModelDataCollection {
	return page.pmdc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PagedModelDataCollectionPage) Values() []ModelData {
	if page.pmdc.IsEmpty() {
		return nil
	}
	return *page.pmdc.Value
}

// Creates a new instance of the PagedModelDataCollectionPage type.
func NewPagedModelDataCollectionPage(getNextPage func(context.Context, PagedModelDataCollection) (PagedModelDataCollection, error)) PagedModelDataCollectionPage {
	return PagedModelDataCollectionPage{fn: getNextPage}
}

// QueryResult the results of a query operation and an optional continuation token.
type QueryResult struct {
	autorest.Response `json:"-"`
	// Items - The query results.
	Items *[]interface{} `json:"items,omitempty"`
	// ContinuationToken - A token which can be used to construct a new QuerySpecification to retrieve the next set of results.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// QuerySpecification a query specification containing either a query statement or a continuation token
// from a previous query result.
type QuerySpecification struct {
	// Query - The query to execute. This value is ignored if a continuation token is provided.
	Query *string `json:"query,omitempty"`
	// ContinuationToken - A token which is used to retrieve the next set of results from a previous query.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// RelationshipCollection a collection of relationships which relate digital twins together.
type RelationshipCollection struct {
	autorest.Response `json:"-"`
	// Value - The relationship objects.
	Value *[]interface{} `json:"value,omitempty"`
	// NextLink - A URI to retrieve the next page of objects.
	NextLink *string `json:"nextLink,omitempty"`
}

// RelationshipCollectionIterator provides access to a complete listing of interface{} values.
type RelationshipCollectionIterator struct {
	i    int
	page RelationshipCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RelationshipCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RelationshipCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RelationshipCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RelationshipCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RelationshipCollectionIterator) Response() RelationshipCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RelationshipCollectionIterator) Value() interface{} {
	if !iter.page.NotDone() {
		return map[string]interface{}{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RelationshipCollectionIterator type.
func NewRelationshipCollectionIterator(page RelationshipCollectionPage) RelationshipCollectionIterator {
	return RelationshipCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rc RelationshipCollection) IsEmpty() bool {
	return rc.Value == nil || len(*rc.Value) == 0
}

// relationshipCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rc RelationshipCollection) relationshipCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if rc.NextLink == nil || len(to.String(rc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rc.NextLink)))
}

// RelationshipCollectionPage contains a page of interface{} values.
type RelationshipCollectionPage struct {
	fn func(context.Context, RelationshipCollection) (RelationshipCollection, error)
	rc RelationshipCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RelationshipCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RelationshipCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rc)
	if err != nil {
		return err
	}
	page.rc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RelationshipCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RelationshipCollectionPage) NotDone() bool {
	return !page.rc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RelationshipCollectionPage) Response() RelationshipCollection {
	return page.rc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RelationshipCollectionPage) Values() []interface{} {
	if page.rc.IsEmpty() {
		return nil
	}
	return *page.rc.Value
}

// Creates a new instance of the RelationshipCollectionPage type.
func NewRelationshipCollectionPage(getNextPage func(context.Context, RelationshipCollection) (RelationshipCollection, error)) RelationshipCollectionPage {
	return RelationshipCollectionPage{fn: getNextPage}
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}
