package migrate

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// HyperVSitesClient is the discover your workloads for Azure.
type HyperVSitesClient struct {
	BaseClient
}

// NewHyperVSitesClient creates an instance of the HyperVSitesClient client.
func NewHyperVSitesClient() HyperVSitesClient {
	return NewHyperVSitesClientWithBaseURI(DefaultBaseURI)
}

// NewHyperVSitesClientWithBaseURI creates an instance of the HyperVSitesClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewHyperVSitesClientWithBaseURI(baseURI string) HyperVSitesClient {
	return HyperVSitesClient{NewWithBaseURI(baseURI)}
}

// DeleteSite sends the delete site request.
// Parameters:
// subscriptionID - the ID of the target subscription.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// siteName - site name.
// APIVersion - the API version to use for this operation.
func (client HyperVSitesClient) DeleteSite(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, APIVersion string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVSitesClient.DeleteSite")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSitePreparer(ctx, subscriptionID, resourceGroupName, siteName, APIVersion)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "DeleteSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSiteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "DeleteSite", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "DeleteSite", resp, "Failure responding to request")
	}

	return
}

// DeleteSitePreparer prepares the DeleteSite request.
func (client HyperVSitesClient) DeleteSitePreparer(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, APIVersion string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/HyperVSites/{siteName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSiteSender sends the DeleteSite request. The method will close the
// http.Response Body if it receives an error.
func (client HyperVSitesClient) DeleteSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSiteResponder handles the response to the DeleteSite request. The method always
// closes the http.Response Body.
func (client HyperVSitesClient) DeleteSiteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetSite sends the get site request.
// Parameters:
// subscriptionID - the ID of the target subscription.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// siteName - site name.
// APIVersion - the API version to use for this operation.
func (client HyperVSitesClient) GetSite(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, APIVersion string) (result HyperVSite, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVSitesClient.GetSite")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSitePreparer(ctx, subscriptionID, resourceGroupName, siteName, APIVersion)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "GetSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "GetSite", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "GetSite", resp, "Failure responding to request")
	}

	return
}

// GetSitePreparer prepares the GetSite request.
func (client HyperVSitesClient) GetSitePreparer(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, APIVersion string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/HyperVSites/{siteName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteSender sends the GetSite request. The method will close the
// http.Response Body if it receives an error.
func (client HyperVSitesClient) GetSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteResponder handles the response to the GetSite request. The method always
// closes the http.Response Body.
func (client HyperVSitesClient) GetSiteResponder(resp *http.Response) (result HyperVSite, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteHealthSummary sends the get site health summary request.
// Parameters:
// subscriptionID - the ID of the target subscription.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// siteName - site name.
// APIVersion - the API version to use for this operation.
func (client HyperVSitesClient) GetSiteHealthSummary(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, APIVersion string) (result SiteHealthSummaryCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVSitesClient.GetSiteHealthSummary")
		defer func() {
			sc := -1
			if result.shsc.Response.Response != nil {
				sc = result.shsc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSiteHealthSummaryNextResults
	req, err := client.GetSiteHealthSummaryPreparer(ctx, subscriptionID, resourceGroupName, siteName, APIVersion)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "GetSiteHealthSummary", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteHealthSummarySender(req)
	if err != nil {
		result.shsc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "GetSiteHealthSummary", resp, "Failure sending request")
		return
	}

	result.shsc, err = client.GetSiteHealthSummaryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "GetSiteHealthSummary", resp, "Failure responding to request")
	}

	return
}

// GetSiteHealthSummaryPreparer prepares the GetSiteHealthSummary request.
func (client HyperVSitesClient) GetSiteHealthSummaryPreparer(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, APIVersion string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/HyperVSites/{siteName}/healthSummary", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteHealthSummarySender sends the GetSiteHealthSummary request. The method will close the
// http.Response Body if it receives an error.
func (client HyperVSitesClient) GetSiteHealthSummarySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteHealthSummaryResponder handles the response to the GetSiteHealthSummary request. The method always
// closes the http.Response Body.
func (client HyperVSitesClient) GetSiteHealthSummaryResponder(resp *http.Response) (result SiteHealthSummaryCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteHealthSummaryNextResults retrieves the next set of results, if any.
func (client HyperVSitesClient) getSiteHealthSummaryNextResults(ctx context.Context, lastResults SiteHealthSummaryCollection) (result SiteHealthSummaryCollection, err error) {
	req, err := lastResults.siteHealthSummaryCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "getSiteHealthSummaryNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteHealthSummarySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "getSiteHealthSummaryNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteHealthSummaryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "getSiteHealthSummaryNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteHealthSummaryComplete enumerates all values, automatically crossing page boundaries as required.
func (client HyperVSitesClient) GetSiteHealthSummaryComplete(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, APIVersion string) (result SiteHealthSummaryCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVSitesClient.GetSiteHealthSummary")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSiteHealthSummary(ctx, subscriptionID, resourceGroupName, siteName, APIVersion)
	return
}

// GetSiteUsage sends the get site usage request.
// Parameters:
// subscriptionID - the ID of the target subscription.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// siteName - site name.
func (client HyperVSitesClient) GetSiteUsage(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, APIVersion string) (result HyperVSiteUsage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVSitesClient.GetSiteUsage")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteUsagePreparer(ctx, subscriptionID, resourceGroupName, siteName, APIVersion)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "GetSiteUsage", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteUsageSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "GetSiteUsage", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteUsageResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "GetSiteUsage", resp, "Failure responding to request")
	}

	return
}

// GetSiteUsagePreparer prepares the GetSiteUsage request.
func (client HyperVSitesClient) GetSiteUsagePreparer(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, APIVersion string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/HyperVSites/{siteName}/summary", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteUsageSender sends the GetSiteUsage request. The method will close the
// http.Response Body if it receives an error.
func (client HyperVSitesClient) GetSiteUsageSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteUsageResponder handles the response to the GetSiteUsage request. The method always
// closes the http.Response Body.
func (client HyperVSitesClient) GetSiteUsageResponder(resp *http.Response) (result HyperVSiteUsage, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// PatchSite sends the patch site request.
// Parameters:
// subscriptionID - the ID of the target subscription.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// siteName - site name.
// body - body with site details.
// APIVersion - the API version to use for this operation.
func (client HyperVSitesClient) PatchSite(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, body HyperVSite, APIVersion string) (result HyperVSite, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVSitesClient.PatchSite")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PatchSitePreparer(ctx, subscriptionID, resourceGroupName, siteName, body, APIVersion)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "PatchSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.PatchSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "PatchSite", resp, "Failure sending request")
		return
	}

	result, err = client.PatchSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "PatchSite", resp, "Failure responding to request")
	}

	return
}

// PatchSitePreparer prepares the PatchSite request.
func (client HyperVSitesClient) PatchSitePreparer(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, body HyperVSite, APIVersion string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	body.ID = nil
	body.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/HyperVSites/{siteName}", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PatchSiteSender sends the PatchSite request. The method will close the
// http.Response Body if it receives an error.
func (client HyperVSitesClient) PatchSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// PatchSiteResponder handles the response to the PatchSite request. The method always
// closes the http.Response Body.
func (client HyperVSitesClient) PatchSiteResponder(resp *http.Response) (result HyperVSite, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// PutSite sends the put site request.
// Parameters:
// subscriptionID - the ID of the target subscription.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// siteName - site name.
// body - body with site details.
// APIVersion - the API version to use for this operation.
func (client HyperVSitesClient) PutSite(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, body HyperVSite, APIVersion string) (result HyperVSite, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVSitesClient.PutSite")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PutSitePreparer(ctx, subscriptionID, resourceGroupName, siteName, body, APIVersion)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "PutSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.PutSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "PutSite", resp, "Failure sending request")
		return
	}

	result, err = client.PutSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "PutSite", resp, "Failure responding to request")
	}

	return
}

// PutSitePreparer prepares the PutSite request.
func (client HyperVSitesClient) PutSitePreparer(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, body HyperVSite, APIVersion string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	body.ID = nil
	body.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/HyperVSites/{siteName}", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PutSiteSender sends the PutSite request. The method will close the
// http.Response Body if it receives an error.
func (client HyperVSitesClient) PutSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// PutSiteResponder handles the response to the PutSite request. The method always
// closes the http.Response Body.
func (client HyperVSitesClient) PutSiteResponder(resp *http.Response) (result HyperVSite, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RefreshSite sends the refresh site request.
// Parameters:
// subscriptionID - the ID of the target subscription.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// siteName - site name.
// APIVersion - the API version to use for this operation.
func (client HyperVSitesClient) RefreshSite(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, APIVersion string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVSitesClient.RefreshSite")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.RefreshSitePreparer(ctx, subscriptionID, resourceGroupName, siteName, APIVersion)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "RefreshSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.RefreshSiteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "RefreshSite", resp, "Failure sending request")
		return
	}

	result, err = client.RefreshSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVSitesClient", "RefreshSite", resp, "Failure responding to request")
	}

	return
}

// RefreshSitePreparer prepares the RefreshSite request.
func (client HyperVSitesClient) RefreshSitePreparer(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, APIVersion string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/HyperVSites/{siteName}/refresh", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RefreshSiteSender sends the RefreshSite request. The method will close the
// http.Response Body if it receives an error.
func (client HyperVSitesClient) RefreshSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// RefreshSiteResponder handles the response to the RefreshSite request. The method always
// closes the http.Response Body.
func (client HyperVSitesClient) RefreshSiteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}
