DROP TABLE `insert`;

CREATE TABLE `insert` (key INT, `as` STRING);

EXPLAIN INSERT INTO TABLE `insert` SELECT * FROM src LIMIT 100;
INSERT INTO TABLE `insert` SELECT * FROM src LIMIT 100;
SELECT SUM(HASH(hash)) FROM (
    SELECT TRANSFORM(*) USING 'tr \t _' AS (hash) FROM `insert`
) t;

EXPLAIN INSERT INTO TABLE `insert` SELECT * FROM src LIMIT 100;
INSERT INTO TABLE `insert` SELECT * FROM src LIMIT 100;
SELECT SUM(HASH(sum)) FROM (
    SELECT TRANSFORM(*) USING 'tr \t _' AS (sum) FROM `insert`
) t;

SELECT COUNT(*) FROM `insert`;

EXPLAIN INSERT OVERWRITE TABLE `insert` SELECT * FROM src LIMIT 10;
INSERT OVERWRITE TABLE `insert` SELECT * FROM src LIMIT 10;
SELECT SUM(HASH(add)) FROM (
    SELECT TRANSFORM(*) USING 'tr \t _' AS (add) FROM `insert`
) t;


DROP TABLE `insert`;
