// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptInvitation = "AcceptInvitation"

// AcceptInvitationRequest generates a "aws/request.Request" representing the
// client's request for the AcceptInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptInvitation for more information on using the AcceptInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptInvitationRequest method.
//    req, resp := client.AcceptInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/AcceptInvitation
func (c *Macie2) AcceptInvitationRequest(input *AcceptInvitationInput) (req *request.Request, output *AcceptInvitationOutput) {
	op := &request.Operation{
		Name:       opAcceptInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations/accept",
	}

	if input == nil {
		input = &AcceptInvitationInput{}
	}

	output = &AcceptInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptInvitation API operation for Amazon Macie 2.
//
// Accepts an Amazon Macie membership invitation that was received from a specific
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation AcceptInvitation for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/AcceptInvitation
func (c *Macie2) AcceptInvitation(input *AcceptInvitationInput) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	return out, req.Send()
}

// AcceptInvitationWithContext is the same as AcceptInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) AcceptInvitationWithContext(ctx aws.Context, input *AcceptInvitationInput, opts ...request.Option) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetCustomDataIdentifiers = "BatchGetCustomDataIdentifiers"

// BatchGetCustomDataIdentifiersRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetCustomDataIdentifiers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetCustomDataIdentifiers for more information on using the BatchGetCustomDataIdentifiers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetCustomDataIdentifiersRequest method.
//    req, resp := client.BatchGetCustomDataIdentifiersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/BatchGetCustomDataIdentifiers
func (c *Macie2) BatchGetCustomDataIdentifiersRequest(input *BatchGetCustomDataIdentifiersInput) (req *request.Request, output *BatchGetCustomDataIdentifiersOutput) {
	op := &request.Operation{
		Name:       opBatchGetCustomDataIdentifiers,
		HTTPMethod: "POST",
		HTTPPath:   "/custom-data-identifiers/get",
	}

	if input == nil {
		input = &BatchGetCustomDataIdentifiersInput{}
	}

	output = &BatchGetCustomDataIdentifiersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetCustomDataIdentifiers API operation for Amazon Macie 2.
//
// Retrieves information about one or more custom data identifiers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation BatchGetCustomDataIdentifiers for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/BatchGetCustomDataIdentifiers
func (c *Macie2) BatchGetCustomDataIdentifiers(input *BatchGetCustomDataIdentifiersInput) (*BatchGetCustomDataIdentifiersOutput, error) {
	req, out := c.BatchGetCustomDataIdentifiersRequest(input)
	return out, req.Send()
}

// BatchGetCustomDataIdentifiersWithContext is the same as BatchGetCustomDataIdentifiers with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetCustomDataIdentifiers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) BatchGetCustomDataIdentifiersWithContext(ctx aws.Context, input *BatchGetCustomDataIdentifiersInput, opts ...request.Option) (*BatchGetCustomDataIdentifiersOutput, error) {
	req, out := c.BatchGetCustomDataIdentifiersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateClassificationJob = "CreateClassificationJob"

// CreateClassificationJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateClassificationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateClassificationJob for more information on using the CreateClassificationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClassificationJobRequest method.
//    req, resp := client.CreateClassificationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateClassificationJob
func (c *Macie2) CreateClassificationJobRequest(input *CreateClassificationJobInput) (req *request.Request, output *CreateClassificationJobOutput) {
	op := &request.Operation{
		Name:       opCreateClassificationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/jobs",
	}

	if input == nil {
		input = &CreateClassificationJobInput{}
	}

	output = &CreateClassificationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClassificationJob API operation for Amazon Macie 2.
//
// Creates and defines the settings for a classification job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation CreateClassificationJob for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateClassificationJob
func (c *Macie2) CreateClassificationJob(input *CreateClassificationJobInput) (*CreateClassificationJobOutput, error) {
	req, out := c.CreateClassificationJobRequest(input)
	return out, req.Send()
}

// CreateClassificationJobWithContext is the same as CreateClassificationJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateClassificationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) CreateClassificationJobWithContext(ctx aws.Context, input *CreateClassificationJobInput, opts ...request.Option) (*CreateClassificationJobOutput, error) {
	req, out := c.CreateClassificationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomDataIdentifier = "CreateCustomDataIdentifier"

// CreateCustomDataIdentifierRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomDataIdentifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomDataIdentifier for more information on using the CreateCustomDataIdentifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCustomDataIdentifierRequest method.
//    req, resp := client.CreateCustomDataIdentifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateCustomDataIdentifier
func (c *Macie2) CreateCustomDataIdentifierRequest(input *CreateCustomDataIdentifierInput) (req *request.Request, output *CreateCustomDataIdentifierOutput) {
	op := &request.Operation{
		Name:       opCreateCustomDataIdentifier,
		HTTPMethod: "POST",
		HTTPPath:   "/custom-data-identifiers",
	}

	if input == nil {
		input = &CreateCustomDataIdentifierInput{}
	}

	output = &CreateCustomDataIdentifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomDataIdentifier API operation for Amazon Macie 2.
//
// Creates and defines the criteria and other settings for a custom data identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation CreateCustomDataIdentifier for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateCustomDataIdentifier
func (c *Macie2) CreateCustomDataIdentifier(input *CreateCustomDataIdentifierInput) (*CreateCustomDataIdentifierOutput, error) {
	req, out := c.CreateCustomDataIdentifierRequest(input)
	return out, req.Send()
}

// CreateCustomDataIdentifierWithContext is the same as CreateCustomDataIdentifier with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomDataIdentifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) CreateCustomDataIdentifierWithContext(ctx aws.Context, input *CreateCustomDataIdentifierInput, opts ...request.Option) (*CreateCustomDataIdentifierOutput, error) {
	req, out := c.CreateCustomDataIdentifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFindingsFilter = "CreateFindingsFilter"

// CreateFindingsFilterRequest generates a "aws/request.Request" representing the
// client's request for the CreateFindingsFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFindingsFilter for more information on using the CreateFindingsFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFindingsFilterRequest method.
//    req, resp := client.CreateFindingsFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateFindingsFilter
func (c *Macie2) CreateFindingsFilterRequest(input *CreateFindingsFilterInput) (req *request.Request, output *CreateFindingsFilterOutput) {
	op := &request.Operation{
		Name:       opCreateFindingsFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/findingsfilters",
	}

	if input == nil {
		input = &CreateFindingsFilterInput{}
	}

	output = &CreateFindingsFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFindingsFilter API operation for Amazon Macie 2.
//
// Creates and defines the criteria and other settings for a findings filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation CreateFindingsFilter for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateFindingsFilter
func (c *Macie2) CreateFindingsFilter(input *CreateFindingsFilterInput) (*CreateFindingsFilterOutput, error) {
	req, out := c.CreateFindingsFilterRequest(input)
	return out, req.Send()
}

// CreateFindingsFilterWithContext is the same as CreateFindingsFilter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFindingsFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) CreateFindingsFilterWithContext(ctx aws.Context, input *CreateFindingsFilterInput, opts ...request.Option) (*CreateFindingsFilterOutput, error) {
	req, out := c.CreateFindingsFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInvitations = "CreateInvitations"

// CreateInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the CreateInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInvitations for more information on using the CreateInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInvitationsRequest method.
//    req, resp := client.CreateInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateInvitations
func (c *Macie2) CreateInvitationsRequest(input *CreateInvitationsInput) (req *request.Request, output *CreateInvitationsOutput) {
	op := &request.Operation{
		Name:       opCreateInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations",
	}

	if input == nil {
		input = &CreateInvitationsInput{}
	}

	output = &CreateInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInvitations API operation for Amazon Macie 2.
//
// Sends an Amazon Macie membership invitation to one or more accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation CreateInvitations for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateInvitations
func (c *Macie2) CreateInvitations(input *CreateInvitationsInput) (*CreateInvitationsOutput, error) {
	req, out := c.CreateInvitationsRequest(input)
	return out, req.Send()
}

// CreateInvitationsWithContext is the same as CreateInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) CreateInvitationsWithContext(ctx aws.Context, input *CreateInvitationsInput, opts ...request.Option) (*CreateInvitationsOutput, error) {
	req, out := c.CreateInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMember = "CreateMember"

// CreateMemberRequest generates a "aws/request.Request" representing the
// client's request for the CreateMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMember for more information on using the CreateMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMemberRequest method.
//    req, resp := client.CreateMemberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateMember
func (c *Macie2) CreateMemberRequest(input *CreateMemberInput) (req *request.Request, output *CreateMemberOutput) {
	op := &request.Operation{
		Name:       opCreateMember,
		HTTPMethod: "POST",
		HTTPPath:   "/members",
	}

	if input == nil {
		input = &CreateMemberInput{}
	}

	output = &CreateMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMember API operation for Amazon Macie 2.
//
// Associates an account with an Amazon Macie master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation CreateMember for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateMember
func (c *Macie2) CreateMember(input *CreateMemberInput) (*CreateMemberOutput, error) {
	req, out := c.CreateMemberRequest(input)
	return out, req.Send()
}

// CreateMemberWithContext is the same as CreateMember with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) CreateMemberWithContext(ctx aws.Context, input *CreateMemberInput, opts ...request.Option) (*CreateMemberOutput, error) {
	req, out := c.CreateMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSampleFindings = "CreateSampleFindings"

// CreateSampleFindingsRequest generates a "aws/request.Request" representing the
// client's request for the CreateSampleFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSampleFindings for more information on using the CreateSampleFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSampleFindingsRequest method.
//    req, resp := client.CreateSampleFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateSampleFindings
func (c *Macie2) CreateSampleFindingsRequest(input *CreateSampleFindingsInput) (req *request.Request, output *CreateSampleFindingsOutput) {
	op := &request.Operation{
		Name:       opCreateSampleFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings/sample",
	}

	if input == nil {
		input = &CreateSampleFindingsInput{}
	}

	output = &CreateSampleFindingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateSampleFindings API operation for Amazon Macie 2.
//
// Creates sample findings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation CreateSampleFindings for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateSampleFindings
func (c *Macie2) CreateSampleFindings(input *CreateSampleFindingsInput) (*CreateSampleFindingsOutput, error) {
	req, out := c.CreateSampleFindingsRequest(input)
	return out, req.Send()
}

// CreateSampleFindingsWithContext is the same as CreateSampleFindings with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSampleFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) CreateSampleFindingsWithContext(ctx aws.Context, input *CreateSampleFindingsInput, opts ...request.Option) (*CreateSampleFindingsOutput, error) {
	req, out := c.CreateSampleFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeclineInvitations = "DeclineInvitations"

// DeclineInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeclineInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeclineInvitations for more information on using the DeclineInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeclineInvitationsRequest method.
//    req, resp := client.DeclineInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeclineInvitations
func (c *Macie2) DeclineInvitationsRequest(input *DeclineInvitationsInput) (req *request.Request, output *DeclineInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeclineInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations/decline",
	}

	if input == nil {
		input = &DeclineInvitationsInput{}
	}

	output = &DeclineInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeclineInvitations API operation for Amazon Macie 2.
//
// Declines Amazon Macie membership invitations that were received from specific
// accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation DeclineInvitations for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeclineInvitations
func (c *Macie2) DeclineInvitations(input *DeclineInvitationsInput) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	return out, req.Send()
}

// DeclineInvitationsWithContext is the same as DeclineInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeclineInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) DeclineInvitationsWithContext(ctx aws.Context, input *DeclineInvitationsInput, opts ...request.Option) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomDataIdentifier = "DeleteCustomDataIdentifier"

// DeleteCustomDataIdentifierRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomDataIdentifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomDataIdentifier for more information on using the DeleteCustomDataIdentifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCustomDataIdentifierRequest method.
//    req, resp := client.DeleteCustomDataIdentifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteCustomDataIdentifier
func (c *Macie2) DeleteCustomDataIdentifierRequest(input *DeleteCustomDataIdentifierInput) (req *request.Request, output *DeleteCustomDataIdentifierOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomDataIdentifier,
		HTTPMethod: "DELETE",
		HTTPPath:   "/custom-data-identifiers/{id}",
	}

	if input == nil {
		input = &DeleteCustomDataIdentifierInput{}
	}

	output = &DeleteCustomDataIdentifierOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomDataIdentifier API operation for Amazon Macie 2.
//
// Soft deletes a custom data identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation DeleteCustomDataIdentifier for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteCustomDataIdentifier
func (c *Macie2) DeleteCustomDataIdentifier(input *DeleteCustomDataIdentifierInput) (*DeleteCustomDataIdentifierOutput, error) {
	req, out := c.DeleteCustomDataIdentifierRequest(input)
	return out, req.Send()
}

// DeleteCustomDataIdentifierWithContext is the same as DeleteCustomDataIdentifier with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomDataIdentifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) DeleteCustomDataIdentifierWithContext(ctx aws.Context, input *DeleteCustomDataIdentifierInput, opts ...request.Option) (*DeleteCustomDataIdentifierOutput, error) {
	req, out := c.DeleteCustomDataIdentifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFindingsFilter = "DeleteFindingsFilter"

// DeleteFindingsFilterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFindingsFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFindingsFilter for more information on using the DeleteFindingsFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFindingsFilterRequest method.
//    req, resp := client.DeleteFindingsFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteFindingsFilter
func (c *Macie2) DeleteFindingsFilterRequest(input *DeleteFindingsFilterInput) (req *request.Request, output *DeleteFindingsFilterOutput) {
	op := &request.Operation{
		Name:       opDeleteFindingsFilter,
		HTTPMethod: "DELETE",
		HTTPPath:   "/findingsfilters/{id}",
	}

	if input == nil {
		input = &DeleteFindingsFilterInput{}
	}

	output = &DeleteFindingsFilterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFindingsFilter API operation for Amazon Macie 2.
//
// Deletes a findings filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation DeleteFindingsFilter for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteFindingsFilter
func (c *Macie2) DeleteFindingsFilter(input *DeleteFindingsFilterInput) (*DeleteFindingsFilterOutput, error) {
	req, out := c.DeleteFindingsFilterRequest(input)
	return out, req.Send()
}

// DeleteFindingsFilterWithContext is the same as DeleteFindingsFilter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFindingsFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) DeleteFindingsFilterWithContext(ctx aws.Context, input *DeleteFindingsFilterInput, opts ...request.Option) (*DeleteFindingsFilterOutput, error) {
	req, out := c.DeleteFindingsFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInvitations = "DeleteInvitations"

// DeleteInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInvitations for more information on using the DeleteInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInvitationsRequest method.
//    req, resp := client.DeleteInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteInvitations
func (c *Macie2) DeleteInvitationsRequest(input *DeleteInvitationsInput) (req *request.Request, output *DeleteInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeleteInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations/delete",
	}

	if input == nil {
		input = &DeleteInvitationsInput{}
	}

	output = &DeleteInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInvitations API operation for Amazon Macie 2.
//
// Deletes Amazon Macie membership invitations that were received from specific
// accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation DeleteInvitations for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteInvitations
func (c *Macie2) DeleteInvitations(input *DeleteInvitationsInput) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	return out, req.Send()
}

// DeleteInvitationsWithContext is the same as DeleteInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) DeleteInvitationsWithContext(ctx aws.Context, input *DeleteInvitationsInput, opts ...request.Option) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMember = "DeleteMember"

// DeleteMemberRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMember for more information on using the DeleteMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMemberRequest method.
//    req, resp := client.DeleteMemberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteMember
func (c *Macie2) DeleteMemberRequest(input *DeleteMemberInput) (req *request.Request, output *DeleteMemberOutput) {
	op := &request.Operation{
		Name:       opDeleteMember,
		HTTPMethod: "DELETE",
		HTTPPath:   "/members/{id}",
	}

	if input == nil {
		input = &DeleteMemberInput{}
	}

	output = &DeleteMemberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMember API operation for Amazon Macie 2.
//
// Deletes the association between an Amazon Macie master account and an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation DeleteMember for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteMember
func (c *Macie2) DeleteMember(input *DeleteMemberInput) (*DeleteMemberOutput, error) {
	req, out := c.DeleteMemberRequest(input)
	return out, req.Send()
}

// DeleteMemberWithContext is the same as DeleteMember with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) DeleteMemberWithContext(ctx aws.Context, input *DeleteMemberInput, opts ...request.Option) (*DeleteMemberOutput, error) {
	req, out := c.DeleteMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBuckets = "DescribeBuckets"

// DescribeBucketsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBuckets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBuckets for more information on using the DescribeBuckets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBucketsRequest method.
//    req, resp := client.DescribeBucketsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeBuckets
func (c *Macie2) DescribeBucketsRequest(input *DescribeBucketsInput) (req *request.Request, output *DescribeBucketsOutput) {
	op := &request.Operation{
		Name:       opDescribeBuckets,
		HTTPMethod: "POST",
		HTTPPath:   "/datasources/s3",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeBucketsInput{}
	}

	output = &DescribeBucketsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBuckets API operation for Amazon Macie 2.
//
// Retrieves (queries) statistical data and other information about one or more
// S3 buckets that Amazon Macie monitors and analyzes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation DescribeBuckets for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeBuckets
func (c *Macie2) DescribeBuckets(input *DescribeBucketsInput) (*DescribeBucketsOutput, error) {
	req, out := c.DescribeBucketsRequest(input)
	return out, req.Send()
}

// DescribeBucketsWithContext is the same as DescribeBuckets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBuckets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) DescribeBucketsWithContext(ctx aws.Context, input *DescribeBucketsInput, opts ...request.Option) (*DescribeBucketsOutput, error) {
	req, out := c.DescribeBucketsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeBucketsPages iterates over the pages of a DescribeBuckets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeBuckets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeBuckets operation.
//    pageNum := 0
//    err := client.DescribeBucketsPages(params,
//        func(page *macie2.DescribeBucketsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Macie2) DescribeBucketsPages(input *DescribeBucketsInput, fn func(*DescribeBucketsOutput, bool) bool) error {
	return c.DescribeBucketsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeBucketsPagesWithContext same as DescribeBucketsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) DescribeBucketsPagesWithContext(ctx aws.Context, input *DescribeBucketsInput, fn func(*DescribeBucketsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeBucketsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeBucketsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeBucketsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClassificationJob = "DescribeClassificationJob"

// DescribeClassificationJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClassificationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClassificationJob for more information on using the DescribeClassificationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClassificationJobRequest method.
//    req, resp := client.DescribeClassificationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeClassificationJob
func (c *Macie2) DescribeClassificationJobRequest(input *DescribeClassificationJobInput) (req *request.Request, output *DescribeClassificationJobOutput) {
	op := &request.Operation{
		Name:       opDescribeClassificationJob,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs/{jobId}",
	}

	if input == nil {
		input = &DescribeClassificationJobInput{}
	}

	output = &DescribeClassificationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClassificationJob API operation for Amazon Macie 2.
//
// Retrieves information about the status and settings for a classification
// job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation DescribeClassificationJob for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeClassificationJob
func (c *Macie2) DescribeClassificationJob(input *DescribeClassificationJobInput) (*DescribeClassificationJobOutput, error) {
	req, out := c.DescribeClassificationJobRequest(input)
	return out, req.Send()
}

// DescribeClassificationJobWithContext is the same as DescribeClassificationJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClassificationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) DescribeClassificationJobWithContext(ctx aws.Context, input *DescribeClassificationJobInput, opts ...request.Option) (*DescribeClassificationJobOutput, error) {
	req, out := c.DescribeClassificationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationConfiguration = "DescribeOrganizationConfiguration"

// DescribeOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationConfiguration for more information on using the DescribeOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationConfigurationRequest method.
//    req, resp := client.DescribeOrganizationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeOrganizationConfiguration
func (c *Macie2) DescribeOrganizationConfigurationRequest(input *DescribeOrganizationConfigurationInput) (req *request.Request, output *DescribeOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/admin/configuration",
	}

	if input == nil {
		input = &DescribeOrganizationConfigurationInput{}
	}

	output = &DescribeOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationConfiguration API operation for Amazon Macie 2.
//
// Retrieves information about the Amazon Macie configuration settings for an
// AWS organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation DescribeOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeOrganizationConfiguration
func (c *Macie2) DescribeOrganizationConfiguration(input *DescribeOrganizationConfigurationInput) (*DescribeOrganizationConfigurationOutput, error) {
	req, out := c.DescribeOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// DescribeOrganizationConfigurationWithContext is the same as DescribeOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) DescribeOrganizationConfigurationWithContext(ctx aws.Context, input *DescribeOrganizationConfigurationInput, opts ...request.Option) (*DescribeOrganizationConfigurationOutput, error) {
	req, out := c.DescribeOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableMacie = "DisableMacie"

// DisableMacieRequest generates a "aws/request.Request" representing the
// client's request for the DisableMacie operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableMacie for more information on using the DisableMacie
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableMacieRequest method.
//    req, resp := client.DisableMacieRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisableMacie
func (c *Macie2) DisableMacieRequest(input *DisableMacieInput) (req *request.Request, output *DisableMacieOutput) {
	op := &request.Operation{
		Name:       opDisableMacie,
		HTTPMethod: "DELETE",
		HTTPPath:   "/macie",
	}

	if input == nil {
		input = &DisableMacieInput{}
	}

	output = &DisableMacieOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableMacie API operation for Amazon Macie 2.
//
// Disables an Amazon Macie account and deletes Macie resources for the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation DisableMacie for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisableMacie
func (c *Macie2) DisableMacie(input *DisableMacieInput) (*DisableMacieOutput, error) {
	req, out := c.DisableMacieRequest(input)
	return out, req.Send()
}

// DisableMacieWithContext is the same as DisableMacie with the addition of
// the ability to pass a context and additional request options.
//
// See DisableMacie for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) DisableMacieWithContext(ctx aws.Context, input *DisableMacieInput, opts ...request.Option) (*DisableMacieOutput, error) {
	req, out := c.DisableMacieRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableOrganizationAdminAccount = "DisableOrganizationAdminAccount"

// DisableOrganizationAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisableOrganizationAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableOrganizationAdminAccount for more information on using the DisableOrganizationAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableOrganizationAdminAccountRequest method.
//    req, resp := client.DisableOrganizationAdminAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisableOrganizationAdminAccount
func (c *Macie2) DisableOrganizationAdminAccountRequest(input *DisableOrganizationAdminAccountInput) (req *request.Request, output *DisableOrganizationAdminAccountOutput) {
	op := &request.Operation{
		Name:       opDisableOrganizationAdminAccount,
		HTTPMethod: "DELETE",
		HTTPPath:   "/admin",
	}

	if input == nil {
		input = &DisableOrganizationAdminAccountInput{}
	}

	output = &DisableOrganizationAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableOrganizationAdminAccount API operation for Amazon Macie 2.
//
// Disables an account as a delegated administrator of Amazon Macie for an AWS
// organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation DisableOrganizationAdminAccount for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisableOrganizationAdminAccount
func (c *Macie2) DisableOrganizationAdminAccount(input *DisableOrganizationAdminAccountInput) (*DisableOrganizationAdminAccountOutput, error) {
	req, out := c.DisableOrganizationAdminAccountRequest(input)
	return out, req.Send()
}

// DisableOrganizationAdminAccountWithContext is the same as DisableOrganizationAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisableOrganizationAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) DisableOrganizationAdminAccountWithContext(ctx aws.Context, input *DisableOrganizationAdminAccountInput, opts ...request.Option) (*DisableOrganizationAdminAccountOutput, error) {
	req, out := c.DisableOrganizationAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateFromMasterAccount = "DisassociateFromMasterAccount"

// DisassociateFromMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateFromMasterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateFromMasterAccount for more information on using the DisassociateFromMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateFromMasterAccountRequest method.
//    req, resp := client.DisassociateFromMasterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateFromMasterAccount
func (c *Macie2) DisassociateFromMasterAccountRequest(input *DisassociateFromMasterAccountInput) (req *request.Request, output *DisassociateFromMasterAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateFromMasterAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/master/disassociate",
	}

	if input == nil {
		input = &DisassociateFromMasterAccountInput{}
	}

	output = &DisassociateFromMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateFromMasterAccount API operation for Amazon Macie 2.
//
// Disassociates a member account from its Amazon Macie master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation DisassociateFromMasterAccount for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateFromMasterAccount
func (c *Macie2) DisassociateFromMasterAccount(input *DisassociateFromMasterAccountInput) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	return out, req.Send()
}

// DisassociateFromMasterAccountWithContext is the same as DisassociateFromMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateFromMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) DisassociateFromMasterAccountWithContext(ctx aws.Context, input *DisassociateFromMasterAccountInput, opts ...request.Option) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMember = "DisassociateMember"

// DisassociateMemberRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMember for more information on using the DisassociateMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateMemberRequest method.
//    req, resp := client.DisassociateMemberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateMember
func (c *Macie2) DisassociateMemberRequest(input *DisassociateMemberInput) (req *request.Request, output *DisassociateMemberOutput) {
	op := &request.Operation{
		Name:       opDisassociateMember,
		HTTPMethod: "POST",
		HTTPPath:   "/members/disassociate/{id}",
	}

	if input == nil {
		input = &DisassociateMemberInput{}
	}

	output = &DisassociateMemberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateMember API operation for Amazon Macie 2.
//
// Disassociates an Amazon Macie master account from a member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation DisassociateMember for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateMember
func (c *Macie2) DisassociateMember(input *DisassociateMemberInput) (*DisassociateMemberOutput, error) {
	req, out := c.DisassociateMemberRequest(input)
	return out, req.Send()
}

// DisassociateMemberWithContext is the same as DisassociateMember with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) DisassociateMemberWithContext(ctx aws.Context, input *DisassociateMemberInput, opts ...request.Option) (*DisassociateMemberOutput, error) {
	req, out := c.DisassociateMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableMacie = "EnableMacie"

// EnableMacieRequest generates a "aws/request.Request" representing the
// client's request for the EnableMacie operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableMacie for more information on using the EnableMacie
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableMacieRequest method.
//    req, resp := client.EnableMacieRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/EnableMacie
func (c *Macie2) EnableMacieRequest(input *EnableMacieInput) (req *request.Request, output *EnableMacieOutput) {
	op := &request.Operation{
		Name:       opEnableMacie,
		HTTPMethod: "POST",
		HTTPPath:   "/macie",
	}

	if input == nil {
		input = &EnableMacieInput{}
	}

	output = &EnableMacieOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableMacie API operation for Amazon Macie 2.
//
// Enables Amazon Macie and specifies the configuration settings for a Macie
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation EnableMacie for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/EnableMacie
func (c *Macie2) EnableMacie(input *EnableMacieInput) (*EnableMacieOutput, error) {
	req, out := c.EnableMacieRequest(input)
	return out, req.Send()
}

// EnableMacieWithContext is the same as EnableMacie with the addition of
// the ability to pass a context and additional request options.
//
// See EnableMacie for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) EnableMacieWithContext(ctx aws.Context, input *EnableMacieInput, opts ...request.Option) (*EnableMacieOutput, error) {
	req, out := c.EnableMacieRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableOrganizationAdminAccount = "EnableOrganizationAdminAccount"

// EnableOrganizationAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the EnableOrganizationAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableOrganizationAdminAccount for more information on using the EnableOrganizationAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableOrganizationAdminAccountRequest method.
//    req, resp := client.EnableOrganizationAdminAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/EnableOrganizationAdminAccount
func (c *Macie2) EnableOrganizationAdminAccountRequest(input *EnableOrganizationAdminAccountInput) (req *request.Request, output *EnableOrganizationAdminAccountOutput) {
	op := &request.Operation{
		Name:       opEnableOrganizationAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/admin",
	}

	if input == nil {
		input = &EnableOrganizationAdminAccountInput{}
	}

	output = &EnableOrganizationAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableOrganizationAdminAccount API operation for Amazon Macie 2.
//
// Enables an account as a delegated administrator of Amazon Macie for an AWS
// organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation EnableOrganizationAdminAccount for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/EnableOrganizationAdminAccount
func (c *Macie2) EnableOrganizationAdminAccount(input *EnableOrganizationAdminAccountInput) (*EnableOrganizationAdminAccountOutput, error) {
	req, out := c.EnableOrganizationAdminAccountRequest(input)
	return out, req.Send()
}

// EnableOrganizationAdminAccountWithContext is the same as EnableOrganizationAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See EnableOrganizationAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) EnableOrganizationAdminAccountWithContext(ctx aws.Context, input *EnableOrganizationAdminAccountInput, opts ...request.Option) (*EnableOrganizationAdminAccountOutput, error) {
	req, out := c.EnableOrganizationAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketStatistics = "GetBucketStatistics"

// GetBucketStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketStatistics for more information on using the GetBucketStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketStatisticsRequest method.
//    req, resp := client.GetBucketStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetBucketStatistics
func (c *Macie2) GetBucketStatisticsRequest(input *GetBucketStatisticsInput) (req *request.Request, output *GetBucketStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetBucketStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/datasources/s3/statistics",
	}

	if input == nil {
		input = &GetBucketStatisticsInput{}
	}

	output = &GetBucketStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketStatistics API operation for Amazon Macie 2.
//
// Retrieves (queries) aggregated statistical data for all the S3 buckets that
// Amazon Macie monitors and analyzes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation GetBucketStatistics for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetBucketStatistics
func (c *Macie2) GetBucketStatistics(input *GetBucketStatisticsInput) (*GetBucketStatisticsOutput, error) {
	req, out := c.GetBucketStatisticsRequest(input)
	return out, req.Send()
}

// GetBucketStatisticsWithContext is the same as GetBucketStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) GetBucketStatisticsWithContext(ctx aws.Context, input *GetBucketStatisticsInput, opts ...request.Option) (*GetBucketStatisticsOutput, error) {
	req, out := c.GetBucketStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetClassificationExportConfiguration = "GetClassificationExportConfiguration"

// GetClassificationExportConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetClassificationExportConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetClassificationExportConfiguration for more information on using the GetClassificationExportConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetClassificationExportConfigurationRequest method.
//    req, resp := client.GetClassificationExportConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetClassificationExportConfiguration
func (c *Macie2) GetClassificationExportConfigurationRequest(input *GetClassificationExportConfigurationInput) (req *request.Request, output *GetClassificationExportConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetClassificationExportConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/classification-export-configuration",
	}

	if input == nil {
		input = &GetClassificationExportConfigurationInput{}
	}

	output = &GetClassificationExportConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetClassificationExportConfiguration API operation for Amazon Macie 2.
//
// Retrieves the configuration settings for storing data classification results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation GetClassificationExportConfiguration for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetClassificationExportConfiguration
func (c *Macie2) GetClassificationExportConfiguration(input *GetClassificationExportConfigurationInput) (*GetClassificationExportConfigurationOutput, error) {
	req, out := c.GetClassificationExportConfigurationRequest(input)
	return out, req.Send()
}

// GetClassificationExportConfigurationWithContext is the same as GetClassificationExportConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetClassificationExportConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) GetClassificationExportConfigurationWithContext(ctx aws.Context, input *GetClassificationExportConfigurationInput, opts ...request.Option) (*GetClassificationExportConfigurationOutput, error) {
	req, out := c.GetClassificationExportConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCustomDataIdentifier = "GetCustomDataIdentifier"

// GetCustomDataIdentifierRequest generates a "aws/request.Request" representing the
// client's request for the GetCustomDataIdentifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCustomDataIdentifier for more information on using the GetCustomDataIdentifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCustomDataIdentifierRequest method.
//    req, resp := client.GetCustomDataIdentifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetCustomDataIdentifier
func (c *Macie2) GetCustomDataIdentifierRequest(input *GetCustomDataIdentifierInput) (req *request.Request, output *GetCustomDataIdentifierOutput) {
	op := &request.Operation{
		Name:       opGetCustomDataIdentifier,
		HTTPMethod: "GET",
		HTTPPath:   "/custom-data-identifiers/{id}",
	}

	if input == nil {
		input = &GetCustomDataIdentifierInput{}
	}

	output = &GetCustomDataIdentifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCustomDataIdentifier API operation for Amazon Macie 2.
//
// Retrieves information about the criteria and other settings for a custom
// data identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation GetCustomDataIdentifier for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetCustomDataIdentifier
func (c *Macie2) GetCustomDataIdentifier(input *GetCustomDataIdentifierInput) (*GetCustomDataIdentifierOutput, error) {
	req, out := c.GetCustomDataIdentifierRequest(input)
	return out, req.Send()
}

// GetCustomDataIdentifierWithContext is the same as GetCustomDataIdentifier with the addition of
// the ability to pass a context and additional request options.
//
// See GetCustomDataIdentifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) GetCustomDataIdentifierWithContext(ctx aws.Context, input *GetCustomDataIdentifierInput, opts ...request.Option) (*GetCustomDataIdentifierOutput, error) {
	req, out := c.GetCustomDataIdentifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFindingStatistics = "GetFindingStatistics"

// GetFindingStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetFindingStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindingStatistics for more information on using the GetFindingStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFindingStatisticsRequest method.
//    req, resp := client.GetFindingStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingStatistics
func (c *Macie2) GetFindingStatisticsRequest(input *GetFindingStatisticsInput) (req *request.Request, output *GetFindingStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetFindingStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/findings/statistics",
	}

	if input == nil {
		input = &GetFindingStatisticsInput{}
	}

	output = &GetFindingStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindingStatistics API operation for Amazon Macie 2.
//
// Retrieves (queries) aggregated statistical data about findings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation GetFindingStatistics for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingStatistics
func (c *Macie2) GetFindingStatistics(input *GetFindingStatisticsInput) (*GetFindingStatisticsOutput, error) {
	req, out := c.GetFindingStatisticsRequest(input)
	return out, req.Send()
}

// GetFindingStatisticsWithContext is the same as GetFindingStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindingStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) GetFindingStatisticsWithContext(ctx aws.Context, input *GetFindingStatisticsInput, opts ...request.Option) (*GetFindingStatisticsOutput, error) {
	req, out := c.GetFindingStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFindings = "GetFindings"

// GetFindingsRequest generates a "aws/request.Request" representing the
// client's request for the GetFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindings for more information on using the GetFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFindingsRequest method.
//    req, resp := client.GetFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindings
func (c *Macie2) GetFindingsRequest(input *GetFindingsInput) (req *request.Request, output *GetFindingsOutput) {
	op := &request.Operation{
		Name:       opGetFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings/describe",
	}

	if input == nil {
		input = &GetFindingsInput{}
	}

	output = &GetFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindings API operation for Amazon Macie 2.
//
// Retrieves information about one or more findings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation GetFindings for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindings
func (c *Macie2) GetFindings(input *GetFindingsInput) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	return out, req.Send()
}

// GetFindingsWithContext is the same as GetFindings with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) GetFindingsWithContext(ctx aws.Context, input *GetFindingsInput, opts ...request.Option) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFindingsFilter = "GetFindingsFilter"

// GetFindingsFilterRequest generates a "aws/request.Request" representing the
// client's request for the GetFindingsFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindingsFilter for more information on using the GetFindingsFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFindingsFilterRequest method.
//    req, resp := client.GetFindingsFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingsFilter
func (c *Macie2) GetFindingsFilterRequest(input *GetFindingsFilterInput) (req *request.Request, output *GetFindingsFilterOutput) {
	op := &request.Operation{
		Name:       opGetFindingsFilter,
		HTTPMethod: "GET",
		HTTPPath:   "/findingsfilters/{id}",
	}

	if input == nil {
		input = &GetFindingsFilterInput{}
	}

	output = &GetFindingsFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindingsFilter API operation for Amazon Macie 2.
//
// Retrieves information about the criteria and other settings for a findings
// filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation GetFindingsFilter for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingsFilter
func (c *Macie2) GetFindingsFilter(input *GetFindingsFilterInput) (*GetFindingsFilterOutput, error) {
	req, out := c.GetFindingsFilterRequest(input)
	return out, req.Send()
}

// GetFindingsFilterWithContext is the same as GetFindingsFilter with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindingsFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) GetFindingsFilterWithContext(ctx aws.Context, input *GetFindingsFilterInput, opts ...request.Option) (*GetFindingsFilterOutput, error) {
	req, out := c.GetFindingsFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInvitationsCount = "GetInvitationsCount"

// GetInvitationsCountRequest generates a "aws/request.Request" representing the
// client's request for the GetInvitationsCount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInvitationsCount for more information on using the GetInvitationsCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInvitationsCountRequest method.
//    req, resp := client.GetInvitationsCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetInvitationsCount
func (c *Macie2) GetInvitationsCountRequest(input *GetInvitationsCountInput) (req *request.Request, output *GetInvitationsCountOutput) {
	op := &request.Operation{
		Name:       opGetInvitationsCount,
		HTTPMethod: "GET",
		HTTPPath:   "/invitations/count",
	}

	if input == nil {
		input = &GetInvitationsCountInput{}
	}

	output = &GetInvitationsCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInvitationsCount API operation for Amazon Macie 2.
//
// Retrieves the count of Amazon Macie membership invitations that were received
// by an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation GetInvitationsCount for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetInvitationsCount
func (c *Macie2) GetInvitationsCount(input *GetInvitationsCountInput) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	return out, req.Send()
}

// GetInvitationsCountWithContext is the same as GetInvitationsCount with the addition of
// the ability to pass a context and additional request options.
//
// See GetInvitationsCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) GetInvitationsCountWithContext(ctx aws.Context, input *GetInvitationsCountInput, opts ...request.Option) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMacieSession = "GetMacieSession"

// GetMacieSessionRequest generates a "aws/request.Request" representing the
// client's request for the GetMacieSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMacieSession for more information on using the GetMacieSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMacieSessionRequest method.
//    req, resp := client.GetMacieSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMacieSession
func (c *Macie2) GetMacieSessionRequest(input *GetMacieSessionInput) (req *request.Request, output *GetMacieSessionOutput) {
	op := &request.Operation{
		Name:       opGetMacieSession,
		HTTPMethod: "GET",
		HTTPPath:   "/macie",
	}

	if input == nil {
		input = &GetMacieSessionInput{}
	}

	output = &GetMacieSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMacieSession API operation for Amazon Macie 2.
//
// Retrieves information about the current status and configuration settings
// for an Amazon Macie account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation GetMacieSession for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMacieSession
func (c *Macie2) GetMacieSession(input *GetMacieSessionInput) (*GetMacieSessionOutput, error) {
	req, out := c.GetMacieSessionRequest(input)
	return out, req.Send()
}

// GetMacieSessionWithContext is the same as GetMacieSession with the addition of
// the ability to pass a context and additional request options.
//
// See GetMacieSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) GetMacieSessionWithContext(ctx aws.Context, input *GetMacieSessionInput, opts ...request.Option) (*GetMacieSessionOutput, error) {
	req, out := c.GetMacieSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMasterAccount = "GetMasterAccount"

// GetMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetMasterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMasterAccount for more information on using the GetMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMasterAccountRequest method.
//    req, resp := client.GetMasterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMasterAccount
func (c *Macie2) GetMasterAccountRequest(input *GetMasterAccountInput) (req *request.Request, output *GetMasterAccountOutput) {
	op := &request.Operation{
		Name:       opGetMasterAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/master",
	}

	if input == nil {
		input = &GetMasterAccountInput{}
	}

	output = &GetMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMasterAccount API operation for Amazon Macie 2.
//
// Retrieves information about the Amazon Macie master account for an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation GetMasterAccount for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMasterAccount
func (c *Macie2) GetMasterAccount(input *GetMasterAccountInput) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	return out, req.Send()
}

// GetMasterAccountWithContext is the same as GetMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) GetMasterAccountWithContext(ctx aws.Context, input *GetMasterAccountInput, opts ...request.Option) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMember = "GetMember"

// GetMemberRequest generates a "aws/request.Request" representing the
// client's request for the GetMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMember for more information on using the GetMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMemberRequest method.
//    req, resp := client.GetMemberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMember
func (c *Macie2) GetMemberRequest(input *GetMemberInput) (req *request.Request, output *GetMemberOutput) {
	op := &request.Operation{
		Name:       opGetMember,
		HTTPMethod: "GET",
		HTTPPath:   "/members/{id}",
	}

	if input == nil {
		input = &GetMemberInput{}
	}

	output = &GetMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMember API operation for Amazon Macie 2.
//
// Retrieves information about a member account that's associated with an Amazon
// Macie master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation GetMember for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMember
func (c *Macie2) GetMember(input *GetMemberInput) (*GetMemberOutput, error) {
	req, out := c.GetMemberRequest(input)
	return out, req.Send()
}

// GetMemberWithContext is the same as GetMember with the addition of
// the ability to pass a context and additional request options.
//
// See GetMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) GetMemberWithContext(ctx aws.Context, input *GetMemberInput, opts ...request.Option) (*GetMemberOutput, error) {
	req, out := c.GetMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUsageStatistics = "GetUsageStatistics"

// GetUsageStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetUsageStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUsageStatistics for more information on using the GetUsageStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUsageStatisticsRequest method.
//    req, resp := client.GetUsageStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageStatistics
func (c *Macie2) GetUsageStatisticsRequest(input *GetUsageStatisticsInput) (req *request.Request, output *GetUsageStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetUsageStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/usage/statistics",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetUsageStatisticsInput{}
	}

	output = &GetUsageStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUsageStatistics API operation for Amazon Macie 2.
//
// Retrieves (queries) quotas and aggregated usage data for one or more accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation GetUsageStatistics for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageStatistics
func (c *Macie2) GetUsageStatistics(input *GetUsageStatisticsInput) (*GetUsageStatisticsOutput, error) {
	req, out := c.GetUsageStatisticsRequest(input)
	return out, req.Send()
}

// GetUsageStatisticsWithContext is the same as GetUsageStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetUsageStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) GetUsageStatisticsWithContext(ctx aws.Context, input *GetUsageStatisticsInput, opts ...request.Option) (*GetUsageStatisticsOutput, error) {
	req, out := c.GetUsageStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetUsageStatisticsPages iterates over the pages of a GetUsageStatistics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetUsageStatistics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetUsageStatistics operation.
//    pageNum := 0
//    err := client.GetUsageStatisticsPages(params,
//        func(page *macie2.GetUsageStatisticsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Macie2) GetUsageStatisticsPages(input *GetUsageStatisticsInput, fn func(*GetUsageStatisticsOutput, bool) bool) error {
	return c.GetUsageStatisticsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetUsageStatisticsPagesWithContext same as GetUsageStatisticsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) GetUsageStatisticsPagesWithContext(ctx aws.Context, input *GetUsageStatisticsInput, fn func(*GetUsageStatisticsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetUsageStatisticsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetUsageStatisticsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetUsageStatisticsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetUsageTotals = "GetUsageTotals"

// GetUsageTotalsRequest generates a "aws/request.Request" representing the
// client's request for the GetUsageTotals operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUsageTotals for more information on using the GetUsageTotals
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUsageTotalsRequest method.
//    req, resp := client.GetUsageTotalsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageTotals
func (c *Macie2) GetUsageTotalsRequest(input *GetUsageTotalsInput) (req *request.Request, output *GetUsageTotalsOutput) {
	op := &request.Operation{
		Name:       opGetUsageTotals,
		HTTPMethod: "GET",
		HTTPPath:   "/usage",
	}

	if input == nil {
		input = &GetUsageTotalsInput{}
	}

	output = &GetUsageTotalsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUsageTotals API operation for Amazon Macie 2.
//
// Retrieves (queries) aggregated usage data for an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation GetUsageTotals for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageTotals
func (c *Macie2) GetUsageTotals(input *GetUsageTotalsInput) (*GetUsageTotalsOutput, error) {
	req, out := c.GetUsageTotalsRequest(input)
	return out, req.Send()
}

// GetUsageTotalsWithContext is the same as GetUsageTotals with the addition of
// the ability to pass a context and additional request options.
//
// See GetUsageTotals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) GetUsageTotalsWithContext(ctx aws.Context, input *GetUsageTotalsInput, opts ...request.Option) (*GetUsageTotalsOutput, error) {
	req, out := c.GetUsageTotalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListClassificationJobs = "ListClassificationJobs"

// ListClassificationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListClassificationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClassificationJobs for more information on using the ListClassificationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListClassificationJobsRequest method.
//    req, resp := client.ListClassificationJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListClassificationJobs
func (c *Macie2) ListClassificationJobsRequest(input *ListClassificationJobsInput) (req *request.Request, output *ListClassificationJobsOutput) {
	op := &request.Operation{
		Name:       opListClassificationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/jobs/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClassificationJobsInput{}
	}

	output = &ListClassificationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClassificationJobs API operation for Amazon Macie 2.
//
// Retrieves a subset of information about one or more classification jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation ListClassificationJobs for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListClassificationJobs
func (c *Macie2) ListClassificationJobs(input *ListClassificationJobsInput) (*ListClassificationJobsOutput, error) {
	req, out := c.ListClassificationJobsRequest(input)
	return out, req.Send()
}

// ListClassificationJobsWithContext is the same as ListClassificationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListClassificationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) ListClassificationJobsWithContext(ctx aws.Context, input *ListClassificationJobsInput, opts ...request.Option) (*ListClassificationJobsOutput, error) {
	req, out := c.ListClassificationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClassificationJobsPages iterates over the pages of a ListClassificationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClassificationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListClassificationJobs operation.
//    pageNum := 0
//    err := client.ListClassificationJobsPages(params,
//        func(page *macie2.ListClassificationJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Macie2) ListClassificationJobsPages(input *ListClassificationJobsInput, fn func(*ListClassificationJobsOutput, bool) bool) error {
	return c.ListClassificationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClassificationJobsPagesWithContext same as ListClassificationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) ListClassificationJobsPagesWithContext(ctx aws.Context, input *ListClassificationJobsInput, fn func(*ListClassificationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClassificationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClassificationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClassificationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCustomDataIdentifiers = "ListCustomDataIdentifiers"

// ListCustomDataIdentifiersRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomDataIdentifiers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomDataIdentifiers for more information on using the ListCustomDataIdentifiers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCustomDataIdentifiersRequest method.
//    req, resp := client.ListCustomDataIdentifiersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListCustomDataIdentifiers
func (c *Macie2) ListCustomDataIdentifiersRequest(input *ListCustomDataIdentifiersInput) (req *request.Request, output *ListCustomDataIdentifiersOutput) {
	op := &request.Operation{
		Name:       opListCustomDataIdentifiers,
		HTTPMethod: "POST",
		HTTPPath:   "/custom-data-identifiers/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomDataIdentifiersInput{}
	}

	output = &ListCustomDataIdentifiersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomDataIdentifiers API operation for Amazon Macie 2.
//
// Retrieves a subset of information about all the custom data identifiers for
// an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation ListCustomDataIdentifiers for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListCustomDataIdentifiers
func (c *Macie2) ListCustomDataIdentifiers(input *ListCustomDataIdentifiersInput) (*ListCustomDataIdentifiersOutput, error) {
	req, out := c.ListCustomDataIdentifiersRequest(input)
	return out, req.Send()
}

// ListCustomDataIdentifiersWithContext is the same as ListCustomDataIdentifiers with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomDataIdentifiers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) ListCustomDataIdentifiersWithContext(ctx aws.Context, input *ListCustomDataIdentifiersInput, opts ...request.Option) (*ListCustomDataIdentifiersOutput, error) {
	req, out := c.ListCustomDataIdentifiersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomDataIdentifiersPages iterates over the pages of a ListCustomDataIdentifiers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomDataIdentifiers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCustomDataIdentifiers operation.
//    pageNum := 0
//    err := client.ListCustomDataIdentifiersPages(params,
//        func(page *macie2.ListCustomDataIdentifiersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Macie2) ListCustomDataIdentifiersPages(input *ListCustomDataIdentifiersInput, fn func(*ListCustomDataIdentifiersOutput, bool) bool) error {
	return c.ListCustomDataIdentifiersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomDataIdentifiersPagesWithContext same as ListCustomDataIdentifiersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) ListCustomDataIdentifiersPagesWithContext(ctx aws.Context, input *ListCustomDataIdentifiersInput, fn func(*ListCustomDataIdentifiersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomDataIdentifiersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomDataIdentifiersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomDataIdentifiersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFindings = "ListFindings"

// ListFindingsRequest generates a "aws/request.Request" representing the
// client's request for the ListFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFindings for more information on using the ListFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFindingsRequest method.
//    req, resp := client.ListFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindings
func (c *Macie2) ListFindingsRequest(input *ListFindingsInput) (req *request.Request, output *ListFindingsOutput) {
	op := &request.Operation{
		Name:       opListFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFindingsInput{}
	}

	output = &ListFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFindings API operation for Amazon Macie 2.
//
// Retrieves a subset of information about one or more findings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation ListFindings for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindings
func (c *Macie2) ListFindings(input *ListFindingsInput) (*ListFindingsOutput, error) {
	req, out := c.ListFindingsRequest(input)
	return out, req.Send()
}

// ListFindingsWithContext is the same as ListFindings with the addition of
// the ability to pass a context and additional request options.
//
// See ListFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) ListFindingsWithContext(ctx aws.Context, input *ListFindingsInput, opts ...request.Option) (*ListFindingsOutput, error) {
	req, out := c.ListFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFindingsPages iterates over the pages of a ListFindings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFindings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFindings operation.
//    pageNum := 0
//    err := client.ListFindingsPages(params,
//        func(page *macie2.ListFindingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Macie2) ListFindingsPages(input *ListFindingsInput, fn func(*ListFindingsOutput, bool) bool) error {
	return c.ListFindingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFindingsPagesWithContext same as ListFindingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) ListFindingsPagesWithContext(ctx aws.Context, input *ListFindingsInput, fn func(*ListFindingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFindingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFindingsFilters = "ListFindingsFilters"

// ListFindingsFiltersRequest generates a "aws/request.Request" representing the
// client's request for the ListFindingsFilters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFindingsFilters for more information on using the ListFindingsFilters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFindingsFiltersRequest method.
//    req, resp := client.ListFindingsFiltersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindingsFilters
func (c *Macie2) ListFindingsFiltersRequest(input *ListFindingsFiltersInput) (req *request.Request, output *ListFindingsFiltersOutput) {
	op := &request.Operation{
		Name:       opListFindingsFilters,
		HTTPMethod: "GET",
		HTTPPath:   "/findingsfilters",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFindingsFiltersInput{}
	}

	output = &ListFindingsFiltersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFindingsFilters API operation for Amazon Macie 2.
//
// Retrieves a subset of information about all the findings filters for an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation ListFindingsFilters for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindingsFilters
func (c *Macie2) ListFindingsFilters(input *ListFindingsFiltersInput) (*ListFindingsFiltersOutput, error) {
	req, out := c.ListFindingsFiltersRequest(input)
	return out, req.Send()
}

// ListFindingsFiltersWithContext is the same as ListFindingsFilters with the addition of
// the ability to pass a context and additional request options.
//
// See ListFindingsFilters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) ListFindingsFiltersWithContext(ctx aws.Context, input *ListFindingsFiltersInput, opts ...request.Option) (*ListFindingsFiltersOutput, error) {
	req, out := c.ListFindingsFiltersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFindingsFiltersPages iterates over the pages of a ListFindingsFilters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFindingsFilters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFindingsFilters operation.
//    pageNum := 0
//    err := client.ListFindingsFiltersPages(params,
//        func(page *macie2.ListFindingsFiltersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Macie2) ListFindingsFiltersPages(input *ListFindingsFiltersInput, fn func(*ListFindingsFiltersOutput, bool) bool) error {
	return c.ListFindingsFiltersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFindingsFiltersPagesWithContext same as ListFindingsFiltersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) ListFindingsFiltersPagesWithContext(ctx aws.Context, input *ListFindingsFiltersInput, fn func(*ListFindingsFiltersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFindingsFiltersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFindingsFiltersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFindingsFiltersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInvitations = "ListInvitations"

// ListInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInvitations for more information on using the ListInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInvitationsRequest method.
//    req, resp := client.ListInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListInvitations
func (c *Macie2) ListInvitationsRequest(input *ListInvitationsInput) (req *request.Request, output *ListInvitationsOutput) {
	op := &request.Operation{
		Name:       opListInvitations,
		HTTPMethod: "GET",
		HTTPPath:   "/invitations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInvitationsInput{}
	}

	output = &ListInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInvitations API operation for Amazon Macie 2.
//
// Retrieves information about all the Amazon Macie membership invitations that
// were received by an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation ListInvitations for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListInvitations
func (c *Macie2) ListInvitations(input *ListInvitationsInput) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	return out, req.Send()
}

// ListInvitationsWithContext is the same as ListInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) ListInvitationsWithContext(ctx aws.Context, input *ListInvitationsInput, opts ...request.Option) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInvitationsPages iterates over the pages of a ListInvitations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInvitations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInvitations operation.
//    pageNum := 0
//    err := client.ListInvitationsPages(params,
//        func(page *macie2.ListInvitationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Macie2) ListInvitationsPages(input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool) error {
	return c.ListInvitationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInvitationsPagesWithContext same as ListInvitationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) ListInvitationsPagesWithContext(ctx aws.Context, input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInvitationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInvitationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInvitationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMembers = "ListMembers"

// ListMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMembers for more information on using the ListMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMembersRequest method.
//    req, resp := client.ListMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListMembers
func (c *Macie2) ListMembersRequest(input *ListMembersInput) (req *request.Request, output *ListMembersOutput) {
	op := &request.Operation{
		Name:       opListMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/members",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMembersInput{}
	}

	output = &ListMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMembers API operation for Amazon Macie 2.
//
// Retrieves information about the accounts that are associated with an Amazon
// Macie master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation ListMembers for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListMembers
func (c *Macie2) ListMembers(input *ListMembersInput) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	return out, req.Send()
}

// ListMembersWithContext is the same as ListMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) ListMembersWithContext(ctx aws.Context, input *ListMembersInput, opts ...request.Option) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMembersPages iterates over the pages of a ListMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMembers operation.
//    pageNum := 0
//    err := client.ListMembersPages(params,
//        func(page *macie2.ListMembersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Macie2) ListMembersPages(input *ListMembersInput, fn func(*ListMembersOutput, bool) bool) error {
	return c.ListMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMembersPagesWithContext same as ListMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) ListMembersPagesWithContext(ctx aws.Context, input *ListMembersInput, fn func(*ListMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOrganizationAdminAccounts = "ListOrganizationAdminAccounts"

// ListOrganizationAdminAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListOrganizationAdminAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOrganizationAdminAccounts for more information on using the ListOrganizationAdminAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOrganizationAdminAccountsRequest method.
//    req, resp := client.ListOrganizationAdminAccountsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListOrganizationAdminAccounts
func (c *Macie2) ListOrganizationAdminAccountsRequest(input *ListOrganizationAdminAccountsInput) (req *request.Request, output *ListOrganizationAdminAccountsOutput) {
	op := &request.Operation{
		Name:       opListOrganizationAdminAccounts,
		HTTPMethod: "GET",
		HTTPPath:   "/admin",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOrganizationAdminAccountsInput{}
	}

	output = &ListOrganizationAdminAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOrganizationAdminAccounts API operation for Amazon Macie 2.
//
// Retrieves information about the account that's designated as the delegated
// administrator of Amazon Macie for an AWS organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation ListOrganizationAdminAccounts for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListOrganizationAdminAccounts
func (c *Macie2) ListOrganizationAdminAccounts(input *ListOrganizationAdminAccountsInput) (*ListOrganizationAdminAccountsOutput, error) {
	req, out := c.ListOrganizationAdminAccountsRequest(input)
	return out, req.Send()
}

// ListOrganizationAdminAccountsWithContext is the same as ListOrganizationAdminAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListOrganizationAdminAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) ListOrganizationAdminAccountsWithContext(ctx aws.Context, input *ListOrganizationAdminAccountsInput, opts ...request.Option) (*ListOrganizationAdminAccountsOutput, error) {
	req, out := c.ListOrganizationAdminAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOrganizationAdminAccountsPages iterates over the pages of a ListOrganizationAdminAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOrganizationAdminAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOrganizationAdminAccounts operation.
//    pageNum := 0
//    err := client.ListOrganizationAdminAccountsPages(params,
//        func(page *macie2.ListOrganizationAdminAccountsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Macie2) ListOrganizationAdminAccountsPages(input *ListOrganizationAdminAccountsInput, fn func(*ListOrganizationAdminAccountsOutput, bool) bool) error {
	return c.ListOrganizationAdminAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOrganizationAdminAccountsPagesWithContext same as ListOrganizationAdminAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) ListOrganizationAdminAccountsPagesWithContext(ctx aws.Context, input *ListOrganizationAdminAccountsInput, fn func(*ListOrganizationAdminAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOrganizationAdminAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOrganizationAdminAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOrganizationAdminAccountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListTagsForResource
func (c *Macie2) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Macie 2.
//
// Retrieves the tags (keys and values) that are associated with a classification
// job, custom data identifier, findings filter, or member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation ListTagsForResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListTagsForResource
func (c *Macie2) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutClassificationExportConfiguration = "PutClassificationExportConfiguration"

// PutClassificationExportConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutClassificationExportConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutClassificationExportConfiguration for more information on using the PutClassificationExportConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutClassificationExportConfigurationRequest method.
//    req, resp := client.PutClassificationExportConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/PutClassificationExportConfiguration
func (c *Macie2) PutClassificationExportConfigurationRequest(input *PutClassificationExportConfigurationInput) (req *request.Request, output *PutClassificationExportConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutClassificationExportConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/classification-export-configuration",
	}

	if input == nil {
		input = &PutClassificationExportConfigurationInput{}
	}

	output = &PutClassificationExportConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutClassificationExportConfiguration API operation for Amazon Macie 2.
//
// Creates or updates the configuration settings for storing data classification
// results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation PutClassificationExportConfiguration for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/PutClassificationExportConfiguration
func (c *Macie2) PutClassificationExportConfiguration(input *PutClassificationExportConfigurationInput) (*PutClassificationExportConfigurationOutput, error) {
	req, out := c.PutClassificationExportConfigurationRequest(input)
	return out, req.Send()
}

// PutClassificationExportConfigurationWithContext is the same as PutClassificationExportConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutClassificationExportConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) PutClassificationExportConfigurationWithContext(ctx aws.Context, input *PutClassificationExportConfigurationInput, opts ...request.Option) (*PutClassificationExportConfigurationOutput, error) {
	req, out := c.PutClassificationExportConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/TagResource
func (c *Macie2) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Macie 2.
//
// Adds or updates one or more tags (keys and values) that are associated with
// a classification job, custom data identifier, findings filter, or member
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation TagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/TagResource
func (c *Macie2) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestCustomDataIdentifier = "TestCustomDataIdentifier"

// TestCustomDataIdentifierRequest generates a "aws/request.Request" representing the
// client's request for the TestCustomDataIdentifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestCustomDataIdentifier for more information on using the TestCustomDataIdentifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestCustomDataIdentifierRequest method.
//    req, resp := client.TestCustomDataIdentifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/TestCustomDataIdentifier
func (c *Macie2) TestCustomDataIdentifierRequest(input *TestCustomDataIdentifierInput) (req *request.Request, output *TestCustomDataIdentifierOutput) {
	op := &request.Operation{
		Name:       opTestCustomDataIdentifier,
		HTTPMethod: "POST",
		HTTPPath:   "/custom-data-identifiers/test",
	}

	if input == nil {
		input = &TestCustomDataIdentifierInput{}
	}

	output = &TestCustomDataIdentifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestCustomDataIdentifier API operation for Amazon Macie 2.
//
// Tests a custom data identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation TestCustomDataIdentifier for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/TestCustomDataIdentifier
func (c *Macie2) TestCustomDataIdentifier(input *TestCustomDataIdentifierInput) (*TestCustomDataIdentifierOutput, error) {
	req, out := c.TestCustomDataIdentifierRequest(input)
	return out, req.Send()
}

// TestCustomDataIdentifierWithContext is the same as TestCustomDataIdentifier with the addition of
// the ability to pass a context and additional request options.
//
// See TestCustomDataIdentifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) TestCustomDataIdentifierWithContext(ctx aws.Context, input *TestCustomDataIdentifierInput, opts ...request.Option) (*TestCustomDataIdentifierOutput, error) {
	req, out := c.TestCustomDataIdentifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UntagResource
func (c *Macie2) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Macie 2.
//
// Removes one or more tags (keys and values) from a classification job, custom
// data identifier, findings filter, or member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation UntagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UntagResource
func (c *Macie2) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateClassificationJob = "UpdateClassificationJob"

// UpdateClassificationJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateClassificationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateClassificationJob for more information on using the UpdateClassificationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateClassificationJobRequest method.
//    req, resp := client.UpdateClassificationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateClassificationJob
func (c *Macie2) UpdateClassificationJobRequest(input *UpdateClassificationJobInput) (req *request.Request, output *UpdateClassificationJobOutput) {
	op := &request.Operation{
		Name:       opUpdateClassificationJob,
		HTTPMethod: "PATCH",
		HTTPPath:   "/jobs/{jobId}",
	}

	if input == nil {
		input = &UpdateClassificationJobInput{}
	}

	output = &UpdateClassificationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateClassificationJob API operation for Amazon Macie 2.
//
// Cancels a classification job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation UpdateClassificationJob for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateClassificationJob
func (c *Macie2) UpdateClassificationJob(input *UpdateClassificationJobInput) (*UpdateClassificationJobOutput, error) {
	req, out := c.UpdateClassificationJobRequest(input)
	return out, req.Send()
}

// UpdateClassificationJobWithContext is the same as UpdateClassificationJob with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateClassificationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) UpdateClassificationJobWithContext(ctx aws.Context, input *UpdateClassificationJobInput, opts ...request.Option) (*UpdateClassificationJobOutput, error) {
	req, out := c.UpdateClassificationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFindingsFilter = "UpdateFindingsFilter"

// UpdateFindingsFilterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFindingsFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFindingsFilter for more information on using the UpdateFindingsFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFindingsFilterRequest method.
//    req, resp := client.UpdateFindingsFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateFindingsFilter
func (c *Macie2) UpdateFindingsFilterRequest(input *UpdateFindingsFilterInput) (req *request.Request, output *UpdateFindingsFilterOutput) {
	op := &request.Operation{
		Name:       opUpdateFindingsFilter,
		HTTPMethod: "PATCH",
		HTTPPath:   "/findingsfilters/{id}",
	}

	if input == nil {
		input = &UpdateFindingsFilterInput{}
	}

	output = &UpdateFindingsFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFindingsFilter API operation for Amazon Macie 2.
//
// Updates the criteria and other settings for a findings filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation UpdateFindingsFilter for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateFindingsFilter
func (c *Macie2) UpdateFindingsFilter(input *UpdateFindingsFilterInput) (*UpdateFindingsFilterOutput, error) {
	req, out := c.UpdateFindingsFilterRequest(input)
	return out, req.Send()
}

// UpdateFindingsFilterWithContext is the same as UpdateFindingsFilter with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFindingsFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) UpdateFindingsFilterWithContext(ctx aws.Context, input *UpdateFindingsFilterInput, opts ...request.Option) (*UpdateFindingsFilterOutput, error) {
	req, out := c.UpdateFindingsFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMacieSession = "UpdateMacieSession"

// UpdateMacieSessionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMacieSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMacieSession for more information on using the UpdateMacieSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMacieSessionRequest method.
//    req, resp := client.UpdateMacieSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateMacieSession
func (c *Macie2) UpdateMacieSessionRequest(input *UpdateMacieSessionInput) (req *request.Request, output *UpdateMacieSessionOutput) {
	op := &request.Operation{
		Name:       opUpdateMacieSession,
		HTTPMethod: "PATCH",
		HTTPPath:   "/macie",
	}

	if input == nil {
		input = &UpdateMacieSessionInput{}
	}

	output = &UpdateMacieSessionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateMacieSession API operation for Amazon Macie 2.
//
// Suspends or re-enables an Amazon Macie account, or updates the configuration
// settings for a Macie account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation UpdateMacieSession for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateMacieSession
func (c *Macie2) UpdateMacieSession(input *UpdateMacieSessionInput) (*UpdateMacieSessionOutput, error) {
	req, out := c.UpdateMacieSessionRequest(input)
	return out, req.Send()
}

// UpdateMacieSessionWithContext is the same as UpdateMacieSession with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMacieSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) UpdateMacieSessionWithContext(ctx aws.Context, input *UpdateMacieSessionInput, opts ...request.Option) (*UpdateMacieSessionOutput, error) {
	req, out := c.UpdateMacieSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMemberSession = "UpdateMemberSession"

// UpdateMemberSessionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMemberSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMemberSession for more information on using the UpdateMemberSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMemberSessionRequest method.
//    req, resp := client.UpdateMemberSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateMemberSession
func (c *Macie2) UpdateMemberSessionRequest(input *UpdateMemberSessionInput) (req *request.Request, output *UpdateMemberSessionOutput) {
	op := &request.Operation{
		Name:       opUpdateMemberSession,
		HTTPMethod: "PATCH",
		HTTPPath:   "/macie/members/{id}",
	}

	if input == nil {
		input = &UpdateMemberSessionInput{}
	}

	output = &UpdateMemberSessionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateMemberSession API operation for Amazon Macie 2.
//
// Enables an Amazon Macie master account to suspend or re-enable a member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation UpdateMemberSession for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateMemberSession
func (c *Macie2) UpdateMemberSession(input *UpdateMemberSessionInput) (*UpdateMemberSessionOutput, error) {
	req, out := c.UpdateMemberSessionRequest(input)
	return out, req.Send()
}

// UpdateMemberSessionWithContext is the same as UpdateMemberSession with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMemberSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) UpdateMemberSessionWithContext(ctx aws.Context, input *UpdateMemberSessionInput, opts ...request.Option) (*UpdateMemberSessionOutput, error) {
	req, out := c.UpdateMemberSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOrganizationConfiguration = "UpdateOrganizationConfiguration"

// UpdateOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOrganizationConfiguration for more information on using the UpdateOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateOrganizationConfigurationRequest method.
//    req, resp := client.UpdateOrganizationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateOrganizationConfiguration
func (c *Macie2) UpdateOrganizationConfigurationRequest(input *UpdateOrganizationConfigurationInput) (req *request.Request, output *UpdateOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateOrganizationConfiguration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/admin/configuration",
	}

	if input == nil {
		input = &UpdateOrganizationConfigurationInput{}
	}

	output = &UpdateOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateOrganizationConfiguration API operation for Amazon Macie 2.
//
// Updates Amazon Macie configuration settings for an AWS organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie 2's
// API operation UpdateOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Provides information about an error that occurred due to a syntax error in
//   a request.
//
//   * InternalServerException
//   Provides information about an error that occurred due to an unknown internal
//   server error, exception, or failure.
//
//   * ServiceQuotaExceededException
//   Provides information about an error that occurred due to one or more service
//   quotas for an account.
//
//   * AccessDeniedException
//   Provides information about an error that occurred due to insufficient access
//   to a specified resource.
//
//   * ResourceNotFoundException
//   Provides information about an error that occurred because a specified resource
//   wasn't found.
//
//   * ThrottlingException
//   Provides information about an error that occurred because too many requests
//   were sent during a certain amount of time.
//
//   * ConflictException
//   Provides information about an error that occurred due to a versioning conflict
//   for a specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateOrganizationConfiguration
func (c *Macie2) UpdateOrganizationConfiguration(input *UpdateOrganizationConfigurationInput) (*UpdateOrganizationConfigurationOutput, error) {
	req, out := c.UpdateOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// UpdateOrganizationConfigurationWithContext is the same as UpdateOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) UpdateOrganizationConfigurationWithContext(ctx aws.Context, input *UpdateOrganizationConfigurationInput, opts ...request.Option) (*UpdateOrganizationConfigurationOutput, error) {
	req, out := c.UpdateOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Specifies an Amazon Macie membership invitation to accept.
type AcceptInvitationInput struct {
	_ struct{} `type:"structure"`

	// InvitationId is a required field
	InvitationId *string `locationName:"invitationId" type:"string" required:"true"`

	// MasterAccount is a required field
	MasterAccount *string `locationName:"masterAccount" type:"string" required:"true"`
}

// String returns the string representation
func (s AcceptInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptInvitationInput"}
	if s.InvitationId == nil {
		invalidParams.Add(request.NewErrParamRequired("InvitationId"))
	}
	if s.MasterAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterAccount"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvitationId sets the InvitationId field's value.
func (s *AcceptInvitationInput) SetInvitationId(v string) *AcceptInvitationInput {
	s.InvitationId = &v
	return s
}

// SetMasterAccount sets the MasterAccount field's value.
func (s *AcceptInvitationInput) SetMasterAccount(v string) *AcceptInvitationInput {
	s.MasterAccount = &v
	return s
}

type AcceptInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcceptInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptInvitationOutput) GoString() string {
	return s.String()
}

// Provides information about the permissions settings of the bucket-level access
// control list (ACL) for an S3 bucket.
type AccessControlList struct {
	_ struct{} `type:"structure"`

	AllowsPublicReadAccess *bool `locationName:"allowsPublicReadAccess" type:"boolean"`

	AllowsPublicWriteAccess *bool `locationName:"allowsPublicWriteAccess" type:"boolean"`
}

// String returns the string representation
func (s AccessControlList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessControlList) GoString() string {
	return s.String()
}

// SetAllowsPublicReadAccess sets the AllowsPublicReadAccess field's value.
func (s *AccessControlList) SetAllowsPublicReadAccess(v bool) *AccessControlList {
	s.AllowsPublicReadAccess = &v
	return s
}

// SetAllowsPublicWriteAccess sets the AllowsPublicWriteAccess field's value.
func (s *AccessControlList) SetAllowsPublicWriteAccess(v bool) *AccessControlList {
	s.AllowsPublicWriteAccess = &v
	return s
}

// Provides information about an error that occurred due to insufficient access
// to a specified resource.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies details for an account to associate with an Amazon Macie master
// account.
type AccountDetail struct {
	_ struct{} `type:"structure"`

	// AccountId is a required field
	AccountId *string `locationName:"accountId" type:"string" required:"true"`

	// Email is a required field
	Email *string `locationName:"email" type:"string" required:"true"`
}

// String returns the string representation
func (s AccountDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountDetail) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountDetail) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountDetail"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.Email == nil {
		invalidParams.Add(request.NewErrParamRequired("Email"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AccountDetail) SetAccountId(v string) *AccountDetail {
	s.AccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *AccountDetail) SetEmail(v string) *AccountDetail {
	s.Email = &v
	return s
}

// Provides information about account-level permissions settings that apply
// to an S3 bucket.
type AccountLevelPermissions struct {
	_ struct{} `type:"structure"`

	// Provides information about the block public access settings for an S3 bucket.
	// These settings can apply to a bucket at the account level or bucket level.
	// For detailed information about each setting, see Using Amazon S3 block public
	// access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
	// in the Amazon Simple Storage Service Developer Guide.
	BlockPublicAccess *BlockPublicAccess `locationName:"blockPublicAccess" type:"structure"`
}

// String returns the string representation
func (s AccountLevelPermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountLevelPermissions) GoString() string {
	return s.String()
}

// SetBlockPublicAccess sets the BlockPublicAccess field's value.
func (s *AccountLevelPermissions) SetBlockPublicAccess(v *BlockPublicAccess) *AccountLevelPermissions {
	s.BlockPublicAccess = v
	return s
}

// Provides information about an account that's designated as a delegated administrator
// of Amazon Macie for an AWS organization.
type AdminAccount struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	// The current status of an account as a delegated administrator of Amazon Macie
	// for an AWS organization.
	Status *string `locationName:"status" type:"string" enum:"AdminStatus"`
}

// String returns the string representation
func (s AdminAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminAccount) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AdminAccount) SetAccountId(v string) *AdminAccount {
	s.AccountId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AdminAccount) SetStatus(v string) *AdminAccount {
	s.Status = &v
	return s
}

// Provides information about an API operation that an entity invoked for an
// affected resource.
type ApiCallDetails struct {
	_ struct{} `type:"structure"`

	Api *string `locationName:"api" type:"string"`

	ApiServiceName *string `locationName:"apiServiceName" type:"string"`

	FirstSeen *time.Time `locationName:"firstSeen" type:"timestamp" timestampFormat:"iso8601"`

	LastSeen *time.Time `locationName:"lastSeen" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ApiCallDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApiCallDetails) GoString() string {
	return s.String()
}

// SetApi sets the Api field's value.
func (s *ApiCallDetails) SetApi(v string) *ApiCallDetails {
	s.Api = &v
	return s
}

// SetApiServiceName sets the ApiServiceName field's value.
func (s *ApiCallDetails) SetApiServiceName(v string) *ApiCallDetails {
	s.ApiServiceName = &v
	return s
}

// SetFirstSeen sets the FirstSeen field's value.
func (s *ApiCallDetails) SetFirstSeen(v time.Time) *ApiCallDetails {
	s.FirstSeen = &v
	return s
}

// SetLastSeen sets the LastSeen field's value.
func (s *ApiCallDetails) SetLastSeen(v time.Time) *ApiCallDetails {
	s.LastSeen = &v
	return s
}

// Provides information about an identity that performed an action on an affected
// resource by using temporary security credentials. The credentials were obtained
// using the AssumeRole operation of the AWS Security Token Service (AWS STS)
// API.
type AssumedRole struct {
	_ struct{} `type:"structure"`

	AccessKeyId *string `locationName:"accessKeyId" type:"string"`

	AccountId *string `locationName:"accountId" type:"string"`

	Arn *string `locationName:"arn" type:"string"`

	PrincipalId *string `locationName:"principalId" type:"string"`

	// Provides information about a session that was created for an entity that
	// performed an action by using temporary security credentials.
	SessionContext *SessionContext `locationName:"sessionContext" type:"structure"`
}

// String returns the string representation
func (s AssumedRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssumedRole) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *AssumedRole) SetAccessKeyId(v string) *AssumedRole {
	s.AccessKeyId = &v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *AssumedRole) SetAccountId(v string) *AssumedRole {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *AssumedRole) SetArn(v string) *AssumedRole {
	s.Arn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AssumedRole) SetPrincipalId(v string) *AssumedRole {
	s.PrincipalId = &v
	return s
}

// SetSessionContext sets the SessionContext field's value.
func (s *AssumedRole) SetSessionContext(v *SessionContext) *AssumedRole {
	s.SessionContext = v
	return s
}

// Provides information about an AWS account and entity that performed an action
// on an affected resource. The action was performed using the credentials for
// an AWS account other than your own account.
type AwsAccount struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	PrincipalId *string `locationName:"principalId" type:"string"`
}

// String returns the string representation
func (s AwsAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsAccount) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AwsAccount) SetAccountId(v string) *AwsAccount {
	s.AccountId = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AwsAccount) SetPrincipalId(v string) *AwsAccount {
	s.PrincipalId = &v
	return s
}

// Provides information about an AWS service that performed an action on an
// affected resource.
type AwsService struct {
	_ struct{} `type:"structure"`

	InvokedBy *string `locationName:"invokedBy" type:"string"`
}

// String returns the string representation
func (s AwsService) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsService) GoString() string {
	return s.String()
}

// SetInvokedBy sets the InvokedBy field's value.
func (s *AwsService) SetInvokedBy(v string) *AwsService {
	s.InvokedBy = &v
	return s
}

// Provides information about a custom data identifier.
type BatchGetCustomDataIdentifierSummary struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	Deleted *bool `locationName:"deleted" type:"boolean"`

	Description *string `locationName:"description" type:"string"`

	Id *string `locationName:"id" type:"string"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s BatchGetCustomDataIdentifierSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetCustomDataIdentifierSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *BatchGetCustomDataIdentifierSummary) SetArn(v string) *BatchGetCustomDataIdentifierSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *BatchGetCustomDataIdentifierSummary) SetCreatedAt(v time.Time) *BatchGetCustomDataIdentifierSummary {
	s.CreatedAt = &v
	return s
}

// SetDeleted sets the Deleted field's value.
func (s *BatchGetCustomDataIdentifierSummary) SetDeleted(v bool) *BatchGetCustomDataIdentifierSummary {
	s.Deleted = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BatchGetCustomDataIdentifierSummary) SetDescription(v string) *BatchGetCustomDataIdentifierSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *BatchGetCustomDataIdentifierSummary) SetId(v string) *BatchGetCustomDataIdentifierSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *BatchGetCustomDataIdentifierSummary) SetName(v string) *BatchGetCustomDataIdentifierSummary {
	s.Name = &v
	return s
}

// Specifies one or more custom data identifiers to retrieve information about.
type BatchGetCustomDataIdentifiersInput struct {
	_ struct{} `type:"structure"`

	Ids []*string `locationName:"ids" type:"list"`
}

// String returns the string representation
func (s BatchGetCustomDataIdentifiersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetCustomDataIdentifiersInput) GoString() string {
	return s.String()
}

// SetIds sets the Ids field's value.
func (s *BatchGetCustomDataIdentifiersInput) SetIds(v []*string) *BatchGetCustomDataIdentifiersInput {
	s.Ids = v
	return s
}

// Provides information about one or more custom data identifiers.
type BatchGetCustomDataIdentifiersOutput struct {
	_ struct{} `type:"structure"`

	CustomDataIdentifiers []*BatchGetCustomDataIdentifierSummary `locationName:"customDataIdentifiers" type:"list"`

	NotFoundIdentifierIds []*string `locationName:"notFoundIdentifierIds" type:"list"`
}

// String returns the string representation
func (s BatchGetCustomDataIdentifiersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetCustomDataIdentifiersOutput) GoString() string {
	return s.String()
}

// SetCustomDataIdentifiers sets the CustomDataIdentifiers field's value.
func (s *BatchGetCustomDataIdentifiersOutput) SetCustomDataIdentifiers(v []*BatchGetCustomDataIdentifierSummary) *BatchGetCustomDataIdentifiersOutput {
	s.CustomDataIdentifiers = v
	return s
}

// SetNotFoundIdentifierIds sets the NotFoundIdentifierIds field's value.
func (s *BatchGetCustomDataIdentifiersOutput) SetNotFoundIdentifierIds(v []*string) *BatchGetCustomDataIdentifiersOutput {
	s.NotFoundIdentifierIds = v
	return s
}

// Provides information about the block public access settings for an S3 bucket.
// These settings can apply to a bucket at the account level or bucket level.
// For detailed information about each setting, see Using Amazon S3 block public
// access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
// in the Amazon Simple Storage Service Developer Guide.
type BlockPublicAccess struct {
	_ struct{} `type:"structure"`

	BlockPublicAcls *bool `locationName:"blockPublicAcls" type:"boolean"`

	BlockPublicPolicy *bool `locationName:"blockPublicPolicy" type:"boolean"`

	IgnorePublicAcls *bool `locationName:"ignorePublicAcls" type:"boolean"`

	RestrictPublicBuckets *bool `locationName:"restrictPublicBuckets" type:"boolean"`
}

// String returns the string representation
func (s BlockPublicAccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockPublicAccess) GoString() string {
	return s.String()
}

// SetBlockPublicAcls sets the BlockPublicAcls field's value.
func (s *BlockPublicAccess) SetBlockPublicAcls(v bool) *BlockPublicAccess {
	s.BlockPublicAcls = &v
	return s
}

// SetBlockPublicPolicy sets the BlockPublicPolicy field's value.
func (s *BlockPublicAccess) SetBlockPublicPolicy(v bool) *BlockPublicAccess {
	s.BlockPublicPolicy = &v
	return s
}

// SetIgnorePublicAcls sets the IgnorePublicAcls field's value.
func (s *BlockPublicAccess) SetIgnorePublicAcls(v bool) *BlockPublicAccess {
	s.IgnorePublicAcls = &v
	return s
}

// SetRestrictPublicBuckets sets the RestrictPublicBuckets field's value.
func (s *BlockPublicAccess) SetRestrictPublicBuckets(v bool) *BlockPublicAccess {
	s.RestrictPublicBuckets = &v
	return s
}

// Provides information about the number of S3 buckets that are publicly accessible
// based on a combination of permissions settings for each bucket.
type BucketCountByEffectivePermission struct {
	_ struct{} `type:"structure"`

	PubliclyAccessible *int64 `locationName:"publiclyAccessible" type:"long"`

	PubliclyReadable *int64 `locationName:"publiclyReadable" type:"long"`

	PubliclyWritable *int64 `locationName:"publiclyWritable" type:"long"`
}

// String returns the string representation
func (s BucketCountByEffectivePermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketCountByEffectivePermission) GoString() string {
	return s.String()
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *BucketCountByEffectivePermission) SetPubliclyAccessible(v int64) *BucketCountByEffectivePermission {
	s.PubliclyAccessible = &v
	return s
}

// SetPubliclyReadable sets the PubliclyReadable field's value.
func (s *BucketCountByEffectivePermission) SetPubliclyReadable(v int64) *BucketCountByEffectivePermission {
	s.PubliclyReadable = &v
	return s
}

// SetPubliclyWritable sets the PubliclyWritable field's value.
func (s *BucketCountByEffectivePermission) SetPubliclyWritable(v int64) *BucketCountByEffectivePermission {
	s.PubliclyWritable = &v
	return s
}

// Provides information about the number of S3 buckets that use certain types
// of server-side encryption or don't encrypt objects by default.
type BucketCountByEncryptionType struct {
	_ struct{} `type:"structure"`

	KmsManaged *int64 `locationName:"kmsManaged" type:"long"`

	S3Managed *int64 `locationName:"s3Managed" type:"long"`

	Unencrypted *int64 `locationName:"unencrypted" type:"long"`
}

// String returns the string representation
func (s BucketCountByEncryptionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketCountByEncryptionType) GoString() string {
	return s.String()
}

// SetKmsManaged sets the KmsManaged field's value.
func (s *BucketCountByEncryptionType) SetKmsManaged(v int64) *BucketCountByEncryptionType {
	s.KmsManaged = &v
	return s
}

// SetS3Managed sets the S3Managed field's value.
func (s *BucketCountByEncryptionType) SetS3Managed(v int64) *BucketCountByEncryptionType {
	s.S3Managed = &v
	return s
}

// SetUnencrypted sets the Unencrypted field's value.
func (s *BucketCountByEncryptionType) SetUnencrypted(v int64) *BucketCountByEncryptionType {
	s.Unencrypted = &v
	return s
}

// Provides information about the number of S3 buckets that are shared with
// other AWS accounts.
type BucketCountBySharedAccessType struct {
	_ struct{} `type:"structure"`

	External *int64 `locationName:"external" type:"long"`

	Internal *int64 `locationName:"internal" type:"long"`

	NotShared *int64 `locationName:"notShared" type:"long"`
}

// String returns the string representation
func (s BucketCountBySharedAccessType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketCountBySharedAccessType) GoString() string {
	return s.String()
}

// SetExternal sets the External field's value.
func (s *BucketCountBySharedAccessType) SetExternal(v int64) *BucketCountBySharedAccessType {
	s.External = &v
	return s
}

// SetInternal sets the Internal field's value.
func (s *BucketCountBySharedAccessType) SetInternal(v int64) *BucketCountBySharedAccessType {
	s.Internal = &v
	return s
}

// SetNotShared sets the NotShared field's value.
func (s *BucketCountBySharedAccessType) SetNotShared(v int64) *BucketCountBySharedAccessType {
	s.NotShared = &v
	return s
}

// Specifies the operator to use in an attribute-based condition that filters
// the results of a query for information about S3 buckets.
type BucketCriteriaAdditionalProperties struct {
	_ struct{} `type:"structure"`

	Eq []*string `locationName:"eq" type:"list"`

	Gt *int64 `locationName:"gt" type:"long"`

	Gte *int64 `locationName:"gte" type:"long"`

	Lt *int64 `locationName:"lt" type:"long"`

	Lte *int64 `locationName:"lte" type:"long"`

	Neq []*string `locationName:"neq" type:"list"`

	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation
func (s BucketCriteriaAdditionalProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketCriteriaAdditionalProperties) GoString() string {
	return s.String()
}

// SetEq sets the Eq field's value.
func (s *BucketCriteriaAdditionalProperties) SetEq(v []*string) *BucketCriteriaAdditionalProperties {
	s.Eq = v
	return s
}

// SetGt sets the Gt field's value.
func (s *BucketCriteriaAdditionalProperties) SetGt(v int64) *BucketCriteriaAdditionalProperties {
	s.Gt = &v
	return s
}

// SetGte sets the Gte field's value.
func (s *BucketCriteriaAdditionalProperties) SetGte(v int64) *BucketCriteriaAdditionalProperties {
	s.Gte = &v
	return s
}

// SetLt sets the Lt field's value.
func (s *BucketCriteriaAdditionalProperties) SetLt(v int64) *BucketCriteriaAdditionalProperties {
	s.Lt = &v
	return s
}

// SetLte sets the Lte field's value.
func (s *BucketCriteriaAdditionalProperties) SetLte(v int64) *BucketCriteriaAdditionalProperties {
	s.Lte = &v
	return s
}

// SetNeq sets the Neq field's value.
func (s *BucketCriteriaAdditionalProperties) SetNeq(v []*string) *BucketCriteriaAdditionalProperties {
	s.Neq = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *BucketCriteriaAdditionalProperties) SetPrefix(v string) *BucketCriteriaAdditionalProperties {
	s.Prefix = &v
	return s
}

// Provides information about the bucket-level permissions settings for an S3
// bucket.
type BucketLevelPermissions struct {
	_ struct{} `type:"structure"`

	// Provides information about the permissions settings of the bucket-level access
	// control list (ACL) for an S3 bucket.
	AccessControlList *AccessControlList `locationName:"accessControlList" type:"structure"`

	// Provides information about the block public access settings for an S3 bucket.
	// These settings can apply to a bucket at the account level or bucket level.
	// For detailed information about each setting, see Using Amazon S3 block public
	// access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
	// in the Amazon Simple Storage Service Developer Guide.
	BlockPublicAccess *BlockPublicAccess `locationName:"blockPublicAccess" type:"structure"`

	// Provides information about the permissions settings of a bucket policy for
	// an S3 bucket.
	BucketPolicy *BucketPolicy `locationName:"bucketPolicy" type:"structure"`
}

// String returns the string representation
func (s BucketLevelPermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketLevelPermissions) GoString() string {
	return s.String()
}

// SetAccessControlList sets the AccessControlList field's value.
func (s *BucketLevelPermissions) SetAccessControlList(v *AccessControlList) *BucketLevelPermissions {
	s.AccessControlList = v
	return s
}

// SetBlockPublicAccess sets the BlockPublicAccess field's value.
func (s *BucketLevelPermissions) SetBlockPublicAccess(v *BlockPublicAccess) *BucketLevelPermissions {
	s.BlockPublicAccess = v
	return s
}

// SetBucketPolicy sets the BucketPolicy field's value.
func (s *BucketLevelPermissions) SetBucketPolicy(v *BucketPolicy) *BucketLevelPermissions {
	s.BucketPolicy = v
	return s
}

// Provides information about an S3 bucket that Amazon Macie monitors and analyzes.
type BucketMetadata struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	BucketArn *string `locationName:"bucketArn" type:"string"`

	BucketCreatedAt *time.Time `locationName:"bucketCreatedAt" type:"timestamp" timestampFormat:"iso8601"`

	BucketName *string `locationName:"bucketName" type:"string"`

	ClassifiableObjectCount *int64 `locationName:"classifiableObjectCount" type:"long"`

	ClassifiableSizeInBytes *int64 `locationName:"classifiableSizeInBytes" type:"long"`

	LastUpdated *time.Time `locationName:"lastUpdated" type:"timestamp" timestampFormat:"iso8601"`

	ObjectCount *int64 `locationName:"objectCount" type:"long"`

	// Provides information about the number of objects that are in an S3 bucket
	// and use certain types of server-side encryption, use client-side encryption,
	// or aren't encrypted.
	ObjectCountByEncryptionType *ObjectCountByEncryptionType `locationName:"objectCountByEncryptionType" type:"structure"`

	// Provides information about the permissions settings that determine whether
	// an S3 bucket is publicly accessible.
	PublicAccess *BucketPublicAccess `locationName:"publicAccess" type:"structure"`

	Region *string `locationName:"region" type:"string"`

	// Provides information about settings that define whether one or more objects
	// in an S3 bucket are replicated to S3 buckets for other AWS accounts and,
	// if so, which accounts.
	ReplicationDetails *ReplicationDetails `locationName:"replicationDetails" type:"structure"`

	SharedAccess *string `locationName:"sharedAccess" type:"string" enum:"SharedAccess"`

	SizeInBytes *int64 `locationName:"sizeInBytes" type:"long"`

	SizeInBytesCompressed *int64 `locationName:"sizeInBytesCompressed" type:"long"`

	Tags []*KeyValuePair `locationName:"tags" type:"list"`

	// Provides information about the total storage size (in bytes) or number of
	// objects that Amazon Macie can't analyze in one or more S3 buckets. In a BucketMetadata
	// object, this data is for a specific bucket. In a GetBucketStatisticsResponse
	// object, this data is aggregated for all the buckets in the query results.
	UnclassifiableObjectCount *ObjectLevelStatistics `locationName:"unclassifiableObjectCount" type:"structure"`

	// Provides information about the total storage size (in bytes) or number of
	// objects that Amazon Macie can't analyze in one or more S3 buckets. In a BucketMetadata
	// object, this data is for a specific bucket. In a GetBucketStatisticsResponse
	// object, this data is aggregated for all the buckets in the query results.
	UnclassifiableObjectSizeInBytes *ObjectLevelStatistics `locationName:"unclassifiableObjectSizeInBytes" type:"structure"`

	Versioning *bool `locationName:"versioning" type:"boolean"`
}

// String returns the string representation
func (s BucketMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketMetadata) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *BucketMetadata) SetAccountId(v string) *BucketMetadata {
	s.AccountId = &v
	return s
}

// SetBucketArn sets the BucketArn field's value.
func (s *BucketMetadata) SetBucketArn(v string) *BucketMetadata {
	s.BucketArn = &v
	return s
}

// SetBucketCreatedAt sets the BucketCreatedAt field's value.
func (s *BucketMetadata) SetBucketCreatedAt(v time.Time) *BucketMetadata {
	s.BucketCreatedAt = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *BucketMetadata) SetBucketName(v string) *BucketMetadata {
	s.BucketName = &v
	return s
}

// SetClassifiableObjectCount sets the ClassifiableObjectCount field's value.
func (s *BucketMetadata) SetClassifiableObjectCount(v int64) *BucketMetadata {
	s.ClassifiableObjectCount = &v
	return s
}

// SetClassifiableSizeInBytes sets the ClassifiableSizeInBytes field's value.
func (s *BucketMetadata) SetClassifiableSizeInBytes(v int64) *BucketMetadata {
	s.ClassifiableSizeInBytes = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *BucketMetadata) SetLastUpdated(v time.Time) *BucketMetadata {
	s.LastUpdated = &v
	return s
}

// SetObjectCount sets the ObjectCount field's value.
func (s *BucketMetadata) SetObjectCount(v int64) *BucketMetadata {
	s.ObjectCount = &v
	return s
}

// SetObjectCountByEncryptionType sets the ObjectCountByEncryptionType field's value.
func (s *BucketMetadata) SetObjectCountByEncryptionType(v *ObjectCountByEncryptionType) *BucketMetadata {
	s.ObjectCountByEncryptionType = v
	return s
}

// SetPublicAccess sets the PublicAccess field's value.
func (s *BucketMetadata) SetPublicAccess(v *BucketPublicAccess) *BucketMetadata {
	s.PublicAccess = v
	return s
}

// SetRegion sets the Region field's value.
func (s *BucketMetadata) SetRegion(v string) *BucketMetadata {
	s.Region = &v
	return s
}

// SetReplicationDetails sets the ReplicationDetails field's value.
func (s *BucketMetadata) SetReplicationDetails(v *ReplicationDetails) *BucketMetadata {
	s.ReplicationDetails = v
	return s
}

// SetSharedAccess sets the SharedAccess field's value.
func (s *BucketMetadata) SetSharedAccess(v string) *BucketMetadata {
	s.SharedAccess = &v
	return s
}

// SetSizeInBytes sets the SizeInBytes field's value.
func (s *BucketMetadata) SetSizeInBytes(v int64) *BucketMetadata {
	s.SizeInBytes = &v
	return s
}

// SetSizeInBytesCompressed sets the SizeInBytesCompressed field's value.
func (s *BucketMetadata) SetSizeInBytesCompressed(v int64) *BucketMetadata {
	s.SizeInBytesCompressed = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *BucketMetadata) SetTags(v []*KeyValuePair) *BucketMetadata {
	s.Tags = v
	return s
}

// SetUnclassifiableObjectCount sets the UnclassifiableObjectCount field's value.
func (s *BucketMetadata) SetUnclassifiableObjectCount(v *ObjectLevelStatistics) *BucketMetadata {
	s.UnclassifiableObjectCount = v
	return s
}

// SetUnclassifiableObjectSizeInBytes sets the UnclassifiableObjectSizeInBytes field's value.
func (s *BucketMetadata) SetUnclassifiableObjectSizeInBytes(v *ObjectLevelStatistics) *BucketMetadata {
	s.UnclassifiableObjectSizeInBytes = v
	return s
}

// SetVersioning sets the Versioning field's value.
func (s *BucketMetadata) SetVersioning(v bool) *BucketMetadata {
	s.Versioning = &v
	return s
}

// Provides information about the account-level and bucket-level permissions
// settings for an S3 bucket.
type BucketPermissionConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides information about account-level permissions settings that apply
	// to an S3 bucket.
	AccountLevelPermissions *AccountLevelPermissions `locationName:"accountLevelPermissions" type:"structure"`

	// Provides information about the bucket-level permissions settings for an S3
	// bucket.
	BucketLevelPermissions *BucketLevelPermissions `locationName:"bucketLevelPermissions" type:"structure"`
}

// String returns the string representation
func (s BucketPermissionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketPermissionConfiguration) GoString() string {
	return s.String()
}

// SetAccountLevelPermissions sets the AccountLevelPermissions field's value.
func (s *BucketPermissionConfiguration) SetAccountLevelPermissions(v *AccountLevelPermissions) *BucketPermissionConfiguration {
	s.AccountLevelPermissions = v
	return s
}

// SetBucketLevelPermissions sets the BucketLevelPermissions field's value.
func (s *BucketPermissionConfiguration) SetBucketLevelPermissions(v *BucketLevelPermissions) *BucketPermissionConfiguration {
	s.BucketLevelPermissions = v
	return s
}

// Provides information about the permissions settings of a bucket policy for
// an S3 bucket.
type BucketPolicy struct {
	_ struct{} `type:"structure"`

	AllowsPublicReadAccess *bool `locationName:"allowsPublicReadAccess" type:"boolean"`

	AllowsPublicWriteAccess *bool `locationName:"allowsPublicWriteAccess" type:"boolean"`
}

// String returns the string representation
func (s BucketPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketPolicy) GoString() string {
	return s.String()
}

// SetAllowsPublicReadAccess sets the AllowsPublicReadAccess field's value.
func (s *BucketPolicy) SetAllowsPublicReadAccess(v bool) *BucketPolicy {
	s.AllowsPublicReadAccess = &v
	return s
}

// SetAllowsPublicWriteAccess sets the AllowsPublicWriteAccess field's value.
func (s *BucketPolicy) SetAllowsPublicWriteAccess(v bool) *BucketPolicy {
	s.AllowsPublicWriteAccess = &v
	return s
}

// Provides information about the permissions settings that determine whether
// an S3 bucket is publicly accessible.
type BucketPublicAccess struct {
	_ struct{} `type:"structure"`

	EffectivePermission *string `locationName:"effectivePermission" type:"string" enum:"EffectivePermission"`

	// Provides information about the account-level and bucket-level permissions
	// settings for an S3 bucket.
	PermissionConfiguration *BucketPermissionConfiguration `locationName:"permissionConfiguration" type:"structure"`
}

// String returns the string representation
func (s BucketPublicAccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketPublicAccess) GoString() string {
	return s.String()
}

// SetEffectivePermission sets the EffectivePermission field's value.
func (s *BucketPublicAccess) SetEffectivePermission(v string) *BucketPublicAccess {
	s.EffectivePermission = &v
	return s
}

// SetPermissionConfiguration sets the PermissionConfiguration field's value.
func (s *BucketPublicAccess) SetPermissionConfiguration(v *BucketPermissionConfiguration) *BucketPublicAccess {
	s.PermissionConfiguration = v
	return s
}

// Specifies criteria for sorting the results of a query for information about
// S3 buckets.
type BucketSortCriteria struct {
	_ struct{} `type:"structure"`

	AttributeName *string `locationName:"attributeName" type:"string"`

	OrderBy *string `locationName:"orderBy" type:"string" enum:"OrderBy"`
}

// String returns the string representation
func (s BucketSortCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketSortCriteria) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *BucketSortCriteria) SetAttributeName(v string) *BucketSortCriteria {
	s.AttributeName = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *BucketSortCriteria) SetOrderBy(v string) *BucketSortCriteria {
	s.OrderBy = &v
	return s
}

// Provides information about a sensitive data finding, including the classification
// job that produced the finding.
type ClassificationDetails struct {
	_ struct{} `type:"structure"`

	DetailedResultsLocation *string `locationName:"detailedResultsLocation" type:"string"`

	JobArn *string `locationName:"jobArn" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	// Provides detailed information about a sensitive data finding, including the
	// types and number of occurrences of the sensitive data that was found.
	Result *ClassificationResult `locationName:"result" type:"structure"`
}

// String returns the string representation
func (s ClassificationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClassificationDetails) GoString() string {
	return s.String()
}

// SetDetailedResultsLocation sets the DetailedResultsLocation field's value.
func (s *ClassificationDetails) SetDetailedResultsLocation(v string) *ClassificationDetails {
	s.DetailedResultsLocation = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *ClassificationDetails) SetJobArn(v string) *ClassificationDetails {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ClassificationDetails) SetJobId(v string) *ClassificationDetails {
	s.JobId = &v
	return s
}

// SetResult sets the Result field's value.
func (s *ClassificationDetails) SetResult(v *ClassificationResult) *ClassificationDetails {
	s.Result = v
	return s
}

// Specifies where to store data classification results, and the encryption
// settings to use when storing results in that location. Currently, you can
// store classification results only in an S3 bucket.
type ClassificationExportConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies an S3 bucket to store data classification results in, and the encryption
	// settings to use when storing results in that bucket.
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure"`
}

// String returns the string representation
func (s ClassificationExportConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClassificationExportConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClassificationExportConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClassificationExportConfiguration"}
	if s.S3Destination != nil {
		if err := s.S3Destination.Validate(); err != nil {
			invalidParams.AddNested("S3Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Destination sets the S3Destination field's value.
func (s *ClassificationExportConfiguration) SetS3Destination(v *S3Destination) *ClassificationExportConfiguration {
	s.S3Destination = v
	return s
}

// Provides detailed information about a sensitive data finding, including the
// types and number of occurrences of the sensitive data that was found.
type ClassificationResult struct {
	_ struct{} `type:"structure"`

	// Provides information about the number of occurrences of the data that produced
	// a sensitive data finding, and the custom data identifiers that detected the
	// data for the finding.
	CustomDataIdentifiers *CustomDataIdentifiers `locationName:"customDataIdentifiers" type:"structure"`

	MimeType *string `locationName:"mimeType" type:"string"`

	// Provides information about the category and number of occurrences of sensitive
	// data that produced a finding.
	SensitiveData []*SensitiveDataItem `locationName:"sensitiveData" type:"list"`

	SizeClassified *int64 `locationName:"sizeClassified" type:"long"`

	// Provides information about the status of a sensitive data finding.
	Status *ClassificationResultStatus `locationName:"status" type:"structure"`
}

// String returns the string representation
func (s ClassificationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClassificationResult) GoString() string {
	return s.String()
}

// SetCustomDataIdentifiers sets the CustomDataIdentifiers field's value.
func (s *ClassificationResult) SetCustomDataIdentifiers(v *CustomDataIdentifiers) *ClassificationResult {
	s.CustomDataIdentifiers = v
	return s
}

// SetMimeType sets the MimeType field's value.
func (s *ClassificationResult) SetMimeType(v string) *ClassificationResult {
	s.MimeType = &v
	return s
}

// SetSensitiveData sets the SensitiveData field's value.
func (s *ClassificationResult) SetSensitiveData(v []*SensitiveDataItem) *ClassificationResult {
	s.SensitiveData = v
	return s
}

// SetSizeClassified sets the SizeClassified field's value.
func (s *ClassificationResult) SetSizeClassified(v int64) *ClassificationResult {
	s.SizeClassified = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ClassificationResult) SetStatus(v *ClassificationResultStatus) *ClassificationResult {
	s.Status = v
	return s
}

// Provides information about the status of a sensitive data finding.
type ClassificationResultStatus struct {
	_ struct{} `type:"structure"`

	Code *string `locationName:"code" type:"string"`

	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation
func (s ClassificationResultStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClassificationResultStatus) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ClassificationResultStatus) SetCode(v string) *ClassificationResultStatus {
	s.Code = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ClassificationResultStatus) SetReason(v string) *ClassificationResultStatus {
	s.Reason = &v
	return s
}

// Provides information about an error that occurred due to a versioning conflict
// for a specified resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the scope, schedule, and other settings for a classification job.
// You can't delete or change the settings for a classification job after you
// create it. This helps ensure that you have an immutable history of sensitive
// data findings and discovery results for data privacy and protection audits
// or investigations.
type CreateClassificationJobInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	CustomDataIdentifierIds []*string `locationName:"customDataIdentifierIds" type:"list"`

	Description *string `locationName:"description" type:"string"`

	InitialRun *bool `locationName:"initialRun" type:"boolean"`

	// The schedule for running a classification job. Valid values are:
	//
	// JobType is a required field
	JobType *string `locationName:"jobType" type:"string" required:"true" enum:"JobType"`

	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Specifies which S3 buckets contain the objects that a classification job
	// analyzes, and the scope of that analysis.
	//
	// S3JobDefinition is a required field
	S3JobDefinition *S3JobDefinition `locationName:"s3JobDefinition" type:"structure" required:"true"`

	SamplingPercentage *int64 `locationName:"samplingPercentage" type:"integer"`

	// Specifies the recurrence pattern for running a classification job.
	ScheduleFrequency *JobScheduleFrequency `locationName:"scheduleFrequency" type:"structure"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateClassificationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClassificationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClassificationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClassificationJobInput"}
	if s.JobType == nil {
		invalidParams.Add(request.NewErrParamRequired("JobType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.S3JobDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("S3JobDefinition"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateClassificationJobInput) SetClientToken(v string) *CreateClassificationJobInput {
	s.ClientToken = &v
	return s
}

// SetCustomDataIdentifierIds sets the CustomDataIdentifierIds field's value.
func (s *CreateClassificationJobInput) SetCustomDataIdentifierIds(v []*string) *CreateClassificationJobInput {
	s.CustomDataIdentifierIds = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateClassificationJobInput) SetDescription(v string) *CreateClassificationJobInput {
	s.Description = &v
	return s
}

// SetInitialRun sets the InitialRun field's value.
func (s *CreateClassificationJobInput) SetInitialRun(v bool) *CreateClassificationJobInput {
	s.InitialRun = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *CreateClassificationJobInput) SetJobType(v string) *CreateClassificationJobInput {
	s.JobType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateClassificationJobInput) SetName(v string) *CreateClassificationJobInput {
	s.Name = &v
	return s
}

// SetS3JobDefinition sets the S3JobDefinition field's value.
func (s *CreateClassificationJobInput) SetS3JobDefinition(v *S3JobDefinition) *CreateClassificationJobInput {
	s.S3JobDefinition = v
	return s
}

// SetSamplingPercentage sets the SamplingPercentage field's value.
func (s *CreateClassificationJobInput) SetSamplingPercentage(v int64) *CreateClassificationJobInput {
	s.SamplingPercentage = &v
	return s
}

// SetScheduleFrequency sets the ScheduleFrequency field's value.
func (s *CreateClassificationJobInput) SetScheduleFrequency(v *JobScheduleFrequency) *CreateClassificationJobInput {
	s.ScheduleFrequency = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClassificationJobInput) SetTags(v map[string]*string) *CreateClassificationJobInput {
	s.Tags = v
	return s
}

// Provides information about a classification job that was created in response
// to a request.
type CreateClassificationJobOutput struct {
	_ struct{} `type:"structure"`

	JobArn *string `locationName:"jobArn" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`
}

// String returns the string representation
func (s CreateClassificationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClassificationJobOutput) GoString() string {
	return s.String()
}

// SetJobArn sets the JobArn field's value.
func (s *CreateClassificationJobOutput) SetJobArn(v string) *CreateClassificationJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CreateClassificationJobOutput) SetJobId(v string) *CreateClassificationJobOutput {
	s.JobId = &v
	return s
}

// Specifies the criteria and other settings for a new custom data identifier.
// You can't change a custom data identifier after you create it. This helps
// ensure that you have an immutable history of sensitive data findings and
// discovery results for data privacy and protection audits or investigations.
type CreateCustomDataIdentifierInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	Description *string `locationName:"description" type:"string"`

	IgnoreWords []*string `locationName:"ignoreWords" type:"list"`

	Keywords []*string `locationName:"keywords" type:"list"`

	MaximumMatchDistance *int64 `locationName:"maximumMatchDistance" type:"integer"`

	Name *string `locationName:"name" type:"string"`

	Regex *string `locationName:"regex" type:"string"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateCustomDataIdentifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomDataIdentifierInput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateCustomDataIdentifierInput) SetClientToken(v string) *CreateCustomDataIdentifierInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCustomDataIdentifierInput) SetDescription(v string) *CreateCustomDataIdentifierInput {
	s.Description = &v
	return s
}

// SetIgnoreWords sets the IgnoreWords field's value.
func (s *CreateCustomDataIdentifierInput) SetIgnoreWords(v []*string) *CreateCustomDataIdentifierInput {
	s.IgnoreWords = v
	return s
}

// SetKeywords sets the Keywords field's value.
func (s *CreateCustomDataIdentifierInput) SetKeywords(v []*string) *CreateCustomDataIdentifierInput {
	s.Keywords = v
	return s
}

// SetMaximumMatchDistance sets the MaximumMatchDistance field's value.
func (s *CreateCustomDataIdentifierInput) SetMaximumMatchDistance(v int64) *CreateCustomDataIdentifierInput {
	s.MaximumMatchDistance = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCustomDataIdentifierInput) SetName(v string) *CreateCustomDataIdentifierInput {
	s.Name = &v
	return s
}

// SetRegex sets the Regex field's value.
func (s *CreateCustomDataIdentifierInput) SetRegex(v string) *CreateCustomDataIdentifierInput {
	s.Regex = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCustomDataIdentifierInput) SetTags(v map[string]*string) *CreateCustomDataIdentifierInput {
	s.Tags = v
	return s
}

// Provides information about a custom data identifier that was created in response
// to a request.
type CreateCustomDataIdentifierOutput struct {
	_ struct{} `type:"structure"`

	CustomDataIdentifierId *string `locationName:"customDataIdentifierId" type:"string"`
}

// String returns the string representation
func (s CreateCustomDataIdentifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomDataIdentifierOutput) GoString() string {
	return s.String()
}

// SetCustomDataIdentifierId sets the CustomDataIdentifierId field's value.
func (s *CreateCustomDataIdentifierOutput) SetCustomDataIdentifierId(v string) *CreateCustomDataIdentifierOutput {
	s.CustomDataIdentifierId = &v
	return s
}

// Specifies the criteria and other settings for a new findings filter.
type CreateFindingsFilterInput struct {
	_ struct{} `type:"structure"`

	// The action to perform on findings that meet the filter criteria. To suppress
	// (automatically archive) findings that meet the criteria, set this value to
	// ARCHIVE. Valid values are:
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true" enum:"FindingsFilterAction"`

	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	Description *string `locationName:"description" type:"string"`

	// Specifies, as a map, one or more property-based conditions that filter the
	// results of a query for findings.
	//
	// FindingCriteria is a required field
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure" required:"true"`

	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	Position *int64 `locationName:"position" type:"integer"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateFindingsFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFindingsFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFindingsFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFindingsFilterInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.FindingCriteria == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingCriteria"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *CreateFindingsFilterInput) SetAction(v string) *CreateFindingsFilterInput {
	s.Action = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateFindingsFilterInput) SetClientToken(v string) *CreateFindingsFilterInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFindingsFilterInput) SetDescription(v string) *CreateFindingsFilterInput {
	s.Description = &v
	return s
}

// SetFindingCriteria sets the FindingCriteria field's value.
func (s *CreateFindingsFilterInput) SetFindingCriteria(v *FindingCriteria) *CreateFindingsFilterInput {
	s.FindingCriteria = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFindingsFilterInput) SetName(v string) *CreateFindingsFilterInput {
	s.Name = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *CreateFindingsFilterInput) SetPosition(v int64) *CreateFindingsFilterInput {
	s.Position = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFindingsFilterInput) SetTags(v map[string]*string) *CreateFindingsFilterInput {
	s.Tags = v
	return s
}

// Provides information about a findings filter that was created in response
// to a request.
type CreateFindingsFilterOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s CreateFindingsFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFindingsFilterOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateFindingsFilterOutput) SetArn(v string) *CreateFindingsFilterOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateFindingsFilterOutput) SetId(v string) *CreateFindingsFilterOutput {
	s.Id = &v
	return s
}

// Specifies the settings for an Amazon Macie membership invitation.
type CreateInvitationsInput struct {
	_ struct{} `type:"structure"`

	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" type:"list" required:"true"`

	DisableEmailNotification *bool `locationName:"disableEmailNotification" type:"boolean"`

	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s CreateInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInvitationsInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *CreateInvitationsInput) SetAccountIds(v []*string) *CreateInvitationsInput {
	s.AccountIds = v
	return s
}

// SetDisableEmailNotification sets the DisableEmailNotification field's value.
func (s *CreateInvitationsInput) SetDisableEmailNotification(v bool) *CreateInvitationsInput {
	s.DisableEmailNotification = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *CreateInvitationsInput) SetMessage(v string) *CreateInvitationsInput {
	s.Message = &v
	return s
}

// Provides information about an unprocessed request to send an Amazon Macie
// membership invitation to a specific account.
type CreateInvitationsOutput struct {
	_ struct{} `type:"structure"`

	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list"`
}

// String returns the string representation
func (s CreateInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInvitationsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *CreateInvitationsOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *CreateInvitationsOutput {
	s.UnprocessedAccounts = v
	return s
}

// Specifies an account to associate with an Amazon Macie master account.
type CreateMemberInput struct {
	_ struct{} `type:"structure"`

	// Specifies details for an account to associate with an Amazon Macie master
	// account.
	//
	// Account is a required field
	Account *AccountDetail `locationName:"account" type:"structure" required:"true"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMemberInput"}
	if s.Account == nil {
		invalidParams.Add(request.NewErrParamRequired("Account"))
	}
	if s.Account != nil {
		if err := s.Account.Validate(); err != nil {
			invalidParams.AddNested("Account", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccount sets the Account field's value.
func (s *CreateMemberInput) SetAccount(v *AccountDetail) *CreateMemberInput {
	s.Account = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMemberInput) SetTags(v map[string]*string) *CreateMemberInput {
	s.Tags = v
	return s
}

// Provides information about a request to associate an account with an Amazon
// Macie master account.
type CreateMemberOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`
}

// String returns the string representation
func (s CreateMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMemberOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateMemberOutput) SetArn(v string) *CreateMemberOutput {
	s.Arn = &v
	return s
}

// Specifies the types of findings to include in a set of sample findings that
// Amazon Macie creates.
type CreateSampleFindingsInput struct {
	_ struct{} `type:"structure"`

	FindingTypes []*string `locationName:"findingTypes" type:"list"`
}

// String returns the string representation
func (s CreateSampleFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSampleFindingsInput) GoString() string {
	return s.String()
}

// SetFindingTypes sets the FindingTypes field's value.
func (s *CreateSampleFindingsInput) SetFindingTypes(v []*string) *CreateSampleFindingsInput {
	s.FindingTypes = v
	return s
}

type CreateSampleFindingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateSampleFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSampleFindingsOutput) GoString() string {
	return s.String()
}

// Specifies the operator to use in a property-based condition that filters
// the results of a query for findings.
type CriterionAdditionalProperties struct {
	_ struct{} `type:"structure"`

	Eq []*string `locationName:"eq" type:"list"`

	Gt *int64 `locationName:"gt" type:"long"`

	Gte *int64 `locationName:"gte" type:"long"`

	Lt *int64 `locationName:"lt" type:"long"`

	Lte *int64 `locationName:"lte" type:"long"`

	Neq []*string `locationName:"neq" type:"list"`
}

// String returns the string representation
func (s CriterionAdditionalProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CriterionAdditionalProperties) GoString() string {
	return s.String()
}

// SetEq sets the Eq field's value.
func (s *CriterionAdditionalProperties) SetEq(v []*string) *CriterionAdditionalProperties {
	s.Eq = v
	return s
}

// SetGt sets the Gt field's value.
func (s *CriterionAdditionalProperties) SetGt(v int64) *CriterionAdditionalProperties {
	s.Gt = &v
	return s
}

// SetGte sets the Gte field's value.
func (s *CriterionAdditionalProperties) SetGte(v int64) *CriterionAdditionalProperties {
	s.Gte = &v
	return s
}

// SetLt sets the Lt field's value.
func (s *CriterionAdditionalProperties) SetLt(v int64) *CriterionAdditionalProperties {
	s.Lt = &v
	return s
}

// SetLte sets the Lte field's value.
func (s *CriterionAdditionalProperties) SetLte(v int64) *CriterionAdditionalProperties {
	s.Lte = &v
	return s
}

// SetNeq sets the Neq field's value.
func (s *CriterionAdditionalProperties) SetNeq(v []*string) *CriterionAdditionalProperties {
	s.Neq = v
	return s
}

// Provides information about a custom data identifier.
type CustomDataIdentifierSummary struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	Description *string `locationName:"description" type:"string"`

	Id *string `locationName:"id" type:"string"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s CustomDataIdentifierSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomDataIdentifierSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CustomDataIdentifierSummary) SetArn(v string) *CustomDataIdentifierSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CustomDataIdentifierSummary) SetCreatedAt(v time.Time) *CustomDataIdentifierSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CustomDataIdentifierSummary) SetDescription(v string) *CustomDataIdentifierSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CustomDataIdentifierSummary) SetId(v string) *CustomDataIdentifierSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CustomDataIdentifierSummary) SetName(v string) *CustomDataIdentifierSummary {
	s.Name = &v
	return s
}

// Provides information about the number of occurrences of the data that produced
// a sensitive data finding, and the custom data identifiers that detected the
// data for the finding.
type CustomDataIdentifiers struct {
	_ struct{} `type:"structure"`

	// Provides information about custom data identifiers that produced a sensitive
	// data finding, and the number of occurrences of the data that each identifier
	// detected.
	Detections []*CustomDetection `locationName:"detections" type:"list"`

	TotalCount *int64 `locationName:"totalCount" type:"long"`
}

// String returns the string representation
func (s CustomDataIdentifiers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomDataIdentifiers) GoString() string {
	return s.String()
}

// SetDetections sets the Detections field's value.
func (s *CustomDataIdentifiers) SetDetections(v []*CustomDetection) *CustomDataIdentifiers {
	s.Detections = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *CustomDataIdentifiers) SetTotalCount(v int64) *CustomDataIdentifiers {
	s.TotalCount = &v
	return s
}

// Provides information about a custom data identifier that produced a sensitive
// data finding, and the number of occurrences of the data that it detected
// for the finding.
type CustomDetection struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Count *int64 `locationName:"count" type:"long"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s CustomDetection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomDetection) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CustomDetection) SetArn(v string) *CustomDetection {
	s.Arn = &v
	return s
}

// SetCount sets the Count field's value.
func (s *CustomDetection) SetCount(v int64) *CustomDetection {
	s.Count = &v
	return s
}

// SetName sets the Name field's value.
func (s *CustomDetection) SetName(v string) *CustomDetection {
	s.Name = &v
	return s
}

// Specifies that a classification job runs once a day, every day. This is an
// empty object.
type DailySchedule struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DailySchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DailySchedule) GoString() string {
	return s.String()
}

// Specifies one or more accounts that sent Amazon Macie membership invitations
// to decline.
type DeclineInvitationsInput struct {
	_ struct{} `type:"structure"`

	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DeclineInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeclineInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeclineInvitationsInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeclineInvitationsInput) SetAccountIds(v []*string) *DeclineInvitationsInput {
	s.AccountIds = v
	return s
}

// Provides information about unprocessed requests to decline Amazon Macie membership
// invitations that were received from specific accounts.
type DeclineInvitationsOutput struct {
	_ struct{} `type:"structure"`

	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list"`
}

// String returns the string representation
func (s DeclineInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineInvitationsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeclineInvitationsOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *DeclineInvitationsOutput {
	s.UnprocessedAccounts = v
	return s
}

// Provides information about sensitive data that was detected by managed data
// identifiers and produced a sensitive data finding.
type DefaultDetection struct {
	_ struct{} `type:"structure"`

	Count *int64 `locationName:"count" type:"long"`

	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s DefaultDetection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultDetection) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *DefaultDetection) SetCount(v int64) *DefaultDetection {
	s.Count = &v
	return s
}

// SetType sets the Type field's value.
func (s *DefaultDetection) SetType(v string) *DefaultDetection {
	s.Type = &v
	return s
}

type DeleteCustomDataIdentifierInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCustomDataIdentifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomDataIdentifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomDataIdentifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomDataIdentifierInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteCustomDataIdentifierInput) SetId(v string) *DeleteCustomDataIdentifierInput {
	s.Id = &v
	return s
}

type DeleteCustomDataIdentifierOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCustomDataIdentifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomDataIdentifierOutput) GoString() string {
	return s.String()
}

type DeleteFindingsFilterInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFindingsFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFindingsFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFindingsFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFindingsFilterInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteFindingsFilterInput) SetId(v string) *DeleteFindingsFilterInput {
	s.Id = &v
	return s
}

type DeleteFindingsFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFindingsFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFindingsFilterOutput) GoString() string {
	return s.String()
}

// Specifies one or more accounts that sent Amazon Macie membership invitations
// to delete.
type DeleteInvitationsInput struct {
	_ struct{} `type:"structure"`

	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInvitationsInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeleteInvitationsInput) SetAccountIds(v []*string) *DeleteInvitationsInput {
	s.AccountIds = v
	return s
}

// Provides information about unprocessed requests to delete Amazon Macie membership
// invitations that were received from specific accounts.
type DeleteInvitationsOutput struct {
	_ struct{} `type:"structure"`

	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list"`
}

// String returns the string representation
func (s DeleteInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInvitationsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeleteInvitationsOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *DeleteInvitationsOutput {
	s.UnprocessedAccounts = v
	return s
}

type DeleteMemberInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMemberInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteMemberInput) SetId(v string) *DeleteMemberInput {
	s.Id = &v
	return s
}

type DeleteMemberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMemberOutput) GoString() string {
	return s.String()
}

// Specifies criteria for filtering, sorting, and paginating the results of
// a query for information about S3 buckets.
type DescribeBucketsInput struct {
	_ struct{} `type:"structure"`

	// Specifies, as a map, one or more attribute-based conditions that filter the
	// results of a query for information about S3 buckets.
	Criteria map[string]*BucketCriteriaAdditionalProperties `locationName:"criteria" type:"map"`

	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies criteria for sorting the results of a query for information about
	// S3 buckets.
	SortCriteria *BucketSortCriteria `locationName:"sortCriteria" type:"structure"`
}

// String returns the string representation
func (s DescribeBucketsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBucketsInput) GoString() string {
	return s.String()
}

// SetCriteria sets the Criteria field's value.
func (s *DescribeBucketsInput) SetCriteria(v map[string]*BucketCriteriaAdditionalProperties) *DescribeBucketsInput {
	s.Criteria = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeBucketsInput) SetMaxResults(v int64) *DescribeBucketsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBucketsInput) SetNextToken(v string) *DescribeBucketsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *DescribeBucketsInput) SetSortCriteria(v *BucketSortCriteria) *DescribeBucketsInput {
	s.SortCriteria = v
	return s
}

// Provides the results of a query that retrieved statistical data and other
// information about one or more S3 buckets that Amazon Macie monitors and analyzes.
type DescribeBucketsOutput struct {
	_ struct{} `type:"structure"`

	Buckets []*BucketMetadata `locationName:"buckets" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeBucketsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBucketsOutput) GoString() string {
	return s.String()
}

// SetBuckets sets the Buckets field's value.
func (s *DescribeBucketsOutput) SetBuckets(v []*BucketMetadata) *DescribeBucketsOutput {
	s.Buckets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBucketsOutput) SetNextToken(v string) *DescribeBucketsOutput {
	s.NextToken = &v
	return s
}

type DescribeClassificationJobInput struct {
	_ struct{} `type:"structure"`

	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeClassificationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClassificationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClassificationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClassificationJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeClassificationJobInput) SetJobId(v string) *DescribeClassificationJobInput {
	s.JobId = &v
	return s
}

// Provides information about a classification job, including the current configuration
// settings and status of the job.
type DescribeClassificationJobOutput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	CustomDataIdentifierIds []*string `locationName:"customDataIdentifierIds" type:"list"`

	Description *string `locationName:"description" type:"string"`

	InitialRun *bool `locationName:"initialRun" type:"boolean"`

	JobArn *string `locationName:"jobArn" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	// The current status of a classification job. Possible values are:
	JobStatus *string `locationName:"jobStatus" type:"string" enum:"JobStatus"`

	// The schedule for running a classification job. Valid values are:
	JobType *string `locationName:"jobType" type:"string" enum:"JobType"`

	LastRunTime *time.Time `locationName:"lastRunTime" type:"timestamp" timestampFormat:"iso8601"`

	Name *string `locationName:"name" type:"string"`

	// Specifies which S3 buckets contain the objects that a classification job
	// analyzes, and the scope of that analysis.
	S3JobDefinition *S3JobDefinition `locationName:"s3JobDefinition" type:"structure"`

	SamplingPercentage *int64 `locationName:"samplingPercentage" type:"integer"`

	// Specifies the recurrence pattern for running a classification job.
	ScheduleFrequency *JobScheduleFrequency `locationName:"scheduleFrequency" type:"structure"`

	// Provides processing statistics for a classification job.
	Statistics *Statistics `locationName:"statistics" type:"structure"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeClassificationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClassificationJobOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *DescribeClassificationJobOutput) SetClientToken(v string) *DescribeClassificationJobOutput {
	s.ClientToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeClassificationJobOutput) SetCreatedAt(v time.Time) *DescribeClassificationJobOutput {
	s.CreatedAt = &v
	return s
}

// SetCustomDataIdentifierIds sets the CustomDataIdentifierIds field's value.
func (s *DescribeClassificationJobOutput) SetCustomDataIdentifierIds(v []*string) *DescribeClassificationJobOutput {
	s.CustomDataIdentifierIds = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeClassificationJobOutput) SetDescription(v string) *DescribeClassificationJobOutput {
	s.Description = &v
	return s
}

// SetInitialRun sets the InitialRun field's value.
func (s *DescribeClassificationJobOutput) SetInitialRun(v bool) *DescribeClassificationJobOutput {
	s.InitialRun = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *DescribeClassificationJobOutput) SetJobArn(v string) *DescribeClassificationJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeClassificationJobOutput) SetJobId(v string) *DescribeClassificationJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *DescribeClassificationJobOutput) SetJobStatus(v string) *DescribeClassificationJobOutput {
	s.JobStatus = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *DescribeClassificationJobOutput) SetJobType(v string) *DescribeClassificationJobOutput {
	s.JobType = &v
	return s
}

// SetLastRunTime sets the LastRunTime field's value.
func (s *DescribeClassificationJobOutput) SetLastRunTime(v time.Time) *DescribeClassificationJobOutput {
	s.LastRunTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeClassificationJobOutput) SetName(v string) *DescribeClassificationJobOutput {
	s.Name = &v
	return s
}

// SetS3JobDefinition sets the S3JobDefinition field's value.
func (s *DescribeClassificationJobOutput) SetS3JobDefinition(v *S3JobDefinition) *DescribeClassificationJobOutput {
	s.S3JobDefinition = v
	return s
}

// SetSamplingPercentage sets the SamplingPercentage field's value.
func (s *DescribeClassificationJobOutput) SetSamplingPercentage(v int64) *DescribeClassificationJobOutput {
	s.SamplingPercentage = &v
	return s
}

// SetScheduleFrequency sets the ScheduleFrequency field's value.
func (s *DescribeClassificationJobOutput) SetScheduleFrequency(v *JobScheduleFrequency) *DescribeClassificationJobOutput {
	s.ScheduleFrequency = v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *DescribeClassificationJobOutput) SetStatistics(v *Statistics) *DescribeClassificationJobOutput {
	s.Statistics = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeClassificationJobOutput) SetTags(v map[string]*string) *DescribeClassificationJobOutput {
	s.Tags = v
	return s
}

type DescribeOrganizationConfigurationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeOrganizationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationConfigurationInput) GoString() string {
	return s.String()
}

// Provides information about the Amazon Macie configuration settings for an
// AWS organization.
type DescribeOrganizationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	AutoEnable *bool `locationName:"autoEnable" type:"boolean"`

	MaxAccountLimitReached *bool `locationName:"maxAccountLimitReached" type:"boolean"`
}

// String returns the string representation
func (s DescribeOrganizationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationConfigurationOutput) GoString() string {
	return s.String()
}

// SetAutoEnable sets the AutoEnable field's value.
func (s *DescribeOrganizationConfigurationOutput) SetAutoEnable(v bool) *DescribeOrganizationConfigurationOutput {
	s.AutoEnable = &v
	return s
}

// SetMaxAccountLimitReached sets the MaxAccountLimitReached field's value.
func (s *DescribeOrganizationConfigurationOutput) SetMaxAccountLimitReached(v bool) *DescribeOrganizationConfigurationOutput {
	s.MaxAccountLimitReached = &v
	return s
}

type DisableMacieInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableMacieInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableMacieInput) GoString() string {
	return s.String()
}

type DisableMacieOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableMacieOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableMacieOutput) GoString() string {
	return s.String()
}

type DisableOrganizationAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// AdminAccountId is a required field
	AdminAccountId *string `location:"querystring" locationName:"adminAccountId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableOrganizationAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableOrganizationAdminAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableOrganizationAdminAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableOrganizationAdminAccountInput"}
	if s.AdminAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminAccountId sets the AdminAccountId field's value.
func (s *DisableOrganizationAdminAccountInput) SetAdminAccountId(v string) *DisableOrganizationAdminAccountInput {
	s.AdminAccountId = &v
	return s
}

type DisableOrganizationAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableOrganizationAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableOrganizationAdminAccountOutput) GoString() string {
	return s.String()
}

type DisassociateFromMasterAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateFromMasterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFromMasterAccountInput) GoString() string {
	return s.String()
}

type DisassociateFromMasterAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateFromMasterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFromMasterAccountOutput) GoString() string {
	return s.String()
}

type DisassociateMemberInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateMemberInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DisassociateMemberInput) SetId(v string) *DisassociateMemberInput {
	s.Id = &v
	return s
}

type DisassociateMemberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMemberOutput) GoString() string {
	return s.String()
}

// Provides information about the domain name of the device that an entity used
// to perform an action on an affected resource.
type DomainDetails struct {
	_ struct{} `type:"structure"`

	DomainName *string `locationName:"domainName" type:"string"`
}

// String returns the string representation
func (s DomainDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainDetails) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *DomainDetails) SetDomainName(v string) *DomainDetails {
	s.DomainName = &v
	return s
}

// Enables Amazon Macie and specifies the configuration settings for an Amazon
// Macie account.
type EnableMacieInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The frequency with which Amazon Macie publishes updates to policy findings
	// for an account. This includes publishing updates to AWS Security Hub and
	// Amazon EventBridge (formerly called Amazon CloudWatch Events). Valid values
	// are:
	FindingPublishingFrequency *string `locationName:"findingPublishingFrequency" type:"string" enum:"FindingPublishingFrequency"`

	// The status of an Amazon Macie account. Valid values are:
	Status *string `locationName:"status" type:"string" enum:"MacieStatus"`
}

// String returns the string representation
func (s EnableMacieInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableMacieInput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *EnableMacieInput) SetClientToken(v string) *EnableMacieInput {
	s.ClientToken = &v
	return s
}

// SetFindingPublishingFrequency sets the FindingPublishingFrequency field's value.
func (s *EnableMacieInput) SetFindingPublishingFrequency(v string) *EnableMacieInput {
	s.FindingPublishingFrequency = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EnableMacieInput) SetStatus(v string) *EnableMacieInput {
	s.Status = &v
	return s
}

type EnableMacieOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableMacieOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableMacieOutput) GoString() string {
	return s.String()
}

// Specifies an account to designate as a delegated administrator of Amazon
// Macie for an AWS organization. To submit this request, you must be a user
// of the master account for the AWS organization.
type EnableOrganizationAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// AdminAccountId is a required field
	AdminAccountId *string `locationName:"adminAccountId" type:"string" required:"true"`

	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s EnableOrganizationAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableOrganizationAdminAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableOrganizationAdminAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableOrganizationAdminAccountInput"}
	if s.AdminAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminAccountId sets the AdminAccountId field's value.
func (s *EnableOrganizationAdminAccountInput) SetAdminAccountId(v string) *EnableOrganizationAdminAccountInput {
	s.AdminAccountId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *EnableOrganizationAdminAccountInput) SetClientToken(v string) *EnableOrganizationAdminAccountInput {
	s.ClientToken = &v
	return s
}

type EnableOrganizationAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableOrganizationAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableOrganizationAdminAccountOutput) GoString() string {
	return s.String()
}

// Provides information about an identity that performed an action on an affected
// resource by using temporary security credentials. The credentials were obtained
// using the GetFederationToken operation of the AWS Security Token Service
// (AWS STS) API.
type FederatedUser struct {
	_ struct{} `type:"structure"`

	AccessKeyId *string `locationName:"accessKeyId" type:"string"`

	AccountId *string `locationName:"accountId" type:"string"`

	Arn *string `locationName:"arn" type:"string"`

	PrincipalId *string `locationName:"principalId" type:"string"`

	// Provides information about a session that was created for an entity that
	// performed an action by using temporary security credentials.
	SessionContext *SessionContext `locationName:"sessionContext" type:"structure"`
}

// String returns the string representation
func (s FederatedUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FederatedUser) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *FederatedUser) SetAccessKeyId(v string) *FederatedUser {
	s.AccessKeyId = &v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *FederatedUser) SetAccountId(v string) *FederatedUser {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *FederatedUser) SetArn(v string) *FederatedUser {
	s.Arn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *FederatedUser) SetPrincipalId(v string) *FederatedUser {
	s.PrincipalId = &v
	return s
}

// SetSessionContext sets the SessionContext field's value.
func (s *FederatedUser) SetSessionContext(v *SessionContext) *FederatedUser {
	s.SessionContext = v
	return s
}

// Provides information about a finding.
type Finding struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	Archived *bool `locationName:"archived" type:"boolean"`

	// The category of the finding. Valid values are:
	Category *string `locationName:"category" type:"string" enum:"FindingCategory"`

	// Provides information about a sensitive data finding, including the classification
	// job that produced the finding.
	ClassificationDetails *ClassificationDetails `locationName:"classificationDetails" type:"structure"`

	Count *int64 `locationName:"count" type:"long"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	Description *string `locationName:"description" type:"string"`

	Id *string `locationName:"id" type:"string"`

	Partition *string `locationName:"partition" type:"string"`

	// Provides the details of a policy finding.
	PolicyDetails *PolicyDetails `locationName:"policyDetails" type:"structure"`

	Region *string `locationName:"region" type:"string"`

	// Provides information about the resources that a finding applies to.
	ResourcesAffected *ResourcesAffected `locationName:"resourcesAffected" type:"structure"`

	Sample *bool `locationName:"sample" type:"boolean"`

	SchemaVersion *string `locationName:"schemaVersion" type:"string"`

	// Provides the numeric score and textual representation of a severity value.
	Severity *Severity `locationName:"severity" type:"structure"`

	Title *string `locationName:"title" type:"string"`

	// The type of finding. Valid values are:
	Type *string `locationName:"type" type:"string" enum:"FindingType"`

	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Finding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Finding) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Finding) SetAccountId(v string) *Finding {
	s.AccountId = &v
	return s
}

// SetArchived sets the Archived field's value.
func (s *Finding) SetArchived(v bool) *Finding {
	s.Archived = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *Finding) SetCategory(v string) *Finding {
	s.Category = &v
	return s
}

// SetClassificationDetails sets the ClassificationDetails field's value.
func (s *Finding) SetClassificationDetails(v *ClassificationDetails) *Finding {
	s.ClassificationDetails = v
	return s
}

// SetCount sets the Count field's value.
func (s *Finding) SetCount(v int64) *Finding {
	s.Count = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Finding) SetCreatedAt(v time.Time) *Finding {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Finding) SetDescription(v string) *Finding {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Finding) SetId(v string) *Finding {
	s.Id = &v
	return s
}

// SetPartition sets the Partition field's value.
func (s *Finding) SetPartition(v string) *Finding {
	s.Partition = &v
	return s
}

// SetPolicyDetails sets the PolicyDetails field's value.
func (s *Finding) SetPolicyDetails(v *PolicyDetails) *Finding {
	s.PolicyDetails = v
	return s
}

// SetRegion sets the Region field's value.
func (s *Finding) SetRegion(v string) *Finding {
	s.Region = &v
	return s
}

// SetResourcesAffected sets the ResourcesAffected field's value.
func (s *Finding) SetResourcesAffected(v *ResourcesAffected) *Finding {
	s.ResourcesAffected = v
	return s
}

// SetSample sets the Sample field's value.
func (s *Finding) SetSample(v bool) *Finding {
	s.Sample = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *Finding) SetSchemaVersion(v string) *Finding {
	s.SchemaVersion = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *Finding) SetSeverity(v *Severity) *Finding {
	s.Severity = v
	return s
}

// SetTitle sets the Title field's value.
func (s *Finding) SetTitle(v string) *Finding {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *Finding) SetType(v string) *Finding {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Finding) SetUpdatedAt(v time.Time) *Finding {
	s.UpdatedAt = &v
	return s
}

// Provides information about an action that occurred for a resource and produced
// a policy finding.
type FindingAction struct {
	_ struct{} `type:"structure"`

	// The type of action that occurred for the resource and produced the policy
	// finding:
	ActionType *string `locationName:"actionType" type:"string" enum:"FindingActionType"`

	// Provides information about an API operation that an entity invoked for an
	// affected resource.
	ApiCallDetails *ApiCallDetails `locationName:"apiCallDetails" type:"structure"`
}

// String returns the string representation
func (s FindingAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FindingAction) GoString() string {
	return s.String()
}

// SetActionType sets the ActionType field's value.
func (s *FindingAction) SetActionType(v string) *FindingAction {
	s.ActionType = &v
	return s
}

// SetApiCallDetails sets the ApiCallDetails field's value.
func (s *FindingAction) SetApiCallDetails(v *ApiCallDetails) *FindingAction {
	s.ApiCallDetails = v
	return s
}

// Provides information about an entity that performed an action that produced
// a policy finding for a resource.
type FindingActor struct {
	_ struct{} `type:"structure"`

	// Provides information about the domain name of the device that an entity used
	// to perform an action on an affected resource.
	DomainDetails *DomainDetails `locationName:"domainDetails" type:"structure"`

	// Provides information about the IP address of the device that an entity used
	// to perform an action on an affected resource.
	IpAddressDetails *IpAddressDetails `locationName:"ipAddressDetails" type:"structure"`

	// Provides information about the type and other characteristics of an entity
	// that performed an action on an affected resource.
	UserIdentity *UserIdentity `locationName:"userIdentity" type:"structure"`
}

// String returns the string representation
func (s FindingActor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FindingActor) GoString() string {
	return s.String()
}

// SetDomainDetails sets the DomainDetails field's value.
func (s *FindingActor) SetDomainDetails(v *DomainDetails) *FindingActor {
	s.DomainDetails = v
	return s
}

// SetIpAddressDetails sets the IpAddressDetails field's value.
func (s *FindingActor) SetIpAddressDetails(v *IpAddressDetails) *FindingActor {
	s.IpAddressDetails = v
	return s
}

// SetUserIdentity sets the UserIdentity field's value.
func (s *FindingActor) SetUserIdentity(v *UserIdentity) *FindingActor {
	s.UserIdentity = v
	return s
}

// Specifies, as a map, one or more property-based conditions that filter the
// results of a query for findings.
type FindingCriteria struct {
	_ struct{} `type:"structure"`

	// Specifies a condition that defines a property, operator, and value to use
	// to filter the results of a query for findings.
	Criterion map[string]*CriterionAdditionalProperties `locationName:"criterion" type:"map"`
}

// String returns the string representation
func (s FindingCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FindingCriteria) GoString() string {
	return s.String()
}

// SetCriterion sets the Criterion field's value.
func (s *FindingCriteria) SetCriterion(v map[string]*CriterionAdditionalProperties) *FindingCriteria {
	s.Criterion = v
	return s
}

// Specifies criteria for sorting the results of a query that retrieves aggregated
// statistical data about findings.
type FindingStatisticsSortCriteria struct {
	_ struct{} `type:"structure"`

	// The grouping to sort the results by. Valid values are:
	AttributeName *string `locationName:"attributeName" type:"string" enum:"FindingStatisticsSortAttributeName"`

	OrderBy *string `locationName:"orderBy" type:"string" enum:"OrderBy"`
}

// String returns the string representation
func (s FindingStatisticsSortCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FindingStatisticsSortCriteria) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *FindingStatisticsSortCriteria) SetAttributeName(v string) *FindingStatisticsSortCriteria {
	s.AttributeName = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *FindingStatisticsSortCriteria) SetOrderBy(v string) *FindingStatisticsSortCriteria {
	s.OrderBy = &v
	return s
}

// Provides information about a findings filter.
type FindingsFilterListItem struct {
	_ struct{} `type:"structure"`

	// The action to perform on findings that meet the filter criteria. To suppress
	// (automatically archive) findings that meet the criteria, set this value to
	// ARCHIVE. Valid values are:
	Action *string `locationName:"action" type:"string" enum:"FindingsFilterAction"`

	Arn *string `locationName:"arn" type:"string"`

	Id *string `locationName:"id" type:"string"`

	Name *string `locationName:"name" type:"string"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s FindingsFilterListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FindingsFilterListItem) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *FindingsFilterListItem) SetAction(v string) *FindingsFilterListItem {
	s.Action = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *FindingsFilterListItem) SetArn(v string) *FindingsFilterListItem {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *FindingsFilterListItem) SetId(v string) *FindingsFilterListItem {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *FindingsFilterListItem) SetName(v string) *FindingsFilterListItem {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *FindingsFilterListItem) SetTags(v map[string]*string) *FindingsFilterListItem {
	s.Tags = v
	return s
}

// Specifies the account that owns the S3 buckets to retrieve aggregated statistical
// data for.
type GetBucketStatisticsInput struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`
}

// String returns the string representation
func (s GetBucketStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketStatisticsInput) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *GetBucketStatisticsInput) SetAccountId(v string) *GetBucketStatisticsInput {
	s.AccountId = &v
	return s
}

// Provides the results of a query that retrieved aggregated statistical data
// for the S3 buckets that are owned by an account.
type GetBucketStatisticsOutput struct {
	_ struct{} `type:"structure"`

	BucketCount *int64 `locationName:"bucketCount" type:"long"`

	// Provides information about the number of S3 buckets that are publicly accessible
	// based on a combination of permissions settings for each bucket.
	BucketCountByEffectivePermission *BucketCountByEffectivePermission `locationName:"bucketCountByEffectivePermission" type:"structure"`

	// Provides information about the number of S3 buckets that use certain types
	// of server-side encryption or don't encrypt objects by default.
	BucketCountByEncryptionType *BucketCountByEncryptionType `locationName:"bucketCountByEncryptionType" type:"structure"`

	// Provides information about the number of S3 buckets that are shared with
	// other AWS accounts.
	BucketCountBySharedAccessType *BucketCountBySharedAccessType `locationName:"bucketCountBySharedAccessType" type:"structure"`

	ClassifiableObjectCount *int64 `locationName:"classifiableObjectCount" type:"long"`

	ClassifiableSizeInBytes *int64 `locationName:"classifiableSizeInBytes" type:"long"`

	LastUpdated *time.Time `locationName:"lastUpdated" type:"timestamp" timestampFormat:"iso8601"`

	ObjectCount *int64 `locationName:"objectCount" type:"long"`

	SizeInBytes *int64 `locationName:"sizeInBytes" type:"long"`

	SizeInBytesCompressed *int64 `locationName:"sizeInBytesCompressed" type:"long"`

	// Provides information about the total storage size (in bytes) or number of
	// objects that Amazon Macie can't analyze in one or more S3 buckets. In a BucketMetadata
	// object, this data is for a specific bucket. In a GetBucketStatisticsResponse
	// object, this data is aggregated for all the buckets in the query results.
	UnclassifiableObjectCount *ObjectLevelStatistics `locationName:"unclassifiableObjectCount" type:"structure"`

	// Provides information about the total storage size (in bytes) or number of
	// objects that Amazon Macie can't analyze in one or more S3 buckets. In a BucketMetadata
	// object, this data is for a specific bucket. In a GetBucketStatisticsResponse
	// object, this data is aggregated for all the buckets in the query results.
	UnclassifiableObjectSizeInBytes *ObjectLevelStatistics `locationName:"unclassifiableObjectSizeInBytes" type:"structure"`
}

// String returns the string representation
func (s GetBucketStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketStatisticsOutput) GoString() string {
	return s.String()
}

// SetBucketCount sets the BucketCount field's value.
func (s *GetBucketStatisticsOutput) SetBucketCount(v int64) *GetBucketStatisticsOutput {
	s.BucketCount = &v
	return s
}

// SetBucketCountByEffectivePermission sets the BucketCountByEffectivePermission field's value.
func (s *GetBucketStatisticsOutput) SetBucketCountByEffectivePermission(v *BucketCountByEffectivePermission) *GetBucketStatisticsOutput {
	s.BucketCountByEffectivePermission = v
	return s
}

// SetBucketCountByEncryptionType sets the BucketCountByEncryptionType field's value.
func (s *GetBucketStatisticsOutput) SetBucketCountByEncryptionType(v *BucketCountByEncryptionType) *GetBucketStatisticsOutput {
	s.BucketCountByEncryptionType = v
	return s
}

// SetBucketCountBySharedAccessType sets the BucketCountBySharedAccessType field's value.
func (s *GetBucketStatisticsOutput) SetBucketCountBySharedAccessType(v *BucketCountBySharedAccessType) *GetBucketStatisticsOutput {
	s.BucketCountBySharedAccessType = v
	return s
}

// SetClassifiableObjectCount sets the ClassifiableObjectCount field's value.
func (s *GetBucketStatisticsOutput) SetClassifiableObjectCount(v int64) *GetBucketStatisticsOutput {
	s.ClassifiableObjectCount = &v
	return s
}

// SetClassifiableSizeInBytes sets the ClassifiableSizeInBytes field's value.
func (s *GetBucketStatisticsOutput) SetClassifiableSizeInBytes(v int64) *GetBucketStatisticsOutput {
	s.ClassifiableSizeInBytes = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *GetBucketStatisticsOutput) SetLastUpdated(v time.Time) *GetBucketStatisticsOutput {
	s.LastUpdated = &v
	return s
}

// SetObjectCount sets the ObjectCount field's value.
func (s *GetBucketStatisticsOutput) SetObjectCount(v int64) *GetBucketStatisticsOutput {
	s.ObjectCount = &v
	return s
}

// SetSizeInBytes sets the SizeInBytes field's value.
func (s *GetBucketStatisticsOutput) SetSizeInBytes(v int64) *GetBucketStatisticsOutput {
	s.SizeInBytes = &v
	return s
}

// SetSizeInBytesCompressed sets the SizeInBytesCompressed field's value.
func (s *GetBucketStatisticsOutput) SetSizeInBytesCompressed(v int64) *GetBucketStatisticsOutput {
	s.SizeInBytesCompressed = &v
	return s
}

// SetUnclassifiableObjectCount sets the UnclassifiableObjectCount field's value.
func (s *GetBucketStatisticsOutput) SetUnclassifiableObjectCount(v *ObjectLevelStatistics) *GetBucketStatisticsOutput {
	s.UnclassifiableObjectCount = v
	return s
}

// SetUnclassifiableObjectSizeInBytes sets the UnclassifiableObjectSizeInBytes field's value.
func (s *GetBucketStatisticsOutput) SetUnclassifiableObjectSizeInBytes(v *ObjectLevelStatistics) *GetBucketStatisticsOutput {
	s.UnclassifiableObjectSizeInBytes = v
	return s
}

type GetClassificationExportConfigurationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetClassificationExportConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetClassificationExportConfigurationInput) GoString() string {
	return s.String()
}

// Provides information about the current configuration settings for storing
// data classification results.
type GetClassificationExportConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Specifies where to store data classification results, and the encryption
	// settings to use when storing results in that location. Currently, you can
	// store classification results only in an S3 bucket.
	Configuration *ClassificationExportConfiguration `locationName:"configuration" type:"structure"`
}

// String returns the string representation
func (s GetClassificationExportConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetClassificationExportConfigurationOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *GetClassificationExportConfigurationOutput) SetConfiguration(v *ClassificationExportConfiguration) *GetClassificationExportConfigurationOutput {
	s.Configuration = v
	return s
}

type GetCustomDataIdentifierInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCustomDataIdentifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCustomDataIdentifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCustomDataIdentifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCustomDataIdentifierInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetCustomDataIdentifierInput) SetId(v string) *GetCustomDataIdentifierInput {
	s.Id = &v
	return s
}

// Provides information about the criteria and other settings for a custom data
// identifier.
type GetCustomDataIdentifierOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	Deleted *bool `locationName:"deleted" type:"boolean"`

	Description *string `locationName:"description" type:"string"`

	Id *string `locationName:"id" type:"string"`

	IgnoreWords []*string `locationName:"ignoreWords" type:"list"`

	Keywords []*string `locationName:"keywords" type:"list"`

	MaximumMatchDistance *int64 `locationName:"maximumMatchDistance" type:"integer"`

	Name *string `locationName:"name" type:"string"`

	Regex *string `locationName:"regex" type:"string"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetCustomDataIdentifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCustomDataIdentifierOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetCustomDataIdentifierOutput) SetArn(v string) *GetCustomDataIdentifierOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetCustomDataIdentifierOutput) SetCreatedAt(v time.Time) *GetCustomDataIdentifierOutput {
	s.CreatedAt = &v
	return s
}

// SetDeleted sets the Deleted field's value.
func (s *GetCustomDataIdentifierOutput) SetDeleted(v bool) *GetCustomDataIdentifierOutput {
	s.Deleted = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetCustomDataIdentifierOutput) SetDescription(v string) *GetCustomDataIdentifierOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetCustomDataIdentifierOutput) SetId(v string) *GetCustomDataIdentifierOutput {
	s.Id = &v
	return s
}

// SetIgnoreWords sets the IgnoreWords field's value.
func (s *GetCustomDataIdentifierOutput) SetIgnoreWords(v []*string) *GetCustomDataIdentifierOutput {
	s.IgnoreWords = v
	return s
}

// SetKeywords sets the Keywords field's value.
func (s *GetCustomDataIdentifierOutput) SetKeywords(v []*string) *GetCustomDataIdentifierOutput {
	s.Keywords = v
	return s
}

// SetMaximumMatchDistance sets the MaximumMatchDistance field's value.
func (s *GetCustomDataIdentifierOutput) SetMaximumMatchDistance(v int64) *GetCustomDataIdentifierOutput {
	s.MaximumMatchDistance = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetCustomDataIdentifierOutput) SetName(v string) *GetCustomDataIdentifierOutput {
	s.Name = &v
	return s
}

// SetRegex sets the Regex field's value.
func (s *GetCustomDataIdentifierOutput) SetRegex(v string) *GetCustomDataIdentifierOutput {
	s.Regex = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetCustomDataIdentifierOutput) SetTags(v map[string]*string) *GetCustomDataIdentifierOutput {
	s.Tags = v
	return s
}

// Specifies criteria for filtering, grouping, sorting, and paginating the results
// of a query that retrieves aggregated statistical data about findings.
type GetFindingStatisticsInput struct {
	_ struct{} `type:"structure"`

	// Specifies, as a map, one or more property-based conditions that filter the
	// results of a query for findings.
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure"`

	// GroupBy is a required field
	GroupBy *string `locationName:"groupBy" type:"string" required:"true" enum:"GroupBy"`

	Size *int64 `locationName:"size" type:"integer"`

	// Specifies criteria for sorting the results of a query that retrieves aggregated
	// statistical data about findings.
	SortCriteria *FindingStatisticsSortCriteria `locationName:"sortCriteria" type:"structure"`
}

// String returns the string representation
func (s GetFindingStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFindingStatisticsInput"}
	if s.GroupBy == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupBy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFindingCriteria sets the FindingCriteria field's value.
func (s *GetFindingStatisticsInput) SetFindingCriteria(v *FindingCriteria) *GetFindingStatisticsInput {
	s.FindingCriteria = v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetFindingStatisticsInput) SetGroupBy(v string) *GetFindingStatisticsInput {
	s.GroupBy = &v
	return s
}

// SetSize sets the Size field's value.
func (s *GetFindingStatisticsInput) SetSize(v int64) *GetFindingStatisticsInput {
	s.Size = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *GetFindingStatisticsInput) SetSortCriteria(v *FindingStatisticsSortCriteria) *GetFindingStatisticsInput {
	s.SortCriteria = v
	return s
}

// Provides the results of a query that retrieved aggregated statistical data
// about findings.
type GetFindingStatisticsOutput struct {
	_ struct{} `type:"structure"`

	CountsByGroup []*GroupCount `locationName:"countsByGroup" type:"list"`
}

// String returns the string representation
func (s GetFindingStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingStatisticsOutput) GoString() string {
	return s.String()
}

// SetCountsByGroup sets the CountsByGroup field's value.
func (s *GetFindingStatisticsOutput) SetCountsByGroup(v []*GroupCount) *GetFindingStatisticsOutput {
	s.CountsByGroup = v
	return s
}

type GetFindingsFilterInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFindingsFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingsFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFindingsFilterInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetFindingsFilterInput) SetId(v string) *GetFindingsFilterInput {
	s.Id = &v
	return s
}

// Provides information about the criteria and other settings for a findings
// filter.
type GetFindingsFilterOutput struct {
	_ struct{} `type:"structure"`

	// The action to perform on findings that meet the filter criteria. To suppress
	// (automatically archive) findings that meet the criteria, set this value to
	// ARCHIVE. Valid values are:
	Action *string `locationName:"action" type:"string" enum:"FindingsFilterAction"`

	Arn *string `locationName:"arn" type:"string"`

	Description *string `locationName:"description" type:"string"`

	// Specifies, as a map, one or more property-based conditions that filter the
	// results of a query for findings.
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	Name *string `locationName:"name" type:"string"`

	Position *int64 `locationName:"position" type:"integer"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetFindingsFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsFilterOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *GetFindingsFilterOutput) SetAction(v string) *GetFindingsFilterOutput {
	s.Action = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetFindingsFilterOutput) SetArn(v string) *GetFindingsFilterOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetFindingsFilterOutput) SetDescription(v string) *GetFindingsFilterOutput {
	s.Description = &v
	return s
}

// SetFindingCriteria sets the FindingCriteria field's value.
func (s *GetFindingsFilterOutput) SetFindingCriteria(v *FindingCriteria) *GetFindingsFilterOutput {
	s.FindingCriteria = v
	return s
}

// SetId sets the Id field's value.
func (s *GetFindingsFilterOutput) SetId(v string) *GetFindingsFilterOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetFindingsFilterOutput) SetName(v string) *GetFindingsFilterOutput {
	s.Name = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetFindingsFilterOutput) SetPosition(v int64) *GetFindingsFilterOutput {
	s.Position = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetFindingsFilterOutput) SetTags(v map[string]*string) *GetFindingsFilterOutput {
	s.Tags = v
	return s
}

// Specifies one or more findings to retrieve information about.
type GetFindingsInput struct {
	_ struct{} `type:"structure"`

	// FindingIds is a required field
	FindingIds []*string `locationName:"findingIds" type:"list" required:"true"`

	// Specifies criteria for sorting the results of a request for information about
	// findings.
	SortCriteria *SortCriteria `locationName:"sortCriteria" type:"structure"`
}

// String returns the string representation
func (s GetFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFindingsInput"}
	if s.FindingIds == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFindingIds sets the FindingIds field's value.
func (s *GetFindingsInput) SetFindingIds(v []*string) *GetFindingsInput {
	s.FindingIds = v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *GetFindingsInput) SetSortCriteria(v *SortCriteria) *GetFindingsInput {
	s.SortCriteria = v
	return s
}

// Provides the results of a request for information about one or more findings.
type GetFindingsOutput struct {
	_ struct{} `type:"structure"`

	Findings []*Finding `locationName:"findings" type:"list"`
}

// String returns the string representation
func (s GetFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsOutput) GoString() string {
	return s.String()
}

// SetFindings sets the Findings field's value.
func (s *GetFindingsOutput) SetFindings(v []*Finding) *GetFindingsOutput {
	s.Findings = v
	return s
}

type GetInvitationsCountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetInvitationsCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvitationsCountInput) GoString() string {
	return s.String()
}

// Provides the count of all the Amazon Macie membership invitations that were
// received by an account, not including the currently accepted invitation.
type GetInvitationsCountOutput struct {
	_ struct{} `type:"structure"`

	InvitationsCount *int64 `locationName:"invitationsCount" type:"long"`
}

// String returns the string representation
func (s GetInvitationsCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvitationsCountOutput) GoString() string {
	return s.String()
}

// SetInvitationsCount sets the InvitationsCount field's value.
func (s *GetInvitationsCountOutput) SetInvitationsCount(v int64) *GetInvitationsCountOutput {
	s.InvitationsCount = &v
	return s
}

type GetMacieSessionInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetMacieSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMacieSessionInput) GoString() string {
	return s.String()
}

// Provides information about the current status and configuration settings
// for an Amazon Macie account.
type GetMacieSessionOutput struct {
	_ struct{} `type:"structure"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The frequency with which Amazon Macie publishes updates to policy findings
	// for an account. This includes publishing updates to AWS Security Hub and
	// Amazon EventBridge (formerly called Amazon CloudWatch Events). Valid values
	// are:
	FindingPublishingFrequency *string `locationName:"findingPublishingFrequency" type:"string" enum:"FindingPublishingFrequency"`

	ServiceRole *string `locationName:"serviceRole" type:"string"`

	// The status of an Amazon Macie account. Valid values are:
	Status *string `locationName:"status" type:"string" enum:"MacieStatus"`

	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetMacieSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMacieSessionOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetMacieSessionOutput) SetCreatedAt(v time.Time) *GetMacieSessionOutput {
	s.CreatedAt = &v
	return s
}

// SetFindingPublishingFrequency sets the FindingPublishingFrequency field's value.
func (s *GetMacieSessionOutput) SetFindingPublishingFrequency(v string) *GetMacieSessionOutput {
	s.FindingPublishingFrequency = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *GetMacieSessionOutput) SetServiceRole(v string) *GetMacieSessionOutput {
	s.ServiceRole = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetMacieSessionOutput) SetStatus(v string) *GetMacieSessionOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetMacieSessionOutput) SetUpdatedAt(v time.Time) *GetMacieSessionOutput {
	s.UpdatedAt = &v
	return s
}

type GetMasterAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetMasterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMasterAccountInput) GoString() string {
	return s.String()
}

// Provides information about the Amazon Macie master account for an account.
// If the accounts are associated by a Macie membership invitation, the response
// also provides information about that invitation.
type GetMasterAccountOutput struct {
	_ struct{} `type:"structure"`

	// Provides information about an Amazon Macie membership invitation that was
	// received by an account.
	Master *Invitation `locationName:"master" type:"structure"`
}

// String returns the string representation
func (s GetMasterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMasterAccountOutput) GoString() string {
	return s.String()
}

// SetMaster sets the Master field's value.
func (s *GetMasterAccountOutput) SetMaster(v *Invitation) *GetMasterAccountOutput {
	s.Master = v
	return s
}

type GetMemberInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMemberInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetMemberInput) SetId(v string) *GetMemberInput {
	s.Id = &v
	return s
}

// Provides information about an account that's associated with an Amazon Macie
// master account.
type GetMemberOutput struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	Arn *string `locationName:"arn" type:"string"`

	Email *string `locationName:"email" type:"string"`

	InvitedAt *time.Time `locationName:"invitedAt" type:"timestamp" timestampFormat:"iso8601"`

	MasterAccountId *string `locationName:"masterAccountId" type:"string"`

	// The current status of the relationship between an account and an associated
	// Amazon Macie master account (inviter account). Possible values are:
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string" enum:"RelationshipStatus"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]*string `locationName:"tags" type:"map"`

	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMemberOutput) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *GetMemberOutput) SetAccountId(v string) *GetMemberOutput {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetMemberOutput) SetArn(v string) *GetMemberOutput {
	s.Arn = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *GetMemberOutput) SetEmail(v string) *GetMemberOutput {
	s.Email = &v
	return s
}

// SetInvitedAt sets the InvitedAt field's value.
func (s *GetMemberOutput) SetInvitedAt(v time.Time) *GetMemberOutput {
	s.InvitedAt = &v
	return s
}

// SetMasterAccountId sets the MasterAccountId field's value.
func (s *GetMemberOutput) SetMasterAccountId(v string) *GetMemberOutput {
	s.MasterAccountId = &v
	return s
}

// SetRelationshipStatus sets the RelationshipStatus field's value.
func (s *GetMemberOutput) SetRelationshipStatus(v string) *GetMemberOutput {
	s.RelationshipStatus = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetMemberOutput) SetTags(v map[string]*string) *GetMemberOutput {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetMemberOutput) SetUpdatedAt(v time.Time) *GetMemberOutput {
	s.UpdatedAt = &v
	return s
}

// Specifies criteria for filtering, sorting, and paginating the results of
// a query for quotas and aggregated usage data for one or more accounts.
type GetUsageStatisticsInput struct {
	_ struct{} `type:"structure"`

	FilterBy []*UsageStatisticsFilter `locationName:"filterBy" type:"list"`

	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies criteria for sorting the results of a query for account quotas
	// and usage data.
	SortBy *UsageStatisticsSortBy `locationName:"sortBy" type:"structure"`
}

// String returns the string representation
func (s GetUsageStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUsageStatisticsInput) GoString() string {
	return s.String()
}

// SetFilterBy sets the FilterBy field's value.
func (s *GetUsageStatisticsInput) SetFilterBy(v []*UsageStatisticsFilter) *GetUsageStatisticsInput {
	s.FilterBy = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetUsageStatisticsInput) SetMaxResults(v int64) *GetUsageStatisticsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetUsageStatisticsInput) SetNextToken(v string) *GetUsageStatisticsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *GetUsageStatisticsInput) SetSortBy(v *UsageStatisticsSortBy) *GetUsageStatisticsInput {
	s.SortBy = v
	return s
}

// Provides the results of a query that retrieved quotas and aggregated usage
// data for one or more accounts.
type GetUsageStatisticsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	Records []*UsageRecord `locationName:"records" type:"list"`
}

// String returns the string representation
func (s GetUsageStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUsageStatisticsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetUsageStatisticsOutput) SetNextToken(v string) *GetUsageStatisticsOutput {
	s.NextToken = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *GetUsageStatisticsOutput) SetRecords(v []*UsageRecord) *GetUsageStatisticsOutput {
	s.Records = v
	return s
}

type GetUsageTotalsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetUsageTotalsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUsageTotalsInput) GoString() string {
	return s.String()
}

// Provides the results of a query that retrieved aggregated usage data for
// an account during the past 30 days.
type GetUsageTotalsOutput struct {
	_ struct{} `type:"structure"`

	UsageTotals []*UsageTotal `locationName:"usageTotals" type:"list"`
}

// String returns the string representation
func (s GetUsageTotalsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUsageTotalsOutput) GoString() string {
	return s.String()
}

// SetUsageTotals sets the UsageTotals field's value.
func (s *GetUsageTotalsOutput) SetUsageTotals(v []*UsageTotal) *GetUsageTotalsOutput {
	s.UsageTotals = v
	return s
}

// Provides a group of results for a query that retrieved aggregated statistical
// data about findings.
type GroupCount struct {
	_ struct{} `type:"structure"`

	Count *int64 `locationName:"count" type:"long"`

	GroupKey *string `locationName:"groupKey" type:"string"`
}

// String returns the string representation
func (s GroupCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupCount) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *GroupCount) SetCount(v int64) *GroupCount {
	s.Count = &v
	return s
}

// SetGroupKey sets the GroupKey field's value.
func (s *GroupCount) SetGroupKey(v string) *GroupCount {
	s.GroupKey = &v
	return s
}

// Provides information about an AWS Identity and Access Management (IAM) user
// who performed an action on an affected resource.
type IamUser struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	Arn *string `locationName:"arn" type:"string"`

	PrincipalId *string `locationName:"principalId" type:"string"`

	UserName *string `locationName:"userName" type:"string"`
}

// String returns the string representation
func (s IamUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IamUser) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *IamUser) SetAccountId(v string) *IamUser {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *IamUser) SetArn(v string) *IamUser {
	s.Arn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *IamUser) SetPrincipalId(v string) *IamUser {
	s.PrincipalId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *IamUser) SetUserName(v string) *IamUser {
	s.UserName = &v
	return s
}

// Provides information about an error that occurred due to an unknown internal
// server error, exception, or failure.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about an Amazon Macie membership invitation that was
// received by an account.
type Invitation struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	InvitationId *string `locationName:"invitationId" type:"string"`

	InvitedAt *time.Time `locationName:"invitedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The current status of the relationship between an account and an associated
	// Amazon Macie master account (inviter account). Possible values are:
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string" enum:"RelationshipStatus"`
}

// String returns the string representation
func (s Invitation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Invitation) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Invitation) SetAccountId(v string) *Invitation {
	s.AccountId = &v
	return s
}

// SetInvitationId sets the InvitationId field's value.
func (s *Invitation) SetInvitationId(v string) *Invitation {
	s.InvitationId = &v
	return s
}

// SetInvitedAt sets the InvitedAt field's value.
func (s *Invitation) SetInvitedAt(v time.Time) *Invitation {
	s.InvitedAt = &v
	return s
}

// SetRelationshipStatus sets the RelationshipStatus field's value.
func (s *Invitation) SetRelationshipStatus(v string) *Invitation {
	s.RelationshipStatus = &v
	return s
}

// Provides information about the IP address of the device that an entity used
// to perform an action on an affected resource.
type IpAddressDetails struct {
	_ struct{} `type:"structure"`

	IpAddressV4 *string `locationName:"ipAddressV4" type:"string"`

	// Provides information about the city that an IP address originated from.
	IpCity *IpCity `locationName:"ipCity" type:"structure"`

	// Provides information about the country that an IP address originated from.
	IpCountry *IpCountry `locationName:"ipCountry" type:"structure"`

	// Provides geographic coordinates that indicate where a specified IP address
	// originated from.
	IpGeoLocation *IpGeoLocation `locationName:"ipGeoLocation" type:"structure"`

	// Provides information about the registered owner of an IP address.
	IpOwner *IpOwner `locationName:"ipOwner" type:"structure"`
}

// String returns the string representation
func (s IpAddressDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpAddressDetails) GoString() string {
	return s.String()
}

// SetIpAddressV4 sets the IpAddressV4 field's value.
func (s *IpAddressDetails) SetIpAddressV4(v string) *IpAddressDetails {
	s.IpAddressV4 = &v
	return s
}

// SetIpCity sets the IpCity field's value.
func (s *IpAddressDetails) SetIpCity(v *IpCity) *IpAddressDetails {
	s.IpCity = v
	return s
}

// SetIpCountry sets the IpCountry field's value.
func (s *IpAddressDetails) SetIpCountry(v *IpCountry) *IpAddressDetails {
	s.IpCountry = v
	return s
}

// SetIpGeoLocation sets the IpGeoLocation field's value.
func (s *IpAddressDetails) SetIpGeoLocation(v *IpGeoLocation) *IpAddressDetails {
	s.IpGeoLocation = v
	return s
}

// SetIpOwner sets the IpOwner field's value.
func (s *IpAddressDetails) SetIpOwner(v *IpOwner) *IpAddressDetails {
	s.IpOwner = v
	return s
}

// Provides information about the city that an IP address originated from.
type IpCity struct {
	_ struct{} `type:"structure"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s IpCity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpCity) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *IpCity) SetName(v string) *IpCity {
	s.Name = &v
	return s
}

// Provides information about the country that an IP address originated from.
type IpCountry struct {
	_ struct{} `type:"structure"`

	Code *string `locationName:"code" type:"string"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s IpCountry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpCountry) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *IpCountry) SetCode(v string) *IpCountry {
	s.Code = &v
	return s
}

// SetName sets the Name field's value.
func (s *IpCountry) SetName(v string) *IpCountry {
	s.Name = &v
	return s
}

// Provides geographic coordinates that indicate where a specified IP address
// originated from.
type IpGeoLocation struct {
	_ struct{} `type:"structure"`

	Lat *float64 `locationName:"lat" type:"double"`

	Lon *float64 `locationName:"lon" type:"double"`
}

// String returns the string representation
func (s IpGeoLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpGeoLocation) GoString() string {
	return s.String()
}

// SetLat sets the Lat field's value.
func (s *IpGeoLocation) SetLat(v float64) *IpGeoLocation {
	s.Lat = &v
	return s
}

// SetLon sets the Lon field's value.
func (s *IpGeoLocation) SetLon(v float64) *IpGeoLocation {
	s.Lon = &v
	return s
}

// Provides information about the registered owner of an IP address.
type IpOwner struct {
	_ struct{} `type:"structure"`

	Asn *string `locationName:"asn" type:"string"`

	AsnOrg *string `locationName:"asnOrg" type:"string"`

	Isp *string `locationName:"isp" type:"string"`

	Org *string `locationName:"org" type:"string"`
}

// String returns the string representation
func (s IpOwner) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpOwner) GoString() string {
	return s.String()
}

// SetAsn sets the Asn field's value.
func (s *IpOwner) SetAsn(v string) *IpOwner {
	s.Asn = &v
	return s
}

// SetAsnOrg sets the AsnOrg field's value.
func (s *IpOwner) SetAsnOrg(v string) *IpOwner {
	s.AsnOrg = &v
	return s
}

// SetIsp sets the Isp field's value.
func (s *IpOwner) SetIsp(v string) *IpOwner {
	s.Isp = &v
	return s
}

// SetOrg sets the Org field's value.
func (s *IpOwner) SetOrg(v string) *IpOwner {
	s.Org = &v
	return s
}

// Specifies the recurrence pattern for running a classification job.
type JobScheduleFrequency struct {
	_ struct{} `type:"structure"`

	// Specifies that a classification job runs once a day, every day. This is an
	// empty object.
	DailySchedule *DailySchedule `locationName:"dailySchedule" type:"structure"`

	// Specifies a monthly recurrence pattern for running a classification job.
	MonthlySchedule *MonthlySchedule `locationName:"monthlySchedule" type:"structure"`

	// Specifies a weekly recurrence pattern for running a classification job.
	WeeklySchedule *WeeklySchedule `locationName:"weeklySchedule" type:"structure"`
}

// String returns the string representation
func (s JobScheduleFrequency) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobScheduleFrequency) GoString() string {
	return s.String()
}

// SetDailySchedule sets the DailySchedule field's value.
func (s *JobScheduleFrequency) SetDailySchedule(v *DailySchedule) *JobScheduleFrequency {
	s.DailySchedule = v
	return s
}

// SetMonthlySchedule sets the MonthlySchedule field's value.
func (s *JobScheduleFrequency) SetMonthlySchedule(v *MonthlySchedule) *JobScheduleFrequency {
	s.MonthlySchedule = v
	return s
}

// SetWeeklySchedule sets the WeeklySchedule field's value.
func (s *JobScheduleFrequency) SetWeeklySchedule(v *WeeklySchedule) *JobScheduleFrequency {
	s.WeeklySchedule = v
	return s
}

// Specifies a property- or tag-based condition that defines criteria for including
// or excluding objects from a classification job.
type JobScopeTerm struct {
	_ struct{} `type:"structure"`

	// Specifies a property-based condition that determines whether an object is
	// included or excluded from a classification job.
	SimpleScopeTerm *SimpleScopeTerm `locationName:"simpleScopeTerm" type:"structure"`

	// Specifies a tag-based condition that determines whether an object is included
	// or excluded from a classification job.
	TagScopeTerm *TagScopeTerm `locationName:"tagScopeTerm" type:"structure"`
}

// String returns the string representation
func (s JobScopeTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobScopeTerm) GoString() string {
	return s.String()
}

// SetSimpleScopeTerm sets the SimpleScopeTerm field's value.
func (s *JobScopeTerm) SetSimpleScopeTerm(v *SimpleScopeTerm) *JobScopeTerm {
	s.SimpleScopeTerm = v
	return s
}

// SetTagScopeTerm sets the TagScopeTerm field's value.
func (s *JobScopeTerm) SetTagScopeTerm(v *TagScopeTerm) *JobScopeTerm {
	s.TagScopeTerm = v
	return s
}

// Specifies one or more property- and tag-based conditions that define criteria
// for including or excluding objects from a classification job.
type JobScopingBlock struct {
	_ struct{} `type:"structure"`

	And []*JobScopeTerm `locationName:"and" type:"list"`
}

// String returns the string representation
func (s JobScopingBlock) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobScopingBlock) GoString() string {
	return s.String()
}

// SetAnd sets the And field's value.
func (s *JobScopingBlock) SetAnd(v []*JobScopeTerm) *JobScopingBlock {
	s.And = v
	return s
}

// Provides information about a classification job, including the current status
// of the job.
type JobSummary struct {
	_ struct{} `type:"structure"`

	BucketDefinitions []*S3BucketDefinitionForJob `locationName:"bucketDefinitions" type:"list"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	JobId *string `locationName:"jobId" type:"string"`

	// The current status of a classification job. Possible values are:
	JobStatus *string `locationName:"jobStatus" type:"string" enum:"JobStatus"`

	// The schedule for running a classification job. Valid values are:
	JobType *string `locationName:"jobType" type:"string" enum:"JobType"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s JobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobSummary) GoString() string {
	return s.String()
}

// SetBucketDefinitions sets the BucketDefinitions field's value.
func (s *JobSummary) SetBucketDefinitions(v []*S3BucketDefinitionForJob) *JobSummary {
	s.BucketDefinitions = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *JobSummary) SetCreatedAt(v time.Time) *JobSummary {
	s.CreatedAt = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobSummary) SetJobId(v string) *JobSummary {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *JobSummary) SetJobStatus(v string) *JobSummary {
	s.JobStatus = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *JobSummary) SetJobType(v string) *JobSummary {
	s.JobType = &v
	return s
}

// SetName sets the Name field's value.
func (s *JobSummary) SetName(v string) *JobSummary {
	s.Name = &v
	return s
}

// Provides information about the tags that are associated with an S3 bucket
// or object. Each tag consists of a required tag key and an associated tag
// value.
type KeyValuePair struct {
	_ struct{} `type:"structure"`

	Key *string `locationName:"key" type:"string"`

	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s KeyValuePair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyValuePair) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *KeyValuePair) SetKey(v string) *KeyValuePair {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *KeyValuePair) SetValue(v string) *KeyValuePair {
	s.Value = &v
	return s
}

// Specifies criteria for filtering, sorting, and paginating the results of
// a request for information about classification jobs.
type ListClassificationJobsInput struct {
	_ struct{} `type:"structure"`

	// Specifies criteria for filtering the results of a request for information
	// about classification jobs.
	FilterCriteria *ListJobsFilterCriteria `locationName:"filterCriteria" type:"structure"`

	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies criteria for sorting the results of a request for information about
	// classification jobs.
	SortCriteria *ListJobsSortCriteria `locationName:"sortCriteria" type:"structure"`
}

// String returns the string representation
func (s ListClassificationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClassificationJobsInput) GoString() string {
	return s.String()
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *ListClassificationJobsInput) SetFilterCriteria(v *ListJobsFilterCriteria) *ListClassificationJobsInput {
	s.FilterCriteria = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClassificationJobsInput) SetMaxResults(v int64) *ListClassificationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClassificationJobsInput) SetNextToken(v string) *ListClassificationJobsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *ListClassificationJobsInput) SetSortCriteria(v *ListJobsSortCriteria) *ListClassificationJobsInput {
	s.SortCriteria = v
	return s
}

// Provides the results of a request for information about one or more classification
// jobs.
type ListClassificationJobsOutput struct {
	_ struct{} `type:"structure"`

	Items []*JobSummary `locationName:"items" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListClassificationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClassificationJobsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListClassificationJobsOutput) SetItems(v []*JobSummary) *ListClassificationJobsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClassificationJobsOutput) SetNextToken(v string) *ListClassificationJobsOutput {
	s.NextToken = &v
	return s
}

// Specifies criteria for paginating the results of a request for information
// about custom data identifiers.
type ListCustomDataIdentifiersInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListCustomDataIdentifiersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCustomDataIdentifiersInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCustomDataIdentifiersInput) SetMaxResults(v int64) *ListCustomDataIdentifiersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomDataIdentifiersInput) SetNextToken(v string) *ListCustomDataIdentifiersInput {
	s.NextToken = &v
	return s
}

// Provides the results of a request for information about custom data identifiers.
type ListCustomDataIdentifiersOutput struct {
	_ struct{} `type:"structure"`

	Items []*CustomDataIdentifierSummary `locationName:"items" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListCustomDataIdentifiersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCustomDataIdentifiersOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListCustomDataIdentifiersOutput) SetItems(v []*CustomDataIdentifierSummary) *ListCustomDataIdentifiersOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomDataIdentifiersOutput) SetNextToken(v string) *ListCustomDataIdentifiersOutput {
	s.NextToken = &v
	return s
}

type ListFindingsFiltersInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFindingsFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFindingsFiltersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFindingsFiltersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFindingsFiltersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFindingsFiltersInput) SetMaxResults(v int64) *ListFindingsFiltersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsFiltersInput) SetNextToken(v string) *ListFindingsFiltersInput {
	s.NextToken = &v
	return s
}

// Provides information about all the findings filters for an account.
type ListFindingsFiltersOutput struct {
	_ struct{} `type:"structure"`

	FindingsFilterListItems []*FindingsFilterListItem `locationName:"findingsFilterListItems" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFindingsFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFindingsFiltersOutput) GoString() string {
	return s.String()
}

// SetFindingsFilterListItems sets the FindingsFilterListItems field's value.
func (s *ListFindingsFiltersOutput) SetFindingsFilterListItems(v []*FindingsFilterListItem) *ListFindingsFiltersOutput {
	s.FindingsFilterListItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsFiltersOutput) SetNextToken(v string) *ListFindingsFiltersOutput {
	s.NextToken = &v
	return s
}

// Specifies criteria for filtering, sorting, and paginating the results of
// a request for information about findings.
type ListFindingsInput struct {
	_ struct{} `type:"structure"`

	// Specifies, as a map, one or more property-based conditions that filter the
	// results of a query for findings.
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure"`

	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies criteria for sorting the results of a request for information about
	// findings.
	SortCriteria *SortCriteria `locationName:"sortCriteria" type:"structure"`
}

// String returns the string representation
func (s ListFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFindingsInput) GoString() string {
	return s.String()
}

// SetFindingCriteria sets the FindingCriteria field's value.
func (s *ListFindingsInput) SetFindingCriteria(v *FindingCriteria) *ListFindingsInput {
	s.FindingCriteria = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFindingsInput) SetMaxResults(v int64) *ListFindingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsInput) SetNextToken(v string) *ListFindingsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *ListFindingsInput) SetSortCriteria(v *SortCriteria) *ListFindingsInput {
	s.SortCriteria = v
	return s
}

// Provides the results of a request for information about one or more findings.
type ListFindingsOutput struct {
	_ struct{} `type:"structure"`

	FindingIds []*string `locationName:"findingIds" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFindingsOutput) GoString() string {
	return s.String()
}

// SetFindingIds sets the FindingIds field's value.
func (s *ListFindingsOutput) SetFindingIds(v []*string) *ListFindingsOutput {
	s.FindingIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsOutput) SetNextToken(v string) *ListFindingsOutput {
	s.NextToken = &v
	return s
}

type ListInvitationsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInvitationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInvitationsInput) SetMaxResults(v int64) *ListInvitationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsInput) SetNextToken(v string) *ListInvitationsInput {
	s.NextToken = &v
	return s
}

// Provides information about all the Amazon Macie membership invitations that
// were received by an account.
type ListInvitationsOutput struct {
	_ struct{} `type:"structure"`

	Invitations []*Invitation `locationName:"invitations" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsOutput) GoString() string {
	return s.String()
}

// SetInvitations sets the Invitations field's value.
func (s *ListInvitationsOutput) SetInvitations(v []*Invitation) *ListInvitationsOutput {
	s.Invitations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsOutput) SetNextToken(v string) *ListInvitationsOutput {
	s.NextToken = &v
	return s
}

// Specifies criteria for filtering the results of a request for information
// about classification jobs.
type ListJobsFilterCriteria struct {
	_ struct{} `type:"structure"`

	Excludes []*ListJobsFilterTerm `locationName:"excludes" type:"list"`

	Includes []*ListJobsFilterTerm `locationName:"includes" type:"list"`
}

// String returns the string representation
func (s ListJobsFilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsFilterCriteria) GoString() string {
	return s.String()
}

// SetExcludes sets the Excludes field's value.
func (s *ListJobsFilterCriteria) SetExcludes(v []*ListJobsFilterTerm) *ListJobsFilterCriteria {
	s.Excludes = v
	return s
}

// SetIncludes sets the Includes field's value.
func (s *ListJobsFilterCriteria) SetIncludes(v []*ListJobsFilterTerm) *ListJobsFilterCriteria {
	s.Includes = v
	return s
}

// Specifies a condition that filters the results of a request for information
// about classification jobs. Each condition consists of a property, an operator,
// and one or more values.
type ListJobsFilterTerm struct {
	_ struct{} `type:"structure"`

	// The operator to use in a condition. Valid values are:
	Comparator *string `locationName:"comparator" type:"string" enum:"JobComparator"`

	// The property to use to filter the results. Valid values are:
	Key *string `locationName:"key" type:"string" enum:"ListJobsFilterKey"`

	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s ListJobsFilterTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsFilterTerm) GoString() string {
	return s.String()
}

// SetComparator sets the Comparator field's value.
func (s *ListJobsFilterTerm) SetComparator(v string) *ListJobsFilterTerm {
	s.Comparator = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ListJobsFilterTerm) SetKey(v string) *ListJobsFilterTerm {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ListJobsFilterTerm) SetValues(v []*string) *ListJobsFilterTerm {
	s.Values = v
	return s
}

// Specifies criteria for sorting the results of a request for information about
// classification jobs.
type ListJobsSortCriteria struct {
	_ struct{} `type:"structure"`

	// The property to sort the results by. Valid values are:
	AttributeName *string `locationName:"attributeName" type:"string" enum:"ListJobsSortAttributeName"`

	OrderBy *string `locationName:"orderBy" type:"string" enum:"OrderBy"`
}

// String returns the string representation
func (s ListJobsSortCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsSortCriteria) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *ListJobsSortCriteria) SetAttributeName(v string) *ListJobsSortCriteria {
	s.AttributeName = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *ListJobsSortCriteria) SetOrderBy(v string) *ListJobsSortCriteria {
	s.OrderBy = &v
	return s
}

type ListMembersInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	OnlyAssociated *string `location:"querystring" locationName:"onlyAssociated" type:"string"`
}

// String returns the string representation
func (s ListMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMembersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMembersInput) SetMaxResults(v int64) *ListMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersInput) SetNextToken(v string) *ListMembersInput {
	s.NextToken = &v
	return s
}

// SetOnlyAssociated sets the OnlyAssociated field's value.
func (s *ListMembersInput) SetOnlyAssociated(v string) *ListMembersInput {
	s.OnlyAssociated = &v
	return s
}

// Provides information about the accounts that are associated with an Amazon
// Macie master account.
type ListMembersOutput struct {
	_ struct{} `type:"structure"`

	Members []*Member `locationName:"members" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListMembersOutput) SetMembers(v []*Member) *ListMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersOutput) SetNextToken(v string) *ListMembersOutput {
	s.NextToken = &v
	return s
}

type ListOrganizationAdminAccountsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListOrganizationAdminAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOrganizationAdminAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOrganizationAdminAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOrganizationAdminAccountsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOrganizationAdminAccountsInput) SetMaxResults(v int64) *ListOrganizationAdminAccountsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationAdminAccountsInput) SetNextToken(v string) *ListOrganizationAdminAccountsInput {
	s.NextToken = &v
	return s
}

// Provides information about the accounts that are designated as delegated
// administrators of Amazon Macie for an AWS organization.
type ListOrganizationAdminAccountsOutput struct {
	_ struct{} `type:"structure"`

	AdminAccounts []*AdminAccount `locationName:"adminAccounts" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListOrganizationAdminAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOrganizationAdminAccountsOutput) GoString() string {
	return s.String()
}

// SetAdminAccounts sets the AdminAccounts field's value.
func (s *ListOrganizationAdminAccountsOutput) SetAdminAccounts(v []*AdminAccount) *ListOrganizationAdminAccountsOutput {
	s.AdminAccounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationAdminAccountsOutput) SetNextToken(v string) *ListOrganizationAdminAccountsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

// Provides information about the tags (keys and values) that are associated
// with a classification job, custom data identifier, findings filter, or member
// account.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Provides information about an account that's associated with an Amazon Macie
// master account.
type Member struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	Arn *string `locationName:"arn" type:"string"`

	Email *string `locationName:"email" type:"string"`

	InvitedAt *time.Time `locationName:"invitedAt" type:"timestamp" timestampFormat:"iso8601"`

	MasterAccountId *string `locationName:"masterAccountId" type:"string"`

	// The current status of the relationship between an account and an associated
	// Amazon Macie master account (inviter account). Possible values are:
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string" enum:"RelationshipStatus"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]*string `locationName:"tags" type:"map"`

	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Member) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Member) SetAccountId(v string) *Member {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Member) SetArn(v string) *Member {
	s.Arn = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *Member) SetEmail(v string) *Member {
	s.Email = &v
	return s
}

// SetInvitedAt sets the InvitedAt field's value.
func (s *Member) SetInvitedAt(v time.Time) *Member {
	s.InvitedAt = &v
	return s
}

// SetMasterAccountId sets the MasterAccountId field's value.
func (s *Member) SetMasterAccountId(v string) *Member {
	s.MasterAccountId = &v
	return s
}

// SetRelationshipStatus sets the RelationshipStatus field's value.
func (s *Member) SetRelationshipStatus(v string) *Member {
	s.RelationshipStatus = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Member) SetTags(v map[string]*string) *Member {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Member) SetUpdatedAt(v time.Time) *Member {
	s.UpdatedAt = &v
	return s
}

// Specifies a monthly recurrence pattern for running a classification job.
type MonthlySchedule struct {
	_ struct{} `type:"structure"`

	DayOfMonth *int64 `locationName:"dayOfMonth" type:"integer"`
}

// String returns the string representation
func (s MonthlySchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MonthlySchedule) GoString() string {
	return s.String()
}

// SetDayOfMonth sets the DayOfMonth field's value.
func (s *MonthlySchedule) SetDayOfMonth(v int64) *MonthlySchedule {
	s.DayOfMonth = &v
	return s
}

// Provides information about the number of objects that are in an S3 bucket
// and use certain types of server-side encryption, use client-side encryption,
// or aren't encrypted.
type ObjectCountByEncryptionType struct {
	_ struct{} `type:"structure"`

	CustomerManaged *int64 `locationName:"customerManaged" type:"long"`

	KmsManaged *int64 `locationName:"kmsManaged" type:"long"`

	S3Managed *int64 `locationName:"s3Managed" type:"long"`

	Unencrypted *int64 `locationName:"unencrypted" type:"long"`
}

// String returns the string representation
func (s ObjectCountByEncryptionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectCountByEncryptionType) GoString() string {
	return s.String()
}

// SetCustomerManaged sets the CustomerManaged field's value.
func (s *ObjectCountByEncryptionType) SetCustomerManaged(v int64) *ObjectCountByEncryptionType {
	s.CustomerManaged = &v
	return s
}

// SetKmsManaged sets the KmsManaged field's value.
func (s *ObjectCountByEncryptionType) SetKmsManaged(v int64) *ObjectCountByEncryptionType {
	s.KmsManaged = &v
	return s
}

// SetS3Managed sets the S3Managed field's value.
func (s *ObjectCountByEncryptionType) SetS3Managed(v int64) *ObjectCountByEncryptionType {
	s.S3Managed = &v
	return s
}

// SetUnencrypted sets the Unencrypted field's value.
func (s *ObjectCountByEncryptionType) SetUnencrypted(v int64) *ObjectCountByEncryptionType {
	s.Unencrypted = &v
	return s
}

// Provides information about the total storage size (in bytes) or number of
// objects that Amazon Macie can't analyze in one or more S3 buckets. In a BucketMetadata
// object, this data is for a specific bucket. In a GetBucketStatisticsResponse
// object, this data is aggregated for all the buckets in the query results.
type ObjectLevelStatistics struct {
	_ struct{} `type:"structure"`

	FileType *int64 `locationName:"fileType" type:"long"`

	StorageClass *int64 `locationName:"storageClass" type:"long"`

	Total *int64 `locationName:"total" type:"long"`
}

// String returns the string representation
func (s ObjectLevelStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectLevelStatistics) GoString() string {
	return s.String()
}

// SetFileType sets the FileType field's value.
func (s *ObjectLevelStatistics) SetFileType(v int64) *ObjectLevelStatistics {
	s.FileType = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *ObjectLevelStatistics) SetStorageClass(v int64) *ObjectLevelStatistics {
	s.StorageClass = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *ObjectLevelStatistics) SetTotal(v int64) *ObjectLevelStatistics {
	s.Total = &v
	return s
}

// Provides the details of a policy finding.
type PolicyDetails struct {
	_ struct{} `type:"structure"`

	// Provides information about an action that occurred for a resource and produced
	// a policy finding.
	Action *FindingAction `locationName:"action" type:"structure"`

	// Provides information about an entity that performed an action that produced
	// a policy finding for a resource.
	Actor *FindingActor `locationName:"actor" type:"structure"`
}

// String returns the string representation
func (s PolicyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyDetails) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *PolicyDetails) SetAction(v *FindingAction) *PolicyDetails {
	s.Action = v
	return s
}

// SetActor sets the Actor field's value.
func (s *PolicyDetails) SetActor(v *FindingActor) *PolicyDetails {
	s.Actor = v
	return s
}

// Specifies where to store data classification results, and the encryption
// settings to use when storing results in that location. Currently, you can
// store classification results only in an S3 bucket.
type PutClassificationExportConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Specifies where to store data classification results, and the encryption
	// settings to use when storing results in that location. Currently, you can
	// store classification results only in an S3 bucket.
	//
	// Configuration is a required field
	Configuration *ClassificationExportConfiguration `locationName:"configuration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutClassificationExportConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutClassificationExportConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutClassificationExportConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutClassificationExportConfigurationInput"}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *PutClassificationExportConfigurationInput) SetConfiguration(v *ClassificationExportConfiguration) *PutClassificationExportConfigurationInput {
	s.Configuration = v
	return s
}

// Provides information about updated settings for storing data classification
// results.
type PutClassificationExportConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Specifies where to store data classification results, and the encryption
	// settings to use when storing results in that location. Currently, you can
	// store classification results only in an S3 bucket.
	Configuration *ClassificationExportConfiguration `locationName:"configuration" type:"structure"`
}

// String returns the string representation
func (s PutClassificationExportConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutClassificationExportConfigurationOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *PutClassificationExportConfigurationOutput) SetConfiguration(v *ClassificationExportConfiguration) *PutClassificationExportConfigurationOutput {
	s.Configuration = v
	return s
}

// Provides information about settings that define whether one or more objects
// in an S3 bucket are replicated to S3 buckets for other AWS accounts and,
// if so, which accounts.
type ReplicationDetails struct {
	_ struct{} `type:"structure"`

	Replicated *bool `locationName:"replicated" type:"boolean"`

	ReplicatedExternally *bool `locationName:"replicatedExternally" type:"boolean"`

	ReplicationAccounts []*string `locationName:"replicationAccounts" type:"list"`
}

// String returns the string representation
func (s ReplicationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationDetails) GoString() string {
	return s.String()
}

// SetReplicated sets the Replicated field's value.
func (s *ReplicationDetails) SetReplicated(v bool) *ReplicationDetails {
	s.Replicated = &v
	return s
}

// SetReplicatedExternally sets the ReplicatedExternally field's value.
func (s *ReplicationDetails) SetReplicatedExternally(v bool) *ReplicationDetails {
	s.ReplicatedExternally = &v
	return s
}

// SetReplicationAccounts sets the ReplicationAccounts field's value.
func (s *ReplicationDetails) SetReplicationAccounts(v []*string) *ReplicationDetails {
	s.ReplicationAccounts = v
	return s
}

// Provides information about an error that occurred because a specified resource
// wasn't found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about the resources that a finding applies to.
type ResourcesAffected struct {
	_ struct{} `type:"structure"`

	// Provides information about an S3 bucket that a finding applies to.
	S3Bucket *S3Bucket `locationName:"s3Bucket" type:"structure"`

	// Provides information about an S3 object that a finding applies to.
	S3Object *S3Object `locationName:"s3Object" type:"structure"`
}

// String returns the string representation
func (s ResourcesAffected) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourcesAffected) GoString() string {
	return s.String()
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *ResourcesAffected) SetS3Bucket(v *S3Bucket) *ResourcesAffected {
	s.S3Bucket = v
	return s
}

// SetS3Object sets the S3Object field's value.
func (s *ResourcesAffected) SetS3Object(v *S3Object) *ResourcesAffected {
	s.S3Object = v
	return s
}

// Provides information about an S3 bucket that a finding applies to.
type S3Bucket struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// Provides information about the server-side encryption settings for an S3
	// bucket or object.
	DefaultServerSideEncryption *ServerSideEncryption `locationName:"defaultServerSideEncryption" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	// Provides information about the user who owns an S3 bucket.
	Owner *S3BucketOwner `locationName:"owner" type:"structure"`

	// Provides information about the permissions settings that determine whether
	// an S3 bucket is publicly accessible.
	PublicAccess *BucketPublicAccess `locationName:"publicAccess" type:"structure"`

	// Provides information about the tags that are associated with an S3 bucket
	// or object. Each tag consists of a required tag key and an associated tag
	// value.
	Tags []*KeyValuePair `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s S3Bucket) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Bucket) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *S3Bucket) SetArn(v string) *S3Bucket {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *S3Bucket) SetCreatedAt(v time.Time) *S3Bucket {
	s.CreatedAt = &v
	return s
}

// SetDefaultServerSideEncryption sets the DefaultServerSideEncryption field's value.
func (s *S3Bucket) SetDefaultServerSideEncryption(v *ServerSideEncryption) *S3Bucket {
	s.DefaultServerSideEncryption = v
	return s
}

// SetName sets the Name field's value.
func (s *S3Bucket) SetName(v string) *S3Bucket {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *S3Bucket) SetOwner(v *S3BucketOwner) *S3Bucket {
	s.Owner = v
	return s
}

// SetPublicAccess sets the PublicAccess field's value.
func (s *S3Bucket) SetPublicAccess(v *BucketPublicAccess) *S3Bucket {
	s.PublicAccess = v
	return s
}

// SetTags sets the Tags field's value.
func (s *S3Bucket) SetTags(v []*KeyValuePair) *S3Bucket {
	s.Tags = v
	return s
}

// Specifies which S3 buckets contain the objects that a classification job
// analyzes.
type S3BucketDefinitionForJob struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	Buckets []*string `locationName:"buckets" type:"list"`
}

// String returns the string representation
func (s S3BucketDefinitionForJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3BucketDefinitionForJob) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *S3BucketDefinitionForJob) SetAccountId(v string) *S3BucketDefinitionForJob {
	s.AccountId = &v
	return s
}

// SetBuckets sets the Buckets field's value.
func (s *S3BucketDefinitionForJob) SetBuckets(v []*string) *S3BucketDefinitionForJob {
	s.Buckets = v
	return s
}

// Provides information about the user who owns an S3 bucket.
type S3BucketOwner struct {
	_ struct{} `type:"structure"`

	DisplayName *string `locationName:"displayName" type:"string"`

	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s S3BucketOwner) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3BucketOwner) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *S3BucketOwner) SetDisplayName(v string) *S3BucketOwner {
	s.DisplayName = &v
	return s
}

// SetId sets the Id field's value.
func (s *S3BucketOwner) SetId(v string) *S3BucketOwner {
	s.Id = &v
	return s
}

// Specifies an S3 bucket to store data classification results in, and the encryption
// settings to use when storing results in that bucket.
type S3Destination struct {
	_ struct{} `type:"structure"`

	// BucketName is a required field
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	KeyPrefix *string `locationName:"keyPrefix" type:"string"`

	// KmsKeyArn is a required field
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Destination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Destination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Destination"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.KmsKeyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsKeyArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Destination) SetBucketName(v string) *S3Destination {
	s.BucketName = &v
	return s
}

// SetKeyPrefix sets the KeyPrefix field's value.
func (s *S3Destination) SetKeyPrefix(v string) *S3Destination {
	s.KeyPrefix = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *S3Destination) SetKmsKeyArn(v string) *S3Destination {
	s.KmsKeyArn = &v
	return s
}

// Specifies which S3 buckets contain the objects that a classification job
// analyzes, and the scope of that analysis.
type S3JobDefinition struct {
	_ struct{} `type:"structure"`

	BucketDefinitions []*S3BucketDefinitionForJob `locationName:"bucketDefinitions" type:"list"`

	// Specifies one or more property- and tag-based conditions that refine the
	// scope of a classification job. These conditions define criteria that determine
	// which objects a job analyzes.
	Scoping *Scoping `locationName:"scoping" type:"structure"`
}

// String returns the string representation
func (s S3JobDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3JobDefinition) GoString() string {
	return s.String()
}

// SetBucketDefinitions sets the BucketDefinitions field's value.
func (s *S3JobDefinition) SetBucketDefinitions(v []*S3BucketDefinitionForJob) *S3JobDefinition {
	s.BucketDefinitions = v
	return s
}

// SetScoping sets the Scoping field's value.
func (s *S3JobDefinition) SetScoping(v *Scoping) *S3JobDefinition {
	s.Scoping = v
	return s
}

// Provides information about an S3 object that a finding applies to.
type S3Object struct {
	_ struct{} `type:"structure"`

	BucketArn *string `locationName:"bucketArn" type:"string"`

	ETag *string `locationName:"eTag" type:"string"`

	Extension *string `locationName:"extension" type:"string"`

	Key *string `locationName:"key" type:"string"`

	LastModified *time.Time `locationName:"lastModified" type:"timestamp" timestampFormat:"iso8601"`

	Path *string `locationName:"path" type:"string"`

	PublicAccess *bool `locationName:"publicAccess" type:"boolean"`

	// Provides information about the server-side encryption settings for an S3
	// bucket or object.
	ServerSideEncryption *ServerSideEncryption `locationName:"serverSideEncryption" type:"structure"`

	Size *int64 `locationName:"size" type:"long"`

	// The storage class of the S3 bucket or object. Possible values are:
	StorageClass *string `locationName:"storageClass" type:"string" enum:"StorageClass"`

	// Provides information about the tags that are associated with an S3 bucket
	// or object. Each tag consists of a required tag key and an associated tag
	// value.
	Tags []*KeyValuePair `locationName:"tags" type:"list"`

	VersionId *string `locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s S3Object) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Object) GoString() string {
	return s.String()
}

// SetBucketArn sets the BucketArn field's value.
func (s *S3Object) SetBucketArn(v string) *S3Object {
	s.BucketArn = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *S3Object) SetETag(v string) *S3Object {
	s.ETag = &v
	return s
}

// SetExtension sets the Extension field's value.
func (s *S3Object) SetExtension(v string) *S3Object {
	s.Extension = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Object) SetKey(v string) *S3Object {
	s.Key = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *S3Object) SetLastModified(v time.Time) *S3Object {
	s.LastModified = &v
	return s
}

// SetPath sets the Path field's value.
func (s *S3Object) SetPath(v string) *S3Object {
	s.Path = &v
	return s
}

// SetPublicAccess sets the PublicAccess field's value.
func (s *S3Object) SetPublicAccess(v bool) *S3Object {
	s.PublicAccess = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *S3Object) SetServerSideEncryption(v *ServerSideEncryption) *S3Object {
	s.ServerSideEncryption = v
	return s
}

// SetSize sets the Size field's value.
func (s *S3Object) SetSize(v int64) *S3Object {
	s.Size = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *S3Object) SetStorageClass(v string) *S3Object {
	s.StorageClass = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *S3Object) SetTags(v []*KeyValuePair) *S3Object {
	s.Tags = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *S3Object) SetVersionId(v string) *S3Object {
	s.VersionId = &v
	return s
}

// Specifies one or more property- and tag-based conditions that refine the
// scope of a classification job. These conditions define criteria that determine
// which objects a job analyzes.
type Scoping struct {
	_ struct{} `type:"structure"`

	// Specifies one or more property- and tag-based conditions that define criteria
	// for including or excluding objects from a classification job.
	Excludes *JobScopingBlock `locationName:"excludes" type:"structure"`

	// Specifies one or more property- and tag-based conditions that define criteria
	// for including or excluding objects from a classification job.
	Includes *JobScopingBlock `locationName:"includes" type:"structure"`
}

// String returns the string representation
func (s Scoping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scoping) GoString() string {
	return s.String()
}

// SetExcludes sets the Excludes field's value.
func (s *Scoping) SetExcludes(v *JobScopingBlock) *Scoping {
	s.Excludes = v
	return s
}

// SetIncludes sets the Includes field's value.
func (s *Scoping) SetIncludes(v *JobScopingBlock) *Scoping {
	s.Includes = v
	return s
}

// Provides information about the category, type, and number of occurrences
// of sensitive data that produced a finding.
type SensitiveDataItem struct {
	_ struct{} `type:"structure"`

	// The category of sensitive data that was detected and produced the finding.
	// Possible values are:
	Category *string `locationName:"category" type:"string" enum:"SensitiveDataItemCategory"`

	// Provides information about sensitive data that was detected by managed data
	// identifiers and produced a sensitive data finding, and the number of occurrences
	// of each type of sensitive data that was detected.
	Detections []*DefaultDetection `locationName:"detections" type:"list"`

	TotalCount *int64 `locationName:"totalCount" type:"long"`
}

// String returns the string representation
func (s SensitiveDataItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SensitiveDataItem) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *SensitiveDataItem) SetCategory(v string) *SensitiveDataItem {
	s.Category = &v
	return s
}

// SetDetections sets the Detections field's value.
func (s *SensitiveDataItem) SetDetections(v []*DefaultDetection) *SensitiveDataItem {
	s.Detections = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SensitiveDataItem) SetTotalCount(v int64) *SensitiveDataItem {
	s.TotalCount = &v
	return s
}

// Provides information about the server-side encryption settings for an S3
// bucket or object.
type ServerSideEncryption struct {
	_ struct{} `type:"structure"`

	// The type of server-side encryption that's used to encrypt objects in the
	// S3 bucket. Valid values are:
	EncryptionType *string `locationName:"encryptionType" type:"string" enum:"EncryptionType"`

	KmsMasterKeyId *string `locationName:"kmsMasterKeyId" type:"string"`
}

// String returns the string representation
func (s ServerSideEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerSideEncryption) GoString() string {
	return s.String()
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *ServerSideEncryption) SetEncryptionType(v string) *ServerSideEncryption {
	s.EncryptionType = &v
	return s
}

// SetKmsMasterKeyId sets the KmsMasterKeyId field's value.
func (s *ServerSideEncryption) SetKmsMasterKeyId(v string) *ServerSideEncryption {
	s.KmsMasterKeyId = &v
	return s
}

// Specifies a current quota for an account.
type ServiceLimit struct {
	_ struct{} `type:"structure"`

	IsServiceLimited *bool `locationName:"isServiceLimited" type:"boolean"`

	Unit *string `locationName:"unit" type:"string" enum:"Unit"`

	Value *int64 `locationName:"value" type:"long"`
}

// String returns the string representation
func (s ServiceLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceLimit) GoString() string {
	return s.String()
}

// SetIsServiceLimited sets the IsServiceLimited field's value.
func (s *ServiceLimit) SetIsServiceLimited(v bool) *ServiceLimit {
	s.IsServiceLimited = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *ServiceLimit) SetUnit(v string) *ServiceLimit {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ServiceLimit) SetValue(v int64) *ServiceLimit {
	s.Value = &v
	return s
}

// Provides information about an error that occurred due to one or more service
// quotas for an account.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about a session that was created for an entity that
// performed an action by using temporary security credentials.
type SessionContext struct {
	_ struct{} `type:"structure"`

	// Provides information about the context in which temporary security credentials
	// were issued to an entity.
	Attributes *SessionContextAttributes `locationName:"attributes" type:"structure"`

	// Provides information about the source and type of temporary security credentials
	// that were issued to an entity.
	SessionIssuer *SessionIssuer `locationName:"sessionIssuer" type:"structure"`
}

// String returns the string representation
func (s SessionContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SessionContext) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *SessionContext) SetAttributes(v *SessionContextAttributes) *SessionContext {
	s.Attributes = v
	return s
}

// SetSessionIssuer sets the SessionIssuer field's value.
func (s *SessionContext) SetSessionIssuer(v *SessionIssuer) *SessionContext {
	s.SessionIssuer = v
	return s
}

// Provides information about the context in which temporary security credentials
// were issued to an entity.
type SessionContextAttributes struct {
	_ struct{} `type:"structure"`

	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"iso8601"`

	MfaAuthenticated *bool `locationName:"mfaAuthenticated" type:"boolean"`
}

// String returns the string representation
func (s SessionContextAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SessionContextAttributes) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *SessionContextAttributes) SetCreationDate(v time.Time) *SessionContextAttributes {
	s.CreationDate = &v
	return s
}

// SetMfaAuthenticated sets the MfaAuthenticated field's value.
func (s *SessionContextAttributes) SetMfaAuthenticated(v bool) *SessionContextAttributes {
	s.MfaAuthenticated = &v
	return s
}

// Provides information about the source and type of temporary security credentials
// that were issued to an entity.
type SessionIssuer struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	Arn *string `locationName:"arn" type:"string"`

	PrincipalId *string `locationName:"principalId" type:"string"`

	Type *string `locationName:"type" type:"string"`

	UserName *string `locationName:"userName" type:"string"`
}

// String returns the string representation
func (s SessionIssuer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SessionIssuer) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *SessionIssuer) SetAccountId(v string) *SessionIssuer {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *SessionIssuer) SetArn(v string) *SessionIssuer {
	s.Arn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *SessionIssuer) SetPrincipalId(v string) *SessionIssuer {
	s.PrincipalId = &v
	return s
}

// SetType sets the Type field's value.
func (s *SessionIssuer) SetType(v string) *SessionIssuer {
	s.Type = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *SessionIssuer) SetUserName(v string) *SessionIssuer {
	s.UserName = &v
	return s
}

// Provides the numeric score and textual representation of a severity value.
type Severity struct {
	_ struct{} `type:"structure"`

	// The textual representation of the finding's severity. Possible values are:
	Description *string `locationName:"description" type:"string" enum:"SeverityDescription"`

	Score *int64 `locationName:"score" type:"long"`
}

// String returns the string representation
func (s Severity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Severity) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Severity) SetDescription(v string) *Severity {
	s.Description = &v
	return s
}

// SetScore sets the Score field's value.
func (s *Severity) SetScore(v int64) *Severity {
	s.Score = &v
	return s
}

// Specifies a property-based condition that determines whether an object is
// included or excluded from a classification job.
type SimpleScopeTerm struct {
	_ struct{} `type:"structure"`

	// The operator to use in a condition. Valid values are:
	Comparator *string `locationName:"comparator" type:"string" enum:"JobComparator"`

	// The property to use in a condition that determines which objects are analyzed
	// by a classification job. Valid values are:
	Key *string `locationName:"key" type:"string" enum:"ScopeFilterKey"`

	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s SimpleScopeTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimpleScopeTerm) GoString() string {
	return s.String()
}

// SetComparator sets the Comparator field's value.
func (s *SimpleScopeTerm) SetComparator(v string) *SimpleScopeTerm {
	s.Comparator = &v
	return s
}

// SetKey sets the Key field's value.
func (s *SimpleScopeTerm) SetKey(v string) *SimpleScopeTerm {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SimpleScopeTerm) SetValues(v []*string) *SimpleScopeTerm {
	s.Values = v
	return s
}

// Specifies criteria for sorting the results of a request for information about
// findings.
type SortCriteria struct {
	_ struct{} `type:"structure"`

	AttributeName *string `locationName:"attributeName" type:"string"`

	OrderBy *string `locationName:"orderBy" type:"string" enum:"OrderBy"`
}

// String returns the string representation
func (s SortCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SortCriteria) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *SortCriteria) SetAttributeName(v string) *SortCriteria {
	s.AttributeName = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *SortCriteria) SetOrderBy(v string) *SortCriteria {
	s.OrderBy = &v
	return s
}

// Provides processing statistics for a classification job.
type Statistics struct {
	_ struct{} `type:"structure"`

	ApproximateNumberOfObjectsToProcess *float64 `locationName:"approximateNumberOfObjectsToProcess" type:"double"`

	NumberOfRuns *float64 `locationName:"numberOfRuns" type:"double"`
}

// String returns the string representation
func (s Statistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Statistics) GoString() string {
	return s.String()
}

// SetApproximateNumberOfObjectsToProcess sets the ApproximateNumberOfObjectsToProcess field's value.
func (s *Statistics) SetApproximateNumberOfObjectsToProcess(v float64) *Statistics {
	s.ApproximateNumberOfObjectsToProcess = &v
	return s
}

// SetNumberOfRuns sets the NumberOfRuns field's value.
func (s *Statistics) SetNumberOfRuns(v float64) *Statistics {
	s.NumberOfRuns = &v
	return s
}

// Specifies the tags (keys and values) to associate with a classification job,
// custom data identifier, findings filter, or member account.
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

// The request succeeded. The specified tags were added to the resource.
type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Specifies a tag-based condition that determines whether an object is included
// or excluded from a classification job.
type TagScopeTerm struct {
	_ struct{} `type:"structure"`

	// The operator to use in a condition. Valid values are:
	Comparator *string `locationName:"comparator" type:"string" enum:"JobComparator"`

	Key *string `locationName:"key" type:"string"`

	TagValues []*TagValuePair `locationName:"tagValues" type:"list"`

	// The type of object to apply a tag-based condition to. Valid values are:
	Target *string `locationName:"target" type:"string" enum:"TagTarget"`
}

// String returns the string representation
func (s TagScopeTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagScopeTerm) GoString() string {
	return s.String()
}

// SetComparator sets the Comparator field's value.
func (s *TagScopeTerm) SetComparator(v string) *TagScopeTerm {
	s.Comparator = &v
	return s
}

// SetKey sets the Key field's value.
func (s *TagScopeTerm) SetKey(v string) *TagScopeTerm {
	s.Key = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *TagScopeTerm) SetTagValues(v []*TagValuePair) *TagScopeTerm {
	s.TagValues = v
	return s
}

// SetTarget sets the Target field's value.
func (s *TagScopeTerm) SetTarget(v string) *TagScopeTerm {
	s.Target = &v
	return s
}

// Specifies a tag key and value, as a pair, to use in a tag-based condition
// for a classification job.
type TagValuePair struct {
	_ struct{} `type:"structure"`

	Key *string `locationName:"key" type:"string"`

	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s TagValuePair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagValuePair) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagValuePair) SetKey(v string) *TagValuePair {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagValuePair) SetValue(v string) *TagValuePair {
	s.Value = &v
	return s
}

// Specifies the detection criteria of a custom data identifier to test.
type TestCustomDataIdentifierInput struct {
	_ struct{} `type:"structure"`

	IgnoreWords []*string `locationName:"ignoreWords" type:"list"`

	Keywords []*string `locationName:"keywords" type:"list"`

	MaximumMatchDistance *int64 `locationName:"maximumMatchDistance" type:"integer"`

	// Regex is a required field
	Regex *string `locationName:"regex" type:"string" required:"true"`

	// SampleText is a required field
	SampleText *string `locationName:"sampleText" type:"string" required:"true"`
}

// String returns the string representation
func (s TestCustomDataIdentifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestCustomDataIdentifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestCustomDataIdentifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestCustomDataIdentifierInput"}
	if s.Regex == nil {
		invalidParams.Add(request.NewErrParamRequired("Regex"))
	}
	if s.SampleText == nil {
		invalidParams.Add(request.NewErrParamRequired("SampleText"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIgnoreWords sets the IgnoreWords field's value.
func (s *TestCustomDataIdentifierInput) SetIgnoreWords(v []*string) *TestCustomDataIdentifierInput {
	s.IgnoreWords = v
	return s
}

// SetKeywords sets the Keywords field's value.
func (s *TestCustomDataIdentifierInput) SetKeywords(v []*string) *TestCustomDataIdentifierInput {
	s.Keywords = v
	return s
}

// SetMaximumMatchDistance sets the MaximumMatchDistance field's value.
func (s *TestCustomDataIdentifierInput) SetMaximumMatchDistance(v int64) *TestCustomDataIdentifierInput {
	s.MaximumMatchDistance = &v
	return s
}

// SetRegex sets the Regex field's value.
func (s *TestCustomDataIdentifierInput) SetRegex(v string) *TestCustomDataIdentifierInput {
	s.Regex = &v
	return s
}

// SetSampleText sets the SampleText field's value.
func (s *TestCustomDataIdentifierInput) SetSampleText(v string) *TestCustomDataIdentifierInput {
	s.SampleText = &v
	return s
}

// Provides test results for a custom data identifier.
type TestCustomDataIdentifierOutput struct {
	_ struct{} `type:"structure"`

	MatchCount *int64 `locationName:"matchCount" type:"integer"`
}

// String returns the string representation
func (s TestCustomDataIdentifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestCustomDataIdentifierOutput) GoString() string {
	return s.String()
}

// SetMatchCount sets the MatchCount field's value.
func (s *TestCustomDataIdentifierOutput) SetMatchCount(v int64) *TestCustomDataIdentifierOutput {
	s.MatchCount = &v
	return s
}

// Provides information about an error that occurred because too many requests
// were sent during a certain amount of time.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about an account-related request that hasn't been processed.
type UnprocessedAccount struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	// The source of an error, issue, or delay. Possible values are:
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ErrorCode"`

	ErrorMessage *string `locationName:"errorMessage" type:"string"`
}

// String returns the string representation
func (s UnprocessedAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedAccount) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *UnprocessedAccount) SetAccountId(v string) *UnprocessedAccount {
	s.AccountId = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UnprocessedAccount) SetErrorCode(v string) *UnprocessedAccount {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UnprocessedAccount) SetErrorMessage(v string) *UnprocessedAccount {
	s.ErrorMessage = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

// The request succeeded. The specified tags were removed from the resource.
type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Cancels a classification job.
type UpdateClassificationJobInput struct {
	_ struct{} `type:"structure"`

	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The current status of a classification job. Possible values are:
	//
	// JobStatus is a required field
	JobStatus *string `locationName:"jobStatus" type:"string" required:"true" enum:"JobStatus"`
}

// String returns the string representation
func (s UpdateClassificationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClassificationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClassificationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClassificationJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.JobStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("JobStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *UpdateClassificationJobInput) SetJobId(v string) *UpdateClassificationJobInput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *UpdateClassificationJobInput) SetJobStatus(v string) *UpdateClassificationJobInput {
	s.JobStatus = &v
	return s
}

type UpdateClassificationJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateClassificationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClassificationJobOutput) GoString() string {
	return s.String()
}

// Specifies the criteria and other settings for a findings filter.
type UpdateFindingsFilterInput struct {
	_ struct{} `type:"structure"`

	// The action to perform on findings that meet the filter criteria. To suppress
	// (automatically archive) findings that meet the criteria, set this value to
	// ARCHIVE. Valid values are:
	Action *string `locationName:"action" type:"string" enum:"FindingsFilterAction"`

	Description *string `locationName:"description" type:"string"`

	// Specifies, as a map, one or more property-based conditions that filter the
	// results of a query for findings.
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	Name *string `locationName:"name" type:"string"`

	Position *int64 `locationName:"position" type:"integer"`
}

// String returns the string representation
func (s UpdateFindingsFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFindingsFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFindingsFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFindingsFilterInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *UpdateFindingsFilterInput) SetAction(v string) *UpdateFindingsFilterInput {
	s.Action = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFindingsFilterInput) SetDescription(v string) *UpdateFindingsFilterInput {
	s.Description = &v
	return s
}

// SetFindingCriteria sets the FindingCriteria field's value.
func (s *UpdateFindingsFilterInput) SetFindingCriteria(v *FindingCriteria) *UpdateFindingsFilterInput {
	s.FindingCriteria = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateFindingsFilterInput) SetId(v string) *UpdateFindingsFilterInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFindingsFilterInput) SetName(v string) *UpdateFindingsFilterInput {
	s.Name = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *UpdateFindingsFilterInput) SetPosition(v int64) *UpdateFindingsFilterInput {
	s.Position = &v
	return s
}

// Provides information about a findings filter that was updated in response
// to a request.
type UpdateFindingsFilterOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s UpdateFindingsFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFindingsFilterOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateFindingsFilterOutput) SetArn(v string) *UpdateFindingsFilterOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateFindingsFilterOutput) SetId(v string) *UpdateFindingsFilterOutput {
	s.Id = &v
	return s
}

// Changes the status or configuration settings for an Amazon Macie account.
type UpdateMacieSessionInput struct {
	_ struct{} `type:"structure"`

	// The frequency with which Amazon Macie publishes updates to policy findings
	// for an account. This includes publishing updates to AWS Security Hub and
	// Amazon EventBridge (formerly called Amazon CloudWatch Events). Valid values
	// are:
	FindingPublishingFrequency *string `locationName:"findingPublishingFrequency" type:"string" enum:"FindingPublishingFrequency"`

	// The status of an Amazon Macie account. Valid values are:
	Status *string `locationName:"status" type:"string" enum:"MacieStatus"`
}

// String returns the string representation
func (s UpdateMacieSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMacieSessionInput) GoString() string {
	return s.String()
}

// SetFindingPublishingFrequency sets the FindingPublishingFrequency field's value.
func (s *UpdateMacieSessionInput) SetFindingPublishingFrequency(v string) *UpdateMacieSessionInput {
	s.FindingPublishingFrequency = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateMacieSessionInput) SetStatus(v string) *UpdateMacieSessionInput {
	s.Status = &v
	return s
}

type UpdateMacieSessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateMacieSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMacieSessionOutput) GoString() string {
	return s.String()
}

// Suspends (pauses) or re-enables an Amazon Macie member account.
type UpdateMemberSessionInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The status of an Amazon Macie account. Valid values are:
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"MacieStatus"`
}

// String returns the string representation
func (s UpdateMemberSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMemberSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMemberSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMemberSessionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdateMemberSessionInput) SetId(v string) *UpdateMemberSessionInput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateMemberSessionInput) SetStatus(v string) *UpdateMemberSessionInput {
	s.Status = &v
	return s
}

type UpdateMemberSessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateMemberSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMemberSessionOutput) GoString() string {
	return s.String()
}

// Specifies whether Amazon Macie is enabled automatically for accounts that
// are added to an AWS organization.
type UpdateOrganizationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// AutoEnable is a required field
	AutoEnable *bool `locationName:"autoEnable" type:"boolean" required:"true"`
}

// String returns the string representation
func (s UpdateOrganizationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOrganizationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOrganizationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOrganizationConfigurationInput"}
	if s.AutoEnable == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoEnable"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoEnable sets the AutoEnable field's value.
func (s *UpdateOrganizationConfigurationInput) SetAutoEnable(v bool) *UpdateOrganizationConfigurationInput {
	s.AutoEnable = &v
	return s
}

type UpdateOrganizationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateOrganizationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOrganizationConfigurationOutput) GoString() string {
	return s.String()
}

// Provides data for a specific usage metric and the corresponding quota for
// an account. The value for the metric is an aggregated value that reports
// usage during the past 30 days.
type UsageByAccount struct {
	_ struct{} `type:"structure"`

	// The type of currency that data for a usage metric is reported in. Possible
	// values are:
	Currency *string `locationName:"currency" type:"string" enum:"Currency"`

	EstimatedCost *string `locationName:"estimatedCost" type:"string"`

	// Specifies a current quota for an account.
	ServiceLimit *ServiceLimit `locationName:"serviceLimit" type:"structure"`

	// The name of a usage metric for an account. Possible values are:
	Type *string `locationName:"type" type:"string" enum:"UsageType"`
}

// String returns the string representation
func (s UsageByAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UsageByAccount) GoString() string {
	return s.String()
}

// SetCurrency sets the Currency field's value.
func (s *UsageByAccount) SetCurrency(v string) *UsageByAccount {
	s.Currency = &v
	return s
}

// SetEstimatedCost sets the EstimatedCost field's value.
func (s *UsageByAccount) SetEstimatedCost(v string) *UsageByAccount {
	s.EstimatedCost = &v
	return s
}

// SetServiceLimit sets the ServiceLimit field's value.
func (s *UsageByAccount) SetServiceLimit(v *ServiceLimit) *UsageByAccount {
	s.ServiceLimit = v
	return s
}

// SetType sets the Type field's value.
func (s *UsageByAccount) SetType(v string) *UsageByAccount {
	s.Type = &v
	return s
}

// Provides quota and aggregated usage data for an account.
type UsageRecord struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	FreeTrialStartDate *time.Time `locationName:"freeTrialStartDate" type:"timestamp" timestampFormat:"iso8601"`

	Usage []*UsageByAccount `locationName:"usage" type:"list"`
}

// String returns the string representation
func (s UsageRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UsageRecord) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *UsageRecord) SetAccountId(v string) *UsageRecord {
	s.AccountId = &v
	return s
}

// SetFreeTrialStartDate sets the FreeTrialStartDate field's value.
func (s *UsageRecord) SetFreeTrialStartDate(v time.Time) *UsageRecord {
	s.FreeTrialStartDate = &v
	return s
}

// SetUsage sets the Usage field's value.
func (s *UsageRecord) SetUsage(v []*UsageByAccount) *UsageRecord {
	s.Usage = v
	return s
}

// Specifies a condition for filtering the results of a query for account quotas
// and usage data.
type UsageStatisticsFilter struct {
	_ struct{} `type:"structure"`

	// The operator to use in a condition that filters the results of a query for
	// account quotas and usage data. Valid values are:
	Comparator *string `locationName:"comparator" type:"string" enum:"UsageStatisticsFilterComparator"`

	// The field to use in a condition that filters the results of a query for account
	// quotas and usage data. Valid values are:
	Key *string `locationName:"key" type:"string" enum:"UsageStatisticsFilterKey"`

	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s UsageStatisticsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UsageStatisticsFilter) GoString() string {
	return s.String()
}

// SetComparator sets the Comparator field's value.
func (s *UsageStatisticsFilter) SetComparator(v string) *UsageStatisticsFilter {
	s.Comparator = &v
	return s
}

// SetKey sets the Key field's value.
func (s *UsageStatisticsFilter) SetKey(v string) *UsageStatisticsFilter {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *UsageStatisticsFilter) SetValues(v []*string) *UsageStatisticsFilter {
	s.Values = v
	return s
}

// Specifies criteria for sorting the results of a query for account quotas
// and usage data.
type UsageStatisticsSortBy struct {
	_ struct{} `type:"structure"`

	// The field to use to sort the results of a query for account quotas and usage
	// data. Valid values are:
	Key *string `locationName:"key" type:"string" enum:"UsageStatisticsSortKey"`

	OrderBy *string `locationName:"orderBy" type:"string" enum:"OrderBy"`
}

// String returns the string representation
func (s UsageStatisticsSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UsageStatisticsSortBy) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *UsageStatisticsSortBy) SetKey(v string) *UsageStatisticsSortBy {
	s.Key = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *UsageStatisticsSortBy) SetOrderBy(v string) *UsageStatisticsSortBy {
	s.OrderBy = &v
	return s
}

// Provides aggregated data for a usage metric. The value for the metric reports
// usage data for an account during the past 30 days.
type UsageTotal struct {
	_ struct{} `type:"structure"`

	// The type of currency that data for a usage metric is reported in. Possible
	// values are:
	Currency *string `locationName:"currency" type:"string" enum:"Currency"`

	EstimatedCost *string `locationName:"estimatedCost" type:"string"`

	// The name of a usage metric for an account. Possible values are:
	Type *string `locationName:"type" type:"string" enum:"UsageType"`
}

// String returns the string representation
func (s UsageTotal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UsageTotal) GoString() string {
	return s.String()
}

// SetCurrency sets the Currency field's value.
func (s *UsageTotal) SetCurrency(v string) *UsageTotal {
	s.Currency = &v
	return s
}

// SetEstimatedCost sets the EstimatedCost field's value.
func (s *UsageTotal) SetEstimatedCost(v string) *UsageTotal {
	s.EstimatedCost = &v
	return s
}

// SetType sets the Type field's value.
func (s *UsageTotal) SetType(v string) *UsageTotal {
	s.Type = &v
	return s
}

// Provides information about the type and other characteristics of an entity
// that performed an action on an affected resource.
type UserIdentity struct {
	_ struct{} `type:"structure"`

	// Provides information about an identity that performed an action on an affected
	// resource by using temporary security credentials. The credentials were obtained
	// using the AssumeRole operation of the AWS Security Token Service (AWS STS)
	// API.
	AssumedRole *AssumedRole `locationName:"assumedRole" type:"structure"`

	// Provides information about an AWS account and entity that performed an action
	// on an affected resource. The action was performed using the credentials for
	// an AWS account other than your own account.
	AwsAccount *AwsAccount `locationName:"awsAccount" type:"structure"`

	// Provides information about an AWS service that performed an action on an
	// affected resource.
	AwsService *AwsService `locationName:"awsService" type:"structure"`

	// Provides information about an identity that performed an action on an affected
	// resource by using temporary security credentials. The credentials were obtained
	// using the GetFederationToken operation of the AWS Security Token Service
	// (AWS STS) API.
	FederatedUser *FederatedUser `locationName:"federatedUser" type:"structure"`

	// Provides information about an AWS Identity and Access Management (IAM) user
	// who performed an action on an affected resource.
	IamUser *IamUser `locationName:"iamUser" type:"structure"`

	// Provides information about an AWS account and entity that performed an action
	// on an affected resource. The action was performed using the credentials for
	// your AWS account.
	Root *UserIdentityRoot `locationName:"root" type:"structure"`

	// The type of entity that performed the action on the affected resource. Possible
	// values are:
	Type *string `locationName:"type" type:"string" enum:"UserIdentityType"`
}

// String returns the string representation
func (s UserIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserIdentity) GoString() string {
	return s.String()
}

// SetAssumedRole sets the AssumedRole field's value.
func (s *UserIdentity) SetAssumedRole(v *AssumedRole) *UserIdentity {
	s.AssumedRole = v
	return s
}

// SetAwsAccount sets the AwsAccount field's value.
func (s *UserIdentity) SetAwsAccount(v *AwsAccount) *UserIdentity {
	s.AwsAccount = v
	return s
}

// SetAwsService sets the AwsService field's value.
func (s *UserIdentity) SetAwsService(v *AwsService) *UserIdentity {
	s.AwsService = v
	return s
}

// SetFederatedUser sets the FederatedUser field's value.
func (s *UserIdentity) SetFederatedUser(v *FederatedUser) *UserIdentity {
	s.FederatedUser = v
	return s
}

// SetIamUser sets the IamUser field's value.
func (s *UserIdentity) SetIamUser(v *IamUser) *UserIdentity {
	s.IamUser = v
	return s
}

// SetRoot sets the Root field's value.
func (s *UserIdentity) SetRoot(v *UserIdentityRoot) *UserIdentity {
	s.Root = v
	return s
}

// SetType sets the Type field's value.
func (s *UserIdentity) SetType(v string) *UserIdentity {
	s.Type = &v
	return s
}

// Provides information about an AWS account and entity that performed an action
// on an affected resource. The action was performed using the credentials for
// your AWS account.
type UserIdentityRoot struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	Arn *string `locationName:"arn" type:"string"`

	PrincipalId *string `locationName:"principalId" type:"string"`
}

// String returns the string representation
func (s UserIdentityRoot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserIdentityRoot) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *UserIdentityRoot) SetAccountId(v string) *UserIdentityRoot {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *UserIdentityRoot) SetArn(v string) *UserIdentityRoot {
	s.Arn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *UserIdentityRoot) SetPrincipalId(v string) *UserIdentityRoot {
	s.PrincipalId = &v
	return s
}

// Provides information about an error that occurred due to a syntax error in
// a request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies a weekly recurrence pattern for running a classification job.
type WeeklySchedule struct {
	_ struct{} `type:"structure"`

	DayOfWeek *string `locationName:"dayOfWeek" type:"string" enum:"DayOfWeek"`
}

// String returns the string representation
func (s WeeklySchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WeeklySchedule) GoString() string {
	return s.String()
}

// SetDayOfWeek sets the DayOfWeek field's value.
func (s *WeeklySchedule) SetDayOfWeek(v string) *WeeklySchedule {
	s.DayOfWeek = &v
	return s
}

// The current status of an account as a delegated administrator of Amazon Macie
// for an AWS organization.
const (
	// AdminStatusEnabled is a AdminStatus enum value
	AdminStatusEnabled = "ENABLED"

	// AdminStatusDisablingInProgress is a AdminStatus enum value
	AdminStatusDisablingInProgress = "DISABLING_IN_PROGRESS"
)

// AdminStatus_Values returns all elements of the AdminStatus enum
func AdminStatus_Values() []string {
	return []string{
		AdminStatusEnabled,
		AdminStatusDisablingInProgress,
	}
}

// The type of currency that data for a usage metric is reported in. Possible
// values are:
const (
	// CurrencyUsd is a Currency enum value
	CurrencyUsd = "USD"
)

// Currency_Values returns all elements of the Currency enum
func Currency_Values() []string {
	return []string{
		CurrencyUsd,
	}
}

const (
	// DayOfWeekSunday is a DayOfWeek enum value
	DayOfWeekSunday = "SUNDAY"

	// DayOfWeekMonday is a DayOfWeek enum value
	DayOfWeekMonday = "MONDAY"

	// DayOfWeekTuesday is a DayOfWeek enum value
	DayOfWeekTuesday = "TUESDAY"

	// DayOfWeekWednesday is a DayOfWeek enum value
	DayOfWeekWednesday = "WEDNESDAY"

	// DayOfWeekThursday is a DayOfWeek enum value
	DayOfWeekThursday = "THURSDAY"

	// DayOfWeekFriday is a DayOfWeek enum value
	DayOfWeekFriday = "FRIDAY"

	// DayOfWeekSaturday is a DayOfWeek enum value
	DayOfWeekSaturday = "SATURDAY"
)

// DayOfWeek_Values returns all elements of the DayOfWeek enum
func DayOfWeek_Values() []string {
	return []string{
		DayOfWeekSunday,
		DayOfWeekMonday,
		DayOfWeekTuesday,
		DayOfWeekWednesday,
		DayOfWeekThursday,
		DayOfWeekFriday,
		DayOfWeekSaturday,
	}
}

const (
	// EffectivePermissionPublic is a EffectivePermission enum value
	EffectivePermissionPublic = "PUBLIC"

	// EffectivePermissionNotPublic is a EffectivePermission enum value
	EffectivePermissionNotPublic = "NOT_PUBLIC"

	// EffectivePermissionUnknown is a EffectivePermission enum value
	EffectivePermissionUnknown = "UNKNOWN"
)

// EffectivePermission_Values returns all elements of the EffectivePermission enum
func EffectivePermission_Values() []string {
	return []string{
		EffectivePermissionPublic,
		EffectivePermissionNotPublic,
		EffectivePermissionUnknown,
	}
}

// The type of server-side encryption that's used to encrypt objects in the
// S3 bucket. Valid values are:
const (
	// EncryptionTypeNone is a EncryptionType enum value
	EncryptionTypeNone = "NONE"

	// EncryptionTypeAes256 is a EncryptionType enum value
	EncryptionTypeAes256 = "AES256"

	// EncryptionTypeAwsKms is a EncryptionType enum value
	EncryptionTypeAwsKms = "aws:kms"

	// EncryptionTypeUnknown is a EncryptionType enum value
	EncryptionTypeUnknown = "UNKNOWN"
)

// EncryptionType_Values returns all elements of the EncryptionType enum
func EncryptionType_Values() []string {
	return []string{
		EncryptionTypeNone,
		EncryptionTypeAes256,
		EncryptionTypeAwsKms,
		EncryptionTypeUnknown,
	}
}

// The source of an error, issue, or delay. Possible values are:
const (
	// ErrorCodeClientError is a ErrorCode enum value
	ErrorCodeClientError = "ClientError"

	// ErrorCodeInternalError is a ErrorCode enum value
	ErrorCodeInternalError = "InternalError"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeClientError,
		ErrorCodeInternalError,
	}
}

// The type of action that occurred for the resource and produced the policy
// finding:
const (
	// FindingActionTypeAwsApiCall is a FindingActionType enum value
	FindingActionTypeAwsApiCall = "AWS_API_CALL"
)

// FindingActionType_Values returns all elements of the FindingActionType enum
func FindingActionType_Values() []string {
	return []string{
		FindingActionTypeAwsApiCall,
	}
}

// The category of the finding. Valid values are:
const (
	// FindingCategoryClassification is a FindingCategory enum value
	FindingCategoryClassification = "CLASSIFICATION"

	// FindingCategoryPolicy is a FindingCategory enum value
	FindingCategoryPolicy = "POLICY"
)

// FindingCategory_Values returns all elements of the FindingCategory enum
func FindingCategory_Values() []string {
	return []string{
		FindingCategoryClassification,
		FindingCategoryPolicy,
	}
}

// The frequency with which Amazon Macie publishes updates to policy findings
// for an account. This includes publishing updates to AWS Security Hub and
// Amazon EventBridge (formerly called Amazon CloudWatch Events). Valid values
// are:
const (
	// FindingPublishingFrequencyFifteenMinutes is a FindingPublishingFrequency enum value
	FindingPublishingFrequencyFifteenMinutes = "FIFTEEN_MINUTES"

	// FindingPublishingFrequencyOneHour is a FindingPublishingFrequency enum value
	FindingPublishingFrequencyOneHour = "ONE_HOUR"

	// FindingPublishingFrequencySixHours is a FindingPublishingFrequency enum value
	FindingPublishingFrequencySixHours = "SIX_HOURS"
)

// FindingPublishingFrequency_Values returns all elements of the FindingPublishingFrequency enum
func FindingPublishingFrequency_Values() []string {
	return []string{
		FindingPublishingFrequencyFifteenMinutes,
		FindingPublishingFrequencyOneHour,
		FindingPublishingFrequencySixHours,
	}
}

// The grouping to sort the results by. Valid values are:
const (
	// FindingStatisticsSortAttributeNameGroupKey is a FindingStatisticsSortAttributeName enum value
	FindingStatisticsSortAttributeNameGroupKey = "groupKey"

	// FindingStatisticsSortAttributeNameCount is a FindingStatisticsSortAttributeName enum value
	FindingStatisticsSortAttributeNameCount = "count"
)

// FindingStatisticsSortAttributeName_Values returns all elements of the FindingStatisticsSortAttributeName enum
func FindingStatisticsSortAttributeName_Values() []string {
	return []string{
		FindingStatisticsSortAttributeNameGroupKey,
		FindingStatisticsSortAttributeNameCount,
	}
}

// The type of finding. Valid values are:
const (
	// FindingTypeSensitiveDataS3objectMultiple is a FindingType enum value
	FindingTypeSensitiveDataS3objectMultiple = "SensitiveData:S3Object/Multiple"

	// FindingTypeSensitiveDataS3objectFinancial is a FindingType enum value
	FindingTypeSensitiveDataS3objectFinancial = "SensitiveData:S3Object/Financial"

	// FindingTypeSensitiveDataS3objectPersonal is a FindingType enum value
	FindingTypeSensitiveDataS3objectPersonal = "SensitiveData:S3Object/Personal"

	// FindingTypeSensitiveDataS3objectCredentials is a FindingType enum value
	FindingTypeSensitiveDataS3objectCredentials = "SensitiveData:S3Object/Credentials"

	// FindingTypeSensitiveDataS3objectCustomIdentifier is a FindingType enum value
	FindingTypeSensitiveDataS3objectCustomIdentifier = "SensitiveData:S3Object/CustomIdentifier"

	// FindingTypePolicyIamuserS3bucketPublic is a FindingType enum value
	FindingTypePolicyIamuserS3bucketPublic = "Policy:IAMUser/S3BucketPublic"

	// FindingTypePolicyIamuserS3bucketSharedExternally is a FindingType enum value
	FindingTypePolicyIamuserS3bucketSharedExternally = "Policy:IAMUser/S3BucketSharedExternally"

	// FindingTypePolicyIamuserS3bucketReplicatedExternally is a FindingType enum value
	FindingTypePolicyIamuserS3bucketReplicatedExternally = "Policy:IAMUser/S3BucketReplicatedExternally"

	// FindingTypePolicyIamuserS3bucketEncryptionDisabled is a FindingType enum value
	FindingTypePolicyIamuserS3bucketEncryptionDisabled = "Policy:IAMUser/S3BucketEncryptionDisabled"

	// FindingTypePolicyIamuserS3blockPublicAccessDisabled is a FindingType enum value
	FindingTypePolicyIamuserS3blockPublicAccessDisabled = "Policy:IAMUser/S3BlockPublicAccessDisabled"
)

// FindingType_Values returns all elements of the FindingType enum
func FindingType_Values() []string {
	return []string{
		FindingTypeSensitiveDataS3objectMultiple,
		FindingTypeSensitiveDataS3objectFinancial,
		FindingTypeSensitiveDataS3objectPersonal,
		FindingTypeSensitiveDataS3objectCredentials,
		FindingTypeSensitiveDataS3objectCustomIdentifier,
		FindingTypePolicyIamuserS3bucketPublic,
		FindingTypePolicyIamuserS3bucketSharedExternally,
		FindingTypePolicyIamuserS3bucketReplicatedExternally,
		FindingTypePolicyIamuserS3bucketEncryptionDisabled,
		FindingTypePolicyIamuserS3blockPublicAccessDisabled,
	}
}

// The action to perform on findings that meet the filter criteria. To suppress
// (automatically archive) findings that meet the criteria, set this value to
// ARCHIVE. Valid values are:
const (
	// FindingsFilterActionArchive is a FindingsFilterAction enum value
	FindingsFilterActionArchive = "ARCHIVE"

	// FindingsFilterActionNoop is a FindingsFilterAction enum value
	FindingsFilterActionNoop = "NOOP"
)

// FindingsFilterAction_Values returns all elements of the FindingsFilterAction enum
func FindingsFilterAction_Values() []string {
	return []string{
		FindingsFilterActionArchive,
		FindingsFilterActionNoop,
	}
}

const (
	// GroupByResourcesAffectedS3bucketName is a GroupBy enum value
	GroupByResourcesAffectedS3bucketName = "resourcesAffected.s3Bucket.name"

	// GroupByType is a GroupBy enum value
	GroupByType = "type"

	// GroupByClassificationDetailsJobId is a GroupBy enum value
	GroupByClassificationDetailsJobId = "classificationDetails.jobId"

	// GroupBySeverityDescription is a GroupBy enum value
	GroupBySeverityDescription = "severity.description"
)

// GroupBy_Values returns all elements of the GroupBy enum
func GroupBy_Values() []string {
	return []string{
		GroupByResourcesAffectedS3bucketName,
		GroupByType,
		GroupByClassificationDetailsJobId,
		GroupBySeverityDescription,
	}
}

// The operator to use in a condition. Valid values are:
const (
	// JobComparatorEq is a JobComparator enum value
	JobComparatorEq = "EQ"

	// JobComparatorGt is a JobComparator enum value
	JobComparatorGt = "GT"

	// JobComparatorGte is a JobComparator enum value
	JobComparatorGte = "GTE"

	// JobComparatorLt is a JobComparator enum value
	JobComparatorLt = "LT"

	// JobComparatorLte is a JobComparator enum value
	JobComparatorLte = "LTE"

	// JobComparatorNe is a JobComparator enum value
	JobComparatorNe = "NE"

	// JobComparatorContains is a JobComparator enum value
	JobComparatorContains = "CONTAINS"
)

// JobComparator_Values returns all elements of the JobComparator enum
func JobComparator_Values() []string {
	return []string{
		JobComparatorEq,
		JobComparatorGt,
		JobComparatorGte,
		JobComparatorLt,
		JobComparatorLte,
		JobComparatorNe,
		JobComparatorContains,
	}
}

// The current status of a classification job. Possible values are:
const (
	// JobStatusRunning is a JobStatus enum value
	JobStatusRunning = "RUNNING"

	// JobStatusPaused is a JobStatus enum value
	JobStatusPaused = "PAUSED"

	// JobStatusCancelled is a JobStatus enum value
	JobStatusCancelled = "CANCELLED"

	// JobStatusComplete is a JobStatus enum value
	JobStatusComplete = "COMPLETE"

	// JobStatusIdle is a JobStatus enum value
	JobStatusIdle = "IDLE"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusRunning,
		JobStatusPaused,
		JobStatusCancelled,
		JobStatusComplete,
		JobStatusIdle,
	}
}

// The schedule for running a classification job. Valid values are:
const (
	// JobTypeOneTime is a JobType enum value
	JobTypeOneTime = "ONE_TIME"

	// JobTypeScheduled is a JobType enum value
	JobTypeScheduled = "SCHEDULED"
)

// JobType_Values returns all elements of the JobType enum
func JobType_Values() []string {
	return []string{
		JobTypeOneTime,
		JobTypeScheduled,
	}
}

// The property to use to filter the results. Valid values are:
const (
	// ListJobsFilterKeyJobType is a ListJobsFilterKey enum value
	ListJobsFilterKeyJobType = "jobType"

	// ListJobsFilterKeyJobStatus is a ListJobsFilterKey enum value
	ListJobsFilterKeyJobStatus = "jobStatus"

	// ListJobsFilterKeyCreatedAt is a ListJobsFilterKey enum value
	ListJobsFilterKeyCreatedAt = "createdAt"

	// ListJobsFilterKeyName is a ListJobsFilterKey enum value
	ListJobsFilterKeyName = "name"
)

// ListJobsFilterKey_Values returns all elements of the ListJobsFilterKey enum
func ListJobsFilterKey_Values() []string {
	return []string{
		ListJobsFilterKeyJobType,
		ListJobsFilterKeyJobStatus,
		ListJobsFilterKeyCreatedAt,
		ListJobsFilterKeyName,
	}
}

// The property to sort the results by. Valid values are:
const (
	// ListJobsSortAttributeNameCreatedAt is a ListJobsSortAttributeName enum value
	ListJobsSortAttributeNameCreatedAt = "createdAt"

	// ListJobsSortAttributeNameJobStatus is a ListJobsSortAttributeName enum value
	ListJobsSortAttributeNameJobStatus = "jobStatus"

	// ListJobsSortAttributeNameName is a ListJobsSortAttributeName enum value
	ListJobsSortAttributeNameName = "name"

	// ListJobsSortAttributeNameJobType is a ListJobsSortAttributeName enum value
	ListJobsSortAttributeNameJobType = "jobType"
)

// ListJobsSortAttributeName_Values returns all elements of the ListJobsSortAttributeName enum
func ListJobsSortAttributeName_Values() []string {
	return []string{
		ListJobsSortAttributeNameCreatedAt,
		ListJobsSortAttributeNameJobStatus,
		ListJobsSortAttributeNameName,
		ListJobsSortAttributeNameJobType,
	}
}

// The status of an Amazon Macie account. Valid values are:
const (
	// MacieStatusPaused is a MacieStatus enum value
	MacieStatusPaused = "PAUSED"

	// MacieStatusEnabled is a MacieStatus enum value
	MacieStatusEnabled = "ENABLED"
)

// MacieStatus_Values returns all elements of the MacieStatus enum
func MacieStatus_Values() []string {
	return []string{
		MacieStatusPaused,
		MacieStatusEnabled,
	}
}

const (
	// OrderByAsc is a OrderBy enum value
	OrderByAsc = "ASC"

	// OrderByDesc is a OrderBy enum value
	OrderByDesc = "DESC"
)

// OrderBy_Values returns all elements of the OrderBy enum
func OrderBy_Values() []string {
	return []string{
		OrderByAsc,
		OrderByDesc,
	}
}

// The current status of the relationship between an account and an associated
// Amazon Macie master account (inviter account). Possible values are:
const (
	// RelationshipStatusEnabled is a RelationshipStatus enum value
	RelationshipStatusEnabled = "Enabled"

	// RelationshipStatusPaused is a RelationshipStatus enum value
	RelationshipStatusPaused = "Paused"

	// RelationshipStatusInvited is a RelationshipStatus enum value
	RelationshipStatusInvited = "Invited"

	// RelationshipStatusCreated is a RelationshipStatus enum value
	RelationshipStatusCreated = "Created"

	// RelationshipStatusRemoved is a RelationshipStatus enum value
	RelationshipStatusRemoved = "Removed"

	// RelationshipStatusResigned is a RelationshipStatus enum value
	RelationshipStatusResigned = "Resigned"

	// RelationshipStatusEmailVerificationInProgress is a RelationshipStatus enum value
	RelationshipStatusEmailVerificationInProgress = "EmailVerificationInProgress"

	// RelationshipStatusEmailVerificationFailed is a RelationshipStatus enum value
	RelationshipStatusEmailVerificationFailed = "EmailVerificationFailed"

	// RelationshipStatusRegionDisabled is a RelationshipStatus enum value
	RelationshipStatusRegionDisabled = "RegionDisabled"

	// RelationshipStatusAccountSuspended is a RelationshipStatus enum value
	RelationshipStatusAccountSuspended = "AccountSuspended"
)

// RelationshipStatus_Values returns all elements of the RelationshipStatus enum
func RelationshipStatus_Values() []string {
	return []string{
		RelationshipStatusEnabled,
		RelationshipStatusPaused,
		RelationshipStatusInvited,
		RelationshipStatusCreated,
		RelationshipStatusRemoved,
		RelationshipStatusResigned,
		RelationshipStatusEmailVerificationInProgress,
		RelationshipStatusEmailVerificationFailed,
		RelationshipStatusRegionDisabled,
		RelationshipStatusAccountSuspended,
	}
}

// The property to use in a condition that determines which objects are analyzed
// by a classification job. Valid values are:
const (
	// ScopeFilterKeyBucketCreationDate is a ScopeFilterKey enum value
	ScopeFilterKeyBucketCreationDate = "BUCKET_CREATION_DATE"

	// ScopeFilterKeyObjectExtension is a ScopeFilterKey enum value
	ScopeFilterKeyObjectExtension = "OBJECT_EXTENSION"

	// ScopeFilterKeyObjectLastModifiedDate is a ScopeFilterKey enum value
	ScopeFilterKeyObjectLastModifiedDate = "OBJECT_LAST_MODIFIED_DATE"

	// ScopeFilterKeyObjectSize is a ScopeFilterKey enum value
	ScopeFilterKeyObjectSize = "OBJECT_SIZE"

	// ScopeFilterKeyTag is a ScopeFilterKey enum value
	ScopeFilterKeyTag = "TAG"
)

// ScopeFilterKey_Values returns all elements of the ScopeFilterKey enum
func ScopeFilterKey_Values() []string {
	return []string{
		ScopeFilterKeyBucketCreationDate,
		ScopeFilterKeyObjectExtension,
		ScopeFilterKeyObjectLastModifiedDate,
		ScopeFilterKeyObjectSize,
		ScopeFilterKeyTag,
	}
}

// The category of sensitive data that was detected and produced the finding.
// Possible values are:
const (
	// SensitiveDataItemCategoryFinancialInformation is a SensitiveDataItemCategory enum value
	SensitiveDataItemCategoryFinancialInformation = "FINANCIAL_INFORMATION"

	// SensitiveDataItemCategoryPersonalInformation is a SensitiveDataItemCategory enum value
	SensitiveDataItemCategoryPersonalInformation = "PERSONAL_INFORMATION"

	// SensitiveDataItemCategoryCredentials is a SensitiveDataItemCategory enum value
	SensitiveDataItemCategoryCredentials = "CREDENTIALS"

	// SensitiveDataItemCategoryCustomIdentifier is a SensitiveDataItemCategory enum value
	SensitiveDataItemCategoryCustomIdentifier = "CUSTOM_IDENTIFIER"
)

// SensitiveDataItemCategory_Values returns all elements of the SensitiveDataItemCategory enum
func SensitiveDataItemCategory_Values() []string {
	return []string{
		SensitiveDataItemCategoryFinancialInformation,
		SensitiveDataItemCategoryPersonalInformation,
		SensitiveDataItemCategoryCredentials,
		SensitiveDataItemCategoryCustomIdentifier,
	}
}

// The textual representation of the finding's severity. Possible values are:
const (
	// SeverityDescriptionLow is a SeverityDescription enum value
	SeverityDescriptionLow = "Low"

	// SeverityDescriptionMedium is a SeverityDescription enum value
	SeverityDescriptionMedium = "Medium"

	// SeverityDescriptionHigh is a SeverityDescription enum value
	SeverityDescriptionHigh = "High"
)

// SeverityDescription_Values returns all elements of the SeverityDescription enum
func SeverityDescription_Values() []string {
	return []string{
		SeverityDescriptionLow,
		SeverityDescriptionMedium,
		SeverityDescriptionHigh,
	}
}

const (
	// SharedAccessExternal is a SharedAccess enum value
	SharedAccessExternal = "EXTERNAL"

	// SharedAccessInternal is a SharedAccess enum value
	SharedAccessInternal = "INTERNAL"

	// SharedAccessNotShared is a SharedAccess enum value
	SharedAccessNotShared = "NOT_SHARED"

	// SharedAccessUnknown is a SharedAccess enum value
	SharedAccessUnknown = "UNKNOWN"
)

// SharedAccess_Values returns all elements of the SharedAccess enum
func SharedAccess_Values() []string {
	return []string{
		SharedAccessExternal,
		SharedAccessInternal,
		SharedAccessNotShared,
		SharedAccessUnknown,
	}
}

// The storage class of the S3 bucket or object. Possible values are:
const (
	// StorageClassStandard is a StorageClass enum value
	StorageClassStandard = "STANDARD"

	// StorageClassReducedRedundancy is a StorageClass enum value
	StorageClassReducedRedundancy = "REDUCED_REDUNDANCY"

	// StorageClassStandardIa is a StorageClass enum value
	StorageClassStandardIa = "STANDARD_IA"

	// StorageClassIntelligentTiering is a StorageClass enum value
	StorageClassIntelligentTiering = "INTELLIGENT_TIERING"

	// StorageClassDeepArchive is a StorageClass enum value
	StorageClassDeepArchive = "DEEP_ARCHIVE"

	// StorageClassOnezoneIa is a StorageClass enum value
	StorageClassOnezoneIa = "ONEZONE_IA"

	// StorageClassGlacier is a StorageClass enum value
	StorageClassGlacier = "GLACIER"
)

// StorageClass_Values returns all elements of the StorageClass enum
func StorageClass_Values() []string {
	return []string{
		StorageClassStandard,
		StorageClassReducedRedundancy,
		StorageClassStandardIa,
		StorageClassIntelligentTiering,
		StorageClassDeepArchive,
		StorageClassOnezoneIa,
		StorageClassGlacier,
	}
}

// The type of object to apply a tag-based condition to. Valid values are:
const (
	// TagTargetS3Object is a TagTarget enum value
	TagTargetS3Object = "S3_OBJECT"
)

// TagTarget_Values returns all elements of the TagTarget enum
func TagTarget_Values() []string {
	return []string{
		TagTargetS3Object,
	}
}

const (
	// UnitTerabytes is a Unit enum value
	UnitTerabytes = "TERABYTES"
)

// Unit_Values returns all elements of the Unit enum
func Unit_Values() []string {
	return []string{
		UnitTerabytes,
	}
}

// The operator to use in a condition that filters the results of a query for
// account quotas and usage data. Valid values are:
const (
	// UsageStatisticsFilterComparatorGt is a UsageStatisticsFilterComparator enum value
	UsageStatisticsFilterComparatorGt = "GT"

	// UsageStatisticsFilterComparatorGte is a UsageStatisticsFilterComparator enum value
	UsageStatisticsFilterComparatorGte = "GTE"

	// UsageStatisticsFilterComparatorLt is a UsageStatisticsFilterComparator enum value
	UsageStatisticsFilterComparatorLt = "LT"

	// UsageStatisticsFilterComparatorLte is a UsageStatisticsFilterComparator enum value
	UsageStatisticsFilterComparatorLte = "LTE"

	// UsageStatisticsFilterComparatorEq is a UsageStatisticsFilterComparator enum value
	UsageStatisticsFilterComparatorEq = "EQ"

	// UsageStatisticsFilterComparatorNe is a UsageStatisticsFilterComparator enum value
	UsageStatisticsFilterComparatorNe = "NE"

	// UsageStatisticsFilterComparatorContains is a UsageStatisticsFilterComparator enum value
	UsageStatisticsFilterComparatorContains = "CONTAINS"
)

// UsageStatisticsFilterComparator_Values returns all elements of the UsageStatisticsFilterComparator enum
func UsageStatisticsFilterComparator_Values() []string {
	return []string{
		UsageStatisticsFilterComparatorGt,
		UsageStatisticsFilterComparatorGte,
		UsageStatisticsFilterComparatorLt,
		UsageStatisticsFilterComparatorLte,
		UsageStatisticsFilterComparatorEq,
		UsageStatisticsFilterComparatorNe,
		UsageStatisticsFilterComparatorContains,
	}
}

// The field to use in a condition that filters the results of a query for account
// quotas and usage data. Valid values are:
const (
	// UsageStatisticsFilterKeyAccountId is a UsageStatisticsFilterKey enum value
	UsageStatisticsFilterKeyAccountId = "accountId"

	// UsageStatisticsFilterKeyServiceLimit is a UsageStatisticsFilterKey enum value
	UsageStatisticsFilterKeyServiceLimit = "serviceLimit"

	// UsageStatisticsFilterKeyFreeTrialStartDate is a UsageStatisticsFilterKey enum value
	UsageStatisticsFilterKeyFreeTrialStartDate = "freeTrialStartDate"

	// UsageStatisticsFilterKeyTotal is a UsageStatisticsFilterKey enum value
	UsageStatisticsFilterKeyTotal = "total"
)

// UsageStatisticsFilterKey_Values returns all elements of the UsageStatisticsFilterKey enum
func UsageStatisticsFilterKey_Values() []string {
	return []string{
		UsageStatisticsFilterKeyAccountId,
		UsageStatisticsFilterKeyServiceLimit,
		UsageStatisticsFilterKeyFreeTrialStartDate,
		UsageStatisticsFilterKeyTotal,
	}
}

// The field to use to sort the results of a query for account quotas and usage
// data. Valid values are:
const (
	// UsageStatisticsSortKeyAccountId is a UsageStatisticsSortKey enum value
	UsageStatisticsSortKeyAccountId = "accountId"

	// UsageStatisticsSortKeyTotal is a UsageStatisticsSortKey enum value
	UsageStatisticsSortKeyTotal = "total"

	// UsageStatisticsSortKeyServiceLimitValue is a UsageStatisticsSortKey enum value
	UsageStatisticsSortKeyServiceLimitValue = "serviceLimitValue"

	// UsageStatisticsSortKeyFreeTrialStartDate is a UsageStatisticsSortKey enum value
	UsageStatisticsSortKeyFreeTrialStartDate = "freeTrialStartDate"
)

// UsageStatisticsSortKey_Values returns all elements of the UsageStatisticsSortKey enum
func UsageStatisticsSortKey_Values() []string {
	return []string{
		UsageStatisticsSortKeyAccountId,
		UsageStatisticsSortKeyTotal,
		UsageStatisticsSortKeyServiceLimitValue,
		UsageStatisticsSortKeyFreeTrialStartDate,
	}
}

// The name of a usage metric for an account. Possible values are:
const (
	// UsageTypeDataInventoryEvaluation is a UsageType enum value
	UsageTypeDataInventoryEvaluation = "DATA_INVENTORY_EVALUATION"

	// UsageTypeSensitiveDataDiscovery is a UsageType enum value
	UsageTypeSensitiveDataDiscovery = "SENSITIVE_DATA_DISCOVERY"
)

// UsageType_Values returns all elements of the UsageType enum
func UsageType_Values() []string {
	return []string{
		UsageTypeDataInventoryEvaluation,
		UsageTypeSensitiveDataDiscovery,
	}
}

// The type of entity that performed the action on the affected resource. Possible
// values are:
const (
	// UserIdentityTypeAssumedRole is a UserIdentityType enum value
	UserIdentityTypeAssumedRole = "AssumedRole"

	// UserIdentityTypeIamuser is a UserIdentityType enum value
	UserIdentityTypeIamuser = "IAMUser"

	// UserIdentityTypeFederatedUser is a UserIdentityType enum value
	UserIdentityTypeFederatedUser = "FederatedUser"

	// UserIdentityTypeRoot is a UserIdentityType enum value
	UserIdentityTypeRoot = "Root"

	// UserIdentityTypeAwsaccount is a UserIdentityType enum value
	UserIdentityTypeAwsaccount = "AWSAccount"

	// UserIdentityTypeAwsservice is a UserIdentityType enum value
	UserIdentityTypeAwsservice = "AWSService"
)

// UserIdentityType_Values returns all elements of the UserIdentityType enum
func UserIdentityType_Values() []string {
	return []string{
		UserIdentityTypeAssumedRole,
		UserIdentityTypeIamuser,
		UserIdentityTypeFederatedUser,
		UserIdentityTypeRoot,
		UserIdentityTypeAwsaccount,
		UserIdentityTypeAwsservice,
	}
}
