// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/home/graph/v1/homegraph.proto

package graph

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request type for the
// [`RequestSyncDevices`](#google.home.graph.v1.HomeGraphApiService.RequestSyncDevices)
// call.
type RequestSyncDevicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Third-party user ID.
	AgentUserId string `protobuf:"bytes,1,opt,name=agent_user_id,json=agentUserId,proto3" json:"agent_user_id,omitempty"`
	// Optional. If set, the request will be added to a queue and a response will
	// be returned immediately. This enables concurrent requests for the given
	// `agent_user_id`, but the caller will not receive any error responses.
	Async bool `protobuf:"varint,2,opt,name=async,proto3" json:"async,omitempty"`
}

func (x *RequestSyncDevicesRequest) Reset() {
	*x = RequestSyncDevicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestSyncDevicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestSyncDevicesRequest) ProtoMessage() {}

func (x *RequestSyncDevicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestSyncDevicesRequest.ProtoReflect.Descriptor instead.
func (*RequestSyncDevicesRequest) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{0}
}

func (x *RequestSyncDevicesRequest) GetAgentUserId() string {
	if x != nil {
		return x.AgentUserId
	}
	return ""
}

func (x *RequestSyncDevicesRequest) GetAsync() bool {
	if x != nil {
		return x.Async
	}
	return false
}

// Response type for the
// [`RequestSyncDevices`](#google.home.graph.v1.HomeGraphApiService.RequestSyncDevices)
// call.
//
// Intentionally empty upon success. An HTTP response code is returned
// with more details upon failure.
type RequestSyncDevicesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RequestSyncDevicesResponse) Reset() {
	*x = RequestSyncDevicesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestSyncDevicesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestSyncDevicesResponse) ProtoMessage() {}

func (x *RequestSyncDevicesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestSyncDevicesResponse.ProtoReflect.Descriptor instead.
func (*RequestSyncDevicesResponse) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{1}
}

// Request type for the
// [`ReportStateAndNotification`](#google.home.graph.v1.HomeGraphApiService.ReportStateAndNotification)
// call. It may include states, notifications, or both. States and notifications
// are defined per `device_id` (for example, "123" and "456" in the following
// example).
// # Example
//
// ```json
// {
//   "requestId": "ff36a3cc-ec34-11e6-b1a0-64510650abcf",
//   "agentUserId": "1234",
//   "payload": {
//     "devices": {
//       "states": {
//         "123": {
//           "on": true
//         },
//         "456": {
//           "on": true,
//           "brightness": 10
//         }
//       },
//     }
//   }
// }
// ```
type ReportStateAndNotificationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Request ID used for debugging.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Unique identifier per event (for example, a doorbell press).
	EventId string `protobuf:"bytes,4,opt,name=event_id,json=eventId,proto3" json:"event_id,omitempty"`
	// Required. Third-party user ID.
	AgentUserId string `protobuf:"bytes,2,opt,name=agent_user_id,json=agentUserId,proto3" json:"agent_user_id,omitempty"`
	// Deprecated.
	// (-- Token to maintain state in the follow up notification response. See the
	// notifications guide at
	// https://developers.google.com/assistant/smarthome/develop/notifications for
	// details on implementing follow up notifications --)
	//
	// Deprecated: Do not use.
	FollowUpToken string `protobuf:"bytes,5,opt,name=follow_up_token,json=followUpToken,proto3" json:"follow_up_token,omitempty"`
	// Required. State of devices to update and notification metadata for devices.
	Payload *StateAndNotificationPayload `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *ReportStateAndNotificationRequest) Reset() {
	*x = ReportStateAndNotificationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportStateAndNotificationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportStateAndNotificationRequest) ProtoMessage() {}

func (x *ReportStateAndNotificationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportStateAndNotificationRequest.ProtoReflect.Descriptor instead.
func (*ReportStateAndNotificationRequest) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{2}
}

func (x *ReportStateAndNotificationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *ReportStateAndNotificationRequest) GetEventId() string {
	if x != nil {
		return x.EventId
	}
	return ""
}

func (x *ReportStateAndNotificationRequest) GetAgentUserId() string {
	if x != nil {
		return x.AgentUserId
	}
	return ""
}

// Deprecated: Do not use.
func (x *ReportStateAndNotificationRequest) GetFollowUpToken() string {
	if x != nil {
		return x.FollowUpToken
	}
	return ""
}

func (x *ReportStateAndNotificationRequest) GetPayload() *StateAndNotificationPayload {
	if x != nil {
		return x.Payload
	}
	return nil
}

// Response type for the
// [`ReportStateAndNotification`](#google.home.graph.v1.HomeGraphApiService.ReportStateAndNotification)
// call.
type ReportStateAndNotificationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Request ID copied from
	// [ReportStateAndNotificationRequest][google.home.graph.v1.ReportStateAndNotificationRequest].
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ReportStateAndNotificationResponse) Reset() {
	*x = ReportStateAndNotificationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportStateAndNotificationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportStateAndNotificationResponse) ProtoMessage() {}

func (x *ReportStateAndNotificationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportStateAndNotificationResponse.ProtoReflect.Descriptor instead.
func (*ReportStateAndNotificationResponse) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{3}
}

func (x *ReportStateAndNotificationResponse) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Payload containing the state and notification information for devices.
type StateAndNotificationPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The devices for updating state and sending notifications.
	Devices *ReportStateAndNotificationDevice `protobuf:"bytes,1,opt,name=devices,proto3" json:"devices,omitempty"`
}

func (x *StateAndNotificationPayload) Reset() {
	*x = StateAndNotificationPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StateAndNotificationPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateAndNotificationPayload) ProtoMessage() {}

func (x *StateAndNotificationPayload) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateAndNotificationPayload.ProtoReflect.Descriptor instead.
func (*StateAndNotificationPayload) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{4}
}

func (x *StateAndNotificationPayload) GetDevices() *ReportStateAndNotificationDevice {
	if x != nil {
		return x.Devices
	}
	return nil
}

// The states and notifications specific to a device.
type ReportStateAndNotificationDevice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// States of devices to update. See the **Device STATES** section
	// of the individual trait [reference
	// guides](https://developers.google.com/assistant/smarthome/traits).
	States *structpb.Struct `protobuf:"bytes,1,opt,name=states,proto3" json:"states,omitempty"`
	// Notifications metadata for devices. See the **Device NOTIFICATIONS**
	// section of the individual trait [reference
	// guides](https://developers.google.com/assistant/smarthome/traits).
	Notifications *structpb.Struct `protobuf:"bytes,2,opt,name=notifications,proto3" json:"notifications,omitempty"`
}

func (x *ReportStateAndNotificationDevice) Reset() {
	*x = ReportStateAndNotificationDevice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportStateAndNotificationDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportStateAndNotificationDevice) ProtoMessage() {}

func (x *ReportStateAndNotificationDevice) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportStateAndNotificationDevice.ProtoReflect.Descriptor instead.
func (*ReportStateAndNotificationDevice) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{5}
}

func (x *ReportStateAndNotificationDevice) GetStates() *structpb.Struct {
	if x != nil {
		return x.States
	}
	return nil
}

func (x *ReportStateAndNotificationDevice) GetNotifications() *structpb.Struct {
	if x != nil {
		return x.Notifications
	}
	return nil
}

// Request type for the
// [`DeleteAgentUser`](#google.home.graph.v1.HomeGraphApiService.DeleteAgentUser)
// call.
type DeleteAgentUserRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Request ID used for debugging.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Required. Third-party user ID.
	AgentUserId string `protobuf:"bytes,2,opt,name=agent_user_id,json=agentUserId,proto3" json:"agent_user_id,omitempty"`
}

func (x *DeleteAgentUserRequest) Reset() {
	*x = DeleteAgentUserRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAgentUserRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAgentUserRequest) ProtoMessage() {}

func (x *DeleteAgentUserRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAgentUserRequest.ProtoReflect.Descriptor instead.
func (*DeleteAgentUserRequest) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteAgentUserRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteAgentUserRequest) GetAgentUserId() string {
	if x != nil {
		return x.AgentUserId
	}
	return ""
}

// Request type for the
// [`Query`](#google.home.graph.v1.HomeGraphApiService.Query) call.
type QueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Request ID used for debugging.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Required. Third-party user ID.
	AgentUserId string `protobuf:"bytes,2,opt,name=agent_user_id,json=agentUserId,proto3" json:"agent_user_id,omitempty"`
	// Required. Inputs containing third-party device IDs for which to
	// get the device states.
	Inputs []*QueryRequestInput `protobuf:"bytes,3,rep,name=inputs,proto3" json:"inputs,omitempty"`
}

func (x *QueryRequest) Reset() {
	*x = QueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryRequest) ProtoMessage() {}

func (x *QueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryRequest.ProtoReflect.Descriptor instead.
func (*QueryRequest) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{7}
}

func (x *QueryRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *QueryRequest) GetAgentUserId() string {
	if x != nil {
		return x.AgentUserId
	}
	return ""
}

func (x *QueryRequest) GetInputs() []*QueryRequestInput {
	if x != nil {
		return x.Inputs
	}
	return nil
}

// Device ID inputs to [QueryRequest][google.home.graph.v1.QueryRequest].
type QueryRequestInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Payload containing third-party device IDs.
	Payload *QueryRequestPayload `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *QueryRequestInput) Reset() {
	*x = QueryRequestInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryRequestInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryRequestInput) ProtoMessage() {}

func (x *QueryRequestInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryRequestInput.ProtoReflect.Descriptor instead.
func (*QueryRequestInput) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{8}
}

func (x *QueryRequestInput) GetPayload() *QueryRequestPayload {
	if x != nil {
		return x.Payload
	}
	return nil
}

// Payload containing device IDs.
type QueryRequestPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Third-party device IDs for which to get the device states.
	Devices []*AgentDeviceId `protobuf:"bytes,1,rep,name=devices,proto3" json:"devices,omitempty"`
}

func (x *QueryRequestPayload) Reset() {
	*x = QueryRequestPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryRequestPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryRequestPayload) ProtoMessage() {}

func (x *QueryRequestPayload) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryRequestPayload.ProtoReflect.Descriptor instead.
func (*QueryRequestPayload) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{9}
}

func (x *QueryRequestPayload) GetDevices() []*AgentDeviceId {
	if x != nil {
		return x.Devices
	}
	return nil
}

// Third-party device ID for one device.
type AgentDeviceId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Third-party device ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *AgentDeviceId) Reset() {
	*x = AgentDeviceId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AgentDeviceId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentDeviceId) ProtoMessage() {}

func (x *AgentDeviceId) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentDeviceId.ProtoReflect.Descriptor instead.
func (*AgentDeviceId) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{10}
}

func (x *AgentDeviceId) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Response type for the
// [`Query`](#google.home.graph.v1.HomeGraphApiService.Query) call.
// This should follow the same format as the Google smart home
// `action.devices.QUERY`
// [response](https://developers.google.com/assistant/smarthome/reference/intent/query).
// # Example
//
// ```json
// {
//   "requestId": "ff36a3cc-ec34-11e6-b1a0-64510650abcf",
//   "payload": {
//     "devices": {
//       "123": {
//         "on": true,
//         "online": true
//       },
//       "456": {
//         "on": true,
//         "online": true,
//         "brightness": 80,
//         "color": {
//           "name": "cerulean",
//           "spectrumRGB": 31655
//         }
//       }
//     }
//   }
// }
// ```
type QueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Request ID used for debugging. Copied from the request.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Device states for the devices given in the request.
	Payload *QueryResponsePayload `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *QueryResponse) Reset() {
	*x = QueryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryResponse) ProtoMessage() {}

func (x *QueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryResponse.ProtoReflect.Descriptor instead.
func (*QueryResponse) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{11}
}

func (x *QueryResponse) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *QueryResponse) GetPayload() *QueryResponsePayload {
	if x != nil {
		return x.Payload
	}
	return nil
}

// Payload containing device states information.
type QueryResponsePayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// States of the devices. Map of third-party device ID to struct of device
	// states.
	Devices map[string]*structpb.Struct `protobuf:"bytes,1,rep,name=devices,proto3" json:"devices,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *QueryResponsePayload) Reset() {
	*x = QueryResponsePayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryResponsePayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryResponsePayload) ProtoMessage() {}

func (x *QueryResponsePayload) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryResponsePayload.ProtoReflect.Descriptor instead.
func (*QueryResponsePayload) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{12}
}

func (x *QueryResponsePayload) GetDevices() map[string]*structpb.Struct {
	if x != nil {
		return x.Devices
	}
	return nil
}

// Request type for the [`Sync`](#google.home.graph.v1.HomeGraphApiService.Sync)
// call.
type SyncRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Request ID used for debugging.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Required. Third-party user ID.
	AgentUserId string `protobuf:"bytes,2,opt,name=agent_user_id,json=agentUserId,proto3" json:"agent_user_id,omitempty"`
}

func (x *SyncRequest) Reset() {
	*x = SyncRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncRequest) ProtoMessage() {}

func (x *SyncRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncRequest.ProtoReflect.Descriptor instead.
func (*SyncRequest) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{13}
}

func (x *SyncRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *SyncRequest) GetAgentUserId() string {
	if x != nil {
		return x.AgentUserId
	}
	return ""
}

// Response type for the
// [`Sync`](#google.home.graph.v1.HomeGraphApiService.Sync) call.
// This should follow the same format as the Google smart home
// `action.devices.SYNC`
// [response](https://developers.google.com/assistant/smarthome/reference/intent/sync).
// # Example
//
// ```json
// {
//   "requestId": "ff36a3cc-ec34-11e6-b1a0-64510650abcf",
//   "payload": {
//     "agentUserId": "1836.15267389",
//     "devices": [{
//       "id": "123",
//       "type": "action.devices.types.OUTLET",
//       "traits": [
//         "action.devices.traits.OnOff"
//       ],
//       "name": {
//         "defaultNames": ["My Outlet 1234"],
//         "name": "Night light",
//         "nicknames": ["wall plug"]
//       },
//       "willReportState": false,
//       "deviceInfo": {
//         "manufacturer": "lights-out-inc",
//         "model": "hs1234",
//         "hwVersion": "3.2",
//         "swVersion": "11.4"
//       },
//       "customData": {
//         "fooValue": 74,
//         "barValue": true,
//         "bazValue": "foo"
//       }
//     }]
//   }
// }
// ```
type SyncResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Request ID used for debugging. Copied from the request.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Devices associated with the third-party user.
	Payload *SyncResponsePayload `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *SyncResponse) Reset() {
	*x = SyncResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncResponse) ProtoMessage() {}

func (x *SyncResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncResponse.ProtoReflect.Descriptor instead.
func (*SyncResponse) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{14}
}

func (x *SyncResponse) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *SyncResponse) GetPayload() *SyncResponsePayload {
	if x != nil {
		return x.Payload
	}
	return nil
}

// Payload containing device information.
type SyncResponsePayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Third-party user ID
	AgentUserId string `protobuf:"bytes,1,opt,name=agent_user_id,json=agentUserId,proto3" json:"agent_user_id,omitempty"`
	// Devices associated with the third-party user.
	Devices []*Device `protobuf:"bytes,2,rep,name=devices,proto3" json:"devices,omitempty"`
}

func (x *SyncResponsePayload) Reset() {
	*x = SyncResponsePayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncResponsePayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncResponsePayload) ProtoMessage() {}

func (x *SyncResponsePayload) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_graph_v1_homegraph_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncResponsePayload.ProtoReflect.Descriptor instead.
func (*SyncResponsePayload) Descriptor() ([]byte, []int) {
	return file_google_home_graph_v1_homegraph_proto_rawDescGZIP(), []int{15}
}

func (x *SyncResponsePayload) GetAgentUserId() string {
	if x != nil {
		return x.AgentUserId
	}
	return ""
}

func (x *SyncResponsePayload) GetDevices() []*Device {
	if x != nil {
		return x.Devices
	}
	return nil
}

var File_google_home_graph_v1_homegraph_proto protoreflect.FileDescriptor

var file_google_home_graph_v1_homegraph_proto_rawDesc = []byte{
	0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2f, 0x67, 0x72,
	0x61, 0x70, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x14, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68,
	0x6f, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2f, 0x67, 0x72, 0x61,
	0x70, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5f, 0x0a,
	0x19, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x79, 0x6e, 0x63, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0d, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x73, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x05, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x22, 0x1c,
	0x0a, 0x1a, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x79, 0x6e, 0x63, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x84, 0x02, 0x0a,
	0x21, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0d,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x0f, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x5f,
	0x75, 0x70, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x0d, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x55, 0x70, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x50, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65,
	0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x41,
	0x6e, 0x64, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x22, 0x43, 0x0a, 0x22, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x41, 0x6e, 0x64, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x6f, 0x0a, 0x1b, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x41, 0x6e, 0x64, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x50, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x22, 0x92, 0x01, 0x0a, 0x20, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x2f,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x12,
	0x3d, 0x0a, 0x0d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x0d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x8b,
	0x01, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x73,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x52, 0x0a, 0x0d, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x68, 0x6f, 0x6d, 0x65, 0x67, 0x72, 0x61,
	0x70, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x73, 0x65, 0x72, 0x50, 0x61, 0x74, 0x68, 0x52,
	0x0b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x22, 0x9c, 0x01, 0x0a,
	0x0c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0d,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68,
	0x6f, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x22, 0x58, 0x0a, 0x11, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x12, 0x43, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e,
	0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x07, 0x70, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x54, 0x0a, 0x13, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x3d, 0x0a, 0x07,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x49, 0x64, 0x52, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x22, 0x1f, 0x0a, 0x0d, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x74, 0x0a, 0x0d,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x07,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x22, 0xbe, 0x01, 0x0a, 0x14, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x51, 0x0a, 0x07, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x1a, 0x53,
	0x0a, 0x0c, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x2d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x55, 0x0a, 0x0b, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x12, 0x27, 0x0a, 0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x22, 0x72, 0x0a, 0x0c, 0x53, 0x79,
	0x6e, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x43, 0x0a, 0x07, 0x70, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x71,
	0x0a, 0x13, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x22, 0x0a, 0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x36, 0x0a, 0x07, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x32, 0x8c, 0x07, 0x0a, 0x13, 0x48, 0x6f, 0x6d, 0x65, 0x47, 0x72, 0x61, 0x70, 0x68, 0x41,
	0x70, 0x69, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xab, 0x01, 0x0a, 0x12, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x79, 0x6e, 0x63, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53,
	0x79, 0x6e, 0x63, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e,
	0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x53, 0x79, 0x6e, 0x63, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1c, 0x22, 0x17, 0x2f, 0x76, 0x31,
	0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x3a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x53, 0x79, 0x6e, 0x63, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x12, 0xee, 0x01, 0x0a, 0x1a, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x67, 0x72,
	0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x41, 0x6e, 0x64, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5d, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2b, 0x22, 0x26, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x3a, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x4e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x29, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x2c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x2c, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x9d, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x73, 0x65, 0x72, 0x12, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x55,
	0x73, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x2a, 0x21, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x3d, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x55, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0xda, 0x41, 0x18,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x12, 0x90, 0x01, 0x0a, 0x05, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65,
	0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x16, 0x22, 0x11, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x3a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x1f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x2c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x85, 0x01, 0x0a, 0x04,
	0x53, 0x79, 0x6e, 0x63, 0x12, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f,
	0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x6e, 0x63,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x79, 0x6e, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x36, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x15, 0x22, 0x10, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x3a, 0x73, 0x79, 0x6e, 0x63, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x18, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x1a, 0x1b, 0xca, 0x41, 0x18, 0x68, 0x6f, 0x6d, 0x65, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x42, 0xbb, 0x01, 0x0a, 0x18, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x42, 0x18, 0x48,
	0x6f, 0x6d, 0x65, 0x47, 0x72, 0x61, 0x70, 0x68, 0x41, 0x70, 0x69, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x5a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x68,
	0x6f, 0x6d, 0x65, 0x2f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2f, 0x76, 0x31, 0x3b, 0x67, 0x72, 0x61,
	0x70, 0x68, 0xea, 0x41, 0x49, 0x0a, 0x26, 0x68, 0x6f, 0x6d, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x73, 0x65, 0x72, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x55, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x3d, 0x2a, 0x2a, 0x7d, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_home_graph_v1_homegraph_proto_rawDescOnce sync.Once
	file_google_home_graph_v1_homegraph_proto_rawDescData = file_google_home_graph_v1_homegraph_proto_rawDesc
)

func file_google_home_graph_v1_homegraph_proto_rawDescGZIP() []byte {
	file_google_home_graph_v1_homegraph_proto_rawDescOnce.Do(func() {
		file_google_home_graph_v1_homegraph_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_home_graph_v1_homegraph_proto_rawDescData)
	})
	return file_google_home_graph_v1_homegraph_proto_rawDescData
}

var file_google_home_graph_v1_homegraph_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_home_graph_v1_homegraph_proto_goTypes = []interface{}{
	(*RequestSyncDevicesRequest)(nil),          // 0: google.home.graph.v1.RequestSyncDevicesRequest
	(*RequestSyncDevicesResponse)(nil),         // 1: google.home.graph.v1.RequestSyncDevicesResponse
	(*ReportStateAndNotificationRequest)(nil),  // 2: google.home.graph.v1.ReportStateAndNotificationRequest
	(*ReportStateAndNotificationResponse)(nil), // 3: google.home.graph.v1.ReportStateAndNotificationResponse
	(*StateAndNotificationPayload)(nil),        // 4: google.home.graph.v1.StateAndNotificationPayload
	(*ReportStateAndNotificationDevice)(nil),   // 5: google.home.graph.v1.ReportStateAndNotificationDevice
	(*DeleteAgentUserRequest)(nil),             // 6: google.home.graph.v1.DeleteAgentUserRequest
	(*QueryRequest)(nil),                       // 7: google.home.graph.v1.QueryRequest
	(*QueryRequestInput)(nil),                  // 8: google.home.graph.v1.QueryRequestInput
	(*QueryRequestPayload)(nil),                // 9: google.home.graph.v1.QueryRequestPayload
	(*AgentDeviceId)(nil),                      // 10: google.home.graph.v1.AgentDeviceId
	(*QueryResponse)(nil),                      // 11: google.home.graph.v1.QueryResponse
	(*QueryResponsePayload)(nil),               // 12: google.home.graph.v1.QueryResponsePayload
	(*SyncRequest)(nil),                        // 13: google.home.graph.v1.SyncRequest
	(*SyncResponse)(nil),                       // 14: google.home.graph.v1.SyncResponse
	(*SyncResponsePayload)(nil),                // 15: google.home.graph.v1.SyncResponsePayload
	nil,                                        // 16: google.home.graph.v1.QueryResponsePayload.DevicesEntry
	(*structpb.Struct)(nil),                    // 17: google.protobuf.Struct
	(*Device)(nil),                             // 18: google.home.graph.v1.Device
	(*emptypb.Empty)(nil),                      // 19: google.protobuf.Empty
}
var file_google_home_graph_v1_homegraph_proto_depIdxs = []int32{
	4,  // 0: google.home.graph.v1.ReportStateAndNotificationRequest.payload:type_name -> google.home.graph.v1.StateAndNotificationPayload
	5,  // 1: google.home.graph.v1.StateAndNotificationPayload.devices:type_name -> google.home.graph.v1.ReportStateAndNotificationDevice
	17, // 2: google.home.graph.v1.ReportStateAndNotificationDevice.states:type_name -> google.protobuf.Struct
	17, // 3: google.home.graph.v1.ReportStateAndNotificationDevice.notifications:type_name -> google.protobuf.Struct
	8,  // 4: google.home.graph.v1.QueryRequest.inputs:type_name -> google.home.graph.v1.QueryRequestInput
	9,  // 5: google.home.graph.v1.QueryRequestInput.payload:type_name -> google.home.graph.v1.QueryRequestPayload
	10, // 6: google.home.graph.v1.QueryRequestPayload.devices:type_name -> google.home.graph.v1.AgentDeviceId
	12, // 7: google.home.graph.v1.QueryResponse.payload:type_name -> google.home.graph.v1.QueryResponsePayload
	16, // 8: google.home.graph.v1.QueryResponsePayload.devices:type_name -> google.home.graph.v1.QueryResponsePayload.DevicesEntry
	15, // 9: google.home.graph.v1.SyncResponse.payload:type_name -> google.home.graph.v1.SyncResponsePayload
	18, // 10: google.home.graph.v1.SyncResponsePayload.devices:type_name -> google.home.graph.v1.Device
	17, // 11: google.home.graph.v1.QueryResponsePayload.DevicesEntry.value:type_name -> google.protobuf.Struct
	0,  // 12: google.home.graph.v1.HomeGraphApiService.RequestSyncDevices:input_type -> google.home.graph.v1.RequestSyncDevicesRequest
	2,  // 13: google.home.graph.v1.HomeGraphApiService.ReportStateAndNotification:input_type -> google.home.graph.v1.ReportStateAndNotificationRequest
	6,  // 14: google.home.graph.v1.HomeGraphApiService.DeleteAgentUser:input_type -> google.home.graph.v1.DeleteAgentUserRequest
	7,  // 15: google.home.graph.v1.HomeGraphApiService.Query:input_type -> google.home.graph.v1.QueryRequest
	13, // 16: google.home.graph.v1.HomeGraphApiService.Sync:input_type -> google.home.graph.v1.SyncRequest
	1,  // 17: google.home.graph.v1.HomeGraphApiService.RequestSyncDevices:output_type -> google.home.graph.v1.RequestSyncDevicesResponse
	3,  // 18: google.home.graph.v1.HomeGraphApiService.ReportStateAndNotification:output_type -> google.home.graph.v1.ReportStateAndNotificationResponse
	19, // 19: google.home.graph.v1.HomeGraphApiService.DeleteAgentUser:output_type -> google.protobuf.Empty
	11, // 20: google.home.graph.v1.HomeGraphApiService.Query:output_type -> google.home.graph.v1.QueryResponse
	14, // 21: google.home.graph.v1.HomeGraphApiService.Sync:output_type -> google.home.graph.v1.SyncResponse
	17, // [17:22] is the sub-list for method output_type
	12, // [12:17] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_home_graph_v1_homegraph_proto_init() }
func file_google_home_graph_v1_homegraph_proto_init() {
	if File_google_home_graph_v1_homegraph_proto != nil {
		return
	}
	file_google_home_graph_v1_device_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_home_graph_v1_homegraph_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestSyncDevicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_graph_v1_homegraph_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestSyncDevicesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_graph_v1_homegraph_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportStateAndNotificationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_graph_v1_homegraph_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportStateAndNotificationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_graph_v1_homegraph_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StateAndNotificationPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_graph_v1_homegraph_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportStateAndNotificationDevice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_graph_v1_homegraph_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAgentUserRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_graph_v1_homegraph_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_graph_v1_homegraph_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryRequestInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_graph_v1_homegraph_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryRequestPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_graph_v1_homegraph_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AgentDeviceId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_graph_v1_homegraph_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_graph_v1_homegraph_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryResponsePayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_graph_v1_homegraph_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_graph_v1_homegraph_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_graph_v1_homegraph_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncResponsePayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_home_graph_v1_homegraph_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_home_graph_v1_homegraph_proto_goTypes,
		DependencyIndexes: file_google_home_graph_v1_homegraph_proto_depIdxs,
		MessageInfos:      file_google_home_graph_v1_homegraph_proto_msgTypes,
	}.Build()
	File_google_home_graph_v1_homegraph_proto = out.File
	file_google_home_graph_v1_homegraph_proto_rawDesc = nil
	file_google_home_graph_v1_homegraph_proto_goTypes = nil
	file_google_home_graph_v1_homegraph_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// HomeGraphApiServiceClient is the client API for HomeGraphApiService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type HomeGraphApiServiceClient interface {
	// Requests Google to send an `action.devices.SYNC`
	// [intent](https://developers.google.com/assistant/smarthome/reference/intent/sync)
	// to your smart home Action to update device metadata for the given user.
	//
	//
	// The third-party user's identity is passed via the `agent_user_id`
	// (see
	// [RequestSyncDevicesRequest][google.home.graph.v1.RequestSyncDevicesRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	RequestSyncDevices(ctx context.Context, in *RequestSyncDevicesRequest, opts ...grpc.CallOption) (*RequestSyncDevicesResponse, error)
	// Reports device state and optionally sends device notifications.
	// Called by your smart home Action when the state of a third-party device
	// changes or you need to send a notification about the device.
	// See [Implement Report
	// State](https://developers.google.com/assistant/smarthome/develop/report-state)
	// for more information.
	//
	// This method updates the device state according to its declared
	// [traits](https://developers.google.com/assistant/smarthome/concepts/devices-traits).
	// Publishing a new state value outside of these traits will result in an
	// `INVALID_ARGUMENT` error response.
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see
	// [ReportStateAndNotificationRequest][google.home.graph.v1.ReportStateAndNotificationRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	ReportStateAndNotification(ctx context.Context, in *ReportStateAndNotificationRequest, opts ...grpc.CallOption) (*ReportStateAndNotificationResponse, error)
	// Unlinks the given third-party user from your smart home Action.
	// All data related to this user will be deleted.
	//
	// For more details on how users link their accounts, see
	// [fulfillment and
	// authentication](https://developers.google.com/assistant/smarthome/concepts/fulfillment-authentication).
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see
	// [DeleteAgentUserRequest][google.home.graph.v1.DeleteAgentUserRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	DeleteAgentUser(ctx context.Context, in *DeleteAgentUserRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets the current states in Home Graph for the given set of the third-party
	// user's devices.
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see [QueryRequest][google.home.graph.v1.QueryRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	Query(ctx context.Context, in *QueryRequest, opts ...grpc.CallOption) (*QueryResponse, error)
	// Gets all the devices associated with the given third-party user.
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see [SyncRequest][google.home.graph.v1.SyncRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	Sync(ctx context.Context, in *SyncRequest, opts ...grpc.CallOption) (*SyncResponse, error)
}

type homeGraphApiServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewHomeGraphApiServiceClient(cc grpc.ClientConnInterface) HomeGraphApiServiceClient {
	return &homeGraphApiServiceClient{cc}
}

func (c *homeGraphApiServiceClient) RequestSyncDevices(ctx context.Context, in *RequestSyncDevicesRequest, opts ...grpc.CallOption) (*RequestSyncDevicesResponse, error) {
	out := new(RequestSyncDevicesResponse)
	err := c.cc.Invoke(ctx, "/google.home.graph.v1.HomeGraphApiService/RequestSyncDevices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *homeGraphApiServiceClient) ReportStateAndNotification(ctx context.Context, in *ReportStateAndNotificationRequest, opts ...grpc.CallOption) (*ReportStateAndNotificationResponse, error) {
	out := new(ReportStateAndNotificationResponse)
	err := c.cc.Invoke(ctx, "/google.home.graph.v1.HomeGraphApiService/ReportStateAndNotification", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *homeGraphApiServiceClient) DeleteAgentUser(ctx context.Context, in *DeleteAgentUserRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.home.graph.v1.HomeGraphApiService/DeleteAgentUser", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *homeGraphApiServiceClient) Query(ctx context.Context, in *QueryRequest, opts ...grpc.CallOption) (*QueryResponse, error) {
	out := new(QueryResponse)
	err := c.cc.Invoke(ctx, "/google.home.graph.v1.HomeGraphApiService/Query", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *homeGraphApiServiceClient) Sync(ctx context.Context, in *SyncRequest, opts ...grpc.CallOption) (*SyncResponse, error) {
	out := new(SyncResponse)
	err := c.cc.Invoke(ctx, "/google.home.graph.v1.HomeGraphApiService/Sync", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HomeGraphApiServiceServer is the server API for HomeGraphApiService service.
type HomeGraphApiServiceServer interface {
	// Requests Google to send an `action.devices.SYNC`
	// [intent](https://developers.google.com/assistant/smarthome/reference/intent/sync)
	// to your smart home Action to update device metadata for the given user.
	//
	//
	// The third-party user's identity is passed via the `agent_user_id`
	// (see
	// [RequestSyncDevicesRequest][google.home.graph.v1.RequestSyncDevicesRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	RequestSyncDevices(context.Context, *RequestSyncDevicesRequest) (*RequestSyncDevicesResponse, error)
	// Reports device state and optionally sends device notifications.
	// Called by your smart home Action when the state of a third-party device
	// changes or you need to send a notification about the device.
	// See [Implement Report
	// State](https://developers.google.com/assistant/smarthome/develop/report-state)
	// for more information.
	//
	// This method updates the device state according to its declared
	// [traits](https://developers.google.com/assistant/smarthome/concepts/devices-traits).
	// Publishing a new state value outside of these traits will result in an
	// `INVALID_ARGUMENT` error response.
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see
	// [ReportStateAndNotificationRequest][google.home.graph.v1.ReportStateAndNotificationRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	ReportStateAndNotification(context.Context, *ReportStateAndNotificationRequest) (*ReportStateAndNotificationResponse, error)
	// Unlinks the given third-party user from your smart home Action.
	// All data related to this user will be deleted.
	//
	// For more details on how users link their accounts, see
	// [fulfillment and
	// authentication](https://developers.google.com/assistant/smarthome/concepts/fulfillment-authentication).
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see
	// [DeleteAgentUserRequest][google.home.graph.v1.DeleteAgentUserRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	DeleteAgentUser(context.Context, *DeleteAgentUserRequest) (*emptypb.Empty, error)
	// Gets the current states in Home Graph for the given set of the third-party
	// user's devices.
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see [QueryRequest][google.home.graph.v1.QueryRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	Query(context.Context, *QueryRequest) (*QueryResponse, error)
	// Gets all the devices associated with the given third-party user.
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see [SyncRequest][google.home.graph.v1.SyncRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	Sync(context.Context, *SyncRequest) (*SyncResponse, error)
}

// UnimplementedHomeGraphApiServiceServer can be embedded to have forward compatible implementations.
type UnimplementedHomeGraphApiServiceServer struct {
}

func (*UnimplementedHomeGraphApiServiceServer) RequestSyncDevices(context.Context, *RequestSyncDevicesRequest) (*RequestSyncDevicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RequestSyncDevices not implemented")
}
func (*UnimplementedHomeGraphApiServiceServer) ReportStateAndNotification(context.Context, *ReportStateAndNotificationRequest) (*ReportStateAndNotificationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportStateAndNotification not implemented")
}
func (*UnimplementedHomeGraphApiServiceServer) DeleteAgentUser(context.Context, *DeleteAgentUserRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAgentUser not implemented")
}
func (*UnimplementedHomeGraphApiServiceServer) Query(context.Context, *QueryRequest) (*QueryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Query not implemented")
}
func (*UnimplementedHomeGraphApiServiceServer) Sync(context.Context, *SyncRequest) (*SyncResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Sync not implemented")
}

func RegisterHomeGraphApiServiceServer(s *grpc.Server, srv HomeGraphApiServiceServer) {
	s.RegisterService(&_HomeGraphApiService_serviceDesc, srv)
}

func _HomeGraphApiService_RequestSyncDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RequestSyncDevicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HomeGraphApiServiceServer).RequestSyncDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.graph.v1.HomeGraphApiService/RequestSyncDevices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HomeGraphApiServiceServer).RequestSyncDevices(ctx, req.(*RequestSyncDevicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HomeGraphApiService_ReportStateAndNotification_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportStateAndNotificationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HomeGraphApiServiceServer).ReportStateAndNotification(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.graph.v1.HomeGraphApiService/ReportStateAndNotification",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HomeGraphApiServiceServer).ReportStateAndNotification(ctx, req.(*ReportStateAndNotificationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HomeGraphApiService_DeleteAgentUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAgentUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HomeGraphApiServiceServer).DeleteAgentUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.graph.v1.HomeGraphApiService/DeleteAgentUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HomeGraphApiServiceServer).DeleteAgentUser(ctx, req.(*DeleteAgentUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HomeGraphApiService_Query_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HomeGraphApiServiceServer).Query(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.graph.v1.HomeGraphApiService/Query",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HomeGraphApiServiceServer).Query(ctx, req.(*QueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HomeGraphApiService_Sync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SyncRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HomeGraphApiServiceServer).Sync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.graph.v1.HomeGraphApiService/Sync",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HomeGraphApiServiceServer).Sync(ctx, req.(*SyncRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HomeGraphApiService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.home.graph.v1.HomeGraphApiService",
	HandlerType: (*HomeGraphApiServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RequestSyncDevices",
			Handler:    _HomeGraphApiService_RequestSyncDevices_Handler,
		},
		{
			MethodName: "ReportStateAndNotification",
			Handler:    _HomeGraphApiService_ReportStateAndNotification_Handler,
		},
		{
			MethodName: "DeleteAgentUser",
			Handler:    _HomeGraphApiService_DeleteAgentUser_Handler,
		},
		{
			MethodName: "Query",
			Handler:    _HomeGraphApiService_Query_Handler,
		},
		{
			MethodName: "Sync",
			Handler:    _HomeGraphApiService_Sync_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/home/graph/v1/homegraph.proto",
}
