package insights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// PrivateLinkScopeOperationStatusClient is the monitor Management Client
type PrivateLinkScopeOperationStatusClient struct {
	BaseClient
}

// NewPrivateLinkScopeOperationStatusClient creates an instance of the PrivateLinkScopeOperationStatusClient client.
func NewPrivateLinkScopeOperationStatusClient(subscriptionID string) PrivateLinkScopeOperationStatusClient {
	return NewPrivateLinkScopeOperationStatusClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewPrivateLinkScopeOperationStatusClientWithBaseURI creates an instance of the PrivateLinkScopeOperationStatusClient
// client using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI
// (sovereign clouds, Azure stack).
func NewPrivateLinkScopeOperationStatusClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkScopeOperationStatusClient {
	return PrivateLinkScopeOperationStatusClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get the status of an azure asynchronous operation associated with a private link scope operation.
// Parameters:
// asyncOperationID - the operation Id.
// resourceGroupName - the name of the resource group.
func (client PrivateLinkScopeOperationStatusClient) Get(ctx context.Context, asyncOperationID string, resourceGroupName string) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkScopeOperationStatusClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("insights.PrivateLinkScopeOperationStatusClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, asyncOperationID, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.PrivateLinkScopeOperationStatusClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "insights.PrivateLinkScopeOperationStatusClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.PrivateLinkScopeOperationStatusClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client PrivateLinkScopeOperationStatusClient) GetPreparer(ctx context.Context, asyncOperationID string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"asyncOperationId":  autorest.Encode("path", asyncOperationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-10-17-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/privateLinkScopeOperationStatuses/{asyncOperationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client PrivateLinkScopeOperationStatusClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client PrivateLinkScopeOperationStatusClient) GetResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
