// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatch

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opDeleteAlarms = "DeleteAlarms"

// DeleteAlarmsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlarms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlarms for more information on using the DeleteAlarms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAlarmsRequest method.
//    req, resp := client.DeleteAlarmsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteAlarms
func (c *CloudWatch) DeleteAlarmsRequest(input *DeleteAlarmsInput) (req *request.Request, output *DeleteAlarmsOutput) {
	op := &request.Operation{
		Name:       opDeleteAlarms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAlarmsInput{}
	}

	output = &DeleteAlarmsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlarms API operation for Amazon CloudWatch.
//
// Deletes the specified alarms. In the event of an error, no alarms are deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DeleteAlarms for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFound "ResourceNotFound"
//   The named resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteAlarms
func (c *CloudWatch) DeleteAlarms(input *DeleteAlarmsInput) (*DeleteAlarmsOutput, error) {
	req, out := c.DeleteAlarmsRequest(input)
	return out, req.Send()
}

// DeleteAlarmsWithContext is the same as DeleteAlarms with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlarms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DeleteAlarmsWithContext(ctx aws.Context, input *DeleteAlarmsInput, opts ...request.Option) (*DeleteAlarmsOutput, error) {
	req, out := c.DeleteAlarmsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDashboards = "DeleteDashboards"

// DeleteDashboardsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDashboards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDashboards for more information on using the DeleteDashboards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDashboardsRequest method.
//    req, resp := client.DeleteDashboardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteDashboards
func (c *CloudWatch) DeleteDashboardsRequest(input *DeleteDashboardsInput) (req *request.Request, output *DeleteDashboardsOutput) {
	op := &request.Operation{
		Name:       opDeleteDashboards,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDashboardsInput{}
	}

	output = &DeleteDashboardsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDashboards API operation for Amazon CloudWatch.
//
// Deletes all dashboards that you specify. You may specify up to 100 dashboards
// to delete. If there is an error during this call, no dashboards are deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DeleteDashboards for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value of an input parameter is bad or out-of-range.
//
//   * ErrCodeDashboardNotFoundError "ResourceNotFound"
//   The specified dashboard does not exist.
//
//   * ErrCodeInternalServiceFault "InternalServiceError"
//   Request processing has failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteDashboards
func (c *CloudWatch) DeleteDashboards(input *DeleteDashboardsInput) (*DeleteDashboardsOutput, error) {
	req, out := c.DeleteDashboardsRequest(input)
	return out, req.Send()
}

// DeleteDashboardsWithContext is the same as DeleteDashboards with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDashboards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DeleteDashboardsWithContext(ctx aws.Context, input *DeleteDashboardsInput, opts ...request.Option) (*DeleteDashboardsOutput, error) {
	req, out := c.DeleteDashboardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAlarmHistory = "DescribeAlarmHistory"

// DescribeAlarmHistoryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlarmHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlarmHistory for more information on using the DescribeAlarmHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAlarmHistoryRequest method.
//    req, resp := client.DescribeAlarmHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmHistory
func (c *CloudWatch) DescribeAlarmHistoryRequest(input *DescribeAlarmHistoryInput) (req *request.Request, output *DescribeAlarmHistoryOutput) {
	op := &request.Operation{
		Name:       opDescribeAlarmHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAlarmHistoryInput{}
	}

	output = &DescribeAlarmHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlarmHistory API operation for Amazon CloudWatch.
//
// Retrieves the history for the specified alarm. You can filter the results
// by date range or item type. If an alarm name is not specified, the histories
// for all alarms are returned.
//
// CloudWatch retains the history of an alarm even if you delete the alarm.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DescribeAlarmHistory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The next token specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmHistory
func (c *CloudWatch) DescribeAlarmHistory(input *DescribeAlarmHistoryInput) (*DescribeAlarmHistoryOutput, error) {
	req, out := c.DescribeAlarmHistoryRequest(input)
	return out, req.Send()
}

// DescribeAlarmHistoryWithContext is the same as DescribeAlarmHistory with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlarmHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAlarmHistoryWithContext(ctx aws.Context, input *DescribeAlarmHistoryInput, opts ...request.Option) (*DescribeAlarmHistoryOutput, error) {
	req, out := c.DescribeAlarmHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAlarmHistoryPages iterates over the pages of a DescribeAlarmHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAlarmHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAlarmHistory operation.
//    pageNum := 0
//    err := client.DescribeAlarmHistoryPages(params,
//        func(page *DescribeAlarmHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudWatch) DescribeAlarmHistoryPages(input *DescribeAlarmHistoryInput, fn func(*DescribeAlarmHistoryOutput, bool) bool) error {
	return c.DescribeAlarmHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAlarmHistoryPagesWithContext same as DescribeAlarmHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAlarmHistoryPagesWithContext(ctx aws.Context, input *DescribeAlarmHistoryInput, fn func(*DescribeAlarmHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAlarmHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAlarmHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeAlarmHistoryOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeAlarms = "DescribeAlarms"

// DescribeAlarmsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlarms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlarms for more information on using the DescribeAlarms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAlarmsRequest method.
//    req, resp := client.DescribeAlarmsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarms
func (c *CloudWatch) DescribeAlarmsRequest(input *DescribeAlarmsInput) (req *request.Request, output *DescribeAlarmsOutput) {
	op := &request.Operation{
		Name:       opDescribeAlarms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAlarmsInput{}
	}

	output = &DescribeAlarmsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlarms API operation for Amazon CloudWatch.
//
// Retrieves the specified alarms. If no alarms are specified, all alarms are
// returned. Alarms can be retrieved by using only a prefix for the alarm name,
// the alarm state, or a prefix for any action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DescribeAlarms for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The next token specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarms
func (c *CloudWatch) DescribeAlarms(input *DescribeAlarmsInput) (*DescribeAlarmsOutput, error) {
	req, out := c.DescribeAlarmsRequest(input)
	return out, req.Send()
}

// DescribeAlarmsWithContext is the same as DescribeAlarms with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlarms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAlarmsWithContext(ctx aws.Context, input *DescribeAlarmsInput, opts ...request.Option) (*DescribeAlarmsOutput, error) {
	req, out := c.DescribeAlarmsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAlarmsPages iterates over the pages of a DescribeAlarms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAlarms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAlarms operation.
//    pageNum := 0
//    err := client.DescribeAlarmsPages(params,
//        func(page *DescribeAlarmsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudWatch) DescribeAlarmsPages(input *DescribeAlarmsInput, fn func(*DescribeAlarmsOutput, bool) bool) error {
	return c.DescribeAlarmsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAlarmsPagesWithContext same as DescribeAlarmsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAlarmsPagesWithContext(ctx aws.Context, input *DescribeAlarmsInput, fn func(*DescribeAlarmsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAlarmsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAlarmsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeAlarmsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeAlarmsForMetric = "DescribeAlarmsForMetric"

// DescribeAlarmsForMetricRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlarmsForMetric operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlarmsForMetric for more information on using the DescribeAlarmsForMetric
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAlarmsForMetricRequest method.
//    req, resp := client.DescribeAlarmsForMetricRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmsForMetric
func (c *CloudWatch) DescribeAlarmsForMetricRequest(input *DescribeAlarmsForMetricInput) (req *request.Request, output *DescribeAlarmsForMetricOutput) {
	op := &request.Operation{
		Name:       opDescribeAlarmsForMetric,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAlarmsForMetricInput{}
	}

	output = &DescribeAlarmsForMetricOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlarmsForMetric API operation for Amazon CloudWatch.
//
// Retrieves the alarms for the specified metric. To filter the results, specify
// a statistic, period, or unit.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DescribeAlarmsForMetric for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmsForMetric
func (c *CloudWatch) DescribeAlarmsForMetric(input *DescribeAlarmsForMetricInput) (*DescribeAlarmsForMetricOutput, error) {
	req, out := c.DescribeAlarmsForMetricRequest(input)
	return out, req.Send()
}

// DescribeAlarmsForMetricWithContext is the same as DescribeAlarmsForMetric with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlarmsForMetric for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAlarmsForMetricWithContext(ctx aws.Context, input *DescribeAlarmsForMetricInput, opts ...request.Option) (*DescribeAlarmsForMetricOutput, error) {
	req, out := c.DescribeAlarmsForMetricRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableAlarmActions = "DisableAlarmActions"

// DisableAlarmActionsRequest generates a "aws/request.Request" representing the
// client's request for the DisableAlarmActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableAlarmActions for more information on using the DisableAlarmActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableAlarmActionsRequest method.
//    req, resp := client.DisableAlarmActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DisableAlarmActions
func (c *CloudWatch) DisableAlarmActionsRequest(input *DisableAlarmActionsInput) (req *request.Request, output *DisableAlarmActionsOutput) {
	op := &request.Operation{
		Name:       opDisableAlarmActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableAlarmActionsInput{}
	}

	output = &DisableAlarmActionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableAlarmActions API operation for Amazon CloudWatch.
//
// Disables the actions for the specified alarms. When an alarm's actions are
// disabled, the alarm actions do not execute when the alarm state changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DisableAlarmActions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DisableAlarmActions
func (c *CloudWatch) DisableAlarmActions(input *DisableAlarmActionsInput) (*DisableAlarmActionsOutput, error) {
	req, out := c.DisableAlarmActionsRequest(input)
	return out, req.Send()
}

// DisableAlarmActionsWithContext is the same as DisableAlarmActions with the addition of
// the ability to pass a context and additional request options.
//
// See DisableAlarmActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DisableAlarmActionsWithContext(ctx aws.Context, input *DisableAlarmActionsInput, opts ...request.Option) (*DisableAlarmActionsOutput, error) {
	req, out := c.DisableAlarmActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableAlarmActions = "EnableAlarmActions"

// EnableAlarmActionsRequest generates a "aws/request.Request" representing the
// client's request for the EnableAlarmActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableAlarmActions for more information on using the EnableAlarmActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableAlarmActionsRequest method.
//    req, resp := client.EnableAlarmActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/EnableAlarmActions
func (c *CloudWatch) EnableAlarmActionsRequest(input *EnableAlarmActionsInput) (req *request.Request, output *EnableAlarmActionsOutput) {
	op := &request.Operation{
		Name:       opEnableAlarmActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableAlarmActionsInput{}
	}

	output = &EnableAlarmActionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableAlarmActions API operation for Amazon CloudWatch.
//
// Enables the actions for the specified alarms.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation EnableAlarmActions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/EnableAlarmActions
func (c *CloudWatch) EnableAlarmActions(input *EnableAlarmActionsInput) (*EnableAlarmActionsOutput, error) {
	req, out := c.EnableAlarmActionsRequest(input)
	return out, req.Send()
}

// EnableAlarmActionsWithContext is the same as EnableAlarmActions with the addition of
// the ability to pass a context and additional request options.
//
// See EnableAlarmActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) EnableAlarmActionsWithContext(ctx aws.Context, input *EnableAlarmActionsInput, opts ...request.Option) (*EnableAlarmActionsOutput, error) {
	req, out := c.EnableAlarmActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDashboard = "GetDashboard"

// GetDashboardRequest generates a "aws/request.Request" representing the
// client's request for the GetDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDashboard for more information on using the GetDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDashboardRequest method.
//    req, resp := client.GetDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetDashboard
func (c *CloudWatch) GetDashboardRequest(input *GetDashboardInput) (req *request.Request, output *GetDashboardOutput) {
	op := &request.Operation{
		Name:       opGetDashboard,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDashboardInput{}
	}

	output = &GetDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDashboard API operation for Amazon CloudWatch.
//
// Displays the details of the dashboard that you specify.
//
// To copy an existing dashboard, use GetDashboard, and then use the data returned
// within DashboardBody as the template for the new dashboard when you call
// PutDashboard to create the copy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation GetDashboard for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value of an input parameter is bad or out-of-range.
//
//   * ErrCodeDashboardNotFoundError "ResourceNotFound"
//   The specified dashboard does not exist.
//
//   * ErrCodeInternalServiceFault "InternalServiceError"
//   Request processing has failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetDashboard
func (c *CloudWatch) GetDashboard(input *GetDashboardInput) (*GetDashboardOutput, error) {
	req, out := c.GetDashboardRequest(input)
	return out, req.Send()
}

// GetDashboardWithContext is the same as GetDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See GetDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) GetDashboardWithContext(ctx aws.Context, input *GetDashboardInput, opts ...request.Option) (*GetDashboardOutput, error) {
	req, out := c.GetDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMetricData = "GetMetricData"

// GetMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMetricData for more information on using the GetMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMetricDataRequest method.
//    req, resp := client.GetMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricData
func (c *CloudWatch) GetMetricDataRequest(input *GetMetricDataInput) (req *request.Request, output *GetMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMetricDataInput{}
	}

	output = &GetMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMetricData API operation for Amazon CloudWatch.
//
// You can use the GetMetricData API to retrieve as many as 100 different metrics
// in a single request, with a total of as many as 100,800 datapoints. You can
// also optionally perform math expressions on the values of the returned statistics,
// to create new time series that represent new insights into your data. For
// example, using Lambda metrics, you could divide the Errors metric by the
// Invocations metric to get an error rate time series. For more information
// about metric math expressions, see Metric Math Syntax and Functions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax)
// in the Amazon CloudWatch User Guide.
//
// Calls to the GetMetricData API have a different pricing structure than calls
// to GetMetricStatistics. For more information about pricing, see Amazon CloudWatch
// Pricing (https://aws.amazon.com/cloudwatch/pricing/).
//
// Amazon CloudWatch retains metric data as follows:
//
//    * Data points with a period of less than 60 seconds are available for
//    3 hours. These data points are high-resolution metrics and are available
//    only for custom metrics that have been defined with a StorageResolution
//    of 1.
//
//    * Data points with a period of 60 seconds (1-minute) are available for
//    15 days.
//
//    * Data points with a period of 300 seconds (5-minute) are available for
//    63 days.
//
//    * Data points with a period of 3600 seconds (1 hour) are available for
//    455 days (15 months).
//
// Data points that are initially published with a shorter period are aggregated
// together for long-term storage. For example, if you collect data using a
// period of 1 minute, the data remains available for 15 days with 1-minute
// resolution. After 15 days, this data is still available, but is aggregated
// and retrievable only with a resolution of 5 minutes. After 63 days, the data
// is further aggregated and is available with a resolution of 1 hour.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation GetMetricData for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The next token specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricData
func (c *CloudWatch) GetMetricData(input *GetMetricDataInput) (*GetMetricDataOutput, error) {
	req, out := c.GetMetricDataRequest(input)
	return out, req.Send()
}

// GetMetricDataWithContext is the same as GetMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) GetMetricDataWithContext(ctx aws.Context, input *GetMetricDataInput, opts ...request.Option) (*GetMetricDataOutput, error) {
	req, out := c.GetMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMetricStatistics = "GetMetricStatistics"

// GetMetricStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetMetricStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMetricStatistics for more information on using the GetMetricStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMetricStatisticsRequest method.
//    req, resp := client.GetMetricStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricStatistics
func (c *CloudWatch) GetMetricStatisticsRequest(input *GetMetricStatisticsInput) (req *request.Request, output *GetMetricStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetMetricStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMetricStatisticsInput{}
	}

	output = &GetMetricStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMetricStatistics API operation for Amazon CloudWatch.
//
// Gets statistics for the specified metric.
//
// The maximum number of data points returned from a single call is 1,440. If
// you request more than 1,440 data points, CloudWatch returns an error. To
// reduce the number of data points, you can narrow the specified time range
// and make multiple requests across adjacent time ranges, or you can increase
// the specified period. Data points are not returned in chronological order.
//
// CloudWatch aggregates data points based on the length of the period that
// you specify. For example, if you request statistics with a one-hour period,
// CloudWatch aggregates all data points with time stamps that fall within each
// one-hour period. Therefore, the number of values aggregated by CloudWatch
// is larger than the number of data points returned.
//
// CloudWatch needs raw data points to calculate percentile statistics. If you
// publish data using a statistic set instead, you can only retrieve percentile
// statistics for this data if one of the following conditions is true:
//
//    * The SampleCount value of the statistic set is 1.
//
//    * The Min and the Max values of the statistic set are equal.
//
// Percentile statistics are not available for metrics when any of the metric
// values are negative numbers.
//
// Amazon CloudWatch retains metric data as follows:
//
//    * Data points with a period of less than 60 seconds are available for
//    3 hours. These data points are high-resolution metrics and are available
//    only for custom metrics that have been defined with a StorageResolution
//    of 1.
//
//    * Data points with a period of 60 seconds (1-minute) are available for
//    15 days.
//
//    * Data points with a period of 300 seconds (5-minute) are available for
//    63 days.
//
//    * Data points with a period of 3600 seconds (1 hour) are available for
//    455 days (15 months).
//
// Data points that are initially published with a shorter period are aggregated
// together for long-term storage. For example, if you collect data using a
// period of 1 minute, the data remains available for 15 days with 1-minute
// resolution. After 15 days, this data is still available, but is aggregated
// and retrievable only with a resolution of 5 minutes. After 63 days, the data
// is further aggregated and is available with a resolution of 1 hour.
//
// CloudWatch started retaining 5-minute and 1-hour metric data as of July 9,
// 2016.
//
// For information about metrics and dimensions supported by AWS services, see
// the Amazon CloudWatch Metrics and Dimensions Reference (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CW_Support_For_AWS.html)
// in the Amazon CloudWatch User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation GetMetricStatistics for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value of an input parameter is bad or out-of-range.
//
//   * ErrCodeMissingRequiredParameterException "MissingParameter"
//   An input parameter that is required is missing.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Parameters were used together that cannot be used together.
//
//   * ErrCodeInternalServiceFault "InternalServiceError"
//   Request processing has failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricStatistics
func (c *CloudWatch) GetMetricStatistics(input *GetMetricStatisticsInput) (*GetMetricStatisticsOutput, error) {
	req, out := c.GetMetricStatisticsRequest(input)
	return out, req.Send()
}

// GetMetricStatisticsWithContext is the same as GetMetricStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetMetricStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) GetMetricStatisticsWithContext(ctx aws.Context, input *GetMetricStatisticsInput, opts ...request.Option) (*GetMetricStatisticsOutput, error) {
	req, out := c.GetMetricStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMetricWidgetImage = "GetMetricWidgetImage"

// GetMetricWidgetImageRequest generates a "aws/request.Request" representing the
// client's request for the GetMetricWidgetImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMetricWidgetImage for more information on using the GetMetricWidgetImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMetricWidgetImageRequest method.
//    req, resp := client.GetMetricWidgetImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricWidgetImage
func (c *CloudWatch) GetMetricWidgetImageRequest(input *GetMetricWidgetImageInput) (req *request.Request, output *GetMetricWidgetImageOutput) {
	op := &request.Operation{
		Name:       opGetMetricWidgetImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMetricWidgetImageInput{}
	}

	output = &GetMetricWidgetImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMetricWidgetImage API operation for Amazon CloudWatch.
//
// You can use the GetMetricWidgetImage API to retrieve a snapshot graph of
// one or more Amazon CloudWatch metrics as a bitmap image. You can then embed
// this image into your services and products, such as wiki pages, reports,
// and documents. You could also retrieve images regularly, such as every minute,
// and create your own custom live dashboard.
//
// The graph you retrieve can include all CloudWatch metric graph features,
// including metric math and horizontal and vertical annotations.
//
// There is a limit of 20 transactions per second for this API. Each GetMetricWidgetImage
// action has the following limits:
//
//    * As many as 100 metrics in the graph.
//
//    * Up to 100 KB uncompressed payload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation GetMetricWidgetImage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricWidgetImage
func (c *CloudWatch) GetMetricWidgetImage(input *GetMetricWidgetImageInput) (*GetMetricWidgetImageOutput, error) {
	req, out := c.GetMetricWidgetImageRequest(input)
	return out, req.Send()
}

// GetMetricWidgetImageWithContext is the same as GetMetricWidgetImage with the addition of
// the ability to pass a context and additional request options.
//
// See GetMetricWidgetImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) GetMetricWidgetImageWithContext(ctx aws.Context, input *GetMetricWidgetImageInput, opts ...request.Option) (*GetMetricWidgetImageOutput, error) {
	req, out := c.GetMetricWidgetImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDashboards = "ListDashboards"

// ListDashboardsRequest generates a "aws/request.Request" representing the
// client's request for the ListDashboards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDashboards for more information on using the ListDashboards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDashboardsRequest method.
//    req, resp := client.ListDashboardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListDashboards
func (c *CloudWatch) ListDashboardsRequest(input *ListDashboardsInput) (req *request.Request, output *ListDashboardsOutput) {
	op := &request.Operation{
		Name:       opListDashboards,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDashboardsInput{}
	}

	output = &ListDashboardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDashboards API operation for Amazon CloudWatch.
//
// Returns a list of the dashboards for your account. If you include DashboardNamePrefix,
// only those dashboards with names starting with the prefix are listed. Otherwise,
// all dashboards in your account are listed.
//
// ListDashboards returns up to 1000 results on one page. If there are more
// than 1000 dashboards, you can call ListDashboards again and include the value
// you received for NextToken in the first call, to receive the next 1000 results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation ListDashboards for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value of an input parameter is bad or out-of-range.
//
//   * ErrCodeInternalServiceFault "InternalServiceError"
//   Request processing has failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListDashboards
func (c *CloudWatch) ListDashboards(input *ListDashboardsInput) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	return out, req.Send()
}

// ListDashboardsWithContext is the same as ListDashboards with the addition of
// the ability to pass a context and additional request options.
//
// See ListDashboards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) ListDashboardsWithContext(ctx aws.Context, input *ListDashboardsInput, opts ...request.Option) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMetrics = "ListMetrics"

// ListMetricsRequest generates a "aws/request.Request" representing the
// client's request for the ListMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMetrics for more information on using the ListMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMetricsRequest method.
//    req, resp := client.ListMetricsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListMetrics
func (c *CloudWatch) ListMetricsRequest(input *ListMetricsInput) (req *request.Request, output *ListMetricsOutput) {
	op := &request.Operation{
		Name:       opListMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMetricsInput{}
	}

	output = &ListMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMetrics API operation for Amazon CloudWatch.
//
// List the specified metrics. You can use the returned metrics with GetMetricData
// or GetMetricStatistics to obtain statistical data.
//
// Up to 500 results are returned for any one call. To retrieve additional results,
// use the returned token with subsequent calls.
//
// After you create a metric, allow up to fifteen minutes before the metric
// appears. Statistics about the metric, however, are available sooner using
// GetMetricData or GetMetricStatistics.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation ListMetrics for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceFault "InternalServiceError"
//   Request processing has failed due to some unknown error, exception, or failure.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value of an input parameter is bad or out-of-range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListMetrics
func (c *CloudWatch) ListMetrics(input *ListMetricsInput) (*ListMetricsOutput, error) {
	req, out := c.ListMetricsRequest(input)
	return out, req.Send()
}

// ListMetricsWithContext is the same as ListMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See ListMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) ListMetricsWithContext(ctx aws.Context, input *ListMetricsInput, opts ...request.Option) (*ListMetricsOutput, error) {
	req, out := c.ListMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMetricsPages iterates over the pages of a ListMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMetrics operation.
//    pageNum := 0
//    err := client.ListMetricsPages(params,
//        func(page *ListMetricsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudWatch) ListMetricsPages(input *ListMetricsInput, fn func(*ListMetricsOutput, bool) bool) error {
	return c.ListMetricsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMetricsPagesWithContext same as ListMetricsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) ListMetricsPagesWithContext(ctx aws.Context, input *ListMetricsInput, fn func(*ListMetricsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMetricsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMetricsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListMetricsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opPutDashboard = "PutDashboard"

// PutDashboardRequest generates a "aws/request.Request" representing the
// client's request for the PutDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDashboard for more information on using the PutDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutDashboardRequest method.
//    req, resp := client.PutDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutDashboard
func (c *CloudWatch) PutDashboardRequest(input *PutDashboardInput) (req *request.Request, output *PutDashboardOutput) {
	op := &request.Operation{
		Name:       opPutDashboard,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutDashboardInput{}
	}

	output = &PutDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutDashboard API operation for Amazon CloudWatch.
//
// Creates a dashboard if it does not already exist, or updates an existing
// dashboard. If you update a dashboard, the entire contents are replaced with
// what you specify here.
//
// There is no limit to the number of dashboards in your account. All dashboards
// in your account are global, not region-specific.
//
// A simple way to create a dashboard using PutDashboard is to copy an existing
// dashboard. To copy an existing dashboard using the console, you can load
// the dashboard and then use the View/edit source command in the Actions menu
// to display the JSON block for that dashboard. Another way to copy a dashboard
// is to use GetDashboard, and then use the data returned within DashboardBody
// as the template for the new dashboard when you call PutDashboard.
//
// When you create a dashboard with PutDashboard, a good practice is to add
// a text widget at the top of the dashboard with a message that the dashboard
// was created by script and should not be changed in the console. This message
// could also point console users to the location of the DashboardBody script
// or the CloudFormation template used to create the dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation PutDashboard for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDashboardInvalidInputError "InvalidParameterInput"
//   Some part of the dashboard data is invalid.
//
//   * ErrCodeInternalServiceFault "InternalServiceError"
//   Request processing has failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutDashboard
func (c *CloudWatch) PutDashboard(input *PutDashboardInput) (*PutDashboardOutput, error) {
	req, out := c.PutDashboardRequest(input)
	return out, req.Send()
}

// PutDashboardWithContext is the same as PutDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See PutDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) PutDashboardWithContext(ctx aws.Context, input *PutDashboardInput, opts ...request.Option) (*PutDashboardOutput, error) {
	req, out := c.PutDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutMetricAlarm = "PutMetricAlarm"

// PutMetricAlarmRequest generates a "aws/request.Request" representing the
// client's request for the PutMetricAlarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutMetricAlarm for more information on using the PutMetricAlarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutMetricAlarmRequest method.
//    req, resp := client.PutMetricAlarmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricAlarm
func (c *CloudWatch) PutMetricAlarmRequest(input *PutMetricAlarmInput) (req *request.Request, output *PutMetricAlarmOutput) {
	op := &request.Operation{
		Name:       opPutMetricAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutMetricAlarmInput{}
	}

	output = &PutMetricAlarmOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutMetricAlarm API operation for Amazon CloudWatch.
//
// Creates or updates an alarm and associates it with the specified metric or
// metric math expression.
//
// When this operation creates an alarm, the alarm state is immediately set
// to INSUFFICIENT_DATA. The alarm is then evaluated and its state is set appropriately.
// Any actions associated with the new state are then executed.
//
// When you update an existing alarm, its state is left unchanged, but the update
// completely overwrites the previous configuration of the alarm.
//
// If you are an IAM user, you must have Amazon EC2 permissions for some alarm
// operations:
//
//    * iam:CreateServiceLinkedRole for all alarms with EC2 actions
//
//    * ec2:DescribeInstanceStatus and ec2:DescribeInstances for all alarms
//    on EC2 instance status metrics
//
//    * ec2:StopInstances for alarms with stop actions
//
//    * ec2:TerminateInstances for alarms with terminate actions
//
//    * ec2:DescribeInstanceRecoveryAttribute and ec2:RecoverInstances for alarms
//    with recover actions
//
// If you have read/write permissions for Amazon CloudWatch but not for Amazon
// EC2, you can still create an alarm, but the stop or terminate actions are
// not performed. However, if you are later granted the required permissions,
// the alarm actions that you created earlier are performed.
//
// If you are using an IAM role (for example, an EC2 instance profile), you
// cannot stop or terminate the instance using alarm actions. However, you can
// still see the alarm state and perform any other actions such as Amazon SNS
// notifications or Auto Scaling policies.
//
// If you are using temporary security credentials granted using AWS STS, you
// cannot stop or terminate an EC2 instance using alarm actions.
//
// The first time you create an alarm in the AWS Management Console, the CLI,
// or by using the PutMetricAlarm API, CloudWatch creates the necessary service-linked
// role for you. The service-linked role is called AWSServiceRoleForCloudWatchEvents.
// For more information, see AWS service-linked role (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation PutMetricAlarm for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   The quota for alarms for this customer has already been reached.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricAlarm
func (c *CloudWatch) PutMetricAlarm(input *PutMetricAlarmInput) (*PutMetricAlarmOutput, error) {
	req, out := c.PutMetricAlarmRequest(input)
	return out, req.Send()
}

// PutMetricAlarmWithContext is the same as PutMetricAlarm with the addition of
// the ability to pass a context and additional request options.
//
// See PutMetricAlarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) PutMetricAlarmWithContext(ctx aws.Context, input *PutMetricAlarmInput, opts ...request.Option) (*PutMetricAlarmOutput, error) {
	req, out := c.PutMetricAlarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutMetricData = "PutMetricData"

// PutMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the PutMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutMetricData for more information on using the PutMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutMetricDataRequest method.
//    req, resp := client.PutMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricData
func (c *CloudWatch) PutMetricDataRequest(input *PutMetricDataInput) (req *request.Request, output *PutMetricDataOutput) {
	op := &request.Operation{
		Name:       opPutMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutMetricDataInput{}
	}

	output = &PutMetricDataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutMetricData API operation for Amazon CloudWatch.
//
// Publishes metric data points to Amazon CloudWatch. CloudWatch associates
// the data points with the specified metric. If the specified metric does not
// exist, CloudWatch creates the metric. When CloudWatch creates a metric, it
// can take up to fifteen minutes for the metric to appear in calls to ListMetrics.
//
// You can publish either individual data points in the Value field, or arrays
// of values and the number of times each value occurred during the period by
// using the Values and Counts fields in the MetricDatum structure. Using the
// Values and Counts method enables you to publish up to 150 values per metric
// with one PutMetricData request, and supports retrieving percentile statistics
// on this data.
//
// Each PutMetricData request is limited to 40 KB in size for HTTP POST requests.
// You can send a payload compressed by gzip. Each request is also limited to
// no more than 20 different metrics.
//
// Although the Value parameter accepts numbers of type Double, CloudWatch rejects
// values that are either too small or too large. Values must be in the range
// of 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).
// In addition, special values (for example, NaN, +Infinity, -Infinity) are
// not supported.
//
// You can use up to 10 dimensions per metric to further clarify what data the
// metric collects. Each dimension consists of a Name and Value pair. For more
// information about specifying dimensions, see Publishing Metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html)
// in the Amazon CloudWatch User Guide.
//
// Data points with time stamps from 24 hours ago or longer can take at least
// 48 hours to become available for GetMetricData or GetMetricStatistics from
// the time they are submitted.
//
// CloudWatch needs raw data points to calculate percentile statistics. If you
// publish data using a statistic set instead, you can only retrieve percentile
// statistics for this data if one of the following conditions is true:
//
//    * The SampleCount value of the statistic set is 1 and Min, Max, and Sum
//    are all equal.
//
//    * The Min and Max are equal, and Sum is equal to Min multiplied by SampleCount.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation PutMetricData for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value of an input parameter is bad or out-of-range.
//
//   * ErrCodeMissingRequiredParameterException "MissingParameter"
//   An input parameter that is required is missing.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Parameters were used together that cannot be used together.
//
//   * ErrCodeInternalServiceFault "InternalServiceError"
//   Request processing has failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricData
func (c *CloudWatch) PutMetricData(input *PutMetricDataInput) (*PutMetricDataOutput, error) {
	req, out := c.PutMetricDataRequest(input)
	return out, req.Send()
}

// PutMetricDataWithContext is the same as PutMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See PutMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) PutMetricDataWithContext(ctx aws.Context, input *PutMetricDataInput, opts ...request.Option) (*PutMetricDataOutput, error) {
	req, out := c.PutMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetAlarmState = "SetAlarmState"

// SetAlarmStateRequest generates a "aws/request.Request" representing the
// client's request for the SetAlarmState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetAlarmState for more information on using the SetAlarmState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetAlarmStateRequest method.
//    req, resp := client.SetAlarmStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/SetAlarmState
func (c *CloudWatch) SetAlarmStateRequest(input *SetAlarmStateInput) (req *request.Request, output *SetAlarmStateOutput) {
	op := &request.Operation{
		Name:       opSetAlarmState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetAlarmStateInput{}
	}

	output = &SetAlarmStateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetAlarmState API operation for Amazon CloudWatch.
//
// Temporarily sets the state of an alarm for testing purposes. When the updated
// state differs from the previous value, the action configured for the appropriate
// state is invoked. For example, if your alarm is configured to send an Amazon
// SNS message when an alarm is triggered, temporarily changing the alarm state
// to ALARM sends an SNS message. The alarm returns to its actual state (often
// within seconds). Because the alarm state change happens quickly, it is typically
// only visible in the alarm's History tab in the Amazon CloudWatch console
// or through DescribeAlarmHistory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation SetAlarmState for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFound "ResourceNotFound"
//   The named resource does not exist.
//
//   * ErrCodeInvalidFormatFault "InvalidFormat"
//   Data was not syntactically valid JSON.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/SetAlarmState
func (c *CloudWatch) SetAlarmState(input *SetAlarmStateInput) (*SetAlarmStateOutput, error) {
	req, out := c.SetAlarmStateRequest(input)
	return out, req.Send()
}

// SetAlarmStateWithContext is the same as SetAlarmState with the addition of
// the ability to pass a context and additional request options.
//
// See SetAlarmState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) SetAlarmStateWithContext(ctx aws.Context, input *SetAlarmStateInput, opts ...request.Option) (*SetAlarmStateOutput, error) {
	req, out := c.SetAlarmStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents the history of a specific alarm.
type AlarmHistoryItem struct {
	_ struct{} `type:"structure"`

	// The descriptive name for the alarm.
	AlarmName *string `min:"1" type:"string"`

	// Data about the alarm, in JSON format.
	HistoryData *string `min:"1" type:"string"`

	// The type of alarm history item.
	HistoryItemType *string `type:"string" enum:"HistoryItemType"`

	// A summary of the alarm history, in text format.
	HistorySummary *string `min:"1" type:"string"`

	// The time stamp for the alarm history item.
	Timestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s AlarmHistoryItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlarmHistoryItem) GoString() string {
	return s.String()
}

// SetAlarmName sets the AlarmName field's value.
func (s *AlarmHistoryItem) SetAlarmName(v string) *AlarmHistoryItem {
	s.AlarmName = &v
	return s
}

// SetHistoryData sets the HistoryData field's value.
func (s *AlarmHistoryItem) SetHistoryData(v string) *AlarmHistoryItem {
	s.HistoryData = &v
	return s
}

// SetHistoryItemType sets the HistoryItemType field's value.
func (s *AlarmHistoryItem) SetHistoryItemType(v string) *AlarmHistoryItem {
	s.HistoryItemType = &v
	return s
}

// SetHistorySummary sets the HistorySummary field's value.
func (s *AlarmHistoryItem) SetHistorySummary(v string) *AlarmHistoryItem {
	s.HistorySummary = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *AlarmHistoryItem) SetTimestamp(v time.Time) *AlarmHistoryItem {
	s.Timestamp = &v
	return s
}

// Represents a specific dashboard.
type DashboardEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dashboard.
	DashboardArn *string `type:"string"`

	// The name of the dashboard.
	DashboardName *string `type:"string"`

	// The time stamp of when the dashboard was last modified, either by an API
	// call or through the console. This number is expressed as the number of milliseconds
	// since Jan 1, 1970 00:00:00 UTC.
	LastModified *time.Time `type:"timestamp"`

	// The size of the dashboard, in bytes.
	Size *int64 `type:"long"`
}

// String returns the string representation
func (s DashboardEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DashboardEntry) GoString() string {
	return s.String()
}

// SetDashboardArn sets the DashboardArn field's value.
func (s *DashboardEntry) SetDashboardArn(v string) *DashboardEntry {
	s.DashboardArn = &v
	return s
}

// SetDashboardName sets the DashboardName field's value.
func (s *DashboardEntry) SetDashboardName(v string) *DashboardEntry {
	s.DashboardName = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *DashboardEntry) SetLastModified(v time.Time) *DashboardEntry {
	s.LastModified = &v
	return s
}

// SetSize sets the Size field's value.
func (s *DashboardEntry) SetSize(v int64) *DashboardEntry {
	s.Size = &v
	return s
}

// An error or warning for the operation.
type DashboardValidationMessage struct {
	_ struct{} `type:"structure"`

	// The data path related to the message.
	DataPath *string `type:"string"`

	// A message describing the error or warning.
	Message *string `type:"string"`
}

// String returns the string representation
func (s DashboardValidationMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DashboardValidationMessage) GoString() string {
	return s.String()
}

// SetDataPath sets the DataPath field's value.
func (s *DashboardValidationMessage) SetDataPath(v string) *DashboardValidationMessage {
	s.DataPath = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DashboardValidationMessage) SetMessage(v string) *DashboardValidationMessage {
	s.Message = &v
	return s
}

// Encapsulates the statistical data that CloudWatch computes from metric data.
type Datapoint struct {
	_ struct{} `type:"structure"`

	// The average of the metric values that correspond to the data point.
	Average *float64 `type:"double"`

	// The percentile statistic for the data point.
	ExtendedStatistics map[string]*float64 `type:"map"`

	// The maximum metric value for the data point.
	Maximum *float64 `type:"double"`

	// The minimum metric value for the data point.
	Minimum *float64 `type:"double"`

	// The number of metric values that contributed to the aggregate value of this
	// data point.
	SampleCount *float64 `type:"double"`

	// The sum of the metric values for the data point.
	Sum *float64 `type:"double"`

	// The time stamp used for the data point.
	Timestamp *time.Time `type:"timestamp"`

	// The standard unit for the data point.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s Datapoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Datapoint) GoString() string {
	return s.String()
}

// SetAverage sets the Average field's value.
func (s *Datapoint) SetAverage(v float64) *Datapoint {
	s.Average = &v
	return s
}

// SetExtendedStatistics sets the ExtendedStatistics field's value.
func (s *Datapoint) SetExtendedStatistics(v map[string]*float64) *Datapoint {
	s.ExtendedStatistics = v
	return s
}

// SetMaximum sets the Maximum field's value.
func (s *Datapoint) SetMaximum(v float64) *Datapoint {
	s.Maximum = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *Datapoint) SetMinimum(v float64) *Datapoint {
	s.Minimum = &v
	return s
}

// SetSampleCount sets the SampleCount field's value.
func (s *Datapoint) SetSampleCount(v float64) *Datapoint {
	s.SampleCount = &v
	return s
}

// SetSum sets the Sum field's value.
func (s *Datapoint) SetSum(v float64) *Datapoint {
	s.Sum = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *Datapoint) SetTimestamp(v time.Time) *Datapoint {
	s.Timestamp = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Datapoint) SetUnit(v string) *Datapoint {
	s.Unit = &v
	return s
}

type DeleteAlarmsInput struct {
	_ struct{} `type:"structure"`

	// The alarms to be deleted.
	//
	// AlarmNames is a required field
	AlarmNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteAlarmsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAlarmsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAlarmsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAlarmsInput"}
	if s.AlarmNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmNames sets the AlarmNames field's value.
func (s *DeleteAlarmsInput) SetAlarmNames(v []*string) *DeleteAlarmsInput {
	s.AlarmNames = v
	return s
}

type DeleteAlarmsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAlarmsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAlarmsOutput) GoString() string {
	return s.String()
}

type DeleteDashboardsInput struct {
	_ struct{} `type:"structure"`

	// The dashboards to be deleted. This parameter is required.
	//
	// DashboardNames is a required field
	DashboardNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteDashboardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDashboardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDashboardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDashboardsInput"}
	if s.DashboardNames == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboardNames sets the DashboardNames field's value.
func (s *DeleteDashboardsInput) SetDashboardNames(v []*string) *DeleteDashboardsInput {
	s.DashboardNames = v
	return s
}

type DeleteDashboardsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDashboardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDashboardsOutput) GoString() string {
	return s.String()
}

type DescribeAlarmHistoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the alarm.
	AlarmName *string `min:"1" type:"string"`

	// The ending date to retrieve alarm history.
	EndDate *time.Time `type:"timestamp"`

	// The type of alarm histories to retrieve.
	HistoryItemType *string `type:"string" enum:"HistoryItemType"`

	// The maximum number of alarm history records to retrieve.
	MaxRecords *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`

	// The starting date to retrieve alarm history.
	StartDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeAlarmHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlarmHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlarmHistoryInput"}
	if s.AlarmName != nil && len(*s.AlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmName", 1))
	}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRecords", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmName sets the AlarmName field's value.
func (s *DescribeAlarmHistoryInput) SetAlarmName(v string) *DescribeAlarmHistoryInput {
	s.AlarmName = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *DescribeAlarmHistoryInput) SetEndDate(v time.Time) *DescribeAlarmHistoryInput {
	s.EndDate = &v
	return s
}

// SetHistoryItemType sets the HistoryItemType field's value.
func (s *DescribeAlarmHistoryInput) SetHistoryItemType(v string) *DescribeAlarmHistoryInput {
	s.HistoryItemType = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeAlarmHistoryInput) SetMaxRecords(v int64) *DescribeAlarmHistoryInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAlarmHistoryInput) SetNextToken(v string) *DescribeAlarmHistoryInput {
	s.NextToken = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *DescribeAlarmHistoryInput) SetStartDate(v time.Time) *DescribeAlarmHistoryInput {
	s.StartDate = &v
	return s
}

type DescribeAlarmHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The alarm histories, in JSON format.
	AlarmHistoryItems []*AlarmHistoryItem `type:"list"`

	// The token that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAlarmHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmHistoryOutput) GoString() string {
	return s.String()
}

// SetAlarmHistoryItems sets the AlarmHistoryItems field's value.
func (s *DescribeAlarmHistoryOutput) SetAlarmHistoryItems(v []*AlarmHistoryItem) *DescribeAlarmHistoryOutput {
	s.AlarmHistoryItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAlarmHistoryOutput) SetNextToken(v string) *DescribeAlarmHistoryOutput {
	s.NextToken = &v
	return s
}

type DescribeAlarmsForMetricInput struct {
	_ struct{} `type:"structure"`

	// The dimensions associated with the metric. If the metric has any associated
	// dimensions, you must specify them in order for the call to succeed.
	Dimensions []*Dimension `type:"list"`

	// The percentile statistic for the metric. Specify a value between p0.0 and
	// p100.
	ExtendedStatistic *string `type:"string"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace of the metric.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`

	// The period, in seconds, over which the statistic is applied.
	Period *int64 `min:"1" type:"integer"`

	// The statistic for the metric, other than percentiles. For percentile statistics,
	// use ExtendedStatistics.
	Statistic *string `type:"string" enum:"Statistic"`

	// The unit for the metric.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s DescribeAlarmsForMetricInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmsForMetricInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlarmsForMetricInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlarmsForMetricInput"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *DescribeAlarmsForMetricInput) SetDimensions(v []*Dimension) *DescribeAlarmsForMetricInput {
	s.Dimensions = v
	return s
}

// SetExtendedStatistic sets the ExtendedStatistic field's value.
func (s *DescribeAlarmsForMetricInput) SetExtendedStatistic(v string) *DescribeAlarmsForMetricInput {
	s.ExtendedStatistic = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *DescribeAlarmsForMetricInput) SetMetricName(v string) *DescribeAlarmsForMetricInput {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeAlarmsForMetricInput) SetNamespace(v string) *DescribeAlarmsForMetricInput {
	s.Namespace = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *DescribeAlarmsForMetricInput) SetPeriod(v int64) *DescribeAlarmsForMetricInput {
	s.Period = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *DescribeAlarmsForMetricInput) SetStatistic(v string) *DescribeAlarmsForMetricInput {
	s.Statistic = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *DescribeAlarmsForMetricInput) SetUnit(v string) *DescribeAlarmsForMetricInput {
	s.Unit = &v
	return s
}

type DescribeAlarmsForMetricOutput struct {
	_ struct{} `type:"structure"`

	// The information for each alarm with the specified metric.
	MetricAlarms []*MetricAlarm `type:"list"`
}

// String returns the string representation
func (s DescribeAlarmsForMetricOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmsForMetricOutput) GoString() string {
	return s.String()
}

// SetMetricAlarms sets the MetricAlarms field's value.
func (s *DescribeAlarmsForMetricOutput) SetMetricAlarms(v []*MetricAlarm) *DescribeAlarmsForMetricOutput {
	s.MetricAlarms = v
	return s
}

type DescribeAlarmsInput struct {
	_ struct{} `type:"structure"`

	// The action name prefix.
	ActionPrefix *string `min:"1" type:"string"`

	// The alarm name prefix. If this parameter is specified, you cannot specify
	// AlarmNames.
	AlarmNamePrefix *string `min:"1" type:"string"`

	// The names of the alarms.
	AlarmNames []*string `type:"list"`

	// The maximum number of alarm descriptions to retrieve.
	MaxRecords *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`

	// The state value to be used in matching alarms.
	StateValue *string `type:"string" enum:"StateValue"`
}

// String returns the string representation
func (s DescribeAlarmsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlarmsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlarmsInput"}
	if s.ActionPrefix != nil && len(*s.ActionPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionPrefix", 1))
	}
	if s.AlarmNamePrefix != nil && len(*s.AlarmNamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmNamePrefix", 1))
	}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRecords", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionPrefix sets the ActionPrefix field's value.
func (s *DescribeAlarmsInput) SetActionPrefix(v string) *DescribeAlarmsInput {
	s.ActionPrefix = &v
	return s
}

// SetAlarmNamePrefix sets the AlarmNamePrefix field's value.
func (s *DescribeAlarmsInput) SetAlarmNamePrefix(v string) *DescribeAlarmsInput {
	s.AlarmNamePrefix = &v
	return s
}

// SetAlarmNames sets the AlarmNames field's value.
func (s *DescribeAlarmsInput) SetAlarmNames(v []*string) *DescribeAlarmsInput {
	s.AlarmNames = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeAlarmsInput) SetMaxRecords(v int64) *DescribeAlarmsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAlarmsInput) SetNextToken(v string) *DescribeAlarmsInput {
	s.NextToken = &v
	return s
}

// SetStateValue sets the StateValue field's value.
func (s *DescribeAlarmsInput) SetStateValue(v string) *DescribeAlarmsInput {
	s.StateValue = &v
	return s
}

type DescribeAlarmsOutput struct {
	_ struct{} `type:"structure"`

	// The information for the specified alarms.
	MetricAlarms []*MetricAlarm `type:"list"`

	// The token that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAlarmsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmsOutput) GoString() string {
	return s.String()
}

// SetMetricAlarms sets the MetricAlarms field's value.
func (s *DescribeAlarmsOutput) SetMetricAlarms(v []*MetricAlarm) *DescribeAlarmsOutput {
	s.MetricAlarms = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAlarmsOutput) SetNextToken(v string) *DescribeAlarmsOutput {
	s.NextToken = &v
	return s
}

// Expands the identity of a metric.
type Dimension struct {
	_ struct{} `type:"structure"`

	// The name of the dimension.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value representing the dimension measurement.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Dimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Dimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Dimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Dimension"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Dimension) SetName(v string) *Dimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Dimension) SetValue(v string) *Dimension {
	s.Value = &v
	return s
}

// Represents filters for a dimension.
type DimensionFilter struct {
	_ struct{} `type:"structure"`

	// The dimension name to be matched.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value of the dimension to be matched.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DimensionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DimensionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DimensionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DimensionFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DimensionFilter) SetName(v string) *DimensionFilter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DimensionFilter) SetValue(v string) *DimensionFilter {
	s.Value = &v
	return s
}

type DisableAlarmActionsInput struct {
	_ struct{} `type:"structure"`

	// The names of the alarms.
	//
	// AlarmNames is a required field
	AlarmNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DisableAlarmActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableAlarmActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableAlarmActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableAlarmActionsInput"}
	if s.AlarmNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmNames sets the AlarmNames field's value.
func (s *DisableAlarmActionsInput) SetAlarmNames(v []*string) *DisableAlarmActionsInput {
	s.AlarmNames = v
	return s
}

type DisableAlarmActionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableAlarmActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableAlarmActionsOutput) GoString() string {
	return s.String()
}

type EnableAlarmActionsInput struct {
	_ struct{} `type:"structure"`

	// The names of the alarms.
	//
	// AlarmNames is a required field
	AlarmNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s EnableAlarmActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAlarmActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableAlarmActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableAlarmActionsInput"}
	if s.AlarmNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmNames sets the AlarmNames field's value.
func (s *EnableAlarmActionsInput) SetAlarmNames(v []*string) *EnableAlarmActionsInput {
	s.AlarmNames = v
	return s
}

type EnableAlarmActionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableAlarmActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAlarmActionsOutput) GoString() string {
	return s.String()
}

type GetDashboardInput struct {
	_ struct{} `type:"structure"`

	// The name of the dashboard to be described.
	//
	// DashboardName is a required field
	DashboardName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDashboardInput"}
	if s.DashboardName == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboardName sets the DashboardName field's value.
func (s *GetDashboardInput) SetDashboardName(v string) *GetDashboardInput {
	s.DashboardName = &v
	return s
}

type GetDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dashboard.
	DashboardArn *string `type:"string"`

	// The detailed information about the dashboard, including what widgets are
	// included and their location on the dashboard. For more information about
	// the DashboardBody syntax, see CloudWatch-Dashboard-Body-Structure.
	DashboardBody *string `type:"string"`

	// The name of the dashboard.
	DashboardName *string `type:"string"`
}

// String returns the string representation
func (s GetDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDashboardOutput) GoString() string {
	return s.String()
}

// SetDashboardArn sets the DashboardArn field's value.
func (s *GetDashboardOutput) SetDashboardArn(v string) *GetDashboardOutput {
	s.DashboardArn = &v
	return s
}

// SetDashboardBody sets the DashboardBody field's value.
func (s *GetDashboardOutput) SetDashboardBody(v string) *GetDashboardOutput {
	s.DashboardBody = &v
	return s
}

// SetDashboardName sets the DashboardName field's value.
func (s *GetDashboardOutput) SetDashboardName(v string) *GetDashboardOutput {
	s.DashboardName = &v
	return s
}

type GetMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The time stamp indicating the latest data to be returned.
	//
	// For better performance, specify StartTime and EndTime values that align with
	// the value of the metric's Period and sync up with the beginning and end of
	// an hour. For example, if the Period of a metric is 5 minutes, specifying
	// 12:05 or 12:30 as EndTime can get a faster response from CloudWatch than
	// setting 12:07 or 12:29 as the EndTime.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The maximum number of data points the request should return before paginating.
	// If you omit this, the default of 100,800 is used.
	MaxDatapoints *int64 `type:"integer"`

	// The metric queries to be returned. A single GetMetricData call can include
	// as many as 100 MetricDataQuery structures. Each of these structures can specify
	// either a metric to retrieve, or a math expression to perform on retrieved
	// data.
	//
	// MetricDataQueries is a required field
	MetricDataQueries []*MetricDataQuery `type:"list" required:"true"`

	// Include this value, if it was returned by the previous call, to get the next
	// set of data points.
	NextToken *string `type:"string"`

	// The order in which data points should be returned. TimestampDescending returns
	// the newest data first and paginates when the MaxDatapoints limit is reached.
	// TimestampAscending returns the oldest data first and paginates when the MaxDatapoints
	// limit is reached.
	ScanBy *string `type:"string" enum:"ScanBy"`

	// The time stamp indicating the earliest data to be returned.
	//
	// For better performance, specify StartTime and EndTime values that align with
	// the value of the metric's Period and sync up with the beginning and end of
	// an hour. For example, if the Period of a metric is 5 minutes, specifying
	// 12:05 or 12:30 as StartTime can get a faster response from CloudWatch than
	// setting 12:07 or 12:29 as the StartTime.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s GetMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMetricDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMetricDataInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.MetricDataQueries == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricDataQueries"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.MetricDataQueries != nil {
		for i, v := range s.MetricDataQueries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDataQueries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetMetricDataInput) SetEndTime(v time.Time) *GetMetricDataInput {
	s.EndTime = &v
	return s
}

// SetMaxDatapoints sets the MaxDatapoints field's value.
func (s *GetMetricDataInput) SetMaxDatapoints(v int64) *GetMetricDataInput {
	s.MaxDatapoints = &v
	return s
}

// SetMetricDataQueries sets the MetricDataQueries field's value.
func (s *GetMetricDataInput) SetMetricDataQueries(v []*MetricDataQuery) *GetMetricDataInput {
	s.MetricDataQueries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetMetricDataInput) SetNextToken(v string) *GetMetricDataInput {
	s.NextToken = &v
	return s
}

// SetScanBy sets the ScanBy field's value.
func (s *GetMetricDataInput) SetScanBy(v string) *GetMetricDataInput {
	s.ScanBy = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetMetricDataInput) SetStartTime(v time.Time) *GetMetricDataInput {
	s.StartTime = &v
	return s
}

type GetMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// The metrics that are returned, including the metric name, namespace, and
	// dimensions.
	MetricDataResults []*MetricDataResult `type:"list"`

	// A token that marks the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMetricDataOutput) GoString() string {
	return s.String()
}

// SetMetricDataResults sets the MetricDataResults field's value.
func (s *GetMetricDataOutput) SetMetricDataResults(v []*MetricDataResult) *GetMetricDataOutput {
	s.MetricDataResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetMetricDataOutput) SetNextToken(v string) *GetMetricDataOutput {
	s.NextToken = &v
	return s
}

type GetMetricStatisticsInput struct {
	_ struct{} `type:"structure"`

	// The dimensions. If the metric contains multiple dimensions, you must include
	// a value for each dimension. CloudWatch treats each unique combination of
	// dimensions as a separate metric. If a specific combination of dimensions
	// was not published, you can't retrieve statistics for it. You must specify
	// the same dimensions that were used when the metrics were created. For an
	// example, see Dimension Combinations (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#dimension-combinations)
	// in the Amazon CloudWatch User Guide. For more information about specifying
	// dimensions, see Publishing Metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html)
	// in the Amazon CloudWatch User Guide.
	Dimensions []*Dimension `type:"list"`

	// The time stamp that determines the last data point to return.
	//
	// The value specified is exclusive; results include data points up to the specified
	// time stamp. The time stamp must be in ISO 8601 UTC format (for example, 2016-10-10T23:00:00Z).
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The percentile statistics. Specify values between p0.0 and p100. When calling
	// GetMetricStatistics, you must specify either Statistics or ExtendedStatistics,
	// but not both. Percentile statistics are not available for metrics when any
	// of the metric values are negative numbers.
	ExtendedStatistics []*string `min:"1" type:"list"`

	// The name of the metric, with or without spaces.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace of the metric, with or without spaces.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`

	// The granularity, in seconds, of the returned data points. For metrics with
	// regular resolution, a period can be as short as one minute (60 seconds) and
	// must be a multiple of 60. For high-resolution metrics that are collected
	// at intervals of less than one minute, the period can be 1, 5, 10, 30, 60,
	// or any multiple of 60. High-resolution metrics are those metrics stored by
	// a PutMetricData call that includes a StorageResolution of 1 second.
	//
	// If the StartTime parameter specifies a time stamp that is greater than 3
	// hours ago, you must specify the period as follows or no data points in that
	// time range is returned:
	//
	//    * Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds
	//    (1 minute).
	//
	//    * Start time between 15 and 63 days ago - Use a multiple of 300 seconds
	//    (5 minutes).
	//
	//    * Start time greater than 63 days ago - Use a multiple of 3600 seconds
	//    (1 hour).
	//
	// Period is a required field
	Period *int64 `min:"1" type:"integer" required:"true"`

	// The time stamp that determines the first data point to return. Start times
	// are evaluated relative to the time that CloudWatch receives the request.
	//
	// The value specified is inclusive; results include data points with the specified
	// time stamp. The time stamp must be in ISO 8601 UTC format (for example, 2016-10-03T23:00:00Z).
	//
	// CloudWatch rounds the specified time stamp as follows:
	//
	//    * Start time less than 15 days ago - Round down to the nearest whole minute.
	//    For example, 12:32:34 is rounded down to 12:32:00.
	//
	//    * Start time between 15 and 63 days ago - Round down to the nearest 5-minute
	//    clock interval. For example, 12:32:34 is rounded down to 12:30:00.
	//
	//    * Start time greater than 63 days ago - Round down to the nearest 1-hour
	//    clock interval. For example, 12:32:34 is rounded down to 12:00:00.
	//
	// If you set Period to 5, 10, or 30, the start time of your request is rounded
	// down to the nearest time that corresponds to even 5-, 10-, or 30-second divisions
	// of a minute. For example, if you make a query at (HH:mm:ss) 01:05:23 for
	// the previous 10-second period, the start time of your request is rounded
	// down and you receive data from 01:05:10 to 01:05:20. If you make a query
	// at 15:07:17 for the previous 5 minutes of data, using a period of 5 seconds,
	// you receive data timestamped between 15:02:15 and 15:07:15.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`

	// The metric statistics, other than percentile. For percentile statistics,
	// use ExtendedStatistics. When calling GetMetricStatistics, you must specify
	// either Statistics or ExtendedStatistics, but not both.
	Statistics []*string `min:"1" type:"list"`

	// The unit for a given metric. Metrics may be reported in multiple units. Not
	// supplying a unit results in all units being returned. If you specify only
	// a unit that the metric does not report, the results of the call are null.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s GetMetricStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMetricStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMetricStatisticsInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.ExtendedStatistics != nil && len(s.ExtendedStatistics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExtendedStatistics", 1))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.Statistics != nil && len(s.Statistics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Statistics", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *GetMetricStatisticsInput) SetDimensions(v []*Dimension) *GetMetricStatisticsInput {
	s.Dimensions = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetMetricStatisticsInput) SetEndTime(v time.Time) *GetMetricStatisticsInput {
	s.EndTime = &v
	return s
}

// SetExtendedStatistics sets the ExtendedStatistics field's value.
func (s *GetMetricStatisticsInput) SetExtendedStatistics(v []*string) *GetMetricStatisticsInput {
	s.ExtendedStatistics = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *GetMetricStatisticsInput) SetMetricName(v string) *GetMetricStatisticsInput {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *GetMetricStatisticsInput) SetNamespace(v string) *GetMetricStatisticsInput {
	s.Namespace = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GetMetricStatisticsInput) SetPeriod(v int64) *GetMetricStatisticsInput {
	s.Period = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetMetricStatisticsInput) SetStartTime(v time.Time) *GetMetricStatisticsInput {
	s.StartTime = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *GetMetricStatisticsInput) SetStatistics(v []*string) *GetMetricStatisticsInput {
	s.Statistics = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *GetMetricStatisticsInput) SetUnit(v string) *GetMetricStatisticsInput {
	s.Unit = &v
	return s
}

type GetMetricStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// The data points for the specified metric.
	Datapoints []*Datapoint `type:"list"`

	// A label for the specified metric.
	Label *string `type:"string"`
}

// String returns the string representation
func (s GetMetricStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMetricStatisticsOutput) GoString() string {
	return s.String()
}

// SetDatapoints sets the Datapoints field's value.
func (s *GetMetricStatisticsOutput) SetDatapoints(v []*Datapoint) *GetMetricStatisticsOutput {
	s.Datapoints = v
	return s
}

// SetLabel sets the Label field's value.
func (s *GetMetricStatisticsOutput) SetLabel(v string) *GetMetricStatisticsOutput {
	s.Label = &v
	return s
}

type GetMetricWidgetImageInput struct {
	_ struct{} `type:"structure"`

	// A JSON string that defines the bitmap graph to be retrieved. The string includes
	// the metrics to include in the graph, statistics, annotations, title, axis
	// limits, and so on. You can include only one MetricWidget parameter in each
	// GetMetricWidgetImage call.
	//
	// For more information about the syntax of MetricWidget see CloudWatch-Metric-Widget-Structure.
	//
	// If any metric on the graph could not load all the requested data points,
	// an orange triangle with an exclamation point appears next to the graph legend.
	//
	// MetricWidget is a required field
	MetricWidget *string `type:"string" required:"true"`

	// The format of the resulting image. Only PNG images are supported.
	//
	// The default is png. If you specify png, the API returns an HTTP response
	// with the content-type set to text/xml. The image data is in a MetricWidgetImage
	// field. For example:
	//
	// <GetMetricWidgetImageResponse xmlns=<URLstring>>
	//
	// <GetMetricWidgetImageResult>
	//
	// <MetricWidgetImage>
	//
	// iVBORw0KGgoAAAANSUhEUgAAAlgAAAGQEAYAAAAip...
	//
	// </MetricWidgetImage>
	//
	// </GetMetricWidgetImageResult>
	//
	// <ResponseMetadata>
	//
	// <RequestId>6f0d4192-4d42-11e8-82c1-f539a07e0e3b</RequestId>
	//
	// </ResponseMetadata>
	//
	// </GetMetricWidgetImageResponse>
	//
	// The image/png setting is intended only for custom HTTP requests. For most
	// use cases, and all actions using an AWS SDK, you should use png. If you specify
	// image/png, the HTTP response has a content-type set to image/png, and the
	// body of the response is a PNG image.
	OutputFormat *string `type:"string"`
}

// String returns the string representation
func (s GetMetricWidgetImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMetricWidgetImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricWidgetImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMetricWidgetImageInput"}
	if s.MetricWidget == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricWidget"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricWidget sets the MetricWidget field's value.
func (s *GetMetricWidgetImageInput) SetMetricWidget(v string) *GetMetricWidgetImageInput {
	s.MetricWidget = &v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *GetMetricWidgetImageInput) SetOutputFormat(v string) *GetMetricWidgetImageInput {
	s.OutputFormat = &v
	return s
}

type GetMetricWidgetImageOutput struct {
	_ struct{} `type:"structure"`

	// The image of the graph, in the output format specified.
	//
	// MetricWidgetImage is automatically base64 encoded/decoded by the SDK.
	MetricWidgetImage []byte `type:"blob"`
}

// String returns the string representation
func (s GetMetricWidgetImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMetricWidgetImageOutput) GoString() string {
	return s.String()
}

// SetMetricWidgetImage sets the MetricWidgetImage field's value.
func (s *GetMetricWidgetImageOutput) SetMetricWidgetImage(v []byte) *GetMetricWidgetImageOutput {
	s.MetricWidgetImage = v
	return s
}

type ListDashboardsInput struct {
	_ struct{} `type:"structure"`

	// If you specify this parameter, only the dashboards with names starting with
	// the specified string are listed. The maximum length is 255, and valid characters
	// are A-Z, a-z, 0-9, ".", "-", and "_".
	DashboardNamePrefix *string `type:"string"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDashboardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDashboardsInput) GoString() string {
	return s.String()
}

// SetDashboardNamePrefix sets the DashboardNamePrefix field's value.
func (s *ListDashboardsInput) SetDashboardNamePrefix(v string) *ListDashboardsInput {
	s.DashboardNamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDashboardsInput) SetNextToken(v string) *ListDashboardsInput {
	s.NextToken = &v
	return s
}

type ListDashboardsOutput struct {
	_ struct{} `type:"structure"`

	// The list of matching dashboards.
	DashboardEntries []*DashboardEntry `type:"list"`

	// The token that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDashboardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDashboardsOutput) GoString() string {
	return s.String()
}

// SetDashboardEntries sets the DashboardEntries field's value.
func (s *ListDashboardsOutput) SetDashboardEntries(v []*DashboardEntry) *ListDashboardsOutput {
	s.DashboardEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDashboardsOutput) SetNextToken(v string) *ListDashboardsOutput {
	s.NextToken = &v
	return s
}

type ListMetricsInput struct {
	_ struct{} `type:"structure"`

	// The dimensions to filter against.
	Dimensions []*DimensionFilter `type:"list"`

	// The name of the metric to filter against.
	MetricName *string `min:"1" type:"string"`

	// The namespace to filter against.
	Namespace *string `min:"1" type:"string"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMetricsInput"}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *ListMetricsInput) SetDimensions(v []*DimensionFilter) *ListMetricsInput {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *ListMetricsInput) SetMetricName(v string) *ListMetricsInput {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListMetricsInput) SetNamespace(v string) *ListMetricsInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMetricsInput) SetNextToken(v string) *ListMetricsInput {
	s.NextToken = &v
	return s
}

type ListMetricsOutput struct {
	_ struct{} `type:"structure"`

	// The metrics.
	Metrics []*Metric `type:"list"`

	// The token that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMetricsOutput) GoString() string {
	return s.String()
}

// SetMetrics sets the Metrics field's value.
func (s *ListMetricsOutput) SetMetrics(v []*Metric) *ListMetricsOutput {
	s.Metrics = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMetricsOutput) SetNextToken(v string) *ListMetricsOutput {
	s.NextToken = &v
	return s
}

// A message returned by the GetMetricDataAPI, including a code and a description.
type MessageData struct {
	_ struct{} `type:"structure"`

	// The error code or status code associated with the message.
	Code *string `type:"string"`

	// The message text.
	Value *string `type:"string"`
}

// String returns the string representation
func (s MessageData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageData) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *MessageData) SetCode(v string) *MessageData {
	s.Code = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MessageData) SetValue(v string) *MessageData {
	s.Value = &v
	return s
}

// Represents a specific metric.
type Metric struct {
	_ struct{} `type:"structure"`

	// The dimensions for the metric.
	Dimensions []*Dimension `type:"list"`

	// The name of the metric. This is a required field.
	MetricName *string `min:"1" type:"string"`

	// The namespace of the metric.
	Namespace *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Metric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Metric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Metric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Metric"}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *Metric) SetDimensions(v []*Dimension) *Metric {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *Metric) SetMetricName(v string) *Metric {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *Metric) SetNamespace(v string) *Metric {
	s.Namespace = &v
	return s
}

// Represents an alarm.
type MetricAlarm struct {
	_ struct{} `type:"structure"`

	// Indicates whether actions should be executed during any changes to the alarm
	// state.
	ActionsEnabled *bool `type:"boolean"`

	// The actions to execute when this alarm transitions to the ALARM state from
	// any other state. Each action is specified as an Amazon Resource Name (ARN).
	AlarmActions []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the alarm.
	AlarmArn *string `min:"1" type:"string"`

	// The time stamp of the last update to the alarm configuration.
	AlarmConfigurationUpdatedTimestamp *time.Time `type:"timestamp"`

	// The description of the alarm.
	AlarmDescription *string `type:"string"`

	// The name of the alarm.
	AlarmName *string `min:"1" type:"string"`

	// The arithmetic operation to use when comparing the specified statistic and
	// threshold. The specified statistic value is used as the first operand.
	ComparisonOperator *string `type:"string" enum:"ComparisonOperator"`

	// The number of datapoints that must be breaching to trigger the alarm.
	DatapointsToAlarm *int64 `min:"1" type:"integer"`

	// The dimensions for the metric associated with the alarm.
	Dimensions []*Dimension `type:"list"`

	// Used only for alarms based on percentiles. If ignore, the alarm state does
	// not change during periods with too few data points to be statistically significant.
	// If evaluate or this parameter is not used, the alarm is always evaluated
	// and possibly changes state no matter how many data points are available.
	EvaluateLowSampleCountPercentile *string `min:"1" type:"string"`

	// The number of periods over which data is compared to the specified threshold.
	EvaluationPeriods *int64 `min:"1" type:"integer"`

	// The percentile statistic for the metric associated with the alarm. Specify
	// a value between p0.0 and p100.
	ExtendedStatistic *string `type:"string"`

	// The actions to execute when this alarm transitions to the INSUFFICIENT_DATA
	// state from any other state. Each action is specified as an Amazon Resource
	// Name (ARN).
	InsufficientDataActions []*string `type:"list"`

	// The name of the metric associated with the alarm.
	MetricName *string `min:"1" type:"string"`

	Metrics []*MetricDataQuery `type:"list"`

	// The namespace of the metric associated with the alarm.
	Namespace *string `min:"1" type:"string"`

	// The actions to execute when this alarm transitions to the OK state from any
	// other state. Each action is specified as an Amazon Resource Name (ARN).
	OKActions []*string `type:"list"`

	// The period, in seconds, over which the statistic is applied.
	Period *int64 `min:"1" type:"integer"`

	// An explanation for the alarm state, in text format.
	StateReason *string `type:"string"`

	// An explanation for the alarm state, in JSON format.
	StateReasonData *string `type:"string"`

	// The time stamp of the last update to the alarm state.
	StateUpdatedTimestamp *time.Time `type:"timestamp"`

	// The state value for the alarm.
	StateValue *string `type:"string" enum:"StateValue"`

	// The statistic for the metric associated with the alarm, other than percentile.
	// For percentile statistics, use ExtendedStatistic.
	Statistic *string `type:"string" enum:"Statistic"`

	// The value to compare with the specified statistic.
	Threshold *float64 `type:"double"`

	// Sets how this alarm is to handle missing data points. If this parameter is
	// omitted, the default behavior of missing is used.
	TreatMissingData *string `min:"1" type:"string"`

	// The unit of the metric associated with the alarm.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s MetricAlarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricAlarm) GoString() string {
	return s.String()
}

// SetActionsEnabled sets the ActionsEnabled field's value.
func (s *MetricAlarm) SetActionsEnabled(v bool) *MetricAlarm {
	s.ActionsEnabled = &v
	return s
}

// SetAlarmActions sets the AlarmActions field's value.
func (s *MetricAlarm) SetAlarmActions(v []*string) *MetricAlarm {
	s.AlarmActions = v
	return s
}

// SetAlarmArn sets the AlarmArn field's value.
func (s *MetricAlarm) SetAlarmArn(v string) *MetricAlarm {
	s.AlarmArn = &v
	return s
}

// SetAlarmConfigurationUpdatedTimestamp sets the AlarmConfigurationUpdatedTimestamp field's value.
func (s *MetricAlarm) SetAlarmConfigurationUpdatedTimestamp(v time.Time) *MetricAlarm {
	s.AlarmConfigurationUpdatedTimestamp = &v
	return s
}

// SetAlarmDescription sets the AlarmDescription field's value.
func (s *MetricAlarm) SetAlarmDescription(v string) *MetricAlarm {
	s.AlarmDescription = &v
	return s
}

// SetAlarmName sets the AlarmName field's value.
func (s *MetricAlarm) SetAlarmName(v string) *MetricAlarm {
	s.AlarmName = &v
	return s
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *MetricAlarm) SetComparisonOperator(v string) *MetricAlarm {
	s.ComparisonOperator = &v
	return s
}

// SetDatapointsToAlarm sets the DatapointsToAlarm field's value.
func (s *MetricAlarm) SetDatapointsToAlarm(v int64) *MetricAlarm {
	s.DatapointsToAlarm = &v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *MetricAlarm) SetDimensions(v []*Dimension) *MetricAlarm {
	s.Dimensions = v
	return s
}

// SetEvaluateLowSampleCountPercentile sets the EvaluateLowSampleCountPercentile field's value.
func (s *MetricAlarm) SetEvaluateLowSampleCountPercentile(v string) *MetricAlarm {
	s.EvaluateLowSampleCountPercentile = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *MetricAlarm) SetEvaluationPeriods(v int64) *MetricAlarm {
	s.EvaluationPeriods = &v
	return s
}

// SetExtendedStatistic sets the ExtendedStatistic field's value.
func (s *MetricAlarm) SetExtendedStatistic(v string) *MetricAlarm {
	s.ExtendedStatistic = &v
	return s
}

// SetInsufficientDataActions sets the InsufficientDataActions field's value.
func (s *MetricAlarm) SetInsufficientDataActions(v []*string) *MetricAlarm {
	s.InsufficientDataActions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *MetricAlarm) SetMetricName(v string) *MetricAlarm {
	s.MetricName = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *MetricAlarm) SetMetrics(v []*MetricDataQuery) *MetricAlarm {
	s.Metrics = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *MetricAlarm) SetNamespace(v string) *MetricAlarm {
	s.Namespace = &v
	return s
}

// SetOKActions sets the OKActions field's value.
func (s *MetricAlarm) SetOKActions(v []*string) *MetricAlarm {
	s.OKActions = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *MetricAlarm) SetPeriod(v int64) *MetricAlarm {
	s.Period = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *MetricAlarm) SetStateReason(v string) *MetricAlarm {
	s.StateReason = &v
	return s
}

// SetStateReasonData sets the StateReasonData field's value.
func (s *MetricAlarm) SetStateReasonData(v string) *MetricAlarm {
	s.StateReasonData = &v
	return s
}

// SetStateUpdatedTimestamp sets the StateUpdatedTimestamp field's value.
func (s *MetricAlarm) SetStateUpdatedTimestamp(v time.Time) *MetricAlarm {
	s.StateUpdatedTimestamp = &v
	return s
}

// SetStateValue sets the StateValue field's value.
func (s *MetricAlarm) SetStateValue(v string) *MetricAlarm {
	s.StateValue = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *MetricAlarm) SetStatistic(v string) *MetricAlarm {
	s.Statistic = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *MetricAlarm) SetThreshold(v float64) *MetricAlarm {
	s.Threshold = &v
	return s
}

// SetTreatMissingData sets the TreatMissingData field's value.
func (s *MetricAlarm) SetTreatMissingData(v string) *MetricAlarm {
	s.TreatMissingData = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricAlarm) SetUnit(v string) *MetricAlarm {
	s.Unit = &v
	return s
}

// This structure is used in both GetMetricData and PutMetricAlarm. The supported
// use of this structure is different for those two operations.
//
// When used in GetMetricData, it indicates the metric data to return, and whether
// this call is just retrieving a batch set of data for one metric, or is performing
// a math expression on metric data. A single GetMetricData call can include
// up to 100 MetricDataQuery structures.
//
// When used in PutMetricAlarm, it enables you to create an alarm based on a
// metric math expression. Each MetricDataQuery in the array specifies either
// a metric to retrieve, or a math expression to be performed on retrieved metrics.
// A single PutMetricAlarm call can include up to 20 MetricDataQuery structures
// in the array. The 20 structures can include as many as 10 structures that
// contain a MetricStat parameter to retrieve a metric, and as many as 10 structures
// that contain the Expression parameter to perform a math expression. Of those
// Expression structures, one must have True as the value for ReturnData. The
// result of this expression is the value the alarm watches.
//
// Any expression used in a PutMetricAlarm operation must return a single time
// series. For more information, see Metric Math Syntax and Functions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax)
// in the Amazon CloudWatch User Guide.
//
// Some of the parameters of this structure also have different uses whether
// you are using this structure in a GetMetricData operation or a PutMetricAlarm
// operation. These differences are explained in the following parameter list.
type MetricDataQuery struct {
	_ struct{} `type:"structure"`

	// The math expression to be performed on the returned data, if this object
	// is performing a math expression. This expression can use the Id of the other
	// metrics to refer to those metrics, and can also use the Id of other expressions
	// to use the result of those expressions. For more information about metric
	// math expressions, see Metric Math Syntax and Functions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax)
	// in the Amazon CloudWatch User Guide.
	//
	// Within each MetricDataQuery object, you must specify either Expression or
	// MetricStat but not both.
	Expression *string `min:"1" type:"string"`

	// A short name used to tie this object to the results in the response. This
	// name must be unique within a single call to GetMetricData. If you are performing
	// math expressions on this set of data, this name represents that data and
	// can serve as a variable in the mathematical expression. The valid characters
	// are letters, numbers, and underscore. The first character must be a lowercase
	// letter.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A human-readable label for this metric or expression. This is especially
	// useful if this is an expression, so that you know what the value represents.
	// If the metric or expression is shown in a CloudWatch dashboard widget, the
	// label is shown. If Label is omitted, CloudWatch generates a default.
	Label *string `type:"string"`

	// The metric to be returned, along with statistics, period, and units. Use
	// this parameter only if this object is retrieving a metric and not performing
	// a math expression on returned data.
	//
	// Within one MetricDataQuery object, you must specify either Expression or
	// MetricStat but not both.
	MetricStat *MetricStat `type:"structure"`

	// When used in GetMetricData, this option indicates whether to return the timestamps
	// and raw data values of this metric. If you are performing this call just
	// to do math expressions and do not also need the raw data returned, you can
	// specify False. If you omit this, the default of True is used.
	//
	// When used in PutMetricAlarm, specify True for the one expression result to
	// use as the alarm. For all other metrics and expressions in the same PutMetricAlarm
	// operation, specify ReturnData as False.
	ReturnData *bool `type:"boolean"`
}

// String returns the string representation
func (s MetricDataQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDataQuery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDataQuery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDataQuery"}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.MetricStat != nil {
		if err := s.MetricStat.Validate(); err != nil {
			invalidParams.AddNested("MetricStat", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpression sets the Expression field's value.
func (s *MetricDataQuery) SetExpression(v string) *MetricDataQuery {
	s.Expression = &v
	return s
}

// SetId sets the Id field's value.
func (s *MetricDataQuery) SetId(v string) *MetricDataQuery {
	s.Id = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *MetricDataQuery) SetLabel(v string) *MetricDataQuery {
	s.Label = &v
	return s
}

// SetMetricStat sets the MetricStat field's value.
func (s *MetricDataQuery) SetMetricStat(v *MetricStat) *MetricDataQuery {
	s.MetricStat = v
	return s
}

// SetReturnData sets the ReturnData field's value.
func (s *MetricDataQuery) SetReturnData(v bool) *MetricDataQuery {
	s.ReturnData = &v
	return s
}

// A GetMetricData call returns an array of MetricDataResult structures. Each
// of these structures includes the data points for that metric, along with
// the timestamps of those data points and other identifying information.
type MetricDataResult struct {
	_ struct{} `type:"structure"`

	// The short name you specified to represent this metric.
	Id *string `min:"1" type:"string"`

	// The human-readable label associated with the data.
	Label *string `type:"string"`

	// A list of messages with additional information about the data returned.
	Messages []*MessageData `type:"list"`

	// The status of the returned data. Complete indicates that all data points
	// in the requested time range were returned. PartialData means that an incomplete
	// set of data points were returned. You can use the NextToken value that was
	// returned and repeat your request to get more data points. NextToken is not
	// returned if you are performing a math expression. InternalError indicates
	// that an error occurred. Retry your request using NextToken, if present.
	StatusCode *string `type:"string" enum:"StatusCode"`

	// The timestamps for the data points, formatted in Unix timestamp format. The
	// number of timestamps always matches the number of values and the value for
	// Timestamps[x] is Values[x].
	Timestamps []*time.Time `type:"list"`

	// The data points for the metric corresponding to Timestamps. The number of
	// values always matches the number of timestamps and the timestamp for Values[x]
	// is Timestamps[x].
	Values []*float64 `type:"list"`
}

// String returns the string representation
func (s MetricDataResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDataResult) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *MetricDataResult) SetId(v string) *MetricDataResult {
	s.Id = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *MetricDataResult) SetLabel(v string) *MetricDataResult {
	s.Label = &v
	return s
}

// SetMessages sets the Messages field's value.
func (s *MetricDataResult) SetMessages(v []*MessageData) *MetricDataResult {
	s.Messages = v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *MetricDataResult) SetStatusCode(v string) *MetricDataResult {
	s.StatusCode = &v
	return s
}

// SetTimestamps sets the Timestamps field's value.
func (s *MetricDataResult) SetTimestamps(v []*time.Time) *MetricDataResult {
	s.Timestamps = v
	return s
}

// SetValues sets the Values field's value.
func (s *MetricDataResult) SetValues(v []*float64) *MetricDataResult {
	s.Values = v
	return s
}

// Encapsulates the information sent to either create a metric or add new values
// to be aggregated into an existing metric.
type MetricDatum struct {
	_ struct{} `type:"structure"`

	// Array of numbers that is used along with the Values array. Each number in
	// the Count array is the number of times the corresponding value in the Values
	// array occurred during the period.
	//
	// If you omit the Counts array, the default of 1 is used as the value for each
	// count. If you include a Counts array, it must include the same amount of
	// values as the Values array.
	Counts []*float64 `type:"list"`

	// The dimensions associated with the metric.
	Dimensions []*Dimension `type:"list"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The statistical values for the metric.
	StatisticValues *StatisticSet `type:"structure"`

	// Valid values are 1 and 60. Setting this to 1 specifies this metric as a high-resolution
	// metric, so that CloudWatch stores the metric with sub-minute resolution down
	// to one second. Setting this to 60 specifies this metric as a regular-resolution
	// metric, which CloudWatch stores at 1-minute resolution. Currently, high resolution
	// is available only for custom metrics. For more information about high-resolution
	// metrics, see High-Resolution Metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#high-resolution-metrics)
	// in the Amazon CloudWatch User Guide.
	//
	// This field is optional, if you do not specify it the default of 60 is used.
	StorageResolution *int64 `min:"1" type:"integer"`

	// The time the metric data was received, expressed as the number of milliseconds
	// since Jan 1, 1970 00:00:00 UTC.
	Timestamp *time.Time `type:"timestamp"`

	// The unit of the metric.
	Unit *string `type:"string" enum:"StandardUnit"`

	// The value for the metric.
	//
	// Although the parameter accepts numbers of type Double, CloudWatch rejects
	// values that are either too small or too large. Values must be in the range
	// of 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).
	// In addition, special values (for example, NaN, +Infinity, -Infinity) are
	// not supported.
	Value *float64 `type:"double"`

	// Array of numbers representing the values for the metric during the period.
	// Each unique value is listed just once in this array, and the corresponding
	// number in the Counts array specifies the number of times that value occurred
	// during the period. You can include up to 150 unique values in each PutMetricData
	// action that specifies a Values array.
	//
	// Although the Values array accepts numbers of type Double, CloudWatch rejects
	// values that are either too small or too large. Values must be in the range
	// of 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).
	// In addition, special values (for example, NaN, +Infinity, -Infinity) are
	// not supported.
	Values []*float64 `type:"list"`
}

// String returns the string representation
func (s MetricDatum) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDatum) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDatum) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDatum"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.StorageResolution != nil && *s.StorageResolution < 1 {
		invalidParams.Add(request.NewErrParamMinValue("StorageResolution", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StatisticValues != nil {
		if err := s.StatisticValues.Validate(); err != nil {
			invalidParams.AddNested("StatisticValues", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCounts sets the Counts field's value.
func (s *MetricDatum) SetCounts(v []*float64) *MetricDatum {
	s.Counts = v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *MetricDatum) SetDimensions(v []*Dimension) *MetricDatum {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *MetricDatum) SetMetricName(v string) *MetricDatum {
	s.MetricName = &v
	return s
}

// SetStatisticValues sets the StatisticValues field's value.
func (s *MetricDatum) SetStatisticValues(v *StatisticSet) *MetricDatum {
	s.StatisticValues = v
	return s
}

// SetStorageResolution sets the StorageResolution field's value.
func (s *MetricDatum) SetStorageResolution(v int64) *MetricDatum {
	s.StorageResolution = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *MetricDatum) SetTimestamp(v time.Time) *MetricDatum {
	s.Timestamp = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricDatum) SetUnit(v string) *MetricDatum {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MetricDatum) SetValue(v float64) *MetricDatum {
	s.Value = &v
	return s
}

// SetValues sets the Values field's value.
func (s *MetricDatum) SetValues(v []*float64) *MetricDatum {
	s.Values = v
	return s
}

// This structure defines the metric to be returned, along with the statistics,
// period, and units.
type MetricStat struct {
	_ struct{} `type:"structure"`

	// The metric to return, including the metric name, namespace, and dimensions.
	//
	// Metric is a required field
	Metric *Metric `type:"structure" required:"true"`

	// The period, in seconds, to use when retrieving the metric.
	//
	// Period is a required field
	Period *int64 `min:"1" type:"integer" required:"true"`

	// The statistic to return. It can include any CloudWatch statistic or extended
	// statistic.
	//
	// Stat is a required field
	Stat *string `type:"string" required:"true"`

	// The unit to use for the returned data points.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s MetricStat) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricStat) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricStat) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricStat"}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}
	if s.Stat == nil {
		invalidParams.Add(request.NewErrParamRequired("Stat"))
	}
	if s.Metric != nil {
		if err := s.Metric.Validate(); err != nil {
			invalidParams.AddNested("Metric", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetric sets the Metric field's value.
func (s *MetricStat) SetMetric(v *Metric) *MetricStat {
	s.Metric = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *MetricStat) SetPeriod(v int64) *MetricStat {
	s.Period = &v
	return s
}

// SetStat sets the Stat field's value.
func (s *MetricStat) SetStat(v string) *MetricStat {
	s.Stat = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricStat) SetUnit(v string) *MetricStat {
	s.Unit = &v
	return s
}

type PutDashboardInput struct {
	_ struct{} `type:"structure"`

	// The detailed information about the dashboard in JSON format, including the
	// widgets to include and their location on the dashboard. This parameter is
	// required.
	//
	// For more information about the syntax, see CloudWatch-Dashboard-Body-Structure.
	//
	// DashboardBody is a required field
	DashboardBody *string `type:"string" required:"true"`

	// The name of the dashboard. If a dashboard with this name already exists,
	// this call modifies that dashboard, replacing its current contents. Otherwise,
	// a new dashboard is created. The maximum length is 255, and valid characters
	// are A-Z, a-z, 0-9, "-", and "_". This parameter is required.
	//
	// DashboardName is a required field
	DashboardName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDashboardInput"}
	if s.DashboardBody == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardBody"))
	}
	if s.DashboardName == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboardBody sets the DashboardBody field's value.
func (s *PutDashboardInput) SetDashboardBody(v string) *PutDashboardInput {
	s.DashboardBody = &v
	return s
}

// SetDashboardName sets the DashboardName field's value.
func (s *PutDashboardInput) SetDashboardName(v string) *PutDashboardInput {
	s.DashboardName = &v
	return s
}

type PutDashboardOutput struct {
	_ struct{} `type:"structure"`

	// If the input for PutDashboard was correct and the dashboard was successfully
	// created or modified, this result is empty.
	//
	// If this result includes only warning messages, then the input was valid enough
	// for the dashboard to be created or modified, but some elements of the dashboard
	// may not render.
	//
	// If this result includes error messages, the input was not valid and the operation
	// failed.
	DashboardValidationMessages []*DashboardValidationMessage `type:"list"`
}

// String returns the string representation
func (s PutDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDashboardOutput) GoString() string {
	return s.String()
}

// SetDashboardValidationMessages sets the DashboardValidationMessages field's value.
func (s *PutDashboardOutput) SetDashboardValidationMessages(v []*DashboardValidationMessage) *PutDashboardOutput {
	s.DashboardValidationMessages = v
	return s
}

type PutMetricAlarmInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether actions should be executed during any changes to the alarm
	// state. The default is TRUE.
	ActionsEnabled *bool `type:"boolean"`

	// The actions to execute when this alarm transitions to the ALARM state from
	// any other state. Each action is specified as an Amazon Resource Name (ARN).
	//
	// Valid Values: arn:aws:automate:region:ec2:stop | arn:aws:automate:region:ec2:terminate
	// | arn:aws:automate:region:ec2:recover | arn:aws:automate:region:ec2:reboot
	// | arn:aws:sns:region:account-id:sns-topic-name | arn:aws:autoscaling:region:account-id:scalingPolicy:policy-idautoScalingGroupName/group-friendly-name:policyName/policy-friendly-name
	//
	// Valid Values (for use with IAM roles): arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Stop/1.0
	// | arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Terminate/1.0
	// | arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Reboot/1.0
	AlarmActions []*string `type:"list"`

	// The description for the alarm.
	AlarmDescription *string `type:"string"`

	// The name for the alarm. This name must be unique within your AWS account.
	//
	// AlarmName is a required field
	AlarmName *string `min:"1" type:"string" required:"true"`

	// The arithmetic operation to use when comparing the specified statistic and
	// threshold. The specified statistic value is used as the first operand.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true" enum:"ComparisonOperator"`

	// The number of datapoints that must be breaching to trigger the alarm. This
	// is used only if you are setting an "M out of N" alarm. In that case, this
	// value is the M. For more information, see Evaluating an Alarm (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation)
	// in the Amazon CloudWatch User Guide.
	DatapointsToAlarm *int64 `min:"1" type:"integer"`

	// The dimensions for the metric specified in MetricName.
	Dimensions []*Dimension `type:"list"`

	// Used only for alarms based on percentiles. If you specify ignore, the alarm
	// state does not change during periods with too few data points to be statistically
	// significant. If you specify evaluate or omit this parameter, the alarm is
	// always evaluated and possibly changes state no matter how many data points
	// are available. For more information, see Percentile-Based CloudWatch Alarms
	// and Low Data Samples (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples).
	//
	// Valid Values: evaluate | ignore
	EvaluateLowSampleCountPercentile *string `min:"1" type:"string"`

	// The number of periods over which data is compared to the specified threshold.
	// If you are setting an alarm that requires that a number of consecutive data
	// points be breaching to trigger the alarm, this value specifies that number.
	// If you are setting an "M out of N" alarm, this value is the N.
	//
	// An alarm's total current evaluation period can be no longer than one day,
	// so this number multiplied by Period cannot be more than 86,400 seconds.
	//
	// EvaluationPeriods is a required field
	EvaluationPeriods *int64 `min:"1" type:"integer" required:"true"`

	// The percentile statistic for the metric specified in MetricName. Specify
	// a value between p0.0 and p100. When you call PutMetricAlarm and specify a
	// MetricName, you must specify either Statistic or ExtendedStatistic, but not
	// both.
	ExtendedStatistic *string `type:"string"`

	// The actions to execute when this alarm transitions to the INSUFFICIENT_DATA
	// state from any other state. Each action is specified as an Amazon Resource
	// Name (ARN).
	//
	// Valid Values: arn:aws:automate:region:ec2:stop | arn:aws:automate:region:ec2:terminate
	// | arn:aws:automate:region:ec2:recover | arn:aws:automate:region:ec2:reboot
	// | arn:aws:sns:region:account-id:sns-topic-name | arn:aws:autoscaling:region:account-id:scalingPolicy:policy-idautoScalingGroupName/group-friendly-name:policyName/policy-friendly-name
	//
	// Valid Values (for use with IAM roles): >arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Stop/1.0
	// | arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Terminate/1.0
	// | arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Reboot/1.0
	InsufficientDataActions []*string `type:"list"`

	// The name for the metric associated with the alarm.
	//
	// If you are creating an alarm based on a math expression, you cannot specify
	// this parameter, or any of the Dimensions, Period, Namespace, Statistic, or
	// ExtendedStatistic parameters. Instead, you specify all this information in
	// the Metrics array.
	MetricName *string `min:"1" type:"string"`

	// An array of MetricDataQuery structures that enable you to create an alarm
	// based on the result of a metric math expression. Each item in the Metrics
	// array either retrieves a metric or performs a math expression.
	//
	// One item in the Metrics array is the expression that the alarm watches. You
	// designate this expression by setting ReturnValue to true for this object
	// in the array. For more information, see MetricDataQuery.
	//
	// If you use the Metrics parameter, you cannot include the MetricName, Dimensions,
	// Period, Namespace, Statistic, or ExtendedStatistic parameters of PutMetricAlarm
	// in the same operation. Instead, you retrieve the metrics you are using in
	// your math expression as part of the Metrics array.
	Metrics []*MetricDataQuery `type:"list"`

	// The namespace for the metric associated specified in MetricName.
	Namespace *string `min:"1" type:"string"`

	// The actions to execute when this alarm transitions to an OK state from any
	// other state. Each action is specified as an Amazon Resource Name (ARN).
	//
	// Valid Values: arn:aws:automate:region:ec2:stop | arn:aws:automate:region:ec2:terminate
	// | arn:aws:automate:region:ec2:recover | arn:aws:automate:region:ec2:reboot
	// | arn:aws:sns:region:account-id:sns-topic-name | arn:aws:autoscaling:region:account-id:scalingPolicy:policy-idautoScalingGroupName/group-friendly-name:policyName/policy-friendly-name
	//
	// Valid Values (for use with IAM roles): arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Stop/1.0
	// | arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Terminate/1.0
	// | arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Reboot/1.0
	OKActions []*string `type:"list"`

	// The length, in seconds, used each time the metric specified in MetricName
	// is evaluated. Valid values are 10, 30, and any multiple of 60.
	//
	// Be sure to specify 10 or 30 only for metrics that are stored by a PutMetricData
	// call with a StorageResolution of 1. If you specify a period of 10 or 30 for
	// a metric that does not have sub-minute resolution, the alarm still attempts
	// to gather data at the period rate that you specify. In this case, it does
	// not receive data for the attempts that do not correspond to a one-minute
	// data resolution, and the alarm may often lapse into INSUFFICENT_DATA status.
	// Specifying 10 or 30 also sets this alarm as a high-resolution alarm, which
	// has a higher charge than other alarms. For more information about pricing,
	// see Amazon CloudWatch Pricing (https://aws.amazon.com/cloudwatch/pricing/).
	//
	// An alarm's total current evaluation period can be no longer than one day,
	// so Period multiplied by EvaluationPeriods cannot be more than 86,400 seconds.
	Period *int64 `min:"1" type:"integer"`

	// The statistic for the metric specified in MetricName, other than percentile.
	// For percentile statistics, use ExtendedStatistic. When you call PutMetricAlarm
	// and specify a MetricName, you must specify either Statistic or ExtendedStatistic,
	// but not both.
	Statistic *string `type:"string" enum:"Statistic"`

	// The value against which the specified statistic is compared.
	//
	// Threshold is a required field
	Threshold *float64 `type:"double" required:"true"`

	// Sets how this alarm is to handle missing data points. If TreatMissingData
	// is omitted, the default behavior of missing is used. For more information,
	// see Configuring How CloudWatch Alarms Treats Missing Data (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data).
	//
	// Valid Values: breaching | notBreaching | ignore | missing
	TreatMissingData *string `min:"1" type:"string"`

	// The unit of measure for the statistic. For example, the units for the Amazon
	// EC2 NetworkIn metric are Bytes because NetworkIn tracks the number of bytes
	// that an instance receives on all network interfaces. You can also specify
	// a unit when you create a custom metric. Units help provide conceptual meaning
	// to your data. Metric data points that specify a unit of measure, such as
	// Percent, are aggregated separately.
	//
	// If you specify a unit, you must use a unit that is appropriate for the metric.
	// Otherwise, the CloudWatch alarm can get stuck in the INSUFFICIENT DATA state.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s PutMetricAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetricAlarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMetricAlarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMetricAlarmInput"}
	if s.AlarmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmName"))
	}
	if s.AlarmName != nil && len(*s.AlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmName", 1))
	}
	if s.ComparisonOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("ComparisonOperator"))
	}
	if s.DatapointsToAlarm != nil && *s.DatapointsToAlarm < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DatapointsToAlarm", 1))
	}
	if s.EvaluateLowSampleCountPercentile != nil && len(*s.EvaluateLowSampleCountPercentile) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EvaluateLowSampleCountPercentile", 1))
	}
	if s.EvaluationPeriods == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationPeriods"))
	}
	if s.EvaluationPeriods != nil && *s.EvaluationPeriods < 1 {
		invalidParams.Add(request.NewErrParamMinValue("EvaluationPeriods", 1))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}
	if s.Threshold == nil {
		invalidParams.Add(request.NewErrParamRequired("Threshold"))
	}
	if s.TreatMissingData != nil && len(*s.TreatMissingData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TreatMissingData", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Metrics != nil {
		for i, v := range s.Metrics {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Metrics", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionsEnabled sets the ActionsEnabled field's value.
func (s *PutMetricAlarmInput) SetActionsEnabled(v bool) *PutMetricAlarmInput {
	s.ActionsEnabled = &v
	return s
}

// SetAlarmActions sets the AlarmActions field's value.
func (s *PutMetricAlarmInput) SetAlarmActions(v []*string) *PutMetricAlarmInput {
	s.AlarmActions = v
	return s
}

// SetAlarmDescription sets the AlarmDescription field's value.
func (s *PutMetricAlarmInput) SetAlarmDescription(v string) *PutMetricAlarmInput {
	s.AlarmDescription = &v
	return s
}

// SetAlarmName sets the AlarmName field's value.
func (s *PutMetricAlarmInput) SetAlarmName(v string) *PutMetricAlarmInput {
	s.AlarmName = &v
	return s
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *PutMetricAlarmInput) SetComparisonOperator(v string) *PutMetricAlarmInput {
	s.ComparisonOperator = &v
	return s
}

// SetDatapointsToAlarm sets the DatapointsToAlarm field's value.
func (s *PutMetricAlarmInput) SetDatapointsToAlarm(v int64) *PutMetricAlarmInput {
	s.DatapointsToAlarm = &v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *PutMetricAlarmInput) SetDimensions(v []*Dimension) *PutMetricAlarmInput {
	s.Dimensions = v
	return s
}

// SetEvaluateLowSampleCountPercentile sets the EvaluateLowSampleCountPercentile field's value.
func (s *PutMetricAlarmInput) SetEvaluateLowSampleCountPercentile(v string) *PutMetricAlarmInput {
	s.EvaluateLowSampleCountPercentile = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *PutMetricAlarmInput) SetEvaluationPeriods(v int64) *PutMetricAlarmInput {
	s.EvaluationPeriods = &v
	return s
}

// SetExtendedStatistic sets the ExtendedStatistic field's value.
func (s *PutMetricAlarmInput) SetExtendedStatistic(v string) *PutMetricAlarmInput {
	s.ExtendedStatistic = &v
	return s
}

// SetInsufficientDataActions sets the InsufficientDataActions field's value.
func (s *PutMetricAlarmInput) SetInsufficientDataActions(v []*string) *PutMetricAlarmInput {
	s.InsufficientDataActions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *PutMetricAlarmInput) SetMetricName(v string) *PutMetricAlarmInput {
	s.MetricName = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *PutMetricAlarmInput) SetMetrics(v []*MetricDataQuery) *PutMetricAlarmInput {
	s.Metrics = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PutMetricAlarmInput) SetNamespace(v string) *PutMetricAlarmInput {
	s.Namespace = &v
	return s
}

// SetOKActions sets the OKActions field's value.
func (s *PutMetricAlarmInput) SetOKActions(v []*string) *PutMetricAlarmInput {
	s.OKActions = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *PutMetricAlarmInput) SetPeriod(v int64) *PutMetricAlarmInput {
	s.Period = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *PutMetricAlarmInput) SetStatistic(v string) *PutMetricAlarmInput {
	s.Statistic = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *PutMetricAlarmInput) SetThreshold(v float64) *PutMetricAlarmInput {
	s.Threshold = &v
	return s
}

// SetTreatMissingData sets the TreatMissingData field's value.
func (s *PutMetricAlarmInput) SetTreatMissingData(v string) *PutMetricAlarmInput {
	s.TreatMissingData = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *PutMetricAlarmInput) SetUnit(v string) *PutMetricAlarmInput {
	s.Unit = &v
	return s
}

type PutMetricAlarmOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutMetricAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetricAlarmOutput) GoString() string {
	return s.String()
}

type PutMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The data for the metric. The array can include no more than 20 metrics per
	// call.
	//
	// MetricData is a required field
	MetricData []*MetricDatum `type:"list" required:"true"`

	// The namespace for the metric data.
	//
	// You cannot specify a namespace that begins with "AWS/". Namespaces that begin
	// with "AWS/" are reserved for use by Amazon Web Services products.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetricDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMetricDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMetricDataInput"}
	if s.MetricData == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricData"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.MetricData != nil {
		for i, v := range s.MetricData {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricData", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricData sets the MetricData field's value.
func (s *PutMetricDataInput) SetMetricData(v []*MetricDatum) *PutMetricDataInput {
	s.MetricData = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PutMetricDataInput) SetNamespace(v string) *PutMetricDataInput {
	s.Namespace = &v
	return s
}

type PutMetricDataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetricDataOutput) GoString() string {
	return s.String()
}

type SetAlarmStateInput struct {
	_ struct{} `type:"structure"`

	// The name for the alarm. This name must be unique within the AWS account.
	// The maximum length is 255 characters.
	//
	// AlarmName is a required field
	AlarmName *string `min:"1" type:"string" required:"true"`

	// The reason that this alarm is set to this specific state, in text format.
	//
	// StateReason is a required field
	StateReason *string `type:"string" required:"true"`

	// The reason that this alarm is set to this specific state, in JSON format.
	StateReasonData *string `type:"string"`

	// The value of the state.
	//
	// StateValue is a required field
	StateValue *string `type:"string" required:"true" enum:"StateValue"`
}

// String returns the string representation
func (s SetAlarmStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetAlarmStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetAlarmStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetAlarmStateInput"}
	if s.AlarmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmName"))
	}
	if s.AlarmName != nil && len(*s.AlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmName", 1))
	}
	if s.StateReason == nil {
		invalidParams.Add(request.NewErrParamRequired("StateReason"))
	}
	if s.StateValue == nil {
		invalidParams.Add(request.NewErrParamRequired("StateValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmName sets the AlarmName field's value.
func (s *SetAlarmStateInput) SetAlarmName(v string) *SetAlarmStateInput {
	s.AlarmName = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *SetAlarmStateInput) SetStateReason(v string) *SetAlarmStateInput {
	s.StateReason = &v
	return s
}

// SetStateReasonData sets the StateReasonData field's value.
func (s *SetAlarmStateInput) SetStateReasonData(v string) *SetAlarmStateInput {
	s.StateReasonData = &v
	return s
}

// SetStateValue sets the StateValue field's value.
func (s *SetAlarmStateInput) SetStateValue(v string) *SetAlarmStateInput {
	s.StateValue = &v
	return s
}

type SetAlarmStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetAlarmStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetAlarmStateOutput) GoString() string {
	return s.String()
}

// Represents a set of statistics that describes a specific metric.
type StatisticSet struct {
	_ struct{} `type:"structure"`

	// The maximum value of the sample set.
	//
	// Maximum is a required field
	Maximum *float64 `type:"double" required:"true"`

	// The minimum value of the sample set.
	//
	// Minimum is a required field
	Minimum *float64 `type:"double" required:"true"`

	// The number of samples used for the statistic set.
	//
	// SampleCount is a required field
	SampleCount *float64 `type:"double" required:"true"`

	// The sum of values for the sample set.
	//
	// Sum is a required field
	Sum *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s StatisticSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatisticSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatisticSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StatisticSet"}
	if s.Maximum == nil {
		invalidParams.Add(request.NewErrParamRequired("Maximum"))
	}
	if s.Minimum == nil {
		invalidParams.Add(request.NewErrParamRequired("Minimum"))
	}
	if s.SampleCount == nil {
		invalidParams.Add(request.NewErrParamRequired("SampleCount"))
	}
	if s.Sum == nil {
		invalidParams.Add(request.NewErrParamRequired("Sum"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximum sets the Maximum field's value.
func (s *StatisticSet) SetMaximum(v float64) *StatisticSet {
	s.Maximum = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *StatisticSet) SetMinimum(v float64) *StatisticSet {
	s.Minimum = &v
	return s
}

// SetSampleCount sets the SampleCount field's value.
func (s *StatisticSet) SetSampleCount(v float64) *StatisticSet {
	s.SampleCount = &v
	return s
}

// SetSum sets the Sum field's value.
func (s *StatisticSet) SetSum(v float64) *StatisticSet {
	s.Sum = &v
	return s
}

const (
	// ComparisonOperatorGreaterThanOrEqualToThreshold is a ComparisonOperator enum value
	ComparisonOperatorGreaterThanOrEqualToThreshold = "GreaterThanOrEqualToThreshold"

	// ComparisonOperatorGreaterThanThreshold is a ComparisonOperator enum value
	ComparisonOperatorGreaterThanThreshold = "GreaterThanThreshold"

	// ComparisonOperatorLessThanThreshold is a ComparisonOperator enum value
	ComparisonOperatorLessThanThreshold = "LessThanThreshold"

	// ComparisonOperatorLessThanOrEqualToThreshold is a ComparisonOperator enum value
	ComparisonOperatorLessThanOrEqualToThreshold = "LessThanOrEqualToThreshold"
)

const (
	// HistoryItemTypeConfigurationUpdate is a HistoryItemType enum value
	HistoryItemTypeConfigurationUpdate = "ConfigurationUpdate"

	// HistoryItemTypeStateUpdate is a HistoryItemType enum value
	HistoryItemTypeStateUpdate = "StateUpdate"

	// HistoryItemTypeAction is a HistoryItemType enum value
	HistoryItemTypeAction = "Action"
)

const (
	// ScanByTimestampDescending is a ScanBy enum value
	ScanByTimestampDescending = "TimestampDescending"

	// ScanByTimestampAscending is a ScanBy enum value
	ScanByTimestampAscending = "TimestampAscending"
)

const (
	// StandardUnitSeconds is a StandardUnit enum value
	StandardUnitSeconds = "Seconds"

	// StandardUnitMicroseconds is a StandardUnit enum value
	StandardUnitMicroseconds = "Microseconds"

	// StandardUnitMilliseconds is a StandardUnit enum value
	StandardUnitMilliseconds = "Milliseconds"

	// StandardUnitBytes is a StandardUnit enum value
	StandardUnitBytes = "Bytes"

	// StandardUnitKilobytes is a StandardUnit enum value
	StandardUnitKilobytes = "Kilobytes"

	// StandardUnitMegabytes is a StandardUnit enum value
	StandardUnitMegabytes = "Megabytes"

	// StandardUnitGigabytes is a StandardUnit enum value
	StandardUnitGigabytes = "Gigabytes"

	// StandardUnitTerabytes is a StandardUnit enum value
	StandardUnitTerabytes = "Terabytes"

	// StandardUnitBits is a StandardUnit enum value
	StandardUnitBits = "Bits"

	// StandardUnitKilobits is a StandardUnit enum value
	StandardUnitKilobits = "Kilobits"

	// StandardUnitMegabits is a StandardUnit enum value
	StandardUnitMegabits = "Megabits"

	// StandardUnitGigabits is a StandardUnit enum value
	StandardUnitGigabits = "Gigabits"

	// StandardUnitTerabits is a StandardUnit enum value
	StandardUnitTerabits = "Terabits"

	// StandardUnitPercent is a StandardUnit enum value
	StandardUnitPercent = "Percent"

	// StandardUnitCount is a StandardUnit enum value
	StandardUnitCount = "Count"

	// StandardUnitBytesSecond is a StandardUnit enum value
	StandardUnitBytesSecond = "Bytes/Second"

	// StandardUnitKilobytesSecond is a StandardUnit enum value
	StandardUnitKilobytesSecond = "Kilobytes/Second"

	// StandardUnitMegabytesSecond is a StandardUnit enum value
	StandardUnitMegabytesSecond = "Megabytes/Second"

	// StandardUnitGigabytesSecond is a StandardUnit enum value
	StandardUnitGigabytesSecond = "Gigabytes/Second"

	// StandardUnitTerabytesSecond is a StandardUnit enum value
	StandardUnitTerabytesSecond = "Terabytes/Second"

	// StandardUnitBitsSecond is a StandardUnit enum value
	StandardUnitBitsSecond = "Bits/Second"

	// StandardUnitKilobitsSecond is a StandardUnit enum value
	StandardUnitKilobitsSecond = "Kilobits/Second"

	// StandardUnitMegabitsSecond is a StandardUnit enum value
	StandardUnitMegabitsSecond = "Megabits/Second"

	// StandardUnitGigabitsSecond is a StandardUnit enum value
	StandardUnitGigabitsSecond = "Gigabits/Second"

	// StandardUnitTerabitsSecond is a StandardUnit enum value
	StandardUnitTerabitsSecond = "Terabits/Second"

	// StandardUnitCountSecond is a StandardUnit enum value
	StandardUnitCountSecond = "Count/Second"

	// StandardUnitNone is a StandardUnit enum value
	StandardUnitNone = "None"
)

const (
	// StateValueOk is a StateValue enum value
	StateValueOk = "OK"

	// StateValueAlarm is a StateValue enum value
	StateValueAlarm = "ALARM"

	// StateValueInsufficientData is a StateValue enum value
	StateValueInsufficientData = "INSUFFICIENT_DATA"
)

const (
	// StatisticSampleCount is a Statistic enum value
	StatisticSampleCount = "SampleCount"

	// StatisticAverage is a Statistic enum value
	StatisticAverage = "Average"

	// StatisticSum is a Statistic enum value
	StatisticSum = "Sum"

	// StatisticMinimum is a Statistic enum value
	StatisticMinimum = "Minimum"

	// StatisticMaximum is a Statistic enum value
	StatisticMaximum = "Maximum"
)

const (
	// StatusCodeComplete is a StatusCode enum value
	StatusCodeComplete = "Complete"

	// StatusCodeInternalError is a StatusCode enum value
	StatusCodeInternalError = "InternalError"

	// StatusCodePartialData is a StatusCode enum value
	StatusCodePartialData = "PartialData"
)
