// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateRelationalDatabaseParametersInput struct {
	_ struct{} `type:"structure"`

	// The database parameters to update.
	//
	// Parameters is a required field
	Parameters []RelationalDatabaseParameter `locationName:"parameters" type:"list" required:"true"`

	// The name of your database for which to update parameters.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRelationalDatabaseParametersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRelationalDatabaseParametersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRelationalDatabaseParametersInput"}

	if s.Parameters == nil {
		invalidParams.Add(aws.NewErrParamRequired("Parameters"))
	}

	if s.RelationalDatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateRelationalDatabaseParametersOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your update relational database parameters
	// request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s UpdateRelationalDatabaseParametersOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateRelationalDatabaseParameters = "UpdateRelationalDatabaseParameters"

// UpdateRelationalDatabaseParametersRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Allows the update of one or more parameters of a database in Amazon Lightsail.
//
// Parameter updates don't cause outages; therefore, their application is not
// subject to the preferred maintenance window. However, there are two ways
// in which paramater updates are applied: dynamic or pending-reboot. Parameters
// marked with a dynamic apply type are applied immediately. Parameters marked
// with a pending-reboot apply type are applied only after the database is rebooted
// using the reboot relational database operation.
//
// The update relational database parameters operation supports tag-based access
// control via resource tags applied to the resource identified by relationalDatabaseName.
// For more information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using UpdateRelationalDatabaseParametersRequest.
//    req := client.UpdateRelationalDatabaseParametersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabaseParameters
func (c *Client) UpdateRelationalDatabaseParametersRequest(input *UpdateRelationalDatabaseParametersInput) UpdateRelationalDatabaseParametersRequest {
	op := &aws.Operation{
		Name:       opUpdateRelationalDatabaseParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRelationalDatabaseParametersInput{}
	}

	req := c.newRequest(op, input, &UpdateRelationalDatabaseParametersOutput{})
	return UpdateRelationalDatabaseParametersRequest{Request: req, Input: input, Copy: c.UpdateRelationalDatabaseParametersRequest}
}

// UpdateRelationalDatabaseParametersRequest is the request type for the
// UpdateRelationalDatabaseParameters API operation.
type UpdateRelationalDatabaseParametersRequest struct {
	*aws.Request
	Input *UpdateRelationalDatabaseParametersInput
	Copy  func(*UpdateRelationalDatabaseParametersInput) UpdateRelationalDatabaseParametersRequest
}

// Send marshals and sends the UpdateRelationalDatabaseParameters API request.
func (r UpdateRelationalDatabaseParametersRequest) Send(ctx context.Context) (*UpdateRelationalDatabaseParametersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRelationalDatabaseParametersResponse{
		UpdateRelationalDatabaseParametersOutput: r.Request.Data.(*UpdateRelationalDatabaseParametersOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRelationalDatabaseParametersResponse is the response type for the
// UpdateRelationalDatabaseParameters API operation.
type UpdateRelationalDatabaseParametersResponse struct {
	*UpdateRelationalDatabaseParametersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRelationalDatabaseParameters request.
func (r *UpdateRelationalDatabaseParametersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
