// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package support

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddAttachmentsToSet = "AddAttachmentsToSet"

// AddAttachmentsToSetRequest generates a "aws/request.Request" representing the
// client's request for the AddAttachmentsToSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddAttachmentsToSet for more information on using the AddAttachmentsToSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddAttachmentsToSetRequest method.
//    req, resp := client.AddAttachmentsToSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/AddAttachmentsToSet
func (c *Support) AddAttachmentsToSetRequest(input *AddAttachmentsToSetInput) (req *request.Request, output *AddAttachmentsToSetOutput) {
	op := &request.Operation{
		Name:       opAddAttachmentsToSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddAttachmentsToSetInput{}
	}

	output = &AddAttachmentsToSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddAttachmentsToSet API operation for AWS Support.
//
// Adds one or more attachments to an attachment set. If an attachmentSetId
// is not specified, a new attachment set is created, and the ID of the set
// is returned in the response. If an attachmentSetId is specified, the attachments
// are added to the specified set, if it exists.
//
// An attachment set is a temporary container for attachments that are to be
// added to a case or case communication. The set is available for one hour
// after it is created; the expiryTime returned in the response indicates when
// the set expires. The maximum number of attachments in a set is 3, and the
// maximum size of any attachment in the set is 5 MB.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation AddAttachmentsToSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error occurred.
//
//   * ErrCodeAttachmentSetIdNotFound "AttachmentSetIdNotFound"
//   An attachment set with the specified ID could not be found.
//
//   * ErrCodeAttachmentSetExpired "AttachmentSetExpired"
//   The expiration time of the attachment set has passed. The set expires 1 hour
//   after it is created.
//
//   * ErrCodeAttachmentSetSizeLimitExceeded "AttachmentSetSizeLimitExceeded"
//   A limit for the size of an attachment set has been exceeded. The limits are
//   3 attachments and 5 MB per attachment.
//
//   * ErrCodeAttachmentLimitExceeded "AttachmentLimitExceeded"
//   The limit for the number of attachment sets created in a short period of
//   time has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/AddAttachmentsToSet
func (c *Support) AddAttachmentsToSet(input *AddAttachmentsToSetInput) (*AddAttachmentsToSetOutput, error) {
	req, out := c.AddAttachmentsToSetRequest(input)
	return out, req.Send()
}

// AddAttachmentsToSetWithContext is the same as AddAttachmentsToSet with the addition of
// the ability to pass a context and additional request options.
//
// See AddAttachmentsToSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) AddAttachmentsToSetWithContext(ctx aws.Context, input *AddAttachmentsToSetInput, opts ...request.Option) (*AddAttachmentsToSetOutput, error) {
	req, out := c.AddAttachmentsToSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddCommunicationToCase = "AddCommunicationToCase"

// AddCommunicationToCaseRequest generates a "aws/request.Request" representing the
// client's request for the AddCommunicationToCase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddCommunicationToCase for more information on using the AddCommunicationToCase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddCommunicationToCaseRequest method.
//    req, resp := client.AddCommunicationToCaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/AddCommunicationToCase
func (c *Support) AddCommunicationToCaseRequest(input *AddCommunicationToCaseInput) (req *request.Request, output *AddCommunicationToCaseOutput) {
	op := &request.Operation{
		Name:       opAddCommunicationToCase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddCommunicationToCaseInput{}
	}

	output = &AddCommunicationToCaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddCommunicationToCase API operation for AWS Support.
//
// Adds additional customer communication to an AWS Support case. You use the
// caseId value to identify the case to add communication to. You can list a
// set of email addresses to copy on the communication using the ccEmailAddresses
// value. The communicationBody value contains the text of the communication.
//
// The response indicates the success or failure of the request.
//
// This operation implements a subset of the features of the AWS Support Center.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation AddCommunicationToCase for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error occurred.
//
//   * ErrCodeCaseIdNotFound "CaseIdNotFound"
//   The requested caseId could not be located.
//
//   * ErrCodeAttachmentSetIdNotFound "AttachmentSetIdNotFound"
//   An attachment set with the specified ID could not be found.
//
//   * ErrCodeAttachmentSetExpired "AttachmentSetExpired"
//   The expiration time of the attachment set has passed. The set expires 1 hour
//   after it is created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/AddCommunicationToCase
func (c *Support) AddCommunicationToCase(input *AddCommunicationToCaseInput) (*AddCommunicationToCaseOutput, error) {
	req, out := c.AddCommunicationToCaseRequest(input)
	return out, req.Send()
}

// AddCommunicationToCaseWithContext is the same as AddCommunicationToCase with the addition of
// the ability to pass a context and additional request options.
//
// See AddCommunicationToCase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) AddCommunicationToCaseWithContext(ctx aws.Context, input *AddCommunicationToCaseInput, opts ...request.Option) (*AddCommunicationToCaseOutput, error) {
	req, out := c.AddCommunicationToCaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCase = "CreateCase"

// CreateCaseRequest generates a "aws/request.Request" representing the
// client's request for the CreateCase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCase for more information on using the CreateCase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCaseRequest method.
//    req, resp := client.CreateCaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/CreateCase
func (c *Support) CreateCaseRequest(input *CreateCaseInput) (req *request.Request, output *CreateCaseOutput) {
	op := &request.Operation{
		Name:       opCreateCase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCaseInput{}
	}

	output = &CreateCaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCase API operation for AWS Support.
//
// Creates a new case in the AWS Support Center. This operation is modeled on
// the behavior of the AWS Support Center Create Case (https://console.aws.amazon.com/support/home#/case/create)
// page. Its parameters require you to specify the following information:
//
//    * issueType. The type of issue for the case. You can specify either "customer-service"
//    or "technical." If you do not indicate a value, the default is "technical."
//
//    * serviceCode. The code for an AWS service. You obtain the serviceCode
//    by calling DescribeServices.
//
//    * categoryCode. The category for the service defined for the serviceCode
//    value. You also obtain the category code for a service by calling DescribeServices.
//    Each AWS service defines its own set of category codes.
//
//    * severityCode. A value that indicates the urgency of the case, which
//    in turn determines the response time according to your service level agreement
//    with AWS Support. You obtain the SeverityCode by calling DescribeSeverityLevels.
//
//    * subject. The Subject field on the AWS Support Center Create Case (https://console.aws.amazon.com/support/home#/case/create)
//    page.
//
//    * communicationBody. The Description field on the AWS Support Center Create
//    Case (https://console.aws.amazon.com/support/home#/case/create) page.
//
//    * attachmentSetId. The ID of a set of attachments that has been created
//    by using AddAttachmentsToSet.
//
//    * language. The human language in which AWS Support handles the case.
//    English and Japanese are currently supported.
//
//    * ccEmailAddresses. The AWS Support Center CC field on the Create Case
//    (https://console.aws.amazon.com/support/home#/case/create) page. You can
//    list email addresses to be copied on any correspondence about the case.
//    The account that opens the case is already identified by passing the AWS
//    Credentials in the HTTP POST method or in a method or function call from
//    one of the programming languages supported by an AWS SDK (http://aws.amazon.com/tools/).
//
// To add additional communication or attachments to an existing case, use AddCommunicationToCase.
//
// A successful CreateCase request returns an AWS Support case number. Case
// numbers are used by the DescribeCases operation to retrieve existing AWS
// Support cases.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation CreateCase for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error occurred.
//
//   * ErrCodeCaseCreationLimitExceeded "CaseCreationLimitExceeded"
//   The case creation limit for the account has been exceeded.
//
//   * ErrCodeAttachmentSetIdNotFound "AttachmentSetIdNotFound"
//   An attachment set with the specified ID could not be found.
//
//   * ErrCodeAttachmentSetExpired "AttachmentSetExpired"
//   The expiration time of the attachment set has passed. The set expires 1 hour
//   after it is created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/CreateCase
func (c *Support) CreateCase(input *CreateCaseInput) (*CreateCaseOutput, error) {
	req, out := c.CreateCaseRequest(input)
	return out, req.Send()
}

// CreateCaseWithContext is the same as CreateCase with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) CreateCaseWithContext(ctx aws.Context, input *CreateCaseInput, opts ...request.Option) (*CreateCaseOutput, error) {
	req, out := c.CreateCaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAttachment = "DescribeAttachment"

// DescribeAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAttachment for more information on using the DescribeAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAttachmentRequest method.
//    req, resp := client.DescribeAttachmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeAttachment
func (c *Support) DescribeAttachmentRequest(input *DescribeAttachmentInput) (req *request.Request, output *DescribeAttachmentOutput) {
	op := &request.Operation{
		Name:       opDescribeAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAttachmentInput{}
	}

	output = &DescribeAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAttachment API operation for AWS Support.
//
// Returns the attachment that has the specified ID. Attachment IDs are generated
// by the case management system when you add an attachment to a case or case
// communication. Attachment IDs are returned in the AttachmentDetails objects
// that are returned by the DescribeCommunications operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeAttachment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error occurred.
//
//   * ErrCodeDescribeAttachmentLimitExceeded "DescribeAttachmentLimitExceeded"
//   The limit for the number of DescribeAttachment requests in a short period
//   of time has been exceeded.
//
//   * ErrCodeAttachmentIdNotFound "AttachmentIdNotFound"
//   An attachment with the specified ID could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeAttachment
func (c *Support) DescribeAttachment(input *DescribeAttachmentInput) (*DescribeAttachmentOutput, error) {
	req, out := c.DescribeAttachmentRequest(input)
	return out, req.Send()
}

// DescribeAttachmentWithContext is the same as DescribeAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) DescribeAttachmentWithContext(ctx aws.Context, input *DescribeAttachmentInput, opts ...request.Option) (*DescribeAttachmentOutput, error) {
	req, out := c.DescribeAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCases = "DescribeCases"

// DescribeCasesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCases for more information on using the DescribeCases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCasesRequest method.
//    req, resp := client.DescribeCasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCases
func (c *Support) DescribeCasesRequest(input *DescribeCasesInput) (req *request.Request, output *DescribeCasesOutput) {
	op := &request.Operation{
		Name:       opDescribeCases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCasesInput{}
	}

	output = &DescribeCasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCases API operation for AWS Support.
//
// Returns a list of cases that you specify by passing one or more case IDs.
// In addition, you can filter the cases by date by setting values for the afterTime
// and beforeTime request parameters. You can set values for the includeResolvedCases
// and includeCommunications request parameters to control how much information
// is returned.
//
// Case data is available for 12 months after creation. If a case was created
// more than 12 months ago, a request for data might cause an error.
//
// The response returns the following in JSON format:
//
//    * One or more CaseDetails data types.
//
//    * One or more nextToken values, which specify where to paginate the returned
//    records represented by the CaseDetails objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeCases for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error occurred.
//
//   * ErrCodeCaseIdNotFound "CaseIdNotFound"
//   The requested caseId could not be located.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCases
func (c *Support) DescribeCases(input *DescribeCasesInput) (*DescribeCasesOutput, error) {
	req, out := c.DescribeCasesRequest(input)
	return out, req.Send()
}

// DescribeCasesWithContext is the same as DescribeCases with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) DescribeCasesWithContext(ctx aws.Context, input *DescribeCasesInput, opts ...request.Option) (*DescribeCasesOutput, error) {
	req, out := c.DescribeCasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCasesPages iterates over the pages of a DescribeCases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCases operation.
//    pageNum := 0
//    err := client.DescribeCasesPages(params,
//        func(page *support.DescribeCasesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Support) DescribeCasesPages(input *DescribeCasesInput, fn func(*DescribeCasesOutput, bool) bool) error {
	return c.DescribeCasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCasesPagesWithContext same as DescribeCasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) DescribeCasesPagesWithContext(ctx aws.Context, input *DescribeCasesInput, fn func(*DescribeCasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeCasesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeCommunications = "DescribeCommunications"

// DescribeCommunicationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCommunications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCommunications for more information on using the DescribeCommunications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCommunicationsRequest method.
//    req, resp := client.DescribeCommunicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCommunications
func (c *Support) DescribeCommunicationsRequest(input *DescribeCommunicationsInput) (req *request.Request, output *DescribeCommunicationsOutput) {
	op := &request.Operation{
		Name:       opDescribeCommunications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCommunicationsInput{}
	}

	output = &DescribeCommunicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCommunications API operation for AWS Support.
//
// Returns communications (and attachments) for one or more support cases. You
// can use the afterTime and beforeTime parameters to filter by date. You can
// use the caseId parameter to restrict the results to a particular case.
//
// Case data is available for 12 months after creation. If a case was created
// more than 12 months ago, a request for data might cause an error.
//
// You can use the maxResults and nextToken parameters to control the pagination
// of the result set. Set maxResults to the number of cases you want displayed
// on each page, and use nextToken to specify the resumption of pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeCommunications for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error occurred.
//
//   * ErrCodeCaseIdNotFound "CaseIdNotFound"
//   The requested caseId could not be located.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCommunications
func (c *Support) DescribeCommunications(input *DescribeCommunicationsInput) (*DescribeCommunicationsOutput, error) {
	req, out := c.DescribeCommunicationsRequest(input)
	return out, req.Send()
}

// DescribeCommunicationsWithContext is the same as DescribeCommunications with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCommunications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) DescribeCommunicationsWithContext(ctx aws.Context, input *DescribeCommunicationsInput, opts ...request.Option) (*DescribeCommunicationsOutput, error) {
	req, out := c.DescribeCommunicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCommunicationsPages iterates over the pages of a DescribeCommunications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCommunications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCommunications operation.
//    pageNum := 0
//    err := client.DescribeCommunicationsPages(params,
//        func(page *support.DescribeCommunicationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Support) DescribeCommunicationsPages(input *DescribeCommunicationsInput, fn func(*DescribeCommunicationsOutput, bool) bool) error {
	return c.DescribeCommunicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCommunicationsPagesWithContext same as DescribeCommunicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) DescribeCommunicationsPagesWithContext(ctx aws.Context, input *DescribeCommunicationsInput, fn func(*DescribeCommunicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCommunicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCommunicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeCommunicationsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeServices = "DescribeServices"

// DescribeServicesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeServices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeServices for more information on using the DescribeServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeServicesRequest method.
//    req, resp := client.DescribeServicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeServices
func (c *Support) DescribeServicesRequest(input *DescribeServicesInput) (req *request.Request, output *DescribeServicesOutput) {
	op := &request.Operation{
		Name:       opDescribeServices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServicesInput{}
	}

	output = &DescribeServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeServices API operation for AWS Support.
//
// Returns the current list of AWS services and a list of service categories
// that applies to each one. You then use service names and categories in your
// CreateCase requests. Each AWS service has its own set of categories.
//
// The service codes and category codes correspond to the values that are displayed
// in the Service and Category drop-down lists on the AWS Support Center Create
// Case (https://console.aws.amazon.com/support/home#/case/create) page. The
// values in those fields, however, do not necessarily match the service codes
// and categories returned by the DescribeServices request. Always use the service
// codes and categories obtained programmatically. This practice ensures that
// you always have the most recent set of service and category codes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeServices for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeServices
func (c *Support) DescribeServices(input *DescribeServicesInput) (*DescribeServicesOutput, error) {
	req, out := c.DescribeServicesRequest(input)
	return out, req.Send()
}

// DescribeServicesWithContext is the same as DescribeServices with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) DescribeServicesWithContext(ctx aws.Context, input *DescribeServicesInput, opts ...request.Option) (*DescribeServicesOutput, error) {
	req, out := c.DescribeServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSeverityLevels = "DescribeSeverityLevels"

// DescribeSeverityLevelsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSeverityLevels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSeverityLevels for more information on using the DescribeSeverityLevels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSeverityLevelsRequest method.
//    req, resp := client.DescribeSeverityLevelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeSeverityLevels
func (c *Support) DescribeSeverityLevelsRequest(input *DescribeSeverityLevelsInput) (req *request.Request, output *DescribeSeverityLevelsOutput) {
	op := &request.Operation{
		Name:       opDescribeSeverityLevels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSeverityLevelsInput{}
	}

	output = &DescribeSeverityLevelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSeverityLevels API operation for AWS Support.
//
// Returns the list of severity levels that you can assign to an AWS Support
// case. The severity level for a case is also a field in the CaseDetails data
// type included in any CreateCase request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeSeverityLevels for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeSeverityLevels
func (c *Support) DescribeSeverityLevels(input *DescribeSeverityLevelsInput) (*DescribeSeverityLevelsOutput, error) {
	req, out := c.DescribeSeverityLevelsRequest(input)
	return out, req.Send()
}

// DescribeSeverityLevelsWithContext is the same as DescribeSeverityLevels with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSeverityLevels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) DescribeSeverityLevelsWithContext(ctx aws.Context, input *DescribeSeverityLevelsInput, opts ...request.Option) (*DescribeSeverityLevelsOutput, error) {
	req, out := c.DescribeSeverityLevelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrustedAdvisorCheckRefreshStatuses = "DescribeTrustedAdvisorCheckRefreshStatuses"

// DescribeTrustedAdvisorCheckRefreshStatusesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrustedAdvisorCheckRefreshStatuses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrustedAdvisorCheckRefreshStatuses for more information on using the DescribeTrustedAdvisorCheckRefreshStatuses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTrustedAdvisorCheckRefreshStatusesRequest method.
//    req, resp := client.DescribeTrustedAdvisorCheckRefreshStatusesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorCheckRefreshStatuses
func (c *Support) DescribeTrustedAdvisorCheckRefreshStatusesRequest(input *DescribeTrustedAdvisorCheckRefreshStatusesInput) (req *request.Request, output *DescribeTrustedAdvisorCheckRefreshStatusesOutput) {
	op := &request.Operation{
		Name:       opDescribeTrustedAdvisorCheckRefreshStatuses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustedAdvisorCheckRefreshStatusesInput{}
	}

	output = &DescribeTrustedAdvisorCheckRefreshStatusesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrustedAdvisorCheckRefreshStatuses API operation for AWS Support.
//
// Returns the refresh status of the Trusted Advisor checks that have the specified
// check IDs. Check IDs can be obtained by calling DescribeTrustedAdvisorChecks.
//
// Some checks are refreshed automatically, and their refresh statuses cannot
// be retrieved by using this operation. Use of the DescribeTrustedAdvisorCheckRefreshStatuses
// operation for these checks causes an InvalidParameterValue error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeTrustedAdvisorCheckRefreshStatuses for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorCheckRefreshStatuses
func (c *Support) DescribeTrustedAdvisorCheckRefreshStatuses(input *DescribeTrustedAdvisorCheckRefreshStatusesInput) (*DescribeTrustedAdvisorCheckRefreshStatusesOutput, error) {
	req, out := c.DescribeTrustedAdvisorCheckRefreshStatusesRequest(input)
	return out, req.Send()
}

// DescribeTrustedAdvisorCheckRefreshStatusesWithContext is the same as DescribeTrustedAdvisorCheckRefreshStatuses with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrustedAdvisorCheckRefreshStatuses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) DescribeTrustedAdvisorCheckRefreshStatusesWithContext(ctx aws.Context, input *DescribeTrustedAdvisorCheckRefreshStatusesInput, opts ...request.Option) (*DescribeTrustedAdvisorCheckRefreshStatusesOutput, error) {
	req, out := c.DescribeTrustedAdvisorCheckRefreshStatusesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrustedAdvisorCheckResult = "DescribeTrustedAdvisorCheckResult"

// DescribeTrustedAdvisorCheckResultRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrustedAdvisorCheckResult operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrustedAdvisorCheckResult for more information on using the DescribeTrustedAdvisorCheckResult
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTrustedAdvisorCheckResultRequest method.
//    req, resp := client.DescribeTrustedAdvisorCheckResultRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorCheckResult
func (c *Support) DescribeTrustedAdvisorCheckResultRequest(input *DescribeTrustedAdvisorCheckResultInput) (req *request.Request, output *DescribeTrustedAdvisorCheckResultOutput) {
	op := &request.Operation{
		Name:       opDescribeTrustedAdvisorCheckResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustedAdvisorCheckResultInput{}
	}

	output = &DescribeTrustedAdvisorCheckResultOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrustedAdvisorCheckResult API operation for AWS Support.
//
// Returns the results of the Trusted Advisor check that has the specified check
// ID. Check IDs can be obtained by calling DescribeTrustedAdvisorChecks.
//
// The response contains a TrustedAdvisorCheckResult object, which contains
// these three objects:
//
//    * TrustedAdvisorCategorySpecificSummary
//
//    * TrustedAdvisorResourceDetail
//
//    * TrustedAdvisorResourcesSummary
//
// In addition, the response contains these fields:
//
//    * status. The alert status of the check: "ok" (green), "warning" (yellow),
//    "error" (red), or "not_available".
//
//    * timestamp. The time of the last refresh of the check.
//
//    * checkId. The unique identifier for the check.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeTrustedAdvisorCheckResult for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorCheckResult
func (c *Support) DescribeTrustedAdvisorCheckResult(input *DescribeTrustedAdvisorCheckResultInput) (*DescribeTrustedAdvisorCheckResultOutput, error) {
	req, out := c.DescribeTrustedAdvisorCheckResultRequest(input)
	return out, req.Send()
}

// DescribeTrustedAdvisorCheckResultWithContext is the same as DescribeTrustedAdvisorCheckResult with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrustedAdvisorCheckResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) DescribeTrustedAdvisorCheckResultWithContext(ctx aws.Context, input *DescribeTrustedAdvisorCheckResultInput, opts ...request.Option) (*DescribeTrustedAdvisorCheckResultOutput, error) {
	req, out := c.DescribeTrustedAdvisorCheckResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrustedAdvisorCheckSummaries = "DescribeTrustedAdvisorCheckSummaries"

// DescribeTrustedAdvisorCheckSummariesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrustedAdvisorCheckSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrustedAdvisorCheckSummaries for more information on using the DescribeTrustedAdvisorCheckSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTrustedAdvisorCheckSummariesRequest method.
//    req, resp := client.DescribeTrustedAdvisorCheckSummariesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorCheckSummaries
func (c *Support) DescribeTrustedAdvisorCheckSummariesRequest(input *DescribeTrustedAdvisorCheckSummariesInput) (req *request.Request, output *DescribeTrustedAdvisorCheckSummariesOutput) {
	op := &request.Operation{
		Name:       opDescribeTrustedAdvisorCheckSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustedAdvisorCheckSummariesInput{}
	}

	output = &DescribeTrustedAdvisorCheckSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrustedAdvisorCheckSummaries API operation for AWS Support.
//
// Returns the summaries of the results of the Trusted Advisor checks that have
// the specified check IDs. Check IDs can be obtained by calling DescribeTrustedAdvisorChecks.
//
// The response contains an array of TrustedAdvisorCheckSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeTrustedAdvisorCheckSummaries for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorCheckSummaries
func (c *Support) DescribeTrustedAdvisorCheckSummaries(input *DescribeTrustedAdvisorCheckSummariesInput) (*DescribeTrustedAdvisorCheckSummariesOutput, error) {
	req, out := c.DescribeTrustedAdvisorCheckSummariesRequest(input)
	return out, req.Send()
}

// DescribeTrustedAdvisorCheckSummariesWithContext is the same as DescribeTrustedAdvisorCheckSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrustedAdvisorCheckSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) DescribeTrustedAdvisorCheckSummariesWithContext(ctx aws.Context, input *DescribeTrustedAdvisorCheckSummariesInput, opts ...request.Option) (*DescribeTrustedAdvisorCheckSummariesOutput, error) {
	req, out := c.DescribeTrustedAdvisorCheckSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrustedAdvisorChecks = "DescribeTrustedAdvisorChecks"

// DescribeTrustedAdvisorChecksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrustedAdvisorChecks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrustedAdvisorChecks for more information on using the DescribeTrustedAdvisorChecks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTrustedAdvisorChecksRequest method.
//    req, resp := client.DescribeTrustedAdvisorChecksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorChecks
func (c *Support) DescribeTrustedAdvisorChecksRequest(input *DescribeTrustedAdvisorChecksInput) (req *request.Request, output *DescribeTrustedAdvisorChecksOutput) {
	op := &request.Operation{
		Name:       opDescribeTrustedAdvisorChecks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustedAdvisorChecksInput{}
	}

	output = &DescribeTrustedAdvisorChecksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrustedAdvisorChecks API operation for AWS Support.
//
// Returns information about all available Trusted Advisor checks, including
// name, ID, category, description, and metadata. You must specify a language
// code; English ("en") and Japanese ("ja") are currently supported. The response
// contains a TrustedAdvisorCheckDescription for each check.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation DescribeTrustedAdvisorChecks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorChecks
func (c *Support) DescribeTrustedAdvisorChecks(input *DescribeTrustedAdvisorChecksInput) (*DescribeTrustedAdvisorChecksOutput, error) {
	req, out := c.DescribeTrustedAdvisorChecksRequest(input)
	return out, req.Send()
}

// DescribeTrustedAdvisorChecksWithContext is the same as DescribeTrustedAdvisorChecks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrustedAdvisorChecks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) DescribeTrustedAdvisorChecksWithContext(ctx aws.Context, input *DescribeTrustedAdvisorChecksInput, opts ...request.Option) (*DescribeTrustedAdvisorChecksOutput, error) {
	req, out := c.DescribeTrustedAdvisorChecksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRefreshTrustedAdvisorCheck = "RefreshTrustedAdvisorCheck"

// RefreshTrustedAdvisorCheckRequest generates a "aws/request.Request" representing the
// client's request for the RefreshTrustedAdvisorCheck operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RefreshTrustedAdvisorCheck for more information on using the RefreshTrustedAdvisorCheck
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RefreshTrustedAdvisorCheckRequest method.
//    req, resp := client.RefreshTrustedAdvisorCheckRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/RefreshTrustedAdvisorCheck
func (c *Support) RefreshTrustedAdvisorCheckRequest(input *RefreshTrustedAdvisorCheckInput) (req *request.Request, output *RefreshTrustedAdvisorCheckOutput) {
	op := &request.Operation{
		Name:       opRefreshTrustedAdvisorCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RefreshTrustedAdvisorCheckInput{}
	}

	output = &RefreshTrustedAdvisorCheckOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RefreshTrustedAdvisorCheck API operation for AWS Support.
//
// Requests a refresh of the Trusted Advisor check that has the specified check
// ID. Check IDs can be obtained by calling DescribeTrustedAdvisorChecks.
//
// Some checks are refreshed automatically, and they cannot be refreshed by
// using this operation. Use of the RefreshTrustedAdvisorCheck operation for
// these checks causes an InvalidParameterValue error.
//
// The response contains a TrustedAdvisorCheckRefreshStatus object, which contains
// these fields:
//
//    * status. The refresh status of the check: "none", "enqueued", "processing",
//    "success", or "abandoned".
//
//    * millisUntilNextRefreshable. The amount of time, in milliseconds, until
//    the check is eligible for refresh.
//
//    * checkId. The unique identifier for the check.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation RefreshTrustedAdvisorCheck for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/RefreshTrustedAdvisorCheck
func (c *Support) RefreshTrustedAdvisorCheck(input *RefreshTrustedAdvisorCheckInput) (*RefreshTrustedAdvisorCheckOutput, error) {
	req, out := c.RefreshTrustedAdvisorCheckRequest(input)
	return out, req.Send()
}

// RefreshTrustedAdvisorCheckWithContext is the same as RefreshTrustedAdvisorCheck with the addition of
// the ability to pass a context and additional request options.
//
// See RefreshTrustedAdvisorCheck for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) RefreshTrustedAdvisorCheckWithContext(ctx aws.Context, input *RefreshTrustedAdvisorCheckInput, opts ...request.Option) (*RefreshTrustedAdvisorCheckOutput, error) {
	req, out := c.RefreshTrustedAdvisorCheckRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResolveCase = "ResolveCase"

// ResolveCaseRequest generates a "aws/request.Request" representing the
// client's request for the ResolveCase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResolveCase for more information on using the ResolveCase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResolveCaseRequest method.
//    req, resp := client.ResolveCaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/ResolveCase
func (c *Support) ResolveCaseRequest(input *ResolveCaseInput) (req *request.Request, output *ResolveCaseOutput) {
	op := &request.Operation{
		Name:       opResolveCase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResolveCaseInput{}
	}

	output = &ResolveCaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResolveCase API operation for AWS Support.
//
// Takes a caseId and returns the initial state of the case along with the state
// of the case after the call to ResolveCase completed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support's
// API operation ResolveCase for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error occurred.
//
//   * ErrCodeCaseIdNotFound "CaseIdNotFound"
//   The requested caseId could not be located.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/ResolveCase
func (c *Support) ResolveCase(input *ResolveCaseInput) (*ResolveCaseOutput, error) {
	req, out := c.ResolveCaseRequest(input)
	return out, req.Send()
}

// ResolveCaseWithContext is the same as ResolveCase with the addition of
// the ability to pass a context and additional request options.
//
// See ResolveCase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Support) ResolveCaseWithContext(ctx aws.Context, input *ResolveCaseInput, opts ...request.Option) (*ResolveCaseOutput, error) {
	req, out := c.ResolveCaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddAttachmentsToSetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the attachment set. If an attachmentSetId is not specified, a new
	// attachment set is created, and the ID of the set is returned in the response.
	// If an attachmentSetId is specified, the attachments are added to the specified
	// set, if it exists.
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// One or more attachments to add to the set. The limit is 3 attachments per
	// set, and the size limit is 5 MB per attachment.
	//
	// Attachments is a required field
	Attachments []*Attachment `locationName:"attachments" type:"list" required:"true"`
}

// String returns the string representation
func (s AddAttachmentsToSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddAttachmentsToSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddAttachmentsToSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddAttachmentsToSetInput"}
	if s.Attachments == nil {
		invalidParams.Add(request.NewErrParamRequired("Attachments"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachmentSetId sets the AttachmentSetId field's value.
func (s *AddAttachmentsToSetInput) SetAttachmentSetId(v string) *AddAttachmentsToSetInput {
	s.AttachmentSetId = &v
	return s
}

// SetAttachments sets the Attachments field's value.
func (s *AddAttachmentsToSetInput) SetAttachments(v []*Attachment) *AddAttachmentsToSetInput {
	s.Attachments = v
	return s
}

// The ID and expiry time of the attachment set returned by the AddAttachmentsToSet
// operation.
type AddAttachmentsToSetOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the attachment set. If an attachmentSetId was not specified, a
	// new attachment set is created, and the ID of the set is returned in the response.
	// If an attachmentSetId was specified, the attachments are added to the specified
	// set, if it exists.
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// The time and date when the attachment set expires.
	ExpiryTime *string `locationName:"expiryTime" type:"string"`
}

// String returns the string representation
func (s AddAttachmentsToSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddAttachmentsToSetOutput) GoString() string {
	return s.String()
}

// SetAttachmentSetId sets the AttachmentSetId field's value.
func (s *AddAttachmentsToSetOutput) SetAttachmentSetId(v string) *AddAttachmentsToSetOutput {
	s.AttachmentSetId = &v
	return s
}

// SetExpiryTime sets the ExpiryTime field's value.
func (s *AddAttachmentsToSetOutput) SetExpiryTime(v string) *AddAttachmentsToSetOutput {
	s.ExpiryTime = &v
	return s
}

// To be written.
type AddCommunicationToCaseInput struct {
	_ struct{} `type:"structure"`

	// The ID of a set of one or more attachments for the communication to add to
	// the case. Create the set by calling AddAttachmentsToSet
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`

	// The email addresses in the CC line of an email to be added to the support
	// case.
	CcEmailAddresses []*string `locationName:"ccEmailAddresses" type:"list"`

	// The body of an email communication to add to the support case.
	//
	// CommunicationBody is a required field
	CommunicationBody *string `locationName:"communicationBody" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddCommunicationToCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCommunicationToCaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddCommunicationToCaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddCommunicationToCaseInput"}
	if s.CommunicationBody == nil {
		invalidParams.Add(request.NewErrParamRequired("CommunicationBody"))
	}
	if s.CommunicationBody != nil && len(*s.CommunicationBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CommunicationBody", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachmentSetId sets the AttachmentSetId field's value.
func (s *AddCommunicationToCaseInput) SetAttachmentSetId(v string) *AddCommunicationToCaseInput {
	s.AttachmentSetId = &v
	return s
}

// SetCaseId sets the CaseId field's value.
func (s *AddCommunicationToCaseInput) SetCaseId(v string) *AddCommunicationToCaseInput {
	s.CaseId = &v
	return s
}

// SetCcEmailAddresses sets the CcEmailAddresses field's value.
func (s *AddCommunicationToCaseInput) SetCcEmailAddresses(v []*string) *AddCommunicationToCaseInput {
	s.CcEmailAddresses = v
	return s
}

// SetCommunicationBody sets the CommunicationBody field's value.
func (s *AddCommunicationToCaseInput) SetCommunicationBody(v string) *AddCommunicationToCaseInput {
	s.CommunicationBody = &v
	return s
}

// The result of the AddCommunicationToCase operation.
type AddCommunicationToCaseOutput struct {
	_ struct{} `type:"structure"`

	// True if AddCommunicationToCase succeeds. Otherwise, returns an error.
	Result *bool `locationName:"result" type:"boolean"`
}

// String returns the string representation
func (s AddCommunicationToCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCommunicationToCaseOutput) GoString() string {
	return s.String()
}

// SetResult sets the Result field's value.
func (s *AddCommunicationToCaseOutput) SetResult(v bool) *AddCommunicationToCaseOutput {
	s.Result = &v
	return s
}

// An attachment to a case communication. The attachment consists of the file
// name and the content of the file.
type Attachment struct {
	_ struct{} `type:"structure"`

	// The content of the attachment file.
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	Data []byte `locationName:"data" type:"blob"`

	// The name of the attachment file.
	FileName *string `locationName:"fileName" type:"string"`
}

// String returns the string representation
func (s Attachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Attachment) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *Attachment) SetData(v []byte) *Attachment {
	s.Data = v
	return s
}

// SetFileName sets the FileName field's value.
func (s *Attachment) SetFileName(v string) *Attachment {
	s.FileName = &v
	return s
}

// The file name and ID of an attachment to a case communication. You can use
// the ID to retrieve the attachment with the DescribeAttachment operation.
type AttachmentDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the attachment.
	AttachmentId *string `locationName:"attachmentId" type:"string"`

	// The file name of the attachment.
	FileName *string `locationName:"fileName" type:"string"`
}

// String returns the string representation
func (s AttachmentDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachmentDetails) GoString() string {
	return s.String()
}

// SetAttachmentId sets the AttachmentId field's value.
func (s *AttachmentDetails) SetAttachmentId(v string) *AttachmentDetails {
	s.AttachmentId = &v
	return s
}

// SetFileName sets the FileName field's value.
func (s *AttachmentDetails) SetFileName(v string) *AttachmentDetails {
	s.FileName = &v
	return s
}

// A JSON-formatted object that contains the metadata for a support case. It
// is contained the response from a DescribeCases request. CaseDetails contains
// the following fields:
//
//    * caseId. The AWS Support case ID requested or returned in the call. The
//    case ID is an alphanumeric string formatted as shown in this example:
//    case-12345678910-2013-c4c1d2bf33c5cf47.
//
//    * categoryCode. The category of problem for the AWS Support case. Corresponds
//    to the CategoryCode values returned by a call to DescribeServices.
//
//    * displayId. The identifier for the case on pages in the AWS Support Center.
//
//    * language. The ISO 639-1 code for the language in which AWS provides
//    support. AWS Support currently supports English ("en") and Japanese ("ja").
//    Language parameters must be passed explicitly for operations that take
//    them.
//
//    * recentCommunications. One or more Communication objects. Fields of these
//    objects are attachments, body, caseId, submittedBy, and timeCreated.
//
//    * nextToken. A resumption point for pagination.
//
//    * serviceCode. The identifier for the AWS service that corresponds to
//    the service code defined in the call to DescribeServices.
//
//    * severityCode. The severity code assigned to the case. Contains one of
//    the values returned by the call to DescribeSeverityLevels.
//
//    * status. The status of the case in the AWS Support Center.
//
//    * subject. The subject line of the case.
//
//    * submittedBy. The email address of the account that submitted the case.
//
//    * timeCreated. The time the case was created, in ISO-8601 format.
type CaseDetails struct {
	_ struct{} `type:"structure"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`

	// The category of problem for the AWS Support case.
	CategoryCode *string `locationName:"categoryCode" type:"string"`

	// The email addresses that receive copies of communication about the case.
	CcEmailAddresses []*string `locationName:"ccEmailAddresses" type:"list"`

	// The ID displayed for the case in the AWS Support Center. This is a numeric
	// string.
	DisplayId *string `locationName:"displayId" type:"string"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	// The five most recent communications between you and AWS Support Center, including
	// the IDs of any attachments to the communications. Also includes a nextToken
	// that you can use to retrieve earlier communications.
	RecentCommunications *RecentCaseCommunications `locationName:"recentCommunications" type:"structure"`

	// The code for the AWS service returned by the call to DescribeServices.
	ServiceCode *string `locationName:"serviceCode" type:"string"`

	// The code for the severity level returned by the call to DescribeSeverityLevels.
	SeverityCode *string `locationName:"severityCode" type:"string"`

	// The status of the case.
	Status *string `locationName:"status" type:"string"`

	// The subject line for the case in the AWS Support Center.
	Subject *string `locationName:"subject" type:"string"`

	// The email address of the account that submitted the case.
	SubmittedBy *string `locationName:"submittedBy" type:"string"`

	// The time that the case was case created in the AWS Support Center.
	TimeCreated *string `locationName:"timeCreated" type:"string"`
}

// String returns the string representation
func (s CaseDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaseDetails) GoString() string {
	return s.String()
}

// SetCaseId sets the CaseId field's value.
func (s *CaseDetails) SetCaseId(v string) *CaseDetails {
	s.CaseId = &v
	return s
}

// SetCategoryCode sets the CategoryCode field's value.
func (s *CaseDetails) SetCategoryCode(v string) *CaseDetails {
	s.CategoryCode = &v
	return s
}

// SetCcEmailAddresses sets the CcEmailAddresses field's value.
func (s *CaseDetails) SetCcEmailAddresses(v []*string) *CaseDetails {
	s.CcEmailAddresses = v
	return s
}

// SetDisplayId sets the DisplayId field's value.
func (s *CaseDetails) SetDisplayId(v string) *CaseDetails {
	s.DisplayId = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *CaseDetails) SetLanguage(v string) *CaseDetails {
	s.Language = &v
	return s
}

// SetRecentCommunications sets the RecentCommunications field's value.
func (s *CaseDetails) SetRecentCommunications(v *RecentCaseCommunications) *CaseDetails {
	s.RecentCommunications = v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *CaseDetails) SetServiceCode(v string) *CaseDetails {
	s.ServiceCode = &v
	return s
}

// SetSeverityCode sets the SeverityCode field's value.
func (s *CaseDetails) SetSeverityCode(v string) *CaseDetails {
	s.SeverityCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CaseDetails) SetStatus(v string) *CaseDetails {
	s.Status = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *CaseDetails) SetSubject(v string) *CaseDetails {
	s.Subject = &v
	return s
}

// SetSubmittedBy sets the SubmittedBy field's value.
func (s *CaseDetails) SetSubmittedBy(v string) *CaseDetails {
	s.SubmittedBy = &v
	return s
}

// SetTimeCreated sets the TimeCreated field's value.
func (s *CaseDetails) SetTimeCreated(v string) *CaseDetails {
	s.TimeCreated = &v
	return s
}

// A JSON-formatted name/value pair that represents the category name and category
// code of the problem, selected from the DescribeServices response for each
// AWS service.
type Category struct {
	_ struct{} `type:"structure"`

	// The category code for the support case.
	Code *string `locationName:"code" type:"string"`

	// The category name for the support case.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s Category) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Category) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *Category) SetCode(v string) *Category {
	s.Code = &v
	return s
}

// SetName sets the Name field's value.
func (s *Category) SetName(v string) *Category {
	s.Name = &v
	return s
}

// A communication associated with an AWS Support case. The communication consists
// of the case ID, the message body, attachment information, the account email
// address, and the date and time of the communication.
type Communication struct {
	_ struct{} `type:"structure"`

	// Information about the attachments to the case communication.
	AttachmentSet []*AttachmentDetails `locationName:"attachmentSet" type:"list"`

	// The text of the communication between the customer and AWS Support.
	Body *string `locationName:"body" min:"1" type:"string"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`

	// The email address of the account that submitted the AWS Support case.
	SubmittedBy *string `locationName:"submittedBy" type:"string"`

	// The time the communication was created.
	TimeCreated *string `locationName:"timeCreated" type:"string"`
}

// String returns the string representation
func (s Communication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Communication) GoString() string {
	return s.String()
}

// SetAttachmentSet sets the AttachmentSet field's value.
func (s *Communication) SetAttachmentSet(v []*AttachmentDetails) *Communication {
	s.AttachmentSet = v
	return s
}

// SetBody sets the Body field's value.
func (s *Communication) SetBody(v string) *Communication {
	s.Body = &v
	return s
}

// SetCaseId sets the CaseId field's value.
func (s *Communication) SetCaseId(v string) *Communication {
	s.CaseId = &v
	return s
}

// SetSubmittedBy sets the SubmittedBy field's value.
func (s *Communication) SetSubmittedBy(v string) *Communication {
	s.SubmittedBy = &v
	return s
}

// SetTimeCreated sets the TimeCreated field's value.
func (s *Communication) SetTimeCreated(v string) *Communication {
	s.TimeCreated = &v
	return s
}

type CreateCaseInput struct {
	_ struct{} `type:"structure"`

	// The ID of a set of one or more attachments for the case. Create the set by
	// using AddAttachmentsToSet.
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// The category of problem for the AWS Support case.
	CategoryCode *string `locationName:"categoryCode" type:"string"`

	// A list of email addresses that AWS Support copies on case correspondence.
	CcEmailAddresses []*string `locationName:"ccEmailAddresses" type:"list"`

	// The communication body text when you create an AWS Support case by calling
	// CreateCase.
	//
	// CommunicationBody is a required field
	CommunicationBody *string `locationName:"communicationBody" min:"1" type:"string" required:"true"`

	// The type of issue for the case. You can specify either "customer-service"
	// or "technical." If you do not indicate a value, the default is "technical."
	IssueType *string `locationName:"issueType" type:"string"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	// The code for the AWS service returned by the call to DescribeServices.
	ServiceCode *string `locationName:"serviceCode" type:"string"`

	// The code for the severity level returned by the call to DescribeSeverityLevels.
	//
	// The availability of severity levels depends on each customer's support subscription.
	// In other words, your subscription may not necessarily require the urgent
	// level of response time.
	SeverityCode *string `locationName:"severityCode" type:"string"`

	// The title of the AWS Support case.
	//
	// Subject is a required field
	Subject *string `locationName:"subject" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCaseInput"}
	if s.CommunicationBody == nil {
		invalidParams.Add(request.NewErrParamRequired("CommunicationBody"))
	}
	if s.CommunicationBody != nil && len(*s.CommunicationBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CommunicationBody", 1))
	}
	if s.Subject == nil {
		invalidParams.Add(request.NewErrParamRequired("Subject"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachmentSetId sets the AttachmentSetId field's value.
func (s *CreateCaseInput) SetAttachmentSetId(v string) *CreateCaseInput {
	s.AttachmentSetId = &v
	return s
}

// SetCategoryCode sets the CategoryCode field's value.
func (s *CreateCaseInput) SetCategoryCode(v string) *CreateCaseInput {
	s.CategoryCode = &v
	return s
}

// SetCcEmailAddresses sets the CcEmailAddresses field's value.
func (s *CreateCaseInput) SetCcEmailAddresses(v []*string) *CreateCaseInput {
	s.CcEmailAddresses = v
	return s
}

// SetCommunicationBody sets the CommunicationBody field's value.
func (s *CreateCaseInput) SetCommunicationBody(v string) *CreateCaseInput {
	s.CommunicationBody = &v
	return s
}

// SetIssueType sets the IssueType field's value.
func (s *CreateCaseInput) SetIssueType(v string) *CreateCaseInput {
	s.IssueType = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *CreateCaseInput) SetLanguage(v string) *CreateCaseInput {
	s.Language = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *CreateCaseInput) SetServiceCode(v string) *CreateCaseInput {
	s.ServiceCode = &v
	return s
}

// SetSeverityCode sets the SeverityCode field's value.
func (s *CreateCaseInput) SetSeverityCode(v string) *CreateCaseInput {
	s.SeverityCode = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *CreateCaseInput) SetSubject(v string) *CreateCaseInput {
	s.Subject = &v
	return s
}

// The AWS Support case ID returned by a successful completion of the CreateCase
// operation.
type CreateCaseOutput struct {
	_ struct{} `type:"structure"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`
}

// String returns the string representation
func (s CreateCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCaseOutput) GoString() string {
	return s.String()
}

// SetCaseId sets the CaseId field's value.
func (s *CreateCaseOutput) SetCaseId(v string) *CreateCaseOutput {
	s.CaseId = &v
	return s
}

type DescribeAttachmentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the attachment to return. Attachment IDs are returned by the DescribeCommunications
	// operation.
	//
	// AttachmentId is a required field
	AttachmentId *string `locationName:"attachmentId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAttachmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAttachmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAttachmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAttachmentInput"}
	if s.AttachmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AttachmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachmentId sets the AttachmentId field's value.
func (s *DescribeAttachmentInput) SetAttachmentId(v string) *DescribeAttachmentInput {
	s.AttachmentId = &v
	return s
}

// The content and file name of the attachment returned by the DescribeAttachment
// operation.
type DescribeAttachmentOutput struct {
	_ struct{} `type:"structure"`

	// The attachment content and file name.
	Attachment *Attachment `locationName:"attachment" type:"structure"`
}

// String returns the string representation
func (s DescribeAttachmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAttachmentOutput) GoString() string {
	return s.String()
}

// SetAttachment sets the Attachment field's value.
func (s *DescribeAttachmentOutput) SetAttachment(v *Attachment) *DescribeAttachmentOutput {
	s.Attachment = v
	return s
}

type DescribeCasesInput struct {
	_ struct{} `type:"structure"`

	// The start date for a filtered date search on support case communications.
	// Case communications are available for 12 months after creation.
	AfterTime *string `locationName:"afterTime" type:"string"`

	// The end date for a filtered date search on support case communications. Case
	// communications are available for 12 months after creation.
	BeforeTime *string `locationName:"beforeTime" type:"string"`

	// A list of ID numbers of the support cases you want returned. The maximum
	// number of cases is 100.
	CaseIdList []*string `locationName:"caseIdList" type:"list"`

	// The ID displayed for a case in the AWS Support Center user interface.
	DisplayId *string `locationName:"displayId" type:"string"`

	// Specifies whether communications should be included in the DescribeCases
	// results. The default is true.
	IncludeCommunications *bool `locationName:"includeCommunications" type:"boolean"`

	// Specifies whether resolved support cases should be included in the DescribeCases
	// results. The default is false.
	IncludeResolvedCases *bool `locationName:"includeResolvedCases" type:"boolean"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	// The maximum number of results to return before paginating.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeCasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCasesInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterTime sets the AfterTime field's value.
func (s *DescribeCasesInput) SetAfterTime(v string) *DescribeCasesInput {
	s.AfterTime = &v
	return s
}

// SetBeforeTime sets the BeforeTime field's value.
func (s *DescribeCasesInput) SetBeforeTime(v string) *DescribeCasesInput {
	s.BeforeTime = &v
	return s
}

// SetCaseIdList sets the CaseIdList field's value.
func (s *DescribeCasesInput) SetCaseIdList(v []*string) *DescribeCasesInput {
	s.CaseIdList = v
	return s
}

// SetDisplayId sets the DisplayId field's value.
func (s *DescribeCasesInput) SetDisplayId(v string) *DescribeCasesInput {
	s.DisplayId = &v
	return s
}

// SetIncludeCommunications sets the IncludeCommunications field's value.
func (s *DescribeCasesInput) SetIncludeCommunications(v bool) *DescribeCasesInput {
	s.IncludeCommunications = &v
	return s
}

// SetIncludeResolvedCases sets the IncludeResolvedCases field's value.
func (s *DescribeCasesInput) SetIncludeResolvedCases(v bool) *DescribeCasesInput {
	s.IncludeResolvedCases = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *DescribeCasesInput) SetLanguage(v string) *DescribeCasesInput {
	s.Language = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeCasesInput) SetMaxResults(v int64) *DescribeCasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeCasesInput) SetNextToken(v string) *DescribeCasesInput {
	s.NextToken = &v
	return s
}

// Returns an array of CaseDetails objects and a nextToken that defines a point
// for pagination in the result set.
type DescribeCasesOutput struct {
	_ struct{} `type:"structure"`

	// The details for the cases that match the request.
	Cases []*CaseDetails `locationName:"cases" type:"list"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeCasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCasesOutput) GoString() string {
	return s.String()
}

// SetCases sets the Cases field's value.
func (s *DescribeCasesOutput) SetCases(v []*CaseDetails) *DescribeCasesOutput {
	s.Cases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeCasesOutput) SetNextToken(v string) *DescribeCasesOutput {
	s.NextToken = &v
	return s
}

type DescribeCommunicationsInput struct {
	_ struct{} `type:"structure"`

	// The start date for a filtered date search on support case communications.
	// Case communications are available for 12 months after creation.
	AfterTime *string `locationName:"afterTime" type:"string"`

	// The end date for a filtered date search on support case communications. Case
	// communications are available for 12 months after creation.
	BeforeTime *string `locationName:"beforeTime" type:"string"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	//
	// CaseId is a required field
	CaseId *string `locationName:"caseId" type:"string" required:"true"`

	// The maximum number of results to return before paginating.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeCommunicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCommunicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCommunicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCommunicationsInput"}
	if s.CaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("CaseId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterTime sets the AfterTime field's value.
func (s *DescribeCommunicationsInput) SetAfterTime(v string) *DescribeCommunicationsInput {
	s.AfterTime = &v
	return s
}

// SetBeforeTime sets the BeforeTime field's value.
func (s *DescribeCommunicationsInput) SetBeforeTime(v string) *DescribeCommunicationsInput {
	s.BeforeTime = &v
	return s
}

// SetCaseId sets the CaseId field's value.
func (s *DescribeCommunicationsInput) SetCaseId(v string) *DescribeCommunicationsInput {
	s.CaseId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeCommunicationsInput) SetMaxResults(v int64) *DescribeCommunicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeCommunicationsInput) SetNextToken(v string) *DescribeCommunicationsInput {
	s.NextToken = &v
	return s
}

// The communications returned by the DescribeCommunications operation.
type DescribeCommunicationsOutput struct {
	_ struct{} `type:"structure"`

	// The communications for the case.
	Communications []*Communication `locationName:"communications" type:"list"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeCommunicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCommunicationsOutput) GoString() string {
	return s.String()
}

// SetCommunications sets the Communications field's value.
func (s *DescribeCommunicationsOutput) SetCommunications(v []*Communication) *DescribeCommunicationsOutput {
	s.Communications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeCommunicationsOutput) SetNextToken(v string) *DescribeCommunicationsOutput {
	s.NextToken = &v
	return s
}

type DescribeServicesInput struct {
	_ struct{} `type:"structure"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	// A JSON-formatted list of service codes available for AWS services.
	ServiceCodeList []*string `locationName:"serviceCodeList" type:"list"`
}

// String returns the string representation
func (s DescribeServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServicesInput) GoString() string {
	return s.String()
}

// SetLanguage sets the Language field's value.
func (s *DescribeServicesInput) SetLanguage(v string) *DescribeServicesInput {
	s.Language = &v
	return s
}

// SetServiceCodeList sets the ServiceCodeList field's value.
func (s *DescribeServicesInput) SetServiceCodeList(v []*string) *DescribeServicesInput {
	s.ServiceCodeList = v
	return s
}

// The list of AWS services returned by the DescribeServices operation.
type DescribeServicesOutput struct {
	_ struct{} `type:"structure"`

	// A JSON-formatted list of AWS services.
	Services []*Service `locationName:"services" type:"list"`
}

// String returns the string representation
func (s DescribeServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServicesOutput) GoString() string {
	return s.String()
}

// SetServices sets the Services field's value.
func (s *DescribeServicesOutput) SetServices(v []*Service) *DescribeServicesOutput {
	s.Services = v
	return s
}

type DescribeSeverityLevelsInput struct {
	_ struct{} `type:"structure"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`
}

// String returns the string representation
func (s DescribeSeverityLevelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSeverityLevelsInput) GoString() string {
	return s.String()
}

// SetLanguage sets the Language field's value.
func (s *DescribeSeverityLevelsInput) SetLanguage(v string) *DescribeSeverityLevelsInput {
	s.Language = &v
	return s
}

// The list of severity levels returned by the DescribeSeverityLevels operation.
type DescribeSeverityLevelsOutput struct {
	_ struct{} `type:"structure"`

	// The available severity levels for the support case. Available severity levels
	// are defined by your service level agreement with AWS.
	SeverityLevels []*SeverityLevel `locationName:"severityLevels" type:"list"`
}

// String returns the string representation
func (s DescribeSeverityLevelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSeverityLevelsOutput) GoString() string {
	return s.String()
}

// SetSeverityLevels sets the SeverityLevels field's value.
func (s *DescribeSeverityLevelsOutput) SetSeverityLevels(v []*SeverityLevel) *DescribeSeverityLevelsOutput {
	s.SeverityLevels = v
	return s
}

type DescribeTrustedAdvisorCheckRefreshStatusesInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the Trusted Advisor checks to get the status of. Note: Specifying
	// the check ID of a check that is automatically refreshed causes an InvalidParameterValue
	// error.
	//
	// CheckIds is a required field
	CheckIds []*string `locationName:"checkIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckRefreshStatusesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckRefreshStatusesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrustedAdvisorCheckRefreshStatusesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTrustedAdvisorCheckRefreshStatusesInput"}
	if s.CheckIds == nil {
		invalidParams.Add(request.NewErrParamRequired("CheckIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCheckIds sets the CheckIds field's value.
func (s *DescribeTrustedAdvisorCheckRefreshStatusesInput) SetCheckIds(v []*string) *DescribeTrustedAdvisorCheckRefreshStatusesInput {
	s.CheckIds = v
	return s
}

// The statuses of the Trusted Advisor checks returned by the DescribeTrustedAdvisorCheckRefreshStatuses
// operation.
type DescribeTrustedAdvisorCheckRefreshStatusesOutput struct {
	_ struct{} `type:"structure"`

	// The refresh status of the specified Trusted Advisor checks.
	//
	// Statuses is a required field
	Statuses []*TrustedAdvisorCheckRefreshStatus `locationName:"statuses" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckRefreshStatusesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckRefreshStatusesOutput) GoString() string {
	return s.String()
}

// SetStatuses sets the Statuses field's value.
func (s *DescribeTrustedAdvisorCheckRefreshStatusesOutput) SetStatuses(v []*TrustedAdvisorCheckRefreshStatus) *DescribeTrustedAdvisorCheckRefreshStatusesOutput {
	s.Statuses = v
	return s
}

type DescribeTrustedAdvisorCheckResultInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the Trusted Advisor check.
	//
	// CheckId is a required field
	CheckId *string `locationName:"checkId" type:"string" required:"true"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckResultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrustedAdvisorCheckResultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTrustedAdvisorCheckResultInput"}
	if s.CheckId == nil {
		invalidParams.Add(request.NewErrParamRequired("CheckId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCheckId sets the CheckId field's value.
func (s *DescribeTrustedAdvisorCheckResultInput) SetCheckId(v string) *DescribeTrustedAdvisorCheckResultInput {
	s.CheckId = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *DescribeTrustedAdvisorCheckResultInput) SetLanguage(v string) *DescribeTrustedAdvisorCheckResultInput {
	s.Language = &v
	return s
}

// The result of the Trusted Advisor check returned by the DescribeTrustedAdvisorCheckResult
// operation.
type DescribeTrustedAdvisorCheckResultOutput struct {
	_ struct{} `type:"structure"`

	// The detailed results of the Trusted Advisor check.
	Result *TrustedAdvisorCheckResult `locationName:"result" type:"structure"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckResultOutput) GoString() string {
	return s.String()
}

// SetResult sets the Result field's value.
func (s *DescribeTrustedAdvisorCheckResultOutput) SetResult(v *TrustedAdvisorCheckResult) *DescribeTrustedAdvisorCheckResultOutput {
	s.Result = v
	return s
}

type DescribeTrustedAdvisorCheckSummariesInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the Trusted Advisor checks.
	//
	// CheckIds is a required field
	CheckIds []*string `locationName:"checkIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckSummariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrustedAdvisorCheckSummariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTrustedAdvisorCheckSummariesInput"}
	if s.CheckIds == nil {
		invalidParams.Add(request.NewErrParamRequired("CheckIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCheckIds sets the CheckIds field's value.
func (s *DescribeTrustedAdvisorCheckSummariesInput) SetCheckIds(v []*string) *DescribeTrustedAdvisorCheckSummariesInput {
	s.CheckIds = v
	return s
}

// The summaries of the Trusted Advisor checks returned by the DescribeTrustedAdvisorCheckSummaries
// operation.
type DescribeTrustedAdvisorCheckSummariesOutput struct {
	_ struct{} `type:"structure"`

	// The summary information for the requested Trusted Advisor checks.
	//
	// Summaries is a required field
	Summaries []*TrustedAdvisorCheckSummary `locationName:"summaries" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckSummariesOutput) GoString() string {
	return s.String()
}

// SetSummaries sets the Summaries field's value.
func (s *DescribeTrustedAdvisorCheckSummariesOutput) SetSummaries(v []*TrustedAdvisorCheckSummary) *DescribeTrustedAdvisorCheckSummariesOutput {
	s.Summaries = v
	return s
}

type DescribeTrustedAdvisorChecksInput struct {
	_ struct{} `type:"structure"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	//
	// Language is a required field
	Language *string `locationName:"language" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorChecksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorChecksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrustedAdvisorChecksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTrustedAdvisorChecksInput"}
	if s.Language == nil {
		invalidParams.Add(request.NewErrParamRequired("Language"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguage sets the Language field's value.
func (s *DescribeTrustedAdvisorChecksInput) SetLanguage(v string) *DescribeTrustedAdvisorChecksInput {
	s.Language = &v
	return s
}

// Information about the Trusted Advisor checks returned by the DescribeTrustedAdvisorChecks
// operation.
type DescribeTrustedAdvisorChecksOutput struct {
	_ struct{} `type:"structure"`

	// Information about all available Trusted Advisor checks.
	//
	// Checks is a required field
	Checks []*TrustedAdvisorCheckDescription `locationName:"checks" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorChecksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorChecksOutput) GoString() string {
	return s.String()
}

// SetChecks sets the Checks field's value.
func (s *DescribeTrustedAdvisorChecksOutput) SetChecks(v []*TrustedAdvisorCheckDescription) *DescribeTrustedAdvisorChecksOutput {
	s.Checks = v
	return s
}

// The five most recent communications associated with the case.
type RecentCaseCommunications struct {
	_ struct{} `type:"structure"`

	// The five most recent communications associated with the case.
	Communications []*Communication `locationName:"communications" type:"list"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s RecentCaseCommunications) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecentCaseCommunications) GoString() string {
	return s.String()
}

// SetCommunications sets the Communications field's value.
func (s *RecentCaseCommunications) SetCommunications(v []*Communication) *RecentCaseCommunications {
	s.Communications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *RecentCaseCommunications) SetNextToken(v string) *RecentCaseCommunications {
	s.NextToken = &v
	return s
}

type RefreshTrustedAdvisorCheckInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the Trusted Advisor check to refresh. Note: Specifying
	// the check ID of a check that is automatically refreshed causes an InvalidParameterValue
	// error.
	//
	// CheckId is a required field
	CheckId *string `locationName:"checkId" type:"string" required:"true"`
}

// String returns the string representation
func (s RefreshTrustedAdvisorCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshTrustedAdvisorCheckInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RefreshTrustedAdvisorCheckInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RefreshTrustedAdvisorCheckInput"}
	if s.CheckId == nil {
		invalidParams.Add(request.NewErrParamRequired("CheckId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCheckId sets the CheckId field's value.
func (s *RefreshTrustedAdvisorCheckInput) SetCheckId(v string) *RefreshTrustedAdvisorCheckInput {
	s.CheckId = &v
	return s
}

// The current refresh status of a Trusted Advisor check.
type RefreshTrustedAdvisorCheckOutput struct {
	_ struct{} `type:"structure"`

	// The current refresh status for a check, including the amount of time until
	// the check is eligible for refresh.
	//
	// Status is a required field
	Status *TrustedAdvisorCheckRefreshStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation
func (s RefreshTrustedAdvisorCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshTrustedAdvisorCheckOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *RefreshTrustedAdvisorCheckOutput) SetStatus(v *TrustedAdvisorCheckRefreshStatus) *RefreshTrustedAdvisorCheckOutput {
	s.Status = v
	return s
}

type ResolveCaseInput struct {
	_ struct{} `type:"structure"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`
}

// String returns the string representation
func (s ResolveCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolveCaseInput) GoString() string {
	return s.String()
}

// SetCaseId sets the CaseId field's value.
func (s *ResolveCaseInput) SetCaseId(v string) *ResolveCaseInput {
	s.CaseId = &v
	return s
}

// The status of the case returned by the ResolveCase operation.
type ResolveCaseOutput struct {
	_ struct{} `type:"structure"`

	// The status of the case after the ResolveCase request was processed.
	FinalCaseStatus *string `locationName:"finalCaseStatus" type:"string"`

	// The status of the case when the ResolveCase request was sent.
	InitialCaseStatus *string `locationName:"initialCaseStatus" type:"string"`
}

// String returns the string representation
func (s ResolveCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolveCaseOutput) GoString() string {
	return s.String()
}

// SetFinalCaseStatus sets the FinalCaseStatus field's value.
func (s *ResolveCaseOutput) SetFinalCaseStatus(v string) *ResolveCaseOutput {
	s.FinalCaseStatus = &v
	return s
}

// SetInitialCaseStatus sets the InitialCaseStatus field's value.
func (s *ResolveCaseOutput) SetInitialCaseStatus(v string) *ResolveCaseOutput {
	s.InitialCaseStatus = &v
	return s
}

// Information about an AWS service returned by the DescribeServices operation.
type Service struct {
	_ struct{} `type:"structure"`

	// A list of categories that describe the type of support issue a case describes.
	// Categories consist of a category name and a category code. Category names
	// and codes are passed to AWS Support when you call CreateCase.
	Categories []*Category `locationName:"categories" type:"list"`

	// The code for an AWS service returned by the DescribeServices response. The
	// name element contains the corresponding friendly name.
	Code *string `locationName:"code" type:"string"`

	// The friendly name for an AWS service. The code element contains the corresponding
	// code.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Service) GoString() string {
	return s.String()
}

// SetCategories sets the Categories field's value.
func (s *Service) SetCategories(v []*Category) *Service {
	s.Categories = v
	return s
}

// SetCode sets the Code field's value.
func (s *Service) SetCode(v string) *Service {
	s.Code = &v
	return s
}

// SetName sets the Name field's value.
func (s *Service) SetName(v string) *Service {
	s.Name = &v
	return s
}

// A code and name pair that represent a severity level that can be applied
// to a support case.
type SeverityLevel struct {
	_ struct{} `type:"structure"`

	// One of four values: "low," "medium," "high," and "urgent". These values correspond
	// to response times returned to the caller in severityLevel.name.
	Code *string `locationName:"code" type:"string"`

	// The name of the severity level that corresponds to the severity level code.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s SeverityLevel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SeverityLevel) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *SeverityLevel) SetCode(v string) *SeverityLevel {
	s.Code = &v
	return s
}

// SetName sets the Name field's value.
func (s *SeverityLevel) SetName(v string) *SeverityLevel {
	s.Name = &v
	return s
}

// The container for summary information that relates to the category of the
// Trusted Advisor check.
type TrustedAdvisorCategorySpecificSummary struct {
	_ struct{} `type:"structure"`

	// The summary information about cost savings for a Trusted Advisor check that
	// is in the Cost Optimizing category.
	CostOptimizing *TrustedAdvisorCostOptimizingSummary `locationName:"costOptimizing" type:"structure"`
}

// String returns the string representation
func (s TrustedAdvisorCategorySpecificSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCategorySpecificSummary) GoString() string {
	return s.String()
}

// SetCostOptimizing sets the CostOptimizing field's value.
func (s *TrustedAdvisorCategorySpecificSummary) SetCostOptimizing(v *TrustedAdvisorCostOptimizingSummary) *TrustedAdvisorCategorySpecificSummary {
	s.CostOptimizing = v
	return s
}

// The description and metadata for a Trusted Advisor check.
type TrustedAdvisorCheckDescription struct {
	_ struct{} `type:"structure"`

	// The category of the Trusted Advisor check.
	//
	// Category is a required field
	Category *string `locationName:"category" type:"string" required:"true"`

	// The description of the Trusted Advisor check, which includes the alert criteria
	// and recommended actions (contains HTML markup).
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The unique identifier for the Trusted Advisor check.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The column headings for the data returned by the Trusted Advisor check. The
	// order of the headings corresponds to the order of the data in the Metadata
	// element of the TrustedAdvisorResourceDetail for the check. Metadata contains
	// all the data that is shown in the Excel download, even in those cases where
	// the UI shows just summary data.
	//
	// Metadata is a required field
	Metadata []*string `locationName:"metadata" type:"list" required:"true"`

	// The display name for the Trusted Advisor check.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s TrustedAdvisorCheckDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCheckDescription) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *TrustedAdvisorCheckDescription) SetCategory(v string) *TrustedAdvisorCheckDescription {
	s.Category = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TrustedAdvisorCheckDescription) SetDescription(v string) *TrustedAdvisorCheckDescription {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *TrustedAdvisorCheckDescription) SetId(v string) *TrustedAdvisorCheckDescription {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *TrustedAdvisorCheckDescription) SetMetadata(v []*string) *TrustedAdvisorCheckDescription {
	s.Metadata = v
	return s
}

// SetName sets the Name field's value.
func (s *TrustedAdvisorCheckDescription) SetName(v string) *TrustedAdvisorCheckDescription {
	s.Name = &v
	return s
}

// The refresh status of a Trusted Advisor check.
type TrustedAdvisorCheckRefreshStatus struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the Trusted Advisor check.
	//
	// CheckId is a required field
	CheckId *string `locationName:"checkId" type:"string" required:"true"`

	// The amount of time, in milliseconds, until the Trusted Advisor check is eligible
	// for refresh.
	//
	// MillisUntilNextRefreshable is a required field
	MillisUntilNextRefreshable *int64 `locationName:"millisUntilNextRefreshable" type:"long" required:"true"`

	// The status of the Trusted Advisor check for which a refresh has been requested:
	// "none", "enqueued", "processing", "success", or "abandoned".
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation
func (s TrustedAdvisorCheckRefreshStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCheckRefreshStatus) GoString() string {
	return s.String()
}

// SetCheckId sets the CheckId field's value.
func (s *TrustedAdvisorCheckRefreshStatus) SetCheckId(v string) *TrustedAdvisorCheckRefreshStatus {
	s.CheckId = &v
	return s
}

// SetMillisUntilNextRefreshable sets the MillisUntilNextRefreshable field's value.
func (s *TrustedAdvisorCheckRefreshStatus) SetMillisUntilNextRefreshable(v int64) *TrustedAdvisorCheckRefreshStatus {
	s.MillisUntilNextRefreshable = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TrustedAdvisorCheckRefreshStatus) SetStatus(v string) *TrustedAdvisorCheckRefreshStatus {
	s.Status = &v
	return s
}

// The results of a Trusted Advisor check returned by DescribeTrustedAdvisorCheckResult.
type TrustedAdvisorCheckResult struct {
	_ struct{} `type:"structure"`

	// Summary information that relates to the category of the check. Cost Optimizing
	// is the only category that is currently supported.
	//
	// CategorySpecificSummary is a required field
	CategorySpecificSummary *TrustedAdvisorCategorySpecificSummary `locationName:"categorySpecificSummary" type:"structure" required:"true"`

	// The unique identifier for the Trusted Advisor check.
	//
	// CheckId is a required field
	CheckId *string `locationName:"checkId" type:"string" required:"true"`

	// The details about each resource listed in the check result.
	//
	// FlaggedResources is a required field
	FlaggedResources []*TrustedAdvisorResourceDetail `locationName:"flaggedResources" type:"list" required:"true"`

	// Details about AWS resources that were analyzed in a call to Trusted Advisor
	// DescribeTrustedAdvisorCheckSummaries.
	//
	// ResourcesSummary is a required field
	ResourcesSummary *TrustedAdvisorResourcesSummary `locationName:"resourcesSummary" type:"structure" required:"true"`

	// The alert status of the check: "ok" (green), "warning" (yellow), "error"
	// (red), or "not_available".
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`

	// The time of the last refresh of the check.
	//
	// Timestamp is a required field
	Timestamp *string `locationName:"timestamp" type:"string" required:"true"`
}

// String returns the string representation
func (s TrustedAdvisorCheckResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCheckResult) GoString() string {
	return s.String()
}

// SetCategorySpecificSummary sets the CategorySpecificSummary field's value.
func (s *TrustedAdvisorCheckResult) SetCategorySpecificSummary(v *TrustedAdvisorCategorySpecificSummary) *TrustedAdvisorCheckResult {
	s.CategorySpecificSummary = v
	return s
}

// SetCheckId sets the CheckId field's value.
func (s *TrustedAdvisorCheckResult) SetCheckId(v string) *TrustedAdvisorCheckResult {
	s.CheckId = &v
	return s
}

// SetFlaggedResources sets the FlaggedResources field's value.
func (s *TrustedAdvisorCheckResult) SetFlaggedResources(v []*TrustedAdvisorResourceDetail) *TrustedAdvisorCheckResult {
	s.FlaggedResources = v
	return s
}

// SetResourcesSummary sets the ResourcesSummary field's value.
func (s *TrustedAdvisorCheckResult) SetResourcesSummary(v *TrustedAdvisorResourcesSummary) *TrustedAdvisorCheckResult {
	s.ResourcesSummary = v
	return s
}

// SetStatus sets the Status field's value.
func (s *TrustedAdvisorCheckResult) SetStatus(v string) *TrustedAdvisorCheckResult {
	s.Status = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *TrustedAdvisorCheckResult) SetTimestamp(v string) *TrustedAdvisorCheckResult {
	s.Timestamp = &v
	return s
}

// A summary of a Trusted Advisor check result, including the alert status,
// last refresh, and number of resources examined.
type TrustedAdvisorCheckSummary struct {
	_ struct{} `type:"structure"`

	// Summary information that relates to the category of the check. Cost Optimizing
	// is the only category that is currently supported.
	//
	// CategorySpecificSummary is a required field
	CategorySpecificSummary *TrustedAdvisorCategorySpecificSummary `locationName:"categorySpecificSummary" type:"structure" required:"true"`

	// The unique identifier for the Trusted Advisor check.
	//
	// CheckId is a required field
	CheckId *string `locationName:"checkId" type:"string" required:"true"`

	// Specifies whether the Trusted Advisor check has flagged resources.
	HasFlaggedResources *bool `locationName:"hasFlaggedResources" type:"boolean"`

	// Details about AWS resources that were analyzed in a call to Trusted Advisor
	// DescribeTrustedAdvisorCheckSummaries.
	//
	// ResourcesSummary is a required field
	ResourcesSummary *TrustedAdvisorResourcesSummary `locationName:"resourcesSummary" type:"structure" required:"true"`

	// The alert status of the check: "ok" (green), "warning" (yellow), "error"
	// (red), or "not_available".
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`

	// The time of the last refresh of the check.
	//
	// Timestamp is a required field
	Timestamp *string `locationName:"timestamp" type:"string" required:"true"`
}

// String returns the string representation
func (s TrustedAdvisorCheckSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCheckSummary) GoString() string {
	return s.String()
}

// SetCategorySpecificSummary sets the CategorySpecificSummary field's value.
func (s *TrustedAdvisorCheckSummary) SetCategorySpecificSummary(v *TrustedAdvisorCategorySpecificSummary) *TrustedAdvisorCheckSummary {
	s.CategorySpecificSummary = v
	return s
}

// SetCheckId sets the CheckId field's value.
func (s *TrustedAdvisorCheckSummary) SetCheckId(v string) *TrustedAdvisorCheckSummary {
	s.CheckId = &v
	return s
}

// SetHasFlaggedResources sets the HasFlaggedResources field's value.
func (s *TrustedAdvisorCheckSummary) SetHasFlaggedResources(v bool) *TrustedAdvisorCheckSummary {
	s.HasFlaggedResources = &v
	return s
}

// SetResourcesSummary sets the ResourcesSummary field's value.
func (s *TrustedAdvisorCheckSummary) SetResourcesSummary(v *TrustedAdvisorResourcesSummary) *TrustedAdvisorCheckSummary {
	s.ResourcesSummary = v
	return s
}

// SetStatus sets the Status field's value.
func (s *TrustedAdvisorCheckSummary) SetStatus(v string) *TrustedAdvisorCheckSummary {
	s.Status = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *TrustedAdvisorCheckSummary) SetTimestamp(v string) *TrustedAdvisorCheckSummary {
	s.Timestamp = &v
	return s
}

// The estimated cost savings that might be realized if the recommended actions
// are taken.
type TrustedAdvisorCostOptimizingSummary struct {
	_ struct{} `type:"structure"`

	// The estimated monthly savings that might be realized if the recommended actions
	// are taken.
	//
	// EstimatedMonthlySavings is a required field
	EstimatedMonthlySavings *float64 `locationName:"estimatedMonthlySavings" type:"double" required:"true"`

	// The estimated percentage of savings that might be realized if the recommended
	// actions are taken.
	//
	// EstimatedPercentMonthlySavings is a required field
	EstimatedPercentMonthlySavings *float64 `locationName:"estimatedPercentMonthlySavings" type:"double" required:"true"`
}

// String returns the string representation
func (s TrustedAdvisorCostOptimizingSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCostOptimizingSummary) GoString() string {
	return s.String()
}

// SetEstimatedMonthlySavings sets the EstimatedMonthlySavings field's value.
func (s *TrustedAdvisorCostOptimizingSummary) SetEstimatedMonthlySavings(v float64) *TrustedAdvisorCostOptimizingSummary {
	s.EstimatedMonthlySavings = &v
	return s
}

// SetEstimatedPercentMonthlySavings sets the EstimatedPercentMonthlySavings field's value.
func (s *TrustedAdvisorCostOptimizingSummary) SetEstimatedPercentMonthlySavings(v float64) *TrustedAdvisorCostOptimizingSummary {
	s.EstimatedPercentMonthlySavings = &v
	return s
}

// Contains information about a resource identified by a Trusted Advisor check.
type TrustedAdvisorResourceDetail struct {
	_ struct{} `type:"structure"`

	// Specifies whether the AWS resource was ignored by Trusted Advisor because
	// it was marked as suppressed by the user.
	IsSuppressed *bool `locationName:"isSuppressed" type:"boolean"`

	// Additional information about the identified resource. The exact metadata
	// and its order can be obtained by inspecting the TrustedAdvisorCheckDescription
	// object returned by the call to DescribeTrustedAdvisorChecks. Metadata contains
	// all the data that is shown in the Excel download, even in those cases where
	// the UI shows just summary data.
	//
	// Metadata is a required field
	Metadata []*string `locationName:"metadata" type:"list" required:"true"`

	// The AWS region in which the identified resource is located.
	Region *string `locationName:"region" type:"string"`

	// The unique identifier for the identified resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The status code for the resource identified in the Trusted Advisor check.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation
func (s TrustedAdvisorResourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorResourceDetail) GoString() string {
	return s.String()
}

// SetIsSuppressed sets the IsSuppressed field's value.
func (s *TrustedAdvisorResourceDetail) SetIsSuppressed(v bool) *TrustedAdvisorResourceDetail {
	s.IsSuppressed = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *TrustedAdvisorResourceDetail) SetMetadata(v []*string) *TrustedAdvisorResourceDetail {
	s.Metadata = v
	return s
}

// SetRegion sets the Region field's value.
func (s *TrustedAdvisorResourceDetail) SetRegion(v string) *TrustedAdvisorResourceDetail {
	s.Region = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *TrustedAdvisorResourceDetail) SetResourceId(v string) *TrustedAdvisorResourceDetail {
	s.ResourceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TrustedAdvisorResourceDetail) SetStatus(v string) *TrustedAdvisorResourceDetail {
	s.Status = &v
	return s
}

// Details about AWS resources that were analyzed in a call to Trusted Advisor
// DescribeTrustedAdvisorCheckSummaries.
type TrustedAdvisorResourcesSummary struct {
	_ struct{} `type:"structure"`

	// The number of AWS resources that were flagged (listed) by the Trusted Advisor
	// check.
	//
	// ResourcesFlagged is a required field
	ResourcesFlagged *int64 `locationName:"resourcesFlagged" type:"long" required:"true"`

	// The number of AWS resources ignored by Trusted Advisor because information
	// was unavailable.
	//
	// ResourcesIgnored is a required field
	ResourcesIgnored *int64 `locationName:"resourcesIgnored" type:"long" required:"true"`

	// The number of AWS resources that were analyzed by the Trusted Advisor check.
	//
	// ResourcesProcessed is a required field
	ResourcesProcessed *int64 `locationName:"resourcesProcessed" type:"long" required:"true"`

	// The number of AWS resources ignored by Trusted Advisor because they were
	// marked as suppressed by the user.
	//
	// ResourcesSuppressed is a required field
	ResourcesSuppressed *int64 `locationName:"resourcesSuppressed" type:"long" required:"true"`
}

// String returns the string representation
func (s TrustedAdvisorResourcesSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorResourcesSummary) GoString() string {
	return s.String()
}

// SetResourcesFlagged sets the ResourcesFlagged field's value.
func (s *TrustedAdvisorResourcesSummary) SetResourcesFlagged(v int64) *TrustedAdvisorResourcesSummary {
	s.ResourcesFlagged = &v
	return s
}

// SetResourcesIgnored sets the ResourcesIgnored field's value.
func (s *TrustedAdvisorResourcesSummary) SetResourcesIgnored(v int64) *TrustedAdvisorResourcesSummary {
	s.ResourcesIgnored = &v
	return s
}

// SetResourcesProcessed sets the ResourcesProcessed field's value.
func (s *TrustedAdvisorResourcesSummary) SetResourcesProcessed(v int64) *TrustedAdvisorResourcesSummary {
	s.ResourcesProcessed = &v
	return s
}

// SetResourcesSuppressed sets the ResourcesSuppressed field's value.
func (s *TrustedAdvisorResourcesSummary) SetResourcesSuppressed(v int64) *TrustedAdvisorResourcesSummary {
	s.ResourcesSuppressed = &v
	return s
}
