// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateCampaign = "CreateCampaign"

// CreateCampaignRequest generates a "aws/request.Request" representing the
// client's request for the CreateCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCampaign for more information on using the CreateCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCampaignRequest method.
//    req, resp := client.CreateCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateCampaign
func (c *Personalize) CreateCampaignRequest(input *CreateCampaignInput) (req *request.Request, output *CreateCampaignOutput) {
	op := &request.Operation{
		Name:       opCreateCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCampaignInput{}
	}

	output = &CreateCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCampaign API operation for Amazon Personalize.
//
// Creates a campaign by deploying a solution version. When a client calls the
// GetRecommendations (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
// and GetPersonalizedRanking (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html)
// APIs, a campaign is specified in the request.
//
// Minimum Provisioned TPS and Auto-Scaling
//
// A transaction is a single GetRecommendations or GetPersonalizedRanking call.
// Transactions per second (TPS) is the throughput and unit of billing for Amazon
// Personalize. The minimum provisioned TPS (minProvisionedTPS) specifies the
// baseline throughput provisioned by Amazon Personalize, and thus, the minimum
// billing charge. If your TPS increases beyond minProvisionedTPS, Amazon Personalize
// auto-scales the provisioned capacity up and down, but never below minProvisionedTPS,
// to maintain a 70% utilization. There's a short time delay while the capacity
// is increased that might cause loss of transactions. It's recommended to start
// with a low minProvisionedTPS, track your usage using Amazon CloudWatch metrics,
// and then increase the minProvisionedTPS as necessary.
//
// Status
//
// A campaign can be in one of the following states:
//
//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//    * DELETE PENDING > DELETE IN_PROGRESS
//
// To get the campaign status, call DescribeCampaign.
//
// Wait until the status of the campaign is ACTIVE before asking the campaign
// for recommendations.
//
// Related APIs
//
//    * ListCampaigns
//
//    * DescribeCampaign
//
//    * UpdateCampaign
//
//    * DeleteCampaign
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateCampaign for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The limit on the number of requests per second has been exceeded.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateCampaign
func (c *Personalize) CreateCampaign(input *CreateCampaignInput) (*CreateCampaignOutput, error) {
	req, out := c.CreateCampaignRequest(input)
	return out, req.Send()
}

// CreateCampaignWithContext is the same as CreateCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateCampaignWithContext(ctx aws.Context, input *CreateCampaignInput, opts ...request.Option) (*CreateCampaignOutput, error) {
	req, out := c.CreateCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataset = "CreateDataset"

// CreateDatasetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataset for more information on using the CreateDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDatasetRequest method.
//    req, resp := client.CreateDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDataset
func (c *Personalize) CreateDatasetRequest(input *CreateDatasetInput) (req *request.Request, output *CreateDatasetOutput) {
	op := &request.Operation{
		Name:       opCreateDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetInput{}
	}

	output = &CreateDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataset API operation for Amazon Personalize.
//
// Creates an empty dataset and adds it to the specified dataset group. Use
// CreateDatasetImportJob to import your training data to a dataset.
//
// There are three types of datasets:
//
//    * Interactions
//
//    * Items
//
//    * Users
//
// Each dataset type has an associated schema with required field types. Only
// the Interactions dataset is required in order to train a model (also referred
// to as creating a solution).
//
// A dataset can be in one of the following states:
//
//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//    * DELETE PENDING > DELETE IN_PROGRESS
//
// To get the status of the dataset, call DescribeDataset.
//
// Related APIs
//
//    * CreateDatasetGroup
//
//    * ListDatasets
//
//    * DescribeDataset
//
//    * DeleteDataset
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateDataset for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The limit on the number of requests per second has been exceeded.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDataset
func (c *Personalize) CreateDataset(input *CreateDatasetInput) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	return out, req.Send()
}

// CreateDatasetWithContext is the same as CreateDataset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateDatasetWithContext(ctx aws.Context, input *CreateDatasetInput, opts ...request.Option) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatasetGroup = "CreateDatasetGroup"

// CreateDatasetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatasetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatasetGroup for more information on using the CreateDatasetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDatasetGroupRequest method.
//    req, resp := client.CreateDatasetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetGroup
func (c *Personalize) CreateDatasetGroupRequest(input *CreateDatasetGroupInput) (req *request.Request, output *CreateDatasetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDatasetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetGroupInput{}
	}

	output = &CreateDatasetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDatasetGroup API operation for Amazon Personalize.
//
// Creates an empty dataset group. A dataset group contains related datasets
// that supply data for training a model. A dataset group can contain at most
// three datasets, one for each type of dataset:
//
//    * Interactions
//
//    * Items
//
//    * Users
//
// To train a model (create a solution), a dataset group that contains an Interactions
// dataset is required. Call CreateDataset to add a dataset to the group.
//
// A dataset group can be in one of the following states:
//
//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//    * DELETE PENDING
//
// To get the status of the dataset group, call DescribeDatasetGroup. If the
// status shows as CREATE FAILED, the response includes a failureReason key,
// which describes why the creation failed.
//
// You must wait until the status of the dataset group is ACTIVE before adding
// a dataset to the group.
//
// You can specify an AWS Key Management Service (KMS) key to encrypt the datasets
// in the group. If you specify a KMS key, you must also include an AWS Identity
// and Access Management (IAM) role that has permission to access the key.
//
// APIs that require a dataset group ARN in the request
//
//    * CreateDataset
//
//    * CreateEventTracker
//
//    * CreateSolution
//
// Related APIs
//
//    * ListDatasetGroups
//
//    * DescribeDatasetGroup
//
//    * DeleteDatasetGroup
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateDatasetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The limit on the number of requests per second has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetGroup
func (c *Personalize) CreateDatasetGroup(input *CreateDatasetGroupInput) (*CreateDatasetGroupOutput, error) {
	req, out := c.CreateDatasetGroupRequest(input)
	return out, req.Send()
}

// CreateDatasetGroupWithContext is the same as CreateDatasetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatasetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateDatasetGroupWithContext(ctx aws.Context, input *CreateDatasetGroupInput, opts ...request.Option) (*CreateDatasetGroupOutput, error) {
	req, out := c.CreateDatasetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatasetImportJob = "CreateDatasetImportJob"

// CreateDatasetImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatasetImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatasetImportJob for more information on using the CreateDatasetImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDatasetImportJobRequest method.
//    req, resp := client.CreateDatasetImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetImportJob
func (c *Personalize) CreateDatasetImportJobRequest(input *CreateDatasetImportJobInput) (req *request.Request, output *CreateDatasetImportJobOutput) {
	op := &request.Operation{
		Name:       opCreateDatasetImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetImportJobInput{}
	}

	output = &CreateDatasetImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDatasetImportJob API operation for Amazon Personalize.
//
// Creates a job that imports training data from your data source (an Amazon
// S3 bucket) to an Amazon Personalize dataset. To allow Amazon Personalize
// to import the training data, you must specify an AWS Identity and Access
// Management (IAM) role that has permission to read from the data source.
//
// The dataset import job replaces any previous data in the dataset.
//
// Status
//
// A dataset import job can be in one of the following states:
//
//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
// To get the status of the import job, call DescribeDatasetImportJob, providing
// the Amazon Resource Name (ARN) of the dataset import job. The dataset import
// is complete when the status shows as ACTIVE. If the status shows as CREATE
// FAILED, the response includes a failureReason key, which describes why the
// job failed.
//
// Importing takes time. You must wait until the status shows as ACTIVE before
// training a model using the dataset.
//
// Related APIs
//
//    * ListDatasetImportJobs
//
//    * DescribeDatasetImportJob
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateDatasetImportJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The limit on the number of requests per second has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetImportJob
func (c *Personalize) CreateDatasetImportJob(input *CreateDatasetImportJobInput) (*CreateDatasetImportJobOutput, error) {
	req, out := c.CreateDatasetImportJobRequest(input)
	return out, req.Send()
}

// CreateDatasetImportJobWithContext is the same as CreateDatasetImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatasetImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateDatasetImportJobWithContext(ctx aws.Context, input *CreateDatasetImportJobInput, opts ...request.Option) (*CreateDatasetImportJobOutput, error) {
	req, out := c.CreateDatasetImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventTracker = "CreateEventTracker"

// CreateEventTrackerRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventTracker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventTracker for more information on using the CreateEventTracker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEventTrackerRequest method.
//    req, resp := client.CreateEventTrackerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateEventTracker
func (c *Personalize) CreateEventTrackerRequest(input *CreateEventTrackerInput) (req *request.Request, output *CreateEventTrackerOutput) {
	op := &request.Operation{
		Name:       opCreateEventTracker,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventTrackerInput{}
	}

	output = &CreateEventTrackerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventTracker API operation for Amazon Personalize.
//
// Creates an event tracker that you use when sending event data to the specified
// dataset group using the PutEvents (https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html)
// API.
//
// When Amazon Personalize creates an event tracker, it also creates an event-interactions
// dataset in the dataset group associated with the event tracker. The event-interactions
// dataset stores the event data from the PutEvents call. The contents of this
// dataset are not available to the user.
//
// Only one event tracker can be associated with a dataset group. You will get
// an error if you call CreateEventTracker using the same dataset group as an
// existing event tracker.
//
// When you send event data you include your tracking ID. The tracking ID identifies
// the customer and authorizes the customer to send the data.
//
// The event tracker can be in one of the following states:
//
//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//    * DELETE PENDING > DELETE IN_PROGRESS
//
// To get the status of the event tracker, call DescribeEventTracker.
//
// The event tracker must be in the ACTIVE state before using the tracking ID.
//
// Related APIs
//
//    * ListEventTrackers
//
//    * DescribeEventTracker
//
//    * DeleteEventTracker
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateEventTracker for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The limit on the number of requests per second has been exceeded.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateEventTracker
func (c *Personalize) CreateEventTracker(input *CreateEventTrackerInput) (*CreateEventTrackerOutput, error) {
	req, out := c.CreateEventTrackerRequest(input)
	return out, req.Send()
}

// CreateEventTrackerWithContext is the same as CreateEventTracker with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventTracker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateEventTrackerWithContext(ctx aws.Context, input *CreateEventTrackerInput, opts ...request.Option) (*CreateEventTrackerOutput, error) {
	req, out := c.CreateEventTrackerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSchema = "CreateSchema"

// CreateSchemaRequest generates a "aws/request.Request" representing the
// client's request for the CreateSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSchema for more information on using the CreateSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSchemaRequest method.
//    req, resp := client.CreateSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSchema
func (c *Personalize) CreateSchemaRequest(input *CreateSchemaInput) (req *request.Request, output *CreateSchemaOutput) {
	op := &request.Operation{
		Name:       opCreateSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSchemaInput{}
	}

	output = &CreateSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSchema API operation for Amazon Personalize.
//
// Creates an Amazon Personalize schema from the specified schema string. The
// schema you create must be in Avro JSON format.
//
// Amazon Personalize recognizes three schema variants. Each schema is associated
// with a dataset type and has a set of required field and keywords. You specify
// a schema when you call CreateDataset.
//
// Related APIs
//
//    * ListSchemas
//
//    * DescribeSchema
//
//    * DeleteSchema
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateSchema for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The limit on the number of requests per second has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSchema
func (c *Personalize) CreateSchema(input *CreateSchemaInput) (*CreateSchemaOutput, error) {
	req, out := c.CreateSchemaRequest(input)
	return out, req.Send()
}

// CreateSchemaWithContext is the same as CreateSchema with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateSchemaWithContext(ctx aws.Context, input *CreateSchemaInput, opts ...request.Option) (*CreateSchemaOutput, error) {
	req, out := c.CreateSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSolution = "CreateSolution"

// CreateSolutionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSolution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSolution for more information on using the CreateSolution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSolutionRequest method.
//    req, resp := client.CreateSolutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSolution
func (c *Personalize) CreateSolutionRequest(input *CreateSolutionInput) (req *request.Request, output *CreateSolutionOutput) {
	op := &request.Operation{
		Name:       opCreateSolution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSolutionInput{}
	}

	output = &CreateSolutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSolution API operation for Amazon Personalize.
//
// Creates the configuration for training a model. A trained model is known
// as a solution. After the configuration is created, you train the model (create
// a solution) by calling the CreateSolutionVersion operation. Every time you
// call CreateSolutionVersion, a new version of the solution is created.
//
// After creating a solution version, you check its accuracy by calling GetSolutionMetrics.
// When you are satisfied with the version, you deploy it using CreateCampaign.
// The campaign provides recommendations to a client through the GetRecommendations
// (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
// API.
//
// To train a model, Amazon Personalize requires training data and a recipe.
// The training data comes from the dataset group that you provide in the request.
// A recipe specifies the training algorithm and a feature transformation. You
// can specify one of the predefined recipes provided by Amazon Personalize.
// Alternatively, you can specify performAutoML and Amazon Personalize will
// analyze your data and select the optimum USER_PERSONALIZATION recipe for
// you.
//
// Status
//
// A solution can be in one of the following states:
//
//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//    * DELETE PENDING > DELETE IN_PROGRESS
//
// To get the status of the solution, call DescribeSolution. Wait until the
// status shows as ACTIVE before calling CreateSolutionVersion.
//
// Related APIs
//
//    * ListSolutions
//
//    * CreateSolutionVersion
//
//    * DescribeSolution
//
//    * DeleteSolution
//
//    * ListSolutionVersions
//
//    * DescribeSolutionVersion
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateSolution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The limit on the number of requests per second has been exceeded.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSolution
func (c *Personalize) CreateSolution(input *CreateSolutionInput) (*CreateSolutionOutput, error) {
	req, out := c.CreateSolutionRequest(input)
	return out, req.Send()
}

// CreateSolutionWithContext is the same as CreateSolution with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSolution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateSolutionWithContext(ctx aws.Context, input *CreateSolutionInput, opts ...request.Option) (*CreateSolutionOutput, error) {
	req, out := c.CreateSolutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSolutionVersion = "CreateSolutionVersion"

// CreateSolutionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSolutionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSolutionVersion for more information on using the CreateSolutionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSolutionVersionRequest method.
//    req, resp := client.CreateSolutionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSolutionVersion
func (c *Personalize) CreateSolutionVersionRequest(input *CreateSolutionVersionInput) (req *request.Request, output *CreateSolutionVersionOutput) {
	op := &request.Operation{
		Name:       opCreateSolutionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSolutionVersionInput{}
	}

	output = &CreateSolutionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSolutionVersion API operation for Amazon Personalize.
//
// Trains or retrains an active solution. A solution is created using the CreateSolution
// operation and must be in the ACTIVE state before calling CreateSolutionVersion.
// A new version of the solution is created every time you call this operation.
//
// Status
//
// A solution version can be in one of the following states:
//
//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
// To get the status of the version, call DescribeSolutionVersion. Wait until
// the status shows as ACTIVE before calling CreateCampaign.
//
// If the status shows as CREATE FAILED, the response includes a failureReason
// key, which describes why the job failed.
//
// Related APIs
//
//    * ListSolutionVersions
//
//    * DescribeSolutionVersion
//
//    * ListSolutions
//
//    * CreateSolution
//
//    * DescribeSolution
//
//    * DeleteSolution
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateSolutionVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSolutionVersion
func (c *Personalize) CreateSolutionVersion(input *CreateSolutionVersionInput) (*CreateSolutionVersionOutput, error) {
	req, out := c.CreateSolutionVersionRequest(input)
	return out, req.Send()
}

// CreateSolutionVersionWithContext is the same as CreateSolutionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSolutionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateSolutionVersionWithContext(ctx aws.Context, input *CreateSolutionVersionInput, opts ...request.Option) (*CreateSolutionVersionOutput, error) {
	req, out := c.CreateSolutionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCampaign = "DeleteCampaign"

// DeleteCampaignRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCampaign for more information on using the DeleteCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCampaignRequest method.
//    req, resp := client.DeleteCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteCampaign
func (c *Personalize) DeleteCampaignRequest(input *DeleteCampaignInput) (req *request.Request, output *DeleteCampaignOutput) {
	op := &request.Operation{
		Name:       opDeleteCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCampaignInput{}
	}

	output = &DeleteCampaignOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCampaign API operation for Amazon Personalize.
//
// Removes a campaign by deleting the solution deployment. The solution that
// the campaign is based on is not deleted and can be redeployed when needed.
// A deleted campaign can no longer be specified in a GetRecommendations (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
// request. For more information on campaigns, see CreateCampaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DeleteCampaign for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteCampaign
func (c *Personalize) DeleteCampaign(input *DeleteCampaignInput) (*DeleteCampaignOutput, error) {
	req, out := c.DeleteCampaignRequest(input)
	return out, req.Send()
}

// DeleteCampaignWithContext is the same as DeleteCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DeleteCampaignWithContext(ctx aws.Context, input *DeleteCampaignInput, opts ...request.Option) (*DeleteCampaignOutput, error) {
	req, out := c.DeleteCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataset = "DeleteDataset"

// DeleteDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataset for more information on using the DeleteDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDatasetRequest method.
//    req, resp := client.DeleteDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteDataset
func (c *Personalize) DeleteDatasetRequest(input *DeleteDatasetInput) (req *request.Request, output *DeleteDatasetOutput) {
	op := &request.Operation{
		Name:       opDeleteDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDatasetInput{}
	}

	output = &DeleteDatasetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataset API operation for Amazon Personalize.
//
// Deletes a dataset. You can't delete a dataset if an associated DatasetImportJob
// or SolutionVersion is in the CREATE PENDING or IN PROGRESS state. For more
// information on datasets, see CreateDataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DeleteDataset for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteDataset
func (c *Personalize) DeleteDataset(input *DeleteDatasetInput) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	return out, req.Send()
}

// DeleteDatasetWithContext is the same as DeleteDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DeleteDatasetWithContext(ctx aws.Context, input *DeleteDatasetInput, opts ...request.Option) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDatasetGroup = "DeleteDatasetGroup"

// DeleteDatasetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDatasetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDatasetGroup for more information on using the DeleteDatasetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDatasetGroupRequest method.
//    req, resp := client.DeleteDatasetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteDatasetGroup
func (c *Personalize) DeleteDatasetGroupRequest(input *DeleteDatasetGroupInput) (req *request.Request, output *DeleteDatasetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDatasetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDatasetGroupInput{}
	}

	output = &DeleteDatasetGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDatasetGroup API operation for Amazon Personalize.
//
// Deletes a dataset group. Before you delete a dataset group, you must delete
// the following:
//
//    * All associated event trackers.
//
//    * All associated solutions.
//
//    * All datasets in the dataset group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DeleteDatasetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteDatasetGroup
func (c *Personalize) DeleteDatasetGroup(input *DeleteDatasetGroupInput) (*DeleteDatasetGroupOutput, error) {
	req, out := c.DeleteDatasetGroupRequest(input)
	return out, req.Send()
}

// DeleteDatasetGroupWithContext is the same as DeleteDatasetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDatasetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DeleteDatasetGroupWithContext(ctx aws.Context, input *DeleteDatasetGroupInput, opts ...request.Option) (*DeleteDatasetGroupOutput, error) {
	req, out := c.DeleteDatasetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventTracker = "DeleteEventTracker"

// DeleteEventTrackerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventTracker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventTracker for more information on using the DeleteEventTracker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventTrackerRequest method.
//    req, resp := client.DeleteEventTrackerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteEventTracker
func (c *Personalize) DeleteEventTrackerRequest(input *DeleteEventTrackerInput) (req *request.Request, output *DeleteEventTrackerOutput) {
	op := &request.Operation{
		Name:       opDeleteEventTracker,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventTrackerInput{}
	}

	output = &DeleteEventTrackerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEventTracker API operation for Amazon Personalize.
//
// Deletes the event tracker. Does not delete the event-interactions dataset
// from the associated dataset group. For more information on event trackers,
// see CreateEventTracker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DeleteEventTracker for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteEventTracker
func (c *Personalize) DeleteEventTracker(input *DeleteEventTrackerInput) (*DeleteEventTrackerOutput, error) {
	req, out := c.DeleteEventTrackerRequest(input)
	return out, req.Send()
}

// DeleteEventTrackerWithContext is the same as DeleteEventTracker with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventTracker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DeleteEventTrackerWithContext(ctx aws.Context, input *DeleteEventTrackerInput, opts ...request.Option) (*DeleteEventTrackerOutput, error) {
	req, out := c.DeleteEventTrackerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSchema = "DeleteSchema"

// DeleteSchemaRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSchema for more information on using the DeleteSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSchemaRequest method.
//    req, resp := client.DeleteSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteSchema
func (c *Personalize) DeleteSchemaRequest(input *DeleteSchemaInput) (req *request.Request, output *DeleteSchemaOutput) {
	op := &request.Operation{
		Name:       opDeleteSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSchemaInput{}
	}

	output = &DeleteSchemaOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSchema API operation for Amazon Personalize.
//
// Deletes a schema. Before deleting a schema, you must delete all datasets
// referencing the schema. For more information on schemas, see CreateSchema.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DeleteSchema for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteSchema
func (c *Personalize) DeleteSchema(input *DeleteSchemaInput) (*DeleteSchemaOutput, error) {
	req, out := c.DeleteSchemaRequest(input)
	return out, req.Send()
}

// DeleteSchemaWithContext is the same as DeleteSchema with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DeleteSchemaWithContext(ctx aws.Context, input *DeleteSchemaInput, opts ...request.Option) (*DeleteSchemaOutput, error) {
	req, out := c.DeleteSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSolution = "DeleteSolution"

// DeleteSolutionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSolution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSolution for more information on using the DeleteSolution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSolutionRequest method.
//    req, resp := client.DeleteSolutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteSolution
func (c *Personalize) DeleteSolutionRequest(input *DeleteSolutionInput) (req *request.Request, output *DeleteSolutionOutput) {
	op := &request.Operation{
		Name:       opDeleteSolution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSolutionInput{}
	}

	output = &DeleteSolutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSolution API operation for Amazon Personalize.
//
// Deletes all versions of a solution and the Solution object itself. Before
// deleting a solution, you must delete all campaigns based on the solution.
// To determine what campaigns are using the solution, call ListCampaigns and
// supply the Amazon Resource Name (ARN) of the solution. You can't delete a
// solution if an associated SolutionVersion is in the CREATE PENDING or IN
// PROGRESS state. For more information on solutions, see CreateSolution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DeleteSolution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteSolution
func (c *Personalize) DeleteSolution(input *DeleteSolutionInput) (*DeleteSolutionOutput, error) {
	req, out := c.DeleteSolutionRequest(input)
	return out, req.Send()
}

// DeleteSolutionWithContext is the same as DeleteSolution with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSolution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DeleteSolutionWithContext(ctx aws.Context, input *DeleteSolutionInput, opts ...request.Option) (*DeleteSolutionOutput, error) {
	req, out := c.DeleteSolutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAlgorithm = "DescribeAlgorithm"

// DescribeAlgorithmRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlgorithm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlgorithm for more information on using the DescribeAlgorithm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAlgorithmRequest method.
//    req, resp := client.DescribeAlgorithmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeAlgorithm
func (c *Personalize) DescribeAlgorithmRequest(input *DescribeAlgorithmInput) (req *request.Request, output *DescribeAlgorithmOutput) {
	op := &request.Operation{
		Name:       opDescribeAlgorithm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAlgorithmInput{}
	}

	output = &DescribeAlgorithmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlgorithm API operation for Amazon Personalize.
//
// Describes the given algorithm.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeAlgorithm for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeAlgorithm
func (c *Personalize) DescribeAlgorithm(input *DescribeAlgorithmInput) (*DescribeAlgorithmOutput, error) {
	req, out := c.DescribeAlgorithmRequest(input)
	return out, req.Send()
}

// DescribeAlgorithmWithContext is the same as DescribeAlgorithm with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlgorithm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeAlgorithmWithContext(ctx aws.Context, input *DescribeAlgorithmInput, opts ...request.Option) (*DescribeAlgorithmOutput, error) {
	req, out := c.DescribeAlgorithmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCampaign = "DescribeCampaign"

// DescribeCampaignRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCampaign for more information on using the DescribeCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCampaignRequest method.
//    req, resp := client.DescribeCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeCampaign
func (c *Personalize) DescribeCampaignRequest(input *DescribeCampaignInput) (req *request.Request, output *DescribeCampaignOutput) {
	op := &request.Operation{
		Name:       opDescribeCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCampaignInput{}
	}

	output = &DescribeCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCampaign API operation for Amazon Personalize.
//
// Describes the given campaign, including its status.
//
// A campaign can be in one of the following states:
//
//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//    * DELETE PENDING > DELETE IN_PROGRESS
//
// When the status is CREATE FAILED, the response includes the failureReason
// key, which describes why.
//
// For more information on campaigns, see CreateCampaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeCampaign for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeCampaign
func (c *Personalize) DescribeCampaign(input *DescribeCampaignInput) (*DescribeCampaignOutput, error) {
	req, out := c.DescribeCampaignRequest(input)
	return out, req.Send()
}

// DescribeCampaignWithContext is the same as DescribeCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeCampaignWithContext(ctx aws.Context, input *DescribeCampaignInput, opts ...request.Option) (*DescribeCampaignOutput, error) {
	req, out := c.DescribeCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataset = "DescribeDataset"

// DescribeDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataset for more information on using the DescribeDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDatasetRequest method.
//    req, resp := client.DescribeDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDataset
func (c *Personalize) DescribeDatasetRequest(input *DescribeDatasetInput) (req *request.Request, output *DescribeDatasetOutput) {
	op := &request.Operation{
		Name:       opDescribeDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetInput{}
	}

	output = &DescribeDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataset API operation for Amazon Personalize.
//
// Describes the given dataset. For more information on datasets, see CreateDataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeDataset for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDataset
func (c *Personalize) DescribeDataset(input *DescribeDatasetInput) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	return out, req.Send()
}

// DescribeDatasetWithContext is the same as DescribeDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeDatasetWithContext(ctx aws.Context, input *DescribeDatasetInput, opts ...request.Option) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDatasetGroup = "DescribeDatasetGroup"

// DescribeDatasetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDatasetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDatasetGroup for more information on using the DescribeDatasetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDatasetGroupRequest method.
//    req, resp := client.DescribeDatasetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetGroup
func (c *Personalize) DescribeDatasetGroupRequest(input *DescribeDatasetGroupInput) (req *request.Request, output *DescribeDatasetGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeDatasetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetGroupInput{}
	}

	output = &DescribeDatasetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDatasetGroup API operation for Amazon Personalize.
//
// Describes the given dataset group. For more information on dataset groups,
// see CreateDatasetGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeDatasetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetGroup
func (c *Personalize) DescribeDatasetGroup(input *DescribeDatasetGroupInput) (*DescribeDatasetGroupOutput, error) {
	req, out := c.DescribeDatasetGroupRequest(input)
	return out, req.Send()
}

// DescribeDatasetGroupWithContext is the same as DescribeDatasetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDatasetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeDatasetGroupWithContext(ctx aws.Context, input *DescribeDatasetGroupInput, opts ...request.Option) (*DescribeDatasetGroupOutput, error) {
	req, out := c.DescribeDatasetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDatasetImportJob = "DescribeDatasetImportJob"

// DescribeDatasetImportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDatasetImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDatasetImportJob for more information on using the DescribeDatasetImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDatasetImportJobRequest method.
//    req, resp := client.DescribeDatasetImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetImportJob
func (c *Personalize) DescribeDatasetImportJobRequest(input *DescribeDatasetImportJobInput) (req *request.Request, output *DescribeDatasetImportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeDatasetImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetImportJobInput{}
	}

	output = &DescribeDatasetImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDatasetImportJob API operation for Amazon Personalize.
//
// Describes the dataset import job created by CreateDatasetImportJob, including
// the import job status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeDatasetImportJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetImportJob
func (c *Personalize) DescribeDatasetImportJob(input *DescribeDatasetImportJobInput) (*DescribeDatasetImportJobOutput, error) {
	req, out := c.DescribeDatasetImportJobRequest(input)
	return out, req.Send()
}

// DescribeDatasetImportJobWithContext is the same as DescribeDatasetImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDatasetImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeDatasetImportJobWithContext(ctx aws.Context, input *DescribeDatasetImportJobInput, opts ...request.Option) (*DescribeDatasetImportJobOutput, error) {
	req, out := c.DescribeDatasetImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventTracker = "DescribeEventTracker"

// DescribeEventTrackerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventTracker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventTracker for more information on using the DescribeEventTracker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventTrackerRequest method.
//    req, resp := client.DescribeEventTrackerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeEventTracker
func (c *Personalize) DescribeEventTrackerRequest(input *DescribeEventTrackerInput) (req *request.Request, output *DescribeEventTrackerOutput) {
	op := &request.Operation{
		Name:       opDescribeEventTracker,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventTrackerInput{}
	}

	output = &DescribeEventTrackerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventTracker API operation for Amazon Personalize.
//
// Describes an event tracker. The response includes the trackingId and status
// of the event tracker. For more information on event trackers, see CreateEventTracker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeEventTracker for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeEventTracker
func (c *Personalize) DescribeEventTracker(input *DescribeEventTrackerInput) (*DescribeEventTrackerOutput, error) {
	req, out := c.DescribeEventTrackerRequest(input)
	return out, req.Send()
}

// DescribeEventTrackerWithContext is the same as DescribeEventTracker with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventTracker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeEventTrackerWithContext(ctx aws.Context, input *DescribeEventTrackerInput, opts ...request.Option) (*DescribeEventTrackerOutput, error) {
	req, out := c.DescribeEventTrackerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFeatureTransformation = "DescribeFeatureTransformation"

// DescribeFeatureTransformationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFeatureTransformation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFeatureTransformation for more information on using the DescribeFeatureTransformation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFeatureTransformationRequest method.
//    req, resp := client.DescribeFeatureTransformationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeFeatureTransformation
func (c *Personalize) DescribeFeatureTransformationRequest(input *DescribeFeatureTransformationInput) (req *request.Request, output *DescribeFeatureTransformationOutput) {
	op := &request.Operation{
		Name:       opDescribeFeatureTransformation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFeatureTransformationInput{}
	}

	output = &DescribeFeatureTransformationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFeatureTransformation API operation for Amazon Personalize.
//
// Describes the given feature transformation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeFeatureTransformation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeFeatureTransformation
func (c *Personalize) DescribeFeatureTransformation(input *DescribeFeatureTransformationInput) (*DescribeFeatureTransformationOutput, error) {
	req, out := c.DescribeFeatureTransformationRequest(input)
	return out, req.Send()
}

// DescribeFeatureTransformationWithContext is the same as DescribeFeatureTransformation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFeatureTransformation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeFeatureTransformationWithContext(ctx aws.Context, input *DescribeFeatureTransformationInput, opts ...request.Option) (*DescribeFeatureTransformationOutput, error) {
	req, out := c.DescribeFeatureTransformationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRecipe = "DescribeRecipe"

// DescribeRecipeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRecipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRecipe for more information on using the DescribeRecipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRecipeRequest method.
//    req, resp := client.DescribeRecipeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeRecipe
func (c *Personalize) DescribeRecipeRequest(input *DescribeRecipeInput) (req *request.Request, output *DescribeRecipeOutput) {
	op := &request.Operation{
		Name:       opDescribeRecipe,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRecipeInput{}
	}

	output = &DescribeRecipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRecipe API operation for Amazon Personalize.
//
// Describes a recipe.
//
// A recipe contains three items:
//
//    * An algorithm that trains a model.
//
//    * Hyperparameters that govern the training.
//
//    * Feature transformation information for modifying the input data before
//    training.
//
// Amazon Personalize provides a set of predefined recipes. You specify a recipe
// when you create a solution with the CreateSolution API. CreateSolution trains
// a model by using the algorithm in the specified recipe and a training dataset.
// The solution, when deployed as a campaign, can provide recommendations using
// the GetRecommendations (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeRecipe for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeRecipe
func (c *Personalize) DescribeRecipe(input *DescribeRecipeInput) (*DescribeRecipeOutput, error) {
	req, out := c.DescribeRecipeRequest(input)
	return out, req.Send()
}

// DescribeRecipeWithContext is the same as DescribeRecipe with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRecipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeRecipeWithContext(ctx aws.Context, input *DescribeRecipeInput, opts ...request.Option) (*DescribeRecipeOutput, error) {
	req, out := c.DescribeRecipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSchema = "DescribeSchema"

// DescribeSchemaRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSchema for more information on using the DescribeSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSchemaRequest method.
//    req, resp := client.DescribeSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSchema
func (c *Personalize) DescribeSchemaRequest(input *DescribeSchemaInput) (req *request.Request, output *DescribeSchemaOutput) {
	op := &request.Operation{
		Name:       opDescribeSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSchemaInput{}
	}

	output = &DescribeSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSchema API operation for Amazon Personalize.
//
// Describes a schema. For more information on schemas, see CreateSchema.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeSchema for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSchema
func (c *Personalize) DescribeSchema(input *DescribeSchemaInput) (*DescribeSchemaOutput, error) {
	req, out := c.DescribeSchemaRequest(input)
	return out, req.Send()
}

// DescribeSchemaWithContext is the same as DescribeSchema with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeSchemaWithContext(ctx aws.Context, input *DescribeSchemaInput, opts ...request.Option) (*DescribeSchemaOutput, error) {
	req, out := c.DescribeSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSolution = "DescribeSolution"

// DescribeSolutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSolution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSolution for more information on using the DescribeSolution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSolutionRequest method.
//    req, resp := client.DescribeSolutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSolution
func (c *Personalize) DescribeSolutionRequest(input *DescribeSolutionInput) (req *request.Request, output *DescribeSolutionOutput) {
	op := &request.Operation{
		Name:       opDescribeSolution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSolutionInput{}
	}

	output = &DescribeSolutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSolution API operation for Amazon Personalize.
//
// Describes a solution. For more information on solutions, see CreateSolution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeSolution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSolution
func (c *Personalize) DescribeSolution(input *DescribeSolutionInput) (*DescribeSolutionOutput, error) {
	req, out := c.DescribeSolutionRequest(input)
	return out, req.Send()
}

// DescribeSolutionWithContext is the same as DescribeSolution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSolution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeSolutionWithContext(ctx aws.Context, input *DescribeSolutionInput, opts ...request.Option) (*DescribeSolutionOutput, error) {
	req, out := c.DescribeSolutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSolutionVersion = "DescribeSolutionVersion"

// DescribeSolutionVersionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSolutionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSolutionVersion for more information on using the DescribeSolutionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSolutionVersionRequest method.
//    req, resp := client.DescribeSolutionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSolutionVersion
func (c *Personalize) DescribeSolutionVersionRequest(input *DescribeSolutionVersionInput) (req *request.Request, output *DescribeSolutionVersionOutput) {
	op := &request.Operation{
		Name:       opDescribeSolutionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSolutionVersionInput{}
	}

	output = &DescribeSolutionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSolutionVersion API operation for Amazon Personalize.
//
// Describes a specific version of a solution. For more information on solutions,
// see CreateSolution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeSolutionVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSolutionVersion
func (c *Personalize) DescribeSolutionVersion(input *DescribeSolutionVersionInput) (*DescribeSolutionVersionOutput, error) {
	req, out := c.DescribeSolutionVersionRequest(input)
	return out, req.Send()
}

// DescribeSolutionVersionWithContext is the same as DescribeSolutionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSolutionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeSolutionVersionWithContext(ctx aws.Context, input *DescribeSolutionVersionInput, opts ...request.Option) (*DescribeSolutionVersionOutput, error) {
	req, out := c.DescribeSolutionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSolutionMetrics = "GetSolutionMetrics"

// GetSolutionMetricsRequest generates a "aws/request.Request" representing the
// client's request for the GetSolutionMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSolutionMetrics for more information on using the GetSolutionMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSolutionMetricsRequest method.
//    req, resp := client.GetSolutionMetricsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/GetSolutionMetrics
func (c *Personalize) GetSolutionMetricsRequest(input *GetSolutionMetricsInput) (req *request.Request, output *GetSolutionMetricsOutput) {
	op := &request.Operation{
		Name:       opGetSolutionMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSolutionMetricsInput{}
	}

	output = &GetSolutionMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSolutionMetrics API operation for Amazon Personalize.
//
// Gets the metrics for the specified solution version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation GetSolutionMetrics for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/GetSolutionMetrics
func (c *Personalize) GetSolutionMetrics(input *GetSolutionMetricsInput) (*GetSolutionMetricsOutput, error) {
	req, out := c.GetSolutionMetricsRequest(input)
	return out, req.Send()
}

// GetSolutionMetricsWithContext is the same as GetSolutionMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See GetSolutionMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) GetSolutionMetricsWithContext(ctx aws.Context, input *GetSolutionMetricsInput, opts ...request.Option) (*GetSolutionMetricsOutput, error) {
	req, out := c.GetSolutionMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCampaigns = "ListCampaigns"

// ListCampaignsRequest generates a "aws/request.Request" representing the
// client's request for the ListCampaigns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCampaigns for more information on using the ListCampaigns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCampaignsRequest method.
//    req, resp := client.ListCampaignsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListCampaigns
func (c *Personalize) ListCampaignsRequest(input *ListCampaignsInput) (req *request.Request, output *ListCampaignsOutput) {
	op := &request.Operation{
		Name:       opListCampaigns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCampaignsInput{}
	}

	output = &ListCampaignsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCampaigns API operation for Amazon Personalize.
//
// Returns a list of campaigns that use the given solution. When a solution
// is not specified, all the campaigns associated with the account are listed.
// The response provides the properties for each campaign, including the Amazon
// Resource Name (ARN). For more information on campaigns, see CreateCampaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListCampaigns for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListCampaigns
func (c *Personalize) ListCampaigns(input *ListCampaignsInput) (*ListCampaignsOutput, error) {
	req, out := c.ListCampaignsRequest(input)
	return out, req.Send()
}

// ListCampaignsWithContext is the same as ListCampaigns with the addition of
// the ability to pass a context and additional request options.
//
// See ListCampaigns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListCampaignsWithContext(ctx aws.Context, input *ListCampaignsInput, opts ...request.Option) (*ListCampaignsOutput, error) {
	req, out := c.ListCampaignsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCampaignsPages iterates over the pages of a ListCampaigns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCampaigns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCampaigns operation.
//    pageNum := 0
//    err := client.ListCampaignsPages(params,
//        func(page *personalize.ListCampaignsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Personalize) ListCampaignsPages(input *ListCampaignsInput, fn func(*ListCampaignsOutput, bool) bool) error {
	return c.ListCampaignsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCampaignsPagesWithContext same as ListCampaignsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListCampaignsPagesWithContext(ctx aws.Context, input *ListCampaignsInput, fn func(*ListCampaignsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCampaignsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCampaignsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListCampaignsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListDatasetGroups = "ListDatasetGroups"

// ListDatasetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasetGroups for more information on using the ListDatasetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDatasetGroupsRequest method.
//    req, resp := client.ListDatasetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetGroups
func (c *Personalize) ListDatasetGroupsRequest(input *ListDatasetGroupsInput) (req *request.Request, output *ListDatasetGroupsOutput) {
	op := &request.Operation{
		Name:       opListDatasetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetGroupsInput{}
	}

	output = &ListDatasetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasetGroups API operation for Amazon Personalize.
//
// Returns a list of dataset groups. The response provides the properties for
// each dataset group, including the Amazon Resource Name (ARN). For more information
// on dataset groups, see CreateDatasetGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListDatasetGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetGroups
func (c *Personalize) ListDatasetGroups(input *ListDatasetGroupsInput) (*ListDatasetGroupsOutput, error) {
	req, out := c.ListDatasetGroupsRequest(input)
	return out, req.Send()
}

// ListDatasetGroupsWithContext is the same as ListDatasetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListDatasetGroupsWithContext(ctx aws.Context, input *ListDatasetGroupsInput, opts ...request.Option) (*ListDatasetGroupsOutput, error) {
	req, out := c.ListDatasetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetGroupsPages iterates over the pages of a ListDatasetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDatasetGroups operation.
//    pageNum := 0
//    err := client.ListDatasetGroupsPages(params,
//        func(page *personalize.ListDatasetGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Personalize) ListDatasetGroupsPages(input *ListDatasetGroupsInput, fn func(*ListDatasetGroupsOutput, bool) bool) error {
	return c.ListDatasetGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetGroupsPagesWithContext same as ListDatasetGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListDatasetGroupsPagesWithContext(ctx aws.Context, input *ListDatasetGroupsInput, fn func(*ListDatasetGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDatasetGroupsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListDatasetImportJobs = "ListDatasetImportJobs"

// ListDatasetImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasetImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasetImportJobs for more information on using the ListDatasetImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDatasetImportJobsRequest method.
//    req, resp := client.ListDatasetImportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetImportJobs
func (c *Personalize) ListDatasetImportJobsRequest(input *ListDatasetImportJobsInput) (req *request.Request, output *ListDatasetImportJobsOutput) {
	op := &request.Operation{
		Name:       opListDatasetImportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetImportJobsInput{}
	}

	output = &ListDatasetImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasetImportJobs API operation for Amazon Personalize.
//
// Returns a list of dataset import jobs that use the given dataset. When a
// dataset is not specified, all the dataset import jobs associated with the
// account are listed. The response provides the properties for each dataset
// import job, including the Amazon Resource Name (ARN). For more information
// on dataset import jobs, see CreateDatasetImportJob. For more information
// on datasets, see CreateDataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListDatasetImportJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetImportJobs
func (c *Personalize) ListDatasetImportJobs(input *ListDatasetImportJobsInput) (*ListDatasetImportJobsOutput, error) {
	req, out := c.ListDatasetImportJobsRequest(input)
	return out, req.Send()
}

// ListDatasetImportJobsWithContext is the same as ListDatasetImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasetImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListDatasetImportJobsWithContext(ctx aws.Context, input *ListDatasetImportJobsInput, opts ...request.Option) (*ListDatasetImportJobsOutput, error) {
	req, out := c.ListDatasetImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetImportJobsPages iterates over the pages of a ListDatasetImportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasetImportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDatasetImportJobs operation.
//    pageNum := 0
//    err := client.ListDatasetImportJobsPages(params,
//        func(page *personalize.ListDatasetImportJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Personalize) ListDatasetImportJobsPages(input *ListDatasetImportJobsInput, fn func(*ListDatasetImportJobsOutput, bool) bool) error {
	return c.ListDatasetImportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetImportJobsPagesWithContext same as ListDatasetImportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListDatasetImportJobsPagesWithContext(ctx aws.Context, input *ListDatasetImportJobsInput, fn func(*ListDatasetImportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetImportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetImportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDatasetImportJobsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListDatasets = "ListDatasets"

// ListDatasetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasets for more information on using the ListDatasets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDatasetsRequest method.
//    req, resp := client.ListDatasetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasets
func (c *Personalize) ListDatasetsRequest(input *ListDatasetsInput) (req *request.Request, output *ListDatasetsOutput) {
	op := &request.Operation{
		Name:       opListDatasets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetsInput{}
	}

	output = &ListDatasetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasets API operation for Amazon Personalize.
//
// Returns the list of datasets contained in the given dataset group. The response
// provides the properties for each dataset, including the Amazon Resource Name
// (ARN). For more information on datasets, see CreateDataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListDatasets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasets
func (c *Personalize) ListDatasets(input *ListDatasetsInput) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	return out, req.Send()
}

// ListDatasetsWithContext is the same as ListDatasets with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListDatasetsWithContext(ctx aws.Context, input *ListDatasetsInput, opts ...request.Option) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetsPages iterates over the pages of a ListDatasets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDatasets operation.
//    pageNum := 0
//    err := client.ListDatasetsPages(params,
//        func(page *personalize.ListDatasetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Personalize) ListDatasetsPages(input *ListDatasetsInput, fn func(*ListDatasetsOutput, bool) bool) error {
	return c.ListDatasetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetsPagesWithContext same as ListDatasetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListDatasetsPagesWithContext(ctx aws.Context, input *ListDatasetsInput, fn func(*ListDatasetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDatasetsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListEventTrackers = "ListEventTrackers"

// ListEventTrackersRequest generates a "aws/request.Request" representing the
// client's request for the ListEventTrackers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventTrackers for more information on using the ListEventTrackers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEventTrackersRequest method.
//    req, resp := client.ListEventTrackersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListEventTrackers
func (c *Personalize) ListEventTrackersRequest(input *ListEventTrackersInput) (req *request.Request, output *ListEventTrackersOutput) {
	op := &request.Operation{
		Name:       opListEventTrackers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventTrackersInput{}
	}

	output = &ListEventTrackersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventTrackers API operation for Amazon Personalize.
//
// Returns the list of event trackers associated with the account. The response
// provides the properties for each event tracker, including the Amazon Resource
// Name (ARN) and tracking ID. For more information on event trackers, see CreateEventTracker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListEventTrackers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListEventTrackers
func (c *Personalize) ListEventTrackers(input *ListEventTrackersInput) (*ListEventTrackersOutput, error) {
	req, out := c.ListEventTrackersRequest(input)
	return out, req.Send()
}

// ListEventTrackersWithContext is the same as ListEventTrackers with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventTrackers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListEventTrackersWithContext(ctx aws.Context, input *ListEventTrackersInput, opts ...request.Option) (*ListEventTrackersOutput, error) {
	req, out := c.ListEventTrackersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventTrackersPages iterates over the pages of a ListEventTrackers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEventTrackers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEventTrackers operation.
//    pageNum := 0
//    err := client.ListEventTrackersPages(params,
//        func(page *personalize.ListEventTrackersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Personalize) ListEventTrackersPages(input *ListEventTrackersInput, fn func(*ListEventTrackersOutput, bool) bool) error {
	return c.ListEventTrackersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventTrackersPagesWithContext same as ListEventTrackersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListEventTrackersPagesWithContext(ctx aws.Context, input *ListEventTrackersInput, fn func(*ListEventTrackersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventTrackersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventTrackersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListEventTrackersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListRecipes = "ListRecipes"

// ListRecipesRequest generates a "aws/request.Request" representing the
// client's request for the ListRecipes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecipes for more information on using the ListRecipes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRecipesRequest method.
//    req, resp := client.ListRecipesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecipes
func (c *Personalize) ListRecipesRequest(input *ListRecipesInput) (req *request.Request, output *ListRecipesOutput) {
	op := &request.Operation{
		Name:       opListRecipes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecipesInput{}
	}

	output = &ListRecipesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecipes API operation for Amazon Personalize.
//
// Returns a list of available recipes. The response provides the properties
// for each recipe, including the recipe's Amazon Resource Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListRecipes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecipes
func (c *Personalize) ListRecipes(input *ListRecipesInput) (*ListRecipesOutput, error) {
	req, out := c.ListRecipesRequest(input)
	return out, req.Send()
}

// ListRecipesWithContext is the same as ListRecipes with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecipes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListRecipesWithContext(ctx aws.Context, input *ListRecipesInput, opts ...request.Option) (*ListRecipesOutput, error) {
	req, out := c.ListRecipesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecipesPages iterates over the pages of a ListRecipes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecipes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRecipes operation.
//    pageNum := 0
//    err := client.ListRecipesPages(params,
//        func(page *personalize.ListRecipesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Personalize) ListRecipesPages(input *ListRecipesInput, fn func(*ListRecipesOutput, bool) bool) error {
	return c.ListRecipesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecipesPagesWithContext same as ListRecipesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListRecipesPagesWithContext(ctx aws.Context, input *ListRecipesInput, fn func(*ListRecipesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecipesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecipesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListRecipesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListSchemas = "ListSchemas"

// ListSchemasRequest generates a "aws/request.Request" representing the
// client's request for the ListSchemas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSchemas for more information on using the ListSchemas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSchemasRequest method.
//    req, resp := client.ListSchemasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSchemas
func (c *Personalize) ListSchemasRequest(input *ListSchemasInput) (req *request.Request, output *ListSchemasOutput) {
	op := &request.Operation{
		Name:       opListSchemas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSchemasInput{}
	}

	output = &ListSchemasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSchemas API operation for Amazon Personalize.
//
// Returns the list of schemas associated with the account. The response provides
// the properties for each schema, including the Amazon Resource Name (ARN).
// For more information on schemas, see CreateSchema.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListSchemas for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSchemas
func (c *Personalize) ListSchemas(input *ListSchemasInput) (*ListSchemasOutput, error) {
	req, out := c.ListSchemasRequest(input)
	return out, req.Send()
}

// ListSchemasWithContext is the same as ListSchemas with the addition of
// the ability to pass a context and additional request options.
//
// See ListSchemas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListSchemasWithContext(ctx aws.Context, input *ListSchemasInput, opts ...request.Option) (*ListSchemasOutput, error) {
	req, out := c.ListSchemasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSchemasPages iterates over the pages of a ListSchemas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSchemas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSchemas operation.
//    pageNum := 0
//    err := client.ListSchemasPages(params,
//        func(page *personalize.ListSchemasOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Personalize) ListSchemasPages(input *ListSchemasInput, fn func(*ListSchemasOutput, bool) bool) error {
	return c.ListSchemasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSchemasPagesWithContext same as ListSchemasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListSchemasPagesWithContext(ctx aws.Context, input *ListSchemasInput, fn func(*ListSchemasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSchemasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSchemasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListSchemasOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListSolutionVersions = "ListSolutionVersions"

// ListSolutionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSolutionVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSolutionVersions for more information on using the ListSolutionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSolutionVersionsRequest method.
//    req, resp := client.ListSolutionVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutionVersions
func (c *Personalize) ListSolutionVersionsRequest(input *ListSolutionVersionsInput) (req *request.Request, output *ListSolutionVersionsOutput) {
	op := &request.Operation{
		Name:       opListSolutionVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSolutionVersionsInput{}
	}

	output = &ListSolutionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSolutionVersions API operation for Amazon Personalize.
//
// Returns a list of solution versions for the given solution. When a solution
// is not specified, all the solution versions associated with the account are
// listed. The response provides the properties for each solution version, including
// the Amazon Resource Name (ARN). For more information on solutions, see CreateSolution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListSolutionVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutionVersions
func (c *Personalize) ListSolutionVersions(input *ListSolutionVersionsInput) (*ListSolutionVersionsOutput, error) {
	req, out := c.ListSolutionVersionsRequest(input)
	return out, req.Send()
}

// ListSolutionVersionsWithContext is the same as ListSolutionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSolutionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListSolutionVersionsWithContext(ctx aws.Context, input *ListSolutionVersionsInput, opts ...request.Option) (*ListSolutionVersionsOutput, error) {
	req, out := c.ListSolutionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSolutionVersionsPages iterates over the pages of a ListSolutionVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSolutionVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSolutionVersions operation.
//    pageNum := 0
//    err := client.ListSolutionVersionsPages(params,
//        func(page *personalize.ListSolutionVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Personalize) ListSolutionVersionsPages(input *ListSolutionVersionsInput, fn func(*ListSolutionVersionsOutput, bool) bool) error {
	return c.ListSolutionVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSolutionVersionsPagesWithContext same as ListSolutionVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListSolutionVersionsPagesWithContext(ctx aws.Context, input *ListSolutionVersionsInput, fn func(*ListSolutionVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSolutionVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSolutionVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListSolutionVersionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListSolutions = "ListSolutions"

// ListSolutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSolutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSolutions for more information on using the ListSolutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSolutionsRequest method.
//    req, resp := client.ListSolutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutions
func (c *Personalize) ListSolutionsRequest(input *ListSolutionsInput) (req *request.Request, output *ListSolutionsOutput) {
	op := &request.Operation{
		Name:       opListSolutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSolutionsInput{}
	}

	output = &ListSolutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSolutions API operation for Amazon Personalize.
//
// Returns a list of solutions that use the given dataset group. When a dataset
// group is not specified, all the solutions associated with the account are
// listed. The response provides the properties for each solution, including
// the Amazon Resource Name (ARN). For more information on solutions, see CreateSolution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListSolutions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutions
func (c *Personalize) ListSolutions(input *ListSolutionsInput) (*ListSolutionsOutput, error) {
	req, out := c.ListSolutionsRequest(input)
	return out, req.Send()
}

// ListSolutionsWithContext is the same as ListSolutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSolutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListSolutionsWithContext(ctx aws.Context, input *ListSolutionsInput, opts ...request.Option) (*ListSolutionsOutput, error) {
	req, out := c.ListSolutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSolutionsPages iterates over the pages of a ListSolutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSolutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSolutions operation.
//    pageNum := 0
//    err := client.ListSolutionsPages(params,
//        func(page *personalize.ListSolutionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Personalize) ListSolutionsPages(input *ListSolutionsInput, fn func(*ListSolutionsOutput, bool) bool) error {
	return c.ListSolutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSolutionsPagesWithContext same as ListSolutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListSolutionsPagesWithContext(ctx aws.Context, input *ListSolutionsInput, fn func(*ListSolutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSolutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSolutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListSolutionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opUpdateCampaign = "UpdateCampaign"

// UpdateCampaignRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCampaign for more information on using the UpdateCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCampaignRequest method.
//    req, resp := client.UpdateCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateCampaign
func (c *Personalize) UpdateCampaignRequest(input *UpdateCampaignInput) (req *request.Request, output *UpdateCampaignOutput) {
	op := &request.Operation{
		Name:       opUpdateCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCampaignInput{}
	}

	output = &UpdateCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCampaign API operation for Amazon Personalize.
//
// Updates a campaign by either deploying a new solution or changing the value
// of the campaign's minProvisionedTPS parameter.
//
// To update a campaign, the campaign status must be ACTIVE or CREATE FAILED.
// Check the campaign status using the DescribeCampaign API.
//
// You must wait until the status of the updated campaign is ACTIVE before asking
// the campaign for recommendations.
//
// For more information on campaigns, see CreateCampaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation UpdateCampaign for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Provide a valid value for the field or parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Could not find the specified resource.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateCampaign
func (c *Personalize) UpdateCampaign(input *UpdateCampaignInput) (*UpdateCampaignOutput, error) {
	req, out := c.UpdateCampaignRequest(input)
	return out, req.Send()
}

// UpdateCampaignWithContext is the same as UpdateCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) UpdateCampaignWithContext(ctx aws.Context, input *UpdateCampaignInput, opts ...request.Option) (*UpdateCampaignOutput, error) {
	req, out := c.UpdateCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes a custom algorithm.
type Algorithm struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm.
	AlgorithmArn *string `locationName:"algorithmArn" type:"string"`

	// The URI of the Docker container for the algorithm image.
	AlgorithmImage *AlgorithmImage `locationName:"algorithmImage" type:"structure"`

	// The date and time (in Unix time) that the algorithm was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// Specifies the default hyperparameters, their ranges, and whether they are
	// tunable. A tunable hyperparameter can have its value determined during hyperparameter
	// optimization (HPO).
	DefaultHyperParameterRanges *DefaultHyperParameterRanges `locationName:"defaultHyperParameterRanges" type:"structure"`

	// Specifies the default hyperparameters.
	DefaultHyperParameters map[string]*string `locationName:"defaultHyperParameters" type:"map"`

	// Specifies the default maximum number of training jobs and parallel training
	// jobs.
	DefaultResourceConfig map[string]*string `locationName:"defaultResourceConfig" type:"map"`

	// The date and time (in Unix time) that the algorithm was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the algorithm.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the role.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The training input mode.
	TrainingInputMode *string `locationName:"trainingInputMode" type:"string"`
}

// String returns the string representation
func (s Algorithm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Algorithm) GoString() string {
	return s.String()
}

// SetAlgorithmArn sets the AlgorithmArn field's value.
func (s *Algorithm) SetAlgorithmArn(v string) *Algorithm {
	s.AlgorithmArn = &v
	return s
}

// SetAlgorithmImage sets the AlgorithmImage field's value.
func (s *Algorithm) SetAlgorithmImage(v *AlgorithmImage) *Algorithm {
	s.AlgorithmImage = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *Algorithm) SetCreationDateTime(v time.Time) *Algorithm {
	s.CreationDateTime = &v
	return s
}

// SetDefaultHyperParameterRanges sets the DefaultHyperParameterRanges field's value.
func (s *Algorithm) SetDefaultHyperParameterRanges(v *DefaultHyperParameterRanges) *Algorithm {
	s.DefaultHyperParameterRanges = v
	return s
}

// SetDefaultHyperParameters sets the DefaultHyperParameters field's value.
func (s *Algorithm) SetDefaultHyperParameters(v map[string]*string) *Algorithm {
	s.DefaultHyperParameters = v
	return s
}

// SetDefaultResourceConfig sets the DefaultResourceConfig field's value.
func (s *Algorithm) SetDefaultResourceConfig(v map[string]*string) *Algorithm {
	s.DefaultResourceConfig = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *Algorithm) SetLastUpdatedDateTime(v time.Time) *Algorithm {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Algorithm) SetName(v string) *Algorithm {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Algorithm) SetRoleArn(v string) *Algorithm {
	s.RoleArn = &v
	return s
}

// SetTrainingInputMode sets the TrainingInputMode field's value.
func (s *Algorithm) SetTrainingInputMode(v string) *Algorithm {
	s.TrainingInputMode = &v
	return s
}

// Describes an algorithm image.
type AlgorithmImage struct {
	_ struct{} `type:"structure"`

	// The URI of the Docker container for the algorithm image.
	//
	// DockerURI is a required field
	DockerURI *string `locationName:"dockerURI" type:"string" required:"true"`

	// The name of the algorithm image.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s AlgorithmImage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlgorithmImage) GoString() string {
	return s.String()
}

// SetDockerURI sets the DockerURI field's value.
func (s *AlgorithmImage) SetDockerURI(v string) *AlgorithmImage {
	s.DockerURI = &v
	return s
}

// SetName sets the Name field's value.
func (s *AlgorithmImage) SetName(v string) *AlgorithmImage {
	s.Name = &v
	return s
}

// When the solution performs AutoML (performAutoML is true in CreateSolution),
// Amazon Personalize determines which recipe, from the specified list, optimizes
// the given metric. Amazon Personalize then uses that recipe for the solution.
type AutoMLConfig struct {
	_ struct{} `type:"structure"`

	// The metric to optimize.
	MetricName *string `locationName:"metricName" type:"string"`

	// The list of candidate recipes.
	RecipeList []*string `locationName:"recipeList" type:"list"`
}

// String returns the string representation
func (s AutoMLConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLConfig) GoString() string {
	return s.String()
}

// SetMetricName sets the MetricName field's value.
func (s *AutoMLConfig) SetMetricName(v string) *AutoMLConfig {
	s.MetricName = &v
	return s
}

// SetRecipeList sets the RecipeList field's value.
func (s *AutoMLConfig) SetRecipeList(v []*string) *AutoMLConfig {
	s.RecipeList = v
	return s
}

// When the solution performs AutoML (performAutoML is true in CreateSolution),
// specifies the recipe that best optimized the specified metric.
type AutoMLResult struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the best recipe.
	BestRecipeArn *string `locationName:"bestRecipeArn" type:"string"`
}

// String returns the string representation
func (s AutoMLResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLResult) GoString() string {
	return s.String()
}

// SetBestRecipeArn sets the BestRecipeArn field's value.
func (s *AutoMLResult) SetBestRecipeArn(v string) *AutoMLResult {
	s.BestRecipeArn = &v
	return s
}

// Describes a deployed solution version, otherwise known as a campaign. For
// more information on campaigns, see CreateCampaign.
type Campaign struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign.
	CampaignArn *string `locationName:"campaignArn" type:"string"`

	// The date and time (in Unix format) that the campaign was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If a campaign fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix format) that the campaign was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// Provides a summary of the properties of a campaign update. For a complete
	// listing, call the DescribeCampaign API.
	LatestCampaignUpdate *CampaignUpdateSummary `locationName:"latestCampaignUpdate" type:"structure"`

	// Specifies the requested minimum provisioned transactions (recommendations)
	// per second.
	MinProvisionedTPS *int64 `locationName:"minProvisionedTPS" min:"1" type:"integer"`

	// The name of the campaign.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of a specific version of the solution.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the campaign.
	//
	// A campaign can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s Campaign) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Campaign) GoString() string {
	return s.String()
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *Campaign) SetCampaignArn(v string) *Campaign {
	s.CampaignArn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *Campaign) SetCreationDateTime(v time.Time) *Campaign {
	s.CreationDateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *Campaign) SetFailureReason(v string) *Campaign {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *Campaign) SetLastUpdatedDateTime(v time.Time) *Campaign {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLatestCampaignUpdate sets the LatestCampaignUpdate field's value.
func (s *Campaign) SetLatestCampaignUpdate(v *CampaignUpdateSummary) *Campaign {
	s.LatestCampaignUpdate = v
	return s
}

// SetMinProvisionedTPS sets the MinProvisionedTPS field's value.
func (s *Campaign) SetMinProvisionedTPS(v int64) *Campaign {
	s.MinProvisionedTPS = &v
	return s
}

// SetName sets the Name field's value.
func (s *Campaign) SetName(v string) *Campaign {
	s.Name = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *Campaign) SetSolutionVersionArn(v string) *Campaign {
	s.SolutionVersionArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Campaign) SetStatus(v string) *Campaign {
	s.Status = &v
	return s
}

// Provides a summary of the properties of a campaign. For a complete listing,
// call the DescribeCampaign API.
type CampaignSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign.
	CampaignArn *string `locationName:"campaignArn" type:"string"`

	// The date and time (in Unix time) that the campaign was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If a campaign fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the campaign was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the campaign.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the campaign.
	//
	// A campaign can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s CampaignSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignSummary) GoString() string {
	return s.String()
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *CampaignSummary) SetCampaignArn(v string) *CampaignSummary {
	s.CampaignArn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CampaignSummary) SetCreationDateTime(v time.Time) *CampaignSummary {
	s.CreationDateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CampaignSummary) SetFailureReason(v string) *CampaignSummary {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *CampaignSummary) SetLastUpdatedDateTime(v time.Time) *CampaignSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *CampaignSummary) SetName(v string) *CampaignSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CampaignSummary) SetStatus(v string) *CampaignSummary {
	s.Status = &v
	return s
}

// Provides a summary of the properties of a campaign update. For a complete
// listing, call the DescribeCampaign API.
type CampaignUpdateSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the campaign update was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If a campaign update fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the campaign update was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// Specifies the requested minimum provisioned transactions (recommendations)
	// per second that Amazon Personalize will support.
	MinProvisionedTPS *int64 `locationName:"minProvisionedTPS" min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the deployed solution version.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the campaign update.
	//
	// A campaign update can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s CampaignUpdateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignUpdateSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CampaignUpdateSummary) SetCreationDateTime(v time.Time) *CampaignUpdateSummary {
	s.CreationDateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CampaignUpdateSummary) SetFailureReason(v string) *CampaignUpdateSummary {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *CampaignUpdateSummary) SetLastUpdatedDateTime(v time.Time) *CampaignUpdateSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetMinProvisionedTPS sets the MinProvisionedTPS field's value.
func (s *CampaignUpdateSummary) SetMinProvisionedTPS(v int64) *CampaignUpdateSummary {
	s.MinProvisionedTPS = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *CampaignUpdateSummary) SetSolutionVersionArn(v string) *CampaignUpdateSummary {
	s.SolutionVersionArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CampaignUpdateSummary) SetStatus(v string) *CampaignUpdateSummary {
	s.Status = &v
	return s
}

// Provides the name and range of a categorical hyperparameter.
type CategoricalHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`

	// A list of the categories for the hyperparameter.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s CategoricalHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CategoricalHyperParameterRange) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CategoricalHyperParameterRange) SetName(v string) *CategoricalHyperParameterRange {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *CategoricalHyperParameterRange) SetValues(v []*string) *CategoricalHyperParameterRange {
	s.Values = v
	return s
}

// Provides the name and range of a continuous hyperparameter.
type ContinuousHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// The maximum allowable value for the hyperparameter.
	MaxValue *float64 `locationName:"maxValue" type:"double"`

	// The minimum allowable value for the hyperparameter.
	MinValue *float64 `locationName:"minValue" type:"double"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s ContinuousHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinuousHyperParameterRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinuousHyperParameterRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContinuousHyperParameterRange"}
	if s.MaxValue != nil && *s.MaxValue < -1e+06 {
		invalidParams.Add(request.NewErrParamMinValue("MaxValue", -1e+06))
	}
	if s.MinValue != nil && *s.MinValue < -1e+06 {
		invalidParams.Add(request.NewErrParamMinValue("MinValue", -1e+06))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxValue sets the MaxValue field's value.
func (s *ContinuousHyperParameterRange) SetMaxValue(v float64) *ContinuousHyperParameterRange {
	s.MaxValue = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *ContinuousHyperParameterRange) SetMinValue(v float64) *ContinuousHyperParameterRange {
	s.MinValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContinuousHyperParameterRange) SetName(v string) *ContinuousHyperParameterRange {
	s.Name = &v
	return s
}

type CreateCampaignInput struct {
	_ struct{} `type:"structure"`

	// Specifies the requested minimum provisioned transactions (recommendations)
	// per second that Amazon Personalize will support.
	//
	// MinProvisionedTPS is a required field
	MinProvisionedTPS *int64 `locationName:"minProvisionedTPS" min:"1" type:"integer" required:"true"`

	// A name for the new campaign. The campaign name must be unique within your
	// account.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the solution version to deploy.
	//
	// SolutionVersionArn is a required field
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCampaignInput"}
	if s.MinProvisionedTPS == nil {
		invalidParams.Add(request.NewErrParamRequired("MinProvisionedTPS"))
	}
	if s.MinProvisionedTPS != nil && *s.MinProvisionedTPS < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinProvisionedTPS", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SolutionVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SolutionVersionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMinProvisionedTPS sets the MinProvisionedTPS field's value.
func (s *CreateCampaignInput) SetMinProvisionedTPS(v int64) *CreateCampaignInput {
	s.MinProvisionedTPS = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCampaignInput) SetName(v string) *CreateCampaignInput {
	s.Name = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *CreateCampaignInput) SetSolutionVersionArn(v string) *CreateCampaignInput {
	s.SolutionVersionArn = &v
	return s
}

type CreateCampaignOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign.
	CampaignArn *string `locationName:"campaignArn" type:"string"`
}

// String returns the string representation
func (s CreateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *CreateCampaignOutput) SetCampaignArn(v string) *CreateCampaignOutput {
	s.CampaignArn = &v
	return s
}

type CreateDatasetGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a KMS key used to encrypt the datasets.
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string"`

	// The name for the new dataset group.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that has permissions to access the KMS key. Supplying
	// an IAM role is only valid when also specifying a KMS key.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation
func (s CreateDatasetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CreateDatasetGroupInput) SetKmsKeyArn(v string) *CreateDatasetGroupInput {
	s.KmsKeyArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDatasetGroupInput) SetName(v string) *CreateDatasetGroupInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateDatasetGroupInput) SetRoleArn(v string) *CreateDatasetGroupInput {
	s.RoleArn = &v
	return s
}

type CreateDatasetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new dataset group.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`
}

// String returns the string representation
func (s CreateDatasetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetGroupOutput) GoString() string {
	return s.String()
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *CreateDatasetGroupOutput) SetDatasetGroupArn(v string) *CreateDatasetGroupOutput {
	s.DatasetGroupArn = &v
	return s
}

type CreateDatasetImportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket that contains the training data to import.
	//
	// DataSource is a required field
	DataSource *DataSource `locationName:"dataSource" type:"structure" required:"true"`

	// The ARN of the dataset that receives the imported data.
	//
	// DatasetArn is a required field
	DatasetArn *string `locationName:"datasetArn" type:"string" required:"true"`

	// The name for the dataset import job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that has permissions to read from the Amazon S3 data
	// source.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDatasetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetImportJobInput"}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSource sets the DataSource field's value.
func (s *CreateDatasetImportJobInput) SetDataSource(v *DataSource) *CreateDatasetImportJobInput {
	s.DataSource = v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *CreateDatasetImportJobInput) SetDatasetArn(v string) *CreateDatasetImportJobInput {
	s.DatasetArn = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *CreateDatasetImportJobInput) SetJobName(v string) *CreateDatasetImportJobInput {
	s.JobName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateDatasetImportJobInput) SetRoleArn(v string) *CreateDatasetImportJobInput {
	s.RoleArn = &v
	return s
}

type CreateDatasetImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset import job.
	DatasetImportJobArn *string `locationName:"datasetImportJobArn" type:"string"`
}

// String returns the string representation
func (s CreateDatasetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetImportJobOutput) GoString() string {
	return s.String()
}

// SetDatasetImportJobArn sets the DatasetImportJobArn field's value.
func (s *CreateDatasetImportJobOutput) SetDatasetImportJobArn(v string) *CreateDatasetImportJobOutput {
	s.DatasetImportJobArn = &v
	return s
}

type CreateDatasetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group to add the dataset to.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`

	// The type of dataset.
	//
	// One of the following (case insensitive) values:
	//
	//    * Interactions
	//
	//    * Items
	//
	//    * Users
	//
	// DatasetType is a required field
	DatasetType *string `locationName:"datasetType" type:"string" required:"true"`

	// The name for the dataset.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The ARN of the schema to associate with the dataset. The schema defines the
	// dataset fields.
	//
	// SchemaArn is a required field
	SchemaArn *string `locationName:"schemaArn" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetInput"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}
	if s.DatasetType == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *CreateDatasetInput) SetDatasetGroupArn(v string) *CreateDatasetInput {
	s.DatasetGroupArn = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *CreateDatasetInput) SetDatasetType(v string) *CreateDatasetInput {
	s.DatasetType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDatasetInput) SetName(v string) *CreateDatasetInput {
	s.Name = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *CreateDatasetInput) SetSchemaArn(v string) *CreateDatasetInput {
	s.SchemaArn = &v
	return s
}

type CreateDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset.
	DatasetArn *string `locationName:"datasetArn" type:"string"`
}

// String returns the string representation
func (s CreateDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetOutput) GoString() string {
	return s.String()
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *CreateDatasetOutput) SetDatasetArn(v string) *CreateDatasetOutput {
	s.DatasetArn = &v
	return s
}

type CreateEventTrackerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group that receives the event
	// data.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`

	// The name for the event tracker.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEventTrackerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventTrackerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventTrackerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventTrackerInput"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *CreateEventTrackerInput) SetDatasetGroupArn(v string) *CreateEventTrackerInput {
	s.DatasetGroupArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEventTrackerInput) SetName(v string) *CreateEventTrackerInput {
	s.Name = &v
	return s
}

type CreateEventTrackerOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the event tracker.
	EventTrackerArn *string `locationName:"eventTrackerArn" type:"string"`

	// The ID of the event tracker. Include this ID in requests to the PutEvents
	// (https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html)
	// API.
	TrackingId *string `locationName:"trackingId" type:"string"`
}

// String returns the string representation
func (s CreateEventTrackerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventTrackerOutput) GoString() string {
	return s.String()
}

// SetEventTrackerArn sets the EventTrackerArn field's value.
func (s *CreateEventTrackerOutput) SetEventTrackerArn(v string) *CreateEventTrackerOutput {
	s.EventTrackerArn = &v
	return s
}

// SetTrackingId sets the TrackingId field's value.
func (s *CreateEventTrackerOutput) SetTrackingId(v string) *CreateEventTrackerOutput {
	s.TrackingId = &v
	return s
}

type CreateSchemaInput struct {
	_ struct{} `type:"structure"`

	// The name for the schema.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A schema in Avro JSON format.
	//
	// Schema is a required field
	Schema *string `locationName:"schema" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSchemaInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Schema == nil {
		invalidParams.Add(request.NewErrParamRequired("Schema"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateSchemaInput) SetName(v string) *CreateSchemaInput {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *CreateSchemaInput) SetSchema(v string) *CreateSchemaInput {
	s.Schema = &v
	return s
}

type CreateSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the created schema.
	SchemaArn *string `locationName:"schemaArn" type:"string"`
}

// String returns the string representation
func (s CreateSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSchemaOutput) GoString() string {
	return s.String()
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *CreateSchemaOutput) SetSchemaArn(v string) *CreateSchemaOutput {
	s.SchemaArn = &v
	return s
}

type CreateSolutionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group that provides the training
	// data.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`

	// When your have multiple event types (using an EVENT_TYPE schema field), this
	// parameter specifies which event type (for example, 'click' or 'like') is
	// used for training the model.
	EventType *string `locationName:"eventType" type:"string"`

	// The name for the solution.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Whether to perform automated machine learning (AutoML). The default is false.
	// For this case, you must specify recipeArn.
	//
	// When set to true, Amazon Personalize analyzes your training data and selects
	// the optimal USER_PERSONALIZATION recipe and hyperparameters. In this case,
	// you must omit recipeArn. Amazon Personalize determines the optimal recipe
	// by running tests with different values for the hyperparameters. AutoML lengthens
	// the training process as compared to selecting a specific recipe.
	PerformAutoML *bool `locationName:"performAutoML" type:"boolean"`

	// Whether to perform hyperparameter optimization (HPO) on the specified or
	// selected recipe. The default is false.
	//
	// When performing AutoML, this parameter is always true and you should not
	// set it to false.
	PerformHPO *bool `locationName:"performHPO" type:"boolean"`

	// The ARN of the recipe to use for model training. Only specified when performAutoML
	// is false.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// The configuration to use with the solution. When performAutoML is set to
	// true, Amazon Personalize only evaluates the autoMLConfig section of the solution
	// configuration.
	SolutionConfig *SolutionConfig `locationName:"solutionConfig" type:"structure"`
}

// String returns the string representation
func (s CreateSolutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSolutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSolutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSolutionInput"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SolutionConfig != nil {
		if err := s.SolutionConfig.Validate(); err != nil {
			invalidParams.AddNested("SolutionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *CreateSolutionInput) SetDatasetGroupArn(v string) *CreateSolutionInput {
	s.DatasetGroupArn = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *CreateSolutionInput) SetEventType(v string) *CreateSolutionInput {
	s.EventType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSolutionInput) SetName(v string) *CreateSolutionInput {
	s.Name = &v
	return s
}

// SetPerformAutoML sets the PerformAutoML field's value.
func (s *CreateSolutionInput) SetPerformAutoML(v bool) *CreateSolutionInput {
	s.PerformAutoML = &v
	return s
}

// SetPerformHPO sets the PerformHPO field's value.
func (s *CreateSolutionInput) SetPerformHPO(v bool) *CreateSolutionInput {
	s.PerformHPO = &v
	return s
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *CreateSolutionInput) SetRecipeArn(v string) *CreateSolutionInput {
	s.RecipeArn = &v
	return s
}

// SetSolutionConfig sets the SolutionConfig field's value.
func (s *CreateSolutionInput) SetSolutionConfig(v *SolutionConfig) *CreateSolutionInput {
	s.SolutionConfig = v
	return s
}

type CreateSolutionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the solution.
	SolutionArn *string `locationName:"solutionArn" type:"string"`
}

// String returns the string representation
func (s CreateSolutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSolutionOutput) GoString() string {
	return s.String()
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *CreateSolutionOutput) SetSolutionArn(v string) *CreateSolutionOutput {
	s.SolutionArn = &v
	return s
}

type CreateSolutionVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the solution containing the training configuration
	// information.
	//
	// SolutionArn is a required field
	SolutionArn *string `locationName:"solutionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSolutionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSolutionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSolutionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSolutionVersionInput"}
	if s.SolutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SolutionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *CreateSolutionVersionInput) SetSolutionArn(v string) *CreateSolutionVersionInput {
	s.SolutionArn = &v
	return s
}

type CreateSolutionVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the new solution version.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`
}

// String returns the string representation
func (s CreateSolutionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSolutionVersionOutput) GoString() string {
	return s.String()
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *CreateSolutionVersionOutput) SetSolutionVersionArn(v string) *CreateSolutionVersionOutput {
	s.SolutionVersionArn = &v
	return s
}

// Describes the data source that contains the data to upload to a dataset.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The path to the Amazon S3 bucket where the data that you want to upload to
	// your dataset is stored. For example:
	//
	// s3://bucket-name/training-data.csv
	DataLocation *string `locationName:"dataLocation" type:"string"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSource) GoString() string {
	return s.String()
}

// SetDataLocation sets the DataLocation field's value.
func (s *DataSource) SetDataLocation(v string) *DataSource {
	s.DataLocation = &v
	return s
}

// Provides metadata for a dataset.
type Dataset struct {
	_ struct{} `type:"structure"`

	// The creation date and time (in Unix time) of the dataset.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset that you want metadata for.
	DatasetArn *string `locationName:"datasetArn" type:"string"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// One of the following values:
	//
	//    * Interactions
	//
	//    * Items
	//
	//    * Users
	DatasetType *string `locationName:"datasetType" type:"string"`

	// A time stamp that shows when the dataset was updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the dataset.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The ARN of the associated schema.
	SchemaArn *string `locationName:"schemaArn" type:"string"`

	// The status of the dataset.
	//
	// A dataset can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s Dataset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Dataset) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *Dataset) SetCreationDateTime(v time.Time) *Dataset {
	s.CreationDateTime = &v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *Dataset) SetDatasetArn(v string) *Dataset {
	s.DatasetArn = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *Dataset) SetDatasetGroupArn(v string) *Dataset {
	s.DatasetGroupArn = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *Dataset) SetDatasetType(v string) *Dataset {
	s.DatasetType = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *Dataset) SetLastUpdatedDateTime(v time.Time) *Dataset {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Dataset) SetName(v string) *Dataset {
	s.Name = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *Dataset) SetSchemaArn(v string) *Dataset {
	s.SchemaArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Dataset) SetStatus(v string) *Dataset {
	s.Status = &v
	return s
}

// A dataset group is a collection of related datasets (Interactions, User,
// and Item). You create a dataset group by calling CreateDatasetGroup. You
// then create a dataset and add it to a dataset group by calling CreateDataset.
// The dataset group is used to create and train a solution by calling CreateSolution.
// A dataset group can contain only one of each type of dataset.
//
// You can specify an AWS Key Management Service (KMS) key to encrypt the datasets
// in the group.
type DatasetGroup struct {
	_ struct{} `type:"structure"`

	// The creation date and time (in Unix time) of the dataset group.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// If creating a dataset group fails, provides the reason why.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt the datasets.
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string"`

	// The last update date and time (in Unix time) of the dataset group.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the dataset group.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The ARN of the IAM role that has permissions to create the dataset group.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The current status of the dataset group.
	//
	// A dataset group can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s DatasetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetGroup) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetGroup) SetCreationDateTime(v time.Time) *DatasetGroup {
	s.CreationDateTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *DatasetGroup) SetDatasetGroupArn(v string) *DatasetGroup {
	s.DatasetGroupArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DatasetGroup) SetFailureReason(v string) *DatasetGroup {
	s.FailureReason = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *DatasetGroup) SetKmsKeyArn(v string) *DatasetGroup {
	s.KmsKeyArn = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetGroup) SetLastUpdatedDateTime(v time.Time) *DatasetGroup {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DatasetGroup) SetName(v string) *DatasetGroup {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DatasetGroup) SetRoleArn(v string) *DatasetGroup {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetGroup) SetStatus(v string) *DatasetGroup {
	s.Status = &v
	return s
}

// Provides a summary of the properties of a dataset group. For a complete listing,
// call the DescribeDatasetGroup API.
type DatasetGroupSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the dataset group was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// If creating a dataset group fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the dataset group was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the dataset group.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the dataset group.
	//
	// A dataset group can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s DatasetGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetGroupSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetGroupSummary) SetCreationDateTime(v time.Time) *DatasetGroupSummary {
	s.CreationDateTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *DatasetGroupSummary) SetDatasetGroupArn(v string) *DatasetGroupSummary {
	s.DatasetGroupArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DatasetGroupSummary) SetFailureReason(v string) *DatasetGroupSummary {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetGroupSummary) SetLastUpdatedDateTime(v time.Time) *DatasetGroupSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DatasetGroupSummary) SetName(v string) *DatasetGroupSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetGroupSummary) SetStatus(v string) *DatasetGroupSummary {
	s.Status = &v
	return s
}

// Describes a job that imports training data from a data source (Amazon S3
// bucket) to an Amazon Personalize dataset. For more information, see CreateDatasetImportJob.
//
// A dataset import job can be in one of the following states:
//
//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
type DatasetImportJob struct {
	_ struct{} `type:"structure"`

	// The creation date and time (in Unix time) of the dataset import job.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon S3 bucket that contains the training data to import.
	DataSource *DataSource `locationName:"dataSource" type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset that receives the imported
	// data.
	DatasetArn *string `locationName:"datasetArn" type:"string"`

	// The ARN of the dataset import job.
	DatasetImportJobArn *string `locationName:"datasetImportJobArn" type:"string"`

	// If a dataset import job fails, provides the reason why.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The name of the import job.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// The date and time (in Unix time) the dataset was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The ARN of the AWS Identity and Access Management (IAM) role that has permissions
	// to read from the Amazon S3 data source.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The status of the dataset import job.
	//
	// A dataset import job can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s DatasetImportJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetImportJob) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetImportJob) SetCreationDateTime(v time.Time) *DatasetImportJob {
	s.CreationDateTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *DatasetImportJob) SetDataSource(v *DataSource) *DatasetImportJob {
	s.DataSource = v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DatasetImportJob) SetDatasetArn(v string) *DatasetImportJob {
	s.DatasetArn = &v
	return s
}

// SetDatasetImportJobArn sets the DatasetImportJobArn field's value.
func (s *DatasetImportJob) SetDatasetImportJobArn(v string) *DatasetImportJob {
	s.DatasetImportJobArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DatasetImportJob) SetFailureReason(v string) *DatasetImportJob {
	s.FailureReason = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *DatasetImportJob) SetJobName(v string) *DatasetImportJob {
	s.JobName = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetImportJob) SetLastUpdatedDateTime(v time.Time) *DatasetImportJob {
	s.LastUpdatedDateTime = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DatasetImportJob) SetRoleArn(v string) *DatasetImportJob {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetImportJob) SetStatus(v string) *DatasetImportJob {
	s.Status = &v
	return s
}

// Provides a summary of the properties of a dataset import job. For a complete
// listing, call the DescribeDatasetImportJob API.
type DatasetImportJobSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the dataset import job was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset import job.
	DatasetImportJobArn *string `locationName:"datasetImportJobArn" type:"string"`

	// If a dataset import job fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The name of the dataset import job.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// The date and time (in Unix time) that the dataset was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The status of the dataset import job.
	//
	// A dataset import job can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s DatasetImportJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetImportJobSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetImportJobSummary) SetCreationDateTime(v time.Time) *DatasetImportJobSummary {
	s.CreationDateTime = &v
	return s
}

// SetDatasetImportJobArn sets the DatasetImportJobArn field's value.
func (s *DatasetImportJobSummary) SetDatasetImportJobArn(v string) *DatasetImportJobSummary {
	s.DatasetImportJobArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DatasetImportJobSummary) SetFailureReason(v string) *DatasetImportJobSummary {
	s.FailureReason = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *DatasetImportJobSummary) SetJobName(v string) *DatasetImportJobSummary {
	s.JobName = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetImportJobSummary) SetLastUpdatedDateTime(v time.Time) *DatasetImportJobSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetImportJobSummary) SetStatus(v string) *DatasetImportJobSummary {
	s.Status = &v
	return s
}

// Describes the schema for a dataset. For more information on schemas, see
// CreateSchema.
type DatasetSchema struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the schema was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The date and time (in Unix time) that the schema was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the schema.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The schema.
	Schema *string `locationName:"schema" type:"string"`

	// The Amazon Resource Name (ARN) of the schema.
	SchemaArn *string `locationName:"schemaArn" type:"string"`
}

// String returns the string representation
func (s DatasetSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetSchema) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetSchema) SetCreationDateTime(v time.Time) *DatasetSchema {
	s.CreationDateTime = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetSchema) SetLastUpdatedDateTime(v time.Time) *DatasetSchema {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DatasetSchema) SetName(v string) *DatasetSchema {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *DatasetSchema) SetSchema(v string) *DatasetSchema {
	s.Schema = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *DatasetSchema) SetSchemaArn(v string) *DatasetSchema {
	s.SchemaArn = &v
	return s
}

// Provides a summary of the properties of a dataset schema. For a complete
// listing, call the DescribeSchema API.
type DatasetSchemaSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the schema was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The date and time (in Unix time) that the schema was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the schema.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the schema.
	SchemaArn *string `locationName:"schemaArn" type:"string"`
}

// String returns the string representation
func (s DatasetSchemaSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetSchemaSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetSchemaSummary) SetCreationDateTime(v time.Time) *DatasetSchemaSummary {
	s.CreationDateTime = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetSchemaSummary) SetLastUpdatedDateTime(v time.Time) *DatasetSchemaSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DatasetSchemaSummary) SetName(v string) *DatasetSchemaSummary {
	s.Name = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *DatasetSchemaSummary) SetSchemaArn(v string) *DatasetSchemaSummary {
	s.SchemaArn = &v
	return s
}

// Provides a summary of the properties of a dataset. For a complete listing,
// call the DescribeDataset API.
type DatasetSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the dataset was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset.
	DatasetArn *string `locationName:"datasetArn" type:"string"`

	// The dataset type. One of the following values:
	//
	//    * Interactions
	//
	//    * Items
	//
	//    * Users
	//
	//    * Event-Interactions
	DatasetType *string `locationName:"datasetType" type:"string"`

	// The date and time (in Unix time) that the dataset was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the dataset.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the dataset.
	//
	// A dataset can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s DatasetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetSummary) SetCreationDateTime(v time.Time) *DatasetSummary {
	s.CreationDateTime = &v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DatasetSummary) SetDatasetArn(v string) *DatasetSummary {
	s.DatasetArn = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *DatasetSummary) SetDatasetType(v string) *DatasetSummary {
	s.DatasetType = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetSummary) SetLastUpdatedDateTime(v time.Time) *DatasetSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DatasetSummary) SetName(v string) *DatasetSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetSummary) SetStatus(v string) *DatasetSummary {
	s.Status = &v
	return s
}

// Provides the name and default range of a categorical hyperparameter and whether
// the hyperparameter is tunable. A tunable hyperparameter can have its value
// determined during hyperparameter optimization (HPO).
type DefaultCategoricalHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// Whether the hyperparameter is tunable.
	IsTunable *bool `locationName:"isTunable" type:"boolean"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`

	// A list of the categories for the hyperparameter.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s DefaultCategoricalHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultCategoricalHyperParameterRange) GoString() string {
	return s.String()
}

// SetIsTunable sets the IsTunable field's value.
func (s *DefaultCategoricalHyperParameterRange) SetIsTunable(v bool) *DefaultCategoricalHyperParameterRange {
	s.IsTunable = &v
	return s
}

// SetName sets the Name field's value.
func (s *DefaultCategoricalHyperParameterRange) SetName(v string) *DefaultCategoricalHyperParameterRange {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DefaultCategoricalHyperParameterRange) SetValues(v []*string) *DefaultCategoricalHyperParameterRange {
	s.Values = v
	return s
}

// Provides the name and default range of a continuous hyperparameter and whether
// the hyperparameter is tunable. A tunable hyperparameter can have its value
// determined during hyperparameter optimization (HPO).
type DefaultContinuousHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// Whether the hyperparameter is tunable.
	IsTunable *bool `locationName:"isTunable" type:"boolean"`

	// The maximum allowable value for the hyperparameter.
	MaxValue *float64 `locationName:"maxValue" type:"double"`

	// The minimum allowable value for the hyperparameter.
	MinValue *float64 `locationName:"minValue" type:"double"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s DefaultContinuousHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultContinuousHyperParameterRange) GoString() string {
	return s.String()
}

// SetIsTunable sets the IsTunable field's value.
func (s *DefaultContinuousHyperParameterRange) SetIsTunable(v bool) *DefaultContinuousHyperParameterRange {
	s.IsTunable = &v
	return s
}

// SetMaxValue sets the MaxValue field's value.
func (s *DefaultContinuousHyperParameterRange) SetMaxValue(v float64) *DefaultContinuousHyperParameterRange {
	s.MaxValue = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *DefaultContinuousHyperParameterRange) SetMinValue(v float64) *DefaultContinuousHyperParameterRange {
	s.MinValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *DefaultContinuousHyperParameterRange) SetName(v string) *DefaultContinuousHyperParameterRange {
	s.Name = &v
	return s
}

// Specifies the hyperparameters and their default ranges. Hyperparameters can
// be categorical, continuous, or integer-valued.
type DefaultHyperParameterRanges struct {
	_ struct{} `type:"structure"`

	// The categorical hyperparameters and their default ranges.
	CategoricalHyperParameterRanges []*DefaultCategoricalHyperParameterRange `locationName:"categoricalHyperParameterRanges" type:"list"`

	// The continuous hyperparameters and their default ranges.
	ContinuousHyperParameterRanges []*DefaultContinuousHyperParameterRange `locationName:"continuousHyperParameterRanges" type:"list"`

	// The integer-valued hyperparameters and their default ranges.
	IntegerHyperParameterRanges []*DefaultIntegerHyperParameterRange `locationName:"integerHyperParameterRanges" type:"list"`
}

// String returns the string representation
func (s DefaultHyperParameterRanges) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultHyperParameterRanges) GoString() string {
	return s.String()
}

// SetCategoricalHyperParameterRanges sets the CategoricalHyperParameterRanges field's value.
func (s *DefaultHyperParameterRanges) SetCategoricalHyperParameterRanges(v []*DefaultCategoricalHyperParameterRange) *DefaultHyperParameterRanges {
	s.CategoricalHyperParameterRanges = v
	return s
}

// SetContinuousHyperParameterRanges sets the ContinuousHyperParameterRanges field's value.
func (s *DefaultHyperParameterRanges) SetContinuousHyperParameterRanges(v []*DefaultContinuousHyperParameterRange) *DefaultHyperParameterRanges {
	s.ContinuousHyperParameterRanges = v
	return s
}

// SetIntegerHyperParameterRanges sets the IntegerHyperParameterRanges field's value.
func (s *DefaultHyperParameterRanges) SetIntegerHyperParameterRanges(v []*DefaultIntegerHyperParameterRange) *DefaultHyperParameterRanges {
	s.IntegerHyperParameterRanges = v
	return s
}

// Provides the name and default range of a integer-valued hyperparameter and
// whether the hyperparameter is tunable. A tunable hyperparameter can have
// its value determined during hyperparameter optimization (HPO).
type DefaultIntegerHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// Indicates whether the hyperparameter is tunable.
	IsTunable *bool `locationName:"isTunable" type:"boolean"`

	// The maximum allowable value for the hyperparameter.
	MaxValue *int64 `locationName:"maxValue" type:"integer"`

	// The minimum allowable value for the hyperparameter.
	MinValue *int64 `locationName:"minValue" type:"integer"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s DefaultIntegerHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultIntegerHyperParameterRange) GoString() string {
	return s.String()
}

// SetIsTunable sets the IsTunable field's value.
func (s *DefaultIntegerHyperParameterRange) SetIsTunable(v bool) *DefaultIntegerHyperParameterRange {
	s.IsTunable = &v
	return s
}

// SetMaxValue sets the MaxValue field's value.
func (s *DefaultIntegerHyperParameterRange) SetMaxValue(v int64) *DefaultIntegerHyperParameterRange {
	s.MaxValue = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *DefaultIntegerHyperParameterRange) SetMinValue(v int64) *DefaultIntegerHyperParameterRange {
	s.MinValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *DefaultIntegerHyperParameterRange) SetName(v string) *DefaultIntegerHyperParameterRange {
	s.Name = &v
	return s
}

type DeleteCampaignInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign to delete.
	//
	// CampaignArn is a required field
	CampaignArn *string `locationName:"campaignArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCampaignInput"}
	if s.CampaignArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *DeleteCampaignInput) SetCampaignArn(v string) *DeleteCampaignInput {
	s.CampaignArn = &v
	return s
}

type DeleteCampaignOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCampaignOutput) GoString() string {
	return s.String()
}

type DeleteDatasetGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset group to delete.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDatasetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatasetGroupInput"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *DeleteDatasetGroupInput) SetDatasetGroupArn(v string) *DeleteDatasetGroupInput {
	s.DatasetGroupArn = &v
	return s
}

type DeleteDatasetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDatasetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetGroupOutput) GoString() string {
	return s.String()
}

type DeleteDatasetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset to delete.
	//
	// DatasetArn is a required field
	DatasetArn *string `locationName:"datasetArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatasetInput"}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DeleteDatasetInput) SetDatasetArn(v string) *DeleteDatasetInput {
	s.DatasetArn = &v
	return s
}

type DeleteDatasetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetOutput) GoString() string {
	return s.String()
}

type DeleteEventTrackerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the event tracker to delete.
	//
	// EventTrackerArn is a required field
	EventTrackerArn *string `locationName:"eventTrackerArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventTrackerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventTrackerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventTrackerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventTrackerInput"}
	if s.EventTrackerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTrackerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventTrackerArn sets the EventTrackerArn field's value.
func (s *DeleteEventTrackerInput) SetEventTrackerArn(v string) *DeleteEventTrackerInput {
	s.EventTrackerArn = &v
	return s
}

type DeleteEventTrackerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEventTrackerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventTrackerOutput) GoString() string {
	return s.String()
}

type DeleteSchemaInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the schema to delete.
	//
	// SchemaArn is a required field
	SchemaArn *string `locationName:"schemaArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSchemaInput"}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *DeleteSchemaInput) SetSchemaArn(v string) *DeleteSchemaInput {
	s.SchemaArn = &v
	return s
}

type DeleteSchemaOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSchemaOutput) GoString() string {
	return s.String()
}

type DeleteSolutionInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the solution to delete.
	//
	// SolutionArn is a required field
	SolutionArn *string `locationName:"solutionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSolutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSolutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSolutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSolutionInput"}
	if s.SolutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SolutionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *DeleteSolutionInput) SetSolutionArn(v string) *DeleteSolutionInput {
	s.SolutionArn = &v
	return s
}

type DeleteSolutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSolutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSolutionOutput) GoString() string {
	return s.String()
}

type DescribeAlgorithmInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm to describe.
	//
	// AlgorithmArn is a required field
	AlgorithmArn *string `locationName:"algorithmArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAlgorithmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlgorithmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlgorithmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlgorithmInput"}
	if s.AlgorithmArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AlgorithmArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmArn sets the AlgorithmArn field's value.
func (s *DescribeAlgorithmInput) SetAlgorithmArn(v string) *DescribeAlgorithmInput {
	s.AlgorithmArn = &v
	return s
}

type DescribeAlgorithmOutput struct {
	_ struct{} `type:"structure"`

	// A listing of the properties of the algorithm.
	Algorithm *Algorithm `locationName:"algorithm" type:"structure"`
}

// String returns the string representation
func (s DescribeAlgorithmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlgorithmOutput) GoString() string {
	return s.String()
}

// SetAlgorithm sets the Algorithm field's value.
func (s *DescribeAlgorithmOutput) SetAlgorithm(v *Algorithm) *DescribeAlgorithmOutput {
	s.Algorithm = v
	return s
}

type DescribeCampaignInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign.
	//
	// CampaignArn is a required field
	CampaignArn *string `locationName:"campaignArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCampaignInput"}
	if s.CampaignArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *DescribeCampaignInput) SetCampaignArn(v string) *DescribeCampaignInput {
	s.CampaignArn = &v
	return s
}

type DescribeCampaignOutput struct {
	_ struct{} `type:"structure"`

	// The properties of the campaign.
	Campaign *Campaign `locationName:"campaign" type:"structure"`
}

// String returns the string representation
func (s DescribeCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaign sets the Campaign field's value.
func (s *DescribeCampaignOutput) SetCampaign(v *Campaign) *DescribeCampaignOutput {
	s.Campaign = v
	return s
}

type DescribeDatasetGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group to describe.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDatasetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetGroupInput"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *DescribeDatasetGroupInput) SetDatasetGroupArn(v string) *DescribeDatasetGroupInput {
	s.DatasetGroupArn = &v
	return s
}

type DescribeDatasetGroupOutput struct {
	_ struct{} `type:"structure"`

	// A listing of the dataset group's properties.
	DatasetGroup *DatasetGroup `locationName:"datasetGroup" type:"structure"`
}

// String returns the string representation
func (s DescribeDatasetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetGroupOutput) GoString() string {
	return s.String()
}

// SetDatasetGroup sets the DatasetGroup field's value.
func (s *DescribeDatasetGroupOutput) SetDatasetGroup(v *DatasetGroup) *DescribeDatasetGroupOutput {
	s.DatasetGroup = v
	return s
}

type DescribeDatasetImportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset import job to describe.
	//
	// DatasetImportJobArn is a required field
	DatasetImportJobArn *string `locationName:"datasetImportJobArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDatasetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetImportJobInput"}
	if s.DatasetImportJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetImportJobArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetImportJobArn sets the DatasetImportJobArn field's value.
func (s *DescribeDatasetImportJobInput) SetDatasetImportJobArn(v string) *DescribeDatasetImportJobInput {
	s.DatasetImportJobArn = &v
	return s
}

type DescribeDatasetImportJobOutput struct {
	_ struct{} `type:"structure"`

	// Information about the dataset import job, including the status.
	//
	// The status is one of the following values:
	//
	//    * CREATE PENDING
	//
	//    * CREATE IN_PROGRESS
	//
	//    * ACTIVE
	//
	//    * CREATE FAILED
	DatasetImportJob *DatasetImportJob `locationName:"datasetImportJob" type:"structure"`
}

// String returns the string representation
func (s DescribeDatasetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetImportJobOutput) GoString() string {
	return s.String()
}

// SetDatasetImportJob sets the DatasetImportJob field's value.
func (s *DescribeDatasetImportJobOutput) SetDatasetImportJob(v *DatasetImportJob) *DescribeDatasetImportJobOutput {
	s.DatasetImportJob = v
	return s
}

type DescribeDatasetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset to describe.
	//
	// DatasetArn is a required field
	DatasetArn *string `locationName:"datasetArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetInput"}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DescribeDatasetInput) SetDatasetArn(v string) *DescribeDatasetInput {
	s.DatasetArn = &v
	return s
}

type DescribeDatasetOutput struct {
	_ struct{} `type:"structure"`

	// A listing of the dataset's properties.
	Dataset *Dataset `locationName:"dataset" type:"structure"`
}

// String returns the string representation
func (s DescribeDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetOutput) GoString() string {
	return s.String()
}

// SetDataset sets the Dataset field's value.
func (s *DescribeDatasetOutput) SetDataset(v *Dataset) *DescribeDatasetOutput {
	s.Dataset = v
	return s
}

type DescribeEventTrackerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the event tracker to describe.
	//
	// EventTrackerArn is a required field
	EventTrackerArn *string `locationName:"eventTrackerArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEventTrackerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventTrackerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventTrackerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventTrackerInput"}
	if s.EventTrackerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTrackerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventTrackerArn sets the EventTrackerArn field's value.
func (s *DescribeEventTrackerInput) SetEventTrackerArn(v string) *DescribeEventTrackerInput {
	s.EventTrackerArn = &v
	return s
}

type DescribeEventTrackerOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the event tracker.
	EventTracker *EventTracker `locationName:"eventTracker" type:"structure"`
}

// String returns the string representation
func (s DescribeEventTrackerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventTrackerOutput) GoString() string {
	return s.String()
}

// SetEventTracker sets the EventTracker field's value.
func (s *DescribeEventTrackerOutput) SetEventTracker(v *EventTracker) *DescribeEventTrackerOutput {
	s.EventTracker = v
	return s
}

type DescribeFeatureTransformationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the feature transformation to describe.
	//
	// FeatureTransformationArn is a required field
	FeatureTransformationArn *string `locationName:"featureTransformationArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFeatureTransformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFeatureTransformationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFeatureTransformationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFeatureTransformationInput"}
	if s.FeatureTransformationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureTransformationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeatureTransformationArn sets the FeatureTransformationArn field's value.
func (s *DescribeFeatureTransformationInput) SetFeatureTransformationArn(v string) *DescribeFeatureTransformationInput {
	s.FeatureTransformationArn = &v
	return s
}

type DescribeFeatureTransformationOutput struct {
	_ struct{} `type:"structure"`

	// A listing of the FeatureTransformation properties.
	FeatureTransformation *FeatureTransformation `locationName:"featureTransformation" type:"structure"`
}

// String returns the string representation
func (s DescribeFeatureTransformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFeatureTransformationOutput) GoString() string {
	return s.String()
}

// SetFeatureTransformation sets the FeatureTransformation field's value.
func (s *DescribeFeatureTransformationOutput) SetFeatureTransformation(v *FeatureTransformation) *DescribeFeatureTransformationOutput {
	s.FeatureTransformation = v
	return s
}

type DescribeRecipeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the recipe to describe.
	//
	// RecipeArn is a required field
	RecipeArn *string `locationName:"recipeArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRecipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRecipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRecipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRecipeInput"}
	if s.RecipeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecipeArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *DescribeRecipeInput) SetRecipeArn(v string) *DescribeRecipeInput {
	s.RecipeArn = &v
	return s
}

type DescribeRecipeOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the recipe.
	Recipe *Recipe `locationName:"recipe" type:"structure"`
}

// String returns the string representation
func (s DescribeRecipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRecipeOutput) GoString() string {
	return s.String()
}

// SetRecipe sets the Recipe field's value.
func (s *DescribeRecipeOutput) SetRecipe(v *Recipe) *DescribeRecipeOutput {
	s.Recipe = v
	return s
}

type DescribeSchemaInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the schema to retrieve.
	//
	// SchemaArn is a required field
	SchemaArn *string `locationName:"schemaArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSchemaInput"}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *DescribeSchemaInput) SetSchemaArn(v string) *DescribeSchemaInput {
	s.SchemaArn = &v
	return s
}

type DescribeSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The requested schema.
	Schema *DatasetSchema `locationName:"schema" type:"structure"`
}

// String returns the string representation
func (s DescribeSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSchemaOutput) GoString() string {
	return s.String()
}

// SetSchema sets the Schema field's value.
func (s *DescribeSchemaOutput) SetSchema(v *DatasetSchema) *DescribeSchemaOutput {
	s.Schema = v
	return s
}

type DescribeSolutionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the solution to describe.
	//
	// SolutionArn is a required field
	SolutionArn *string `locationName:"solutionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSolutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSolutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSolutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSolutionInput"}
	if s.SolutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SolutionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *DescribeSolutionInput) SetSolutionArn(v string) *DescribeSolutionInput {
	s.SolutionArn = &v
	return s
}

type DescribeSolutionOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the solution.
	Solution *Solution `locationName:"solution" type:"structure"`
}

// String returns the string representation
func (s DescribeSolutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSolutionOutput) GoString() string {
	return s.String()
}

// SetSolution sets the Solution field's value.
func (s *DescribeSolutionOutput) SetSolution(v *Solution) *DescribeSolutionOutput {
	s.Solution = v
	return s
}

type DescribeSolutionVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the solution version.
	//
	// SolutionVersionArn is a required field
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSolutionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSolutionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSolutionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSolutionVersionInput"}
	if s.SolutionVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SolutionVersionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *DescribeSolutionVersionInput) SetSolutionVersionArn(v string) *DescribeSolutionVersionInput {
	s.SolutionVersionArn = &v
	return s
}

type DescribeSolutionVersionOutput struct {
	_ struct{} `type:"structure"`

	// The solution version.
	SolutionVersion *SolutionVersion `locationName:"solutionVersion" type:"structure"`
}

// String returns the string representation
func (s DescribeSolutionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSolutionVersionOutput) GoString() string {
	return s.String()
}

// SetSolutionVersion sets the SolutionVersion field's value.
func (s *DescribeSolutionVersionOutput) SetSolutionVersion(v *SolutionVersion) *DescribeSolutionVersionOutput {
	s.SolutionVersion = v
	return s
}

// Provides information about an event tracker.
type EventTracker struct {
	_ struct{} `type:"structure"`

	// The Amazon AWS account that owns the event tracker.
	AccountId *string `locationName:"accountId" type:"string"`

	// The date and time (in Unix format) that the event tracker was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group that receives the event
	// data.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The ARN of the event tracker.
	EventTrackerArn *string `locationName:"eventTrackerArn" type:"string"`

	// The date and time (in Unix time) that the event tracker was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the event tracker.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the event tracker.
	//
	// An event tracker can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`

	// The ID of the event tracker. Include this ID in requests to the PutEvents
	// (https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html)
	// API.
	TrackingId *string `locationName:"trackingId" type:"string"`
}

// String returns the string representation
func (s EventTracker) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventTracker) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *EventTracker) SetAccountId(v string) *EventTracker {
	s.AccountId = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *EventTracker) SetCreationDateTime(v time.Time) *EventTracker {
	s.CreationDateTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *EventTracker) SetDatasetGroupArn(v string) *EventTracker {
	s.DatasetGroupArn = &v
	return s
}

// SetEventTrackerArn sets the EventTrackerArn field's value.
func (s *EventTracker) SetEventTrackerArn(v string) *EventTracker {
	s.EventTrackerArn = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *EventTracker) SetLastUpdatedDateTime(v time.Time) *EventTracker {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventTracker) SetName(v string) *EventTracker {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EventTracker) SetStatus(v string) *EventTracker {
	s.Status = &v
	return s
}

// SetTrackingId sets the TrackingId field's value.
func (s *EventTracker) SetTrackingId(v string) *EventTracker {
	s.TrackingId = &v
	return s
}

// Provides a summary of the properties of an event tracker. For a complete
// listing, call the DescribeEventTracker API.
type EventTrackerSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the event tracker was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the event tracker.
	EventTrackerArn *string `locationName:"eventTrackerArn" type:"string"`

	// The date and time (in Unix time) that the event tracker was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the event tracker.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the event tracker.
	//
	// An event tracker can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s EventTrackerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventTrackerSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *EventTrackerSummary) SetCreationDateTime(v time.Time) *EventTrackerSummary {
	s.CreationDateTime = &v
	return s
}

// SetEventTrackerArn sets the EventTrackerArn field's value.
func (s *EventTrackerSummary) SetEventTrackerArn(v string) *EventTrackerSummary {
	s.EventTrackerArn = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *EventTrackerSummary) SetLastUpdatedDateTime(v time.Time) *EventTrackerSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventTrackerSummary) SetName(v string) *EventTrackerSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EventTrackerSummary) SetStatus(v string) *EventTrackerSummary {
	s.Status = &v
	return s
}

// Provides feature transformation information. Feature transformation is the
// process of modifying raw input data into a form more suitable for model training.
type FeatureTransformation struct {
	_ struct{} `type:"structure"`

	// The creation date and time (in Unix time) of the feature transformation.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// Provides the default parameters for feature transformation.
	DefaultParameters map[string]*string `locationName:"defaultParameters" type:"map"`

	// The Amazon Resource Name (ARN) of the FeatureTransformation object.
	FeatureTransformationArn *string `locationName:"featureTransformationArn" type:"string"`

	// The last update date and time (in Unix time) of the feature transformation.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the feature transformation.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the feature transformation.
	//
	// A feature transformation can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s FeatureTransformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FeatureTransformation) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *FeatureTransformation) SetCreationDateTime(v time.Time) *FeatureTransformation {
	s.CreationDateTime = &v
	return s
}

// SetDefaultParameters sets the DefaultParameters field's value.
func (s *FeatureTransformation) SetDefaultParameters(v map[string]*string) *FeatureTransformation {
	s.DefaultParameters = v
	return s
}

// SetFeatureTransformationArn sets the FeatureTransformationArn field's value.
func (s *FeatureTransformation) SetFeatureTransformationArn(v string) *FeatureTransformation {
	s.FeatureTransformationArn = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *FeatureTransformation) SetLastUpdatedDateTime(v time.Time) *FeatureTransformation {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *FeatureTransformation) SetName(v string) *FeatureTransformation {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FeatureTransformation) SetStatus(v string) *FeatureTransformation {
	s.Status = &v
	return s
}

type GetSolutionMetricsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the solution version for which to get metrics.
	//
	// SolutionVersionArn is a required field
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSolutionMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSolutionMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSolutionMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSolutionMetricsInput"}
	if s.SolutionVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SolutionVersionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *GetSolutionMetricsInput) SetSolutionVersionArn(v string) *GetSolutionMetricsInput {
	s.SolutionVersionArn = &v
	return s
}

type GetSolutionMetricsOutput struct {
	_ struct{} `type:"structure"`

	// The metrics for the solution version.
	Metrics map[string]*float64 `locationName:"metrics" type:"map"`

	// The same solution version ARN as specified in the request.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`
}

// String returns the string representation
func (s GetSolutionMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSolutionMetricsOutput) GoString() string {
	return s.String()
}

// SetMetrics sets the Metrics field's value.
func (s *GetSolutionMetricsOutput) SetMetrics(v map[string]*float64) *GetSolutionMetricsOutput {
	s.Metrics = v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *GetSolutionMetricsOutput) SetSolutionVersionArn(v string) *GetSolutionMetricsOutput {
	s.SolutionVersionArn = &v
	return s
}

// Describes the properties for hyperparameter optimization (HPO). For use with
// the bring-your-own-recipe feature. Do not use for Amazon Personalize native
// recipes.
type HPOConfig struct {
	_ struct{} `type:"structure"`

	// The hyperparameters and their allowable ranges.
	AlgorithmHyperParameterRanges *HyperParameterRanges `locationName:"algorithmHyperParameterRanges" type:"structure"`

	// The metric to optimize during HPO.
	HpoObjective *HPOObjective `locationName:"hpoObjective" type:"structure"`

	// Describes the resource configuration for HPO.
	HpoResourceConfig *HPOResourceConfig `locationName:"hpoResourceConfig" type:"structure"`
}

// String returns the string representation
func (s HPOConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HPOConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HPOConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HPOConfig"}
	if s.AlgorithmHyperParameterRanges != nil {
		if err := s.AlgorithmHyperParameterRanges.Validate(); err != nil {
			invalidParams.AddNested("AlgorithmHyperParameterRanges", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmHyperParameterRanges sets the AlgorithmHyperParameterRanges field's value.
func (s *HPOConfig) SetAlgorithmHyperParameterRanges(v *HyperParameterRanges) *HPOConfig {
	s.AlgorithmHyperParameterRanges = v
	return s
}

// SetHpoObjective sets the HpoObjective field's value.
func (s *HPOConfig) SetHpoObjective(v *HPOObjective) *HPOConfig {
	s.HpoObjective = v
	return s
}

// SetHpoResourceConfig sets the HpoResourceConfig field's value.
func (s *HPOConfig) SetHpoResourceConfig(v *HPOResourceConfig) *HPOConfig {
	s.HpoResourceConfig = v
	return s
}

// The metric to optimize during hyperparameter optimization (HPO).
type HPOObjective struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	MetricName *string `locationName:"metricName" type:"string"`

	// A regular expression for finding the metric in the training job logs.
	MetricRegex *string `locationName:"metricRegex" type:"string"`

	// The data type of the metric.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s HPOObjective) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HPOObjective) GoString() string {
	return s.String()
}

// SetMetricName sets the MetricName field's value.
func (s *HPOObjective) SetMetricName(v string) *HPOObjective {
	s.MetricName = &v
	return s
}

// SetMetricRegex sets the MetricRegex field's value.
func (s *HPOObjective) SetMetricRegex(v string) *HPOObjective {
	s.MetricRegex = &v
	return s
}

// SetType sets the Type field's value.
func (s *HPOObjective) SetType(v string) *HPOObjective {
	s.Type = &v
	return s
}

// Describes the resource configuration for hyperparameter optimization (HPO).
type HPOResourceConfig struct {
	_ struct{} `type:"structure"`

	// The maximum number of training jobs.
	MaxNumberOfTrainingJobs *string `locationName:"maxNumberOfTrainingJobs" type:"string"`

	// The maximum number of parallel training jobs.
	MaxParallelTrainingJobs *string `locationName:"maxParallelTrainingJobs" type:"string"`
}

// String returns the string representation
func (s HPOResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HPOResourceConfig) GoString() string {
	return s.String()
}

// SetMaxNumberOfTrainingJobs sets the MaxNumberOfTrainingJobs field's value.
func (s *HPOResourceConfig) SetMaxNumberOfTrainingJobs(v string) *HPOResourceConfig {
	s.MaxNumberOfTrainingJobs = &v
	return s
}

// SetMaxParallelTrainingJobs sets the MaxParallelTrainingJobs field's value.
func (s *HPOResourceConfig) SetMaxParallelTrainingJobs(v string) *HPOResourceConfig {
	s.MaxParallelTrainingJobs = &v
	return s
}

// Specifies the hyperparameters and their ranges. Hyperparameters can be categorical,
// continuous, or integer-valued.
type HyperParameterRanges struct {
	_ struct{} `type:"structure"`

	// The categorical hyperparameters and their ranges.
	CategoricalHyperParameterRanges []*CategoricalHyperParameterRange `locationName:"categoricalHyperParameterRanges" type:"list"`

	// The continuous hyperparameters and their ranges.
	ContinuousHyperParameterRanges []*ContinuousHyperParameterRange `locationName:"continuousHyperParameterRanges" type:"list"`

	// The integer-valued hyperparameters and their ranges.
	IntegerHyperParameterRanges []*IntegerHyperParameterRange `locationName:"integerHyperParameterRanges" type:"list"`
}

// String returns the string representation
func (s HyperParameterRanges) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HyperParameterRanges) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterRanges) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HyperParameterRanges"}
	if s.ContinuousHyperParameterRanges != nil {
		for i, v := range s.ContinuousHyperParameterRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContinuousHyperParameterRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.IntegerHyperParameterRanges != nil {
		for i, v := range s.IntegerHyperParameterRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IntegerHyperParameterRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoricalHyperParameterRanges sets the CategoricalHyperParameterRanges field's value.
func (s *HyperParameterRanges) SetCategoricalHyperParameterRanges(v []*CategoricalHyperParameterRange) *HyperParameterRanges {
	s.CategoricalHyperParameterRanges = v
	return s
}

// SetContinuousHyperParameterRanges sets the ContinuousHyperParameterRanges field's value.
func (s *HyperParameterRanges) SetContinuousHyperParameterRanges(v []*ContinuousHyperParameterRange) *HyperParameterRanges {
	s.ContinuousHyperParameterRanges = v
	return s
}

// SetIntegerHyperParameterRanges sets the IntegerHyperParameterRanges field's value.
func (s *HyperParameterRanges) SetIntegerHyperParameterRanges(v []*IntegerHyperParameterRange) *HyperParameterRanges {
	s.IntegerHyperParameterRanges = v
	return s
}

// Provides the name and range of an integer-valued hyperparameter.
type IntegerHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// The maximum allowable value for the hyperparameter.
	MaxValue *int64 `locationName:"maxValue" type:"integer"`

	// The minimum allowable value for the hyperparameter.
	MinValue *int64 `locationName:"minValue" type:"integer"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s IntegerHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IntegerHyperParameterRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntegerHyperParameterRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IntegerHyperParameterRange"}
	if s.MinValue != nil && *s.MinValue < -1e+06 {
		invalidParams.Add(request.NewErrParamMinValue("MinValue", -1e+06))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxValue sets the MaxValue field's value.
func (s *IntegerHyperParameterRange) SetMaxValue(v int64) *IntegerHyperParameterRange {
	s.MaxValue = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *IntegerHyperParameterRange) SetMinValue(v int64) *IntegerHyperParameterRange {
	s.MinValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *IntegerHyperParameterRange) SetName(v string) *IntegerHyperParameterRange {
	s.Name = &v
	return s
}

type ListCampaignsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of campaigns to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListCampaigns for getting the
	// next set of campaigns (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the solution to list the campaigns for.
	// When a solution is not specified, all the campaigns associated with the account
	// are listed.
	SolutionArn *string `locationName:"solutionArn" type:"string"`
}

// String returns the string representation
func (s ListCampaignsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCampaignsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCampaignsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCampaignsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCampaignsInput) SetMaxResults(v int64) *ListCampaignsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCampaignsInput) SetNextToken(v string) *ListCampaignsInput {
	s.NextToken = &v
	return s
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *ListCampaignsInput) SetSolutionArn(v string) *ListCampaignsInput {
	s.SolutionArn = &v
	return s
}

type ListCampaignsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the campaigns.
	Campaigns []*CampaignSummary `locationName:"campaigns" type:"list"`

	// A token for getting the next set of campaigns (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListCampaignsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCampaignsOutput) GoString() string {
	return s.String()
}

// SetCampaigns sets the Campaigns field's value.
func (s *ListCampaignsOutput) SetCampaigns(v []*CampaignSummary) *ListCampaignsOutput {
	s.Campaigns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCampaignsOutput) SetNextToken(v string) *ListCampaignsOutput {
	s.NextToken = &v
	return s
}

type ListDatasetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of dataset groups to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListDatasetGroups for getting
	// the next set of dataset groups (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDatasetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetGroupsInput) SetMaxResults(v int64) *ListDatasetGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetGroupsInput) SetNextToken(v string) *ListDatasetGroupsInput {
	s.NextToken = &v
	return s
}

type ListDatasetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The list of your dataset groups.
	DatasetGroups []*DatasetGroupSummary `locationName:"datasetGroups" type:"list"`

	// A token for getting the next set of dataset groups (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDatasetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetGroupsOutput) GoString() string {
	return s.String()
}

// SetDatasetGroups sets the DatasetGroups field's value.
func (s *ListDatasetGroupsOutput) SetDatasetGroups(v []*DatasetGroupSummary) *ListDatasetGroupsOutput {
	s.DatasetGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetGroupsOutput) SetNextToken(v string) *ListDatasetGroupsOutput {
	s.NextToken = &v
	return s
}

type ListDatasetImportJobsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset to list the dataset import
	// jobs for.
	DatasetArn *string `locationName:"datasetArn" type:"string"`

	// The maximum number of dataset import jobs to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListDatasetImportJobs for getting
	// the next set of dataset import jobs (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDatasetImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetImportJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *ListDatasetImportJobsInput) SetDatasetArn(v string) *ListDatasetImportJobsInput {
	s.DatasetArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetImportJobsInput) SetMaxResults(v int64) *ListDatasetImportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetImportJobsInput) SetNextToken(v string) *ListDatasetImportJobsInput {
	s.NextToken = &v
	return s
}

type ListDatasetImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// The list of dataset import jobs.
	DatasetImportJobs []*DatasetImportJobSummary `locationName:"datasetImportJobs" type:"list"`

	// A token for getting the next set of dataset import jobs (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDatasetImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetImportJobsOutput) GoString() string {
	return s.String()
}

// SetDatasetImportJobs sets the DatasetImportJobs field's value.
func (s *ListDatasetImportJobsOutput) SetDatasetImportJobs(v []*DatasetImportJobSummary) *ListDatasetImportJobsOutput {
	s.DatasetImportJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetImportJobsOutput) SetNextToken(v string) *ListDatasetImportJobsOutput {
	s.NextToken = &v
	return s
}

type ListDatasetsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group that contains the datasets
	// to list.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The maximum number of datasets to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListDatasetImportJobs for getting
	// the next set of dataset import jobs (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDatasetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *ListDatasetsInput) SetDatasetGroupArn(v string) *ListDatasetsInput {
	s.DatasetGroupArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetsInput) SetMaxResults(v int64) *ListDatasetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsInput) SetNextToken(v string) *ListDatasetsInput {
	s.NextToken = &v
	return s
}

type ListDatasetsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Dataset objects. Each object provides metadata information.
	Datasets []*DatasetSummary `locationName:"datasets" type:"list"`

	// A token for getting the next set of datasets (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDatasetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetsOutput) GoString() string {
	return s.String()
}

// SetDatasets sets the Datasets field's value.
func (s *ListDatasetsOutput) SetDatasets(v []*DatasetSummary) *ListDatasetsOutput {
	s.Datasets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsOutput) SetNextToken(v string) *ListDatasetsOutput {
	s.NextToken = &v
	return s
}

type ListEventTrackersInput struct {
	_ struct{} `type:"structure"`

	// The ARN of a dataset group used to filter the response.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The maximum number of event trackers to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListEventTrackers for getting
	// the next set of event trackers (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListEventTrackersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventTrackersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventTrackersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventTrackersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *ListEventTrackersInput) SetDatasetGroupArn(v string) *ListEventTrackersInput {
	s.DatasetGroupArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEventTrackersInput) SetMaxResults(v int64) *ListEventTrackersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventTrackersInput) SetNextToken(v string) *ListEventTrackersInput {
	s.NextToken = &v
	return s
}

type ListEventTrackersOutput struct {
	_ struct{} `type:"structure"`

	// A list of event trackers.
	EventTrackers []*EventTrackerSummary `locationName:"eventTrackers" type:"list"`

	// A token for getting the next set of event trackers (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListEventTrackersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventTrackersOutput) GoString() string {
	return s.String()
}

// SetEventTrackers sets the EventTrackers field's value.
func (s *ListEventTrackersOutput) SetEventTrackers(v []*EventTrackerSummary) *ListEventTrackersOutput {
	s.EventTrackers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventTrackersOutput) SetNextToken(v string) *ListEventTrackersOutput {
	s.NextToken = &v
	return s
}

type ListRecipesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of recipes to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListRecipes for getting the next
	// set of recipes (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// The default is SERVICE.
	RecipeProvider *string `locationName:"recipeProvider" type:"string" enum:"RecipeProvider"`
}

// String returns the string representation
func (s ListRecipesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecipesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecipesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecipesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecipesInput) SetMaxResults(v int64) *ListRecipesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecipesInput) SetNextToken(v string) *ListRecipesInput {
	s.NextToken = &v
	return s
}

// SetRecipeProvider sets the RecipeProvider field's value.
func (s *ListRecipesInput) SetRecipeProvider(v string) *ListRecipesInput {
	s.RecipeProvider = &v
	return s
}

type ListRecipesOutput struct {
	_ struct{} `type:"structure"`

	// A token for getting the next set of recipes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of available recipes.
	Recipes []*RecipeSummary `locationName:"recipes" type:"list"`
}

// String returns the string representation
func (s ListRecipesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecipesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecipesOutput) SetNextToken(v string) *ListRecipesOutput {
	s.NextToken = &v
	return s
}

// SetRecipes sets the Recipes field's value.
func (s *ListRecipesOutput) SetRecipes(v []*RecipeSummary) *ListRecipesOutput {
	s.Recipes = v
	return s
}

type ListSchemasInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of schemas to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListSchemas for getting the next
	// set of schemas (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListSchemasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSchemasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSchemasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSchemasInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSchemasInput) SetMaxResults(v int64) *ListSchemasInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemasInput) SetNextToken(v string) *ListSchemasInput {
	s.NextToken = &v
	return s
}

type ListSchemasOutput struct {
	_ struct{} `type:"structure"`

	// A token used to get the next set of schemas (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of schemas.
	Schemas []*DatasetSchemaSummary `locationName:"schemas" type:"list"`
}

// String returns the string representation
func (s ListSchemasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSchemasOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemasOutput) SetNextToken(v string) *ListSchemasOutput {
	s.NextToken = &v
	return s
}

// SetSchemas sets the Schemas field's value.
func (s *ListSchemasOutput) SetSchemas(v []*DatasetSchemaSummary) *ListSchemasOutput {
	s.Schemas = v
	return s
}

type ListSolutionVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of solution versions to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListSolutionVersions for getting
	// the next set of solution versions (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the solution.
	SolutionArn *string `locationName:"solutionArn" type:"string"`
}

// String returns the string representation
func (s ListSolutionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSolutionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSolutionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSolutionVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSolutionVersionsInput) SetMaxResults(v int64) *ListSolutionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolutionVersionsInput) SetNextToken(v string) *ListSolutionVersionsInput {
	s.NextToken = &v
	return s
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *ListSolutionVersionsInput) SetSolutionArn(v string) *ListSolutionVersionsInput {
	s.SolutionArn = &v
	return s
}

type ListSolutionVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A token for getting the next set of solution versions (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of solution versions describing the version properties.
	SolutionVersions []*SolutionVersionSummary `locationName:"solutionVersions" type:"list"`
}

// String returns the string representation
func (s ListSolutionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSolutionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolutionVersionsOutput) SetNextToken(v string) *ListSolutionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetSolutionVersions sets the SolutionVersions field's value.
func (s *ListSolutionVersionsOutput) SetSolutionVersions(v []*SolutionVersionSummary) *ListSolutionVersionsOutput {
	s.SolutionVersions = v
	return s
}

type ListSolutionsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The maximum number of solutions to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListSolutions for getting the
	// next set of solutions (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListSolutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSolutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSolutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSolutionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *ListSolutionsInput) SetDatasetGroupArn(v string) *ListSolutionsInput {
	s.DatasetGroupArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSolutionsInput) SetMaxResults(v int64) *ListSolutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolutionsInput) SetNextToken(v string) *ListSolutionsInput {
	s.NextToken = &v
	return s
}

type ListSolutionsOutput struct {
	_ struct{} `type:"structure"`

	// A token for getting the next set of solutions (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of the current solutions.
	Solutions []*SolutionSummary `locationName:"solutions" type:"list"`
}

// String returns the string representation
func (s ListSolutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSolutionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolutionsOutput) SetNextToken(v string) *ListSolutionsOutput {
	s.NextToken = &v
	return s
}

// SetSolutions sets the Solutions field's value.
func (s *ListSolutionsOutput) SetSolutions(v []*SolutionSummary) *ListSolutionsOutput {
	s.Solutions = v
	return s
}

// Provides information about a recipe. Each recipe provides an algorithm that
// Amazon Personalize uses in model training when you use the CreateSolution
// operation.
type Recipe struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm that Amazon Personalize uses
	// to train the model.
	AlgorithmArn *string `locationName:"algorithmArn" type:"string"`

	// The date and time (in Unix format) that the recipe was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the recipe.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the FeatureTransformation object.
	FeatureTransformationArn *string `locationName:"featureTransformationArn" type:"string"`

	// The date and time (in Unix format) that the recipe was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the recipe.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the recipe.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// One of the following values:
	//
	//    * PERSONALIZED_RANKING
	//
	//    * RELATED_ITEMS
	//
	//    * USER_PERSONALIZATION
	RecipeType *string `locationName:"recipeType" type:"string"`

	// The status of the recipe.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s Recipe) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Recipe) GoString() string {
	return s.String()
}

// SetAlgorithmArn sets the AlgorithmArn field's value.
func (s *Recipe) SetAlgorithmArn(v string) *Recipe {
	s.AlgorithmArn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *Recipe) SetCreationDateTime(v time.Time) *Recipe {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Recipe) SetDescription(v string) *Recipe {
	s.Description = &v
	return s
}

// SetFeatureTransformationArn sets the FeatureTransformationArn field's value.
func (s *Recipe) SetFeatureTransformationArn(v string) *Recipe {
	s.FeatureTransformationArn = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *Recipe) SetLastUpdatedDateTime(v time.Time) *Recipe {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Recipe) SetName(v string) *Recipe {
	s.Name = &v
	return s
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *Recipe) SetRecipeArn(v string) *Recipe {
	s.RecipeArn = &v
	return s
}

// SetRecipeType sets the RecipeType field's value.
func (s *Recipe) SetRecipeType(v string) *Recipe {
	s.RecipeType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Recipe) SetStatus(v string) *Recipe {
	s.Status = &v
	return s
}

// Provides a summary of the properties of a recipe. For a complete listing,
// call the DescribeRecipe API.
type RecipeSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the recipe was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The date and time (in Unix time) that the recipe was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the recipe.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the recipe.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// The status of the recipe.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s RecipeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecipeSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *RecipeSummary) SetCreationDateTime(v time.Time) *RecipeSummary {
	s.CreationDateTime = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *RecipeSummary) SetLastUpdatedDateTime(v time.Time) *RecipeSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *RecipeSummary) SetName(v string) *RecipeSummary {
	s.Name = &v
	return s
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *RecipeSummary) SetRecipeArn(v string) *RecipeSummary {
	s.RecipeArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RecipeSummary) SetStatus(v string) *RecipeSummary {
	s.Status = &v
	return s
}

// An object that provides information about a solution. A solution is a trained
// model that can be deployed as a campaign.
type Solution struct {
	_ struct{} `type:"structure"`

	// When performAutoML is true, specifies the best recipe found.
	AutoMLResult *AutoMLResult `locationName:"autoMLResult" type:"structure"`

	// The creation date and time (in Unix time) of the solution.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group that provides the training
	// data.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The event type (for example, 'click' or 'like') that is used for training
	// the model.
	EventType *string `locationName:"eventType" type:"string"`

	// The date and time (in Unix time) that the solution was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// Describes the latest version of the solution, including the status and the
	// ARN.
	LatestSolutionVersion *SolutionVersionSummary `locationName:"latestSolutionVersion" type:"structure"`

	// The name of the solution.
	Name *string `locationName:"name" min:"1" type:"string"`

	// When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION
	// recipe from the list specified in the solution configuration (recipeArn must
	// not be specified). When false (the default), Amazon Personalize uses recipeArn
	// for training.
	PerformAutoML *bool `locationName:"performAutoML" type:"boolean"`

	// Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
	// The default is false.
	PerformHPO *bool `locationName:"performHPO" type:"boolean"`

	// The ARN of the recipe used to create the solution.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// The ARN of the solution.
	SolutionArn *string `locationName:"solutionArn" type:"string"`

	// Describes the configuration properties for the solution.
	SolutionConfig *SolutionConfig `locationName:"solutionConfig" type:"structure"`

	// The status of the solution.
	//
	// A solution can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s Solution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Solution) GoString() string {
	return s.String()
}

// SetAutoMLResult sets the AutoMLResult field's value.
func (s *Solution) SetAutoMLResult(v *AutoMLResult) *Solution {
	s.AutoMLResult = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *Solution) SetCreationDateTime(v time.Time) *Solution {
	s.CreationDateTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *Solution) SetDatasetGroupArn(v string) *Solution {
	s.DatasetGroupArn = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *Solution) SetEventType(v string) *Solution {
	s.EventType = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *Solution) SetLastUpdatedDateTime(v time.Time) *Solution {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLatestSolutionVersion sets the LatestSolutionVersion field's value.
func (s *Solution) SetLatestSolutionVersion(v *SolutionVersionSummary) *Solution {
	s.LatestSolutionVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *Solution) SetName(v string) *Solution {
	s.Name = &v
	return s
}

// SetPerformAutoML sets the PerformAutoML field's value.
func (s *Solution) SetPerformAutoML(v bool) *Solution {
	s.PerformAutoML = &v
	return s
}

// SetPerformHPO sets the PerformHPO field's value.
func (s *Solution) SetPerformHPO(v bool) *Solution {
	s.PerformHPO = &v
	return s
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *Solution) SetRecipeArn(v string) *Solution {
	s.RecipeArn = &v
	return s
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *Solution) SetSolutionArn(v string) *Solution {
	s.SolutionArn = &v
	return s
}

// SetSolutionConfig sets the SolutionConfig field's value.
func (s *Solution) SetSolutionConfig(v *SolutionConfig) *Solution {
	s.SolutionConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Solution) SetStatus(v string) *Solution {
	s.Status = &v
	return s
}

// Describes the configuration properties for the solution.
type SolutionConfig struct {
	_ struct{} `type:"structure"`

	// Lists the hyperparameter names and ranges.
	AlgorithmHyperParameters map[string]*string `locationName:"algorithmHyperParameters" type:"map"`

	// The AutoMLConfig object containing a list of recipes to search when AutoML
	// is performed.
	AutoMLConfig *AutoMLConfig `locationName:"autoMLConfig" type:"structure"`

	// Only events with a value greater than or equal to this threshold are used
	// for training a model.
	EventValueThreshold *string `locationName:"eventValueThreshold" type:"string"`

	// Lists the feature transformation parameters.
	FeatureTransformationParameters map[string]*string `locationName:"featureTransformationParameters" type:"map"`

	// Describes the properties for hyperparameter optimization (HPO). For use with
	// the bring-your-own-recipe feature. Not used with Amazon Personalize predefined
	// recipes.
	HpoConfig *HPOConfig `locationName:"hpoConfig" type:"structure"`
}

// String returns the string representation
func (s SolutionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SolutionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SolutionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SolutionConfig"}
	if s.HpoConfig != nil {
		if err := s.HpoConfig.Validate(); err != nil {
			invalidParams.AddNested("HpoConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmHyperParameters sets the AlgorithmHyperParameters field's value.
func (s *SolutionConfig) SetAlgorithmHyperParameters(v map[string]*string) *SolutionConfig {
	s.AlgorithmHyperParameters = v
	return s
}

// SetAutoMLConfig sets the AutoMLConfig field's value.
func (s *SolutionConfig) SetAutoMLConfig(v *AutoMLConfig) *SolutionConfig {
	s.AutoMLConfig = v
	return s
}

// SetEventValueThreshold sets the EventValueThreshold field's value.
func (s *SolutionConfig) SetEventValueThreshold(v string) *SolutionConfig {
	s.EventValueThreshold = &v
	return s
}

// SetFeatureTransformationParameters sets the FeatureTransformationParameters field's value.
func (s *SolutionConfig) SetFeatureTransformationParameters(v map[string]*string) *SolutionConfig {
	s.FeatureTransformationParameters = v
	return s
}

// SetHpoConfig sets the HpoConfig field's value.
func (s *SolutionConfig) SetHpoConfig(v *HPOConfig) *SolutionConfig {
	s.HpoConfig = v
	return s
}

// Provides a summary of the properties of a solution. For a complete listing,
// call the DescribeSolution API.
type SolutionSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the solution was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The date and time (in Unix time) that the solution was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the solution.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the solution.
	SolutionArn *string `locationName:"solutionArn" type:"string"`

	// The status of the solution.
	//
	// A solution can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s SolutionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SolutionSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *SolutionSummary) SetCreationDateTime(v time.Time) *SolutionSummary {
	s.CreationDateTime = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *SolutionSummary) SetLastUpdatedDateTime(v time.Time) *SolutionSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *SolutionSummary) SetName(v string) *SolutionSummary {
	s.Name = &v
	return s
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *SolutionSummary) SetSolutionArn(v string) *SolutionSummary {
	s.SolutionArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SolutionSummary) SetStatus(v string) *SolutionSummary {
	s.Status = &v
	return s
}

// An object that provides information about a specific version of a Solution.
type SolutionVersion struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that this version of the solution was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group providing the training
	// data.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The event type (for example, 'click' or 'like') that is used for training
	// the model.
	EventType *string `locationName:"eventType" type:"string"`

	// If training a solution version fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the solution was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// When true, Amazon Personalize performs a search for the most optimal recipe
	// according to the solution configuration. When false (the default), Amazon
	// Personalize uses recipeArn.
	PerformAutoML *bool `locationName:"performAutoML" type:"boolean"`

	// Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
	// The default is false.
	PerformHPO *bool `locationName:"performHPO" type:"boolean"`

	// The ARN of the recipe used in the solution.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// The ARN of the solution.
	SolutionArn *string `locationName:"solutionArn" type:"string"`

	// Describes the configuration properties for the solution.
	SolutionConfig *SolutionConfig `locationName:"solutionConfig" type:"structure"`

	// The ARN of the solution version.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the solution version.
	//
	// A solution version can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s SolutionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SolutionVersion) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *SolutionVersion) SetCreationDateTime(v time.Time) *SolutionVersion {
	s.CreationDateTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *SolutionVersion) SetDatasetGroupArn(v string) *SolutionVersion {
	s.DatasetGroupArn = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *SolutionVersion) SetEventType(v string) *SolutionVersion {
	s.EventType = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *SolutionVersion) SetFailureReason(v string) *SolutionVersion {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *SolutionVersion) SetLastUpdatedDateTime(v time.Time) *SolutionVersion {
	s.LastUpdatedDateTime = &v
	return s
}

// SetPerformAutoML sets the PerformAutoML field's value.
func (s *SolutionVersion) SetPerformAutoML(v bool) *SolutionVersion {
	s.PerformAutoML = &v
	return s
}

// SetPerformHPO sets the PerformHPO field's value.
func (s *SolutionVersion) SetPerformHPO(v bool) *SolutionVersion {
	s.PerformHPO = &v
	return s
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *SolutionVersion) SetRecipeArn(v string) *SolutionVersion {
	s.RecipeArn = &v
	return s
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *SolutionVersion) SetSolutionArn(v string) *SolutionVersion {
	s.SolutionArn = &v
	return s
}

// SetSolutionConfig sets the SolutionConfig field's value.
func (s *SolutionVersion) SetSolutionConfig(v *SolutionConfig) *SolutionVersion {
	s.SolutionConfig = v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *SolutionVersion) SetSolutionVersionArn(v string) *SolutionVersion {
	s.SolutionVersionArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SolutionVersion) SetStatus(v string) *SolutionVersion {
	s.Status = &v
	return s
}

// Provides a summary of the properties of a solution version. For a complete
// listing, call the DescribeSolutionVersion API.
type SolutionVersionSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that this version of a solution was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If a solution version fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the solution version was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the solution version.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the solution version.
	//
	// A solution version can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s SolutionVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SolutionVersionSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *SolutionVersionSummary) SetCreationDateTime(v time.Time) *SolutionVersionSummary {
	s.CreationDateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *SolutionVersionSummary) SetFailureReason(v string) *SolutionVersionSummary {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *SolutionVersionSummary) SetLastUpdatedDateTime(v time.Time) *SolutionVersionSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *SolutionVersionSummary) SetSolutionVersionArn(v string) *SolutionVersionSummary {
	s.SolutionVersionArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SolutionVersionSummary) SetStatus(v string) *SolutionVersionSummary {
	s.Status = &v
	return s
}

type UpdateCampaignInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign.
	//
	// CampaignArn is a required field
	CampaignArn *string `locationName:"campaignArn" type:"string" required:"true"`

	// Specifies the requested minimum provisioned transactions (recommendations)
	// per second that Amazon Personalize will support.
	MinProvisionedTPS *int64 `locationName:"minProvisionedTPS" min:"1" type:"integer"`

	// The ARN of a new solution version to deploy.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`
}

// String returns the string representation
func (s UpdateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCampaignInput"}
	if s.CampaignArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignArn"))
	}
	if s.MinProvisionedTPS != nil && *s.MinProvisionedTPS < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinProvisionedTPS", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *UpdateCampaignInput) SetCampaignArn(v string) *UpdateCampaignInput {
	s.CampaignArn = &v
	return s
}

// SetMinProvisionedTPS sets the MinProvisionedTPS field's value.
func (s *UpdateCampaignInput) SetMinProvisionedTPS(v int64) *UpdateCampaignInput {
	s.MinProvisionedTPS = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *UpdateCampaignInput) SetSolutionVersionArn(v string) *UpdateCampaignInput {
	s.SolutionVersionArn = &v
	return s
}

type UpdateCampaignOutput struct {
	_ struct{} `type:"structure"`

	// The same campaign ARN as given in the request.
	CampaignArn *string `locationName:"campaignArn" type:"string"`
}

// String returns the string representation
func (s UpdateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *UpdateCampaignOutput) SetCampaignArn(v string) *UpdateCampaignOutput {
	s.CampaignArn = &v
	return s
}

const (
	// RecipeProviderService is a RecipeProvider enum value
	RecipeProviderService = "SERVICE"
)
