'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _regenerator = require('babel-runtime/regenerator');

var _regenerator2 = _interopRequireDefault(_regenerator);

var _asyncToGenerator2 = require('babel-runtime/helpers/asyncToGenerator');

var _asyncToGenerator3 = _interopRequireDefault(_asyncToGenerator2);

/**
 * Runs the specified batch of functions on the server, then resolves
 * the related promises.
 */
var processBatch = function () {
  var _ref3 = (0, _asyncToGenerator3.default)( /*#__PURE__*/_regenerator2.default.mark(function _callee(kfetch, batch) {
    var _ref4, results;

    return _regenerator2.default.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.prev = 0;
            _context.next = 3;
            return kfetch({
              pathname: _consts.FUNCTIONS_URL,
              method: 'POST',
              body: JSON.stringify({
                functions: Object.values(batch).map(function (_ref5) {
                  var request = _ref5.request;
                  return request;
                })
              })
            });

          case 3:
            _ref4 = _context.sent;
            results = _ref4.results;


            results.forEach(function (_ref6) {
              var id = _ref6.id,
                  result = _ref6.result;
              var future = batch[id].future;

              if (result.statusCode && result.err) {
                future.reject(result);
              } else {
                future.resolve(result);
              }
            });
            _context.next = 11;
            break;

          case 8:
            _context.prev = 8;
            _context.t0 = _context['catch'](0);

            Object.values(batch).forEach(function (_ref7) {
              var future = _ref7.future;

              future.reject(_context.t0);
            });

          case 11:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this, [[0, 8]]);
  }));

  return function processBatch(_x, _x2) {
    return _ref3.apply(this, arguments);
  };
}();

exports.batchedFetch = batchedFetch;

var _consts = require('./consts');

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Create a function which executes an Expression function on the
 * server as part of a larger batch of executions.
 */
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function batchedFetch(_ref) {
  var kfetch = _ref.kfetch,
      serialize = _ref.serialize,
      _ref$ms = _ref.ms,
      ms = _ref$ms === undefined ? 10 : _ref$ms;

  // Uniquely identifies each function call in a batch operation
  // so that the appropriate promise can be resolved / rejected later.
  var id = 0;

  // A map like { id: { future, request } }, which is used to
  // track all of the function calls in a batch operation.
  var batch = {};
  var timeout = void 0;

  var nextId = function nextId() {
    return ++id;
  };

  var reset = function reset() {
    id = 0;
    batch = {};
    timeout = undefined;
  };

  var runBatch = function runBatch() {
    processBatch(kfetch, batch);
    reset();
  };

  return function (_ref2) {
    var functionName = _ref2.functionName,
        context = _ref2.context,
        args = _ref2.args;

    if (!timeout) {
      timeout = setTimeout(runBatch, ms);
    }

    var request = {
      functionName: functionName,
      args: args,
      context: serialize(context)
    };

    // Check to see if this is a duplicate server function.
    var duplicate = Object.values(batch).find(function (batchedRequest) {
      return _lodash2.default.isMatch(batchedRequest.request, request);
    });

    // If it is, just return the promise of the duplicated request.
    if (duplicate) {
      return duplicate.future.promise;
    }

    // If not, create a new promise, id, and add it to the batched collection.
    var future = createFuture();
    var id = nextId();
    request.id = id;

    batch[id] = {
      future: future,
      request: request
    };

    return future.promise;
  };
}

/**
 * An externally resolvable / rejectable promise, used to make sure
 * individual batch responses go to the correct caller.
 */
function createFuture() {
  var _resolve = void 0;
  var _reject = void 0;

  return {
    resolve: function resolve(val) {
      return _resolve(val);
    },
    reject: function reject(val) {
      return _reject(val);
    },

    promise: new Promise(function (res, rej) {
      _resolve = res;
      _reject = rej;
    })
  };
}