// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/api/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// EtcdsGetter has a method to return a EtcdInterface.
// A group's client should implement this interface.
type EtcdsGetter interface {
	Etcds() EtcdInterface
}

// EtcdInterface has methods to work with Etcd resources.
type EtcdInterface interface {
	Create(*v1.Etcd) (*v1.Etcd, error)
	Update(*v1.Etcd) (*v1.Etcd, error)
	UpdateStatus(*v1.Etcd) (*v1.Etcd, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.Etcd, error)
	List(opts metav1.ListOptions) (*v1.EtcdList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.Etcd, err error)
	EtcdExpansion
}

// etcds implements EtcdInterface
type etcds struct {
	client rest.Interface
}

// newEtcds returns a Etcds
func newEtcds(c *OperatorV1Client) *etcds {
	return &etcds{
		client: c.RESTClient(),
	}
}

// Get takes name of the etcd, and returns the corresponding etcd object, and an error if there is any.
func (c *etcds) Get(name string, options metav1.GetOptions) (result *v1.Etcd, err error) {
	result = &v1.Etcd{}
	err = c.client.Get().
		Resource("etcds").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Etcds that match those selectors.
func (c *etcds) List(opts metav1.ListOptions) (result *v1.EtcdList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.EtcdList{}
	err = c.client.Get().
		Resource("etcds").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested etcds.
func (c *etcds) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("etcds").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a etcd and creates it.  Returns the server's representation of the etcd, and an error, if there is any.
func (c *etcds) Create(etcd *v1.Etcd) (result *v1.Etcd, err error) {
	result = &v1.Etcd{}
	err = c.client.Post().
		Resource("etcds").
		Body(etcd).
		Do().
		Into(result)
	return
}

// Update takes the representation of a etcd and updates it. Returns the server's representation of the etcd, and an error, if there is any.
func (c *etcds) Update(etcd *v1.Etcd) (result *v1.Etcd, err error) {
	result = &v1.Etcd{}
	err = c.client.Put().
		Resource("etcds").
		Name(etcd.Name).
		Body(etcd).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *etcds) UpdateStatus(etcd *v1.Etcd) (result *v1.Etcd, err error) {
	result = &v1.Etcd{}
	err = c.client.Put().
		Resource("etcds").
		Name(etcd.Name).
		SubResource("status").
		Body(etcd).
		Do().
		Into(result)
	return
}

// Delete takes name of the etcd and deletes it. Returns an error if one occurs.
func (c *etcds) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("etcds").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *etcds) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("etcds").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched etcd.
func (c *etcds) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.Etcd, err error) {
	result = &v1.Etcd{}
	err = c.client.Patch(pt).
		Resource("etcds").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
