// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/datacatalog/v1beta1/datacatalog.proto

package datacatalog

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Entry resources in Cloud Data Catalog can be of different types e.g. BigQuery
// Table entry is of type 'TABLE'. This enum describes all the possible types
// Cloud Data Catalog contains.
type EntryType int32

const (
	// Default unknown type
	EntryType_ENTRY_TYPE_UNSPECIFIED EntryType = 0
	// The type of entry that has a GoogleSQL schema, including logical views.
	EntryType_TABLE EntryType = 2
	// An entry type which is used for streaming entries. Example - Pub/Sub.
	EntryType_DATA_STREAM EntryType = 3
)

var EntryType_name = map[int32]string{
	0: "ENTRY_TYPE_UNSPECIFIED",
	2: "TABLE",
	3: "DATA_STREAM",
}

var EntryType_value = map[string]int32{
	"ENTRY_TYPE_UNSPECIFIED": 0,
	"TABLE":                  2,
	"DATA_STREAM":            3,
}

func (x EntryType) String() string {
	return proto.EnumName(EntryType_name, int32(x))
}

func (EntryType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{0}
}

// Request message for
// [LookupEntry][google.cloud.datacatalog.v1beta1.DataCatalog.LookupEntry].
type LookupEntryRequest struct {
	// Represents either the Google Cloud Platform resource or SQL name for a
	// Google Cloud Platform resource.
	//
	// Types that are valid to be assigned to TargetName:
	//	*LookupEntryRequest_LinkedResource
	//	*LookupEntryRequest_SqlResource
	TargetName           isLookupEntryRequest_TargetName `protobuf_oneof:"target_name"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *LookupEntryRequest) Reset()         { *m = LookupEntryRequest{} }
func (m *LookupEntryRequest) String() string { return proto.CompactTextString(m) }
func (*LookupEntryRequest) ProtoMessage()    {}
func (*LookupEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{0}
}

func (m *LookupEntryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LookupEntryRequest.Unmarshal(m, b)
}
func (m *LookupEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LookupEntryRequest.Marshal(b, m, deterministic)
}
func (m *LookupEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LookupEntryRequest.Merge(m, src)
}
func (m *LookupEntryRequest) XXX_Size() int {
	return xxx_messageInfo_LookupEntryRequest.Size(m)
}
func (m *LookupEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LookupEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LookupEntryRequest proto.InternalMessageInfo

type isLookupEntryRequest_TargetName interface {
	isLookupEntryRequest_TargetName()
}

type LookupEntryRequest_LinkedResource struct {
	LinkedResource string `protobuf:"bytes,1,opt,name=linked_resource,json=linkedResource,proto3,oneof"`
}

type LookupEntryRequest_SqlResource struct {
	SqlResource string `protobuf:"bytes,3,opt,name=sql_resource,json=sqlResource,proto3,oneof"`
}

func (*LookupEntryRequest_LinkedResource) isLookupEntryRequest_TargetName() {}

func (*LookupEntryRequest_SqlResource) isLookupEntryRequest_TargetName() {}

func (m *LookupEntryRequest) GetTargetName() isLookupEntryRequest_TargetName {
	if m != nil {
		return m.TargetName
	}
	return nil
}

func (m *LookupEntryRequest) GetLinkedResource() string {
	if x, ok := m.GetTargetName().(*LookupEntryRequest_LinkedResource); ok {
		return x.LinkedResource
	}
	return ""
}

func (m *LookupEntryRequest) GetSqlResource() string {
	if x, ok := m.GetTargetName().(*LookupEntryRequest_SqlResource); ok {
		return x.SqlResource
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LookupEntryRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LookupEntryRequest_LinkedResource)(nil),
		(*LookupEntryRequest_SqlResource)(nil),
	}
}

// Entry Metadata.
// A Data Catalog Entry resource represents another resource in Google
// Cloud Platform, such as a BigQuery Dataset or a Pub/Sub Topic. Clients can
// use the `linked_resource` field in the Entry resource to refer to the
// original resource id of the source system.
//
// An Entry resource contains resource details, such as its schema.
type Entry struct {
	// Output only. The Data Catalog resource name of the entry in URL format. For
	// example,
	// "projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The full name of the cloud resource the entry belongs to. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	//
	// Data Catalog supports resources from select Google Cloud Platform systems.
	// `linked_resource` is the full name of the Google Cloud Platform resource.
	// For example, the `linked_resource` for a table resource from BigQuery is:
	//
	// "//bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId".
	LinkedResource string `protobuf:"bytes,9,opt,name=linked_resource,json=linkedResource,proto3" json:"linked_resource,omitempty"`
	// Type of entry.
	Type EntryType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.datacatalog.v1beta1.EntryType" json:"type,omitempty"`
	// Type specification information.
	//
	// Types that are valid to be assigned to TypeSpec:
	//	*Entry_BigqueryTableSpec
	TypeSpec isEntry_TypeSpec `protobuf_oneof:"type_spec"`
	// Display information such as title and description.
	// A short name to identify the entry, for example,
	// "Analytics Data - Jan 2011".
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Entry description, which can consist of several sentences or paragraphs
	// that describe entry contents.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Schema of the entry.
	Schema *Schema `protobuf:"bytes,5,opt,name=schema,proto3" json:"schema,omitempty"`
	// Timestamps about the underlying Google Cloud Platform resource -- not about
	// this Data Catalog Entry.
	SourceSystemTimestamps *SystemTimestamps `protobuf:"bytes,7,opt,name=source_system_timestamps,json=sourceSystemTimestamps,proto3" json:"source_system_timestamps,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}          `json:"-"`
	XXX_unrecognized       []byte            `json:"-"`
	XXX_sizecache          int32             `json:"-"`
}

func (m *Entry) Reset()         { *m = Entry{} }
func (m *Entry) String() string { return proto.CompactTextString(m) }
func (*Entry) ProtoMessage()    {}
func (*Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{1}
}

func (m *Entry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entry.Unmarshal(m, b)
}
func (m *Entry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entry.Marshal(b, m, deterministic)
}
func (m *Entry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entry.Merge(m, src)
}
func (m *Entry) XXX_Size() int {
	return xxx_messageInfo_Entry.Size(m)
}
func (m *Entry) XXX_DiscardUnknown() {
	xxx_messageInfo_Entry.DiscardUnknown(m)
}

var xxx_messageInfo_Entry proto.InternalMessageInfo

func (m *Entry) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Entry) GetLinkedResource() string {
	if m != nil {
		return m.LinkedResource
	}
	return ""
}

func (m *Entry) GetType() EntryType {
	if m != nil {
		return m.Type
	}
	return EntryType_ENTRY_TYPE_UNSPECIFIED
}

type isEntry_TypeSpec interface {
	isEntry_TypeSpec()
}

type Entry_BigqueryTableSpec struct {
	BigqueryTableSpec *BigQueryTableSpec `protobuf:"bytes,12,opt,name=bigquery_table_spec,json=bigqueryTableSpec,proto3,oneof"`
}

func (*Entry_BigqueryTableSpec) isEntry_TypeSpec() {}

func (m *Entry) GetTypeSpec() isEntry_TypeSpec {
	if m != nil {
		return m.TypeSpec
	}
	return nil
}

func (m *Entry) GetBigqueryTableSpec() *BigQueryTableSpec {
	if x, ok := m.GetTypeSpec().(*Entry_BigqueryTableSpec); ok {
		return x.BigqueryTableSpec
	}
	return nil
}

func (m *Entry) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Entry) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entry) GetSchema() *Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *Entry) GetSourceSystemTimestamps() *SystemTimestamps {
	if m != nil {
		return m.SourceSystemTimestamps
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Entry) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Entry_BigqueryTableSpec)(nil),
	}
}

func init() {
	proto.RegisterEnum("google.cloud.datacatalog.v1beta1.EntryType", EntryType_name, EntryType_value)
	proto.RegisterType((*LookupEntryRequest)(nil), "google.cloud.datacatalog.v1beta1.LookupEntryRequest")
	proto.RegisterType((*Entry)(nil), "google.cloud.datacatalog.v1beta1.Entry")
}

func init() {
	proto.RegisterFile("google/cloud/datacatalog/v1beta1/datacatalog.proto", fileDescriptor_2054d97e7b16f897)
}

var fileDescriptor_2054d97e7b16f897 = []byte{
	// 563 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x53, 0x4d, 0x6f, 0xd3, 0x40,
	0x10, 0x8d, 0xf3, 0x51, 0x94, 0x75, 0x68, 0xc3, 0x22, 0x15, 0x13, 0x55, 0x22, 0x84, 0x43, 0x03,
	0x08, 0x5b, 0x49, 0x39, 0xc1, 0x01, 0xf2, 0x61, 0xd4, 0x8a, 0x12, 0x05, 0xc7, 0x1c, 0xca, 0xc5,
	0xda, 0x38, 0x23, 0x63, 0xd5, 0xf6, 0x6e, 0xbc, 0x1b, 0x24, 0x5f, 0xb9, 0x73, 0xe2, 0xcc, 0xaf,
	0xe2, 0x2f, 0x70, 0xe6, 0xcc, 0xb1, 0xf2, 0xda, 0x4d, 0xa2, 0x56, 0x95, 0x73, 0xb3, 0xde, 0xbc,
	0xf7, 0x66, 0x76, 0xfc, 0x06, 0xf5, 0x3d, 0x4a, 0xbd, 0x00, 0x0c, 0x37, 0xa0, 0xab, 0x85, 0xb1,
	0x20, 0x82, 0xb8, 0x44, 0x90, 0x80, 0x7a, 0xc6, 0xf7, 0xde, 0x1c, 0x04, 0xe9, 0x6d, 0x63, 0x3a,
	0x8b, 0xa9, 0xa0, 0xb8, 0x9d, 0x69, 0x74, 0xa9, 0xd1, 0xb7, 0xeb, 0xb9, 0xa6, 0x75, 0x94, 0xbb,
	0x12, 0xe6, 0x1b, 0x24, 0x8a, 0xa8, 0x20, 0xc2, 0xa7, 0x11, 0xcf, 0xf4, 0xad, 0x57, 0x85, 0x3d,
	0xb9, 0xfb, 0x0d, 0x42, 0x92, 0xd3, 0x7b, 0x85, 0x74, 0x41, 0xe6, 0x01, 0x38, 0x9c, 0x81, 0xbb,
	0xbb, 0xc4, 0x0f, 0x81, 0x0b, 0x12, 0xb2, 0x7c, 0xa8, 0x0e, 0x47, 0xf8, 0x9c, 0xd2, 0xcb, 0x15,
	0x33, 0x23, 0x11, 0x27, 0x16, 0x2c, 0x57, 0xc0, 0x05, 0x7e, 0x8e, 0x0e, 0x02, 0x3f, 0xba, 0x84,
	0x85, 0x13, 0x03, 0xa7, 0xab, 0xd8, 0x05, 0x4d, 0x69, 0x2b, 0xdd, 0xfa, 0x69, 0xc9, 0xda, 0xcf,
	0x0a, 0x56, 0x8e, 0xe3, 0x67, 0xa8, 0xc1, 0x97, 0xc1, 0x86, 0x57, 0xc9, 0x79, 0x2a, 0x5f, 0x06,
	0xd7, 0xa4, 0xe1, 0x7d, 0xa4, 0x0a, 0x12, 0x7b, 0x20, 0x9c, 0x88, 0x84, 0xd0, 0xf9, 0x57, 0x41,
	0x35, 0xd9, 0x0f, 0x63, 0x54, 0x4d, 0x91, 0xcc, 0xdd, 0x92, 0xdf, 0xf8, 0xf8, 0x76, 0xf3, 0xba,
	0x2c, 0xdf, 0x6c, 0xfd, 0x0e, 0x55, 0x45, 0xc2, 0x40, 0x2b, 0xb7, 0x95, 0xee, 0x7e, 0xff, 0xa5,
	0x5e, 0xf4, 0x7f, 0x74, 0xd9, 0xd3, 0x4e, 0x18, 0x58, 0x52, 0x88, 0x01, 0x3d, 0x9c, 0xfb, 0xde,
	0x72, 0x05, 0x71, 0xe2, 0x6c, 0x96, 0xa9, 0x35, 0xda, 0x4a, 0x57, 0xed, 0x9f, 0x14, 0xfb, 0x0d,
	0x7d, 0xef, 0x73, 0x2a, 0xb6, 0x53, 0xed, 0x8c, 0x81, 0x7b, 0x5a, 0xb2, 0x1e, 0x5c, 0x3b, 0xae,
	0x41, 0xfc, 0x14, 0x35, 0x16, 0x3e, 0x67, 0x01, 0x49, 0xe4, 0xf3, 0xb3, 0x15, 0x59, 0x6a, 0x8e,
	0x4d, 0xd2, 0x37, 0xb7, 0x91, 0xba, 0x00, 0xee, 0xc6, 0x3e, 0x4b, 0x13, 0xa3, 0x55, 0x73, 0xc6,
	0x06, 0xc2, 0xef, 0xd1, 0x5e, 0x16, 0x0f, 0xad, 0x26, 0xc7, 0xeb, 0x16, 0x8f, 0x37, 0x93, 0x7c,
	0x2b, 0xd7, 0xe1, 0x00, 0x69, 0xd9, 0xe2, 0x1c, 0x9e, 0x70, 0x01, 0xa1, 0xb3, 0x09, 0x83, 0x76,
	0x4f, 0x7a, 0xf6, 0x77, 0xf0, 0x94, 0x52, 0x7b, 0xad, 0xb4, 0x0e, 0x33, 0xcf, 0x9b, 0xf8, 0x50,
	0x45, 0xf5, 0x74, 0xc7, 0x72, 0xa3, 0x2f, 0x46, 0xa8, 0xbe, 0xde, 0x3d, 0x6e, 0xa1, 0x43, 0x73,
	0x62, 0x5b, 0x17, 0x8e, 0x7d, 0x31, 0x35, 0x9d, 0x2f, 0x93, 0xd9, 0xd4, 0x1c, 0x9d, 0x7d, 0x38,
	0x33, 0xc7, 0xcd, 0x12, 0xae, 0xa3, 0x9a, 0x3d, 0x18, 0x9e, 0x9b, 0xcd, 0x32, 0x3e, 0x40, 0xea,
	0x78, 0x60, 0x0f, 0x9c, 0x99, 0x6d, 0x99, 0x83, 0x4f, 0xcd, 0x4a, 0xff, 0xb7, 0x82, 0xd4, 0x31,
	0x11, 0x64, 0x94, 0x8d, 0x84, 0x7f, 0x2a, 0x48, 0xdd, 0xca, 0x2e, 0x7e, 0x5d, 0x3c, 0xfd, 0xed,
	0xa8, 0xb7, 0x8e, 0x77, 0x8c, 0x4d, 0xe7, 0xc9, 0x8f, 0x3f, 0x7f, 0x7f, 0x95, 0x1f, 0xe3, 0x47,
	0xeb, 0x63, 0x82, 0x48, 0xc4, 0x3e, 0xf0, 0x37, 0x81, 0x74, 0x1d, 0x32, 0x74, 0xe4, 0xd2, 0xf0,
	0x4e, 0xbb, 0xa9, 0xf2, 0xf5, 0x63, 0x5e, 0xf3, 0x68, 0x40, 0x22, 0x4f, 0xa7, 0xb1, 0x67, 0x78,
	0x10, 0xc9, 0x43, 0x34, 0xb2, 0x12, 0x61, 0x3e, 0xbf, 0xfb, 0x7c, 0xdf, 0x6e, 0x61, 0xff, 0x15,
	0x65, 0xbe, 0x27, 0xa5, 0x27, 0x57, 0x01, 0x00, 0x00, 0xff, 0xff, 0x7f, 0xc1, 0xb0, 0xec, 0xce,
	0x04, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DataCatalogClient is the client API for DataCatalog service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataCatalogClient interface {
	// Get an entry by target resource name. This method allows clients to use
	// the resource name from the source Google Cloud Platform service to get the
	// Cloud Data Catalog Entry.
	LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error)
}

type dataCatalogClient struct {
	cc *grpc.ClientConn
}

func NewDataCatalogClient(cc *grpc.ClientConn) DataCatalogClient {
	return &dataCatalogClient{cc}
}

func (c *dataCatalogClient) LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/LookupEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataCatalogServer is the server API for DataCatalog service.
type DataCatalogServer interface {
	// Get an entry by target resource name. This method allows clients to use
	// the resource name from the source Google Cloud Platform service to get the
	// Cloud Data Catalog Entry.
	LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error)
}

func RegisterDataCatalogServer(s *grpc.Server, srv DataCatalogServer) {
	s.RegisterService(&_DataCatalog_serviceDesc, srv)
}

func _DataCatalog_LookupEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).LookupEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/LookupEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).LookupEntry(ctx, req.(*LookupEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataCatalog_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datacatalog.v1beta1.DataCatalog",
	HandlerType: (*DataCatalogServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "LookupEntry",
			Handler:    _DataCatalog_LookupEntry_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datacatalog/v1beta1/datacatalog.proto",
}
