// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package retail provides access to the Retail API.
//
// For product documentation, see: https://cloud.google.com/recommendations
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/retail/v2alpha"
//   ...
//   ctx := context.Background()
//   retailService, err := retail.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   retailService, err := retail.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   retailService, err := retail.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package retail // import "google.golang.org/api/retail/v2alpha"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "retail:v2alpha"
const apiName = "retail"
const apiVersion = "v2alpha"
const basePath = "https://retail.googleapis.com/"
const mtlsBasePath = "https://retail.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// View and manage your data across Google Cloud Platform services
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Catalogs = NewProjectsLocationsCatalogsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Catalogs *ProjectsLocationsCatalogsService

	Operations *ProjectsLocationsOperationsService
}

func NewProjectsLocationsCatalogsService(s *Service) *ProjectsLocationsCatalogsService {
	rs := &ProjectsLocationsCatalogsService{s: s}
	rs.Branches = NewProjectsLocationsCatalogsBranchesService(s)
	rs.Operations = NewProjectsLocationsCatalogsOperationsService(s)
	rs.Placements = NewProjectsLocationsCatalogsPlacementsService(s)
	rs.UserEvents = NewProjectsLocationsCatalogsUserEventsService(s)
	return rs
}

type ProjectsLocationsCatalogsService struct {
	s *Service

	Branches *ProjectsLocationsCatalogsBranchesService

	Operations *ProjectsLocationsCatalogsOperationsService

	Placements *ProjectsLocationsCatalogsPlacementsService

	UserEvents *ProjectsLocationsCatalogsUserEventsService
}

func NewProjectsLocationsCatalogsBranchesService(s *Service) *ProjectsLocationsCatalogsBranchesService {
	rs := &ProjectsLocationsCatalogsBranchesService{s: s}
	rs.Operations = NewProjectsLocationsCatalogsBranchesOperationsService(s)
	rs.Products = NewProjectsLocationsCatalogsBranchesProductsService(s)
	return rs
}

type ProjectsLocationsCatalogsBranchesService struct {
	s *Service

	Operations *ProjectsLocationsCatalogsBranchesOperationsService

	Products *ProjectsLocationsCatalogsBranchesProductsService
}

func NewProjectsLocationsCatalogsBranchesOperationsService(s *Service) *ProjectsLocationsCatalogsBranchesOperationsService {
	rs := &ProjectsLocationsCatalogsBranchesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsBranchesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsBranchesProductsService(s *Service) *ProjectsLocationsCatalogsBranchesProductsService {
	rs := &ProjectsLocationsCatalogsBranchesProductsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsBranchesProductsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsOperationsService(s *Service) *ProjectsLocationsCatalogsOperationsService {
	rs := &ProjectsLocationsCatalogsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsOperationsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsPlacementsService(s *Service) *ProjectsLocationsCatalogsPlacementsService {
	rs := &ProjectsLocationsCatalogsPlacementsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsPlacementsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsUserEventsService(s *Service) *ProjectsLocationsCatalogsUserEventsService {
	rs := &ProjectsLocationsCatalogsUserEventsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsUserEventsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

// GoogleApiHttpBody: Message that represents an arbitrary HTTP body. It
// should only be used for payload formats that can't be represented as
// JSON, such as raw binary or an HTML page. This message can be used
// both in streaming and non-streaming API methods in the request as
// well as the response. It can be used as a top-level request field,
// which is convenient if one wants to extract parameters from either
// the URL or HTTP template into the request fields and also want access
// to the raw HTTP body. Example: message GetResourceRequest { // A
// unique request id. string request_id = 1; // The raw HTTP body is
// bound to this field. google.api.HttpBody http_body = 2; } service
// ResourceService { rpc GetResource(GetResourceRequest) returns
// (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody)
// returns (google.protobuf.Empty); } Example with streaming methods:
// service CaldavService { rpc GetCalendar(stream google.api.HttpBody)
// returns (stream google.api.HttpBody); rpc UpdateCalendar(stream
// google.api.HttpBody) returns (stream google.api.HttpBody); } Use of
// this type only changes how the request and response bodies are
// handled, all other features will continue to work unchanged.
type GoogleApiHttpBody struct {
	// ContentType: The HTTP Content-Type header value specifying the
	// content type of the body.
	ContentType string `json:"contentType,omitempty"`

	// Data: The HTTP request/response body as raw binary.
	Data string `json:"data,omitempty"`

	// Extensions: Application specific response metadata. Must be set in
	// the first response for streaming APIs.
	Extensions []googleapi.RawMessage `json:"extensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleApiHttpBody) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiHttpBody
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingErrorContext: A description of the context in
// which an error occurred.
type GoogleCloudRetailLoggingErrorContext struct {
	// HttpRequest: The HTTP request which was processed when the error was
	// triggered.
	HttpRequest *GoogleCloudRetailLoggingHttpRequestContext `json:"httpRequest,omitempty"`

	// ReportLocation: The location in the source code where the decision
	// was made to report the error, usually the place where it was logged.
	ReportLocation *GoogleCloudRetailLoggingSourceLocation `json:"reportLocation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HttpRequest") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HttpRequest") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailLoggingErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingErrorContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingErrorLog: An error log which is reported to
// the Error Reporting system. This proto a superset of
// google.devtools.clouderrorreporting.v1beta1.ReportedErrorEvent.
type GoogleCloudRetailLoggingErrorLog struct {
	// Context: A description of the context in which the error occurred.
	Context *GoogleCloudRetailLoggingErrorContext `json:"context,omitempty"`

	// ImportPayload: The error payload that is populated on LRO import
	// APIs.
	ImportPayload *GoogleCloudRetailLoggingImportErrorContext `json:"importPayload,omitempty"`

	// Message: A message describing the error.
	Message string `json:"message,omitempty"`

	// RequestPayload: The API request payload, represented as a protocol
	// buffer. Most API request types are supported. For example:
	// "type.googleapis.com/google.cloud.retail.v2.ProductService.CreateProdu
	// ctRequest"
	// "type.googleapis.com/google.cloud.retail.v2.UserEventService.WriteUser
	// EventRequest"
	RequestPayload googleapi.RawMessage `json:"requestPayload,omitempty"`

	// ResponsePayload: The API response payload, represented as a protocol
	// buffer. This is used to log some "soft errors", where the response is
	// valid but we consider there are some quality issues like unjoined
	// events. The following API responses are supported and no PII is
	// included: "google.cloud.retail.v2.PredictionService.Predict"
	// "google.cloud.retail.v2.UserEventService.WriteUserEvent"
	// "google.cloud.retail.v2.UserEventService.CollectUserEvent"
	ResponsePayload googleapi.RawMessage `json:"responsePayload,omitempty"`

	// ServiceContext: The service context in which this error has occurred.
	ServiceContext *GoogleCloudRetailLoggingServiceContext `json:"serviceContext,omitempty"`

	// Status: The RPC status associated with the error log.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Context") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Context") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailLoggingErrorLog) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingErrorLog
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingHttpRequestContext: HTTP request data that is
// related to a reported error.
type GoogleCloudRetailLoggingHttpRequestContext struct {
	// ResponseStatusCode: The HTTP response status code for the request.
	ResponseStatusCode int64 `json:"responseStatusCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResponseStatusCode")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResponseStatusCode") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailLoggingHttpRequestContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingHttpRequestContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingImportErrorContext: The error payload that is
// populated on LRO import APIs. Including:
// "google.cloud.retail.v2.ProductService.ImportProducts"
// "google.cloud.retail.v2.EventService.ImportUserEvents"
type GoogleCloudRetailLoggingImportErrorContext struct {
	// CatalogItem: The detailed content which caused the error on importing
	// a catalog item.
	CatalogItem string `json:"catalogItem,omitempty"`

	// GcsPath: GCS file path of the import source. Can be set for batch
	// operation error.
	GcsPath string `json:"gcsPath,omitempty"`

	// LineNumber: Line number of the content in file. Should be empty for
	// permission or batch operation error.
	LineNumber string `json:"lineNumber,omitempty"`

	// OperationName: The operation resource name of the LRO.
	OperationName string `json:"operationName,omitempty"`

	// Product: The detailed content which caused the error on importing a
	// product.
	Product string `json:"product,omitempty"`

	// UserEvent: The detailed content which caused the error on importing a
	// user event.
	UserEvent string `json:"userEvent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CatalogItem") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CatalogItem") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailLoggingImportErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingImportErrorContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingServiceContext: Describes a running service
// that sends errors.
type GoogleCloudRetailLoggingServiceContext struct {
	// Service: An identifier of the service. For example,
	// "retail.googleapis.com".
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Service") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Service") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailLoggingServiceContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingServiceContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingSourceLocation: Indicates a location in the
// source code of the service for which errors are reported.
type GoogleCloudRetailLoggingSourceLocation struct {
	// FunctionName: Human-readable name of a function or method. For
	// example, "google.cloud.retail.v2.UserEventService.ImportUserEvents".
	FunctionName string `json:"functionName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FunctionName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FunctionName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailLoggingSourceLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingSourceLocation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportErrorsConfig: Configuration of destination
// for Import related errors.
type GoogleCloudRetailV2ImportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage path for import errors. This must be
	// an empty, existing Cloud Storage bucket. Import errors will be
	// written to a file in this bucket, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ImportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportErrorsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportMetadata: Metadata related to the progress
// of the Import operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2ImportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ImportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportProductsResponse: Response of the
// ImportProductsRequest. If the long running operation is done, then
// this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2ImportProductsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorsConfig *GoogleCloudRetailV2ImportErrorsConfig `json:"errorsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ImportProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportProductsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2ImportUserEventsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorsConfig *GoogleCloudRetailV2ImportErrorsConfig `json:"errorsConfig,omitempty"`

	// ImportSummary: Aggregated statistics of user event import status.
	ImportSummary *GoogleCloudRetailV2UserEventImportSummary `json:"importSummary,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2PurgeMetadata: Metadata related to the progress of
// the Purge operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2PurgeMetadata struct {
}

// GoogleCloudRetailV2PurgeUserEventsResponse: Response of the
// PurgeUserEventsRequest. If the long running operation is successfully
// done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudRetailV2PurgeUserEventsResponse struct {
	// PurgedEventsCount: The total count of events purged as a result of
	// the operation.
	PurgedEventsCount int64 `json:"purgedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "PurgedEventsCount")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PurgedEventsCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2PurgeUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2PurgeUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2RejoinUserEventsMetadata: Metadata for
// RejoinUserEvents method.
type GoogleCloudRetailV2RejoinUserEventsMetadata struct {
}

// GoogleCloudRetailV2RejoinUserEventsResponse: Response message for
// RejoinUserEvents method.
type GoogleCloudRetailV2RejoinUserEventsResponse struct {
	// RejoinedUserEventsCount: Number of user events that were joined with
	// latest product catalog.
	RejoinedUserEventsCount int64 `json:"rejoinedUserEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "RejoinedUserEventsCount") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RejoinedUserEventsCount")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2RejoinUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2RejoinUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2UserEventImportSummary: A summary of import
// result. The UserEventImportSummary summarizes the import status for
// user events.
type GoogleCloudRetailV2UserEventImportSummary struct {
	// JoinedEventsCount: Count of user events imported with complete
	// existing catalog information.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`

	// UnjoinedEventsCount: Count of user events imported, but with catalog
	// information not found in the imported catalog.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "JoinedEventsCount")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "JoinedEventsCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2UserEventImportSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2UserEventImportSummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaBigQuerySource: BigQuery source import data
// from.
type GoogleCloudRetailV2alphaBigQuerySource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for product imports: * `product` (default): One JSON
	// Product per line. Each product must have a valid Product.id. *
	// `product_merchant_center`: See Importing catalog data from Merchant
	// Center
	// (https://cloud.google.com/retail/recommendations-ai/docs/upload-catalog#mc).
	// Supported values for user events imports: * `user_event` (default):
	// One JSON UserEvent per line. * `user_event_ga360`: Using
	// https://support.google.com/analytics/answer/3437719?hl=en.
	DataSchema string `json:"dataSchema,omitempty"`

	// DatasetId: Required. The BigQuery data set to copy the data from with
	// a length limit of 1,024 characters.
	DatasetId string `json:"datasetId,omitempty"`

	// GcsStagingDir: Intermediate Cloud Storage directory used for the
	// import with a length limit of 2,000 characters. Can be specified if
	// one wants to have the BigQuery export to a specific Cloud Storage
	// directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`

	// ProjectId: The project id (can be project # or id) that the BigQuery
	// source is in with a length limit of 128 characters. If not specified,
	// inherits the project id from the parent request.
	ProjectId string `json:"projectId,omitempty"`

	// TableId: Required. The BigQuery table to copy the data from with a
	// length limit of 1,024 characters.
	TableId string `json:"tableId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataSchema") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaBigQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaBigQuerySource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCatalog: The catalog configuration.
type GoogleCloudRetailV2alphaCatalog struct {
	// DisplayName: Required. Immutable. The catalog display name. This
	// field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Required. Immutable. The fully qualified resource name of the
	// catalog.
	Name string `json:"name,omitempty"`

	// ProductLevelConfig: Required. The product level configuration.
	ProductLevelConfig *GoogleCloudRetailV2alphaProductLevelConfig `json:"productLevelConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaCatalog) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCatalog
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCustomAttribute: A custom attribute that is
// not explicitly modeled in Product.
type GoogleCloudRetailV2alphaCustomAttribute struct {
	// Numbers: The numerical values of this custom attribute. For example,
	// `[2.3, 15.4]` when the key is "lengths_cm". At most 400 values are
	// allowed.Otherwise, an INVALID_ARGUMENT error is returned. Exactly one
	// of text or numbers should be set. Otherwise, an INVALID_ARGUMENT
	// error is returned.
	Numbers []float64 `json:"numbers,omitempty"`

	// Text: The textual values of this custom attribute. For example,
	// `["yellow", "green"]` when the key is "color". At most 400 values are
	// allowed. Empty values are not allowed. Each value must be a UTF-8
	// encoded string with a length limit of 256 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. Exactly one of text or numbers
	// should be set. Otherwise, an INVALID_ARGUMENT error is returned.
	Text []string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Numbers") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Numbers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaCustomAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCustomAttribute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExportErrorsConfig: Configuration of
// destination for Export related errors.
type GoogleCloudRetailV2alphaExportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage path for import errors. This must be
	// an empty, existing Cloud Storage bucket. Export errors will be
	// written to a file in this bucket, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaExportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportErrorsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExportMetadata: Metadata related to the
// progress of the Export operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2alphaExportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaExportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExportProductsResponse: Response of the
// ExportProductsRequest. If the long running operation is done, then
// this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2alphaExportProductsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorsConfig *GoogleCloudRetailV2alphaExportErrorsConfig `json:"errorsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaExportProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportProductsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExportUserEventsResponse: Response of the
// ExportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2alphaExportUserEventsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorsConfig *GoogleCloudRetailV2alphaExportErrorsConfig `json:"errorsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaExportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaGcsSource: Google Cloud Storage location for
// input content. format.
type GoogleCloudRetailV2alphaGcsSource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for product imports: * `product` (default): One JSON
	// Product per line. Each product must have a valid Product.id. *
	// `product_merchant_center`: See Importing catalog data from Merchant
	// Center
	// (https://cloud.google.com/retail/recommendations-ai/docs/upload-catalog#mcc).
	// Supported values for user events imports: * `user_event` (default):
	// One JSON UserEvent per line. * `user_event_ga360`: Using
	// https://support.google.com/analytics/answer/3437719?hl=en.
	DataSchema string `json:"dataSchema,omitempty"`

	// InputUris: Required. Google Cloud Storage URIs to input files. URI
	// can be up to 2000 characters long. URIs can match the full object
	// path (for example, `gs://bucket/directory/object.json`) or a pattern
	// matching one or more files, such as `gs://bucket/directory/*.json`. A
	// request can contain at most 100 files, and each file can be up to 2
	// GB. See Importing product information
	// (https://cloud.google.com/recommendations-ai/docs/upload-catalog) for
	// the expected file format and setup instructions.
	InputUris []string `json:"inputUris,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataSchema") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaGcsSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImage: Product thumbnail/detail image.
type GoogleCloudRetailV2alphaImage struct {
	// Height: Height of the image in number of pixels. This field must be
	// nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
	Height int64 `json:"height,omitempty"`

	// Uri: Required. URI of the image. This field must be a valid UTF-8
	// encoded URI with a length limit of 5,000 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. Google Merchant Center property
	// image_link (https://support.google.com/merchants/answer/6324350).
	// Schema.org property Product.image (https://schema.org/image).
	Uri string `json:"uri,omitempty"`

	// Width: Width of the image in number of pixels. This field must be
	// nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
	Width int64 `json:"width,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Height") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportErrorsConfig: Configuration of
// destination for Import related errors.
type GoogleCloudRetailV2alphaImportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage path for import errors. This must be
	// an empty, existing Cloud Storage bucket. Import errors will be
	// written to a file in this bucket, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaImportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportErrorsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportMetadata: Metadata related to the
// progress of the Import operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2alphaImportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaImportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportProductsRequest: Request message for
// Import methods.
type GoogleCloudRetailV2alphaImportProductsRequest struct {
	// ErrorsConfig: The desired location of errors incurred during the
	// Import.
	ErrorsConfig *GoogleCloudRetailV2alphaImportErrorsConfig `json:"errorsConfig,omitempty"`

	// InputConfig: Required. The desired input location of the data.
	InputConfig *GoogleCloudRetailV2alphaProductInputConfig `json:"inputConfig,omitempty"`

	// UpdateMask: Indicates which fields in the provided imported
	// 'products' to update. If not set, will by default update all fields.
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorsConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorsConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaImportProductsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportProductsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportProductsResponse: Response of the
// ImportProductsRequest. If the long running operation is done, then
// this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2alphaImportProductsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorsConfig *GoogleCloudRetailV2alphaImportErrorsConfig `json:"errorsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaImportProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportProductsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportUserEventsRequest: Request message for
// the ImportUserEvents request.
type GoogleCloudRetailV2alphaImportUserEventsRequest struct {
	// ErrorsConfig: The desired location of errors incurred during the
	// Import. Cannot be set for inline user event imports.
	ErrorsConfig *GoogleCloudRetailV2alphaImportErrorsConfig `json:"errorsConfig,omitempty"`

	// InputConfig: Required. The desired input location of the data.
	InputConfig *GoogleCloudRetailV2alphaUserEventInputConfig `json:"inputConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorsConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorsConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaImportUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportUserEventsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2alphaImportUserEventsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorsConfig *GoogleCloudRetailV2alphaImportErrorsConfig `json:"errorsConfig,omitempty"`

	// ImportSummary: Aggregated statistics of user event import status.
	ImportSummary *GoogleCloudRetailV2alphaUserEventImportSummary `json:"importSummary,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaListCatalogsResponse: Response for
// CatalogService.ListCatalogs method.
type GoogleCloudRetailV2alphaListCatalogsResponse struct {
	// Catalogs: All the customer's Catalogs.
	Catalogs []*GoogleCloudRetailV2alphaCatalog `json:"catalogs,omitempty"`

	// NextPageToken: A token that can be sent as
	// ListCatalogsRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Catalogs") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Catalogs") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaListCatalogsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaListCatalogsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPredictRequest: Request message for Predict
// method.
type GoogleCloudRetailV2alphaPredictRequest struct {
	// Filter: Filter for restricting prediction results with a length limit
	// of 5,000 characters. Accepts values for tags and the
	// `filterOutOfStockItems` flag. * Tag expressions. Restricts
	// predictions to products that match all of the specified tags. Boolean
	// operators `OR` and `NOT` are supported if the expression is enclosed
	// in parentheses, and must be separated from the tag values by a space.
	// `-"tagA" is also supported and is equivalent to `NOT "tagA". Tag
	// values must be double quoted UTF-8 encoded strings with a size limit
	// of 1,000 characters. Note: "Recently viewed" models don't support tag
	// filtering at the moment. * filterOutOfStockItems. Restricts
	// predictions to products that do not have a stockState value of
	// OUT_OF_STOCK. Examples: * tag=("Red" OR "Blue") tag="New-Arrival"
	// tag=(NOT "promotional") * filterOutOfStockItems tag=(-"promotional")
	// * filterOutOfStockItems If your filter blocks all prediction results,
	// nothing will be returned. If you want generic (unfiltered) popular
	// products to be returned instead, set `strictFiltering` to false in
	// `PredictRequest.params`.
	Filter string `json:"filter,omitempty"`

	// Labels: The labels for the predict request. * Label keys can contain
	// lowercase letters, digits and hyphens, must start with a letter, and
	// must end with a letter or digit. * Non-zero label values can contain
	// lowercase letters, digits and hyphens, must start with a letter, and
	// must end with a letter or digit. * No more than 64 labels can be
	// associated with a given request. See https://goo.gl/xmQnxf for more
	// information on and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`

	// PageSize: Maximum number of results to return per page. Set this
	// property to the number of prediction results needed. If zero, the
	// service will choose a reasonable default. The maximum allowed value
	// is 100. Values above 100 will be coerced to 100.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: The previous PredictResponse.next_page_token.
	PageToken string `json:"pageToken,omitempty"`

	// Params: Additional domain specific parameters for the predictions.
	// Allowed values: * `returnProduct`: Boolean. If set to true, the
	// associated product object will be returned in the `results.metadata`
	// field in the prediction response. * `returnScore`: Boolean. If set to
	// true, the prediction 'score' corresponding to each returned product
	// will be set in the `results.metadata` field in the prediction
	// response. The given 'score' indicates the probability of an product
	// being clicked/purchased given the user's context and history. *
	// `strictFiltering`: Boolean. True by default. If set to false, the
	// service will return generic (unfiltered) popular products instead of
	// empty if your filter blocks all prediction results.
	Params googleapi.RawMessage `json:"params,omitempty"`

	// UserEvent: Required. Context about the user, what they are looking at
	// and what action they took to trigger the predict request. Note that
	// this user event detail won't be ingested to userEvent logs. Thus, a
	// separate userEvent write request is required for event logging.
	UserEvent *GoogleCloudRetailV2alphaUserEvent `json:"userEvent,omitempty"`

	// ValidateOnly: Use validate only mode for this prediction query. If
	// set to true, a dummy model will be used that returns arbitrary
	// products. Note that the validate only mode should only be used for
	// testing the API, or if the model is not ready.
	ValidateOnly bool `json:"validateOnly,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaPredictRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPredictRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPredictResponse: Response message for predict
// method.
type GoogleCloudRetailV2alphaPredictResponse struct {
	// AttributionToken: A unique attribution token. This should be included
	// in the UserEvent logs resulting from this recommendation, which
	// enables accurate attribution of recommendation model performance.
	AttributionToken string `json:"attributionToken,omitempty"`

	// MissingIds: IDs of products in the request that were missing from the
	// inventory.
	MissingIds []string `json:"missingIds,omitempty"`

	// Results: A list of recommended products. The order represents the
	// ranking (from the most relevant product to the least).
	Results []*GoogleCloudRetailV2alphaPredictResponsePredictionResult `json:"results,omitempty"`

	// ValidateOnly: True if the validateOnly property was set in the
	// request.
	ValidateOnly bool `json:"validateOnly,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AttributionToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributionToken") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaPredictResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPredictResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPredictResponsePredictionResult:
// PredictionResult represents the recommendation prediction results.
type GoogleCloudRetailV2alphaPredictResponsePredictionResult struct {
	// Id: ID of the recommended product
	Id string `json:"id,omitempty"`

	// Metadata: Additional product metadata / annotations. Possible values:
	// * `product`: JSON representation of the product. Will be set if
	// `returnProduct` is set to true in `PredictRequest.params`. * `score`:
	// Prediction score in double value. Will be set if `returnScore` is set
	// to true in `PredictRequest.params`.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaPredictResponsePredictionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPredictResponsePredictionResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPriceInfo: The price information of a
// Product.
type GoogleCloudRetailV2alphaPriceInfo struct {
	// Cost: The costs associated with the sale of a particular product.
	// Used for gross profit reporting. * Profit = price - cost Google
	// Merchant Center property cost_of_goods_sold
	// (https://support.google.com/merchants/answer/9017895).
	Cost float64 `json:"cost,omitempty"`

	// CurrencyCode: The 3-letter currency code defined in ISO 4217
	// (https://www.iso.org/iso-4217-currency-codes.html). If this field is
	// an unrecognizable currency code, an INVALID_ARGUMENT error is
	// returned.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// OriginalPrice: Price of the product without any discount. If zero, by
	// default set to be the price.
	OriginalPrice float64 `json:"originalPrice,omitempty"`

	// Price: Price of the product. Google Merchant Center property price
	// (https://support.google.com/merchants/answer/6324371). Schema.org
	// property Offer.priceSpecification
	// (https://schema.org/priceSpecification).
	Price float64 `json:"price,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cost") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cost") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaPriceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPriceInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2alphaPriceInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2alphaPriceInfo
	var s1 struct {
		Cost          gensupport.JSONFloat64 `json:"cost"`
		OriginalPrice gensupport.JSONFloat64 `json:"originalPrice"`
		Price         gensupport.JSONFloat64 `json:"price"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cost = float64(s1.Cost)
	s.OriginalPrice = float64(s1.OriginalPrice)
	s.Price = float64(s1.Price)
	return nil
}

// GoogleCloudRetailV2alphaProduct: Product captures all metadata
// information of items to be recommended or searched.
type GoogleCloudRetailV2alphaProduct struct {
	// Attributes: Highly encouraged. Extra product attributes to be
	// included. For example, for products, this could include the store
	// name, vendor, style, color, etc. These are very strong signals for
	// recommendation model, thus we highly recommend providing the
	// attributes here. Features that can take on one of a limited number of
	// possible values. Two types of features can be set are: Textual
	// features. some examples would be the brand/maker of a product, or
	// country of a customer. Numerical features. Some examples would be the
	// height/weight of a product, or age of a customer. For example: `{
	// "vendor": {"text": ["vendor123", "vendor456"]}, "lengths_cm":
	// {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]} }`.
	// This field needs to pass all below criteria, otherwise an
	// INVALID_ARGUMENT error is returned: * Max entries count: 150 by
	// default; 100 for Type.VARIANT. * The key must be a UTF-8 encoded
	// string with a length limit of 128 characters.
	Attributes map[string]GoogleCloudRetailV2alphaCustomAttribute `json:"attributes,omitempty"`

	// Availability: The online availability of the Product. Default to
	// Availability.IN_STOCK. Google Merchant Center Property availability
	// (https://support.google.com/merchants/answer/6324448). Schema.org
	// Property Offer.availability (https://schema.org/availability).
	//
	// Possible values:
	//   "AVAILABILITY_UNSPECIFIED" - Default product availability. Default
	// to Availability.IN_STOCK if unset.
	//   "IN_STOCK" - Product in stock.
	//   "OUT_OF_STOCK" - Product out of stock.
	//   "PREORDER" - Product that is in pre-order state.
	//   "BACKORDER" - Product that is back-ordered (i.e. temporarily out of
	// stock).
	Availability string `json:"availability,omitempty"`

	// AvailableQuantity: The available quantity of the item.
	AvailableQuantity int64 `json:"availableQuantity,omitempty"`

	// AvailableTime: The timestamp when this Product becomes available for
	// recommendation.
	AvailableTime string `json:"availableTime,omitempty"`

	// Categories: Product categories. This field is repeated for supporting
	// one product belonging to several parallel categories. Strongly
	// recommended using the full path for better search / recommendation
	// quality. To represent full path of category, use '>' sign to separate
	// different hierarchies. If '>' is part of the category name, please
	// replace it with other character(s). For example, if a shoes product
	// belongs to both ["Shoes & Accessories" -> "Shoes"] and ["Sports &
	// Fitness" -> "Athletic Clothing" -> "Shoes"], it could be represented
	// as: "categories": [ "Shoes & Accessories > Shoes", "Sports & Fitness
	// > Athletic Clothing > Shoes" ] Must be set for Type.PRIMARY Product
	// otherwise an INVALID_ARGUMENT error is returned. At most 250 values
	// are allowed per Product. Empty values are not allowed. Each value
	// must be a UTF-8 encoded string with a length limit of 5,000
	// characters. Otherwise, an INVALID_ARGUMENT error is returned. Google
	// Merchant Center property google_product_category. Schema.org property
	// [Product.category] (https://schema.org/category).
	// [mc_google_product_category]:
	// https://support.google.com/merchants/answer/6324436
	Categories []string `json:"categories,omitempty"`

	// Description: Product description. This field must be a UTF-8 encoded
	// string with a length limit of 5,000 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. Google Merchant Center property
	// description (https://support.google.com/merchants/answer/6324468).
	// schema.org property Product.description
	// (https://schema.org/description).
	Description string `json:"description,omitempty"`

	// Id: Immutable. Product identifier, which is the final component of
	// name. For example, this field is "id_1", if name is
	// `projects/*/locations/global/catalogs/default_catalog/branches/default
	// _branch/products/id_1`. This field must be a UTF-8 encoded string
	// with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT
	// error is returned. Google Merchant Center property id
	// (https://support.google.com/merchants/answer/6324405). Schema.org
	// Property Product.sku (https://schema.org/sku).
	Id string `json:"id,omitempty"`

	// Images: Product images for the product.Highly recommended to put the
	// main image to the first. A maximum of 300 images are allowed. Google
	// Merchant Center property image_link
	// (https://support.google.com/merchants/answer/6324350). Schema.org
	// property Product.image (https://schema.org/image).
	Images []*GoogleCloudRetailV2alphaImage `json:"images,omitempty"`

	// Name: Immutable. Full resource name of the product, such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/default
	// _branch/products/product_id`. The branch ID must be "default_branch".
	Name string `json:"name,omitempty"`

	// PriceInfo: Product price and cost information. Google Merchant Center
	// property price (https://support.google.com/merchants/answer/6324371).
	PriceInfo *GoogleCloudRetailV2alphaPriceInfo `json:"priceInfo,omitempty"`

	// PrimaryProductId: Variant group identifier. Must be an id, with the
	// same parent branch with this product. Otherwise, an error is thrown.
	// For Type.PRIMARY Products, this field can only be empty or set to the
	// same value as id. For VARIANT Products, this field cannot be empty. A
	// maximum of 2,000 products are allowed to share the same Type.PRIMARY
	// Product. Otherwise, an INVALID_ARGUMENT error is returned. Google
	// Merchant Center Property item_group_id
	// (https://support.google.com/merchants/answer/6324507). Schema.org
	// Property Product.inProductGroupWithID
	// (https://schema.org/inProductGroupWithID). This field must be enabled
	// before it can be used. Learn more
	// (/recommendations-ai/docs/catalog#item-group-id).
	PrimaryProductId string `json:"primaryProductId,omitempty"`

	// Tags: Custom tags associated with the product. At most 250 values are
	// allowed per Product. This value must be a UTF-8 encoded string with a
	// length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT
	// error is returned. This tag can be used for filtering recommendation
	// results by passing the tag as part of the PredictRequest.filter.
	// Google Merchant Center property custom_label_0–4
	// (https://support.google.com/merchants/answer/6324473).
	Tags []string `json:"tags,omitempty"`

	// Title: Required. Product title. This field must be a UTF-8 encoded
	// string with a length limit of 1,000 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. Google Merchant Center property
	// title (https://support.google.com/merchants/answer/6324415).
	// Schema.org property Product.name (https://schema.org/name).
	Title string `json:"title,omitempty"`

	// Type: Immutable. The type of the product. This field is output-only.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value. Default to Type.PRIMARY if
	// unset.
	//   "PRIMARY" - The primary type. As the primary unit for predicting,
	// indexing and search serving, a Type.PRIMARY Product is grouped with
	// multiple Type.VARIANT Products.
	//   "VARIANT" - The variant type. Type.VARIANT Products usually share
	// some common attributes on the same Type.PRIMARY Products, but they
	// have variant attributes like different colors, sizes and prices, etc.
	//   "COLLECTION" - The collection type. Collection products are bundled
	// Type.PRIMARY Products or Type.VARIANT Products that are sold
	// together, such as a jewelry set with necklaces, earrings and rings,
	// etc.
	Type string `json:"type,omitempty"`

	// Uri: Canonical URL directly linking to the product detail page. It is
	// strongly recommended to provide a valid uri for the product,
	// otherwise the service performance could be significantly degraded.
	// This field must be a UTF-8 encoded string with a length limit of
	// 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned.
	// Google Merchant Center property link
	// (https://support.google.com/merchants/answer/6324416). Schema.org
	// property Offer.url (https://schema.org/url).
	Uri string `json:"uri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attributes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaProduct) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaProduct
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaProductDetail: Detailed product information
// associated with a user event.
type GoogleCloudRetailV2alphaProductDetail struct {
	// Product: Required. Product information. Only Product.id field is used
	// when ingesting an event, all other product fields are ignored as we
	// will look them up from the catalog.
	Product *GoogleCloudRetailV2alphaProduct `json:"product,omitempty"`

	// Quantity: Quantity of the product associated with the user event. For
	// example, this field will be 2 if two products are added to the
	// shopping cart for `purchase-complete` event. Required for
	// `add-to-cart` and `purchase-complete` event types.
	Quantity int64 `json:"quantity,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Product") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Product") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaProductDetail) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaProductDetail
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaProductInlineSource: The inline source for
// the input config for ImportProducts method.
type GoogleCloudRetailV2alphaProductInlineSource struct {
	// Products: Required. A list of products to update/create. Each product
	// must have a valid Product.id. Recommended max of 10k items.
	Products []*GoogleCloudRetailV2alphaProduct `json:"products,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Products") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Products") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaProductInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaProductInlineSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaProductInputConfig: The input config source
// for products.
type GoogleCloudRetailV2alphaProductInputConfig struct {
	// BigQuerySource: BigQuery input source.
	BigQuerySource *GoogleCloudRetailV2alphaBigQuerySource `json:"bigQuerySource,omitempty"`

	// GcsSource: Google Cloud Storage location for the input content.
	GcsSource *GoogleCloudRetailV2alphaGcsSource `json:"gcsSource,omitempty"`

	// ProductInlineSource: The Inline source for the input content for
	// products.
	ProductInlineSource *GoogleCloudRetailV2alphaProductInlineSource `json:"productInlineSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigQuerySource") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigQuerySource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaProductInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaProductInputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaProductLevelConfig: Configures what level the
// product should be uploaded with regards to how users will be send
// events and how predictions will be made.
type GoogleCloudRetailV2alphaProductLevelConfig struct {
	// IngestionProductType: The type of Products allowed to be ingested
	// into the catalog. Acceptable values are: * `primary` (default): You
	// can only ingest Product.Type.PRIMARY Products. This means
	// Product.primary_product_id can only be empty or set to the same value
	// as Product.id. * `variant`: You can only ingest Product.Type.VARIANT
	// Products. This means Product.primary_product_id cannot be empty. If
	// this field is set to an invalid value other than these, an
	// INVALID_ARGUMENT error is returned. If this field is `variant` and
	// merchant_center_product_id_field is `itemGroupId`, an
	// INVALID_ARGUMENT error is returned. See Using catalog levels
	// (/retail/recommendations-ai/docs/catalog#catalog-levels) for more
	// details.
	IngestionProductType string `json:"ingestionProductType,omitempty"`

	// MerchantCenterProductIdField: Which field of Merchant Center Product
	// (/bigquery-transfer/docs/merchant-center-products-schema) should be
	// imported as Product.id. Acceptable values are: * `offerId` (default):
	// Import `offerId` as the product ID. * `itemGroupId`: Import
	// `itemGroupId` as the product ID. Notice that Retail API will choose
	// one item from the ones with the same `itemGroupId`, and use it to
	// represent the item group. If this field is set to an invalid value
	// other than these, an INVALID_ARGUMENT error is returned. If this
	// field is `itemGroupId` and ingestion_product_type is `variant`, an
	// INVALID_ARGUMENT error is returned. See Using catalog levels
	// (/retail/recommendations-ai/docs/catalog#catalog-levels) for more
	// details.
	MerchantCenterProductIdField string `json:"merchantCenterProductIdField,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "IngestionProductType") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IngestionProductType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaProductLevelConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaProductLevelConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPurchaseTransaction: A transaction represents
// the entire purchase transaction.
type GoogleCloudRetailV2alphaPurchaseTransaction struct {
	// Cost: All the costs associated with the products. These can be
	// manufacturing costs, shipping expenses not borne by the end user, or
	// any other costs, such that: * Profit = revenue - tax - cost
	Cost float64 `json:"cost,omitempty"`

	// CurrencyCode: Required. Currency code. Use three-character ISO-4217
	// code.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// Id: The transaction ID with a length limit of 128 characters.
	Id string `json:"id,omitempty"`

	// Revenue: Required. Total non-zero revenue or grand total associated
	// with the transaction. This value include shipping, tax, or other
	// adjustments to total revenue that you want to include as part of your
	// revenue calculations.
	Revenue float64 `json:"revenue,omitempty"`

	// Tax: All the taxes associated with the transaction.
	Tax float64 `json:"tax,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cost") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cost") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaPurchaseTransaction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPurchaseTransaction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2alphaPurchaseTransaction) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2alphaPurchaseTransaction
	var s1 struct {
		Cost    gensupport.JSONFloat64 `json:"cost"`
		Revenue gensupport.JSONFloat64 `json:"revenue"`
		Tax     gensupport.JSONFloat64 `json:"tax"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cost = float64(s1.Cost)
	s.Revenue = float64(s1.Revenue)
	s.Tax = float64(s1.Tax)
	return nil
}

// GoogleCloudRetailV2alphaPurgeMetadata: Metadata related to the
// progress of the Purge operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2alphaPurgeMetadata struct {
}

// GoogleCloudRetailV2alphaPurgeUserEventsRequest: Request message for
// PurgeUserEvents method.
type GoogleCloudRetailV2alphaPurgeUserEventsRequest struct {
	// Filter: Required. The filter string to specify the events to be
	// deleted with a length limit of 5,000 characters. Empty string filter
	// is not allowed. The eligible fields for filtering are: * `eventType`:
	// Double quoted UserEvent.event_type string. * `eventTime`: in ISO 8601
	// "zulu" format. * `visitorId`: Double quoted string. Specifying this
	// will delete all events associated with a visitor. * `userId`: Double
	// quoted string. Specifying this will delete all events associated with
	// a user. Examples: * Deleting all events in a time range: `eventTime >
	// "2012-04-23T18:25:43.511Z" eventTime < "2012-04-23T18:30:43.511Z" *
	// Deleting specific eventType in time range: `eventTime >
	// "2012-04-23T18:25:43.511Z" eventType = "detail-page-view" * Deleting
	// all events for a specific visitor: `visitorId = "visitor1024" The
	// filtering fields are assumed to have an implicit AND.
	Filter string `json:"filter,omitempty"`

	// Force: Actually perform the purge. If `force` is set to false, the
	// method will return the expected purge count without deleting any user
	// events.
	Force bool `json:"force,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaPurgeUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPurgeUserEventsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPurgeUserEventsResponse: Response of the
// PurgeUserEventsRequest. If the long running operation is successfully
// done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudRetailV2alphaPurgeUserEventsResponse struct {
	// PurgedEventsCount: The total count of events purged as a result of
	// the operation.
	PurgedEventsCount int64 `json:"purgedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "PurgedEventsCount")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PurgedEventsCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaPurgeUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPurgeUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRejoinUserEventsMetadata: Metadata for
// RejoinUserEvents method.
type GoogleCloudRetailV2alphaRejoinUserEventsMetadata struct {
}

// GoogleCloudRetailV2alphaRejoinUserEventsRequest: Request message for
// RejoinUserEvents method.
type GoogleCloudRetailV2alphaRejoinUserEventsRequest struct {
	// UserEventRejoinScope: The type of the user event rejoin to define the
	// scope and range of the user events to be rejoined with the latest
	// product catalog. Defaults to USER_EVENT_REJOIN_SCOPE_UNSPECIFIED if
	// this field is not set, or set to an invalid integer value.
	//
	// Possible values:
	//   "USER_EVENT_REJOIN_SCOPE_UNSPECIFIED" - Rejoin all events with the
	// latest product catalog, including both joined events and unjoined
	// events.
	//   "JOINED_EVENTS" - Only rejoin joined events with the latest product
	// catalog.
	//   "UNJOINED_EVENTS" - Only rejoin unjoined events with the latest
	// product catalog.
	UserEventRejoinScope string `json:"userEventRejoinScope,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "UserEventRejoinScope") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserEventRejoinScope") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaRejoinUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRejoinUserEventsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRejoinUserEventsResponse: Response message
// for RejoinUserEvents method.
type GoogleCloudRetailV2alphaRejoinUserEventsResponse struct {
	// RejoinedUserEventsCount: Number of user events that were joined with
	// latest product catalog.
	RejoinedUserEventsCount int64 `json:"rejoinedUserEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "RejoinedUserEventsCount") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RejoinedUserEventsCount")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaRejoinUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRejoinUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaUserEvent: UserEvent captures all metadata
// information Retail API needs to know about how end users interact
// with customers' website.
type GoogleCloudRetailV2alphaUserEvent struct {
	// Attributes: Extra user event features to include in the
	// recommendation model. The key must be a UTF-8 encoded string with a
	// length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT
	// error is returned. For product recommendation, an example of extra
	// user information is traffic_channel, i.e. how user arrives at the
	// site. Users can arrive at the site by coming to the site directly, or
	// coming through Google search, and etc.
	Attributes map[string]GoogleCloudRetailV2alphaCustomAttribute `json:"attributes,omitempty"`

	// AttributionToken: Highly recommended for user events that are the
	// result of PredictionService.Predict. This field enables accurate
	// attribution of recommendation model performance. The value must be a
	// valid PredictResponse.attribution_token for user events that are the
	// result of PredictionService.Predict. This token enables us to
	// accurately attribute page view or purchase back to the event and the
	// particular predict response containing this clicked/purchased
	// product. If user clicks on product K in the recommendation results,
	// pass PredictResponse.attribution_token as a URL parameter to product
	// K's page. When recording events on product K's page, log the
	// PredictResponse.attribution_token to this field.
	AttributionToken string `json:"attributionToken,omitempty"`

	// CartId: The id or name of the associated shopping cart. This id is
	// used to associate multiple items added or present in the cart before
	// purchase. This can only be set for `add-to-cart`,
	// `purchase-complete`, or `shopping-cart-page-view` events.
	CartId string `json:"cartId,omitempty"`

	// EventTime: Only required for UserEventService.ImportUserEvents
	// method. Timestamp of when the user event happened.
	EventTime string `json:"eventTime,omitempty"`

	// EventType: Required. User event type. Allowed values are: *
	// `add-to-cart`: Products being added to cart. * `category-page-view`:
	// Special pages such as sale or promotion pages viewed. *
	// `detail-page-view`: Products detail page viewed. * `home-page-view`:
	// Homepage viewed. * `promotion-offered`: Promotion is offered to a
	// user. * `promotion-not-offered`: Promotion is not offered to a user.
	// * `purchase-complete`: User finishing a purchase. * `search`: Product
	// search. * `shopping-cart-page-view`: User viewing a shopping cart.
	EventType string `json:"eventType,omitempty"`

	// ExperimentIds: A list of identifiers for the independent experiment
	// groups this user event belongs to. This is used to distinguish
	// between user events associated with different experiment setups (e.g.
	// using Retail API, using different recommendation models).
	ExperimentIds []string `json:"experimentIds,omitempty"`

	// PageCategories: The categories associated with a category page. To
	// represent full path of category, use '>' sign to separate different
	// hierarchies. If '>' is part of the category name, please replace it
	// with other character(s). Category pages include special pages such as
	// sales or promotions. For instance, a special sale page may have the
	// category hierarchy: "pageCategories" : ["Sales > 2017 Black Friday
	// Deals"]. Required for `category-page-view` events. At least one of
	// search_query or page_categories is required for `search` events.
	// Other event types should not set this field. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	PageCategories []string `json:"pageCategories,omitempty"`

	// PageViewId: A unique id of a web page view. This should be kept the
	// same for all user events triggered from the same pageview. For
	// example, an item detail page view could trigger multiple events as
	// the user is browsing the page. The `pageViewId` property should be
	// kept the same for all these events so that they can be grouped
	// together properly. When using the client side event reporting with
	// JavaScript pixel and Google Tag Manager, this value is filled in
	// automatically.
	PageViewId string `json:"pageViewId,omitempty"`

	// ProductDetails: The main product details related to the event. This
	// field is required for the following event types: * `add-to-cart` *
	// `detail-page-view` * `purchase-complete` In a `search` event, this
	// field represents the products returned to the end user on the current
	// page (the end user may have not finished broswing the whole page
	// yet). When a new page is returned to the end user, after
	// pagination/filtering/ordering even for the same query, a new `search`
	// event with different product_details is desired. The end user may
	// have not finished broswing the whole page yet.
	ProductDetails []*GoogleCloudRetailV2alphaProductDetail `json:"productDetails,omitempty"`

	// PurchaseTransaction: A transaction represents the entire purchase
	// transaction. Required for `purchase-complete` events. Other event
	// types should not set this field. Otherwise, an INVALID_ARGUMENT error
	// is returned.
	PurchaseTransaction *GoogleCloudRetailV2alphaPurchaseTransaction `json:"purchaseTransaction,omitempty"`

	// ReferrerUri: The referrer URL of the current page. When using the
	// client side event reporting with JavaScript pixel and Google Tag
	// Manager, this value is filled in automatically.
	ReferrerUri string `json:"referrerUri,omitempty"`

	// SearchQuery: The user's search query. The value must be a UTF-8
	// encoded string with a length limit of 5,000 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. At least one of search_query or
	// page_categories is required for `search` events. Other event types
	// should not set this field. Otherwise, an INVALID_ARGUMENT error is
	// returned.
	SearchQuery string `json:"searchQuery,omitempty"`

	// Uri: Complete URL (window.location.href) of the user's current page.
	// When using the client side event reporting with JavaScript pixel and
	// Google Tag Manager, this value is filled in automatically. Maximum
	// length 5,000 characters.
	Uri string `json:"uri,omitempty"`

	// UserInfo: User information.
	UserInfo *GoogleCloudRetailV2alphaUserInfo `json:"userInfo,omitempty"`

	// VisitorId: Required. A unique identifier for tracking visitors. For
	// example, this could be implemented with an HTTP cookie, which should
	// be able to uniquely identify a visitor on a single device. This
	// unique identifier should not change if the visitor log in/out of the
	// website. The field must be a UTF-8 encoded string with a length limit
	// of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
	VisitorId string `json:"visitorId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attributes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaUserEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaUserEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaUserEventImportSummary: A summary of import
// result. The UserEventImportSummary summarizes the import status for
// user events.
type GoogleCloudRetailV2alphaUserEventImportSummary struct {
	// JoinedEventsCount: Count of user events imported with complete
	// existing catalog information.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`

	// UnjoinedEventsCount: Count of user events imported, but with catalog
	// information not found in the imported catalog.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "JoinedEventsCount")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "JoinedEventsCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaUserEventImportSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaUserEventImportSummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaUserEventInlineSource: The inline source for
// the input config for ImportUserEvents method.
type GoogleCloudRetailV2alphaUserEventInlineSource struct {
	// UserEvents: Required. A list of user events to import. Recommended
	// max of 10k items.
	UserEvents []*GoogleCloudRetailV2alphaUserEvent `json:"userEvents,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UserEvents") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserEvents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaUserEventInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaUserEventInlineSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaUserEventInputConfig: The input config source
// for user events.
type GoogleCloudRetailV2alphaUserEventInputConfig struct {
	// BigQuerySource: Required. BigQuery input source.
	BigQuerySource *GoogleCloudRetailV2alphaBigQuerySource `json:"bigQuerySource,omitempty"`

	// GcsSource: Required. Google Cloud Storage location for the input
	// content.
	GcsSource *GoogleCloudRetailV2alphaGcsSource `json:"gcsSource,omitempty"`

	// UserEventInlineSource: Required. The Inline source for the input
	// content for UserEvents.
	UserEventInlineSource *GoogleCloudRetailV2alphaUserEventInlineSource `json:"userEventInlineSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigQuerySource") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigQuerySource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaUserEventInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaUserEventInputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaUserInfo: Information of an end user.
type GoogleCloudRetailV2alphaUserInfo struct {
	// DirectUserRequest: True if the request is made directly from the end
	// user, in which case the ip_address and user_agent can be populated
	// from the HTTP request. This flag should be set only if the API
	// request is made directly from the end user such as a mobile app (and
	// not if a gateway or a server is processing and pushing the user
	// events). This should not be set when using the JavaScript tag in
	// UserEventService.CollectUserEvent.
	DirectUserRequest bool `json:"directUserRequest,omitempty"`

	// IpAddress: The end user's IP address. This field is used to extract
	// location information for personalization. This field must be either
	// an IPv4 address (e.g. "104.133.9.80") or an IPv6 address (e.g.
	// "2001:0db8:85a3:0000:0000:8a2e:0370:7334"). Otherwise, an
	// INVALID_ARGUMENT error is returned. This should not be set when using
	// the JavaScript tag in UserEventService.CollectUserEvent or if
	// direct_user_request is set.
	IpAddress string `json:"ipAddress,omitempty"`

	// UserAgent: User agent as included in the HTTP header. The field must
	// be a UTF-8 encoded string with a length limit of 1,000 characters.
	// Otherwise, an INVALID_ARGUMENT error is returned. This should not be
	// set when using the client side event reporting with GTM or JavaScript
	// tag in UserEventService.CollectUserEvent or if direct_user_request is
	// set.
	UserAgent string `json:"userAgent,omitempty"`

	// UserId: Highly recommended for logged-in users. Unique identifier for
	// logged-in user, such as a user name. The field must be a UTF-8
	// encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	UserId string `json:"userId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DirectUserRequest")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DirectUserRequest") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaUserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaUserInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaExportErrorsConfig: Configuration of
// destination for Export related errors.
type GoogleCloudRetailV2betaExportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage path for import errors. This must be
	// an empty, existing Cloud Storage bucket. Export errors will be
	// written to a file in this bucket, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaExportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaExportErrorsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaExportMetadata: Metadata related to the
// progress of the Export operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2betaExportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaExportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaExportMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaExportProductsResponse: Response of the
// ExportProductsRequest. If the long running operation is done, then
// this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2betaExportProductsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorsConfig *GoogleCloudRetailV2betaExportErrorsConfig `json:"errorsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaExportProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaExportProductsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaExportUserEventsResponse: Response of the
// ExportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2betaExportUserEventsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorsConfig *GoogleCloudRetailV2betaExportErrorsConfig `json:"errorsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaExportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaExportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaImportErrorsConfig: Configuration of
// destination for Import related errors.
type GoogleCloudRetailV2betaImportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage path for import errors. This must be
	// an empty, existing Cloud Storage bucket. Import errors will be
	// written to a file in this bucket, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaImportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaImportErrorsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaImportMetadata: Metadata related to the
// progress of the Import operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2betaImportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaImportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaImportMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaImportProductsResponse: Response of the
// ImportProductsRequest. If the long running operation is done, then
// this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2betaImportProductsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorsConfig *GoogleCloudRetailV2betaImportErrorsConfig `json:"errorsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaImportProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaImportProductsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2betaImportUserEventsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorsConfig *GoogleCloudRetailV2betaImportErrorsConfig `json:"errorsConfig,omitempty"`

	// ImportSummary: Aggregated statistics of user event import status.
	ImportSummary *GoogleCloudRetailV2betaUserEventImportSummary `json:"importSummary,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaImportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaPurgeMetadata: Metadata related to the
// progress of the Purge operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2betaPurgeMetadata struct {
}

// GoogleCloudRetailV2betaPurgeUserEventsResponse: Response of the
// PurgeUserEventsRequest. If the long running operation is successfully
// done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudRetailV2betaPurgeUserEventsResponse struct {
	// PurgedEventsCount: The total count of events purged as a result of
	// the operation.
	PurgedEventsCount int64 `json:"purgedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "PurgedEventsCount")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PurgedEventsCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaPurgeUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaPurgeUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaRejoinUserEventsMetadata: Metadata for
// RejoinUserEvents method.
type GoogleCloudRetailV2betaRejoinUserEventsMetadata struct {
}

// GoogleCloudRetailV2betaRejoinUserEventsResponse: Response message for
// RejoinUserEvents method.
type GoogleCloudRetailV2betaRejoinUserEventsResponse struct {
	// RejoinedUserEventsCount: Number of user events that were joined with
	// latest product catalog.
	RejoinedUserEventsCount int64 `json:"rejoinedUserEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "RejoinedUserEventsCount") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RejoinedUserEventsCount")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaRejoinUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaRejoinUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaUserEventImportSummary: A summary of import
// result. The UserEventImportSummary summarizes the import status for
// user events.
type GoogleCloudRetailV2betaUserEventImportSummary struct {
	// JoinedEventsCount: Count of user events imported with complete
	// existing catalog information.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`

	// UnjoinedEventsCount: Count of user events imported, but with catalog
	// information not found in the imported catalog.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "JoinedEventsCount")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "JoinedEventsCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaUserEventImportSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaUserEventImportSummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal response of the operation in case of success. If
	// the original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to
// avoid defining duplicated empty messages in your APIs. A typical
// example is to use it as the request or the response type of an API
// method. For instance: service Foo { rpc Bar(google.protobuf.Empty)
// returns (google.protobuf.Empty); } The JSON representation for
// `Empty` is empty JSON object `{}`.
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that
// is suitable for different programming environments, including REST
// APIs and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "retail.projects.locations.catalogs.list":

type ProjectsLocationsCatalogsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the Catalogs associated with the project.
func (r *ProjectsLocationsCatalogsService) List(parent string) *ProjectsLocationsCatalogsListCall {
	c := &ProjectsLocationsCatalogsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// Catalogs to return. If unspecified, defaults to 50. The maximum
// allowed value is 1000. Values above 1000 will be coerced to 1000. If
// this field is negative, an INVALID_ARGUMENT is returned.
func (c *ProjectsLocationsCatalogsListCall) PageSize(pageSize int64) *ProjectsLocationsCatalogsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// ListCatalogsResponse.next_page_token, received from a previous
// CatalogService.ListCatalogs call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// CatalogService.ListCatalogs must match the call that provided the
// page token. Otherwise, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCatalogsListCall) PageToken(pageToken string) *ProjectsLocationsCatalogsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCatalogsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsListCall) Context(ctx context.Context) *ProjectsLocationsCatalogsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/catalogs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.list" call.
// Exactly one of *GoogleCloudRetailV2alphaListCatalogsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudRetailV2alphaListCatalogsResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCatalogsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaListCatalogsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2alphaListCatalogsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the Catalogs associated with the project.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.catalogs.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Maximum number of Catalogs to return. If unspecified, defaults to 50. The maximum allowed value is 1000. Values above 1000 will be coerced to 1000. If this field is negative, an INVALID_ARGUMENT is returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token ListCatalogsResponse.next_page_token, received from a previous CatalogService.ListCatalogs call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to CatalogService.ListCatalogs must match the call that provided the page token. Otherwise, an INVALID_ARGUMENT error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The account resource name with an associated location. If the caller does not have permission to list Catalogs under this location, regardless of whether or not this location exists, a PERMISSION_DENIED error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+parent}/catalogs",
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2alphaListCatalogsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCatalogsListCall) Pages(ctx context.Context, f func(*GoogleCloudRetailV2alphaListCatalogsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "retail.projects.locations.catalogs.patch":

type ProjectsLocationsCatalogsPatchCall struct {
	s                               *Service
	name                            string
	googlecloudretailv2alphacatalog *GoogleCloudRetailV2alphaCatalog
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Patch: Updates the Catalogs.
func (r *ProjectsLocationsCatalogsService) Patch(name string, googlecloudretailv2alphacatalog *GoogleCloudRetailV2alphaCatalog) *ProjectsLocationsCatalogsPatchCall {
	c := &ProjectsLocationsCatalogsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2alphacatalog = googlecloudretailv2alphacatalog
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which
// fields in the provided Catalog to update. If not set, will only
// update the Catalog.product_level_config field, which is also the only
// currently supported field to update. If an unsupported or unknown
// field is provided, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCatalogsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCatalogsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsPatchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphacatalog)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.patch" call.
// Exactly one of *GoogleCloudRetailV2alphaCatalog or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRetailV2alphaCatalog.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaCatalog, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2alphaCatalog{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the Catalogs.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}",
	//   "httpMethod": "PATCH",
	//   "id": "retail.projects.locations.catalogs.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Immutable. The fully qualified resource name of the catalog.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Indicates which fields in the provided Catalog to update. If not set, will only update the Catalog.product_level_config field, which is also the only currently supported field to update. If an unsupported or unknown field is provided, an INVALID_ARGUMENT error is returned.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2alphaCatalog"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2alphaCatalog"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.branches.operations.get":

type ProjectsLocationsCatalogsBranchesOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
func (r *ProjectsLocationsCatalogsBranchesOperationsService) Get(name string) *ProjectsLocationsCatalogsBranchesOperationsGetCall {
	c := &ProjectsLocationsCatalogsBranchesOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsBranchesOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.catalogs.branches.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.branches.products.create":

type ProjectsLocationsCatalogsBranchesProductsCreateCall struct {
	s                               *Service
	parent                          string
	googlecloudretailv2alphaproduct *GoogleCloudRetailV2alphaProduct
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Create: Creates a Product.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Create(parent string, googlecloudretailv2alphaproduct *GoogleCloudRetailV2alphaProduct) *ProjectsLocationsCatalogsBranchesProductsCreateCall {
	c := &ProjectsLocationsCatalogsBranchesProductsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphaproduct = googlecloudretailv2alphaproduct
	return c
}

// ProductId sets the optional parameter "productId": Required. The ID
// to use for the Product, which will become the final component of the
// Product.name. If the caller does not have permission to create the
// Product, regardless of whether or not it exists, a PERMISSION_DENIED
// error is returned. This field must be unique among all Products with
// the same parent. Otherwise, an ALREADY_EXISTS error is returned. This
// field must be a UTF-8 encoded string with a length limit of 128
// characters. Otherwise, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) ProductId(productId string) *ProjectsLocationsCatalogsBranchesProductsCreateCall {
	c.urlParams_.Set("productId", productId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaproduct)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/products")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.create" call.
// Exactly one of *GoogleCloudRetailV2alphaProduct or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRetailV2alphaProduct.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaProduct, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2alphaProduct{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a Product.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/products",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.branches.products.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent catalog resource name, such as `projects/*/locations/global/catalogs/default_catalog/branches/default_branch`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The ID to use for the Product, which will become the final component of the Product.name. If the caller does not have permission to create the Product, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. This field must be unique among all Products with the same parent. Otherwise, an ALREADY_EXISTS error is returned. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+parent}/products",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2alphaProduct"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2alphaProduct"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.branches.products.delete":

type ProjectsLocationsCatalogsBranchesProductsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Product.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Delete(name string) *ProjectsLocationsCatalogsBranchesProductsDeleteCall {
	c := &ProjectsLocationsCatalogsBranchesProductsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a Product.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/products/{productsId}",
	//   "httpMethod": "DELETE",
	//   "id": "retail.projects.locations.catalogs.branches.products.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of Product, such as `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`. If the caller does not have permission to delete the Product, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. If the Product to delete does not exist, a NOT_FOUND error is returned. The Product to delete can neither be a Product.Type.COLLECTION Product member nor a Product.Type.PRIMARY Product with more than one variants. Otherwise, an INVALID_ARGUMENT error is returned. All inventory information for the named Product will be deleted.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+/products/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.branches.products.get":

type ProjectsLocationsCatalogsBranchesProductsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Product.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Get(name string) *ProjectsLocationsCatalogsBranchesProductsGetCall {
	c := &ProjectsLocationsCatalogsBranchesProductsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsBranchesProductsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.get" call.
// Exactly one of *GoogleCloudRetailV2alphaProduct or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRetailV2alphaProduct.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaProduct, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2alphaProduct{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a Product.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/products/{productsId}",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.catalogs.branches.products.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of Product, such as `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`. If the caller does not have permission to access the Product, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. If the requested Product does not exist, a NOT_FOUND error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+/products/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2alphaProduct"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.branches.products.import":

type ProjectsLocationsCatalogsBranchesProductsImportCall struct {
	s                                             *Service
	parent                                        string
	googlecloudretailv2alphaimportproductsrequest *GoogleCloudRetailV2alphaImportProductsRequest
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Import: Bulk import of multiple Products. Request processing may be
// synchronous. No partial updating is supported. Non-existing items are
// created. Note that it is possible for a subset of the Products to be
// successfully updated.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Import(parent string, googlecloudretailv2alphaimportproductsrequest *GoogleCloudRetailV2alphaImportProductsRequest) *ProjectsLocationsCatalogsBranchesProductsImportCall {
	c := &ProjectsLocationsCatalogsBranchesProductsImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphaimportproductsrequest = googlecloudretailv2alphaimportproductsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesProductsImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesProductsImportCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaimportproductsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/products:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.import" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Bulk import of multiple Products. Request processing may be synchronous. No partial updating is supported. Non-existing items are created. Note that it is possible for a subset of the Products to be successfully updated.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/products:import",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.branches.products.import",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. `projects/1234/locations/global/catalogs/default_catalog/branches/default_branch` If no updateMask is specified, requires products.create permission. If updateMask is specified, requires products.update permission.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+parent}/products:import",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2alphaImportProductsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.branches.products.patch":

type ProjectsLocationsCatalogsBranchesProductsPatchCall struct {
	s                               *Service
	name                            string
	googlecloudretailv2alphaproduct *GoogleCloudRetailV2alphaProduct
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Patch: Updates a Product.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Patch(name string, googlecloudretailv2alphaproduct *GoogleCloudRetailV2alphaProduct) *ProjectsLocationsCatalogsBranchesProductsPatchCall {
	c := &ProjectsLocationsCatalogsBranchesProductsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2alphaproduct = googlecloudretailv2alphaproduct
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the Product is not found, a new Product will be created. In
// this situation, `update_mask` is ignored.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsCatalogsBranchesProductsPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which
// fields in the provided Product to update. The immutable and output
// only fields are NOT supported. If not set, all supported fields (the
// fields that are neither immutable nor output only) are updated. If an
// unsupported or unknown field is provided, an INVALID_ARGUMENT error
// is returned.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCatalogsBranchesProductsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaproduct)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.patch" call.
// Exactly one of *GoogleCloudRetailV2alphaProduct or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRetailV2alphaProduct.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaProduct, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2alphaProduct{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a Product.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/products/{productsId}",
	//   "httpMethod": "PATCH",
	//   "id": "retail.projects.locations.catalogs.branches.products.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the Product is not found, a new Product will be created. In this situation, `update_mask` is ignored.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Immutable. Full resource name of the product, such as `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`. The branch ID must be \"default_branch\".",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+/products/.*$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Indicates which fields in the provided Product to update. The immutable and output only fields are NOT supported. If not set, all supported fields (the fields that are neither immutable nor output only) are updated. If an unsupported or unknown field is provided, an INVALID_ARGUMENT error is returned.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2alphaProduct"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2alphaProduct"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.operations.get":

type ProjectsLocationsCatalogsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
func (r *ProjectsLocationsCatalogsOperationsService) Get(name string) *ProjectsLocationsCatalogsOperationsGetCall {
	c := &ProjectsLocationsCatalogsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCatalogsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCatalogsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.catalogs.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.operations.list":

type ProjectsLocationsCatalogsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to
// override the binding to use different resource name schemes, such as
// `users/*/operations`. To override the binding, API services can add a
// binding such as "/v1/{name=users/*}/operations" to their service
// configuration. For backwards compatibility, the default name includes
// the operations collection id, however overriding users must ensure
// the name binding is the parent resource, without the operations
// collection id.
func (r *ProjectsLocationsCatalogsOperationsService) List(name string) *ProjectsLocationsCatalogsOperationsListCall {
	c := &ProjectsLocationsCatalogsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsCatalogsOperationsListCall) Filter(filter string) *ProjectsLocationsCatalogsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsCatalogsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCatalogsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsCatalogsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCatalogsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCatalogsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCatalogsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to override the binding to use different resource name schemes, such as `users/*/operations`. To override the binding, API services can add a binding such as `\"/v1/{name=users/*}/operations\"` to their service configuration. For backwards compatibility, the default name includes the operations collection id, however overriding users must ensure the name binding is the parent resource, without the operations collection id.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.catalogs.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCatalogsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "retail.projects.locations.catalogs.placements.predict":

type ProjectsLocationsCatalogsPlacementsPredictCall struct {
	s                                      *Service
	placement                              string
	googlecloudretailv2alphapredictrequest *GoogleCloudRetailV2alphaPredictRequest
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Predict: Makes a recommendation prediction.
func (r *ProjectsLocationsCatalogsPlacementsService) Predict(placement string, googlecloudretailv2alphapredictrequest *GoogleCloudRetailV2alphaPredictRequest) *ProjectsLocationsCatalogsPlacementsPredictCall {
	c := &ProjectsLocationsCatalogsPlacementsPredictCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.placement = placement
	c.googlecloudretailv2alphapredictrequest = googlecloudretailv2alphapredictrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsPlacementsPredictCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsPlacementsPredictCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsPlacementsPredictCall) Context(ctx context.Context) *ProjectsLocationsCatalogsPlacementsPredictCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsPlacementsPredictCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsPlacementsPredictCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphapredictrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+placement}:predict")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"placement": c.placement,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.placements.predict" call.
// Exactly one of *GoogleCloudRetailV2alphaPredictResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRetailV2alphaPredictResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsPlacementsPredictCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaPredictResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2alphaPredictResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Makes a recommendation prediction.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/placements/{placementsId}:predict",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.placements.predict",
	//   "parameterOrder": [
	//     "placement"
	//   ],
	//   "parameters": {
	//     "placement": {
	//       "description": "Required. Full resource name of the format: {name=projects/*/locations/global/catalogs/default_catalog/placements/*} The ID of the Recommendations AI placement. Before you can request predictions from your model, you must create at least one placement for it. For more information, see [Managing placements](https://cloud.google.com/retail/recommendations-ai/docs/manage-placements). The full list of available placements can be seen at https://console.cloud.google.com/recommendation/catalogs/default_catalog/placements",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/placements/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+placement}:predict",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2alphaPredictRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2alphaPredictResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.userEvents.collect":

type ProjectsLocationsCatalogsUserEventsCollectCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Collect: Writes a single user event from the browser. This uses a GET
// request to due to browser restriction of POST-ing to a 3rd party
// domain. This method is used only by the Retail API JavaScript pixel
// and Google Tag Manager. Users should not call this method directly.
func (r *ProjectsLocationsCatalogsUserEventsService) Collect(parent string) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c := &ProjectsLocationsCatalogsUserEventsCollectCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Ets sets the optional parameter "ets": The event timestamp in
// milliseconds. This prevents browser caching of otherwise identical
// get requests. The name is abbreviated to reduce the payload bytes.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Ets(ets int64) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.urlParams_.Set("ets", fmt.Sprint(ets))
	return c
}

// Uri sets the optional parameter "uri": The URL including
// cgi-parameters but excluding the hash fragment with a length limit of
// 5,000 characters. This is often more useful than the referer URL,
// because many browsers only send the domain for 3rd party requests.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Uri(uri string) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.urlParams_.Set("uri", uri)
	return c
}

// UserEvent sets the optional parameter "userEvent": Required. URL
// encoded UserEvent proto with a length limit of 2,000,000 characters.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) UserEvent(userEvent string) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.urlParams_.Set("userEvent", userEvent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsCollectCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/userEvents:collect")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.collect" call.
// Exactly one of *GoogleApiHttpBody or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleApiHttpBody.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Do(opts ...googleapi.CallOption) (*GoogleApiHttpBody, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleApiHttpBody{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Writes a single user event from the browser. This uses a GET request to due to browser restriction of POST-ing to a 3rd party domain. This method is used only by the Retail API JavaScript pixel and Google Tag Manager. Users should not call this method directly.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/userEvents:collect",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.catalogs.userEvents.collect",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "ets": {
	//       "description": "The event timestamp in milliseconds. This prevents browser caching of otherwise identical get requests. The name is abbreviated to reduce the payload bytes.",
	//       "format": "int64",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent catalog name, such as `projects/1234/locations/global/catalogs/default_catalog`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "uri": {
	//       "description": "The URL including cgi-parameters but excluding the hash fragment with a length limit of 5,000 characters. This is often more useful than the referer URL, because many browsers only send the domain for 3rd party requests.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "userEvent": {
	//       "description": "Required. URL encoded UserEvent proto with a length limit of 2,000,000 characters.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+parent}/userEvents:collect",
	//   "response": {
	//     "$ref": "GoogleApiHttpBody"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.userEvents.import":

type ProjectsLocationsCatalogsUserEventsImportCall struct {
	s                                               *Service
	parent                                          string
	googlecloudretailv2alphaimportusereventsrequest *GoogleCloudRetailV2alphaImportUserEventsRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Import: Bulk import of User events. Request processing might be
// synchronous. Events that already exist are skipped. Use this method
// for backfilling historical user events. Operation.response is of type
// ImportResponse. Note that it is possible for a subset of the items to
// be successfully inserted. Operation.metadata is of type
// ImportMetadata.
func (r *ProjectsLocationsCatalogsUserEventsService) Import(parent string, googlecloudretailv2alphaimportusereventsrequest *GoogleCloudRetailV2alphaImportUserEventsRequest) *ProjectsLocationsCatalogsUserEventsImportCall {
	c := &ProjectsLocationsCatalogsUserEventsImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphaimportusereventsrequest = googlecloudretailv2alphaimportusereventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsUserEventsImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsUserEventsImportCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaimportusereventsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/userEvents:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.import" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUserEventsImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Bulk import of User events. Request processing might be synchronous. Events that already exist are skipped. Use this method for backfilling historical user events. Operation.response is of type ImportResponse. Note that it is possible for a subset of the items to be successfully inserted. Operation.metadata is of type ImportMetadata.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/userEvents:import",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.userEvents.import",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. `projects/1234/locations/global/catalogs/default_catalog`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+parent}/userEvents:import",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2alphaImportUserEventsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.userEvents.purge":

type ProjectsLocationsCatalogsUserEventsPurgeCall struct {
	s                                              *Service
	parent                                         string
	googlecloudretailv2alphapurgeusereventsrequest *GoogleCloudRetailV2alphaPurgeUserEventsRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Purge: Deletes permanently all user events specified by the filter
// provided. Depending on the number of events specified by the filter,
// this operation could take hours or days to complete. To test a
// filter, use the list command first.
func (r *ProjectsLocationsCatalogsUserEventsService) Purge(parent string, googlecloudretailv2alphapurgeusereventsrequest *GoogleCloudRetailV2alphaPurgeUserEventsRequest) *ProjectsLocationsCatalogsUserEventsPurgeCall {
	c := &ProjectsLocationsCatalogsUserEventsPurgeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphapurgeusereventsrequest = googlecloudretailv2alphapurgeusereventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsUserEventsPurgeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsPurgeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsUserEventsPurgeCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsPurgeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsPurgeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsPurgeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphapurgeusereventsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/userEvents:purge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.purge" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUserEventsPurgeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes permanently all user events specified by the filter provided. Depending on the number of events specified by the filter, this operation could take hours or days to complete. To test a filter, use the list command first.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/userEvents:purge",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.userEvents.purge",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The resource name of the catalog under which the events are created. The format is `projects/${projectId}/locations/global/catalogs/${catalogId}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+parent}/userEvents:purge",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2alphaPurgeUserEventsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.userEvents.rejoin":

type ProjectsLocationsCatalogsUserEventsRejoinCall struct {
	s                                               *Service
	parent                                          string
	googlecloudretailv2alpharejoinusereventsrequest *GoogleCloudRetailV2alphaRejoinUserEventsRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Rejoin: Triggers a user event rejoin operation with latest product
// catalog. Events will not be annotated with detailed product
// information if product is missing from the catalog at the time the
// user event is ingested, and these events are stored as unjoined
// events with a limited usage on training and serving. This API can be
// used to trigger a 'join' operation on specified events with latest
// version of product catalog. It can also be used to correct events
// joined with wrong product catalog.
func (r *ProjectsLocationsCatalogsUserEventsService) Rejoin(parent string, googlecloudretailv2alpharejoinusereventsrequest *GoogleCloudRetailV2alphaRejoinUserEventsRequest) *ProjectsLocationsCatalogsUserEventsRejoinCall {
	c := &ProjectsLocationsCatalogsUserEventsRejoinCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alpharejoinusereventsrequest = googlecloudretailv2alpharejoinusereventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsUserEventsRejoinCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsRejoinCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsUserEventsRejoinCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsRejoinCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsRejoinCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsRejoinCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alpharejoinusereventsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/userEvents:rejoin")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.rejoin" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUserEventsRejoinCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Triggers a user event rejoin operation with latest product catalog. Events will not be annotated with detailed product information if product is missing from the catalog at the time the user event is ingested, and these events are stored as unjoined events with a limited usage on training and serving. This API can be used to trigger a 'join' operation on specified events with latest version of product catalog. It can also be used to correct events joined with wrong product catalog.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/userEvents:rejoin",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.userEvents.rejoin",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent catalog resource name, such as `projects/1234/locations/global/catalogs/default_catalog`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+parent}/userEvents:rejoin",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2alphaRejoinUserEventsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.userEvents.write":

type ProjectsLocationsCatalogsUserEventsWriteCall struct {
	s                                 *Service
	parent                            string
	googlecloudretailv2alphauserevent *GoogleCloudRetailV2alphaUserEvent
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Write: Writes a single user event.
func (r *ProjectsLocationsCatalogsUserEventsService) Write(parent string, googlecloudretailv2alphauserevent *GoogleCloudRetailV2alphaUserEvent) *ProjectsLocationsCatalogsUserEventsWriteCall {
	c := &ProjectsLocationsCatalogsUserEventsWriteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphauserevent = googlecloudretailv2alphauserevent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsUserEventsWriteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsWriteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsUserEventsWriteCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsWriteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsWriteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsWriteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphauserevent)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/userEvents:write")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.write" call.
// Exactly one of *GoogleCloudRetailV2alphaUserEvent or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRetailV2alphaUserEvent.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCatalogsUserEventsWriteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaUserEvent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2alphaUserEvent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Writes a single user event.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/userEvents:write",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.userEvents.write",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent catalog resource name, such as `projects/1234/locations/global/catalogs/default_catalog`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+parent}/userEvents:write",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2alphaUserEvent"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2alphaUserEvent"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.operations.get":

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.operations.list":

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to
// override the binding to use different resource name schemes, such as
// `users/*/operations`. To override the binding, API services can add a
// binding such as "/v1/{name=users/*}/operations" to their service
// configuration. For backwards compatibility, the default name includes
// the operations collection id, however overriding users must ensure
// the name binding is the parent resource, without the operations
// collection id.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210322")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to override the binding to use different resource name schemes, such as `users/*/operations`. To override the binding, API services can add a binding such as `\"/v1/{name=users/*}/operations\"` to their service configuration. For backwards compatibility, the default name includes the operations collection id, however overriding users must ensure the name binding is the parent resource, without the operations collection id.",
	//   "flatPath": "v2alpha/projects/{projectsId}/locations/{locationsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2alpha/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
