package eventgrid

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/eventgrid/mgmt/2020-04-01-preview/eventgrid"

// BasicAdvancedFilter this is the base type that represents an advanced filter. To configure an advanced filter, do
// not directly instantiate an object of this class. Instead, instantiate an object of a derived class such as
// BoolEqualsAdvancedFilter, NumberInAdvancedFilter, StringEqualsAdvancedFilter etc. depending on the type of the key
// based on which you want to filter.
type BasicAdvancedFilter interface {
	AsNumberInAdvancedFilter() (*NumberInAdvancedFilter, bool)
	AsNumberNotInAdvancedFilter() (*NumberNotInAdvancedFilter, bool)
	AsNumberLessThanAdvancedFilter() (*NumberLessThanAdvancedFilter, bool)
	AsNumberGreaterThanAdvancedFilter() (*NumberGreaterThanAdvancedFilter, bool)
	AsNumberLessThanOrEqualsAdvancedFilter() (*NumberLessThanOrEqualsAdvancedFilter, bool)
	AsNumberGreaterThanOrEqualsAdvancedFilter() (*NumberGreaterThanOrEqualsAdvancedFilter, bool)
	AsBoolEqualsAdvancedFilter() (*BoolEqualsAdvancedFilter, bool)
	AsStringInAdvancedFilter() (*StringInAdvancedFilter, bool)
	AsStringNotInAdvancedFilter() (*StringNotInAdvancedFilter, bool)
	AsStringBeginsWithAdvancedFilter() (*StringBeginsWithAdvancedFilter, bool)
	AsStringEndsWithAdvancedFilter() (*StringEndsWithAdvancedFilter, bool)
	AsStringContainsAdvancedFilter() (*StringContainsAdvancedFilter, bool)
	AsAdvancedFilter() (*AdvancedFilter, bool)
}

// AdvancedFilter this is the base type that represents an advanced filter. To configure an advanced filter, do
// not directly instantiate an object of this class. Instead, instantiate an object of a derived class such as
// BoolEqualsAdvancedFilter, NumberInAdvancedFilter, StringEqualsAdvancedFilter etc. depending on the type of
// the key based on which you want to filter.
type AdvancedFilter struct {
	// Key - The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
	// OperatorType - Possible values include: 'OperatorTypeAdvancedFilter', 'OperatorTypeNumberIn', 'OperatorTypeNumberNotIn', 'OperatorTypeNumberLessThan', 'OperatorTypeNumberGreaterThan', 'OperatorTypeNumberLessThanOrEquals', 'OperatorTypeNumberGreaterThanOrEquals', 'OperatorTypeBoolEquals', 'OperatorTypeStringIn', 'OperatorTypeStringNotIn', 'OperatorTypeStringBeginsWith', 'OperatorTypeStringEndsWith', 'OperatorTypeStringContains'
	OperatorType OperatorType `json:"operatorType,omitempty"`
}

func unmarshalBasicAdvancedFilter(body []byte) (BasicAdvancedFilter, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["operatorType"] {
	case string(OperatorTypeNumberIn):
		var niaf NumberInAdvancedFilter
		err := json.Unmarshal(body, &niaf)
		return niaf, err
	case string(OperatorTypeNumberNotIn):
		var nniaf NumberNotInAdvancedFilter
		err := json.Unmarshal(body, &nniaf)
		return nniaf, err
	case string(OperatorTypeNumberLessThan):
		var nltaf NumberLessThanAdvancedFilter
		err := json.Unmarshal(body, &nltaf)
		return nltaf, err
	case string(OperatorTypeNumberGreaterThan):
		var ngtaf NumberGreaterThanAdvancedFilter
		err := json.Unmarshal(body, &ngtaf)
		return ngtaf, err
	case string(OperatorTypeNumberLessThanOrEquals):
		var nltoeaf NumberLessThanOrEqualsAdvancedFilter
		err := json.Unmarshal(body, &nltoeaf)
		return nltoeaf, err
	case string(OperatorTypeNumberGreaterThanOrEquals):
		var ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter
		err := json.Unmarshal(body, &ngtoeaf)
		return ngtoeaf, err
	case string(OperatorTypeBoolEquals):
		var beaf BoolEqualsAdvancedFilter
		err := json.Unmarshal(body, &beaf)
		return beaf, err
	case string(OperatorTypeStringIn):
		var siaf StringInAdvancedFilter
		err := json.Unmarshal(body, &siaf)
		return siaf, err
	case string(OperatorTypeStringNotIn):
		var sniaf StringNotInAdvancedFilter
		err := json.Unmarshal(body, &sniaf)
		return sniaf, err
	case string(OperatorTypeStringBeginsWith):
		var sbwaf StringBeginsWithAdvancedFilter
		err := json.Unmarshal(body, &sbwaf)
		return sbwaf, err
	case string(OperatorTypeStringEndsWith):
		var sewaf StringEndsWithAdvancedFilter
		err := json.Unmarshal(body, &sewaf)
		return sewaf, err
	case string(OperatorTypeStringContains):
		var scaf StringContainsAdvancedFilter
		err := json.Unmarshal(body, &scaf)
		return scaf, err
	default:
		var af AdvancedFilter
		err := json.Unmarshal(body, &af)
		return af, err
	}
}
func unmarshalBasicAdvancedFilterArray(body []byte) ([]BasicAdvancedFilter, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	afArray := make([]BasicAdvancedFilter, len(rawMessages))

	for index, rawMessage := range rawMessages {
		af, err := unmarshalBasicAdvancedFilter(*rawMessage)
		if err != nil {
			return nil, err
		}
		afArray[index] = af
	}
	return afArray, nil
}

// MarshalJSON is the custom marshaler for AdvancedFilter.
func (af AdvancedFilter) MarshalJSON() ([]byte, error) {
	af.OperatorType = OperatorTypeAdvancedFilter
	objectMap := make(map[string]interface{})
	if af.Key != nil {
		objectMap["key"] = af.Key
	}
	if af.OperatorType != "" {
		objectMap["operatorType"] = af.OperatorType
	}
	return json.Marshal(objectMap)
}

// AsNumberInAdvancedFilter is the BasicAdvancedFilter implementation for AdvancedFilter.
func (af AdvancedFilter) AsNumberInAdvancedFilter() (*NumberInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberNotInAdvancedFilter is the BasicAdvancedFilter implementation for AdvancedFilter.
func (af AdvancedFilter) AsNumberNotInAdvancedFilter() (*NumberNotInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanAdvancedFilter is the BasicAdvancedFilter implementation for AdvancedFilter.
func (af AdvancedFilter) AsNumberLessThanAdvancedFilter() (*NumberLessThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanAdvancedFilter is the BasicAdvancedFilter implementation for AdvancedFilter.
func (af AdvancedFilter) AsNumberGreaterThanAdvancedFilter() (*NumberGreaterThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for AdvancedFilter.
func (af AdvancedFilter) AsNumberLessThanOrEqualsAdvancedFilter() (*NumberLessThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for AdvancedFilter.
func (af AdvancedFilter) AsNumberGreaterThanOrEqualsAdvancedFilter() (*NumberGreaterThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsBoolEqualsAdvancedFilter is the BasicAdvancedFilter implementation for AdvancedFilter.
func (af AdvancedFilter) AsBoolEqualsAdvancedFilter() (*BoolEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsStringInAdvancedFilter is the BasicAdvancedFilter implementation for AdvancedFilter.
func (af AdvancedFilter) AsStringInAdvancedFilter() (*StringInAdvancedFilter, bool) {
	return nil, false
}

// AsStringNotInAdvancedFilter is the BasicAdvancedFilter implementation for AdvancedFilter.
func (af AdvancedFilter) AsStringNotInAdvancedFilter() (*StringNotInAdvancedFilter, bool) {
	return nil, false
}

// AsStringBeginsWithAdvancedFilter is the BasicAdvancedFilter implementation for AdvancedFilter.
func (af AdvancedFilter) AsStringBeginsWithAdvancedFilter() (*StringBeginsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringEndsWithAdvancedFilter is the BasicAdvancedFilter implementation for AdvancedFilter.
func (af AdvancedFilter) AsStringEndsWithAdvancedFilter() (*StringEndsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringContainsAdvancedFilter is the BasicAdvancedFilter implementation for AdvancedFilter.
func (af AdvancedFilter) AsStringContainsAdvancedFilter() (*StringContainsAdvancedFilter, bool) {
	return nil, false
}

// AsAdvancedFilter is the BasicAdvancedFilter implementation for AdvancedFilter.
func (af AdvancedFilter) AsAdvancedFilter() (*AdvancedFilter, bool) {
	return &af, true
}

// AsBasicAdvancedFilter is the BasicAdvancedFilter implementation for AdvancedFilter.
func (af AdvancedFilter) AsBasicAdvancedFilter() (BasicAdvancedFilter, bool) {
	return &af, true
}

// AzureFunctionEventSubscriptionDestination information about the azure function destination for an event
// subscription.
type AzureFunctionEventSubscriptionDestination struct {
	// AzureFunctionEventSubscriptionDestinationProperties - Azure Function Properties of the event subscription destination.
	*AzureFunctionEventSubscriptionDestinationProperties `json:"properties,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeEventSubscriptionDestination', 'EndpointTypeWebHook', 'EndpointTypeEventHub', 'EndpointTypeStorageQueue', 'EndpointTypeHybridConnection', 'EndpointTypeServiceBusQueue', 'EndpointTypeServiceBusTopic', 'EndpointTypeAzureFunction'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFunctionEventSubscriptionDestination.
func (afesd AzureFunctionEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	afesd.EndpointType = EndpointTypeAzureFunction
	objectMap := make(map[string]interface{})
	if afesd.AzureFunctionEventSubscriptionDestinationProperties != nil {
		objectMap["properties"] = afesd.AzureFunctionEventSubscriptionDestinationProperties
	}
	if afesd.EndpointType != "" {
		objectMap["endpointType"] = afesd.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsWebHookEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for AzureFunctionEventSubscriptionDestination.
func (afesd AzureFunctionEventSubscriptionDestination) AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventHubEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for AzureFunctionEventSubscriptionDestination.
func (afesd AzureFunctionEventSubscriptionDestination) AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool) {
	return nil, false
}

// AsStorageQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for AzureFunctionEventSubscriptionDestination.
func (afesd AzureFunctionEventSubscriptionDestination) AsStorageQueueEventSubscriptionDestination() (*StorageQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsHybridConnectionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for AzureFunctionEventSubscriptionDestination.
func (afesd AzureFunctionEventSubscriptionDestination) AsHybridConnectionEventSubscriptionDestination() (*HybridConnectionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsServiceBusQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for AzureFunctionEventSubscriptionDestination.
func (afesd AzureFunctionEventSubscriptionDestination) AsServiceBusQueueEventSubscriptionDestination() (*ServiceBusQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsServiceBusTopicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for AzureFunctionEventSubscriptionDestination.
func (afesd AzureFunctionEventSubscriptionDestination) AsServiceBusTopicEventSubscriptionDestination() (*ServiceBusTopicEventSubscriptionDestination, bool) {
	return nil, false
}

// AsAzureFunctionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for AzureFunctionEventSubscriptionDestination.
func (afesd AzureFunctionEventSubscriptionDestination) AsAzureFunctionEventSubscriptionDestination() (*AzureFunctionEventSubscriptionDestination, bool) {
	return &afesd, true
}

// AsEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for AzureFunctionEventSubscriptionDestination.
func (afesd AzureFunctionEventSubscriptionDestination) AsEventSubscriptionDestination() (*EventSubscriptionDestination, bool) {
	return nil, false
}

// AsBasicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for AzureFunctionEventSubscriptionDestination.
func (afesd AzureFunctionEventSubscriptionDestination) AsBasicEventSubscriptionDestination() (BasicEventSubscriptionDestination, bool) {
	return &afesd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureFunctionEventSubscriptionDestination struct.
func (afesd *AzureFunctionEventSubscriptionDestination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureFunctionEventSubscriptionDestinationProperties AzureFunctionEventSubscriptionDestinationProperties
				err = json.Unmarshal(*v, &azureFunctionEventSubscriptionDestinationProperties)
				if err != nil {
					return err
				}
				afesd.AzureFunctionEventSubscriptionDestinationProperties = &azureFunctionEventSubscriptionDestinationProperties
			}
		case "endpointType":
			if v != nil {
				var endpointType EndpointType
				err = json.Unmarshal(*v, &endpointType)
				if err != nil {
					return err
				}
				afesd.EndpointType = endpointType
			}
		}
	}

	return nil
}

// AzureFunctionEventSubscriptionDestinationProperties the properties that represent the Azure Function
// destination of an event subscription.
type AzureFunctionEventSubscriptionDestinationProperties struct {
	// ResourceID - The Azure Resource Id that represents the endpoint of the Azure Function destination of an event subscription.
	ResourceID *string `json:"resourceId,omitempty"`
	// MaxEventsPerBatch - Maximum number of events per batch.
	MaxEventsPerBatch *int32 `json:"maxEventsPerBatch,omitempty"`
	// PreferredBatchSizeInKilobytes - Preferred batch size in Kilobytes.
	PreferredBatchSizeInKilobytes *int32 `json:"preferredBatchSizeInKilobytes,omitempty"`
}

// BoolEqualsAdvancedFilter boolEquals Advanced Filter.
type BoolEqualsAdvancedFilter struct {
	// Value - The boolean filter value.
	Value *bool `json:"value,omitempty"`
	// Key - The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
	// OperatorType - Possible values include: 'OperatorTypeAdvancedFilter', 'OperatorTypeNumberIn', 'OperatorTypeNumberNotIn', 'OperatorTypeNumberLessThan', 'OperatorTypeNumberGreaterThan', 'OperatorTypeNumberLessThanOrEquals', 'OperatorTypeNumberGreaterThanOrEquals', 'OperatorTypeBoolEquals', 'OperatorTypeStringIn', 'OperatorTypeStringNotIn', 'OperatorTypeStringBeginsWith', 'OperatorTypeStringEndsWith', 'OperatorTypeStringContains'
	OperatorType OperatorType `json:"operatorType,omitempty"`
}

// MarshalJSON is the custom marshaler for BoolEqualsAdvancedFilter.
func (beaf BoolEqualsAdvancedFilter) MarshalJSON() ([]byte, error) {
	beaf.OperatorType = OperatorTypeBoolEquals
	objectMap := make(map[string]interface{})
	if beaf.Value != nil {
		objectMap["value"] = beaf.Value
	}
	if beaf.Key != nil {
		objectMap["key"] = beaf.Key
	}
	if beaf.OperatorType != "" {
		objectMap["operatorType"] = beaf.OperatorType
	}
	return json.Marshal(objectMap)
}

// AsNumberInAdvancedFilter is the BasicAdvancedFilter implementation for BoolEqualsAdvancedFilter.
func (beaf BoolEqualsAdvancedFilter) AsNumberInAdvancedFilter() (*NumberInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberNotInAdvancedFilter is the BasicAdvancedFilter implementation for BoolEqualsAdvancedFilter.
func (beaf BoolEqualsAdvancedFilter) AsNumberNotInAdvancedFilter() (*NumberNotInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanAdvancedFilter is the BasicAdvancedFilter implementation for BoolEqualsAdvancedFilter.
func (beaf BoolEqualsAdvancedFilter) AsNumberLessThanAdvancedFilter() (*NumberLessThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanAdvancedFilter is the BasicAdvancedFilter implementation for BoolEqualsAdvancedFilter.
func (beaf BoolEqualsAdvancedFilter) AsNumberGreaterThanAdvancedFilter() (*NumberGreaterThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for BoolEqualsAdvancedFilter.
func (beaf BoolEqualsAdvancedFilter) AsNumberLessThanOrEqualsAdvancedFilter() (*NumberLessThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for BoolEqualsAdvancedFilter.
func (beaf BoolEqualsAdvancedFilter) AsNumberGreaterThanOrEqualsAdvancedFilter() (*NumberGreaterThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsBoolEqualsAdvancedFilter is the BasicAdvancedFilter implementation for BoolEqualsAdvancedFilter.
func (beaf BoolEqualsAdvancedFilter) AsBoolEqualsAdvancedFilter() (*BoolEqualsAdvancedFilter, bool) {
	return &beaf, true
}

// AsStringInAdvancedFilter is the BasicAdvancedFilter implementation for BoolEqualsAdvancedFilter.
func (beaf BoolEqualsAdvancedFilter) AsStringInAdvancedFilter() (*StringInAdvancedFilter, bool) {
	return nil, false
}

// AsStringNotInAdvancedFilter is the BasicAdvancedFilter implementation for BoolEqualsAdvancedFilter.
func (beaf BoolEqualsAdvancedFilter) AsStringNotInAdvancedFilter() (*StringNotInAdvancedFilter, bool) {
	return nil, false
}

// AsStringBeginsWithAdvancedFilter is the BasicAdvancedFilter implementation for BoolEqualsAdvancedFilter.
func (beaf BoolEqualsAdvancedFilter) AsStringBeginsWithAdvancedFilter() (*StringBeginsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringEndsWithAdvancedFilter is the BasicAdvancedFilter implementation for BoolEqualsAdvancedFilter.
func (beaf BoolEqualsAdvancedFilter) AsStringEndsWithAdvancedFilter() (*StringEndsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringContainsAdvancedFilter is the BasicAdvancedFilter implementation for BoolEqualsAdvancedFilter.
func (beaf BoolEqualsAdvancedFilter) AsStringContainsAdvancedFilter() (*StringContainsAdvancedFilter, bool) {
	return nil, false
}

// AsAdvancedFilter is the BasicAdvancedFilter implementation for BoolEqualsAdvancedFilter.
func (beaf BoolEqualsAdvancedFilter) AsAdvancedFilter() (*AdvancedFilter, bool) {
	return nil, false
}

// AsBasicAdvancedFilter is the BasicAdvancedFilter implementation for BoolEqualsAdvancedFilter.
func (beaf BoolEqualsAdvancedFilter) AsBasicAdvancedFilter() (BasicAdvancedFilter, bool) {
	return &beaf, true
}

// ConnectionState connectionState information.
type ConnectionState struct {
	// Status - Status of the connection. Possible values include: 'Pending', 'Approved', 'Rejected', 'Disconnected'
	Status PersistedConnectionStatus `json:"status,omitempty"`
	// Description - Description of the connection state.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - Actions required (if any).
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// BasicDeadLetterDestination information about the dead letter destination for an event subscription. To configure a
// deadletter destination, do not directly instantiate an object of this class. Instead, instantiate an object of a
// derived class. Currently, StorageBlobDeadLetterDestination is the only class that derives from this class.
type BasicDeadLetterDestination interface {
	AsStorageBlobDeadLetterDestination() (*StorageBlobDeadLetterDestination, bool)
	AsDeadLetterDestination() (*DeadLetterDestination, bool)
}

// DeadLetterDestination information about the dead letter destination for an event subscription. To configure
// a deadletter destination, do not directly instantiate an object of this class. Instead, instantiate an
// object of a derived class. Currently, StorageBlobDeadLetterDestination is the only class that derives from
// this class.
type DeadLetterDestination struct {
	// EndpointType - Possible values include: 'EndpointTypeDeadLetterDestination', 'EndpointTypeStorageBlob'
	EndpointType EndpointTypeBasicDeadLetterDestination `json:"endpointType,omitempty"`
}

func unmarshalBasicDeadLetterDestination(body []byte) (BasicDeadLetterDestination, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["endpointType"] {
	case string(EndpointTypeStorageBlob):
		var sbdld StorageBlobDeadLetterDestination
		err := json.Unmarshal(body, &sbdld)
		return sbdld, err
	default:
		var dld DeadLetterDestination
		err := json.Unmarshal(body, &dld)
		return dld, err
	}
}
func unmarshalBasicDeadLetterDestinationArray(body []byte) ([]BasicDeadLetterDestination, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dldArray := make([]BasicDeadLetterDestination, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dld, err := unmarshalBasicDeadLetterDestination(*rawMessage)
		if err != nil {
			return nil, err
		}
		dldArray[index] = dld
	}
	return dldArray, nil
}

// MarshalJSON is the custom marshaler for DeadLetterDestination.
func (dld DeadLetterDestination) MarshalJSON() ([]byte, error) {
	dld.EndpointType = EndpointTypeDeadLetterDestination
	objectMap := make(map[string]interface{})
	if dld.EndpointType != "" {
		objectMap["endpointType"] = dld.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsStorageBlobDeadLetterDestination is the BasicDeadLetterDestination implementation for DeadLetterDestination.
func (dld DeadLetterDestination) AsStorageBlobDeadLetterDestination() (*StorageBlobDeadLetterDestination, bool) {
	return nil, false
}

// AsDeadLetterDestination is the BasicDeadLetterDestination implementation for DeadLetterDestination.
func (dld DeadLetterDestination) AsDeadLetterDestination() (*DeadLetterDestination, bool) {
	return &dld, true
}

// AsBasicDeadLetterDestination is the BasicDeadLetterDestination implementation for DeadLetterDestination.
func (dld DeadLetterDestination) AsBasicDeadLetterDestination() (BasicDeadLetterDestination, bool) {
	return &dld, true
}

// DeadLetterWithResourceIdentity information about the deadletter destination with resource identity.
type DeadLetterWithResourceIdentity struct {
	// Identity - The identity to use when dead-lettering events.
	Identity *EventSubscriptionIdentity `json:"identity,omitempty"`
	// DeadLetterDestination - Information about the destination where events have to be delivered for the event subscription.
	// Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
	DeadLetterDestination BasicDeadLetterDestination `json:"deadLetterDestination,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DeadLetterWithResourceIdentity struct.
func (dlwri *DeadLetterWithResourceIdentity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity EventSubscriptionIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				dlwri.Identity = &identity
			}
		case "deadLetterDestination":
			if v != nil {
				deadLetterDestination, err := unmarshalBasicDeadLetterDestination(*v)
				if err != nil {
					return err
				}
				dlwri.DeadLetterDestination = deadLetterDestination
			}
		}
	}

	return nil
}

// DeliveryWithResourceIdentity information about the delivery for an event subscription with resource
// identity.
type DeliveryWithResourceIdentity struct {
	// Identity - The identity to use when delivering events.
	Identity *EventSubscriptionIdentity `json:"identity,omitempty"`
	// Destination - Information about the destination where events have to be delivered for the event subscription.
	// Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
	Destination BasicEventSubscriptionDestination `json:"destination,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DeliveryWithResourceIdentity struct.
func (dwri *DeliveryWithResourceIdentity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity EventSubscriptionIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				dwri.Identity = &identity
			}
		case "destination":
			if v != nil {
				destination, err := unmarshalBasicEventSubscriptionDestination(*v)
				if err != nil {
					return err
				}
				dwri.Destination = destination
			}
		}
	}

	return nil
}

// Domain eventGrid Domain.
type Domain struct {
	autorest.Response `json:"-"`
	// DomainProperties - Properties of the domain.
	*DomainProperties `json:"properties,omitempty"`
	// Sku - The Sku pricing tier for the domain.
	Sku *ResourceSku `json:"sku,omitempty"`
	// Identity - Identity information for the resource.
	Identity *IdentityInfo `json:"identity,omitempty"`
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the resource.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Domain.
func (d Domain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DomainProperties != nil {
		objectMap["properties"] = d.DomainProperties
	}
	if d.Sku != nil {
		objectMap["sku"] = d.Sku
	}
	if d.Identity != nil {
		objectMap["identity"] = d.Identity
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Domain struct.
func (d *Domain) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var domainProperties DomainProperties
				err = json.Unmarshal(*v, &domainProperties)
				if err != nil {
					return err
				}
				d.DomainProperties = &domainProperties
			}
		case "sku":
			if v != nil {
				var sku ResourceSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				d.Sku = &sku
			}
		case "identity":
			if v != nil {
				var identity IdentityInfo
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				d.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DomainProperties properties of the Domain.
type DomainProperties struct {
	// PrivateEndpointConnections - List of private endpoint connections.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the domain. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Canceled', 'Failed'
	ProvisioningState DomainProvisioningState `json:"provisioningState,omitempty"`
	// Endpoint - READ-ONLY; Endpoint for the domain.
	Endpoint *string `json:"endpoint,omitempty"`
	// InputSchema - This determines the format that Event Grid should expect for incoming events published to the domain. Possible values include: 'InputSchemaEventGridSchema', 'InputSchemaCustomEventSchema', 'InputSchemaCloudEventSchemaV10'
	InputSchema InputSchema `json:"inputSchema,omitempty"`
	// InputSchemaMapping - Information about the InputSchemaMapping which specified the info about mapping event payload.
	InputSchemaMapping BasicInputSchemaMapping `json:"inputSchemaMapping,omitempty"`
	// MetricResourceID - READ-ONLY; Metric resource id for the domain.
	MetricResourceID *string `json:"metricResourceId,omitempty"`
	// PublicNetworkAccess - This determines if traffic is allowed over public network. By default it is enabled.
	// You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules" />. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// InboundIPRules - This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
	InboundIPRules *[]InboundIPRule `json:"inboundIpRules,omitempty"`
}

// MarshalJSON is the custom marshaler for DomainProperties.
func (dp DomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.PrivateEndpointConnections != nil {
		objectMap["privateEndpointConnections"] = dp.PrivateEndpointConnections
	}
	if dp.InputSchema != "" {
		objectMap["inputSchema"] = dp.InputSchema
	}
	objectMap["inputSchemaMapping"] = dp.InputSchemaMapping
	if dp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = dp.PublicNetworkAccess
	}
	if dp.InboundIPRules != nil {
		objectMap["inboundIpRules"] = dp.InboundIPRules
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DomainProperties struct.
func (dp *DomainProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "privateEndpointConnections":
			if v != nil {
				var privateEndpointConnections []PrivateEndpointConnection
				err = json.Unmarshal(*v, &privateEndpointConnections)
				if err != nil {
					return err
				}
				dp.PrivateEndpointConnections = &privateEndpointConnections
			}
		case "provisioningState":
			if v != nil {
				var provisioningState DomainProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				dp.ProvisioningState = provisioningState
			}
		case "endpoint":
			if v != nil {
				var endpoint string
				err = json.Unmarshal(*v, &endpoint)
				if err != nil {
					return err
				}
				dp.Endpoint = &endpoint
			}
		case "inputSchema":
			if v != nil {
				var inputSchema InputSchema
				err = json.Unmarshal(*v, &inputSchema)
				if err != nil {
					return err
				}
				dp.InputSchema = inputSchema
			}
		case "inputSchemaMapping":
			if v != nil {
				inputSchemaMapping, err := unmarshalBasicInputSchemaMapping(*v)
				if err != nil {
					return err
				}
				dp.InputSchemaMapping = inputSchemaMapping
			}
		case "metricResourceId":
			if v != nil {
				var metricResourceID string
				err = json.Unmarshal(*v, &metricResourceID)
				if err != nil {
					return err
				}
				dp.MetricResourceID = &metricResourceID
			}
		case "publicNetworkAccess":
			if v != nil {
				var publicNetworkAccess PublicNetworkAccess
				err = json.Unmarshal(*v, &publicNetworkAccess)
				if err != nil {
					return err
				}
				dp.PublicNetworkAccess = publicNetworkAccess
			}
		case "inboundIpRules":
			if v != nil {
				var inboundIPRules []InboundIPRule
				err = json.Unmarshal(*v, &inboundIPRules)
				if err != nil {
					return err
				}
				dp.InboundIPRules = &inboundIPRules
			}
		}
	}

	return nil
}

// DomainRegenerateKeyRequest domain regenerate share access key request.
type DomainRegenerateKeyRequest struct {
	// KeyName - Key name to regenerate key1 or key2.
	KeyName *string `json:"keyName,omitempty"`
}

// DomainsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DomainsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DomainsClient) (Domain, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DomainsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DomainsCreateOrUpdateFuture.Result.
func (future *DomainsCreateOrUpdateFuture) result(client DomainsClient) (d Domain, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.DomainsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.DomainsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.DomainsCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DomainsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DomainsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DomainsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DomainsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DomainsDeleteFuture.Result.
func (future *DomainsDeleteFuture) result(client DomainsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.DomainsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.DomainsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DomainSharedAccessKeys shared access keys of the Domain.
type DomainSharedAccessKeys struct {
	autorest.Response `json:"-"`
	// Key1 - Shared access key1 for the domain.
	Key1 *string `json:"key1,omitempty"`
	// Key2 - Shared access key2 for the domain.
	Key2 *string `json:"key2,omitempty"`
}

// DomainsListResult result of the List Domains operation
type DomainsListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of Domains
	Value *[]Domain `json:"value,omitempty"`
	// NextLink - A link for the next page of domains
	NextLink *string `json:"nextLink,omitempty"`
}

// DomainsListResultIterator provides access to a complete listing of Domain values.
type DomainsListResultIterator struct {
	i    int
	page DomainsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DomainsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DomainsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DomainsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DomainsListResultIterator) Response() DomainsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DomainsListResultIterator) Value() Domain {
	if !iter.page.NotDone() {
		return Domain{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DomainsListResultIterator type.
func NewDomainsListResultIterator(page DomainsListResultPage) DomainsListResultIterator {
	return DomainsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DomainsListResult) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dlr DomainsListResult) hasNextLink() bool {
	return dlr.NextLink != nil && len(*dlr.NextLink) != 0
}

// domainsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DomainsListResult) domainsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DomainsListResultPage contains a page of Domain values.
type DomainsListResultPage struct {
	fn  func(context.Context, DomainsListResult) (DomainsListResult, error)
	dlr DomainsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DomainsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dlr)
		if err != nil {
			return err
		}
		page.dlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DomainsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DomainsListResultPage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DomainsListResultPage) Response() DomainsListResult {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DomainsListResultPage) Values() []Domain {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// Creates a new instance of the DomainsListResultPage type.
func NewDomainsListResultPage(cur DomainsListResult, getNextPage func(context.Context, DomainsListResult) (DomainsListResult, error)) DomainsListResultPage {
	return DomainsListResultPage{
		fn:  getNextPage,
		dlr: cur,
	}
}

// DomainsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DomainsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DomainsClient) (Domain, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DomainsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DomainsUpdateFuture.Result.
func (future *DomainsUpdateFuture) result(client DomainsClient) (d Domain, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.DomainsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.DomainsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.UpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.DomainsUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DomainTopic domain Topic.
type DomainTopic struct {
	autorest.Response `json:"-"`
	// DomainTopicProperties - Properties of the Domain Topic.
	*DomainTopicProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DomainTopic.
func (dt DomainTopic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dt.DomainTopicProperties != nil {
		objectMap["properties"] = dt.DomainTopicProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DomainTopic struct.
func (dt *DomainTopic) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var domainTopicProperties DomainTopicProperties
				err = json.Unmarshal(*v, &domainTopicProperties)
				if err != nil {
					return err
				}
				dt.DomainTopicProperties = &domainTopicProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dt.Type = &typeVar
			}
		}
	}

	return nil
}

// DomainTopicProperties properties of the Domain Topic.
type DomainTopicProperties struct {
	// ProvisioningState - Provisioning state of the domain topic. Possible values include: 'DomainTopicProvisioningStateCreating', 'DomainTopicProvisioningStateUpdating', 'DomainTopicProvisioningStateDeleting', 'DomainTopicProvisioningStateSucceeded', 'DomainTopicProvisioningStateCanceled', 'DomainTopicProvisioningStateFailed'
	ProvisioningState DomainTopicProvisioningState `json:"provisioningState,omitempty"`
}

// DomainTopicsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DomainTopicsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DomainTopicsClient) (DomainTopic, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DomainTopicsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DomainTopicsCreateOrUpdateFuture.Result.
func (future *DomainTopicsCreateOrUpdateFuture) result(client DomainTopicsClient) (dt DomainTopic, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.DomainTopicsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dt.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.DomainTopicsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dt.Response.Response, err = future.GetResult(sender); err == nil && dt.Response.Response.StatusCode != http.StatusNoContent {
		dt, err = client.CreateOrUpdateResponder(dt.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.DomainTopicsCreateOrUpdateFuture", "Result", dt.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DomainTopicsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DomainTopicsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DomainTopicsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DomainTopicsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DomainTopicsDeleteFuture.Result.
func (future *DomainTopicsDeleteFuture) result(client DomainTopicsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.DomainTopicsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.DomainTopicsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DomainTopicsListResult result of the List Domain Topics operation
type DomainTopicsListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of Domain Topics
	Value *[]DomainTopic `json:"value,omitempty"`
	// NextLink - A link for the next page of domain topics
	NextLink *string `json:"nextLink,omitempty"`
}

// DomainTopicsListResultIterator provides access to a complete listing of DomainTopic values.
type DomainTopicsListResultIterator struct {
	i    int
	page DomainTopicsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DomainTopicsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainTopicsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DomainTopicsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DomainTopicsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DomainTopicsListResultIterator) Response() DomainTopicsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DomainTopicsListResultIterator) Value() DomainTopic {
	if !iter.page.NotDone() {
		return DomainTopic{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DomainTopicsListResultIterator type.
func NewDomainTopicsListResultIterator(page DomainTopicsListResultPage) DomainTopicsListResultIterator {
	return DomainTopicsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dtlr DomainTopicsListResult) IsEmpty() bool {
	return dtlr.Value == nil || len(*dtlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dtlr DomainTopicsListResult) hasNextLink() bool {
	return dtlr.NextLink != nil && len(*dtlr.NextLink) != 0
}

// domainTopicsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dtlr DomainTopicsListResult) domainTopicsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dtlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dtlr.NextLink)))
}

// DomainTopicsListResultPage contains a page of DomainTopic values.
type DomainTopicsListResultPage struct {
	fn   func(context.Context, DomainTopicsListResult) (DomainTopicsListResult, error)
	dtlr DomainTopicsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DomainTopicsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainTopicsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dtlr)
		if err != nil {
			return err
		}
		page.dtlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DomainTopicsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DomainTopicsListResultPage) NotDone() bool {
	return !page.dtlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DomainTopicsListResultPage) Response() DomainTopicsListResult {
	return page.dtlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DomainTopicsListResultPage) Values() []DomainTopic {
	if page.dtlr.IsEmpty() {
		return nil
	}
	return *page.dtlr.Value
}

// Creates a new instance of the DomainTopicsListResultPage type.
func NewDomainTopicsListResultPage(cur DomainTopicsListResult, getNextPage func(context.Context, DomainTopicsListResult) (DomainTopicsListResult, error)) DomainTopicsListResultPage {
	return DomainTopicsListResultPage{
		fn:   getNextPage,
		dtlr: cur,
	}
}

// DomainUpdateParameterProperties information of domain update parameter properties.
type DomainUpdateParameterProperties struct {
	// PublicNetworkAccess - This determines if traffic is allowed over public network. By default it is enabled.
	// You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainUpdateParameterProperties.InboundIpRules" />. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// InboundIPRules - This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
	InboundIPRules *[]InboundIPRule `json:"inboundIpRules,omitempty"`
}

// DomainUpdateParameters properties of the Domain update.
type DomainUpdateParameters struct {
	// Tags - Tags of the domains resource.
	Tags map[string]*string `json:"tags"`
	// DomainUpdateParameterProperties - Properties of the resource.
	*DomainUpdateParameterProperties `json:"properties,omitempty"`
	// Identity - Identity information for the resource.
	Identity *IdentityInfo `json:"identity,omitempty"`
	// Sku - The Sku pricing tier for the domain.
	Sku *ResourceSku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for DomainUpdateParameters.
func (dup DomainUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dup.Tags != nil {
		objectMap["tags"] = dup.Tags
	}
	if dup.DomainUpdateParameterProperties != nil {
		objectMap["properties"] = dup.DomainUpdateParameterProperties
	}
	if dup.Identity != nil {
		objectMap["identity"] = dup.Identity
	}
	if dup.Sku != nil {
		objectMap["sku"] = dup.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DomainUpdateParameters struct.
func (dup *DomainUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dup.Tags = tags
			}
		case "properties":
			if v != nil {
				var domainUpdateParameterProperties DomainUpdateParameterProperties
				err = json.Unmarshal(*v, &domainUpdateParameterProperties)
				if err != nil {
					return err
				}
				dup.DomainUpdateParameterProperties = &domainUpdateParameterProperties
			}
		case "identity":
			if v != nil {
				var identity IdentityInfo
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				dup.Identity = &identity
			}
		case "sku":
			if v != nil {
				var sku ResourceSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				dup.Sku = &sku
			}
		}
	}

	return nil
}

// EventChannel event Channel.
type EventChannel struct {
	autorest.Response `json:"-"`
	// EventChannelProperties - Properties of the EventChannel.
	*EventChannelProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventChannel.
func (ec EventChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ec.EventChannelProperties != nil {
		objectMap["properties"] = ec.EventChannelProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EventChannel struct.
func (ec *EventChannel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventChannelProperties EventChannelProperties
				err = json.Unmarshal(*v, &eventChannelProperties)
				if err != nil {
					return err
				}
				ec.EventChannelProperties = &eventChannelProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ec.Type = &typeVar
			}
		}
	}

	return nil
}

// EventChannelDestination properties of the destination of an event channel.
type EventChannelDestination struct {
	// AzureSubscriptionID - Azure subscription ID of the customer creating the event channel. The partner topic
	// associated with the event channel will be created under this Azure subscription.
	AzureSubscriptionID *string `json:"azureSubscriptionId,omitempty"`
	// ResourceGroup - Azure Resource Group of the customer creating the event channel. The partner topic
	// associated with the event channel will be created under this resource group.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// PartnerTopicName - Name of the partner topic associated with the event channel.
	PartnerTopicName *string `json:"partnerTopicName,omitempty"`
}

// EventChannelFilter filter for the Event Channel.
type EventChannelFilter struct {
	// AdvancedFilters - An array of advanced filters that are used for filtering event channels.
	AdvancedFilters *[]BasicAdvancedFilter `json:"advancedFilters,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EventChannelFilter struct.
func (ecf *EventChannelFilter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "advancedFilters":
			if v != nil {
				advancedFilters, err := unmarshalBasicAdvancedFilterArray(*v)
				if err != nil {
					return err
				}
				ecf.AdvancedFilters = &advancedFilters
			}
		}
	}

	return nil
}

// EventChannelProperties properties of the Event Channel.
type EventChannelProperties struct {
	// Source - Source of the event channel. This represents a unique resource in the partner's resource model.
	Source *EventChannelSource `json:"source,omitempty"`
	// Destination - Represents the destination of an event channel.
	Destination *EventChannelDestination `json:"destination,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the event channel. Possible values include: 'EventChannelProvisioningStateCreating', 'EventChannelProvisioningStateUpdating', 'EventChannelProvisioningStateDeleting', 'EventChannelProvisioningStateSucceeded', 'EventChannelProvisioningStateCanceled', 'EventChannelProvisioningStateFailed'
	ProvisioningState EventChannelProvisioningState `json:"provisioningState,omitempty"`
	// PartnerTopicReadinessState - READ-ONLY; The readiness state of the corresponding partner topic. Possible values include: 'NotActivatedByUserYet', 'ActivatedByUser', 'DeactivatedByUser', 'DeletedByUser'
	PartnerTopicReadinessState PartnerTopicReadinessState `json:"partnerTopicReadinessState,omitempty"`
	// ExpirationTimeIfNotActivatedUtc - Expiration time of the event channel. If this timer expires while the corresponding partner topic is never activated,
	// the event channel and corresponding partner topic are deleted.
	ExpirationTimeIfNotActivatedUtc *date.Time `json:"expirationTimeIfNotActivatedUtc,omitempty"`
	// Filter - Information about the filter for the event channel.
	Filter *EventChannelFilter `json:"filter,omitempty"`
	// PartnerTopicFriendlyDescription - Friendly description about the topic. This can be set by the publisher/partner to show custom description for the customer partner topic.
	// This will be helpful to remove any ambiguity of the origin of creation of the partner topic for the customer.
	PartnerTopicFriendlyDescription *string `json:"partnerTopicFriendlyDescription,omitempty"`
}

// MarshalJSON is the custom marshaler for EventChannelProperties.
func (ecp EventChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ecp.Source != nil {
		objectMap["source"] = ecp.Source
	}
	if ecp.Destination != nil {
		objectMap["destination"] = ecp.Destination
	}
	if ecp.ExpirationTimeIfNotActivatedUtc != nil {
		objectMap["expirationTimeIfNotActivatedUtc"] = ecp.ExpirationTimeIfNotActivatedUtc
	}
	if ecp.Filter != nil {
		objectMap["filter"] = ecp.Filter
	}
	if ecp.PartnerTopicFriendlyDescription != nil {
		objectMap["partnerTopicFriendlyDescription"] = ecp.PartnerTopicFriendlyDescription
	}
	return json.Marshal(objectMap)
}

// EventChannelsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EventChannelsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EventChannelsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EventChannelsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EventChannelsDeleteFuture.Result.
func (future *EventChannelsDeleteFuture) result(client EventChannelsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventChannelsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.EventChannelsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EventChannelsListResult result of the List Event Channels operation
type EventChannelsListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of Event Channels
	Value *[]EventChannel `json:"value,omitempty"`
	// NextLink - A link for the next page of event channels
	NextLink *string `json:"nextLink,omitempty"`
}

// EventChannelsListResultIterator provides access to a complete listing of EventChannel values.
type EventChannelsListResultIterator struct {
	i    int
	page EventChannelsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventChannelsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventChannelsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EventChannelsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventChannelsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventChannelsListResultIterator) Response() EventChannelsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventChannelsListResultIterator) Value() EventChannel {
	if !iter.page.NotDone() {
		return EventChannel{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EventChannelsListResultIterator type.
func NewEventChannelsListResultIterator(page EventChannelsListResultPage) EventChannelsListResultIterator {
	return EventChannelsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eclr EventChannelsListResult) IsEmpty() bool {
	return eclr.Value == nil || len(*eclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eclr EventChannelsListResult) hasNextLink() bool {
	return eclr.NextLink != nil && len(*eclr.NextLink) != 0
}

// eventChannelsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eclr EventChannelsListResult) eventChannelsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !eclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eclr.NextLink)))
}

// EventChannelsListResultPage contains a page of EventChannel values.
type EventChannelsListResultPage struct {
	fn   func(context.Context, EventChannelsListResult) (EventChannelsListResult, error)
	eclr EventChannelsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventChannelsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventChannelsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eclr)
		if err != nil {
			return err
		}
		page.eclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EventChannelsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventChannelsListResultPage) NotDone() bool {
	return !page.eclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventChannelsListResultPage) Response() EventChannelsListResult {
	return page.eclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventChannelsListResultPage) Values() []EventChannel {
	if page.eclr.IsEmpty() {
		return nil
	}
	return *page.eclr.Value
}

// Creates a new instance of the EventChannelsListResultPage type.
func NewEventChannelsListResultPage(cur EventChannelsListResult, getNextPage func(context.Context, EventChannelsListResult) (EventChannelsListResult, error)) EventChannelsListResultPage {
	return EventChannelsListResultPage{
		fn:   getNextPage,
		eclr: cur,
	}
}

// EventChannelSource properties of the source of an event channel.
type EventChannelSource struct {
	// Source - The identifier of the resource that's the source of the events.
	// This represents a unique resource in the partner's resource model.
	Source *string `json:"source,omitempty"`
}

// EventHubEventSubscriptionDestination information about the event hub destination for an event
// subscription.
type EventHubEventSubscriptionDestination struct {
	// EventHubEventSubscriptionDestinationProperties - Event Hub Properties of the event subscription destination.
	*EventHubEventSubscriptionDestinationProperties `json:"properties,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeEventSubscriptionDestination', 'EndpointTypeWebHook', 'EndpointTypeEventHub', 'EndpointTypeStorageQueue', 'EndpointTypeHybridConnection', 'EndpointTypeServiceBusQueue', 'EndpointTypeServiceBusTopic', 'EndpointTypeAzureFunction'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	ehesd.EndpointType = EndpointTypeEventHub
	objectMap := make(map[string]interface{})
	if ehesd.EventHubEventSubscriptionDestinationProperties != nil {
		objectMap["properties"] = ehesd.EventHubEventSubscriptionDestinationProperties
	}
	if ehesd.EndpointType != "" {
		objectMap["endpointType"] = ehesd.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsWebHookEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventHubEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool) {
	return &ehesd, true
}

// AsStorageQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsStorageQueueEventSubscriptionDestination() (*StorageQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsHybridConnectionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsHybridConnectionEventSubscriptionDestination() (*HybridConnectionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsServiceBusQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsServiceBusQueueEventSubscriptionDestination() (*ServiceBusQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsServiceBusTopicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsServiceBusTopicEventSubscriptionDestination() (*ServiceBusTopicEventSubscriptionDestination, bool) {
	return nil, false
}

// AsAzureFunctionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsAzureFunctionEventSubscriptionDestination() (*AzureFunctionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsEventSubscriptionDestination() (*EventSubscriptionDestination, bool) {
	return nil, false
}

// AsBasicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsBasicEventSubscriptionDestination() (BasicEventSubscriptionDestination, bool) {
	return &ehesd, true
}

// UnmarshalJSON is the custom unmarshaler for EventHubEventSubscriptionDestination struct.
func (ehesd *EventHubEventSubscriptionDestination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventHubEventSubscriptionDestinationProperties EventHubEventSubscriptionDestinationProperties
				err = json.Unmarshal(*v, &eventHubEventSubscriptionDestinationProperties)
				if err != nil {
					return err
				}
				ehesd.EventHubEventSubscriptionDestinationProperties = &eventHubEventSubscriptionDestinationProperties
			}
		case "endpointType":
			if v != nil {
				var endpointType EndpointType
				err = json.Unmarshal(*v, &endpointType)
				if err != nil {
					return err
				}
				ehesd.EndpointType = endpointType
			}
		}
	}

	return nil
}

// EventHubEventSubscriptionDestinationProperties the properties for a event hub destination.
type EventHubEventSubscriptionDestinationProperties struct {
	// ResourceID - The Azure Resource Id that represents the endpoint of an Event Hub destination of an event subscription.
	ResourceID *string `json:"resourceId,omitempty"`
}

// EventSubscription event Subscription
type EventSubscription struct {
	autorest.Response `json:"-"`
	// EventSubscriptionProperties - Properties of the event subscription.
	*EventSubscriptionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventSubscription.
func (es EventSubscription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if es.EventSubscriptionProperties != nil {
		objectMap["properties"] = es.EventSubscriptionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EventSubscription struct.
func (es *EventSubscription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventSubscriptionProperties EventSubscriptionProperties
				err = json.Unmarshal(*v, &eventSubscriptionProperties)
				if err != nil {
					return err
				}
				es.EventSubscriptionProperties = &eventSubscriptionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				es.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				es.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				es.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicEventSubscriptionDestination information about the destination for an event subscription.
type BasicEventSubscriptionDestination interface {
	AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool)
	AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool)
	AsStorageQueueEventSubscriptionDestination() (*StorageQueueEventSubscriptionDestination, bool)
	AsHybridConnectionEventSubscriptionDestination() (*HybridConnectionEventSubscriptionDestination, bool)
	AsServiceBusQueueEventSubscriptionDestination() (*ServiceBusQueueEventSubscriptionDestination, bool)
	AsServiceBusTopicEventSubscriptionDestination() (*ServiceBusTopicEventSubscriptionDestination, bool)
	AsAzureFunctionEventSubscriptionDestination() (*AzureFunctionEventSubscriptionDestination, bool)
	AsEventSubscriptionDestination() (*EventSubscriptionDestination, bool)
}

// EventSubscriptionDestination information about the destination for an event subscription.
type EventSubscriptionDestination struct {
	// EndpointType - Possible values include: 'EndpointTypeEventSubscriptionDestination', 'EndpointTypeWebHook', 'EndpointTypeEventHub', 'EndpointTypeStorageQueue', 'EndpointTypeHybridConnection', 'EndpointTypeServiceBusQueue', 'EndpointTypeServiceBusTopic', 'EndpointTypeAzureFunction'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

func unmarshalBasicEventSubscriptionDestination(body []byte) (BasicEventSubscriptionDestination, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["endpointType"] {
	case string(EndpointTypeWebHook):
		var whesd WebHookEventSubscriptionDestination
		err := json.Unmarshal(body, &whesd)
		return whesd, err
	case string(EndpointTypeEventHub):
		var ehesd EventHubEventSubscriptionDestination
		err := json.Unmarshal(body, &ehesd)
		return ehesd, err
	case string(EndpointTypeStorageQueue):
		var sqesd StorageQueueEventSubscriptionDestination
		err := json.Unmarshal(body, &sqesd)
		return sqesd, err
	case string(EndpointTypeHybridConnection):
		var hcesd HybridConnectionEventSubscriptionDestination
		err := json.Unmarshal(body, &hcesd)
		return hcesd, err
	case string(EndpointTypeServiceBusQueue):
		var sbqesd ServiceBusQueueEventSubscriptionDestination
		err := json.Unmarshal(body, &sbqesd)
		return sbqesd, err
	case string(EndpointTypeServiceBusTopic):
		var sbtesd ServiceBusTopicEventSubscriptionDestination
		err := json.Unmarshal(body, &sbtesd)
		return sbtesd, err
	case string(EndpointTypeAzureFunction):
		var afesd AzureFunctionEventSubscriptionDestination
		err := json.Unmarshal(body, &afesd)
		return afesd, err
	default:
		var esd EventSubscriptionDestination
		err := json.Unmarshal(body, &esd)
		return esd, err
	}
}
func unmarshalBasicEventSubscriptionDestinationArray(body []byte) ([]BasicEventSubscriptionDestination, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	esdArray := make([]BasicEventSubscriptionDestination, len(rawMessages))

	for index, rawMessage := range rawMessages {
		esd, err := unmarshalBasicEventSubscriptionDestination(*rawMessage)
		if err != nil {
			return nil, err
		}
		esdArray[index] = esd
	}
	return esdArray, nil
}

// MarshalJSON is the custom marshaler for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	esd.EndpointType = EndpointTypeEventSubscriptionDestination
	objectMap := make(map[string]interface{})
	if esd.EndpointType != "" {
		objectMap["endpointType"] = esd.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsWebHookEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventHubEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool) {
	return nil, false
}

// AsStorageQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) AsStorageQueueEventSubscriptionDestination() (*StorageQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsHybridConnectionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) AsHybridConnectionEventSubscriptionDestination() (*HybridConnectionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsServiceBusQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) AsServiceBusQueueEventSubscriptionDestination() (*ServiceBusQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsServiceBusTopicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) AsServiceBusTopicEventSubscriptionDestination() (*ServiceBusTopicEventSubscriptionDestination, bool) {
	return nil, false
}

// AsAzureFunctionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) AsAzureFunctionEventSubscriptionDestination() (*AzureFunctionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) AsEventSubscriptionDestination() (*EventSubscriptionDestination, bool) {
	return &esd, true
}

// AsBasicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) AsBasicEventSubscriptionDestination() (BasicEventSubscriptionDestination, bool) {
	return &esd, true
}

// EventSubscriptionFilter filter for the Event Subscription.
type EventSubscriptionFilter struct {
	// SubjectBeginsWith - An optional string to filter events for an event subscription based on a resource path prefix.
	// The format of this depends on the publisher of the events.
	// Wildcard characters are not supported in this path.
	SubjectBeginsWith *string `json:"subjectBeginsWith,omitempty"`
	// SubjectEndsWith - An optional string to filter events for an event subscription based on a resource path suffix.
	// Wildcard characters are not supported in this path.
	SubjectEndsWith *string `json:"subjectEndsWith,omitempty"`
	// IncludedEventTypes - A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
	IncludedEventTypes *[]string `json:"includedEventTypes,omitempty"`
	// IsSubjectCaseSensitive - Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the filter
	// should be compared in a case sensitive manner.
	IsSubjectCaseSensitive *bool `json:"isSubjectCaseSensitive,omitempty"`
	// AdvancedFilters - An array of advanced filters that are used for filtering event subscriptions.
	AdvancedFilters *[]BasicAdvancedFilter `json:"advancedFilters,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EventSubscriptionFilter struct.
func (esf *EventSubscriptionFilter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "subjectBeginsWith":
			if v != nil {
				var subjectBeginsWith string
				err = json.Unmarshal(*v, &subjectBeginsWith)
				if err != nil {
					return err
				}
				esf.SubjectBeginsWith = &subjectBeginsWith
			}
		case "subjectEndsWith":
			if v != nil {
				var subjectEndsWith string
				err = json.Unmarshal(*v, &subjectEndsWith)
				if err != nil {
					return err
				}
				esf.SubjectEndsWith = &subjectEndsWith
			}
		case "includedEventTypes":
			if v != nil {
				var includedEventTypes []string
				err = json.Unmarshal(*v, &includedEventTypes)
				if err != nil {
					return err
				}
				esf.IncludedEventTypes = &includedEventTypes
			}
		case "isSubjectCaseSensitive":
			if v != nil {
				var isSubjectCaseSensitive bool
				err = json.Unmarshal(*v, &isSubjectCaseSensitive)
				if err != nil {
					return err
				}
				esf.IsSubjectCaseSensitive = &isSubjectCaseSensitive
			}
		case "advancedFilters":
			if v != nil {
				advancedFilters, err := unmarshalBasicAdvancedFilterArray(*v)
				if err != nil {
					return err
				}
				esf.AdvancedFilters = &advancedFilters
			}
		}
	}

	return nil
}

// EventSubscriptionFullURL full endpoint url of an event subscription
type EventSubscriptionFullURL struct {
	autorest.Response `json:"-"`
	// EndpointURL - The URL that represents the endpoint of the destination of an event subscription.
	EndpointURL *string `json:"endpointUrl,omitempty"`
}

// EventSubscriptionIdentity the identity information with the event subscription.
type EventSubscriptionIdentity struct {
	// Type - The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity. Possible values include: 'SystemAssigned', 'UserAssigned'
	Type EventSubscriptionIdentityType `json:"type,omitempty"`
	// UserAssignedIdentity - The user identity associated with the resource.
	UserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
}

// EventSubscriptionProperties properties of the Event Subscription.
type EventSubscriptionProperties struct {
	// Topic - READ-ONLY; Name of the topic of the event subscription.
	Topic *string `json:"topic,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the event subscription. Possible values include: 'EventSubscriptionProvisioningStateCreating', 'EventSubscriptionProvisioningStateUpdating', 'EventSubscriptionProvisioningStateDeleting', 'EventSubscriptionProvisioningStateSucceeded', 'EventSubscriptionProvisioningStateCanceled', 'EventSubscriptionProvisioningStateFailed', 'EventSubscriptionProvisioningStateAwaitingManualAction'
	ProvisioningState EventSubscriptionProvisioningState `json:"provisioningState,omitempty"`
	// Destination - Information about the destination where events have to be delivered for the event subscription.
	// Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
	Destination BasicEventSubscriptionDestination `json:"destination,omitempty"`
	// DeliveryWithResourceIdentity - Information about the destination where events have to be delivered for the event subscription.
	// Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
	DeliveryWithResourceIdentity *DeliveryWithResourceIdentity `json:"deliveryWithResourceIdentity,omitempty"`
	// Filter - Information about the filter for the event subscription.
	Filter *EventSubscriptionFilter `json:"filter,omitempty"`
	// Labels - List of user defined labels.
	Labels *[]string `json:"labels,omitempty"`
	// ExpirationTimeUtc - Expiration time of the event subscription.
	ExpirationTimeUtc *date.Time `json:"expirationTimeUtc,omitempty"`
	// EventDeliverySchema - The event delivery schema for the event subscription. Possible values include: 'EventGridSchema', 'CustomInputSchema', 'CloudEventSchemaV10'
	EventDeliverySchema EventDeliverySchema `json:"eventDeliverySchema,omitempty"`
	// RetryPolicy - The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
	RetryPolicy *RetryPolicy `json:"retryPolicy,omitempty"`
	// DeadLetterDestination - The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
	// Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
	DeadLetterDestination BasicDeadLetterDestination `json:"deadLetterDestination,omitempty"`
	// DeadLetterWithResourceIdentity - The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
	// Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
	DeadLetterWithResourceIdentity *DeadLetterWithResourceIdentity `json:"deadLetterWithResourceIdentity,omitempty"`
}

// MarshalJSON is the custom marshaler for EventSubscriptionProperties.
func (esp EventSubscriptionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["destination"] = esp.Destination
	if esp.DeliveryWithResourceIdentity != nil {
		objectMap["deliveryWithResourceIdentity"] = esp.DeliveryWithResourceIdentity
	}
	if esp.Filter != nil {
		objectMap["filter"] = esp.Filter
	}
	if esp.Labels != nil {
		objectMap["labels"] = esp.Labels
	}
	if esp.ExpirationTimeUtc != nil {
		objectMap["expirationTimeUtc"] = esp.ExpirationTimeUtc
	}
	if esp.EventDeliverySchema != "" {
		objectMap["eventDeliverySchema"] = esp.EventDeliverySchema
	}
	if esp.RetryPolicy != nil {
		objectMap["retryPolicy"] = esp.RetryPolicy
	}
	objectMap["deadLetterDestination"] = esp.DeadLetterDestination
	if esp.DeadLetterWithResourceIdentity != nil {
		objectMap["deadLetterWithResourceIdentity"] = esp.DeadLetterWithResourceIdentity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EventSubscriptionProperties struct.
func (esp *EventSubscriptionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "topic":
			if v != nil {
				var topic string
				err = json.Unmarshal(*v, &topic)
				if err != nil {
					return err
				}
				esp.Topic = &topic
			}
		case "provisioningState":
			if v != nil {
				var provisioningState EventSubscriptionProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				esp.ProvisioningState = provisioningState
			}
		case "destination":
			if v != nil {
				destination, err := unmarshalBasicEventSubscriptionDestination(*v)
				if err != nil {
					return err
				}
				esp.Destination = destination
			}
		case "deliveryWithResourceIdentity":
			if v != nil {
				var deliveryWithResourceIdentity DeliveryWithResourceIdentity
				err = json.Unmarshal(*v, &deliveryWithResourceIdentity)
				if err != nil {
					return err
				}
				esp.DeliveryWithResourceIdentity = &deliveryWithResourceIdentity
			}
		case "filter":
			if v != nil {
				var filter EventSubscriptionFilter
				err = json.Unmarshal(*v, &filter)
				if err != nil {
					return err
				}
				esp.Filter = &filter
			}
		case "labels":
			if v != nil {
				var labels []string
				err = json.Unmarshal(*v, &labels)
				if err != nil {
					return err
				}
				esp.Labels = &labels
			}
		case "expirationTimeUtc":
			if v != nil {
				var expirationTimeUtc date.Time
				err = json.Unmarshal(*v, &expirationTimeUtc)
				if err != nil {
					return err
				}
				esp.ExpirationTimeUtc = &expirationTimeUtc
			}
		case "eventDeliverySchema":
			if v != nil {
				var eventDeliverySchema EventDeliverySchema
				err = json.Unmarshal(*v, &eventDeliverySchema)
				if err != nil {
					return err
				}
				esp.EventDeliverySchema = eventDeliverySchema
			}
		case "retryPolicy":
			if v != nil {
				var retryPolicy RetryPolicy
				err = json.Unmarshal(*v, &retryPolicy)
				if err != nil {
					return err
				}
				esp.RetryPolicy = &retryPolicy
			}
		case "deadLetterDestination":
			if v != nil {
				deadLetterDestination, err := unmarshalBasicDeadLetterDestination(*v)
				if err != nil {
					return err
				}
				esp.DeadLetterDestination = deadLetterDestination
			}
		case "deadLetterWithResourceIdentity":
			if v != nil {
				var deadLetterWithResourceIdentity DeadLetterWithResourceIdentity
				err = json.Unmarshal(*v, &deadLetterWithResourceIdentity)
				if err != nil {
					return err
				}
				esp.DeadLetterWithResourceIdentity = &deadLetterWithResourceIdentity
			}
		}
	}

	return nil
}

// EventSubscriptionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EventSubscriptionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EventSubscriptionsClient) (EventSubscription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EventSubscriptionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EventSubscriptionsCreateOrUpdateFuture.Result.
func (future *EventSubscriptionsCreateOrUpdateFuture) result(client EventSubscriptionsClient) (es EventSubscription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		es.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.EventSubscriptionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if es.Response.Response, err = future.GetResult(sender); err == nil && es.Response.Response.StatusCode != http.StatusNoContent {
		es, err = client.CreateOrUpdateResponder(es.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsCreateOrUpdateFuture", "Result", es.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EventSubscriptionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EventSubscriptionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EventSubscriptionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EventSubscriptionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EventSubscriptionsDeleteFuture.Result.
func (future *EventSubscriptionsDeleteFuture) result(client EventSubscriptionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.EventSubscriptionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EventSubscriptionsListResult result of the List EventSubscriptions operation
type EventSubscriptionsListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of EventSubscriptions
	Value *[]EventSubscription `json:"value,omitempty"`
	// NextLink - A link for the next page of event subscriptions
	NextLink *string `json:"nextLink,omitempty"`
}

// EventSubscriptionsListResultIterator provides access to a complete listing of EventSubscription values.
type EventSubscriptionsListResultIterator struct {
	i    int
	page EventSubscriptionsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventSubscriptionsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventSubscriptionsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EventSubscriptionsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventSubscriptionsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventSubscriptionsListResultIterator) Response() EventSubscriptionsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventSubscriptionsListResultIterator) Value() EventSubscription {
	if !iter.page.NotDone() {
		return EventSubscription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EventSubscriptionsListResultIterator type.
func NewEventSubscriptionsListResultIterator(page EventSubscriptionsListResultPage) EventSubscriptionsListResultIterator {
	return EventSubscriptionsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eslr EventSubscriptionsListResult) IsEmpty() bool {
	return eslr.Value == nil || len(*eslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eslr EventSubscriptionsListResult) hasNextLink() bool {
	return eslr.NextLink != nil && len(*eslr.NextLink) != 0
}

// eventSubscriptionsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eslr EventSubscriptionsListResult) eventSubscriptionsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !eslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eslr.NextLink)))
}

// EventSubscriptionsListResultPage contains a page of EventSubscription values.
type EventSubscriptionsListResultPage struct {
	fn   func(context.Context, EventSubscriptionsListResult) (EventSubscriptionsListResult, error)
	eslr EventSubscriptionsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventSubscriptionsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventSubscriptionsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eslr)
		if err != nil {
			return err
		}
		page.eslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EventSubscriptionsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventSubscriptionsListResultPage) NotDone() bool {
	return !page.eslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventSubscriptionsListResultPage) Response() EventSubscriptionsListResult {
	return page.eslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventSubscriptionsListResultPage) Values() []EventSubscription {
	if page.eslr.IsEmpty() {
		return nil
	}
	return *page.eslr.Value
}

// Creates a new instance of the EventSubscriptionsListResultPage type.
func NewEventSubscriptionsListResultPage(cur EventSubscriptionsListResult, getNextPage func(context.Context, EventSubscriptionsListResult) (EventSubscriptionsListResult, error)) EventSubscriptionsListResultPage {
	return EventSubscriptionsListResultPage{
		fn:   getNextPage,
		eslr: cur,
	}
}

// EventSubscriptionsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EventSubscriptionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EventSubscriptionsClient) (EventSubscription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EventSubscriptionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EventSubscriptionsUpdateFuture.Result.
func (future *EventSubscriptionsUpdateFuture) result(client EventSubscriptionsClient) (es EventSubscription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		es.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.EventSubscriptionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if es.Response.Response, err = future.GetResult(sender); err == nil && es.Response.Response.StatusCode != http.StatusNoContent {
		es, err = client.UpdateResponder(es.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsUpdateFuture", "Result", es.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EventSubscriptionUpdateParameters properties of the Event Subscription update.
type EventSubscriptionUpdateParameters struct {
	// Destination - Information about the destination where events have to be delivered for the event subscription.
	// Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
	Destination BasicEventSubscriptionDestination `json:"destination,omitempty"`
	// DeliveryWithResourceIdentity - Information about the destination where events have to be delivered for the event subscription.
	// Uses the managed identity setup on the parent resource (topic / domain) to acquire the authentication tokens being used during delivery / dead-lettering.
	DeliveryWithResourceIdentity *DeliveryWithResourceIdentity `json:"deliveryWithResourceIdentity,omitempty"`
	// Filter - Information about the filter for the event subscription.
	Filter *EventSubscriptionFilter `json:"filter,omitempty"`
	// Labels - List of user defined labels.
	Labels *[]string `json:"labels,omitempty"`
	// ExpirationTimeUtc - Information about the expiration time for the event subscription.
	ExpirationTimeUtc *date.Time `json:"expirationTimeUtc,omitempty"`
	// EventDeliverySchema - The event delivery schema for the event subscription. Possible values include: 'EventGridSchema', 'CustomInputSchema', 'CloudEventSchemaV10'
	EventDeliverySchema EventDeliverySchema `json:"eventDeliverySchema,omitempty"`
	// RetryPolicy - The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
	RetryPolicy *RetryPolicy `json:"retryPolicy,omitempty"`
	// DeadLetterDestination - The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
	// Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
	DeadLetterDestination BasicDeadLetterDestination `json:"deadLetterDestination,omitempty"`
	// DeadLetterWithResourceIdentity - The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
	// Uses the managed identity setup on the parent resource (topic / domain) to acquire the authentication tokens being used during delivery / dead-lettering.
	DeadLetterWithResourceIdentity *DeadLetterWithResourceIdentity `json:"deadLetterWithResourceIdentity,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EventSubscriptionUpdateParameters struct.
func (esup *EventSubscriptionUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "destination":
			if v != nil {
				destination, err := unmarshalBasicEventSubscriptionDestination(*v)
				if err != nil {
					return err
				}
				esup.Destination = destination
			}
		case "deliveryWithResourceIdentity":
			if v != nil {
				var deliveryWithResourceIdentity DeliveryWithResourceIdentity
				err = json.Unmarshal(*v, &deliveryWithResourceIdentity)
				if err != nil {
					return err
				}
				esup.DeliveryWithResourceIdentity = &deliveryWithResourceIdentity
			}
		case "filter":
			if v != nil {
				var filter EventSubscriptionFilter
				err = json.Unmarshal(*v, &filter)
				if err != nil {
					return err
				}
				esup.Filter = &filter
			}
		case "labels":
			if v != nil {
				var labels []string
				err = json.Unmarshal(*v, &labels)
				if err != nil {
					return err
				}
				esup.Labels = &labels
			}
		case "expirationTimeUtc":
			if v != nil {
				var expirationTimeUtc date.Time
				err = json.Unmarshal(*v, &expirationTimeUtc)
				if err != nil {
					return err
				}
				esup.ExpirationTimeUtc = &expirationTimeUtc
			}
		case "eventDeliverySchema":
			if v != nil {
				var eventDeliverySchema EventDeliverySchema
				err = json.Unmarshal(*v, &eventDeliverySchema)
				if err != nil {
					return err
				}
				esup.EventDeliverySchema = eventDeliverySchema
			}
		case "retryPolicy":
			if v != nil {
				var retryPolicy RetryPolicy
				err = json.Unmarshal(*v, &retryPolicy)
				if err != nil {
					return err
				}
				esup.RetryPolicy = &retryPolicy
			}
		case "deadLetterDestination":
			if v != nil {
				deadLetterDestination, err := unmarshalBasicDeadLetterDestination(*v)
				if err != nil {
					return err
				}
				esup.DeadLetterDestination = deadLetterDestination
			}
		case "deadLetterWithResourceIdentity":
			if v != nil {
				var deadLetterWithResourceIdentity DeadLetterWithResourceIdentity
				err = json.Unmarshal(*v, &deadLetterWithResourceIdentity)
				if err != nil {
					return err
				}
				esup.DeadLetterWithResourceIdentity = &deadLetterWithResourceIdentity
			}
		}
	}

	return nil
}

// EventType event Type for a subject under a topic
type EventType struct {
	// EventTypeProperties - Properties of the event type.
	*EventTypeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventType.
func (et EventType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if et.EventTypeProperties != nil {
		objectMap["properties"] = et.EventTypeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EventType struct.
func (et *EventType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventTypeProperties EventTypeProperties
				err = json.Unmarshal(*v, &eventTypeProperties)
				if err != nil {
					return err
				}
				et.EventTypeProperties = &eventTypeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				et.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				et.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				et.Type = &typeVar
			}
		}
	}

	return nil
}

// EventTypeProperties properties of the event type
type EventTypeProperties struct {
	// DisplayName - Display name of the event type.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Description of the event type.
	Description *string `json:"description,omitempty"`
	// SchemaURL - Url of the schema for this event type.
	SchemaURL *string `json:"schemaUrl,omitempty"`
	// IsInDefaultSet - IsInDefaultSet flag of the event type.
	IsInDefaultSet *bool `json:"isInDefaultSet,omitempty"`
}

// EventTypesListResult result of the List Event Types operation
type EventTypesListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of event types
	Value *[]EventType `json:"value,omitempty"`
}

// ExtensionTopic event grid Extension Topic. This is used for getting Event Grid related metrics for Azure
// resources.
type ExtensionTopic struct {
	autorest.Response `json:"-"`
	// ExtensionTopicProperties - Properties of the extension topic
	*ExtensionTopicProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtensionTopic.
func (et ExtensionTopic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if et.ExtensionTopicProperties != nil {
		objectMap["properties"] = et.ExtensionTopicProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExtensionTopic struct.
func (et *ExtensionTopic) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var extensionTopicProperties ExtensionTopicProperties
				err = json.Unmarshal(*v, &extensionTopicProperties)
				if err != nil {
					return err
				}
				et.ExtensionTopicProperties = &extensionTopicProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				et.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				et.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				et.Type = &typeVar
			}
		}
	}

	return nil
}

// ExtensionTopicProperties properties of the Extension Topic
type ExtensionTopicProperties struct {
	// Description - Description of the extension topic.
	Description *string `json:"description,omitempty"`
	// SystemTopic - System topic resource id which is mapped to the source.
	SystemTopic *string `json:"systemTopic,omitempty"`
}

// HybridConnectionEventSubscriptionDestination information about the HybridConnection destination for an
// event subscription.
type HybridConnectionEventSubscriptionDestination struct {
	// HybridConnectionEventSubscriptionDestinationProperties - Hybrid connection Properties of the event subscription destination.
	*HybridConnectionEventSubscriptionDestinationProperties `json:"properties,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeEventSubscriptionDestination', 'EndpointTypeWebHook', 'EndpointTypeEventHub', 'EndpointTypeStorageQueue', 'EndpointTypeHybridConnection', 'EndpointTypeServiceBusQueue', 'EndpointTypeServiceBusTopic', 'EndpointTypeAzureFunction'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	hcesd.EndpointType = EndpointTypeHybridConnection
	objectMap := make(map[string]interface{})
	if hcesd.HybridConnectionEventSubscriptionDestinationProperties != nil {
		objectMap["properties"] = hcesd.HybridConnectionEventSubscriptionDestinationProperties
	}
	if hcesd.EndpointType != "" {
		objectMap["endpointType"] = hcesd.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsWebHookEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventHubEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool) {
	return nil, false
}

// AsStorageQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) AsStorageQueueEventSubscriptionDestination() (*StorageQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsHybridConnectionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) AsHybridConnectionEventSubscriptionDestination() (*HybridConnectionEventSubscriptionDestination, bool) {
	return &hcesd, true
}

// AsServiceBusQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) AsServiceBusQueueEventSubscriptionDestination() (*ServiceBusQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsServiceBusTopicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) AsServiceBusTopicEventSubscriptionDestination() (*ServiceBusTopicEventSubscriptionDestination, bool) {
	return nil, false
}

// AsAzureFunctionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) AsAzureFunctionEventSubscriptionDestination() (*AzureFunctionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) AsEventSubscriptionDestination() (*EventSubscriptionDestination, bool) {
	return nil, false
}

// AsBasicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) AsBasicEventSubscriptionDestination() (BasicEventSubscriptionDestination, bool) {
	return &hcesd, true
}

// UnmarshalJSON is the custom unmarshaler for HybridConnectionEventSubscriptionDestination struct.
func (hcesd *HybridConnectionEventSubscriptionDestination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hybridConnectionEventSubscriptionDestinationProperties HybridConnectionEventSubscriptionDestinationProperties
				err = json.Unmarshal(*v, &hybridConnectionEventSubscriptionDestinationProperties)
				if err != nil {
					return err
				}
				hcesd.HybridConnectionEventSubscriptionDestinationProperties = &hybridConnectionEventSubscriptionDestinationProperties
			}
		case "endpointType":
			if v != nil {
				var endpointType EndpointType
				err = json.Unmarshal(*v, &endpointType)
				if err != nil {
					return err
				}
				hcesd.EndpointType = endpointType
			}
		}
	}

	return nil
}

// HybridConnectionEventSubscriptionDestinationProperties the properties for a hybrid connection
// destination.
type HybridConnectionEventSubscriptionDestinationProperties struct {
	// ResourceID - The Azure Resource ID of an hybrid connection that is the destination of an event subscription.
	ResourceID *string `json:"resourceId,omitempty"`
}

// IdentityInfo the identity information for the resource.
type IdentityInfo struct {
	// Type - The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity. Possible values include: 'IdentityTypeNone', 'IdentityTypeSystemAssigned', 'IdentityTypeUserAssigned', 'IdentityTypeSystemAssignedUserAssigned'
	Type IdentityType `json:"type,omitempty"`
	// PrincipalID - The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	// This property is currently not used and reserved for future usage.
	UserAssignedIdentities map[string]*UserIdentityProperties `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for IdentityInfo.
func (ii IdentityInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ii.Type != "" {
		objectMap["type"] = ii.Type
	}
	if ii.PrincipalID != nil {
		objectMap["principalId"] = ii.PrincipalID
	}
	if ii.TenantID != nil {
		objectMap["tenantId"] = ii.TenantID
	}
	if ii.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = ii.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// InboundIPRule ...
type InboundIPRule struct {
	// IPMask - IP Address in CIDR notation e.g., 10.0.0.0/8.
	IPMask *string `json:"ipMask,omitempty"`
	// Action - Action to perform based on the match or no match of the IpMask. Possible values include: 'Allow'
	Action IPActionType `json:"action,omitempty"`
}

// BasicInputSchemaMapping by default, Event Grid expects events to be in the Event Grid event schema. Specifying an
// input schema mapping enables publishing to Event Grid using a custom input schema. Currently, the only supported
// type of InputSchemaMapping is 'JsonInputSchemaMapping'.
type BasicInputSchemaMapping interface {
	AsJSONInputSchemaMapping() (*JSONInputSchemaMapping, bool)
	AsInputSchemaMapping() (*InputSchemaMapping, bool)
}

// InputSchemaMapping by default, Event Grid expects events to be in the Event Grid event schema. Specifying an
// input schema mapping enables publishing to Event Grid using a custom input schema. Currently, the only
// supported type of InputSchemaMapping is 'JsonInputSchemaMapping'.
type InputSchemaMapping struct {
	// InputSchemaMappingType - Possible values include: 'InputSchemaMappingTypeInputSchemaMapping', 'InputSchemaMappingTypeJSON'
	InputSchemaMappingType InputSchemaMappingType `json:"inputSchemaMappingType,omitempty"`
}

func unmarshalBasicInputSchemaMapping(body []byte) (BasicInputSchemaMapping, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["inputSchemaMappingType"] {
	case string(InputSchemaMappingTypeJSON):
		var jism JSONInputSchemaMapping
		err := json.Unmarshal(body, &jism)
		return jism, err
	default:
		var ism InputSchemaMapping
		err := json.Unmarshal(body, &ism)
		return ism, err
	}
}
func unmarshalBasicInputSchemaMappingArray(body []byte) ([]BasicInputSchemaMapping, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ismArray := make([]BasicInputSchemaMapping, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ism, err := unmarshalBasicInputSchemaMapping(*rawMessage)
		if err != nil {
			return nil, err
		}
		ismArray[index] = ism
	}
	return ismArray, nil
}

// MarshalJSON is the custom marshaler for InputSchemaMapping.
func (ism InputSchemaMapping) MarshalJSON() ([]byte, error) {
	ism.InputSchemaMappingType = InputSchemaMappingTypeInputSchemaMapping
	objectMap := make(map[string]interface{})
	if ism.InputSchemaMappingType != "" {
		objectMap["inputSchemaMappingType"] = ism.InputSchemaMappingType
	}
	return json.Marshal(objectMap)
}

// AsJSONInputSchemaMapping is the BasicInputSchemaMapping implementation for InputSchemaMapping.
func (ism InputSchemaMapping) AsJSONInputSchemaMapping() (*JSONInputSchemaMapping, bool) {
	return nil, false
}

// AsInputSchemaMapping is the BasicInputSchemaMapping implementation for InputSchemaMapping.
func (ism InputSchemaMapping) AsInputSchemaMapping() (*InputSchemaMapping, bool) {
	return &ism, true
}

// AsBasicInputSchemaMapping is the BasicInputSchemaMapping implementation for InputSchemaMapping.
func (ism InputSchemaMapping) AsBasicInputSchemaMapping() (BasicInputSchemaMapping, bool) {
	return &ism, true
}

// JSONField this is used to express the source of an input schema mapping for a single target field in the
// Event Grid Event schema. This is currently used in the mappings for the 'id', 'topic' and 'eventtime'
// properties. This represents a field in the input event schema.
type JSONField struct {
	// SourceField - Name of a field in the input event schema that's to be used as the source of a mapping.
	SourceField *string `json:"sourceField,omitempty"`
}

// JSONFieldWithDefault this is used to express the source of an input schema mapping for a single target
// field
// in the Event Grid Event schema. This is currently used in the mappings for the 'subject',
// 'eventtype' and 'dataversion' properties. This represents a field in the input event schema
// along with a default value to be used, and at least one of these two properties should be provided.
type JSONFieldWithDefault struct {
	// SourceField - Name of a field in the input event schema that's to be used as the source of a mapping.
	SourceField *string `json:"sourceField,omitempty"`
	// DefaultValue - The default value to be used for mapping when a SourceField is not provided or if there's no property with the specified name in the published JSON event payload.
	DefaultValue *string `json:"defaultValue,omitempty"`
}

// JSONInputSchemaMapping this enables publishing to Event Grid using a custom input schema. This can be
// used to map properties from a custom input JSON schema to the Event Grid event schema.
type JSONInputSchemaMapping struct {
	// JSONInputSchemaMappingProperties - JSON Properties of the input schema mapping
	*JSONInputSchemaMappingProperties `json:"properties,omitempty"`
	// InputSchemaMappingType - Possible values include: 'InputSchemaMappingTypeInputSchemaMapping', 'InputSchemaMappingTypeJSON'
	InputSchemaMappingType InputSchemaMappingType `json:"inputSchemaMappingType,omitempty"`
}

// MarshalJSON is the custom marshaler for JSONInputSchemaMapping.
func (jism JSONInputSchemaMapping) MarshalJSON() ([]byte, error) {
	jism.InputSchemaMappingType = InputSchemaMappingTypeJSON
	objectMap := make(map[string]interface{})
	if jism.JSONInputSchemaMappingProperties != nil {
		objectMap["properties"] = jism.JSONInputSchemaMappingProperties
	}
	if jism.InputSchemaMappingType != "" {
		objectMap["inputSchemaMappingType"] = jism.InputSchemaMappingType
	}
	return json.Marshal(objectMap)
}

// AsJSONInputSchemaMapping is the BasicInputSchemaMapping implementation for JSONInputSchemaMapping.
func (jism JSONInputSchemaMapping) AsJSONInputSchemaMapping() (*JSONInputSchemaMapping, bool) {
	return &jism, true
}

// AsInputSchemaMapping is the BasicInputSchemaMapping implementation for JSONInputSchemaMapping.
func (jism JSONInputSchemaMapping) AsInputSchemaMapping() (*InputSchemaMapping, bool) {
	return nil, false
}

// AsBasicInputSchemaMapping is the BasicInputSchemaMapping implementation for JSONInputSchemaMapping.
func (jism JSONInputSchemaMapping) AsBasicInputSchemaMapping() (BasicInputSchemaMapping, bool) {
	return &jism, true
}

// UnmarshalJSON is the custom unmarshaler for JSONInputSchemaMapping struct.
func (jism *JSONInputSchemaMapping) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var JSONInputSchemaMappingProperties JSONInputSchemaMappingProperties
				err = json.Unmarshal(*v, &JSONInputSchemaMappingProperties)
				if err != nil {
					return err
				}
				jism.JSONInputSchemaMappingProperties = &JSONInputSchemaMappingProperties
			}
		case "inputSchemaMappingType":
			if v != nil {
				var inputSchemaMappingType InputSchemaMappingType
				err = json.Unmarshal(*v, &inputSchemaMappingType)
				if err != nil {
					return err
				}
				jism.InputSchemaMappingType = inputSchemaMappingType
			}
		}
	}

	return nil
}

// JSONInputSchemaMappingProperties this can be used to map properties of a source schema (or default
// values, for certain supported properties) to properties of the EventGridEvent schema.
type JSONInputSchemaMappingProperties struct {
	// ID - The mapping information for the Id property of the Event Grid Event.
	ID *JSONField `json:"id,omitempty"`
	// Topic - The mapping information for the Topic property of the Event Grid Event.
	Topic *JSONField `json:"topic,omitempty"`
	// EventTime - The mapping information for the EventTime property of the Event Grid Event.
	EventTime *JSONField `json:"eventTime,omitempty"`
	// EventType - The mapping information for the EventType property of the Event Grid Event.
	EventType *JSONFieldWithDefault `json:"eventType,omitempty"`
	// Subject - The mapping information for the Subject property of the Event Grid Event.
	Subject *JSONFieldWithDefault `json:"subject,omitempty"`
	// DataVersion - The mapping information for the DataVersion property of the Event Grid Event.
	DataVersion *JSONFieldWithDefault `json:"dataVersion,omitempty"`
}

// NumberGreaterThanAdvancedFilter numberGreaterThan Advanced Filter.
type NumberGreaterThanAdvancedFilter struct {
	// Value - The filter value.
	Value *float64 `json:"value,omitempty"`
	// Key - The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
	// OperatorType - Possible values include: 'OperatorTypeAdvancedFilter', 'OperatorTypeNumberIn', 'OperatorTypeNumberNotIn', 'OperatorTypeNumberLessThan', 'OperatorTypeNumberGreaterThan', 'OperatorTypeNumberLessThanOrEquals', 'OperatorTypeNumberGreaterThanOrEquals', 'OperatorTypeBoolEquals', 'OperatorTypeStringIn', 'OperatorTypeStringNotIn', 'OperatorTypeStringBeginsWith', 'OperatorTypeStringEndsWith', 'OperatorTypeStringContains'
	OperatorType OperatorType `json:"operatorType,omitempty"`
}

// MarshalJSON is the custom marshaler for NumberGreaterThanAdvancedFilter.
func (ngtaf NumberGreaterThanAdvancedFilter) MarshalJSON() ([]byte, error) {
	ngtaf.OperatorType = OperatorTypeNumberGreaterThan
	objectMap := make(map[string]interface{})
	if ngtaf.Value != nil {
		objectMap["value"] = ngtaf.Value
	}
	if ngtaf.Key != nil {
		objectMap["key"] = ngtaf.Key
	}
	if ngtaf.OperatorType != "" {
		objectMap["operatorType"] = ngtaf.OperatorType
	}
	return json.Marshal(objectMap)
}

// AsNumberInAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanAdvancedFilter.
func (ngtaf NumberGreaterThanAdvancedFilter) AsNumberInAdvancedFilter() (*NumberInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberNotInAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanAdvancedFilter.
func (ngtaf NumberGreaterThanAdvancedFilter) AsNumberNotInAdvancedFilter() (*NumberNotInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanAdvancedFilter.
func (ngtaf NumberGreaterThanAdvancedFilter) AsNumberLessThanAdvancedFilter() (*NumberLessThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanAdvancedFilter.
func (ngtaf NumberGreaterThanAdvancedFilter) AsNumberGreaterThanAdvancedFilter() (*NumberGreaterThanAdvancedFilter, bool) {
	return &ngtaf, true
}

// AsNumberLessThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanAdvancedFilter.
func (ngtaf NumberGreaterThanAdvancedFilter) AsNumberLessThanOrEqualsAdvancedFilter() (*NumberLessThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanAdvancedFilter.
func (ngtaf NumberGreaterThanAdvancedFilter) AsNumberGreaterThanOrEqualsAdvancedFilter() (*NumberGreaterThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsBoolEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanAdvancedFilter.
func (ngtaf NumberGreaterThanAdvancedFilter) AsBoolEqualsAdvancedFilter() (*BoolEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsStringInAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanAdvancedFilter.
func (ngtaf NumberGreaterThanAdvancedFilter) AsStringInAdvancedFilter() (*StringInAdvancedFilter, bool) {
	return nil, false
}

// AsStringNotInAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanAdvancedFilter.
func (ngtaf NumberGreaterThanAdvancedFilter) AsStringNotInAdvancedFilter() (*StringNotInAdvancedFilter, bool) {
	return nil, false
}

// AsStringBeginsWithAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanAdvancedFilter.
func (ngtaf NumberGreaterThanAdvancedFilter) AsStringBeginsWithAdvancedFilter() (*StringBeginsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringEndsWithAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanAdvancedFilter.
func (ngtaf NumberGreaterThanAdvancedFilter) AsStringEndsWithAdvancedFilter() (*StringEndsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringContainsAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanAdvancedFilter.
func (ngtaf NumberGreaterThanAdvancedFilter) AsStringContainsAdvancedFilter() (*StringContainsAdvancedFilter, bool) {
	return nil, false
}

// AsAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanAdvancedFilter.
func (ngtaf NumberGreaterThanAdvancedFilter) AsAdvancedFilter() (*AdvancedFilter, bool) {
	return nil, false
}

// AsBasicAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanAdvancedFilter.
func (ngtaf NumberGreaterThanAdvancedFilter) AsBasicAdvancedFilter() (BasicAdvancedFilter, bool) {
	return &ngtaf, true
}

// NumberGreaterThanOrEqualsAdvancedFilter numberGreaterThanOrEquals Advanced Filter.
type NumberGreaterThanOrEqualsAdvancedFilter struct {
	// Value - The filter value.
	Value *float64 `json:"value,omitempty"`
	// Key - The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
	// OperatorType - Possible values include: 'OperatorTypeAdvancedFilter', 'OperatorTypeNumberIn', 'OperatorTypeNumberNotIn', 'OperatorTypeNumberLessThan', 'OperatorTypeNumberGreaterThan', 'OperatorTypeNumberLessThanOrEquals', 'OperatorTypeNumberGreaterThanOrEquals', 'OperatorTypeBoolEquals', 'OperatorTypeStringIn', 'OperatorTypeStringNotIn', 'OperatorTypeStringBeginsWith', 'OperatorTypeStringEndsWith', 'OperatorTypeStringContains'
	OperatorType OperatorType `json:"operatorType,omitempty"`
}

// MarshalJSON is the custom marshaler for NumberGreaterThanOrEqualsAdvancedFilter.
func (ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter) MarshalJSON() ([]byte, error) {
	ngtoeaf.OperatorType = OperatorTypeNumberGreaterThanOrEquals
	objectMap := make(map[string]interface{})
	if ngtoeaf.Value != nil {
		objectMap["value"] = ngtoeaf.Value
	}
	if ngtoeaf.Key != nil {
		objectMap["key"] = ngtoeaf.Key
	}
	if ngtoeaf.OperatorType != "" {
		objectMap["operatorType"] = ngtoeaf.OperatorType
	}
	return json.Marshal(objectMap)
}

// AsNumberInAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanOrEqualsAdvancedFilter.
func (ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter) AsNumberInAdvancedFilter() (*NumberInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberNotInAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanOrEqualsAdvancedFilter.
func (ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter) AsNumberNotInAdvancedFilter() (*NumberNotInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanOrEqualsAdvancedFilter.
func (ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter) AsNumberLessThanAdvancedFilter() (*NumberLessThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanOrEqualsAdvancedFilter.
func (ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter) AsNumberGreaterThanAdvancedFilter() (*NumberGreaterThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanOrEqualsAdvancedFilter.
func (ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter) AsNumberLessThanOrEqualsAdvancedFilter() (*NumberLessThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanOrEqualsAdvancedFilter.
func (ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter) AsNumberGreaterThanOrEqualsAdvancedFilter() (*NumberGreaterThanOrEqualsAdvancedFilter, bool) {
	return &ngtoeaf, true
}

// AsBoolEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanOrEqualsAdvancedFilter.
func (ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter) AsBoolEqualsAdvancedFilter() (*BoolEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsStringInAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanOrEqualsAdvancedFilter.
func (ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter) AsStringInAdvancedFilter() (*StringInAdvancedFilter, bool) {
	return nil, false
}

// AsStringNotInAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanOrEqualsAdvancedFilter.
func (ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter) AsStringNotInAdvancedFilter() (*StringNotInAdvancedFilter, bool) {
	return nil, false
}

// AsStringBeginsWithAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanOrEqualsAdvancedFilter.
func (ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter) AsStringBeginsWithAdvancedFilter() (*StringBeginsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringEndsWithAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanOrEqualsAdvancedFilter.
func (ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter) AsStringEndsWithAdvancedFilter() (*StringEndsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringContainsAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanOrEqualsAdvancedFilter.
func (ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter) AsStringContainsAdvancedFilter() (*StringContainsAdvancedFilter, bool) {
	return nil, false
}

// AsAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanOrEqualsAdvancedFilter.
func (ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter) AsAdvancedFilter() (*AdvancedFilter, bool) {
	return nil, false
}

// AsBasicAdvancedFilter is the BasicAdvancedFilter implementation for NumberGreaterThanOrEqualsAdvancedFilter.
func (ngtoeaf NumberGreaterThanOrEqualsAdvancedFilter) AsBasicAdvancedFilter() (BasicAdvancedFilter, bool) {
	return &ngtoeaf, true
}

// NumberInAdvancedFilter numberIn Advanced Filter.
type NumberInAdvancedFilter struct {
	// Values - The set of filter values.
	Values *[]float64 `json:"values,omitempty"`
	// Key - The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
	// OperatorType - Possible values include: 'OperatorTypeAdvancedFilter', 'OperatorTypeNumberIn', 'OperatorTypeNumberNotIn', 'OperatorTypeNumberLessThan', 'OperatorTypeNumberGreaterThan', 'OperatorTypeNumberLessThanOrEquals', 'OperatorTypeNumberGreaterThanOrEquals', 'OperatorTypeBoolEquals', 'OperatorTypeStringIn', 'OperatorTypeStringNotIn', 'OperatorTypeStringBeginsWith', 'OperatorTypeStringEndsWith', 'OperatorTypeStringContains'
	OperatorType OperatorType `json:"operatorType,omitempty"`
}

// MarshalJSON is the custom marshaler for NumberInAdvancedFilter.
func (niaf NumberInAdvancedFilter) MarshalJSON() ([]byte, error) {
	niaf.OperatorType = OperatorTypeNumberIn
	objectMap := make(map[string]interface{})
	if niaf.Values != nil {
		objectMap["values"] = niaf.Values
	}
	if niaf.Key != nil {
		objectMap["key"] = niaf.Key
	}
	if niaf.OperatorType != "" {
		objectMap["operatorType"] = niaf.OperatorType
	}
	return json.Marshal(objectMap)
}

// AsNumberInAdvancedFilter is the BasicAdvancedFilter implementation for NumberInAdvancedFilter.
func (niaf NumberInAdvancedFilter) AsNumberInAdvancedFilter() (*NumberInAdvancedFilter, bool) {
	return &niaf, true
}

// AsNumberNotInAdvancedFilter is the BasicAdvancedFilter implementation for NumberInAdvancedFilter.
func (niaf NumberInAdvancedFilter) AsNumberNotInAdvancedFilter() (*NumberNotInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanAdvancedFilter is the BasicAdvancedFilter implementation for NumberInAdvancedFilter.
func (niaf NumberInAdvancedFilter) AsNumberLessThanAdvancedFilter() (*NumberLessThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanAdvancedFilter is the BasicAdvancedFilter implementation for NumberInAdvancedFilter.
func (niaf NumberInAdvancedFilter) AsNumberGreaterThanAdvancedFilter() (*NumberGreaterThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberInAdvancedFilter.
func (niaf NumberInAdvancedFilter) AsNumberLessThanOrEqualsAdvancedFilter() (*NumberLessThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberInAdvancedFilter.
func (niaf NumberInAdvancedFilter) AsNumberGreaterThanOrEqualsAdvancedFilter() (*NumberGreaterThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsBoolEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberInAdvancedFilter.
func (niaf NumberInAdvancedFilter) AsBoolEqualsAdvancedFilter() (*BoolEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsStringInAdvancedFilter is the BasicAdvancedFilter implementation for NumberInAdvancedFilter.
func (niaf NumberInAdvancedFilter) AsStringInAdvancedFilter() (*StringInAdvancedFilter, bool) {
	return nil, false
}

// AsStringNotInAdvancedFilter is the BasicAdvancedFilter implementation for NumberInAdvancedFilter.
func (niaf NumberInAdvancedFilter) AsStringNotInAdvancedFilter() (*StringNotInAdvancedFilter, bool) {
	return nil, false
}

// AsStringBeginsWithAdvancedFilter is the BasicAdvancedFilter implementation for NumberInAdvancedFilter.
func (niaf NumberInAdvancedFilter) AsStringBeginsWithAdvancedFilter() (*StringBeginsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringEndsWithAdvancedFilter is the BasicAdvancedFilter implementation for NumberInAdvancedFilter.
func (niaf NumberInAdvancedFilter) AsStringEndsWithAdvancedFilter() (*StringEndsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringContainsAdvancedFilter is the BasicAdvancedFilter implementation for NumberInAdvancedFilter.
func (niaf NumberInAdvancedFilter) AsStringContainsAdvancedFilter() (*StringContainsAdvancedFilter, bool) {
	return nil, false
}

// AsAdvancedFilter is the BasicAdvancedFilter implementation for NumberInAdvancedFilter.
func (niaf NumberInAdvancedFilter) AsAdvancedFilter() (*AdvancedFilter, bool) {
	return nil, false
}

// AsBasicAdvancedFilter is the BasicAdvancedFilter implementation for NumberInAdvancedFilter.
func (niaf NumberInAdvancedFilter) AsBasicAdvancedFilter() (BasicAdvancedFilter, bool) {
	return &niaf, true
}

// NumberLessThanAdvancedFilter numberLessThan Advanced Filter.
type NumberLessThanAdvancedFilter struct {
	// Value - The filter value.
	Value *float64 `json:"value,omitempty"`
	// Key - The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
	// OperatorType - Possible values include: 'OperatorTypeAdvancedFilter', 'OperatorTypeNumberIn', 'OperatorTypeNumberNotIn', 'OperatorTypeNumberLessThan', 'OperatorTypeNumberGreaterThan', 'OperatorTypeNumberLessThanOrEquals', 'OperatorTypeNumberGreaterThanOrEquals', 'OperatorTypeBoolEquals', 'OperatorTypeStringIn', 'OperatorTypeStringNotIn', 'OperatorTypeStringBeginsWith', 'OperatorTypeStringEndsWith', 'OperatorTypeStringContains'
	OperatorType OperatorType `json:"operatorType,omitempty"`
}

// MarshalJSON is the custom marshaler for NumberLessThanAdvancedFilter.
func (nltaf NumberLessThanAdvancedFilter) MarshalJSON() ([]byte, error) {
	nltaf.OperatorType = OperatorTypeNumberLessThan
	objectMap := make(map[string]interface{})
	if nltaf.Value != nil {
		objectMap["value"] = nltaf.Value
	}
	if nltaf.Key != nil {
		objectMap["key"] = nltaf.Key
	}
	if nltaf.OperatorType != "" {
		objectMap["operatorType"] = nltaf.OperatorType
	}
	return json.Marshal(objectMap)
}

// AsNumberInAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanAdvancedFilter.
func (nltaf NumberLessThanAdvancedFilter) AsNumberInAdvancedFilter() (*NumberInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberNotInAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanAdvancedFilter.
func (nltaf NumberLessThanAdvancedFilter) AsNumberNotInAdvancedFilter() (*NumberNotInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanAdvancedFilter.
func (nltaf NumberLessThanAdvancedFilter) AsNumberLessThanAdvancedFilter() (*NumberLessThanAdvancedFilter, bool) {
	return &nltaf, true
}

// AsNumberGreaterThanAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanAdvancedFilter.
func (nltaf NumberLessThanAdvancedFilter) AsNumberGreaterThanAdvancedFilter() (*NumberGreaterThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanAdvancedFilter.
func (nltaf NumberLessThanAdvancedFilter) AsNumberLessThanOrEqualsAdvancedFilter() (*NumberLessThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanAdvancedFilter.
func (nltaf NumberLessThanAdvancedFilter) AsNumberGreaterThanOrEqualsAdvancedFilter() (*NumberGreaterThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsBoolEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanAdvancedFilter.
func (nltaf NumberLessThanAdvancedFilter) AsBoolEqualsAdvancedFilter() (*BoolEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsStringInAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanAdvancedFilter.
func (nltaf NumberLessThanAdvancedFilter) AsStringInAdvancedFilter() (*StringInAdvancedFilter, bool) {
	return nil, false
}

// AsStringNotInAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanAdvancedFilter.
func (nltaf NumberLessThanAdvancedFilter) AsStringNotInAdvancedFilter() (*StringNotInAdvancedFilter, bool) {
	return nil, false
}

// AsStringBeginsWithAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanAdvancedFilter.
func (nltaf NumberLessThanAdvancedFilter) AsStringBeginsWithAdvancedFilter() (*StringBeginsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringEndsWithAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanAdvancedFilter.
func (nltaf NumberLessThanAdvancedFilter) AsStringEndsWithAdvancedFilter() (*StringEndsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringContainsAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanAdvancedFilter.
func (nltaf NumberLessThanAdvancedFilter) AsStringContainsAdvancedFilter() (*StringContainsAdvancedFilter, bool) {
	return nil, false
}

// AsAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanAdvancedFilter.
func (nltaf NumberLessThanAdvancedFilter) AsAdvancedFilter() (*AdvancedFilter, bool) {
	return nil, false
}

// AsBasicAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanAdvancedFilter.
func (nltaf NumberLessThanAdvancedFilter) AsBasicAdvancedFilter() (BasicAdvancedFilter, bool) {
	return &nltaf, true
}

// NumberLessThanOrEqualsAdvancedFilter numberLessThanOrEquals Advanced Filter.
type NumberLessThanOrEqualsAdvancedFilter struct {
	// Value - The filter value.
	Value *float64 `json:"value,omitempty"`
	// Key - The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
	// OperatorType - Possible values include: 'OperatorTypeAdvancedFilter', 'OperatorTypeNumberIn', 'OperatorTypeNumberNotIn', 'OperatorTypeNumberLessThan', 'OperatorTypeNumberGreaterThan', 'OperatorTypeNumberLessThanOrEquals', 'OperatorTypeNumberGreaterThanOrEquals', 'OperatorTypeBoolEquals', 'OperatorTypeStringIn', 'OperatorTypeStringNotIn', 'OperatorTypeStringBeginsWith', 'OperatorTypeStringEndsWith', 'OperatorTypeStringContains'
	OperatorType OperatorType `json:"operatorType,omitempty"`
}

// MarshalJSON is the custom marshaler for NumberLessThanOrEqualsAdvancedFilter.
func (nltoeaf NumberLessThanOrEqualsAdvancedFilter) MarshalJSON() ([]byte, error) {
	nltoeaf.OperatorType = OperatorTypeNumberLessThanOrEquals
	objectMap := make(map[string]interface{})
	if nltoeaf.Value != nil {
		objectMap["value"] = nltoeaf.Value
	}
	if nltoeaf.Key != nil {
		objectMap["key"] = nltoeaf.Key
	}
	if nltoeaf.OperatorType != "" {
		objectMap["operatorType"] = nltoeaf.OperatorType
	}
	return json.Marshal(objectMap)
}

// AsNumberInAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanOrEqualsAdvancedFilter.
func (nltoeaf NumberLessThanOrEqualsAdvancedFilter) AsNumberInAdvancedFilter() (*NumberInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberNotInAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanOrEqualsAdvancedFilter.
func (nltoeaf NumberLessThanOrEqualsAdvancedFilter) AsNumberNotInAdvancedFilter() (*NumberNotInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanOrEqualsAdvancedFilter.
func (nltoeaf NumberLessThanOrEqualsAdvancedFilter) AsNumberLessThanAdvancedFilter() (*NumberLessThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanOrEqualsAdvancedFilter.
func (nltoeaf NumberLessThanOrEqualsAdvancedFilter) AsNumberGreaterThanAdvancedFilter() (*NumberGreaterThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanOrEqualsAdvancedFilter.
func (nltoeaf NumberLessThanOrEqualsAdvancedFilter) AsNumberLessThanOrEqualsAdvancedFilter() (*NumberLessThanOrEqualsAdvancedFilter, bool) {
	return &nltoeaf, true
}

// AsNumberGreaterThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanOrEqualsAdvancedFilter.
func (nltoeaf NumberLessThanOrEqualsAdvancedFilter) AsNumberGreaterThanOrEqualsAdvancedFilter() (*NumberGreaterThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsBoolEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanOrEqualsAdvancedFilter.
func (nltoeaf NumberLessThanOrEqualsAdvancedFilter) AsBoolEqualsAdvancedFilter() (*BoolEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsStringInAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanOrEqualsAdvancedFilter.
func (nltoeaf NumberLessThanOrEqualsAdvancedFilter) AsStringInAdvancedFilter() (*StringInAdvancedFilter, bool) {
	return nil, false
}

// AsStringNotInAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanOrEqualsAdvancedFilter.
func (nltoeaf NumberLessThanOrEqualsAdvancedFilter) AsStringNotInAdvancedFilter() (*StringNotInAdvancedFilter, bool) {
	return nil, false
}

// AsStringBeginsWithAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanOrEqualsAdvancedFilter.
func (nltoeaf NumberLessThanOrEqualsAdvancedFilter) AsStringBeginsWithAdvancedFilter() (*StringBeginsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringEndsWithAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanOrEqualsAdvancedFilter.
func (nltoeaf NumberLessThanOrEqualsAdvancedFilter) AsStringEndsWithAdvancedFilter() (*StringEndsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringContainsAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanOrEqualsAdvancedFilter.
func (nltoeaf NumberLessThanOrEqualsAdvancedFilter) AsStringContainsAdvancedFilter() (*StringContainsAdvancedFilter, bool) {
	return nil, false
}

// AsAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanOrEqualsAdvancedFilter.
func (nltoeaf NumberLessThanOrEqualsAdvancedFilter) AsAdvancedFilter() (*AdvancedFilter, bool) {
	return nil, false
}

// AsBasicAdvancedFilter is the BasicAdvancedFilter implementation for NumberLessThanOrEqualsAdvancedFilter.
func (nltoeaf NumberLessThanOrEqualsAdvancedFilter) AsBasicAdvancedFilter() (BasicAdvancedFilter, bool) {
	return &nltoeaf, true
}

// NumberNotInAdvancedFilter numberNotIn Advanced Filter.
type NumberNotInAdvancedFilter struct {
	// Values - The set of filter values.
	Values *[]float64 `json:"values,omitempty"`
	// Key - The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
	// OperatorType - Possible values include: 'OperatorTypeAdvancedFilter', 'OperatorTypeNumberIn', 'OperatorTypeNumberNotIn', 'OperatorTypeNumberLessThan', 'OperatorTypeNumberGreaterThan', 'OperatorTypeNumberLessThanOrEquals', 'OperatorTypeNumberGreaterThanOrEquals', 'OperatorTypeBoolEquals', 'OperatorTypeStringIn', 'OperatorTypeStringNotIn', 'OperatorTypeStringBeginsWith', 'OperatorTypeStringEndsWith', 'OperatorTypeStringContains'
	OperatorType OperatorType `json:"operatorType,omitempty"`
}

// MarshalJSON is the custom marshaler for NumberNotInAdvancedFilter.
func (nniaf NumberNotInAdvancedFilter) MarshalJSON() ([]byte, error) {
	nniaf.OperatorType = OperatorTypeNumberNotIn
	objectMap := make(map[string]interface{})
	if nniaf.Values != nil {
		objectMap["values"] = nniaf.Values
	}
	if nniaf.Key != nil {
		objectMap["key"] = nniaf.Key
	}
	if nniaf.OperatorType != "" {
		objectMap["operatorType"] = nniaf.OperatorType
	}
	return json.Marshal(objectMap)
}

// AsNumberInAdvancedFilter is the BasicAdvancedFilter implementation for NumberNotInAdvancedFilter.
func (nniaf NumberNotInAdvancedFilter) AsNumberInAdvancedFilter() (*NumberInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberNotInAdvancedFilter is the BasicAdvancedFilter implementation for NumberNotInAdvancedFilter.
func (nniaf NumberNotInAdvancedFilter) AsNumberNotInAdvancedFilter() (*NumberNotInAdvancedFilter, bool) {
	return &nniaf, true
}

// AsNumberLessThanAdvancedFilter is the BasicAdvancedFilter implementation for NumberNotInAdvancedFilter.
func (nniaf NumberNotInAdvancedFilter) AsNumberLessThanAdvancedFilter() (*NumberLessThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanAdvancedFilter is the BasicAdvancedFilter implementation for NumberNotInAdvancedFilter.
func (nniaf NumberNotInAdvancedFilter) AsNumberGreaterThanAdvancedFilter() (*NumberGreaterThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberNotInAdvancedFilter.
func (nniaf NumberNotInAdvancedFilter) AsNumberLessThanOrEqualsAdvancedFilter() (*NumberLessThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberNotInAdvancedFilter.
func (nniaf NumberNotInAdvancedFilter) AsNumberGreaterThanOrEqualsAdvancedFilter() (*NumberGreaterThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsBoolEqualsAdvancedFilter is the BasicAdvancedFilter implementation for NumberNotInAdvancedFilter.
func (nniaf NumberNotInAdvancedFilter) AsBoolEqualsAdvancedFilter() (*BoolEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsStringInAdvancedFilter is the BasicAdvancedFilter implementation for NumberNotInAdvancedFilter.
func (nniaf NumberNotInAdvancedFilter) AsStringInAdvancedFilter() (*StringInAdvancedFilter, bool) {
	return nil, false
}

// AsStringNotInAdvancedFilter is the BasicAdvancedFilter implementation for NumberNotInAdvancedFilter.
func (nniaf NumberNotInAdvancedFilter) AsStringNotInAdvancedFilter() (*StringNotInAdvancedFilter, bool) {
	return nil, false
}

// AsStringBeginsWithAdvancedFilter is the BasicAdvancedFilter implementation for NumberNotInAdvancedFilter.
func (nniaf NumberNotInAdvancedFilter) AsStringBeginsWithAdvancedFilter() (*StringBeginsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringEndsWithAdvancedFilter is the BasicAdvancedFilter implementation for NumberNotInAdvancedFilter.
func (nniaf NumberNotInAdvancedFilter) AsStringEndsWithAdvancedFilter() (*StringEndsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringContainsAdvancedFilter is the BasicAdvancedFilter implementation for NumberNotInAdvancedFilter.
func (nniaf NumberNotInAdvancedFilter) AsStringContainsAdvancedFilter() (*StringContainsAdvancedFilter, bool) {
	return nil, false
}

// AsAdvancedFilter is the BasicAdvancedFilter implementation for NumberNotInAdvancedFilter.
func (nniaf NumberNotInAdvancedFilter) AsAdvancedFilter() (*AdvancedFilter, bool) {
	return nil, false
}

// AsBasicAdvancedFilter is the BasicAdvancedFilter implementation for NumberNotInAdvancedFilter.
func (nniaf NumberNotInAdvancedFilter) AsBasicAdvancedFilter() (BasicAdvancedFilter, bool) {
	return &nniaf, true
}

// Operation represents an operation returned by the GetOperations request
type Operation struct {
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
	// Display - Display name of the operation
	Display *OperationInfo `json:"display,omitempty"`
	// Origin - Origin of the operation
	Origin *string `json:"origin,omitempty"`
	// Properties - Properties of the operation
	Properties interface{} `json:"properties,omitempty"`
}

// OperationInfo information about an operation
type OperationInfo struct {
	// Provider - Name of the provider
	Provider *string `json:"provider,omitempty"`
	// Resource - Name of the resource type
	Resource *string `json:"resource,omitempty"`
	// Operation - Name of the operation
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation
	Description *string `json:"description,omitempty"`
}

// OperationsListResult result of the List Operations operation
type OperationsListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of operations
	Value *[]Operation `json:"value,omitempty"`
}

// PartnerNamespace eventGrid Partner Namespace.
type PartnerNamespace struct {
	autorest.Response `json:"-"`
	// PartnerNamespaceProperties - Properties of the partner namespace.
	*PartnerNamespaceProperties `json:"properties,omitempty"`
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the resource.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PartnerNamespace.
func (pn PartnerNamespace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pn.PartnerNamespaceProperties != nil {
		objectMap["properties"] = pn.PartnerNamespaceProperties
	}
	if pn.Location != nil {
		objectMap["location"] = pn.Location
	}
	if pn.Tags != nil {
		objectMap["tags"] = pn.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PartnerNamespace struct.
func (pn *PartnerNamespace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var partnerNamespaceProperties PartnerNamespaceProperties
				err = json.Unmarshal(*v, &partnerNamespaceProperties)
				if err != nil {
					return err
				}
				pn.PartnerNamespaceProperties = &partnerNamespaceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pn.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pn.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pn.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pn.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pn.Type = &typeVar
			}
		}
	}

	return nil
}

// PartnerNamespaceProperties properties of the partner namespace.
type PartnerNamespaceProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the partner namespace. Possible values include: 'PartnerNamespaceProvisioningStateCreating', 'PartnerNamespaceProvisioningStateUpdating', 'PartnerNamespaceProvisioningStateDeleting', 'PartnerNamespaceProvisioningStateSucceeded', 'PartnerNamespaceProvisioningStateCanceled', 'PartnerNamespaceProvisioningStateFailed'
	ProvisioningState PartnerNamespaceProvisioningState `json:"provisioningState,omitempty"`
	// PartnerRegistrationFullyQualifiedID - The fully qualified ARM Id of the partner registration that should be associated with this partner namespace. This takes the following format:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}.
	PartnerRegistrationFullyQualifiedID *string `json:"partnerRegistrationFullyQualifiedId,omitempty"`
	// Endpoint - READ-ONLY; Endpoint for the partner namespace.
	Endpoint *string `json:"endpoint,omitempty"`
}

// MarshalJSON is the custom marshaler for PartnerNamespaceProperties.
func (pnp PartnerNamespaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pnp.PartnerRegistrationFullyQualifiedID != nil {
		objectMap["partnerRegistrationFullyQualifiedId"] = pnp.PartnerRegistrationFullyQualifiedID
	}
	return json.Marshal(objectMap)
}

// PartnerNamespaceRegenerateKeyRequest partnerNamespace regenerate shared access key request.
type PartnerNamespaceRegenerateKeyRequest struct {
	// KeyName - Key name to regenerate (key1 or key2).
	KeyName *string `json:"keyName,omitempty"`
}

// PartnerNamespacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PartnerNamespacesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PartnerNamespacesClient) (PartnerNamespace, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PartnerNamespacesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PartnerNamespacesCreateOrUpdateFuture.Result.
func (future *PartnerNamespacesCreateOrUpdateFuture) result(client PartnerNamespacesClient) (pn PartnerNamespace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.PartnerNamespacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pn.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.PartnerNamespacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pn.Response.Response, err = future.GetResult(sender); err == nil && pn.Response.Response.StatusCode != http.StatusNoContent {
		pn, err = client.CreateOrUpdateResponder(pn.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.PartnerNamespacesCreateOrUpdateFuture", "Result", pn.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PartnerNamespacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PartnerNamespacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PartnerNamespacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PartnerNamespacesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PartnerNamespacesDeleteFuture.Result.
func (future *PartnerNamespacesDeleteFuture) result(client PartnerNamespacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.PartnerNamespacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.PartnerNamespacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PartnerNamespaceSharedAccessKeys shared access keys of the partner namespace.
type PartnerNamespaceSharedAccessKeys struct {
	autorest.Response `json:"-"`
	// Key1 - Shared access key1 for the partner namespace.
	Key1 *string `json:"key1,omitempty"`
	// Key2 - Shared access key2 for the partner namespace.
	Key2 *string `json:"key2,omitempty"`
}

// PartnerNamespacesListResult result of the List Partner Namespaces operation
type PartnerNamespacesListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of partner namespaces.
	Value *[]PartnerNamespace `json:"value,omitempty"`
	// NextLink - A link for the next page of partner namespaces.
	NextLink *string `json:"nextLink,omitempty"`
}

// PartnerNamespacesListResultIterator provides access to a complete listing of PartnerNamespace values.
type PartnerNamespacesListResultIterator struct {
	i    int
	page PartnerNamespacesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PartnerNamespacesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PartnerNamespacesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PartnerNamespacesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PartnerNamespacesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PartnerNamespacesListResultIterator) Response() PartnerNamespacesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PartnerNamespacesListResultIterator) Value() PartnerNamespace {
	if !iter.page.NotDone() {
		return PartnerNamespace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PartnerNamespacesListResultIterator type.
func NewPartnerNamespacesListResultIterator(page PartnerNamespacesListResultPage) PartnerNamespacesListResultIterator {
	return PartnerNamespacesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pnlr PartnerNamespacesListResult) IsEmpty() bool {
	return pnlr.Value == nil || len(*pnlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pnlr PartnerNamespacesListResult) hasNextLink() bool {
	return pnlr.NextLink != nil && len(*pnlr.NextLink) != 0
}

// partnerNamespacesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pnlr PartnerNamespacesListResult) partnerNamespacesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !pnlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pnlr.NextLink)))
}

// PartnerNamespacesListResultPage contains a page of PartnerNamespace values.
type PartnerNamespacesListResultPage struct {
	fn   func(context.Context, PartnerNamespacesListResult) (PartnerNamespacesListResult, error)
	pnlr PartnerNamespacesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PartnerNamespacesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PartnerNamespacesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pnlr)
		if err != nil {
			return err
		}
		page.pnlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PartnerNamespacesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PartnerNamespacesListResultPage) NotDone() bool {
	return !page.pnlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PartnerNamespacesListResultPage) Response() PartnerNamespacesListResult {
	return page.pnlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PartnerNamespacesListResultPage) Values() []PartnerNamespace {
	if page.pnlr.IsEmpty() {
		return nil
	}
	return *page.pnlr.Value
}

// Creates a new instance of the PartnerNamespacesListResultPage type.
func NewPartnerNamespacesListResultPage(cur PartnerNamespacesListResult, getNextPage func(context.Context, PartnerNamespacesListResult) (PartnerNamespacesListResult, error)) PartnerNamespacesListResultPage {
	return PartnerNamespacesListResultPage{
		fn:   getNextPage,
		pnlr: cur,
	}
}

// PartnerNamespacesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PartnerNamespacesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PartnerNamespacesClient) (PartnerNamespace, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PartnerNamespacesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PartnerNamespacesUpdateFuture.Result.
func (future *PartnerNamespacesUpdateFuture) result(client PartnerNamespacesClient) (pn PartnerNamespace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.PartnerNamespacesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pn.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.PartnerNamespacesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pn.Response.Response, err = future.GetResult(sender); err == nil && pn.Response.Response.StatusCode != http.StatusNoContent {
		pn, err = client.UpdateResponder(pn.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.PartnerNamespacesUpdateFuture", "Result", pn.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PartnerNamespaceUpdateParameters properties of the PartnerNamespace update.
type PartnerNamespaceUpdateParameters struct {
	// Tags - Tags of the partner namespace.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PartnerNamespaceUpdateParameters.
func (pnup PartnerNamespaceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pnup.Tags != nil {
		objectMap["tags"] = pnup.Tags
	}
	return json.Marshal(objectMap)
}

// PartnerRegistration information about a partner registration.
type PartnerRegistration struct {
	autorest.Response `json:"-"`
	// PartnerRegistrationProperties - Properties of the partner registration.
	*PartnerRegistrationProperties `json:"properties,omitempty"`
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the resource.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PartnerRegistration.
func (pr PartnerRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pr.PartnerRegistrationProperties != nil {
		objectMap["properties"] = pr.PartnerRegistrationProperties
	}
	if pr.Location != nil {
		objectMap["location"] = pr.Location
	}
	if pr.Tags != nil {
		objectMap["tags"] = pr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PartnerRegistration struct.
func (pr *PartnerRegistration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var partnerRegistrationProperties PartnerRegistrationProperties
				err = json.Unmarshal(*v, &partnerRegistrationProperties)
				if err != nil {
					return err
				}
				pr.PartnerRegistrationProperties = &partnerRegistrationProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pr.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pr.Type = &typeVar
			}
		}
	}

	return nil
}

// PartnerRegistrationEventTypesListResult result of the List Partner Registration Event Types operation.
type PartnerRegistrationEventTypesListResult struct {
	// Value - A collection of partner registration event types.
	Value *[]EventType `json:"value,omitempty"`
	// NextLink - A link for the next page of partner registration event types.
	NextLink *string `json:"nextLink,omitempty"`
}

// PartnerRegistrationProperties properties of the partner registration.
type PartnerRegistrationProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the partner registration. Possible values include: 'PartnerRegistrationProvisioningStateCreating', 'PartnerRegistrationProvisioningStateUpdating', 'PartnerRegistrationProvisioningStateDeleting', 'PartnerRegistrationProvisioningStateSucceeded', 'PartnerRegistrationProvisioningStateCanceled', 'PartnerRegistrationProvisioningStateFailed'
	ProvisioningState PartnerRegistrationProvisioningState `json:"provisioningState,omitempty"`
	// PartnerName - Official name of the partner name. For example: "Contoso".
	PartnerName *string `json:"partnerName,omitempty"`
	// PartnerResourceTypeName - Name of the partner resource type.
	PartnerResourceTypeName *string `json:"partnerResourceTypeName,omitempty"`
	// PartnerResourceTypeDisplayName - Display name of the partner resource type.
	PartnerResourceTypeDisplayName *string `json:"partnerResourceTypeDisplayName,omitempty"`
	// PartnerResourceTypeDescription - Short description of the partner resource type. The length of this description should not exceed 256 characters.
	PartnerResourceTypeDescription *string `json:"partnerResourceTypeDescription,omitempty"`
	// LongDescription - Long description for the custom scenarios and integration to be displayed in the portal if needed.
	// Length of this description should not exceed 2048 characters.
	LongDescription *string `json:"longDescription,omitempty"`
	// PartnerCustomerServiceNumber - The customer service number of the publisher. The expected phone format should start with a '+' sign
	// followed by the country code. The remaining digits are then followed. Only digits and spaces are allowed and its
	// length cannot exceed 16 digits including country code. Examples of valid phone numbers are: +1 515 123 4567 and
	// +966 7 5115 2471. Examples of invalid phone numbers are: +1 (515) 123-4567, 1 515 123 4567 and +966 121 5115 24 7 551 1234 43
	PartnerCustomerServiceNumber *string `json:"partnerCustomerServiceNumber,omitempty"`
	// PartnerCustomerServiceExtension - The extension of the customer service number of the publisher. Only digits are allowed and number of digits should not exceed 10.
	PartnerCustomerServiceExtension *string `json:"partnerCustomerServiceExtension,omitempty"`
	// CustomerServiceURI - The extension of the customer service URI of the publisher.
	CustomerServiceURI *string `json:"customerServiceUri,omitempty"`
	// SetupURI - URI of the partner website that can be used by Azure customers to setup Event Grid
	// integration on an event source.
	SetupURI *string `json:"setupUri,omitempty"`
	// LogoURI - URI of the logo.
	LogoURI *string `json:"logoUri,omitempty"`
	// VisibilityState - Visibility state of the partner registration. Possible values include: 'Hidden', 'PublicPreview', 'GenerallyAvailable'
	VisibilityState PartnerRegistrationVisibilityState `json:"visibilityState,omitempty"`
	// AuthorizedAzureSubscriptionIds - List of Azure subscription Ids that are authorized to create a partner namespace
	// associated with this partner registration. This is an optional property. Creating
	// partner namespaces is always permitted under the same Azure subscription as the one used
	// for creating the partner registration.
	AuthorizedAzureSubscriptionIds *[]string `json:"authorizedAzureSubscriptionIds,omitempty"`
}

// MarshalJSON is the custom marshaler for PartnerRegistrationProperties.
func (prp PartnerRegistrationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prp.PartnerName != nil {
		objectMap["partnerName"] = prp.PartnerName
	}
	if prp.PartnerResourceTypeName != nil {
		objectMap["partnerResourceTypeName"] = prp.PartnerResourceTypeName
	}
	if prp.PartnerResourceTypeDisplayName != nil {
		objectMap["partnerResourceTypeDisplayName"] = prp.PartnerResourceTypeDisplayName
	}
	if prp.PartnerResourceTypeDescription != nil {
		objectMap["partnerResourceTypeDescription"] = prp.PartnerResourceTypeDescription
	}
	if prp.LongDescription != nil {
		objectMap["longDescription"] = prp.LongDescription
	}
	if prp.PartnerCustomerServiceNumber != nil {
		objectMap["partnerCustomerServiceNumber"] = prp.PartnerCustomerServiceNumber
	}
	if prp.PartnerCustomerServiceExtension != nil {
		objectMap["partnerCustomerServiceExtension"] = prp.PartnerCustomerServiceExtension
	}
	if prp.CustomerServiceURI != nil {
		objectMap["customerServiceUri"] = prp.CustomerServiceURI
	}
	if prp.SetupURI != nil {
		objectMap["setupUri"] = prp.SetupURI
	}
	if prp.LogoURI != nil {
		objectMap["logoUri"] = prp.LogoURI
	}
	if prp.VisibilityState != "" {
		objectMap["visibilityState"] = prp.VisibilityState
	}
	if prp.AuthorizedAzureSubscriptionIds != nil {
		objectMap["authorizedAzureSubscriptionIds"] = prp.AuthorizedAzureSubscriptionIds
	}
	return json.Marshal(objectMap)
}

// PartnerRegistrationsListResult result of the List Partner Registrations operation.
type PartnerRegistrationsListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of partner registrations.
	Value *[]PartnerRegistration `json:"value,omitempty"`
	// NextLink - A link for the next page of partner registrations.
	NextLink *string `json:"nextLink,omitempty"`
}

// PartnerRegistrationsListResultIterator provides access to a complete listing of PartnerRegistration
// values.
type PartnerRegistrationsListResultIterator struct {
	i    int
	page PartnerRegistrationsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PartnerRegistrationsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PartnerRegistrationsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PartnerRegistrationsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PartnerRegistrationsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PartnerRegistrationsListResultIterator) Response() PartnerRegistrationsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PartnerRegistrationsListResultIterator) Value() PartnerRegistration {
	if !iter.page.NotDone() {
		return PartnerRegistration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PartnerRegistrationsListResultIterator type.
func NewPartnerRegistrationsListResultIterator(page PartnerRegistrationsListResultPage) PartnerRegistrationsListResultIterator {
	return PartnerRegistrationsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (prlr PartnerRegistrationsListResult) IsEmpty() bool {
	return prlr.Value == nil || len(*prlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (prlr PartnerRegistrationsListResult) hasNextLink() bool {
	return prlr.NextLink != nil && len(*prlr.NextLink) != 0
}

// partnerRegistrationsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (prlr PartnerRegistrationsListResult) partnerRegistrationsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !prlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(prlr.NextLink)))
}

// PartnerRegistrationsListResultPage contains a page of PartnerRegistration values.
type PartnerRegistrationsListResultPage struct {
	fn   func(context.Context, PartnerRegistrationsListResult) (PartnerRegistrationsListResult, error)
	prlr PartnerRegistrationsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PartnerRegistrationsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PartnerRegistrationsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.prlr)
		if err != nil {
			return err
		}
		page.prlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PartnerRegistrationsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PartnerRegistrationsListResultPage) NotDone() bool {
	return !page.prlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PartnerRegistrationsListResultPage) Response() PartnerRegistrationsListResult {
	return page.prlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PartnerRegistrationsListResultPage) Values() []PartnerRegistration {
	if page.prlr.IsEmpty() {
		return nil
	}
	return *page.prlr.Value
}

// Creates a new instance of the PartnerRegistrationsListResultPage type.
func NewPartnerRegistrationsListResultPage(cur PartnerRegistrationsListResult, getNextPage func(context.Context, PartnerRegistrationsListResult) (PartnerRegistrationsListResult, error)) PartnerRegistrationsListResultPage {
	return PartnerRegistrationsListResultPage{
		fn:   getNextPage,
		prlr: cur,
	}
}

// PartnerRegistrationUpdateParameters properties of the Partner Registration update.
type PartnerRegistrationUpdateParameters struct {
	// Tags - Tags of the partner registration resource.
	Tags map[string]*string `json:"tags"`
	// PartnerTopicTypeName - Name of the partner topic type.
	PartnerTopicTypeName *string `json:"partnerTopicTypeName,omitempty"`
	// PartnerTopicTypeDisplayName - Display name of the partner topic type.
	PartnerTopicTypeDisplayName *string `json:"partnerTopicTypeDisplayName,omitempty"`
	// PartnerTopicTypeDescription - Description of the partner topic type.
	PartnerTopicTypeDescription *string `json:"partnerTopicTypeDescription,omitempty"`
	// SetupURI - URI of the partner website that can be used by Azure customers to setup Event Grid
	// integration on an event source.
	SetupURI *string `json:"setupUri,omitempty"`
	// LogoURI - URI of the partner logo.
	LogoURI *string `json:"logoUri,omitempty"`
	// AuthorizedAzureSubscriptionIds - List of IDs of Azure AD applications that are authorized to create a partner namespace
	// associated with this partner registration. This is an optional property. Creating
	// partner namespaces is always permitted under the same Azure subscription as the one used
	// for creating the partner registration.
	AuthorizedAzureSubscriptionIds *[]string `json:"authorizedAzureSubscriptionIds,omitempty"`
}

// MarshalJSON is the custom marshaler for PartnerRegistrationUpdateParameters.
func (prup PartnerRegistrationUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prup.Tags != nil {
		objectMap["tags"] = prup.Tags
	}
	if prup.PartnerTopicTypeName != nil {
		objectMap["partnerTopicTypeName"] = prup.PartnerTopicTypeName
	}
	if prup.PartnerTopicTypeDisplayName != nil {
		objectMap["partnerTopicTypeDisplayName"] = prup.PartnerTopicTypeDisplayName
	}
	if prup.PartnerTopicTypeDescription != nil {
		objectMap["partnerTopicTypeDescription"] = prup.PartnerTopicTypeDescription
	}
	if prup.SetupURI != nil {
		objectMap["setupUri"] = prup.SetupURI
	}
	if prup.LogoURI != nil {
		objectMap["logoUri"] = prup.LogoURI
	}
	if prup.AuthorizedAzureSubscriptionIds != nil {
		objectMap["authorizedAzureSubscriptionIds"] = prup.AuthorizedAzureSubscriptionIds
	}
	return json.Marshal(objectMap)
}

// PartnerTopic eventGrid Partner Topic.
type PartnerTopic struct {
	autorest.Response `json:"-"`
	// PartnerTopicProperties - Properties of the partner topic.
	*PartnerTopicProperties `json:"properties,omitempty"`
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the resource.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PartnerTopic.
func (pt PartnerTopic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pt.PartnerTopicProperties != nil {
		objectMap["properties"] = pt.PartnerTopicProperties
	}
	if pt.Location != nil {
		objectMap["location"] = pt.Location
	}
	if pt.Tags != nil {
		objectMap["tags"] = pt.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PartnerTopic struct.
func (pt *PartnerTopic) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var partnerTopicProperties PartnerTopicProperties
				err = json.Unmarshal(*v, &partnerTopicProperties)
				if err != nil {
					return err
				}
				pt.PartnerTopicProperties = &partnerTopicProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pt.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pt.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pt.Type = &typeVar
			}
		}
	}

	return nil
}

// PartnerTopicEventSubscriptionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type PartnerTopicEventSubscriptionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PartnerTopicEventSubscriptionsClient) (EventSubscription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PartnerTopicEventSubscriptionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PartnerTopicEventSubscriptionsCreateOrUpdateFuture.Result.
func (future *PartnerTopicEventSubscriptionsCreateOrUpdateFuture) result(client PartnerTopicEventSubscriptionsClient) (es EventSubscription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.PartnerTopicEventSubscriptionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		es.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.PartnerTopicEventSubscriptionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if es.Response.Response, err = future.GetResult(sender); err == nil && es.Response.Response.StatusCode != http.StatusNoContent {
		es, err = client.CreateOrUpdateResponder(es.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.PartnerTopicEventSubscriptionsCreateOrUpdateFuture", "Result", es.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PartnerTopicEventSubscriptionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PartnerTopicEventSubscriptionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PartnerTopicEventSubscriptionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PartnerTopicEventSubscriptionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PartnerTopicEventSubscriptionsDeleteFuture.Result.
func (future *PartnerTopicEventSubscriptionsDeleteFuture) result(client PartnerTopicEventSubscriptionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.PartnerTopicEventSubscriptionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.PartnerTopicEventSubscriptionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PartnerTopicEventSubscriptionsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PartnerTopicEventSubscriptionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PartnerTopicEventSubscriptionsClient) (EventSubscription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PartnerTopicEventSubscriptionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PartnerTopicEventSubscriptionsUpdateFuture.Result.
func (future *PartnerTopicEventSubscriptionsUpdateFuture) result(client PartnerTopicEventSubscriptionsClient) (es EventSubscription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.PartnerTopicEventSubscriptionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		es.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.PartnerTopicEventSubscriptionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if es.Response.Response, err = future.GetResult(sender); err == nil && es.Response.Response.StatusCode != http.StatusNoContent {
		es, err = client.UpdateResponder(es.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.PartnerTopicEventSubscriptionsUpdateFuture", "Result", es.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PartnerTopicProperties properties of the Partner Topic.
type PartnerTopicProperties struct {
	// Source - Source associated with this partner topic. This represents a unique partner resource.
	Source *string `json:"source,omitempty"`
	// ExpirationTimeIfNotActivatedUtc - Expiration time of the partner topic. If this timer expires while the partner topic is still never activated,
	// the partner topic and corresponding event channel are deleted.
	ExpirationTimeIfNotActivatedUtc *date.Time `json:"expirationTimeIfNotActivatedUtc,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the partner topic. Possible values include: 'PartnerTopicProvisioningStateCreating', 'PartnerTopicProvisioningStateUpdating', 'PartnerTopicProvisioningStateDeleting', 'PartnerTopicProvisioningStateSucceeded', 'PartnerTopicProvisioningStateCanceled', 'PartnerTopicProvisioningStateFailed'
	ProvisioningState PartnerTopicProvisioningState `json:"provisioningState,omitempty"`
	// ActivationState - Activation state of the partner topic. Possible values include: 'NeverActivated', 'Activated', 'Deactivated'
	ActivationState PartnerTopicActivationState `json:"activationState,omitempty"`
	// PartnerTopicFriendlyDescription - Friendly description about the topic. This can be set by the publisher/partner to show custom description for the customer partner topic.
	// This will be helpful to remove any ambiguity of the origin of creation of the partner topic for the customer.
	PartnerTopicFriendlyDescription *string `json:"partnerTopicFriendlyDescription,omitempty"`
}

// MarshalJSON is the custom marshaler for PartnerTopicProperties.
func (ptp PartnerTopicProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ptp.Source != nil {
		objectMap["source"] = ptp.Source
	}
	if ptp.ExpirationTimeIfNotActivatedUtc != nil {
		objectMap["expirationTimeIfNotActivatedUtc"] = ptp.ExpirationTimeIfNotActivatedUtc
	}
	if ptp.ActivationState != "" {
		objectMap["activationState"] = ptp.ActivationState
	}
	if ptp.PartnerTopicFriendlyDescription != nil {
		objectMap["partnerTopicFriendlyDescription"] = ptp.PartnerTopicFriendlyDescription
	}
	return json.Marshal(objectMap)
}

// PartnerTopicsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PartnerTopicsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PartnerTopicsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PartnerTopicsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PartnerTopicsDeleteFuture.Result.
func (future *PartnerTopicsDeleteFuture) result(client PartnerTopicsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.PartnerTopicsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.PartnerTopicsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PartnerTopicsListResult result of the List Partner Topics operation.
type PartnerTopicsListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of partner topics.
	Value *[]PartnerTopic `json:"value,omitempty"`
	// NextLink - A link for the next page of partner topics.
	NextLink *string `json:"nextLink,omitempty"`
}

// PartnerTopicsListResultIterator provides access to a complete listing of PartnerTopic values.
type PartnerTopicsListResultIterator struct {
	i    int
	page PartnerTopicsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PartnerTopicsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PartnerTopicsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PartnerTopicsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PartnerTopicsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PartnerTopicsListResultIterator) Response() PartnerTopicsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PartnerTopicsListResultIterator) Value() PartnerTopic {
	if !iter.page.NotDone() {
		return PartnerTopic{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PartnerTopicsListResultIterator type.
func NewPartnerTopicsListResultIterator(page PartnerTopicsListResultPage) PartnerTopicsListResultIterator {
	return PartnerTopicsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ptlr PartnerTopicsListResult) IsEmpty() bool {
	return ptlr.Value == nil || len(*ptlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ptlr PartnerTopicsListResult) hasNextLink() bool {
	return ptlr.NextLink != nil && len(*ptlr.NextLink) != 0
}

// partnerTopicsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ptlr PartnerTopicsListResult) partnerTopicsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ptlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ptlr.NextLink)))
}

// PartnerTopicsListResultPage contains a page of PartnerTopic values.
type PartnerTopicsListResultPage struct {
	fn   func(context.Context, PartnerTopicsListResult) (PartnerTopicsListResult, error)
	ptlr PartnerTopicsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PartnerTopicsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PartnerTopicsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ptlr)
		if err != nil {
			return err
		}
		page.ptlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PartnerTopicsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PartnerTopicsListResultPage) NotDone() bool {
	return !page.ptlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PartnerTopicsListResultPage) Response() PartnerTopicsListResult {
	return page.ptlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PartnerTopicsListResultPage) Values() []PartnerTopic {
	if page.ptlr.IsEmpty() {
		return nil
	}
	return *page.ptlr.Value
}

// Creates a new instance of the PartnerTopicsListResultPage type.
func NewPartnerTopicsListResultPage(cur PartnerTopicsListResult, getNextPage func(context.Context, PartnerTopicsListResult) (PartnerTopicsListResult, error)) PartnerTopicsListResultPage {
	return PartnerTopicsListResultPage{
		fn:   getNextPage,
		ptlr: cur,
	}
}

// PartnerTopicType properties of a partner topic type.
type PartnerTopicType struct {
	// PartnerTopicTypeProperties - Properties of the partner topic type.
	*PartnerTopicTypeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PartnerTopicType.
func (ptt PartnerTopicType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ptt.PartnerTopicTypeProperties != nil {
		objectMap["properties"] = ptt.PartnerTopicTypeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PartnerTopicType struct.
func (ptt *PartnerTopicType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var partnerTopicTypeProperties PartnerTopicTypeProperties
				err = json.Unmarshal(*v, &partnerTopicTypeProperties)
				if err != nil {
					return err
				}
				ptt.PartnerTopicTypeProperties = &partnerTopicTypeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ptt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ptt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ptt.Type = &typeVar
			}
		}
	}

	return nil
}

// PartnerTopicTypeProperties properties of a partner topic type.
type PartnerTopicTypeProperties struct {
	// PartnerName - Official name of the partner.
	PartnerName *string `json:"partnerName,omitempty"`
	// TopicTypeName - Name of the partner topic type. This name should be unique among all partner topic types names.
	TopicTypeName *string `json:"topicTypeName,omitempty"`
	// DisplayName - Display Name for the partner topic type.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Description of the partner topic type.
	Description *string `json:"description,omitempty"`
	// SetupURI - URI of the partner website that can be used by Azure customers to setup Event Grid
	// integration on an event source.
	SetupURI *string `json:"setupUri,omitempty"`
	// AuthorizationState - Status of whether the customer has authorized a partner to create partner topics
	// in the customer's subscription. Possible values include: 'NotApplicable', 'NotAuthorized', 'Authorized'
	AuthorizationState PartnerTopicTypeAuthorizationState `json:"authorizationState,omitempty"`
}

// PartnerTopicTypesListResult result of the List Partner Topic Types operation.
type PartnerTopicTypesListResult struct {
	// Value - A collection of partner topic types.
	Value *[]PartnerTopicType `json:"value,omitempty"`
}

// PartnerTopicUpdateParameters properties of the Partner Topic update.
type PartnerTopicUpdateParameters struct {
	// Tags - Tags of the partner topic.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PartnerTopicUpdateParameters.
func (ptup PartnerTopicUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ptup.Tags != nil {
		objectMap["tags"] = ptup.Tags
	}
	return json.Marshal(objectMap)
}

// PrivateEndpoint privateEndpoint information.
type PrivateEndpoint struct {
	// ID - The ARM identifier for Private Endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection ...
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnection.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult result of the list of all private endpoint connections operation.
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of private endpoint connection resources.
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
	// NextLink - A link for the next page of private endpoint connection resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateEndpointConnectionListResultIterator provides access to a complete listing of
// PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultIterator struct {
	i    int
	page PrivateEndpointConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointConnectionListResultIterator) Response() PrivateEndpointConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointConnectionListResultIterator) Value() PrivateEndpointConnection {
	if !iter.page.NotDone() {
		return PrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointConnectionListResultIterator type.
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return PrivateEndpointConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (peclr PrivateEndpointConnectionListResult) IsEmpty() bool {
	return peclr.Value == nil || len(*peclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (peclr PrivateEndpointConnectionListResult) hasNextLink() bool {
	return peclr.NextLink != nil && len(*peclr.NextLink) != 0
}

// privateEndpointConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (peclr PrivateEndpointConnectionListResult) privateEndpointConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !peclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(peclr.NextLink)))
}

// PrivateEndpointConnectionListResultPage contains a page of PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultPage struct {
	fn    func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)
	peclr PrivateEndpointConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.peclr)
		if err != nil {
			return err
		}
		page.peclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointConnectionListResultPage) NotDone() bool {
	return !page.peclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointConnectionListResultPage) Response() PrivateEndpointConnectionListResult {
	return page.peclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointConnectionListResultPage) Values() []PrivateEndpointConnection {
	if page.peclr.IsEmpty() {
		return nil
	}
	return *page.peclr.Value
}

// Creates a new instance of the PrivateEndpointConnectionListResultPage type.
func NewPrivateEndpointConnectionListResultPage(cur PrivateEndpointConnectionListResult, getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return PrivateEndpointConnectionListResultPage{
		fn:    getNextPage,
		peclr: cur,
	}
}

// PrivateEndpointConnectionProperties properties of the private endpoint connection resource.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The Private Endpoint resource for this Connection.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// GroupIds - GroupIds from the private link service resource.
	GroupIds *[]string `json:"groupIds,omitempty"`
	// PrivateLinkServiceConnectionState - Details about the state of the connection.
	PrivateLinkServiceConnectionState *ConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - Provisioning state of the Private Endpoint Connection. Possible values include: 'ResourceProvisioningStateCreating', 'ResourceProvisioningStateUpdating', 'ResourceProvisioningStateDeleting', 'ResourceProvisioningStateSucceeded', 'ResourceProvisioningStateCanceled', 'ResourceProvisioningStateFailed'
	ProvisioningState ResourceProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateEndpointConnectionsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsUpdateFuture.Result.
func (future *PrivateEndpointConnectionsUpdateFuture) result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.PrivateEndpointConnectionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.PrivateEndpointConnectionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.UpdateResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.PrivateEndpointConnectionsUpdateFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateLinkResource information of the private link resource.
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// PrivateLinkResourceProperties - Properties of the private link resource.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	if plr.ID != nil {
		objectMap["id"] = plr.ID
	}
	if plr.Name != nil {
		objectMap["name"] = plr.Name
	}
	if plr.Type != nil {
		objectMap["type"] = plr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResourceProperties ...
type PrivateLinkResourceProperties struct {
	GroupID           *string   `json:"groupId,omitempty"`
	DisplayName       *string   `json:"displayName,omitempty"`
	RequiredMembers   *[]string `json:"requiredMembers,omitempty"`
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// PrivateLinkResourcesListResult result of the List private link resources operation.
type PrivateLinkResourcesListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
	// NextLink - A link for the next page of private link resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateLinkResourcesListResultIterator provides access to a complete listing of PrivateLinkResource
// values.
type PrivateLinkResourcesListResultIterator struct {
	i    int
	page PrivateLinkResourcesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateLinkResourcesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourcesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateLinkResourcesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateLinkResourcesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateLinkResourcesListResultIterator) Response() PrivateLinkResourcesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateLinkResourcesListResultIterator) Value() PrivateLinkResource {
	if !iter.page.NotDone() {
		return PrivateLinkResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateLinkResourcesListResultIterator type.
func NewPrivateLinkResourcesListResultIterator(page PrivateLinkResourcesListResultPage) PrivateLinkResourcesListResultIterator {
	return PrivateLinkResourcesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plrlr PrivateLinkResourcesListResult) IsEmpty() bool {
	return plrlr.Value == nil || len(*plrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plrlr PrivateLinkResourcesListResult) hasNextLink() bool {
	return plrlr.NextLink != nil && len(*plrlr.NextLink) != 0
}

// privateLinkResourcesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plrlr PrivateLinkResourcesListResult) privateLinkResourcesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plrlr.NextLink)))
}

// PrivateLinkResourcesListResultPage contains a page of PrivateLinkResource values.
type PrivateLinkResourcesListResultPage struct {
	fn    func(context.Context, PrivateLinkResourcesListResult) (PrivateLinkResourcesListResult, error)
	plrlr PrivateLinkResourcesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateLinkResourcesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourcesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plrlr)
		if err != nil {
			return err
		}
		page.plrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateLinkResourcesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateLinkResourcesListResultPage) NotDone() bool {
	return !page.plrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateLinkResourcesListResultPage) Response() PrivateLinkResourcesListResult {
	return page.plrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateLinkResourcesListResultPage) Values() []PrivateLinkResource {
	if page.plrlr.IsEmpty() {
		return nil
	}
	return *page.plrlr.Value
}

// Creates a new instance of the PrivateLinkResourcesListResultPage type.
func NewPrivateLinkResourcesListResultPage(cur PrivateLinkResourcesListResult, getNextPage func(context.Context, PrivateLinkResourcesListResult) (PrivateLinkResourcesListResult, error)) PrivateLinkResourcesListResultPage {
	return PrivateLinkResourcesListResultPage{
		fn:    getNextPage,
		plrlr: cur,
	}
}

// Resource definition of a Resource
type Resource struct {
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSku describes an EventGrid Resource Sku.
type ResourceSku struct {
	// Name - The Sku name of the resource. The possible values are: Basic or Premium. Possible values include: 'Basic', 'Premium'
	Name Sku `json:"name,omitempty"`
}

// RetryPolicy information about the retry policy for an event subscription.
type RetryPolicy struct {
	// MaxDeliveryAttempts - Maximum number of delivery retry attempts for events.
	MaxDeliveryAttempts *int32 `json:"maxDeliveryAttempts,omitempty"`
	// EventTimeToLiveInMinutes - Time To Live (in minutes) for events.
	EventTimeToLiveInMinutes *int32 `json:"eventTimeToLiveInMinutes,omitempty"`
}

// ServiceBusQueueEventSubscriptionDestination information about the service bus destination for an event
// subscription.
type ServiceBusQueueEventSubscriptionDestination struct {
	// ServiceBusQueueEventSubscriptionDestinationProperties - Service Bus Properties of the event subscription destination.
	*ServiceBusQueueEventSubscriptionDestinationProperties `json:"properties,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeEventSubscriptionDestination', 'EndpointTypeWebHook', 'EndpointTypeEventHub', 'EndpointTypeStorageQueue', 'EndpointTypeHybridConnection', 'EndpointTypeServiceBusQueue', 'EndpointTypeServiceBusTopic', 'EndpointTypeAzureFunction'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceBusQueueEventSubscriptionDestination.
func (sbqesd ServiceBusQueueEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	sbqesd.EndpointType = EndpointTypeServiceBusQueue
	objectMap := make(map[string]interface{})
	if sbqesd.ServiceBusQueueEventSubscriptionDestinationProperties != nil {
		objectMap["properties"] = sbqesd.ServiceBusQueueEventSubscriptionDestinationProperties
	}
	if sbqesd.EndpointType != "" {
		objectMap["endpointType"] = sbqesd.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsWebHookEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusQueueEventSubscriptionDestination.
func (sbqesd ServiceBusQueueEventSubscriptionDestination) AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventHubEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusQueueEventSubscriptionDestination.
func (sbqesd ServiceBusQueueEventSubscriptionDestination) AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool) {
	return nil, false
}

// AsStorageQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusQueueEventSubscriptionDestination.
func (sbqesd ServiceBusQueueEventSubscriptionDestination) AsStorageQueueEventSubscriptionDestination() (*StorageQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsHybridConnectionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusQueueEventSubscriptionDestination.
func (sbqesd ServiceBusQueueEventSubscriptionDestination) AsHybridConnectionEventSubscriptionDestination() (*HybridConnectionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsServiceBusQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusQueueEventSubscriptionDestination.
func (sbqesd ServiceBusQueueEventSubscriptionDestination) AsServiceBusQueueEventSubscriptionDestination() (*ServiceBusQueueEventSubscriptionDestination, bool) {
	return &sbqesd, true
}

// AsServiceBusTopicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusQueueEventSubscriptionDestination.
func (sbqesd ServiceBusQueueEventSubscriptionDestination) AsServiceBusTopicEventSubscriptionDestination() (*ServiceBusTopicEventSubscriptionDestination, bool) {
	return nil, false
}

// AsAzureFunctionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusQueueEventSubscriptionDestination.
func (sbqesd ServiceBusQueueEventSubscriptionDestination) AsAzureFunctionEventSubscriptionDestination() (*AzureFunctionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusQueueEventSubscriptionDestination.
func (sbqesd ServiceBusQueueEventSubscriptionDestination) AsEventSubscriptionDestination() (*EventSubscriptionDestination, bool) {
	return nil, false
}

// AsBasicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusQueueEventSubscriptionDestination.
func (sbqesd ServiceBusQueueEventSubscriptionDestination) AsBasicEventSubscriptionDestination() (BasicEventSubscriptionDestination, bool) {
	return &sbqesd, true
}

// UnmarshalJSON is the custom unmarshaler for ServiceBusQueueEventSubscriptionDestination struct.
func (sbqesd *ServiceBusQueueEventSubscriptionDestination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceBusQueueEventSubscriptionDestinationProperties ServiceBusQueueEventSubscriptionDestinationProperties
				err = json.Unmarshal(*v, &serviceBusQueueEventSubscriptionDestinationProperties)
				if err != nil {
					return err
				}
				sbqesd.ServiceBusQueueEventSubscriptionDestinationProperties = &serviceBusQueueEventSubscriptionDestinationProperties
			}
		case "endpointType":
			if v != nil {
				var endpointType EndpointType
				err = json.Unmarshal(*v, &endpointType)
				if err != nil {
					return err
				}
				sbqesd.EndpointType = endpointType
			}
		}
	}

	return nil
}

// ServiceBusQueueEventSubscriptionDestinationProperties the properties that represent the Service Bus
// destination of an event subscription.
type ServiceBusQueueEventSubscriptionDestinationProperties struct {
	// ResourceID - The Azure Resource Id that represents the endpoint of the Service Bus destination of an event subscription.
	ResourceID *string `json:"resourceId,omitempty"`
}

// ServiceBusTopicEventSubscriptionDestination information about the service bus topic destination for an
// event subscription.
type ServiceBusTopicEventSubscriptionDestination struct {
	// ServiceBusTopicEventSubscriptionDestinationProperties - Service Bus Topic Properties of the event subscription destination.
	*ServiceBusTopicEventSubscriptionDestinationProperties `json:"properties,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeEventSubscriptionDestination', 'EndpointTypeWebHook', 'EndpointTypeEventHub', 'EndpointTypeStorageQueue', 'EndpointTypeHybridConnection', 'EndpointTypeServiceBusQueue', 'EndpointTypeServiceBusTopic', 'EndpointTypeAzureFunction'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceBusTopicEventSubscriptionDestination.
func (sbtesd ServiceBusTopicEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	sbtesd.EndpointType = EndpointTypeServiceBusTopic
	objectMap := make(map[string]interface{})
	if sbtesd.ServiceBusTopicEventSubscriptionDestinationProperties != nil {
		objectMap["properties"] = sbtesd.ServiceBusTopicEventSubscriptionDestinationProperties
	}
	if sbtesd.EndpointType != "" {
		objectMap["endpointType"] = sbtesd.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsWebHookEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusTopicEventSubscriptionDestination.
func (sbtesd ServiceBusTopicEventSubscriptionDestination) AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventHubEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusTopicEventSubscriptionDestination.
func (sbtesd ServiceBusTopicEventSubscriptionDestination) AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool) {
	return nil, false
}

// AsStorageQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusTopicEventSubscriptionDestination.
func (sbtesd ServiceBusTopicEventSubscriptionDestination) AsStorageQueueEventSubscriptionDestination() (*StorageQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsHybridConnectionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusTopicEventSubscriptionDestination.
func (sbtesd ServiceBusTopicEventSubscriptionDestination) AsHybridConnectionEventSubscriptionDestination() (*HybridConnectionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsServiceBusQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusTopicEventSubscriptionDestination.
func (sbtesd ServiceBusTopicEventSubscriptionDestination) AsServiceBusQueueEventSubscriptionDestination() (*ServiceBusQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsServiceBusTopicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusTopicEventSubscriptionDestination.
func (sbtesd ServiceBusTopicEventSubscriptionDestination) AsServiceBusTopicEventSubscriptionDestination() (*ServiceBusTopicEventSubscriptionDestination, bool) {
	return &sbtesd, true
}

// AsAzureFunctionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusTopicEventSubscriptionDestination.
func (sbtesd ServiceBusTopicEventSubscriptionDestination) AsAzureFunctionEventSubscriptionDestination() (*AzureFunctionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusTopicEventSubscriptionDestination.
func (sbtesd ServiceBusTopicEventSubscriptionDestination) AsEventSubscriptionDestination() (*EventSubscriptionDestination, bool) {
	return nil, false
}

// AsBasicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for ServiceBusTopicEventSubscriptionDestination.
func (sbtesd ServiceBusTopicEventSubscriptionDestination) AsBasicEventSubscriptionDestination() (BasicEventSubscriptionDestination, bool) {
	return &sbtesd, true
}

// UnmarshalJSON is the custom unmarshaler for ServiceBusTopicEventSubscriptionDestination struct.
func (sbtesd *ServiceBusTopicEventSubscriptionDestination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceBusTopicEventSubscriptionDestinationProperties ServiceBusTopicEventSubscriptionDestinationProperties
				err = json.Unmarshal(*v, &serviceBusTopicEventSubscriptionDestinationProperties)
				if err != nil {
					return err
				}
				sbtesd.ServiceBusTopicEventSubscriptionDestinationProperties = &serviceBusTopicEventSubscriptionDestinationProperties
			}
		case "endpointType":
			if v != nil {
				var endpointType EndpointType
				err = json.Unmarshal(*v, &endpointType)
				if err != nil {
					return err
				}
				sbtesd.EndpointType = endpointType
			}
		}
	}

	return nil
}

// ServiceBusTopicEventSubscriptionDestinationProperties the properties that represent the Service Bus
// Topic destination of an event subscription.
type ServiceBusTopicEventSubscriptionDestinationProperties struct {
	// ResourceID - The Azure Resource Id that represents the endpoint of the Service Bus Topic destination of an event subscription.
	ResourceID *string `json:"resourceId,omitempty"`
}

// StorageBlobDeadLetterDestination information about the storage blob based dead letter destination.
type StorageBlobDeadLetterDestination struct {
	// StorageBlobDeadLetterDestinationProperties - The properties of the Storage Blob based deadletter destination
	*StorageBlobDeadLetterDestinationProperties `json:"properties,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeDeadLetterDestination', 'EndpointTypeStorageBlob'
	EndpointType EndpointTypeBasicDeadLetterDestination `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageBlobDeadLetterDestination.
func (sbdld StorageBlobDeadLetterDestination) MarshalJSON() ([]byte, error) {
	sbdld.EndpointType = EndpointTypeStorageBlob
	objectMap := make(map[string]interface{})
	if sbdld.StorageBlobDeadLetterDestinationProperties != nil {
		objectMap["properties"] = sbdld.StorageBlobDeadLetterDestinationProperties
	}
	if sbdld.EndpointType != "" {
		objectMap["endpointType"] = sbdld.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsStorageBlobDeadLetterDestination is the BasicDeadLetterDestination implementation for StorageBlobDeadLetterDestination.
func (sbdld StorageBlobDeadLetterDestination) AsStorageBlobDeadLetterDestination() (*StorageBlobDeadLetterDestination, bool) {
	return &sbdld, true
}

// AsDeadLetterDestination is the BasicDeadLetterDestination implementation for StorageBlobDeadLetterDestination.
func (sbdld StorageBlobDeadLetterDestination) AsDeadLetterDestination() (*DeadLetterDestination, bool) {
	return nil, false
}

// AsBasicDeadLetterDestination is the BasicDeadLetterDestination implementation for StorageBlobDeadLetterDestination.
func (sbdld StorageBlobDeadLetterDestination) AsBasicDeadLetterDestination() (BasicDeadLetterDestination, bool) {
	return &sbdld, true
}

// UnmarshalJSON is the custom unmarshaler for StorageBlobDeadLetterDestination struct.
func (sbdld *StorageBlobDeadLetterDestination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageBlobDeadLetterDestinationProperties StorageBlobDeadLetterDestinationProperties
				err = json.Unmarshal(*v, &storageBlobDeadLetterDestinationProperties)
				if err != nil {
					return err
				}
				sbdld.StorageBlobDeadLetterDestinationProperties = &storageBlobDeadLetterDestinationProperties
			}
		case "endpointType":
			if v != nil {
				var endpointType EndpointTypeBasicDeadLetterDestination
				err = json.Unmarshal(*v, &endpointType)
				if err != nil {
					return err
				}
				sbdld.EndpointType = endpointType
			}
		}
	}

	return nil
}

// StorageBlobDeadLetterDestinationProperties properties of the storage blob based dead letter destination.
type StorageBlobDeadLetterDestinationProperties struct {
	// ResourceID - The Azure Resource ID of the storage account that is the destination of the deadletter events
	ResourceID *string `json:"resourceId,omitempty"`
	// BlobContainerName - The name of the Storage blob container that is the destination of the deadletter events
	BlobContainerName *string `json:"blobContainerName,omitempty"`
}

// StorageQueueEventSubscriptionDestination information about the storage queue destination for an event
// subscription.
type StorageQueueEventSubscriptionDestination struct {
	// StorageQueueEventSubscriptionDestinationProperties - Storage Queue Properties of the event subscription destination.
	*StorageQueueEventSubscriptionDestinationProperties `json:"properties,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeEventSubscriptionDestination', 'EndpointTypeWebHook', 'EndpointTypeEventHub', 'EndpointTypeStorageQueue', 'EndpointTypeHybridConnection', 'EndpointTypeServiceBusQueue', 'EndpointTypeServiceBusTopic', 'EndpointTypeAzureFunction'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	sqesd.EndpointType = EndpointTypeStorageQueue
	objectMap := make(map[string]interface{})
	if sqesd.StorageQueueEventSubscriptionDestinationProperties != nil {
		objectMap["properties"] = sqesd.StorageQueueEventSubscriptionDestinationProperties
	}
	if sqesd.EndpointType != "" {
		objectMap["endpointType"] = sqesd.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsWebHookEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventHubEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool) {
	return nil, false
}

// AsStorageQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) AsStorageQueueEventSubscriptionDestination() (*StorageQueueEventSubscriptionDestination, bool) {
	return &sqesd, true
}

// AsHybridConnectionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) AsHybridConnectionEventSubscriptionDestination() (*HybridConnectionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsServiceBusQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) AsServiceBusQueueEventSubscriptionDestination() (*ServiceBusQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsServiceBusTopicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) AsServiceBusTopicEventSubscriptionDestination() (*ServiceBusTopicEventSubscriptionDestination, bool) {
	return nil, false
}

// AsAzureFunctionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) AsAzureFunctionEventSubscriptionDestination() (*AzureFunctionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) AsEventSubscriptionDestination() (*EventSubscriptionDestination, bool) {
	return nil, false
}

// AsBasicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) AsBasicEventSubscriptionDestination() (BasicEventSubscriptionDestination, bool) {
	return &sqesd, true
}

// UnmarshalJSON is the custom unmarshaler for StorageQueueEventSubscriptionDestination struct.
func (sqesd *StorageQueueEventSubscriptionDestination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageQueueEventSubscriptionDestinationProperties StorageQueueEventSubscriptionDestinationProperties
				err = json.Unmarshal(*v, &storageQueueEventSubscriptionDestinationProperties)
				if err != nil {
					return err
				}
				sqesd.StorageQueueEventSubscriptionDestinationProperties = &storageQueueEventSubscriptionDestinationProperties
			}
		case "endpointType":
			if v != nil {
				var endpointType EndpointType
				err = json.Unmarshal(*v, &endpointType)
				if err != nil {
					return err
				}
				sqesd.EndpointType = endpointType
			}
		}
	}

	return nil
}

// StorageQueueEventSubscriptionDestinationProperties the properties for a storage queue destination.
type StorageQueueEventSubscriptionDestinationProperties struct {
	// ResourceID - The Azure Resource ID of the storage account that contains the queue that is the destination of an event subscription.
	ResourceID *string `json:"resourceId,omitempty"`
	// QueueName - The name of the Storage queue under a storage account that is the destination of an event subscription.
	QueueName *string `json:"queueName,omitempty"`
}

// StringBeginsWithAdvancedFilter stringBeginsWith Advanced Filter.
type StringBeginsWithAdvancedFilter struct {
	// Values - The set of filter values.
	Values *[]string `json:"values,omitempty"`
	// Key - The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
	// OperatorType - Possible values include: 'OperatorTypeAdvancedFilter', 'OperatorTypeNumberIn', 'OperatorTypeNumberNotIn', 'OperatorTypeNumberLessThan', 'OperatorTypeNumberGreaterThan', 'OperatorTypeNumberLessThanOrEquals', 'OperatorTypeNumberGreaterThanOrEquals', 'OperatorTypeBoolEquals', 'OperatorTypeStringIn', 'OperatorTypeStringNotIn', 'OperatorTypeStringBeginsWith', 'OperatorTypeStringEndsWith', 'OperatorTypeStringContains'
	OperatorType OperatorType `json:"operatorType,omitempty"`
}

// MarshalJSON is the custom marshaler for StringBeginsWithAdvancedFilter.
func (sbwaf StringBeginsWithAdvancedFilter) MarshalJSON() ([]byte, error) {
	sbwaf.OperatorType = OperatorTypeStringBeginsWith
	objectMap := make(map[string]interface{})
	if sbwaf.Values != nil {
		objectMap["values"] = sbwaf.Values
	}
	if sbwaf.Key != nil {
		objectMap["key"] = sbwaf.Key
	}
	if sbwaf.OperatorType != "" {
		objectMap["operatorType"] = sbwaf.OperatorType
	}
	return json.Marshal(objectMap)
}

// AsNumberInAdvancedFilter is the BasicAdvancedFilter implementation for StringBeginsWithAdvancedFilter.
func (sbwaf StringBeginsWithAdvancedFilter) AsNumberInAdvancedFilter() (*NumberInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberNotInAdvancedFilter is the BasicAdvancedFilter implementation for StringBeginsWithAdvancedFilter.
func (sbwaf StringBeginsWithAdvancedFilter) AsNumberNotInAdvancedFilter() (*NumberNotInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanAdvancedFilter is the BasicAdvancedFilter implementation for StringBeginsWithAdvancedFilter.
func (sbwaf StringBeginsWithAdvancedFilter) AsNumberLessThanAdvancedFilter() (*NumberLessThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanAdvancedFilter is the BasicAdvancedFilter implementation for StringBeginsWithAdvancedFilter.
func (sbwaf StringBeginsWithAdvancedFilter) AsNumberGreaterThanAdvancedFilter() (*NumberGreaterThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for StringBeginsWithAdvancedFilter.
func (sbwaf StringBeginsWithAdvancedFilter) AsNumberLessThanOrEqualsAdvancedFilter() (*NumberLessThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for StringBeginsWithAdvancedFilter.
func (sbwaf StringBeginsWithAdvancedFilter) AsNumberGreaterThanOrEqualsAdvancedFilter() (*NumberGreaterThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsBoolEqualsAdvancedFilter is the BasicAdvancedFilter implementation for StringBeginsWithAdvancedFilter.
func (sbwaf StringBeginsWithAdvancedFilter) AsBoolEqualsAdvancedFilter() (*BoolEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsStringInAdvancedFilter is the BasicAdvancedFilter implementation for StringBeginsWithAdvancedFilter.
func (sbwaf StringBeginsWithAdvancedFilter) AsStringInAdvancedFilter() (*StringInAdvancedFilter, bool) {
	return nil, false
}

// AsStringNotInAdvancedFilter is the BasicAdvancedFilter implementation for StringBeginsWithAdvancedFilter.
func (sbwaf StringBeginsWithAdvancedFilter) AsStringNotInAdvancedFilter() (*StringNotInAdvancedFilter, bool) {
	return nil, false
}

// AsStringBeginsWithAdvancedFilter is the BasicAdvancedFilter implementation for StringBeginsWithAdvancedFilter.
func (sbwaf StringBeginsWithAdvancedFilter) AsStringBeginsWithAdvancedFilter() (*StringBeginsWithAdvancedFilter, bool) {
	return &sbwaf, true
}

// AsStringEndsWithAdvancedFilter is the BasicAdvancedFilter implementation for StringBeginsWithAdvancedFilter.
func (sbwaf StringBeginsWithAdvancedFilter) AsStringEndsWithAdvancedFilter() (*StringEndsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringContainsAdvancedFilter is the BasicAdvancedFilter implementation for StringBeginsWithAdvancedFilter.
func (sbwaf StringBeginsWithAdvancedFilter) AsStringContainsAdvancedFilter() (*StringContainsAdvancedFilter, bool) {
	return nil, false
}

// AsAdvancedFilter is the BasicAdvancedFilter implementation for StringBeginsWithAdvancedFilter.
func (sbwaf StringBeginsWithAdvancedFilter) AsAdvancedFilter() (*AdvancedFilter, bool) {
	return nil, false
}

// AsBasicAdvancedFilter is the BasicAdvancedFilter implementation for StringBeginsWithAdvancedFilter.
func (sbwaf StringBeginsWithAdvancedFilter) AsBasicAdvancedFilter() (BasicAdvancedFilter, bool) {
	return &sbwaf, true
}

// StringContainsAdvancedFilter stringContains Advanced Filter.
type StringContainsAdvancedFilter struct {
	// Values - The set of filter values.
	Values *[]string `json:"values,omitempty"`
	// Key - The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
	// OperatorType - Possible values include: 'OperatorTypeAdvancedFilter', 'OperatorTypeNumberIn', 'OperatorTypeNumberNotIn', 'OperatorTypeNumberLessThan', 'OperatorTypeNumberGreaterThan', 'OperatorTypeNumberLessThanOrEquals', 'OperatorTypeNumberGreaterThanOrEquals', 'OperatorTypeBoolEquals', 'OperatorTypeStringIn', 'OperatorTypeStringNotIn', 'OperatorTypeStringBeginsWith', 'OperatorTypeStringEndsWith', 'OperatorTypeStringContains'
	OperatorType OperatorType `json:"operatorType,omitempty"`
}

// MarshalJSON is the custom marshaler for StringContainsAdvancedFilter.
func (scaf StringContainsAdvancedFilter) MarshalJSON() ([]byte, error) {
	scaf.OperatorType = OperatorTypeStringContains
	objectMap := make(map[string]interface{})
	if scaf.Values != nil {
		objectMap["values"] = scaf.Values
	}
	if scaf.Key != nil {
		objectMap["key"] = scaf.Key
	}
	if scaf.OperatorType != "" {
		objectMap["operatorType"] = scaf.OperatorType
	}
	return json.Marshal(objectMap)
}

// AsNumberInAdvancedFilter is the BasicAdvancedFilter implementation for StringContainsAdvancedFilter.
func (scaf StringContainsAdvancedFilter) AsNumberInAdvancedFilter() (*NumberInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberNotInAdvancedFilter is the BasicAdvancedFilter implementation for StringContainsAdvancedFilter.
func (scaf StringContainsAdvancedFilter) AsNumberNotInAdvancedFilter() (*NumberNotInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanAdvancedFilter is the BasicAdvancedFilter implementation for StringContainsAdvancedFilter.
func (scaf StringContainsAdvancedFilter) AsNumberLessThanAdvancedFilter() (*NumberLessThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanAdvancedFilter is the BasicAdvancedFilter implementation for StringContainsAdvancedFilter.
func (scaf StringContainsAdvancedFilter) AsNumberGreaterThanAdvancedFilter() (*NumberGreaterThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for StringContainsAdvancedFilter.
func (scaf StringContainsAdvancedFilter) AsNumberLessThanOrEqualsAdvancedFilter() (*NumberLessThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for StringContainsAdvancedFilter.
func (scaf StringContainsAdvancedFilter) AsNumberGreaterThanOrEqualsAdvancedFilter() (*NumberGreaterThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsBoolEqualsAdvancedFilter is the BasicAdvancedFilter implementation for StringContainsAdvancedFilter.
func (scaf StringContainsAdvancedFilter) AsBoolEqualsAdvancedFilter() (*BoolEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsStringInAdvancedFilter is the BasicAdvancedFilter implementation for StringContainsAdvancedFilter.
func (scaf StringContainsAdvancedFilter) AsStringInAdvancedFilter() (*StringInAdvancedFilter, bool) {
	return nil, false
}

// AsStringNotInAdvancedFilter is the BasicAdvancedFilter implementation for StringContainsAdvancedFilter.
func (scaf StringContainsAdvancedFilter) AsStringNotInAdvancedFilter() (*StringNotInAdvancedFilter, bool) {
	return nil, false
}

// AsStringBeginsWithAdvancedFilter is the BasicAdvancedFilter implementation for StringContainsAdvancedFilter.
func (scaf StringContainsAdvancedFilter) AsStringBeginsWithAdvancedFilter() (*StringBeginsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringEndsWithAdvancedFilter is the BasicAdvancedFilter implementation for StringContainsAdvancedFilter.
func (scaf StringContainsAdvancedFilter) AsStringEndsWithAdvancedFilter() (*StringEndsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringContainsAdvancedFilter is the BasicAdvancedFilter implementation for StringContainsAdvancedFilter.
func (scaf StringContainsAdvancedFilter) AsStringContainsAdvancedFilter() (*StringContainsAdvancedFilter, bool) {
	return &scaf, true
}

// AsAdvancedFilter is the BasicAdvancedFilter implementation for StringContainsAdvancedFilter.
func (scaf StringContainsAdvancedFilter) AsAdvancedFilter() (*AdvancedFilter, bool) {
	return nil, false
}

// AsBasicAdvancedFilter is the BasicAdvancedFilter implementation for StringContainsAdvancedFilter.
func (scaf StringContainsAdvancedFilter) AsBasicAdvancedFilter() (BasicAdvancedFilter, bool) {
	return &scaf, true
}

// StringEndsWithAdvancedFilter stringEndsWith Advanced Filter.
type StringEndsWithAdvancedFilter struct {
	// Values - The set of filter values.
	Values *[]string `json:"values,omitempty"`
	// Key - The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
	// OperatorType - Possible values include: 'OperatorTypeAdvancedFilter', 'OperatorTypeNumberIn', 'OperatorTypeNumberNotIn', 'OperatorTypeNumberLessThan', 'OperatorTypeNumberGreaterThan', 'OperatorTypeNumberLessThanOrEquals', 'OperatorTypeNumberGreaterThanOrEquals', 'OperatorTypeBoolEquals', 'OperatorTypeStringIn', 'OperatorTypeStringNotIn', 'OperatorTypeStringBeginsWith', 'OperatorTypeStringEndsWith', 'OperatorTypeStringContains'
	OperatorType OperatorType `json:"operatorType,omitempty"`
}

// MarshalJSON is the custom marshaler for StringEndsWithAdvancedFilter.
func (sewaf StringEndsWithAdvancedFilter) MarshalJSON() ([]byte, error) {
	sewaf.OperatorType = OperatorTypeStringEndsWith
	objectMap := make(map[string]interface{})
	if sewaf.Values != nil {
		objectMap["values"] = sewaf.Values
	}
	if sewaf.Key != nil {
		objectMap["key"] = sewaf.Key
	}
	if sewaf.OperatorType != "" {
		objectMap["operatorType"] = sewaf.OperatorType
	}
	return json.Marshal(objectMap)
}

// AsNumberInAdvancedFilter is the BasicAdvancedFilter implementation for StringEndsWithAdvancedFilter.
func (sewaf StringEndsWithAdvancedFilter) AsNumberInAdvancedFilter() (*NumberInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberNotInAdvancedFilter is the BasicAdvancedFilter implementation for StringEndsWithAdvancedFilter.
func (sewaf StringEndsWithAdvancedFilter) AsNumberNotInAdvancedFilter() (*NumberNotInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanAdvancedFilter is the BasicAdvancedFilter implementation for StringEndsWithAdvancedFilter.
func (sewaf StringEndsWithAdvancedFilter) AsNumberLessThanAdvancedFilter() (*NumberLessThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanAdvancedFilter is the BasicAdvancedFilter implementation for StringEndsWithAdvancedFilter.
func (sewaf StringEndsWithAdvancedFilter) AsNumberGreaterThanAdvancedFilter() (*NumberGreaterThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for StringEndsWithAdvancedFilter.
func (sewaf StringEndsWithAdvancedFilter) AsNumberLessThanOrEqualsAdvancedFilter() (*NumberLessThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for StringEndsWithAdvancedFilter.
func (sewaf StringEndsWithAdvancedFilter) AsNumberGreaterThanOrEqualsAdvancedFilter() (*NumberGreaterThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsBoolEqualsAdvancedFilter is the BasicAdvancedFilter implementation for StringEndsWithAdvancedFilter.
func (sewaf StringEndsWithAdvancedFilter) AsBoolEqualsAdvancedFilter() (*BoolEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsStringInAdvancedFilter is the BasicAdvancedFilter implementation for StringEndsWithAdvancedFilter.
func (sewaf StringEndsWithAdvancedFilter) AsStringInAdvancedFilter() (*StringInAdvancedFilter, bool) {
	return nil, false
}

// AsStringNotInAdvancedFilter is the BasicAdvancedFilter implementation for StringEndsWithAdvancedFilter.
func (sewaf StringEndsWithAdvancedFilter) AsStringNotInAdvancedFilter() (*StringNotInAdvancedFilter, bool) {
	return nil, false
}

// AsStringBeginsWithAdvancedFilter is the BasicAdvancedFilter implementation for StringEndsWithAdvancedFilter.
func (sewaf StringEndsWithAdvancedFilter) AsStringBeginsWithAdvancedFilter() (*StringBeginsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringEndsWithAdvancedFilter is the BasicAdvancedFilter implementation for StringEndsWithAdvancedFilter.
func (sewaf StringEndsWithAdvancedFilter) AsStringEndsWithAdvancedFilter() (*StringEndsWithAdvancedFilter, bool) {
	return &sewaf, true
}

// AsStringContainsAdvancedFilter is the BasicAdvancedFilter implementation for StringEndsWithAdvancedFilter.
func (sewaf StringEndsWithAdvancedFilter) AsStringContainsAdvancedFilter() (*StringContainsAdvancedFilter, bool) {
	return nil, false
}

// AsAdvancedFilter is the BasicAdvancedFilter implementation for StringEndsWithAdvancedFilter.
func (sewaf StringEndsWithAdvancedFilter) AsAdvancedFilter() (*AdvancedFilter, bool) {
	return nil, false
}

// AsBasicAdvancedFilter is the BasicAdvancedFilter implementation for StringEndsWithAdvancedFilter.
func (sewaf StringEndsWithAdvancedFilter) AsBasicAdvancedFilter() (BasicAdvancedFilter, bool) {
	return &sewaf, true
}

// StringInAdvancedFilter stringIn Advanced Filter.
type StringInAdvancedFilter struct {
	// Values - The set of filter values.
	Values *[]string `json:"values,omitempty"`
	// Key - The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
	// OperatorType - Possible values include: 'OperatorTypeAdvancedFilter', 'OperatorTypeNumberIn', 'OperatorTypeNumberNotIn', 'OperatorTypeNumberLessThan', 'OperatorTypeNumberGreaterThan', 'OperatorTypeNumberLessThanOrEquals', 'OperatorTypeNumberGreaterThanOrEquals', 'OperatorTypeBoolEquals', 'OperatorTypeStringIn', 'OperatorTypeStringNotIn', 'OperatorTypeStringBeginsWith', 'OperatorTypeStringEndsWith', 'OperatorTypeStringContains'
	OperatorType OperatorType `json:"operatorType,omitempty"`
}

// MarshalJSON is the custom marshaler for StringInAdvancedFilter.
func (siaf StringInAdvancedFilter) MarshalJSON() ([]byte, error) {
	siaf.OperatorType = OperatorTypeStringIn
	objectMap := make(map[string]interface{})
	if siaf.Values != nil {
		objectMap["values"] = siaf.Values
	}
	if siaf.Key != nil {
		objectMap["key"] = siaf.Key
	}
	if siaf.OperatorType != "" {
		objectMap["operatorType"] = siaf.OperatorType
	}
	return json.Marshal(objectMap)
}

// AsNumberInAdvancedFilter is the BasicAdvancedFilter implementation for StringInAdvancedFilter.
func (siaf StringInAdvancedFilter) AsNumberInAdvancedFilter() (*NumberInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberNotInAdvancedFilter is the BasicAdvancedFilter implementation for StringInAdvancedFilter.
func (siaf StringInAdvancedFilter) AsNumberNotInAdvancedFilter() (*NumberNotInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanAdvancedFilter is the BasicAdvancedFilter implementation for StringInAdvancedFilter.
func (siaf StringInAdvancedFilter) AsNumberLessThanAdvancedFilter() (*NumberLessThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanAdvancedFilter is the BasicAdvancedFilter implementation for StringInAdvancedFilter.
func (siaf StringInAdvancedFilter) AsNumberGreaterThanAdvancedFilter() (*NumberGreaterThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for StringInAdvancedFilter.
func (siaf StringInAdvancedFilter) AsNumberLessThanOrEqualsAdvancedFilter() (*NumberLessThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for StringInAdvancedFilter.
func (siaf StringInAdvancedFilter) AsNumberGreaterThanOrEqualsAdvancedFilter() (*NumberGreaterThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsBoolEqualsAdvancedFilter is the BasicAdvancedFilter implementation for StringInAdvancedFilter.
func (siaf StringInAdvancedFilter) AsBoolEqualsAdvancedFilter() (*BoolEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsStringInAdvancedFilter is the BasicAdvancedFilter implementation for StringInAdvancedFilter.
func (siaf StringInAdvancedFilter) AsStringInAdvancedFilter() (*StringInAdvancedFilter, bool) {
	return &siaf, true
}

// AsStringNotInAdvancedFilter is the BasicAdvancedFilter implementation for StringInAdvancedFilter.
func (siaf StringInAdvancedFilter) AsStringNotInAdvancedFilter() (*StringNotInAdvancedFilter, bool) {
	return nil, false
}

// AsStringBeginsWithAdvancedFilter is the BasicAdvancedFilter implementation for StringInAdvancedFilter.
func (siaf StringInAdvancedFilter) AsStringBeginsWithAdvancedFilter() (*StringBeginsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringEndsWithAdvancedFilter is the BasicAdvancedFilter implementation for StringInAdvancedFilter.
func (siaf StringInAdvancedFilter) AsStringEndsWithAdvancedFilter() (*StringEndsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringContainsAdvancedFilter is the BasicAdvancedFilter implementation for StringInAdvancedFilter.
func (siaf StringInAdvancedFilter) AsStringContainsAdvancedFilter() (*StringContainsAdvancedFilter, bool) {
	return nil, false
}

// AsAdvancedFilter is the BasicAdvancedFilter implementation for StringInAdvancedFilter.
func (siaf StringInAdvancedFilter) AsAdvancedFilter() (*AdvancedFilter, bool) {
	return nil, false
}

// AsBasicAdvancedFilter is the BasicAdvancedFilter implementation for StringInAdvancedFilter.
func (siaf StringInAdvancedFilter) AsBasicAdvancedFilter() (BasicAdvancedFilter, bool) {
	return &siaf, true
}

// StringNotInAdvancedFilter stringNotIn Advanced Filter.
type StringNotInAdvancedFilter struct {
	// Values - The set of filter values.
	Values *[]string `json:"values,omitempty"`
	// Key - The field/property in the event based on which you want to filter.
	Key *string `json:"key,omitempty"`
	// OperatorType - Possible values include: 'OperatorTypeAdvancedFilter', 'OperatorTypeNumberIn', 'OperatorTypeNumberNotIn', 'OperatorTypeNumberLessThan', 'OperatorTypeNumberGreaterThan', 'OperatorTypeNumberLessThanOrEquals', 'OperatorTypeNumberGreaterThanOrEquals', 'OperatorTypeBoolEquals', 'OperatorTypeStringIn', 'OperatorTypeStringNotIn', 'OperatorTypeStringBeginsWith', 'OperatorTypeStringEndsWith', 'OperatorTypeStringContains'
	OperatorType OperatorType `json:"operatorType,omitempty"`
}

// MarshalJSON is the custom marshaler for StringNotInAdvancedFilter.
func (sniaf StringNotInAdvancedFilter) MarshalJSON() ([]byte, error) {
	sniaf.OperatorType = OperatorTypeStringNotIn
	objectMap := make(map[string]interface{})
	if sniaf.Values != nil {
		objectMap["values"] = sniaf.Values
	}
	if sniaf.Key != nil {
		objectMap["key"] = sniaf.Key
	}
	if sniaf.OperatorType != "" {
		objectMap["operatorType"] = sniaf.OperatorType
	}
	return json.Marshal(objectMap)
}

// AsNumberInAdvancedFilter is the BasicAdvancedFilter implementation for StringNotInAdvancedFilter.
func (sniaf StringNotInAdvancedFilter) AsNumberInAdvancedFilter() (*NumberInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberNotInAdvancedFilter is the BasicAdvancedFilter implementation for StringNotInAdvancedFilter.
func (sniaf StringNotInAdvancedFilter) AsNumberNotInAdvancedFilter() (*NumberNotInAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanAdvancedFilter is the BasicAdvancedFilter implementation for StringNotInAdvancedFilter.
func (sniaf StringNotInAdvancedFilter) AsNumberLessThanAdvancedFilter() (*NumberLessThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanAdvancedFilter is the BasicAdvancedFilter implementation for StringNotInAdvancedFilter.
func (sniaf StringNotInAdvancedFilter) AsNumberGreaterThanAdvancedFilter() (*NumberGreaterThanAdvancedFilter, bool) {
	return nil, false
}

// AsNumberLessThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for StringNotInAdvancedFilter.
func (sniaf StringNotInAdvancedFilter) AsNumberLessThanOrEqualsAdvancedFilter() (*NumberLessThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsNumberGreaterThanOrEqualsAdvancedFilter is the BasicAdvancedFilter implementation for StringNotInAdvancedFilter.
func (sniaf StringNotInAdvancedFilter) AsNumberGreaterThanOrEqualsAdvancedFilter() (*NumberGreaterThanOrEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsBoolEqualsAdvancedFilter is the BasicAdvancedFilter implementation for StringNotInAdvancedFilter.
func (sniaf StringNotInAdvancedFilter) AsBoolEqualsAdvancedFilter() (*BoolEqualsAdvancedFilter, bool) {
	return nil, false
}

// AsStringInAdvancedFilter is the BasicAdvancedFilter implementation for StringNotInAdvancedFilter.
func (sniaf StringNotInAdvancedFilter) AsStringInAdvancedFilter() (*StringInAdvancedFilter, bool) {
	return nil, false
}

// AsStringNotInAdvancedFilter is the BasicAdvancedFilter implementation for StringNotInAdvancedFilter.
func (sniaf StringNotInAdvancedFilter) AsStringNotInAdvancedFilter() (*StringNotInAdvancedFilter, bool) {
	return &sniaf, true
}

// AsStringBeginsWithAdvancedFilter is the BasicAdvancedFilter implementation for StringNotInAdvancedFilter.
func (sniaf StringNotInAdvancedFilter) AsStringBeginsWithAdvancedFilter() (*StringBeginsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringEndsWithAdvancedFilter is the BasicAdvancedFilter implementation for StringNotInAdvancedFilter.
func (sniaf StringNotInAdvancedFilter) AsStringEndsWithAdvancedFilter() (*StringEndsWithAdvancedFilter, bool) {
	return nil, false
}

// AsStringContainsAdvancedFilter is the BasicAdvancedFilter implementation for StringNotInAdvancedFilter.
func (sniaf StringNotInAdvancedFilter) AsStringContainsAdvancedFilter() (*StringContainsAdvancedFilter, bool) {
	return nil, false
}

// AsAdvancedFilter is the BasicAdvancedFilter implementation for StringNotInAdvancedFilter.
func (sniaf StringNotInAdvancedFilter) AsAdvancedFilter() (*AdvancedFilter, bool) {
	return nil, false
}

// AsBasicAdvancedFilter is the BasicAdvancedFilter implementation for StringNotInAdvancedFilter.
func (sniaf StringNotInAdvancedFilter) AsBasicAdvancedFilter() (BasicAdvancedFilter, bool) {
	return &sniaf, true
}

// SystemTopic eventGrid System Topic.
type SystemTopic struct {
	autorest.Response `json:"-"`
	// SystemTopicProperties - Properties of the system topic.
	*SystemTopicProperties `json:"properties,omitempty"`
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the resource.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SystemTopic.
func (st SystemTopic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if st.SystemTopicProperties != nil {
		objectMap["properties"] = st.SystemTopicProperties
	}
	if st.Location != nil {
		objectMap["location"] = st.Location
	}
	if st.Tags != nil {
		objectMap["tags"] = st.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SystemTopic struct.
func (st *SystemTopic) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var systemTopicProperties SystemTopicProperties
				err = json.Unmarshal(*v, &systemTopicProperties)
				if err != nil {
					return err
				}
				st.SystemTopicProperties = &systemTopicProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				st.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				st.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				st.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				st.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				st.Type = &typeVar
			}
		}
	}

	return nil
}

// SystemTopicEventSubscriptionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type SystemTopicEventSubscriptionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SystemTopicEventSubscriptionsClient) (EventSubscription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SystemTopicEventSubscriptionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SystemTopicEventSubscriptionsCreateOrUpdateFuture.Result.
func (future *SystemTopicEventSubscriptionsCreateOrUpdateFuture) result(client SystemTopicEventSubscriptionsClient) (es EventSubscription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.SystemTopicEventSubscriptionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		es.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.SystemTopicEventSubscriptionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if es.Response.Response, err = future.GetResult(sender); err == nil && es.Response.Response.StatusCode != http.StatusNoContent {
		es, err = client.CreateOrUpdateResponder(es.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.SystemTopicEventSubscriptionsCreateOrUpdateFuture", "Result", es.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SystemTopicEventSubscriptionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SystemTopicEventSubscriptionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SystemTopicEventSubscriptionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SystemTopicEventSubscriptionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SystemTopicEventSubscriptionsDeleteFuture.Result.
func (future *SystemTopicEventSubscriptionsDeleteFuture) result(client SystemTopicEventSubscriptionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.SystemTopicEventSubscriptionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.SystemTopicEventSubscriptionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SystemTopicEventSubscriptionsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SystemTopicEventSubscriptionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SystemTopicEventSubscriptionsClient) (EventSubscription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SystemTopicEventSubscriptionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SystemTopicEventSubscriptionsUpdateFuture.Result.
func (future *SystemTopicEventSubscriptionsUpdateFuture) result(client SystemTopicEventSubscriptionsClient) (es EventSubscription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.SystemTopicEventSubscriptionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		es.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.SystemTopicEventSubscriptionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if es.Response.Response, err = future.GetResult(sender); err == nil && es.Response.Response.StatusCode != http.StatusNoContent {
		es, err = client.UpdateResponder(es.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.SystemTopicEventSubscriptionsUpdateFuture", "Result", es.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SystemTopicProperties properties of the System Topic.
type SystemTopicProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the system topic. Possible values include: 'ResourceProvisioningStateCreating', 'ResourceProvisioningStateUpdating', 'ResourceProvisioningStateDeleting', 'ResourceProvisioningStateSucceeded', 'ResourceProvisioningStateCanceled', 'ResourceProvisioningStateFailed'
	ProvisioningState ResourceProvisioningState `json:"provisioningState,omitempty"`
	// Source - Source for the system topic.
	Source *string `json:"source,omitempty"`
	// TopicType - TopicType for the system topic.
	TopicType *string `json:"topicType,omitempty"`
	// MetricResourceID - READ-ONLY; Metric resource id for the system topic.
	MetricResourceID *string `json:"metricResourceId,omitempty"`
}

// MarshalJSON is the custom marshaler for SystemTopicProperties.
func (stp SystemTopicProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if stp.Source != nil {
		objectMap["source"] = stp.Source
	}
	if stp.TopicType != nil {
		objectMap["topicType"] = stp.TopicType
	}
	return json.Marshal(objectMap)
}

// SystemTopicsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SystemTopicsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SystemTopicsClient) (SystemTopic, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SystemTopicsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SystemTopicsCreateOrUpdateFuture.Result.
func (future *SystemTopicsCreateOrUpdateFuture) result(client SystemTopicsClient) (st SystemTopic, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.SystemTopicsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		st.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.SystemTopicsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if st.Response.Response, err = future.GetResult(sender); err == nil && st.Response.Response.StatusCode != http.StatusNoContent {
		st, err = client.CreateOrUpdateResponder(st.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.SystemTopicsCreateOrUpdateFuture", "Result", st.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SystemTopicsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SystemTopicsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SystemTopicsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SystemTopicsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SystemTopicsDeleteFuture.Result.
func (future *SystemTopicsDeleteFuture) result(client SystemTopicsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.SystemTopicsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.SystemTopicsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SystemTopicsListResult result of the List System topics operation.
type SystemTopicsListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of system Topics.
	Value *[]SystemTopic `json:"value,omitempty"`
	// NextLink - A link for the next page of topics.
	NextLink *string `json:"nextLink,omitempty"`
}

// SystemTopicsListResultIterator provides access to a complete listing of SystemTopic values.
type SystemTopicsListResultIterator struct {
	i    int
	page SystemTopicsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SystemTopicsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SystemTopicsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SystemTopicsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SystemTopicsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SystemTopicsListResultIterator) Response() SystemTopicsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SystemTopicsListResultIterator) Value() SystemTopic {
	if !iter.page.NotDone() {
		return SystemTopic{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SystemTopicsListResultIterator type.
func NewSystemTopicsListResultIterator(page SystemTopicsListResultPage) SystemTopicsListResultIterator {
	return SystemTopicsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (stlr SystemTopicsListResult) IsEmpty() bool {
	return stlr.Value == nil || len(*stlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (stlr SystemTopicsListResult) hasNextLink() bool {
	return stlr.NextLink != nil && len(*stlr.NextLink) != 0
}

// systemTopicsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (stlr SystemTopicsListResult) systemTopicsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !stlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(stlr.NextLink)))
}

// SystemTopicsListResultPage contains a page of SystemTopic values.
type SystemTopicsListResultPage struct {
	fn   func(context.Context, SystemTopicsListResult) (SystemTopicsListResult, error)
	stlr SystemTopicsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SystemTopicsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SystemTopicsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.stlr)
		if err != nil {
			return err
		}
		page.stlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SystemTopicsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SystemTopicsListResultPage) NotDone() bool {
	return !page.stlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SystemTopicsListResultPage) Response() SystemTopicsListResult {
	return page.stlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SystemTopicsListResultPage) Values() []SystemTopic {
	if page.stlr.IsEmpty() {
		return nil
	}
	return *page.stlr.Value
}

// Creates a new instance of the SystemTopicsListResultPage type.
func NewSystemTopicsListResultPage(cur SystemTopicsListResult, getNextPage func(context.Context, SystemTopicsListResult) (SystemTopicsListResult, error)) SystemTopicsListResultPage {
	return SystemTopicsListResultPage{
		fn:   getNextPage,
		stlr: cur,
	}
}

// SystemTopicsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SystemTopicsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SystemTopicsClient) (SystemTopic, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SystemTopicsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SystemTopicsUpdateFuture.Result.
func (future *SystemTopicsUpdateFuture) result(client SystemTopicsClient) (st SystemTopic, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.SystemTopicsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		st.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.SystemTopicsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if st.Response.Response, err = future.GetResult(sender); err == nil && st.Response.Response.StatusCode != http.StatusNoContent {
		st, err = client.UpdateResponder(st.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.SystemTopicsUpdateFuture", "Result", st.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SystemTopicUpdateParameters properties of the System Topic update.
type SystemTopicUpdateParameters struct {
	// Tags - Tags of the system topic.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SystemTopicUpdateParameters.
func (stup SystemTopicUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if stup.Tags != nil {
		objectMap["tags"] = stup.Tags
	}
	return json.Marshal(objectMap)
}

// Topic eventGrid Topic
type Topic struct {
	autorest.Response `json:"-"`
	// TopicProperties - Properties of the topic.
	*TopicProperties `json:"properties,omitempty"`
	// Sku - The Sku pricing tier for the topic.
	Sku *ResourceSku `json:"sku,omitempty"`
	// Identity - Identity information for the resource.
	Identity *IdentityInfo `json:"identity,omitempty"`
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the resource.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Topic.
func (t Topic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.TopicProperties != nil {
		objectMap["properties"] = t.TopicProperties
	}
	if t.Sku != nil {
		objectMap["sku"] = t.Sku
	}
	if t.Identity != nil {
		objectMap["identity"] = t.Identity
	}
	if t.Location != nil {
		objectMap["location"] = t.Location
	}
	if t.Tags != nil {
		objectMap["tags"] = t.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Topic struct.
func (t *Topic) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var topicProperties TopicProperties
				err = json.Unmarshal(*v, &topicProperties)
				if err != nil {
					return err
				}
				t.TopicProperties = &topicProperties
			}
		case "sku":
			if v != nil {
				var sku ResourceSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				t.Sku = &sku
			}
		case "identity":
			if v != nil {
				var identity IdentityInfo
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				t.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				t.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				t.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		}
	}

	return nil
}

// TopicProperties properties of the Topic
type TopicProperties struct {
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the topic. Possible values include: 'TopicProvisioningStateCreating', 'TopicProvisioningStateUpdating', 'TopicProvisioningStateDeleting', 'TopicProvisioningStateSucceeded', 'TopicProvisioningStateCanceled', 'TopicProvisioningStateFailed'
	ProvisioningState TopicProvisioningState `json:"provisioningState,omitempty"`
	// Endpoint - READ-ONLY; Endpoint for the topic.
	Endpoint *string `json:"endpoint,omitempty"`
	// InputSchema - This determines the format that Event Grid should expect for incoming events published to the topic. Possible values include: 'InputSchemaEventGridSchema', 'InputSchemaCustomEventSchema', 'InputSchemaCloudEventSchemaV10'
	InputSchema InputSchema `json:"inputSchema,omitempty"`
	// InputSchemaMapping - This enables publishing using custom event schemas. An InputSchemaMapping can be specified to map various properties of a source schema to various required properties of the EventGridEvent schema.
	InputSchemaMapping BasicInputSchemaMapping `json:"inputSchemaMapping,omitempty"`
	// MetricResourceID - READ-ONLY; Metric resource id for the topic.
	MetricResourceID *string `json:"metricResourceId,omitempty"`
	// PublicNetworkAccess - This determines if traffic is allowed over public network. By default it is enabled.
	// You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules" />. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// InboundIPRules - This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
	InboundIPRules *[]InboundIPRule `json:"inboundIpRules,omitempty"`
}

// MarshalJSON is the custom marshaler for TopicProperties.
func (tp TopicProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.PrivateEndpointConnections != nil {
		objectMap["privateEndpointConnections"] = tp.PrivateEndpointConnections
	}
	if tp.InputSchema != "" {
		objectMap["inputSchema"] = tp.InputSchema
	}
	objectMap["inputSchemaMapping"] = tp.InputSchemaMapping
	if tp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = tp.PublicNetworkAccess
	}
	if tp.InboundIPRules != nil {
		objectMap["inboundIpRules"] = tp.InboundIPRules
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TopicProperties struct.
func (tp *TopicProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "privateEndpointConnections":
			if v != nil {
				var privateEndpointConnections []PrivateEndpointConnection
				err = json.Unmarshal(*v, &privateEndpointConnections)
				if err != nil {
					return err
				}
				tp.PrivateEndpointConnections = &privateEndpointConnections
			}
		case "provisioningState":
			if v != nil {
				var provisioningState TopicProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				tp.ProvisioningState = provisioningState
			}
		case "endpoint":
			if v != nil {
				var endpoint string
				err = json.Unmarshal(*v, &endpoint)
				if err != nil {
					return err
				}
				tp.Endpoint = &endpoint
			}
		case "inputSchema":
			if v != nil {
				var inputSchema InputSchema
				err = json.Unmarshal(*v, &inputSchema)
				if err != nil {
					return err
				}
				tp.InputSchema = inputSchema
			}
		case "inputSchemaMapping":
			if v != nil {
				inputSchemaMapping, err := unmarshalBasicInputSchemaMapping(*v)
				if err != nil {
					return err
				}
				tp.InputSchemaMapping = inputSchemaMapping
			}
		case "metricResourceId":
			if v != nil {
				var metricResourceID string
				err = json.Unmarshal(*v, &metricResourceID)
				if err != nil {
					return err
				}
				tp.MetricResourceID = &metricResourceID
			}
		case "publicNetworkAccess":
			if v != nil {
				var publicNetworkAccess PublicNetworkAccess
				err = json.Unmarshal(*v, &publicNetworkAccess)
				if err != nil {
					return err
				}
				tp.PublicNetworkAccess = publicNetworkAccess
			}
		case "inboundIpRules":
			if v != nil {
				var inboundIPRules []InboundIPRule
				err = json.Unmarshal(*v, &inboundIPRules)
				if err != nil {
					return err
				}
				tp.InboundIPRules = &inboundIPRules
			}
		}
	}

	return nil
}

// TopicRegenerateKeyRequest topic regenerate share access key request
type TopicRegenerateKeyRequest struct {
	// KeyName - Key name to regenerate key1 or key2
	KeyName *string `json:"keyName,omitempty"`
}

// TopicsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TopicsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TopicsClient) (Topic, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TopicsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TopicsCreateOrUpdateFuture.Result.
func (future *TopicsCreateOrUpdateFuture) result(client TopicsClient) (t Topic, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.TopicsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		t.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.TopicsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.CreateOrUpdateResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.TopicsCreateOrUpdateFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TopicsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type TopicsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TopicsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TopicsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TopicsDeleteFuture.Result.
func (future *TopicsDeleteFuture) result(client TopicsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.TopicsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.TopicsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// TopicSharedAccessKeys shared access keys of the Topic
type TopicSharedAccessKeys struct {
	autorest.Response `json:"-"`
	// Key1 - Shared access key1 for the topic.
	Key1 *string `json:"key1,omitempty"`
	// Key2 - Shared access key2 for the topic.
	Key2 *string `json:"key2,omitempty"`
}

// TopicsListResult result of the List Topics operation
type TopicsListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of Topics
	Value *[]Topic `json:"value,omitempty"`
	// NextLink - A link for the next page of topics
	NextLink *string `json:"nextLink,omitempty"`
}

// TopicsListResultIterator provides access to a complete listing of Topic values.
type TopicsListResultIterator struct {
	i    int
	page TopicsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TopicsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopicsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TopicsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TopicsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TopicsListResultIterator) Response() TopicsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TopicsListResultIterator) Value() Topic {
	if !iter.page.NotDone() {
		return Topic{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TopicsListResultIterator type.
func NewTopicsListResultIterator(page TopicsListResultPage) TopicsListResultIterator {
	return TopicsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tlr TopicsListResult) IsEmpty() bool {
	return tlr.Value == nil || len(*tlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tlr TopicsListResult) hasNextLink() bool {
	return tlr.NextLink != nil && len(*tlr.NextLink) != 0
}

// topicsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tlr TopicsListResult) topicsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !tlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tlr.NextLink)))
}

// TopicsListResultPage contains a page of Topic values.
type TopicsListResultPage struct {
	fn  func(context.Context, TopicsListResult) (TopicsListResult, error)
	tlr TopicsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TopicsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopicsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tlr)
		if err != nil {
			return err
		}
		page.tlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TopicsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TopicsListResultPage) NotDone() bool {
	return !page.tlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TopicsListResultPage) Response() TopicsListResult {
	return page.tlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TopicsListResultPage) Values() []Topic {
	if page.tlr.IsEmpty() {
		return nil
	}
	return *page.tlr.Value
}

// Creates a new instance of the TopicsListResultPage type.
func NewTopicsListResultPage(cur TopicsListResult, getNextPage func(context.Context, TopicsListResult) (TopicsListResult, error)) TopicsListResultPage {
	return TopicsListResultPage{
		fn:  getNextPage,
		tlr: cur,
	}
}

// TopicsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type TopicsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TopicsClient) (Topic, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TopicsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TopicsUpdateFuture.Result.
func (future *TopicsUpdateFuture) result(client TopicsClient) (t Topic, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.TopicsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		t.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("eventgrid.TopicsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.UpdateResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.TopicsUpdateFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TopicTypeInfo properties of a topic type info.
type TopicTypeInfo struct {
	autorest.Response `json:"-"`
	// TopicTypeProperties - Properties of the topic type info
	*TopicTypeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TopicTypeInfo.
func (tti TopicTypeInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tti.TopicTypeProperties != nil {
		objectMap["properties"] = tti.TopicTypeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TopicTypeInfo struct.
func (tti *TopicTypeInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var topicTypeProperties TopicTypeProperties
				err = json.Unmarshal(*v, &topicTypeProperties)
				if err != nil {
					return err
				}
				tti.TopicTypeProperties = &topicTypeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tti.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tti.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tti.Type = &typeVar
			}
		}
	}

	return nil
}

// TopicTypeProperties properties of a topic type.
type TopicTypeProperties struct {
	// Provider - Namespace of the provider of the topic type.
	Provider *string `json:"provider,omitempty"`
	// DisplayName - Display Name for the topic type.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Description of the topic type.
	Description *string `json:"description,omitempty"`
	// ResourceRegionType - Region type of the resource. Possible values include: 'RegionalResource', 'GlobalResource'
	ResourceRegionType ResourceRegionType `json:"resourceRegionType,omitempty"`
	// ProvisioningState - Provisioning state of the topic type. Possible values include: 'TopicTypeProvisioningStateCreating', 'TopicTypeProvisioningStateUpdating', 'TopicTypeProvisioningStateDeleting', 'TopicTypeProvisioningStateSucceeded', 'TopicTypeProvisioningStateCanceled', 'TopicTypeProvisioningStateFailed'
	ProvisioningState TopicTypeProvisioningState `json:"provisioningState,omitempty"`
	// SupportedLocations - List of locations supported by this topic type.
	SupportedLocations *[]string `json:"supportedLocations,omitempty"`
	// SourceResourceFormat - Source resource format.
	SourceResourceFormat *string `json:"sourceResourceFormat,omitempty"`
}

// TopicTypesListResult result of the List Topic Types operation
type TopicTypesListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of topic types
	Value *[]TopicTypeInfo `json:"value,omitempty"`
}

// TopicUpdateParameterProperties information of topic update parameter properties.
type TopicUpdateParameterProperties struct {
	// PublicNetworkAccess - This determines if traffic is allowed over public network. By default it is enabled.
	// You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicUpdateParameterProperties.InboundIpRules" />. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// InboundIPRules - This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
	InboundIPRules *[]InboundIPRule `json:"inboundIpRules,omitempty"`
}

// TopicUpdateParameters properties of the Topic update
type TopicUpdateParameters struct {
	// Tags - Tags of the resource.
	Tags map[string]*string `json:"tags"`
	// Identity - Resource identity information.
	Identity *IdentityInfo `json:"identity,omitempty"`
	// TopicUpdateParameterProperties - Properties of the resource.
	*TopicUpdateParameterProperties `json:"properties,omitempty"`
	// Sku - The Sku pricing tier for the topic.
	Sku *ResourceSku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for TopicUpdateParameters.
func (tup TopicUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tup.Tags != nil {
		objectMap["tags"] = tup.Tags
	}
	if tup.Identity != nil {
		objectMap["identity"] = tup.Identity
	}
	if tup.TopicUpdateParameterProperties != nil {
		objectMap["properties"] = tup.TopicUpdateParameterProperties
	}
	if tup.Sku != nil {
		objectMap["sku"] = tup.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TopicUpdateParameters struct.
func (tup *TopicUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				tup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity IdentityInfo
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				tup.Identity = &identity
			}
		case "properties":
			if v != nil {
				var topicUpdateParameterProperties TopicUpdateParameterProperties
				err = json.Unmarshal(*v, &topicUpdateParameterProperties)
				if err != nil {
					return err
				}
				tup.TopicUpdateParameterProperties = &topicUpdateParameterProperties
			}
		case "sku":
			if v != nil {
				var sku ResourceSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				tup.Sku = &sku
			}
		}
	}

	return nil
}

// TrackedResource definition of a Tracked Resource.
type TrackedResource struct {
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the resource.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// UserIdentityProperties the information about the user identity.
type UserIdentityProperties struct {
	// PrincipalID - The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// WebHookEventSubscriptionDestination information about the webhook destination for an event subscription.
type WebHookEventSubscriptionDestination struct {
	// WebHookEventSubscriptionDestinationProperties - WebHook Properties of the event subscription destination.
	*WebHookEventSubscriptionDestinationProperties `json:"properties,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeEventSubscriptionDestination', 'EndpointTypeWebHook', 'EndpointTypeEventHub', 'EndpointTypeStorageQueue', 'EndpointTypeHybridConnection', 'EndpointTypeServiceBusQueue', 'EndpointTypeServiceBusTopic', 'EndpointTypeAzureFunction'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	whesd.EndpointType = EndpointTypeWebHook
	objectMap := make(map[string]interface{})
	if whesd.WebHookEventSubscriptionDestinationProperties != nil {
		objectMap["properties"] = whesd.WebHookEventSubscriptionDestinationProperties
	}
	if whesd.EndpointType != "" {
		objectMap["endpointType"] = whesd.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsWebHookEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool) {
	return &whesd, true
}

// AsEventHubEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool) {
	return nil, false
}

// AsStorageQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsStorageQueueEventSubscriptionDestination() (*StorageQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsHybridConnectionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsHybridConnectionEventSubscriptionDestination() (*HybridConnectionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsServiceBusQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsServiceBusQueueEventSubscriptionDestination() (*ServiceBusQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsServiceBusTopicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsServiceBusTopicEventSubscriptionDestination() (*ServiceBusTopicEventSubscriptionDestination, bool) {
	return nil, false
}

// AsAzureFunctionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsAzureFunctionEventSubscriptionDestination() (*AzureFunctionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsEventSubscriptionDestination() (*EventSubscriptionDestination, bool) {
	return nil, false
}

// AsBasicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsBasicEventSubscriptionDestination() (BasicEventSubscriptionDestination, bool) {
	return &whesd, true
}

// UnmarshalJSON is the custom unmarshaler for WebHookEventSubscriptionDestination struct.
func (whesd *WebHookEventSubscriptionDestination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var webHookEventSubscriptionDestinationProperties WebHookEventSubscriptionDestinationProperties
				err = json.Unmarshal(*v, &webHookEventSubscriptionDestinationProperties)
				if err != nil {
					return err
				}
				whesd.WebHookEventSubscriptionDestinationProperties = &webHookEventSubscriptionDestinationProperties
			}
		case "endpointType":
			if v != nil {
				var endpointType EndpointType
				err = json.Unmarshal(*v, &endpointType)
				if err != nil {
					return err
				}
				whesd.EndpointType = endpointType
			}
		}
	}

	return nil
}

// WebHookEventSubscriptionDestinationProperties information about the webhook destination properties for
// an event subscription.
type WebHookEventSubscriptionDestinationProperties struct {
	// EndpointURL - The URL that represents the endpoint of the destination of an event subscription.
	EndpointURL *string `json:"endpointUrl,omitempty"`
	// EndpointBaseURL - READ-ONLY; The base URL that represents the endpoint of the destination of an event subscription.
	EndpointBaseURL *string `json:"endpointBaseUrl,omitempty"`
	// MaxEventsPerBatch - Maximum number of events per batch.
	MaxEventsPerBatch *int32 `json:"maxEventsPerBatch,omitempty"`
	// PreferredBatchSizeInKilobytes - Preferred batch size in Kilobytes.
	PreferredBatchSizeInKilobytes *int32 `json:"preferredBatchSizeInKilobytes,omitempty"`
	// AzureActiveDirectoryTenantID - The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
	AzureActiveDirectoryTenantID *string `json:"azureActiveDirectoryTenantId,omitempty"`
	// AzureActiveDirectoryApplicationIDOrURI - The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests.
	AzureActiveDirectoryApplicationIDOrURI *string `json:"azureActiveDirectoryApplicationIdOrUri,omitempty"`
}

// MarshalJSON is the custom marshaler for WebHookEventSubscriptionDestinationProperties.
func (whesdp WebHookEventSubscriptionDestinationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if whesdp.EndpointURL != nil {
		objectMap["endpointUrl"] = whesdp.EndpointURL
	}
	if whesdp.MaxEventsPerBatch != nil {
		objectMap["maxEventsPerBatch"] = whesdp.MaxEventsPerBatch
	}
	if whesdp.PreferredBatchSizeInKilobytes != nil {
		objectMap["preferredBatchSizeInKilobytes"] = whesdp.PreferredBatchSizeInKilobytes
	}
	if whesdp.AzureActiveDirectoryTenantID != nil {
		objectMap["azureActiveDirectoryTenantId"] = whesdp.AzureActiveDirectoryTenantID
	}
	if whesdp.AzureActiveDirectoryApplicationIDOrURI != nil {
		objectMap["azureActiveDirectoryApplicationIdOrUri"] = whesdp.AzureActiveDirectoryApplicationIDOrURI
	}
	return json.Marshal(objectMap)
}
