// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateContainerAgentInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that your
	// container instance is running on. If you do not specify a cluster, the default
	// cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// The container instance ID or full ARN entries for the container instance
	// on which you would like to update the Amazon ECS container agent.
	//
	// ContainerInstance is a required field
	ContainerInstance *string `locationName:"containerInstance" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateContainerAgentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContainerAgentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateContainerAgentInput"}

	if s.ContainerInstance == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContainerInstance"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateContainerAgentOutput struct {
	_ struct{} `type:"structure"`

	// The container instance for which the container agent was updated.
	ContainerInstance *ContainerInstance `locationName:"containerInstance" type:"structure"`
}

// String returns the string representation
func (s UpdateContainerAgentOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateContainerAgent = "UpdateContainerAgent"

// UpdateContainerAgentRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Updates the Amazon ECS container agent on a specified container instance.
// Updating the Amazon ECS container agent does not interrupt running tasks
// or services on the container instance. The process for updating the agent
// differs depending on whether your container instance was launched with the
// Amazon ECS-optimized AMI or another operating system.
//
// UpdateContainerAgent requires the Amazon ECS-optimized AMI or Amazon Linux
// with the ecs-init service installed and running. For help updating the Amazon
// ECS container agent on other operating systems, see Manually Updating the
// Amazon ECS Container Agent (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html#manually_update_agent)
// in the Amazon Elastic Container Service Developer Guide.
//
//    // Example sending a request using UpdateContainerAgentRequest.
//    req := client.UpdateContainerAgentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateContainerAgent
func (c *Client) UpdateContainerAgentRequest(input *UpdateContainerAgentInput) UpdateContainerAgentRequest {
	op := &aws.Operation{
		Name:       opUpdateContainerAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateContainerAgentInput{}
	}

	req := c.newRequest(op, input, &UpdateContainerAgentOutput{})
	return UpdateContainerAgentRequest{Request: req, Input: input, Copy: c.UpdateContainerAgentRequest}
}

// UpdateContainerAgentRequest is the request type for the
// UpdateContainerAgent API operation.
type UpdateContainerAgentRequest struct {
	*aws.Request
	Input *UpdateContainerAgentInput
	Copy  func(*UpdateContainerAgentInput) UpdateContainerAgentRequest
}

// Send marshals and sends the UpdateContainerAgent API request.
func (r UpdateContainerAgentRequest) Send(ctx context.Context) (*UpdateContainerAgentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateContainerAgentResponse{
		UpdateContainerAgentOutput: r.Request.Data.(*UpdateContainerAgentOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateContainerAgentResponse is the response type for the
// UpdateContainerAgent API operation.
type UpdateContainerAgentResponse struct {
	*UpdateContainerAgentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateContainerAgent request.
func (r *UpdateContainerAgentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
