import * as _ from 'lodash';
import { Store } from 'redux';
import { RootState } from '@console/internal/redux';
import { initSubscriptionService } from '@console/plugin-sdk/src/api/pluginSubscriptionService';
import { PluginStore } from '@console/plugin-sdk/src/store';
import { setPluginStore } from '../utils/k8s';
import { registerPluginEntryCallback, loadAndEnablePlugin } from './plugin-loader';

export const initConsolePlugins = _.once(
  (pluginStore: PluginStore, reduxStore: Store<RootState>) => {
    initSubscriptionService(pluginStore, reduxStore);
    registerPluginEntryCallback(pluginStore);

    pluginStore.getAllowedDynamicPluginNames().forEach((pluginName) => {
      loadAndEnablePlugin(pluginName, pluginStore, () => {
        // TODO(vojtech): add new entry into the notification drawer
        pluginStore.registerFailedDynamicPlugin(pluginName);
      });
    });
    setPluginStore(pluginStore);
  },
);
