// Code generated by protoc-gen-go.
// source: datastore_v1.proto
// DO NOT EDIT!

/*
Package datastore is a generated protocol buffer package.

It is generated from these files:
	datastore_v1.proto

It has these top-level messages:
	PartitionId
	Key
	Value
	Property
	Entity
	EntityResult
	Query
	KindExpression
	PropertyReference
	PropertyExpression
	PropertyOrder
	Filter
	CompositeFilter
	PropertyFilter
	GqlQuery
	GqlQueryArg
	QueryResultBatch
	Mutation
	MutationResult
	ReadOptions
	LookupRequest
	LookupResponse
	RunQueryRequest
	RunQueryResponse
	BeginTransactionRequest
	BeginTransactionResponse
	RollbackRequest
	RollbackResponse
	CommitRequest
	CommitResponse
	AllocateIdsRequest
	AllocateIdsResponse
*/
package datastore

import proto "github.com/golang/protobuf/proto"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = math.Inf

// Specifies what data the 'entity' field contains.
// A ResultType is either implied (for example, in LookupResponse.found it
// is always FULL) or specified by context (for example, in message
// QueryResultBatch, field 'entity_result_type' specifies a ResultType
// for all the values in field 'entity_result').
type EntityResult_ResultType int32

const (
	EntityResult_FULL       EntityResult_ResultType = 1
	EntityResult_PROJECTION EntityResult_ResultType = 2
	// The entity may have no key.
	// A property value may have meaning 18.
	EntityResult_KEY_ONLY EntityResult_ResultType = 3
)

var EntityResult_ResultType_name = map[int32]string{
	1: "FULL",
	2: "PROJECTION",
	3: "KEY_ONLY",
}
var EntityResult_ResultType_value = map[string]int32{
	"FULL":       1,
	"PROJECTION": 2,
	"KEY_ONLY":   3,
}

func (x EntityResult_ResultType) Enum() *EntityResult_ResultType {
	p := new(EntityResult_ResultType)
	*p = x
	return p
}
func (x EntityResult_ResultType) String() string {
	return proto.EnumName(EntityResult_ResultType_name, int32(x))
}
func (x *EntityResult_ResultType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(EntityResult_ResultType_value, data, "EntityResult_ResultType")
	if err != nil {
		return err
	}
	*x = EntityResult_ResultType(value)
	return nil
}

type PropertyExpression_AggregationFunction int32

const (
	PropertyExpression_FIRST PropertyExpression_AggregationFunction = 1
)

var PropertyExpression_AggregationFunction_name = map[int32]string{
	1: "FIRST",
}
var PropertyExpression_AggregationFunction_value = map[string]int32{
	"FIRST": 1,
}

func (x PropertyExpression_AggregationFunction) Enum() *PropertyExpression_AggregationFunction {
	p := new(PropertyExpression_AggregationFunction)
	*p = x
	return p
}
func (x PropertyExpression_AggregationFunction) String() string {
	return proto.EnumName(PropertyExpression_AggregationFunction_name, int32(x))
}
func (x *PropertyExpression_AggregationFunction) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(PropertyExpression_AggregationFunction_value, data, "PropertyExpression_AggregationFunction")
	if err != nil {
		return err
	}
	*x = PropertyExpression_AggregationFunction(value)
	return nil
}

type PropertyOrder_Direction int32

const (
	PropertyOrder_ASCENDING  PropertyOrder_Direction = 1
	PropertyOrder_DESCENDING PropertyOrder_Direction = 2
)

var PropertyOrder_Direction_name = map[int32]string{
	1: "ASCENDING",
	2: "DESCENDING",
}
var PropertyOrder_Direction_value = map[string]int32{
	"ASCENDING":  1,
	"DESCENDING": 2,
}

func (x PropertyOrder_Direction) Enum() *PropertyOrder_Direction {
	p := new(PropertyOrder_Direction)
	*p = x
	return p
}
func (x PropertyOrder_Direction) String() string {
	return proto.EnumName(PropertyOrder_Direction_name, int32(x))
}
func (x *PropertyOrder_Direction) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(PropertyOrder_Direction_value, data, "PropertyOrder_Direction")
	if err != nil {
		return err
	}
	*x = PropertyOrder_Direction(value)
	return nil
}

type CompositeFilter_Operator int32

const (
	CompositeFilter_AND CompositeFilter_Operator = 1
)

var CompositeFilter_Operator_name = map[int32]string{
	1: "AND",
}
var CompositeFilter_Operator_value = map[string]int32{
	"AND": 1,
}

func (x CompositeFilter_Operator) Enum() *CompositeFilter_Operator {
	p := new(CompositeFilter_Operator)
	*p = x
	return p
}
func (x CompositeFilter_Operator) String() string {
	return proto.EnumName(CompositeFilter_Operator_name, int32(x))
}
func (x *CompositeFilter_Operator) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CompositeFilter_Operator_value, data, "CompositeFilter_Operator")
	if err != nil {
		return err
	}
	*x = CompositeFilter_Operator(value)
	return nil
}

type PropertyFilter_Operator int32

const (
	PropertyFilter_LESS_THAN             PropertyFilter_Operator = 1
	PropertyFilter_LESS_THAN_OR_EQUAL    PropertyFilter_Operator = 2
	PropertyFilter_GREATER_THAN          PropertyFilter_Operator = 3
	PropertyFilter_GREATER_THAN_OR_EQUAL PropertyFilter_Operator = 4
	PropertyFilter_EQUAL                 PropertyFilter_Operator = 5
	PropertyFilter_HAS_ANCESTOR          PropertyFilter_Operator = 11
)

var PropertyFilter_Operator_name = map[int32]string{
	1:  "LESS_THAN",
	2:  "LESS_THAN_OR_EQUAL",
	3:  "GREATER_THAN",
	4:  "GREATER_THAN_OR_EQUAL",
	5:  "EQUAL",
	11: "HAS_ANCESTOR",
}
var PropertyFilter_Operator_value = map[string]int32{
	"LESS_THAN":             1,
	"LESS_THAN_OR_EQUAL":    2,
	"GREATER_THAN":          3,
	"GREATER_THAN_OR_EQUAL": 4,
	"EQUAL":                 5,
	"HAS_ANCESTOR":          11,
}

func (x PropertyFilter_Operator) Enum() *PropertyFilter_Operator {
	p := new(PropertyFilter_Operator)
	*p = x
	return p
}
func (x PropertyFilter_Operator) String() string {
	return proto.EnumName(PropertyFilter_Operator_name, int32(x))
}
func (x *PropertyFilter_Operator) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(PropertyFilter_Operator_value, data, "PropertyFilter_Operator")
	if err != nil {
		return err
	}
	*x = PropertyFilter_Operator(value)
	return nil
}

// The possible values for the 'more_results' field.
type QueryResultBatch_MoreResultsType int32

const (
	QueryResultBatch_NOT_FINISHED             QueryResultBatch_MoreResultsType = 1
	QueryResultBatch_MORE_RESULTS_AFTER_LIMIT QueryResultBatch_MoreResultsType = 2
	// results after the limit.
	QueryResultBatch_NO_MORE_RESULTS QueryResultBatch_MoreResultsType = 3
)

var QueryResultBatch_MoreResultsType_name = map[int32]string{
	1: "NOT_FINISHED",
	2: "MORE_RESULTS_AFTER_LIMIT",
	3: "NO_MORE_RESULTS",
}
var QueryResultBatch_MoreResultsType_value = map[string]int32{
	"NOT_FINISHED":             1,
	"MORE_RESULTS_AFTER_LIMIT": 2,
	"NO_MORE_RESULTS":          3,
}

func (x QueryResultBatch_MoreResultsType) Enum() *QueryResultBatch_MoreResultsType {
	p := new(QueryResultBatch_MoreResultsType)
	*p = x
	return p
}
func (x QueryResultBatch_MoreResultsType) String() string {
	return proto.EnumName(QueryResultBatch_MoreResultsType_name, int32(x))
}
func (x *QueryResultBatch_MoreResultsType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(QueryResultBatch_MoreResultsType_value, data, "QueryResultBatch_MoreResultsType")
	if err != nil {
		return err
	}
	*x = QueryResultBatch_MoreResultsType(value)
	return nil
}

type ReadOptions_ReadConsistency int32

const (
	ReadOptions_DEFAULT  ReadOptions_ReadConsistency = 0
	ReadOptions_STRONG   ReadOptions_ReadConsistency = 1
	ReadOptions_EVENTUAL ReadOptions_ReadConsistency = 2
)

var ReadOptions_ReadConsistency_name = map[int32]string{
	0: "DEFAULT",
	1: "STRONG",
	2: "EVENTUAL",
}
var ReadOptions_ReadConsistency_value = map[string]int32{
	"DEFAULT":  0,
	"STRONG":   1,
	"EVENTUAL": 2,
}

func (x ReadOptions_ReadConsistency) Enum() *ReadOptions_ReadConsistency {
	p := new(ReadOptions_ReadConsistency)
	*p = x
	return p
}
func (x ReadOptions_ReadConsistency) String() string {
	return proto.EnumName(ReadOptions_ReadConsistency_name, int32(x))
}
func (x *ReadOptions_ReadConsistency) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ReadOptions_ReadConsistency_value, data, "ReadOptions_ReadConsistency")
	if err != nil {
		return err
	}
	*x = ReadOptions_ReadConsistency(value)
	return nil
}

type BeginTransactionRequest_IsolationLevel int32

const (
	BeginTransactionRequest_SNAPSHOT BeginTransactionRequest_IsolationLevel = 0
	// conflict if their mutations conflict. For example:
	// Read(A),Write(B) may not conflict with Read(B),Write(A),
	// but Read(B),Write(B) does conflict with Read(B),Write(B).
	BeginTransactionRequest_SERIALIZABLE BeginTransactionRequest_IsolationLevel = 1
)

var BeginTransactionRequest_IsolationLevel_name = map[int32]string{
	0: "SNAPSHOT",
	1: "SERIALIZABLE",
}
var BeginTransactionRequest_IsolationLevel_value = map[string]int32{
	"SNAPSHOT":     0,
	"SERIALIZABLE": 1,
}

func (x BeginTransactionRequest_IsolationLevel) Enum() *BeginTransactionRequest_IsolationLevel {
	p := new(BeginTransactionRequest_IsolationLevel)
	*p = x
	return p
}
func (x BeginTransactionRequest_IsolationLevel) String() string {
	return proto.EnumName(BeginTransactionRequest_IsolationLevel_name, int32(x))
}
func (x *BeginTransactionRequest_IsolationLevel) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(BeginTransactionRequest_IsolationLevel_value, data, "BeginTransactionRequest_IsolationLevel")
	if err != nil {
		return err
	}
	*x = BeginTransactionRequest_IsolationLevel(value)
	return nil
}

type CommitRequest_Mode int32

const (
	CommitRequest_TRANSACTIONAL     CommitRequest_Mode = 1
	CommitRequest_NON_TRANSACTIONAL CommitRequest_Mode = 2
)

var CommitRequest_Mode_name = map[int32]string{
	1: "TRANSACTIONAL",
	2: "NON_TRANSACTIONAL",
}
var CommitRequest_Mode_value = map[string]int32{
	"TRANSACTIONAL":     1,
	"NON_TRANSACTIONAL": 2,
}

func (x CommitRequest_Mode) Enum() *CommitRequest_Mode {
	p := new(CommitRequest_Mode)
	*p = x
	return p
}
func (x CommitRequest_Mode) String() string {
	return proto.EnumName(CommitRequest_Mode_name, int32(x))
}
func (x *CommitRequest_Mode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CommitRequest_Mode_value, data, "CommitRequest_Mode")
	if err != nil {
		return err
	}
	*x = CommitRequest_Mode(value)
	return nil
}

// An identifier for a particular subset of entities.
//
// Entities are partitioned into various subsets, each used by different
// datasets and different namespaces within a dataset and so forth.
//
// All input partition IDs are normalized before use.
// A partition ID is normalized as follows:
//   If the partition ID is unset or is set to an empty partition ID, replace it
//       with the context partition ID.
//   Otherwise, if the partition ID has no dataset ID, assign it the context
//       partition ID's dataset ID.
// Unless otherwise documented, the context partition ID has the dataset ID set
// to the context dataset ID and no other partition dimension set.
//
// A partition ID is empty if all of its fields are unset.
//
// Partition dimension:
// A dimension may be unset.
// A dimension's value must never be "".
// A dimension's value must match [A-Za-z\d\.\-_]{1,100}
// If the value of any dimension matches regex "__.*__",
// the partition is reserved/read-only.
// A reserved/read-only partition ID is forbidden in certain documented contexts.
//
// Dataset ID:
// A dataset id's value must never be "".
// A dataset id's value must match
// ([a-z\d\-]{1,100}~)?([a-z\d][a-z\d\-\.]{0,99}:)?([a-z\d][a-z\d\-]{0,99}
type PartitionId struct {
	// The dataset ID.
	DatasetId *string `protobuf:"bytes,3,opt,name=dataset_id" json:"dataset_id,omitempty"`
	// The namespace.
	Namespace        *string `protobuf:"bytes,4,opt,name=namespace" json:"namespace,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PartitionId) Reset()         { *m = PartitionId{} }
func (m *PartitionId) String() string { return proto.CompactTextString(m) }
func (*PartitionId) ProtoMessage()    {}

func (m *PartitionId) GetDatasetId() string {
	if m != nil && m.DatasetId != nil {
		return *m.DatasetId
	}
	return ""
}

func (m *PartitionId) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

// A unique identifier for an entity.
// If a key's partition id or any of its path kinds or names are
// reserved/read-only, the key is reserved/read-only.
// A reserved/read-only key is forbidden in certain documented contexts.
type Key struct {
	// Entities are partitioned into subsets, currently identified by a dataset
	// (usually implicitly specified by the project) and namespace ID.
	// Queries are scoped to a single partition.
	PartitionId *PartitionId `protobuf:"bytes,1,opt,name=partition_id" json:"partition_id,omitempty"`
	// The entity path.
	// An entity path consists of one or more elements composed of a kind and a
	// string or numerical identifier, which identify entities. The first
	// element identifies a <em>root entity</em>, the second element identifies
	// a <em>child</em> of the root entity, the third element a child of the
	// second entity, and so forth. The entities identified by all prefixes of
	// the path are called the element's <em>ancestors</em>.
	// An entity path is always fully complete: ALL of the entity's ancestors
	// are required to be in the path along with the entity identifier itself.
	// The only exception is that in some documented cases, the identifier in the
	// last path element (for the entity) itself may be omitted. A path can never
	// be empty.
	PathElement      []*Key_PathElement `protobuf:"bytes,2,rep,name=path_element" json:"path_element,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *Key) Reset()         { *m = Key{} }
func (m *Key) String() string { return proto.CompactTextString(m) }
func (*Key) ProtoMessage()    {}

func (m *Key) GetPartitionId() *PartitionId {
	if m != nil {
		return m.PartitionId
	}
	return nil
}

func (m *Key) GetPathElement() []*Key_PathElement {
	if m != nil {
		return m.PathElement
	}
	return nil
}

// A (kind, ID/name) pair used to construct a key path.
//
// At most one of name or ID may be set.
// If either is set, the element is complete.
// If neither is set, the element is incomplete.
type Key_PathElement struct {
	// The kind of the entity.
	// A kind matching regex "__.*__" is reserved/read-only.
	// A kind must not contain more than 500 characters.
	// Cannot be "".
	Kind *string `protobuf:"bytes,1,req,name=kind" json:"kind,omitempty"`
	// The ID of the entity.
	// Never equal to zero. Values less than zero are discouraged and will not
	// be supported in the future.
	Id *int64 `protobuf:"varint,2,opt,name=id" json:"id,omitempty"`
	// The name of the entity.
	// A name matching regex "__.*__" is reserved/read-only.
	// A name must not be more than 500 characters.
	// Cannot be "".
	Name             *string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Key_PathElement) Reset()         { *m = Key_PathElement{} }
func (m *Key_PathElement) String() string { return proto.CompactTextString(m) }
func (*Key_PathElement) ProtoMessage()    {}

func (m *Key_PathElement) GetKind() string {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return ""
}

func (m *Key_PathElement) GetId() int64 {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return 0
}

func (m *Key_PathElement) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

// A message that can hold any of the supported value types and associated
// metadata.
//
// At most one of the <type>Value fields may be set.
// If none are set the value is "null".
//
type Value struct {
	// A boolean value.
	BooleanValue *bool `protobuf:"varint,1,opt,name=boolean_value" json:"boolean_value,omitempty"`
	// An integer value.
	IntegerValue *int64 `protobuf:"varint,2,opt,name=integer_value" json:"integer_value,omitempty"`
	// A double value.
	DoubleValue *float64 `protobuf:"fixed64,3,opt,name=double_value" json:"double_value,omitempty"`
	// A timestamp value.
	TimestampMicrosecondsValue *int64 `protobuf:"varint,4,opt,name=timestamp_microseconds_value" json:"timestamp_microseconds_value,omitempty"`
	// A key value.
	KeyValue *Key `protobuf:"bytes,5,opt,name=key_value" json:"key_value,omitempty"`
	// A blob key value.
	BlobKeyValue *string `protobuf:"bytes,16,opt,name=blob_key_value" json:"blob_key_value,omitempty"`
	// A UTF-8 encoded string value.
	StringValue *string `protobuf:"bytes,17,opt,name=string_value" json:"string_value,omitempty"`
	// A blob value.
	BlobValue []byte `protobuf:"bytes,18,opt,name=blob_value" json:"blob_value,omitempty"`
	// An entity value.
	// May have no key.
	// May have a key with an incomplete key path.
	// May have a reserved/read-only key.
	EntityValue *Entity `protobuf:"bytes,6,opt,name=entity_value" json:"entity_value,omitempty"`
	// A list value.
	// Cannot contain another list value.
	// Cannot also have a meaning and indexing set.
	ListValue []*Value `protobuf:"bytes,7,rep,name=list_value" json:"list_value,omitempty"`
	// The <code>meaning</code> field is reserved and should not be used.
	Meaning *int32 `protobuf:"varint,14,opt,name=meaning" json:"meaning,omitempty"`
	// If the value should be indexed.
	//
	// The <code>indexed</code> property may be set for a
	// <code>null</code> value.
	// When <code>indexed</code> is <code>true</code>, <code>stringValue</code>
	// is limited to 500 characters and the blob value is limited to 500 bytes.
	// Exception: If meaning is set to 2, string_value is limited to 2038
	// characters regardless of indexed.
	// When indexed is true, meaning 15 and 22 are not allowed, and meaning 16
	// will be ignored on input (and will never be set on output).
	// Input values by default have <code>indexed</code> set to
	// <code>true</code>; however, you can explicitly set <code>indexed</code> to
	// <code>true</code> if you want. (An output value never has
	// <code>indexed</code> explicitly set to <code>true</code>.) If a value is
	// itself an entity, it cannot have <code>indexed</code> set to
	// <code>true</code>.
	// Exception: An entity value with meaning 9, 20 or 21 may be indexed.
	Indexed          *bool  `protobuf:"varint,15,opt,name=indexed,def=1" json:"indexed,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Value) Reset()         { *m = Value{} }
func (m *Value) String() string { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()    {}

const Default_Value_Indexed bool = true

func (m *Value) GetBooleanValue() bool {
	if m != nil && m.BooleanValue != nil {
		return *m.BooleanValue
	}
	return false
}

func (m *Value) GetIntegerValue() int64 {
	if m != nil && m.IntegerValue != nil {
		return *m.IntegerValue
	}
	return 0
}

func (m *Value) GetDoubleValue() float64 {
	if m != nil && m.DoubleValue != nil {
		return *m.DoubleValue
	}
	return 0
}

func (m *Value) GetTimestampMicrosecondsValue() int64 {
	if m != nil && m.TimestampMicrosecondsValue != nil {
		return *m.TimestampMicrosecondsValue
	}
	return 0
}

func (m *Value) GetKeyValue() *Key {
	if m != nil {
		return m.KeyValue
	}
	return nil
}

func (m *Value) GetBlobKeyValue() string {
	if m != nil && m.BlobKeyValue != nil {
		return *m.BlobKeyValue
	}
	return ""
}

func (m *Value) GetStringValue() string {
	if m != nil && m.StringValue != nil {
		return *m.StringValue
	}
	return ""
}

func (m *Value) GetBlobValue() []byte {
	if m != nil {
		return m.BlobValue
	}
	return nil
}

func (m *Value) GetEntityValue() *Entity {
	if m != nil {
		return m.EntityValue
	}
	return nil
}

func (m *Value) GetListValue() []*Value {
	if m != nil {
		return m.ListValue
	}
	return nil
}

func (m *Value) GetMeaning() int32 {
	if m != nil && m.Meaning != nil {
		return *m.Meaning
	}
	return 0
}

func (m *Value) GetIndexed() bool {
	if m != nil && m.Indexed != nil {
		return *m.Indexed
	}
	return Default_Value_Indexed
}

// An entity property.
type Property struct {
	// The name of the property.
	// A property name matching regex "__.*__" is reserved.
	// A reserved property name is forbidden in certain documented contexts.
	// The name must not contain more than 500 characters.
	// Cannot be "".
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// The value(s) of the property.
	// Each value can have only one value property populated. For example,
	// you cannot have a values list of <code>{ value: { integerValue: 22,
	// stringValue: "a" } }</code>, but you can have <code>{ value: { listValue:
	// [ { integerValue: 22 }, { stringValue: "a" } ] }</code>.
	Value            *Value `protobuf:"bytes,4,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Property) Reset()         { *m = Property{} }
func (m *Property) String() string { return proto.CompactTextString(m) }
func (*Property) ProtoMessage()    {}

func (m *Property) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Property) GetValue() *Value {
	if m != nil {
		return m.Value
	}
	return nil
}

// An entity.
//
// An entity is limited to 1 megabyte when stored. That <em>roughly</em>
// corresponds to a limit of 1 megabyte for the serialized form of this
// message.
type Entity struct {
	// The entity's key.
	//
	// An entity must have a key, unless otherwise documented (for example,
	// an entity in <code>Value.entityValue</code> may have no key).
	// An entity's kind is its key's path's last element's kind,
	// or null if it has no key.
	Key *Key `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// The entity's properties.
	// Each property's name must be unique for its entity.
	Property         []*Property `protobuf:"bytes,2,rep,name=property" json:"property,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Entity) Reset()         { *m = Entity{} }
func (m *Entity) String() string { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()    {}

func (m *Entity) GetKey() *Key {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *Entity) GetProperty() []*Property {
	if m != nil {
		return m.Property
	}
	return nil
}

// The result of fetching an entity from the datastore.
type EntityResult struct {
	// The resulting entity.
	Entity           *Entity `protobuf:"bytes,1,req,name=entity" json:"entity,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *EntityResult) Reset()         { *m = EntityResult{} }
func (m *EntityResult) String() string { return proto.CompactTextString(m) }
func (*EntityResult) ProtoMessage()    {}

func (m *EntityResult) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

// A query.
type Query struct {
	// The projection to return. If not set the entire entity is returned.
	Projection []*PropertyExpression `protobuf:"bytes,2,rep,name=projection" json:"projection,omitempty"`
	// The kinds to query (if empty, returns entities from all kinds).
	Kind []*KindExpression `protobuf:"bytes,3,rep,name=kind" json:"kind,omitempty"`
	// The filter to apply (optional).
	Filter *Filter `protobuf:"bytes,4,opt,name=filter" json:"filter,omitempty"`
	// The order to apply to the query results (if empty, order is unspecified).
	Order []*PropertyOrder `protobuf:"bytes,5,rep,name=order" json:"order,omitempty"`
	// The properties to group by (if empty, no grouping is applied to the
	// result set).
	GroupBy []*PropertyReference `protobuf:"bytes,6,rep,name=group_by" json:"group_by,omitempty"`
	// A starting point for the query results. Optional. Query cursors are
	// returned in query result batches.
	StartCursor []byte `protobuf:"bytes,7,opt,name=start_cursor" json:"start_cursor,omitempty"`
	// An ending point for the query results. Optional. Query cursors are
	// returned in query result batches.
	EndCursor []byte `protobuf:"bytes,8,opt,name=end_cursor" json:"end_cursor,omitempty"`
	// The number of results to skip. Applies before limit, but after all other
	// constraints (optional, defaults to 0).
	Offset *int32 `protobuf:"varint,10,opt,name=offset,def=0" json:"offset,omitempty"`
	// The maximum number of results to return. Applies after all other
	// constraints. Optional.
	Limit            *int32 `protobuf:"varint,11,opt,name=limit" json:"limit,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Query) Reset()         { *m = Query{} }
func (m *Query) String() string { return proto.CompactTextString(m) }
func (*Query) ProtoMessage()    {}

const Default_Query_Offset int32 = 0

func (m *Query) GetProjection() []*PropertyExpression {
	if m != nil {
		return m.Projection
	}
	return nil
}

func (m *Query) GetKind() []*KindExpression {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (m *Query) GetFilter() *Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *Query) GetOrder() []*PropertyOrder {
	if m != nil {
		return m.Order
	}
	return nil
}

func (m *Query) GetGroupBy() []*PropertyReference {
	if m != nil {
		return m.GroupBy
	}
	return nil
}

func (m *Query) GetStartCursor() []byte {
	if m != nil {
		return m.StartCursor
	}
	return nil
}

func (m *Query) GetEndCursor() []byte {
	if m != nil {
		return m.EndCursor
	}
	return nil
}

func (m *Query) GetOffset() int32 {
	if m != nil && m.Offset != nil {
		return *m.Offset
	}
	return Default_Query_Offset
}

func (m *Query) GetLimit() int32 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return 0
}

// A representation of a kind.
type KindExpression struct {
	// The name of the kind.
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *KindExpression) Reset()         { *m = KindExpression{} }
func (m *KindExpression) String() string { return proto.CompactTextString(m) }
func (*KindExpression) ProtoMessage()    {}

func (m *KindExpression) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

// A reference to a property relative to the kind expressions.
// exactly.
type PropertyReference struct {
	// The name of the property.
	Name             *string `protobuf:"bytes,2,req,name=name" json:"name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PropertyReference) Reset()         { *m = PropertyReference{} }
func (m *PropertyReference) String() string { return proto.CompactTextString(m) }
func (*PropertyReference) ProtoMessage()    {}

func (m *PropertyReference) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

// A representation of a property in a projection.
type PropertyExpression struct {
	// The property to project.
	Property *PropertyReference `protobuf:"bytes,1,req,name=property" json:"property,omitempty"`
	// The aggregation function to apply to the property. Optional.
	// Can only be used when grouping by at least one property. Must
	// then be set on all properties in the projection that are not
	// being grouped by.
	AggregationFunction *PropertyExpression_AggregationFunction `protobuf:"varint,2,opt,name=aggregation_function,enum=datastore.PropertyExpression_AggregationFunction" json:"aggregation_function,omitempty"`
	XXX_unrecognized    []byte                                  `json:"-"`
}

func (m *PropertyExpression) Reset()         { *m = PropertyExpression{} }
func (m *PropertyExpression) String() string { return proto.CompactTextString(m) }
func (*PropertyExpression) ProtoMessage()    {}

func (m *PropertyExpression) GetProperty() *PropertyReference {
	if m != nil {
		return m.Property
	}
	return nil
}

func (m *PropertyExpression) GetAggregationFunction() PropertyExpression_AggregationFunction {
	if m != nil && m.AggregationFunction != nil {
		return *m.AggregationFunction
	}
	return PropertyExpression_FIRST
}

// The desired order for a specific property.
type PropertyOrder struct {
	// The property to order by.
	Property *PropertyReference `protobuf:"bytes,1,req,name=property" json:"property,omitempty"`
	// The direction to order by.
	Direction        *PropertyOrder_Direction `protobuf:"varint,2,opt,name=direction,enum=datastore.PropertyOrder_Direction,def=1" json:"direction,omitempty"`
	XXX_unrecognized []byte                   `json:"-"`
}

func (m *PropertyOrder) Reset()         { *m = PropertyOrder{} }
func (m *PropertyOrder) String() string { return proto.CompactTextString(m) }
func (*PropertyOrder) ProtoMessage()    {}

const Default_PropertyOrder_Direction PropertyOrder_Direction = PropertyOrder_ASCENDING

func (m *PropertyOrder) GetProperty() *PropertyReference {
	if m != nil {
		return m.Property
	}
	return nil
}

func (m *PropertyOrder) GetDirection() PropertyOrder_Direction {
	if m != nil && m.Direction != nil {
		return *m.Direction
	}
	return Default_PropertyOrder_Direction
}

// A holder for any type of filter. Exactly one field should be specified.
type Filter struct {
	// A composite filter.
	CompositeFilter *CompositeFilter `protobuf:"bytes,1,opt,name=composite_filter" json:"composite_filter,omitempty"`
	// A filter on a property.
	PropertyFilter   *PropertyFilter `protobuf:"bytes,2,opt,name=property_filter" json:"property_filter,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *Filter) Reset()         { *m = Filter{} }
func (m *Filter) String() string { return proto.CompactTextString(m) }
func (*Filter) ProtoMessage()    {}

func (m *Filter) GetCompositeFilter() *CompositeFilter {
	if m != nil {
		return m.CompositeFilter
	}
	return nil
}

func (m *Filter) GetPropertyFilter() *PropertyFilter {
	if m != nil {
		return m.PropertyFilter
	}
	return nil
}

// A filter that merges the multiple other filters using the given operation.
type CompositeFilter struct {
	// The operator for combining multiple filters.
	Operator *CompositeFilter_Operator `protobuf:"varint,1,req,name=operator,enum=datastore.CompositeFilter_Operator" json:"operator,omitempty"`
	// The list of filters to combine.
	// Must contain at least one filter.
	Filter           []*Filter `protobuf:"bytes,2,rep,name=filter" json:"filter,omitempty"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *CompositeFilter) Reset()         { *m = CompositeFilter{} }
func (m *CompositeFilter) String() string { return proto.CompactTextString(m) }
func (*CompositeFilter) ProtoMessage()    {}

func (m *CompositeFilter) GetOperator() CompositeFilter_Operator {
	if m != nil && m.Operator != nil {
		return *m.Operator
	}
	return CompositeFilter_AND
}

func (m *CompositeFilter) GetFilter() []*Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

// A filter on a specific property.
type PropertyFilter struct {
	// The property to filter by.
	Property *PropertyReference `protobuf:"bytes,1,req,name=property" json:"property,omitempty"`
	// The operator to filter by.
	Operator *PropertyFilter_Operator `protobuf:"varint,2,req,name=operator,enum=datastore.PropertyFilter_Operator" json:"operator,omitempty"`
	// The value to compare the property to.
	Value            *Value `protobuf:"bytes,3,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *PropertyFilter) Reset()         { *m = PropertyFilter{} }
func (m *PropertyFilter) String() string { return proto.CompactTextString(m) }
func (*PropertyFilter) ProtoMessage()    {}

func (m *PropertyFilter) GetProperty() *PropertyReference {
	if m != nil {
		return m.Property
	}
	return nil
}

func (m *PropertyFilter) GetOperator() PropertyFilter_Operator {
	if m != nil && m.Operator != nil {
		return *m.Operator
	}
	return PropertyFilter_LESS_THAN
}

func (m *PropertyFilter) GetValue() *Value {
	if m != nil {
		return m.Value
	}
	return nil
}

// A GQL query.
type GqlQuery struct {
	QueryString *string `protobuf:"bytes,1,req,name=query_string" json:"query_string,omitempty"`
	// When false, the query string must not contain a literal.
	AllowLiteral *bool `protobuf:"varint,2,opt,name=allow_literal,def=0" json:"allow_literal,omitempty"`
	// A named argument must set field GqlQueryArg.name.
	// No two named arguments may have the same name.
	// For each non-reserved named binding site in the query string,
	// there must be a named argument with that name,
	// but not necessarily the inverse.
	NameArg []*GqlQueryArg `protobuf:"bytes,3,rep,name=name_arg" json:"name_arg,omitempty"`
	// Numbered binding site @1 references the first numbered argument,
	// effectively using 1-based indexing, rather than the usual 0.
	// A numbered argument must NOT set field GqlQueryArg.name.
	// For each binding site numbered i in query_string,
	// there must be an ith numbered argument.
	// The inverse must also be true.
	NumberArg        []*GqlQueryArg `protobuf:"bytes,4,rep,name=number_arg" json:"number_arg,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *GqlQuery) Reset()         { *m = GqlQuery{} }
func (m *GqlQuery) String() string { return proto.CompactTextString(m) }
func (*GqlQuery) ProtoMessage()    {}

const Default_GqlQuery_AllowLiteral bool = false

func (m *GqlQuery) GetQueryString() string {
	if m != nil && m.QueryString != nil {
		return *m.QueryString
	}
	return ""
}

func (m *GqlQuery) GetAllowLiteral() bool {
	if m != nil && m.AllowLiteral != nil {
		return *m.AllowLiteral
	}
	return Default_GqlQuery_AllowLiteral
}

func (m *GqlQuery) GetNameArg() []*GqlQueryArg {
	if m != nil {
		return m.NameArg
	}
	return nil
}

func (m *GqlQuery) GetNumberArg() []*GqlQueryArg {
	if m != nil {
		return m.NumberArg
	}
	return nil
}

// A binding argument for a GQL query.
// Exactly one of fields value and cursor must be set.
type GqlQueryArg struct {
	// Must match regex "[A-Za-z_$][A-Za-z_$0-9]*".
	// Must not match regex "__.*__".
	// Must not be "".
	Name             *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Value            *Value  `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	Cursor           []byte  `protobuf:"bytes,3,opt,name=cursor" json:"cursor,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *GqlQueryArg) Reset()         { *m = GqlQueryArg{} }
func (m *GqlQueryArg) String() string { return proto.CompactTextString(m) }
func (*GqlQueryArg) ProtoMessage()    {}

func (m *GqlQueryArg) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *GqlQueryArg) GetValue() *Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *GqlQueryArg) GetCursor() []byte {
	if m != nil {
		return m.Cursor
	}
	return nil
}

// A batch of results produced by a query.
type QueryResultBatch struct {
	// The result type for every entity in entityResults.
	EntityResultType *EntityResult_ResultType `protobuf:"varint,1,req,name=entity_result_type,enum=datastore.EntityResult_ResultType" json:"entity_result_type,omitempty"`
	// The results for this batch.
	EntityResult []*EntityResult `protobuf:"bytes,2,rep,name=entity_result" json:"entity_result,omitempty"`
	// A cursor that points to the position after the last result in the batch.
	// May be absent.
	EndCursor []byte `protobuf:"bytes,4,opt,name=end_cursor" json:"end_cursor,omitempty"`
	// The state of the query after the current batch.
	MoreResults *QueryResultBatch_MoreResultsType `protobuf:"varint,5,req,name=more_results,enum=datastore.QueryResultBatch_MoreResultsType" json:"more_results,omitempty"`
	// The number of results skipped because of <code>Query.offset</code>.
	SkippedResults   *int32 `protobuf:"varint,6,opt,name=skipped_results" json:"skipped_results,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *QueryResultBatch) Reset()         { *m = QueryResultBatch{} }
func (m *QueryResultBatch) String() string { return proto.CompactTextString(m) }
func (*QueryResultBatch) ProtoMessage()    {}

func (m *QueryResultBatch) GetEntityResultType() EntityResult_ResultType {
	if m != nil && m.EntityResultType != nil {
		return *m.EntityResultType
	}
	return EntityResult_FULL
}

func (m *QueryResultBatch) GetEntityResult() []*EntityResult {
	if m != nil {
		return m.EntityResult
	}
	return nil
}

func (m *QueryResultBatch) GetEndCursor() []byte {
	if m != nil {
		return m.EndCursor
	}
	return nil
}

func (m *QueryResultBatch) GetMoreResults() QueryResultBatch_MoreResultsType {
	if m != nil && m.MoreResults != nil {
		return *m.MoreResults
	}
	return QueryResultBatch_NOT_FINISHED
}

func (m *QueryResultBatch) GetSkippedResults() int32 {
	if m != nil && m.SkippedResults != nil {
		return *m.SkippedResults
	}
	return 0
}

// A set of changes to apply.
//
// No entity in this message may have a reserved property name,
// not even a property in an entity in a value.
// No value in this message may have meaning 18,
// not even a value in an entity in another value.
//
// If entities with duplicate keys are present, an arbitrary choice will
// be made as to which is written.
type Mutation struct {
	// Entities to upsert.
	// Each upserted entity's key must have a complete path and
	// must not be reserved/read-only.
	Upsert []*Entity `protobuf:"bytes,1,rep,name=upsert" json:"upsert,omitempty"`
	// Entities to update.
	// Each updated entity's key must have a complete path and
	// must not be reserved/read-only.
	Update []*Entity `protobuf:"bytes,2,rep,name=update" json:"update,omitempty"`
	// Entities to insert.
	// Each inserted entity's key must have a complete path and
	// must not be reserved/read-only.
	Insert []*Entity `protobuf:"bytes,3,rep,name=insert" json:"insert,omitempty"`
	// Insert entities with a newly allocated ID.
	// Each inserted entity's key must omit the final identifier in its path and
	// must not be reserved/read-only.
	InsertAutoId []*Entity `protobuf:"bytes,4,rep,name=insert_auto_id" json:"insert_auto_id,omitempty"`
	// Keys of entities to delete.
	// Each key must have a complete key path and must not be reserved/read-only.
	Delete []*Key `protobuf:"bytes,5,rep,name=delete" json:"delete,omitempty"`
	// Ignore a user specified read-only period. Optional.
	Force            *bool  `protobuf:"varint,6,opt,name=force" json:"force,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Mutation) Reset()         { *m = Mutation{} }
func (m *Mutation) String() string { return proto.CompactTextString(m) }
func (*Mutation) ProtoMessage()    {}

func (m *Mutation) GetUpsert() []*Entity {
	if m != nil {
		return m.Upsert
	}
	return nil
}

func (m *Mutation) GetUpdate() []*Entity {
	if m != nil {
		return m.Update
	}
	return nil
}

func (m *Mutation) GetInsert() []*Entity {
	if m != nil {
		return m.Insert
	}
	return nil
}

func (m *Mutation) GetInsertAutoId() []*Entity {
	if m != nil {
		return m.InsertAutoId
	}
	return nil
}

func (m *Mutation) GetDelete() []*Key {
	if m != nil {
		return m.Delete
	}
	return nil
}

func (m *Mutation) GetForce() bool {
	if m != nil && m.Force != nil {
		return *m.Force
	}
	return false
}

// The result of applying a mutation.
type MutationResult struct {
	// Number of index writes.
	IndexUpdates *int32 `protobuf:"varint,1,req,name=index_updates" json:"index_updates,omitempty"`
	// Keys for <code>insertAutoId</code> entities. One per entity from the
	// request, in the same order.
	InsertAutoIdKey  []*Key `protobuf:"bytes,2,rep,name=insert_auto_id_key" json:"insert_auto_id_key,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *MutationResult) Reset()         { *m = MutationResult{} }
func (m *MutationResult) String() string { return proto.CompactTextString(m) }
func (*MutationResult) ProtoMessage()    {}

func (m *MutationResult) GetIndexUpdates() int32 {
	if m != nil && m.IndexUpdates != nil {
		return *m.IndexUpdates
	}
	return 0
}

func (m *MutationResult) GetInsertAutoIdKey() []*Key {
	if m != nil {
		return m.InsertAutoIdKey
	}
	return nil
}

// Options shared by read requests.
type ReadOptions struct {
	// The read consistency to use.
	// Cannot be set when transaction is set.
	// Lookup and ancestor queries default to STRONG, global queries default to
	// EVENTUAL and cannot be set to STRONG.
	ReadConsistency *ReadOptions_ReadConsistency `protobuf:"varint,1,opt,name=read_consistency,enum=datastore.ReadOptions_ReadConsistency,def=0" json:"read_consistency,omitempty"`
	// The transaction to use. Optional.
	Transaction      []byte `protobuf:"bytes,2,opt,name=transaction" json:"transaction,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ReadOptions) Reset()         { *m = ReadOptions{} }
func (m *ReadOptions) String() string { return proto.CompactTextString(m) }
func (*ReadOptions) ProtoMessage()    {}

const Default_ReadOptions_ReadConsistency ReadOptions_ReadConsistency = ReadOptions_DEFAULT

func (m *ReadOptions) GetReadConsistency() ReadOptions_ReadConsistency {
	if m != nil && m.ReadConsistency != nil {
		return *m.ReadConsistency
	}
	return Default_ReadOptions_ReadConsistency
}

func (m *ReadOptions) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The request for Lookup.
type LookupRequest struct {
	// Options for this lookup request. Optional.
	ReadOptions *ReadOptions `protobuf:"bytes,1,opt,name=read_options" json:"read_options,omitempty"`
	// Keys of entities to look up from the datastore.
	Key              []*Key `protobuf:"bytes,3,rep,name=key" json:"key,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *LookupRequest) Reset()         { *m = LookupRequest{} }
func (m *LookupRequest) String() string { return proto.CompactTextString(m) }
func (*LookupRequest) ProtoMessage()    {}

func (m *LookupRequest) GetReadOptions() *ReadOptions {
	if m != nil {
		return m.ReadOptions
	}
	return nil
}

func (m *LookupRequest) GetKey() []*Key {
	if m != nil {
		return m.Key
	}
	return nil
}

// The response for Lookup.
type LookupResponse struct {
	// Entities found as ResultType.FULL entities.
	Found []*EntityResult `protobuf:"bytes,1,rep,name=found" json:"found,omitempty"`
	// Entities not found as ResultType.KEY_ONLY entities.
	Missing []*EntityResult `protobuf:"bytes,2,rep,name=missing" json:"missing,omitempty"`
	// A list of keys that were not looked up due to resource constraints.
	Deferred         []*Key `protobuf:"bytes,3,rep,name=deferred" json:"deferred,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *LookupResponse) Reset()         { *m = LookupResponse{} }
func (m *LookupResponse) String() string { return proto.CompactTextString(m) }
func (*LookupResponse) ProtoMessage()    {}

func (m *LookupResponse) GetFound() []*EntityResult {
	if m != nil {
		return m.Found
	}
	return nil
}

func (m *LookupResponse) GetMissing() []*EntityResult {
	if m != nil {
		return m.Missing
	}
	return nil
}

func (m *LookupResponse) GetDeferred() []*Key {
	if m != nil {
		return m.Deferred
	}
	return nil
}

// The request for RunQuery.
type RunQueryRequest struct {
	// The options for this query.
	ReadOptions *ReadOptions `protobuf:"bytes,1,opt,name=read_options" json:"read_options,omitempty"`
	// Entities are partitioned into subsets, identified by a dataset (usually
	// implicitly specified by the project) and namespace ID. Queries are scoped
	// to a single partition.
	// This partition ID is normalized with the standard default context
	// partition ID, but all other partition IDs in RunQueryRequest are
	// normalized with this partition ID as the context partition ID.
	PartitionId *PartitionId `protobuf:"bytes,2,opt,name=partition_id" json:"partition_id,omitempty"`
	// The query to run.
	// Either this field or field gql_query must be set, but not both.
	Query *Query `protobuf:"bytes,3,opt,name=query" json:"query,omitempty"`
	// The GQL query to run.
	// Either this field or field query must be set, but not both.
	GqlQuery         *GqlQuery `protobuf:"bytes,7,opt,name=gql_query" json:"gql_query,omitempty"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *RunQueryRequest) Reset()         { *m = RunQueryRequest{} }
func (m *RunQueryRequest) String() string { return proto.CompactTextString(m) }
func (*RunQueryRequest) ProtoMessage()    {}

func (m *RunQueryRequest) GetReadOptions() *ReadOptions {
	if m != nil {
		return m.ReadOptions
	}
	return nil
}

func (m *RunQueryRequest) GetPartitionId() *PartitionId {
	if m != nil {
		return m.PartitionId
	}
	return nil
}

func (m *RunQueryRequest) GetQuery() *Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *RunQueryRequest) GetGqlQuery() *GqlQuery {
	if m != nil {
		return m.GqlQuery
	}
	return nil
}

// The response for RunQuery.
type RunQueryResponse struct {
	// A batch of query results (always present).
	Batch            *QueryResultBatch `protobuf:"bytes,1,opt,name=batch" json:"batch,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *RunQueryResponse) Reset()         { *m = RunQueryResponse{} }
func (m *RunQueryResponse) String() string { return proto.CompactTextString(m) }
func (*RunQueryResponse) ProtoMessage()    {}

func (m *RunQueryResponse) GetBatch() *QueryResultBatch {
	if m != nil {
		return m.Batch
	}
	return nil
}

// The request for BeginTransaction.
type BeginTransactionRequest struct {
	// The transaction isolation level.
	IsolationLevel   *BeginTransactionRequest_IsolationLevel `protobuf:"varint,1,opt,name=isolation_level,enum=datastore.BeginTransactionRequest_IsolationLevel,def=0" json:"isolation_level,omitempty"`
	XXX_unrecognized []byte                                  `json:"-"`
}

func (m *BeginTransactionRequest) Reset()         { *m = BeginTransactionRequest{} }
func (m *BeginTransactionRequest) String() string { return proto.CompactTextString(m) }
func (*BeginTransactionRequest) ProtoMessage()    {}

const Default_BeginTransactionRequest_IsolationLevel BeginTransactionRequest_IsolationLevel = BeginTransactionRequest_SNAPSHOT

func (m *BeginTransactionRequest) GetIsolationLevel() BeginTransactionRequest_IsolationLevel {
	if m != nil && m.IsolationLevel != nil {
		return *m.IsolationLevel
	}
	return Default_BeginTransactionRequest_IsolationLevel
}

// The response for BeginTransaction.
type BeginTransactionResponse struct {
	// The transaction identifier (always present).
	Transaction      []byte `protobuf:"bytes,1,opt,name=transaction" json:"transaction,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *BeginTransactionResponse) Reset()         { *m = BeginTransactionResponse{} }
func (m *BeginTransactionResponse) String() string { return proto.CompactTextString(m) }
func (*BeginTransactionResponse) ProtoMessage()    {}

func (m *BeginTransactionResponse) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The request for Rollback.
type RollbackRequest struct {
	// The transaction identifier, returned by a call to
	// <code>beginTransaction</code>.
	Transaction      []byte `protobuf:"bytes,1,req,name=transaction" json:"transaction,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RollbackRequest) Reset()         { *m = RollbackRequest{} }
func (m *RollbackRequest) String() string { return proto.CompactTextString(m) }
func (*RollbackRequest) ProtoMessage()    {}

func (m *RollbackRequest) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The response for Rollback.
type RollbackResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *RollbackResponse) Reset()         { *m = RollbackResponse{} }
func (m *RollbackResponse) String() string { return proto.CompactTextString(m) }
func (*RollbackResponse) ProtoMessage()    {}

// The request for Commit.
type CommitRequest struct {
	// The transaction identifier, returned by a call to
	// <code>beginTransaction</code>. Must be set when mode is TRANSACTIONAL.
	Transaction []byte `protobuf:"bytes,1,opt,name=transaction" json:"transaction,omitempty"`
	// The mutation to perform. Optional.
	Mutation *Mutation `protobuf:"bytes,2,opt,name=mutation" json:"mutation,omitempty"`
	// The type of commit to perform. Either TRANSACTIONAL or NON_TRANSACTIONAL.
	Mode             *CommitRequest_Mode `protobuf:"varint,5,opt,name=mode,enum=datastore.CommitRequest_Mode,def=1" json:"mode,omitempty"`
	XXX_unrecognized []byte              `json:"-"`
}

func (m *CommitRequest) Reset()         { *m = CommitRequest{} }
func (m *CommitRequest) String() string { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()    {}

const Default_CommitRequest_Mode CommitRequest_Mode = CommitRequest_TRANSACTIONAL

func (m *CommitRequest) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *CommitRequest) GetMutation() *Mutation {
	if m != nil {
		return m.Mutation
	}
	return nil
}

func (m *CommitRequest) GetMode() CommitRequest_Mode {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return Default_CommitRequest_Mode
}

// The response for Commit.
type CommitResponse struct {
	// The result of performing the mutation (if any).
	MutationResult   *MutationResult `protobuf:"bytes,1,opt,name=mutation_result" json:"mutation_result,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *CommitResponse) Reset()         { *m = CommitResponse{} }
func (m *CommitResponse) String() string { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()    {}

func (m *CommitResponse) GetMutationResult() *MutationResult {
	if m != nil {
		return m.MutationResult
	}
	return nil
}

// The request for AllocateIds.
type AllocateIdsRequest struct {
	// A list of keys with incomplete key paths to allocate IDs for.
	// No key may be reserved/read-only.
	Key              []*Key `protobuf:"bytes,1,rep,name=key" json:"key,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *AllocateIdsRequest) Reset()         { *m = AllocateIdsRequest{} }
func (m *AllocateIdsRequest) String() string { return proto.CompactTextString(m) }
func (*AllocateIdsRequest) ProtoMessage()    {}

func (m *AllocateIdsRequest) GetKey() []*Key {
	if m != nil {
		return m.Key
	}
	return nil
}

// The response for AllocateIds.
type AllocateIdsResponse struct {
	// The keys specified in the request (in the same order), each with
	// its key path completed with a newly allocated ID.
	Key              []*Key `protobuf:"bytes,1,rep,name=key" json:"key,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *AllocateIdsResponse) Reset()         { *m = AllocateIdsResponse{} }
func (m *AllocateIdsResponse) String() string { return proto.CompactTextString(m) }
func (*AllocateIdsResponse) ProtoMessage()    {}

func (m *AllocateIdsResponse) GetKey() []*Key {
	if m != nil {
		return m.Key
	}
	return nil
}

func init() {
	proto.RegisterEnum("datastore.EntityResult_ResultType", EntityResult_ResultType_name, EntityResult_ResultType_value)
	proto.RegisterEnum("datastore.PropertyExpression_AggregationFunction", PropertyExpression_AggregationFunction_name, PropertyExpression_AggregationFunction_value)
	proto.RegisterEnum("datastore.PropertyOrder_Direction", PropertyOrder_Direction_name, PropertyOrder_Direction_value)
	proto.RegisterEnum("datastore.CompositeFilter_Operator", CompositeFilter_Operator_name, CompositeFilter_Operator_value)
	proto.RegisterEnum("datastore.PropertyFilter_Operator", PropertyFilter_Operator_name, PropertyFilter_Operator_value)
	proto.RegisterEnum("datastore.QueryResultBatch_MoreResultsType", QueryResultBatch_MoreResultsType_name, QueryResultBatch_MoreResultsType_value)
	proto.RegisterEnum("datastore.ReadOptions_ReadConsistency", ReadOptions_ReadConsistency_name, ReadOptions_ReadConsistency_value)
	proto.RegisterEnum("datastore.BeginTransactionRequest_IsolationLevel", BeginTransactionRequest_IsolationLevel_name, BeginTransactionRequest_IsolationLevel_value)
	proto.RegisterEnum("datastore.CommitRequest_Mode", CommitRequest_Mode_name, CommitRequest_Mode_value)
}
