// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteVoiceTemplateInput struct {
	_ struct{} `type:"structure"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVoiceTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteVoiceTemplateInput"}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteVoiceTemplateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "template-name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteVoiceTemplateOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// Provides information about an API request or response.
	//
	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteVoiceTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteVoiceTemplateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.MessageBody != nil {
		v := s.MessageBody

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "MessageBody", v, metadata)
	}
	return nil
}

const opDeleteVoiceTemplate = "DeleteVoiceTemplate"

// DeleteVoiceTemplateRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Deletes a message template that was designed for use in messages that were
// sent through the voice channel.
//
//    // Example sending a request using DeleteVoiceTemplateRequest.
//    req := client.DeleteVoiceTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceTemplate
func (c *Client) DeleteVoiceTemplateRequest(input *DeleteVoiceTemplateInput) DeleteVoiceTemplateRequest {
	op := &aws.Operation{
		Name:       opDeleteVoiceTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/templates/{template-name}/voice",
	}

	if input == nil {
		input = &DeleteVoiceTemplateInput{}
	}

	req := c.newRequest(op, input, &DeleteVoiceTemplateOutput{})
	return DeleteVoiceTemplateRequest{Request: req, Input: input, Copy: c.DeleteVoiceTemplateRequest}
}

// DeleteVoiceTemplateRequest is the request type for the
// DeleteVoiceTemplate API operation.
type DeleteVoiceTemplateRequest struct {
	*aws.Request
	Input *DeleteVoiceTemplateInput
	Copy  func(*DeleteVoiceTemplateInput) DeleteVoiceTemplateRequest
}

// Send marshals and sends the DeleteVoiceTemplate API request.
func (r DeleteVoiceTemplateRequest) Send(ctx context.Context) (*DeleteVoiceTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteVoiceTemplateResponse{
		DeleteVoiceTemplateOutput: r.Request.Data.(*DeleteVoiceTemplateOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteVoiceTemplateResponse is the response type for the
// DeleteVoiceTemplate API operation.
type DeleteVoiceTemplateResponse struct {
	*DeleteVoiceTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteVoiceTemplate request.
func (r *DeleteVoiceTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
