import * as React from 'react';
import { useFormikContext, FormikValues } from 'formik';
import { useTranslation } from 'react-i18next';
import { RadioGroupField } from '@console/shared';
import FormSection from '../section/FormSection';
import { imageRegistryType } from '../../../utils/imagestream-utils';
import ImageStream from './ImageStream';
import ImageSearch from './ImageSearch';

const ImageSearchSection: React.FC = () => {
  const { t } = useTranslation();
  const { values, setFieldValue, initialValues } = useFormikContext<FormikValues>();
  const [registry, setRegistry] = React.useState(values.registry);
  React.useEffect(() => {
    if (values.registry !== registry) {
      setRegistry(values.registry);
      setFieldValue('searchTerm', initialValues.searchTerm);
      setFieldValue('isi', initialValues.isi);
      setFieldValue('imageStream', initialValues.imageStream);
    }
  }, [
    initialValues.imageStream,
    initialValues.isi,
    initialValues.searchTerm,
    registry,
    setFieldValue,
    values,
  ]);

  return (
    <FormSection
      title={t('devconsole~Image')}
      subTitle={t('devconsole~Deploy an existing Image from an Image Stream or Image registry.')}
    >
      <RadioGroupField
        name="registry"
        options={[
          {
            label: imageRegistryType(t).External.label,
            value: imageRegistryType(t).External.value,
            isDisabled: values.formType === 'edit' && values.registry === 'internal',
            activeChildren: <ImageSearch />,
          },
          {
            label: imageRegistryType(t).Internal.label,
            value: imageRegistryType(t).Internal.value,
            isDisabled: values.formType === 'edit' && values.registry === 'external',
            activeChildren: <ImageStream />,
          },
        ]}
      />
    </FormSection>
  );
};

export default ImageSearchSection;
