package servermanagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AutoUpgrade enumerates the values for auto upgrade.
type AutoUpgrade string

const (
	// Off ...
	Off AutoUpgrade = "Off"
	// On ...
	On AutoUpgrade = "On"
)

// PossibleAutoUpgradeValues returns an array of possible values for the AutoUpgrade const type.
func PossibleAutoUpgradeValues() []AutoUpgrade {
	return []AutoUpgrade{Off, On}
}

// GatewayExpandOption enumerates the values for gateway expand option.
type GatewayExpandOption string

const (
	// Status ...
	Status GatewayExpandOption = "status"
)

// PossibleGatewayExpandOptionValues returns an array of possible values for the GatewayExpandOption const type.
func PossibleGatewayExpandOptionValues() []GatewayExpandOption {
	return []GatewayExpandOption{Status}
}

// PowerShellExpandOption enumerates the values for power shell expand option.
type PowerShellExpandOption string

const (
	// Output ...
	Output PowerShellExpandOption = "output"
)

// PossiblePowerShellExpandOptionValues returns an array of possible values for the PowerShellExpandOption const type.
func PossiblePowerShellExpandOptionValues() []PowerShellExpandOption {
	return []PowerShellExpandOption{Output}
}

// PromptFieldType enumerates the values for prompt field type.
type PromptFieldType string

const (
	// Credential ...
	Credential PromptFieldType = "Credential"
	// SecureString ...
	SecureString PromptFieldType = "SecureString"
	// String ...
	String PromptFieldType = "String"
)

// PossiblePromptFieldTypeValues returns an array of possible values for the PromptFieldType const type.
func PossiblePromptFieldTypeValues() []PromptFieldType {
	return []PromptFieldType{Credential, SecureString, String}
}

// Error error message.
type Error struct {
	Code    *int32  `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
	Fields  *string `json:"fields,omitempty"`
}

// GatewayCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type GatewayCreateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future GatewayCreateFuture) Result(client GatewayClient) (gr GatewayResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.GatewayCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return gr, azure.NewAsyncOpIncompleteError("servermanagement.GatewayCreateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		gr, err = client.CreateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "servermanagement.GatewayCreateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.GatewayCreateFuture", "Result", resp, "Failure sending request")
		return
	}
	gr, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.GatewayCreateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// GatewayGetProfileFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type GatewayGetProfileFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future GatewayGetProfileFuture) Result(client GatewayClient) (gp GatewayProfile, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.GatewayGetProfileFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return gp, azure.NewAsyncOpIncompleteError("servermanagement.GatewayGetProfileFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		gp, err = client.GetProfileResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "servermanagement.GatewayGetProfileFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.GatewayGetProfileFuture", "Result", resp, "Failure sending request")
		return
	}
	gp, err = client.GetProfileResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.GatewayGetProfileFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// GatewayParameters ...
type GatewayParameters struct {
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags                         interface{} `json:"tags,omitempty"`
	*GatewayParametersProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for GatewayParameters.
func (gp GatewayParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gp.Location != nil {
		objectMap["location"] = gp.Location
	}
	objectMap["tags"] = gp.Tags
	if gp.GatewayParametersProperties != nil {
		objectMap["properties"] = gp.GatewayParametersProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GatewayParameters struct.
func (gp *GatewayParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gp.Tags = tags
			}
		case "properties":
			if v != nil {
				var gatewayParametersProperties GatewayParametersProperties
				err = json.Unmarshal(*v, &gatewayParametersProperties)
				if err != nil {
					return err
				}
				gp.GatewayParametersProperties = &gatewayParametersProperties
			}
		}
	}

	return nil
}

// GatewayParametersProperties ...
type GatewayParametersProperties struct {
	// AutoUpgrade - The autoUpgrade property gives the flexibility to gateway to auto upgrade itself. If properties value not specified, then we assume autoUpgrade = Off. Possible values include: 'On', 'Off'
	AutoUpgrade AutoUpgrade `json:"autoUpgrade,omitempty"`
}

// GatewayProfile JSON properties that the gateway service uses know how to communicate with the resource.
type GatewayProfile struct {
	autorest.Response `json:"-"`
	// DataPlaneServiceBaseAddress - The Dataplane connection URL.
	DataPlaneServiceBaseAddress *string `json:"dataPlaneServiceBaseAddress,omitempty"`
	// GatewayID - The ID of the gateway.
	GatewayID *string `json:"gatewayId,omitempty"`
	// Environment - The environment for the gateway (DEV, DogFood, or Production).
	Environment *string `json:"environment,omitempty"`
	// UpgradeManifestURL - Gateway upgrade manifest URL.
	UpgradeManifestURL *string `json:"upgradeManifestUrl,omitempty"`
	// MessagingNamespace - Messaging namespace.
	MessagingNamespace *string `json:"messagingNamespace,omitempty"`
	// MessagingAccount - Messaging Account.
	MessagingAccount *string `json:"messagingAccount,omitempty"`
	// MessagingKey - Messaging Key.
	MessagingKey *string `json:"messagingKey,omitempty"`
	// RequestQueue - Request queue name.
	RequestQueue *string `json:"requestQueue,omitempty"`
	// ResponseTopic - Response topic name.
	ResponseTopic *string `json:"responseTopic,omitempty"`
	// StatusBlobSignature - The gateway status blob SAS URL.
	StatusBlobSignature *string `json:"statusBlobSignature,omitempty"`
}

// GatewayRegenerateProfileFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GatewayRegenerateProfileFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future GatewayRegenerateProfileFuture) Result(client GatewayClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.GatewayRegenerateProfileFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("servermanagement.GatewayRegenerateProfileFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.RegenerateProfileResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "servermanagement.GatewayRegenerateProfileFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.GatewayRegenerateProfileFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.RegenerateProfileResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.GatewayRegenerateProfileFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// GatewayResource ...
type GatewayResource struct {
	autorest.Response          `json:"-"`
	*GatewayResourceProperties `json:"properties,omitempty"`
	// ID - Resource Manager Resource ID.
	ID *string `json:"id,omitempty"`
	// Type - Resource Manager Resource Type.
	Type *string `json:"type,omitempty"`
	// Name - Resource Manager Resource Name.
	Name *string `json:"name,omitempty"`
	// Location - Resource Manager Resource Location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource Manager Resource Tags.
	Tags map[string]*string `json:"tags"`
	Etag *string            `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for GatewayResource.
func (gr GatewayResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gr.GatewayResourceProperties != nil {
		objectMap["properties"] = gr.GatewayResourceProperties
	}
	if gr.ID != nil {
		objectMap["id"] = gr.ID
	}
	if gr.Type != nil {
		objectMap["type"] = gr.Type
	}
	if gr.Name != nil {
		objectMap["name"] = gr.Name
	}
	if gr.Location != nil {
		objectMap["location"] = gr.Location
	}
	if gr.Tags != nil {
		objectMap["tags"] = gr.Tags
	}
	if gr.Etag != nil {
		objectMap["etag"] = gr.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GatewayResource struct.
func (gr *GatewayResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gatewayResourceProperties GatewayResourceProperties
				err = json.Unmarshal(*v, &gatewayResourceProperties)
				if err != nil {
					return err
				}
				gr.GatewayResourceProperties = &gatewayResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gr.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gr.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gr.Tags = tags
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				gr.Etag = &etag
			}
		}
	}

	return nil
}

// GatewayResourceProperties ...
type GatewayResourceProperties struct {
	// Created - UTC date and time when gateway was first added to management service.
	Created *date.Time `json:"created,omitempty"`
	// Updated - UTC date and time when node was last updated.
	Updated *date.Time `json:"updated,omitempty"`
	// AutoUpgrade - Setting of the autoupgrade. Possible values include: 'On', 'Off'
	AutoUpgrade AutoUpgrade `json:"autoUpgrade,omitempty"`
	// DesiredVersion - Latest available MSI version.
	DesiredVersion *string `json:"desiredVersion,omitempty"`
	// Instances - Names of the nodes in the gateway.
	Instances *[]GatewayStatus `json:"instances,omitempty"`
	// ActiveMessageCount - number of active messages
	ActiveMessageCount *int32 `json:"activeMessageCount,omitempty"`
	// LatestPublishedMsiVersion - Last published MSI version.
	LatestPublishedMsiVersion *string `json:"latestPublishedMsiVersion,omitempty"`
	// PublishedTimeUtc - The date/time of the last published gateway.
	PublishedTimeUtc *date.Time `json:"publishedTimeUtc,omitempty"`
}

// GatewayResources collection of Gateway Resources.
type GatewayResources struct {
	autorest.Response `json:"-"`
	// Value - Collection of Gateway Resources.
	Value *[]GatewayResource `json:"value,omitempty"`
	// NextLink - The URL to the next set of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// GatewayResourcesIterator provides access to a complete listing of GatewayResource values.
type GatewayResourcesIterator struct {
	i    int
	page GatewayResourcesPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GatewayResourcesIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GatewayResourcesIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GatewayResourcesIterator) Response() GatewayResources {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GatewayResourcesIterator) Value() GatewayResource {
	if !iter.page.NotDone() {
		return GatewayResource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (gr GatewayResources) IsEmpty() bool {
	return gr.Value == nil || len(*gr.Value) == 0
}

// gatewayResourcesPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (gr GatewayResources) gatewayResourcesPreparer() (*http.Request, error) {
	if gr.NextLink == nil || len(to.String(gr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(gr.NextLink)))
}

// GatewayResourcesPage contains a page of GatewayResource values.
type GatewayResourcesPage struct {
	fn func(GatewayResources) (GatewayResources, error)
	gr GatewayResources
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GatewayResourcesPage) Next() error {
	next, err := page.fn(page.gr)
	if err != nil {
		return err
	}
	page.gr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GatewayResourcesPage) NotDone() bool {
	return !page.gr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GatewayResourcesPage) Response() GatewayResources {
	return page.gr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GatewayResourcesPage) Values() []GatewayResource {
	if page.gr.IsEmpty() {
		return nil
	}
	return *page.gr.Value
}

// GatewayStatus expanded gateway status information.
type GatewayStatus struct {
	// AvailableMemoryMByte - The available memory on the gateway host machine in megabytes.
	AvailableMemoryMByte *float64 `json:"availableMemoryMByte,omitempty"`
	// GatewayCPUUtilizationPercent - The CPU utilization of the gateway process (numeric value between 0 and 100).
	GatewayCPUUtilizationPercent *float64 `json:"gatewayCpuUtilizationPercent,omitempty"`
	// TotalCPUUtilizationPercent - CPU Utilization of the whole system.
	TotalCPUUtilizationPercent *float64 `json:"totalCpuUtilizationPercent,omitempty"`
	// GatewayVersion - The version of the gateway that is installed on the system.
	GatewayVersion *string `json:"gatewayVersion,omitempty"`
	// FriendlyOsName - The Plaintext description of the OS on the gateway.
	FriendlyOsName *string `json:"friendlyOsName,omitempty"`
	// InstalledDate - The date the gateway was installed.
	InstalledDate *date.Time `json:"installedDate,omitempty"`
	// LogicalProcessorCount - Number of logical processors in the gateway system.
	LogicalProcessorCount *int32 `json:"logicalProcessorCount,omitempty"`
	// Name - The computer name of the gateway system.
	Name *string `json:"name,omitempty"`
	// GatewayID - The gateway resource ID.
	GatewayID *string `json:"gatewayId,omitempty"`
	// GatewayWorkingSetMByte - The working set size of the gateway process in megabytes.
	GatewayWorkingSetMByte *float64 `json:"gatewayWorkingSetMByte,omitempty"`
	// StatusUpdated - UTC date and time when gateway status was last updated.
	StatusUpdated *date.Time `json:"statusUpdated,omitempty"`
}

// GatewayUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type GatewayUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future GatewayUpdateFuture) Result(client GatewayClient) (gr GatewayResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.GatewayUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return gr, azure.NewAsyncOpIncompleteError("servermanagement.GatewayUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		gr, err = client.UpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "servermanagement.GatewayUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.GatewayUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	gr, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.GatewayUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// GatewayUpgradeFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type GatewayUpgradeFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future GatewayUpgradeFuture) Result(client GatewayClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.GatewayUpgradeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("servermanagement.GatewayUpgradeFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.UpgradeResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "servermanagement.GatewayUpgradeFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.GatewayUpgradeFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.UpgradeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.GatewayUpgradeFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// NodeCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type NodeCreateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future NodeCreateFuture) Result(client NodeClient) (nr NodeResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.NodeCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return nr, azure.NewAsyncOpIncompleteError("servermanagement.NodeCreateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		nr, err = client.CreateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "servermanagement.NodeCreateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.NodeCreateFuture", "Result", resp, "Failure sending request")
		return
	}
	nr, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.NodeCreateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// NodeParameters ...
type NodeParameters struct {
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags                      interface{} `json:"tags,omitempty"`
	*NodeParametersProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for NodeParameters.
func (np NodeParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if np.Location != nil {
		objectMap["location"] = np.Location
	}
	objectMap["tags"] = np.Tags
	if np.NodeParametersProperties != nil {
		objectMap["properties"] = np.NodeParametersProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NodeParameters struct.
func (np *NodeParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				np.Location = &location
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				np.Tags = tags
			}
		case "properties":
			if v != nil {
				var nodeParametersProperties NodeParametersProperties
				err = json.Unmarshal(*v, &nodeParametersProperties)
				if err != nil {
					return err
				}
				np.NodeParametersProperties = &nodeParametersProperties
			}
		}
	}

	return nil
}

// NodeParametersProperties ...
type NodeParametersProperties struct {
	// GatewayID - Gateway ID which will manage this node.
	GatewayID *string `json:"gatewayId,omitempty"`
	// ConnectionName - myhost.domain.com
	ConnectionName *string `json:"connectionName,omitempty"`
	// UserName - User name to be used to connect to node.
	UserName *string `json:"userName,omitempty"`
	// Password - Password associated with user name.
	Password *string `json:"password,omitempty"`
}

// NodeResource a Node Resource.
type NodeResource struct {
	autorest.Response       `json:"-"`
	*NodeResourceProperties `json:"properties,omitempty"`
	// ID - Resource Manager Resource ID.
	ID *string `json:"id,omitempty"`
	// Type - Resource Manager Resource Type.
	Type *string `json:"type,omitempty"`
	// Name - Resource Manager Resource Name.
	Name *string `json:"name,omitempty"`
	// Location - Resource Manager Resource Location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource Manager Resource Tags.
	Tags map[string]*string `json:"tags"`
	Etag *string            `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for NodeResource.
func (nr NodeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nr.NodeResourceProperties != nil {
		objectMap["properties"] = nr.NodeResourceProperties
	}
	if nr.ID != nil {
		objectMap["id"] = nr.ID
	}
	if nr.Type != nil {
		objectMap["type"] = nr.Type
	}
	if nr.Name != nil {
		objectMap["name"] = nr.Name
	}
	if nr.Location != nil {
		objectMap["location"] = nr.Location
	}
	if nr.Tags != nil {
		objectMap["tags"] = nr.Tags
	}
	if nr.Etag != nil {
		objectMap["etag"] = nr.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NodeResource struct.
func (nr *NodeResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var nodeResourceProperties NodeResourceProperties
				err = json.Unmarshal(*v, &nodeResourceProperties)
				if err != nil {
					return err
				}
				nr.NodeResourceProperties = &nodeResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nr.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nr.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				nr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				nr.Tags = tags
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				nr.Etag = &etag
			}
		}
	}

	return nil
}

// NodeResourceProperties ...
type NodeResourceProperties struct {
	// GatewayID - ID of the gateway.
	GatewayID *string `json:"gatewayId,omitempty"`
	// ConnectionName - myhost.domain.com
	ConnectionName *string `json:"connectionName,omitempty"`
	// Created - UTC date and time when node was first added to management service.
	Created *date.Time `json:"created,omitempty"`
	// Updated - UTC date and time when node was last updated.
	Updated *date.Time `json:"updated,omitempty"`
}

// NodeResources a collection of node resource objects.
type NodeResources struct {
	autorest.Response `json:"-"`
	// Value - Collection of Node Resources.
	Value *[]NodeResource `json:"value,omitempty"`
	// NextLink - The URL to the next set of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// NodeResourcesIterator provides access to a complete listing of NodeResource values.
type NodeResourcesIterator struct {
	i    int
	page NodeResourcesPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NodeResourcesIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NodeResourcesIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NodeResourcesIterator) Response() NodeResources {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NodeResourcesIterator) Value() NodeResource {
	if !iter.page.NotDone() {
		return NodeResource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (nr NodeResources) IsEmpty() bool {
	return nr.Value == nil || len(*nr.Value) == 0
}

// nodeResourcesPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nr NodeResources) nodeResourcesPreparer() (*http.Request, error) {
	if nr.NextLink == nil || len(to.String(nr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nr.NextLink)))
}

// NodeResourcesPage contains a page of NodeResource values.
type NodeResourcesPage struct {
	fn func(NodeResources) (NodeResources, error)
	nr NodeResources
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NodeResourcesPage) Next() error {
	next, err := page.fn(page.nr)
	if err != nil {
		return err
	}
	page.nr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NodeResourcesPage) NotDone() bool {
	return !page.nr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NodeResourcesPage) Response() NodeResources {
	return page.nr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NodeResourcesPage) Values() []NodeResource {
	if page.nr.IsEmpty() {
		return nil
	}
	return *page.nr.Value
}

// NodeUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type NodeUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future NodeUpdateFuture) Result(client NodeClient) (nr NodeResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.NodeUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return nr, azure.NewAsyncOpIncompleteError("servermanagement.NodeUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		nr, err = client.UpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "servermanagement.NodeUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.NodeUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	nr, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.NodeUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// PowerShellCancelCommandFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PowerShellCancelCommandFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future PowerShellCancelCommandFuture) Result(client PowerShellClient) (pscr PowerShellCommandResults, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.PowerShellCancelCommandFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return pscr, azure.NewAsyncOpIncompleteError("servermanagement.PowerShellCancelCommandFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		pscr, err = client.CancelCommandResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "servermanagement.PowerShellCancelCommandFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.PowerShellCancelCommandFuture", "Result", resp, "Failure sending request")
		return
	}
	pscr, err = client.CancelCommandResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.PowerShellCancelCommandFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// PowerShellCommandParameters the parameters to a PowerShell script execution command.
type PowerShellCommandParameters struct {
	*PowerShellCommandParametersProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PowerShellCommandParameters.
func (pscp PowerShellCommandParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pscp.PowerShellCommandParametersProperties != nil {
		objectMap["properties"] = pscp.PowerShellCommandParametersProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PowerShellCommandParameters struct.
func (pscp *PowerShellCommandParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var powerShellCommandParametersProperties PowerShellCommandParametersProperties
				err = json.Unmarshal(*v, &powerShellCommandParametersProperties)
				if err != nil {
					return err
				}
				pscp.PowerShellCommandParametersProperties = &powerShellCommandParametersProperties
			}
		}
	}

	return nil
}

// PowerShellCommandParametersProperties ...
type PowerShellCommandParametersProperties struct {
	// Command - Script to execute.
	Command *string `json:"command,omitempty"`
}

// PowerShellCommandResult ...
type PowerShellCommandResult struct {
	// MessageType - The type of message.
	MessageType *int32 `json:"messageType,omitempty"`
	// ForegroundColor - The HTML color string representing the foreground color.
	ForegroundColor *string `json:"foregroundColor,omitempty"`
	// BackgroundColor - The HTML color string representing the background color.
	BackgroundColor *string `json:"backgroundColor,omitempty"`
	// Value - Actual result text from the PowerShell Command.
	Value *string `json:"value,omitempty"`
	// Prompt - The interactive prompt message.
	Prompt *string `json:"prompt,omitempty"`
	// ExitCode - The exit code from a executable that was called from PowerShell.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// ID - ID of the prompt message.
	ID *int32 `json:"id,omitempty"`
	// Caption - Text that precedes the prompt.
	Caption *string `json:"caption,omitempty"`
	// Message - Text of the prompt.
	Message *string `json:"message,omitempty"`
	// Descriptions - Collection of PromptFieldDescription objects that contains the user input
	Descriptions *[]PromptFieldDescription `json:"descriptions,omitempty"`
}

// PowerShellCommandResults a collection of results from a PowerShell command.
type PowerShellCommandResults struct {
	autorest.Response `json:"-"`
	Results           *[]PowerShellCommandResult `json:"results,omitempty"`
	Pssession         *string                    `json:"pssession,omitempty"`
	Command           *string                    `json:"command,omitempty"`
	Completed         *bool                      `json:"completed,omitempty"`
}

// PowerShellCommandStatus ...
type PowerShellCommandStatus struct {
	autorest.Response         `json:"-"`
	*PowerShellCommandResults `json:"properties,omitempty"`
	// ID - Resource Manager Resource ID.
	ID *string `json:"id,omitempty"`
	// Type - Resource Manager Resource Type.
	Type *string `json:"type,omitempty"`
	// Name - Resource Manager Resource Name.
	Name *string `json:"name,omitempty"`
	// Location - Resource Manager Resource Location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource Manager Resource Tags.
	Tags map[string]*string `json:"tags"`
	Etag *string            `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for PowerShellCommandStatus.
func (pscs PowerShellCommandStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pscs.PowerShellCommandResults != nil {
		objectMap["properties"] = pscs.PowerShellCommandResults
	}
	if pscs.ID != nil {
		objectMap["id"] = pscs.ID
	}
	if pscs.Type != nil {
		objectMap["type"] = pscs.Type
	}
	if pscs.Name != nil {
		objectMap["name"] = pscs.Name
	}
	if pscs.Location != nil {
		objectMap["location"] = pscs.Location
	}
	if pscs.Tags != nil {
		objectMap["tags"] = pscs.Tags
	}
	if pscs.Etag != nil {
		objectMap["etag"] = pscs.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PowerShellCommandStatus struct.
func (pscs *PowerShellCommandStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var powerShellCommandResults PowerShellCommandResults
				err = json.Unmarshal(*v, &powerShellCommandResults)
				if err != nil {
					return err
				}
				pscs.PowerShellCommandResults = &powerShellCommandResults
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pscs.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pscs.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pscs.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pscs.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pscs.Tags = tags
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pscs.Etag = &etag
			}
		}
	}

	return nil
}

// PowerShellCreateSessionFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PowerShellCreateSessionFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future PowerShellCreateSessionFuture) Result(client PowerShellClient) (pssr PowerShellSessionResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.PowerShellCreateSessionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return pssr, azure.NewAsyncOpIncompleteError("servermanagement.PowerShellCreateSessionFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		pssr, err = client.CreateSessionResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "servermanagement.PowerShellCreateSessionFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.PowerShellCreateSessionFuture", "Result", resp, "Failure sending request")
		return
	}
	pssr, err = client.CreateSessionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.PowerShellCreateSessionFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// PowerShellInvokeCommandFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PowerShellInvokeCommandFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future PowerShellInvokeCommandFuture) Result(client PowerShellClient) (pscr PowerShellCommandResults, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.PowerShellInvokeCommandFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return pscr, azure.NewAsyncOpIncompleteError("servermanagement.PowerShellInvokeCommandFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		pscr, err = client.InvokeCommandResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "servermanagement.PowerShellInvokeCommandFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.PowerShellInvokeCommandFuture", "Result", resp, "Failure sending request")
		return
	}
	pscr, err = client.InvokeCommandResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.PowerShellInvokeCommandFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// PowerShellSessionResource a PowerShell session resource (practically equivalent to a runspace instance).
type PowerShellSessionResource struct {
	autorest.Response                    `json:"-"`
	*PowerShellSessionResourceProperties `json:"properties,omitempty"`
	// ID - Resource Manager Resource ID.
	ID *string `json:"id,omitempty"`
	// Type - Resource Manager Resource Type.
	Type *string `json:"type,omitempty"`
	// Name - Resource Manager Resource Name.
	Name *string `json:"name,omitempty"`
	// Location - Resource Manager Resource Location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource Manager Resource Tags.
	Tags map[string]*string `json:"tags"`
	Etag *string            `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for PowerShellSessionResource.
func (pssr PowerShellSessionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pssr.PowerShellSessionResourceProperties != nil {
		objectMap["properties"] = pssr.PowerShellSessionResourceProperties
	}
	if pssr.ID != nil {
		objectMap["id"] = pssr.ID
	}
	if pssr.Type != nil {
		objectMap["type"] = pssr.Type
	}
	if pssr.Name != nil {
		objectMap["name"] = pssr.Name
	}
	if pssr.Location != nil {
		objectMap["location"] = pssr.Location
	}
	if pssr.Tags != nil {
		objectMap["tags"] = pssr.Tags
	}
	if pssr.Etag != nil {
		objectMap["etag"] = pssr.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PowerShellSessionResource struct.
func (pssr *PowerShellSessionResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var powerShellSessionResourceProperties PowerShellSessionResourceProperties
				err = json.Unmarshal(*v, &powerShellSessionResourceProperties)
				if err != nil {
					return err
				}
				pssr.PowerShellSessionResourceProperties = &powerShellSessionResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pssr.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pssr.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pssr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pssr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pssr.Tags = tags
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pssr.Etag = &etag
			}
		}
	}

	return nil
}

// PowerShellSessionResourceProperties ...
type PowerShellSessionResourceProperties struct {
	// SessionID - The PowerShell Session ID.
	SessionID *string `json:"sessionId,omitempty"`
	// State - The runspace state.
	State *string `json:"state,omitempty"`
	// RunspaceAvailability - The availability of the runspace.
	RunspaceAvailability *string `json:"runspaceAvailability,omitempty"`
	// DisconnectedOn - Timestamp of last time the service disconnected from the runspace.
	DisconnectedOn *date.Time `json:"disconnectedOn,omitempty"`
	// ExpiresOn - Timestamp when the runspace expires.
	ExpiresOn *date.Time               `json:"expiresOn,omitempty"`
	Version   *VersionServermanagement `json:"version,omitempty"`
	// Name - Name of the runspace.
	Name *string `json:"name,omitempty"`
}

// PowerShellSessionResources a collection of PowerShell session resources.
type PowerShellSessionResources struct {
	autorest.Response `json:"-"`
	// Value - Collection of PowerShell session resources.
	Value *[]PowerShellSessionResource `json:"value,omitempty"`
	// NextLink - The URL to the next set of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// PowerShellTabCompletionParameters ...
type PowerShellTabCompletionParameters struct {
	// Command - Command to get tab completion for.
	Command *string `json:"command,omitempty"`
}

// PowerShellTabCompletionResults an array of strings representing the different values that can be selected
// through.
type PowerShellTabCompletionResults struct {
	autorest.Response `json:"-"`
	Results           *[]string `json:"results,omitempty"`
}

// PowerShellUpdateCommandFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PowerShellUpdateCommandFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future PowerShellUpdateCommandFuture) Result(client PowerShellClient) (pscr PowerShellCommandResults, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.PowerShellUpdateCommandFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return pscr, azure.NewAsyncOpIncompleteError("servermanagement.PowerShellUpdateCommandFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		pscr, err = client.UpdateCommandResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "servermanagement.PowerShellUpdateCommandFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.PowerShellUpdateCommandFuture", "Result", resp, "Failure sending request")
		return
	}
	pscr, err = client.UpdateCommandResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.PowerShellUpdateCommandFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// PromptFieldDescription field description for the implementation of PSHostUserInterface.Prompt.
type PromptFieldDescription struct {
	// Name - The name of the prompt.
	Name *string `json:"name,omitempty"`
	// Label - The label text of the prompt.
	Label *string `json:"label,omitempty"`
	// HelpMessage - The help message of the prompt.
	HelpMessage *string `json:"helpMessage,omitempty"`
	// PromptFieldTypeIsList - When set to 'true' the prompt field type is a list of values.
	PromptFieldTypeIsList *bool `json:"promptFieldTypeIsList,omitempty"`
	// PromptFieldType - Possible values include: 'String', 'SecureString', 'Credential'
	PromptFieldType PromptFieldType `json:"promptFieldType,omitempty"`
}

// PromptMessageResponse the response to a prompt message.
type PromptMessageResponse struct {
	// Response - The list of responses a cmdlet expects.
	Response *[]string `json:"response,omitempty"`
}

// Resource resource Manager Resource Information.
type Resource struct {
	// ID - Resource Manager Resource ID.
	ID *string `json:"id,omitempty"`
	// Type - Resource Manager Resource Type.
	Type *string `json:"type,omitempty"`
	// Name - Resource Manager Resource Name.
	Name *string `json:"name,omitempty"`
	// Location - Resource Manager Resource Location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource Manager Resource Tags.
	Tags map[string]*string `json:"tags"`
	Etag *string            `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.Etag != nil {
		objectMap["etag"] = r.Etag
	}
	return json.Marshal(objectMap)
}

// SessionCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SessionCreateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future SessionCreateFuture) Result(client SessionClient) (sr SessionResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.SessionCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return sr, azure.NewAsyncOpIncompleteError("servermanagement.SessionCreateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		sr, err = client.CreateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "servermanagement.SessionCreateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.SessionCreateFuture", "Result", resp, "Failure sending request")
		return
	}
	sr, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servermanagement.SessionCreateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// SessionParameters ...
type SessionParameters struct {
	*SessionParametersProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SessionParameters.
func (sp SessionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.SessionParametersProperties != nil {
		objectMap["properties"] = sp.SessionParametersProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SessionParameters struct.
func (sp *SessionParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sessionParametersProperties SessionParametersProperties
				err = json.Unmarshal(*v, &sessionParametersProperties)
				if err != nil {
					return err
				}
				sp.SessionParametersProperties = &sessionParametersProperties
			}
		}
	}

	return nil
}

// SessionParametersProperties ...
type SessionParametersProperties struct {
	// UserName - User name to be used to connect to node.
	UserName *string `json:"userName,omitempty"`
	// Password - Password associated with user name.
	Password *string `json:"password,omitempty"`
}

// SessionResource the session object.
type SessionResource struct {
	autorest.Response          `json:"-"`
	*SessionResourceProperties `json:"properties,omitempty"`
	// ID - Resource Manager Resource ID.
	ID *string `json:"id,omitempty"`
	// Type - Resource Manager Resource Type.
	Type *string `json:"type,omitempty"`
	// Name - Resource Manager Resource Name.
	Name *string `json:"name,omitempty"`
	// Location - Resource Manager Resource Location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource Manager Resource Tags.
	Tags map[string]*string `json:"tags"`
	Etag *string            `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for SessionResource.
func (sr SessionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.SessionResourceProperties != nil {
		objectMap["properties"] = sr.SessionResourceProperties
	}
	if sr.ID != nil {
		objectMap["id"] = sr.ID
	}
	if sr.Type != nil {
		objectMap["type"] = sr.Type
	}
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	if sr.Location != nil {
		objectMap["location"] = sr.Location
	}
	if sr.Tags != nil {
		objectMap["tags"] = sr.Tags
	}
	if sr.Etag != nil {
		objectMap["etag"] = sr.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SessionResource struct.
func (sr *SessionResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sessionResourceProperties SessionResourceProperties
				err = json.Unmarshal(*v, &sessionResourceProperties)
				if err != nil {
					return err
				}
				sr.SessionResourceProperties = &sessionResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sr.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sr.Tags = tags
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sr.Etag = &etag
			}
		}
	}

	return nil
}

// SessionResourceProperties ...
type SessionResourceProperties struct {
	// UserName - The username connecting to the session.
	UserName *string `json:"userName,omitempty"`
	// Created - UTC date and time when node was first added to management service.
	Created *date.Time `json:"created,omitempty"`
	// Updated - UTC date and time when node was last updated.
	Updated *date.Time `json:"updated,omitempty"`
}

// VersionServermanagement a multipart-numeric version number.
type VersionServermanagement struct {
	// Major - The leftmost number of the version.
	Major *int32 `json:"major,omitempty"`
	// Minor - The second leftmost number of the version.
	Minor *int32 `json:"minor,omitempty"`
	// Build - The third number of the version.
	Build *int32 `json:"build,omitempty"`
	// Revision - The fourth number of the version.
	Revision *int32 `json:"revision,omitempty"`
	// MajorRevision - The MSW of the fourth part.
	MajorRevision *int32 `json:"majorRevision,omitempty"`
	// MinorRevision - The LSW of the fourth part.
	MinorRevision *int32 `json:"minorRevision,omitempty"`
}
