import * as React from 'react';
import { SecurityIcon } from '@patternfly/react-icons';
import { shallow, ShallowWrapper } from 'enzyme';
import { TableData } from '@console/internal/components/factory';
import { ExternalLink } from '@console/internal/components/utils';
import { fakeVulnFor } from '../../../integration-tests/bad-pods';
import { Priority, vulnPriority } from '../../const';
import ImageVulnerabilityRow from '../ImageVulnerabilityRow';

describe('ImageVulnerabilityRow', () => {
  type ImageVulnerabilityRowProps = React.ComponentProps<typeof ImageVulnerabilityRow>;
  let wrapper: ShallowWrapper<ImageVulnerabilityRowProps>;
  const vuln = fakeVulnFor(Priority.Critical);
  const props: ImageVulnerabilityRowProps = {
    obj: {
      feature: vuln.spec.features[0],
      vulnerability: vuln.spec.features[0].vulnerabilities[0],
    },
    columns: [],
  };

  it('renders a `SecurityIcon` with the correct color for the severity', () => {
    wrapper = shallow(<ImageVulnerabilityRow {...props} />);
    expect(wrapper.find(SecurityIcon).props().color).toEqual(
      vulnPriority.get(Priority.Critical).color.value,
    );
  });

  it('should render 7 column', () => {
    wrapper = shallow(<ImageVulnerabilityRow {...props} />);
    expect(wrapper.find(TableData)).toHaveLength(5);
  });
  it('should render Vulnerability column', () => {
    wrapper = shallow(<ImageVulnerabilityRow {...props} />);
    const vulnerabilityColumn = wrapper.find(TableData).at(0);
    expect(vulnerabilityColumn.find(ExternalLink).props().text).toBe('RHSA-2019:1880');
    expect(vulnerabilityColumn.find(ExternalLink).props().href).toBe(
      'https://access.redhat.com/errata/RHSA-2019:1880',
    );
  });
  it('should render Package column', () => {
    wrapper = shallow(<ImageVulnerabilityRow {...props} />);
    const vulnerabilityColumn = wrapper.find(TableData).at(2);
    expect(vulnerabilityColumn.props().children).toBe('libcurl');
  });
  it('should render Current Version column', () => {
    wrapper = shallow(<ImageVulnerabilityRow {...props} />);
    const vulnerabilityColumn = wrapper.find(TableData).at(3);
    expect(vulnerabilityColumn.props().children).toBe('7.29.0-51.el7');
  });
  it('should render Fixed in Version column', () => {
    wrapper = shallow(<ImageVulnerabilityRow {...props} />);
    const vulnerabilityColumn = wrapper.find(TableData).at(4);
    expect(vulnerabilityColumn.props().children).toBe('0:7.29.0-51.el7_6.3');
  });
});
