// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetExternalModelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The Amazon SageMaker model endpoint.
	ModelEndpoint *string `locationName:"modelEndpoint" type:"string"`

	// The next page token for the request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetExternalModelsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExternalModelsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetExternalModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetExternalModelsOutput struct {
	_ struct{} `type:"structure"`

	// Gets the Amazon SageMaker models.
	ExternalModels []ExternalModel `locationName:"externalModels" type:"list"`

	// The next page token to be used in subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetExternalModelsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetExternalModels = "GetExternalModels"

// GetExternalModelsRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Gets the details for one or more Amazon SageMaker models that have been imported
// into the service. This is a paginated API. If you provide a null maxSizePerPage,
// this actions retrieves a maximum of 10 records per page. If you provide a
// maxSizePerPage, the value must be between 5 and 10. To get the next page
// results, provide the pagination token from the GetExternalModelsResult as
// part of your request. A null pagination token fetches the records from the
// beginning.
//
//    // Example sending a request using GetExternalModelsRequest.
//    req := client.GetExternalModelsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels
func (c *Client) GetExternalModelsRequest(input *GetExternalModelsInput) GetExternalModelsRequest {
	op := &aws.Operation{
		Name:       opGetExternalModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetExternalModelsInput{}
	}

	req := c.newRequest(op, input, &GetExternalModelsOutput{})
	return GetExternalModelsRequest{Request: req, Input: input, Copy: c.GetExternalModelsRequest}
}

// GetExternalModelsRequest is the request type for the
// GetExternalModels API operation.
type GetExternalModelsRequest struct {
	*aws.Request
	Input *GetExternalModelsInput
	Copy  func(*GetExternalModelsInput) GetExternalModelsRequest
}

// Send marshals and sends the GetExternalModels API request.
func (r GetExternalModelsRequest) Send(ctx context.Context) (*GetExternalModelsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetExternalModelsResponse{
		GetExternalModelsOutput: r.Request.Data.(*GetExternalModelsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetExternalModelsRequestPaginator returns a paginator for GetExternalModels.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetExternalModelsRequest(input)
//   p := frauddetector.NewGetExternalModelsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetExternalModelsPaginator(req GetExternalModelsRequest) GetExternalModelsPaginator {
	return GetExternalModelsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetExternalModelsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetExternalModelsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetExternalModelsPaginator struct {
	aws.Pager
}

func (p *GetExternalModelsPaginator) CurrentPage() *GetExternalModelsOutput {
	return p.Pager.CurrentPage().(*GetExternalModelsOutput)
}

// GetExternalModelsResponse is the response type for the
// GetExternalModels API operation.
type GetExternalModelsResponse struct {
	*GetExternalModelsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetExternalModels request.
func (r *GetExternalModelsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
