## v1.4.0

### Additions

- For Helm-based operators, added Liveness and Readiness probe by default using [`healthz.Ping`](https://pkg.go.dev/sigs.k8s.io/controller-runtime/pkg/healthz#CheckHandler). ([#4326](https://github.com/operator-framework/operator-sdk/pull/4326))
- For Ansible-based operators, added Liveness and Readiness probe by default using [`healthz.Ping`](https://pkg.go.dev/sigs.k8s.io/controller-runtime/pkg/healthz#CheckHandler). ([#4326](https://github.com/operator-framework/operator-sdk/pull/4326))
- For Ansible/Helm-based operators, added new flag `--health-probe-bind-address` to set the health probe address. ([#4326](https://github.com/operator-framework/operator-sdk/pull/4326))
- (ansible/v1, helm/v1) Added plugin objects for the `manifests` and `scorecard` phase 2 plugins. ([#4419](https://github.com/operator-framework/operator-sdk/pull/4419))
- For Ansible-based and Helm-based operators, as well as for the Operator SDK and the (custom) scorecard tests, the Docker base images are pinned to improve the reproducibility of builds using Docker. ([#4417](https://github.com/operator-framework/operator-sdk/pull/4417))

### Changes

- Changed the suggested finalizer format to `<qualified-group>/<finalizer-name>`. ([#4472](https://github.com/operator-framework/operator-sdk/pull/4472))
- Upgraded the `kudobuilder/kuttl` base image version in the `scorecard-test-kuttl` image to v0.8.0. ([#4391](https://github.com/operator-framework/operator-sdk/pull/4391))
- (go/v2) Changed `go` PROJECT plugin object to `manifests` and `scorecard` objects (`.sdk.operatorframework.io` suffix). ([#4419](https://github.com/operator-framework/operator-sdk/pull/4419))
- (ansible/v1, helm/v1) Post-fixed positional directory argument `.` in `docker-build` make target to align with `podman`. ([#4466](https://github.com/operator-framework/operator-sdk/pull/4466))
- For Ansible-based operators, the Python version has been updated to a newer version, from 3.6 to 3.8 to take advantage of performance improvements, language additions, security updates and generally better availability for local development. ([#4413](https://github.com/operator-framework/operator-sdk/pull/4413))

### Deprecations

- For Ansible-based operators, the `/ping` endpoint is deprecated. Use `/healthz` instead. ([#4326](https://github.com/operator-framework/operator-sdk/pull/4326))

### Bug Fixes

- Project version now determines how package name is retrieved for a project. ([#4431](https://github.com/operator-framework/operator-sdk/pull/4431))
- `run bundle-upgrade` now handles error gracefully when a previous operator version doesn't exist. ([#4451](https://github.com/operator-framework/operator-sdk/pull/4451))
- `run bundle` and `run bundle-upgrade` now validate the value passed to the hidden flag `--mode` before running a bundle. ([#4462](https://github.com/operator-framework/operator-sdk/pull/4462))
- For Go-based projects, `generate <bundle|packagemanifests>` subcommands now consider package and type names when parsing Go API types files to generate a CSV's `owned.customresourcedefinitions`, such that types in different packages and files will not overwrite each other. ([#4445](https://github.com/operator-framework/operator-sdk/pull/4445))
- Bumped operator-framework/api to prevent `operator-sdk bundle validate` from exiting non-0 when validation emits only warnings. ([#4458](https://github.com/operator-framework/operator-sdk/pull/4458))
- Fixed panic when "operator-sdk bundle validate" fails. ([#4386](https://github.com/operator-framework/operator-sdk/pull/4386))
- Update containerd dependency to correctly handle running the Operator SDK CLI on Apple Silicon. ([#4359](https://github.com/operator-framework/operator-sdk/pull/4359))
- Fixed invalid object names generated for long package names passed to `run packagemanifests` & `run bundle`. ([#4471](https://github.com/operator-framework/operator-sdk/pull/4471))
- Corrected the download URL for helm-operator and ansible-operator in their respective project types. ([#4407](https://github.com/operator-framework/operator-sdk/pull/4407))
- Fixed the order of helm-operator, ansible-operator, and kustomize binary checks in the Makefile. ([#4407](https://github.com/operator-framework/operator-sdk/pull/4407))
- Fixed a bug that caused the Helm operator to remove the finalizer without doing a helm uninstall. ([#3431](https://github.com/operator-framework/operator-sdk/pull/3431))
- For Helm-based operators, do not add owner references to resources that contain the Helm annotation: 'helm.sh/resource-policy: keep'. ([#4389](https://github.com/operator-framework/operator-sdk/pull/4389))
