package videoanalyzer

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/videoanalyzer/mgmt/2021-05-01-preview/videoanalyzer"

// AccessPolicyEntity policy that determines how a video can be accessed.
type AccessPolicyEntity struct {
	autorest.Response `json:"-"`
	// AccessPolicyProperties - The resource properties.
	*AccessPolicyProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AccessPolicyEntity.
func (ape AccessPolicyEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ape.AccessPolicyProperties != nil {
		objectMap["properties"] = ape.AccessPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccessPolicyEntity struct.
func (ape *AccessPolicyEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accessPolicyProperties AccessPolicyProperties
				err = json.Unmarshal(*v, &accessPolicyProperties)
				if err != nil {
					return err
				}
				ape.AccessPolicyProperties = &accessPolicyProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ape.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ape.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ape.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ape.Type = &typeVar
			}
		}
	}

	return nil
}

// AccessPolicyEntityCollection a collection of AccessPolicyEntity items.
type AccessPolicyEntityCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of AccessPolicyEntity items.
	Value *[]AccessPolicyEntity `json:"value,omitempty"`
	// NextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	NextLink *string `json:"@nextLink,omitempty"`
}

// AccessPolicyEntityCollectionIterator provides access to a complete listing of AccessPolicyEntity values.
type AccessPolicyEntityCollectionIterator struct {
	i    int
	page AccessPolicyEntityCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccessPolicyEntityCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccessPolicyEntityCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccessPolicyEntityCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccessPolicyEntityCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccessPolicyEntityCollectionIterator) Response() AccessPolicyEntityCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccessPolicyEntityCollectionIterator) Value() AccessPolicyEntity {
	if !iter.page.NotDone() {
		return AccessPolicyEntity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccessPolicyEntityCollectionIterator type.
func NewAccessPolicyEntityCollectionIterator(page AccessPolicyEntityCollectionPage) AccessPolicyEntityCollectionIterator {
	return AccessPolicyEntityCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (apec AccessPolicyEntityCollection) IsEmpty() bool {
	return apec.Value == nil || len(*apec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (apec AccessPolicyEntityCollection) hasNextLink() bool {
	return apec.NextLink != nil && len(*apec.NextLink) != 0
}

// accessPolicyEntityCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (apec AccessPolicyEntityCollection) accessPolicyEntityCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !apec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(apec.NextLink)))
}

// AccessPolicyEntityCollectionPage contains a page of AccessPolicyEntity values.
type AccessPolicyEntityCollectionPage struct {
	fn   func(context.Context, AccessPolicyEntityCollection) (AccessPolicyEntityCollection, error)
	apec AccessPolicyEntityCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccessPolicyEntityCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccessPolicyEntityCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.apec)
		if err != nil {
			return err
		}
		page.apec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccessPolicyEntityCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccessPolicyEntityCollectionPage) NotDone() bool {
	return !page.apec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccessPolicyEntityCollectionPage) Response() AccessPolicyEntityCollection {
	return page.apec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccessPolicyEntityCollectionPage) Values() []AccessPolicyEntity {
	if page.apec.IsEmpty() {
		return nil
	}
	return *page.apec.Value
}

// Creates a new instance of the AccessPolicyEntityCollectionPage type.
func NewAccessPolicyEntityCollectionPage(cur AccessPolicyEntityCollection, getNextPage func(context.Context, AccessPolicyEntityCollection) (AccessPolicyEntityCollection, error)) AccessPolicyEntityCollectionPage {
	return AccessPolicyEntityCollectionPage{
		fn:   getNextPage,
		apec: cur,
	}
}

// AccessPolicyProperties application level properties for the access policy resource.
type AccessPolicyProperties struct {
	// Role - Defines the access level granted by this policy. Possible values include: 'AccessPolicyRoleReader'
	Role AccessPolicyRole `json:"role,omitempty"`
	// Authentication - Authentication method to be used when validating client API access.
	Authentication BasicAuthenticationBase `json:"authentication,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AccessPolicyProperties struct.
func (app *AccessPolicyProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "role":
			if v != nil {
				var role AccessPolicyRole
				err = json.Unmarshal(*v, &role)
				if err != nil {
					return err
				}
				app.Role = role
			}
		case "authentication":
			if v != nil {
				authentication, err := unmarshalBasicAuthenticationBase(*v)
				if err != nil {
					return err
				}
				app.Authentication = authentication
			}
		}
	}

	return nil
}

// AccountEncryption defines how the Video Analyzer account is (optionally) encrypted.
type AccountEncryption struct {
	// Type - The type of key used to encrypt the Account Key. Possible values include: 'AccountEncryptionKeyTypeSystemKey', 'AccountEncryptionKeyTypeCustomerKey'
	Type AccountEncryptionKeyType `json:"type,omitempty"`
	// KeyVaultProperties - The properties of the key used to encrypt the account.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
	// Identity - The Key Vault identity.
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// Status - READ-ONLY; The current status of the Key Vault mapping.
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountEncryption.
func (ae AccountEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ae.Type != "" {
		objectMap["type"] = ae.Type
	}
	if ae.KeyVaultProperties != nil {
		objectMap["keyVaultProperties"] = ae.KeyVaultProperties
	}
	if ae.Identity != nil {
		objectMap["identity"] = ae.Identity
	}
	return json.Marshal(objectMap)
}

// BasicAuthenticationBase base class for access policies authentication methods.
type BasicAuthenticationBase interface {
	AsJwtAuthentication() (*JwtAuthentication, bool)
	AsAuthenticationBase() (*AuthenticationBase, bool)
}

// AuthenticationBase base class for access policies authentication methods.
type AuthenticationBase struct {
	// Type - Possible values include: 'TypeTypeAuthenticationBase', 'TypeTypeMicrosoftVideoAnalyzerJwtAuthentication'
	Type Type `json:"@type,omitempty"`
}

func unmarshalBasicAuthenticationBase(body []byte) (BasicAuthenticationBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeTypeMicrosoftVideoAnalyzerJwtAuthentication):
		var ja JwtAuthentication
		err := json.Unmarshal(body, &ja)
		return ja, err
	default:
		var ab AuthenticationBase
		err := json.Unmarshal(body, &ab)
		return ab, err
	}
}
func unmarshalBasicAuthenticationBaseArray(body []byte) ([]BasicAuthenticationBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	abArray := make([]BasicAuthenticationBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ab, err := unmarshalBasicAuthenticationBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		abArray[index] = ab
	}
	return abArray, nil
}

// MarshalJSON is the custom marshaler for AuthenticationBase.
func (ab AuthenticationBase) MarshalJSON() ([]byte, error) {
	ab.Type = TypeTypeAuthenticationBase
	objectMap := make(map[string]interface{})
	if ab.Type != "" {
		objectMap["@type"] = ab.Type
	}
	return json.Marshal(objectMap)
}

// AsJwtAuthentication is the BasicAuthenticationBase implementation for AuthenticationBase.
func (ab AuthenticationBase) AsJwtAuthentication() (*JwtAuthentication, bool) {
	return nil, false
}

// AsAuthenticationBase is the BasicAuthenticationBase implementation for AuthenticationBase.
func (ab AuthenticationBase) AsAuthenticationBase() (*AuthenticationBase, bool) {
	return &ab, true
}

// AsBasicAuthenticationBase is the BasicAuthenticationBase implementation for AuthenticationBase.
func (ab AuthenticationBase) AsBasicAuthenticationBase() (BasicAuthenticationBase, bool) {
	return &ab, true
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityRequest the check availability request body.
type CheckNameAvailabilityRequest struct {
	// Name - The name of the resource for which availability needs to be checked.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse the check availability result.
type CheckNameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// NameAvailable - Indicates if the resource name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason why the given name is not available. Possible values include: 'CheckNameAvailabilityReasonInvalid', 'CheckNameAvailabilityReasonAlreadyExists'
	Reason CheckNameAvailabilityReason `json:"reason,omitempty"`
	// Message - Detailed reason why the given name is available.
	Message *string `json:"message,omitempty"`
}

// Collection a collection of VideoAnalyzer items.
type Collection struct {
	autorest.Response `json:"-"`
	// Value - A collection of VideoAnalyzer items.
	Value *[]Model `json:"value,omitempty"`
}

// EccTokenKey required validation properties for tokens generated with Elliptical Curve algorithm.
type EccTokenKey struct {
	// Alg - Elliptical curve algorithm to be used: ES256, ES384 or ES512. Possible values include: 'AccessPolicyEccAlgoES256', 'AccessPolicyEccAlgoES384', 'AccessPolicyEccAlgoES512'
	Alg AccessPolicyEccAlgo `json:"alg,omitempty"`
	// X - X coordinate.
	X *string `json:"x,omitempty"`
	// Y - Y coordinate.
	Y *string `json:"y,omitempty"`
	// Kid - JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
	Kid *string `json:"kid,omitempty"`
	// Type - Possible values include: 'TypeBasicTokenKeyTypeTokenKey', 'TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey', 'TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey'
	Type TypeBasicTokenKey `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for EccTokenKey.
func (etk EccTokenKey) MarshalJSON() ([]byte, error) {
	etk.Type = TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey
	objectMap := make(map[string]interface{})
	if etk.Alg != "" {
		objectMap["alg"] = etk.Alg
	}
	if etk.X != nil {
		objectMap["x"] = etk.X
	}
	if etk.Y != nil {
		objectMap["y"] = etk.Y
	}
	if etk.Kid != nil {
		objectMap["kid"] = etk.Kid
	}
	if etk.Type != "" {
		objectMap["@type"] = etk.Type
	}
	return json.Marshal(objectMap)
}

// AsRsaTokenKey is the BasicTokenKey implementation for EccTokenKey.
func (etk EccTokenKey) AsRsaTokenKey() (*RsaTokenKey, bool) {
	return nil, false
}

// AsEccTokenKey is the BasicTokenKey implementation for EccTokenKey.
func (etk EccTokenKey) AsEccTokenKey() (*EccTokenKey, bool) {
	return &etk, true
}

// AsTokenKey is the BasicTokenKey implementation for EccTokenKey.
func (etk EccTokenKey) AsTokenKey() (*TokenKey, bool) {
	return nil, false
}

// AsBasicTokenKey is the BasicTokenKey implementation for EccTokenKey.
func (etk EccTokenKey) AsBasicTokenKey() (BasicTokenKey, bool) {
	return &etk, true
}

// EdgeModuleEntity the representation of an edge module.
type EdgeModuleEntity struct {
	autorest.Response `json:"-"`
	// EdgeModuleProperties - The resource properties.
	*EdgeModuleProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EdgeModuleEntity.
func (eme EdgeModuleEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eme.EdgeModuleProperties != nil {
		objectMap["properties"] = eme.EdgeModuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EdgeModuleEntity struct.
func (eme *EdgeModuleEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var edgeModuleProperties EdgeModuleProperties
				err = json.Unmarshal(*v, &edgeModuleProperties)
				if err != nil {
					return err
				}
				eme.EdgeModuleProperties = &edgeModuleProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				eme.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				eme.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				eme.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				eme.Type = &typeVar
			}
		}
	}

	return nil
}

// EdgeModuleEntityCollection a collection of EdgeModuleEntity items.
type EdgeModuleEntityCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of EdgeModuleEntity items.
	Value *[]EdgeModuleEntity `json:"value,omitempty"`
	// NextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	NextLink *string `json:"@nextLink,omitempty"`
}

// EdgeModuleEntityCollectionIterator provides access to a complete listing of EdgeModuleEntity values.
type EdgeModuleEntityCollectionIterator struct {
	i    int
	page EdgeModuleEntityCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EdgeModuleEntityCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EdgeModuleEntityCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EdgeModuleEntityCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EdgeModuleEntityCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EdgeModuleEntityCollectionIterator) Response() EdgeModuleEntityCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EdgeModuleEntityCollectionIterator) Value() EdgeModuleEntity {
	if !iter.page.NotDone() {
		return EdgeModuleEntity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EdgeModuleEntityCollectionIterator type.
func NewEdgeModuleEntityCollectionIterator(page EdgeModuleEntityCollectionPage) EdgeModuleEntityCollectionIterator {
	return EdgeModuleEntityCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (emec EdgeModuleEntityCollection) IsEmpty() bool {
	return emec.Value == nil || len(*emec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (emec EdgeModuleEntityCollection) hasNextLink() bool {
	return emec.NextLink != nil && len(*emec.NextLink) != 0
}

// edgeModuleEntityCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (emec EdgeModuleEntityCollection) edgeModuleEntityCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !emec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(emec.NextLink)))
}

// EdgeModuleEntityCollectionPage contains a page of EdgeModuleEntity values.
type EdgeModuleEntityCollectionPage struct {
	fn   func(context.Context, EdgeModuleEntityCollection) (EdgeModuleEntityCollection, error)
	emec EdgeModuleEntityCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EdgeModuleEntityCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EdgeModuleEntityCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.emec)
		if err != nil {
			return err
		}
		page.emec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EdgeModuleEntityCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EdgeModuleEntityCollectionPage) NotDone() bool {
	return !page.emec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EdgeModuleEntityCollectionPage) Response() EdgeModuleEntityCollection {
	return page.emec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EdgeModuleEntityCollectionPage) Values() []EdgeModuleEntity {
	if page.emec.IsEmpty() {
		return nil
	}
	return *page.emec.Value
}

// Creates a new instance of the EdgeModuleEntityCollectionPage type.
func NewEdgeModuleEntityCollectionPage(cur EdgeModuleEntityCollection, getNextPage func(context.Context, EdgeModuleEntityCollection) (EdgeModuleEntityCollection, error)) EdgeModuleEntityCollectionPage {
	return EdgeModuleEntityCollectionPage{
		fn:   getNextPage,
		emec: cur,
	}
}

// EdgeModuleProperties application level properties for the edge module resource.
type EdgeModuleProperties struct {
	// EdgeModuleID - READ-ONLY; Internal ID generated for the instance of the Video Analyzer edge module.
	EdgeModuleID *uuid.UUID `json:"edgeModuleId,omitempty"`
}

// EdgeModuleProvisioningToken provisioning token properties. A provisioning token allows for a single
// instance of Azure Video analyzer IoT edge module to be initialized and authorized to the cloud account.
// The provisioning token itself is short lived and it is only used for the initial handshake between IoT
// edge module and the cloud. After the initial handshake, the IoT edge module will agree on a set of
// authentication keys which will be auto-rotated as long as the module is able to periodically connect to
// the cloud. A new provisioning token can be generated for the same IoT edge module in case the module
// state lost or reset.
type EdgeModuleProvisioningToken struct {
	autorest.Response `json:"-"`
	// ExpirationDate - READ-ONLY; The expiration date of the registration token. The Azure Video Analyzer IoT edge module must be initialized and connected to the Internet prior to the token expiration date.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Token - READ-ONLY; The token blob to be provided to the Azure Video Analyzer IoT edge module through the Azure IoT Edge module twin properties.
	Token *string `json:"token,omitempty"`
}

// Endpoint the endpoint details.
type Endpoint struct {
	// EndpointURL - The URL of the endpoint.
	EndpointURL *string `json:"endpointUrl,omitempty"`
	// Type - The type of the endpoint.
	Type *string `json:"type,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Identity the managed identity for the Video Analyzer resource.
type Identity struct {
	// Type - The identity type.
	Type *string `json:"type,omitempty"`
	// UserAssignedIdentities - The User Assigned Managed Identities.
	UserAssignedIdentities map[string]*UserAssignedManagedIdentity `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != nil {
		objectMap["type"] = i.Type
	}
	if i.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = i.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// JwtAuthentication properties for access validation based on JSON Web Tokens (JWT).
type JwtAuthentication struct {
	// Issuers - List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
	Issuers *[]string `json:"issuers,omitempty"`
	// Audiences - List of expected token audiences. Token audience is valid if it matches at least one of the given values.
	Audiences *[]string `json:"audiences,omitempty"`
	// Claims - List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
	Claims *[]TokenClaim `json:"claims,omitempty"`
	// Keys - List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
	Keys *[]BasicTokenKey `json:"keys,omitempty"`
	// Type - Possible values include: 'TypeTypeAuthenticationBase', 'TypeTypeMicrosoftVideoAnalyzerJwtAuthentication'
	Type Type `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for JwtAuthentication.
func (ja JwtAuthentication) MarshalJSON() ([]byte, error) {
	ja.Type = TypeTypeMicrosoftVideoAnalyzerJwtAuthentication
	objectMap := make(map[string]interface{})
	if ja.Issuers != nil {
		objectMap["issuers"] = ja.Issuers
	}
	if ja.Audiences != nil {
		objectMap["audiences"] = ja.Audiences
	}
	if ja.Claims != nil {
		objectMap["claims"] = ja.Claims
	}
	if ja.Keys != nil {
		objectMap["keys"] = ja.Keys
	}
	if ja.Type != "" {
		objectMap["@type"] = ja.Type
	}
	return json.Marshal(objectMap)
}

// AsJwtAuthentication is the BasicAuthenticationBase implementation for JwtAuthentication.
func (ja JwtAuthentication) AsJwtAuthentication() (*JwtAuthentication, bool) {
	return &ja, true
}

// AsAuthenticationBase is the BasicAuthenticationBase implementation for JwtAuthentication.
func (ja JwtAuthentication) AsAuthenticationBase() (*AuthenticationBase, bool) {
	return nil, false
}

// AsBasicAuthenticationBase is the BasicAuthenticationBase implementation for JwtAuthentication.
func (ja JwtAuthentication) AsBasicAuthenticationBase() (BasicAuthenticationBase, bool) {
	return &ja, true
}

// UnmarshalJSON is the custom unmarshaler for JwtAuthentication struct.
func (ja *JwtAuthentication) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "issuers":
			if v != nil {
				var issuers []string
				err = json.Unmarshal(*v, &issuers)
				if err != nil {
					return err
				}
				ja.Issuers = &issuers
			}
		case "audiences":
			if v != nil {
				var audiences []string
				err = json.Unmarshal(*v, &audiences)
				if err != nil {
					return err
				}
				ja.Audiences = &audiences
			}
		case "claims":
			if v != nil {
				var claims []TokenClaim
				err = json.Unmarshal(*v, &claims)
				if err != nil {
					return err
				}
				ja.Claims = &claims
			}
		case "keys":
			if v != nil {
				keys, err := unmarshalBasicTokenKeyArray(*v)
				if err != nil {
					return err
				}
				ja.Keys = &keys
			}
		case "@type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ja.Type = typeVar
			}
		}
	}

	return nil
}

// KeyVaultProperties the details for accessing the encryption keys in Key Vault.
type KeyVaultProperties struct {
	// KeyIdentifier - The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`
	// CurrentKeyIdentifier - READ-ONLY; The current key used to encrypt Video Analyzer account, including the key version.
	CurrentKeyIdentifier *string `json:"currentKeyIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyVaultProperties.
func (kvp KeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kvp.KeyIdentifier != nil {
		objectMap["keyIdentifier"] = kvp.KeyIdentifier
	}
	return json.Marshal(objectMap)
}

// ListProvisioningTokenInput the input parameters to generate registration token for the Azure Video
// Analyzer IoT edge module.
type ListProvisioningTokenInput struct {
	// ExpirationDate - The desired expiration date of the registration token. The Azure Video Analyzer IoT edge module must be initialized and connected to the Internet prior to the token expiration date.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
}

// LogSpecification a diagnostic log emitted by service.
type LogSpecification struct {
	// Name - READ-ONLY; The diagnostic log category name.
	Name *string `json:"name,omitempty"`
	// DisplayName - READ-ONLY; The diagnostic log category display name.
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - READ-ONLY; The time range for requests in each blob.
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// MetricDimension a metric dimension.
type MetricDimension struct {
	// Name - READ-ONLY; The metric dimension name.
	Name *string `json:"name,omitempty"`
	// DisplayName - READ-ONLY; The display name for the dimension.
	DisplayName *string `json:"displayName,omitempty"`
	// ToBeExportedForShoebox - READ-ONLY; Whether to export metric to shoebox.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// MetricSpecification a metric emitted by service.
type MetricSpecification struct {
	// Name - READ-ONLY; The metric name.
	Name *string `json:"name,omitempty"`
	// DisplayName - READ-ONLY; The metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - READ-ONLY; The metric display description.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - READ-ONLY; The metric unit. Possible values include: 'MetricUnitBytes', 'MetricUnitCount', 'MetricUnitMilliseconds'
	Unit MetricUnit `json:"unit,omitempty"`
	// AggregationType - READ-ONLY; The metric aggregation type. Possible values include: 'MetricAggregationTypeAverage', 'MetricAggregationTypeCount', 'MetricAggregationTypeTotal'
	AggregationType MetricAggregationType `json:"aggregationType,omitempty"`
	// LockAggregationType - READ-ONLY; The metric lock aggregation type. Possible values include: 'MetricAggregationTypeAverage', 'MetricAggregationTypeCount', 'MetricAggregationTypeTotal'
	LockAggregationType MetricAggregationType `json:"lockAggregationType,omitempty"`
	// SupportedAggregationTypes - Supported aggregation types.
	SupportedAggregationTypes *[]string `json:"supportedAggregationTypes,omitempty"`
	// Dimensions - READ-ONLY; The metric dimensions.
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
	// EnableRegionalMdmAccount - READ-ONLY; Indicates whether regional MDM account is enabled.
	EnableRegionalMdmAccount *bool `json:"enableRegionalMdmAccount,omitempty"`
	// SourceMdmAccount - READ-ONLY; The source MDM account.
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`
	// SourceMdmNamespace - READ-ONLY; The source MDM namespace.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`
	// SupportedTimeGrainTypes - READ-ONLY; The supported time grain types.
	SupportedTimeGrainTypes *[]string `json:"supportedTimeGrainTypes,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricSpecification.
func (ms MetricSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ms.SupportedAggregationTypes != nil {
		objectMap["supportedAggregationTypes"] = ms.SupportedAggregationTypes
	}
	return json.Marshal(objectMap)
}

// Model a Video Analyzer account.
type Model struct {
	autorest.Response `json:"-"`
	// PropertiesType - The properties of the Video Analyzer account.
	*PropertiesType `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system data of the Video Analyzer account.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Identity - The set of managed identities associated with the Video Analyzer resource.
	Identity *Identity `json:"identity,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Model.
func (mVar Model) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.PropertiesType != nil {
		objectMap["properties"] = mVar.PropertiesType
	}
	if mVar.Identity != nil {
		objectMap["identity"] = mVar.Identity
	}
	if mVar.Tags != nil {
		objectMap["tags"] = mVar.Tags
	}
	if mVar.Location != nil {
		objectMap["location"] = mVar.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Model struct.
func (mVar *Model) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var propertiesType PropertiesType
				err = json.Unmarshal(*v, &propertiesType)
				if err != nil {
					return err
				}
				mVar.PropertiesType = &propertiesType
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mVar.SystemData = &systemData
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				mVar.Identity = &identity
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mVar.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mVar.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		}
	}

	return nil
}

// Operation an operation.
type Operation struct {
	// Name - The operation name.
	Name *string `json:"name,omitempty"`
	// Display - The operation display name.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - Origin of the operation.
	Origin *string `json:"origin,omitempty"`
	// Properties - Operation properties format.
	Properties *Properties `json:"properties,omitempty"`
	// IsDataAction - Whether the operation applies to data-plane.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// ActionType - Indicates the action type. Possible values include: 'ActionTypeInternal'
	ActionType ActionType `json:"actionType,omitempty"`
}

// OperationCollection a collection of Operation items.
type OperationCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of Operation items.
	Value *[]Operation `json:"value,omitempty"`
}

// OperationDisplay operation details.
type OperationDisplay struct {
	// Provider - The service provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation type.
	Operation *string `json:"operation,omitempty"`
	// Description - The operation description.
	Description *string `json:"description,omitempty"`
}

// Properties metric properties.
type Properties struct {
	// ServiceSpecification - READ-ONLY; The service specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// PropertiesType ...
type PropertiesType struct {
	// StorageAccounts - The storage accounts for this resource.
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	// Endpoints - READ-ONLY; The list of endpoints associated with this resource.
	Endpoints *[]Endpoint `json:"endpoints,omitempty"`
	// Encryption - The account encryption properties.
	Encryption *AccountEncryption `json:"encryption,omitempty"`
}

// MarshalJSON is the custom marshaler for PropertiesType.
func (pt PropertiesType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pt.StorageAccounts != nil {
		objectMap["storageAccounts"] = pt.StorageAccounts
	}
	if pt.Encryption != nil {
		objectMap["encryption"] = pt.Encryption
	}
	return json.Marshal(objectMap)
}

// PropertiesUpdate properties of the Video Analyzer account.
type PropertiesUpdate struct {
	// StorageAccounts - The storage accounts for this resource.
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	// Endpoints - READ-ONLY; The list of endpoints associated with this resource.
	Endpoints *[]Endpoint `json:"endpoints,omitempty"`
	// Encryption - The account encryption properties.
	Encryption *AccountEncryption `json:"encryption,omitempty"`
}

// MarshalJSON is the custom marshaler for PropertiesUpdate.
func (pu PropertiesUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pu.StorageAccounts != nil {
		objectMap["storageAccounts"] = pu.StorageAccounts
	}
	if pu.Encryption != nil {
		objectMap["encryption"] = pu.Encryption
	}
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// ResourceIdentity the user assigned managed identity to use when accessing a resource.
type ResourceIdentity struct {
	// UserAssignedIdentity - The user assigned managed identity's resource identifier to use when accessing a resource.
	UserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
}

// RsaTokenKey required validation properties for tokens generated with RSA algorithm.
type RsaTokenKey struct {
	// Alg - RSA algorithm to be used: RS256, RS384 or RS512. Possible values include: 'AccessPolicyRsaAlgoRS256', 'AccessPolicyRsaAlgoRS384', 'AccessPolicyRsaAlgoRS512'
	Alg AccessPolicyRsaAlgo `json:"alg,omitempty"`
	// N - RSA public key modulus.
	N *string `json:"n,omitempty"`
	// E - RSA public key exponent.
	E *string `json:"e,omitempty"`
	// Kid - JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
	Kid *string `json:"kid,omitempty"`
	// Type - Possible values include: 'TypeBasicTokenKeyTypeTokenKey', 'TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey', 'TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey'
	Type TypeBasicTokenKey `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for RsaTokenKey.
func (rtk RsaTokenKey) MarshalJSON() ([]byte, error) {
	rtk.Type = TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey
	objectMap := make(map[string]interface{})
	if rtk.Alg != "" {
		objectMap["alg"] = rtk.Alg
	}
	if rtk.N != nil {
		objectMap["n"] = rtk.N
	}
	if rtk.E != nil {
		objectMap["e"] = rtk.E
	}
	if rtk.Kid != nil {
		objectMap["kid"] = rtk.Kid
	}
	if rtk.Type != "" {
		objectMap["@type"] = rtk.Type
	}
	return json.Marshal(objectMap)
}

// AsRsaTokenKey is the BasicTokenKey implementation for RsaTokenKey.
func (rtk RsaTokenKey) AsRsaTokenKey() (*RsaTokenKey, bool) {
	return &rtk, true
}

// AsEccTokenKey is the BasicTokenKey implementation for RsaTokenKey.
func (rtk RsaTokenKey) AsEccTokenKey() (*EccTokenKey, bool) {
	return nil, false
}

// AsTokenKey is the BasicTokenKey implementation for RsaTokenKey.
func (rtk RsaTokenKey) AsTokenKey() (*TokenKey, bool) {
	return nil, false
}

// AsBasicTokenKey is the BasicTokenKey implementation for RsaTokenKey.
func (rtk RsaTokenKey) AsBasicTokenKey() (BasicTokenKey, bool) {
	return &rtk, true
}

// ServiceSpecification the service metric specifications.
type ServiceSpecification struct {
	// LogSpecifications - READ-ONLY; List of log specifications.
	LogSpecifications *[]LogSpecification `json:"logSpecifications,omitempty"`
	// MetricSpecifications - READ-ONLY; List of metric specifications.
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// StorageAccount the details about the associated storage account.
type StorageAccount struct {
	// ID - The ID of the storage account resource. Video Analyzer relies on tables, queues, and blobs. The primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage).
	ID *string `json:"id,omitempty"`
	// Identity - A managed identity that Video Analyzer will use to access the storage account.
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// Status - READ-ONLY; The current status of the storage account mapping.
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageAccount.
func (sa StorageAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sa.ID != nil {
		objectMap["id"] = sa.ID
	}
	if sa.Identity != nil {
		objectMap["identity"] = sa.Identity
	}
	return json.Marshal(objectMap)
}

// SyncStorageKeysInput the input to the sync storage keys request.
type SyncStorageKeysInput struct {
	// ID - The ID of the storage account resource.
	ID *string `json:"id,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TokenClaim properties for expected token claims.
type TokenClaim struct {
	// Name - Name of the claim which must be present on the token.
	Name *string `json:"name,omitempty"`
	// Value - Expected value of the claim to be present on the token.
	Value *string `json:"value,omitempty"`
}

// BasicTokenKey key properties for JWT token validation.
type BasicTokenKey interface {
	AsRsaTokenKey() (*RsaTokenKey, bool)
	AsEccTokenKey() (*EccTokenKey, bool)
	AsTokenKey() (*TokenKey, bool)
}

// TokenKey key properties for JWT token validation.
type TokenKey struct {
	// Kid - JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
	Kid *string `json:"kid,omitempty"`
	// Type - Possible values include: 'TypeBasicTokenKeyTypeTokenKey', 'TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey', 'TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey'
	Type TypeBasicTokenKey `json:"@type,omitempty"`
}

func unmarshalBasicTokenKey(body []byte) (BasicTokenKey, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey):
		var rtk RsaTokenKey
		err := json.Unmarshal(body, &rtk)
		return rtk, err
	case string(TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey):
		var etk EccTokenKey
		err := json.Unmarshal(body, &etk)
		return etk, err
	default:
		var tk TokenKey
		err := json.Unmarshal(body, &tk)
		return tk, err
	}
}
func unmarshalBasicTokenKeyArray(body []byte) ([]BasicTokenKey, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tkArray := make([]BasicTokenKey, len(rawMessages))

	for index, rawMessage := range rawMessages {
		tk, err := unmarshalBasicTokenKey(*rawMessage)
		if err != nil {
			return nil, err
		}
		tkArray[index] = tk
	}
	return tkArray, nil
}

// MarshalJSON is the custom marshaler for TokenKey.
func (tk TokenKey) MarshalJSON() ([]byte, error) {
	tk.Type = TypeBasicTokenKeyTypeTokenKey
	objectMap := make(map[string]interface{})
	if tk.Kid != nil {
		objectMap["kid"] = tk.Kid
	}
	if tk.Type != "" {
		objectMap["@type"] = tk.Type
	}
	return json.Marshal(objectMap)
}

// AsRsaTokenKey is the BasicTokenKey implementation for TokenKey.
func (tk TokenKey) AsRsaTokenKey() (*RsaTokenKey, bool) {
	return nil, false
}

// AsEccTokenKey is the BasicTokenKey implementation for TokenKey.
func (tk TokenKey) AsEccTokenKey() (*EccTokenKey, bool) {
	return nil, false
}

// AsTokenKey is the BasicTokenKey implementation for TokenKey.
func (tk TokenKey) AsTokenKey() (*TokenKey, bool) {
	return &tk, true
}

// AsBasicTokenKey is the BasicTokenKey implementation for TokenKey.
func (tk TokenKey) AsBasicTokenKey() (BasicTokenKey, bool) {
	return &tk, true
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// Update the update operation for a Video Analyzer account.
type Update struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// PropertiesUpdate - The resource properties.
	*PropertiesUpdate `json:"properties,omitempty"`
	// Identity - The identities associated to the Video Analyzer resource.
	Identity *Identity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for Update.
func (u Update) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.Tags != nil {
		objectMap["tags"] = u.Tags
	}
	if u.PropertiesUpdate != nil {
		objectMap["properties"] = u.PropertiesUpdate
	}
	if u.Identity != nil {
		objectMap["identity"] = u.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Update struct.
func (u *Update) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				u.Tags = tags
			}
		case "properties":
			if v != nil {
				var propertiesUpdate PropertiesUpdate
				err = json.Unmarshal(*v, &propertiesUpdate)
				if err != nil {
					return err
				}
				u.PropertiesUpdate = &propertiesUpdate
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				u.Identity = &identity
			}
		}
	}

	return nil
}

// UserAssignedManagedIdentity the details of the user assigned managed identity used by the Video Analyzer
// resource.
type UserAssignedManagedIdentity struct {
	// ClientID - READ-ONLY; The client ID.
	ClientID *string `json:"clientId,omitempty"`
	// PrincipalID - READ-ONLY; The principal ID.
	PrincipalID *string `json:"principalId,omitempty"`
}

// VideoEntity the representation of a single video in a Video Analyzer account.
type VideoEntity struct {
	autorest.Response `json:"-"`
	// VideoProperties - The resource properties.
	*VideoProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoEntity.
func (ve VideoEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ve.VideoProperties != nil {
		objectMap["properties"] = ve.VideoProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VideoEntity struct.
func (ve *VideoEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var videoProperties VideoProperties
				err = json.Unmarshal(*v, &videoProperties)
				if err != nil {
					return err
				}
				ve.VideoProperties = &videoProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ve.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ve.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ve.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ve.Type = &typeVar
			}
		}
	}

	return nil
}

// VideoEntityCollection a collection of VideoEntity items.
type VideoEntityCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of VideoEntity items.
	Value *[]VideoEntity `json:"value,omitempty"`
	// NextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	NextLink *string `json:"@nextLink,omitempty"`
}

// VideoEntityCollectionIterator provides access to a complete listing of VideoEntity values.
type VideoEntityCollectionIterator struct {
	i    int
	page VideoEntityCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VideoEntityCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VideoEntityCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VideoEntityCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VideoEntityCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VideoEntityCollectionIterator) Response() VideoEntityCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VideoEntityCollectionIterator) Value() VideoEntity {
	if !iter.page.NotDone() {
		return VideoEntity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VideoEntityCollectionIterator type.
func NewVideoEntityCollectionIterator(page VideoEntityCollectionPage) VideoEntityCollectionIterator {
	return VideoEntityCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vec VideoEntityCollection) IsEmpty() bool {
	return vec.Value == nil || len(*vec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vec VideoEntityCollection) hasNextLink() bool {
	return vec.NextLink != nil && len(*vec.NextLink) != 0
}

// videoEntityCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vec VideoEntityCollection) videoEntityCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !vec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vec.NextLink)))
}

// VideoEntityCollectionPage contains a page of VideoEntity values.
type VideoEntityCollectionPage struct {
	fn  func(context.Context, VideoEntityCollection) (VideoEntityCollection, error)
	vec VideoEntityCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VideoEntityCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VideoEntityCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vec)
		if err != nil {
			return err
		}
		page.vec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VideoEntityCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VideoEntityCollectionPage) NotDone() bool {
	return !page.vec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VideoEntityCollectionPage) Response() VideoEntityCollection {
	return page.vec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VideoEntityCollectionPage) Values() []VideoEntity {
	if page.vec.IsEmpty() {
		return nil
	}
	return *page.vec.Value
}

// Creates a new instance of the VideoEntityCollectionPage type.
func NewVideoEntityCollectionPage(cur VideoEntityCollection, getNextPage func(context.Context, VideoEntityCollection) (VideoEntityCollection, error)) VideoEntityCollectionPage {
	return VideoEntityCollectionPage{
		fn:  getNextPage,
		vec: cur,
	}
}

// VideoFlags video flags contain information about the available video actions and its dynamic properties
// based on the current video state.
type VideoFlags struct {
	// CanStream - Value indicating whether or not the video can be streamed. Only "archive" type videos can be streamed.
	CanStream *bool `json:"canStream,omitempty"`
	// HasData - Value indicating whether or not there has ever been data recorded or uploaded into the video. Newly created videos have this value set to false.
	HasData *bool `json:"hasData,omitempty"`
	// IsRecording - Value indicating whether or not the video is currently being referenced be an active live pipeline. The fact that is being referenced, doesn't necessarily indicate that data is being received. For example, video recording may be gated on events or camera may not be accessible at the time.
	IsRecording *bool `json:"isRecording,omitempty"`
}

// VideoMediaInfo contains information about the video and audio content.
type VideoMediaInfo struct {
	// SegmentLength - READ-ONLY; Video segment length indicates the length of individual video files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments.
	SegmentLength *string `json:"segmentLength,omitempty"`
}

// VideoProperties application level properties for the video resource.
type VideoProperties struct {
	// Title - Optional video title provided by the user. Value can be up to 256 characters long.
	Title *string `json:"title,omitempty"`
	// Description - Optional video description provided by the user. Value can be up to 2048 characters long.
	Description *string `json:"description,omitempty"`
	// Type - READ-ONLY; Type of the video archive. Different archive formats provide different capabilities. Possible values include: 'VideoTypeArchive'
	Type VideoType `json:"type,omitempty"`
	// Flags - READ-ONLY; Video flags contain information about the available video actions and its dynamic properties based on the current video state.
	Flags *VideoFlags `json:"flags,omitempty"`
	// Streaming - READ-ONLY; Video streaming holds information about video streaming URLs.
	Streaming *VideoStreaming `json:"streaming,omitempty"`
	// MediaInfo - READ-ONLY; Contains information about the video and audio content.
	MediaInfo *VideoMediaInfo `json:"mediaInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoProperties.
func (vp VideoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vp.Title != nil {
		objectMap["title"] = vp.Title
	}
	if vp.Description != nil {
		objectMap["description"] = vp.Description
	}
	return json.Marshal(objectMap)
}

// VideoStreaming video streaming holds information about video streaming URLs.
type VideoStreaming struct {
	// ArchiveBaseURL - Video streaming base URL for the video archive. When present, archived video can be played through the Azure Video Analyzer player. Alternatively, this URL can be used with compatible DASH or HLS players by appending the following to the base URL:
	//
	//   - HLSv4:     /manifest(format=m3u8-aapl).m3u8
	//   - HLS CMAF:  /manifest(format=m3u8-cmaf)
	//   - DASH CMAF: /manifest(format=mpd-time-cmaf)
	//
	// Moreover, an ongoing video recording can be played in "live mode" with latencies which are approximately double of the chosen video segment length.
	ArchiveBaseURL *string `json:"archiveBaseUrl,omitempty"`
}

// VideoStreamingToken video streaming token grants access to the video streaming URLs which can be used by
// an compatible HLS or DASH player.
type VideoStreamingToken struct {
	autorest.Response `json:"-"`
	// ExpirationDate - READ-ONLY; The streaming token expiration date in ISO8601 format (eg. 2021-01-01T00:00:00Z).
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Token - READ-ONLY; The streaming token value to be added to the video streaming URL as the value for a "token" query string parameter. The token is specific to a single video.
	Token *string `json:"token,omitempty"`
}
