package securityinsight

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActionType enumerates the values for action type.
type ActionType string

const (
	// ActionTypeActionTypeAutomationRuleAction ...
	ActionTypeActionTypeAutomationRuleAction ActionType = "AutomationRuleAction"
	// ActionTypeActionTypeModifyProperties ...
	ActionTypeActionTypeModifyProperties ActionType = "ModifyProperties"
	// ActionTypeActionTypeRunPlaybook ...
	ActionTypeActionTypeRunPlaybook ActionType = "RunPlaybook"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{ActionTypeActionTypeAutomationRuleAction, ActionTypeActionTypeModifyProperties, ActionTypeActionTypeRunPlaybook}
}

// AlertRuleKind enumerates the values for alert rule kind.
type AlertRuleKind string

const (
	// AlertRuleKindFusion ...
	AlertRuleKindFusion AlertRuleKind = "Fusion"
	// AlertRuleKindMicrosoftSecurityIncidentCreation ...
	AlertRuleKindMicrosoftSecurityIncidentCreation AlertRuleKind = "MicrosoftSecurityIncidentCreation"
	// AlertRuleKindMLBehaviorAnalytics ...
	AlertRuleKindMLBehaviorAnalytics AlertRuleKind = "MLBehaviorAnalytics"
	// AlertRuleKindScheduled ...
	AlertRuleKindScheduled AlertRuleKind = "Scheduled"
	// AlertRuleKindThreatIntelligence ...
	AlertRuleKindThreatIntelligence AlertRuleKind = "ThreatIntelligence"
)

// PossibleAlertRuleKindValues returns an array of possible values for the AlertRuleKind const type.
func PossibleAlertRuleKindValues() []AlertRuleKind {
	return []AlertRuleKind{AlertRuleKindFusion, AlertRuleKindMicrosoftSecurityIncidentCreation, AlertRuleKindMLBehaviorAnalytics, AlertRuleKindScheduled, AlertRuleKindThreatIntelligence}
}

// AlertSeverity enumerates the values for alert severity.
type AlertSeverity string

const (
	// AlertSeverityHigh High severity
	AlertSeverityHigh AlertSeverity = "High"
	// AlertSeverityInformational Informational severity
	AlertSeverityInformational AlertSeverity = "Informational"
	// AlertSeverityLow Low severity
	AlertSeverityLow AlertSeverity = "Low"
	// AlertSeverityMedium Medium severity
	AlertSeverityMedium AlertSeverity = "Medium"
)

// PossibleAlertSeverityValues returns an array of possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{AlertSeverityHigh, AlertSeverityInformational, AlertSeverityLow, AlertSeverityMedium}
}

// AlertStatus enumerates the values for alert status.
type AlertStatus string

const (
	// AlertStatusDismissed Alert dismissed as false positive
	AlertStatusDismissed AlertStatus = "Dismissed"
	// AlertStatusInProgress Alert is being handled
	AlertStatusInProgress AlertStatus = "InProgress"
	// AlertStatusNew New alert
	AlertStatusNew AlertStatus = "New"
	// AlertStatusResolved Alert closed after handling
	AlertStatusResolved AlertStatus = "Resolved"
	// AlertStatusUnknown Unknown value
	AlertStatusUnknown AlertStatus = "Unknown"
)

// PossibleAlertStatusValues returns an array of possible values for the AlertStatus const type.
func PossibleAlertStatusValues() []AlertStatus {
	return []AlertStatus{AlertStatusDismissed, AlertStatusInProgress, AlertStatusNew, AlertStatusResolved, AlertStatusUnknown}
}

// AntispamMailDirection enumerates the values for antispam mail direction.
type AntispamMailDirection string

const (
	// AntispamMailDirectionInbound Inbound
	AntispamMailDirectionInbound AntispamMailDirection = "Inbound"
	// AntispamMailDirectionIntraorg Intraorg
	AntispamMailDirectionIntraorg AntispamMailDirection = "Intraorg"
	// AntispamMailDirectionOutbound Outbound
	AntispamMailDirectionOutbound AntispamMailDirection = "Outbound"
	// AntispamMailDirectionUnknown Unknown
	AntispamMailDirectionUnknown AntispamMailDirection = "Unknown"
)

// PossibleAntispamMailDirectionValues returns an array of possible values for the AntispamMailDirection const type.
func PossibleAntispamMailDirectionValues() []AntispamMailDirection {
	return []AntispamMailDirection{AntispamMailDirectionInbound, AntispamMailDirectionIntraorg, AntispamMailDirectionOutbound, AntispamMailDirectionUnknown}
}

// AttackTactic enumerates the values for attack tactic.
type AttackTactic string

const (
	// AttackTacticCollection ...
	AttackTacticCollection AttackTactic = "Collection"
	// AttackTacticCommandAndControl ...
	AttackTacticCommandAndControl AttackTactic = "CommandAndControl"
	// AttackTacticCredentialAccess ...
	AttackTacticCredentialAccess AttackTactic = "CredentialAccess"
	// AttackTacticDefenseEvasion ...
	AttackTacticDefenseEvasion AttackTactic = "DefenseEvasion"
	// AttackTacticDiscovery ...
	AttackTacticDiscovery AttackTactic = "Discovery"
	// AttackTacticExecution ...
	AttackTacticExecution AttackTactic = "Execution"
	// AttackTacticExfiltration ...
	AttackTacticExfiltration AttackTactic = "Exfiltration"
	// AttackTacticImpact ...
	AttackTacticImpact AttackTactic = "Impact"
	// AttackTacticInitialAccess ...
	AttackTacticInitialAccess AttackTactic = "InitialAccess"
	// AttackTacticLateralMovement ...
	AttackTacticLateralMovement AttackTactic = "LateralMovement"
	// AttackTacticPersistence ...
	AttackTacticPersistence AttackTactic = "Persistence"
	// AttackTacticPreAttack ...
	AttackTacticPreAttack AttackTactic = "PreAttack"
	// AttackTacticPrivilegeEscalation ...
	AttackTacticPrivilegeEscalation AttackTactic = "PrivilegeEscalation"
)

// PossibleAttackTacticValues returns an array of possible values for the AttackTactic const type.
func PossibleAttackTacticValues() []AttackTactic {
	return []AttackTactic{AttackTacticCollection, AttackTacticCommandAndControl, AttackTacticCredentialAccess, AttackTacticDefenseEvasion, AttackTacticDiscovery, AttackTacticExecution, AttackTacticExfiltration, AttackTacticImpact, AttackTacticInitialAccess, AttackTacticLateralMovement, AttackTacticPersistence, AttackTacticPreAttack, AttackTacticPrivilegeEscalation}
}

// AutomationRulePropertyConditionSupportedOperator enumerates the values for automation rule property
// condition supported operator.
type AutomationRulePropertyConditionSupportedOperator string

const (
	// AutomationRulePropertyConditionSupportedOperatorContains Evaluates if the property contains at least one
	// of the condition values
	AutomationRulePropertyConditionSupportedOperatorContains AutomationRulePropertyConditionSupportedOperator = "Contains"
	// AutomationRulePropertyConditionSupportedOperatorEndsWith Evaluates if the property ends with any of the
	// condition values
	AutomationRulePropertyConditionSupportedOperatorEndsWith AutomationRulePropertyConditionSupportedOperator = "EndsWith"
	// AutomationRulePropertyConditionSupportedOperatorEquals Evaluates if the property equals at least one of
	// the condition values
	AutomationRulePropertyConditionSupportedOperatorEquals AutomationRulePropertyConditionSupportedOperator = "Equals"
	// AutomationRulePropertyConditionSupportedOperatorNotContains Evaluates if the property does not contain
	// any of the condition values
	AutomationRulePropertyConditionSupportedOperatorNotContains AutomationRulePropertyConditionSupportedOperator = "NotContains"
	// AutomationRulePropertyConditionSupportedOperatorNotEndsWith Evaluates if the property does not end with
	// any of the condition values
	AutomationRulePropertyConditionSupportedOperatorNotEndsWith AutomationRulePropertyConditionSupportedOperator = "NotEndsWith"
	// AutomationRulePropertyConditionSupportedOperatorNotEquals Evaluates if the property does not equal any
	// of the condition values
	AutomationRulePropertyConditionSupportedOperatorNotEquals AutomationRulePropertyConditionSupportedOperator = "NotEquals"
	// AutomationRulePropertyConditionSupportedOperatorNotStartsWith Evaluates if the property does not start
	// with any of the condition values
	AutomationRulePropertyConditionSupportedOperatorNotStartsWith AutomationRulePropertyConditionSupportedOperator = "NotStartsWith"
	// AutomationRulePropertyConditionSupportedOperatorStartsWith Evaluates if the property starts with any of
	// the condition values
	AutomationRulePropertyConditionSupportedOperatorStartsWith AutomationRulePropertyConditionSupportedOperator = "StartsWith"
)

// PossibleAutomationRulePropertyConditionSupportedOperatorValues returns an array of possible values for the AutomationRulePropertyConditionSupportedOperator const type.
func PossibleAutomationRulePropertyConditionSupportedOperatorValues() []AutomationRulePropertyConditionSupportedOperator {
	return []AutomationRulePropertyConditionSupportedOperator{AutomationRulePropertyConditionSupportedOperatorContains, AutomationRulePropertyConditionSupportedOperatorEndsWith, AutomationRulePropertyConditionSupportedOperatorEquals, AutomationRulePropertyConditionSupportedOperatorNotContains, AutomationRulePropertyConditionSupportedOperatorNotEndsWith, AutomationRulePropertyConditionSupportedOperatorNotEquals, AutomationRulePropertyConditionSupportedOperatorNotStartsWith, AutomationRulePropertyConditionSupportedOperatorStartsWith}
}

// AutomationRulePropertyConditionSupportedProperty enumerates the values for automation rule property
// condition supported property.
type AutomationRulePropertyConditionSupportedProperty string

const (
	// AutomationRulePropertyConditionSupportedPropertyAccountAadTenantID The account Azure Active Directory
	// tenant id
	AutomationRulePropertyConditionSupportedPropertyAccountAadTenantID AutomationRulePropertyConditionSupportedProperty = "AccountAadTenantId"
	// AutomationRulePropertyConditionSupportedPropertyAccountAadUserID The account Azure Active Directory user
	// id.
	AutomationRulePropertyConditionSupportedPropertyAccountAadUserID AutomationRulePropertyConditionSupportedProperty = "AccountAadUserId"
	// AutomationRulePropertyConditionSupportedPropertyAccountName The account name
	AutomationRulePropertyConditionSupportedPropertyAccountName AutomationRulePropertyConditionSupportedProperty = "AccountName"
	// AutomationRulePropertyConditionSupportedPropertyAccountNTDomain The account NetBIOS domain name
	AutomationRulePropertyConditionSupportedPropertyAccountNTDomain AutomationRulePropertyConditionSupportedProperty = "AccountNTDomain"
	// AutomationRulePropertyConditionSupportedPropertyAccountObjectGUID The account unique identifier
	AutomationRulePropertyConditionSupportedPropertyAccountObjectGUID AutomationRulePropertyConditionSupportedProperty = "AccountObjectGuid"
	// AutomationRulePropertyConditionSupportedPropertyAccountPUID The account Azure Active Directory Passport
	// User ID
	AutomationRulePropertyConditionSupportedPropertyAccountPUID AutomationRulePropertyConditionSupportedProperty = "AccountPUID"
	// AutomationRulePropertyConditionSupportedPropertyAccountSid The account security identifier
	AutomationRulePropertyConditionSupportedPropertyAccountSid AutomationRulePropertyConditionSupportedProperty = "AccountSid"
	// AutomationRulePropertyConditionSupportedPropertyAccountUPNSuffix The account user principal name suffix
	AutomationRulePropertyConditionSupportedPropertyAccountUPNSuffix AutomationRulePropertyConditionSupportedProperty = "AccountUPNSuffix"
	// AutomationRulePropertyConditionSupportedPropertyAzureResourceResourceID The Azure resource id
	AutomationRulePropertyConditionSupportedPropertyAzureResourceResourceID AutomationRulePropertyConditionSupportedProperty = "AzureResourceResourceId"
	// AutomationRulePropertyConditionSupportedPropertyAzureResourceSubscriptionID The Azure resource
	// subscription id
	AutomationRulePropertyConditionSupportedPropertyAzureResourceSubscriptionID AutomationRulePropertyConditionSupportedProperty = "AzureResourceSubscriptionId"
	// AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppID The cloud application identifier
	AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppID AutomationRulePropertyConditionSupportedProperty = "CloudApplicationAppId"
	// AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppName The cloud application name
	AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppName AutomationRulePropertyConditionSupportedProperty = "CloudApplicationAppName"
	// AutomationRulePropertyConditionSupportedPropertyDNSDomainName The dns record domain name
	AutomationRulePropertyConditionSupportedPropertyDNSDomainName AutomationRulePropertyConditionSupportedProperty = "DNSDomainName"
	// AutomationRulePropertyConditionSupportedPropertyFileDirectory The file directory full path
	AutomationRulePropertyConditionSupportedPropertyFileDirectory AutomationRulePropertyConditionSupportedProperty = "FileDirectory"
	// AutomationRulePropertyConditionSupportedPropertyFileHashValue The file hash value
	AutomationRulePropertyConditionSupportedPropertyFileHashValue AutomationRulePropertyConditionSupportedProperty = "FileHashValue"
	// AutomationRulePropertyConditionSupportedPropertyFileName The file name without path
	AutomationRulePropertyConditionSupportedPropertyFileName AutomationRulePropertyConditionSupportedProperty = "FileName"
	// AutomationRulePropertyConditionSupportedPropertyHostAzureID The host Azure resource id
	AutomationRulePropertyConditionSupportedPropertyHostAzureID AutomationRulePropertyConditionSupportedProperty = "HostAzureID"
	// AutomationRulePropertyConditionSupportedPropertyHostName The host name without domain
	AutomationRulePropertyConditionSupportedPropertyHostName AutomationRulePropertyConditionSupportedProperty = "HostName"
	// AutomationRulePropertyConditionSupportedPropertyHostNetBiosName The host NetBIOS name
	AutomationRulePropertyConditionSupportedPropertyHostNetBiosName AutomationRulePropertyConditionSupportedProperty = "HostNetBiosName"
	// AutomationRulePropertyConditionSupportedPropertyHostNTDomain The host NT domain
	AutomationRulePropertyConditionSupportedPropertyHostNTDomain AutomationRulePropertyConditionSupportedProperty = "HostNTDomain"
	// AutomationRulePropertyConditionSupportedPropertyHostOSVersion The host operating system
	AutomationRulePropertyConditionSupportedPropertyHostOSVersion AutomationRulePropertyConditionSupportedProperty = "HostOSVersion"
	// AutomationRulePropertyConditionSupportedPropertyIncidentDescription The description of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentDescription AutomationRulePropertyConditionSupportedProperty = "IncidentDescription"
	// AutomationRulePropertyConditionSupportedPropertyIncidentProviderName The provider name of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentProviderName AutomationRulePropertyConditionSupportedProperty = "IncidentProviderName"
	// AutomationRulePropertyConditionSupportedPropertyIncidentRelatedAnalyticRuleIds The related Analytic rule
	// ids of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentRelatedAnalyticRuleIds AutomationRulePropertyConditionSupportedProperty = "IncidentRelatedAnalyticRuleIds"
	// AutomationRulePropertyConditionSupportedPropertyIncidentSeverity The severity of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentSeverity AutomationRulePropertyConditionSupportedProperty = "IncidentSeverity"
	// AutomationRulePropertyConditionSupportedPropertyIncidentStatus The status of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentStatus AutomationRulePropertyConditionSupportedProperty = "IncidentStatus"
	// AutomationRulePropertyConditionSupportedPropertyIncidentTactics The tactics of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentTactics AutomationRulePropertyConditionSupportedProperty = "IncidentTactics"
	// AutomationRulePropertyConditionSupportedPropertyIncidentTitle The title of the incident
	AutomationRulePropertyConditionSupportedPropertyIncidentTitle AutomationRulePropertyConditionSupportedProperty = "IncidentTitle"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceID The IoT device id
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceID AutomationRulePropertyConditionSupportedProperty = "IoTDeviceId"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceModel The IoT device model
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceModel AutomationRulePropertyConditionSupportedProperty = "IoTDeviceModel"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceName The IoT device name
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceName AutomationRulePropertyConditionSupportedProperty = "IoTDeviceName"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceOperatingSystem The IoT device operating system
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceOperatingSystem AutomationRulePropertyConditionSupportedProperty = "IoTDeviceOperatingSystem"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceType The IoT device type
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceType AutomationRulePropertyConditionSupportedProperty = "IoTDeviceType"
	// AutomationRulePropertyConditionSupportedPropertyIoTDeviceVendor The IoT device vendor
	AutomationRulePropertyConditionSupportedPropertyIoTDeviceVendor AutomationRulePropertyConditionSupportedProperty = "IoTDeviceVendor"
	// AutomationRulePropertyConditionSupportedPropertyIPAddress The IP address
	AutomationRulePropertyConditionSupportedPropertyIPAddress AutomationRulePropertyConditionSupportedProperty = "IPAddress"
	// AutomationRulePropertyConditionSupportedPropertyMailboxDisplayName The mailbox display name
	AutomationRulePropertyConditionSupportedPropertyMailboxDisplayName AutomationRulePropertyConditionSupportedProperty = "MailboxDisplayName"
	// AutomationRulePropertyConditionSupportedPropertyMailboxPrimaryAddress The mailbox primary address
	AutomationRulePropertyConditionSupportedPropertyMailboxPrimaryAddress AutomationRulePropertyConditionSupportedProperty = "MailboxPrimaryAddress"
	// AutomationRulePropertyConditionSupportedPropertyMailboxUPN The mailbox user principal name
	AutomationRulePropertyConditionSupportedPropertyMailboxUPN AutomationRulePropertyConditionSupportedProperty = "MailboxUPN"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryAction The mail message delivery
	// action
	AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryAction AutomationRulePropertyConditionSupportedProperty = "MailMessageDeliveryAction"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryLocation The mail message delivery
	// location
	AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryLocation AutomationRulePropertyConditionSupportedProperty = "MailMessageDeliveryLocation"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageP1Sender The mail message P1 sender
	AutomationRulePropertyConditionSupportedPropertyMailMessageP1Sender AutomationRulePropertyConditionSupportedProperty = "MailMessageP1Sender"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageP2Sender The mail message P2 sender
	AutomationRulePropertyConditionSupportedPropertyMailMessageP2Sender AutomationRulePropertyConditionSupportedProperty = "MailMessageP2Sender"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageRecipient The mail message recipient
	AutomationRulePropertyConditionSupportedPropertyMailMessageRecipient AutomationRulePropertyConditionSupportedProperty = "MailMessageRecipient"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageSenderIP The mail message sender IP address
	AutomationRulePropertyConditionSupportedPropertyMailMessageSenderIP AutomationRulePropertyConditionSupportedProperty = "MailMessageSenderIP"
	// AutomationRulePropertyConditionSupportedPropertyMailMessageSubject The mail message subject
	AutomationRulePropertyConditionSupportedPropertyMailMessageSubject AutomationRulePropertyConditionSupportedProperty = "MailMessageSubject"
	// AutomationRulePropertyConditionSupportedPropertyMalwareCategory The malware category
	AutomationRulePropertyConditionSupportedPropertyMalwareCategory AutomationRulePropertyConditionSupportedProperty = "MalwareCategory"
	// AutomationRulePropertyConditionSupportedPropertyMalwareName The malware name
	AutomationRulePropertyConditionSupportedPropertyMalwareName AutomationRulePropertyConditionSupportedProperty = "MalwareName"
	// AutomationRulePropertyConditionSupportedPropertyProcessCommandLine The process execution command line
	AutomationRulePropertyConditionSupportedPropertyProcessCommandLine AutomationRulePropertyConditionSupportedProperty = "ProcessCommandLine"
	// AutomationRulePropertyConditionSupportedPropertyProcessID The process id
	AutomationRulePropertyConditionSupportedPropertyProcessID AutomationRulePropertyConditionSupportedProperty = "ProcessId"
	// AutomationRulePropertyConditionSupportedPropertyRegistryKey The registry key path
	AutomationRulePropertyConditionSupportedPropertyRegistryKey AutomationRulePropertyConditionSupportedProperty = "RegistryKey"
	// AutomationRulePropertyConditionSupportedPropertyRegistryValueData The registry key value in string
	// formatted representation
	AutomationRulePropertyConditionSupportedPropertyRegistryValueData AutomationRulePropertyConditionSupportedProperty = "RegistryValueData"
	// AutomationRulePropertyConditionSupportedPropertyURL The url
	AutomationRulePropertyConditionSupportedPropertyURL AutomationRulePropertyConditionSupportedProperty = "Url"
)

// PossibleAutomationRulePropertyConditionSupportedPropertyValues returns an array of possible values for the AutomationRulePropertyConditionSupportedProperty const type.
func PossibleAutomationRulePropertyConditionSupportedPropertyValues() []AutomationRulePropertyConditionSupportedProperty {
	return []AutomationRulePropertyConditionSupportedProperty{AutomationRulePropertyConditionSupportedPropertyAccountAadTenantID, AutomationRulePropertyConditionSupportedPropertyAccountAadUserID, AutomationRulePropertyConditionSupportedPropertyAccountName, AutomationRulePropertyConditionSupportedPropertyAccountNTDomain, AutomationRulePropertyConditionSupportedPropertyAccountObjectGUID, AutomationRulePropertyConditionSupportedPropertyAccountPUID, AutomationRulePropertyConditionSupportedPropertyAccountSid, AutomationRulePropertyConditionSupportedPropertyAccountUPNSuffix, AutomationRulePropertyConditionSupportedPropertyAzureResourceResourceID, AutomationRulePropertyConditionSupportedPropertyAzureResourceSubscriptionID, AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppID, AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppName, AutomationRulePropertyConditionSupportedPropertyDNSDomainName, AutomationRulePropertyConditionSupportedPropertyFileDirectory, AutomationRulePropertyConditionSupportedPropertyFileHashValue, AutomationRulePropertyConditionSupportedPropertyFileName, AutomationRulePropertyConditionSupportedPropertyHostAzureID, AutomationRulePropertyConditionSupportedPropertyHostName, AutomationRulePropertyConditionSupportedPropertyHostNetBiosName, AutomationRulePropertyConditionSupportedPropertyHostNTDomain, AutomationRulePropertyConditionSupportedPropertyHostOSVersion, AutomationRulePropertyConditionSupportedPropertyIncidentDescription, AutomationRulePropertyConditionSupportedPropertyIncidentProviderName, AutomationRulePropertyConditionSupportedPropertyIncidentRelatedAnalyticRuleIds, AutomationRulePropertyConditionSupportedPropertyIncidentSeverity, AutomationRulePropertyConditionSupportedPropertyIncidentStatus, AutomationRulePropertyConditionSupportedPropertyIncidentTactics, AutomationRulePropertyConditionSupportedPropertyIncidentTitle, AutomationRulePropertyConditionSupportedPropertyIoTDeviceID, AutomationRulePropertyConditionSupportedPropertyIoTDeviceModel, AutomationRulePropertyConditionSupportedPropertyIoTDeviceName, AutomationRulePropertyConditionSupportedPropertyIoTDeviceOperatingSystem, AutomationRulePropertyConditionSupportedPropertyIoTDeviceType, AutomationRulePropertyConditionSupportedPropertyIoTDeviceVendor, AutomationRulePropertyConditionSupportedPropertyIPAddress, AutomationRulePropertyConditionSupportedPropertyMailboxDisplayName, AutomationRulePropertyConditionSupportedPropertyMailboxPrimaryAddress, AutomationRulePropertyConditionSupportedPropertyMailboxUPN, AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryAction, AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryLocation, AutomationRulePropertyConditionSupportedPropertyMailMessageP1Sender, AutomationRulePropertyConditionSupportedPropertyMailMessageP2Sender, AutomationRulePropertyConditionSupportedPropertyMailMessageRecipient, AutomationRulePropertyConditionSupportedPropertyMailMessageSenderIP, AutomationRulePropertyConditionSupportedPropertyMailMessageSubject, AutomationRulePropertyConditionSupportedPropertyMalwareCategory, AutomationRulePropertyConditionSupportedPropertyMalwareName, AutomationRulePropertyConditionSupportedPropertyProcessCommandLine, AutomationRulePropertyConditionSupportedPropertyProcessID, AutomationRulePropertyConditionSupportedPropertyRegistryKey, AutomationRulePropertyConditionSupportedPropertyRegistryValueData, AutomationRulePropertyConditionSupportedPropertyURL}
}

// CaseSeverity enumerates the values for case severity.
type CaseSeverity string

const (
	// CaseSeverityCritical Critical severity
	CaseSeverityCritical CaseSeverity = "Critical"
	// CaseSeverityHigh High severity
	CaseSeverityHigh CaseSeverity = "High"
	// CaseSeverityInformational Informational severity
	CaseSeverityInformational CaseSeverity = "Informational"
	// CaseSeverityLow Low severity
	CaseSeverityLow CaseSeverity = "Low"
	// CaseSeverityMedium Medium severity
	CaseSeverityMedium CaseSeverity = "Medium"
)

// PossibleCaseSeverityValues returns an array of possible values for the CaseSeverity const type.
func PossibleCaseSeverityValues() []CaseSeverity {
	return []CaseSeverity{CaseSeverityCritical, CaseSeverityHigh, CaseSeverityInformational, CaseSeverityLow, CaseSeverityMedium}
}

// CaseStatus enumerates the values for case status.
type CaseStatus string

const (
	// CaseStatusClosed A non active case
	CaseStatusClosed CaseStatus = "Closed"
	// CaseStatusDraft Case that wasn't promoted yet to active
	CaseStatusDraft CaseStatus = "Draft"
	// CaseStatusInProgress An active case which is handled
	CaseStatusInProgress CaseStatus = "InProgress"
	// CaseStatusNew An active case which isn't handled currently
	CaseStatusNew CaseStatus = "New"
)

// PossibleCaseStatusValues returns an array of possible values for the CaseStatus const type.
func PossibleCaseStatusValues() []CaseStatus {
	return []CaseStatus{CaseStatusClosed, CaseStatusDraft, CaseStatusInProgress, CaseStatusNew}
}

// CloseReason enumerates the values for close reason.
type CloseReason string

const (
	// CloseReasonDismissed Case was dismissed
	CloseReasonDismissed CloseReason = "Dismissed"
	// CloseReasonFalsePositive Case was false positive
	CloseReasonFalsePositive CloseReason = "FalsePositive"
	// CloseReasonOther Case was closed for another reason
	CloseReasonOther CloseReason = "Other"
	// CloseReasonResolved Case was resolved
	CloseReasonResolved CloseReason = "Resolved"
	// CloseReasonTruePositive Case was true positive
	CloseReasonTruePositive CloseReason = "TruePositive"
)

// PossibleCloseReasonValues returns an array of possible values for the CloseReason const type.
func PossibleCloseReasonValues() []CloseReason {
	return []CloseReason{CloseReasonDismissed, CloseReasonFalsePositive, CloseReasonOther, CloseReasonResolved, CloseReasonTruePositive}
}

// ConditionType enumerates the values for condition type.
type ConditionType string

const (
	// ConditionTypeConditionTypeAutomationRuleCondition ...
	ConditionTypeConditionTypeAutomationRuleCondition ConditionType = "AutomationRuleCondition"
	// ConditionTypeConditionTypeProperty ...
	ConditionTypeConditionTypeProperty ConditionType = "Property"
)

// PossibleConditionTypeValues returns an array of possible values for the ConditionType const type.
func PossibleConditionTypeValues() []ConditionType {
	return []ConditionType{ConditionTypeConditionTypeAutomationRuleCondition, ConditionTypeConditionTypeProperty}
}

// ConfidenceLevel enumerates the values for confidence level.
type ConfidenceLevel string

const (
	// ConfidenceLevelHigh High confidence that the alert is true positive malicious
	ConfidenceLevelHigh ConfidenceLevel = "High"
	// ConfidenceLevelLow Low confidence, meaning we have some doubts this is indeed malicious or part of an
	// attack
	ConfidenceLevelLow ConfidenceLevel = "Low"
	// ConfidenceLevelUnknown Unknown confidence, the is the default value
	ConfidenceLevelUnknown ConfidenceLevel = "Unknown"
)

// PossibleConfidenceLevelValues returns an array of possible values for the ConfidenceLevel const type.
func PossibleConfidenceLevelValues() []ConfidenceLevel {
	return []ConfidenceLevel{ConfidenceLevelHigh, ConfidenceLevelLow, ConfidenceLevelUnknown}
}

// ConfidenceScoreStatus enumerates the values for confidence score status.
type ConfidenceScoreStatus string

const (
	// ConfidenceScoreStatusFinal Final score was calculated and available
	ConfidenceScoreStatusFinal ConfidenceScoreStatus = "Final"
	// ConfidenceScoreStatusInProcess No score was set yet and calculation is in progress
	ConfidenceScoreStatusInProcess ConfidenceScoreStatus = "InProcess"
	// ConfidenceScoreStatusNotApplicable Score will not be calculated for this alert as it is not supported by
	// virtual analyst
	ConfidenceScoreStatusNotApplicable ConfidenceScoreStatus = "NotApplicable"
	// ConfidenceScoreStatusNotFinal Score is calculated and shown as part of the alert, but may be updated
	// again at a later time following the processing of additional data
	ConfidenceScoreStatusNotFinal ConfidenceScoreStatus = "NotFinal"
)

// PossibleConfidenceScoreStatusValues returns an array of possible values for the ConfidenceScoreStatus const type.
func PossibleConfidenceScoreStatusValues() []ConfidenceScoreStatus {
	return []ConfidenceScoreStatus{ConfidenceScoreStatusFinal, ConfidenceScoreStatusInProcess, ConfidenceScoreStatusNotApplicable, ConfidenceScoreStatusNotFinal}
}

// DataConnectorAuthorizationState enumerates the values for data connector authorization state.
type DataConnectorAuthorizationState string

const (
	// DataConnectorAuthorizationStateInvalid ...
	DataConnectorAuthorizationStateInvalid DataConnectorAuthorizationState = "Invalid"
	// DataConnectorAuthorizationStateValid ...
	DataConnectorAuthorizationStateValid DataConnectorAuthorizationState = "Valid"
)

// PossibleDataConnectorAuthorizationStateValues returns an array of possible values for the DataConnectorAuthorizationState const type.
func PossibleDataConnectorAuthorizationStateValues() []DataConnectorAuthorizationState {
	return []DataConnectorAuthorizationState{DataConnectorAuthorizationStateInvalid, DataConnectorAuthorizationStateValid}
}

// DataConnectorKind enumerates the values for data connector kind.
type DataConnectorKind string

const (
	// DataConnectorKindAmazonWebServicesCloudTrail ...
	DataConnectorKindAmazonWebServicesCloudTrail DataConnectorKind = "AmazonWebServicesCloudTrail"
	// DataConnectorKindAzureActiveDirectory ...
	DataConnectorKindAzureActiveDirectory DataConnectorKind = "AzureActiveDirectory"
	// DataConnectorKindAzureAdvancedThreatProtection ...
	DataConnectorKindAzureAdvancedThreatProtection DataConnectorKind = "AzureAdvancedThreatProtection"
	// DataConnectorKindAzureSecurityCenter ...
	DataConnectorKindAzureSecurityCenter DataConnectorKind = "AzureSecurityCenter"
	// DataConnectorKindDynamics365 ...
	DataConnectorKindDynamics365 DataConnectorKind = "Dynamics365"
	// DataConnectorKindMicrosoftCloudAppSecurity ...
	DataConnectorKindMicrosoftCloudAppSecurity DataConnectorKind = "MicrosoftCloudAppSecurity"
	// DataConnectorKindMicrosoftDefenderAdvancedThreatProtection ...
	DataConnectorKindMicrosoftDefenderAdvancedThreatProtection DataConnectorKind = "MicrosoftDefenderAdvancedThreatProtection"
	// DataConnectorKindMicrosoftThreatIntelligence ...
	DataConnectorKindMicrosoftThreatIntelligence DataConnectorKind = "MicrosoftThreatIntelligence"
	// DataConnectorKindMicrosoftThreatProtection ...
	DataConnectorKindMicrosoftThreatProtection DataConnectorKind = "MicrosoftThreatProtection"
	// DataConnectorKindOffice365 ...
	DataConnectorKindOffice365 DataConnectorKind = "Office365"
	// DataConnectorKindOfficeATP ...
	DataConnectorKindOfficeATP DataConnectorKind = "OfficeATP"
	// DataConnectorKindThreatIntelligence ...
	DataConnectorKindThreatIntelligence DataConnectorKind = "ThreatIntelligence"
	// DataConnectorKindThreatIntelligenceTaxii ...
	DataConnectorKindThreatIntelligenceTaxii DataConnectorKind = "ThreatIntelligenceTaxii"
)

// PossibleDataConnectorKindValues returns an array of possible values for the DataConnectorKind const type.
func PossibleDataConnectorKindValues() []DataConnectorKind {
	return []DataConnectorKind{DataConnectorKindAmazonWebServicesCloudTrail, DataConnectorKindAzureActiveDirectory, DataConnectorKindAzureAdvancedThreatProtection, DataConnectorKindAzureSecurityCenter, DataConnectorKindDynamics365, DataConnectorKindMicrosoftCloudAppSecurity, DataConnectorKindMicrosoftDefenderAdvancedThreatProtection, DataConnectorKindMicrosoftThreatIntelligence, DataConnectorKindMicrosoftThreatProtection, DataConnectorKindOffice365, DataConnectorKindOfficeATP, DataConnectorKindThreatIntelligence, DataConnectorKindThreatIntelligenceTaxii}
}

// DataConnectorLicenseState enumerates the values for data connector license state.
type DataConnectorLicenseState string

const (
	// DataConnectorLicenseStateInvalid ...
	DataConnectorLicenseStateInvalid DataConnectorLicenseState = "Invalid"
	// DataConnectorLicenseStateUnknown ...
	DataConnectorLicenseStateUnknown DataConnectorLicenseState = "Unknown"
	// DataConnectorLicenseStateValid ...
	DataConnectorLicenseStateValid DataConnectorLicenseState = "Valid"
)

// PossibleDataConnectorLicenseStateValues returns an array of possible values for the DataConnectorLicenseState const type.
func PossibleDataConnectorLicenseStateValues() []DataConnectorLicenseState {
	return []DataConnectorLicenseState{DataConnectorLicenseStateInvalid, DataConnectorLicenseStateUnknown, DataConnectorLicenseStateValid}
}

// DataTypeState enumerates the values for data type state.
type DataTypeState string

const (
	// DataTypeStateDisabled ...
	DataTypeStateDisabled DataTypeState = "Disabled"
	// DataTypeStateEnabled ...
	DataTypeStateEnabled DataTypeState = "Enabled"
)

// PossibleDataTypeStateValues returns an array of possible values for the DataTypeState const type.
func PossibleDataTypeStateValues() []DataTypeState {
	return []DataTypeState{DataTypeStateDisabled, DataTypeStateEnabled}
}

// DeliveryAction enumerates the values for delivery action.
type DeliveryAction string

const (
	// DeliveryActionBlocked Blocked
	DeliveryActionBlocked DeliveryAction = "Blocked"
	// DeliveryActionDelivered Delivered
	DeliveryActionDelivered DeliveryAction = "Delivered"
	// DeliveryActionDeliveredAsSpam DeliveredAsSpam
	DeliveryActionDeliveredAsSpam DeliveryAction = "DeliveredAsSpam"
	// DeliveryActionReplaced Replaced
	DeliveryActionReplaced DeliveryAction = "Replaced"
	// DeliveryActionUnknown Unknown
	DeliveryActionUnknown DeliveryAction = "Unknown"
)

// PossibleDeliveryActionValues returns an array of possible values for the DeliveryAction const type.
func PossibleDeliveryActionValues() []DeliveryAction {
	return []DeliveryAction{DeliveryActionBlocked, DeliveryActionDelivered, DeliveryActionDeliveredAsSpam, DeliveryActionReplaced, DeliveryActionUnknown}
}

// DeliveryLocation enumerates the values for delivery location.
type DeliveryLocation string

const (
	// DeliveryLocationDeletedFolder DeletedFolder
	DeliveryLocationDeletedFolder DeliveryLocation = "DeletedFolder"
	// DeliveryLocationDropped Dropped
	DeliveryLocationDropped DeliveryLocation = "Dropped"
	// DeliveryLocationExternal External
	DeliveryLocationExternal DeliveryLocation = "External"
	// DeliveryLocationFailed Failed
	DeliveryLocationFailed DeliveryLocation = "Failed"
	// DeliveryLocationForwarded Forwarded
	DeliveryLocationForwarded DeliveryLocation = "Forwarded"
	// DeliveryLocationInbox Inbox
	DeliveryLocationInbox DeliveryLocation = "Inbox"
	// DeliveryLocationJunkFolder JunkFolder
	DeliveryLocationJunkFolder DeliveryLocation = "JunkFolder"
	// DeliveryLocationQuarantine Quarantine
	DeliveryLocationQuarantine DeliveryLocation = "Quarantine"
	// DeliveryLocationUnknown Unknown
	DeliveryLocationUnknown DeliveryLocation = "Unknown"
)

// PossibleDeliveryLocationValues returns an array of possible values for the DeliveryLocation const type.
func PossibleDeliveryLocationValues() []DeliveryLocation {
	return []DeliveryLocation{DeliveryLocationDeletedFolder, DeliveryLocationDropped, DeliveryLocationExternal, DeliveryLocationFailed, DeliveryLocationForwarded, DeliveryLocationInbox, DeliveryLocationJunkFolder, DeliveryLocationQuarantine, DeliveryLocationUnknown}
}

// ElevationToken enumerates the values for elevation token.
type ElevationToken string

const (
	// ElevationTokenDefault Default elevation token
	ElevationTokenDefault ElevationToken = "Default"
	// ElevationTokenFull Full elevation token
	ElevationTokenFull ElevationToken = "Full"
	// ElevationTokenLimited Limited elevation token
	ElevationTokenLimited ElevationToken = "Limited"
)

// PossibleElevationTokenValues returns an array of possible values for the ElevationToken const type.
func PossibleElevationTokenValues() []ElevationToken {
	return []ElevationToken{ElevationTokenDefault, ElevationTokenFull, ElevationTokenLimited}
}

// EntitiesMatchingMethod enumerates the values for entities matching method.
type EntitiesMatchingMethod string

const (
	// EntitiesMatchingMethodAll Grouping alerts into a single incident if all the entities match
	EntitiesMatchingMethodAll EntitiesMatchingMethod = "All"
	// EntitiesMatchingMethodCustom Grouping alerts into a single incident if the selected entities match
	EntitiesMatchingMethodCustom EntitiesMatchingMethod = "Custom"
	// EntitiesMatchingMethodNone Grouping all alerts triggered by this rule into a single incident
	EntitiesMatchingMethodNone EntitiesMatchingMethod = "None"
)

// PossibleEntitiesMatchingMethodValues returns an array of possible values for the EntitiesMatchingMethod const type.
func PossibleEntitiesMatchingMethodValues() []EntitiesMatchingMethod {
	return []EntitiesMatchingMethod{EntitiesMatchingMethodAll, EntitiesMatchingMethodCustom, EntitiesMatchingMethodNone}
}

// EntityKind enumerates the values for entity kind.
type EntityKind string

const (
	// EntityKindAccount Entity represents account in the system.
	EntityKindAccount EntityKind = "Account"
	// EntityKindAzureResource Entity represents azure resource in the system.
	EntityKindAzureResource EntityKind = "AzureResource"
	// EntityKindBookmark Entity represents bookmark in the system.
	EntityKindBookmark EntityKind = "Bookmark"
	// EntityKindCloudApplication Entity represents cloud application in the system.
	EntityKindCloudApplication EntityKind = "CloudApplication"
	// EntityKindDNSResolution Entity represents dns resolution in the system.
	EntityKindDNSResolution EntityKind = "DnsResolution"
	// EntityKindFile Entity represents file in the system.
	EntityKindFile EntityKind = "File"
	// EntityKindFileHash Entity represents file hash in the system.
	EntityKindFileHash EntityKind = "FileHash"
	// EntityKindHost Entity represents host in the system.
	EntityKindHost EntityKind = "Host"
	// EntityKindIoTDevice Entity represents IoT device in the system.
	EntityKindIoTDevice EntityKind = "IoTDevice"
	// EntityKindIP Entity represents ip in the system.
	EntityKindIP EntityKind = "Ip"
	// EntityKindMailbox Entity represents mailbox in the system.
	EntityKindMailbox EntityKind = "Mailbox"
	// EntityKindMailCluster Entity represents mail cluster in the system.
	EntityKindMailCluster EntityKind = "MailCluster"
	// EntityKindMailMessage Entity represents mail message in the system.
	EntityKindMailMessage EntityKind = "MailMessage"
	// EntityKindMalware Entity represents malware in the system.
	EntityKindMalware EntityKind = "Malware"
	// EntityKindProcess Entity represents process in the system.
	EntityKindProcess EntityKind = "Process"
	// EntityKindRegistryKey Entity represents registry key in the system.
	EntityKindRegistryKey EntityKind = "RegistryKey"
	// EntityKindRegistryValue Entity represents registry value in the system.
	EntityKindRegistryValue EntityKind = "RegistryValue"
	// EntityKindSecurityAlert Entity represents security alert in the system.
	EntityKindSecurityAlert EntityKind = "SecurityAlert"
	// EntityKindSecurityGroup Entity represents security group in the system.
	EntityKindSecurityGroup EntityKind = "SecurityGroup"
	// EntityKindSubmissionMail Entity represents submission mail in the system.
	EntityKindSubmissionMail EntityKind = "SubmissionMail"
	// EntityKindURL Entity represents url in the system.
	EntityKindURL EntityKind = "Url"
)

// PossibleEntityKindValues returns an array of possible values for the EntityKind const type.
func PossibleEntityKindValues() []EntityKind {
	return []EntityKind{EntityKindAccount, EntityKindAzureResource, EntityKindBookmark, EntityKindCloudApplication, EntityKindDNSResolution, EntityKindFile, EntityKindFileHash, EntityKindHost, EntityKindIoTDevice, EntityKindIP, EntityKindMailbox, EntityKindMailCluster, EntityKindMailMessage, EntityKindMalware, EntityKindProcess, EntityKindRegistryKey, EntityKindRegistryValue, EntityKindSecurityAlert, EntityKindSecurityGroup, EntityKindSubmissionMail, EntityKindURL}
}

// EntityQueryKind enumerates the values for entity query kind.
type EntityQueryKind string

const (
	// EntityQueryKindExpansion ...
	EntityQueryKindExpansion EntityQueryKind = "Expansion"
	// EntityQueryKindInsight ...
	EntityQueryKindInsight EntityQueryKind = "Insight"
)

// PossibleEntityQueryKindValues returns an array of possible values for the EntityQueryKind const type.
func PossibleEntityQueryKindValues() []EntityQueryKind {
	return []EntityQueryKind{EntityQueryKindExpansion, EntityQueryKindInsight}
}

// EntityTimelineKind enumerates the values for entity timeline kind.
type EntityTimelineKind string

const (
	// EntityTimelineKindActivity activity
	EntityTimelineKindActivity EntityTimelineKind = "Activity"
	// EntityTimelineKindBookmark bookmarks
	EntityTimelineKindBookmark EntityTimelineKind = "Bookmark"
	// EntityTimelineKindSecurityAlert security alerts
	EntityTimelineKindSecurityAlert EntityTimelineKind = "SecurityAlert"
)

// PossibleEntityTimelineKindValues returns an array of possible values for the EntityTimelineKind const type.
func PossibleEntityTimelineKindValues() []EntityTimelineKind {
	return []EntityTimelineKind{EntityTimelineKindActivity, EntityTimelineKindBookmark, EntityTimelineKindSecurityAlert}
}

// EntityType enumerates the values for entity type.
type EntityType string

const (
	// EntityTypeAccount Entity represents account in the system.
	EntityTypeAccount EntityType = "Account"
	// EntityTypeAzureResource Entity represents azure resource in the system.
	EntityTypeAzureResource EntityType = "AzureResource"
	// EntityTypeCloudApplication Entity represents cloud application in the system.
	EntityTypeCloudApplication EntityType = "CloudApplication"
	// EntityTypeDNS Entity represents dns in the system.
	EntityTypeDNS EntityType = "DNS"
	// EntityTypeFile Entity represents file in the system.
	EntityTypeFile EntityType = "File"
	// EntityTypeFileHash Entity represents file hash in the system.
	EntityTypeFileHash EntityType = "FileHash"
	// EntityTypeHost Entity represents host in the system.
	EntityTypeHost EntityType = "Host"
	// EntityTypeHuntingBookmark Entity represents HuntingBookmark in the system.
	EntityTypeHuntingBookmark EntityType = "HuntingBookmark"
	// EntityTypeIoTDevice Entity represents IoT device in the system.
	EntityTypeIoTDevice EntityType = "IoTDevice"
	// EntityTypeIP Entity represents ip in the system.
	EntityTypeIP EntityType = "IP"
	// EntityTypeMailbox Entity represents mailbox in the system.
	EntityTypeMailbox EntityType = "Mailbox"
	// EntityTypeMailCluster Entity represents mail cluster in the system.
	EntityTypeMailCluster EntityType = "MailCluster"
	// EntityTypeMailMessage Entity represents mail message in the system.
	EntityTypeMailMessage EntityType = "MailMessage"
	// EntityTypeMalware Entity represents malware in the system.
	EntityTypeMalware EntityType = "Malware"
	// EntityTypeProcess Entity represents process in the system.
	EntityTypeProcess EntityType = "Process"
	// EntityTypeRegistryKey Entity represents registry key in the system.
	EntityTypeRegistryKey EntityType = "RegistryKey"
	// EntityTypeRegistryValue Entity represents registry value in the system.
	EntityTypeRegistryValue EntityType = "RegistryValue"
	// EntityTypeSecurityAlert Entity represents security alert in the system.
	EntityTypeSecurityAlert EntityType = "SecurityAlert"
	// EntityTypeSecurityGroup Entity represents security group in the system.
	EntityTypeSecurityGroup EntityType = "SecurityGroup"
	// EntityTypeSubmissionMail Entity represents submission mail in the system.
	EntityTypeSubmissionMail EntityType = "SubmissionMail"
	// EntityTypeURL Entity represents url in the system.
	EntityTypeURL EntityType = "URL"
)

// PossibleEntityTypeValues returns an array of possible values for the EntityType const type.
func PossibleEntityTypeValues() []EntityType {
	return []EntityType{EntityTypeAccount, EntityTypeAzureResource, EntityTypeCloudApplication, EntityTypeDNS, EntityTypeFile, EntityTypeFileHash, EntityTypeHost, EntityTypeHuntingBookmark, EntityTypeIoTDevice, EntityTypeIP, EntityTypeMailbox, EntityTypeMailCluster, EntityTypeMailMessage, EntityTypeMalware, EntityTypeProcess, EntityTypeRegistryKey, EntityTypeRegistryValue, EntityTypeSecurityAlert, EntityTypeSecurityGroup, EntityTypeSubmissionMail, EntityTypeURL}
}

// EventGroupingAggregationKind enumerates the values for event grouping aggregation kind.
type EventGroupingAggregationKind string

const (
	// EventGroupingAggregationKindAlertPerResult ...
	EventGroupingAggregationKindAlertPerResult EventGroupingAggregationKind = "AlertPerResult"
	// EventGroupingAggregationKindSingleAlert ...
	EventGroupingAggregationKindSingleAlert EventGroupingAggregationKind = "SingleAlert"
)

// PossibleEventGroupingAggregationKindValues returns an array of possible values for the EventGroupingAggregationKind const type.
func PossibleEventGroupingAggregationKindValues() []EventGroupingAggregationKind {
	return []EventGroupingAggregationKind{EventGroupingAggregationKindAlertPerResult, EventGroupingAggregationKindSingleAlert}
}

// FileHashAlgorithm enumerates the values for file hash algorithm.
type FileHashAlgorithm string

const (
	// FileHashAlgorithmMD5 MD5 hash type
	FileHashAlgorithmMD5 FileHashAlgorithm = "MD5"
	// FileHashAlgorithmSHA1 SHA1 hash type
	FileHashAlgorithmSHA1 FileHashAlgorithm = "SHA1"
	// FileHashAlgorithmSHA256 SHA256 hash type
	FileHashAlgorithmSHA256 FileHashAlgorithm = "SHA256"
	// FileHashAlgorithmSHA256AC SHA256 Authenticode hash type
	FileHashAlgorithmSHA256AC FileHashAlgorithm = "SHA256AC"
	// FileHashAlgorithmUnknown Unknown hash algorithm
	FileHashAlgorithmUnknown FileHashAlgorithm = "Unknown"
)

// PossibleFileHashAlgorithmValues returns an array of possible values for the FileHashAlgorithm const type.
func PossibleFileHashAlgorithmValues() []FileHashAlgorithm {
	return []FileHashAlgorithm{FileHashAlgorithmMD5, FileHashAlgorithmSHA1, FileHashAlgorithmSHA256, FileHashAlgorithmSHA256AC, FileHashAlgorithmUnknown}
}

// GroupingEntityType enumerates the values for grouping entity type.
type GroupingEntityType string

const (
	// GroupingEntityTypeAccount Account entity
	GroupingEntityTypeAccount GroupingEntityType = "Account"
	// GroupingEntityTypeFileHash FileHash entity
	GroupingEntityTypeFileHash GroupingEntityType = "FileHash"
	// GroupingEntityTypeHost Host entity
	GroupingEntityTypeHost GroupingEntityType = "Host"
	// GroupingEntityTypeIP Ip entity
	GroupingEntityTypeIP GroupingEntityType = "Ip"
	// GroupingEntityTypeURL Url entity
	GroupingEntityTypeURL GroupingEntityType = "Url"
)

// PossibleGroupingEntityTypeValues returns an array of possible values for the GroupingEntityType const type.
func PossibleGroupingEntityTypeValues() []GroupingEntityType {
	return []GroupingEntityType{GroupingEntityTypeAccount, GroupingEntityTypeFileHash, GroupingEntityTypeHost, GroupingEntityTypeIP, GroupingEntityTypeURL}
}

// IncidentClassification enumerates the values for incident classification.
type IncidentClassification string

const (
	// IncidentClassificationBenignPositive Incident was benign positive
	IncidentClassificationBenignPositive IncidentClassification = "BenignPositive"
	// IncidentClassificationFalsePositive Incident was false positive
	IncidentClassificationFalsePositive IncidentClassification = "FalsePositive"
	// IncidentClassificationTruePositive Incident was true positive
	IncidentClassificationTruePositive IncidentClassification = "TruePositive"
	// IncidentClassificationUndetermined Incident classification was undetermined
	IncidentClassificationUndetermined IncidentClassification = "Undetermined"
)

// PossibleIncidentClassificationValues returns an array of possible values for the IncidentClassification const type.
func PossibleIncidentClassificationValues() []IncidentClassification {
	return []IncidentClassification{IncidentClassificationBenignPositive, IncidentClassificationFalsePositive, IncidentClassificationTruePositive, IncidentClassificationUndetermined}
}

// IncidentClassificationReason enumerates the values for incident classification reason.
type IncidentClassificationReason string

const (
	// IncidentClassificationReasonInaccurateData Classification reason was inaccurate data
	IncidentClassificationReasonInaccurateData IncidentClassificationReason = "InaccurateData"
	// IncidentClassificationReasonIncorrectAlertLogic Classification reason was incorrect alert logic
	IncidentClassificationReasonIncorrectAlertLogic IncidentClassificationReason = "IncorrectAlertLogic"
	// IncidentClassificationReasonSuspiciousActivity Classification reason was suspicious activity
	IncidentClassificationReasonSuspiciousActivity IncidentClassificationReason = "SuspiciousActivity"
	// IncidentClassificationReasonSuspiciousButExpected Classification reason was suspicious but expected
	IncidentClassificationReasonSuspiciousButExpected IncidentClassificationReason = "SuspiciousButExpected"
)

// PossibleIncidentClassificationReasonValues returns an array of possible values for the IncidentClassificationReason const type.
func PossibleIncidentClassificationReasonValues() []IncidentClassificationReason {
	return []IncidentClassificationReason{IncidentClassificationReasonInaccurateData, IncidentClassificationReasonIncorrectAlertLogic, IncidentClassificationReasonSuspiciousActivity, IncidentClassificationReasonSuspiciousButExpected}
}

// IncidentLabelType enumerates the values for incident label type.
type IncidentLabelType string

const (
	// IncidentLabelTypeSystem Label automatically created by the system
	IncidentLabelTypeSystem IncidentLabelType = "System"
	// IncidentLabelTypeUser Label manually created by a user
	IncidentLabelTypeUser IncidentLabelType = "User"
)

// PossibleIncidentLabelTypeValues returns an array of possible values for the IncidentLabelType const type.
func PossibleIncidentLabelTypeValues() []IncidentLabelType {
	return []IncidentLabelType{IncidentLabelTypeSystem, IncidentLabelTypeUser}
}

// IncidentSeverity enumerates the values for incident severity.
type IncidentSeverity string

const (
	// IncidentSeverityHigh High severity
	IncidentSeverityHigh IncidentSeverity = "High"
	// IncidentSeverityInformational Informational severity
	IncidentSeverityInformational IncidentSeverity = "Informational"
	// IncidentSeverityLow Low severity
	IncidentSeverityLow IncidentSeverity = "Low"
	// IncidentSeverityMedium Medium severity
	IncidentSeverityMedium IncidentSeverity = "Medium"
)

// PossibleIncidentSeverityValues returns an array of possible values for the IncidentSeverity const type.
func PossibleIncidentSeverityValues() []IncidentSeverity {
	return []IncidentSeverity{IncidentSeverityHigh, IncidentSeverityInformational, IncidentSeverityLow, IncidentSeverityMedium}
}

// IncidentStatus enumerates the values for incident status.
type IncidentStatus string

const (
	// IncidentStatusActive An active incident which is being handled
	IncidentStatusActive IncidentStatus = "Active"
	// IncidentStatusClosed A non-active incident
	IncidentStatusClosed IncidentStatus = "Closed"
	// IncidentStatusNew An active incident which isn't being handled currently
	IncidentStatusNew IncidentStatus = "New"
)

// PossibleIncidentStatusValues returns an array of possible values for the IncidentStatus const type.
func PossibleIncidentStatusValues() []IncidentStatus {
	return []IncidentStatus{IncidentStatusActive, IncidentStatusClosed, IncidentStatusNew}
}

// KillChainIntent enumerates the values for kill chain intent.
type KillChainIntent string

const (
	// KillChainIntentCollection Collection consists of techniques used to identify and gather information,
	// such as sensitive files, from a target network prior to exfiltration. This category also covers
	// locations on a system or network where the adversary may look for information to exfiltrate.
	KillChainIntentCollection KillChainIntent = "Collection"
	// KillChainIntentCommandAndControl The command and control tactic represents how adversaries communicate
	// with systems under their control within a target network.
	KillChainIntentCommandAndControl KillChainIntent = "CommandAndControl"
	// KillChainIntentCredentialAccess Credential access represents techniques resulting in access to or
	// control over system, domain, or service credentials that are used within an enterprise environment.
	// Adversaries will likely attempt to obtain legitimate credentials from users or administrator accounts
	// (local system administrator or domain users with administrator access) to use within the network. With
	// sufficient access within a network, an adversary can create accounts for later use within the
	// environment.
	KillChainIntentCredentialAccess KillChainIntent = "CredentialAccess"
	// KillChainIntentDefenseEvasion Defense evasion consists of techniques an adversary may use to evade
	// detection or avoid other defenses. Sometimes these actions are the same as or variations of techniques
	// in other categories that have the added benefit of subverting a particular defense or mitigation.
	KillChainIntentDefenseEvasion KillChainIntent = "DefenseEvasion"
	// KillChainIntentDiscovery Discovery consists of techniques that allow the adversary to gain knowledge
	// about the system and internal network. When adversaries gain access to a new system, they must orient
	// themselves to what they now have control of and what benefits operating from that system give to their
	// current objective or overall goals during the intrusion. The operating system provides many native tools
	// that aid in this post-compromise information-gathering phase.
	KillChainIntentDiscovery KillChainIntent = "Discovery"
	// KillChainIntentExecution The execution tactic represents techniques that result in execution of
	// adversary-controlled code on a local or remote system. This tactic is often used in conjunction with
	// lateral movement to expand access to remote systems on a network.
	KillChainIntentExecution KillChainIntent = "Execution"
	// KillChainIntentExfiltration Exfiltration refers to techniques and attributes that result or aid in the
	// adversary removing files and information from a target network. This category also covers locations on a
	// system or network where the adversary may look for information to exfiltrate.
	KillChainIntentExfiltration KillChainIntent = "Exfiltration"
	// KillChainIntentExploitation Exploitation is the stage where an attacker manage to get foothold on the
	// attacked resource. This stage is applicable not only for compute hosts, but also for resources such as
	// user accounts, certificates etc. Adversaries will often be able to control the resource after this
	// stage.
	KillChainIntentExploitation KillChainIntent = "Exploitation"
	// KillChainIntentImpact The impact intent primary objective is to directly reduce the availability or
	// integrity of a system, service, or network; including manipulation of data to impact a business or
	// operational process. This would often refer to techniques such as ransom-ware, defacement, data
	// manipulation and others.
	KillChainIntentImpact KillChainIntent = "Impact"
	// KillChainIntentLateralMovement Lateral movement consists of techniques that enable an adversary to
	// access and control remote systems on a network and could, but does not necessarily, include execution of
	// tools on remote systems. The lateral movement techniques could allow an adversary to gather information
	// from a system without needing additional tools, such as a remote access tool. An adversary can use
	// lateral movement for many purposes, including remote Execution of tools, pivoting to additional systems,
	// access to specific information or files, access to additional credentials, or to cause an effect.
	KillChainIntentLateralMovement KillChainIntent = "LateralMovement"
	// KillChainIntentPersistence Persistence is any access, action, or configuration change to a system that
	// gives an adversary a persistent presence on that system. Adversaries will often need to maintain access
	// to systems through interruptions such as system restarts, loss of credentials, or other failures that
	// would require a remote access tool to restart or alternate backdoor for them to regain access.
	KillChainIntentPersistence KillChainIntent = "Persistence"
	// KillChainIntentPrivilegeEscalation Privilege escalation is the result of actions that allow an adversary
	// to obtain a higher level of permissions on a system or network. Certain tools or actions require a
	// higher level of privilege to work and are likely necessary at many points throughout an operation. User
	// accounts with permissions to access specific systems or perform specific functions necessary for
	// adversaries to achieve their objective may also be considered an escalation of privilege.
	KillChainIntentPrivilegeEscalation KillChainIntent = "PrivilegeEscalation"
	// KillChainIntentProbing Probing could be an attempt to access a certain resource regardless of a
	// malicious intent or a failed attempt to gain access to a target system to gather information prior to
	// exploitation. This step is usually detected as an attempt originating from outside the network in
	// attempt to scan the target system and find a way in.
	KillChainIntentProbing KillChainIntent = "Probing"
	// KillChainIntentUnknown The default value.
	KillChainIntentUnknown KillChainIntent = "Unknown"
)

// PossibleKillChainIntentValues returns an array of possible values for the KillChainIntent const type.
func PossibleKillChainIntentValues() []KillChainIntent {
	return []KillChainIntent{KillChainIntentCollection, KillChainIntentCommandAndControl, KillChainIntentCredentialAccess, KillChainIntentDefenseEvasion, KillChainIntentDiscovery, KillChainIntentExecution, KillChainIntentExfiltration, KillChainIntentExploitation, KillChainIntentImpact, KillChainIntentLateralMovement, KillChainIntentPersistence, KillChainIntentPrivilegeEscalation, KillChainIntentProbing, KillChainIntentUnknown}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindKindAggregations ...
	KindKindAggregations Kind = "Aggregations"
	// KindKindCasesAggregation ...
	KindKindCasesAggregation Kind = "CasesAggregation"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindKindAggregations, KindKindCasesAggregation}
}

// KindBasicAlertRule enumerates the values for kind basic alert rule.
type KindBasicAlertRule string

const (
	// KindBasicAlertRuleKindAlertRule ...
	KindBasicAlertRuleKindAlertRule KindBasicAlertRule = "AlertRule"
	// KindBasicAlertRuleKindFusion ...
	KindBasicAlertRuleKindFusion KindBasicAlertRule = "Fusion"
	// KindBasicAlertRuleKindMicrosoftSecurityIncidentCreation ...
	KindBasicAlertRuleKindMicrosoftSecurityIncidentCreation KindBasicAlertRule = "MicrosoftSecurityIncidentCreation"
	// KindBasicAlertRuleKindMLBehaviorAnalytics ...
	KindBasicAlertRuleKindMLBehaviorAnalytics KindBasicAlertRule = "MLBehaviorAnalytics"
	// KindBasicAlertRuleKindScheduled ...
	KindBasicAlertRuleKindScheduled KindBasicAlertRule = "Scheduled"
	// KindBasicAlertRuleKindThreatIntelligence ...
	KindBasicAlertRuleKindThreatIntelligence KindBasicAlertRule = "ThreatIntelligence"
)

// PossibleKindBasicAlertRuleValues returns an array of possible values for the KindBasicAlertRule const type.
func PossibleKindBasicAlertRuleValues() []KindBasicAlertRule {
	return []KindBasicAlertRule{KindBasicAlertRuleKindAlertRule, KindBasicAlertRuleKindFusion, KindBasicAlertRuleKindMicrosoftSecurityIncidentCreation, KindBasicAlertRuleKindMLBehaviorAnalytics, KindBasicAlertRuleKindScheduled, KindBasicAlertRuleKindThreatIntelligence}
}

// KindBasicAlertRuleTemplate enumerates the values for kind basic alert rule template.
type KindBasicAlertRuleTemplate string

const (
	// KindBasicAlertRuleTemplateKindAlertRuleTemplate ...
	KindBasicAlertRuleTemplateKindAlertRuleTemplate KindBasicAlertRuleTemplate = "AlertRuleTemplate"
	// KindBasicAlertRuleTemplateKindFusion ...
	KindBasicAlertRuleTemplateKindFusion KindBasicAlertRuleTemplate = "Fusion"
	// KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation ...
	KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation KindBasicAlertRuleTemplate = "MicrosoftSecurityIncidentCreation"
	// KindBasicAlertRuleTemplateKindMLBehaviorAnalytics ...
	KindBasicAlertRuleTemplateKindMLBehaviorAnalytics KindBasicAlertRuleTemplate = "MLBehaviorAnalytics"
	// KindBasicAlertRuleTemplateKindScheduled ...
	KindBasicAlertRuleTemplateKindScheduled KindBasicAlertRuleTemplate = "Scheduled"
	// KindBasicAlertRuleTemplateKindThreatIntelligence ...
	KindBasicAlertRuleTemplateKindThreatIntelligence KindBasicAlertRuleTemplate = "ThreatIntelligence"
)

// PossibleKindBasicAlertRuleTemplateValues returns an array of possible values for the KindBasicAlertRuleTemplate const type.
func PossibleKindBasicAlertRuleTemplateValues() []KindBasicAlertRuleTemplate {
	return []KindBasicAlertRuleTemplate{KindBasicAlertRuleTemplateKindAlertRuleTemplate, KindBasicAlertRuleTemplateKindFusion, KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation, KindBasicAlertRuleTemplateKindMLBehaviorAnalytics, KindBasicAlertRuleTemplateKindScheduled, KindBasicAlertRuleTemplateKindThreatIntelligence}
}

// KindBasicDataConnector enumerates the values for kind basic data connector.
type KindBasicDataConnector string

const (
	// KindBasicDataConnectorKindAmazonWebServicesCloudTrail ...
	KindBasicDataConnectorKindAmazonWebServicesCloudTrail KindBasicDataConnector = "AmazonWebServicesCloudTrail"
	// KindBasicDataConnectorKindAzureActiveDirectory ...
	KindBasicDataConnectorKindAzureActiveDirectory KindBasicDataConnector = "AzureActiveDirectory"
	// KindBasicDataConnectorKindAzureAdvancedThreatProtection ...
	KindBasicDataConnectorKindAzureAdvancedThreatProtection KindBasicDataConnector = "AzureAdvancedThreatProtection"
	// KindBasicDataConnectorKindAzureSecurityCenter ...
	KindBasicDataConnectorKindAzureSecurityCenter KindBasicDataConnector = "AzureSecurityCenter"
	// KindBasicDataConnectorKindDataConnector ...
	KindBasicDataConnectorKindDataConnector KindBasicDataConnector = "DataConnector"
	// KindBasicDataConnectorKindDynamics365 ...
	KindBasicDataConnectorKindDynamics365 KindBasicDataConnector = "Dynamics365"
	// KindBasicDataConnectorKindMicrosoftCloudAppSecurity ...
	KindBasicDataConnectorKindMicrosoftCloudAppSecurity KindBasicDataConnector = "MicrosoftCloudAppSecurity"
	// KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection ...
	KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection KindBasicDataConnector = "MicrosoftDefenderAdvancedThreatProtection"
	// KindBasicDataConnectorKindMicrosoftThreatIntelligence ...
	KindBasicDataConnectorKindMicrosoftThreatIntelligence KindBasicDataConnector = "MicrosoftThreatIntelligence"
	// KindBasicDataConnectorKindMicrosoftThreatProtection ...
	KindBasicDataConnectorKindMicrosoftThreatProtection KindBasicDataConnector = "MicrosoftThreatProtection"
	// KindBasicDataConnectorKindOffice365 ...
	KindBasicDataConnectorKindOffice365 KindBasicDataConnector = "Office365"
	// KindBasicDataConnectorKindOfficeATP ...
	KindBasicDataConnectorKindOfficeATP KindBasicDataConnector = "OfficeATP"
	// KindBasicDataConnectorKindThreatIntelligence ...
	KindBasicDataConnectorKindThreatIntelligence KindBasicDataConnector = "ThreatIntelligence"
	// KindBasicDataConnectorKindThreatIntelligenceTaxii ...
	KindBasicDataConnectorKindThreatIntelligenceTaxii KindBasicDataConnector = "ThreatIntelligenceTaxii"
)

// PossibleKindBasicDataConnectorValues returns an array of possible values for the KindBasicDataConnector const type.
func PossibleKindBasicDataConnectorValues() []KindBasicDataConnector {
	return []KindBasicDataConnector{KindBasicDataConnectorKindAmazonWebServicesCloudTrail, KindBasicDataConnectorKindAzureActiveDirectory, KindBasicDataConnectorKindAzureAdvancedThreatProtection, KindBasicDataConnectorKindAzureSecurityCenter, KindBasicDataConnectorKindDataConnector, KindBasicDataConnectorKindDynamics365, KindBasicDataConnectorKindMicrosoftCloudAppSecurity, KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection, KindBasicDataConnectorKindMicrosoftThreatIntelligence, KindBasicDataConnectorKindMicrosoftThreatProtection, KindBasicDataConnectorKindOffice365, KindBasicDataConnectorKindOfficeATP, KindBasicDataConnectorKindThreatIntelligence, KindBasicDataConnectorKindThreatIntelligenceTaxii}
}

// KindBasicDataConnectorsCheckRequirements enumerates the values for kind basic data connectors check
// requirements.
type KindBasicDataConnectorsCheckRequirements string

const (
	// KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail ...
	KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail KindBasicDataConnectorsCheckRequirements = "AmazonWebServicesCloudTrail"
	// KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory ...
	KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory KindBasicDataConnectorsCheckRequirements = "AzureActiveDirectory"
	// KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection ...
	KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection KindBasicDataConnectorsCheckRequirements = "AzureAdvancedThreatProtection"
	// KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter ...
	KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter KindBasicDataConnectorsCheckRequirements = "AzureSecurityCenter"
	// KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements ...
	KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements KindBasicDataConnectorsCheckRequirements = "DataConnectorsCheckRequirements"
	// KindBasicDataConnectorsCheckRequirementsKindDynamics365 ...
	KindBasicDataConnectorsCheckRequirementsKindDynamics365 KindBasicDataConnectorsCheckRequirements = "Dynamics365"
	// KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity ...
	KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity KindBasicDataConnectorsCheckRequirements = "MicrosoftCloudAppSecurity"
	// KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection ...
	KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection KindBasicDataConnectorsCheckRequirements = "MicrosoftDefenderAdvancedThreatProtection"
	// KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence ...
	KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence KindBasicDataConnectorsCheckRequirements = "MicrosoftThreatIntelligence"
	// KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection ...
	KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection KindBasicDataConnectorsCheckRequirements = "MicrosoftThreatProtection"
	// KindBasicDataConnectorsCheckRequirementsKindOfficeATP ...
	KindBasicDataConnectorsCheckRequirementsKindOfficeATP KindBasicDataConnectorsCheckRequirements = "OfficeATP"
	// KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence ...
	KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence KindBasicDataConnectorsCheckRequirements = "ThreatIntelligence"
	// KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii ...
	KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii KindBasicDataConnectorsCheckRequirements = "ThreatIntelligenceTaxii"
)

// PossibleKindBasicDataConnectorsCheckRequirementsValues returns an array of possible values for the KindBasicDataConnectorsCheckRequirements const type.
func PossibleKindBasicDataConnectorsCheckRequirementsValues() []KindBasicDataConnectorsCheckRequirements {
	return []KindBasicDataConnectorsCheckRequirements{KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail, KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory, KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection, KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter, KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements, KindBasicDataConnectorsCheckRequirementsKindDynamics365, KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity, KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection, KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence, KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection, KindBasicDataConnectorsCheckRequirementsKindOfficeATP, KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence, KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii}
}

// KindBasicEntity enumerates the values for kind basic entity.
type KindBasicEntity string

const (
	// KindBasicEntityKindAccount ...
	KindBasicEntityKindAccount KindBasicEntity = "Account"
	// KindBasicEntityKindAzureResource ...
	KindBasicEntityKindAzureResource KindBasicEntity = "AzureResource"
	// KindBasicEntityKindBookmark ...
	KindBasicEntityKindBookmark KindBasicEntity = "Bookmark"
	// KindBasicEntityKindCloudApplication ...
	KindBasicEntityKindCloudApplication KindBasicEntity = "CloudApplication"
	// KindBasicEntityKindDNSResolution ...
	KindBasicEntityKindDNSResolution KindBasicEntity = "DnsResolution"
	// KindBasicEntityKindEntity ...
	KindBasicEntityKindEntity KindBasicEntity = "Entity"
	// KindBasicEntityKindFile ...
	KindBasicEntityKindFile KindBasicEntity = "File"
	// KindBasicEntityKindFileHash ...
	KindBasicEntityKindFileHash KindBasicEntity = "FileHash"
	// KindBasicEntityKindHost ...
	KindBasicEntityKindHost KindBasicEntity = "Host"
	// KindBasicEntityKindIoTDevice ...
	KindBasicEntityKindIoTDevice KindBasicEntity = "IoTDevice"
	// KindBasicEntityKindIP ...
	KindBasicEntityKindIP KindBasicEntity = "Ip"
	// KindBasicEntityKindMailbox ...
	KindBasicEntityKindMailbox KindBasicEntity = "Mailbox"
	// KindBasicEntityKindMailCluster ...
	KindBasicEntityKindMailCluster KindBasicEntity = "MailCluster"
	// KindBasicEntityKindMailMessage ...
	KindBasicEntityKindMailMessage KindBasicEntity = "MailMessage"
	// KindBasicEntityKindMalware ...
	KindBasicEntityKindMalware KindBasicEntity = "Malware"
	// KindBasicEntityKindProcess ...
	KindBasicEntityKindProcess KindBasicEntity = "Process"
	// KindBasicEntityKindRegistryKey ...
	KindBasicEntityKindRegistryKey KindBasicEntity = "RegistryKey"
	// KindBasicEntityKindRegistryValue ...
	KindBasicEntityKindRegistryValue KindBasicEntity = "RegistryValue"
	// KindBasicEntityKindSecurityAlert ...
	KindBasicEntityKindSecurityAlert KindBasicEntity = "SecurityAlert"
	// KindBasicEntityKindSecurityGroup ...
	KindBasicEntityKindSecurityGroup KindBasicEntity = "SecurityGroup"
	// KindBasicEntityKindSubmissionMail ...
	KindBasicEntityKindSubmissionMail KindBasicEntity = "SubmissionMail"
	// KindBasicEntityKindURL ...
	KindBasicEntityKindURL KindBasicEntity = "Url"
)

// PossibleKindBasicEntityValues returns an array of possible values for the KindBasicEntity const type.
func PossibleKindBasicEntityValues() []KindBasicEntity {
	return []KindBasicEntity{KindBasicEntityKindAccount, KindBasicEntityKindAzureResource, KindBasicEntityKindBookmark, KindBasicEntityKindCloudApplication, KindBasicEntityKindDNSResolution, KindBasicEntityKindEntity, KindBasicEntityKindFile, KindBasicEntityKindFileHash, KindBasicEntityKindHost, KindBasicEntityKindIoTDevice, KindBasicEntityKindIP, KindBasicEntityKindMailbox, KindBasicEntityKindMailCluster, KindBasicEntityKindMailMessage, KindBasicEntityKindMalware, KindBasicEntityKindProcess, KindBasicEntityKindRegistryKey, KindBasicEntityKindRegistryValue, KindBasicEntityKindSecurityAlert, KindBasicEntityKindSecurityGroup, KindBasicEntityKindSubmissionMail, KindBasicEntityKindURL}
}

// KindBasicEntityQuery enumerates the values for kind basic entity query.
type KindBasicEntityQuery string

const (
	// KindBasicEntityQueryKindEntityQuery ...
	KindBasicEntityQueryKindEntityQuery KindBasicEntityQuery = "EntityQuery"
	// KindBasicEntityQueryKindExpansion ...
	KindBasicEntityQueryKindExpansion KindBasicEntityQuery = "Expansion"
)

// PossibleKindBasicEntityQueryValues returns an array of possible values for the KindBasicEntityQuery const type.
func PossibleKindBasicEntityQueryValues() []KindBasicEntityQuery {
	return []KindBasicEntityQuery{KindBasicEntityQueryKindEntityQuery, KindBasicEntityQueryKindExpansion}
}

// KindBasicEntityTimelineItem enumerates the values for kind basic entity timeline item.
type KindBasicEntityTimelineItem string

const (
	// KindBasicEntityTimelineItemKindActivity ...
	KindBasicEntityTimelineItemKindActivity KindBasicEntityTimelineItem = "Activity"
	// KindBasicEntityTimelineItemKindBookmark ...
	KindBasicEntityTimelineItemKindBookmark KindBasicEntityTimelineItem = "Bookmark"
	// KindBasicEntityTimelineItemKindEntityTimelineItem ...
	KindBasicEntityTimelineItemKindEntityTimelineItem KindBasicEntityTimelineItem = "EntityTimelineItem"
	// KindBasicEntityTimelineItemKindSecurityAlert ...
	KindBasicEntityTimelineItemKindSecurityAlert KindBasicEntityTimelineItem = "SecurityAlert"
)

// PossibleKindBasicEntityTimelineItemValues returns an array of possible values for the KindBasicEntityTimelineItem const type.
func PossibleKindBasicEntityTimelineItemValues() []KindBasicEntityTimelineItem {
	return []KindBasicEntityTimelineItem{KindBasicEntityTimelineItemKindActivity, KindBasicEntityTimelineItemKindBookmark, KindBasicEntityTimelineItemKindEntityTimelineItem, KindBasicEntityTimelineItemKindSecurityAlert}
}

// KindBasicSettings enumerates the values for kind basic settings.
type KindBasicSettings string

const (
	// KindBasicSettingsKindEntityAnalytics ...
	KindBasicSettingsKindEntityAnalytics KindBasicSettings = "EntityAnalytics"
	// KindBasicSettingsKindEyesOn ...
	KindBasicSettingsKindEyesOn KindBasicSettings = "EyesOn"
	// KindBasicSettingsKindIPSyncer ...
	KindBasicSettingsKindIPSyncer KindBasicSettings = "IPSyncer"
	// KindBasicSettingsKindSettings ...
	KindBasicSettingsKindSettings KindBasicSettings = "Settings"
	// KindBasicSettingsKindUeba ...
	KindBasicSettingsKindUeba KindBasicSettings = "Ueba"
)

// PossibleKindBasicSettingsValues returns an array of possible values for the KindBasicSettings const type.
func PossibleKindBasicSettingsValues() []KindBasicSettings {
	return []KindBasicSettings{KindBasicSettingsKindEntityAnalytics, KindBasicSettingsKindEyesOn, KindBasicSettingsKindIPSyncer, KindBasicSettingsKindSettings, KindBasicSettingsKindUeba}
}

// KindBasicThreatIntelligenceInformation enumerates the values for kind basic threat intelligence information.
type KindBasicThreatIntelligenceInformation string

const (
	// KindBasicThreatIntelligenceInformationKindIndicator ...
	KindBasicThreatIntelligenceInformationKindIndicator KindBasicThreatIntelligenceInformation = "indicator"
	// KindBasicThreatIntelligenceInformationKindThreatIntelligenceInformation ...
	KindBasicThreatIntelligenceInformationKindThreatIntelligenceInformation KindBasicThreatIntelligenceInformation = "ThreatIntelligenceInformation"
)

// PossibleKindBasicThreatIntelligenceInformationValues returns an array of possible values for the KindBasicThreatIntelligenceInformation const type.
func PossibleKindBasicThreatIntelligenceInformationValues() []KindBasicThreatIntelligenceInformation {
	return []KindBasicThreatIntelligenceInformation{KindBasicThreatIntelligenceInformationKindIndicator, KindBasicThreatIntelligenceInformationKindThreatIntelligenceInformation}
}

// MicrosoftSecurityProductName enumerates the values for microsoft security product name.
type MicrosoftSecurityProductName string

const (
	// MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection ...
	MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection MicrosoftSecurityProductName = "Azure Active Directory Identity Protection"
	// MicrosoftSecurityProductNameAzureAdvancedThreatProtection ...
	MicrosoftSecurityProductNameAzureAdvancedThreatProtection MicrosoftSecurityProductName = "Azure Advanced Threat Protection"
	// MicrosoftSecurityProductNameAzureSecurityCenter ...
	MicrosoftSecurityProductNameAzureSecurityCenter MicrosoftSecurityProductName = "Azure Security Center"
	// MicrosoftSecurityProductNameAzureSecurityCenterforIoT ...
	MicrosoftSecurityProductNameAzureSecurityCenterforIoT MicrosoftSecurityProductName = "Azure Security Center for IoT"
	// MicrosoftSecurityProductNameMicrosoftCloudAppSecurity ...
	MicrosoftSecurityProductNameMicrosoftCloudAppSecurity MicrosoftSecurityProductName = "Microsoft Cloud App Security"
	// MicrosoftSecurityProductNameMicrosoftDefenderAdvancedThreatProtection ...
	MicrosoftSecurityProductNameMicrosoftDefenderAdvancedThreatProtection MicrosoftSecurityProductName = "Microsoft Defender Advanced Threat Protection"
	// MicrosoftSecurityProductNameOffice365AdvancedThreatProtection ...
	MicrosoftSecurityProductNameOffice365AdvancedThreatProtection MicrosoftSecurityProductName = "Office 365 Advanced Threat Protection"
)

// PossibleMicrosoftSecurityProductNameValues returns an array of possible values for the MicrosoftSecurityProductName const type.
func PossibleMicrosoftSecurityProductNameValues() []MicrosoftSecurityProductName {
	return []MicrosoftSecurityProductName{MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection, MicrosoftSecurityProductNameAzureAdvancedThreatProtection, MicrosoftSecurityProductNameAzureSecurityCenter, MicrosoftSecurityProductNameAzureSecurityCenterforIoT, MicrosoftSecurityProductNameMicrosoftCloudAppSecurity, MicrosoftSecurityProductNameMicrosoftDefenderAdvancedThreatProtection, MicrosoftSecurityProductNameOffice365AdvancedThreatProtection}
}

// OSFamily enumerates the values for os family.
type OSFamily string

const (
	// OSFamilyAndroid Host with Android operating system.
	OSFamilyAndroid OSFamily = "Android"
	// OSFamilyIOS Host with IOS operating system.
	OSFamilyIOS OSFamily = "IOS"
	// OSFamilyLinux Host with Linux operating system.
	OSFamilyLinux OSFamily = "Linux"
	// OSFamilyUnknown Host with Unknown operating system.
	OSFamilyUnknown OSFamily = "Unknown"
	// OSFamilyWindows Host with Windows operating system.
	OSFamilyWindows OSFamily = "Windows"
)

// PossibleOSFamilyValues returns an array of possible values for the OSFamily const type.
func PossibleOSFamilyValues() []OSFamily {
	return []OSFamily{OSFamilyAndroid, OSFamilyIOS, OSFamilyLinux, OSFamilyUnknown, OSFamilyWindows}
}

// OutputType enumerates the values for output type.
type OutputType string

const (
	// OutputTypeDate ...
	OutputTypeDate OutputType = "Date"
	// OutputTypeEntity ...
	OutputTypeEntity OutputType = "Entity"
	// OutputTypeNumber ...
	OutputTypeNumber OutputType = "Number"
	// OutputTypeString ...
	OutputTypeString OutputType = "String"
)

// PossibleOutputTypeValues returns an array of possible values for the OutputType const type.
func PossibleOutputTypeValues() []OutputType {
	return []OutputType{OutputTypeDate, OutputTypeEntity, OutputTypeNumber, OutputTypeString}
}

// PollingFrequency enumerates the values for polling frequency.
type PollingFrequency string

const (
	// PollingFrequencyOnceADay Once a day
	PollingFrequencyOnceADay PollingFrequency = "OnceADay"
	// PollingFrequencyOnceAMinute Once a minute
	PollingFrequencyOnceAMinute PollingFrequency = "OnceAMinute"
	// PollingFrequencyOnceAnHour Once an hour
	PollingFrequencyOnceAnHour PollingFrequency = "OnceAnHour"
)

// PossiblePollingFrequencyValues returns an array of possible values for the PollingFrequency const type.
func PossiblePollingFrequencyValues() []PollingFrequency {
	return []PollingFrequency{PollingFrequencyOnceADay, PollingFrequencyOnceAMinute, PollingFrequencyOnceAnHour}
}

// RegistryHive enumerates the values for registry hive.
type RegistryHive string

const (
	// RegistryHiveHKEYA HKEY_A
	RegistryHiveHKEYA RegistryHive = "HKEY_A"
	// RegistryHiveHKEYCLASSESROOT HKEY_CLASSES_ROOT
	RegistryHiveHKEYCLASSESROOT RegistryHive = "HKEY_CLASSES_ROOT"
	// RegistryHiveHKEYCURRENTCONFIG HKEY_CURRENT_CONFIG
	RegistryHiveHKEYCURRENTCONFIG RegistryHive = "HKEY_CURRENT_CONFIG"
	// RegistryHiveHKEYCURRENTUSER HKEY_CURRENT_USER
	RegistryHiveHKEYCURRENTUSER RegistryHive = "HKEY_CURRENT_USER"
	// RegistryHiveHKEYCURRENTUSERLOCALSETTINGS HKEY_CURRENT_USER_LOCAL_SETTINGS
	RegistryHiveHKEYCURRENTUSERLOCALSETTINGS RegistryHive = "HKEY_CURRENT_USER_LOCAL_SETTINGS"
	// RegistryHiveHKEYLOCALMACHINE HKEY_LOCAL_MACHINE
	RegistryHiveHKEYLOCALMACHINE RegistryHive = "HKEY_LOCAL_MACHINE"
	// RegistryHiveHKEYPERFORMANCEDATA HKEY_PERFORMANCE_DATA
	RegistryHiveHKEYPERFORMANCEDATA RegistryHive = "HKEY_PERFORMANCE_DATA"
	// RegistryHiveHKEYPERFORMANCENLSTEXT HKEY_PERFORMANCE_NLSTEXT
	RegistryHiveHKEYPERFORMANCENLSTEXT RegistryHive = "HKEY_PERFORMANCE_NLSTEXT"
	// RegistryHiveHKEYPERFORMANCETEXT HKEY_PERFORMANCE_TEXT
	RegistryHiveHKEYPERFORMANCETEXT RegistryHive = "HKEY_PERFORMANCE_TEXT"
	// RegistryHiveHKEYUSERS HKEY_USERS
	RegistryHiveHKEYUSERS RegistryHive = "HKEY_USERS"
)

// PossibleRegistryHiveValues returns an array of possible values for the RegistryHive const type.
func PossibleRegistryHiveValues() []RegistryHive {
	return []RegistryHive{RegistryHiveHKEYA, RegistryHiveHKEYCLASSESROOT, RegistryHiveHKEYCURRENTCONFIG, RegistryHiveHKEYCURRENTUSER, RegistryHiveHKEYCURRENTUSERLOCALSETTINGS, RegistryHiveHKEYLOCALMACHINE, RegistryHiveHKEYPERFORMANCEDATA, RegistryHiveHKEYPERFORMANCENLSTEXT, RegistryHiveHKEYPERFORMANCETEXT, RegistryHiveHKEYUSERS}
}

// RegistryValueKind enumerates the values for registry value kind.
type RegistryValueKind string

const (
	// RegistryValueKindBinary Binary value type
	RegistryValueKindBinary RegistryValueKind = "Binary"
	// RegistryValueKindDWord DWord value type
	RegistryValueKindDWord RegistryValueKind = "DWord"
	// RegistryValueKindExpandString ExpandString value type
	RegistryValueKindExpandString RegistryValueKind = "ExpandString"
	// RegistryValueKindMultiString MultiString value type
	RegistryValueKindMultiString RegistryValueKind = "MultiString"
	// RegistryValueKindNone None
	RegistryValueKindNone RegistryValueKind = "None"
	// RegistryValueKindQWord QWord value type
	RegistryValueKindQWord RegistryValueKind = "QWord"
	// RegistryValueKindString String value type
	RegistryValueKindString RegistryValueKind = "String"
	// RegistryValueKindUnknown Unknown value type
	RegistryValueKindUnknown RegistryValueKind = "Unknown"
)

// PossibleRegistryValueKindValues returns an array of possible values for the RegistryValueKind const type.
func PossibleRegistryValueKindValues() []RegistryValueKind {
	return []RegistryValueKind{RegistryValueKindBinary, RegistryValueKindDWord, RegistryValueKindExpandString, RegistryValueKindMultiString, RegistryValueKindNone, RegistryValueKindQWord, RegistryValueKindString, RegistryValueKindUnknown}
}

// RelationNodeKind enumerates the values for relation node kind.
type RelationNodeKind string

const (
	// RelationNodeKindBookmark Bookmark node part of the relation
	RelationNodeKindBookmark RelationNodeKind = "Bookmark"
	// RelationNodeKindCase Case node part of the relation
	RelationNodeKindCase RelationNodeKind = "Case"
)

// PossibleRelationNodeKindValues returns an array of possible values for the RelationNodeKind const type.
func PossibleRelationNodeKindValues() []RelationNodeKind {
	return []RelationNodeKind{RelationNodeKindBookmark, RelationNodeKindCase}
}

// RelationTypes enumerates the values for relation types.
type RelationTypes string

const (
	// RelationTypesCasesToBookmarks Relations between cases and bookmarks
	RelationTypesCasesToBookmarks RelationTypes = "CasesToBookmarks"
)

// PossibleRelationTypesValues returns an array of possible values for the RelationTypes const type.
func PossibleRelationTypesValues() []RelationTypes {
	return []RelationTypes{RelationTypesCasesToBookmarks}
}

// SettingKind enumerates the values for setting kind.
type SettingKind string

const (
	// SettingKindEntityAnalytics ...
	SettingKindEntityAnalytics SettingKind = "EntityAnalytics"
	// SettingKindEyesOn ...
	SettingKindEyesOn SettingKind = "EyesOn"
	// SettingKindUeba ...
	SettingKindUeba SettingKind = "Ueba"
)

// PossibleSettingKindValues returns an array of possible values for the SettingKind const type.
func PossibleSettingKindValues() []SettingKind {
	return []SettingKind{SettingKindEntityAnalytics, SettingKindEyesOn, SettingKindUeba}
}

// Source enumerates the values for source.
type Source string

const (
	// SourceLocalfile ...
	SourceLocalfile Source = "Local file"
	// SourceRemotestorage ...
	SourceRemotestorage Source = "Remote storage"
)

// PossibleSourceValues returns an array of possible values for the Source const type.
func PossibleSourceValues() []Source {
	return []Source{SourceLocalfile, SourceRemotestorage}
}

// TemplateStatus enumerates the values for template status.
type TemplateStatus string

const (
	// TemplateStatusAvailable Alert rule template is available.
	TemplateStatusAvailable TemplateStatus = "Available"
	// TemplateStatusInstalled Alert rule template installed. and can not use more then once
	TemplateStatusInstalled TemplateStatus = "Installed"
	// TemplateStatusNotAvailable Alert rule template is not available
	TemplateStatusNotAvailable TemplateStatus = "NotAvailable"
)

// PossibleTemplateStatusValues returns an array of possible values for the TemplateStatus const type.
func PossibleTemplateStatusValues() []TemplateStatus {
	return []TemplateStatus{TemplateStatusAvailable, TemplateStatusInstalled, TemplateStatusNotAvailable}
}

// ThreatIntelligenceResourceKind enumerates the values for threat intelligence resource kind.
type ThreatIntelligenceResourceKind string

const (
	// ThreatIntelligenceResourceKindIndicator Entity represents threat intelligence indicator in the system.
	ThreatIntelligenceResourceKindIndicator ThreatIntelligenceResourceKind = "indicator"
)

// PossibleThreatIntelligenceResourceKindValues returns an array of possible values for the ThreatIntelligenceResourceKind const type.
func PossibleThreatIntelligenceResourceKindValues() []ThreatIntelligenceResourceKind {
	return []ThreatIntelligenceResourceKind{ThreatIntelligenceResourceKindIndicator}
}

// ThreatIntelligenceSortingCriteria enumerates the values for threat intelligence sorting criteria.
type ThreatIntelligenceSortingCriteria string

const (
	// ThreatIntelligenceSortingCriteriaAscending ...
	ThreatIntelligenceSortingCriteriaAscending ThreatIntelligenceSortingCriteria = "ascending"
	// ThreatIntelligenceSortingCriteriaDescending ...
	ThreatIntelligenceSortingCriteriaDescending ThreatIntelligenceSortingCriteria = "descending"
	// ThreatIntelligenceSortingCriteriaUnsorted ...
	ThreatIntelligenceSortingCriteriaUnsorted ThreatIntelligenceSortingCriteria = "unsorted"
)

// PossibleThreatIntelligenceSortingCriteriaValues returns an array of possible values for the ThreatIntelligenceSortingCriteria const type.
func PossibleThreatIntelligenceSortingCriteriaValues() []ThreatIntelligenceSortingCriteria {
	return []ThreatIntelligenceSortingCriteria{ThreatIntelligenceSortingCriteriaAscending, ThreatIntelligenceSortingCriteriaDescending, ThreatIntelligenceSortingCriteriaUnsorted}
}

// TriggerOperator enumerates the values for trigger operator.
type TriggerOperator string

const (
	// TriggerOperatorEqual ...
	TriggerOperatorEqual TriggerOperator = "Equal"
	// TriggerOperatorGreaterThan ...
	TriggerOperatorGreaterThan TriggerOperator = "GreaterThan"
	// TriggerOperatorLessThan ...
	TriggerOperatorLessThan TriggerOperator = "LessThan"
	// TriggerOperatorNotEqual ...
	TriggerOperatorNotEqual TriggerOperator = "NotEqual"
)

// PossibleTriggerOperatorValues returns an array of possible values for the TriggerOperator const type.
func PossibleTriggerOperatorValues() []TriggerOperator {
	return []TriggerOperator{TriggerOperatorEqual, TriggerOperatorGreaterThan, TriggerOperatorLessThan, TriggerOperatorNotEqual}
}

// UebaDataSources enumerates the values for ueba data sources.
type UebaDataSources string

const (
	// UebaDataSourcesAuditLogs ...
	UebaDataSourcesAuditLogs UebaDataSources = "AuditLogs"
	// UebaDataSourcesAzureActivity ...
	UebaDataSourcesAzureActivity UebaDataSources = "AzureActivity"
	// UebaDataSourcesSecurityEvent ...
	UebaDataSourcesSecurityEvent UebaDataSources = "SecurityEvent"
	// UebaDataSourcesSigninLogs ...
	UebaDataSourcesSigninLogs UebaDataSources = "SigninLogs"
)

// PossibleUebaDataSourcesValues returns an array of possible values for the UebaDataSources const type.
func PossibleUebaDataSourcesValues() []UebaDataSources {
	return []UebaDataSources{UebaDataSourcesAuditLogs, UebaDataSourcesAzureActivity, UebaDataSourcesSecurityEvent, UebaDataSourcesSigninLogs}
}
