package elastic

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/elastic/mgmt/2020-07-01-preview/elastic"

// CloudDeployment details of the user's elastic deployment associated with the monitor resource.
type CloudDeployment struct {
	// Name - READ-ONLY; Elastic deployment name
	Name *string `json:"name,omitempty"`
	// DeploymentID - READ-ONLY; Elastic deployment Id
	DeploymentID *string `json:"deploymentId,omitempty"`
	// AzureSubscriptionID - READ-ONLY; Associated Azure subscription Id for the elastic deployment.
	AzureSubscriptionID *string `json:"azureSubscriptionId,omitempty"`
	// ElasticsearchRegion - READ-ONLY; Region where Deployment at Elastic side took place.
	ElasticsearchRegion *string `json:"elasticsearchRegion,omitempty"`
	// ElasticsearchServiceURL - READ-ONLY; Elasticsearch ingestion endpoint of the Elastic deployment.
	ElasticsearchServiceURL *string `json:"elasticsearchServiceUrl,omitempty"`
	// KibanaServiceURL - READ-ONLY; Kibana endpoint of the Elastic deployment.
	KibanaServiceURL *string `json:"kibanaServiceUrl,omitempty"`
	// KibanaSsoURL - READ-ONLY; Kibana dashboard sso URL of the Elastic deployment.
	KibanaSsoURL *string `json:"kibanaSsoUrl,omitempty"`
}

// CloudUser details of the user's elastic account.
type CloudUser struct {
	// EmailAddress - READ-ONLY; Email of the Elastic User Account.
	EmailAddress *string `json:"emailAddress,omitempty"`
	// ID - READ-ONLY; User Id of the elastic account of the User.
	ID *string `json:"id,omitempty"`
	// ElasticCloudSsoDefaultURL - READ-ONLY; Elastic cloud default dashboard sso URL of the Elastic user account.
	ElasticCloudSsoDefaultURL *string `json:"elasticCloudSsoDefaultUrl,omitempty"`
}

// CompanyInfo company information of the user to be passed to partners.
type CompanyInfo struct {
	// Domain - Domain of the company
	Domain *string `json:"domain,omitempty"`
	// Business - Business of the company
	Business *string `json:"business,omitempty"`
	// EmployeesNumber - Number of employees in the company
	EmployeesNumber *string `json:"employeesNumber,omitempty"`
	// State - State of the company location.
	State *string `json:"state,omitempty"`
	// Country - Country of the company location.
	Country *string `json:"country,omitempty"`
}

// DeploymentInfoResponse the properties of deployment in Elastic cloud corresponding to the Elastic
// monitor resource.
type DeploymentInfoResponse struct {
	autorest.Response `json:"-"`
	// Status - READ-ONLY; The Elastic deployment status. Possible values include: 'DeploymentStatusHealthy', 'DeploymentStatusUnhealthy'
	Status DeploymentStatus `json:"status,omitempty"`
	// Version - READ-ONLY; Version of the elasticsearch in Elastic cloud deployment.
	Version *string `json:"version,omitempty"`
	// MemoryCapacity - READ-ONLY; RAM capacity of the elasticsearch in Elastic cloud deployment.
	MemoryCapacity *string `json:"memoryCapacity,omitempty"`
	// DiskCapacity - READ-ONLY; Disk capacity of the elasticsearch in Elastic cloud deployment.
	DiskCapacity *string `json:"diskCapacity,omitempty"`
}

// ErrorResponseBody error response body.
type ErrorResponseBody struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
	// Target - Error target.
	Target *string `json:"target,omitempty"`
	// Details - Error details.
	Details *[]ErrorResponseBody `json:"details,omitempty"`
}

// FilteringTag the definition of a filtering tag. Filtering tags are used for capturing resources and
// include/exclude them from being monitored.
type FilteringTag struct {
	// Name - The name (also known as the key) of the tag.
	Name *string `json:"name,omitempty"`
	// Value - The value of the tag.
	Value *string `json:"value,omitempty"`
	// Action - Valid actions for a filtering tag. Possible values include: 'TagActionInclude', 'TagActionExclude'
	Action TagAction `json:"action,omitempty"`
}

// IdentityProperties identity properties.
type IdentityProperties struct {
	// PrincipalID - READ-ONLY; The identity ID.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - Managed identity type. Possible values include: 'ManagedIdentityTypesSystemAssigned'
	Type ManagedIdentityTypes `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IdentityProperties.
func (IP IdentityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.Type != "" {
		objectMap["type"] = IP.Type
	}
	return json.Marshal(objectMap)
}

// LogRules set of rules for sending logs for the Monitor resource.
type LogRules struct {
	// SendAadLogs - Flag specifying if AAD logs should be sent for the Monitor resource.
	SendAadLogs *bool `json:"sendAadLogs,omitempty"`
	// SendSubscriptionLogs - Flag specifying if subscription logs should be sent for the Monitor resource.
	SendSubscriptionLogs *bool `json:"sendSubscriptionLogs,omitempty"`
	// SendActivityLogs - Flag specifying if activity logs from Azure resources should be sent for the Monitor resource.
	SendActivityLogs *bool `json:"sendActivityLogs,omitempty"`
	// FilteringTags - List of filtering tags to be used for capturing logs. This only takes effect if SendActivityLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
	FilteringTags *[]FilteringTag `json:"filteringTags,omitempty"`
}

// MonitoredResource the properties of a resource currently being monitored by the Elastic monitor
// resource.
type MonitoredResource struct {
	// ID - The ARM id of the resource.
	ID *string `json:"id,omitempty"`
	// SendingLogs - Flag indicating the status of the resource for sending logs operation to Elastic. Possible values include: 'SendingLogsTrue', 'SendingLogsFalse'
	SendingLogs SendingLogs `json:"sendingLogs,omitempty"`
	// ReasonForLogsStatus - Reason for why the resource is sending logs (or why it is not sending).
	ReasonForLogsStatus *string `json:"reasonForLogsStatus,omitempty"`
}

// MonitoredResourceListResponse response of a list operation.
type MonitoredResourceListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]MonitoredResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MonitoredResourceListResponseIterator provides access to a complete listing of MonitoredResource values.
type MonitoredResourceListResponseIterator struct {
	i    int
	page MonitoredResourceListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MonitoredResourceListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitoredResourceListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MonitoredResourceListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MonitoredResourceListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MonitoredResourceListResponseIterator) Response() MonitoredResourceListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MonitoredResourceListResponseIterator) Value() MonitoredResource {
	if !iter.page.NotDone() {
		return MonitoredResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MonitoredResourceListResponseIterator type.
func NewMonitoredResourceListResponseIterator(page MonitoredResourceListResponsePage) MonitoredResourceListResponseIterator {
	return MonitoredResourceListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mrlr MonitoredResourceListResponse) IsEmpty() bool {
	return mrlr.Value == nil || len(*mrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mrlr MonitoredResourceListResponse) hasNextLink() bool {
	return mrlr.NextLink != nil && len(*mrlr.NextLink) != 0
}

// monitoredResourceListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mrlr MonitoredResourceListResponse) monitoredResourceListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !mrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mrlr.NextLink)))
}

// MonitoredResourceListResponsePage contains a page of MonitoredResource values.
type MonitoredResourceListResponsePage struct {
	fn   func(context.Context, MonitoredResourceListResponse) (MonitoredResourceListResponse, error)
	mrlr MonitoredResourceListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MonitoredResourceListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitoredResourceListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mrlr)
		if err != nil {
			return err
		}
		page.mrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MonitoredResourceListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MonitoredResourceListResponsePage) NotDone() bool {
	return !page.mrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MonitoredResourceListResponsePage) Response() MonitoredResourceListResponse {
	return page.mrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MonitoredResourceListResponsePage) Values() []MonitoredResource {
	if page.mrlr.IsEmpty() {
		return nil
	}
	return *page.mrlr.Value
}

// Creates a new instance of the MonitoredResourceListResponsePage type.
func NewMonitoredResourceListResponsePage(cur MonitoredResourceListResponse, getNextPage func(context.Context, MonitoredResourceListResponse) (MonitoredResourceListResponse, error)) MonitoredResourceListResponsePage {
	return MonitoredResourceListResponsePage{
		fn:   getNextPage,
		mrlr: cur,
	}
}

// MonitoringTagRules capture logs and metrics of Azure resources based on ARM tags.
type MonitoringTagRules struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Name of the rule set.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The id of the rule set.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the rule set.
	Type *string `json:"type,omitempty"`
	// Properties - Properties of the monitoring tag rules.
	Properties *MonitoringTagRulesProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for MonitoringTagRules.
func (mtr MonitoringTagRules) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mtr.Properties != nil {
		objectMap["properties"] = mtr.Properties
	}
	return json.Marshal(objectMap)
}

// MonitoringTagRulesListResponse response of a list operation.
type MonitoringTagRulesListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]MonitoringTagRules `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MonitoringTagRulesListResponseIterator provides access to a complete listing of MonitoringTagRules
// values.
type MonitoringTagRulesListResponseIterator struct {
	i    int
	page MonitoringTagRulesListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MonitoringTagRulesListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitoringTagRulesListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MonitoringTagRulesListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MonitoringTagRulesListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MonitoringTagRulesListResponseIterator) Response() MonitoringTagRulesListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MonitoringTagRulesListResponseIterator) Value() MonitoringTagRules {
	if !iter.page.NotDone() {
		return MonitoringTagRules{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MonitoringTagRulesListResponseIterator type.
func NewMonitoringTagRulesListResponseIterator(page MonitoringTagRulesListResponsePage) MonitoringTagRulesListResponseIterator {
	return MonitoringTagRulesListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mtrlr MonitoringTagRulesListResponse) IsEmpty() bool {
	return mtrlr.Value == nil || len(*mtrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mtrlr MonitoringTagRulesListResponse) hasNextLink() bool {
	return mtrlr.NextLink != nil && len(*mtrlr.NextLink) != 0
}

// monitoringTagRulesListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mtrlr MonitoringTagRulesListResponse) monitoringTagRulesListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !mtrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mtrlr.NextLink)))
}

// MonitoringTagRulesListResponsePage contains a page of MonitoringTagRules values.
type MonitoringTagRulesListResponsePage struct {
	fn    func(context.Context, MonitoringTagRulesListResponse) (MonitoringTagRulesListResponse, error)
	mtrlr MonitoringTagRulesListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MonitoringTagRulesListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitoringTagRulesListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mtrlr)
		if err != nil {
			return err
		}
		page.mtrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MonitoringTagRulesListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MonitoringTagRulesListResponsePage) NotDone() bool {
	return !page.mtrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MonitoringTagRulesListResponsePage) Response() MonitoringTagRulesListResponse {
	return page.mtrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MonitoringTagRulesListResponsePage) Values() []MonitoringTagRules {
	if page.mtrlr.IsEmpty() {
		return nil
	}
	return *page.mtrlr.Value
}

// Creates a new instance of the MonitoringTagRulesListResponsePage type.
func NewMonitoringTagRulesListResponsePage(cur MonitoringTagRulesListResponse, getNextPage func(context.Context, MonitoringTagRulesListResponse) (MonitoringTagRulesListResponse, error)) MonitoringTagRulesListResponsePage {
	return MonitoringTagRulesListResponsePage{
		fn:    getNextPage,
		mtrlr: cur,
	}
}

// MonitoringTagRulesProperties definition of the properties for a TagRules resource.
type MonitoringTagRulesProperties struct {
	// ProvisioningState - Provisioning state of the monitoring tag rules. Possible values include: 'ProvisioningStateAccepted', 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted', 'ProvisioningStateNotSpecified'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// LogRules - Rules for sending logs.
	LogRules *LogRules `json:"logRules,omitempty"`
}

// MonitorProperties properties specific to the monitor resource.
type MonitorProperties struct {
	// ProvisioningState - Provisioning state of the monitor resource. Possible values include: 'ProvisioningStateAccepted', 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted', 'ProvisioningStateNotSpecified'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// MonitoringStatus - Flag specifying if the resource monitoring is enabled or disabled. Possible values include: 'MonitoringStatusEnabled', 'MonitoringStatusDisabled'
	MonitoringStatus MonitoringStatus `json:"monitoringStatus,omitempty"`
	// ElasticProperties - Elastic cloud properties.
	ElasticProperties *Properties `json:"elasticProperties,omitempty"`
	// UserInfo - User information.
	UserInfo *UserInfo `json:"userInfo,omitempty"`
	// LiftrResourceCategory - Possible values include: 'LiftrResourceCategoriesUnknown', 'LiftrResourceCategoriesMonitorLogs'
	LiftrResourceCategory LiftrResourceCategories `json:"liftrResourceCategory,omitempty"`
	// LiftrResourcePreference - READ-ONLY; The priority of the resource.
	LiftrResourcePreference *int32 `json:"liftrResourcePreference,omitempty"`
}

// MarshalJSON is the custom marshaler for MonitorProperties.
func (mp MonitorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mp.ProvisioningState != "" {
		objectMap["provisioningState"] = mp.ProvisioningState
	}
	if mp.MonitoringStatus != "" {
		objectMap["monitoringStatus"] = mp.MonitoringStatus
	}
	if mp.ElasticProperties != nil {
		objectMap["elasticProperties"] = mp.ElasticProperties
	}
	if mp.UserInfo != nil {
		objectMap["userInfo"] = mp.UserInfo
	}
	if mp.LiftrResourceCategory != "" {
		objectMap["liftrResourceCategory"] = mp.LiftrResourceCategory
	}
	return json.Marshal(objectMap)
}

// MonitorResource monitor resource.
type MonitorResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; ARM id of the monitor resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the monitor resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the monitor resource.
	Type *string `json:"type,omitempty"`
	// Sku - SKU of the monitor resource.
	Sku *ResourceSku `json:"sku,omitempty"`
	// Properties - Properties of the monitor resource.
	Properties *MonitorProperties `json:"properties,omitempty"`
	// Identity - Identity properties of the monitor resource.
	Identity *IdentityProperties `json:"identity,omitempty"`
	// Tags - The tags of the monitor resource.
	Tags map[string]*string `json:"tags"`
	// Location - The location of the monitor resource
	Location *string `json:"location,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for MonitorResource.
func (mr MonitorResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mr.Sku != nil {
		objectMap["sku"] = mr.Sku
	}
	if mr.Properties != nil {
		objectMap["properties"] = mr.Properties
	}
	if mr.Identity != nil {
		objectMap["identity"] = mr.Identity
	}
	if mr.Tags != nil {
		objectMap["tags"] = mr.Tags
	}
	if mr.Location != nil {
		objectMap["location"] = mr.Location
	}
	return json.Marshal(objectMap)
}

// MonitorResourceListResponse response of a list operation.
type MonitorResourceListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]MonitorResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MonitorResourceListResponseIterator provides access to a complete listing of MonitorResource values.
type MonitorResourceListResponseIterator struct {
	i    int
	page MonitorResourceListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MonitorResourceListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitorResourceListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MonitorResourceListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MonitorResourceListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MonitorResourceListResponseIterator) Response() MonitorResourceListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MonitorResourceListResponseIterator) Value() MonitorResource {
	if !iter.page.NotDone() {
		return MonitorResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MonitorResourceListResponseIterator type.
func NewMonitorResourceListResponseIterator(page MonitorResourceListResponsePage) MonitorResourceListResponseIterator {
	return MonitorResourceListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mrlr MonitorResourceListResponse) IsEmpty() bool {
	return mrlr.Value == nil || len(*mrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mrlr MonitorResourceListResponse) hasNextLink() bool {
	return mrlr.NextLink != nil && len(*mrlr.NextLink) != 0
}

// monitorResourceListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mrlr MonitorResourceListResponse) monitorResourceListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !mrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mrlr.NextLink)))
}

// MonitorResourceListResponsePage contains a page of MonitorResource values.
type MonitorResourceListResponsePage struct {
	fn   func(context.Context, MonitorResourceListResponse) (MonitorResourceListResponse, error)
	mrlr MonitorResourceListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MonitorResourceListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitorResourceListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mrlr)
		if err != nil {
			return err
		}
		page.mrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MonitorResourceListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MonitorResourceListResponsePage) NotDone() bool {
	return !page.mrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MonitorResourceListResponsePage) Response() MonitorResourceListResponse {
	return page.mrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MonitorResourceListResponsePage) Values() []MonitorResource {
	if page.mrlr.IsEmpty() {
		return nil
	}
	return *page.mrlr.Value
}

// Creates a new instance of the MonitorResourceListResponsePage type.
func NewMonitorResourceListResponsePage(cur MonitorResourceListResponse, getNextPage func(context.Context, MonitorResourceListResponse) (MonitorResourceListResponse, error)) MonitorResourceListResponsePage {
	return MonitorResourceListResponsePage{
		fn:   getNextPage,
		mrlr: cur,
	}
}

// MonitorResourceUpdateParameters monitor resource update parameters.
type MonitorResourceUpdateParameters struct {
	// Tags - elastic monitor resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for MonitorResourceUpdateParameters.
func (mrup MonitorResourceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mrup.Tags != nil {
		objectMap["tags"] = mrup.Tags
	}
	return json.Marshal(objectMap)
}

// MonitorsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MonitorsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MonitorsClient) (MonitorResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MonitorsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MonitorsCreateFuture.Result.
func (future *MonitorsCreateFuture) result(client MonitorsClient) (mr MonitorResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "elastic.MonitorsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("elastic.MonitorsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mr.Response.Response, err = future.GetResult(sender); err == nil && mr.Response.Response.StatusCode != http.StatusNoContent {
		mr, err = client.CreateResponder(mr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "elastic.MonitorsCreateFuture", "Result", mr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MonitorsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MonitorsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MonitorsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MonitorsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MonitorsDeleteFuture.Result.
func (future *MonitorsDeleteFuture) result(client MonitorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "elastic.MonitorsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("elastic.MonitorsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider, i.e., Microsoft.Elastic.
	Provider *string `json:"provider,omitempty"`
	// Resource - Type on which the operation is performed, e.g., 'monitors'.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type, e.g., read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation, e.g., 'Write monitors'.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of GET request to list the Microsoft.Elastic operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the Microsoft.Elastic provider.
	Value *[]OperationResult `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of OperationResult values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() OperationResult {
	if !iter.page.NotDone() {
		return OperationResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of OperationResult values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []OperationResult {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationResult a Microsoft.Elastic REST API operation.
type OperationResult struct {
	// Name - Operation name, i.e., {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - Origin of the operation
	Origin *string `json:"origin,omitempty"`
}

// Properties elastic Resource Properties.
type Properties struct {
	// ElasticCloudUser - Details of the user's elastic account.
	ElasticCloudUser *CloudUser `json:"elasticCloudUser,omitempty"`
	// ElasticCloudDeployment - Details of the elastic cloud deployment.
	ElasticCloudDeployment *CloudDeployment `json:"elasticCloudDeployment,omitempty"`
}

// ResourceProviderDefaultErrorResponse RP default error response.
type ResourceProviderDefaultErrorResponse struct {
	// Error - READ-ONLY; Response body of Error
	Error *ErrorResponseBody `json:"error,omitempty"`
}

// ResourceSku microsoft.Elastic SKU.
type ResourceSku struct {
	// Name - Name of the SKU.
	Name *string `json:"name,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TagRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TagRulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TagRulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TagRulesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TagRulesDeleteFuture.Result.
func (future *TagRulesDeleteFuture) result(client TagRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "elastic.TagRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("elastic.TagRulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// UserInfo user Information to be passed to partners.
type UserInfo struct {
	// FirstName - First name of the user
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last name of the user
	LastName *string `json:"lastName,omitempty"`
	// CompanyName - Company name of the user
	CompanyName *string `json:"companyName,omitempty"`
	// EmailAddress - Email of the user used by Elastic for contacting them if needed
	EmailAddress *string `json:"emailAddress,omitempty"`
	// CompanyInfo - Company information of the user to be passed to partners.
	CompanyInfo *CompanyInfo `json:"companyInfo,omitempty"`
}

// VMCollectionUpdate update VM resource collection.
type VMCollectionUpdate struct {
	// VMResourceID - ARM id of the VM resource.
	VMResourceID *string `json:"vmResourceId,omitempty"`
	// OperationName - Operation to be performed for given VM. Possible values include: 'OperationNameAdd', 'OperationNameDelete'
	OperationName OperationName `json:"operationName,omitempty"`
}

// VMHostListResponse response of a list operation.
type VMHostListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]VMResources `json:"value,omitempty"`
	// NextLink - Link to the next Vm resource Id, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// VMHostListResponseIterator provides access to a complete listing of VMResources values.
type VMHostListResponseIterator struct {
	i    int
	page VMHostListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VMHostListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VMHostListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VMHostListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VMHostListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VMHostListResponseIterator) Response() VMHostListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VMHostListResponseIterator) Value() VMResources {
	if !iter.page.NotDone() {
		return VMResources{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VMHostListResponseIterator type.
func NewVMHostListResponseIterator(page VMHostListResponsePage) VMHostListResponseIterator {
	return VMHostListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vhlr VMHostListResponse) IsEmpty() bool {
	return vhlr.Value == nil || len(*vhlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vhlr VMHostListResponse) hasNextLink() bool {
	return vhlr.NextLink != nil && len(*vhlr.NextLink) != 0
}

// vMHostListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vhlr VMHostListResponse) vMHostListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !vhlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vhlr.NextLink)))
}

// VMHostListResponsePage contains a page of VMResources values.
type VMHostListResponsePage struct {
	fn   func(context.Context, VMHostListResponse) (VMHostListResponse, error)
	vhlr VMHostListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VMHostListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VMHostListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vhlr)
		if err != nil {
			return err
		}
		page.vhlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VMHostListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VMHostListResponsePage) NotDone() bool {
	return !page.vhlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VMHostListResponsePage) Response() VMHostListResponse {
	return page.vhlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VMHostListResponsePage) Values() []VMResources {
	if page.vhlr.IsEmpty() {
		return nil
	}
	return *page.vhlr.Value
}

// Creates a new instance of the VMHostListResponsePage type.
func NewVMHostListResponsePage(cur VMHostListResponse, getNextPage func(context.Context, VMHostListResponse) (VMHostListResponse, error)) VMHostListResponsePage {
	return VMHostListResponsePage{
		fn:   getNextPage,
		vhlr: cur,
	}
}

// VMIngestionDetailsResponse the vm ingestion details to install an agent.
type VMIngestionDetailsResponse struct {
	autorest.Response `json:"-"`
	// CloudID - The cloudId of given Elastic monitor resource.
	CloudID *string `json:"cloudId,omitempty"`
	// IngestionKey - Ingestion details to install agent on given VM.
	IngestionKey *string `json:"ingestionKey,omitempty"`
}

// VMResources the vm resource properties that is currently being monitored by the Elastic monitor
// resource.
type VMResources struct {
	// VMResourceID - The ARM id of the VM resource.
	VMResourceID *string `json:"vmResourceId,omitempty"`
}
