package billingapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/billing/mgmt/2017-02-27-preview/billing"
)

// InvoicesClientAPI contains the set of methods on the InvoicesClient type.
type InvoicesClientAPI interface {
	Get(ctx context.Context, invoiceName string) (result billing.Invoice, err error)
	GetLatest(ctx context.Context) (result billing.Invoice, err error)
	List(ctx context.Context, expand string, filter string, skiptoken string, top *int32) (result billing.InvoicesListResultPage, err error)
	ListComplete(ctx context.Context, expand string, filter string, skiptoken string, top *int32) (result billing.InvoicesListResultIterator, err error)
}

var _ InvoicesClientAPI = (*billing.InvoicesClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result billing.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result billing.OperationListResultIterator, err error)
}

var _ OperationsClientAPI = (*billing.OperationsClient)(nil)
