package videoanalyzer

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// TypeBasicTokenKey enumerates the values for type basic token key.
type TypeBasicTokenKey string

const (
	// TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey ...
	TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey TypeBasicTokenKey = "#Microsoft.VideoAnalyzer.EccTokenKey"
	// TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey ...
	TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey TypeBasicTokenKey = "#Microsoft.VideoAnalyzer.RsaTokenKey"
	// TypeBasicTokenKeyTypeTokenKey ...
	TypeBasicTokenKeyTypeTokenKey TypeBasicTokenKey = "TokenKey"
)

// PossibleTypeBasicTokenKeyValues returns an array of possible values for the TypeBasicTokenKey const type.
func PossibleTypeBasicTokenKeyValues() []TypeBasicTokenKey {
	return []TypeBasicTokenKey{TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey, TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey, TypeBasicTokenKeyTypeTokenKey}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeTypeAuthenticationBase ...
	TypeTypeAuthenticationBase Type = "AuthenticationBase"
	// TypeTypeMicrosoftVideoAnalyzerJwtAuthentication ...
	TypeTypeMicrosoftVideoAnalyzerJwtAuthentication Type = "#Microsoft.VideoAnalyzer.JwtAuthentication"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeTypeAuthenticationBase, TypeTypeMicrosoftVideoAnalyzerJwtAuthentication}
}

// AccessPolicyEccAlgo enumerates the values for access policy ecc algo.
type AccessPolicyEccAlgo string

const (
	// AccessPolicyEccAlgoES256 ES265
	AccessPolicyEccAlgoES256 AccessPolicyEccAlgo = "ES256"
	// AccessPolicyEccAlgoES384 ES384
	AccessPolicyEccAlgoES384 AccessPolicyEccAlgo = "ES384"
	// AccessPolicyEccAlgoES512 ES512
	AccessPolicyEccAlgoES512 AccessPolicyEccAlgo = "ES512"
)

// PossibleAccessPolicyEccAlgoValues returns an array of possible values for the AccessPolicyEccAlgo const type.
func PossibleAccessPolicyEccAlgoValues() []AccessPolicyEccAlgo {
	return []AccessPolicyEccAlgo{AccessPolicyEccAlgoES256, AccessPolicyEccAlgoES384, AccessPolicyEccAlgoES512}
}

// AccessPolicyRole enumerates the values for access policy role.
type AccessPolicyRole string

const (
	// AccessPolicyRoleReader Reader role allows for read-only operations to be performed through the client
	// APIs.
	AccessPolicyRoleReader AccessPolicyRole = "Reader"
)

// PossibleAccessPolicyRoleValues returns an array of possible values for the AccessPolicyRole const type.
func PossibleAccessPolicyRoleValues() []AccessPolicyRole {
	return []AccessPolicyRole{AccessPolicyRoleReader}
}

// AccessPolicyRsaAlgo enumerates the values for access policy rsa algo.
type AccessPolicyRsaAlgo string

const (
	// AccessPolicyRsaAlgoRS256 RS256
	AccessPolicyRsaAlgoRS256 AccessPolicyRsaAlgo = "RS256"
	// AccessPolicyRsaAlgoRS384 RS384
	AccessPolicyRsaAlgoRS384 AccessPolicyRsaAlgo = "RS384"
	// AccessPolicyRsaAlgoRS512 RS512
	AccessPolicyRsaAlgoRS512 AccessPolicyRsaAlgo = "RS512"
)

// PossibleAccessPolicyRsaAlgoValues returns an array of possible values for the AccessPolicyRsaAlgo const type.
func PossibleAccessPolicyRsaAlgoValues() []AccessPolicyRsaAlgo {
	return []AccessPolicyRsaAlgo{AccessPolicyRsaAlgoRS256, AccessPolicyRsaAlgoRS384, AccessPolicyRsaAlgoRS512}
}

// AccountEncryptionKeyType enumerates the values for account encryption key type.
type AccountEncryptionKeyType string

const (
	// AccountEncryptionKeyTypeCustomerKey The Account Key is encrypted with a Customer Key.
	AccountEncryptionKeyTypeCustomerKey AccountEncryptionKeyType = "CustomerKey"
	// AccountEncryptionKeyTypeSystemKey The Account Key is encrypted with a System Key.
	AccountEncryptionKeyTypeSystemKey AccountEncryptionKeyType = "SystemKey"
)

// PossibleAccountEncryptionKeyTypeValues returns an array of possible values for the AccountEncryptionKeyType const type.
func PossibleAccountEncryptionKeyTypeValues() []AccountEncryptionKeyType {
	return []AccountEncryptionKeyType{AccountEncryptionKeyTypeCustomerKey, AccountEncryptionKeyTypeSystemKey}
}

// ActionType enumerates the values for action type.
type ActionType string

const (
	// ActionTypeInternal An internal action.
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{ActionTypeInternal}
}

// CheckNameAvailabilityReason enumerates the values for check name availability reason.
type CheckNameAvailabilityReason string

const (
	// CheckNameAvailabilityReasonAlreadyExists ...
	CheckNameAvailabilityReasonAlreadyExists CheckNameAvailabilityReason = "AlreadyExists"
	// CheckNameAvailabilityReasonInvalid ...
	CheckNameAvailabilityReasonInvalid CheckNameAvailabilityReason = "Invalid"
)

// PossibleCheckNameAvailabilityReasonValues returns an array of possible values for the CheckNameAvailabilityReason const type.
func PossibleCheckNameAvailabilityReasonValues() []CheckNameAvailabilityReason {
	return []CheckNameAvailabilityReason{CheckNameAvailabilityReasonAlreadyExists, CheckNameAvailabilityReasonInvalid}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// MetricAggregationType enumerates the values for metric aggregation type.
type MetricAggregationType string

const (
	// MetricAggregationTypeAverage The average.
	MetricAggregationTypeAverage MetricAggregationType = "Average"
	// MetricAggregationTypeCount The count of a number of items, usually requests.
	MetricAggregationTypeCount MetricAggregationType = "Count"
	// MetricAggregationTypeTotal The sum.
	MetricAggregationTypeTotal MetricAggregationType = "Total"
)

// PossibleMetricAggregationTypeValues returns an array of possible values for the MetricAggregationType const type.
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return []MetricAggregationType{MetricAggregationTypeAverage, MetricAggregationTypeCount, MetricAggregationTypeTotal}
}

// MetricUnit enumerates the values for metric unit.
type MetricUnit string

const (
	// MetricUnitBytes The number of bytes.
	MetricUnitBytes MetricUnit = "Bytes"
	// MetricUnitCount The count.
	MetricUnitCount MetricUnit = "Count"
	// MetricUnitMilliseconds The number of milliseconds.
	MetricUnitMilliseconds MetricUnit = "Milliseconds"
)

// PossibleMetricUnitValues returns an array of possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{MetricUnitBytes, MetricUnitCount, MetricUnitMilliseconds}
}

// VideoType enumerates the values for video type.
type VideoType string

const (
	// VideoTypeArchive Archive is flexible format that represents a video stream associated with wall-clock
	// time. The video archive can either be continuous or discontinuous. An archive is discontinuous when
	// there are gaps in the recording due to various reasons, such as the live pipeline being stopped, camera
	// being disconnected or due to the use of event based recordings through the use of a signal gate.
	// Finally, there is no limit to the archive duration and new video data can be appended to the existing
	// archive at any time, as long as the same video codec and codec parameters are being used.
	VideoTypeArchive VideoType = "Archive"
)

// PossibleVideoTypeValues returns an array of possible values for the VideoType const type.
func PossibleVideoTypeValues() []VideoType {
	return []VideoType{VideoTypeArchive}
}
