package storagepool

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/storagepool/mgmt/2020-03-15-preview/storagepool"

// ACL access Control List (ACL) for an iSCSI target lun
type ACL struct {
	// InitiatorIqn - iSCSI initiator iqn (iSCSI Qualified Name); example: iqn.2005-03.org.iscsi:client
	InitiatorIqn *string `json:"initiatorIqn,omitempty"`
	// MappedLuns - Array of lun names mapped to the ACL
	MappedLuns *[]string `json:"mappedLuns,omitempty"`
	// IscsiTargetCredentials - CHAP credentials for iSCSI target.
	*IscsiTargetCredentials `json:"credentials,omitempty"`
}

// MarshalJSON is the custom marshaler for ACL.
func (a ACL) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.InitiatorIqn != nil {
		objectMap["initiatorIqn"] = a.InitiatorIqn
	}
	if a.MappedLuns != nil {
		objectMap["mappedLuns"] = a.MappedLuns
	}
	if a.IscsiTargetCredentials != nil {
		objectMap["credentials"] = a.IscsiTargetCredentials
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ACL struct.
func (a *ACL) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "initiatorIqn":
			if v != nil {
				var initiatorIqn string
				err = json.Unmarshal(*v, &initiatorIqn)
				if err != nil {
					return err
				}
				a.InitiatorIqn = &initiatorIqn
			}
		case "mappedLuns":
			if v != nil {
				var mappedLuns []string
				err = json.Unmarshal(*v, &mappedLuns)
				if err != nil {
					return err
				}
				a.MappedLuns = &mappedLuns
			}
		case "credentials":
			if v != nil {
				var iscsiTargetCredentials IscsiTargetCredentials
				err = json.Unmarshal(*v, &iscsiTargetCredentials)
				if err != nil {
					return err
				}
				a.IscsiTargetCredentials = &iscsiTargetCredentials
			}
		}
	}

	return nil
}

// Attributes attributes of an iSCSI target
type Attributes struct {
	// Authentication - Indicates whether or not authentication is enabled on the ACL.
	Authentication *bool `json:"authentication,omitempty"`
	// ProdModeWriteProtect - Indicates whether or not write protect is enabled on the luns.
	ProdModeWriteProtect *bool `json:"prodModeWriteProtect,omitempty"`
}

// Disk managed disk to attach to the DiskPool. Required.
type Disk struct {
	// ID - Unique Azure resource id of the managed disk. Required.
	ID *string `json:"id,omitempty"`
}

// DiskPool request payload for Create or Update Disk Pool requests.
type DiskPool struct {
	autorest.Response `json:"-"`
	// DiskPoolProperties - RP defined properties for Disk Pool operations.
	*DiskPoolProperties `json:"properties,omitempty"`
	// Sku - Sku description.
	Sku *Sku `json:"sku,omitempty"`
	// SystemData - READ-ONLY; Resource metadata required by ARM RPC
	SystemData *SystemMetadata `json:"systemData,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskPool.
func (dp DiskPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.DiskPoolProperties != nil {
		objectMap["properties"] = dp.DiskPoolProperties
	}
	if dp.Sku != nil {
		objectMap["sku"] = dp.Sku
	}
	if dp.Tags != nil {
		objectMap["tags"] = dp.Tags
	}
	if dp.Location != nil {
		objectMap["location"] = dp.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiskPool struct.
func (dp *DiskPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diskPoolProperties DiskPoolProperties
				err = json.Unmarshal(*v, &diskPoolProperties)
				if err != nil {
					return err
				}
				dp.DiskPoolProperties = &diskPoolProperties
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				dp.Sku = &sku
			}
		case "systemData":
			if v != nil {
				var systemData SystemMetadata
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dp.SystemData = &systemData
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dp.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dp.Type = &typeVar
			}
		}
	}

	return nil
}

// DiskPoolListResult list of Disk Pools
type DiskPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of Disk Pool objects.
	Value *[]DiskPool `json:"value,omitempty"`
	// NextLink - READ-ONLY; URI to fetch the next section of the paginated response.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskPoolListResult.
func (dplr DiskPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dplr.Value != nil {
		objectMap["value"] = dplr.Value
	}
	return json.Marshal(objectMap)
}

// DiskPoolListResultIterator provides access to a complete listing of DiskPool values.
type DiskPoolListResultIterator struct {
	i    int
	page DiskPoolListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiskPoolListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskPoolListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiskPoolListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiskPoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiskPoolListResultIterator) Response() DiskPoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiskPoolListResultIterator) Value() DiskPool {
	if !iter.page.NotDone() {
		return DiskPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiskPoolListResultIterator type.
func NewDiskPoolListResultIterator(page DiskPoolListResultPage) DiskPoolListResultIterator {
	return DiskPoolListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dplr DiskPoolListResult) IsEmpty() bool {
	return dplr.Value == nil || len(*dplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dplr DiskPoolListResult) hasNextLink() bool {
	return dplr.NextLink != nil && len(*dplr.NextLink) != 0
}

// diskPoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dplr DiskPoolListResult) diskPoolListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dplr.NextLink)))
}

// DiskPoolListResultPage contains a page of DiskPool values.
type DiskPoolListResultPage struct {
	fn   func(context.Context, DiskPoolListResult) (DiskPoolListResult, error)
	dplr DiskPoolListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiskPoolListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskPoolListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dplr)
		if err != nil {
			return err
		}
		page.dplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiskPoolListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiskPoolListResultPage) NotDone() bool {
	return !page.dplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiskPoolListResultPage) Response() DiskPoolListResult {
	return page.dplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiskPoolListResultPage) Values() []DiskPool {
	if page.dplr.IsEmpty() {
		return nil
	}
	return *page.dplr.Value
}

// Creates a new instance of the DiskPoolListResultPage type.
func NewDiskPoolListResultPage(cur DiskPoolListResult, getNextPage func(context.Context, DiskPoolListResult) (DiskPoolListResult, error)) DiskPoolListResultPage {
	return DiskPoolListResultPage{
		fn:   getNextPage,
		dplr: cur,
	}
}

// DiskPoolProperties properties section of the Disk Pool request payload.
type DiskPoolProperties struct {
	// ProvisioningState - READ-ONLY; State of the operation on the resource. Possible values include: 'ProvisioningStatesInvalid', 'ProvisioningStatesSucceeded', 'ProvisioningStatesFailed', 'ProvisioningStatesCanceled', 'ProvisioningStatesPending', 'ProvisioningStatesCreating', 'ProvisioningStatesUpdating', 'ProvisioningStatesDeleting'
	ProvisioningState ProvisioningStates `json:"provisioningState,omitempty"`
	// AvailabilityZones - Logical zone for DiskPool resource.
	AvailabilityZones *[]string `json:"availabilityZones,omitempty"`
	// Status - READ-ONLY; Operational status of the Disk pool. Possible values include: 'Invalid', 'Unknown', 'Healthy', 'Unhealthy'
	Status OperationalStatus `json:"status,omitempty"`
	// Disks - List of Azure managed disks to attach to a DiskPool
	Disks *[]Disk `json:"disks,omitempty"`
	// SubnetID - Azure resource id of the subnet for the DiskPool
	SubnetID *string `json:"subnetId,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskPoolProperties.
func (dpp DiskPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dpp.AvailabilityZones != nil {
		objectMap["availabilityZones"] = dpp.AvailabilityZones
	}
	if dpp.Disks != nil {
		objectMap["disks"] = dpp.Disks
	}
	if dpp.SubnetID != nil {
		objectMap["subnetId"] = dpp.SubnetID
	}
	return json.Marshal(objectMap)
}

// DiskPoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DiskPoolsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskPoolsClient) (DiskPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskPoolsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskPoolsCreateOrUpdateFuture.Result.
func (future *DiskPoolsCreateOrUpdateFuture) result(client DiskPoolsClient) (dp DiskPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.DiskPoolsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagepool.DiskPoolsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dp.Response.Response, err = future.GetResult(sender); err == nil && dp.Response.Response.StatusCode != http.StatusNoContent {
		dp, err = client.CreateOrUpdateResponder(dp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storagepool.DiskPoolsCreateOrUpdateFuture", "Result", dp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DiskPoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DiskPoolsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskPoolsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskPoolsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskPoolsDeleteFuture.Result.
func (future *DiskPoolsDeleteFuture) result(client DiskPoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.DiskPoolsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagepool.DiskPoolsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Error the resource management error response.
type Error struct {
	// Error - RP error response
	Error *ErrorResponse `json:"error,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorResponse the resource management error response.
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponse `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// IscsiLun lun to expose the ManagedDisk.
type IscsiLun struct {
	// Name - Lun name.
	Name *string `json:"name,omitempty"`
	// ManagedDiskAzureResourceID - Unique Azure resource id of the managed disk. Required.
	ManagedDiskAzureResourceID *string `json:"managedDiskAzureResourceId,omitempty"`
}

// IscsiTarget payload for iSCSI Target Create or Update requests.
type IscsiTarget struct {
	autorest.Response `json:"-"`
	// IscsiTargetProperties - RP defined properties for iSCSI Target operations.
	*IscsiTargetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IscsiTarget.
func (it IscsiTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if it.IscsiTargetProperties != nil {
		objectMap["properties"] = it.IscsiTargetProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IscsiTarget struct.
func (it *IscsiTarget) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var iscsiTargetProperties IscsiTargetProperties
				err = json.Unmarshal(*v, &iscsiTargetProperties)
				if err != nil {
					return err
				}
				it.IscsiTargetProperties = &iscsiTargetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				it.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				it.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				it.Type = &typeVar
			}
		}
	}

	return nil
}

// IscsiTargetCredentials CHAP credentials for an iSCSI target
type IscsiTargetCredentials struct {
	// Username - Username for Challenge Handshake Authentication Protocol (CHAP) authentication
	Username *string `json:"username,omitempty"`
	// Password - Password for Challenge Handshake Authentication Protocol (CHAP) authentication
	Password *string `json:"password,omitempty"`
}

// IscsiTargetList list of iSCSI Targets.
type IscsiTargetList struct {
	autorest.Response `json:"-"`
	// Value - An array of iSCSI targets within a Disk Pool.
	Value *[]IscsiTarget `json:"value,omitempty"`
	// NextLink - READ-ONLY; URI to fetch the next section of the paginated response.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for IscsiTargetList.
func (itl IscsiTargetList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itl.Value != nil {
		objectMap["value"] = itl.Value
	}
	return json.Marshal(objectMap)
}

// IscsiTargetListIterator provides access to a complete listing of IscsiTarget values.
type IscsiTargetListIterator struct {
	i    int
	page IscsiTargetListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IscsiTargetListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IscsiTargetListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IscsiTargetListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IscsiTargetListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IscsiTargetListIterator) Response() IscsiTargetList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IscsiTargetListIterator) Value() IscsiTarget {
	if !iter.page.NotDone() {
		return IscsiTarget{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IscsiTargetListIterator type.
func NewIscsiTargetListIterator(page IscsiTargetListPage) IscsiTargetListIterator {
	return IscsiTargetListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (itl IscsiTargetList) IsEmpty() bool {
	return itl.Value == nil || len(*itl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (itl IscsiTargetList) hasNextLink() bool {
	return itl.NextLink != nil && len(*itl.NextLink) != 0
}

// iscsiTargetListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (itl IscsiTargetList) iscsiTargetListPreparer(ctx context.Context) (*http.Request, error) {
	if !itl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(itl.NextLink)))
}

// IscsiTargetListPage contains a page of IscsiTarget values.
type IscsiTargetListPage struct {
	fn  func(context.Context, IscsiTargetList) (IscsiTargetList, error)
	itl IscsiTargetList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IscsiTargetListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IscsiTargetListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.itl)
		if err != nil {
			return err
		}
		page.itl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IscsiTargetListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IscsiTargetListPage) NotDone() bool {
	return !page.itl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IscsiTargetListPage) Response() IscsiTargetList {
	return page.itl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IscsiTargetListPage) Values() []IscsiTarget {
	if page.itl.IsEmpty() {
		return nil
	}
	return *page.itl.Value
}

// Creates a new instance of the IscsiTargetListPage type.
func NewIscsiTargetListPage(cur IscsiTargetList, getNextPage func(context.Context, IscsiTargetList) (IscsiTargetList, error)) IscsiTargetListPage {
	return IscsiTargetListPage{
		fn:  getNextPage,
		itl: cur,
	}
}

// IscsiTargetProperties properties of iSCSI Target request payload.
type IscsiTargetProperties struct {
	// ProvisioningState - READ-ONLY; State of the operation on the resource. Possible values include: 'ProvisioningStatesInvalid', 'ProvisioningStatesSucceeded', 'ProvisioningStatesFailed', 'ProvisioningStatesCanceled', 'ProvisioningStatesPending', 'ProvisioningStatesCreating', 'ProvisioningStatesUpdating', 'ProvisioningStatesDeleting'
	ProvisioningState ProvisioningStates `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; Operational status of the Disk pool. Possible values include: 'Invalid', 'Unknown', 'Healthy', 'Unhealthy'
	Status OperationalStatus `json:"status,omitempty"`
	// Tpgs - list of iSCSI target portal groups
	Tpgs *[]TargetPortalGroup `json:"tpgs,omitempty"`
	// TargetIqn - iSCSI target iqn (iSCSI Qualified Name); example: iqn.2005-03.org.iscsi:server
	TargetIqn *string `json:"targetIqn,omitempty"`
}

// MarshalJSON is the custom marshaler for IscsiTargetProperties.
func (itp IscsiTargetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itp.Tpgs != nil {
		objectMap["tpgs"] = itp.Tpgs
	}
	if itp.TargetIqn != nil {
		objectMap["targetIqn"] = itp.TargetIqn
	}
	return json.Marshal(objectMap)
}

// IscsiTargetsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IscsiTargetsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IscsiTargetsClient) (IscsiTarget, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IscsiTargetsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IscsiTargetsCreateOrUpdateFuture.Result.
func (future *IscsiTargetsCreateOrUpdateFuture) result(client IscsiTargetsClient) (it IscsiTarget, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.IscsiTargetsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		it.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagepool.IscsiTargetsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if it.Response.Response, err = future.GetResult(sender); err == nil && it.Response.Response.StatusCode != http.StatusNoContent {
		it, err = client.CreateOrUpdateResponder(it.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storagepool.IscsiTargetsCreateOrUpdateFuture", "Result", it.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IscsiTargetsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IscsiTargetsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IscsiTargetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IscsiTargetsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IscsiTargetsDeleteFuture.Result.
func (future *IscsiTargetsDeleteFuture) result(client IscsiTargetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.IscsiTargetsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagepool.IscsiTargetsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// OperationDisplay metadata about an operation.
type OperationDisplay struct {
	// Provider - Localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - Localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - Localized friendly name for the operation, as it should be shown to the user.
	Operation *string `json:"operation,omitempty"`
	// Description - Localized friendly description for the operation, as it should be shown to the user.
	Description *string `json:"description,omitempty"`
}

// OperationListResult list of operations supported by the RP.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of operations supported by the StoragePool RP.
	Value *[]RPOperation `json:"value,omitempty"`
	// NextLink - URI to fetch the next section of the paginated response.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// Resource ARM resource model definition.
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// RPOperation description of a StoragePool RP Operation
type RPOperation struct {
	// Name - The name of the operation being performed on this particular object
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation applies to data-plane.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// ActionType - Indicates the action type.
	ActionType *string `json:"actionType,omitempty"`
	// Display - Additional metadata about RP operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs UX.
	Origin *string `json:"origin,omitempty"`
}

// Sku the resource model definition representing SKU
type Sku struct {
	// Name - The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`
	// Tier - This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT. Possible values include: 'Free', 'Basic', 'Standard', 'Premium'
	Tier SkuTier `json:"tier,omitempty"`
	// Size - The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// Capacity - If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`
}

// SystemMetadata resource metadata required by ARM RPC
type SystemMetadata struct {
	// CreatedBy - A string identifier for the identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource: user, application, managedIdentity
	CreatedByType *string `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC)
	CreatedAt *string `json:"createdAt,omitempty"`
	// LastModifiedBy - A string identifier for the identity that last modified the resource
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource: user, application, managedIdentity
	LastModifiedByType *string `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *string `json:"lastModifiedAt,omitempty"`
}

// TargetPortalGroup iSCSI target portal group
type TargetPortalGroup struct {
	// Luns - Lun list to be exposed through the iSCSI target. Required
	Luns *[]IscsiLun `json:"luns,omitempty"`
	// Acls - Access Control List (ACL) for an iSCSI target lun
	Acls *[]ACL `json:"acls,omitempty"`
	// Attributes - Attributes of an iSCSI target
	Attributes *Attributes `json:"attributes,omitempty"`
	// Endpoints - READ-ONLY; list of public ip addresses to connect to the iSCSI target
	Endpoints *[]string `json:"endpoints,omitempty"`
	// Tag - READ-ONLY; The tag associated with the iSCSI target portal group
	Tag *int32 `json:"tag,omitempty"`
	// Port - READ-ONLY; The port at which the iSCSI target is available
	Port *int32 `json:"port,omitempty"`
}

// MarshalJSON is the custom marshaler for TargetPortalGroup.
func (tpg TargetPortalGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tpg.Luns != nil {
		objectMap["luns"] = tpg.Luns
	}
	if tpg.Acls != nil {
		objectMap["acls"] = tpg.Acls
	}
	if tpg.Attributes != nil {
		objectMap["attributes"] = tpg.Attributes
	}
	return json.Marshal(objectMap)
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}
