package web

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"io"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/web/mgmt/2015-08-01-preview/web"

// Address address information for domain registration
type Address struct {
	// Address1 - Address 1
	Address1 *string `json:"address1,omitempty"`
	// Address2 - Address 2
	Address2 *string `json:"address2,omitempty"`
	// City - City
	City *string `json:"city,omitempty"`
	// Country - Country
	Country *string `json:"country,omitempty"`
	// PostalCode - Postal code
	PostalCode *string `json:"postalCode,omitempty"`
	// State - State
	State *string `json:"state,omitempty"`
}

// AddressResponse describes main public ip address and any extra vips
type AddressResponse struct {
	autorest.Response `json:"-"`
	// ServiceIPAddress - Main public vip
	ServiceIPAddress *string `json:"serviceIpAddress,omitempty"`
	// InternalIPAddress - VNET internal ip address of the hostingEnvironment (App Service Environment) if it is in internal load-balancing mode
	InternalIPAddress *string `json:"internalIpAddress,omitempty"`
	// OutboundIPAddresses - IP addresses appearing on outbound connections
	OutboundIPAddresses *[]string `json:"outboundIpAddresses,omitempty"`
	// VipMappings - Additional vips
	VipMappings *[]VirtualIPMapping `json:"vipMappings,omitempty"`
}

// APIDefinitionInfo information about the formal API definition for the web app.
type APIDefinitionInfo struct {
	// URL - The URL of the API definition.
	URL *string `json:"url,omitempty"`
}

// APIEntity API Management
type APIEntity struct {
	autorest.Response    `json:"-"`
	*APIEntityProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for APIEntity.
func (ae APIEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ae.APIEntityProperties != nil {
		objectMap["properties"] = ae.APIEntityProperties
	}
	if ae.ID != nil {
		objectMap["id"] = ae.ID
	}
	if ae.Name != nil {
		objectMap["name"] = ae.Name
	}
	if ae.Kind != nil {
		objectMap["kind"] = ae.Kind
	}
	if ae.Location != nil {
		objectMap["location"] = ae.Location
	}
	if ae.Type != nil {
		objectMap["type"] = ae.Type
	}
	if ae.Tags != nil {
		objectMap["tags"] = ae.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for APIEntity struct.
func (ae *APIEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var APIEntityProperties APIEntityProperties
				err = json.Unmarshal(*v, &APIEntityProperties)
				if err != nil {
					return err
				}
				ae.APIEntityProperties = &APIEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ae.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ae.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ae.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ae.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ae.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ae.Tags = tags
			}
		}
	}

	return nil
}

// APIEntityProperties ...
type APIEntityProperties struct {
	// Name - Name of the API
	//             the URL path of this API when exposed via APIM
	Name *string `json:"name,omitempty"`
	// GeneralInformation - the URL path of this API when exposed via APIM
	GeneralInformation *GeneralAPIInformation `json:"generalInformation,omitempty"`
	// Path - the URL path of this API when exposed via APIM
	Path *string `json:"path,omitempty"`
	// RuntimeUrls - Read only property returning the runtime endpoints where the API can be called
	RuntimeUrls *[]string `json:"runtimeUrls,omitempty"`
	// Protocols - Protocols supported by the front end - http/https
	Protocols *[]string `json:"protocols,omitempty"`
	// Policies - API policies
	Policies *APIPolicies `json:"policies,omitempty"`
	// BackendService - Backend service definition
	BackendService *BackendServiceDefinition `json:"backendService,omitempty"`
	// APIDefinitionURL - API definition Url - url where the swagger can be downloaded from
	APIDefinitionURL *string `json:"apiDefinitionUrl,omitempty"`
	// Metadata - Free form object for the data caller wants to store
	Metadata interface{} `json:"metadata,omitempty"`
	// Capabilities - Capabilities
	Capabilities *[]string `json:"capabilities,omitempty"`
	// ConnectionParameters - Connection parameters
	ConnectionParameters map[string]*ConnectionParameter `json:"connectionParameters"`
	// CreatedTime - Timestamp of the connection creation
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - Timestamp of last connection change.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
}

// MarshalJSON is the custom marshaler for APIEntityProperties.
func (ae APIEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ae.Name != nil {
		objectMap["name"] = ae.Name
	}
	if ae.GeneralInformation != nil {
		objectMap["generalInformation"] = ae.GeneralInformation
	}
	if ae.Path != nil {
		objectMap["path"] = ae.Path
	}
	if ae.RuntimeUrls != nil {
		objectMap["runtimeUrls"] = ae.RuntimeUrls
	}
	if ae.Protocols != nil {
		objectMap["protocols"] = ae.Protocols
	}
	if ae.Policies != nil {
		objectMap["policies"] = ae.Policies
	}
	if ae.BackendService != nil {
		objectMap["backendService"] = ae.BackendService
	}
	if ae.APIDefinitionURL != nil {
		objectMap["apiDefinitionUrl"] = ae.APIDefinitionURL
	}
	if ae.Metadata != nil {
		objectMap["metadata"] = ae.Metadata
	}
	if ae.Capabilities != nil {
		objectMap["capabilities"] = ae.Capabilities
	}
	if ae.ConnectionParameters != nil {
		objectMap["connectionParameters"] = ae.ConnectionParameters
	}
	if ae.CreatedTime != nil {
		objectMap["createdTime"] = ae.CreatedTime
	}
	if ae.ChangedTime != nil {
		objectMap["changedTime"] = ae.ChangedTime
	}
	return json.Marshal(objectMap)
}

// APIOAuthSettings oAuth settings for the connection provider
type APIOAuthSettings struct {
	// IdentityProvider - Identity provider
	IdentityProvider *string `json:"identityProvider,omitempty"`
	// ClientID - Resource provider client id
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client Secret needed for OAuth
	ClientSecret *string `json:"clientSecret,omitempty"`
	// Scopes - OAuth scopes
	Scopes *[]string `json:"scopes,omitempty"`
	// RedirectURL - Url
	RedirectURL *string `json:"redirectUrl,omitempty"`
	// Properties - Read only properties for this oauth setting.
	Properties interface{} `json:"properties,omitempty"`
	// CustomParameters - OAuth parameters key is the name of parameter
	CustomParameters map[string]*APIOAuthSettingsParameter `json:"customParameters"`
}

// MarshalJSON is the custom marshaler for APIOAuthSettings.
func (aoas APIOAuthSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aoas.IdentityProvider != nil {
		objectMap["identityProvider"] = aoas.IdentityProvider
	}
	if aoas.ClientID != nil {
		objectMap["clientId"] = aoas.ClientID
	}
	if aoas.ClientSecret != nil {
		objectMap["clientSecret"] = aoas.ClientSecret
	}
	if aoas.Scopes != nil {
		objectMap["scopes"] = aoas.Scopes
	}
	if aoas.RedirectURL != nil {
		objectMap["redirectUrl"] = aoas.RedirectURL
	}
	if aoas.Properties != nil {
		objectMap["properties"] = aoas.Properties
	}
	if aoas.CustomParameters != nil {
		objectMap["customParameters"] = aoas.CustomParameters
	}
	return json.Marshal(objectMap)
}

// APIOAuthSettingsParameter oAuth Settings Parameter
type APIOAuthSettingsParameter struct {
	// Value - Value
	Value *string `json:"value,omitempty"`
	// Options - Read only: Options available to this parameter
	Options interface{} `json:"options,omitempty"`
	// UIDefinition - UI definitions per culture as caller can specify the culture
	UIDefinition interface{} `json:"uiDefinition,omitempty"`
}

// APIPolicies API policies
type APIPolicies struct {
	*APIPoliciesProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for APIPolicies.
func (ap APIPolicies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.APIPoliciesProperties != nil {
		objectMap["properties"] = ap.APIPoliciesProperties
	}
	if ap.ID != nil {
		objectMap["id"] = ap.ID
	}
	if ap.Name != nil {
		objectMap["name"] = ap.Name
	}
	if ap.Kind != nil {
		objectMap["kind"] = ap.Kind
	}
	if ap.Location != nil {
		objectMap["location"] = ap.Location
	}
	if ap.Type != nil {
		objectMap["type"] = ap.Type
	}
	if ap.Tags != nil {
		objectMap["tags"] = ap.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for APIPolicies struct.
func (ap *APIPolicies) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var APIPoliciesProperties APIPoliciesProperties
				err = json.Unmarshal(*v, &APIPoliciesProperties)
				if err != nil {
					return err
				}
				ap.APIPoliciesProperties = &APIPoliciesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ap.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ap.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ap.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ap.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ap.Tags = tags
			}
		}
	}

	return nil
}

// APIPoliciesProperties ...
type APIPoliciesProperties struct {
	// Content - Content of xml policy
	Content *string `json:"content,omitempty"`
}

// ApisCollection collection of Apis
type ApisCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]APIEntity `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// ApisCollectionIterator provides access to a complete listing of APIEntity values.
type ApisCollectionIterator struct {
	i    int
	page ApisCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApisCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApisCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApisCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApisCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApisCollectionIterator) Response() ApisCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApisCollectionIterator) Value() APIEntity {
	if !iter.page.NotDone() {
		return APIEntity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApisCollectionIterator type.
func NewApisCollectionIterator(page ApisCollectionPage) ApisCollectionIterator {
	return ApisCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ac ApisCollection) IsEmpty() bool {
	return ac.Value == nil || len(*ac.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ac ApisCollection) hasNextLink() bool {
	return ac.NextLink != nil && len(*ac.NextLink) != 0
}

// apisCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ac ApisCollection) apisCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ac.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ac.NextLink)))
}

// ApisCollectionPage contains a page of APIEntity values.
type ApisCollectionPage struct {
	fn func(context.Context, ApisCollection) (ApisCollection, error)
	ac ApisCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApisCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApisCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ac)
		if err != nil {
			return err
		}
		page.ac = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApisCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApisCollectionPage) NotDone() bool {
	return !page.ac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApisCollectionPage) Response() ApisCollection {
	return page.ac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApisCollectionPage) Values() []APIEntity {
	if page.ac.IsEmpty() {
		return nil
	}
	return *page.ac.Value
}

// Creates a new instance of the ApisCollectionPage type.
func NewApisCollectionPage(cur ApisCollection, getNextPage func(context.Context, ApisCollection) (ApisCollection, error)) ApisCollectionPage {
	return ApisCollectionPage{
		fn: getNextPage,
		ac: cur,
	}
}

// ApplicationLogsConfig application logs configuration
type ApplicationLogsConfig struct {
	// FileSystem - Application logs to file system configuration
	FileSystem *FileSystemApplicationLogsConfig `json:"fileSystem,omitempty"`
	// AzureTableStorage - Application logs to azure table storage configuration
	AzureTableStorage *AzureTableStorageApplicationLogsConfig `json:"azureTableStorage,omitempty"`
	// AzureBlobStorage - Application logs to blob storage configuration
	AzureBlobStorage *AzureBlobStorageApplicationLogsConfig `json:"azureBlobStorage,omitempty"`
}

// ArmPlan the plan object in an ARM, represents a marketplace plan
type ArmPlan struct {
	// Name - The name
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher
	Publisher *string `json:"publisher,omitempty"`
	// Product - The product
	Product *string `json:"product,omitempty"`
	// PromotionCode - The promotion code
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - Version of product
	Version *string `json:"version,omitempty"`
}

// AutoHealActions autoHealActions - Describes the actions which can be
// taken by the auto-heal module when a rule is triggered.
type AutoHealActions struct {
	// ActionType - ActionType - predefined action to be taken. Possible values include: 'Recycle', 'LogEvent', 'CustomAction'
	ActionType AutoHealActionType `json:"actionType,omitempty"`
	// CustomAction - CustomAction - custom action to be taken
	CustomAction *AutoHealCustomAction `json:"customAction,omitempty"`
	// MinProcessExecutionTime - MinProcessExecutionTime - minimum time the process must execute
	//             before taking the action
	MinProcessExecutionTime *string `json:"minProcessExecutionTime,omitempty"`
}

// AutoHealCustomAction autoHealCustomAction - Describes the custom action to be executed
// when an auto heal rule is triggered.
type AutoHealCustomAction struct {
	// Exe - Executable to be run
	Exe *string `json:"exe,omitempty"`
	// Parameters - Parameters for the executable
	Parameters *string `json:"parameters,omitempty"`
}

// AutoHealRules autoHealRules - describes the rules which can be defined for auto-heal
type AutoHealRules struct {
	// Triggers - Triggers - Conditions that describe when to execute the auto-heal actions
	Triggers *AutoHealTriggers `json:"triggers,omitempty"`
	// Actions - Actions - Actions to be executed when a rule is triggered
	Actions *AutoHealActions `json:"actions,omitempty"`
}

// AutoHealTriggers autoHealTriggers - describes the triggers for auto-heal.
type AutoHealTriggers struct {
	// Requests - Requests - Defines a rule based on total requests
	Requests *RequestsBasedTrigger `json:"requests,omitempty"`
	// PrivateBytesInKB - PrivateBytesInKB - Defines a rule based on private bytes
	PrivateBytesInKB *int32 `json:"privateBytesInKB,omitempty"`
	// StatusCodes - StatusCodes - Defines a rule based on status codes
	StatusCodes *[]StatusCodesBasedTrigger `json:"statusCodes,omitempty"`
	// SlowRequests - SlowRequests - Defines a rule based on request execution time
	SlowRequests *SlowRequestsBasedTrigger `json:"slowRequests,omitempty"`
}

// AzureBlobStorageApplicationLogsConfig application logs azure blob storage configuration
type AzureBlobStorageApplicationLogsConfig struct {
	// Level - Log level. Possible values include: 'LogLevelOff', 'LogLevelVerbose', 'LogLevelInformation', 'LogLevelWarning', 'LogLevelError'
	Level LogLevel `json:"level,omitempty"`
	// SasURL - SAS url to a azure blob container with read/write/list/delete permissions
	SasURL *string `json:"sasUrl,omitempty"`
	// RetentionInDays - Retention in days.
	//             Remove blobs older than X days.
	//             0 or lower means no retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
}

// AzureBlobStorageHTTPLogsConfig http logs to azure blob storage configuration
type AzureBlobStorageHTTPLogsConfig struct {
	// SasURL - SAS url to a azure blob container with read/write/list/delete permissions
	SasURL *string `json:"sasUrl,omitempty"`
	// RetentionInDays - Retention in days.
	//             Remove blobs older than X days.
	//             0 or lower means no retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
	// Enabled - Enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// AzureTableStorageApplicationLogsConfig application logs to azure table storage configuration
type AzureTableStorageApplicationLogsConfig struct {
	// Level - Log level. Possible values include: 'LogLevelOff', 'LogLevelVerbose', 'LogLevelInformation', 'LogLevelWarning', 'LogLevelError'
	Level LogLevel `json:"level,omitempty"`
	// SasURL - SAS url to an azure table with add/query/delete permissions
	SasURL *string `json:"sasUrl,omitempty"`
}

// BackendServiceDefinition API definitions with backend urls
type BackendServiceDefinition struct {
	*BackendServiceDefinitionProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BackendServiceDefinition.
func (bsd BackendServiceDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bsd.BackendServiceDefinitionProperties != nil {
		objectMap["properties"] = bsd.BackendServiceDefinitionProperties
	}
	if bsd.ID != nil {
		objectMap["id"] = bsd.ID
	}
	if bsd.Name != nil {
		objectMap["name"] = bsd.Name
	}
	if bsd.Kind != nil {
		objectMap["kind"] = bsd.Kind
	}
	if bsd.Location != nil {
		objectMap["location"] = bsd.Location
	}
	if bsd.Type != nil {
		objectMap["type"] = bsd.Type
	}
	if bsd.Tags != nil {
		objectMap["tags"] = bsd.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackendServiceDefinition struct.
func (bsd *BackendServiceDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backendServiceDefinitionProperties BackendServiceDefinitionProperties
				err = json.Unmarshal(*v, &backendServiceDefinitionProperties)
				if err != nil {
					return err
				}
				bsd.BackendServiceDefinitionProperties = &backendServiceDefinitionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bsd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bsd.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				bsd.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bsd.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bsd.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bsd.Tags = tags
			}
		}
	}

	return nil
}

// BackendServiceDefinitionProperties ...
type BackendServiceDefinitionProperties struct {
	// ServiceURL - Url from which the swagger payload will be fetched
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// HostingEnvironmentServiceUrls - Service Urls per Hosting environment
	HostingEnvironmentServiceUrls *[]HostingEnvironmentServiceDescriptions `json:"hostingEnvironmentServiceUrls,omitempty"`
}

// BackupItem backup description
type BackupItem struct {
	autorest.Response     `json:"-"`
	*BackupItemProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BackupItem.
func (bi BackupItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bi.BackupItemProperties != nil {
		objectMap["properties"] = bi.BackupItemProperties
	}
	if bi.ID != nil {
		objectMap["id"] = bi.ID
	}
	if bi.Name != nil {
		objectMap["name"] = bi.Name
	}
	if bi.Kind != nil {
		objectMap["kind"] = bi.Kind
	}
	if bi.Location != nil {
		objectMap["location"] = bi.Location
	}
	if bi.Type != nil {
		objectMap["type"] = bi.Type
	}
	if bi.Tags != nil {
		objectMap["tags"] = bi.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupItem struct.
func (bi *BackupItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backupItemProperties BackupItemProperties
				err = json.Unmarshal(*v, &backupItemProperties)
				if err != nil {
					return err
				}
				bi.BackupItemProperties = &backupItemProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bi.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				bi.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bi.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bi.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bi.Tags = tags
			}
		}
	}

	return nil
}

// BackupItemCollection collection of Backup Items
type BackupItemCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]BackupItem `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// BackupItemCollectionIterator provides access to a complete listing of BackupItem values.
type BackupItemCollectionIterator struct {
	i    int
	page BackupItemCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BackupItemCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupItemCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BackupItemCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BackupItemCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BackupItemCollectionIterator) Response() BackupItemCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BackupItemCollectionIterator) Value() BackupItem {
	if !iter.page.NotDone() {
		return BackupItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BackupItemCollectionIterator type.
func NewBackupItemCollectionIterator(page BackupItemCollectionPage) BackupItemCollectionIterator {
	return BackupItemCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bic BackupItemCollection) IsEmpty() bool {
	return bic.Value == nil || len(*bic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bic BackupItemCollection) hasNextLink() bool {
	return bic.NextLink != nil && len(*bic.NextLink) != 0
}

// backupItemCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bic BackupItemCollection) backupItemCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !bic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bic.NextLink)))
}

// BackupItemCollectionPage contains a page of BackupItem values.
type BackupItemCollectionPage struct {
	fn  func(context.Context, BackupItemCollection) (BackupItemCollection, error)
	bic BackupItemCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BackupItemCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupItemCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bic)
		if err != nil {
			return err
		}
		page.bic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BackupItemCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BackupItemCollectionPage) NotDone() bool {
	return !page.bic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BackupItemCollectionPage) Response() BackupItemCollection {
	return page.bic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BackupItemCollectionPage) Values() []BackupItem {
	if page.bic.IsEmpty() {
		return nil
	}
	return *page.bic.Value
}

// Creates a new instance of the BackupItemCollectionPage type.
func NewBackupItemCollectionPage(cur BackupItemCollection, getNextPage func(context.Context, BackupItemCollection) (BackupItemCollection, error)) BackupItemCollectionPage {
	return BackupItemCollectionPage{
		fn:  getNextPage,
		bic: cur,
	}
}

// BackupItemProperties ...
type BackupItemProperties struct {
	// ID - Id of the backup.
	ID *int32 `json:"id,omitempty"`
	// StorageAccountURL - SAS URL for the storage account container which contains this backup
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`
	// BlobName - Name of the blob which contains data for this backup
	BlobName *string `json:"blobName,omitempty"`
	// Name - Name of this backup
	Name *string `json:"name,omitempty"`
	// Status - Backup status. Possible values include: 'InProgress', 'Failed', 'Succeeded', 'TimedOut', 'Created', 'Skipped', 'PartiallySucceeded', 'DeleteInProgress', 'DeleteFailed', 'Deleted'
	Status BackupItemStatus `json:"status,omitempty"`
	// SizeInBytes - Size of the backup in bytes
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
	// Created - Timestamp of the backup creation
	Created *date.Time `json:"created,omitempty"`
	// Log - Details regarding this backup. Might contain an error message.
	Log *string `json:"log,omitempty"`
	// Databases - List of databases included in the backup
	Databases *[]DatabaseBackupSetting `json:"databases,omitempty"`
	// Scheduled - True if this backup has been created due to a schedule being triggered.
	Scheduled *bool `json:"scheduled,omitempty"`
	// LastRestoreTimeStamp - Timestamp of a last restore operation which used this backup.
	LastRestoreTimeStamp *date.Time `json:"lastRestoreTimeStamp,omitempty"`
	// FinishedTimeStamp - Timestamp when this backup finished.
	FinishedTimeStamp *date.Time `json:"finishedTimeStamp,omitempty"`
	// CorrelationID - Unique correlation identifier. Please use this along with the timestamp while communicating with Azure support.
	CorrelationID *string `json:"correlationId,omitempty"`
	// WebsiteSizeInBytes - Size of the original web app which has been backed up
	WebsiteSizeInBytes *int64 `json:"websiteSizeInBytes,omitempty"`
}

// BackupRequest description of a backup which will be performed
type BackupRequest struct {
	autorest.Response        `json:"-"`
	*BackupRequestProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BackupRequest.
func (br BackupRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if br.BackupRequestProperties != nil {
		objectMap["properties"] = br.BackupRequestProperties
	}
	if br.ID != nil {
		objectMap["id"] = br.ID
	}
	if br.Name != nil {
		objectMap["name"] = br.Name
	}
	if br.Kind != nil {
		objectMap["kind"] = br.Kind
	}
	if br.Location != nil {
		objectMap["location"] = br.Location
	}
	if br.Type != nil {
		objectMap["type"] = br.Type
	}
	if br.Tags != nil {
		objectMap["tags"] = br.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupRequest struct.
func (br *BackupRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backupRequestProperties BackupRequestProperties
				err = json.Unmarshal(*v, &backupRequestProperties)
				if err != nil {
					return err
				}
				br.BackupRequestProperties = &backupRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				br.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				br.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				br.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				br.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				br.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				br.Tags = tags
			}
		}
	}

	return nil
}

// BackupRequestProperties ...
type BackupRequestProperties struct {
	// Name - Name of the backup
	Name *string `json:"name,omitempty"`
	// Enabled - True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled
	Enabled *bool `json:"enabled,omitempty"`
	// StorageAccountURL - SAS URL to the container
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`
	// BackupSchedule - Schedule for the backup if it is executed periodically
	BackupSchedule *BackupSchedule `json:"backupSchedule,omitempty"`
	// Databases - Databases included in the backup
	Databases *[]DatabaseBackupSetting `json:"databases,omitempty"`
	// Type - Type of the backup. Possible values include: 'Default', 'Clone', 'Relocation'
	Type BackupRestoreOperationType `json:"type,omitempty"`
}

// BackupSchedule description of a backup schedule. Describes how often should be the backup performed and
// what should be the retention policy.
type BackupSchedule struct {
	// FrequencyInterval - How often should be the backup executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
	FrequencyInterval *int32 `json:"frequencyInterval,omitempty"`
	// FrequencyUnit - How often should be the backup executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7). Possible values include: 'Day', 'Hour'
	FrequencyUnit FrequencyUnit `json:"frequencyUnit,omitempty"`
	// KeepAtLeastOneBackup - True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
	KeepAtLeastOneBackup *bool `json:"keepAtLeastOneBackup,omitempty"`
	// RetentionPeriodInDays - After how many days backups should be deleted
	RetentionPeriodInDays *int32 `json:"retentionPeriodInDays,omitempty"`
	// StartTime - When the schedule should start working
	StartTime *date.Time `json:"startTime,omitempty"`
	// LastExecutionTime - The last time when this schedule was triggered
	LastExecutionTime *date.Time `json:"lastExecutionTime,omitempty"`
}

// Certificate app certificate
type Certificate struct {
	autorest.Response      `json:"-"`
	*CertificateProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Certificate.
func (c Certificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.CertificateProperties != nil {
		objectMap["properties"] = c.CertificateProperties
	}
	if c.ID != nil {
		objectMap["id"] = c.ID
	}
	if c.Name != nil {
		objectMap["name"] = c.Name
	}
	if c.Kind != nil {
		objectMap["kind"] = c.Kind
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	if c.Type != nil {
		objectMap["type"] = c.Type
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Certificate struct.
func (c *Certificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateProperties CertificateProperties
				err = json.Unmarshal(*v, &certificateProperties)
				if err != nil {
					return err
				}
				c.CertificateProperties = &certificateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				c.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		}
	}

	return nil
}

// CertificateCollection collection of certificates
type CertificateCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]Certificate `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateCollectionIterator provides access to a complete listing of Certificate values.
type CertificateCollectionIterator struct {
	i    int
	page CertificateCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateCollectionIterator) Response() CertificateCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateCollectionIterator) Value() Certificate {
	if !iter.page.NotDone() {
		return Certificate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateCollectionIterator type.
func NewCertificateCollectionIterator(page CertificateCollectionPage) CertificateCollectionIterator {
	return CertificateCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cc CertificateCollection) IsEmpty() bool {
	return cc.Value == nil || len(*cc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cc CertificateCollection) hasNextLink() bool {
	return cc.NextLink != nil && len(*cc.NextLink) != 0
}

// certificateCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cc CertificateCollection) certificateCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !cc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cc.NextLink)))
}

// CertificateCollectionPage contains a page of Certificate values.
type CertificateCollectionPage struct {
	fn func(context.Context, CertificateCollection) (CertificateCollection, error)
	cc CertificateCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cc)
		if err != nil {
			return err
		}
		page.cc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateCollectionPage) NotDone() bool {
	return !page.cc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateCollectionPage) Response() CertificateCollection {
	return page.cc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateCollectionPage) Values() []Certificate {
	if page.cc.IsEmpty() {
		return nil
	}
	return *page.cc.Value
}

// Creates a new instance of the CertificateCollectionPage type.
func NewCertificateCollectionPage(cur CertificateCollection, getNextPage func(context.Context, CertificateCollection) (CertificateCollection, error)) CertificateCollectionPage {
	return CertificateCollectionPage{
		fn: getNextPage,
		cc: cur,
	}
}

// CertificateDetails certificate Details
type CertificateDetails struct {
	*CertificateDetailsProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateDetails.
func (cd CertificateDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cd.CertificateDetailsProperties != nil {
		objectMap["properties"] = cd.CertificateDetailsProperties
	}
	if cd.ID != nil {
		objectMap["id"] = cd.ID
	}
	if cd.Name != nil {
		objectMap["name"] = cd.Name
	}
	if cd.Kind != nil {
		objectMap["kind"] = cd.Kind
	}
	if cd.Location != nil {
		objectMap["location"] = cd.Location
	}
	if cd.Type != nil {
		objectMap["type"] = cd.Type
	}
	if cd.Tags != nil {
		objectMap["tags"] = cd.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateDetails struct.
func (cd *CertificateDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateDetailsProperties CertificateDetailsProperties
				err = json.Unmarshal(*v, &certificateDetailsProperties)
				if err != nil {
					return err
				}
				cd.CertificateDetailsProperties = &certificateDetailsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cd.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cd.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cd.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cd.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cd.Tags = tags
			}
		}
	}

	return nil
}

// CertificateDetailsProperties ...
type CertificateDetailsProperties struct {
	// Version - Version
	Version *int32 `json:"version,omitempty"`
	// SerialNumber - Serial Number
	SerialNumber *string `json:"serialNumber,omitempty"`
	// Thumbprint - Thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Subject - Subject
	Subject *string `json:"subject,omitempty"`
	// NotBefore - Valid from
	NotBefore *date.Time `json:"notBefore,omitempty"`
	// NotAfter - Valid to
	NotAfter *date.Time `json:"notAfter,omitempty"`
	// SignatureAlgorithm - Signature Algorithm
	SignatureAlgorithm *string `json:"signatureAlgorithm,omitempty"`
	// Issuer - Issuer
	Issuer *string `json:"issuer,omitempty"`
	// RawData - Raw certificate data
	RawData *string `json:"rawData,omitempty"`
}

// CertificateEmail certificate Email
type CertificateEmail struct {
	*CertificateEmailProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateEmail.
func (ce CertificateEmail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ce.CertificateEmailProperties != nil {
		objectMap["properties"] = ce.CertificateEmailProperties
	}
	if ce.ID != nil {
		objectMap["id"] = ce.ID
	}
	if ce.Name != nil {
		objectMap["name"] = ce.Name
	}
	if ce.Kind != nil {
		objectMap["kind"] = ce.Kind
	}
	if ce.Location != nil {
		objectMap["location"] = ce.Location
	}
	if ce.Type != nil {
		objectMap["type"] = ce.Type
	}
	if ce.Tags != nil {
		objectMap["tags"] = ce.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateEmail struct.
func (ce *CertificateEmail) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateEmailProperties CertificateEmailProperties
				err = json.Unmarshal(*v, &certificateEmailProperties)
				if err != nil {
					return err
				}
				ce.CertificateEmailProperties = &certificateEmailProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ce.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ce.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ce.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ce.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ce.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ce.Tags = tags
			}
		}
	}

	return nil
}

// CertificateEmailProperties ...
type CertificateEmailProperties struct {
	// EmailID - Email id
	EmailID *string `json:"emailId,omitempty"`
	// TimeStamp - Time stamp
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
}

// CertificateOrder certificate purchase order
type CertificateOrder struct {
	autorest.Response           `json:"-"`
	*CertificateOrderProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateOrder.
func (co CertificateOrder) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if co.CertificateOrderProperties != nil {
		objectMap["properties"] = co.CertificateOrderProperties
	}
	if co.ID != nil {
		objectMap["id"] = co.ID
	}
	if co.Name != nil {
		objectMap["name"] = co.Name
	}
	if co.Kind != nil {
		objectMap["kind"] = co.Kind
	}
	if co.Location != nil {
		objectMap["location"] = co.Location
	}
	if co.Type != nil {
		objectMap["type"] = co.Type
	}
	if co.Tags != nil {
		objectMap["tags"] = co.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateOrder struct.
func (co *CertificateOrder) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateOrderProperties CertificateOrderProperties
				err = json.Unmarshal(*v, &certificateOrderProperties)
				if err != nil {
					return err
				}
				co.CertificateOrderProperties = &certificateOrderProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				co.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				co.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				co.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				co.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				co.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				co.Tags = tags
			}
		}
	}

	return nil
}

// CertificateOrderAction represents a certificate action
type CertificateOrderAction struct {
	*CertificateOrderActionProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateOrderAction.
func (coa CertificateOrderAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if coa.CertificateOrderActionProperties != nil {
		objectMap["properties"] = coa.CertificateOrderActionProperties
	}
	if coa.ID != nil {
		objectMap["id"] = coa.ID
	}
	if coa.Name != nil {
		objectMap["name"] = coa.Name
	}
	if coa.Kind != nil {
		objectMap["kind"] = coa.Kind
	}
	if coa.Location != nil {
		objectMap["location"] = coa.Location
	}
	if coa.Type != nil {
		objectMap["type"] = coa.Type
	}
	if coa.Tags != nil {
		objectMap["tags"] = coa.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateOrderAction struct.
func (coa *CertificateOrderAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateOrderActionProperties CertificateOrderActionProperties
				err = json.Unmarshal(*v, &certificateOrderActionProperties)
				if err != nil {
					return err
				}
				coa.CertificateOrderActionProperties = &certificateOrderActionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				coa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				coa.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				coa.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				coa.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				coa.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				coa.Tags = tags
			}
		}
	}

	return nil
}

// CertificateOrderActionProperties ...
type CertificateOrderActionProperties struct {
	// Type - Type. Possible values include: 'CertificateIssued', 'CertificateOrderCanceled', 'CertificateOrderCreated', 'CertificateRevoked', 'DomainValidationComplete', 'FraudDetected', 'OrgNameChange', 'OrgValidationComplete', 'SanDrop'
	Type CertificateOrderActionType `json:"type,omitempty"`
	// CreatedAt - Time at which the certificate action was performed
	CreatedAt *date.Time `json:"createdAt,omitempty"`
}

// CertificateOrderCertificate class representing the Key Vault container for certificate purchased through
// Azure
type CertificateOrderCertificate struct {
	autorest.Response                      `json:"-"`
	*CertificateOrderCertificateProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateOrderCertificate.
func (coc CertificateOrderCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if coc.CertificateOrderCertificateProperties != nil {
		objectMap["properties"] = coc.CertificateOrderCertificateProperties
	}
	if coc.ID != nil {
		objectMap["id"] = coc.ID
	}
	if coc.Name != nil {
		objectMap["name"] = coc.Name
	}
	if coc.Kind != nil {
		objectMap["kind"] = coc.Kind
	}
	if coc.Location != nil {
		objectMap["location"] = coc.Location
	}
	if coc.Type != nil {
		objectMap["type"] = coc.Type
	}
	if coc.Tags != nil {
		objectMap["tags"] = coc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateOrderCertificate struct.
func (coc *CertificateOrderCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateOrderCertificateProperties CertificateOrderCertificateProperties
				err = json.Unmarshal(*v, &certificateOrderCertificateProperties)
				if err != nil {
					return err
				}
				coc.CertificateOrderCertificateProperties = &certificateOrderCertificateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				coc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				coc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				coc.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				coc.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				coc.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				coc.Tags = tags
			}
		}
	}

	return nil
}

// CertificateOrderCertificateCollection collection of certificate order certificates
type CertificateOrderCertificateCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]CertificateOrderCertificate `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateOrderCertificateCollectionIterator provides access to a complete listing of
// CertificateOrderCertificate values.
type CertificateOrderCertificateCollectionIterator struct {
	i    int
	page CertificateOrderCertificateCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateOrderCertificateCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrderCertificateCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateOrderCertificateCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateOrderCertificateCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateOrderCertificateCollectionIterator) Response() CertificateOrderCertificateCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateOrderCertificateCollectionIterator) Value() CertificateOrderCertificate {
	if !iter.page.NotDone() {
		return CertificateOrderCertificate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateOrderCertificateCollectionIterator type.
func NewCertificateOrderCertificateCollectionIterator(page CertificateOrderCertificateCollectionPage) CertificateOrderCertificateCollectionIterator {
	return CertificateOrderCertificateCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cocc CertificateOrderCertificateCollection) IsEmpty() bool {
	return cocc.Value == nil || len(*cocc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cocc CertificateOrderCertificateCollection) hasNextLink() bool {
	return cocc.NextLink != nil && len(*cocc.NextLink) != 0
}

// certificateOrderCertificateCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cocc CertificateOrderCertificateCollection) certificateOrderCertificateCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !cocc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cocc.NextLink)))
}

// CertificateOrderCertificateCollectionPage contains a page of CertificateOrderCertificate values.
type CertificateOrderCertificateCollectionPage struct {
	fn   func(context.Context, CertificateOrderCertificateCollection) (CertificateOrderCertificateCollection, error)
	cocc CertificateOrderCertificateCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateOrderCertificateCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrderCertificateCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cocc)
		if err != nil {
			return err
		}
		page.cocc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateOrderCertificateCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateOrderCertificateCollectionPage) NotDone() bool {
	return !page.cocc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateOrderCertificateCollectionPage) Response() CertificateOrderCertificateCollection {
	return page.cocc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateOrderCertificateCollectionPage) Values() []CertificateOrderCertificate {
	if page.cocc.IsEmpty() {
		return nil
	}
	return *page.cocc.Value
}

// Creates a new instance of the CertificateOrderCertificateCollectionPage type.
func NewCertificateOrderCertificateCollectionPage(cur CertificateOrderCertificateCollection, getNextPage func(context.Context, CertificateOrderCertificateCollection) (CertificateOrderCertificateCollection, error)) CertificateOrderCertificateCollectionPage {
	return CertificateOrderCertificateCollectionPage{
		fn:   getNextPage,
		cocc: cur,
	}
}

// CertificateOrderCertificateProperties ...
type CertificateOrderCertificateProperties struct {
	// KeyVaultID - Key Vault Csm resource Id
	KeyVaultID *string `json:"keyVaultId,omitempty"`
	// KeyVaultSecretName - Key Vault secret name
	KeyVaultSecretName *string `json:"keyVaultSecretName,omitempty"`
	// ProvisioningState - Status of the Key Vault secret. Possible values include: 'KeyVaultSecretStatusInitialized', 'KeyVaultSecretStatusWaitingOnCertificateOrder', 'KeyVaultSecretStatusSucceeded', 'KeyVaultSecretStatusCertificateOrderFailed', 'KeyVaultSecretStatusOperationNotPermittedOnKeyVault', 'KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault', 'KeyVaultSecretStatusKeyVaultDoesNotExist', 'KeyVaultSecretStatusKeyVaultSecretDoesNotExist', 'KeyVaultSecretStatusUnknownError', 'KeyVaultSecretStatusUnknown'
	ProvisioningState KeyVaultSecretStatus `json:"provisioningState,omitempty"`
}

// CertificateOrderCollection collection of certificate orders
type CertificateOrderCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]CertificateOrder `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateOrderCollectionIterator provides access to a complete listing of CertificateOrder values.
type CertificateOrderCollectionIterator struct {
	i    int
	page CertificateOrderCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateOrderCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrderCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateOrderCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateOrderCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateOrderCollectionIterator) Response() CertificateOrderCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateOrderCollectionIterator) Value() CertificateOrder {
	if !iter.page.NotDone() {
		return CertificateOrder{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateOrderCollectionIterator type.
func NewCertificateOrderCollectionIterator(page CertificateOrderCollectionPage) CertificateOrderCollectionIterator {
	return CertificateOrderCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (coc CertificateOrderCollection) IsEmpty() bool {
	return coc.Value == nil || len(*coc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (coc CertificateOrderCollection) hasNextLink() bool {
	return coc.NextLink != nil && len(*coc.NextLink) != 0
}

// certificateOrderCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (coc CertificateOrderCollection) certificateOrderCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !coc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(coc.NextLink)))
}

// CertificateOrderCollectionPage contains a page of CertificateOrder values.
type CertificateOrderCollectionPage struct {
	fn  func(context.Context, CertificateOrderCollection) (CertificateOrderCollection, error)
	coc CertificateOrderCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateOrderCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateOrderCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.coc)
		if err != nil {
			return err
		}
		page.coc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateOrderCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateOrderCollectionPage) NotDone() bool {
	return !page.coc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateOrderCollectionPage) Response() CertificateOrderCollection {
	return page.coc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateOrderCollectionPage) Values() []CertificateOrder {
	if page.coc.IsEmpty() {
		return nil
	}
	return *page.coc.Value
}

// Creates a new instance of the CertificateOrderCollectionPage type.
func NewCertificateOrderCollectionPage(cur CertificateOrderCollection, getNextPage func(context.Context, CertificateOrderCollection) (CertificateOrderCollection, error)) CertificateOrderCollectionPage {
	return CertificateOrderCollectionPage{
		fn:  getNextPage,
		coc: cur,
	}
}

// CertificateOrderProperties ...
type CertificateOrderProperties struct {
	// Certificates - State of the Key Vault secret
	Certificates map[string]*CertificateOrderCertificate `json:"certificates"`
	// DistinguishedName - Certificate distinguished name
	DistinguishedName *string `json:"distinguishedName,omitempty"`
	// DomainVerificationToken - Domain Verification Token
	DomainVerificationToken *string `json:"domainVerificationToken,omitempty"`
	// ValidityInYears - Duration in years (must be between 1 and 3)
	ValidityInYears *int32 `json:"validityInYears,omitempty"`
	// KeySize - Certificate Key Size
	KeySize *int32 `json:"keySize,omitempty"`
	// ProductType - Certificate product type. Possible values include: 'StandardDomainValidatedSsl', 'StandardDomainValidatedWildCardSsl'
	ProductType CertificateProductType `json:"productType,omitempty"`
	// AutoRenew - Auto renew
	AutoRenew *bool `json:"autoRenew,omitempty"`
	// ProvisioningState - Status of certificate order. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - Current order status. Possible values include: 'Pendingissuance', 'Issued', 'Revoked', 'Canceled', 'Denied', 'Pendingrevocation', 'PendingRekey', 'Unused', 'Expired', 'NotSubmitted'
	Status CertificateOrderStatus `json:"status,omitempty"`
	// SignedCertificate - Signed certificate
	SignedCertificate *CertificateDetails `json:"signedCertificate,omitempty"`
	// Csr - Last CSR that was created for this order
	Csr *string `json:"csr,omitempty"`
	// Intermediate - Intermediate certificate
	Intermediate *CertificateDetails `json:"intermediate,omitempty"`
	// Root - Root certificate
	Root *CertificateDetails `json:"root,omitempty"`
	// SerialNumber - Current serial number of the certificate
	SerialNumber *string `json:"serialNumber,omitempty"`
	// LastCertificateIssuanceTime - Certificate last issuance time
	LastCertificateIssuanceTime *date.Time `json:"lastCertificateIssuanceTime,omitempty"`
	// ExpirationTime - Certificate expiration time
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateOrderProperties.
func (co CertificateOrderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if co.Certificates != nil {
		objectMap["certificates"] = co.Certificates
	}
	if co.DistinguishedName != nil {
		objectMap["distinguishedName"] = co.DistinguishedName
	}
	if co.DomainVerificationToken != nil {
		objectMap["domainVerificationToken"] = co.DomainVerificationToken
	}
	if co.ValidityInYears != nil {
		objectMap["validityInYears"] = co.ValidityInYears
	}
	if co.KeySize != nil {
		objectMap["keySize"] = co.KeySize
	}
	if co.ProductType != "" {
		objectMap["productType"] = co.ProductType
	}
	if co.AutoRenew != nil {
		objectMap["autoRenew"] = co.AutoRenew
	}
	if co.ProvisioningState != "" {
		objectMap["provisioningState"] = co.ProvisioningState
	}
	if co.Status != "" {
		objectMap["status"] = co.Status
	}
	if co.SignedCertificate != nil {
		objectMap["signedCertificate"] = co.SignedCertificate
	}
	if co.Csr != nil {
		objectMap["csr"] = co.Csr
	}
	if co.Intermediate != nil {
		objectMap["intermediate"] = co.Intermediate
	}
	if co.Root != nil {
		objectMap["root"] = co.Root
	}
	if co.SerialNumber != nil {
		objectMap["serialNumber"] = co.SerialNumber
	}
	if co.LastCertificateIssuanceTime != nil {
		objectMap["lastCertificateIssuanceTime"] = co.LastCertificateIssuanceTime
	}
	if co.ExpirationTime != nil {
		objectMap["expirationTime"] = co.ExpirationTime
	}
	return json.Marshal(objectMap)
}

// CertificateProperties ...
type CertificateProperties struct {
	// FriendlyName - Friendly name of the certificate
	FriendlyName *string `json:"friendlyName,omitempty"`
	// SubjectName - Subject name of the certificate
	SubjectName *string `json:"subjectName,omitempty"`
	// HostNames - Host names the certificate applies to
	HostNames *[]string `json:"hostNames,omitempty"`
	// PfxBlob - Pfx blob
	PfxBlob *string `json:"pfxBlob,omitempty"`
	// SiteName - App name
	SiteName *string `json:"siteName,omitempty"`
	// SelfLink - Self link
	SelfLink *string `json:"selfLink,omitempty"`
	// Issuer - Certificate issuer
	Issuer *string `json:"issuer,omitempty"`
	// IssueDate - Certificate issue Date
	IssueDate *date.Time `json:"issueDate,omitempty"`
	// ExpirationDate - Certificate expiration date
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Password - Certificate password
	Password *string `json:"password,omitempty"`
	// Thumbprint - Certificate thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Valid - Is the certificate valid?
	Valid *bool `json:"valid,omitempty"`
	// CerBlob - Raw bytes of .cer file
	CerBlob *string `json:"cerBlob,omitempty"`
	// PublicKeyHash - Public key hash
	PublicKeyHash *string `json:"publicKeyHash,omitempty"`
	// HostingEnvironmentProfile - Specification for the hosting environment (App Service Environment) to use for the certificate
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
}

// ClassicMobileService a mobile service
type ClassicMobileService struct {
	autorest.Response               `json:"-"`
	*ClassicMobileServiceProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ClassicMobileService.
func (cms ClassicMobileService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cms.ClassicMobileServiceProperties != nil {
		objectMap["properties"] = cms.ClassicMobileServiceProperties
	}
	if cms.ID != nil {
		objectMap["id"] = cms.ID
	}
	if cms.Name != nil {
		objectMap["name"] = cms.Name
	}
	if cms.Kind != nil {
		objectMap["kind"] = cms.Kind
	}
	if cms.Location != nil {
		objectMap["location"] = cms.Location
	}
	if cms.Type != nil {
		objectMap["type"] = cms.Type
	}
	if cms.Tags != nil {
		objectMap["tags"] = cms.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClassicMobileService struct.
func (cms *ClassicMobileService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var classicMobileServiceProperties ClassicMobileServiceProperties
				err = json.Unmarshal(*v, &classicMobileServiceProperties)
				if err != nil {
					return err
				}
				cms.ClassicMobileServiceProperties = &classicMobileServiceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cms.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cms.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cms.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cms.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cms.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cms.Tags = tags
			}
		}
	}

	return nil
}

// ClassicMobileServiceCollection collection of Classic Mobile Services
type ClassicMobileServiceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]ClassicMobileService `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// ClassicMobileServiceCollectionIterator provides access to a complete listing of ClassicMobileService
// values.
type ClassicMobileServiceCollectionIterator struct {
	i    int
	page ClassicMobileServiceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClassicMobileServiceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClassicMobileServiceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClassicMobileServiceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClassicMobileServiceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClassicMobileServiceCollectionIterator) Response() ClassicMobileServiceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClassicMobileServiceCollectionIterator) Value() ClassicMobileService {
	if !iter.page.NotDone() {
		return ClassicMobileService{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClassicMobileServiceCollectionIterator type.
func NewClassicMobileServiceCollectionIterator(page ClassicMobileServiceCollectionPage) ClassicMobileServiceCollectionIterator {
	return ClassicMobileServiceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cmsc ClassicMobileServiceCollection) IsEmpty() bool {
	return cmsc.Value == nil || len(*cmsc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cmsc ClassicMobileServiceCollection) hasNextLink() bool {
	return cmsc.NextLink != nil && len(*cmsc.NextLink) != 0
}

// classicMobileServiceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cmsc ClassicMobileServiceCollection) classicMobileServiceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !cmsc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cmsc.NextLink)))
}

// ClassicMobileServiceCollectionPage contains a page of ClassicMobileService values.
type ClassicMobileServiceCollectionPage struct {
	fn   func(context.Context, ClassicMobileServiceCollection) (ClassicMobileServiceCollection, error)
	cmsc ClassicMobileServiceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClassicMobileServiceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClassicMobileServiceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cmsc)
		if err != nil {
			return err
		}
		page.cmsc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClassicMobileServiceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClassicMobileServiceCollectionPage) NotDone() bool {
	return !page.cmsc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClassicMobileServiceCollectionPage) Response() ClassicMobileServiceCollection {
	return page.cmsc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClassicMobileServiceCollectionPage) Values() []ClassicMobileService {
	if page.cmsc.IsEmpty() {
		return nil
	}
	return *page.cmsc.Value
}

// Creates a new instance of the ClassicMobileServiceCollectionPage type.
func NewClassicMobileServiceCollectionPage(cur ClassicMobileServiceCollection, getNextPage func(context.Context, ClassicMobileServiceCollection) (ClassicMobileServiceCollection, error)) ClassicMobileServiceCollectionPage {
	return ClassicMobileServiceCollectionPage{
		fn:   getNextPage,
		cmsc: cur,
	}
}

// ClassicMobileServiceProperties ...
type ClassicMobileServiceProperties struct {
	// Name - Name of the mobile service
	Name *string `json:"name,omitempty"`
}

// CloningInfo represents information needed for cloning operation
type CloningInfo struct {
	// CorrelationID - Correlation Id of cloning operation. This id ties multiple cloning operations
	//             together to use the same snapshot
	CorrelationID *string `json:"correlationId,omitempty"`
	// Overwrite - Overwrite destination web app
	Overwrite *bool `json:"overwrite,omitempty"`
	// CloneCustomHostNames - If true, clone custom hostnames from source web app
	CloneCustomHostNames *bool `json:"cloneCustomHostNames,omitempty"`
	// CloneSourceControl - Clone source control from source web app
	CloneSourceControl *bool `json:"cloneSourceControl,omitempty"`
	// SourceWebAppID - ARM resource id of the source web app. Web app resource id is of the form
	//             /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production slots and
	//             /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for other slots
	SourceWebAppID *string `json:"sourceWebAppId,omitempty"`
	// HostingEnvironment - Hosting environment
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`
	// AppSettingsOverrides - Application settings overrides for cloned web app. If specified these settings will override the settings cloned
	//             from source web app. If not specified, application settings from source web app are retained.
	AppSettingsOverrides map[string]*string `json:"appSettingsOverrides"`
	// ConfigureLoadBalancing - If specified configure load balancing for source and clone site
	ConfigureLoadBalancing *bool `json:"configureLoadBalancing,omitempty"`
	// TrafficManagerProfileID - ARM resource id of the traffic manager profile to use if it exists. Traffic manager resource id is of the form
	//             /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}
	TrafficManagerProfileID *string `json:"trafficManagerProfileId,omitempty"`
	// TrafficManagerProfileName - Name of traffic manager profile to create. This is only needed if traffic manager profile does not already exist
	TrafficManagerProfileName *string `json:"trafficManagerProfileName,omitempty"`
}

// MarshalJSON is the custom marshaler for CloningInfo.
func (ci CloningInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ci.CorrelationID != nil {
		objectMap["correlationId"] = ci.CorrelationID
	}
	if ci.Overwrite != nil {
		objectMap["overwrite"] = ci.Overwrite
	}
	if ci.CloneCustomHostNames != nil {
		objectMap["cloneCustomHostNames"] = ci.CloneCustomHostNames
	}
	if ci.CloneSourceControl != nil {
		objectMap["cloneSourceControl"] = ci.CloneSourceControl
	}
	if ci.SourceWebAppID != nil {
		objectMap["sourceWebAppId"] = ci.SourceWebAppID
	}
	if ci.HostingEnvironment != nil {
		objectMap["hostingEnvironment"] = ci.HostingEnvironment
	}
	if ci.AppSettingsOverrides != nil {
		objectMap["appSettingsOverrides"] = ci.AppSettingsOverrides
	}
	if ci.ConfigureLoadBalancing != nil {
		objectMap["configureLoadBalancing"] = ci.ConfigureLoadBalancing
	}
	if ci.TrafficManagerProfileID != nil {
		objectMap["trafficManagerProfileId"] = ci.TrafficManagerProfileID
	}
	if ci.TrafficManagerProfileName != nil {
		objectMap["trafficManagerProfileName"] = ci.TrafficManagerProfileName
	}
	return json.Marshal(objectMap)
}

// ConfirmConsentCodeInput confirm Consent Code Input payload
type ConfirmConsentCodeInput struct {
	*ConfirmConsentCodeInputProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ConfirmConsentCodeInput.
func (ccci ConfirmConsentCodeInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccci.ConfirmConsentCodeInputProperties != nil {
		objectMap["properties"] = ccci.ConfirmConsentCodeInputProperties
	}
	if ccci.ID != nil {
		objectMap["id"] = ccci.ID
	}
	if ccci.Name != nil {
		objectMap["name"] = ccci.Name
	}
	if ccci.Kind != nil {
		objectMap["kind"] = ccci.Kind
	}
	if ccci.Location != nil {
		objectMap["location"] = ccci.Location
	}
	if ccci.Type != nil {
		objectMap["type"] = ccci.Type
	}
	if ccci.Tags != nil {
		objectMap["tags"] = ccci.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConfirmConsentCodeInput struct.
func (ccci *ConfirmConsentCodeInput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var confirmConsentCodeInputProperties ConfirmConsentCodeInputProperties
				err = json.Unmarshal(*v, &confirmConsentCodeInputProperties)
				if err != nil {
					return err
				}
				ccci.ConfirmConsentCodeInputProperties = &confirmConsentCodeInputProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ccci.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ccci.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ccci.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ccci.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ccci.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ccci.Tags = tags
			}
		}
	}

	return nil
}

// ConfirmConsentCodeInputProperties ...
type ConfirmConsentCodeInputProperties struct {
	// PrincipalType - Principal type. Possible values include: 'PrincipalTypeActiveDirectory', 'PrincipalTypeConnection', 'PrincipalTypeMicrosoftAccount'
	PrincipalType PrincipalType `json:"principalType,omitempty"`
	// TenantID - Tenant Id
	TenantID *string `json:"tenantId,omitempty"`
	// ObjectID - AAD object ID. This is userId
	ObjectID *string `json:"objectId,omitempty"`
	// Code - Code that was returned during consent flow
	Code *string `json:"code,omitempty"`
}

// Connection API Connection
type Connection struct {
	autorest.Response     `json:"-"`
	*ConnectionProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Connection.
func (c Connection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ConnectionProperties != nil {
		objectMap["properties"] = c.ConnectionProperties
	}
	if c.ID != nil {
		objectMap["id"] = c.ID
	}
	if c.Name != nil {
		objectMap["name"] = c.Name
	}
	if c.Kind != nil {
		objectMap["kind"] = c.Kind
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	if c.Type != nil {
		objectMap["type"] = c.Type
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Connection struct.
func (c *Connection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var connectionProperties ConnectionProperties
				err = json.Unmarshal(*v, &connectionProperties)
				if err != nil {
					return err
				}
				c.ConnectionProperties = &connectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				c.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		}
	}

	return nil
}

// ConnectionCollection collection of connections
type ConnectionCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]Connection `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// ConnectionCollectionIterator provides access to a complete listing of Connection values.
type ConnectionCollectionIterator struct {
	i    int
	page ConnectionCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConnectionCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectionCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConnectionCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConnectionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConnectionCollectionIterator) Response() ConnectionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConnectionCollectionIterator) Value() Connection {
	if !iter.page.NotDone() {
		return Connection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConnectionCollectionIterator type.
func NewConnectionCollectionIterator(page ConnectionCollectionPage) ConnectionCollectionIterator {
	return ConnectionCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cc ConnectionCollection) IsEmpty() bool {
	return cc.Value == nil || len(*cc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cc ConnectionCollection) hasNextLink() bool {
	return cc.NextLink != nil && len(*cc.NextLink) != 0
}

// connectionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cc ConnectionCollection) connectionCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !cc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cc.NextLink)))
}

// ConnectionCollectionPage contains a page of Connection values.
type ConnectionCollectionPage struct {
	fn func(context.Context, ConnectionCollection) (ConnectionCollection, error)
	cc ConnectionCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConnectionCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectionCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cc)
		if err != nil {
			return err
		}
		page.cc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConnectionCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConnectionCollectionPage) NotDone() bool {
	return !page.cc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConnectionCollectionPage) Response() ConnectionCollection {
	return page.cc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConnectionCollectionPage) Values() []Connection {
	if page.cc.IsEmpty() {
		return nil
	}
	return *page.cc.Value
}

// Creates a new instance of the ConnectionCollectionPage type.
func NewConnectionCollectionPage(cur ConnectionCollection, getNextPage func(context.Context, ConnectionCollection) (ConnectionCollection, error)) ConnectionCollectionPage {
	return ConnectionCollectionPage{
		fn: getNextPage,
		cc: cur,
	}
}

// ConnectionError connection error
type ConnectionError struct {
	*ConnectionErrorProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ConnectionError.
func (ce ConnectionError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ce.ConnectionErrorProperties != nil {
		objectMap["properties"] = ce.ConnectionErrorProperties
	}
	if ce.ID != nil {
		objectMap["id"] = ce.ID
	}
	if ce.Name != nil {
		objectMap["name"] = ce.Name
	}
	if ce.Kind != nil {
		objectMap["kind"] = ce.Kind
	}
	if ce.Location != nil {
		objectMap["location"] = ce.Location
	}
	if ce.Type != nil {
		objectMap["type"] = ce.Type
	}
	if ce.Tags != nil {
		objectMap["tags"] = ce.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectionError struct.
func (ce *ConnectionError) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var connectionErrorProperties ConnectionErrorProperties
				err = json.Unmarshal(*v, &connectionErrorProperties)
				if err != nil {
					return err
				}
				ce.ConnectionErrorProperties = &connectionErrorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ce.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ce.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ce.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ce.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ce.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ce.Tags = tags
			}
		}
	}

	return nil
}

// ConnectionErrorProperties ...
type ConnectionErrorProperties struct {
	// Code - code of the status
	Code *string `json:"code,omitempty"`
	// Message - Description of the status
	Message *string `json:"message,omitempty"`
}

// ConnectionParameter connection provider parameters
type ConnectionParameter struct {
	// Type - Type of the parameter. Possible values include: 'ConnectionParameterTypeString', 'ConnectionParameterTypeSecurestring', 'ConnectionParameterTypeSecureobject', 'ConnectionParameterTypeInt', 'ConnectionParameterTypeBool', 'ConnectionParameterTypeObject', 'ConnectionParameterTypeArray', 'ConnectionParameterTypeOauthSetting', 'ConnectionParameterTypeConnection'
	Type ConnectionParameterType `json:"type,omitempty"`
	// DefaultValue - Default parameter value
	DefaultValue interface{} `json:"defaultValue,omitempty"`
	// OAuthSettings - Settings defining OAuth flow for the back end provider
	OAuthSettings *APIOAuthSettings `json:"oAuthSettings,omitempty"`
	// UIDefinition - UI definitions
	UIDefinition interface{} `json:"uiDefinition,omitempty"`
}

// ConnectionProperties ...
type ConnectionProperties struct {
	// Name - connection name
	Name *string `json:"name,omitempty"`
	// DisplayName - display name
	DisplayName *string `json:"displayName,omitempty"`
	// Statuses - Status of the connection
	Statuses *[]ConnectionStatus `json:"statuses,omitempty"`
	// CustomParameterValues - Custom login setting values.
	CustomParameterValues map[string]*ParameterCustomLoginSettingValues `json:"customParameterValues"`
	TenantID              *string                                       `json:"tenantId,omitempty"`
	// ParameterValues - Tokens/Claim
	ParameterValues map[string]interface{} `json:"parameterValues"`
	// NonSecretParameterValues - Tokens/Claim
	NonSecretParameterValues map[string]interface{} `json:"nonSecretParameterValues"`
	Metadata                 interface{}            `json:"metadata,omitempty"`
	// FirstExpirationTime - Time in UTC when the first expiration of OAuth tokens
	FirstExpirationTime *date.Time `json:"firstExpirationTime,omitempty"`
	// Keywords - List of Keywords that tag the acl
	Keywords *[]string `json:"keywords,omitempty"`
	// CreatedTime - Timestamp of the connection creation
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - Timestamp of last connection change.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// API - expanded connection provider name
	API *ExpandedParentAPIEntity `json:"api,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionProperties.
func (c ConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Name != nil {
		objectMap["name"] = c.Name
	}
	if c.DisplayName != nil {
		objectMap["displayName"] = c.DisplayName
	}
	if c.Statuses != nil {
		objectMap["statuses"] = c.Statuses
	}
	if c.CustomParameterValues != nil {
		objectMap["customParameterValues"] = c.CustomParameterValues
	}
	if c.TenantID != nil {
		objectMap["tenantId"] = c.TenantID
	}
	if c.ParameterValues != nil {
		objectMap["parameterValues"] = c.ParameterValues
	}
	if c.NonSecretParameterValues != nil {
		objectMap["nonSecretParameterValues"] = c.NonSecretParameterValues
	}
	if c.Metadata != nil {
		objectMap["metadata"] = c.Metadata
	}
	if c.FirstExpirationTime != nil {
		objectMap["firstExpirationTime"] = c.FirstExpirationTime
	}
	if c.Keywords != nil {
		objectMap["keywords"] = c.Keywords
	}
	if c.CreatedTime != nil {
		objectMap["createdTime"] = c.CreatedTime
	}
	if c.ChangedTime != nil {
		objectMap["changedTime"] = c.ChangedTime
	}
	if c.API != nil {
		objectMap["api"] = c.API
	}
	return json.Marshal(objectMap)
}

// ConnectionSecrets ...
type ConnectionSecrets struct {
	autorest.Response `json:"-"`
	// ParameterValues - Tokens/Claim
	ParameterValues map[string]interface{} `json:"parameterValues"`
	// ConnectionKey - Connection Key
	ConnectionKey *string `json:"connectionKey,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionSecrets.
func (cs ConnectionSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cs.ParameterValues != nil {
		objectMap["parameterValues"] = cs.ParameterValues
	}
	if cs.ConnectionKey != nil {
		objectMap["connectionKey"] = cs.ConnectionKey
	}
	return json.Marshal(objectMap)
}

// ConnectionStatus connection status
type ConnectionStatus struct {
	*ConnectionStatusProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ConnectionStatus.
func (cs ConnectionStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cs.ConnectionStatusProperties != nil {
		objectMap["properties"] = cs.ConnectionStatusProperties
	}
	if cs.ID != nil {
		objectMap["id"] = cs.ID
	}
	if cs.Name != nil {
		objectMap["name"] = cs.Name
	}
	if cs.Kind != nil {
		objectMap["kind"] = cs.Kind
	}
	if cs.Location != nil {
		objectMap["location"] = cs.Location
	}
	if cs.Type != nil {
		objectMap["type"] = cs.Type
	}
	if cs.Tags != nil {
		objectMap["tags"] = cs.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectionStatus struct.
func (cs *ConnectionStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var connectionStatusProperties ConnectionStatusProperties
				err = json.Unmarshal(*v, &connectionStatusProperties)
				if err != nil {
					return err
				}
				cs.ConnectionStatusProperties = &connectionStatusProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cs.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cs.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cs.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cs.Tags = tags
			}
		}
	}

	return nil
}

// ConnectionStatusProperties ...
type ConnectionStatusProperties struct {
	// Status - Status
	Status *string `json:"status,omitempty"`
	// Target - Target of the error
	Target *string `json:"target,omitempty"`
	// Error - Error details
	Error *ConnectionError `json:"error,omitempty"`
}

// ConnectionStringDictionary string dictionary resource
type ConnectionStringDictionary struct {
	autorest.Response `json:"-"`
	// Properties - Connection strings
	Properties map[string]*ConnStringValueTypePair `json:"properties"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ConnectionStringDictionary.
func (csd ConnectionStringDictionary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csd.Properties != nil {
		objectMap["properties"] = csd.Properties
	}
	if csd.ID != nil {
		objectMap["id"] = csd.ID
	}
	if csd.Name != nil {
		objectMap["name"] = csd.Name
	}
	if csd.Kind != nil {
		objectMap["kind"] = csd.Kind
	}
	if csd.Location != nil {
		objectMap["location"] = csd.Location
	}
	if csd.Type != nil {
		objectMap["type"] = csd.Type
	}
	if csd.Tags != nil {
		objectMap["tags"] = csd.Tags
	}
	return json.Marshal(objectMap)
}

// ConnStringInfo represents database connection string information
type ConnStringInfo struct {
	// Name - Name of connection string
	Name *string `json:"name,omitempty"`
	// ConnectionString - Connection string value
	ConnectionString *string `json:"connectionString,omitempty"`
	// Type - Type of database. Possible values include: 'MySQL', 'SQLServer', 'SQLAzure', 'Custom'
	Type DatabaseServerType `json:"type,omitempty"`
}

// ConnStringValueTypePair database connection string value to type pair
type ConnStringValueTypePair struct {
	// Value - Value of pair
	Value *string `json:"value,omitempty"`
	// Type - Type of database. Possible values include: 'MySQL', 'SQLServer', 'SQLAzure', 'Custom'
	Type DatabaseServerType `json:"type,omitempty"`
}

// ConsentLink ...
type ConsentLink struct {
	// Link - Uri for the consent link
	Link *string `json:"link,omitempty"`
	// FirstPartyLoginURI - Uri for first party login
	FirstPartyLoginURI *string `json:"firstPartyLoginUri,omitempty"`
	// DisplayName - Display Name of the parameter in the connection provider's oauthSettings
	DisplayName *string `json:"displayName,omitempty"`
	// Status - Status of the link. Possible values include: 'Unauthenticated', 'Authenticated', 'Error'
	Status LinkState `json:"status,omitempty"`
}

// ConsentLinkInput connection Consent Link payload
type ConsentLinkInput struct {
	*ConsentLinkInputProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ConsentLinkInput.
func (cli ConsentLinkInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cli.ConsentLinkInputProperties != nil {
		objectMap["properties"] = cli.ConsentLinkInputProperties
	}
	if cli.ID != nil {
		objectMap["id"] = cli.ID
	}
	if cli.Name != nil {
		objectMap["name"] = cli.Name
	}
	if cli.Kind != nil {
		objectMap["kind"] = cli.Kind
	}
	if cli.Location != nil {
		objectMap["location"] = cli.Location
	}
	if cli.Type != nil {
		objectMap["type"] = cli.Type
	}
	if cli.Tags != nil {
		objectMap["tags"] = cli.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConsentLinkInput struct.
func (cli *ConsentLinkInput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var consentLinkInputProperties ConsentLinkInputProperties
				err = json.Unmarshal(*v, &consentLinkInputProperties)
				if err != nil {
					return err
				}
				cli.ConsentLinkInputProperties = &consentLinkInputProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cli.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cli.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cli.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cli.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cli.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cli.Tags = tags
			}
		}
	}

	return nil
}

// ConsentLinkInputParameter ...
type ConsentLinkInputParameter struct {
	// PrincipalType - Principal type. Possible values include: 'PrincipalTypeActiveDirectory', 'PrincipalTypeConnection', 'PrincipalTypeMicrosoftAccount'
	PrincipalType PrincipalType `json:"principalType,omitempty"`
	// TenantID - Tenant Id
	TenantID *string `json:"tenantId,omitempty"`
	// ObjectID - AAD OID (user or group) if the principal type is ActiveDirectory.
	//             MSA PUID if the principal type is MicrosoftAccount.
	ObjectID *string `json:"objectId,omitempty"`
	// ParameterName - Name of the parameter in the connection provider's oauthSettings
	ParameterName *string `json:"parameterName,omitempty"`
	// RedirectURL - Name of the parameter in the connection provider's oauthSettings
	RedirectURL *string `json:"redirectUrl,omitempty"`
}

// ConsentLinkInputProperties ...
type ConsentLinkInputProperties struct {
	// Parameters - Array of links
	Parameters *[]ConsentLinkInputParameter `json:"parameters,omitempty"`
}

// ConsentLinkPayload collection of consent links
type ConsentLinkPayload struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]ConsentLink `json:"value,omitempty"`
}

// Contact contact information for domain registration. If 'Domain Privacy' option is not selected then the
// contact information will be made publicly available through the Whois directories as per ICANN
// requirements.
type Contact struct {
	// AddressMailing - Mailing address
	AddressMailing *Address `json:"addressMailing,omitempty"`
	// Email - Email address
	Email *string `json:"email,omitempty"`
	// Fax - Fax number
	Fax *string `json:"fax,omitempty"`
	// JobTitle - Job title
	JobTitle *string `json:"jobTitle,omitempty"`
	// NameFirst - First name
	NameFirst *string `json:"nameFirst,omitempty"`
	// NameLast - Last name
	NameLast *string `json:"nameLast,omitempty"`
	// NameMiddle - Middle name
	NameMiddle *string `json:"nameMiddle,omitempty"`
	// Organization - Organization
	Organization *string `json:"organization,omitempty"`
	// Phone - Phone number
	Phone *string `json:"phone,omitempty"`
}

// CorsSettings cross-Origin Resource Sharing (CORS) settings for the web app.
type CorsSettings struct {
	// AllowedOrigins - Gets or sets the list of origins that should be allowed to make cross-origin
	//             calls (for example: http://example.com:12345). Use "*" to allow all.
	AllowedOrigins *[]string `json:"allowedOrigins,omitempty"`
}

// CsmMoveResourceEnvelope class containing a list of the resources that need to be moved and the resource
// group they should be moved to
type CsmMoveResourceEnvelope struct {
	TargetResourceGroup *string   `json:"targetResourceGroup,omitempty"`
	Resources           *[]string `json:"resources,omitempty"`
}

// CsmPublishingProfileOptions publishing options for requested profile
type CsmPublishingProfileOptions struct {
	// Format - Name of the format. Valid values are:
	//             FileZilla3
	//             WebDeploy -- default
	//             Ftp
	Format *string `json:"format,omitempty"`
}

// CsmSiteRecoveryEntity class containing details about site recovery operation.
type CsmSiteRecoveryEntity struct {
	// SnapshotTime - Point in time in which the site recover should be attempted.
	SnapshotTime *date.Time `json:"snapshotTime,omitempty"`
	// RecoverConfig - If true, then the website's configuration will be reverted to its state at SnapshotTime
	RecoverConfig *bool `json:"recoverConfig,omitempty"`
	// SiteName - [Optional] Destination web app name into which web app should be recovered. This is case when new web app should be created instead.
	SiteName *string `json:"siteName,omitempty"`
	// SlotName - [Optional] Destination web app slot name into which web app should be recovered
	SlotName *string `json:"slotName,omitempty"`
}

// CsmSlotEntity class containing deployment slot parameters
type CsmSlotEntity struct {
	// TargetSlot - Set the destination deployment slot during swap operation
	TargetSlot *string `json:"targetSlot,omitempty"`
	// PreserveVnet - Get or set the flag indicating it should preserve VNet to the slot during swap
	PreserveVnet *bool `json:"preserveVnet,omitempty"`
}

// CsmUsageQuota usage of the quota resource
type CsmUsageQuota struct {
	// Unit - Units of measurement for the quota resource
	Unit *string `json:"unit,omitempty"`
	// NextResetTime - Next reset time for the resource counter
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
	// CurrentValue - The current value of the resource counter
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - The resource limit
	Limit *int64 `json:"limit,omitempty"`
	// Name - Quota name
	Name *LocalizableString `json:"name,omitempty"`
}

// CsmUsageQuotaCollection collection of csm usage quotas
type CsmUsageQuotaCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]CsmUsageQuota `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// CsmUsageQuotaCollectionIterator provides access to a complete listing of CsmUsageQuota values.
type CsmUsageQuotaCollectionIterator struct {
	i    int
	page CsmUsageQuotaCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CsmUsageQuotaCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CsmUsageQuotaCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CsmUsageQuotaCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CsmUsageQuotaCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CsmUsageQuotaCollectionIterator) Response() CsmUsageQuotaCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CsmUsageQuotaCollectionIterator) Value() CsmUsageQuota {
	if !iter.page.NotDone() {
		return CsmUsageQuota{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CsmUsageQuotaCollectionIterator type.
func NewCsmUsageQuotaCollectionIterator(page CsmUsageQuotaCollectionPage) CsmUsageQuotaCollectionIterator {
	return CsmUsageQuotaCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cuqc CsmUsageQuotaCollection) IsEmpty() bool {
	return cuqc.Value == nil || len(*cuqc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cuqc CsmUsageQuotaCollection) hasNextLink() bool {
	return cuqc.NextLink != nil && len(*cuqc.NextLink) != 0
}

// csmUsageQuotaCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cuqc CsmUsageQuotaCollection) csmUsageQuotaCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !cuqc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cuqc.NextLink)))
}

// CsmUsageQuotaCollectionPage contains a page of CsmUsageQuota values.
type CsmUsageQuotaCollectionPage struct {
	fn   func(context.Context, CsmUsageQuotaCollection) (CsmUsageQuotaCollection, error)
	cuqc CsmUsageQuotaCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CsmUsageQuotaCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CsmUsageQuotaCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cuqc)
		if err != nil {
			return err
		}
		page.cuqc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CsmUsageQuotaCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CsmUsageQuotaCollectionPage) NotDone() bool {
	return !page.cuqc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CsmUsageQuotaCollectionPage) Response() CsmUsageQuotaCollection {
	return page.cuqc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CsmUsageQuotaCollectionPage) Values() []CsmUsageQuota {
	if page.cuqc.IsEmpty() {
		return nil
	}
	return *page.cuqc.Value
}

// Creates a new instance of the CsmUsageQuotaCollectionPage type.
func NewCsmUsageQuotaCollectionPage(cur CsmUsageQuotaCollection, getNextPage func(context.Context, CsmUsageQuotaCollection) (CsmUsageQuotaCollection, error)) CsmUsageQuotaCollectionPage {
	return CsmUsageQuotaCollectionPage{
		fn:   getNextPage,
		cuqc: cur,
	}
}

// Csr certificate signing request object
type Csr struct {
	autorest.Response `json:"-"`
	*CsrProperties    `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Csr.
func (c Csr) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.CsrProperties != nil {
		objectMap["properties"] = c.CsrProperties
	}
	if c.ID != nil {
		objectMap["id"] = c.ID
	}
	if c.Name != nil {
		objectMap["name"] = c.Name
	}
	if c.Kind != nil {
		objectMap["kind"] = c.Kind
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	if c.Type != nil {
		objectMap["type"] = c.Type
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Csr struct.
func (c *Csr) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var csrProperties CsrProperties
				err = json.Unmarshal(*v, &csrProperties)
				if err != nil {
					return err
				}
				c.CsrProperties = &csrProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				c.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		}
	}

	return nil
}

// CsrProperties ...
type CsrProperties struct {
	// Name - Name used to locate CSR object
	Name *string `json:"name,omitempty"`
	// DistinguishedName - Distinguished name of certificate to be created
	DistinguishedName *string `json:"distinguishedName,omitempty"`
	// CsrString - Actual CSR string created
	CsrString *string `json:"csrString,omitempty"`
	// PfxBlob - PFX certificate of created certificate
	PfxBlob *string `json:"pfxBlob,omitempty"`
	// Password - PFX password
	Password *string `json:"password,omitempty"`
	// PublicKeyHash - Hash of the certificates public key
	PublicKeyHash *string `json:"publicKeyHash,omitempty"`
	// HostingEnvironment - Hosting environment
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`
}

// CustomLoginSettingValue custom logging setting value
type CustomLoginSettingValue struct {
	*CustomLoginSettingValueProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CustomLoginSettingValue.
func (clsv CustomLoginSettingValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if clsv.CustomLoginSettingValueProperties != nil {
		objectMap["properties"] = clsv.CustomLoginSettingValueProperties
	}
	if clsv.ID != nil {
		objectMap["id"] = clsv.ID
	}
	if clsv.Name != nil {
		objectMap["name"] = clsv.Name
	}
	if clsv.Kind != nil {
		objectMap["kind"] = clsv.Kind
	}
	if clsv.Location != nil {
		objectMap["location"] = clsv.Location
	}
	if clsv.Type != nil {
		objectMap["type"] = clsv.Type
	}
	if clsv.Tags != nil {
		objectMap["tags"] = clsv.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomLoginSettingValue struct.
func (clsv *CustomLoginSettingValue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customLoginSettingValueProperties CustomLoginSettingValueProperties
				err = json.Unmarshal(*v, &customLoginSettingValueProperties)
				if err != nil {
					return err
				}
				clsv.CustomLoginSettingValueProperties = &customLoginSettingValueProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				clsv.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				clsv.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				clsv.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				clsv.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				clsv.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				clsv.Tags = tags
			}
		}
	}

	return nil
}

// CustomLoginSettingValueProperties ...
type CustomLoginSettingValueProperties struct {
	// Option - Option selected for this custom login setting value
	Option *string `json:"option,omitempty"`
}

// DatabaseBackupSetting note: properties are serialized in JSON format and stored in DB.
// if new properties are added they might not be in the previous data rows
// so please handle nulls
type DatabaseBackupSetting struct {
	// DatabaseType - SqlAzure / MySql
	DatabaseType *string `json:"databaseType,omitempty"`
	Name         *string `json:"name,omitempty"`
	// ConnectionStringName - Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
	//             This is used during restore with overwrite connection strings options.
	ConnectionStringName *string `json:"connectionStringName,omitempty"`
	// ConnectionString - Contains a connection string to a database which is being backed up/restored. If the restore should happen to a new database, the database name inside is the new one.
	ConnectionString *string `json:"connectionString,omitempty"`
}

// DeletedSite reports deleted site including the timestamp of operation
type DeletedSite struct {
	*DeletedSiteProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DeletedSite.
func (ds DeletedSite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ds.DeletedSiteProperties != nil {
		objectMap["properties"] = ds.DeletedSiteProperties
	}
	if ds.ID != nil {
		objectMap["id"] = ds.ID
	}
	if ds.Name != nil {
		objectMap["name"] = ds.Name
	}
	if ds.Kind != nil {
		objectMap["kind"] = ds.Kind
	}
	if ds.Location != nil {
		objectMap["location"] = ds.Location
	}
	if ds.Type != nil {
		objectMap["type"] = ds.Type
	}
	if ds.Tags != nil {
		objectMap["tags"] = ds.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeletedSite struct.
func (ds *DeletedSite) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var deletedSiteProperties DeletedSiteProperties
				err = json.Unmarshal(*v, &deletedSiteProperties)
				if err != nil {
					return err
				}
				ds.DeletedSiteProperties = &deletedSiteProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ds.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ds.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ds.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ds.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ds.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ds.Tags = tags
			}
		}
	}

	return nil
}

// DeletedSiteCollection collection of deleted sites
type DeletedSiteCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]DeletedSite `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// DeletedSiteCollectionIterator provides access to a complete listing of DeletedSite values.
type DeletedSiteCollectionIterator struct {
	i    int
	page DeletedSiteCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedSiteCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedSiteCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeletedSiteCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedSiteCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedSiteCollectionIterator) Response() DeletedSiteCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedSiteCollectionIterator) Value() DeletedSite {
	if !iter.page.NotDone() {
		return DeletedSite{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeletedSiteCollectionIterator type.
func NewDeletedSiteCollectionIterator(page DeletedSiteCollectionPage) DeletedSiteCollectionIterator {
	return DeletedSiteCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dsc DeletedSiteCollection) IsEmpty() bool {
	return dsc.Value == nil || len(*dsc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dsc DeletedSiteCollection) hasNextLink() bool {
	return dsc.NextLink != nil && len(*dsc.NextLink) != 0
}

// deletedSiteCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dsc DeletedSiteCollection) deletedSiteCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !dsc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dsc.NextLink)))
}

// DeletedSiteCollectionPage contains a page of DeletedSite values.
type DeletedSiteCollectionPage struct {
	fn  func(context.Context, DeletedSiteCollection) (DeletedSiteCollection, error)
	dsc DeletedSiteCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedSiteCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedSiteCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dsc)
		if err != nil {
			return err
		}
		page.dsc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeletedSiteCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedSiteCollectionPage) NotDone() bool {
	return !page.dsc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedSiteCollectionPage) Response() DeletedSiteCollection {
	return page.dsc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedSiteCollectionPage) Values() []DeletedSite {
	if page.dsc.IsEmpty() {
		return nil
	}
	return *page.dsc.Value
}

// Creates a new instance of the DeletedSiteCollectionPage type.
func NewDeletedSiteCollectionPage(cur DeletedSiteCollection, getNextPage func(context.Context, DeletedSiteCollection) (DeletedSiteCollection, error)) DeletedSiteCollectionPage {
	return DeletedSiteCollectionPage{
		fn:  getNextPage,
		dsc: cur,
	}
}

// DeletedSiteProperties ...
type DeletedSiteProperties struct {
	// DeletedTimestamp - Time when the site was deleted
	DeletedTimestamp *date.Time `json:"deletedTimestamp,omitempty"`
	// Name - Name of web app
	Name *string `json:"name,omitempty"`
	// State - READ-ONLY; State of the web app
	State *string `json:"state,omitempty"`
	// HostNames - READ-ONLY; Hostnames associated with web app
	HostNames *[]string `json:"hostNames,omitempty"`
	// RepositorySiteName - READ-ONLY; Name of repository site
	RepositorySiteName *string `json:"repositorySiteName,omitempty"`
	// UsageState - READ-ONLY; State indicating whether web app has exceeded its quota usage. Possible values include: 'UsageStateNormal', 'UsageStateExceeded'
	UsageState UsageState `json:"usageState,omitempty"`
	// Enabled - True if the site is enabled; otherwise, false. Setting this  value to false disables the site (takes the site off line).
	Enabled *bool `json:"enabled,omitempty"`
	// EnabledHostNames - READ-ONLY; Hostnames for the web app that are enabled. Hostnames need to be assigned and enabled. If some hostnames are assigned but not enabled
	//             the app is not served on those hostnames
	EnabledHostNames *[]string `json:"enabledHostNames,omitempty"`
	// AvailabilityState - READ-ONLY; Management information availability state for the web app. Possible values are Normal or Limited.
	//             Normal means that the site is running correctly and that management information for the site is available.
	//             Limited means that only partial management information for the site is available and that detailed site information is unavailable. Possible values include: 'Normal', 'Limited', 'DisasterRecoveryMode'
	AvailabilityState SiteAvailabilityState `json:"availabilityState,omitempty"`
	// HostNameSslStates - Hostname SSL states are  used to manage the SSL bindings for site's hostnames.
	HostNameSslStates *[]HostNameSslState `json:"hostNameSslStates,omitempty"`
	ServerFarmID      *string             `json:"serverFarmId,omitempty"`
	// LastModifiedTimeUtc - READ-ONLY; Last time web app was modified in UTC
	LastModifiedTimeUtc *date.Time `json:"lastModifiedTimeUtc,omitempty"`
	// SiteConfig - Configuration of web app
	SiteConfig *SiteConfig `json:"siteConfig,omitempty"`
	// TrafficManagerHostNames - READ-ONLY; Read-only list of Azure Traffic manager hostnames associated with web app
	TrafficManagerHostNames *[]string `json:"trafficManagerHostNames,omitempty"`
	// PremiumAppDeployed - READ-ONLY; If set indicates whether web app is deployed as a premium app
	PremiumAppDeployed *bool `json:"premiumAppDeployed,omitempty"`
	// ScmSiteAlsoStopped - If set indicates whether to stop SCM (KUDU) site when the web app is stopped. Default is false.
	ScmSiteAlsoStopped *bool `json:"scmSiteAlsoStopped,omitempty"`
	// TargetSwapSlot - READ-ONLY; Read-only property that specifies which slot this app will swap into
	TargetSwapSlot *string `json:"targetSwapSlot,omitempty"`
	// HostingEnvironmentProfile - Specification for the hosting environment (App Service Environment) to use for the web app
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	MicroService              *string                    `json:"microService,omitempty"`
	// GatewaySiteName - Name of gateway app associated with web app
	GatewaySiteName *string `json:"gatewaySiteName,omitempty"`
	// ClientAffinityEnabled - Specifies if the client affinity is enabled when load balancing http request for multiple instances of the web app
	ClientAffinityEnabled *bool `json:"clientAffinityEnabled,omitempty"`
	// ClientCertEnabled - Specifies if the client certificate is enabled for the web app
	ClientCertEnabled *bool `json:"clientCertEnabled,omitempty"`
	// HostNamesDisabled - Specifies if the public hostnames are disabled the web app.
	//             If set to true the app is only accessible via API Management process
	HostNamesDisabled *bool `json:"hostNamesDisabled,omitempty"`
	// OutboundIPAddresses - READ-ONLY; List of comma separated IP addresses that this web app uses for outbound connections. Those can be used when configuring firewall rules for databases accessed by this web app.
	OutboundIPAddresses *string `json:"outboundIpAddresses,omitempty"`
	// ContainerSize - Size of a function container
	ContainerSize *int32 `json:"containerSize,omitempty"`
	// MaxNumberOfWorkers - Maximum number of workers
	//             This only applies to function container
	MaxNumberOfWorkers *int32 `json:"maxNumberOfWorkers,omitempty"`
	// CloningInfo - This is only valid for web app creation. If specified, web app is cloned from
	//             a source web app
	CloningInfo *CloningInfo `json:"cloningInfo,omitempty"`
	// ResourceGroup - READ-ONLY; Resource group web app belongs to
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// IsDefaultContainer - READ-ONLY; Site is a default container
	IsDefaultContainer *bool `json:"isDefaultContainer,omitempty"`
	// DefaultHostName - READ-ONLY; Default hostname of the web app
	DefaultHostName *string `json:"defaultHostName,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedSiteProperties.
func (ds DeletedSiteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ds.DeletedTimestamp != nil {
		objectMap["deletedTimestamp"] = ds.DeletedTimestamp
	}
	if ds.Name != nil {
		objectMap["name"] = ds.Name
	}
	if ds.Enabled != nil {
		objectMap["enabled"] = ds.Enabled
	}
	if ds.HostNameSslStates != nil {
		objectMap["hostNameSslStates"] = ds.HostNameSslStates
	}
	if ds.ServerFarmID != nil {
		objectMap["serverFarmId"] = ds.ServerFarmID
	}
	if ds.SiteConfig != nil {
		objectMap["siteConfig"] = ds.SiteConfig
	}
	if ds.ScmSiteAlsoStopped != nil {
		objectMap["scmSiteAlsoStopped"] = ds.ScmSiteAlsoStopped
	}
	if ds.HostingEnvironmentProfile != nil {
		objectMap["hostingEnvironmentProfile"] = ds.HostingEnvironmentProfile
	}
	if ds.MicroService != nil {
		objectMap["microService"] = ds.MicroService
	}
	if ds.GatewaySiteName != nil {
		objectMap["gatewaySiteName"] = ds.GatewaySiteName
	}
	if ds.ClientAffinityEnabled != nil {
		objectMap["clientAffinityEnabled"] = ds.ClientAffinityEnabled
	}
	if ds.ClientCertEnabled != nil {
		objectMap["clientCertEnabled"] = ds.ClientCertEnabled
	}
	if ds.HostNamesDisabled != nil {
		objectMap["hostNamesDisabled"] = ds.HostNamesDisabled
	}
	if ds.ContainerSize != nil {
		objectMap["containerSize"] = ds.ContainerSize
	}
	if ds.MaxNumberOfWorkers != nil {
		objectMap["maxNumberOfWorkers"] = ds.MaxNumberOfWorkers
	}
	if ds.CloningInfo != nil {
		objectMap["cloningInfo"] = ds.CloningInfo
	}
	return json.Marshal(objectMap)
}

// Deployment represents user credentials used for publishing activity
type Deployment struct {
	autorest.Response     `json:"-"`
	*DeploymentProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Deployment.
func (d Deployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DeploymentProperties != nil {
		objectMap["properties"] = d.DeploymentProperties
	}
	if d.ID != nil {
		objectMap["id"] = d.ID
	}
	if d.Name != nil {
		objectMap["name"] = d.Name
	}
	if d.Kind != nil {
		objectMap["kind"] = d.Kind
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Type != nil {
		objectMap["type"] = d.Type
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Deployment struct.
func (d *Deployment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var deploymentProperties DeploymentProperties
				err = json.Unmarshal(*v, &deploymentProperties)
				if err != nil {
					return err
				}
				d.DeploymentProperties = &deploymentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		}
	}

	return nil
}

// DeploymentCollection collection of app deployments
type DeploymentCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]Deployment `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// DeploymentCollectionIterator provides access to a complete listing of Deployment values.
type DeploymentCollectionIterator struct {
	i    int
	page DeploymentCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeploymentCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeploymentCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeploymentCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeploymentCollectionIterator) Response() DeploymentCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeploymentCollectionIterator) Value() Deployment {
	if !iter.page.NotDone() {
		return Deployment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeploymentCollectionIterator type.
func NewDeploymentCollectionIterator(page DeploymentCollectionPage) DeploymentCollectionIterator {
	return DeploymentCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dc DeploymentCollection) IsEmpty() bool {
	return dc.Value == nil || len(*dc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dc DeploymentCollection) hasNextLink() bool {
	return dc.NextLink != nil && len(*dc.NextLink) != 0
}

// deploymentCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dc DeploymentCollection) deploymentCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !dc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dc.NextLink)))
}

// DeploymentCollectionPage contains a page of Deployment values.
type DeploymentCollectionPage struct {
	fn func(context.Context, DeploymentCollection) (DeploymentCollection, error)
	dc DeploymentCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeploymentCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dc)
		if err != nil {
			return err
		}
		page.dc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeploymentCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeploymentCollectionPage) NotDone() bool {
	return !page.dc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeploymentCollectionPage) Response() DeploymentCollection {
	return page.dc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeploymentCollectionPage) Values() []Deployment {
	if page.dc.IsEmpty() {
		return nil
	}
	return *page.dc.Value
}

// Creates a new instance of the DeploymentCollectionPage type.
func NewDeploymentCollectionPage(cur DeploymentCollection, getNextPage func(context.Context, DeploymentCollection) (DeploymentCollection, error)) DeploymentCollectionPage {
	return DeploymentCollectionPage{
		fn: getNextPage,
		dc: cur,
	}
}

// DeploymentProperties ...
type DeploymentProperties struct {
	// ID - Id
	ID *string `json:"id,omitempty"`
	// Status - Status
	Status *int32 `json:"status,omitempty"`
	// Message - Message
	Message *string `json:"message,omitempty"`
	// Author - Author
	Author *string `json:"author,omitempty"`
	// Deployer - Deployer
	Deployer *string `json:"deployer,omitempty"`
	// AuthorEmail - AuthorEmail
	AuthorEmail *string `json:"author_email,omitempty"`
	// StartTime - StartTime
	StartTime *date.Time `json:"start_time,omitempty"`
	// EndTime - EndTime
	EndTime *date.Time `json:"end_time,omitempty"`
	// Active - Active
	Active *bool `json:"active,omitempty"`
	// Details - Detail
	Details *string `json:"details,omitempty"`
}

// Domain represents a domain
type Domain struct {
	autorest.Response `json:"-"`
	*DomainProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Domain.
func (d Domain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DomainProperties != nil {
		objectMap["properties"] = d.DomainProperties
	}
	if d.ID != nil {
		objectMap["id"] = d.ID
	}
	if d.Name != nil {
		objectMap["name"] = d.Name
	}
	if d.Kind != nil {
		objectMap["kind"] = d.Kind
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Type != nil {
		objectMap["type"] = d.Type
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Domain struct.
func (d *Domain) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var domainProperties DomainProperties
				err = json.Unmarshal(*v, &domainProperties)
				if err != nil {
					return err
				}
				d.DomainProperties = &domainProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		}
	}

	return nil
}

// DomainAvailablilityCheckResult domain availablility check result
type DomainAvailablilityCheckResult struct {
	autorest.Response `json:"-"`
	// Name - Name of the domain
	Name *string `json:"name,omitempty"`
	// Available - If true then domain can be purchased using CreateDomain Api
	Available *bool `json:"available,omitempty"`
	// DomainType - Domain type. Possible values include: 'Regular', 'SoftDeleted'
	DomainType DomainType `json:"domainType,omitempty"`
}

// DomainCollection collection of domains
type DomainCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]Domain `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// DomainCollectionIterator provides access to a complete listing of Domain values.
type DomainCollectionIterator struct {
	i    int
	page DomainCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DomainCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DomainCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DomainCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DomainCollectionIterator) Response() DomainCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DomainCollectionIterator) Value() Domain {
	if !iter.page.NotDone() {
		return Domain{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DomainCollectionIterator type.
func NewDomainCollectionIterator(page DomainCollectionPage) DomainCollectionIterator {
	return DomainCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dc DomainCollection) IsEmpty() bool {
	return dc.Value == nil || len(*dc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dc DomainCollection) hasNextLink() bool {
	return dc.NextLink != nil && len(*dc.NextLink) != 0
}

// domainCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dc DomainCollection) domainCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !dc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dc.NextLink)))
}

// DomainCollectionPage contains a page of Domain values.
type DomainCollectionPage struct {
	fn func(context.Context, DomainCollection) (DomainCollection, error)
	dc DomainCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DomainCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dc)
		if err != nil {
			return err
		}
		page.dc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DomainCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DomainCollectionPage) NotDone() bool {
	return !page.dc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DomainCollectionPage) Response() DomainCollection {
	return page.dc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DomainCollectionPage) Values() []Domain {
	if page.dc.IsEmpty() {
		return nil
	}
	return *page.dc.Value
}

// Creates a new instance of the DomainCollectionPage type.
func NewDomainCollectionPage(cur DomainCollection, getNextPage func(context.Context, DomainCollection) (DomainCollection, error)) DomainCollectionPage {
	return DomainCollectionPage{
		fn: getNextPage,
		dc: cur,
	}
}

// DomainControlCenterSsoRequest single sign on request information for domain management
type DomainControlCenterSsoRequest struct {
	autorest.Response `json:"-"`
	// URL - Url where the single sign on request is to be made
	URL *string `json:"url,omitempty"`
	// PostParameterKey - Post parameter key
	PostParameterKey *string `json:"postParameterKey,omitempty"`
	// PostParameterValue - Post parameter value. Client should use 'application/x-www-form-urlencoded' encoding for this value.
	PostParameterValue *string `json:"postParameterValue,omitempty"`
}

// DomainProperties ...
type DomainProperties struct {
	// ContactAdmin - Admin contact information
	ContactAdmin *Contact `json:"contactAdmin,omitempty"`
	// ContactBilling - Billing contact information
	ContactBilling *Contact `json:"contactBilling,omitempty"`
	// ContactRegistrant - Registrant contact information
	ContactRegistrant *Contact `json:"contactRegistrant,omitempty"`
	// ContactTech - Technical contact information
	ContactTech *Contact `json:"contactTech,omitempty"`
	// RegistrationStatus - Domain registration status. Possible values include: 'DomainStatusActive', 'DomainStatusAwaiting', 'DomainStatusCancelled', 'DomainStatusConfiscated', 'DomainStatusDisabled', 'DomainStatusExcluded', 'DomainStatusExpired', 'DomainStatusFailed', 'DomainStatusHeld', 'DomainStatusLocked', 'DomainStatusParked', 'DomainStatusPending', 'DomainStatusReserved', 'DomainStatusReverted', 'DomainStatusSuspended', 'DomainStatusTransferred', 'DomainStatusUnknown', 'DomainStatusUnlocked', 'DomainStatusUnparked', 'DomainStatusUpdated', 'DomainStatusJSONConverterFailed'
	RegistrationStatus DomainStatus `json:"registrationStatus,omitempty"`
	// ProvisioningState - Domain provisioning state. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// NameServers - Name servers
	NameServers *[]string `json:"nameServers,omitempty"`
	// Privacy - If true then domain privacy is enabled for this domain
	Privacy *bool `json:"privacy,omitempty"`
	// CreatedTime - Domain creation timestamp
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ExpirationTime - Domain expiration timestamp
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// LastRenewedTime - Timestamp when the domain was renewed last time
	LastRenewedTime *date.Time `json:"lastRenewedTime,omitempty"`
	// AutoRenew - If true then domain will renewed automatically
	AutoRenew *bool `json:"autoRenew,omitempty"`
	// ReadyForDNSRecordManagement - If true then Azure can assign this domain to Web Apps. This value will be true if domain registration status is active and it is hosted on name servers Azure has programmatic access to
	ReadyForDNSRecordManagement *bool `json:"readyForDnsRecordManagement,omitempty"`
	// ManagedHostNames - All hostnames derived from the domain and assigned to Azure resources
	ManagedHostNames *[]HostName `json:"managedHostNames,omitempty"`
	// Consent - Legal agreement consent
	Consent *DomainPurchaseConsent `json:"consent,omitempty"`
	// DomainNotRenewableReasons - Reasons why domain is not renewable
	DomainNotRenewableReasons *[]string `json:"domainNotRenewableReasons,omitempty"`
}

// DomainPurchaseConsent domain purchase consent object representing acceptance of applicable legal
// agreements
type DomainPurchaseConsent struct {
	// AgreementKeys - List of applicable legal agreement keys. This list can be retrieved using ListLegalAgreements Api under TopLevelDomain resource
	AgreementKeys *[]string `json:"agreementKeys,omitempty"`
	// AgreedBy - Client IP address
	AgreedBy *string `json:"agreedBy,omitempty"`
	// AgreedAt - Timestamp when the agreements were accepted
	AgreedAt *date.Time `json:"agreedAt,omitempty"`
}

// DomainRecommendationSearchParameters domain recommendation search parameters
type DomainRecommendationSearchParameters struct {
	// Keywords - Keywords to be used for generating domain recommendations
	Keywords *string `json:"keywords,omitempty"`
	// MaxDomainRecommendations - Maximum number of recommendations
	MaxDomainRecommendations *int32 `json:"maxDomainRecommendations,omitempty"`
}

// DomainRegistrationInput domain registration input for validation Api
type DomainRegistrationInput struct {
	*DomainRegistrationInputProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DomainRegistrationInput.
func (dri DomainRegistrationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dri.DomainRegistrationInputProperties != nil {
		objectMap["properties"] = dri.DomainRegistrationInputProperties
	}
	if dri.ID != nil {
		objectMap["id"] = dri.ID
	}
	if dri.Name != nil {
		objectMap["name"] = dri.Name
	}
	if dri.Kind != nil {
		objectMap["kind"] = dri.Kind
	}
	if dri.Location != nil {
		objectMap["location"] = dri.Location
	}
	if dri.Type != nil {
		objectMap["type"] = dri.Type
	}
	if dri.Tags != nil {
		objectMap["tags"] = dri.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DomainRegistrationInput struct.
func (dri *DomainRegistrationInput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var domainRegistrationInputProperties DomainRegistrationInputProperties
				err = json.Unmarshal(*v, &domainRegistrationInputProperties)
				if err != nil {
					return err
				}
				dri.DomainRegistrationInputProperties = &domainRegistrationInputProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dri.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dri.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dri.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dri.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dri.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dri.Tags = tags
			}
		}
	}

	return nil
}

// DomainRegistrationInputProperties ...
type DomainRegistrationInputProperties struct {
	// Name - Name of the domain
	Name *string `json:"name,omitempty"`
	// ContactAdmin - Admin contact information
	ContactAdmin *Contact `json:"contactAdmin,omitempty"`
	// ContactBilling - Billing contact information
	ContactBilling *Contact `json:"contactBilling,omitempty"`
	// ContactRegistrant - Registrant contact information
	ContactRegistrant *Contact `json:"contactRegistrant,omitempty"`
	// ContactTech - Technical contact information
	ContactTech *Contact `json:"contactTech,omitempty"`
	// RegistrationStatus - Domain registration status. Possible values include: 'DomainStatusActive', 'DomainStatusAwaiting', 'DomainStatusCancelled', 'DomainStatusConfiscated', 'DomainStatusDisabled', 'DomainStatusExcluded', 'DomainStatusExpired', 'DomainStatusFailed', 'DomainStatusHeld', 'DomainStatusLocked', 'DomainStatusParked', 'DomainStatusPending', 'DomainStatusReserved', 'DomainStatusReverted', 'DomainStatusSuspended', 'DomainStatusTransferred', 'DomainStatusUnknown', 'DomainStatusUnlocked', 'DomainStatusUnparked', 'DomainStatusUpdated', 'DomainStatusJSONConverterFailed'
	RegistrationStatus DomainStatus `json:"registrationStatus,omitempty"`
	// ProvisioningState - Domain provisioning state. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// NameServers - Name servers
	NameServers *[]string `json:"nameServers,omitempty"`
	// Privacy - If true then domain privacy is enabled for this domain
	Privacy *bool `json:"privacy,omitempty"`
	// CreatedTime - Domain creation timestamp
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ExpirationTime - Domain expiration timestamp
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// LastRenewedTime - Timestamp when the domain was renewed last time
	LastRenewedTime *date.Time `json:"lastRenewedTime,omitempty"`
	// AutoRenew - If true then domain will renewed automatically
	AutoRenew *bool `json:"autoRenew,omitempty"`
	// ReadyForDNSRecordManagement - If true then Azure can assign this domain to Web Apps. This value will be true if domain registration status is active and it is hosted on name servers Azure has programmatic access to
	ReadyForDNSRecordManagement *bool `json:"readyForDnsRecordManagement,omitempty"`
	// ManagedHostNames - All hostnames derived from the domain and assigned to Azure resources
	ManagedHostNames *[]HostName `json:"managedHostNames,omitempty"`
	// Consent - Legal agreement consent
	Consent *DomainPurchaseConsent `json:"consent,omitempty"`
	// DomainNotRenewableReasons - Reasons why domain is not renewable
	DomainNotRenewableReasons *[]string `json:"domainNotRenewableReasons,omitempty"`
}

// EnabledConfig enabled configuration
type EnabledConfig struct {
	// Enabled - Enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// ExpandedParentAPIEntity expanded parent object for expansion
type ExpandedParentAPIEntity struct {
	*ExpandedParentAPIEntityProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpandedParentAPIEntity.
func (epAe ExpandedParentAPIEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epAe.ExpandedParentAPIEntityProperties != nil {
		objectMap["properties"] = epAe.ExpandedParentAPIEntityProperties
	}
	if epAe.ID != nil {
		objectMap["id"] = epAe.ID
	}
	if epAe.Name != nil {
		objectMap["name"] = epAe.Name
	}
	if epAe.Kind != nil {
		objectMap["kind"] = epAe.Kind
	}
	if epAe.Location != nil {
		objectMap["location"] = epAe.Location
	}
	if epAe.Type != nil {
		objectMap["type"] = epAe.Type
	}
	if epAe.Tags != nil {
		objectMap["tags"] = epAe.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpandedParentAPIEntity struct.
func (epAe *ExpandedParentAPIEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expandedParentAPIEntityProperties ExpandedParentAPIEntityProperties
				err = json.Unmarshal(*v, &expandedParentAPIEntityProperties)
				if err != nil {
					return err
				}
				epAe.ExpandedParentAPIEntityProperties = &expandedParentAPIEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epAe.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epAe.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				epAe.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				epAe.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epAe.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				epAe.Tags = tags
			}
		}
	}

	return nil
}

// ExpandedParentAPIEntityProperties ...
type ExpandedParentAPIEntityProperties struct {
	// ID - Id of connection provider
	ID *string `json:"id,omitempty"`
	// Entity - Id of connection provider
	Entity *ResponseMessageEnvelopeAPIEntity `json:"entity,omitempty"`
}

// Experiments class containing Routing in production experiments
type Experiments struct {
	// RampUpRules - List of {Microsoft.Web.Hosting.Administration.RampUpRule} objects.
	RampUpRules *[]RampUpRule `json:"rampUpRules,omitempty"`
}

// FileSystemApplicationLogsConfig application logs to file system configuration
type FileSystemApplicationLogsConfig struct {
	// Level - Log level. Possible values include: 'LogLevelOff', 'LogLevelVerbose', 'LogLevelInformation', 'LogLevelWarning', 'LogLevelError'
	Level LogLevel `json:"level,omitempty"`
}

// FileSystemHTTPLogsConfig http logs to file system configuration
type FileSystemHTTPLogsConfig struct {
	// RetentionInMb - Maximum size in megabytes that http log files can use.
	//             When reached old log files will be removed to make space for new ones.
	//             Value can range between 25 and 100.
	RetentionInMb *int32 `json:"retentionInMb,omitempty"`
	// RetentionInDays - Retention in days.
	//             Remove files older than X days.
	//             0 or lower means no retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
	// Enabled - Enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// GeneralAPIInformation general API information
type GeneralAPIInformation struct {
	*GeneralAPIInformationProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GeneralAPIInformation.
func (gai GeneralAPIInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gai.GeneralAPIInformationProperties != nil {
		objectMap["properties"] = gai.GeneralAPIInformationProperties
	}
	if gai.ID != nil {
		objectMap["id"] = gai.ID
	}
	if gai.Name != nil {
		objectMap["name"] = gai.Name
	}
	if gai.Kind != nil {
		objectMap["kind"] = gai.Kind
	}
	if gai.Location != nil {
		objectMap["location"] = gai.Location
	}
	if gai.Type != nil {
		objectMap["type"] = gai.Type
	}
	if gai.Tags != nil {
		objectMap["tags"] = gai.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GeneralAPIInformation struct.
func (gai *GeneralAPIInformation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var generalAPIInformationProperties GeneralAPIInformationProperties
				err = json.Unmarshal(*v, &generalAPIInformationProperties)
				if err != nil {
					return err
				}
				gai.GeneralAPIInformationProperties = &generalAPIInformationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gai.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gai.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				gai.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gai.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gai.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gai.Tags = tags
			}
		}
	}

	return nil
}

// GeneralAPIInformationProperties ...
type GeneralAPIInformationProperties struct {
	// IconURL - Icon Url
	IconURL *string `json:"iconUrl,omitempty"`
	// DisplayName - Display Name
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Description
	Description *string `json:"description,omitempty"`
	// TermsOfUseURL - a public accessible url of the Terms Of Use Url of this API
	TermsOfUseURL *string `json:"termsOfUseUrl,omitempty"`
	// ConnectionDisplayName - DefaultConnectionNameTemplate
	ConnectionDisplayName *string `json:"connectionDisplayName,omitempty"`
	// ConnectionPortalURL - ConnectionPortalUrl
	ConnectionPortalURL interface{} `json:"connectionPortalUrl,omitempty"`
}

// GeoRegion geographical region
type GeoRegion struct {
	*GeoRegionProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GeoRegion.
func (gr GeoRegion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gr.GeoRegionProperties != nil {
		objectMap["properties"] = gr.GeoRegionProperties
	}
	if gr.ID != nil {
		objectMap["id"] = gr.ID
	}
	if gr.Name != nil {
		objectMap["name"] = gr.Name
	}
	if gr.Kind != nil {
		objectMap["kind"] = gr.Kind
	}
	if gr.Location != nil {
		objectMap["location"] = gr.Location
	}
	if gr.Type != nil {
		objectMap["type"] = gr.Type
	}
	if gr.Tags != nil {
		objectMap["tags"] = gr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GeoRegion struct.
func (gr *GeoRegion) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var geoRegionProperties GeoRegionProperties
				err = json.Unmarshal(*v, &geoRegionProperties)
				if err != nil {
					return err
				}
				gr.GeoRegionProperties = &geoRegionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				gr.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gr.Tags = tags
			}
		}
	}

	return nil
}

// GeoRegionCollection collection of geo regions
type GeoRegionCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]GeoRegion `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// GeoRegionCollectionIterator provides access to a complete listing of GeoRegion values.
type GeoRegionCollectionIterator struct {
	i    int
	page GeoRegionCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GeoRegionCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GeoRegionCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GeoRegionCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GeoRegionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GeoRegionCollectionIterator) Response() GeoRegionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GeoRegionCollectionIterator) Value() GeoRegion {
	if !iter.page.NotDone() {
		return GeoRegion{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GeoRegionCollectionIterator type.
func NewGeoRegionCollectionIterator(page GeoRegionCollectionPage) GeoRegionCollectionIterator {
	return GeoRegionCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (grc GeoRegionCollection) IsEmpty() bool {
	return grc.Value == nil || len(*grc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (grc GeoRegionCollection) hasNextLink() bool {
	return grc.NextLink != nil && len(*grc.NextLink) != 0
}

// geoRegionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (grc GeoRegionCollection) geoRegionCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !grc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(grc.NextLink)))
}

// GeoRegionCollectionPage contains a page of GeoRegion values.
type GeoRegionCollectionPage struct {
	fn  func(context.Context, GeoRegionCollection) (GeoRegionCollection, error)
	grc GeoRegionCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GeoRegionCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GeoRegionCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.grc)
		if err != nil {
			return err
		}
		page.grc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GeoRegionCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GeoRegionCollectionPage) NotDone() bool {
	return !page.grc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GeoRegionCollectionPage) Response() GeoRegionCollection {
	return page.grc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GeoRegionCollectionPage) Values() []GeoRegion {
	if page.grc.IsEmpty() {
		return nil
	}
	return *page.grc.Value
}

// Creates a new instance of the GeoRegionCollectionPage type.
func NewGeoRegionCollectionPage(cur GeoRegionCollection, getNextPage func(context.Context, GeoRegionCollection) (GeoRegionCollection, error)) GeoRegionCollectionPage {
	return GeoRegionCollectionPage{
		fn:  getNextPage,
		grc: cur,
	}
}

// GeoRegionProperties ...
type GeoRegionProperties struct {
	// Name - Region name
	Name *string `json:"name,omitempty"`
	// Description - Region description
	Description *string `json:"description,omitempty"`
	// DisplayName - Display name for region
	DisplayName *string `json:"displayName,omitempty"`
}

// HandlerMapping the IIS handler mappings used to define which handler processes HTTP requests with
// certain extension.
// For example it is used to configure php-cgi.exe process to handle all HTTP requests with *.php
// extension.
type HandlerMapping struct {
	// Extension - Requests with this extension will be handled using the specified FastCGI application.
	Extension *string `json:"extension,omitempty"`
	// ScriptProcessor - The absolute path to the FastCGI application.
	ScriptProcessor *string `json:"scriptProcessor,omitempty"`
	// Arguments - Command-line arguments to be passed to the script processor.
	Arguments *string `json:"arguments,omitempty"`
}

// HostingEnvironment description of an hostingEnvironment (App Service Environment)
type HostingEnvironment struct {
	autorest.Response             `json:"-"`
	*HostingEnvironmentProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for HostingEnvironment.
func (he HostingEnvironment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if he.HostingEnvironmentProperties != nil {
		objectMap["properties"] = he.HostingEnvironmentProperties
	}
	if he.ID != nil {
		objectMap["id"] = he.ID
	}
	if he.Name != nil {
		objectMap["name"] = he.Name
	}
	if he.Kind != nil {
		objectMap["kind"] = he.Kind
	}
	if he.Location != nil {
		objectMap["location"] = he.Location
	}
	if he.Type != nil {
		objectMap["type"] = he.Type
	}
	if he.Tags != nil {
		objectMap["tags"] = he.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HostingEnvironment struct.
func (he *HostingEnvironment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hostingEnvironmentProperties HostingEnvironmentProperties
				err = json.Unmarshal(*v, &hostingEnvironmentProperties)
				if err != nil {
					return err
				}
				he.HostingEnvironmentProperties = &hostingEnvironmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				he.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				he.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				he.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				he.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				he.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				he.Tags = tags
			}
		}
	}

	return nil
}

// HostingEnvironmentCollection collection of hosting environments (App Service Environments)
type HostingEnvironmentCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]HostingEnvironment `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// HostingEnvironmentCollectionIterator provides access to a complete listing of HostingEnvironment values.
type HostingEnvironmentCollectionIterator struct {
	i    int
	page HostingEnvironmentCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HostingEnvironmentCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HostingEnvironmentCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HostingEnvironmentCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HostingEnvironmentCollectionIterator) Response() HostingEnvironmentCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HostingEnvironmentCollectionIterator) Value() HostingEnvironment {
	if !iter.page.NotDone() {
		return HostingEnvironment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HostingEnvironmentCollectionIterator type.
func NewHostingEnvironmentCollectionIterator(page HostingEnvironmentCollectionPage) HostingEnvironmentCollectionIterator {
	return HostingEnvironmentCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hec HostingEnvironmentCollection) IsEmpty() bool {
	return hec.Value == nil || len(*hec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hec HostingEnvironmentCollection) hasNextLink() bool {
	return hec.NextLink != nil && len(*hec.NextLink) != 0
}

// hostingEnvironmentCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hec HostingEnvironmentCollection) hostingEnvironmentCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !hec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hec.NextLink)))
}

// HostingEnvironmentCollectionPage contains a page of HostingEnvironment values.
type HostingEnvironmentCollectionPage struct {
	fn  func(context.Context, HostingEnvironmentCollection) (HostingEnvironmentCollection, error)
	hec HostingEnvironmentCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HostingEnvironmentCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hec)
		if err != nil {
			return err
		}
		page.hec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HostingEnvironmentCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HostingEnvironmentCollectionPage) NotDone() bool {
	return !page.hec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HostingEnvironmentCollectionPage) Response() HostingEnvironmentCollection {
	return page.hec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HostingEnvironmentCollectionPage) Values() []HostingEnvironment {
	if page.hec.IsEmpty() {
		return nil
	}
	return *page.hec.Value
}

// Creates a new instance of the HostingEnvironmentCollectionPage type.
func NewHostingEnvironmentCollectionPage(cur HostingEnvironmentCollection, getNextPage func(context.Context, HostingEnvironmentCollection) (HostingEnvironmentCollection, error)) HostingEnvironmentCollectionPage {
	return HostingEnvironmentCollectionPage{
		fn:  getNextPage,
		hec: cur,
	}
}

// HostingEnvironmentDiagnostics diagnostics for a hosting environment (App Service Environment)
type HostingEnvironmentDiagnostics struct {
	autorest.Response `json:"-"`
	// Name - Name/identifier of the diagnostics
	Name *string `json:"name,omitempty"`
	// DiagnosicsOutput - Diagnostics output
	DiagnosicsOutput *string `json:"diagnosicsOutput,omitempty"`
}

// HostingEnvironmentProfile specification for a hostingEnvironment (App Service Environment) to use for
// this resource
type HostingEnvironmentProfile struct {
	// ID - Resource id of the hostingEnvironment (App Service Environment)
	ID *string `json:"id,omitempty"`
	// Name - Name of the hostingEnvironment (App Service Environment) (read only)
	Name *string `json:"name,omitempty"`
	// Type - Resource type of the hostingEnvironment (App Service Environment) (read only)
	Type *string `json:"type,omitempty"`
}

// HostingEnvironmentProperties ...
type HostingEnvironmentProperties struct {
	// Name - Name of the hostingEnvironment (App Service Environment)
	Name *string `json:"name,omitempty"`
	// Location - Location of the hostingEnvironment (App Service Environment), e.g. "West US"
	Location *string `json:"location,omitempty"`
	// ProvisioningState - Provisioning state of the hostingEnvironment (App Service Environment). Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - Current status of the hostingEnvironment (App Service Environment). Possible values include: 'Preparing', 'Ready', 'Scaling', 'Deleting'
	Status HostingEnvironmentStatus `json:"status,omitempty"`
	// VnetName - Name of the hostingEnvironment's (App Service Environment) virtual network
	VnetName *string `json:"vnetName,omitempty"`
	// VnetResourceGroupName - Resource group of the hostingEnvironment's (App Service Environment) virtual network
	VnetResourceGroupName *string `json:"vnetResourceGroupName,omitempty"`
	// VnetSubnetName - Subnet of the hostingEnvironment's (App Service Environment) virtual network
	VnetSubnetName *string `json:"vnetSubnetName,omitempty"`
	// VirtualNetwork - Description of the hostingEnvironment's (App Service Environment) virtual network
	VirtualNetwork *VirtualNetworkProfile `json:"virtualNetwork,omitempty"`
	// InternalLoadBalancingMode - Specifies which endpoints to serve internally in the hostingEnvironment's (App Service Environment) VNET. Possible values include: 'None', 'Web', 'Publishing'
	InternalLoadBalancingMode InternalLoadBalancingMode `json:"internalLoadBalancingMode,omitempty"`
	// MultiSize - Front-end VM size, e.g. "Medium", "Large"
	MultiSize *string `json:"multiSize,omitempty"`
	// MultiRoleCount - Number of front-end instances
	MultiRoleCount *int32 `json:"multiRoleCount,omitempty"`
	// WorkerPools - Description of worker pools with worker size ids, VM sizes, and number of workers in each pool
	WorkerPools *[]WorkerPool `json:"workerPools,omitempty"`
	// IpsslAddressCount - Number of IP SSL addresses reserved for this hostingEnvironment (App Service Environment)
	IpsslAddressCount *int32 `json:"ipsslAddressCount,omitempty"`
	// DatabaseEdition - Edition of the metadata database for the hostingEnvironment (App Service Environment) e.g. "Standard"
	DatabaseEdition *string `json:"databaseEdition,omitempty"`
	// DatabaseServiceObjective - Service objective of the metadata database for the hostingEnvironment (App Service Environment) e.g. "S0"
	DatabaseServiceObjective *string `json:"databaseServiceObjective,omitempty"`
	// UpgradeDomains - Number of upgrade domains of this hostingEnvironment (App Service Environment)
	UpgradeDomains *int32 `json:"upgradeDomains,omitempty"`
	// SubscriptionID - Subscription of the hostingEnvironment (App Service Environment)
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// DNSSuffix - DNS suffix of the hostingEnvironment (App Service Environment)
	DNSSuffix *string `json:"dnsSuffix,omitempty"`
	// LastAction - Last deployment action on this hostingEnvironment (App Service Environment)
	LastAction *string `json:"lastAction,omitempty"`
	// LastActionResult - Result of the last deployment action on this hostingEnvironment (App Service Environment)
	LastActionResult *string `json:"lastActionResult,omitempty"`
	// AllowedMultiSizes - List of comma separated strings describing which VM sizes are allowed for front-ends
	AllowedMultiSizes *string `json:"allowedMultiSizes,omitempty"`
	// AllowedWorkerSizes - List of comma separated strings describing which VM sizes are allowed for workers
	AllowedWorkerSizes *string `json:"allowedWorkerSizes,omitempty"`
	// MaximumNumberOfMachines - Maximum number of VMs in this hostingEnvironment (App Service Environment)
	MaximumNumberOfMachines *int32 `json:"maximumNumberOfMachines,omitempty"`
	// VipMappings - Description of IP SSL mapping for this hostingEnvironment (App Service Environment)
	VipMappings *[]VirtualIPMapping `json:"vipMappings,omitempty"`
	// EnvironmentCapacities - Current total, used, and available worker capacities
	EnvironmentCapacities *[]StampCapacity `json:"environmentCapacities,omitempty"`
	// NetworkAccessControlList - Access control list for controlling traffic to the hostingEnvironment (App Service Environment)
	NetworkAccessControlList *[]NetworkAccessControlEntry `json:"networkAccessControlList,omitempty"`
	// EnvironmentIsHealthy - True/false indicating whether the hostingEnvironment (App Service Environment) is healthy
	EnvironmentIsHealthy *bool `json:"environmentIsHealthy,omitempty"`
	// EnvironmentStatus - Detailed message about with results of the last check of the hostingEnvironment (App Service Environment)
	EnvironmentStatus *string `json:"environmentStatus,omitempty"`
	// ResourceGroup - Resource group of the hostingEnvironment (App Service Environment)
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// APIManagementAccountID - Api Management Account associated with this Hosting Environment
	APIManagementAccountID *string `json:"apiManagementAccountId,omitempty"`
	// Suspended - True/false indicating whether the hostingEnvironment is suspended. The environment can be suspended e.g. when the management endpoint is no longer available
	//             (most likely because NSG blocked the incoming traffic)
	Suspended *bool `json:"suspended,omitempty"`
	// ClusterSettings - Custom settings for changing the behavior of the hosting environment
	ClusterSettings *[]NameValuePair `json:"clusterSettings,omitempty"`
}

// HostingEnvironmentsCreateOrUpdateHostingEnvironmentFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type HostingEnvironmentsCreateOrUpdateHostingEnvironmentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HostingEnvironmentsClient) (HostingEnvironment, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HostingEnvironmentsCreateOrUpdateHostingEnvironmentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HostingEnvironmentsCreateOrUpdateHostingEnvironmentFuture.Result.
func (future *HostingEnvironmentsCreateOrUpdateHostingEnvironmentFuture) result(client HostingEnvironmentsClient) (he HostingEnvironment, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsCreateOrUpdateHostingEnvironmentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		he.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.HostingEnvironmentsCreateOrUpdateHostingEnvironmentFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if he.Response.Response, err = future.GetResult(sender); err == nil && he.Response.Response.StatusCode != http.StatusNoContent {
		he, err = client.CreateOrUpdateHostingEnvironmentResponder(he.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsCreateOrUpdateHostingEnvironmentFuture", "Result", he.Response.Response, "Failure responding to request")
		}
	}
	return
}

// HostingEnvironmentsCreateOrUpdateMultiRolePoolFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type HostingEnvironmentsCreateOrUpdateMultiRolePoolFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HostingEnvironmentsClient) (WorkerPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HostingEnvironmentsCreateOrUpdateMultiRolePoolFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HostingEnvironmentsCreateOrUpdateMultiRolePoolFuture.Result.
func (future *HostingEnvironmentsCreateOrUpdateMultiRolePoolFuture) result(client HostingEnvironmentsClient) (wp WorkerPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsCreateOrUpdateMultiRolePoolFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.HostingEnvironmentsCreateOrUpdateMultiRolePoolFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wp.Response.Response, err = future.GetResult(sender); err == nil && wp.Response.Response.StatusCode != http.StatusNoContent {
		wp, err = client.CreateOrUpdateMultiRolePoolResponder(wp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsCreateOrUpdateMultiRolePoolFuture", "Result", wp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// HostingEnvironmentsCreateOrUpdateWorkerPoolFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type HostingEnvironmentsCreateOrUpdateWorkerPoolFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HostingEnvironmentsClient) (WorkerPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HostingEnvironmentsCreateOrUpdateWorkerPoolFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HostingEnvironmentsCreateOrUpdateWorkerPoolFuture.Result.
func (future *HostingEnvironmentsCreateOrUpdateWorkerPoolFuture) result(client HostingEnvironmentsClient) (wp WorkerPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsCreateOrUpdateWorkerPoolFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.HostingEnvironmentsCreateOrUpdateWorkerPoolFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wp.Response.Response, err = future.GetResult(sender); err == nil && wp.Response.Response.StatusCode != http.StatusNoContent {
		wp, err = client.CreateOrUpdateWorkerPoolResponder(wp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsCreateOrUpdateWorkerPoolFuture", "Result", wp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// HostingEnvironmentsDeleteHostingEnvironmentFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type HostingEnvironmentsDeleteHostingEnvironmentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HostingEnvironmentsClient) (SetObject, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HostingEnvironmentsDeleteHostingEnvironmentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HostingEnvironmentsDeleteHostingEnvironmentFuture.Result.
func (future *HostingEnvironmentsDeleteHostingEnvironmentFuture) result(client HostingEnvironmentsClient) (so SetObject, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsDeleteHostingEnvironmentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		so.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.HostingEnvironmentsDeleteHostingEnvironmentFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.DeleteHostingEnvironmentResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsDeleteHostingEnvironmentFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// HostingEnvironmentServiceDescriptions back end service per ASE
type HostingEnvironmentServiceDescriptions struct {
	// HostingEnvironmentID - Hosting environment Id
	HostingEnvironmentID *string `json:"hostingEnvironmentId,omitempty"`
	// HostID - Host Id
	HostID *string `json:"hostId,omitempty"`
	// ServiceURL - service url to use
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// UseInternalRouting - When the backend url is in same ASE, for performance reason this flag can be set to true
	//             If WebApp.DisableHostNames is also set it improves the security by making the back end accessible only
	//             via API calls
	//             Note: calls will fail if this option is used but back end is not on the same ASE
	UseInternalRouting *bool `json:"useInternalRouting,omitempty"`
}

// HostingEnvironmentsResumeHostingEnvironmentAllFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type HostingEnvironmentsResumeHostingEnvironmentAllFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HostingEnvironmentsClient) (SiteCollectionPage, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HostingEnvironmentsResumeHostingEnvironmentAllFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HostingEnvironmentsResumeHostingEnvironmentAllFuture.Result.
func (future *HostingEnvironmentsResumeHostingEnvironmentAllFuture) result(client HostingEnvironmentsClient) (scp SiteCollectionPage, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsResumeHostingEnvironmentAllFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		scp.sc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.HostingEnvironmentsResumeHostingEnvironmentAllFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if scp.sc.Response.Response, err = future.GetResult(sender); err == nil && scp.sc.Response.Response.StatusCode != http.StatusNoContent {
		scp, err = client.ResumeHostingEnvironmentResponder(scp.sc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsResumeHostingEnvironmentAllFuture", "Result", scp.sc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// HostingEnvironmentsResumeHostingEnvironmentFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type HostingEnvironmentsResumeHostingEnvironmentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HostingEnvironmentsClient) (SiteCollectionPage, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HostingEnvironmentsResumeHostingEnvironmentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HostingEnvironmentsResumeHostingEnvironmentFuture.Result.
func (future *HostingEnvironmentsResumeHostingEnvironmentFuture) result(client HostingEnvironmentsClient) (scp SiteCollectionPage, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsResumeHostingEnvironmentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		scp.sc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.HostingEnvironmentsResumeHostingEnvironmentFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if scp.sc.Response.Response, err = future.GetResult(sender); err == nil && scp.sc.Response.Response.StatusCode != http.StatusNoContent {
		scp, err = client.ResumeHostingEnvironmentResponder(scp.sc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsResumeHostingEnvironmentFuture", "Result", scp.sc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// HostingEnvironmentsSuspendHostingEnvironmentAllFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type HostingEnvironmentsSuspendHostingEnvironmentAllFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HostingEnvironmentsClient) (SiteCollectionPage, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HostingEnvironmentsSuspendHostingEnvironmentAllFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HostingEnvironmentsSuspendHostingEnvironmentAllFuture.Result.
func (future *HostingEnvironmentsSuspendHostingEnvironmentAllFuture) result(client HostingEnvironmentsClient) (scp SiteCollectionPage, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsSuspendHostingEnvironmentAllFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		scp.sc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.HostingEnvironmentsSuspendHostingEnvironmentAllFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if scp.sc.Response.Response, err = future.GetResult(sender); err == nil && scp.sc.Response.Response.StatusCode != http.StatusNoContent {
		scp, err = client.SuspendHostingEnvironmentResponder(scp.sc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsSuspendHostingEnvironmentAllFuture", "Result", scp.sc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// HostingEnvironmentsSuspendHostingEnvironmentFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type HostingEnvironmentsSuspendHostingEnvironmentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HostingEnvironmentsClient) (SiteCollectionPage, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HostingEnvironmentsSuspendHostingEnvironmentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HostingEnvironmentsSuspendHostingEnvironmentFuture.Result.
func (future *HostingEnvironmentsSuspendHostingEnvironmentFuture) result(client HostingEnvironmentsClient) (scp SiteCollectionPage, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsSuspendHostingEnvironmentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		scp.sc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.HostingEnvironmentsSuspendHostingEnvironmentFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if scp.sc.Response.Response, err = future.GetResult(sender); err == nil && scp.sc.Response.Response.StatusCode != http.StatusNoContent {
		scp, err = client.SuspendHostingEnvironmentResponder(scp.sc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsSuspendHostingEnvironmentFuture", "Result", scp.sc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// HostName details of a hostname derived from a domain
type HostName struct {
	// Name - Name of the hostname
	Name *string `json:"name,omitempty"`
	// SiteNames - List of sites the hostname is assigned to. This list will have more than one site only if the hostname is pointing to a Traffic Manager
	SiteNames *[]string `json:"siteNames,omitempty"`
	// AzureResourceName - Name of the Azure resource the hostname is assigned to. If it is assigned to a traffic manager then it will be the traffic manager name otherwise it will be the website name
	AzureResourceName *string `json:"azureResourceName,omitempty"`
	// AzureResourceType - Type of the Azure resource the hostname is assigned to. Possible values include: 'Website', 'TrafficManager'
	AzureResourceType AzureResourceType `json:"azureResourceType,omitempty"`
	// CustomHostNameDNSRecordType - Type of the Dns record. Possible values include: 'CName', 'A'
	CustomHostNameDNSRecordType CustomHostNameDNSRecordType `json:"customHostNameDnsRecordType,omitempty"`
	// HostNameType - Type of the hostname. Possible values include: 'Verified', 'Managed'
	HostNameType HostNameType `json:"hostNameType,omitempty"`
}

// HostNameBinding a host name binding object
type HostNameBinding struct {
	autorest.Response          `json:"-"`
	*HostNameBindingProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for HostNameBinding.
func (hnb HostNameBinding) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hnb.HostNameBindingProperties != nil {
		objectMap["properties"] = hnb.HostNameBindingProperties
	}
	if hnb.ID != nil {
		objectMap["id"] = hnb.ID
	}
	if hnb.Name != nil {
		objectMap["name"] = hnb.Name
	}
	if hnb.Kind != nil {
		objectMap["kind"] = hnb.Kind
	}
	if hnb.Location != nil {
		objectMap["location"] = hnb.Location
	}
	if hnb.Type != nil {
		objectMap["type"] = hnb.Type
	}
	if hnb.Tags != nil {
		objectMap["tags"] = hnb.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HostNameBinding struct.
func (hnb *HostNameBinding) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hostNameBindingProperties HostNameBindingProperties
				err = json.Unmarshal(*v, &hostNameBindingProperties)
				if err != nil {
					return err
				}
				hnb.HostNameBindingProperties = &hostNameBindingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hnb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hnb.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				hnb.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				hnb.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hnb.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				hnb.Tags = tags
			}
		}
	}

	return nil
}

// HostNameBindingCollection collection of host name bindings
type HostNameBindingCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]HostNameBinding `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// HostNameBindingCollectionIterator provides access to a complete listing of HostNameBinding values.
type HostNameBindingCollectionIterator struct {
	i    int
	page HostNameBindingCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HostNameBindingCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostNameBindingCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HostNameBindingCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HostNameBindingCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HostNameBindingCollectionIterator) Response() HostNameBindingCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HostNameBindingCollectionIterator) Value() HostNameBinding {
	if !iter.page.NotDone() {
		return HostNameBinding{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HostNameBindingCollectionIterator type.
func NewHostNameBindingCollectionIterator(page HostNameBindingCollectionPage) HostNameBindingCollectionIterator {
	return HostNameBindingCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hnbc HostNameBindingCollection) IsEmpty() bool {
	return hnbc.Value == nil || len(*hnbc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hnbc HostNameBindingCollection) hasNextLink() bool {
	return hnbc.NextLink != nil && len(*hnbc.NextLink) != 0
}

// hostNameBindingCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hnbc HostNameBindingCollection) hostNameBindingCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !hnbc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hnbc.NextLink)))
}

// HostNameBindingCollectionPage contains a page of HostNameBinding values.
type HostNameBindingCollectionPage struct {
	fn   func(context.Context, HostNameBindingCollection) (HostNameBindingCollection, error)
	hnbc HostNameBindingCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HostNameBindingCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostNameBindingCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hnbc)
		if err != nil {
			return err
		}
		page.hnbc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HostNameBindingCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HostNameBindingCollectionPage) NotDone() bool {
	return !page.hnbc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HostNameBindingCollectionPage) Response() HostNameBindingCollection {
	return page.hnbc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HostNameBindingCollectionPage) Values() []HostNameBinding {
	if page.hnbc.IsEmpty() {
		return nil
	}
	return *page.hnbc.Value
}

// Creates a new instance of the HostNameBindingCollectionPage type.
func NewHostNameBindingCollectionPage(cur HostNameBindingCollection, getNextPage func(context.Context, HostNameBindingCollection) (HostNameBindingCollection, error)) HostNameBindingCollectionPage {
	return HostNameBindingCollectionPage{
		fn:   getNextPage,
		hnbc: cur,
	}
}

// HostNameBindingProperties ...
type HostNameBindingProperties struct {
	// Name - Hostname
	Name *string `json:"name,omitempty"`
	// SiteName - Web app name
	SiteName *string `json:"siteName,omitempty"`
	// DomainID - Fully qualified ARM domain resource URI
	DomainID *string `json:"domainId,omitempty"`
	// AzureResourceName - Azure resource name
	AzureResourceName *string `json:"azureResourceName,omitempty"`
	// AzureResourceType - Azure resource type. Possible values include: 'Website', 'TrafficManager'
	AzureResourceType AzureResourceType `json:"azureResourceType,omitempty"`
	// CustomHostNameDNSRecordType - Custom DNS record type. Possible values include: 'CName', 'A'
	CustomHostNameDNSRecordType CustomHostNameDNSRecordType `json:"customHostNameDnsRecordType,omitempty"`
	// HostNameType - Host name type. Possible values include: 'Verified', 'Managed'
	HostNameType HostNameType `json:"hostNameType,omitempty"`
}

// HostNameSslState object that represents a SSL-enabled host name.
type HostNameSslState struct {
	// Name - Host name
	Name *string `json:"name,omitempty"`
	// SslState - SSL type. Possible values include: 'Disabled', 'SniEnabled', 'IPBasedEnabled'
	SslState SslState `json:"sslState,omitempty"`
	// VirtualIP - Virtual IP address assigned to the host name if IP based SSL is enabled
	VirtualIP *string `json:"virtualIP,omitempty"`
	// Thumbprint - SSL cert thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ToUpdate - Set this flag to update existing host name
	ToUpdate *bool `json:"toUpdate,omitempty"`
}

// HTTPLogsConfig http logs configuration
type HTTPLogsConfig struct {
	// FileSystem - Http logs to file system configuration
	FileSystem *FileSystemHTTPLogsConfig `json:"fileSystem,omitempty"`
	// AzureBlobStorage - Http logs to azure blob storage configuration
	AzureBlobStorage *AzureBlobStorageHTTPLogsConfig `json:"azureBlobStorage,omitempty"`
}

// IPSecurityRestriction represents an ip security restriction on a web app.
type IPSecurityRestriction struct {
	// IPAddress - IP address the security restriction is valid for
	IPAddress *string `json:"ipAddress,omitempty"`
	// SubnetMask - Subnet mask for the range of IP addresses the restriction is valid for
	SubnetMask *string `json:"subnetMask,omitempty"`
}

// KeyValuePairStringString ...
type KeyValuePairStringString struct {
	// Key - READ-ONLY
	Key *string `json:"key,omitempty"`
	// Value - READ-ONLY
	Value *string `json:"value,omitempty"`
}

// ListCertificateEmail ...
type ListCertificateEmail struct {
	autorest.Response `json:"-"`
	Value             *[]CertificateEmail `json:"value,omitempty"`
}

// ListCertificateOrderAction ...
type ListCertificateOrderAction struct {
	autorest.Response `json:"-"`
	Value             *[]CertificateOrderAction `json:"value,omitempty"`
}

// ListConnectionKeysInput list Connection Keys Input payload
type ListConnectionKeysInput struct {
	*ListConnectionKeysInputProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ListConnectionKeysInput.
func (lcki ListConnectionKeysInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lcki.ListConnectionKeysInputProperties != nil {
		objectMap["properties"] = lcki.ListConnectionKeysInputProperties
	}
	if lcki.ID != nil {
		objectMap["id"] = lcki.ID
	}
	if lcki.Name != nil {
		objectMap["name"] = lcki.Name
	}
	if lcki.Kind != nil {
		objectMap["kind"] = lcki.Kind
	}
	if lcki.Location != nil {
		objectMap["location"] = lcki.Location
	}
	if lcki.Type != nil {
		objectMap["type"] = lcki.Type
	}
	if lcki.Tags != nil {
		objectMap["tags"] = lcki.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ListConnectionKeysInput struct.
func (lcki *ListConnectionKeysInput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var listConnectionKeysInputProperties ListConnectionKeysInputProperties
				err = json.Unmarshal(*v, &listConnectionKeysInputProperties)
				if err != nil {
					return err
				}
				lcki.ListConnectionKeysInputProperties = &listConnectionKeysInputProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lcki.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lcki.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				lcki.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lcki.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lcki.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lcki.Tags = tags
			}
		}
	}

	return nil
}

// ListConnectionKeysInputProperties ...
type ListConnectionKeysInputProperties struct {
	// ValidityTimeSpan - time span for how long the keys will be valid
	ValidityTimeSpan *string `json:"validityTimeSpan,omitempty"`
}

// ListCsr ...
type ListCsr struct {
	autorest.Response `json:"-"`
	Value             *[]Csr `json:"value,omitempty"`
}

// ListHostingEnvironmentDiagnostics ...
type ListHostingEnvironmentDiagnostics struct {
	autorest.Response `json:"-"`
	Value             *[]HostingEnvironmentDiagnostics `json:"value,omitempty"`
}

// ListRecommendation ...
type ListRecommendation struct {
	autorest.Response `json:"-"`
	Value             *[]Recommendation `json:"value,omitempty"`
}

// ListVnetInfo ...
type ListVnetInfo struct {
	autorest.Response `json:"-"`
	Value             *[]VnetInfo `json:"value,omitempty"`
}

// ListVnetRoute ...
type ListVnetRoute struct {
	autorest.Response `json:"-"`
	Value             *[]VnetRoute `json:"value,omitempty"`
}

// LocalizableString localizableString object containing the name and a localized value.
type LocalizableString struct {
	// Value - Non localized name
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Localized name
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// ManagedHostingEnvironment description of a managed hosting environment
type ManagedHostingEnvironment struct {
	autorest.Response                    `json:"-"`
	*ManagedHostingEnvironmentProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedHostingEnvironment.
func (mhe ManagedHostingEnvironment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mhe.ManagedHostingEnvironmentProperties != nil {
		objectMap["properties"] = mhe.ManagedHostingEnvironmentProperties
	}
	if mhe.ID != nil {
		objectMap["id"] = mhe.ID
	}
	if mhe.Name != nil {
		objectMap["name"] = mhe.Name
	}
	if mhe.Kind != nil {
		objectMap["kind"] = mhe.Kind
	}
	if mhe.Location != nil {
		objectMap["location"] = mhe.Location
	}
	if mhe.Type != nil {
		objectMap["type"] = mhe.Type
	}
	if mhe.Tags != nil {
		objectMap["tags"] = mhe.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedHostingEnvironment struct.
func (mhe *ManagedHostingEnvironment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedHostingEnvironmentProperties ManagedHostingEnvironmentProperties
				err = json.Unmarshal(*v, &managedHostingEnvironmentProperties)
				if err != nil {
					return err
				}
				mhe.ManagedHostingEnvironmentProperties = &managedHostingEnvironmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mhe.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mhe.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mhe.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mhe.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mhe.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mhe.Tags = tags
			}
		}
	}

	return nil
}

// ManagedHostingEnvironmentCollection collection of managed hosting environments
type ManagedHostingEnvironmentCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]ManagedHostingEnvironment `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedHostingEnvironmentCollectionIterator provides access to a complete listing of
// ManagedHostingEnvironment values.
type ManagedHostingEnvironmentCollectionIterator struct {
	i    int
	page ManagedHostingEnvironmentCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedHostingEnvironmentCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHostingEnvironmentCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedHostingEnvironmentCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedHostingEnvironmentCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedHostingEnvironmentCollectionIterator) Response() ManagedHostingEnvironmentCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedHostingEnvironmentCollectionIterator) Value() ManagedHostingEnvironment {
	if !iter.page.NotDone() {
		return ManagedHostingEnvironment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedHostingEnvironmentCollectionIterator type.
func NewManagedHostingEnvironmentCollectionIterator(page ManagedHostingEnvironmentCollectionPage) ManagedHostingEnvironmentCollectionIterator {
	return ManagedHostingEnvironmentCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mhec ManagedHostingEnvironmentCollection) IsEmpty() bool {
	return mhec.Value == nil || len(*mhec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mhec ManagedHostingEnvironmentCollection) hasNextLink() bool {
	return mhec.NextLink != nil && len(*mhec.NextLink) != 0
}

// managedHostingEnvironmentCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mhec ManagedHostingEnvironmentCollection) managedHostingEnvironmentCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !mhec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mhec.NextLink)))
}

// ManagedHostingEnvironmentCollectionPage contains a page of ManagedHostingEnvironment values.
type ManagedHostingEnvironmentCollectionPage struct {
	fn   func(context.Context, ManagedHostingEnvironmentCollection) (ManagedHostingEnvironmentCollection, error)
	mhec ManagedHostingEnvironmentCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedHostingEnvironmentCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHostingEnvironmentCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mhec)
		if err != nil {
			return err
		}
		page.mhec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedHostingEnvironmentCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedHostingEnvironmentCollectionPage) NotDone() bool {
	return !page.mhec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedHostingEnvironmentCollectionPage) Response() ManagedHostingEnvironmentCollection {
	return page.mhec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedHostingEnvironmentCollectionPage) Values() []ManagedHostingEnvironment {
	if page.mhec.IsEmpty() {
		return nil
	}
	return *page.mhec.Value
}

// Creates a new instance of the ManagedHostingEnvironmentCollectionPage type.
func NewManagedHostingEnvironmentCollectionPage(cur ManagedHostingEnvironmentCollection, getNextPage func(context.Context, ManagedHostingEnvironmentCollection) (ManagedHostingEnvironmentCollection, error)) ManagedHostingEnvironmentCollectionPage {
	return ManagedHostingEnvironmentCollectionPage{
		fn:   getNextPage,
		mhec: cur,
	}
}

// ManagedHostingEnvironmentProperties ...
type ManagedHostingEnvironmentProperties struct {
	// Name - Name of the managed hosting environment
	Name *string `json:"name,omitempty"`
	// Location - Location of the managed hosting environment e.g. "West US"
	Location *string `json:"location,omitempty"`
	// Status - Current status of the managed hosting environment. Possible values include: 'ManagedHostingEnvironmentStatusPreparing', 'ManagedHostingEnvironmentStatusReady', 'ManagedHostingEnvironmentStatusDeleting'
	Status ManagedHostingEnvironmentStatus `json:"status,omitempty"`
	// VirtualNetwork - Description of the managed hosting environment's virtual network
	VirtualNetwork *VirtualNetworkProfile `json:"virtualNetwork,omitempty"`
	// IpsslAddressCount - Number of ip ssl addresses reserved for the managed hosting environment
	IpsslAddressCount *int32 `json:"ipsslAddressCount,omitempty"`
	// DNSSuffix - DNS suffix of the managed hosting environment
	DNSSuffix *string `json:"dnsSuffix,omitempty"`
	// SubscriptionID - Subscription of the managed hosting environment (read only)
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - Resource group of the managed hosting environment (read only)
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// EnvironmentIsHealthy - True/false indicating whether the managed hosting environment is healthy
	EnvironmentIsHealthy *bool `json:"environmentIsHealthy,omitempty"`
	// EnvironmentStatus - Detailed message about with results of the last check of the managed hosting environment
	EnvironmentStatus *string `json:"environmentStatus,omitempty"`
	// Suspended - True/false indicating whether the managed hosting environment is suspended. The environment can be suspended e.g. when the management endpoint is no longer available
	//             (most likely because NSG blocked the incoming traffic)
	Suspended *bool `json:"suspended,omitempty"`
	// APIManagementAccount - Resource id of the api management account associated with this managed hosting environment (read only)
	APIManagementAccount *string `json:"apiManagementAccount,omitempty"`
}

// ManagedHostingEnvironmentsCreateOrUpdateManagedHostingEnvironmentFuture an abstraction for monitoring
// and retrieving the results of a long-running operation.
type ManagedHostingEnvironmentsCreateOrUpdateManagedHostingEnvironmentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedHostingEnvironmentsClient) (HostingEnvironment, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedHostingEnvironmentsCreateOrUpdateManagedHostingEnvironmentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedHostingEnvironmentsCreateOrUpdateManagedHostingEnvironmentFuture.Result.
func (future *ManagedHostingEnvironmentsCreateOrUpdateManagedHostingEnvironmentFuture) result(client ManagedHostingEnvironmentsClient) (he HostingEnvironment, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ManagedHostingEnvironmentsCreateOrUpdateManagedHostingEnvironmentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		he.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.ManagedHostingEnvironmentsCreateOrUpdateManagedHostingEnvironmentFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if he.Response.Response, err = future.GetResult(sender); err == nil && he.Response.Response.StatusCode != http.StatusNoContent {
		he, err = client.CreateOrUpdateManagedHostingEnvironmentResponder(he.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.ManagedHostingEnvironmentsCreateOrUpdateManagedHostingEnvironmentFuture", "Result", he.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedHostingEnvironmentsDeleteManagedHostingEnvironmentFuture an abstraction for monitoring and
// retrieving the results of a long-running operation.
type ManagedHostingEnvironmentsDeleteManagedHostingEnvironmentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedHostingEnvironmentsClient) (SetObject, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedHostingEnvironmentsDeleteManagedHostingEnvironmentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedHostingEnvironmentsDeleteManagedHostingEnvironmentFuture.Result.
func (future *ManagedHostingEnvironmentsDeleteManagedHostingEnvironmentFuture) result(client ManagedHostingEnvironmentsClient) (so SetObject, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ManagedHostingEnvironmentsDeleteManagedHostingEnvironmentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		so.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.ManagedHostingEnvironmentsDeleteManagedHostingEnvironmentFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.DeleteManagedHostingEnvironmentResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.ManagedHostingEnvironmentsDeleteManagedHostingEnvironmentFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MetricAvailabilily class representing metrics availability and retention
type MetricAvailabilily struct {
	// TimeGrain - Time grain
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Retention - Retention period for the current {Microsoft.Web.Hosting.Administration.MetricAvailabilily.TimeGrain}
	Retention *string `json:"retention,omitempty"`
}

// MetricDefinition class representing metadata for the metrics
type MetricDefinition struct {
	autorest.Response           `json:"-"`
	*MetricDefinitionProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for MetricDefinition.
func (md MetricDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if md.MetricDefinitionProperties != nil {
		objectMap["properties"] = md.MetricDefinitionProperties
	}
	if md.ID != nil {
		objectMap["id"] = md.ID
	}
	if md.Name != nil {
		objectMap["name"] = md.Name
	}
	if md.Kind != nil {
		objectMap["kind"] = md.Kind
	}
	if md.Location != nil {
		objectMap["location"] = md.Location
	}
	if md.Type != nil {
		objectMap["type"] = md.Type
	}
	if md.Tags != nil {
		objectMap["tags"] = md.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MetricDefinition struct.
func (md *MetricDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var metricDefinitionProperties MetricDefinitionProperties
				err = json.Unmarshal(*v, &metricDefinitionProperties)
				if err != nil {
					return err
				}
				md.MetricDefinitionProperties = &metricDefinitionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				md.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				md.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				md.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				md.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				md.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				md.Tags = tags
			}
		}
	}

	return nil
}

// MetricDefinitionCollection collection of metric definitions
type MetricDefinitionCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]MetricDefinition `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// MetricDefinitionCollectionIterator provides access to a complete listing of MetricDefinition values.
type MetricDefinitionCollectionIterator struct {
	i    int
	page MetricDefinitionCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MetricDefinitionCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MetricDefinitionCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MetricDefinitionCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MetricDefinitionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MetricDefinitionCollectionIterator) Response() MetricDefinitionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MetricDefinitionCollectionIterator) Value() MetricDefinition {
	if !iter.page.NotDone() {
		return MetricDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MetricDefinitionCollectionIterator type.
func NewMetricDefinitionCollectionIterator(page MetricDefinitionCollectionPage) MetricDefinitionCollectionIterator {
	return MetricDefinitionCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mdc MetricDefinitionCollection) IsEmpty() bool {
	return mdc.Value == nil || len(*mdc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mdc MetricDefinitionCollection) hasNextLink() bool {
	return mdc.NextLink != nil && len(*mdc.NextLink) != 0
}

// metricDefinitionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mdc MetricDefinitionCollection) metricDefinitionCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !mdc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mdc.NextLink)))
}

// MetricDefinitionCollectionPage contains a page of MetricDefinition values.
type MetricDefinitionCollectionPage struct {
	fn  func(context.Context, MetricDefinitionCollection) (MetricDefinitionCollection, error)
	mdc MetricDefinitionCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MetricDefinitionCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MetricDefinitionCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mdc)
		if err != nil {
			return err
		}
		page.mdc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MetricDefinitionCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MetricDefinitionCollectionPage) NotDone() bool {
	return !page.mdc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MetricDefinitionCollectionPage) Response() MetricDefinitionCollection {
	return page.mdc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MetricDefinitionCollectionPage) Values() []MetricDefinition {
	if page.mdc.IsEmpty() {
		return nil
	}
	return *page.mdc.Value
}

// Creates a new instance of the MetricDefinitionCollectionPage type.
func NewMetricDefinitionCollectionPage(cur MetricDefinitionCollection, getNextPage func(context.Context, MetricDefinitionCollection) (MetricDefinitionCollection, error)) MetricDefinitionCollectionPage {
	return MetricDefinitionCollectionPage{
		fn:  getNextPage,
		mdc: cur,
	}
}

// MetricDefinitionProperties ...
type MetricDefinitionProperties struct {
	// Name - Name of the metric
	Name *string `json:"name,omitempty"`
	// Unit - Unit of the metric
	Unit *string `json:"unit,omitempty"`
	// PrimaryAggregationType - Primary aggregation type
	PrimaryAggregationType *string `json:"primaryAggregationType,omitempty"`
	// MetricAvailabilities - List of time grains supported for the metric together with retention period
	MetricAvailabilities *[]MetricAvailabilily `json:"metricAvailabilities,omitempty"`
	// DisplayName - Friendly name shown in the UI
	DisplayName *string `json:"displayName,omitempty"`
}

// NameIdentifier identifies an object
type NameIdentifier struct {
	// Name - Name of the object
	Name *string `json:"name,omitempty"`
}

// NameIdentifierCollection collection of domain name identifiers
type NameIdentifierCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]NameIdentifier `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// NameIdentifierCollectionIterator provides access to a complete listing of NameIdentifier values.
type NameIdentifierCollectionIterator struct {
	i    int
	page NameIdentifierCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NameIdentifierCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NameIdentifierCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NameIdentifierCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NameIdentifierCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NameIdentifierCollectionIterator) Response() NameIdentifierCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NameIdentifierCollectionIterator) Value() NameIdentifier {
	if !iter.page.NotDone() {
		return NameIdentifier{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NameIdentifierCollectionIterator type.
func NewNameIdentifierCollectionIterator(page NameIdentifierCollectionPage) NameIdentifierCollectionIterator {
	return NameIdentifierCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nic NameIdentifierCollection) IsEmpty() bool {
	return nic.Value == nil || len(*nic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nic NameIdentifierCollection) hasNextLink() bool {
	return nic.NextLink != nil && len(*nic.NextLink) != 0
}

// nameIdentifierCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nic NameIdentifierCollection) nameIdentifierCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !nic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nic.NextLink)))
}

// NameIdentifierCollectionPage contains a page of NameIdentifier values.
type NameIdentifierCollectionPage struct {
	fn  func(context.Context, NameIdentifierCollection) (NameIdentifierCollection, error)
	nic NameIdentifierCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NameIdentifierCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NameIdentifierCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nic)
		if err != nil {
			return err
		}
		page.nic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NameIdentifierCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NameIdentifierCollectionPage) NotDone() bool {
	return !page.nic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NameIdentifierCollectionPage) Response() NameIdentifierCollection {
	return page.nic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NameIdentifierCollectionPage) Values() []NameIdentifier {
	if page.nic.IsEmpty() {
		return nil
	}
	return *page.nic.Value
}

// Creates a new instance of the NameIdentifierCollectionPage type.
func NewNameIdentifierCollectionPage(cur NameIdentifierCollection, getNextPage func(context.Context, NameIdentifierCollection) (NameIdentifierCollection, error)) NameIdentifierCollectionPage {
	return NameIdentifierCollectionPage{
		fn:  getNextPage,
		nic: cur,
	}
}

// NameValuePair name value pair
type NameValuePair struct {
	// Name - Pair name
	Name *string `json:"name,omitempty"`
	// Value - Pair value
	Value *string `json:"value,omitempty"`
}

// NetworkAccessControlEntry ...
type NetworkAccessControlEntry struct {
	// Action - Possible values include: 'Permit', 'Deny'
	Action       AccessControlEntryAction `json:"action,omitempty"`
	Description  *string                  `json:"description,omitempty"`
	Order        *int32                   `json:"order,omitempty"`
	RemoteSubnet *string                  `json:"remoteSubnet,omitempty"`
}

// NetworkFeatures this is an object used to store a full view of network features (presently VNET
// integration and Hybrid Connections)
// for a web app.
type NetworkFeatures struct {
	autorest.Response          `json:"-"`
	*NetworkFeaturesProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for NetworkFeatures.
func (nf NetworkFeatures) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nf.NetworkFeaturesProperties != nil {
		objectMap["properties"] = nf.NetworkFeaturesProperties
	}
	if nf.ID != nil {
		objectMap["id"] = nf.ID
	}
	if nf.Name != nil {
		objectMap["name"] = nf.Name
	}
	if nf.Kind != nil {
		objectMap["kind"] = nf.Kind
	}
	if nf.Location != nil {
		objectMap["location"] = nf.Location
	}
	if nf.Type != nil {
		objectMap["type"] = nf.Type
	}
	if nf.Tags != nil {
		objectMap["tags"] = nf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkFeatures struct.
func (nf *NetworkFeatures) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var networkFeaturesProperties NetworkFeaturesProperties
				err = json.Unmarshal(*v, &networkFeaturesProperties)
				if err != nil {
					return err
				}
				nf.NetworkFeaturesProperties = &networkFeaturesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nf.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				nf.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				nf.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nf.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				nf.Tags = tags
			}
		}
	}

	return nil
}

// NetworkFeaturesProperties ...
type NetworkFeaturesProperties struct {
	// VirtualNetworkName - The Vnet Name
	VirtualNetworkName *string `json:"virtualNetworkName,omitempty"`
	// VirtualNetworkConnection - The Vnet Summary view
	VirtualNetworkConnection *VnetInfo `json:"virtualNetworkConnection,omitempty"`
	// HybridConnections - The Hybrid Connections Summary view
	HybridConnections *[]RelayServiceConnectionEntity `json:"hybridConnections,omitempty"`
}

// ParameterCustomLoginSettingValues custom logging setting values
type ParameterCustomLoginSettingValues struct {
	*ParameterCustomLoginSettingValuesProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ParameterCustomLoginSettingValues.
func (pclsv ParameterCustomLoginSettingValues) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pclsv.ParameterCustomLoginSettingValuesProperties != nil {
		objectMap["properties"] = pclsv.ParameterCustomLoginSettingValuesProperties
	}
	if pclsv.ID != nil {
		objectMap["id"] = pclsv.ID
	}
	if pclsv.Name != nil {
		objectMap["name"] = pclsv.Name
	}
	if pclsv.Kind != nil {
		objectMap["kind"] = pclsv.Kind
	}
	if pclsv.Location != nil {
		objectMap["location"] = pclsv.Location
	}
	if pclsv.Type != nil {
		objectMap["type"] = pclsv.Type
	}
	if pclsv.Tags != nil {
		objectMap["tags"] = pclsv.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ParameterCustomLoginSettingValues struct.
func (pclsv *ParameterCustomLoginSettingValues) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var parameterCustomLoginSettingValuesProperties ParameterCustomLoginSettingValuesProperties
				err = json.Unmarshal(*v, &parameterCustomLoginSettingValuesProperties)
				if err != nil {
					return err
				}
				pclsv.ParameterCustomLoginSettingValuesProperties = &parameterCustomLoginSettingValuesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pclsv.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pclsv.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pclsv.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pclsv.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pclsv.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pclsv.Tags = tags
			}
		}
	}

	return nil
}

// ParameterCustomLoginSettingValuesProperties ...
type ParameterCustomLoginSettingValuesProperties struct {
	// CustomParameters - Custom parameters.
	CustomParameters map[string]*CustomLoginSettingValue `json:"customParameters"`
}

// MarshalJSON is the custom marshaler for ParameterCustomLoginSettingValuesProperties.
func (pclsv ParameterCustomLoginSettingValuesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pclsv.CustomParameters != nil {
		objectMap["customParameters"] = pclsv.CustomParameters
	}
	return json.Marshal(objectMap)
}

// PremierAddOnRequest ...
type PremierAddOnRequest struct {
	// Location - Geo region resource belongs to e.g. SouthCentralUS, SouthEastAsia
	Location *string `json:"location,omitempty"`
	// Tags - Tags associated with resource
	Tags map[string]*string `json:"tags"`
	// Plan - Azure resource manager plan
	Plan *ArmPlan `json:"plan,omitempty"`
	// Properties - Resource specific properties
	Properties interface{} `json:"properties,omitempty"`
	// Sku - Sku description of the resource
	Sku *SkuDescription `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for PremierAddOnRequest.
func (paor PremierAddOnRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if paor.Location != nil {
		objectMap["location"] = paor.Location
	}
	if paor.Tags != nil {
		objectMap["tags"] = paor.Tags
	}
	if paor.Plan != nil {
		objectMap["plan"] = paor.Plan
	}
	if paor.Properties != nil {
		objectMap["properties"] = paor.Properties
	}
	if paor.Sku != nil {
		objectMap["sku"] = paor.Sku
	}
	return json.Marshal(objectMap)
}

// RampUpRule routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or
// to gradually change routing % based on performance
type RampUpRule struct {
	// ActionHostName - Hostname of a slot to which the traffic will be redirected if decided to. E.g. mysite-stage.azurewebsites.net
	ActionHostName *string `json:"actionHostName,omitempty"`
	// ReroutePercentage - Percentage of the traffic which will be redirected to {Microsoft.Web.Hosting.Administration.RampUpRule.ActionHostName}
	ReroutePercentage *float64 `json:"reroutePercentage,omitempty"`
	// ChangeStep - [Optional] In auto ramp up scenario this is the step to add/remove from {Microsoft.Web.Hosting.Administration.RampUpRule.ReroutePercentage} until it reaches
	//             {Microsoft.Web.Hosting.Administration.RampUpRule.MinReroutePercentage} or {Microsoft.Web.Hosting.Administration.RampUpRule.MaxReroutePercentage}. Site metrics are checked every N minutes specified in {Microsoft.Web.Hosting.Administration.RampUpRule.ChangeIntervalInMinutes}.
	//             Custom decision algorithm can be provided in TiPCallback site extension which Url can be specified in {Microsoft.Web.Hosting.Administration.RampUpRule.ChangeDecisionCallbackUrl}
	ChangeStep *float64 `json:"changeStep,omitempty"`
	// ChangeIntervalInMinutes - [Optional] Specifies interval in minutes to reevaluate ReroutePercentage
	ChangeIntervalInMinutes *int32 `json:"changeIntervalInMinutes,omitempty"`
	// MinReroutePercentage - [Optional] Specifies lower boundary above which ReroutePercentage will stay.
	MinReroutePercentage *float64 `json:"minReroutePercentage,omitempty"`
	// MaxReroutePercentage - [Optional] Specifies upper boundary below which ReroutePercentage will stay.
	MaxReroutePercentage *float64 `json:"maxReroutePercentage,omitempty"`
	// ChangeDecisionCallbackURL - Custom decision algorithm can be provided in TiPCallback site extension which Url can be specified. See TiPCallback site extension for the scaffold and contracts.
	//             https://www.siteextensions.net/packages/TiPCallback/
	ChangeDecisionCallbackURL *string `json:"changeDecisionCallbackUrl,omitempty"`
	// Name - Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
	Name *string `json:"name,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// Recommendation represents a recommendation result generated by the recommendation engine
type Recommendation struct {
	// CreationTime - Timestamp when this instance was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// RecommendationID - A GUID value that each recommendation object is associated with.
	RecommendationID *string `json:"recommendationId,omitempty"`
	// ResourceID - Full ARM resource ID string that this recommendation object is associated with.
	ResourceID *string `json:"resourceId,omitempty"`
	// ResourceScope - Name of a resource type this recommendation applies, e.g. Subscription, ServerFarm, Site.
	ResourceScope *string `json:"resourceScope,omitempty"`
	// RuleName - Unique name of the rule
	RuleName *string `json:"ruleName,omitempty"`
	// DisplayName - UI friendly name of the rule (may not be unique)
	DisplayName *string `json:"displayName,omitempty"`
	// Message - Localized text of recommendation, good for UI.
	Message *string `json:"message,omitempty"`
	// Level - Level indicating how critical this recommendation can impact. Possible values include: 'Critical', 'Warning', 'Information', 'NonUrgentSuggestion'
	Level NotificationLevel `json:"level,omitempty"`
	// Channels - List of channels that this recommendation can apply. Possible values include: 'Notification', 'API', 'Email', 'All'
	Channels Channels `json:"channels,omitempty"`
	// Tags - The list of category tags that this recommendation belongs to.
	Tags *[]string `json:"tags,omitempty"`
	// ActionName - Name of action recommended by this object.
	ActionName *string `json:"actionName,omitempty"`
	// Enabled - On/off flag indicating the rule is currently enabled or disabled.
	Enabled *int32 `json:"enabled,omitempty"`
	// StartTime - The beginning time of a range that the recommendation refers to.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time of a range that the recommendation refers to.
	EndTime *date.Time `json:"endTime,omitempty"`
	// NextNotificationTime - When to notify this recommendation next. Null means that this will never be notified anymore.
	NextNotificationTime *date.Time `json:"nextNotificationTime,omitempty"`
	// NotificationExpirationTime - Date and time when this notification expires.
	NotificationExpirationTime *date.Time `json:"notificationExpirationTime,omitempty"`
	// NotifiedTime - Last timestamp this instance was actually notified. Null means that this recommendation hasn't been notified yet.
	NotifiedTime *date.Time `json:"notifiedTime,omitempty"`
	// Score - A metric value measured by the rule.
	Score *float64 `json:"score,omitempty"`
}

// RecommendationRule represents a recommendation rule that the recommendation engine can perform
type RecommendationRule struct {
	autorest.Response `json:"-"`
	// Name - Unique name of the rule
	Name *string `json:"name,omitempty"`
	// DisplayName - UI friendly name of the rule
	DisplayName *string `json:"displayName,omitempty"`
	// Message - Localized name of the rule (Good for UI)
	Message *string `json:"message,omitempty"`
	// RecommendationID - Recommendation ID of an associated recommendation object tied to the rule, if exists.
	//             If such an object doesn't exist, it is set to null.
	RecommendationID *string `json:"recommendationId,omitempty"`
	// Description - Localized detailed description of the rule
	Description *string `json:"description,omitempty"`
	// ActionName - Name of action that is recommended by this rule in string
	ActionName *string `json:"actionName,omitempty"`
	// Enabled - On/off flag indicating the rule is currently enabled or disabled.
	Enabled *int32 `json:"enabled,omitempty"`
	// Level - Level of impact indicating how critical this rule is. Possible values include: 'Critical', 'Warning', 'Information', 'NonUrgentSuggestion'
	Level NotificationLevel `json:"level,omitempty"`
	// Channels - List of available channels that this rule applies. Possible values include: 'Notification', 'API', 'Email', 'All'
	Channels Channels `json:"channels,omitempty"`
	// Tags - An array of category tags that the rule contains.
	Tags *[]string `json:"tags,omitempty"`
}

// ReissueCertificateOrderRequest class representing certificate reissue request
type ReissueCertificateOrderRequest struct {
	*ReissueCertificateOrderRequestProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ReissueCertificateOrderRequest.
func (rcor ReissueCertificateOrderRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcor.ReissueCertificateOrderRequestProperties != nil {
		objectMap["properties"] = rcor.ReissueCertificateOrderRequestProperties
	}
	if rcor.ID != nil {
		objectMap["id"] = rcor.ID
	}
	if rcor.Name != nil {
		objectMap["name"] = rcor.Name
	}
	if rcor.Kind != nil {
		objectMap["kind"] = rcor.Kind
	}
	if rcor.Location != nil {
		objectMap["location"] = rcor.Location
	}
	if rcor.Type != nil {
		objectMap["type"] = rcor.Type
	}
	if rcor.Tags != nil {
		objectMap["tags"] = rcor.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReissueCertificateOrderRequest struct.
func (rcor *ReissueCertificateOrderRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var reissueCertificateOrderRequestProperties ReissueCertificateOrderRequestProperties
				err = json.Unmarshal(*v, &reissueCertificateOrderRequestProperties)
				if err != nil {
					return err
				}
				rcor.ReissueCertificateOrderRequestProperties = &reissueCertificateOrderRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rcor.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rcor.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rcor.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rcor.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rcor.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rcor.Tags = tags
			}
		}
	}

	return nil
}

// ReissueCertificateOrderRequestProperties ...
type ReissueCertificateOrderRequestProperties struct {
	// KeySize - Certificate Key Size
	KeySize *int32 `json:"keySize,omitempty"`
	// DelayExistingRevokeInHours - Delay in hours to revoke existing certificate after the new certificate is issued
	DelayExistingRevokeInHours *int32 `json:"delayExistingRevokeInHours,omitempty"`
}

// RelayServiceConnectionEntity class that represents a BizTalk Hybrid Connection
type RelayServiceConnectionEntity struct {
	autorest.Response                       `json:"-"`
	*RelayServiceConnectionEntityProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RelayServiceConnectionEntity.
func (rsce RelayServiceConnectionEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rsce.RelayServiceConnectionEntityProperties != nil {
		objectMap["properties"] = rsce.RelayServiceConnectionEntityProperties
	}
	if rsce.ID != nil {
		objectMap["id"] = rsce.ID
	}
	if rsce.Name != nil {
		objectMap["name"] = rsce.Name
	}
	if rsce.Kind != nil {
		objectMap["kind"] = rsce.Kind
	}
	if rsce.Location != nil {
		objectMap["location"] = rsce.Location
	}
	if rsce.Type != nil {
		objectMap["type"] = rsce.Type
	}
	if rsce.Tags != nil {
		objectMap["tags"] = rsce.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RelayServiceConnectionEntity struct.
func (rsce *RelayServiceConnectionEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var relayServiceConnectionEntityProperties RelayServiceConnectionEntityProperties
				err = json.Unmarshal(*v, &relayServiceConnectionEntityProperties)
				if err != nil {
					return err
				}
				rsce.RelayServiceConnectionEntityProperties = &relayServiceConnectionEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rsce.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rsce.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rsce.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rsce.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rsce.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rsce.Tags = tags
			}
		}
	}

	return nil
}

// RelayServiceConnectionEntityProperties ...
type RelayServiceConnectionEntityProperties struct {
	EntityName               *string `json:"entityName,omitempty"`
	EntityConnectionString   *string `json:"entityConnectionString,omitempty"`
	ResourceType             *string `json:"resourceType,omitempty"`
	ResourceConnectionString *string `json:"resourceConnectionString,omitempty"`
	Hostname                 *string `json:"hostname,omitempty"`
	Port                     *int32  `json:"port,omitempty"`
	BiztalkURI               *string `json:"biztalkUri,omitempty"`
}

// RenewCertificateOrderRequest class representing certificate renew request
type RenewCertificateOrderRequest struct {
	*RenewCertificateOrderRequestProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RenewCertificateOrderRequest.
func (rcor RenewCertificateOrderRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcor.RenewCertificateOrderRequestProperties != nil {
		objectMap["properties"] = rcor.RenewCertificateOrderRequestProperties
	}
	if rcor.ID != nil {
		objectMap["id"] = rcor.ID
	}
	if rcor.Name != nil {
		objectMap["name"] = rcor.Name
	}
	if rcor.Kind != nil {
		objectMap["kind"] = rcor.Kind
	}
	if rcor.Location != nil {
		objectMap["location"] = rcor.Location
	}
	if rcor.Type != nil {
		objectMap["type"] = rcor.Type
	}
	if rcor.Tags != nil {
		objectMap["tags"] = rcor.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RenewCertificateOrderRequest struct.
func (rcor *RenewCertificateOrderRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var renewCertificateOrderRequestProperties RenewCertificateOrderRequestProperties
				err = json.Unmarshal(*v, &renewCertificateOrderRequestProperties)
				if err != nil {
					return err
				}
				rcor.RenewCertificateOrderRequestProperties = &renewCertificateOrderRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rcor.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rcor.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rcor.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rcor.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rcor.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rcor.Tags = tags
			}
		}
	}

	return nil
}

// RenewCertificateOrderRequestProperties ...
type RenewCertificateOrderRequestProperties struct {
	// KeySize - Certificate Key Size
	KeySize *int32 `json:"keySize,omitempty"`
}

// RequestsBasedTrigger requestsBasedTrigger
type RequestsBasedTrigger struct {
	// Count - Count
	Count *int32 `json:"count,omitempty"`
	// TimeInterval - TimeInterval
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// Resource ...
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Kind != nil {
		objectMap["kind"] = r.Kind
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceMetric object representing a metric for any resource
type ResourceMetric struct {
	// Name - Name of metric
	Name *ResourceMetricName `json:"name,omitempty"`
	// Unit - Metric unit
	Unit *string `json:"unit,omitempty"`
	// TimeGrain - Metric granularity. E.g PT1H, PT5M, P1D
	TimeGrain *string `json:"timeGrain,omitempty"`
	// StartTime - Metric start time
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Metric end time
	EndTime *date.Time `json:"endTime,omitempty"`
	// ResourceID - Metric resource Id
	ResourceID *string `json:"resourceId,omitempty"`
	// MetricValues - Metric values
	MetricValues *[]ResourceMetricValue `json:"metricValues,omitempty"`
	// Properties - Properties
	Properties *[]KeyValuePairStringString `json:"properties,omitempty"`
}

// ResourceMetricCollection collection of metric responses
type ResourceMetricCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]ResourceMetric `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceMetricCollectionIterator provides access to a complete listing of ResourceMetric values.
type ResourceMetricCollectionIterator struct {
	i    int
	page ResourceMetricCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceMetricCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceMetricCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceMetricCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceMetricCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceMetricCollectionIterator) Response() ResourceMetricCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceMetricCollectionIterator) Value() ResourceMetric {
	if !iter.page.NotDone() {
		return ResourceMetric{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceMetricCollectionIterator type.
func NewResourceMetricCollectionIterator(page ResourceMetricCollectionPage) ResourceMetricCollectionIterator {
	return ResourceMetricCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rmc ResourceMetricCollection) IsEmpty() bool {
	return rmc.Value == nil || len(*rmc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rmc ResourceMetricCollection) hasNextLink() bool {
	return rmc.NextLink != nil && len(*rmc.NextLink) != 0
}

// resourceMetricCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rmc ResourceMetricCollection) resourceMetricCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !rmc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rmc.NextLink)))
}

// ResourceMetricCollectionPage contains a page of ResourceMetric values.
type ResourceMetricCollectionPage struct {
	fn  func(context.Context, ResourceMetricCollection) (ResourceMetricCollection, error)
	rmc ResourceMetricCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceMetricCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceMetricCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rmc)
		if err != nil {
			return err
		}
		page.rmc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceMetricCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceMetricCollectionPage) NotDone() bool {
	return !page.rmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceMetricCollectionPage) Response() ResourceMetricCollection {
	return page.rmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceMetricCollectionPage) Values() []ResourceMetric {
	if page.rmc.IsEmpty() {
		return nil
	}
	return *page.rmc.Value
}

// Creates a new instance of the ResourceMetricCollectionPage type.
func NewResourceMetricCollectionPage(cur ResourceMetricCollection, getNextPage func(context.Context, ResourceMetricCollection) (ResourceMetricCollection, error)) ResourceMetricCollectionPage {
	return ResourceMetricCollectionPage{
		fn:  getNextPage,
		rmc: cur,
	}
}

// ResourceMetricName name of a metric for any resource
type ResourceMetricName struct {
	// Value - metric name value
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Localized metric name value
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// ResourceMetricValue value of resource metric
type ResourceMetricValue struct {
	// TimeStamp - Value timestamp
	TimeStamp *string `json:"timeStamp,omitempty"`
	// Average - Value average
	Average *float64 `json:"average,omitempty"`
	// Minimum - Value minimum
	Minimum *float64 `json:"minimum,omitempty"`
	// Maximum - Value maximum
	Maximum *float64 `json:"maximum,omitempty"`
	// Total - Value total
	Total *float64 `json:"total,omitempty"`
	// Count - Value count
	Count *float64 `json:"count,omitempty"`
}

// ResourceNameAvailability describes if a resource name is available
type ResourceNameAvailability struct {
	autorest.Response `json:"-"`
	// NameAvailable - True indicates name is valid and available.  False indicates the name is invalid, unavailable, or both.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - Required if nameAvailable is false. 'Invalid' indicates the name provided does not match Azure WebApp service’s naming requirements. 'AlreadyExists' indicates that the name is already in use and is therefore unavailable.
	Reason  *string `json:"reason,omitempty"`
	Message *string `json:"message,omitempty"`
}

// ResourceNameAvailabilityRequest resource name availability request content
type ResourceNameAvailabilityRequest struct {
	// Name - Resource name to verify
	Name *string `json:"name,omitempty"`
	// Type - Resource type used for verification
	Type *string `json:"type,omitempty"`
	// IsFqdn - Is fully qualified domain name
	IsFqdn *bool `json:"isFqdn,omitempty"`
}

// ResponseMessageEnvelopeAPIEntity message envelope that contains the common Azure resource manager
// properties and the resource provider specific content
type ResponseMessageEnvelopeAPIEntity struct {
	// ID - Resource Id. Typically id is populated only for responses to GET requests. Caller is responsible for passing in this
	//             value for GET requests only.
	//             For example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupId}/providers/Microsoft.Web/sites/{sitename}
	ID *string `json:"id,omitempty"`
	// Name - Name of resource
	Name *string `json:"name,omitempty"`
	// Type - Type of resource e.g Microsoft.Web/sites
	Type *string `json:"type,omitempty"`
	// Location - Geo region resource belongs to e.g. SouthCentralUS, SouthEastAsia
	Location *string `json:"location,omitempty"`
	// Tags - Tags associated with resource
	Tags map[string]*string `json:"tags"`
	// Plan - Azure resource manager plan
	Plan *ArmPlan `json:"plan,omitempty"`
	// Properties - Resource specific properties
	Properties *APIEntity `json:"properties,omitempty"`
	// Sku - Sku description of the resource
	Sku *SkuDescription `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for ResponseMessageEnvelopeAPIEntity.
func (rmeAe ResponseMessageEnvelopeAPIEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmeAe.ID != nil {
		objectMap["id"] = rmeAe.ID
	}
	if rmeAe.Name != nil {
		objectMap["name"] = rmeAe.Name
	}
	if rmeAe.Type != nil {
		objectMap["type"] = rmeAe.Type
	}
	if rmeAe.Location != nil {
		objectMap["location"] = rmeAe.Location
	}
	if rmeAe.Tags != nil {
		objectMap["tags"] = rmeAe.Tags
	}
	if rmeAe.Plan != nil {
		objectMap["plan"] = rmeAe.Plan
	}
	if rmeAe.Properties != nil {
		objectMap["properties"] = rmeAe.Properties
	}
	if rmeAe.Sku != nil {
		objectMap["sku"] = rmeAe.Sku
	}
	return json.Marshal(objectMap)
}

// RestoreRequest description of a restore request
type RestoreRequest struct {
	autorest.Response         `json:"-"`
	*RestoreRequestProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RestoreRequest.
func (rr RestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rr.RestoreRequestProperties != nil {
		objectMap["properties"] = rr.RestoreRequestProperties
	}
	if rr.ID != nil {
		objectMap["id"] = rr.ID
	}
	if rr.Name != nil {
		objectMap["name"] = rr.Name
	}
	if rr.Kind != nil {
		objectMap["kind"] = rr.Kind
	}
	if rr.Location != nil {
		objectMap["location"] = rr.Location
	}
	if rr.Type != nil {
		objectMap["type"] = rr.Type
	}
	if rr.Tags != nil {
		objectMap["tags"] = rr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestoreRequest struct.
func (rr *RestoreRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restoreRequestProperties RestoreRequestProperties
				err = json.Unmarshal(*v, &restoreRequestProperties)
				if err != nil {
					return err
				}
				rr.RestoreRequestProperties = &restoreRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rr.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rr.Tags = tags
			}
		}
	}

	return nil
}

// RestoreRequestProperties ...
type RestoreRequestProperties struct {
	// StorageAccountURL - SAS URL to the container
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`
	// BlobName - Name of a blob which contains the backup
	BlobName *string `json:"blobName,omitempty"`
	// Overwrite - True if the restore operation can overwrite target site. "True" needed if trying to restore over an existing site.
	Overwrite *bool `json:"overwrite,omitempty"`
	// SiteName - Name of a site (Web App)
	SiteName *string `json:"siteName,omitempty"`
	// Databases - Collection of databases which should be restored. This list has to match the list of databases included in the backup.
	Databases *[]DatabaseBackupSetting `json:"databases,omitempty"`
	// IgnoreConflictingHostNames - Changes a logic when restoring a site with custom domains. If "true", custom domains are removed automatically. If "false", custom domains are added to
	//             the site object when it is being restored, but that might fail due to conflicts during the operation.
	IgnoreConflictingHostNames *bool `json:"ignoreConflictingHostNames,omitempty"`
	// OperationType - Operation type. Possible values include: 'Default', 'Clone', 'Relocation'
	OperationType BackupRestoreOperationType `json:"operationType,omitempty"`
	// AdjustConnectionStrings - Gets or sets a flag showing if SiteConfig.ConnectionStrings should be set in new site
	AdjustConnectionStrings *bool `json:"adjustConnectionStrings,omitempty"`
	// HostingEnvironment - App Service Environment name, if needed (only when restoring a site to an App Service Environment)
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`
}

// RestoreResponse response for a restore site request
type RestoreResponse struct {
	autorest.Response          `json:"-"`
	*RestoreResponseProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RestoreResponse.
func (rr RestoreResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rr.RestoreResponseProperties != nil {
		objectMap["properties"] = rr.RestoreResponseProperties
	}
	if rr.ID != nil {
		objectMap["id"] = rr.ID
	}
	if rr.Name != nil {
		objectMap["name"] = rr.Name
	}
	if rr.Kind != nil {
		objectMap["kind"] = rr.Kind
	}
	if rr.Location != nil {
		objectMap["location"] = rr.Location
	}
	if rr.Type != nil {
		objectMap["type"] = rr.Type
	}
	if rr.Tags != nil {
		objectMap["tags"] = rr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestoreResponse struct.
func (rr *RestoreResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restoreResponseProperties RestoreResponseProperties
				err = json.Unmarshal(*v, &restoreResponseProperties)
				if err != nil {
					return err
				}
				rr.RestoreResponseProperties = &restoreResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rr.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rr.Tags = tags
			}
		}
	}

	return nil
}

// RestoreResponseProperties ...
type RestoreResponseProperties struct {
	// OperationID - When server starts the restore process, it will return an OperationId identifying that particular restore operation
	OperationID *string `json:"operationId,omitempty"`
}

// RoutingRule routing rules for TiP
type RoutingRule struct {
	// Name - Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
	Name *string `json:"name,omitempty"`
}

// ServerFarmCollection collection of serverfarms
type ServerFarmCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]ServerFarmWithRichSku `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerFarmCollectionIterator provides access to a complete listing of ServerFarmWithRichSku values.
type ServerFarmCollectionIterator struct {
	i    int
	page ServerFarmCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerFarmCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerFarmCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerFarmCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerFarmCollectionIterator) Response() ServerFarmCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerFarmCollectionIterator) Value() ServerFarmWithRichSku {
	if !iter.page.NotDone() {
		return ServerFarmWithRichSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerFarmCollectionIterator type.
func NewServerFarmCollectionIterator(page ServerFarmCollectionPage) ServerFarmCollectionIterator {
	return ServerFarmCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sfc ServerFarmCollection) IsEmpty() bool {
	return sfc.Value == nil || len(*sfc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sfc ServerFarmCollection) hasNextLink() bool {
	return sfc.NextLink != nil && len(*sfc.NextLink) != 0
}

// serverFarmCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sfc ServerFarmCollection) serverFarmCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !sfc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sfc.NextLink)))
}

// ServerFarmCollectionPage contains a page of ServerFarmWithRichSku values.
type ServerFarmCollectionPage struct {
	fn  func(context.Context, ServerFarmCollection) (ServerFarmCollection, error)
	sfc ServerFarmCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerFarmCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sfc)
		if err != nil {
			return err
		}
		page.sfc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerFarmCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerFarmCollectionPage) NotDone() bool {
	return !page.sfc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerFarmCollectionPage) Response() ServerFarmCollection {
	return page.sfc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerFarmCollectionPage) Values() []ServerFarmWithRichSku {
	if page.sfc.IsEmpty() {
		return nil
	}
	return *page.sfc.Value
}

// Creates a new instance of the ServerFarmCollectionPage type.
func NewServerFarmCollectionPage(cur ServerFarmCollection, getNextPage func(context.Context, ServerFarmCollection) (ServerFarmCollection, error)) ServerFarmCollectionPage {
	return ServerFarmCollectionPage{
		fn:  getNextPage,
		sfc: cur,
	}
}

// ServerFarmsCreateOrUpdateServerFarmFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServerFarmsCreateOrUpdateServerFarmFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerFarmsClient) (ServerFarmWithRichSku, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServerFarmsCreateOrUpdateServerFarmFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServerFarmsCreateOrUpdateServerFarmFuture.Result.
func (future *ServerFarmsCreateOrUpdateServerFarmFuture) result(client ServerFarmsClient) (sfwrs ServerFarmWithRichSku, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsCreateOrUpdateServerFarmFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sfwrs.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.ServerFarmsCreateOrUpdateServerFarmFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sfwrs.Response.Response, err = future.GetResult(sender); err == nil && sfwrs.Response.Response.StatusCode != http.StatusNoContent {
		sfwrs, err = client.CreateOrUpdateServerFarmResponder(sfwrs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.ServerFarmsCreateOrUpdateServerFarmFuture", "Result", sfwrs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerFarmWithRichSku app Service Plan Model
type ServerFarmWithRichSku struct {
	autorest.Response                `json:"-"`
	*ServerFarmWithRichSkuProperties `json:"properties,omitempty"`
	Sku                              *SkuDescription `json:"sku,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServerFarmWithRichSku.
func (sfwrs ServerFarmWithRichSku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sfwrs.ServerFarmWithRichSkuProperties != nil {
		objectMap["properties"] = sfwrs.ServerFarmWithRichSkuProperties
	}
	if sfwrs.Sku != nil {
		objectMap["sku"] = sfwrs.Sku
	}
	if sfwrs.ID != nil {
		objectMap["id"] = sfwrs.ID
	}
	if sfwrs.Name != nil {
		objectMap["name"] = sfwrs.Name
	}
	if sfwrs.Kind != nil {
		objectMap["kind"] = sfwrs.Kind
	}
	if sfwrs.Location != nil {
		objectMap["location"] = sfwrs.Location
	}
	if sfwrs.Type != nil {
		objectMap["type"] = sfwrs.Type
	}
	if sfwrs.Tags != nil {
		objectMap["tags"] = sfwrs.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerFarmWithRichSku struct.
func (sfwrs *ServerFarmWithRichSku) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverFarmWithRichSkuProperties ServerFarmWithRichSkuProperties
				err = json.Unmarshal(*v, &serverFarmWithRichSkuProperties)
				if err != nil {
					return err
				}
				sfwrs.ServerFarmWithRichSkuProperties = &serverFarmWithRichSkuProperties
			}
		case "sku":
			if v != nil {
				var sku SkuDescription
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sfwrs.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sfwrs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sfwrs.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sfwrs.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sfwrs.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sfwrs.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sfwrs.Tags = tags
			}
		}
	}

	return nil
}

// ServerFarmWithRichSkuProperties ...
type ServerFarmWithRichSkuProperties struct {
	// Name - Name for the App Service Plan
	Name *string `json:"name,omitempty"`
	// WorkerTierName - Target worker tier assigned to the App Service Plan
	WorkerTierName *string `json:"workerTierName,omitempty"`
	// Status - READ-ONLY; App Service Plan Status. Possible values include: 'StatusOptionsReady', 'StatusOptionsPending'
	Status StatusOptions `json:"status,omitempty"`
	// Subscription - READ-ONLY; App Service Plan Subscription
	Subscription *string `json:"subscription,omitempty"`
	// AdminSiteName - App Service Plan administration site
	AdminSiteName *string `json:"adminSiteName,omitempty"`
	// HostingEnvironmentProfile - Specification for the hosting environment (App Service Environment) to use for the App Service Plan
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	// MaximumNumberOfWorkers - Maximum number of instances that can be assigned to this App Service Plan
	MaximumNumberOfWorkers *int32 `json:"maximumNumberOfWorkers,omitempty"`
	// GeoRegion - READ-ONLY; Geographical location for the App Service Plan
	GeoRegion *string `json:"geoRegion,omitempty"`
	// PerSiteScaling - If True apps assigned to this App Service Plan can be scaled independently
	//             If False apps assigned to this App Service Plan will scale to all instances of the plan
	PerSiteScaling *bool `json:"perSiteScaling,omitempty"`
	// NumberOfSites - READ-ONLY; Number of web apps assigned to this App Service Plan
	NumberOfSites *int32 `json:"numberOfSites,omitempty"`
	// ResourceGroup - READ-ONLY; Resource group of the server farm
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// Reserved - Enables creation of a Linux App Service Plan
	Reserved *bool `json:"reserved,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerFarmWithRichSkuProperties.
func (sfwrs ServerFarmWithRichSkuProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sfwrs.Name != nil {
		objectMap["name"] = sfwrs.Name
	}
	if sfwrs.WorkerTierName != nil {
		objectMap["workerTierName"] = sfwrs.WorkerTierName
	}
	if sfwrs.AdminSiteName != nil {
		objectMap["adminSiteName"] = sfwrs.AdminSiteName
	}
	if sfwrs.HostingEnvironmentProfile != nil {
		objectMap["hostingEnvironmentProfile"] = sfwrs.HostingEnvironmentProfile
	}
	if sfwrs.MaximumNumberOfWorkers != nil {
		objectMap["maximumNumberOfWorkers"] = sfwrs.MaximumNumberOfWorkers
	}
	if sfwrs.PerSiteScaling != nil {
		objectMap["perSiteScaling"] = sfwrs.PerSiteScaling
	}
	if sfwrs.Reserved != nil {
		objectMap["reserved"] = sfwrs.Reserved
	}
	return json.Marshal(objectMap)
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// Site represents a web app
type Site struct {
	autorest.Response `json:"-"`
	*SiteProperties   `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Site.
func (s Site) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SiteProperties != nil {
		objectMap["properties"] = s.SiteProperties
	}
	if s.ID != nil {
		objectMap["id"] = s.ID
	}
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.Kind != nil {
		objectMap["kind"] = s.Kind
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Type != nil {
		objectMap["type"] = s.Type
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Site struct.
func (s *Site) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteProperties SiteProperties
				err = json.Unmarshal(*v, &siteProperties)
				if err != nil {
					return err
				}
				s.SiteProperties = &siteProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				s.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		}
	}

	return nil
}

// SiteAuthSettings configuration settings for the Azure App Service Authentication / Authorization
// feature.
type SiteAuthSettings struct {
	autorest.Response `json:"-"`
	// Enabled - Gets or sets a value indicating whether the Authentication / Authorization feature is enabled for the current app.
	Enabled *bool `json:"enabled,omitempty"`
	// HTTPAPIPrefixPath - Gets or sets the relative path prefix used by platform HTTP APIs.
	//             Changing this value is not recommended except for compatibility reasons.
	HTTPAPIPrefixPath *string `json:"httpApiPrefixPath,omitempty"`
	// UnauthenticatedClientAction - Gets or sets the action to take when an unauthenticated client attempts to access the app. Possible values include: 'RedirectToLoginPage', 'AllowAnonymous'
	UnauthenticatedClientAction UnauthenticatedClientAction `json:"unauthenticatedClientAction,omitempty"`
	// TokenStoreEnabled - Gets or sets a value indicating whether to durably store platform-specific security tokens
	//             obtained during login flows. This capability is disabled by default.
	TokenStoreEnabled *bool `json:"tokenStoreEnabled,omitempty"`
	// AllowedExternalRedirectUrls - Gets or sets a collection of external URLs that can be redirected to as part of logging in
	//             or logging out of the web app. Note that the query string part of the URL is ignored.
	//             This is an advanced setting typically only needed by Windows Store application backends.
	//             Note that URLs within the current domain are always implicitly allowed.
	AllowedExternalRedirectUrls *[]string `json:"allowedExternalRedirectUrls,omitempty"`
	// DefaultProvider - Gets or sets the default authentication provider to use when multiple providers are configured.
	//             This setting is only needed if multiple providers are configured and the unauthenticated client
	//             action is set to "RedirectToLoginPage". Possible values include: 'AzureActiveDirectory', 'Facebook', 'Google', 'MicrosoftAccount', 'Twitter'
	DefaultProvider BuiltInAuthenticationProvider `json:"defaultProvider,omitempty"`
	// TokenRefreshExtensionHours - Gets or sets the number of hours after session token expiration that a session token can be used to
	//             call the token refresh API. The default is 72 hours.
	TokenRefreshExtensionHours *float64 `json:"tokenRefreshExtensionHours,omitempty"`
	// ClientID - Gets or sets the Client ID of this relying party application, known as the client_id.
	//             This setting is required for enabling OpenID Connection authentication with Azure Active Directory or
	//             other 3rd party OpenID Connect providers.
	//             More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Gets or sets the Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key).
	//             This setting is optional. If no client secret is configured, the OpenID Connect implicit auth flow is used to authenticate end users.
	//             Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
	//             More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
	ClientSecret *string `json:"clientSecret,omitempty"`
	// Issuer - Gets or sets the OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
	//             When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://sts.windows.net/{tenant-guid}/.
	//             This URI is a case-sensitive identifier for the token issuer.
	//             More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
	Issuer *string `json:"issuer,omitempty"`
	// AllowedAudiences - Gets or sets a list of allowed audience values to consider when validating JWTs issued by
	//             Azure Active Directory. Note that the {Microsoft.Web.Hosting.Administration.SiteAuthSettings.ClientId} value is always considered an
	//             allowed audience, regardless of this setting.
	AllowedAudiences *[]string `json:"allowedAudiences,omitempty"`
	// AdditionalLoginParams - Gets or sets a list of login parameters to send to the OpenID Connect authorization endpoint when
	//             a user logs in. Each parameter must be in the form "key=value".
	AdditionalLoginParams *[]string `json:"additionalLoginParams,omitempty"`
	AadClientID           *string   `json:"aadClientId,omitempty"`
	OpenIDIssuer          *string   `json:"openIdIssuer,omitempty"`
	// GoogleClientID - Gets or sets the OpenID Connect Client ID for the Google web application.
	//             This setting is required for enabling Google Sign-In.
	//             Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleClientID *string `json:"googleClientId,omitempty"`
	// GoogleClientSecret - Gets or sets the client secret associated with the Google web application.
	//             This setting is required for enabling Google Sign-In.
	//             Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleClientSecret *string `json:"googleClientSecret,omitempty"`
	// GoogleOAuthScopes - Gets or sets the OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.
	//             This setting is optional. If not specified, "openid", "profile", and "email" are used as default scopes.
	//             Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleOAuthScopes *[]string `json:"googleOAuthScopes,omitempty"`
	// FacebookAppID - Gets or sets the App ID of the Facebook app used for login.
	//             This setting is required for enabling Facebook Login.
	//             Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
	FacebookAppID *string `json:"facebookAppId,omitempty"`
	// FacebookAppSecret - Gets or sets the App Secret of the Facebook app used for Facebook Login.
	//             This setting is required for enabling Facebook Login.
	//             Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
	FacebookAppSecret *string `json:"facebookAppSecret,omitempty"`
	// FacebookOAuthScopes - Gets or sets the OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.
	//             This setting is optional.
	//             Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
	FacebookOAuthScopes *[]string `json:"facebookOAuthScopes,omitempty"`
	// TwitterConsumerKey - Gets or sets the OAuth 1.0a consumer key of the Twitter application used for sign-in.
	//             This setting is required for enabling Twitter Sign-In.
	//             Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	TwitterConsumerKey *string `json:"twitterConsumerKey,omitempty"`
	// TwitterConsumerSecret - Gets or sets the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
	//             This setting is required for enabling Twitter Sign-In.
	//             Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	TwitterConsumerSecret *string `json:"twitterConsumerSecret,omitempty"`
	// MicrosoftAccountClientID - Gets or sets the OAuth 2.0 client ID that was created for the app used for authentication.
	//             This setting is required for enabling Microsoft Account authentication.
	//             Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
	MicrosoftAccountClientID *string `json:"microsoftAccountClientId,omitempty"`
	// MicrosoftAccountClientSecret - Gets or sets the OAuth 2.0 client secret that was created for the app used for authentication.
	//             This setting is required for enabling Microsoft Account authentication.
	//             Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
	MicrosoftAccountClientSecret *string `json:"microsoftAccountClientSecret,omitempty"`
	// MicrosoftAccountOAuthScopes - Gets or sets the OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.
	//             This setting is optional. If not specified, "wl.basic" is used as the default scope.
	//             Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
	MicrosoftAccountOAuthScopes *[]string `json:"microsoftAccountOAuthScopes,omitempty"`
}

// SiteCloneability represents whether or not a web app is cloneable
type SiteCloneability struct {
	autorest.Response `json:"-"`
	// Result - Name of web app. Possible values include: 'Cloneable', 'PartiallyCloneable', 'NotCloneable'
	Result CloneAbilityResult `json:"result,omitempty"`
	// BlockingFeatures - List of features enabled on web app that prevent cloning
	BlockingFeatures *[]SiteCloneabilityCriterion `json:"blockingFeatures,omitempty"`
	// UnsupportedFeatures - List of features enabled on web app that are non-blocking but cannot be cloned. The web app can still be cloned
	//             but the features in this list will not be set up on cloned web app.
	UnsupportedFeatures *[]SiteCloneabilityCriterion `json:"unsupportedFeatures,omitempty"`
	// BlockingCharacteristics - List of blocking application characteristics
	BlockingCharacteristics *[]SiteCloneabilityCriterion `json:"blockingCharacteristics,omitempty"`
}

// SiteCloneabilityCriterion represents a site cloneability criterion
type SiteCloneabilityCriterion struct {
	// Name - Name of criterion
	Name *string `json:"name,omitempty"`
	// Description - Description of criterion
	Description *string `json:"description,omitempty"`
}

// SiteCollection collection of sites
type SiteCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]Site `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// SiteCollectionIterator provides access to a complete listing of Site values.
type SiteCollectionIterator struct {
	i    int
	page SiteCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SiteCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SiteCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SiteCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SiteCollectionIterator) Response() SiteCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SiteCollectionIterator) Value() Site {
	if !iter.page.NotDone() {
		return Site{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SiteCollectionIterator type.
func NewSiteCollectionIterator(page SiteCollectionPage) SiteCollectionIterator {
	return SiteCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sc SiteCollection) IsEmpty() bool {
	return sc.Value == nil || len(*sc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sc SiteCollection) hasNextLink() bool {
	return sc.NextLink != nil && len(*sc.NextLink) != 0
}

// siteCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sc SiteCollection) siteCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !sc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sc.NextLink)))
}

// SiteCollectionPage contains a page of Site values.
type SiteCollectionPage struct {
	fn func(context.Context, SiteCollection) (SiteCollection, error)
	sc SiteCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SiteCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sc)
		if err != nil {
			return err
		}
		page.sc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SiteCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SiteCollectionPage) NotDone() bool {
	return !page.sc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SiteCollectionPage) Response() SiteCollection {
	return page.sc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SiteCollectionPage) Values() []Site {
	if page.sc.IsEmpty() {
		return nil
	}
	return *page.sc.Value
}

// Creates a new instance of the SiteCollectionPage type.
func NewSiteCollectionPage(cur SiteCollection, getNextPage func(context.Context, SiteCollection) (SiteCollection, error)) SiteCollectionPage {
	return SiteCollectionPage{
		fn: getNextPage,
		sc: cur,
	}
}

// SiteConfig configuration of Azure web site
type SiteConfig struct {
	autorest.Response     `json:"-"`
	*SiteConfigProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SiteConfig.
func (sc SiteConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sc.SiteConfigProperties != nil {
		objectMap["properties"] = sc.SiteConfigProperties
	}
	if sc.ID != nil {
		objectMap["id"] = sc.ID
	}
	if sc.Name != nil {
		objectMap["name"] = sc.Name
	}
	if sc.Kind != nil {
		objectMap["kind"] = sc.Kind
	}
	if sc.Location != nil {
		objectMap["location"] = sc.Location
	}
	if sc.Type != nil {
		objectMap["type"] = sc.Type
	}
	if sc.Tags != nil {
		objectMap["tags"] = sc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteConfig struct.
func (sc *SiteConfig) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteConfigProperties SiteConfigProperties
				err = json.Unmarshal(*v, &siteConfigProperties)
				if err != nil {
					return err
				}
				sc.SiteConfigProperties = &siteConfigProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sc.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sc.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sc.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sc.Tags = tags
			}
		}
	}

	return nil
}

// SiteConfigProperties ...
type SiteConfigProperties struct {
	// NumberOfWorkers - Number of workers
	NumberOfWorkers *int32 `json:"numberOfWorkers,omitempty"`
	// DefaultDocuments - Default documents
	DefaultDocuments *[]string `json:"defaultDocuments,omitempty"`
	// NetFrameworkVersion - Net Framework Version
	NetFrameworkVersion *string `json:"netFrameworkVersion,omitempty"`
	// PhpVersion - Version of PHP
	PhpVersion *string `json:"phpVersion,omitempty"`
	// PythonVersion - Version of Python
	PythonVersion *string `json:"pythonVersion,omitempty"`
	// NodeVersion - Version of Node
	NodeVersion *string `json:"nodeVersion,omitempty"`
	// RequestTracingEnabled - Enable request tracing
	RequestTracingEnabled *bool `json:"requestTracingEnabled,omitempty"`
	// RequestTracingExpirationTime - Request tracing expiration time
	RequestTracingExpirationTime *date.Time `json:"requestTracingExpirationTime,omitempty"`
	// RemoteDebuggingEnabled - Remote Debugging Enabled
	RemoteDebuggingEnabled *bool `json:"remoteDebuggingEnabled,omitempty"`
	// RemoteDebuggingVersion - Remote Debugging Version
	RemoteDebuggingVersion *string `json:"remoteDebuggingVersion,omitempty"`
	// HTTPLoggingEnabled - HTTP logging Enabled
	HTTPLoggingEnabled *bool `json:"httpLoggingEnabled,omitempty"`
	// LogsDirectorySizeLimit - HTTP Logs Directory size limit
	LogsDirectorySizeLimit *int32 `json:"logsDirectorySizeLimit,omitempty"`
	// DetailedErrorLoggingEnabled - Detailed error logging enabled
	DetailedErrorLoggingEnabled *bool `json:"detailedErrorLoggingEnabled,omitempty"`
	// PublishingUsername - Publishing user name
	PublishingUsername *string `json:"publishingUsername,omitempty"`
	// PublishingPassword - Publishing password
	PublishingPassword *string `json:"publishingPassword,omitempty"`
	// AppSettings - Application Settings
	AppSettings *[]NameValuePair `json:"appSettings,omitempty"`
	// Metadata - Site Metadata
	Metadata *[]NameValuePair `json:"metadata,omitempty"`
	// ConnectionStrings - Connection strings
	ConnectionStrings *[]ConnStringInfo `json:"connectionStrings,omitempty"`
	// HandlerMappings - Handler mappings
	HandlerMappings *[]HandlerMapping `json:"handlerMappings,omitempty"`
	// DocumentRoot - Document root
	DocumentRoot *string `json:"documentRoot,omitempty"`
	// ScmType - SCM type
	ScmType *string `json:"scmType,omitempty"`
	// Use32BitWorkerProcess - Use 32 bit worker process
	Use32BitWorkerProcess *bool `json:"use32BitWorkerProcess,omitempty"`
	// WebSocketsEnabled - Web socket enabled.
	WebSocketsEnabled *bool `json:"webSocketsEnabled,omitempty"`
	// AlwaysOn - Always On
	AlwaysOn *bool `json:"alwaysOn,omitempty"`
	// JavaVersion - Java version
	JavaVersion *string `json:"javaVersion,omitempty"`
	// JavaContainer - Java container
	JavaContainer *string `json:"javaContainer,omitempty"`
	// JavaContainerVersion - Java container version
	JavaContainerVersion *string `json:"javaContainerVersion,omitempty"`
	// AppCommandLine - App Command Line to launch
	AppCommandLine *string `json:"appCommandLine,omitempty"`
	// ManagedPipelineMode - Managed pipeline mode. Possible values include: 'Integrated', 'Classic'
	ManagedPipelineMode ManagedPipelineMode `json:"managedPipelineMode,omitempty"`
	// VirtualApplications - Virtual applications
	VirtualApplications *[]VirtualApplication `json:"virtualApplications,omitempty"`
	// LoadBalancing - Site load balancing. Possible values include: 'WeightedRoundRobin', 'LeastRequests', 'LeastResponseTime', 'WeightedTotalTraffic', 'RequestHash'
	LoadBalancing SiteLoadBalancing `json:"loadBalancing,omitempty"`
	// Experiments - This is work around for polymorphic types
	Experiments *Experiments `json:"experiments,omitempty"`
	// Limits - Site limits
	Limits *SiteLimits `json:"limits,omitempty"`
	// AutoHealEnabled - Auto heal enabled
	AutoHealEnabled *bool `json:"autoHealEnabled,omitempty"`
	// AutoHealRules - Auto heal rules
	AutoHealRules *AutoHealRules `json:"autoHealRules,omitempty"`
	// TracingOptions - Tracing options
	TracingOptions *string `json:"tracingOptions,omitempty"`
	// VnetName - Vnet name
	VnetName *string `json:"vnetName,omitempty"`
	// Cors - Cross-Origin Resource Sharing (CORS) settings.
	Cors *CorsSettings `json:"cors,omitempty"`
	// APIDefinition - Information about the formal API definition for the web app.
	APIDefinition *APIDefinitionInfo `json:"apiDefinition,omitempty"`
	// AutoSwapSlotName - Auto swap slot name
	AutoSwapSlotName *string `json:"autoSwapSlotName,omitempty"`
	// LocalMySQLEnabled - Local mysql enabled
	LocalMySQLEnabled *bool `json:"localMySqlEnabled,omitempty"`
	// IPSecurityRestrictions - Ip Security restrictions
	IPSecurityRestrictions *[]IPSecurityRestriction `json:"ipSecurityRestrictions,omitempty"`
}

// SiteInstance instance of a web app
type SiteInstance struct {
	*SiteInstanceProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SiteInstance.
func (si SiteInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if si.SiteInstanceProperties != nil {
		objectMap["properties"] = si.SiteInstanceProperties
	}
	if si.ID != nil {
		objectMap["id"] = si.ID
	}
	if si.Name != nil {
		objectMap["name"] = si.Name
	}
	if si.Kind != nil {
		objectMap["kind"] = si.Kind
	}
	if si.Location != nil {
		objectMap["location"] = si.Location
	}
	if si.Type != nil {
		objectMap["type"] = si.Type
	}
	if si.Tags != nil {
		objectMap["tags"] = si.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteInstance struct.
func (si *SiteInstance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteInstanceProperties SiteInstanceProperties
				err = json.Unmarshal(*v, &siteInstanceProperties)
				if err != nil {
					return err
				}
				si.SiteInstanceProperties = &siteInstanceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				si.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				si.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				si.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				si.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				si.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				si.Tags = tags
			}
		}
	}

	return nil
}

// SiteInstanceCollection collection of site instances
type SiteInstanceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]SiteInstance `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// SiteInstanceCollectionIterator provides access to a complete listing of SiteInstance values.
type SiteInstanceCollectionIterator struct {
	i    int
	page SiteInstanceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SiteInstanceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteInstanceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SiteInstanceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SiteInstanceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SiteInstanceCollectionIterator) Response() SiteInstanceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SiteInstanceCollectionIterator) Value() SiteInstance {
	if !iter.page.NotDone() {
		return SiteInstance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SiteInstanceCollectionIterator type.
func NewSiteInstanceCollectionIterator(page SiteInstanceCollectionPage) SiteInstanceCollectionIterator {
	return SiteInstanceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sic SiteInstanceCollection) IsEmpty() bool {
	return sic.Value == nil || len(*sic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sic SiteInstanceCollection) hasNextLink() bool {
	return sic.NextLink != nil && len(*sic.NextLink) != 0
}

// siteInstanceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sic SiteInstanceCollection) siteInstanceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !sic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sic.NextLink)))
}

// SiteInstanceCollectionPage contains a page of SiteInstance values.
type SiteInstanceCollectionPage struct {
	fn  func(context.Context, SiteInstanceCollection) (SiteInstanceCollection, error)
	sic SiteInstanceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SiteInstanceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteInstanceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sic)
		if err != nil {
			return err
		}
		page.sic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SiteInstanceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SiteInstanceCollectionPage) NotDone() bool {
	return !page.sic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SiteInstanceCollectionPage) Response() SiteInstanceCollection {
	return page.sic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SiteInstanceCollectionPage) Values() []SiteInstance {
	if page.sic.IsEmpty() {
		return nil
	}
	return *page.sic.Value
}

// Creates a new instance of the SiteInstanceCollectionPage type.
func NewSiteInstanceCollectionPage(cur SiteInstanceCollection, getNextPage func(context.Context, SiteInstanceCollection) (SiteInstanceCollection, error)) SiteInstanceCollectionPage {
	return SiteInstanceCollectionPage{
		fn:  getNextPage,
		sic: cur,
	}
}

// SiteInstanceProperties ...
type SiteInstanceProperties struct {
	// Name - Name of instance
	Name *string `json:"name,omitempty"`
}

// SiteLimits represents metric limits set on a web app.
type SiteLimits struct {
	// MaxPercentageCPU - Maximum allowed CPU usage percentage
	MaxPercentageCPU *float64 `json:"maxPercentageCpu,omitempty"`
	// MaxMemoryInMb - Maximum allowed memory usage in MB
	MaxMemoryInMb *int64 `json:"maxMemoryInMb,omitempty"`
	// MaxDiskSizeInMb - Maximum allowed disk size usage in MB
	MaxDiskSizeInMb *int64 `json:"maxDiskSizeInMb,omitempty"`
}

// SiteLogsConfig configuration of Azure web site
type SiteLogsConfig struct {
	autorest.Response         `json:"-"`
	*SiteLogsConfigProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SiteLogsConfig.
func (slc SiteLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if slc.SiteLogsConfigProperties != nil {
		objectMap["properties"] = slc.SiteLogsConfigProperties
	}
	if slc.ID != nil {
		objectMap["id"] = slc.ID
	}
	if slc.Name != nil {
		objectMap["name"] = slc.Name
	}
	if slc.Kind != nil {
		objectMap["kind"] = slc.Kind
	}
	if slc.Location != nil {
		objectMap["location"] = slc.Location
	}
	if slc.Type != nil {
		objectMap["type"] = slc.Type
	}
	if slc.Tags != nil {
		objectMap["tags"] = slc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteLogsConfig struct.
func (slc *SiteLogsConfig) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteLogsConfigProperties SiteLogsConfigProperties
				err = json.Unmarshal(*v, &siteLogsConfigProperties)
				if err != nil {
					return err
				}
				slc.SiteLogsConfigProperties = &siteLogsConfigProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				slc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				slc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				slc.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				slc.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				slc.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				slc.Tags = tags
			}
		}
	}

	return nil
}

// SiteLogsConfigProperties ...
type SiteLogsConfigProperties struct {
	// ApplicationLogs - Application logs configuration
	ApplicationLogs *ApplicationLogsConfig `json:"applicationLogs,omitempty"`
	// HTTPLogs - Http logs configuration
	HTTPLogs *HTTPLogsConfig `json:"httpLogs,omitempty"`
	// FailedRequestsTracing - Failed requests tracing configuration
	FailedRequestsTracing *EnabledConfig `json:"failedRequestsTracing,omitempty"`
	// DetailedErrorMessages - Detailed error messages configuration
	DetailedErrorMessages *EnabledConfig `json:"detailedErrorMessages,omitempty"`
}

// SiteProperties ...
type SiteProperties struct {
	// Name - Name of web app
	Name *string `json:"name,omitempty"`
	// State - READ-ONLY; State of the web app
	State *string `json:"state,omitempty"`
	// HostNames - READ-ONLY; Hostnames associated with web app
	HostNames *[]string `json:"hostNames,omitempty"`
	// RepositorySiteName - READ-ONLY; Name of repository site
	RepositorySiteName *string `json:"repositorySiteName,omitempty"`
	// UsageState - READ-ONLY; State indicating whether web app has exceeded its quota usage. Possible values include: 'UsageStateNormal', 'UsageStateExceeded'
	UsageState UsageState `json:"usageState,omitempty"`
	// Enabled - True if the site is enabled; otherwise, false. Setting this  value to false disables the site (takes the site off line).
	Enabled *bool `json:"enabled,omitempty"`
	// EnabledHostNames - READ-ONLY; Hostnames for the web app that are enabled. Hostnames need to be assigned and enabled. If some hostnames are assigned but not enabled
	//             the app is not served on those hostnames
	EnabledHostNames *[]string `json:"enabledHostNames,omitempty"`
	// AvailabilityState - READ-ONLY; Management information availability state for the web app. Possible values are Normal or Limited.
	//             Normal means that the site is running correctly and that management information for the site is available.
	//             Limited means that only partial management information for the site is available and that detailed site information is unavailable. Possible values include: 'Normal', 'Limited', 'DisasterRecoveryMode'
	AvailabilityState SiteAvailabilityState `json:"availabilityState,omitempty"`
	// HostNameSslStates - Hostname SSL states are  used to manage the SSL bindings for site's hostnames.
	HostNameSslStates *[]HostNameSslState `json:"hostNameSslStates,omitempty"`
	ServerFarmID      *string             `json:"serverFarmId,omitempty"`
	// LastModifiedTimeUtc - READ-ONLY; Last time web app was modified in UTC
	LastModifiedTimeUtc *date.Time `json:"lastModifiedTimeUtc,omitempty"`
	// SiteConfig - Configuration of web app
	SiteConfig *SiteConfig `json:"siteConfig,omitempty"`
	// TrafficManagerHostNames - READ-ONLY; Read-only list of Azure Traffic manager hostnames associated with web app
	TrafficManagerHostNames *[]string `json:"trafficManagerHostNames,omitempty"`
	// PremiumAppDeployed - READ-ONLY; If set indicates whether web app is deployed as a premium app
	PremiumAppDeployed *bool `json:"premiumAppDeployed,omitempty"`
	// ScmSiteAlsoStopped - If set indicates whether to stop SCM (KUDU) site when the web app is stopped. Default is false.
	ScmSiteAlsoStopped *bool `json:"scmSiteAlsoStopped,omitempty"`
	// TargetSwapSlot - READ-ONLY; Read-only property that specifies which slot this app will swap into
	TargetSwapSlot *string `json:"targetSwapSlot,omitempty"`
	// HostingEnvironmentProfile - Specification for the hosting environment (App Service Environment) to use for the web app
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	MicroService              *string                    `json:"microService,omitempty"`
	// GatewaySiteName - Name of gateway app associated with web app
	GatewaySiteName *string `json:"gatewaySiteName,omitempty"`
	// ClientAffinityEnabled - Specifies if the client affinity is enabled when load balancing http request for multiple instances of the web app
	ClientAffinityEnabled *bool `json:"clientAffinityEnabled,omitempty"`
	// ClientCertEnabled - Specifies if the client certificate is enabled for the web app
	ClientCertEnabled *bool `json:"clientCertEnabled,omitempty"`
	// HostNamesDisabled - Specifies if the public hostnames are disabled the web app.
	//             If set to true the app is only accessible via API Management process
	HostNamesDisabled *bool `json:"hostNamesDisabled,omitempty"`
	// OutboundIPAddresses - READ-ONLY; List of comma separated IP addresses that this web app uses for outbound connections. Those can be used when configuring firewall rules for databases accessed by this web app.
	OutboundIPAddresses *string `json:"outboundIpAddresses,omitempty"`
	// ContainerSize - Size of a function container
	ContainerSize *int32 `json:"containerSize,omitempty"`
	// MaxNumberOfWorkers - Maximum number of workers
	//             This only applies to function container
	MaxNumberOfWorkers *int32 `json:"maxNumberOfWorkers,omitempty"`
	// CloningInfo - This is only valid for web app creation. If specified, web app is cloned from
	//             a source web app
	CloningInfo *CloningInfo `json:"cloningInfo,omitempty"`
	// ResourceGroup - READ-ONLY; Resource group web app belongs to
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// IsDefaultContainer - READ-ONLY; Site is a default container
	IsDefaultContainer *bool `json:"isDefaultContainer,omitempty"`
	// DefaultHostName - READ-ONLY; Default hostname of the web app
	DefaultHostName *string `json:"defaultHostName,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteProperties.
func (s SiteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.Enabled != nil {
		objectMap["enabled"] = s.Enabled
	}
	if s.HostNameSslStates != nil {
		objectMap["hostNameSslStates"] = s.HostNameSslStates
	}
	if s.ServerFarmID != nil {
		objectMap["serverFarmId"] = s.ServerFarmID
	}
	if s.SiteConfig != nil {
		objectMap["siteConfig"] = s.SiteConfig
	}
	if s.ScmSiteAlsoStopped != nil {
		objectMap["scmSiteAlsoStopped"] = s.ScmSiteAlsoStopped
	}
	if s.HostingEnvironmentProfile != nil {
		objectMap["hostingEnvironmentProfile"] = s.HostingEnvironmentProfile
	}
	if s.MicroService != nil {
		objectMap["microService"] = s.MicroService
	}
	if s.GatewaySiteName != nil {
		objectMap["gatewaySiteName"] = s.GatewaySiteName
	}
	if s.ClientAffinityEnabled != nil {
		objectMap["clientAffinityEnabled"] = s.ClientAffinityEnabled
	}
	if s.ClientCertEnabled != nil {
		objectMap["clientCertEnabled"] = s.ClientCertEnabled
	}
	if s.HostNamesDisabled != nil {
		objectMap["hostNamesDisabled"] = s.HostNamesDisabled
	}
	if s.ContainerSize != nil {
		objectMap["containerSize"] = s.ContainerSize
	}
	if s.MaxNumberOfWorkers != nil {
		objectMap["maxNumberOfWorkers"] = s.MaxNumberOfWorkers
	}
	if s.CloningInfo != nil {
		objectMap["cloningInfo"] = s.CloningInfo
	}
	return json.Marshal(objectMap)
}

// SitePropertiesModel ...
type SitePropertiesModel struct {
	Metadata    *[]NameValuePair `json:"metadata,omitempty"`
	Properties  *[]NameValuePair `json:"properties,omitempty"`
	AppSettings *[]NameValuePair `json:"appSettings,omitempty"`
}

// SitesCreateOrUpdateSiteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SitesCreateOrUpdateSiteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SitesClient) (Site, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SitesCreateOrUpdateSiteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SitesCreateOrUpdateSiteFuture.Result.
func (future *SitesCreateOrUpdateSiteFuture) result(client SitesClient) (s Site, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesCreateOrUpdateSiteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		s.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.SitesCreateOrUpdateSiteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateSiteResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesCreateOrUpdateSiteFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SitesCreateOrUpdateSiteSlotFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SitesCreateOrUpdateSiteSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SitesClient) (Site, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SitesCreateOrUpdateSiteSlotFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SitesCreateOrUpdateSiteSlotFuture.Result.
func (future *SitesCreateOrUpdateSiteSlotFuture) result(client SitesClient) (s Site, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesCreateOrUpdateSiteSlotFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		s.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.SitesCreateOrUpdateSiteSlotFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateSiteSlotResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesCreateOrUpdateSiteSlotFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SitesListSitePublishingCredentialsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SitesListSitePublishingCredentialsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SitesClient) (User, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SitesListSitePublishingCredentialsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SitesListSitePublishingCredentialsFuture.Result.
func (future *SitesListSitePublishingCredentialsFuture) result(client SitesClient) (u User, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesListSitePublishingCredentialsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		u.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.SitesListSitePublishingCredentialsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if u.Response.Response, err = future.GetResult(sender); err == nil && u.Response.Response.StatusCode != http.StatusNoContent {
		u, err = client.ListSitePublishingCredentialsResponder(u.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesListSitePublishingCredentialsFuture", "Result", u.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SitesListSitePublishingCredentialsSlotFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type SitesListSitePublishingCredentialsSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SitesClient) (User, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SitesListSitePublishingCredentialsSlotFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SitesListSitePublishingCredentialsSlotFuture.Result.
func (future *SitesListSitePublishingCredentialsSlotFuture) result(client SitesClient) (u User, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesListSitePublishingCredentialsSlotFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		u.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.SitesListSitePublishingCredentialsSlotFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if u.Response.Response, err = future.GetResult(sender); err == nil && u.Response.Response.StatusCode != http.StatusNoContent {
		u, err = client.ListSitePublishingCredentialsSlotResponder(u.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesListSitePublishingCredentialsSlotFuture", "Result", u.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SiteSourceControl describes the source control configuration for web app
type SiteSourceControl struct {
	autorest.Response            `json:"-"`
	*SiteSourceControlProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SiteSourceControl.
func (ssc SiteSourceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssc.SiteSourceControlProperties != nil {
		objectMap["properties"] = ssc.SiteSourceControlProperties
	}
	if ssc.ID != nil {
		objectMap["id"] = ssc.ID
	}
	if ssc.Name != nil {
		objectMap["name"] = ssc.Name
	}
	if ssc.Kind != nil {
		objectMap["kind"] = ssc.Kind
	}
	if ssc.Location != nil {
		objectMap["location"] = ssc.Location
	}
	if ssc.Type != nil {
		objectMap["type"] = ssc.Type
	}
	if ssc.Tags != nil {
		objectMap["tags"] = ssc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteSourceControl struct.
func (ssc *SiteSourceControl) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteSourceControlProperties SiteSourceControlProperties
				err = json.Unmarshal(*v, &siteSourceControlProperties)
				if err != nil {
					return err
				}
				ssc.SiteSourceControlProperties = &siteSourceControlProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ssc.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ssc.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssc.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ssc.Tags = tags
			}
		}
	}

	return nil
}

// SiteSourceControlProperties ...
type SiteSourceControlProperties struct {
	// RepoURL - Repository or source control url
	RepoURL *string `json:"repoUrl,omitempty"`
	// Branch - Name of branch to use for deployment
	Branch *string `json:"branch,omitempty"`
	// IsManualIntegration - Whether to manual or continuous integration
	IsManualIntegration *bool `json:"isManualIntegration,omitempty"`
	// DeploymentRollbackEnabled - Whether to manual or continuous integration
	DeploymentRollbackEnabled *bool `json:"deploymentRollbackEnabled,omitempty"`
	// IsMercurial - Mercurial or Git repository type
	IsMercurial *bool `json:"isMercurial,omitempty"`
}

// SitesRecoverSiteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SitesRecoverSiteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SitesClient) (Site, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SitesRecoverSiteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SitesRecoverSiteFuture.Result.
func (future *SitesRecoverSiteFuture) result(client SitesClient) (s Site, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesRecoverSiteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		s.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.SitesRecoverSiteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.RecoverSiteResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesRecoverSiteFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SitesRecoverSiteSlotFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SitesRecoverSiteSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SitesClient) (Site, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SitesRecoverSiteSlotFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SitesRecoverSiteSlotFuture.Result.
func (future *SitesRecoverSiteSlotFuture) result(client SitesClient) (s Site, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesRecoverSiteSlotFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		s.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.SitesRecoverSiteSlotFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.RecoverSiteSlotResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesRecoverSiteSlotFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SitesRestoreSiteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SitesRestoreSiteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SitesClient) (RestoreResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SitesRestoreSiteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SitesRestoreSiteFuture.Result.
func (future *SitesRestoreSiteFuture) result(client SitesClient) (rr RestoreResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesRestoreSiteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.SitesRestoreSiteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rr.Response.Response, err = future.GetResult(sender); err == nil && rr.Response.Response.StatusCode != http.StatusNoContent {
		rr, err = client.RestoreSiteResponder(rr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesRestoreSiteFuture", "Result", rr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SitesRestoreSiteSlotFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SitesRestoreSiteSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SitesClient) (RestoreResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SitesRestoreSiteSlotFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SitesRestoreSiteSlotFuture.Result.
func (future *SitesRestoreSiteSlotFuture) result(client SitesClient) (rr RestoreResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesRestoreSiteSlotFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.SitesRestoreSiteSlotFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rr.Response.Response, err = future.GetResult(sender); err == nil && rr.Response.Response.StatusCode != http.StatusNoContent {
		rr, err = client.RestoreSiteSlotResponder(rr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesRestoreSiteSlotFuture", "Result", rr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SitesSwapSlotsSlotFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SitesSwapSlotsSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SitesClient) (SetObject, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SitesSwapSlotsSlotFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SitesSwapSlotsSlotFuture.Result.
func (future *SitesSwapSlotsSlotFuture) result(client SitesClient) (so SetObject, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesSwapSlotsSlotFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		so.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.SitesSwapSlotsSlotFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.SwapSlotsSlotResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesSwapSlotsSlotFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SitesSwapSlotWithProductionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SitesSwapSlotWithProductionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SitesClient) (SetObject, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SitesSwapSlotWithProductionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SitesSwapSlotWithProductionFuture.Result.
func (future *SitesSwapSlotWithProductionFuture) result(client SitesClient) (so SetObject, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesSwapSlotWithProductionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		so.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("web.SitesSwapSlotWithProductionFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.SwapSlotWithProductionResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesSwapSlotWithProductionFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SkuCapacity description of the App Service Plan scale options
type SkuCapacity struct {
	// Minimum - Minimum number of Workers for this App Service Plan SKU
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - Maximum number of Workers for this App Service Plan SKU
	Maximum *int32 `json:"maximum,omitempty"`
	// Default - Default number of Workers for this App Service Plan SKU
	Default *int32 `json:"default,omitempty"`
	// ScaleType - Available scale configurations for an App Service Plan
	ScaleType *string `json:"scaleType,omitempty"`
}

// SkuDescription describes a sku for a scalable resource
type SkuDescription struct {
	// Name - Name of the resource sku
	Name *string `json:"name,omitempty"`
	// Tier - Service Tier of the resource sku
	Tier *string `json:"tier,omitempty"`
	// Size - Size specifier of the resource sku
	Size *string `json:"size,omitempty"`
	// Family - Family code of the resource sku
	Family *string `json:"family,omitempty"`
	// Capacity - Current number of instances assigned to the resource
	Capacity *int32 `json:"capacity,omitempty"`
}

// SkuInfo sku discovery information
type SkuInfo struct {
	// ResourceType - Resource type that this sku applies to
	ResourceType *string `json:"resourceType,omitempty"`
	// Sku - Name and tier of the sku
	Sku *SkuDescription `json:"sku,omitempty"`
	// Capacity - Min, max, and default scale values of the sku
	Capacity *SkuCapacity `json:"capacity,omitempty"`
}

// SkuInfoCollection collection of SkuInfos
type SkuInfoCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]SkuInfo `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// SkuInfoCollectionIterator provides access to a complete listing of SkuInfo values.
type SkuInfoCollectionIterator struct {
	i    int
	page SkuInfoCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SkuInfoCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkuInfoCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SkuInfoCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SkuInfoCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SkuInfoCollectionIterator) Response() SkuInfoCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SkuInfoCollectionIterator) Value() SkuInfo {
	if !iter.page.NotDone() {
		return SkuInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SkuInfoCollectionIterator type.
func NewSkuInfoCollectionIterator(page SkuInfoCollectionPage) SkuInfoCollectionIterator {
	return SkuInfoCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sic SkuInfoCollection) IsEmpty() bool {
	return sic.Value == nil || len(*sic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sic SkuInfoCollection) hasNextLink() bool {
	return sic.NextLink != nil && len(*sic.NextLink) != 0
}

// skuInfoCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sic SkuInfoCollection) skuInfoCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !sic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sic.NextLink)))
}

// SkuInfoCollectionPage contains a page of SkuInfo values.
type SkuInfoCollectionPage struct {
	fn  func(context.Context, SkuInfoCollection) (SkuInfoCollection, error)
	sic SkuInfoCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SkuInfoCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkuInfoCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sic)
		if err != nil {
			return err
		}
		page.sic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SkuInfoCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SkuInfoCollectionPage) NotDone() bool {
	return !page.sic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SkuInfoCollectionPage) Response() SkuInfoCollection {
	return page.sic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SkuInfoCollectionPage) Values() []SkuInfo {
	if page.sic.IsEmpty() {
		return nil
	}
	return *page.sic.Value
}

// Creates a new instance of the SkuInfoCollectionPage type.
func NewSkuInfoCollectionPage(cur SkuInfoCollection, getNextPage func(context.Context, SkuInfoCollection) (SkuInfoCollection, error)) SkuInfoCollectionPage {
	return SkuInfoCollectionPage{
		fn:  getNextPage,
		sic: cur,
	}
}

// SlotConfigNames class containing names for connection strings and application settings to be marked as
// sticky to the slot
// and not moved during swap operation
// This is valid for all deployment slots under the site
type SlotConfigNames struct {
	// ConnectionStringNames - List of connection string names
	ConnectionStringNames *[]string `json:"connectionStringNames,omitempty"`
	// AppSettingNames - List of application settings names
	AppSettingNames *[]string `json:"appSettingNames,omitempty"`
}

// SlotConfigNamesResource slot Config names azure resource
type SlotConfigNamesResource struct {
	autorest.Response                  `json:"-"`
	*SlotConfigNamesResourceProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SlotConfigNamesResource.
func (scnr SlotConfigNamesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scnr.SlotConfigNamesResourceProperties != nil {
		objectMap["properties"] = scnr.SlotConfigNamesResourceProperties
	}
	if scnr.ID != nil {
		objectMap["id"] = scnr.ID
	}
	if scnr.Name != nil {
		objectMap["name"] = scnr.Name
	}
	if scnr.Kind != nil {
		objectMap["kind"] = scnr.Kind
	}
	if scnr.Location != nil {
		objectMap["location"] = scnr.Location
	}
	if scnr.Type != nil {
		objectMap["type"] = scnr.Type
	}
	if scnr.Tags != nil {
		objectMap["tags"] = scnr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SlotConfigNamesResource struct.
func (scnr *SlotConfigNamesResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var slotConfigNamesResourceProperties SlotConfigNamesResourceProperties
				err = json.Unmarshal(*v, &slotConfigNamesResourceProperties)
				if err != nil {
					return err
				}
				scnr.SlotConfigNamesResourceProperties = &slotConfigNamesResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scnr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scnr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				scnr.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				scnr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scnr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				scnr.Tags = tags
			}
		}
	}

	return nil
}

// SlotConfigNamesResourceProperties ...
type SlotConfigNamesResourceProperties struct {
	// ConnectionStringNames - List of connection string names
	ConnectionStringNames *[]string `json:"connectionStringNames,omitempty"`
	// AppSettingNames - List of application settings names
	AppSettingNames *[]string `json:"appSettingNames,omitempty"`
}

// SlotDifference an object describing the difference in setting values between two web app slots
type SlotDifference struct {
	*SlotDifferenceProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SlotDifference.
func (sd SlotDifference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sd.SlotDifferenceProperties != nil {
		objectMap["properties"] = sd.SlotDifferenceProperties
	}
	if sd.ID != nil {
		objectMap["id"] = sd.ID
	}
	if sd.Name != nil {
		objectMap["name"] = sd.Name
	}
	if sd.Kind != nil {
		objectMap["kind"] = sd.Kind
	}
	if sd.Location != nil {
		objectMap["location"] = sd.Location
	}
	if sd.Type != nil {
		objectMap["type"] = sd.Type
	}
	if sd.Tags != nil {
		objectMap["tags"] = sd.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SlotDifference struct.
func (sd *SlotDifference) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var slotDifferenceProperties SlotDifferenceProperties
				err = json.Unmarshal(*v, &slotDifferenceProperties)
				if err != nil {
					return err
				}
				sd.SlotDifferenceProperties = &slotDifferenceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sd.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sd.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sd.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sd.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sd.Tags = tags
			}
		}
	}

	return nil
}

// SlotDifferenceCollection collection of Slot Differences
type SlotDifferenceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]SlotDifference `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// SlotDifferenceCollectionIterator provides access to a complete listing of SlotDifference values.
type SlotDifferenceCollectionIterator struct {
	i    int
	page SlotDifferenceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SlotDifferenceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SlotDifferenceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SlotDifferenceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SlotDifferenceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SlotDifferenceCollectionIterator) Response() SlotDifferenceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SlotDifferenceCollectionIterator) Value() SlotDifference {
	if !iter.page.NotDone() {
		return SlotDifference{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SlotDifferenceCollectionIterator type.
func NewSlotDifferenceCollectionIterator(page SlotDifferenceCollectionPage) SlotDifferenceCollectionIterator {
	return SlotDifferenceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sdc SlotDifferenceCollection) IsEmpty() bool {
	return sdc.Value == nil || len(*sdc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sdc SlotDifferenceCollection) hasNextLink() bool {
	return sdc.NextLink != nil && len(*sdc.NextLink) != 0
}

// slotDifferenceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sdc SlotDifferenceCollection) slotDifferenceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !sdc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sdc.NextLink)))
}

// SlotDifferenceCollectionPage contains a page of SlotDifference values.
type SlotDifferenceCollectionPage struct {
	fn  func(context.Context, SlotDifferenceCollection) (SlotDifferenceCollection, error)
	sdc SlotDifferenceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SlotDifferenceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SlotDifferenceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sdc)
		if err != nil {
			return err
		}
		page.sdc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SlotDifferenceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SlotDifferenceCollectionPage) NotDone() bool {
	return !page.sdc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SlotDifferenceCollectionPage) Response() SlotDifferenceCollection {
	return page.sdc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SlotDifferenceCollectionPage) Values() []SlotDifference {
	if page.sdc.IsEmpty() {
		return nil
	}
	return *page.sdc.Value
}

// Creates a new instance of the SlotDifferenceCollectionPage type.
func NewSlotDifferenceCollectionPage(cur SlotDifferenceCollection, getNextPage func(context.Context, SlotDifferenceCollection) (SlotDifferenceCollection, error)) SlotDifferenceCollectionPage {
	return SlotDifferenceCollectionPage{
		fn:  getNextPage,
		sdc: cur,
	}
}

// SlotDifferenceProperties ...
type SlotDifferenceProperties struct {
	// Type - Indicates the type of the difference: Information, Warning or Error.
	Type *string `json:"type,omitempty"`
	// SettingType - The type of the settings: General, AppSetting or ConnectionString
	SettingType *string `json:"settingType,omitempty"`
	// DiffRule - Rule that describes how to process the difference in settings during web app slot swap.
	DiffRule *string `json:"diffRule,omitempty"`
	// SettingName - Name of the setting
	SettingName *string `json:"settingName,omitempty"`
	// ValueInCurrentSlot - Value of the setting in the current web app slot
	ValueInCurrentSlot *string `json:"valueInCurrentSlot,omitempty"`
	// ValueInTargetSlot - Value of the setting in the target web app slot
	ValueInTargetSlot *string `json:"valueInTargetSlot,omitempty"`
	// Description - Description of the difference
	Description *string `json:"description,omitempty"`
}

// SlowRequestsBasedTrigger slowRequestsBasedTrigger
type SlowRequestsBasedTrigger struct {
	// TimeTaken - TimeTaken
	TimeTaken *string `json:"timeTaken,omitempty"`
	// Count - Count
	Count *int32 `json:"count,omitempty"`
	// TimeInterval - TimeInterval
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// SourceControl describes the Source Control OAuth Token
type SourceControl struct {
	autorest.Response        `json:"-"`
	*SourceControlProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SourceControl.
func (sc SourceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sc.SourceControlProperties != nil {
		objectMap["properties"] = sc.SourceControlProperties
	}
	if sc.ID != nil {
		objectMap["id"] = sc.ID
	}
	if sc.Name != nil {
		objectMap["name"] = sc.Name
	}
	if sc.Kind != nil {
		objectMap["kind"] = sc.Kind
	}
	if sc.Location != nil {
		objectMap["location"] = sc.Location
	}
	if sc.Type != nil {
		objectMap["type"] = sc.Type
	}
	if sc.Tags != nil {
		objectMap["tags"] = sc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SourceControl struct.
func (sc *SourceControl) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sourceControlProperties SourceControlProperties
				err = json.Unmarshal(*v, &sourceControlProperties)
				if err != nil {
					return err
				}
				sc.SourceControlProperties = &sourceControlProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sc.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sc.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sc.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sc.Tags = tags
			}
		}
	}

	return nil
}

// SourceControlCollection collection of source controls
type SourceControlCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]SourceControl `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// SourceControlCollectionIterator provides access to a complete listing of SourceControl values.
type SourceControlCollectionIterator struct {
	i    int
	page SourceControlCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SourceControlCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SourceControlCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SourceControlCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SourceControlCollectionIterator) Response() SourceControlCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SourceControlCollectionIterator) Value() SourceControl {
	if !iter.page.NotDone() {
		return SourceControl{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SourceControlCollectionIterator type.
func NewSourceControlCollectionIterator(page SourceControlCollectionPage) SourceControlCollectionIterator {
	return SourceControlCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (scc SourceControlCollection) IsEmpty() bool {
	return scc.Value == nil || len(*scc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (scc SourceControlCollection) hasNextLink() bool {
	return scc.NextLink != nil && len(*scc.NextLink) != 0
}

// sourceControlCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (scc SourceControlCollection) sourceControlCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !scc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(scc.NextLink)))
}

// SourceControlCollectionPage contains a page of SourceControl values.
type SourceControlCollectionPage struct {
	fn  func(context.Context, SourceControlCollection) (SourceControlCollection, error)
	scc SourceControlCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SourceControlCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.scc)
		if err != nil {
			return err
		}
		page.scc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SourceControlCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SourceControlCollectionPage) NotDone() bool {
	return !page.scc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SourceControlCollectionPage) Response() SourceControlCollection {
	return page.scc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SourceControlCollectionPage) Values() []SourceControl {
	if page.scc.IsEmpty() {
		return nil
	}
	return *page.scc.Value
}

// Creates a new instance of the SourceControlCollectionPage type.
func NewSourceControlCollectionPage(cur SourceControlCollection, getNextPage func(context.Context, SourceControlCollection) (SourceControlCollection, error)) SourceControlCollectionPage {
	return SourceControlCollectionPage{
		fn:  getNextPage,
		scc: cur,
	}
}

// SourceControlProperties ...
type SourceControlProperties struct {
	// Name - Name or Source Control Type
	Name *string `json:"name,omitempty"`
	// Token - OAuth Access Token
	Token *string `json:"token,omitempty"`
	// TokenSecret - OAuth Access Token Secret
	TokenSecret *string `json:"tokenSecret,omitempty"`
	// RefreshToken - OAuth Refresh Token
	RefreshToken *string `json:"refreshToken,omitempty"`
	// ExpirationTime - OAuth Token Expiration
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
}

// StampCapacity class containing stamp capacity information
type StampCapacity struct {
	// Name - Name of the stamp
	Name *string `json:"name,omitempty"`
	// AvailableCapacity - Available capacity (# of machines, bytes of storage etc...)
	AvailableCapacity *int64 `json:"availableCapacity,omitempty"`
	// TotalCapacity - Total capacity (# of machines, bytes of storage etc...)
	TotalCapacity *int64 `json:"totalCapacity,omitempty"`
	// Unit - Name of the unit
	Unit *string `json:"unit,omitempty"`
	// ComputeMode - Shared/Dedicated workers. Possible values include: 'Shared', 'Dedicated', 'Dynamic'
	ComputeMode ComputeModeOptions `json:"computeMode,omitempty"`
	// WorkerSize - Size of the machines. Possible values include: 'WorkerSizeOptionsDefault', 'WorkerSizeOptionsSmall', 'WorkerSizeOptionsMedium', 'WorkerSizeOptionsLarge'
	WorkerSize WorkerSizeOptions `json:"workerSize,omitempty"`
	// WorkerSizeID - Size Id of machines:
	//             0 - Small
	//             1 - Medium
	//             2 - Large
	WorkerSizeID *int32 `json:"workerSizeId,omitempty"`
	// ExcludeFromCapacityAllocation - If true it includes basic sites
	//             Basic sites are not used for capacity allocation.
	ExcludeFromCapacityAllocation *bool `json:"excludeFromCapacityAllocation,omitempty"`
	// IsApplicableForAllComputeModes - Is capacity applicable for all sites?
	IsApplicableForAllComputeModes *bool `json:"isApplicableForAllComputeModes,omitempty"`
	// SiteMode - Shared or Dedicated
	SiteMode *string `json:"siteMode,omitempty"`
}

// StampCapacityCollection collection of stamp capacities
type StampCapacityCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]StampCapacity `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// StampCapacityCollectionIterator provides access to a complete listing of StampCapacity values.
type StampCapacityCollectionIterator struct {
	i    int
	page StampCapacityCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StampCapacityCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StampCapacityCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StampCapacityCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StampCapacityCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StampCapacityCollectionIterator) Response() StampCapacityCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StampCapacityCollectionIterator) Value() StampCapacity {
	if !iter.page.NotDone() {
		return StampCapacity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StampCapacityCollectionIterator type.
func NewStampCapacityCollectionIterator(page StampCapacityCollectionPage) StampCapacityCollectionIterator {
	return StampCapacityCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (scc StampCapacityCollection) IsEmpty() bool {
	return scc.Value == nil || len(*scc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (scc StampCapacityCollection) hasNextLink() bool {
	return scc.NextLink != nil && len(*scc.NextLink) != 0
}

// stampCapacityCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (scc StampCapacityCollection) stampCapacityCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !scc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(scc.NextLink)))
}

// StampCapacityCollectionPage contains a page of StampCapacity values.
type StampCapacityCollectionPage struct {
	fn  func(context.Context, StampCapacityCollection) (StampCapacityCollection, error)
	scc StampCapacityCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StampCapacityCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StampCapacityCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.scc)
		if err != nil {
			return err
		}
		page.scc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StampCapacityCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StampCapacityCollectionPage) NotDone() bool {
	return !page.scc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StampCapacityCollectionPage) Response() StampCapacityCollection {
	return page.scc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StampCapacityCollectionPage) Values() []StampCapacity {
	if page.scc.IsEmpty() {
		return nil
	}
	return *page.scc.Value
}

// Creates a new instance of the StampCapacityCollectionPage type.
func NewStampCapacityCollectionPage(cur StampCapacityCollection, getNextPage func(context.Context, StampCapacityCollection) (StampCapacityCollection, error)) StampCapacityCollectionPage {
	return StampCapacityCollectionPage{
		fn:  getNextPage,
		scc: cur,
	}
}

// StatusCodesBasedTrigger statusCodeBasedTrigger
type StatusCodesBasedTrigger struct {
	// Status - HTTP status code
	Status *int32 `json:"status,omitempty"`
	// SubStatus - SubStatus
	SubStatus *int32 `json:"subStatus,omitempty"`
	// Win32Status - Win32 error code
	Win32Status *int32 `json:"win32Status,omitempty"`
	// Count - Count
	Count *int32 `json:"count,omitempty"`
	// TimeInterval - TimeInterval
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// StringDictionary string dictionary resource
type StringDictionary struct {
	autorest.Response `json:"-"`
	// Properties - Settings
	Properties map[string]*string `json:"properties"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for StringDictionary.
func (sd StringDictionary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sd.Properties != nil {
		objectMap["properties"] = sd.Properties
	}
	if sd.ID != nil {
		objectMap["id"] = sd.ID
	}
	if sd.Name != nil {
		objectMap["name"] = sd.Name
	}
	if sd.Kind != nil {
		objectMap["kind"] = sd.Kind
	}
	if sd.Location != nil {
		objectMap["location"] = sd.Location
	}
	if sd.Type != nil {
		objectMap["type"] = sd.Type
	}
	if sd.Tags != nil {
		objectMap["tags"] = sd.Tags
	}
	return json.Marshal(objectMap)
}

// TldLegalAgreement represents a legal agreement for top level domain
type TldLegalAgreement struct {
	// AgreementKey - Unique identifier for the agreement
	AgreementKey *string `json:"agreementKey,omitempty"`
	// Title - Agreement title
	Title *string `json:"title,omitempty"`
	// Content - Agreement details
	Content *string `json:"content,omitempty"`
	// URL - Url where a copy of the agreement details is hosted
	URL *string `json:"url,omitempty"`
}

// TldLegalAgreementCollection collection of Tld Legal Agreements
type TldLegalAgreementCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]TldLegalAgreement `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// TldLegalAgreementCollectionIterator provides access to a complete listing of TldLegalAgreement values.
type TldLegalAgreementCollectionIterator struct {
	i    int
	page TldLegalAgreementCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TldLegalAgreementCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TldLegalAgreementCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TldLegalAgreementCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TldLegalAgreementCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TldLegalAgreementCollectionIterator) Response() TldLegalAgreementCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TldLegalAgreementCollectionIterator) Value() TldLegalAgreement {
	if !iter.page.NotDone() {
		return TldLegalAgreement{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TldLegalAgreementCollectionIterator type.
func NewTldLegalAgreementCollectionIterator(page TldLegalAgreementCollectionPage) TldLegalAgreementCollectionIterator {
	return TldLegalAgreementCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tlac TldLegalAgreementCollection) IsEmpty() bool {
	return tlac.Value == nil || len(*tlac.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tlac TldLegalAgreementCollection) hasNextLink() bool {
	return tlac.NextLink != nil && len(*tlac.NextLink) != 0
}

// tldLegalAgreementCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tlac TldLegalAgreementCollection) tldLegalAgreementCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !tlac.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tlac.NextLink)))
}

// TldLegalAgreementCollectionPage contains a page of TldLegalAgreement values.
type TldLegalAgreementCollectionPage struct {
	fn   func(context.Context, TldLegalAgreementCollection) (TldLegalAgreementCollection, error)
	tlac TldLegalAgreementCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TldLegalAgreementCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TldLegalAgreementCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tlac)
		if err != nil {
			return err
		}
		page.tlac = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TldLegalAgreementCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TldLegalAgreementCollectionPage) NotDone() bool {
	return !page.tlac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TldLegalAgreementCollectionPage) Response() TldLegalAgreementCollection {
	return page.tlac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TldLegalAgreementCollectionPage) Values() []TldLegalAgreement {
	if page.tlac.IsEmpty() {
		return nil
	}
	return *page.tlac.Value
}

// Creates a new instance of the TldLegalAgreementCollectionPage type.
func NewTldLegalAgreementCollectionPage(cur TldLegalAgreementCollection, getNextPage func(context.Context, TldLegalAgreementCollection) (TldLegalAgreementCollection, error)) TldLegalAgreementCollectionPage {
	return TldLegalAgreementCollectionPage{
		fn:   getNextPage,
		tlac: cur,
	}
}

// TopLevelDomain a top level domain object
type TopLevelDomain struct {
	autorest.Response         `json:"-"`
	*TopLevelDomainProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TopLevelDomain.
func (tld TopLevelDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tld.TopLevelDomainProperties != nil {
		objectMap["properties"] = tld.TopLevelDomainProperties
	}
	if tld.ID != nil {
		objectMap["id"] = tld.ID
	}
	if tld.Name != nil {
		objectMap["name"] = tld.Name
	}
	if tld.Kind != nil {
		objectMap["kind"] = tld.Kind
	}
	if tld.Location != nil {
		objectMap["location"] = tld.Location
	}
	if tld.Type != nil {
		objectMap["type"] = tld.Type
	}
	if tld.Tags != nil {
		objectMap["tags"] = tld.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TopLevelDomain struct.
func (tld *TopLevelDomain) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var topLevelDomainProperties TopLevelDomainProperties
				err = json.Unmarshal(*v, &topLevelDomainProperties)
				if err != nil {
					return err
				}
				tld.TopLevelDomainProperties = &topLevelDomainProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tld.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tld.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tld.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tld.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tld.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				tld.Tags = tags
			}
		}
	}

	return nil
}

// TopLevelDomainAgreementOption options for retrieving the list of top level domain legal agreements
type TopLevelDomainAgreementOption struct {
	// IncludePrivacy - If true then the list of agreements will include agreements for domain privacy as well.
	IncludePrivacy *bool `json:"includePrivacy,omitempty"`
}

// TopLevelDomainCollection collection of Top Level Domains
type TopLevelDomainCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]TopLevelDomain `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// TopLevelDomainCollectionIterator provides access to a complete listing of TopLevelDomain values.
type TopLevelDomainCollectionIterator struct {
	i    int
	page TopLevelDomainCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TopLevelDomainCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopLevelDomainCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TopLevelDomainCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TopLevelDomainCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TopLevelDomainCollectionIterator) Response() TopLevelDomainCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TopLevelDomainCollectionIterator) Value() TopLevelDomain {
	if !iter.page.NotDone() {
		return TopLevelDomain{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TopLevelDomainCollectionIterator type.
func NewTopLevelDomainCollectionIterator(page TopLevelDomainCollectionPage) TopLevelDomainCollectionIterator {
	return TopLevelDomainCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tldc TopLevelDomainCollection) IsEmpty() bool {
	return tldc.Value == nil || len(*tldc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tldc TopLevelDomainCollection) hasNextLink() bool {
	return tldc.NextLink != nil && len(*tldc.NextLink) != 0
}

// topLevelDomainCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tldc TopLevelDomainCollection) topLevelDomainCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !tldc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tldc.NextLink)))
}

// TopLevelDomainCollectionPage contains a page of TopLevelDomain values.
type TopLevelDomainCollectionPage struct {
	fn   func(context.Context, TopLevelDomainCollection) (TopLevelDomainCollection, error)
	tldc TopLevelDomainCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TopLevelDomainCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopLevelDomainCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tldc)
		if err != nil {
			return err
		}
		page.tldc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TopLevelDomainCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TopLevelDomainCollectionPage) NotDone() bool {
	return !page.tldc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TopLevelDomainCollectionPage) Response() TopLevelDomainCollection {
	return page.tldc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TopLevelDomainCollectionPage) Values() []TopLevelDomain {
	if page.tldc.IsEmpty() {
		return nil
	}
	return *page.tldc.Value
}

// Creates a new instance of the TopLevelDomainCollectionPage type.
func NewTopLevelDomainCollectionPage(cur TopLevelDomainCollection, getNextPage func(context.Context, TopLevelDomainCollection) (TopLevelDomainCollection, error)) TopLevelDomainCollectionPage {
	return TopLevelDomainCollectionPage{
		fn:   getNextPage,
		tldc: cur,
	}
}

// TopLevelDomainProperties ...
type TopLevelDomainProperties struct {
	// Name - Name of the top level domain
	Name *string `json:"name,omitempty"`
	// Privacy - If true then the top level domain supports domain privacy
	Privacy *bool `json:"privacy,omitempty"`
}

// Usage class that represents usage of the quota resource.
type Usage struct {
	*UsageProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.UsageProperties != nil {
		objectMap["properties"] = u.UsageProperties
	}
	if u.ID != nil {
		objectMap["id"] = u.ID
	}
	if u.Name != nil {
		objectMap["name"] = u.Name
	}
	if u.Kind != nil {
		objectMap["kind"] = u.Kind
	}
	if u.Location != nil {
		objectMap["location"] = u.Location
	}
	if u.Type != nil {
		objectMap["type"] = u.Type
	}
	if u.Tags != nil {
		objectMap["tags"] = u.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Usage struct.
func (u *Usage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var usageProperties UsageProperties
				err = json.Unmarshal(*v, &usageProperties)
				if err != nil {
					return err
				}
				u.UsageProperties = &usageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				u.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				u.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				u.Tags = tags
			}
		}
	}

	return nil
}

// UsageCollection collection of usages
type UsageCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// UsageCollectionIterator provides access to a complete listing of Usage values.
type UsageCollectionIterator struct {
	i    int
	page UsageCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UsageCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsageCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UsageCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UsageCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UsageCollectionIterator) Response() UsageCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UsageCollectionIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UsageCollectionIterator type.
func NewUsageCollectionIterator(page UsageCollectionPage) UsageCollectionIterator {
	return UsageCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (uc UsageCollection) IsEmpty() bool {
	return uc.Value == nil || len(*uc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (uc UsageCollection) hasNextLink() bool {
	return uc.NextLink != nil && len(*uc.NextLink) != 0
}

// usageCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (uc UsageCollection) usageCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !uc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(uc.NextLink)))
}

// UsageCollectionPage contains a page of Usage values.
type UsageCollectionPage struct {
	fn func(context.Context, UsageCollection) (UsageCollection, error)
	uc UsageCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UsageCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsageCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.uc)
		if err != nil {
			return err
		}
		page.uc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UsageCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UsageCollectionPage) NotDone() bool {
	return !page.uc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UsageCollectionPage) Response() UsageCollection {
	return page.uc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UsageCollectionPage) Values() []Usage {
	if page.uc.IsEmpty() {
		return nil
	}
	return *page.uc.Value
}

// Creates a new instance of the UsageCollectionPage type.
func NewUsageCollectionPage(cur UsageCollection, getNextPage func(context.Context, UsageCollection) (UsageCollection, error)) UsageCollectionPage {
	return UsageCollectionPage{
		fn: getNextPage,
		uc: cur,
	}
}

// UsageProperties ...
type UsageProperties struct {
	// DisplayName - Friendly name shown in the UI
	DisplayName *string `json:"displayName,omitempty"`
	// Name - Name of the quota
	Name *string `json:"name,omitempty"`
	// ResourceName - Name of the quota resource
	ResourceName *string `json:"resourceName,omitempty"`
	// Unit - Units of measurement for the quota resource
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - The current value of the resource counter
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - The resource limit
	Limit *int64 `json:"limit,omitempty"`
	// NextResetTime - Next reset time for the resource counter
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
	// ComputeMode - ComputeMode used for this usage. Possible values include: 'Shared', 'Dedicated', 'Dynamic'
	ComputeMode ComputeModeOptions `json:"computeMode,omitempty"`
	// SiteMode - SiteMode used for this usage
	SiteMode *string `json:"siteMode,omitempty"`
}

// User represents user credentials used for publishing activity
type User struct {
	autorest.Response `json:"-"`
	*UserProperties   `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for User.
func (u User) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.UserProperties != nil {
		objectMap["properties"] = u.UserProperties
	}
	if u.ID != nil {
		objectMap["id"] = u.ID
	}
	if u.Name != nil {
		objectMap["name"] = u.Name
	}
	if u.Kind != nil {
		objectMap["kind"] = u.Kind
	}
	if u.Location != nil {
		objectMap["location"] = u.Location
	}
	if u.Type != nil {
		objectMap["type"] = u.Type
	}
	if u.Tags != nil {
		objectMap["tags"] = u.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for User struct.
func (u *User) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userProperties UserProperties
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				u.UserProperties = &userProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				u.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				u.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				u.Tags = tags
			}
		}
	}

	return nil
}

// UserProperties ...
type UserProperties struct {
	// Name - Username (internal)
	Name *string `json:"name,omitempty"`
	// PublishingUserName - Username used for publishing
	PublishingUserName *string `json:"publishingUserName,omitempty"`
	// PublishingPassword - Password used for publishing
	PublishingPassword *string `json:"publishingPassword,omitempty"`
	// ScmURI - Service Control Manager URI, including username and password
	ScmURI *string `json:"scmUri,omitempty"`
}

// VirtualApplication ...
type VirtualApplication struct {
	VirtualPath        *string             `json:"virtualPath,omitempty"`
	PhysicalPath       *string             `json:"physicalPath,omitempty"`
	PreloadEnabled     *bool               `json:"preloadEnabled,omitempty"`
	VirtualDirectories *[]VirtualDirectory `json:"virtualDirectories,omitempty"`
}

// VirtualDirectory ...
type VirtualDirectory struct {
	VirtualPath  *string `json:"virtualPath,omitempty"`
	PhysicalPath *string `json:"physicalPath,omitempty"`
}

// VirtualIPMapping class that represents a VIP mapping
type VirtualIPMapping struct {
	// VirtualIP - Virtual IP address
	VirtualIP *string `json:"virtualIP,omitempty"`
	// InternalHTTPPort - Internal HTTP port
	InternalHTTPPort *int32 `json:"internalHttpPort,omitempty"`
	// InternalHTTPSPort - Internal HTTPS port
	InternalHTTPSPort *int32 `json:"internalHttpsPort,omitempty"`
	// InUse - Is VIP mapping in use
	InUse *bool `json:"inUse,omitempty"`
}

// VirtualNetworkProfile specification for using a virtual network
type VirtualNetworkProfile struct {
	// ID - Resource id of the virtual network
	ID *string `json:"id,omitempty"`
	// Name - Name of the virtual network (read-only)
	Name *string `json:"name,omitempty"`
	// Type - Resource type of the virtual network (read-only)
	Type *string `json:"type,omitempty"`
	// Subnet - Subnet within the virtual network
	Subnet *string `json:"subnet,omitempty"`
}

// VnetGateway the VnetGateway contract. This is used to give the vnet gateway access to the VPN package.
type VnetGateway struct {
	autorest.Response      `json:"-"`
	*VnetGatewayProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VnetGateway.
func (vg VnetGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vg.VnetGatewayProperties != nil {
		objectMap["properties"] = vg.VnetGatewayProperties
	}
	if vg.ID != nil {
		objectMap["id"] = vg.ID
	}
	if vg.Name != nil {
		objectMap["name"] = vg.Name
	}
	if vg.Kind != nil {
		objectMap["kind"] = vg.Kind
	}
	if vg.Location != nil {
		objectMap["location"] = vg.Location
	}
	if vg.Type != nil {
		objectMap["type"] = vg.Type
	}
	if vg.Tags != nil {
		objectMap["tags"] = vg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VnetGateway struct.
func (vg *VnetGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vnetGatewayProperties VnetGatewayProperties
				err = json.Unmarshal(*v, &vnetGatewayProperties)
				if err != nil {
					return err
				}
				vg.VnetGatewayProperties = &vnetGatewayProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vg.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vg.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vg.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vg.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vg.Tags = tags
			}
		}
	}

	return nil
}

// VnetGatewayProperties ...
type VnetGatewayProperties struct {
	// VnetName - The VNET name.
	VnetName *string `json:"vnetName,omitempty"`
	// VpnPackageURI - The URI where the Vpn package can be downloaded
	VpnPackageURI *string `json:"vpnPackageUri,omitempty"`
}

// VnetInfo vNETInfo contract. This contract is public and is a stripped down version of VNETInfoInternal
type VnetInfo struct {
	autorest.Response   `json:"-"`
	*VnetInfoProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VnetInfo.
func (vi VnetInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vi.VnetInfoProperties != nil {
		objectMap["properties"] = vi.VnetInfoProperties
	}
	if vi.ID != nil {
		objectMap["id"] = vi.ID
	}
	if vi.Name != nil {
		objectMap["name"] = vi.Name
	}
	if vi.Kind != nil {
		objectMap["kind"] = vi.Kind
	}
	if vi.Location != nil {
		objectMap["location"] = vi.Location
	}
	if vi.Type != nil {
		objectMap["type"] = vi.Type
	}
	if vi.Tags != nil {
		objectMap["tags"] = vi.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VnetInfo struct.
func (vi *VnetInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vnetInfoProperties VnetInfoProperties
				err = json.Unmarshal(*v, &vnetInfoProperties)
				if err != nil {
					return err
				}
				vi.VnetInfoProperties = &vnetInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vi.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vi.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vi.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vi.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vi.Tags = tags
			}
		}
	}

	return nil
}

// VnetInfoProperties ...
type VnetInfoProperties struct {
	// VnetResourceID - The vnet resource id
	VnetResourceID *string `json:"vnetResourceId,omitempty"`
	// CertThumbprint - The client certificate thumbprint
	CertThumbprint *string `json:"certThumbprint,omitempty"`
	// CertBlob - A certificate file (.cer) blob containing the public key of the private key used to authenticate a
	//             Point-To-Site VPN connection.
	CertBlob *string `json:"certBlob,omitempty"`
	// Routes - The routes that this virtual network connection uses.
	Routes *[]VnetRoute `json:"routes,omitempty"`
	// ResyncRequired - Flag to determine if a resync is required
	ResyncRequired *bool `json:"resyncRequired,omitempty"`
	// DNSServers - Dns servers to be used by this VNET. This should be a comma-separated list of IP addresses.
	DNSServers *string `json:"dnsServers,omitempty"`
}

// VnetRoute vnetRoute contract used to pass routing information for a vnet.
type VnetRoute struct {
	autorest.Response    `json:"-"`
	*VnetRouteProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VnetRoute.
func (vr VnetRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vr.VnetRouteProperties != nil {
		objectMap["properties"] = vr.VnetRouteProperties
	}
	if vr.ID != nil {
		objectMap["id"] = vr.ID
	}
	if vr.Name != nil {
		objectMap["name"] = vr.Name
	}
	if vr.Kind != nil {
		objectMap["kind"] = vr.Kind
	}
	if vr.Location != nil {
		objectMap["location"] = vr.Location
	}
	if vr.Type != nil {
		objectMap["type"] = vr.Type
	}
	if vr.Tags != nil {
		objectMap["tags"] = vr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VnetRoute struct.
func (vr *VnetRoute) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vnetRouteProperties VnetRouteProperties
				err = json.Unmarshal(*v, &vnetRouteProperties)
				if err != nil {
					return err
				}
				vr.VnetRouteProperties = &vnetRouteProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vr.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vr.Tags = tags
			}
		}
	}

	return nil
}

// VnetRouteProperties ...
type VnetRouteProperties struct {
	// Name - The name of this route. This is only returned by the server and does not need to be set by the client.
	Name *string `json:"name,omitempty"`
	// StartAddress - The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified.
	StartAddress *string `json:"startAddress,omitempty"`
	// EndAddress - The ending address for this route. If the start address is specified in CIDR notation, this must be omitted.
	EndAddress *string `json:"endAddress,omitempty"`
	// RouteType - The type of route this is:
	//             DEFAULT - By default, every web app has routes to the local address ranges specified by RFC1918
	//             INHERITED - Routes inherited from the real Virtual Network routes
	//             STATIC - Static route set on the web app only
	//
	//             These values will be used for syncing a Web App's routes with those from a Virtual Network. This operation will clear all DEFAULT and INHERITED routes and replace them
	//             with new INHERITED routes.
	RouteType *string `json:"routeType,omitempty"`
}

// WorkerPool worker pool of a hostingEnvironment (App Service Environment)
type WorkerPool struct {
	autorest.Response     `json:"-"`
	*WorkerPoolProperties `json:"properties,omitempty"`
	Sku                   *SkuDescription `json:"sku,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WorkerPool.
func (wp WorkerPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.WorkerPoolProperties != nil {
		objectMap["properties"] = wp.WorkerPoolProperties
	}
	if wp.Sku != nil {
		objectMap["sku"] = wp.Sku
	}
	if wp.ID != nil {
		objectMap["id"] = wp.ID
	}
	if wp.Name != nil {
		objectMap["name"] = wp.Name
	}
	if wp.Kind != nil {
		objectMap["kind"] = wp.Kind
	}
	if wp.Location != nil {
		objectMap["location"] = wp.Location
	}
	if wp.Type != nil {
		objectMap["type"] = wp.Type
	}
	if wp.Tags != nil {
		objectMap["tags"] = wp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkerPool struct.
func (wp *WorkerPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workerPoolProperties WorkerPoolProperties
				err = json.Unmarshal(*v, &workerPoolProperties)
				if err != nil {
					return err
				}
				wp.WorkerPoolProperties = &workerPoolProperties
			}
		case "sku":
			if v != nil {
				var sku SkuDescription
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				wp.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wp.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				wp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wp.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wp.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wp.Tags = tags
			}
		}
	}

	return nil
}

// WorkerPoolCollection collection of worker pools
type WorkerPoolCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources
	Value *[]WorkerPool `json:"value,omitempty"`
	// NextLink - Link to next page of resources
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkerPoolCollectionIterator provides access to a complete listing of WorkerPool values.
type WorkerPoolCollectionIterator struct {
	i    int
	page WorkerPoolCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkerPoolCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkerPoolCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkerPoolCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkerPoolCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkerPoolCollectionIterator) Response() WorkerPoolCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkerPoolCollectionIterator) Value() WorkerPool {
	if !iter.page.NotDone() {
		return WorkerPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkerPoolCollectionIterator type.
func NewWorkerPoolCollectionIterator(page WorkerPoolCollectionPage) WorkerPoolCollectionIterator {
	return WorkerPoolCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wpc WorkerPoolCollection) IsEmpty() bool {
	return wpc.Value == nil || len(*wpc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wpc WorkerPoolCollection) hasNextLink() bool {
	return wpc.NextLink != nil && len(*wpc.NextLink) != 0
}

// workerPoolCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wpc WorkerPoolCollection) workerPoolCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !wpc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wpc.NextLink)))
}

// WorkerPoolCollectionPage contains a page of WorkerPool values.
type WorkerPoolCollectionPage struct {
	fn  func(context.Context, WorkerPoolCollection) (WorkerPoolCollection, error)
	wpc WorkerPoolCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkerPoolCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkerPoolCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wpc)
		if err != nil {
			return err
		}
		page.wpc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkerPoolCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkerPoolCollectionPage) NotDone() bool {
	return !page.wpc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkerPoolCollectionPage) Response() WorkerPoolCollection {
	return page.wpc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkerPoolCollectionPage) Values() []WorkerPool {
	if page.wpc.IsEmpty() {
		return nil
	}
	return *page.wpc.Value
}

// Creates a new instance of the WorkerPoolCollectionPage type.
func NewWorkerPoolCollectionPage(cur WorkerPoolCollection, getNextPage func(context.Context, WorkerPoolCollection) (WorkerPoolCollection, error)) WorkerPoolCollectionPage {
	return WorkerPoolCollectionPage{
		fn:  getNextPage,
		wpc: cur,
	}
}

// WorkerPoolProperties ...
type WorkerPoolProperties struct {
	// WorkerSizeID - Worker size id for referencing this worker pool
	WorkerSizeID *int32 `json:"workerSizeId,omitempty"`
	// ComputeMode - Shared or dedicated web app hosting. Possible values include: 'Shared', 'Dedicated', 'Dynamic'
	ComputeMode ComputeModeOptions `json:"computeMode,omitempty"`
	// WorkerSize - VM size of the worker pool instances
	WorkerSize *string `json:"workerSize,omitempty"`
	// WorkerCount - Number of instances in the worker pool
	WorkerCount *int32 `json:"workerCount,omitempty"`
	// InstanceNames - Names of all instances in the worker pool (read only)
	InstanceNames *[]string `json:"instanceNames,omitempty"`
}
