package redis

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/redis/mgmt/2016-04-01/redis"

// AccessKeys redis cache access keys.
type AccessKeys struct {
	autorest.Response `json:"-"`
	// PrimaryKey - READ-ONLY; The current primary key that clients can use to authenticate with Redis cache.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - READ-ONLY; The current secondary key that clients can use to authenticate with Redis cache.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
}

// CreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type CreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (ResourceType, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CreateFuture.Result.
func (future *CreateFuture) result(client Client) (rt ResourceType, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redis.CreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rt.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("redis.CreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rt.Response.Response, err = future.GetResult(sender); err == nil && rt.Response.Response.StatusCode != http.StatusNoContent {
		rt, err = client.CreateResponder(rt.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "redis.CreateFuture", "Result", rt.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CreateParameters parameters supplied to the Create Redis operation.
type CreateParameters struct {
	// CreateProperties - Redis cache properties.
	*CreateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CreateParameters.
func (cp CreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.CreateProperties != nil {
		objectMap["properties"] = cp.CreateProperties
	}
	if cp.Location != nil {
		objectMap["location"] = cp.Location
	}
	if cp.Tags != nil {
		objectMap["tags"] = cp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateParameters struct.
func (cp *CreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var createProperties CreateProperties
				err = json.Unmarshal(*v, &createProperties)
				if err != nil {
					return err
				}
				cp.CreateProperties = &createProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cp.Tags = tags
			}
		}
	}

	return nil
}

// CreateProperties properties supplied to Create Redis operation.
type CreateProperties struct {
	// Sku - The SKU of the Redis cache to deploy.
	Sku *Sku `json:"sku,omitempty"`
	// RedisConfiguration - All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
	RedisConfiguration map[string]*string `json:"redisConfiguration"`
	// EnableNonSslPort - Specifies whether the non-ssl Redis server port (6379) is enabled.
	EnableNonSslPort *bool `json:"enableNonSslPort,omitempty"`
	// TenantSettings - tenantSettings
	TenantSettings map[string]*string `json:"tenantSettings"`
	// ShardCount - The number of shards to be created on a Premium Cluster Cache.
	ShardCount *int32 `json:"shardCount,omitempty"`
	// SubnetID - The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
	SubnetID *string `json:"subnetId,omitempty"`
	// StaticIP - Static IP address. Required when deploying a Redis cache inside an existing Azure Virtual Network.
	StaticIP *string `json:"staticIP,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateProperties.
func (cp CreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Sku != nil {
		objectMap["sku"] = cp.Sku
	}
	if cp.RedisConfiguration != nil {
		objectMap["redisConfiguration"] = cp.RedisConfiguration
	}
	if cp.EnableNonSslPort != nil {
		objectMap["enableNonSslPort"] = cp.EnableNonSslPort
	}
	if cp.TenantSettings != nil {
		objectMap["tenantSettings"] = cp.TenantSettings
	}
	if cp.ShardCount != nil {
		objectMap["shardCount"] = cp.ShardCount
	}
	if cp.SubnetID != nil {
		objectMap["subnetId"] = cp.SubnetID
	}
	if cp.StaticIP != nil {
		objectMap["staticIP"] = cp.StaticIP
	}
	return json.Marshal(objectMap)
}

// DeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeleteFuture.Result.
func (future *DeleteFuture) result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redis.DeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("redis.DeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExportDataFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ExportDataFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExportDataFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExportDataFuture.Result.
func (future *ExportDataFuture) result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redis.ExportDataFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("redis.ExportDataFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExportRDBParameters parameters for Redis export operation.
type ExportRDBParameters struct {
	// Format - File format.
	Format *string `json:"format,omitempty"`
	// Prefix - Prefix to use for exported files.
	Prefix *string `json:"prefix,omitempty"`
	// Container - Container name to export to.
	Container *string `json:"container,omitempty"`
}

// FirewallRule a firewall rule on a redis cache has a name, and describes a contiguous range of IP
// addresses permitted to connect
type FirewallRule struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; resource ID (of the firewall rule)
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; name of the firewall rule
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; type (of the firewall rule resource = 'Microsoft.Cache/redis/firewallRule')
	Type *string `json:"type,omitempty"`
	// FirewallRuleProperties - redis cache firewall rule properties
	*FirewallRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallRule.
func (fr FirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fr.FirewallRuleProperties != nil {
		objectMap["properties"] = fr.FirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallRule struct.
func (fr *FirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fr.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var firewallRuleProperties FirewallRuleProperties
				err = json.Unmarshal(*v, &firewallRuleProperties)
				if err != nil {
					return err
				}
				fr.FirewallRuleProperties = &firewallRuleProperties
			}
		}
	}

	return nil
}

// FirewallRuleListResult the response of list firewall rules Redis operation.
type FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list firewall rules operation.
	Value *[]FirewallRule `json:"value,omitempty"`
	// NextLink - Link for next set of locations.
	NextLink *string `json:"nextLink,omitempty"`
}

// FirewallRuleListResultIterator provides access to a complete listing of FirewallRule values.
type FirewallRuleListResultIterator struct {
	i    int
	page FirewallRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FirewallRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FirewallRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FirewallRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FirewallRuleListResultIterator) Response() FirewallRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FirewallRuleListResultIterator) Value() FirewallRule {
	if !iter.page.NotDone() {
		return FirewallRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FirewallRuleListResultIterator type.
func NewFirewallRuleListResultIterator(page FirewallRuleListResultPage) FirewallRuleListResultIterator {
	return FirewallRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (frlr FirewallRuleListResult) IsEmpty() bool {
	return frlr.Value == nil || len(*frlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (frlr FirewallRuleListResult) hasNextLink() bool {
	return frlr.NextLink != nil && len(*frlr.NextLink) != 0
}

// firewallRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (frlr FirewallRuleListResult) firewallRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !frlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(frlr.NextLink)))
}

// FirewallRuleListResultPage contains a page of FirewallRule values.
type FirewallRuleListResultPage struct {
	fn   func(context.Context, FirewallRuleListResult) (FirewallRuleListResult, error)
	frlr FirewallRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FirewallRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.frlr)
		if err != nil {
			return err
		}
		page.frlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FirewallRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FirewallRuleListResultPage) NotDone() bool {
	return !page.frlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FirewallRuleListResultPage) Response() FirewallRuleListResult {
	return page.frlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FirewallRuleListResultPage) Values() []FirewallRule {
	if page.frlr.IsEmpty() {
		return nil
	}
	return *page.frlr.Value
}

// Creates a new instance of the FirewallRuleListResultPage type.
func NewFirewallRuleListResultPage(cur FirewallRuleListResult, getNextPage func(context.Context, FirewallRuleListResult) (FirewallRuleListResult, error)) FirewallRuleListResultPage {
	return FirewallRuleListResultPage{
		fn:   getNextPage,
		frlr: cur,
	}
}

// FirewallRuleProperties specifies a range of IP addresses permitted to connect to the cache
type FirewallRuleProperties struct {
	// StartIP - lowest IP address included in the range
	StartIP *string `json:"startIP,omitempty"`
	// EndIP - highest IP address included in the range
	EndIP *string `json:"endIP,omitempty"`
}

// ForceRebootResponse response to force reboot for Redis cache.
type ForceRebootResponse struct {
	autorest.Response `json:"-"`
	// Message - READ-ONLY; Status message
	Message *string `json:"Message,omitempty"`
}

// ImportDataFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ImportDataFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ImportDataFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ImportDataFuture.Result.
func (future *ImportDataFuture) result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redis.ImportDataFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("redis.ImportDataFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ImportRDBParameters parameters for Redis import operation.
type ImportRDBParameters struct {
	// Format - File format.
	Format *string `json:"format,omitempty"`
	// Files - files to import.
	Files *[]string `json:"files,omitempty"`
}

// ListResult the response of list Redis operation.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Redis cache instances.
	Value *[]ResourceType `json:"value,omitempty"`
	// NextLink - Link for next set of locations.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of ResourceType values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() ResourceType {
	if !iter.page.NotDone() {
		return ResourceType{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListResultIterator type.
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return ListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lr ListResult) hasNextLink() bool {
	return lr.NextLink != nil && len(*lr.NextLink) != 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of ResourceType values.
type ListResultPage struct {
	fn func(context.Context, ListResult) (ListResult, error)
	lr ListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lr)
		if err != nil {
			return err
		}
		page.lr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []ResourceType {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Creates a new instance of the ListResultPage type.
func NewListResultPage(cur ListResult, getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return ListResultPage{
		fn: getNextPage,
		lr: cur,
	}
}

// Operation REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that describes the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that describes the operation.
type OperationDisplay struct {
	// Provider - Friendly name of the resource provider
	Provider *string `json:"provider,omitempty"`
	// Operation - Operation type: read, write, delete, listKeys/action, etc.
	Operation *string `json:"operation,omitempty"`
	// Resource - Resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Description - Friendly name of the operation
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list REST API operations. It contains a list of operations
// and a URL nextLink to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// PatchSchedule response to put/get patch schedules for Redis cache.
type PatchSchedule struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// ScheduleEntries - List of patch schedules for a Redis cache.
	*ScheduleEntries `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PatchSchedule.
func (ps PatchSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ps.ScheduleEntries != nil {
		objectMap["properties"] = ps.ScheduleEntries
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PatchSchedule struct.
func (ps *PatchSchedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ps.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ps.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ps.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ps.Location = &location
			}
		case "properties":
			if v != nil {
				var scheduleEntries ScheduleEntries
				err = json.Unmarshal(*v, &scheduleEntries)
				if err != nil {
					return err
				}
				ps.ScheduleEntries = &scheduleEntries
			}
		}
	}

	return nil
}

// Properties properties supplied to Create or Update Redis operation.
type Properties struct {
	// RedisConfiguration - All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
	RedisConfiguration map[string]*string `json:"redisConfiguration"`
	// EnableNonSslPort - Specifies whether the non-ssl Redis server port (6379) is enabled.
	EnableNonSslPort *bool `json:"enableNonSslPort,omitempty"`
	// TenantSettings - tenantSettings
	TenantSettings map[string]*string `json:"tenantSettings"`
	// ShardCount - The number of shards to be created on a Premium Cluster Cache.
	ShardCount *int32 `json:"shardCount,omitempty"`
	// SubnetID - The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
	SubnetID *string `json:"subnetId,omitempty"`
	// StaticIP - Static IP address. Required when deploying a Redis cache inside an existing Azure Virtual Network.
	StaticIP *string `json:"staticIP,omitempty"`
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.RedisConfiguration != nil {
		objectMap["redisConfiguration"] = p.RedisConfiguration
	}
	if p.EnableNonSslPort != nil {
		objectMap["enableNonSslPort"] = p.EnableNonSslPort
	}
	if p.TenantSettings != nil {
		objectMap["tenantSettings"] = p.TenantSettings
	}
	if p.ShardCount != nil {
		objectMap["shardCount"] = p.ShardCount
	}
	if p.SubnetID != nil {
		objectMap["subnetId"] = p.SubnetID
	}
	if p.StaticIP != nil {
		objectMap["staticIP"] = p.StaticIP
	}
	return json.Marshal(objectMap)
}

// RebootParameters specifies which Redis node(s) to reboot.
type RebootParameters struct {
	// RebootType - Which Redis node(s) to reboot. Depending on this value data loss is possible. Possible values include: 'PrimaryNode', 'SecondaryNode', 'AllNodes'
	RebootType RebootType `json:"rebootType,omitempty"`
	// ShardID - If clustering is enabled, the ID of the shard to be rebooted.
	ShardID *int32 `json:"shardId,omitempty"`
}

// RegenerateKeyParameters specifies which Redis access keys to reset.
type RegenerateKeyParameters struct {
	// KeyType - The Redis access key to regenerate. Possible values include: 'Primary', 'Secondary'
	KeyType KeyType `json:"keyType,omitempty"`
}

// Resource the Resource definition.
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceProperties parameters describing a Redis instance.
type ResourceProperties struct {
	// Sku - The SKU of the Redis cache to deploy.
	Sku *Sku `json:"sku,omitempty"`
	// RedisVersion - READ-ONLY; Redis version.
	RedisVersion *string `json:"redisVersion,omitempty"`
	// ProvisioningState - READ-ONLY; Redis instance provisioning status.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// HostName - READ-ONLY; Redis host name.
	HostName *string `json:"hostName,omitempty"`
	// Port - READ-ONLY; Redis non-SSL port.
	Port *int32 `json:"port,omitempty"`
	// SslPort - READ-ONLY; Redis SSL port.
	SslPort *int32 `json:"sslPort,omitempty"`
	// AccessKeys - READ-ONLY; The keys of the Redis cache - not set if this object is not the response to Create or Update redis cache
	AccessKeys *AccessKeys `json:"accessKeys,omitempty"`
	// RedisConfiguration - All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
	RedisConfiguration map[string]*string `json:"redisConfiguration"`
	// EnableNonSslPort - Specifies whether the non-ssl Redis server port (6379) is enabled.
	EnableNonSslPort *bool `json:"enableNonSslPort,omitempty"`
	// TenantSettings - tenantSettings
	TenantSettings map[string]*string `json:"tenantSettings"`
	// ShardCount - The number of shards to be created on a Premium Cluster Cache.
	ShardCount *int32 `json:"shardCount,omitempty"`
	// SubnetID - The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
	SubnetID *string `json:"subnetId,omitempty"`
	// StaticIP - Static IP address. Required when deploying a Redis cache inside an existing Azure Virtual Network.
	StaticIP *string `json:"staticIP,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceProperties.
func (rp ResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.Sku != nil {
		objectMap["sku"] = rp.Sku
	}
	if rp.RedisConfiguration != nil {
		objectMap["redisConfiguration"] = rp.RedisConfiguration
	}
	if rp.EnableNonSslPort != nil {
		objectMap["enableNonSslPort"] = rp.EnableNonSslPort
	}
	if rp.TenantSettings != nil {
		objectMap["tenantSettings"] = rp.TenantSettings
	}
	if rp.ShardCount != nil {
		objectMap["shardCount"] = rp.ShardCount
	}
	if rp.SubnetID != nil {
		objectMap["subnetId"] = rp.SubnetID
	}
	if rp.StaticIP != nil {
		objectMap["staticIP"] = rp.StaticIP
	}
	return json.Marshal(objectMap)
}

// ResourceType a single Redis item in List or Get Operation.
type ResourceType struct {
	autorest.Response `json:"-"`
	// ResourceProperties - Redis cache properties.
	*ResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ResourceType.
func (rt ResourceType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.ResourceProperties != nil {
		objectMap["properties"] = rt.ResourceProperties
	}
	if rt.Location != nil {
		objectMap["location"] = rt.Location
	}
	if rt.Tags != nil {
		objectMap["tags"] = rt.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceType struct.
func (rt *ResourceType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var resourceProperties ResourceProperties
				err = json.Unmarshal(*v, &resourceProperties)
				if err != nil {
					return err
				}
				rt.ResourceProperties = &resourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rt.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rt.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rt.Tags = tags
			}
		}
	}

	return nil
}

// ScheduleEntries list of patch schedules for a Redis cache.
type ScheduleEntries struct {
	// ScheduleEntries - List of patch schedules for a Redis cache.
	ScheduleEntries *[]ScheduleEntry `json:"scheduleEntries,omitempty"`
}

// ScheduleEntry patch schedule entry for a Premium Redis Cache.
type ScheduleEntry struct {
	// DayOfWeek - Day of the week when a cache can be patched. Possible values include: 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday', 'Everyday', 'Weekend'
	DayOfWeek DayOfWeek `json:"dayOfWeek,omitempty"`
	// StartHourUtc - Start hour after which cache patching can start.
	StartHourUtc *int32 `json:"startHourUtc,omitempty"`
	// MaintenanceWindow - ISO8601 timespan specifying how much time cache patching can take.
	MaintenanceWindow *string `json:"maintenanceWindow,omitempty"`
}

// Sku SKU parameters supplied to the create Redis operation.
type Sku struct {
	// Name - The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium). Possible values include: 'Basic', 'Standard', 'Premium'
	Name SkuName `json:"name,omitempty"`
	// Family - The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium). Possible values include: 'C', 'P'
	Family SkuFamily `json:"family,omitempty"`
	// Capacity - The size of the Redis cache to deploy. Valid values: for C (Basic/Standard) family (0, 1, 2, 3, 4, 5, 6), for P (Premium) family (1, 2, 3, 4).
	Capacity *int32 `json:"capacity,omitempty"`
}

// UpdateParameters parameters supplied to the Update Redis operation.
type UpdateParameters struct {
	// UpdateProperties - Redis cache properties.
	*UpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for UpdateParameters.
func (up UpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if up.UpdateProperties != nil {
		objectMap["properties"] = up.UpdateProperties
	}
	if up.Tags != nil {
		objectMap["tags"] = up.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateParameters struct.
func (up *UpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateProperties UpdateProperties
				err = json.Unmarshal(*v, &updateProperties)
				if err != nil {
					return err
				}
				up.UpdateProperties = &updateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				up.Tags = tags
			}
		}
	}

	return nil
}

// UpdateProperties properties supplied to Update Redis operation.
type UpdateProperties struct {
	// Sku - The SKU of the Redis cache to deploy.
	Sku *Sku `json:"sku,omitempty"`
	// RedisConfiguration - All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
	RedisConfiguration map[string]*string `json:"redisConfiguration"`
	// EnableNonSslPort - Specifies whether the non-ssl Redis server port (6379) is enabled.
	EnableNonSslPort *bool `json:"enableNonSslPort,omitempty"`
	// TenantSettings - tenantSettings
	TenantSettings map[string]*string `json:"tenantSettings"`
	// ShardCount - The number of shards to be created on a Premium Cluster Cache.
	ShardCount *int32 `json:"shardCount,omitempty"`
	// SubnetID - The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
	SubnetID *string `json:"subnetId,omitempty"`
	// StaticIP - Static IP address. Required when deploying a Redis cache inside an existing Azure Virtual Network.
	StaticIP *string `json:"staticIP,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateProperties.
func (up UpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if up.Sku != nil {
		objectMap["sku"] = up.Sku
	}
	if up.RedisConfiguration != nil {
		objectMap["redisConfiguration"] = up.RedisConfiguration
	}
	if up.EnableNonSslPort != nil {
		objectMap["enableNonSslPort"] = up.EnableNonSslPort
	}
	if up.TenantSettings != nil {
		objectMap["tenantSettings"] = up.TenantSettings
	}
	if up.ShardCount != nil {
		objectMap["shardCount"] = up.ShardCount
	}
	if up.SubnetID != nil {
		objectMap["subnetId"] = up.SubnetID
	}
	if up.StaticIP != nil {
		objectMap["staticIP"] = up.StaticIP
	}
	return json.Marshal(objectMap)
}
