/*
Copyright 2018 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was automatically generated by lister-gen

package v1alpha2

import (
	v1alpha2 "github.com/openshift/service-idler/pkg/apis/idling/v1alpha2"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// IdlerLister helps list Idlers.
type IdlerLister interface {
	// List lists all Idlers in the indexer.
	List(selector labels.Selector) (ret []*v1alpha2.Idler, err error)
	// Idlers returns an object that can list and get Idlers.
	Idlers(namespace string) IdlerNamespaceLister
	IdlerListerExpansion
}

// idlerLister implements the IdlerLister interface.
type idlerLister struct {
	indexer cache.Indexer
}

// NewIdlerLister returns a new IdlerLister.
func NewIdlerLister(indexer cache.Indexer) IdlerLister {
	return &idlerLister{indexer: indexer}
}

// List lists all Idlers in the indexer.
func (s *idlerLister) List(selector labels.Selector) (ret []*v1alpha2.Idler, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha2.Idler))
	})
	return ret, err
}

// Idlers returns an object that can list and get Idlers.
func (s *idlerLister) Idlers(namespace string) IdlerNamespaceLister {
	return idlerNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// IdlerNamespaceLister helps list and get Idlers.
type IdlerNamespaceLister interface {
	// List lists all Idlers in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha2.Idler, err error)
	// Get retrieves the Idler from the indexer for a given namespace and name.
	Get(name string) (*v1alpha2.Idler, error)
	IdlerNamespaceListerExpansion
}

// idlerNamespaceLister implements the IdlerNamespaceLister
// interface.
type idlerNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Idlers in the indexer for a given namespace.
func (s idlerNamespaceLister) List(selector labels.Selector) (ret []*v1alpha2.Idler, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha2.Idler))
	})
	return ret, err
}

// Get retrieves the Idler from the indexer for a given namespace and name.
func (s idlerNamespaceLister) Get(name string) (*v1alpha2.Idler, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha2.Resource("idler"), name)
	}
	return obj.(*v1alpha2.Idler), nil
}
