// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/aiplatform/v1beta1/schema/io_format.proto

package schema

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/cloud/aiplatform/v1beta1/schema/predict/instance"
	code "google.golang.org/genproto/googleapis/rpc/code"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents a line of JSONL in the batch prediction output file.
type PredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Some identifier from the input so that the prediction can be mapped back to
	// the input instance.
	//
	// Types that are assignable to Input:
	//	*PredictionResult_Instance
	//	*PredictionResult_Key
	Input isPredictionResult_Input `protobuf_oneof:"input"`
	// The prediction result.
	// Value is used here instead of Any so that JsonFormat does not append an
	// extra "@type" field when we convert the proto to JSON and so we can
	// represent array of objects.
	// Do not set error if this is set.
	Prediction *structpb.Value `protobuf:"bytes,3,opt,name=prediction,proto3" json:"prediction,omitempty"`
	// The error result.
	// Do not set prediction if this is set.
	Error *PredictionResult_Error `protobuf:"bytes,4,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *PredictionResult) Reset() {
	*x = PredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredictionResult) ProtoMessage() {}

func (x *PredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredictionResult.ProtoReflect.Descriptor instead.
func (*PredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{0}
}

func (m *PredictionResult) GetInput() isPredictionResult_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (x *PredictionResult) GetInstance() *structpb.Struct {
	if x, ok := x.GetInput().(*PredictionResult_Instance); ok {
		return x.Instance
	}
	return nil
}

func (x *PredictionResult) GetKey() string {
	if x, ok := x.GetInput().(*PredictionResult_Key); ok {
		return x.Key
	}
	return ""
}

func (x *PredictionResult) GetPrediction() *structpb.Value {
	if x != nil {
		return x.Prediction
	}
	return nil
}

func (x *PredictionResult) GetError() *PredictionResult_Error {
	if x != nil {
		return x.Error
	}
	return nil
}

type isPredictionResult_Input interface {
	isPredictionResult_Input()
}

type PredictionResult_Instance struct {
	// User's input instance.
	// Struct is used here instead of Any so that JsonFormat does not append an
	// extra "@type" field when we convert the proto to JSON.
	Instance *structpb.Struct `protobuf:"bytes,1,opt,name=instance,proto3,oneof"`
}

type PredictionResult_Key struct {
	// Optional user-provided key from the input instance.
	Key string `protobuf:"bytes,2,opt,name=key,proto3,oneof"`
}

func (*PredictionResult_Instance) isPredictionResult_Input() {}

func (*PredictionResult_Key) isPredictionResult_Input() {}

type PredictionResult_Error struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Error status. This will be serialized into the enum name e.g.
	// "NOT_FOUND".
	Status code.Code `protobuf:"varint,1,opt,name=status,proto3,enum=google.rpc.Code" json:"status,omitempty"`
	// Error message with additional details.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *PredictionResult_Error) Reset() {
	*x = PredictionResult_Error{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PredictionResult_Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredictionResult_Error) ProtoMessage() {}

func (x *PredictionResult_Error) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredictionResult_Error.ProtoReflect.Descriptor instead.
func (*PredictionResult_Error) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{0, 0}
}

func (x *PredictionResult_Error) GetStatus() code.Code {
	if x != nil {
		return x.Status
	}
	return code.Code_OK
}

func (x *PredictionResult_Error) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

var File_google_cloud_aiplatform_v1beta1_schema_io_format_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x69, 0x6f, 0x5f, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x1a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x67, 0x65, 0x6f,
	0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x4c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x2f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc1, 0x02, 0x0a,
	0x10, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x35, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x48, 0x00, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x36, 0x0a, 0x0a,
	0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x1a, 0x4b, 0x0a, 0x05, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x12, 0x28, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63,
	0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x18, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x42, 0x8b, 0x01, 0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42,
	0x0d, 0x49, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x4c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x3b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_goTypes = []interface{}{
	(*PredictionResult)(nil),       // 0: google.cloud.aiplatform.v1beta1.schema.PredictionResult
	(*PredictionResult_Error)(nil), // 1: google.cloud.aiplatform.v1beta1.schema.PredictionResult.Error
	(*structpb.Struct)(nil),        // 2: google.protobuf.Struct
	(*structpb.Value)(nil),         // 3: google.protobuf.Value
	(code.Code)(0),                 // 4: google.rpc.Code
}
var file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_depIdxs = []int32{
	2, // 0: google.cloud.aiplatform.v1beta1.schema.PredictionResult.instance:type_name -> google.protobuf.Struct
	3, // 1: google.cloud.aiplatform.v1beta1.schema.PredictionResult.prediction:type_name -> google.protobuf.Value
	1, // 2: google.cloud.aiplatform.v1beta1.schema.PredictionResult.error:type_name -> google.cloud.aiplatform.v1beta1.schema.PredictionResult.Error
	4, // 3: google.cloud.aiplatform.v1beta1.schema.PredictionResult.Error.status:type_name -> google.rpc.Code
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_init() }
func file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_schema_io_format_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_schema_annotation_spec_color_proto_init()
	file_google_cloud_aiplatform_v1beta1_schema_geometry_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PredictionResult_Error); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*PredictionResult_Instance)(nil),
		(*PredictionResult_Key)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_schema_io_format_proto = out.File
	file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_depIdxs = nil
}
