/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package metricsfakes

import (
	"net/http"
	"sync"

	"github.com/prometheus/client_golang/prometheus"
)

type FakeImpl struct {
	ListenAndServeStub        func(string, http.Handler) error
	listenAndServeMutex       sync.RWMutex
	listenAndServeArgsForCall []struct {
		arg1 string
		arg2 http.Handler
	}
	listenAndServeReturns struct {
		result1 error
	}
	listenAndServeReturnsOnCall map[int]struct {
		result1 error
	}
	RegisterStub        func(prometheus.Collector) error
	registerMutex       sync.RWMutex
	registerArgsForCall []struct {
		arg1 prometheus.Collector
	}
	registerReturns struct {
		result1 error
	}
	registerReturnsOnCall map[int]struct {
		result1 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeImpl) ListenAndServe(arg1 string, arg2 http.Handler) error {
	fake.listenAndServeMutex.Lock()
	ret, specificReturn := fake.listenAndServeReturnsOnCall[len(fake.listenAndServeArgsForCall)]
	fake.listenAndServeArgsForCall = append(fake.listenAndServeArgsForCall, struct {
		arg1 string
		arg2 http.Handler
	}{arg1, arg2})
	stub := fake.ListenAndServeStub
	fakeReturns := fake.listenAndServeReturns
	fake.recordInvocation("ListenAndServe", []interface{}{arg1, arg2})
	fake.listenAndServeMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeImpl) ListenAndServeCallCount() int {
	fake.listenAndServeMutex.RLock()
	defer fake.listenAndServeMutex.RUnlock()
	return len(fake.listenAndServeArgsForCall)
}

func (fake *FakeImpl) ListenAndServeCalls(stub func(string, http.Handler) error) {
	fake.listenAndServeMutex.Lock()
	defer fake.listenAndServeMutex.Unlock()
	fake.ListenAndServeStub = stub
}

func (fake *FakeImpl) ListenAndServeArgsForCall(i int) (string, http.Handler) {
	fake.listenAndServeMutex.RLock()
	defer fake.listenAndServeMutex.RUnlock()
	argsForCall := fake.listenAndServeArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeImpl) ListenAndServeReturns(result1 error) {
	fake.listenAndServeMutex.Lock()
	defer fake.listenAndServeMutex.Unlock()
	fake.ListenAndServeStub = nil
	fake.listenAndServeReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) ListenAndServeReturnsOnCall(i int, result1 error) {
	fake.listenAndServeMutex.Lock()
	defer fake.listenAndServeMutex.Unlock()
	fake.ListenAndServeStub = nil
	if fake.listenAndServeReturnsOnCall == nil {
		fake.listenAndServeReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.listenAndServeReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) Register(arg1 prometheus.Collector) error {
	fake.registerMutex.Lock()
	ret, specificReturn := fake.registerReturnsOnCall[len(fake.registerArgsForCall)]
	fake.registerArgsForCall = append(fake.registerArgsForCall, struct {
		arg1 prometheus.Collector
	}{arg1})
	stub := fake.RegisterStub
	fakeReturns := fake.registerReturns
	fake.recordInvocation("Register", []interface{}{arg1})
	fake.registerMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeImpl) RegisterCallCount() int {
	fake.registerMutex.RLock()
	defer fake.registerMutex.RUnlock()
	return len(fake.registerArgsForCall)
}

func (fake *FakeImpl) RegisterCalls(stub func(prometheus.Collector) error) {
	fake.registerMutex.Lock()
	defer fake.registerMutex.Unlock()
	fake.RegisterStub = stub
}

func (fake *FakeImpl) RegisterArgsForCall(i int) prometheus.Collector {
	fake.registerMutex.RLock()
	defer fake.registerMutex.RUnlock()
	argsForCall := fake.registerArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeImpl) RegisterReturns(result1 error) {
	fake.registerMutex.Lock()
	defer fake.registerMutex.Unlock()
	fake.RegisterStub = nil
	fake.registerReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) RegisterReturnsOnCall(i int, result1 error) {
	fake.registerMutex.Lock()
	defer fake.registerMutex.Unlock()
	fake.RegisterStub = nil
	if fake.registerReturnsOnCall == nil {
		fake.registerReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.registerReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeImpl) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.listenAndServeMutex.RLock()
	defer fake.listenAndServeMutex.RUnlock()
	fake.registerMutex.RLock()
	defer fake.registerMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeImpl) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}
